/***************************************************************************
**                                                                        **
**  Polyphone, a soundfont editor                                         **
**  Copyright (C) 2013-2020 Davy Triponney                                **
**                                                                        **
**  This program is free software: you can redistribute it and/or modify  **
**  it under the terms of the GNU General Public License as published by  **
**  the Free Software Foundation, either version 3 of the License, or     **
**  (at your option) any later version.                                   **
**                                                                        **
**  This program is distributed in the hope that it will be useful,       **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of        **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          **
**  GNU General Public License for more details.                          **
**                                                                        **
**  You should have received a copy of the GNU General Public License     **
**  along with this program. If not, see http://www.gnu.org/licenses/.    **
**                                                                        **
****************************************************************************
**           Author: Davy Triponney                                       **
**  Website/Contact: https://www.polyphone-soundfonts.com                 **
**             Date: 01.01.2013                                           **
***************************************************************************/

#ifndef STYLEDACTION_H
#define STYLEDACTION_H

#include <QPushButton>

class StyledAction : public QPushButton
{
    Q_OBJECT

public:
    explicit StyledAction(QWidget *parent = nullptr);
    void initialize(QString label, QString iconName);
    void disable(bool isDisabled);
    void setData(int data);
    int getData();

signals:
    void actionClicked();

protected:
    void leaveEvent(QEvent * event) override;
#if QT_VERSION >= 0x060000
    void enterEvent(QEnterEvent * event) override;
#else
    void enterEvent(QEvent * event) override;
#endif
    QPixmap _icon;
    QPixmap _iconHover;
    QPixmap _iconDisabled;

private slots:
    void onToggled(bool isChecked);
    void onClicked(bool unused);

private:
    bool _isDisabled;
    static const QSize ICON_SIZE;
    QColor _checkedBackgroundColor;
    int _data;
};

#endif // STYLEDACTION_H
