// This file is generated by kconfig_compiler_kf6 from freespacenotifier.kcfg.
// All changes you do to this file will be lost.
#ifndef FREESPACENOTIFIERSETTINGS_H
#define FREESPACENOTIFIERSETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class FreeSpaceNotifierSettings : public KConfigSkeleton
{
  public:

    static FreeSpaceNotifierSettings *self();
    ~FreeSpaceNotifierSettings() override;

    /**
      Set Minimum free space before user starts being notified.
    */
    static
    void setMinimumSpace( int v )
    {
      if (v < 1)
      {
        qDebug() << "setMinimumSpace: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 100000)
      {
        qDebug() << "setMinimumSpace: value " << v << " is greater than the maximum value of 100000";
        v = 100000;
      }

      if (!self()->isMinimumSpaceImmutable())
        self()->mMinimumSpace = v;
    }

    /**
      Get Minimum free space before user starts being notified.
    */
    static
    int minimumSpace()
    {
      return self()->mMinimumSpace;
    }

    /**
      Is Minimum free space before user starts being notified. Immutable
    */
    static
    bool isMinimumSpaceImmutable()
    {
      return self()->isImmutable( QStringLiteral( "minimumSpace" ) );
    }

    /**
      Set Is the free space notification enabled.
    */
    static
    void setEnableNotification( bool v )
    {
      if (!self()->isEnableNotificationImmutable())
        self()->mEnableNotification = v;
    }

    /**
      Get Is the free space notification enabled.
    */
    static
    bool enableNotification()
    {
      return self()->mEnableNotification;
    }

    /**
      Is Is the free space notification enabled. Immutable
    */
    static
    bool isEnableNotificationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "enableNotification" ) );
    }

  protected:
    FreeSpaceNotifierSettings();
    friend class FreeSpaceNotifierSettingsHelper;


    // General
    int mMinimumSpace;
    bool mEnableNotification;

  private:
};

#endif

