/* transition_manager.c generated by valac 0.56.12, the Vala compiler
 * generated from transition_manager.vala, do not modify */

#include <glib-object.h>
#include <poppler.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <math.h>
#include <float.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PDFPC_VIEW_TYPE_TRANSITION_MANAGER (pdfpc_view_transition_manager_get_type ())
#define PDFPC_VIEW_TRANSITION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_VIEW_TYPE_TRANSITION_MANAGER, pdfpcViewTransitionManager))
#define PDFPC_VIEW_TRANSITION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_VIEW_TYPE_TRANSITION_MANAGER, pdfpcViewTransitionManagerClass))
#define PDFPC_VIEW_IS_TRANSITION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_VIEW_TYPE_TRANSITION_MANAGER))
#define PDFPC_VIEW_IS_TRANSITION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_VIEW_TYPE_TRANSITION_MANAGER))
#define PDFPC_VIEW_TRANSITION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_VIEW_TYPE_TRANSITION_MANAGER, pdfpcViewTransitionManagerClass))

typedef struct _pdfpcViewTransitionManager pdfpcViewTransitionManager;
typedef struct _pdfpcViewTransitionManagerClass pdfpcViewTransitionManagerClass;
typedef struct _pdfpcViewTransitionManagerPrivate pdfpcViewTransitionManagerPrivate;
enum  {
	PDFPC_VIEW_TRANSITION_MANAGER_0_PROPERTY,
	PDFPC_VIEW_TRANSITION_MANAGER_IS_ENABLED_PROPERTY,
	PDFPC_VIEW_TRANSITION_MANAGER_FRAME_DURATION_PROPERTY,
	PDFPC_VIEW_TRANSITION_MANAGER_NUM_PROPERTIES
};
static GParamSpec* pdfpc_view_transition_manager_properties[PDFPC_VIEW_TRANSITION_MANAGER_NUM_PROPERTIES];
#define __vala_PopplerPageTransition_free0(var) ((var == NULL) ? NULL : (var = (_vala_PopplerPageTransition_free (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define PDFPC_METADATA_TYPE_PDF (pdfpc_metadata_pdf_get_type ())
#define PDFPC_METADATA_PDF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdf))
#define PDFPC_METADATA_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))
#define PDFPC_METADATA_IS_PDF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_IS_PDF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PDFPC_METADATA_TYPE_PDF))
#define PDFPC_METADATA_PDF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PDFPC_METADATA_TYPE_PDF, pdfpcMetadataPdfClass))

typedef struct _pdfpcMetadataPdf pdfpcMetadataPdf;
typedef struct _pdfpcMetadataPdfClass pdfpcMetadataPdfClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _pdfpcViewTransitionManager {
	GObject parent_instance;
	pdfpcViewTransitionManagerPrivate * priv;
	PopplerPageTransition* transition;
	guint fps;
	guint nframes;
	guint iframe;
	cairo_surface_t* prev;
	cairo_surface_t* next;
	gint width;
	gint height;
};

struct _pdfpcViewTransitionManagerClass {
	GObjectClass parent_class;
};

static gpointer pdfpc_view_transition_manager_parent_class = NULL;
VALA_EXTERN guint pdfpc_options_transition_fps;

VALA_EXTERN GType pdfpc_view_transition_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcViewTransitionManager, g_object_unref)
static void _vala_PopplerPageTransition_free (PopplerPageTransition* self);
VALA_EXTERN GType pdfpc_metadata_pdf_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (pdfpcMetadataPdf, g_object_unref)
VALA_EXTERN pdfpcViewTransitionManager* pdfpc_view_transition_manager_new (pdfpcMetadataPdf* metadata,
                                                               gint slide_number,
                                                               cairo_surface_t* prev,
                                                               cairo_surface_t* next,
                                                               gboolean inverse);
VALA_EXTERN pdfpcViewTransitionManager* pdfpc_view_transition_manager_construct (GType object_type,
                                                                     pdfpcMetadataPdf* metadata,
                                                                     gint slide_number,
                                                                     cairo_surface_t* prev,
                                                                     cairo_surface_t* next,
                                                                     gboolean inverse);
VALA_EXTERN guint pdfpc_metadata_pdf_get_slide_count (pdfpcMetadataPdf* self);
VALA_EXTERN PopplerDocument* pdfpc_metadata_pdf_get_document (pdfpcMetadataPdf* self);
VALA_EXTERN PopplerPageTransition* pdfpc_metadata_pdf_get_default_transition (pdfpcMetadataPdf* self);
static PopplerPageTransition* _vala_PopplerPageTransition_copy (PopplerPageTransition* self);
VALA_EXTERN gboolean pdfpc_view_transition_manager_advance (pdfpcViewTransitionManager* self);
VALA_EXTERN void pdfpc_view_transition_manager_draw_frame (pdfpcViewTransitionManager* self,
                                               cairo_t* cr);
VALA_EXTERN gboolean pdfpc_view_transition_manager_get_is_enabled (pdfpcViewTransitionManager* self);
VALA_EXTERN guint pdfpc_view_transition_manager_get_frame_duration (pdfpcViewTransitionManager* self);
static void pdfpc_view_transition_manager_finalize (GObject * obj);
static GType pdfpc_view_transition_manager_get_type_once (void);
static void _vala_pdfpc_view_transition_manager_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
_vala_PopplerPageTransition_free (PopplerPageTransition* self)
{
	g_boxed_free (poppler_page_transition_get_type (), self);
}

/**
         * The constructor
         */
static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static PopplerPageTransition*
_vala_PopplerPageTransition_copy (PopplerPageTransition* self)
{
	return g_boxed_copy (poppler_page_transition_get_type (), self);
}

static gpointer
__vala_PopplerPageTransition_copy0 (gpointer self)
{
	return self ? _vala_PopplerPageTransition_copy (self) : NULL;
}

pdfpcViewTransitionManager*
pdfpc_view_transition_manager_construct (GType object_type,
                                         pdfpcMetadataPdf* metadata,
                                         gint slide_number,
                                         cairo_surface_t* prev,
                                         cairo_surface_t* next,
                                         gboolean inverse)
{
	pdfpcViewTransitionManager * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	PopplerPageTransition* _tmp31_;
	g_return_val_if_fail (metadata != NULL, NULL);
	g_return_val_if_fail (prev != NULL, NULL);
	g_return_val_if_fail (next != NULL, NULL);
	self = (pdfpcViewTransitionManager*) g_object_new (object_type, NULL);
	self->fps = pdfpc_options_transition_fps;
	self->iframe = (guint) 0;
	_tmp0_ = _cairo_surface_reference0 (prev);
	_cairo_surface_destroy0 (self->prev);
	self->prev = _tmp0_;
	_tmp1_ = _cairo_surface_reference0 (next);
	_cairo_surface_destroy0 (self->next);
	self->next = _tmp1_;
	__vala_PopplerPageTransition_free0 (self->transition);
	self->transition = NULL;
	self->width = cairo_image_surface_get_width (prev);
	self->height = cairo_image_surface_get_height (prev);
	if (self->fps > ((guint) 0)) {
		_tmp3_ = slide_number >= 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = ((guint) slide_number) < pdfpc_metadata_pdf_get_slide_count (metadata);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		PopplerPage* page = NULL;
		PopplerDocument* _tmp4_;
		PopplerDocument* _tmp5_;
		PopplerPage* _tmp6_;
		PopplerPageTransition* trans = NULL;
		PopplerPage* _tmp7_;
		PopplerPageTransition* _tmp8_;
		gboolean _tmp9_ = FALSE;
		PopplerPageTransition* _tmp10_;
		PopplerPageTransition* _tmp15_;
		PopplerPageTransition* _tmp16_;
		PopplerPageTransition* _tmp17_;
		PopplerPageTransition* _tmp18_;
		gboolean _tmp21_ = FALSE;
		_tmp4_ = pdfpc_metadata_pdf_get_document (metadata);
		_tmp5_ = _tmp4_;
		_tmp6_ = poppler_document_get_page (_tmp5_, slide_number);
		page = _tmp6_;
		_tmp7_ = page;
		_tmp8_ = poppler_page_get_transition (_tmp7_);
		trans = _tmp8_;
		_tmp10_ = trans;
		if (_tmp10_ == NULL) {
			_tmp9_ = TRUE;
		} else {
			PopplerPageTransition* _tmp11_;
			_tmp11_ = trans;
			_tmp9_ = _tmp11_->type == POPPLER_PAGE_TRANSITION_REPLACE;
		}
		if (_tmp9_) {
			PopplerPageTransition* _tmp12_;
			PopplerPageTransition* _tmp13_;
			PopplerPageTransition* _tmp14_;
			_tmp12_ = pdfpc_metadata_pdf_get_default_transition (metadata);
			_tmp13_ = _tmp12_;
			_tmp14_ = __vala_PopplerPageTransition_copy0 (_tmp13_);
			__vala_PopplerPageTransition_free0 (trans);
			trans = _tmp14_;
		}
		_tmp15_ = trans;
		_tmp16_ = trans;
		_tmp16_->angle = _tmp16_->angle % 360;
		_tmp17_ = trans;
		if ((_tmp17_->angle % 90) != 0) {
			g_printerr ("Diagonal transitions are unsupported.\n");
			__vala_PopplerPageTransition_free0 (self->transition);
			self->transition = NULL;
		}
		_tmp18_ = trans;
		switch (_tmp18_->type) {
			case POPPLER_PAGE_TRANSITION_REPLACE:
			{
				__vala_PopplerPageTransition_free0 (self->transition);
				self->transition = NULL;
				break;
			}
			case POPPLER_PAGE_TRANSITION_FLY:
			{
				g_printerr ("Fly page transition is unsupported.\n");
				__vala_PopplerPageTransition_free0 (self->transition);
				self->transition = NULL;
				break;
			}
			default:
			{
				PopplerPageTransition* _tmp19_;
				PopplerPageTransition* _tmp20_;
				_tmp19_ = trans;
				_tmp20_ = __vala_PopplerPageTransition_copy0 (_tmp19_);
				__vala_PopplerPageTransition_free0 (self->transition);
				self->transition = _tmp20_;
				break;
			}
		}
		if (inverse) {
			PopplerPageTransition* _tmp22_;
			_tmp22_ = self->transition;
			_tmp21_ = _tmp22_ != NULL;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			PopplerPageTransition* _tmp23_;
			PopplerPageTransition* _tmp26_;
			PopplerPageTransition* _tmp27_;
			PopplerPageTransition* _tmp28_;
			_tmp23_ = self->transition;
			switch (_tmp23_->type) {
				case POPPLER_PAGE_TRANSITION_COVER:
				{
					PopplerPageTransition* _tmp24_;
					_tmp24_ = self->transition;
					_tmp24_->type = POPPLER_PAGE_TRANSITION_UNCOVER;
					break;
				}
				case POPPLER_PAGE_TRANSITION_UNCOVER:
				{
					PopplerPageTransition* _tmp25_;
					_tmp25_ = self->transition;
					_tmp25_->type = POPPLER_PAGE_TRANSITION_COVER;
					break;
				}
				default:
				{
					break;
				}
			}
			_tmp26_ = self->transition;
			_tmp27_ = self->transition;
			_tmp26_->angle = (180 + _tmp27_->angle) % 360;
			_tmp28_ = self->transition;
			switch (_tmp28_->direction) {
				case POPPLER_PAGE_TRANSITION_INWARD:
				{
					PopplerPageTransition* _tmp29_;
					_tmp29_ = self->transition;
					_tmp29_->direction = POPPLER_PAGE_TRANSITION_OUTWARD;
					break;
				}
				case POPPLER_PAGE_TRANSITION_OUTWARD:
				{
					PopplerPageTransition* _tmp30_;
					_tmp30_ = self->transition;
					_tmp30_->direction = POPPLER_PAGE_TRANSITION_INWARD;
					break;
				}
				default:
				break;
			}
		}
		__vala_PopplerPageTransition_free0 (trans);
		_g_object_unref0 (page);
	}
	_tmp31_ = self->transition;
	if (_tmp31_ != NULL) {
		PopplerPageTransition* _tmp32_;
		_tmp32_ = self->transition;
		self->nframes = (guint) ceil (_tmp32_->duration_real * self->fps);
	}
	return self;
}

pdfpcViewTransitionManager*
pdfpc_view_transition_manager_new (pdfpcMetadataPdf* metadata,
                                   gint slide_number,
                                   cairo_surface_t* prev,
                                   cairo_surface_t* next,
                                   gboolean inverse)
{
	return pdfpc_view_transition_manager_construct (PDFPC_VIEW_TYPE_TRANSITION_MANAGER, metadata, slide_number, prev, next, inverse);
}

/**
         * Advance the transition; return true if not finished and false
         * otherwise
         */
gboolean
pdfpc_view_transition_manager_advance (pdfpcViewTransitionManager* self)
{
	guint _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->iframe;
	self->iframe = _tmp0_ + 1;
	if (self->iframe >= self->nframes) {
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}

/**
         * Draw a single transition frame on the context provided.
         * For most of the transitions, first paint one slide, then set a
         * dynamically changing clip region, then paint the other slide.
         */
void
pdfpc_view_transition_manager_draw_frame (pdfpcViewTransitionManager* self,
                                          cairo_t* cr)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* slide1 = NULL;
	cairo_surface_t* slide2 = NULL;
	gdouble xshift = 0.0;
	gdouble yshift = 0.0;
	gdouble clip_width = 0.0;
	gdouble clip_height = 0.0;
	gdouble progress = 0.0;
	PopplerPageTransition* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = pdfpc_view_transition_manager_get_is_enabled (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp3_ = self->next;
	if (self->width != cairo_image_surface_get_width (_tmp3_)) {
		_tmp2_ = TRUE;
	} else {
		cairo_surface_t* _tmp4_;
		_tmp4_ = self->next;
		_tmp2_ = self->height != cairo_image_surface_get_height (_tmp4_);
	}
	if (_tmp2_) {
		return;
	}
	xshift = (gdouble) 0;
	yshift = (gdouble) 0;
	clip_width = (gdouble) self->width;
	clip_height = (gdouble) self->height;
	progress = ((gdouble) self->iframe) / self->nframes;
	if (progress > 1.0) {
		progress = 1.0;
	}
	_tmp5_ = self->transition;
	switch (_tmp5_->type) {
		case POPPLER_PAGE_TRANSITION_COVER:
		{
			PopplerPageTransition* _tmp6_;
			cairo_surface_t* _tmp7_;
			cairo_surface_t* _tmp8_;
			_tmp6_ = self->transition;
			switch (_tmp6_->angle) {
				case 0:
				{
					xshift = (-self->width) * (1.0 - progress);
					break;
				}
				case 90:
				{
					yshift = (-self->height) * (1.0 - progress);
					break;
				}
				case 180:
				{
					xshift = self->width * (1.0 - progress);
					break;
				}
				case 270:
				{
					yshift = self->height * (1.0 - progress);
					break;
				}
				default:
				break;
			}
			_tmp7_ = self->prev;
			cairo_set_source_surface (cr, _tmp7_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			_tmp8_ = self->next;
			cairo_set_source_surface (cr, _tmp8_, xshift, yshift);
			cairo_paint (cr);
			break;
		}
		case POPPLER_PAGE_TRANSITION_UNCOVER:
		{
			PopplerPageTransition* _tmp9_;
			cairo_surface_t* _tmp10_;
			cairo_surface_t* _tmp11_;
			_tmp9_ = self->transition;
			switch (_tmp9_->angle) {
				case 0:
				{
					xshift = self->width * progress;
					break;
				}
				case 90:
				{
					yshift = self->height * progress;
					break;
				}
				case 180:
				{
					xshift = (-self->width) * progress;
					break;
				}
				case 270:
				{
					yshift = (-self->height) * progress;
					break;
				}
				default:
				break;
			}
			_tmp10_ = self->next;
			cairo_set_source_surface (cr, _tmp10_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			_tmp11_ = self->prev;
			cairo_set_source_surface (cr, _tmp11_, xshift, yshift);
			cairo_paint (cr);
			break;
		}
		case POPPLER_PAGE_TRANSITION_PUSH:
		{
			gdouble xshift2 = 0.0;
			gdouble yshift2 = 0.0;
			PopplerPageTransition* _tmp12_;
			cairo_surface_t* _tmp13_;
			cairo_surface_t* _tmp14_;
			xshift2 = (gdouble) 0;
			yshift2 = (gdouble) 0;
			_tmp12_ = self->transition;
			switch (_tmp12_->angle) {
				case 0:
				{
					xshift = self->width * progress;
					xshift2 = xshift - self->width;
					break;
				}
				case 90:
				{
					yshift = self->height * progress;
					yshift2 = yshift - self->height;
					break;
				}
				case 180:
				{
					xshift = (-self->width) * progress;
					xshift2 = xshift + self->width;
					break;
				}
				case 270:
				{
					yshift = (-self->height) * progress;
					yshift2 = yshift + self->height;
					break;
				}
				default:
				break;
			}
			_tmp13_ = self->prev;
			cairo_set_source_surface (cr, _tmp13_, xshift, yshift);
			cairo_paint (cr);
			_tmp14_ = self->next;
			cairo_set_source_surface (cr, _tmp14_, xshift2, yshift2);
			cairo_paint (cr);
			break;
		}
		case POPPLER_PAGE_TRANSITION_DISSOLVE:
		{
			gdouble cell_size = 0.0;
			cairo_surface_t* _tmp15_;
			cairo_surface_t* _tmp20_;
			cell_size = MIN ((gdouble) self->width, (gdouble) self->height) / 10;
			clip_width = (cell_size * progress) + 1;
			clip_height = (cell_size * progress) + 1;
			_tmp15_ = self->prev;
			cairo_set_source_surface (cr, _tmp15_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp16_ = FALSE;
					_tmp16_ = TRUE;
					while (TRUE) {
						if (!_tmp16_) {
							gint _tmp17_;
							_tmp17_ = i;
							i = _tmp17_ + 1;
						}
						_tmp16_ = FALSE;
						if (!((i * cell_size) < ((gdouble) self->width))) {
							break;
						}
						xshift = (i * cell_size) - (clip_width / 2);
						{
							gint j = 0;
							j = 0;
							{
								gboolean _tmp18_ = FALSE;
								_tmp18_ = TRUE;
								while (TRUE) {
									if (!_tmp18_) {
										gint _tmp19_;
										_tmp19_ = j;
										j = _tmp19_ + 1;
									}
									_tmp18_ = FALSE;
									if (!((j * cell_size) < ((gdouble) self->height))) {
										break;
									}
									yshift = (j * cell_size) - (clip_height / 2);
									cairo_rectangle (cr, xshift, yshift, clip_width, clip_height);
								}
							}
						}
					}
				}
			}
			cairo_clip (cr);
			_tmp20_ = self->next;
			cairo_set_source_surface (cr, _tmp20_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			break;
		}
		case POPPLER_PAGE_TRANSITION_FADE:
		{
			cairo_surface_t* _tmp21_;
			cairo_surface_t* _tmp22_;
			_tmp21_ = self->next;
			cairo_set_source_surface (cr, _tmp21_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			_tmp22_ = self->prev;
			cairo_set_source_surface (cr, _tmp22_, (gdouble) 0, (gdouble) 0);
			cairo_paint_with_alpha (cr, 1 - progress);
			break;
		}
		case POPPLER_PAGE_TRANSITION_BOX:
		{
			PopplerPageTransition* _tmp23_;
			cairo_surface_t* _tmp32_;
			cairo_surface_t* _tmp33_;
			_tmp23_ = self->transition;
			if (_tmp23_->direction == POPPLER_PAGE_TRANSITION_INWARD) {
				cairo_surface_t* _tmp24_;
				cairo_surface_t* _tmp25_;
				cairo_surface_t* _tmp26_;
				cairo_surface_t* _tmp27_;
				_tmp24_ = self->next;
				_tmp25_ = _cairo_surface_reference0 (_tmp24_);
				_cairo_surface_destroy0 (slide1);
				slide1 = _tmp25_;
				_tmp26_ = self->prev;
				_tmp27_ = _cairo_surface_reference0 (_tmp26_);
				_cairo_surface_destroy0 (slide2);
				slide2 = _tmp27_;
				xshift = (0.5 * self->width) * progress;
				yshift = (0.5 * self->height) * progress;
			} else {
				cairo_surface_t* _tmp28_;
				cairo_surface_t* _tmp29_;
				cairo_surface_t* _tmp30_;
				cairo_surface_t* _tmp31_;
				_tmp28_ = self->prev;
				_tmp29_ = _cairo_surface_reference0 (_tmp28_);
				_cairo_surface_destroy0 (slide1);
				slide1 = _tmp29_;
				_tmp30_ = self->next;
				_tmp31_ = _cairo_surface_reference0 (_tmp30_);
				_cairo_surface_destroy0 (slide2);
				slide2 = _tmp31_;
				xshift = (0.5 * self->width) * (1 - progress);
				yshift = (0.5 * self->height) * (1 - progress);
			}
			_tmp32_ = slide1;
			cairo_set_source_surface (cr, _tmp32_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			cairo_rectangle (cr, xshift, yshift, self->width - (2 * xshift), self->height - (2 * yshift));
			cairo_clip (cr);
			_tmp33_ = slide2;
			cairo_set_source_surface (cr, _tmp33_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			break;
		}
		case POPPLER_PAGE_TRANSITION_GLITTER:
		case POPPLER_PAGE_TRANSITION_WIPE:
		{
			PopplerPageTransition* _tmp34_;
			cairo_surface_t* _tmp35_;
			PopplerPageTransition* _tmp36_;
			cairo_surface_t* _tmp42_;
			_tmp34_ = self->transition;
			switch (_tmp34_->angle) {
				case 0:
				{
					clip_width = self->width * progress;
					break;
				}
				case 90:
				{
					clip_height = self->height * progress;
					break;
				}
				case 180:
				{
					xshift = self->width * (1 - progress);
					clip_width = self->width * progress;
					break;
				}
				case 270:
				{
					yshift = self->height * (1 - progress);
					clip_height = self->height * progress;
					break;
				}
				default:
				break;
			}
			_tmp35_ = self->prev;
			cairo_set_source_surface (cr, _tmp35_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			_tmp36_ = self->transition;
			if (_tmp36_->type == POPPLER_PAGE_TRANSITION_GLITTER) {
				gint wave_ncells = 0;
				gdouble wave_cell_frac = 0.0;
				gdouble cell_size = 0.0;
				gdouble wave_xmin = 0.0;
				gdouble wave_xmax = 0.0;
				gdouble wave_ymin = 0.0;
				gdouble wave_ymax = 0.0;
				gdouble wave_breadth = 0.0;
				PopplerPageTransition* _tmp37_;
				gint imin = 0;
				gint imax = 0;
				gint jmin = 0;
				gint jmax = 0;
				wave_ncells = 4;
				wave_cell_frac = 0.02;
				cell_size = MIN ((gdouble) self->width, (gdouble) self->height) * wave_cell_frac;
				wave_xmin = (gdouble) 0;
				wave_xmax = (gdouble) self->width;
				wave_ymin = (gdouble) 0;
				wave_ymax = (gdouble) self->height;
				wave_breadth = cell_size * wave_ncells;
				_tmp37_ = self->transition;
				switch (_tmp37_->angle) {
					case 0:
					{
						wave_xmin = MAX (clip_width - wave_breadth, (gdouble) 0);
						wave_xmax = clip_width;
						clip_width -= wave_breadth;
						break;
					}
					case 90:
					{
						wave_ymin = MAX (clip_height - wave_breadth, (gdouble) 0);
						wave_ymax = clip_height;
						clip_height -= wave_breadth;
						break;
					}
					case 180:
					{
						wave_xmin = MAX (xshift - wave_breadth, (gdouble) 0);
						wave_xmax = xshift;
						clip_width += wave_breadth;
						break;
					}
					case 270:
					{
						wave_ymin = MAX (yshift - wave_breadth, (gdouble) 0);
						wave_ymax = yshift;
						clip_height += wave_breadth;
						break;
					}
					default:
					break;
				}
				imin = (gint) floor (wave_xmin / cell_size);
				imax = (gint) floor (wave_xmax / cell_size);
				jmin = (gint) floor (wave_ymin / cell_size);
				jmax = (gint) floor (wave_ymax / cell_size);
				{
					gint i = 0;
					i = imin;
					{
						gboolean _tmp38_ = FALSE;
						_tmp38_ = TRUE;
						while (TRUE) {
							if (!_tmp38_) {
								gint _tmp39_;
								_tmp39_ = i;
								i = _tmp39_ + 1;
							}
							_tmp38_ = FALSE;
							if (!(i < imax)) {
								break;
							}
							{
								gint j = 0;
								j = jmin;
								{
									gboolean _tmp40_ = FALSE;
									_tmp40_ = TRUE;
									while (TRUE) {
										gboolean onoff = FALSE;
										if (!_tmp40_) {
											gint _tmp41_;
											_tmp41_ = j;
											j = _tmp41_ + 1;
										}
										_tmp40_ = FALSE;
										if (!(j < jmax)) {
											break;
										}
										onoff = g_random_boolean ();
										if (onoff) {
											cairo_rectangle (cr, i * cell_size, j * cell_size, cell_size, cell_size);
										}
									}
								}
							}
						}
					}
				}
			}
			cairo_rectangle (cr, xshift, yshift, clip_width, clip_height);
			cairo_clip (cr);
			_tmp42_ = self->next;
			cairo_set_source_surface (cr, _tmp42_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			break;
		}
		case POPPLER_PAGE_TRANSITION_SPLIT:
		{
			PopplerPageTransition* _tmp43_;
			cairo_surface_t* _tmp62_;
			cairo_surface_t* _tmp63_;
			_tmp43_ = self->transition;
			if (_tmp43_->alignment == POPPLER_PAGE_TRANSITION_VERTICAL) {
				PopplerPageTransition* _tmp44_;
				_tmp44_ = self->transition;
				if (_tmp44_->direction == POPPLER_PAGE_TRANSITION_INWARD) {
					cairo_surface_t* _tmp45_;
					cairo_surface_t* _tmp46_;
					cairo_surface_t* _tmp47_;
					cairo_surface_t* _tmp48_;
					_tmp45_ = self->next;
					_tmp46_ = _cairo_surface_reference0 (_tmp45_);
					_cairo_surface_destroy0 (slide1);
					slide1 = _tmp46_;
					_tmp47_ = self->prev;
					_tmp48_ = _cairo_surface_reference0 (_tmp47_);
					_cairo_surface_destroy0 (slide2);
					slide2 = _tmp48_;
					xshift = (0.5 * self->width) * progress;
					clip_width = self->width * (1 - progress);
				} else {
					cairo_surface_t* _tmp49_;
					cairo_surface_t* _tmp50_;
					cairo_surface_t* _tmp51_;
					cairo_surface_t* _tmp52_;
					_tmp49_ = self->prev;
					_tmp50_ = _cairo_surface_reference0 (_tmp49_);
					_cairo_surface_destroy0 (slide1);
					slide1 = _tmp50_;
					_tmp51_ = self->next;
					_tmp52_ = _cairo_surface_reference0 (_tmp51_);
					_cairo_surface_destroy0 (slide2);
					slide2 = _tmp52_;
					xshift = (0.5 * self->width) * (1 - progress);
					clip_width = self->width * progress;
				}
			} else {
				PopplerPageTransition* _tmp53_;
				_tmp53_ = self->transition;
				if (_tmp53_->direction == POPPLER_PAGE_TRANSITION_INWARD) {
					cairo_surface_t* _tmp54_;
					cairo_surface_t* _tmp55_;
					cairo_surface_t* _tmp56_;
					cairo_surface_t* _tmp57_;
					_tmp54_ = self->next;
					_tmp55_ = _cairo_surface_reference0 (_tmp54_);
					_cairo_surface_destroy0 (slide1);
					slide1 = _tmp55_;
					_tmp56_ = self->prev;
					_tmp57_ = _cairo_surface_reference0 (_tmp56_);
					_cairo_surface_destroy0 (slide2);
					slide2 = _tmp57_;
					yshift = (0.5 * self->height) * progress;
					clip_height = self->height * (1 - progress);
				} else {
					cairo_surface_t* _tmp58_;
					cairo_surface_t* _tmp59_;
					cairo_surface_t* _tmp60_;
					cairo_surface_t* _tmp61_;
					_tmp58_ = self->prev;
					_tmp59_ = _cairo_surface_reference0 (_tmp58_);
					_cairo_surface_destroy0 (slide1);
					slide1 = _tmp59_;
					_tmp60_ = self->next;
					_tmp61_ = _cairo_surface_reference0 (_tmp60_);
					_cairo_surface_destroy0 (slide2);
					slide2 = _tmp61_;
					yshift = (0.5 * self->height) * (1 - progress);
					clip_height = self->height * progress;
				}
			}
			_tmp62_ = slide1;
			cairo_set_source_surface (cr, _tmp62_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			cairo_rectangle (cr, xshift, yshift, clip_width, clip_height);
			cairo_clip (cr);
			_tmp63_ = slide2;
			cairo_set_source_surface (cr, _tmp63_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			break;
		}
		case POPPLER_PAGE_TRANSITION_BLINDS:
		{
			gint nblinds = 0;
			PopplerPageTransition* _tmp64_;
			cairo_surface_t* _tmp65_;
			cairo_surface_t* _tmp69_;
			nblinds = 10;
			_tmp64_ = self->transition;
			if (_tmp64_->alignment == POPPLER_PAGE_TRANSITION_VERTICAL) {
				clip_width = ((progress * self->width) / nblinds) + 1;
			} else {
				clip_height = ((progress * self->height) / nblinds) + 1;
			}
			_tmp65_ = self->prev;
			cairo_set_source_surface (cr, _tmp65_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp66_ = FALSE;
					_tmp66_ = TRUE;
					while (TRUE) {
						PopplerPageTransition* _tmp68_;
						if (!_tmp66_) {
							gint _tmp67_;
							_tmp67_ = i;
							i = _tmp67_ + 1;
						}
						_tmp66_ = FALSE;
						if (!(i < nblinds)) {
							break;
						}
						_tmp68_ = self->transition;
						if (_tmp68_->alignment == POPPLER_PAGE_TRANSITION_VERTICAL) {
							xshift = ((i * self->width) / nblinds) - (clip_width / 2);
						} else {
							yshift = ((i * self->height) / nblinds) - (clip_height / 2);
						}
						cairo_rectangle (cr, xshift, yshift, clip_width, clip_height);
					}
				}
			}
			cairo_clip (cr);
			_tmp69_ = self->next;
			cairo_set_source_surface (cr, _tmp69_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			break;
		}
		default:
		{
			cairo_surface_t* _tmp70_;
			_tmp70_ = self->next;
			cairo_set_source_surface (cr, _tmp70_, (gdouble) 0, (gdouble) 0);
			cairo_paint (cr);
			break;
		}
	}
	_cairo_surface_destroy0 (slide2);
	_cairo_surface_destroy0 (slide1);
}

gboolean
pdfpc_view_transition_manager_get_is_enabled (pdfpcViewTransitionManager* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_surface_t* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->prev;
	if (_tmp2_ != NULL) {
		cairo_surface_t* _tmp3_;
		_tmp3_ = self->next;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		PopplerPageTransition* _tmp4_;
		_tmp4_ = self->transition;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

guint
pdfpc_view_transition_manager_get_frame_duration (pdfpcViewTransitionManager* self)
{
	guint result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = pdfpc_view_transition_manager_get_is_enabled (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = (guint) (1000 / self->fps);
		return result;
	} else {
		result = (guint) 0;
		return result;
	}
}

static void
pdfpc_view_transition_manager_class_init (pdfpcViewTransitionManagerClass * klass,
                                          gpointer klass_data)
{
	pdfpc_view_transition_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_pdfpc_view_transition_manager_get_property;
	G_OBJECT_CLASS (klass)->finalize = pdfpc_view_transition_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_VIEW_TRANSITION_MANAGER_IS_ENABLED_PROPERTY, pdfpc_view_transition_manager_properties[PDFPC_VIEW_TRANSITION_MANAGER_IS_ENABLED_PROPERTY] = g_param_spec_boolean ("is-enabled", "is-enabled", "is-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PDFPC_VIEW_TRANSITION_MANAGER_FRAME_DURATION_PROPERTY, pdfpc_view_transition_manager_properties[PDFPC_VIEW_TRANSITION_MANAGER_FRAME_DURATION_PROPERTY] = g_param_spec_uint ("frame-duration", "frame-duration", "frame-duration", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
pdfpc_view_transition_manager_instance_init (pdfpcViewTransitionManager * self,
                                             gpointer klass)
{
	self->transition = NULL;
	self->iframe = (guint) 0;
	self->width = 0;
	self->height = 0;
}

static void
pdfpc_view_transition_manager_finalize (GObject * obj)
{
	pdfpcViewTransitionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PDFPC_VIEW_TYPE_TRANSITION_MANAGER, pdfpcViewTransitionManager);
	__vala_PopplerPageTransition_free0 (self->transition);
	_cairo_surface_destroy0 (self->prev);
	_cairo_surface_destroy0 (self->next);
	G_OBJECT_CLASS (pdfpc_view_transition_manager_parent_class)->finalize (obj);
}

/**
     * Handle PDF slide transition
     */
static GType
pdfpc_view_transition_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (pdfpcViewTransitionManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pdfpc_view_transition_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (pdfpcViewTransitionManager), 0, (GInstanceInitFunc) pdfpc_view_transition_manager_instance_init, NULL };
	GType pdfpc_view_transition_manager_type_id;
	pdfpc_view_transition_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "pdfpcViewTransitionManager", &g_define_type_info, 0);
	return pdfpc_view_transition_manager_type_id;
}

GType
pdfpc_view_transition_manager_get_type (void)
{
	static volatile gsize pdfpc_view_transition_manager_type_id__once = 0;
	if (g_once_init_enter (&pdfpc_view_transition_manager_type_id__once)) {
		GType pdfpc_view_transition_manager_type_id;
		pdfpc_view_transition_manager_type_id = pdfpc_view_transition_manager_get_type_once ();
		g_once_init_leave (&pdfpc_view_transition_manager_type_id__once, pdfpc_view_transition_manager_type_id);
	}
	return pdfpc_view_transition_manager_type_id__once;
}

static void
_vala_pdfpc_view_transition_manager_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	pdfpcViewTransitionManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PDFPC_VIEW_TYPE_TRANSITION_MANAGER, pdfpcViewTransitionManager);
	switch (property_id) {
		case PDFPC_VIEW_TRANSITION_MANAGER_IS_ENABLED_PROPERTY:
		g_value_set_boolean (value, pdfpc_view_transition_manager_get_is_enabled (self));
		break;
		case PDFPC_VIEW_TRANSITION_MANAGER_FRAME_DURATION_PROPERTY:
		g_value_set_uint (value, pdfpc_view_transition_manager_get_frame_duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

