/* Window.c generated by valac 0.56.17, the Vala compiler
 * generated from Window.vala, do not modify */

/*-
 * Copyright (c) 2013-2019 elementary Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Tom Beckmann <tomjonabc@gmail.com>
 *              Cody Garver <cody@elementaryos.org>
 *              Artem Anufrij <artem.anufrij@live.de>
 *              Corentin Noël <corentin@elementary.io>
 */

#include <handy.h>
#include <glib-object.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define AUDIENCE_WINDOW_NAVIGATION_BUTTON_WELCOMESCREEN N_ ("Back")
#define AUDIENCE_WINDOW_NAVIGATION_BUTTON_LIBRARY N_ ("Library")
#define AUDIENCE_WINDOW_NAVIGATION_BUTTON_EPISODES N_ ("Episodes")
#define AUDIENCE_WINDOW_ACTION_GROUP_PREFIX "win"
#define AUDIENCE_WINDOW_ACTION_PREFIX AUDIENCE_WINDOW_ACTION_GROUP_PREFIX "."
#define AUDIENCE_WINDOW_ACTION_BACK "back"
#define AUDIENCE_WINDOW_ACTION_FULLSCREEN "action-fullscreen"
#define AUDIENCE_WINDOW_ACTION_OPEN_FILE "action-open-file"
#define AUDIENCE_WINDOW_ACTION_QUIT "action-quit"
#define AUDIENCE_WINDOW_ACTION_SEARCH "action-search"
#define AUDIENCE_WINDOW_ACTION_UNDO "action-undo"
#define AUDIENCE_APP_ACTION_PLAY_PAUSE "action-play-pause"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;
typedef struct _AudienceWindowPrivate AudienceWindowPrivate;

#define AUDIENCE_TYPE_EPISODES_PAGE (audience_episodes_page_get_type ())
#define AUDIENCE_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage))
#define AUDIENCE_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))
#define AUDIENCE_IS_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_IS_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_EPISODES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))

typedef struct _AudienceEpisodesPage AudienceEpisodesPage;
typedef struct _AudienceEpisodesPageClass AudienceEpisodesPageClass;

#define AUDIENCE_TYPE_LIBRARY_PAGE (audience_library_page_get_type ())
#define AUDIENCE_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage))
#define AUDIENCE_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))
#define AUDIENCE_IS_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_IS_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_LIBRARY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))

typedef struct _AudienceLibraryPage AudienceLibraryPage;
typedef struct _AudienceLibraryPageClass AudienceLibraryPageClass;

#define AUDIENCE_TYPE_PLAYER_PAGE (audience_player_page_get_type ())
#define AUDIENCE_PLAYER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYER_PAGE, AudiencePlayerPage))
#define AUDIENCE_PLAYER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYER_PAGE, AudiencePlayerPageClass))
#define AUDIENCE_IS_PLAYER_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYER_PAGE))
#define AUDIENCE_IS_PLAYER_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYER_PAGE))
#define AUDIENCE_PLAYER_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYER_PAGE, AudiencePlayerPageClass))

typedef struct _AudiencePlayerPage AudiencePlayerPage;
typedef struct _AudiencePlayerPageClass AudiencePlayerPageClass;
enum  {
	AUDIENCE_WINDOW_0_PROPERTY,
	AUDIENCE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* audience_window_properties[AUDIENCE_WINDOW_NUM_PROPERTIES];
typedef enum  {
	AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES
} AudienceWindowNavigationPage;

#define AUDIENCE_WINDOW_TYPE_NAVIGATION_PAGE (audience_window_navigation_page_get_type ())
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef void (*AudienceFuncOverDir) (GFile* file_under_dir, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;

#define AUDIENCE_TYPE_DISK_MANAGER (audience_disk_manager_get_type ())
#define AUDIENCE_DISK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManager))
#define AUDIENCE_DISK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManagerClass))
#define AUDIENCE_IS_DISK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_DISK_MANAGER))
#define AUDIENCE_IS_DISK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_DISK_MANAGER))
#define AUDIENCE_DISK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManagerClass))

typedef struct _AudienceDiskManager AudienceDiskManager;
typedef struct _AudienceDiskManagerClass AudienceDiskManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _AudienceWindowReadFirstDiskData AudienceWindowReadFirstDiskData;
typedef struct _Block4Data Block4Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define AUDIENCE_TYPE_LIBRARY_ITEM (audience_library_item_get_type ())
#define AUDIENCE_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem))
#define AUDIENCE_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))
#define AUDIENCE_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))

typedef struct _AudienceLibraryItem AudienceLibraryItem;
typedef struct _AudienceLibraryItemClass AudienceLibraryItemClass;

#define AUDIENCE_OBJECTS_TYPE_VIDEO (audience_objects_video_get_type ())
#define AUDIENCE_OBJECTS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo))
#define AUDIENCE_OBJECTS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))
#define AUDIENCE_OBJECTS_IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))

typedef struct _AudienceObjectsVideo AudienceObjectsVideo;
typedef struct _AudienceObjectsVideoClass AudienceObjectsVideoClass;

#define AUDIENCE_TYPE_WELCOME_PAGE (audience_welcome_page_get_type ())
#define AUDIENCE_WELCOME_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WELCOME_PAGE, AudienceWelcomePage))
#define AUDIENCE_WELCOME_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WELCOME_PAGE, AudienceWelcomePageClass))
#define AUDIENCE_IS_WELCOME_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WELCOME_PAGE))
#define AUDIENCE_IS_WELCOME_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WELCOME_PAGE))
#define AUDIENCE_WELCOME_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WELCOME_PAGE, AudienceWelcomePageClass))

typedef struct _AudienceWelcomePage AudienceWelcomePage;
typedef struct _AudienceWelcomePageClass AudienceWelcomePageClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
enum  {
	AUDIENCE_WINDOW_MEDIA_VOLUMES_CHANGED_SIGNAL,
	AUDIENCE_WINDOW_NUM_SIGNALS
};
static guint audience_window_signals[AUDIENCE_WINDOW_NUM_SIGNALS] = {0};

struct _AudienceWindow {
	HdyApplicationWindow parent_instance;
	AudienceWindowPrivate * priv;
};

struct _AudienceWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _AudienceWindowPrivate {
	HdyDeck* deck;
	GraniteWidgetsToast* app_notification;
	AudienceEpisodesPage* episodes_page;
	AudienceLibraryPage* library_page;
	GtkBox* welcome_page_box;
	AudiencePlayerPage* player_page;
};

struct _Block1Data {
	int _ref_count_;
	AudienceWindow* self;
	gchar** videos;
	gint videos_length1;
	gint _videos_size_;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	GFile* file;
};

struct _Block3Data {
	int _ref_count_;
	AudienceWindow* self;
	GtkFileChooserNative* file;
	gboolean clear_playlist;
	gboolean force_play;
};

struct _AudienceWindowReadFirstDiskData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceWindow* self;
	AudienceDiskManager* disk_manager;
	AudienceDiskManager* _tmp0_;
	AudienceDiskManager* _tmp1_;
	GeeTreeSet* _tmp2_;
	GeeTreeSet* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GVolume* volume;
	AudienceDiskManager* _tmp7_;
	GeeTreeSet* _tmp8_;
	GeeTreeSet* _tmp9_;
	gpointer _tmp10_;
	GVolume* _tmp11_;
	gboolean _tmp12_;
	GVolume* _tmp13_;
	GVolume* _tmp14_;
	GMount* _tmp15_;
	GMount* _tmp16_;
	GVolume* _tmp17_;
	GError* e;
	GError* _tmp18_;
	const gchar* _tmp19_;
	GFile* root;
	GVolume* _tmp20_;
	GMount* _tmp21_;
	GMount* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GError* _inner_error0_;
};

struct _Block4Data {
	int _ref_count_;
	AudienceWindow* self;
	GAction* play_pause_action;
};

static gint AudienceWindow_private_offset;
static gpointer audience_window_parent_class = NULL;
static GeeMultiMap* audience_window_action_accelerators;
static GeeMultiMap* audience_window_action_accelerators = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
VALA_EXTERN GType audience_episodes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceEpisodesPage, g_object_unref)
VALA_EXTERN GType audience_library_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryPage, g_object_unref)
VALA_EXTERN GType audience_player_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlayerPage, g_object_unref)
VALA_EXTERN GType audience_window_navigation_page_get_type (void) G_GNUC_CONST ;
static void audience_window_action_back (AudienceWindow* self);
static void _audience_window_action_back_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void audience_window_action_fullscreen (AudienceWindow* self);
static void _audience_window_action_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void audience_window_action_open_file (AudienceWindow* self);
static void _audience_window_action_open_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void audience_window_action_quit (AudienceWindow* self);
static void _audience_window_action_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void audience_window_action_search (AudienceWindow* self);
static void _audience_window_action_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void audience_window_action_undo (AudienceWindow* self);
static void _audience_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
VALA_EXTERN gboolean audience_player_page_get_fullscreened (AudiencePlayerPage* self);
VALA_EXTERN void audience_window_run_open_file (AudienceWindow* self,
                                    gboolean clear_playlist,
                                    gboolean force_play);
VALA_EXTERN void audience_library_page_search (AudienceLibraryPage* self);
VALA_EXTERN void audience_episodes_page_search (AudienceEpisodesPage* self);
VALA_EXTERN gboolean audience_is_sandboxed (void);
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
VALA_EXTERN void audience_services_library_manager_undo_delete_item (AudienceServicesLibraryManager* self);
VALA_EXTERN gboolean audience_window_match_keycode (AudienceWindow* self,
                                        guint keyval,
                                        guint code);
static gboolean audience_window_real_key_press_event (GtkWidget* base,
                                               GdkEventKey* e);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN void audience_player_page_seek_jump_seconds (AudiencePlayerPage* self,
                                             gint seconds);
VALA_EXTERN void audience_window_resume_last_videos (AudienceWindow* self);
VALA_EXTERN void audience_window_show_library (AudienceWindow* self);
VALA_EXTERN void audience_window_open_files (AudienceWindow* self,
                                 GFile** files,
                                 gint files_length1,
                                 gboolean clear_playlist_items,
                                 gboolean force_play);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN void audience_recurse_over_dir (GFile* file_to_process,
                                AudienceFuncOverDir func,
                                gpointer func_target);
static void _____lambda16_ (Block2Data* _data2_,
                     GFile* file_ret);
VALA_EXTERN void audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                                   GFile* file);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void ______lambda16__audience_func_over_dir (GFile* file_under_dir,
                                             gpointer self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN AudienceWindowNavigationPage audience_library_page_prepare_to_play (AudienceLibraryPage* self,
                                                                    const gchar* file);
VALA_EXTERN void audience_window_play_file (AudienceWindow* self,
                                const gchar* uri,
                                AudienceWindowNavigationPage origin,
                                gboolean from_beginning);
VALA_EXTERN void audience_window_run_open_dvd (AudienceWindow* self);
static void audience_window_read_first_disk (AudienceWindow* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static void audience_window_read_first_disk_finish (AudienceWindow* self,
                                             GAsyncResult* _res_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda34_ (Block3Data* _data3_,
                  gint response);
static void _vala_array_add3 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _g_object_unref0_ (gpointer var);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
static void ___lambda34__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void audience_window_read_first_disk_data_free (gpointer _data);
static gboolean audience_window_read_first_disk_co (AudienceWindowReadFirstDiskData* _data_);
VALA_EXTERN GType audience_disk_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceDiskManager, g_object_unref)
VALA_EXTERN AudienceDiskManager* audience_disk_manager_get_default (void);
VALA_EXTERN GeeTreeSet* audience_disk_manager_get_volumes (AudienceDiskManager* self);
static void audience_window_read_first_disk_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void audience_window_on_player_ended (AudienceWindow* self);
VALA_EXTERN void audience_playback_manager_play_file (AudiencePlaybackManager* self,
                                          const gchar* uri,
                                          gboolean from_beginning);
VALA_EXTERN gchar* audience_window_get_adjacent_page_name (AudienceWindow* self);
static void audience_window_update_navigation (AudienceWindow* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN gint64 audience_playback_manager_get_position (AudiencePlaybackManager* self);
static GVariant* _variant_new3 (gboolean value);
static gboolean ___lambda81_ (Block4Data* _data4_);
static GVariant* _variant_new4 (gboolean value);
static gboolean ____lambda81__gsource_func (gpointer self);
VALA_EXTERN void audience_window_hide_mouse_cursor (AudienceWindow* self);
VALA_EXTERN void audience_window_show_mouse_cursor (AudienceWindow* self);
VALA_EXTERN AudienceWindow* audience_window_new (void);
VALA_EXTERN AudienceWindow* audience_window_construct (GType object_type);
static GObject * audience_window_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
VALA_EXTERN AudienceLibraryPage* audience_library_page_get_instance (void);
VALA_EXTERN GType audience_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryItem, g_object_unref)
static void _audience_window___lambda82_ (AudienceWindow* self,
                                   AudienceLibraryItem* item,
                                   gboolean setup_only);
VALA_EXTERN GType audience_objects_video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsVideo, g_object_unref)
VALA_EXTERN void audience_episodes_page_set_episodes_items (AudienceEpisodesPage* self,
                                                GeeArrayList* episodes);
VALA_EXTERN GeeArrayList* audience_library_item_get_episodes (AudienceLibraryItem* self);
VALA_EXTERN GtkImage* audience_episodes_page_get_poster (AudienceEpisodesPage* self);
VALA_EXTERN GtkImage* audience_library_item_get_poster (AudienceLibraryItem* self);
VALA_EXTERN gchar* audience_library_item_get_title (AudienceLibraryItem* self);
static void __audience_window___lambda82__audience_library_page_show_episodes (AudienceLibraryPage* _sender,
                                                                        AudienceLibraryItem* item,
                                                                        gboolean setup_only,
                                                                        gpointer self);
VALA_EXTERN GType audience_welcome_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWelcomePage, g_object_unref)
VALA_EXTERN AudienceWelcomePage* audience_welcome_page_new (void);
VALA_EXTERN AudienceWelcomePage* audience_welcome_page_construct (GType object_type);
VALA_EXTERN AudiencePlayerPage* audience_player_page_new (void);
VALA_EXTERN AudiencePlayerPage* audience_player_page_construct (GType object_type);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_new (void);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_construct (GType object_type);
static void _audience_window___lambda90_ (AudienceWindow* self,
                                   const gchar* video);
static void _audience_window_action_undo_granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                        gpointer self);
static void __audience_window___lambda90__audience_services_library_manager_video_moved_to_trash (AudienceServicesLibraryManager* _sender,
                                                                                           const gchar* path,
                                                                                           gpointer self);
static void _audience_window___lambda91_ (AudienceWindow* self);
static void __audience_window___lambda91__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void _audience_window___lambda92_ (AudienceWindow* self);
static void __audience_window___lambda92__g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void _audience_window___lambda93_ (AudienceWindow* self,
                                   GdkDragContext* ctx,
                                   gint x,
                                   gint y,
                                   GtkSelectionData* sel,
                                   guint info,
                                   guint time);
static void _vala_GFile_free_function_content_of (gpointer data);
static void __audience_window___lambda93__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                  GdkDragContext* context,
                                                                  gint x,
                                                                  gint y,
                                                                  GtkSelectionData* selection_data,
                                                                  guint info,
                                                                  guint time_,
                                                                  gpointer self);
static gboolean _audience_window___lambda94_ (AudienceWindow* self,
                                       GdkEventButton* event);
static gboolean __audience_window___lambda94__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                      GdkEventButton* event,
                                                                      gpointer self);
static void _audience_window___lambda95_ (AudienceWindow* self,
                                   GFile* file);
static void __audience_window___lambda95__audience_playback_manager_play (AudiencePlaybackManager* _sender,
                                                                   GFile* file,
                                                                   gpointer self);
static void _audience_window_on_player_ended_audience_playback_manager_ended (AudiencePlaybackManager* _sender,
                                                                       gpointer self);
static void _audience_window___lambda96_ (AudienceWindow* self,
                                   const gchar* item_title);
static void __audience_window___lambda96__audience_playback_manager_item_added (AudiencePlaybackManager* _sender,
                                                                         const gchar* item_title,
                                                                         gpointer self);
static gboolean _audience_window___lambda97_ (AudienceWindow* self,
                                       GdkEventWindowState* e);
VALA_EXTERN void audience_player_page_set_fullscreened (AudiencePlayerPage* self,
                                            gboolean value);
static gboolean __audience_window___lambda97__gtk_widget_window_state_event (GtkWidget* _sender,
                                                                      GdkEventWindowState* event,
                                                                      gpointer self);
static gboolean _audience_window___lambda98_ (AudienceWindow* self,
                                       GdkEventConfigure* event);
VALA_EXTERN void audience_player_page_hide_popovers (AudiencePlayerPage* self);
static gboolean __audience_window___lambda98__gtk_widget_configure_event (GtkWidget* _sender,
                                                                   GdkEventConfigure* event,
                                                                   gpointer self);
static gboolean _audience_window___lambda99_ (AudienceWindow* self,
                                       GdkEventMotion* event);
static gboolean __audience_window___lambda99__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                       GdkEventMotion* event,
                                                                       gpointer self);
static void audience_window_finalize (GObject * obj);
static GType audience_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry AUDIENCE_WINDOW_ACTION_ENTRIES[6] = {{AUDIENCE_WINDOW_ACTION_BACK, _audience_window_action_back_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_FULLSCREEN, _audience_window_action_fullscreen_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_OPEN_FILE, _audience_window_action_open_file_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_QUIT, _audience_window_action_quit_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_SEARCH, _audience_window_action_search_gsimple_action_activate_callback}, {AUDIENCE_WINDOW_ACTION_UNDO, _audience_window_action_undo_gsimple_action_activate_callback}};

static inline gpointer
audience_window_get_instance_private (AudienceWindow* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceWindow_private_offset);
}

static GType
audience_window_navigation_page_get_type_once (void)
{
	static const GEnumValue values[] = {{AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME, "AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME", "welcome"}, {AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY, "AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY", "library"}, {AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES, "AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES", "episodes"}, {0, NULL, NULL}};
	GType audience_window_navigation_page_type_id;
	audience_window_navigation_page_type_id = g_enum_register_static ("AudienceWindowNavigationPage", values);
	return audience_window_navigation_page_type_id;
}

GType
audience_window_navigation_page_get_type (void)
{
	static volatile gsize audience_window_navigation_page_type_id__once = 0;
	if (g_once_init_enter (&audience_window_navigation_page_type_id__once)) {
		GType audience_window_navigation_page_type_id;
		audience_window_navigation_page_type_id = audience_window_navigation_page_get_type_once ();
		g_once_init_leave (&audience_window_navigation_page_type_id__once, audience_window_navigation_page_type_id);
	}
	return audience_window_navigation_page_type_id__once;
}

static void
_audience_window_action_back_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	audience_window_action_back ((AudienceWindow*) self);
}

static void
_audience_window_action_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	audience_window_action_fullscreen ((AudienceWindow*) self);
}

static void
_audience_window_action_open_file_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	audience_window_action_open_file ((AudienceWindow*) self);
}

static void
_audience_window_action_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	audience_window_action_quit ((AudienceWindow*) self);
}

static void
_audience_window_action_search_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	audience_window_action_search ((AudienceWindow*) self);
}

static void
_audience_window_action_undo_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	audience_window_action_undo ((AudienceWindow*) self);
}

static void
audience_window_action_back (AudienceWindow* self)
{
	HdyDeck* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	hdy_deck_navigate (_tmp0_, HDY_NAVIGATION_DIRECTION_BACK);
}

static void
audience_window_action_fullscreen (AudienceWindow* self)
{
	HdyDeck* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AudiencePlayerPage* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	_tmp1_ = hdy_deck_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->player_page;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		AudiencePlayerPage* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->player_page;
		_tmp5_ = audience_player_page_get_fullscreened (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_) {
			gtk_window_unfullscreen ((GtkWindow*) self);
		} else {
			gtk_window_fullscreen ((GtkWindow*) self);
		}
	}
}

static void
audience_window_action_open_file (AudienceWindow* self)
{
	g_return_if_fail (self != NULL);
	audience_window_run_open_file (self, FALSE, TRUE);
}

static void
audience_window_action_quit (AudienceWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
audience_window_action_search (AudienceWindow* self)
{
	HdyDeck* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AudienceLibraryPage* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	_tmp1_ = hdy_deck_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->library_page;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		AudienceLibraryPage* _tmp4_;
		_tmp4_ = self->priv->library_page;
		audience_library_page_search (_tmp4_);
	} else {
		HdyDeck* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		AudienceEpisodesPage* _tmp8_;
		_tmp5_ = self->priv->deck;
		_tmp6_ = hdy_deck_get_visible_child (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->episodes_page;
		if (_tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget)) {
			AudienceEpisodesPage* _tmp9_;
			_tmp9_ = self->priv->episodes_page;
			audience_episodes_page_search (_tmp9_);
		} else {
			GdkDisplay* _tmp10_;
			_tmp10_ = gdk_display_get_default ();
			gdk_display_beep (_tmp10_);
		}
	}
}

static void
audience_window_action_undo (AudienceWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!audience_is_sandboxed ()) {
		AudienceServicesLibraryManager* _tmp0_;
		AudienceServicesLibraryManager* _tmp1_;
		GraniteWidgetsToast* _tmp2_;
		HdyDeck* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		AudienceEpisodesPage* _tmp6_;
		_tmp0_ = audience_services_library_manager_get_instance ();
		_tmp1_ = _tmp0_;
		audience_services_library_manager_undo_delete_item (_tmp1_);
		_g_object_unref0 (_tmp1_);
		_tmp2_ = self->priv->app_notification;
		gtk_revealer_set_reveal_child ((GtkRevealer*) _tmp2_, FALSE);
		_tmp3_ = self->priv->deck;
		_tmp4_ = hdy_deck_get_visible_child (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->episodes_page;
		if (_tmp5_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget)) {
			HdyDeck* _tmp7_;
			AudienceLibraryPage* _tmp8_;
			_tmp7_ = self->priv->deck;
			_tmp8_ = self->priv->library_page;
			hdy_deck_set_visible_child (_tmp7_, (GtkWidget*) _tmp8_);
		}
	}
}

/** Returns true if the code parameter matches the keycode of the keyval parameter for
    * any keyboard group or level (in order to allow for non-QWERTY keyboards) **/
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
audience_window_match_keycode (AudienceWindow* self,
                               guint keyval,
                               guint code)
{
	GdkKeymapKey* keys = NULL;
	gint keys_length1 = 0;
	gint _keys_size_ = 0;
	GdkKeymap* keymap = NULL;
	GdkDisplay* _tmp0_;
	GdkKeymap* _tmp1_;
	GdkKeymap* _tmp2_;
	GdkKeymap* _tmp3_;
	GdkKeymapKey* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_keymap_get_for_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	keymap = _tmp2_;
	_tmp3_ = keymap;
	_tmp6_ = gdk_keymap_get_entries_for_keyval (_tmp3_, keyval, &_tmp4_, &_tmp5_);
	keys = (g_free (keys), NULL);
	keys = _tmp4_;
	keys_length1 = _tmp5_;
	_keys_size_ = keys_length1;
	if (_tmp6_) {
		GdkKeymapKey* _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = keys;
		_tmp7__length1 = keys_length1;
		{
			GdkKeymapKey* key_collection = NULL;
			gint key_collection_length1 = 0;
			gint _key_collection_size_ = 0;
			gint key_it = 0;
			key_collection = _tmp7_;
			key_collection_length1 = _tmp7__length1;
			for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
				GdkKeymapKey key = {0};
				key = key_collection[key_it];
				{
					GdkKeymapKey _tmp8_;
					_tmp8_ = key;
					if (code == _tmp8_.keycode) {
						result = TRUE;
						_g_object_unref0 (keymap);
						keys = (g_free (keys), NULL);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (keymap);
	keys = (g_free (keys), NULL);
	return result;
}

static gboolean
audience_window_real_key_press_event (GtkWidget* base,
                                      GdkEventKey* e)
{
	AudienceWindow * self;
	guint keycode = 0U;
	HdyDeck* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	AudiencePlayerPage* _tmp3_;
	gboolean result;
	self = (AudienceWindow*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	keycode = (guint) e->hardware_keycode;
	_tmp0_ = self->priv->deck;
	_tmp1_ = hdy_deck_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->player_page;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget)) {
		gboolean shift_pressed = FALSE;
		if (audience_window_match_keycode (self, GDK_KEY_space, keycode)) {
			GAction* play_pause_action = NULL;
			GApplication* _tmp4_;
			GAction* _tmp5_;
			GAction* _tmp6_;
			GAction* _tmp7_;
			_tmp4_ = g_application_get_default ();
			_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			play_pause_action = _tmp6_;
			_tmp7_ = play_pause_action;
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction), "activate", NULL);
			result = TRUE;
			_g_object_unref0 (play_pause_action);
			return result;
		} else {
			if (audience_window_match_keycode (self, GDK_KEY_p, keycode)) {
				GAction* play_pause_action = NULL;
				GApplication* _tmp8_;
				GAction* _tmp9_;
				GAction* _tmp10_;
				GAction* _tmp11_;
				_tmp8_ = g_application_get_default ();
				_tmp9_ = g_action_map_lookup_action ((GActionMap*) _tmp8_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
				_tmp10_ = _g_object_ref0 (_tmp9_);
				play_pause_action = _tmp10_;
				_tmp11_ = play_pause_action;
				g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, g_simple_action_get_type (), GSimpleAction), "activate", NULL);
				_g_object_unref0 (play_pause_action);
			} else {
				if (audience_window_match_keycode (self, GDK_KEY_a, keycode)) {
					AudiencePlaybackManager* _tmp12_;
					_tmp12_ = audience_playback_manager_get_default ();
					g_signal_emit_by_name (_tmp12_, "next-audio");
				} else {
					if (audience_window_match_keycode (self, GDK_KEY_s, keycode)) {
						AudiencePlaybackManager* _tmp13_;
						_tmp13_ = audience_playback_manager_get_default ();
						g_signal_emit_by_name (_tmp13_, "next-text");
					}
				}
			}
		}
		shift_pressed = (e->state & GDK_SHIFT_MASK) == GDK_SHIFT_MASK;
		switch (e->keyval) {
			case GDK_KEY_Escape:
			{
				AudiencePlayerPage* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = self->priv->player_page;
				_tmp15_ = audience_player_page_get_fullscreened (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					gtk_window_unfullscreen ((GtkWindow*) self);
				} else {
					gtk_widget_destroy ((GtkWidget*) self);
				}
				result = TRUE;
				return result;
			}
			case GDK_KEY_Down:
			{
				gint _tmp17_ = 0;
				AudiencePlayerPage* _tmp18_;
				if (shift_pressed) {
					_tmp17_ = -5;
				} else {
					_tmp17_ = -60;
				}
				_tmp18_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp18_, _tmp17_);
				break;
			}
			case GDK_KEY_Left:
			{
				gint _tmp19_ = 0;
				AudiencePlayerPage* _tmp20_;
				if (shift_pressed) {
					_tmp19_ = -1;
				} else {
					_tmp19_ = -10;
				}
				_tmp20_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp20_, _tmp19_);
				break;
			}
			case GDK_KEY_Right:
			{
				gint _tmp21_ = 0;
				AudiencePlayerPage* _tmp22_;
				if (shift_pressed) {
					_tmp21_ = 1;
				} else {
					_tmp21_ = 10;
				}
				_tmp22_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp22_, _tmp21_);
				break;
			}
			case GDK_KEY_Up:
			{
				gint _tmp23_ = 0;
				AudiencePlayerPage* _tmp24_;
				if (shift_pressed) {
					_tmp23_ = 5;
				} else {
					_tmp23_ = 60;
				}
				_tmp24_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp24_, _tmp23_);
				break;
			}
			case GDK_KEY_Page_Down:
			{
				AudiencePlayerPage* _tmp25_;
				_tmp25_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp25_, -600);
				break;
			}
			case GDK_KEY_Page_Up:
			{
				AudiencePlayerPage* _tmp26_;
				_tmp26_ = self->priv->player_page;
				audience_player_page_seek_jump_seconds (_tmp26_, 600);
				break;
			}
			default:
			{
				break;
			}
		}
	} else {
		HdyDeck* _tmp27_;
		GtkWidget* _tmp28_;
		GtkWidget* _tmp29_;
		GtkBox* _tmp30_;
		_tmp27_ = self->priv->deck;
		_tmp28_ = hdy_deck_get_visible_child (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->welcome_page_box;
		if (_tmp29_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_widget_get_type (), GtkWidget)) {
			gboolean ctrl_pressed = FALSE;
			gboolean _tmp31_ = FALSE;
			ctrl_pressed = (e->state & GDK_CONTROL_MASK) != 0;
			if (audience_window_match_keycode (self, GDK_KEY_p, keycode)) {
				_tmp31_ = TRUE;
			} else {
				_tmp31_ = audience_window_match_keycode (self, GDK_KEY_space, keycode);
			}
			if (_tmp31_) {
				audience_window_resume_last_videos (self);
				result = TRUE;
				return result;
			} else {
				gboolean _tmp32_ = FALSE;
				if (ctrl_pressed) {
					_tmp32_ = audience_window_match_keycode (self, GDK_KEY_b, keycode);
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					audience_window_show_library (self);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = GTK_WIDGET_CLASS (audience_window_parent_class)->key_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), e);
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		AudienceWindow* self;
		self = _data1_->self;
		_data1_->videos = (_vala_array_free (_data1_->videos, _data1_->videos_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		AudienceWindow* self;
		self = _data2_->_data1_->self;
		_g_object_unref0 (_data2_->file);
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_____lambda16_ (Block2Data* _data2_,
                GFile* file_ret)
{
	Block1Data* _data1_;
	AudienceWindow* self;
	AudiencePlaybackManager* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (file_ret != NULL);
	_tmp0_ = audience_playback_manager_get_default ();
	_tmp1_ = _data2_->file;
	audience_playback_manager_append_to_playlist (_tmp0_, _tmp1_);
	_tmp2_ = g_file_get_uri (file_ret);
	_vala_array_add1 (&_data1_->videos, &_data1_->videos_length1, &_data1_->_videos_size_, _tmp2_);
}

static void
______lambda16__audience_func_over_dir (GFile* file_under_dir,
                                        gpointer self)
{
	_____lambda16_ (self, file_under_dir);
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
audience_window_open_files (AudienceWindow* self,
                            GFile** files,
                            gint files_length1,
                            gboolean clear_playlist_items,
                            gboolean force_play)
{
	Block1Data* _data1_;
	gchar** _tmp1_;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	if (clear_playlist_items) {
		AudiencePlaybackManager* _tmp0_;
		_tmp0_ = audience_playback_manager_get_default ();
		g_signal_emit_by_name (_tmp0_, "clear-playlist", FALSE);
	}
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	_data1_->videos = _tmp1_;
	_data1_->videos_length1 = 0;
	_data1_->_videos_size_ = _data1_->videos_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp2_;
			GFile* file = NULL;
			_tmp2_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp2_;
			{
				Block2Data* _data2_;
				GFile* _tmp3_;
				_data2_ = g_slice_new0 (Block2Data);
				_data2_->_ref_count_ = 1;
				_data2_->_data1_ = block1_data_ref (_data1_);
				_data2_->file = file;
				_tmp3_ = _data2_->file;
				if (g_file_query_file_type (_tmp3_, 0, NULL) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp4_;
					_tmp4_ = _data2_->file;
					audience_recurse_over_dir (_tmp4_, ______lambda16__audience_func_over_dir, _data2_);
				} else {
					AudiencePlaybackManager* _tmp5_;
					GFile* _tmp6_;
					GFile* _tmp7_;
					gchar* _tmp8_;
					_tmp5_ = audience_playback_manager_get_default ();
					_tmp6_ = _data2_->file;
					audience_playback_manager_append_to_playlist (_tmp5_, _tmp6_);
					_tmp7_ = _data2_->file;
					_tmp8_ = g_file_get_uri (_tmp7_);
					_vala_array_add2 (&_data1_->videos, &_data1_->videos_length1, &_data1_->_videos_size_, _tmp8_);
				}
				block2_data_unref (_data2_);
				_data2_ = NULL;
			}
		}
	}
	if (force_play) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		_tmp10_ = _data1_->videos;
		_tmp10__length1 = _data1_->videos_length1;
		_tmp9_ = _tmp10__length1 > 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* videofile = NULL;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		AudienceWindowNavigationPage page = 0;
		AudienceLibraryPage* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp11_ = _data1_->videos;
		_tmp11__length1 = _data1_->videos_length1;
		_tmp12_ = _tmp11_[0];
		_tmp13_ = g_strdup (_tmp12_);
		videofile = _tmp13_;
		_tmp14_ = self->priv->library_page;
		_tmp15_ = videofile;
		page = audience_library_page_prepare_to_play (_tmp14_, _tmp15_);
		_tmp16_ = videofile;
		audience_window_play_file (self, _tmp16_, page, TRUE);
		_g_free0 (videofile);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

void
audience_window_resume_last_videos (AudienceWindow* self)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = audience_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "current-video");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "") != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = audience_settings;
		_tmp5_ = g_settings_get_string (_tmp4_, "current-video");
		_tmp6_ = _tmp5_;
		audience_window_play_file (self, _tmp6_, AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME, FALSE);
		_g_free0 (_tmp6_);
	} else {
		audience_window_action_open_file (self);
	}
}

void
audience_window_run_open_dvd (AudienceWindow* self)
{
	g_return_if_fail (self != NULL);
	audience_window_read_first_disk (self, NULL, NULL);
}

void
audience_window_show_library (AudienceWindow* self)
{
	AudienceLibraryPage* _tmp0_;
	HdyDeck* _tmp1_;
	AudienceLibraryPage* _tmp2_;
	HdyDeck* _tmp3_;
	AudienceLibraryPage* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->library_page;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->deck;
	_tmp2_ = self->priv->library_page;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->deck;
	_tmp4_ = self->priv->library_page;
	hdy_deck_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		AudienceWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->file);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
_vala_array_add3 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
__lambda34_ (Block3Data* _data3_,
             gint response)
{
	AudienceWindow* self;
	self = _data3_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GFile** files = NULL;
		GFile** _tmp0_;
		gint files_length1;
		gint _files_size_;
		GSList* _tmp1_;
		GFile** _tmp5_;
		gint _tmp5__length1;
		GSettings* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp0_ = g_new0 (GFile*, 0 + 1);
		files = _tmp0_;
		files_length1 = 0;
		_files_size_ = files_length1;
		_tmp1_ = gtk_file_chooser_get_files ((GtkFileChooser*) _data3_->file);
		{
			GSList* item_collection = NULL;
			GSList* item_it = NULL;
			item_collection = _tmp1_;
			for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
				GFile* _tmp2_;
				GFile* item = NULL;
				_tmp2_ = _g_object_ref0 ((GFile*) item_it->data);
				item = _tmp2_;
				{
					GFile* _tmp3_;
					GFile* _tmp4_;
					_tmp3_ = item;
					_tmp4_ = _g_object_ref0 (_tmp3_);
					_vala_array_add3 (&files, &files_length1, &_files_size_, _tmp4_);
					_g_object_unref0 (item);
				}
			}
			(item_collection == NULL) ? NULL : (item_collection = (_g_slist_free__g_object_unref0_ (item_collection), NULL));
		}
		_tmp5_ = files;
		_tmp5__length1 = files_length1;
		audience_window_open_files (self, _tmp5_, (gint) _tmp5__length1, _data3_->clear_playlist, _data3_->force_play);
		_tmp6_ = audience_settings;
		_tmp7_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _data3_->file);
		_tmp8_ = _tmp7_;
		g_settings_set_string (_tmp6_, "last-folder", _tmp8_);
		_g_free0 (_tmp8_);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data3_->file);
}

static void
___lambda34__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda34_ (self, response_id);
}

void
audience_window_run_open_file (AudienceWindow* self,
                               gboolean clear_playlist,
                               gboolean force_play)
{
	Block3Data* _data3_;
	GtkFileFilter* all_files_filter = NULL;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* video_filter = NULL;
	GtkFileFilter* _tmp1_;
	GtkFileChooserNative* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkFileFilter* _tmp6_;
	GtkFileFilter* _tmp7_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->clear_playlist = clear_playlist;
	_data3_->force_play = force_play;
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	all_files_filter = _tmp0_;
	gtk_file_filter_set_name (all_files_filter, _ ("All files"));
	gtk_file_filter_add_pattern (all_files_filter, "*");
	_tmp1_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp1_);
	video_filter = _tmp1_;
	gtk_file_filter_set_name (video_filter, _ ("Video files"));
	gtk_file_filter_add_mime_type (video_filter, "video/*");
	_tmp2_ = gtk_file_chooser_native_new (_ ("Open"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Open"), _ ("_Cancel"));
	_data3_->file = _tmp2_;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _data3_->file, TRUE);
	_tmp3_ = audience_settings;
	_tmp4_ = g_settings_get_string (_tmp3_, "last-folder");
	_tmp5_ = _tmp4_;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _data3_->file, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = _g_object_ref0 (video_filter);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data3_->file, _tmp6_);
	_tmp7_ = _g_object_ref0 (all_files_filter);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data3_->file, _tmp7_);
	g_signal_connect_data ((GtkNativeDialog*) _data3_->file, "response", (GCallback) ___lambda34__gtk_native_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data3_->file);
	_g_object_unref0 (video_filter);
	_g_object_unref0 (all_files_filter);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
audience_window_read_first_disk_data_free (gpointer _data)
{
	AudienceWindowReadFirstDiskData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceWindowReadFirstDiskData, _data_);
}

static void
audience_window_read_first_disk (AudienceWindow* self,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	AudienceWindowReadFirstDiskData* _data_;
	AudienceWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AudienceWindowReadFirstDiskData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_window_read_first_disk_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	audience_window_read_first_disk_co (_data_);
}

static void
audience_window_read_first_disk_finish (AudienceWindow* self,
                                        GAsyncResult* _res_)
{
	AudienceWindowReadFirstDiskData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
audience_window_read_first_disk_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	AudienceWindowReadFirstDiskData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	audience_window_read_first_disk_co (_data_);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
audience_window_read_first_disk_co (AudienceWindowReadFirstDiskData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = audience_disk_manager_get_default ();
	_data_->disk_manager = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->disk_manager;
	_data_->_tmp2_ = audience_disk_manager_get_volumes (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_object_unref0 (_data_->_tmp3_);
	if (_data_->_tmp6_) {
		_g_object_unref0 (_data_->disk_manager);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->disk_manager;
	_data_->_tmp8_ = audience_disk_manager_get_volumes (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = gee_abstract_sorted_set_first ((GeeAbstractSortedSet*) _data_->_tmp9_);
	_data_->_tmp11_ = (GVolume*) _data_->_tmp10_;
	_g_object_unref0 (_data_->_tmp9_);
	_data_->volume = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->volume;
	if (g_volume_can_mount (_data_->_tmp13_) == TRUE) {
		_data_->_tmp14_ = _data_->volume;
		_data_->_tmp15_ = g_volume_get_mount (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp12_ = g_mount_can_unmount (_data_->_tmp16_) == FALSE;
		_g_object_unref0 (_data_->_tmp16_);
	} else {
		_data_->_tmp12_ = FALSE;
	}
	if (_data_->_tmp12_) {
		{
			_data_->_tmp17_ = _data_->volume;
			_data_->_state_ = 1;
			g_volume_mount (_data_->_tmp17_, G_MOUNT_MOUNT_NONE, NULL, NULL, audience_window_read_first_disk_ready, _data_);
			return FALSE;
			_state_1:
			g_volume_mount_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp18_ = _data_->e;
			_data_->_tmp19_ = _data_->_tmp18_->message;
			g_critical ("Window.vala:455: %s", _data_->_tmp19_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->volume);
			_g_object_unref0 (_data_->disk_manager);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp20_ = _data_->volume;
	_data_->_tmp21_ = g_volume_get_mount (_data_->_tmp20_);
	_data_->_tmp22_ = _data_->_tmp21_;
	_data_->_tmp23_ = g_mount_get_default_location (_data_->_tmp22_);
	_data_->_tmp24_ = _data_->_tmp23_;
	_g_object_unref0 (_data_->_tmp22_);
	_data_->root = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->root;
	_data_->_tmp26_ = g_file_get_uri (_data_->_tmp25_);
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = string_replace (_data_->_tmp27_, "file:///", "dvd:///");
	_data_->_tmp29_ = _data_->_tmp28_;
	audience_window_play_file (_data_->self, _data_->_tmp29_, AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME, TRUE);
	_g_free0 (_data_->_tmp29_);
	_g_free0 (_data_->_tmp27_);
	_g_object_unref0 (_data_->root);
	_g_object_unref0 (_data_->volume);
	_g_object_unref0 (_data_->disk_manager);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
audience_window_on_player_ended (AudienceWindow* self)
{
	HdyDeck* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->deck;
	hdy_deck_navigate (_tmp0_, HDY_NAVIGATION_DIRECTION_BACK);
	gtk_window_unfullscreen ((GtkWindow*) self);
}

void
audience_window_play_file (AudienceWindow* self,
                           const gchar* uri,
                           AudienceWindowNavigationPage origin,
                           gboolean from_beginning)
{
	AudiencePlayerPage* _tmp0_;
	HdyDeck* _tmp1_;
	AudiencePlayerPage* _tmp2_;
	HdyDeck* _tmp3_;
	AudiencePlayerPage* _tmp4_;
	AudiencePlaybackManager* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->player_page;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->deck;
	_tmp2_ = self->priv->player_page;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->deck;
	_tmp4_ = self->priv->player_page;
	hdy_deck_set_visible_child (_tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = audience_playback_manager_get_default ();
	audience_playback_manager_play_file (_tmp5_, uri, from_beginning);
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		gtk_window_fullscreen ((GtkWindow*) self);
	}
}

gchar*
audience_window_get_adjacent_page_name (AudienceWindow* self)
{
	GtkWidget* previous_child = NULL;
	HdyDeck* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	AudienceEpisodesPage* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->deck;
	_tmp1_ = hdy_deck_get_adjacent_child (_tmp0_, HDY_NAVIGATION_DIRECTION_BACK);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	previous_child = _tmp2_;
	_tmp3_ = previous_child;
	_tmp4_ = self->priv->episodes_page;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (AUDIENCE_WINDOW_NAVIGATION_BUTTON_EPISODES);
		result = _tmp5_;
		_g_object_unref0 (previous_child);
		return result;
	} else {
		GtkWidget* _tmp6_;
		AudienceLibraryPage* _tmp7_;
		_tmp6_ = previous_child;
		_tmp7_ = self->priv->library_page;
		if (_tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget)) {
			gchar* _tmp8_;
			_tmp8_ = g_strdup (AUDIENCE_WINDOW_NAVIGATION_BUTTON_LIBRARY);
			result = _tmp8_;
			_g_object_unref0 (previous_child);
			return result;
		} else {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (AUDIENCE_WINDOW_NAVIGATION_BUTTON_WELCOMESCREEN);
			result = _tmp9_;
			_g_object_unref0 (previous_child);
			return result;
		}
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		AudienceWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->play_pause_action);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static GVariant*
_variant_new3 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static GVariant*
_variant_new4 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gboolean
___lambda81_ (Block4Data* _data4_)
{
	AudienceWindow* self;
	GdkWindow* _tmp0_;
	HdyDeck* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkBox* _tmp4_;
	GtkWidget* next_child = NULL;
	HdyDeck* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkWidget* _tmp18_;
	gboolean result;
	self = _data4_->self;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, NULL);
	_tmp1_ = self->priv->deck;
	_tmp2_ = hdy_deck_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->welcome_page_box;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		gtk_window_set_title ((GtkWindow*) self, _ ("Videos"));
	} else {
		HdyDeck* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		AudienceLibraryPage* _tmp8_;
		_tmp5_ = self->priv->deck;
		_tmp6_ = hdy_deck_get_visible_child (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->library_page;
		if (_tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget)) {
			gtk_window_set_title ((GtkWindow*) self, _ ("Library"));
		} else {
			HdyDeck* _tmp9_;
			GtkWidget* _tmp10_;
			GtkWidget* _tmp11_;
			AudiencePlayerPage* _tmp12_;
			_tmp9_ = self->priv->deck;
			_tmp10_ = hdy_deck_get_visible_child (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = self->priv->player_page;
			if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget)) {
				GAction* _tmp13_;
				GVariant* _tmp14_;
				_tmp13_ = _data4_->play_pause_action;
				_tmp14_ = _variant_new4 (TRUE);
				g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, g_simple_action_get_type (), GSimpleAction), _tmp14_);
				_g_variant_unref0 (_tmp14_);
			}
		}
	}
	_tmp15_ = self->priv->deck;
	_tmp16_ = hdy_deck_get_adjacent_child (_tmp15_, HDY_NAVIGATION_DIRECTION_FORWARD);
	_tmp17_ = _g_object_ref0 (_tmp16_);
	next_child = _tmp17_;
	_tmp18_ = next_child;
	if (_tmp18_ != NULL) {
		HdyDeck* _tmp19_;
		GtkWidget* _tmp20_;
		_tmp19_ = self->priv->deck;
		_tmp20_ = next_child;
		gtk_container_remove ((GtkContainer*) _tmp19_, _tmp20_);
	}
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (next_child);
	return result;
}

static gboolean
____lambda81__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda81_ (self);
	return result;
}

static void
audience_window_update_navigation (AudienceWindow* self)
{
	Block4Data* _data4_;
	gint64 position = 0LL;
	AudiencePlaybackManager* _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	GApplication* _tmp4_;
	GAction* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	GVariant* _tmp8_;
	HdyDeck* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = audience_playback_manager_get_default ();
	_tmp1_ = audience_playback_manager_get_position (_tmp0_);
	_tmp2_ = _tmp1_;
	position = _tmp2_;
	if (position > ((gint64) 0)) {
		GSettings* _tmp3_;
		_tmp3_ = audience_settings;
		g_settings_set_int64 (_tmp3_, "last-stopped", position);
	}
	_tmp4_ = g_application_get_default ();
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_data4_->play_pause_action = _tmp6_;
	_tmp7_ = _data4_->play_pause_action;
	_tmp8_ = _variant_new3 (FALSE);
	g_simple_action_set_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, g_simple_action_get_type (), GSimpleAction), _tmp8_);
	_g_variant_unref0 (_tmp8_);
	_tmp9_ = self->priv->deck;
	_tmp10_ = hdy_deck_get_transition_running (_tmp9_);
	_tmp11_ = _tmp10_;
	if (!_tmp11_) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda81__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

void
audience_window_hide_mouse_cursor (AudienceWindow* self)
{
	GdkCursor* cursor = NULL;
	GdkWindow* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkCursor* _tmp2_;
	GdkWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_window_get_display (_tmp0_);
	_tmp2_ = gdk_cursor_new_for_display (_tmp1_, GDK_BLANK_CURSOR);
	cursor = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp3_, cursor);
	_g_object_unref0 (cursor);
}

void
audience_window_show_mouse_cursor (AudienceWindow* self)
{
	GdkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_cursor (_tmp0_, NULL);
}

AudienceWindow*
audience_window_construct (GType object_type)
{
	AudienceWindow * self = NULL;
	self = (AudienceWindow*) g_object_new (object_type, NULL);
	return self;
}

AudienceWindow*
audience_window_new (void)
{
	return audience_window_construct (AUDIENCE_TYPE_WINDOW);
}

static void
_audience_window___lambda82_ (AudienceWindow* self,
                              AudienceLibraryItem* item,
                              gboolean setup_only)
{
	AudienceEpisodesPage* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	AudienceEpisodesPage* _tmp3_;
	GtkImage* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	GtkImage* _tmp7_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->episodes_page;
	_tmp1_ = audience_library_item_get_episodes (item);
	_tmp2_ = _tmp1_;
	audience_episodes_page_set_episodes_items (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->episodes_page;
	_tmp4_ = audience_episodes_page_get_poster (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = audience_library_item_get_poster (item);
	_tmp7_ = _tmp6_;
	g_object_get (_tmp7_, "pixbuf", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	g_object_set (_tmp5_, "pixbuf", _tmp10_, NULL);
	_g_object_unref0 (_tmp10_);
	if (!setup_only) {
		AudienceEpisodesPage* _tmp11_;
		HdyDeck* _tmp12_;
		AudienceEpisodesPage* _tmp13_;
		HdyDeck* _tmp14_;
		AudienceEpisodesPage* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp11_ = self->priv->episodes_page;
		gtk_widget_show_all ((GtkWidget*) _tmp11_);
		_tmp12_ = self->priv->deck;
		_tmp13_ = self->priv->episodes_page;
		gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = self->priv->deck;
		_tmp15_ = self->priv->episodes_page;
		hdy_deck_set_visible_child (_tmp14_, (GtkWidget*) _tmp15_);
		_tmp16_ = audience_library_item_get_title (item);
		_tmp17_ = _tmp16_;
		gtk_window_set_title ((GtkWindow*) self, _tmp17_);
		_g_free0 (_tmp17_);
	}
}

static void
__audience_window___lambda82__audience_library_page_show_episodes (AudienceLibraryPage* _sender,
                                                                   AudienceLibraryItem* item,
                                                                   gboolean setup_only,
                                                                   gpointer self)
{
	_audience_window___lambda82_ ((AudienceWindow*) self, item, setup_only);
}

static void
_audience_window_action_undo_granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                   gpointer self)
{
	audience_window_action_undo ((AudienceWindow*) self);
}

static void
_audience_window___lambda90_ (AudienceWindow* self,
                              const gchar* video)
{
	GraniteWidgetsToast* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GraniteWidgetsToast* _tmp9_;
	g_return_if_fail (video != NULL);
	_tmp0_ = self->priv->app_notification;
	_tmp1_ = g_path_get_basename (video);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Video '%s' Removed."), _tmp2_);
	_tmp4_ = _tmp3_;
	granite_widgets_toast_set_title (_tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	if (!audience_is_sandboxed ()) {
		GraniteWidgetsToast* _tmp5_;
		GraniteWidgetsToast* _tmp6_;
		guint _tmp7_;
		GraniteWidgetsToast* _tmp8_;
		_tmp5_ = self->priv->app_notification;
		granite_widgets_toast_set_default_action (_tmp5_, _ ("Restore"));
		_tmp6_ = self->priv->app_notification;
		g_signal_parse_name ("default-action", GRANITE_WIDGETS_TYPE_TOAST, &_tmp7_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _audience_window_action_undo_granite_widgets_toast_default_action, self);
		_tmp8_ = self->priv->app_notification;
		g_signal_connect_object (_tmp8_, "default-action", (GCallback) _audience_window_action_undo_granite_widgets_toast_default_action, self, 0);
	}
	_tmp9_ = self->priv->app_notification;
	granite_widgets_toast_send_notification (_tmp9_);
}

static void
__audience_window___lambda90__audience_services_library_manager_video_moved_to_trash (AudienceServicesLibraryManager* _sender,
                                                                                      const gchar* path,
                                                                                      gpointer self)
{
	_audience_window___lambda90_ ((AudienceWindow*) self, path);
}

static void
_audience_window___lambda91_ (AudienceWindow* self)
{
	audience_window_update_navigation (self);
}

static void
__audience_window___lambda91__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	_audience_window___lambda91_ ((AudienceWindow*) self);
}

static void
_audience_window___lambda92_ (AudienceWindow* self)
{
	audience_window_update_navigation (self);
}

static void
__audience_window___lambda92__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	_audience_window___lambda92_ ((AudienceWindow*) self);
}

static void
_vala_GFile_free_function_content_of (gpointer data)
{
	GFile* self;
	self = *((GFile**) data);
	_g_object_unref0_ (self);
}

static void
_audience_window___lambda93_ (AudienceWindow* self,
                              GdkDragContext* ctx,
                              gint x,
                              gint y,
                              GtkSelectionData* sel,
                              guint info,
                              guint time)
{
	GArray* files = NULL;
	GArray* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	GArray* _tmp9_;
	gpointer* _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (GFile*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_GFile_free_function_content_of);
	files = _tmp0_;
	_tmp2_ = _tmp1_ = gtk_selection_data_get_uris (sel);
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp2_;
		uri_collection_length1 = _vala_array_length (_tmp1_);
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp3_;
			gchar* uri = NULL;
			_tmp3_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp3_;
			{
				GFile* file = NULL;
				const gchar* _tmp4_;
				GFile* _tmp5_;
				GArray* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				_tmp4_ = uri;
				_tmp5_ = g_file_new_for_uri (_tmp4_);
				file = _tmp5_;
				_tmp6_ = files;
				_tmp7_ = file;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				g_array_append_val (_tmp6_, _tmp8_);
				_g_object_unref0 (file);
				_g_free0 (uri);
			}
		}
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp9_ = files;
	_tmp10_ = _tmp9_->data;
	_tmp10__length1 = _tmp9_->len;
	audience_window_open_files (self, _tmp10_, (gint) _tmp10__length1, FALSE, FALSE);
	_g_array_unref0 (files);
}

static void
__audience_window___lambda93__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gint x,
                                                             gint y,
                                                             GtkSelectionData* selection_data,
                                                             guint info,
                                                             guint time_,
                                                             gpointer self)
{
	_audience_window___lambda93_ ((AudienceWindow*) self, context, x, y, selection_data, info, time_);
}

static gboolean
_audience_window___lambda94_ (AudienceWindow* self,
                              GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = event->type == GDK_2BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		audience_window_action_fullscreen (self);
	}
	if (event->button == ((guint) GDK_BUTTON_SECONDARY)) {
		GAction* play_pause_action = NULL;
		GApplication* _tmp1_;
		GAction* _tmp2_;
		GAction* _tmp3_;
		GAction* _tmp4_;
		_tmp1_ = g_application_get_default ();
		_tmp2_ = g_action_map_lookup_action ((GActionMap*) _tmp1_, AUDIENCE_APP_ACTION_PLAY_PAUSE);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		play_pause_action = _tmp3_;
		_tmp4_ = play_pause_action;
		g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_simple_action_get_type (), GSimpleAction), "activate", NULL);
		_g_object_unref0 (play_pause_action);
	}
	result = GTK_WIDGET_CLASS (audience_window_parent_class)->button_press_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	return result;
}

static gboolean
__audience_window___lambda94__gtk_widget_button_press_event (GtkWidget* _sender,
                                                             GdkEventButton* event,
                                                             gpointer self)
{
	gboolean result;
	result = _audience_window___lambda94_ ((AudienceWindow*) self, event);
	return result;
}

static void
_audience_window___lambda95_ (AudienceWindow* self,
                              GFile* file)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile** _tmp3_;
	GFile** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_uri (_tmp1_);
	_tmp3_ = g_new0 (GFile*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	audience_window_open_files (self, _tmp4_, (gint) 1, FALSE, TRUE);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (_tmp1_);
}

static void
__audience_window___lambda95__audience_playback_manager_play (AudiencePlaybackManager* _sender,
                                                              GFile* file,
                                                              gpointer self)
{
	_audience_window___lambda95_ ((AudienceWindow*) self, file);
}

static void
_audience_window_on_player_ended_audience_playback_manager_ended (AudiencePlaybackManager* _sender,
                                                                  gpointer self)
{
	audience_window_on_player_ended ((AudienceWindow*) self);
}

static void
_audience_window___lambda96_ (AudienceWindow* self,
                              const gchar* item_title)
{
	GraniteWidgetsToast* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GraniteWidgetsToast* _tmp3_;
	GraniteWidgetsToast* _tmp4_;
	g_return_if_fail (item_title != NULL);
	_tmp0_ = self->priv->app_notification;
	_tmp1_ = g_strdup_printf (_ ("“%s” added to playlist"), item_title);
	_tmp2_ = _tmp1_;
	granite_widgets_toast_set_title (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->app_notification;
	granite_widgets_toast_set_default_action (_tmp3_, NULL);
	_tmp4_ = self->priv->app_notification;
	granite_widgets_toast_send_notification (_tmp4_);
}

static void
__audience_window___lambda96__audience_playback_manager_item_added (AudiencePlaybackManager* _sender,
                                                                    const gchar* item_title,
                                                                    gpointer self)
{
	_audience_window___lambda96_ ((AudienceWindow*) self, item_title);
}

static gboolean
_audience_window___lambda97_ (AudienceWindow* self,
                              GdkEventWindowState* e)
{
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	if ((e->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN) {
		AudiencePlayerPage* _tmp0_;
		AudiencePlayerPage* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp0_ = self->priv->player_page;
		audience_player_page_set_fullscreened (_tmp0_, (e->new_window_state & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN);
		_tmp1_ = self->priv->player_page;
		_tmp2_ = audience_player_page_get_fullscreened (_tmp1_);
		_tmp3_ = _tmp2_;
		if (!_tmp3_) {
			gtk_window_unmaximize ((GtkWindow*) self);
		}
	}
	if ((e->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
		gboolean currently_maximixed = FALSE;
		gboolean _tmp4_ = FALSE;
		HdyDeck* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		AudiencePlayerPage* _tmp8_;
		currently_maximixed = (e->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED;
		_tmp5_ = self->priv->deck;
		_tmp6_ = hdy_deck_get_visible_child (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->player_page;
		if (_tmp7_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget)) {
			_tmp4_ = currently_maximixed;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			gtk_window_fullscreen ((GtkWindow*) self);
		}
	}
	result = FALSE;
	return result;
}

static gboolean
__audience_window___lambda97__gtk_widget_window_state_event (GtkWidget* _sender,
                                                             GdkEventWindowState* event,
                                                             gpointer self)
{
	gboolean result;
	result = _audience_window___lambda97_ ((AudienceWindow*) self, event);
	return result;
}

static gboolean
_audience_window___lambda98_ (AudienceWindow* self,
                              GdkEventConfigure* event)
{
	AudiencePlayerPage* _tmp0_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->player_page;
	audience_player_page_hide_popovers (_tmp0_);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__audience_window___lambda98__gtk_widget_configure_event (GtkWidget* _sender,
                                                          GdkEventConfigure* event,
                                                          gpointer self)
{
	gboolean result;
	result = _audience_window___lambda98_ ((AudienceWindow*) self, event);
	return result;
}

static gboolean
_audience_window___lambda99_ (AudienceWindow* self,
                              GdkEventMotion* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	audience_window_show_mouse_cursor (self);
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__audience_window___lambda99__gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                              GdkEventMotion* event,
                                                              gpointer self)
{
	gboolean result;
	result = _audience_window___lambda99_ ((AudienceWindow*) self, event);
	return result;
}

static GObject *
audience_window_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceWindow * self;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	AudienceLibraryPage* _tmp21_;
	AudienceLibraryPage* _tmp22_;
	HdyHeaderBar* welcome_page_header_bar = NULL;
	gchar* _tmp23_;
	HdyHeaderBar* _tmp24_ = NULL;
	HdyHeaderBar* _tmp25_;
	GtkStyleContext* _tmp26_;
	AudienceWelcomePage* welcome_page = NULL;
	AudienceWelcomePage* _tmp27_;
	GtkBox* _tmp28_;
	GtkBox* _tmp29_;
	HdyHeaderBar* _tmp30_;
	GtkBox* _tmp31_;
	AudienceWelcomePage* _tmp32_;
	GtkBox* _tmp33_;
	GtkStyleContext* _tmp34_;
	AudiencePlayerPage* _tmp35_;
	AudienceEpisodesPage* _tmp36_;
	HdyDeck* _tmp37_ = NULL;
	HdyDeck* _tmp38_;
	GtkBox* _tmp39_;
	HdyWindowHandle* window_handle = NULL;
	HdyDeck* _tmp40_;
	GtkWidget* _tmp41_;
	HdyWindowHandle* _tmp42_ = NULL;
	GraniteWidgetsToast* _tmp43_;
	GtkOverlay* overlay = NULL;
	HdyWindowHandle* _tmp44_;
	GtkWidget* _tmp45_;
	GtkOverlay* _tmp46_ = NULL;
	GtkOverlay* _tmp47_;
	GraniteWidgetsToast* _tmp48_;
	GtkOverlay* _tmp49_;
	AudienceServicesLibraryManager* manager = NULL;
	AudienceServicesLibraryManager* _tmp50_;
	AudienceServicesLibraryManager* _tmp51_;
	HdyDeck* _tmp52_;
	HdyDeck* _tmp53_;
	GtkTargetEntry uris = {0};
	GtkTargetEntry _tmp54_ = {0};
	GtkTargetEntry _tmp55_;
	GtkTargetEntry* _tmp56_;
	GtkTargetEntry* _tmp57_;
	gint _tmp57__length1;
	AudiencePlayerPage* _tmp58_;
	AudiencePlaybackManager* playback_manager = NULL;
	AudiencePlaybackManager* _tmp59_;
	AudiencePlaybackManager* _tmp60_;
	AudiencePlaybackManager* _tmp61_;
	AudiencePlaybackManager* _tmp62_;
	AudiencePlaybackManager* _tmp63_;
	parent_class = G_OBJECT_CLASS (audience_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_WINDOW, AudienceWindow);
	g_action_map_add_action_entries ((GActionMap*) self, AUDIENCE_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (AUDIENCE_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp1_;
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp2_ = audience_window_action_accelerators;
		_tmp3_ = gee_multi_map_get_keys (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_action_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gchar* action = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GtkApplication* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GeeMultiMap* _tmp14_;
			const gchar* _tmp15_;
			GeeCollection* _tmp16_;
			GeeCollection* _tmp17_;
			gint _tmp18_ = 0;
			gpointer* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp7_ = _action_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _action_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			action = (gchar*) _tmp9_;
			_tmp10_ = application_instance;
			_tmp11_ = action;
			_tmp12_ = g_strconcat (AUDIENCE_WINDOW_ACTION_PREFIX, _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = audience_window_action_accelerators;
			_tmp15_ = action;
			_tmp16_ = gee_multi_map_get (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp19_ = gee_collection_to_array (_tmp17_, &_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp20__length1 = _tmp18_;
			gtk_application_set_accels_for_action (_tmp10_, _tmp13_, _tmp20_);
			_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	g_object_set ((GtkWindow*) self, "window-position", GTK_WIN_POS_CENTER, NULL);
	gtk_window_set_gravity ((GtkWindow*) self, GDK_GRAVITY_CENTER);
	gtk_window_set_default_size ((GtkWindow*) self, 1000, 680);
	_tmp21_ = audience_library_page_get_instance ();
	_g_object_unref0 (self->priv->library_page);
	self->priv->library_page = _tmp21_;
	_tmp22_ = self->priv->library_page;
	g_signal_connect_object (_tmp22_, "show-episodes", (GCallback) __audience_window___lambda82__audience_library_page_show_episodes, self, 0);
	_tmp23_ = g_strdup (_ ("Videos"));
	_tmp24_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp24_, TRUE);
	hdy_header_bar_set_title (_tmp24_, _tmp23_);
	_g_free0 (_tmp23_);
	g_object_ref_sink (_tmp24_);
	welcome_page_header_bar = _tmp24_;
	_tmp25_ = welcome_page_header_bar;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) _tmp25_);
	gtk_style_context_add_class (_tmp26_, GTK_STYLE_CLASS_FLAT);
	_tmp27_ = audience_welcome_page_new ();
	g_object_ref_sink (_tmp27_);
	welcome_page = _tmp27_;
	_tmp28_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->welcome_page_box);
	self->priv->welcome_page_box = _tmp28_;
	_tmp29_ = self->priv->welcome_page_box;
	_tmp30_ = welcome_page_header_bar;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->welcome_page_box;
	_tmp32_ = welcome_page;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = self->priv->welcome_page_box;
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) _tmp33_);
	gtk_style_context_add_class (_tmp34_, GTK_STYLE_CLASS_VIEW);
	_tmp35_ = audience_player_page_new ();
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->player_page);
	self->priv->player_page = _tmp35_;
	_tmp36_ = audience_episodes_page_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->episodes_page);
	self->priv->episodes_page = _tmp36_;
	_tmp37_ = (HdyDeck*) hdy_deck_new ();
	hdy_deck_set_can_swipe_back (_tmp37_, TRUE);
	g_object_ref_sink (_tmp37_);
	_g_object_unref0 (self->priv->deck);
	self->priv->deck = _tmp37_;
	_tmp38_ = self->priv->deck;
	_tmp39_ = self->priv->welcome_page_box;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = self->priv->deck;
	_tmp41_ = _g_object_ref0 ((GtkWidget*) _tmp40_);
	_tmp42_ = (HdyWindowHandle*) hdy_window_handle_new ();
	g_object_set ((GtkContainer*) _tmp42_, "child", _tmp41_, NULL);
	_g_object_unref0 (_tmp41_);
	g_object_ref_sink (_tmp42_);
	window_handle = _tmp42_;
	_tmp43_ = granite_widgets_toast_new ("");
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->app_notification);
	self->priv->app_notification = _tmp43_;
	_tmp44_ = window_handle;
	_tmp45_ = _g_object_ref0 ((GtkWidget*) _tmp44_);
	_tmp46_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_set ((GtkContainer*) _tmp46_, "child", _tmp45_, NULL);
	_g_object_unref0 (_tmp45_);
	g_object_ref_sink (_tmp46_);
	overlay = _tmp46_;
	_tmp47_ = overlay;
	_tmp48_ = self->priv->app_notification;
	gtk_overlay_add_overlay (_tmp47_, (GtkWidget*) _tmp48_);
	_tmp49_ = overlay;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp49_, NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp50_ = audience_services_library_manager_get_instance ();
	manager = _tmp50_;
	_tmp51_ = manager;
	g_signal_connect_object (_tmp51_, "video-moved-to-trash", (GCallback) __audience_window___lambda90__audience_services_library_manager_video_moved_to_trash, self, 0);
	_tmp52_ = self->priv->deck;
	g_signal_connect_object ((GObject*) _tmp52_, "notify::visible-child", (GCallback) __audience_window___lambda91__g_object_notify, self, 0);
	_tmp53_ = self->priv->deck;
	g_signal_connect_object ((GObject*) _tmp53_, "notify::transition-running", (GCallback) __audience_window___lambda92__g_object_notify, self, 0);
	_tmp54_.target = "text/uri-list";
	_tmp54_.flags = (guint) 0;
	_tmp54_.info = (guint) 0;
	uris = _tmp54_;
	_tmp55_ = uris;
	_tmp56_ = g_new0 (GtkTargetEntry, 1);
	_tmp56_[0] = _tmp55_;
	_tmp57_ = _tmp56_;
	_tmp57__length1 = 1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp57_, (gint) 1, GDK_ACTION_MOVE);
	_tmp57_ = (g_free (_tmp57_), NULL);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) __audience_window___lambda93__gtk_widget_drag_data_received, self, 0);
	_tmp58_ = self->priv->player_page;
	g_signal_connect_object ((GtkWidget*) _tmp58_, "button-press-event", (GCallback) __audience_window___lambda94__gtk_widget_button_press_event, self, 0);
	_tmp59_ = audience_playback_manager_get_default ();
	_tmp60_ = _g_object_ref0 (_tmp59_);
	playback_manager = _tmp60_;
	_tmp61_ = playback_manager;
	g_signal_connect_object (_tmp61_, "play", (GCallback) __audience_window___lambda95__audience_playback_manager_play, self, 0);
	_tmp62_ = playback_manager;
	g_signal_connect_object (_tmp62_, "ended", (GCallback) _audience_window_on_player_ended_audience_playback_manager_ended, self, 0);
	_tmp63_ = playback_manager;
	g_signal_connect_object (_tmp63_, "item-added", (GCallback) __audience_window___lambda96__audience_playback_manager_item_added, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "window-state-event", (GCallback) __audience_window___lambda97__gtk_widget_window_state_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) __audience_window___lambda98__gtk_widget_configure_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) __audience_window___lambda99__gtk_widget_motion_notify_event, self, 0);
	_g_object_unref0 (playback_manager);
	_g_object_unref0 (manager);
	_g_object_unref0 (overlay);
	_g_object_unref0 (window_handle);
	_g_object_unref0 (welcome_page);
	_g_object_unref0 (welcome_page_header_bar);
	_g_object_unref0 (application_instance);
	return obj;
}

static void
audience_window_class_init (AudienceWindowClass * klass,
                            gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	GeeMultiMap* _tmp6_;
	GeeMultiMap* _tmp7_;
	GeeMultiMap* _tmp8_;
	audience_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceWindow_private_offset);
	((GtkWidgetClass *) klass)->key_press_event = (gboolean (*) (GtkWidget*, GdkEventKey*)) audience_window_real_key_press_event;
	G_OBJECT_CLASS (klass)->constructor = audience_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_window_finalize;
	audience_window_signals[AUDIENCE_WINDOW_MEDIA_VOLUMES_CHANGED_SIGNAL] = g_signal_new ("media-volumes-changed", AUDIENCE_TYPE_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	audience_window_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp1_, AUDIENCE_WINDOW_ACTION_BACK, "<Alt>Left");
	_tmp2_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp2_, AUDIENCE_WINDOW_ACTION_BACK, "Back");
	_tmp3_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp3_, AUDIENCE_WINDOW_ACTION_FULLSCREEN, "F");
	_tmp4_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp4_, AUDIENCE_WINDOW_ACTION_FULLSCREEN, "F11");
	_tmp5_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp5_, AUDIENCE_WINDOW_ACTION_OPEN_FILE, "<Control>O");
	_tmp6_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp6_, AUDIENCE_WINDOW_ACTION_QUIT, "<Control>Q");
	_tmp7_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp7_, AUDIENCE_WINDOW_ACTION_SEARCH, "<Control>F");
	_tmp8_ = audience_window_action_accelerators;
	gee_multi_map_set (_tmp8_, AUDIENCE_WINDOW_ACTION_UNDO, "<Control>Z");
}

static void
audience_window_instance_init (AudienceWindow * self,
                               gpointer klass)
{
	self->priv = audience_window_get_instance_private (self);
}

static void
audience_window_finalize (GObject * obj)
{
	AudienceWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_WINDOW, AudienceWindow);
	_g_object_unref0 (self->priv->deck);
	_g_object_unref0 (self->priv->app_notification);
	_g_object_unref0 (self->priv->episodes_page);
	_g_object_unref0 (self->priv->library_page);
	_g_object_unref0 (self->priv->welcome_page_box);
	_g_object_unref0 (self->priv->player_page);
	G_OBJECT_CLASS (audience_window_parent_class)->finalize (obj);
}

static GType
audience_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceWindow), 0, (GInstanceInitFunc) audience_window_instance_init, NULL };
	GType audience_window_type_id;
	audience_window_type_id = g_type_register_static (hdy_application_window_get_type (), "AudienceWindow", &g_define_type_info, 0);
	AudienceWindow_private_offset = g_type_add_instance_private (audience_window_type_id, sizeof (AudienceWindowPrivate));
	return audience_window_type_id;
}

GType
audience_window_get_type (void)
{
	static volatile gsize audience_window_type_id__once = 0;
	if (g_once_init_enter (&audience_window_type_id__once)) {
		GType audience_window_type_id;
		audience_window_type_id = audience_window_get_type_once ();
		g_once_init_leave (&audience_window_type_id__once, audience_window_type_id);
	}
	return audience_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

