/* PlaylistPopover.c generated by valac 0.56.17, the Vala compiler
 * generated from PlaylistPopover.vala, do not modify */

/*-
 * Copyright 2013-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <handy.h>

#define AUDIENCE_WIDGETS_PLAYLIST_POPOVER_HEIGHT_OFFSET 300
#define AUDIENCE_APP_ACTION_PREFIX "app."
#define AUDIENCE_APP_ACTION_REPEAT "action-repeat"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER (audience_widgets_playlist_popover_get_type ())
#define AUDIENCE_WIDGETS_PLAYLIST_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopover))
#define AUDIENCE_WIDGETS_PLAYLIST_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopoverClass))
#define AUDIENCE_WIDGETS_IS_PLAYLIST_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER))
#define AUDIENCE_WIDGETS_IS_PLAYLIST_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER))
#define AUDIENCE_WIDGETS_PLAYLIST_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopoverClass))

typedef struct _AudienceWidgetsPlaylistPopover AudienceWidgetsPlaylistPopover;
typedef struct _AudienceWidgetsPlaylistPopoverClass AudienceWidgetsPlaylistPopoverClass;
typedef struct _AudienceWidgetsPlaylistPopoverPrivate AudienceWidgetsPlaylistPopoverPrivate;

#define AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM (audience_widgets_playlist_item_get_type ())
#define AUDIENCE_WIDGETS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM, AudienceWidgetsPlaylistItem))
#define AUDIENCE_WIDGETS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM, AudienceWidgetsPlaylistItemClass))
#define AUDIENCE_WIDGETS_IS_PLAYLIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM))
#define AUDIENCE_WIDGETS_IS_PLAYLIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM))
#define AUDIENCE_WIDGETS_PLAYLIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM, AudienceWidgetsPlaylistItemClass))

typedef struct _AudienceWidgetsPlaylistItem AudienceWidgetsPlaylistItem;
typedef struct _AudienceWidgetsPlaylistItemClass AudienceWidgetsPlaylistItemClass;
enum  {
	AUDIENCE_WIDGETS_PLAYLIST_POPOVER_0_PROPERTY,
	AUDIENCE_WIDGETS_PLAYLIST_POPOVER_NUM_PROPERTIES
};
static GParamSpec* audience_widgets_playlist_popover_properties[AUDIENCE_WIDGETS_PLAYLIST_POPOVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUDIENCE_TYPE_DISK_MANAGER (audience_disk_manager_get_type ())
#define AUDIENCE_DISK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManager))
#define AUDIENCE_DISK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManagerClass))
#define AUDIENCE_IS_DISK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_DISK_MANAGER))
#define AUDIENCE_IS_DISK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_DISK_MANAGER))
#define AUDIENCE_DISK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManagerClass))

typedef struct _AudienceDiskManager AudienceDiskManager;
typedef struct _AudienceDiskManagerClass AudienceDiskManagerClass;
typedef struct _Block15Data Block15Data;

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;

struct _AudienceWidgetsPlaylistPopover {
	GtkPopover parent_instance;
	AudienceWidgetsPlaylistPopoverPrivate * priv;
};

struct _AudienceWidgetsPlaylistPopoverClass {
	GtkPopoverClass parent_class;
};

struct _AudienceWidgetsPlaylistPopoverPrivate {
	GeeArrayList* items;
	GtkListBox* playlist;
	GtkButton* dvd;
	gint current;
};

struct _Block15Data {
	int _ref_count_;
	AudienceWidgetsPlaylistPopover* self;
	GtkToggleButton* rep;
	GtkScrolledWindow* playlist_scrolled;
	AudienceDiskManager* disk_manager;
};

static gint AudienceWidgetsPlaylistPopover_private_offset;
static gpointer audience_widgets_playlist_popover_parent_class = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_widgets_playlist_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWidgetsPlaylistPopover, g_object_unref)
VALA_EXTERN GType audience_widgets_playlist_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWidgetsPlaylistItem, g_object_unref)
static void audience_widgets_playlist_popover_save_playlist (AudienceWidgetsPlaylistPopover* self);
static void audience_widgets_playlist_popover_set_dvd_visibility (AudienceWidgetsPlaylistPopover* self,
                                                           gboolean visible);
static gboolean audience_widgets_playlist_popover_next (AudienceWidgetsPlaylistPopover* self);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN const gchar* audience_widgets_playlist_item_get_filename (AudienceWidgetsPlaylistItem* self);
static void audience_widgets_playlist_popover_previous (AudienceWidgetsPlaylistPopover* self);
static void audience_widgets_playlist_popover_add_item (AudienceWidgetsPlaylistPopover* self,
                                                 GFile* path);
VALA_EXTERN gchar* audience_get_title (const gchar* filename);
VALA_EXTERN AudienceWidgetsPlaylistItem* audience_widgets_playlist_item_new (const gchar* title,
                                                                 const gchar* filename);
VALA_EXTERN AudienceWidgetsPlaylistItem* audience_widgets_playlist_item_construct (GType object_type,
                                                                       const gchar* title,
                                                                       const gchar* filename);
static void audience_widgets_playlist_popover_clear_items (AudienceWidgetsPlaylistPopover* self,
                                                    gboolean should_stop);
VALA_EXTERN void audience_playback_manager_stop (AudiencePlaybackManager* self);
static GFile* audience_widgets_playlist_popover_get_first_item (AudienceWidgetsPlaylistPopover* self);
static void audience_widgets_playlist_popover_set_current (AudienceWidgetsPlaylistPopover* self,
                                                    const gchar* current_file);
VALA_EXTERN void audience_widgets_playlist_item_set_is_playing (AudienceWidgetsPlaylistItem* self,
                                                    gboolean value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void audience_widgets_playlist_popover_on_drag_data_received (AudienceWidgetsPlaylistPopover* self,
                                                              GdkDragContext* context,
                                                              gint x,
                                                              gint y,
                                                              GtkSelectionData* selection_data,
                                                              guint target_type,
                                                              guint time);
VALA_EXTERN AudienceWidgetsPlaylistPopover* audience_widgets_playlist_popover_new (void);
VALA_EXTERN AudienceWidgetsPlaylistPopover* audience_widgets_playlist_popover_construct (GType object_type);
static GObject * audience_widgets_playlist_popover_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
VALA_EXTERN GType audience_disk_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceDiskManager, g_object_unref)
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void _audience_widgets_playlist_popover_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                             GdkDragContext* context,
                                                                                             gint x,
                                                                                             gint y,
                                                                                             GtkSelectionData* selection_data,
                                                                                             guint info,
                                                                                             guint time_,
                                                                                             gpointer self);
static void _audience_widgets_playlist_popover___lambda32_ (AudienceWidgetsPlaylistPopover* self,
                                                     GtkListBoxRow* item);
static void __audience_widgets_playlist_popover___lambda32__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                 GtkListBoxRow* row,
                                                                                 gpointer self);
static void _audience_widgets_playlist_popover___lambda33_ (AudienceWidgetsPlaylistPopover* self);
VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
VALA_EXTERN void audience_window_run_open_file (AudienceWindow* self,
                                    gboolean clear_playlist,
                                    gboolean force_play);
static void __audience_widgets_playlist_popover___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void _audience_widgets_playlist_popover___lambda35_ (AudienceWidgetsPlaylistPopover* self);
VALA_EXTERN void audience_window_run_open_dvd (AudienceWindow* self);
static void __audience_widgets_playlist_popover___lambda35__gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void _audience_widgets_playlist_popover___lambda45_ (AudienceWidgetsPlaylistPopover* self);
static void __audience_widgets_playlist_popover___lambda45__gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void _audience_widgets_playlist_popover___lambda46_ (Block15Data* _data15_);
static void __audience_widgets_playlist_popover___lambda46__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                gpointer self);
static void _audience_widgets_playlist_popover_clear_items_audience_playback_manager_clear_playlist (AudiencePlaybackManager* _sender,
                                                                                              gboolean should_stop,
                                                                                              gpointer self);
static GFile* _audience_widgets_playlist_popover_get_first_item_audience_playback_manager_get_first_item (AudiencePlaybackManager* _sender,
                                                                                                   gpointer self);
static gboolean _audience_widgets_playlist_popover_next_audience_playback_manager_next (AudiencePlaybackManager* _sender,
                                                                                 gpointer self);
static void _audience_widgets_playlist_popover_previous_audience_playback_manager_previous (AudiencePlaybackManager* _sender,
                                                                                     gpointer self);
static void _audience_widgets_playlist_popover_add_item_audience_playback_manager_queue_file (AudiencePlaybackManager* _sender,
                                                                                       GFile* file,
                                                                                       gpointer self);
static void _audience_widgets_playlist_popover_save_playlist_audience_playback_manager_save_playlist (AudiencePlaybackManager* _sender,
                                                                                               gpointer self);
static void _audience_widgets_playlist_popover_set_current_audience_playback_manager_uri_changed (AudiencePlaybackManager* _sender,
                                                                                           const gchar* uri,
                                                                                           gpointer self);
VALA_EXTERN AudienceDiskManager* audience_disk_manager_get_default (void);
VALA_EXTERN gboolean audience_disk_manager_has_media_volumes (AudienceDiskManager* self);
static void _audience_widgets_playlist_popover___lambda47_ (Block15Data* _data15_,
                                                     GVolume* vol);
static void __audience_widgets_playlist_popover___lambda47__audience_disk_manager_volume_found (AudienceDiskManager* _sender,
                                                                                         GVolume* volume,
                                                                                         gpointer self);
static void _audience_widgets_playlist_popover___lambda48_ (Block15Data* _data15_,
                                                     GVolume* vol);
static void __audience_widgets_playlist_popover___lambda48__audience_disk_manager_volume_removed (AudienceDiskManager* _sender,
                                                                                           GVolume* volume,
                                                                                           gpointer self);
static void _audience_widgets_playlist_popover___lambda49_ (Block15Data* _data15_);
static void __audience_widgets_playlist_popover___lambda49__gtk_widget_map (GtkWidget* _sender,
                                                                     gpointer self);
static void audience_widgets_playlist_popover_finalize (GObject * obj);
static GType audience_widgets_playlist_popover_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GtkTargetEntry AUDIENCE_WIDGETS_PLAYLIST_POPOVER_TARGET_ENTRIES[1] = {{"PLAYLIST_ITEM", (guint) GTK_TARGET_SAME_APP, (guint) 0}};

static inline gpointer
audience_widgets_playlist_popover_get_instance_private (AudienceWidgetsPlaylistPopover* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceWidgetsPlaylistPopover_private_offset);
}

static void
audience_widgets_playlist_popover_set_dvd_visibility (AudienceWidgetsPlaylistPopover* self,
                                                      gboolean visible)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dvd;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp0_, !visible);
	_tmp1_ = self->priv->dvd;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, visible);
}

static gboolean
audience_widgets_playlist_popover_next (AudienceWidgetsPlaylistPopover* self)
{
	gint _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	AudiencePlaybackManager* _tmp4_;
	GeeArrayList* _tmp5_;
	gpointer _tmp6_;
	AudienceWidgetsPlaylistItem* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->items;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (self->priv->current >= _tmp3_) {
		self->priv->current = 0;
		result = FALSE;
		return result;
	}
	_tmp4_ = audience_playback_manager_get_default ();
	_tmp5_ = self->priv->items;
	_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, self->priv->current);
	_tmp7_ = (AudienceWidgetsPlaylistItem*) _tmp6_;
	_tmp8_ = audience_widgets_playlist_item_get_filename (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_new_for_commandline_arg (_tmp9_);
	_tmp11_ = _tmp10_;
	g_signal_emit_by_name (_tmp4_, "play", _tmp11_);
	_g_object_unref0 (_tmp11_);
	_g_object_unref0 (_tmp7_);
	result = TRUE;
	return result;
}

static void
audience_widgets_playlist_popover_previous (AudienceWidgetsPlaylistPopover* self)
{
	gint _tmp0_;
	AudiencePlaybackManager* _tmp9_;
	GeeArrayList* _tmp10_;
	gpointer _tmp11_;
	AudienceWidgetsPlaylistItem* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ - 1;
	if (self->priv->current < 0) {
		AudiencePlaybackManager* _tmp1_;
		GeeArrayList* _tmp2_;
		gpointer _tmp3_;
		AudienceWidgetsPlaylistItem* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		_tmp1_ = audience_playback_manager_get_default ();
		_tmp2_ = self->priv->items;
		_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _tmp2_, 0);
		_tmp4_ = (AudienceWidgetsPlaylistItem*) _tmp3_;
		_tmp5_ = audience_widgets_playlist_item_get_filename (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_new_for_commandline_arg (_tmp6_);
		_tmp8_ = _tmp7_;
		g_signal_emit_by_name (_tmp1_, "play", _tmp8_);
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp4_);
		return;
	}
	_tmp9_ = audience_playback_manager_get_default ();
	_tmp10_ = self->priv->items;
	_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, self->priv->current);
	_tmp12_ = (AudienceWidgetsPlaylistItem*) _tmp11_;
	_tmp13_ = audience_widgets_playlist_item_get_filename (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_file_new_for_commandline_arg (_tmp14_);
	_tmp16_ = _tmp15_;
	g_signal_emit_by_name (_tmp9_, "play", _tmp16_);
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (_tmp12_);
}

static void
audience_widgets_playlist_popover_add_item (AudienceWidgetsPlaylistPopover* self,
                                            GFile* path)
{
	gchar* file_name = NULL;
	gchar* _tmp0_;
	gchar* item_title = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	AudienceWidgetsPlaylistItem* row = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	AudienceWidgetsPlaylistItem* _tmp20_;
	AudienceWidgetsPlaylistItem* _tmp21_;
	GeeArrayList* _tmp22_;
	AudienceWidgetsPlaylistItem* _tmp23_;
	GtkListBox* _tmp24_;
	AudienceWidgetsPlaylistItem* _tmp25_;
	GtkListBox* _tmp26_;
	AudiencePlaybackManager* _tmp27_;
	const gchar* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (!g_file_query_exists (path, NULL)) {
		return;
	}
	_tmp0_ = g_file_get_uri (path);
	file_name = _tmp0_;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp1_;
		gint _item_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _item_index = 0;
		_tmp1_ = self->priv->items;
		_item_list = _tmp1_;
		_tmp2_ = _item_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_item_size = _tmp4_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			AudienceWidgetsPlaylistItem* item = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			AudienceWidgetsPlaylistItem* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_item_index = _item_index + 1;
			_tmp5_ = _item_index;
			_tmp6_ = _item_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _item_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _item_index);
			item = (AudienceWidgetsPlaylistItem*) _tmp8_;
			_tmp9_ = item;
			_tmp10_ = audience_widgets_playlist_item_get_filename (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = file_name;
			if (g_strcmp0 (_tmp11_, _tmp12_) == 0) {
				_g_object_unref0 (item);
				_g_free0 (file_name);
				return;
			}
			_g_object_unref0 (item);
		}
	}
	_tmp13_ = g_file_get_basename (path);
	_tmp14_ = _tmp13_;
	_tmp15_ = audience_get_title (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	item_title = _tmp16_;
	_tmp17_ = item_title;
	_tmp18_ = g_file_get_uri (path);
	_tmp19_ = _tmp18_;
	_tmp20_ = audience_widgets_playlist_item_new (_tmp17_, _tmp19_);
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	_g_free0 (_tmp19_);
	row = _tmp21_;
	_tmp22_ = self->priv->items;
	_tmp23_ = row;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
	_tmp24_ = self->priv->playlist;
	_tmp25_ = row;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->playlist;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = audience_playback_manager_get_default ();
	_tmp28_ = item_title;
	g_signal_emit_by_name (_tmp27_, "item-added", _tmp28_);
	_g_object_unref0 (row);
	_g_free0 (item_title);
	_g_free0 (file_name);
}

static void
audience_widgets_playlist_popover_clear_items (AudienceWidgetsPlaylistPopover* self,
                                               gboolean should_stop)
{
	GeeArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	self->priv->current = 0;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp0_;
		gint _item_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _item_index = 0;
		_tmp0_ = self->priv->items;
		_item_list = _tmp0_;
		_tmp1_ = _item_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_item_size = _tmp3_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			AudienceWidgetsPlaylistItem* item = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GtkListBox* _tmp8_;
			AudienceWidgetsPlaylistItem* _tmp9_;
			_item_index = _item_index + 1;
			_tmp4_ = _item_index;
			_tmp5_ = _item_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _item_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _item_index);
			item = (AudienceWidgetsPlaylistItem*) _tmp7_;
			_tmp8_ = self->priv->playlist;
			_tmp9_ = item;
			gtk_container_remove ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
			_g_object_unref0 (item);
		}
	}
	_tmp10_ = self->priv->items;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp10_);
	if (should_stop) {
		AudiencePlaybackManager* _tmp11_;
		_tmp11_ = audience_playback_manager_get_default ();
		audience_playback_manager_stop (_tmp11_);
	}
}

static GFile*
audience_widgets_playlist_popover_get_first_item (AudienceWidgetsPlaylistPopover* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		AudienceWidgetsPlaylistItem* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp3_ = self->priv->items;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, 0);
		_tmp5_ = (AudienceWidgetsPlaylistItem*) _tmp4_;
		_tmp6_ = audience_widgets_playlist_item_get_filename (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_new_for_commandline_arg (_tmp7_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp5_);
		result = _tmp9_;
		return result;
	}
	result = NULL;
	return result;
}

static void
audience_widgets_playlist_popover_set_current (AudienceWidgetsPlaylistPopover* self,
                                               const gchar* current_file)
{
	gint count = 0;
	gint current_played = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current_file != NULL);
	count = 0;
	current_played = 0;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp0_;
		gint _item_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _item_index = 0;
		_tmp0_ = self->priv->items;
		_item_list = _tmp0_;
		_tmp1_ = _item_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_item_size = _tmp3_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			AudienceWidgetsPlaylistItem* item = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			AudienceWidgetsPlaylistItem* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp13_;
			_item_index = _item_index + 1;
			_tmp4_ = _item_index;
			_tmp5_ = _item_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _item_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _item_index);
			item = (AudienceWidgetsPlaylistItem*) _tmp7_;
			_tmp8_ = item;
			_tmp9_ = audience_widgets_playlist_item_get_filename (_tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, current_file) == 0) {
				AudienceWidgetsPlaylistItem* _tmp11_;
				current_played = count;
				_tmp11_ = item;
				audience_widgets_playlist_item_set_is_playing (_tmp11_, TRUE);
			} else {
				AudienceWidgetsPlaylistItem* _tmp12_;
				_tmp12_ = item;
				audience_widgets_playlist_item_set_is_playing (_tmp12_, FALSE);
			}
			_tmp13_ = count;
			count = _tmp13_ + 1;
			_g_object_unref0 (item);
		}
	}
	self->priv->current = current_played;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
audience_widgets_playlist_popover_save_playlist (AudienceWidgetsPlaylistPopover* self)
{
	GSettings* privacy_settings = NULL;
	GSettings* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_;
	gchar** videos = NULL;
	gchar** _tmp4_;
	gint videos_length1;
	gint _videos_size_;
	GSettings* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.privacy");
	privacy_settings = _tmp0_;
	_tmp2_ = privacy_settings;
	if (!g_settings_get_boolean (_tmp2_, "remember-recent-files")) {
		_tmp1_ = TRUE;
	} else {
		GSettings* _tmp3_;
		_tmp3_ = privacy_settings;
		_tmp1_ = !g_settings_get_boolean (_tmp3_, "remember-app-usage");
	}
	if (_tmp1_) {
		_g_object_unref0 (privacy_settings);
		return;
	}
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	videos = _tmp4_;
	videos_length1 = 0;
	_videos_size_ = videos_length1;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp5_;
		gint _item_size = 0;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _item_index = 0;
		_tmp5_ = self->priv->items;
		_item_list = _tmp5_;
		_tmp6_ = _item_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_item_size = _tmp8_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			AudienceWidgetsPlaylistItem* item = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			AudienceWidgetsPlaylistItem* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			_item_index = _item_index + 1;
			_tmp9_ = _item_index;
			_tmp10_ = _item_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _item_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _item_index);
			item = (AudienceWidgetsPlaylistItem*) _tmp12_;
			_tmp13_ = item;
			_tmp14_ = audience_widgets_playlist_item_get_filename (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup (_tmp15_);
			_vala_array_add4 (&videos, &videos_length1, &_videos_size_, _tmp16_);
			_g_object_unref0 (item);
		}
	}
	_tmp17_ = audience_settings;
	_tmp18_ = videos;
	_tmp18__length1 = videos_length1;
	g_settings_set_strv (_tmp17_, "last-played-videos", _tmp18_);
	videos = (_vala_array_free (videos, videos_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (privacy_settings);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
audience_widgets_playlist_popover_on_drag_data_received (AudienceWidgetsPlaylistPopover* self,
                                                         GdkDragContext* context,
                                                         gint x,
                                                         gint y,
                                                         GtkSelectionData* selection_data,
                                                         guint target_type,
                                                         guint time)
{
	AudienceWidgetsPlaylistItem* target = NULL;
	GtkWidget* row = NULL;
	AudienceWidgetsPlaylistItem* source = NULL;
	gint new_position = 0;
	gint old_position = 0;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	AudienceWidgetsPlaylistItem* _tmp2_;
	AudienceWidgetsPlaylistItem* _tmp3_;
	AudienceWidgetsPlaylistItem* _tmp4_;
	guint8* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	AudienceWidgetsPlaylistItem* _tmp10_;
	AudienceWidgetsPlaylistItem* _tmp11_;
	AudienceWidgetsPlaylistItem* _tmp12_;
	AudienceWidgetsPlaylistItem* _tmp13_;
	GeeArrayList* _tmp14_;
	AudienceWidgetsPlaylistItem* _tmp15_;
	GeeArrayList* _tmp16_;
	AudienceWidgetsPlaylistItem* _tmp17_;
	GtkListBox* _tmp18_;
	AudienceWidgetsPlaylistItem* _tmp19_;
	GtkListBox* _tmp20_;
	AudienceWidgetsPlaylistItem* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = self->priv->playlist;
	_tmp1_ = gtk_list_box_get_row_at_y (_tmp0_, y);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM, AudienceWidgetsPlaylistItem));
	_g_object_unref0 (target);
	target = _tmp2_;
	_tmp3_ = target;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (source);
		_g_object_unref0 (row);
		_g_object_unref0 (target);
		return;
	}
	_tmp4_ = target;
	new_position = gtk_list_box_row_get_index ((GtkListBoxRow*) _tmp4_);
	_tmp5_ = gtk_selection_data_get_data (selection_data);
	_tmp6_ = ((GtkWidget**) _tmp5_)[0];
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (row);
	row = _tmp7_;
	_tmp8_ = row;
	_tmp9_ = gtk_widget_get_ancestor (_tmp8_, AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM);
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM, AudienceWidgetsPlaylistItem));
	_g_object_unref0 (source);
	source = _tmp10_;
	_tmp11_ = source;
	old_position = gtk_list_box_row_get_index ((GtkListBoxRow*) _tmp11_);
	_tmp12_ = source;
	_tmp13_ = target;
	if (_tmp12_ == _tmp13_) {
		_g_object_unref0 (source);
		_g_object_unref0 (row);
		_g_object_unref0 (target);
		return;
	}
	_tmp14_ = self->priv->items;
	_tmp15_ = source;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp14_, _tmp15_);
	_tmp16_ = self->priv->items;
	_tmp17_ = source;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp16_, new_position, _tmp17_);
	_tmp18_ = self->priv->playlist;
	_tmp19_ = source;
	gtk_container_remove ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->playlist;
	_tmp21_ = source;
	gtk_list_box_insert (_tmp20_, (GtkWidget*) _tmp21_, new_position);
	_g_object_unref0 (source);
	_g_object_unref0 (row);
	_g_object_unref0 (target);
}

AudienceWidgetsPlaylistPopover*
audience_widgets_playlist_popover_construct (GType object_type)
{
	AudienceWidgetsPlaylistPopover * self = NULL;
	self = (AudienceWidgetsPlaylistPopover*) g_object_new (object_type, NULL);
	return self;
}

AudienceWidgetsPlaylistPopover*
audience_widgets_playlist_popover_new (void)
{
	return audience_widgets_playlist_popover_construct (AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		AudienceWidgetsPlaylistPopover* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->disk_manager);
		_g_object_unref0 (_data15_->playlist_scrolled);
		_g_object_unref0 (_data15_->rep);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
_audience_widgets_playlist_popover_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                        GdkDragContext* context,
                                                                                        gint x,
                                                                                        gint y,
                                                                                        GtkSelectionData* selection_data,
                                                                                        guint info,
                                                                                        guint time_,
                                                                                        gpointer self)
{
	audience_widgets_playlist_popover_on_drag_data_received ((AudienceWidgetsPlaylistPopover*) self, context, x, y, selection_data, info, time_);
}

static void
_audience_widgets_playlist_popover___lambda32_ (AudienceWidgetsPlaylistPopover* self,
                                                GtkListBoxRow* item)
{
	gchar* filename = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	AudiencePlaybackManager* _tmp3_;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	g_return_if_fail (item != NULL);
	_tmp0_ = audience_widgets_playlist_item_get_filename (G_TYPE_CHECK_INSTANCE_CAST (item, AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM, AudienceWidgetsPlaylistItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	filename = _tmp2_;
	_tmp3_ = audience_playback_manager_get_default ();
	_tmp4_ = filename;
	_tmp5_ = g_file_new_for_commandline_arg (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_emit_by_name (_tmp3_, "play", _tmp6_);
	_g_object_unref0 (_tmp6_);
	_g_free0 (filename);
}

static void
__audience_widgets_playlist_popover___lambda32__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                            GtkListBoxRow* row,
                                                                            gpointer self)
{
	_audience_widgets_playlist_popover___lambda32_ ((AudienceWidgetsPlaylistPopover*) self, row);
}

static void
_audience_widgets_playlist_popover___lambda33_ (AudienceWidgetsPlaylistPopover* self)
{
	GApplication* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_tmp2_ = _tmp1_;
	audience_window_run_open_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, AUDIENCE_TYPE_WINDOW, AudienceWindow), FALSE, FALSE);
}

static void
__audience_widgets_playlist_popover___lambda33__gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	_audience_widgets_playlist_popover___lambda33_ ((AudienceWidgetsPlaylistPopover*) self);
}

static void
_audience_widgets_playlist_popover___lambda35_ (AudienceWidgetsPlaylistPopover* self)
{
	GApplication* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	gtk_popover_popdown ((GtkPopover*) self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_tmp2_ = _tmp1_;
	audience_window_run_open_dvd (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, AUDIENCE_TYPE_WINDOW, AudienceWindow));
}

static void
__audience_widgets_playlist_popover___lambda35__gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	_audience_widgets_playlist_popover___lambda35_ ((AudienceWidgetsPlaylistPopover*) self);
}

static void
_audience_widgets_playlist_popover___lambda45_ (AudienceWidgetsPlaylistPopover* self)
{
	AudiencePlaybackManager* _tmp0_;
	_tmp0_ = audience_playback_manager_get_default ();
	g_signal_emit_by_name (_tmp0_, "clear-playlist", TRUE);
}

static void
__audience_widgets_playlist_popover___lambda45__gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	_audience_widgets_playlist_popover___lambda45_ ((AudienceWidgetsPlaylistPopover*) self);
}

static void
_audience_widgets_playlist_popover___lambda46_ (Block15Data* _data15_)
{
	AudienceWidgetsPlaylistPopover* self;
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data15_->self;
	_tmp0_ = _data15_->rep;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkToggleButton* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		GtkToggleButton* _tmp6_;
		_tmp3_ = _data15_->rep;
		_tmp4_ = gtk_button_get_image ((GtkButton*) _tmp3_);
		_tmp5_ = _tmp4_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_image_get_type (), GtkImage), "icon-name", "media-playlist-repeat-symbolic", NULL);
		_tmp6_ = _data15_->rep;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Disable Repeat"));
	} else {
		GtkToggleButton* _tmp7_;
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		GtkToggleButton* _tmp10_;
		_tmp7_ = _data15_->rep;
		_tmp8_ = gtk_button_get_image ((GtkButton*) _tmp7_);
		_tmp9_ = _tmp8_;
		g_object_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_image_get_type (), GtkImage), "icon-name", "media-playlist-no-repeat-symbolic", NULL);
		_tmp10_ = _data15_->rep;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("Enable Repeat"));
	}
}

static void
__audience_widgets_playlist_popover___lambda46__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                           gpointer self)
{
	_audience_widgets_playlist_popover___lambda46_ (self);
}

static void
_audience_widgets_playlist_popover_clear_items_audience_playback_manager_clear_playlist (AudiencePlaybackManager* _sender,
                                                                                         gboolean should_stop,
                                                                                         gpointer self)
{
	audience_widgets_playlist_popover_clear_items ((AudienceWidgetsPlaylistPopover*) self, should_stop);
}

static GFile*
_audience_widgets_playlist_popover_get_first_item_audience_playback_manager_get_first_item (AudiencePlaybackManager* _sender,
                                                                                            gpointer self)
{
	GFile* result;
	result = audience_widgets_playlist_popover_get_first_item ((AudienceWidgetsPlaylistPopover*) self);
	return result;
}

static gboolean
_audience_widgets_playlist_popover_next_audience_playback_manager_next (AudiencePlaybackManager* _sender,
                                                                        gpointer self)
{
	gboolean result;
	result = audience_widgets_playlist_popover_next ((AudienceWidgetsPlaylistPopover*) self);
	return result;
}

static void
_audience_widgets_playlist_popover_previous_audience_playback_manager_previous (AudiencePlaybackManager* _sender,
                                                                                gpointer self)
{
	audience_widgets_playlist_popover_previous ((AudienceWidgetsPlaylistPopover*) self);
}

static void
_audience_widgets_playlist_popover_add_item_audience_playback_manager_queue_file (AudiencePlaybackManager* _sender,
                                                                                  GFile* file,
                                                                                  gpointer self)
{
	audience_widgets_playlist_popover_add_item ((AudienceWidgetsPlaylistPopover*) self, file);
}

static void
_audience_widgets_playlist_popover_save_playlist_audience_playback_manager_save_playlist (AudiencePlaybackManager* _sender,
                                                                                          gpointer self)
{
	audience_widgets_playlist_popover_save_playlist ((AudienceWidgetsPlaylistPopover*) self);
}

static void
_audience_widgets_playlist_popover_set_current_audience_playback_manager_uri_changed (AudiencePlaybackManager* _sender,
                                                                                      const gchar* uri,
                                                                                      gpointer self)
{
	audience_widgets_playlist_popover_set_current ((AudienceWidgetsPlaylistPopover*) self, uri);
}

static void
_audience_widgets_playlist_popover___lambda47_ (Block15Data* _data15_,
                                                GVolume* vol)
{
	AudienceWidgetsPlaylistPopover* self;
	AudienceDiskManager* _tmp0_;
	self = _data15_->self;
	g_return_if_fail (vol != NULL);
	_tmp0_ = _data15_->disk_manager;
	audience_widgets_playlist_popover_set_dvd_visibility (self, audience_disk_manager_has_media_volumes (_tmp0_));
}

static void
__audience_widgets_playlist_popover___lambda47__audience_disk_manager_volume_found (AudienceDiskManager* _sender,
                                                                                    GVolume* volume,
                                                                                    gpointer self)
{
	_audience_widgets_playlist_popover___lambda47_ (self, volume);
}

static void
_audience_widgets_playlist_popover___lambda48_ (Block15Data* _data15_,
                                                GVolume* vol)
{
	AudienceWidgetsPlaylistPopover* self;
	AudienceDiskManager* _tmp0_;
	self = _data15_->self;
	g_return_if_fail (vol != NULL);
	_tmp0_ = _data15_->disk_manager;
	audience_widgets_playlist_popover_set_dvd_visibility (self, audience_disk_manager_has_media_volumes (_tmp0_));
}

static void
__audience_widgets_playlist_popover___lambda48__audience_disk_manager_volume_removed (AudienceDiskManager* _sender,
                                                                                      GVolume* volume,
                                                                                      gpointer self)
{
	_audience_widgets_playlist_popover___lambda48_ (self, volume);
}

static void
_audience_widgets_playlist_popover___lambda49_ (Block15Data* _data15_)
{
	AudienceWidgetsPlaylistPopover* self;
	gint window_height = 0;
	GApplication* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	GdkWindow* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	self = _data15_->self;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) _tmp2_);
	window_height = gdk_window_get_height (_tmp3_);
	_tmp4_ = _data15_->playlist_scrolled;
	gtk_scrolled_window_set_max_content_height (_tmp4_, window_height - AUDIENCE_WIDGETS_PLAYLIST_POPOVER_HEIGHT_OFFSET);
}

static void
__audience_widgets_playlist_popover___lambda49__gtk_widget_map (GtkWidget* _sender,
                                                                gpointer self)
{
	_audience_widgets_playlist_popover___lambda49_ (self);
}

static GObject *
audience_widgets_playlist_popover_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceWidgetsPlaylistPopover * self;
	Block15Data* _data15_;
	GeeArrayList* _tmp0_;
	GtkButton* fil = NULL;
	gchar* _tmp1_;
	GtkButton* _tmp2_ = NULL;
	gchar* _tmp3_;
	GtkButton* _tmp4_ = NULL;
	GtkButton* clear_playlist_button = NULL;
	gchar* _tmp5_;
	GtkButton* _tmp6_ = NULL;
	gchar* _tmp7_;
	GtkImage* _tmp8_;
	gchar* _tmp9_;
	GtkToggleButton* _tmp10_ = NULL;
	GtkListBox* _tmp11_ = NULL;
	GtkListBox* _tmp12_;
	GtkWidget* _tmp13_;
	GtkScrolledWindow* _tmp14_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp15_ = NULL;
	GtkGrid* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkGrid* _tmp18_;
	GtkButton* _tmp19_;
	GtkGrid* _tmp20_;
	GtkButton* _tmp21_;
	GtkGrid* _tmp22_;
	GtkButton* _tmp23_;
	GtkGrid* _tmp24_;
	GtkToggleButton* _tmp25_;
	GtkGrid* _tmp26_;
	GtkGrid* _tmp27_;
	GtkListBox* _tmp51_;
	GtkButton* _tmp52_;
	GtkButton* _tmp53_;
	GtkButton* _tmp54_;
	GtkToggleButton* _tmp55_;
	AudiencePlaybackManager* playback_manager = NULL;
	AudiencePlaybackManager* _tmp56_;
	AudiencePlaybackManager* _tmp57_;
	AudiencePlaybackManager* _tmp58_;
	AudiencePlaybackManager* _tmp59_;
	AudiencePlaybackManager* _tmp60_;
	AudiencePlaybackManager* _tmp61_;
	AudiencePlaybackManager* _tmp62_;
	AudiencePlaybackManager* _tmp63_;
	AudiencePlaybackManager* _tmp64_;
	AudienceDiskManager* _tmp65_;
	AudienceDiskManager* _tmp66_;
	AudienceDiskManager* _tmp67_;
	AudienceDiskManager* _tmp68_;
	parent_class = G_OBJECT_CLASS (audience_widgets_playlist_popover_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopover);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (AUDIENCE_WIDGETS_TYPE_PLAYLIST_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp0_;
	_tmp1_ = g_strdup (_ ("Open file"));
	_tmp2_ = (GtkButton*) gtk_button_new_from_icon_name ("document-open-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_ref_sink (_tmp2_);
	fil = _tmp2_;
	_tmp3_ = g_strdup (_ ("Play from Disc"));
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("media-optical-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->dvd);
	self->priv->dvd = _tmp4_;
	_tmp5_ = g_strdup (_ ("Clear Playlist"));
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	g_object_ref_sink (_tmp6_);
	clear_playlist_button = _tmp6_;
	_tmp7_ = g_strdup (AUDIENCE_APP_ACTION_PREFIX AUDIENCE_APP_ACTION_REPEAT);
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("media-playlist-no-repeat-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = g_strdup (_ ("Enable Repeat"));
	_tmp10_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp10_, _tmp7_);
	_g_free0 (_tmp7_);
	gtk_button_set_image ((GtkButton*) _tmp10_, (GtkWidget*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp9_);
	_g_free0 (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_data15_->rep = _tmp10_;
	_tmp11_ = (GtkListBox*) gtk_list_box_new ();
	gtk_widget_set_can_focus ((GtkWidget*) _tmp11_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp11_, TRUE);
	gtk_list_box_set_selection_mode (_tmp11_, GTK_SELECTION_BROWSE);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->playlist);
	self->priv->playlist = _tmp11_;
	_tmp12_ = self->priv->playlist;
	_tmp13_ = _g_object_ref0 ((GtkWidget*) _tmp12_);
	_tmp14_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_min_content_height (_tmp14_, 100);
	gtk_scrolled_window_set_min_content_width (_tmp14_, 260);
	gtk_scrolled_window_set_propagate_natural_height (_tmp14_, TRUE);
	g_object_set ((GtkContainer*) _tmp14_, "child", _tmp13_, NULL);
	_g_object_unref0 (_tmp13_);
	g_object_ref_sink (_tmp14_);
	_data15_->playlist_scrolled = _tmp14_;
	_tmp15_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp15_, 12);
	gtk_grid_set_row_spacing (_tmp15_, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp15_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp15_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp15_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp15_, 6);
	g_object_ref_sink (_tmp15_);
	grid = _tmp15_;
	_tmp16_ = grid;
	_tmp17_ = _data15_->playlist_scrolled;
	gtk_grid_attach (_tmp16_, (GtkWidget*) _tmp17_, 0, 0, 7, 1);
	_tmp18_ = grid;
	_tmp19_ = fil;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp19_, 0, 1, 1, 1);
	_tmp20_ = grid;
	_tmp21_ = clear_playlist_button;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 1, 1, 1, 1);
	_tmp22_ = grid;
	_tmp23_ = self->priv->dvd;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 2, 1, 1, 1);
	_tmp24_ = grid;
	_tmp25_ = _data15_->rep;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 6, 1, 1, 1);
	_tmp26_ = grid;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_tmp27_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp27_);
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, AUDIENCE_WIDGETS_PLAYLIST_POPOVER_TARGET_ENTRIES, (gint) G_N_ELEMENTS (AUDIENCE_WIDGETS_PLAYLIST_POPOVER_TARGET_ENTRIES), GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _audience_widgets_playlist_popover_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				GSettings* _tmp30_;
				gchar** _tmp31_;
				gchar** _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				gboolean _tmp34_;
				GSettings* _tmp35_;
				gchar** _tmp36_;
				gchar** _tmp37_;
				gchar** _tmp38_;
				gint _tmp38__length1;
				const gchar* _tmp39_;
				GSettings* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gboolean _tmp43_;
				GSettings* _tmp44_;
				gchar** _tmp45_;
				gchar** _tmp46_;
				gchar** _tmp47_;
				gint _tmp47__length1;
				const gchar* _tmp48_;
				GFile* _tmp49_;
				GFile* _tmp50_;
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = i;
					i = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				_tmp30_ = audience_settings;
				_tmp32_ = _tmp31_ = g_settings_get_strv (_tmp30_, "last-played-videos");
				_tmp33_ = _tmp32_;
				_tmp33__length1 = _vala_array_length (_tmp31_);
				_tmp34_ = !(i < _vala_array_length (_tmp31_));
				_tmp33_ = (_vala_array_free (_tmp33_, _tmp33__length1, (GDestroyNotify) g_free), NULL);
				if (_tmp34_) {
					break;
				}
				_tmp35_ = audience_settings;
				_tmp37_ = _tmp36_ = g_settings_get_strv (_tmp35_, "last-played-videos");
				_tmp38_ = _tmp37_;
				_tmp38__length1 = _vala_array_length (_tmp36_);
				_tmp39_ = _tmp38_[i];
				_tmp40_ = audience_settings;
				_tmp41_ = g_settings_get_string (_tmp40_, "current-video");
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strcmp0 (_tmp39_, _tmp42_) == 0;
				_g_free0 (_tmp42_);
				_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
				if (_tmp43_) {
					self->priv->current = i;
				}
				_tmp44_ = audience_settings;
				_tmp46_ = _tmp45_ = g_settings_get_strv (_tmp44_, "last-played-videos");
				_tmp47_ = _tmp46_;
				_tmp47__length1 = _vala_array_length (_tmp45_);
				_tmp48_ = _tmp47_[i];
				_tmp49_ = g_file_new_for_uri (_tmp48_);
				_tmp50_ = _tmp49_;
				audience_widgets_playlist_popover_add_item (self, _tmp50_);
				_g_object_unref0 (_tmp50_);
				_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	_tmp51_ = self->priv->playlist;
	g_signal_connect_object (_tmp51_, "row-activated", (GCallback) __audience_widgets_playlist_popover___lambda32__gtk_list_box_row_activated, self, 0);
	_tmp52_ = fil;
	g_signal_connect_object (_tmp52_, "clicked", (GCallback) __audience_widgets_playlist_popover___lambda33__gtk_button_clicked, self, 0);
	_tmp53_ = self->priv->dvd;
	g_signal_connect_object (_tmp53_, "clicked", (GCallback) __audience_widgets_playlist_popover___lambda35__gtk_button_clicked, self, 0);
	_tmp54_ = clear_playlist_button;
	g_signal_connect_object (_tmp54_, "clicked", (GCallback) __audience_widgets_playlist_popover___lambda45__gtk_button_clicked, self, 0);
	_tmp55_ = _data15_->rep;
	g_signal_connect_data (_tmp55_, "toggled", (GCallback) __audience_widgets_playlist_popover___lambda46__gtk_toggle_button_toggled, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp56_ = audience_playback_manager_get_default ();
	_tmp57_ = _g_object_ref0 (_tmp56_);
	playback_manager = _tmp57_;
	_tmp58_ = playback_manager;
	g_signal_connect_object (_tmp58_, "clear-playlist", (GCallback) _audience_widgets_playlist_popover_clear_items_audience_playback_manager_clear_playlist, self, 0);
	_tmp59_ = playback_manager;
	g_signal_connect_object (_tmp59_, "get-first-item", (GCallback) _audience_widgets_playlist_popover_get_first_item_audience_playback_manager_get_first_item, self, 0);
	_tmp60_ = playback_manager;
	g_signal_connect_object (_tmp60_, "next", (GCallback) _audience_widgets_playlist_popover_next_audience_playback_manager_next, self, 0);
	_tmp61_ = playback_manager;
	g_signal_connect_object (_tmp61_, "previous", (GCallback) _audience_widgets_playlist_popover_previous_audience_playback_manager_previous, self, 0);
	_tmp62_ = playback_manager;
	g_signal_connect_object (_tmp62_, "queue-file", (GCallback) _audience_widgets_playlist_popover_add_item_audience_playback_manager_queue_file, self, 0);
	_tmp63_ = playback_manager;
	g_signal_connect_object (_tmp63_, "save-playlist", (GCallback) _audience_widgets_playlist_popover_save_playlist_audience_playback_manager_save_playlist, self, 0);
	_tmp64_ = playback_manager;
	g_signal_connect_object (_tmp64_, "uri-changed", (GCallback) _audience_widgets_playlist_popover_set_current_audience_playback_manager_uri_changed, self, 0);
	_tmp65_ = audience_disk_manager_get_default ();
	_data15_->disk_manager = _tmp65_;
	_tmp66_ = _data15_->disk_manager;
	audience_widgets_playlist_popover_set_dvd_visibility (self, audience_disk_manager_has_media_volumes (_tmp66_));
	_tmp67_ = _data15_->disk_manager;
	g_signal_connect_data (_tmp67_, "volume-found", (GCallback) __audience_widgets_playlist_popover___lambda47__audience_disk_manager_volume_found, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp68_ = _data15_->disk_manager;
	g_signal_connect_data (_tmp68_, "volume-removed", (GCallback) __audience_widgets_playlist_popover___lambda48__audience_disk_manager_volume_removed, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	g_signal_connect_data ((GtkWidget*) self, "map", (GCallback) __audience_widgets_playlist_popover___lambda49__gtk_widget_map, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_g_object_unref0 (playback_manager);
	_g_object_unref0 (grid);
	_g_object_unref0 (clear_playlist_button);
	_g_object_unref0 (fil);
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return obj;
}

static void
audience_widgets_playlist_popover_class_init (AudienceWidgetsPlaylistPopoverClass * klass,
                                              gpointer klass_data)
{
	audience_widgets_playlist_popover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceWidgetsPlaylistPopover_private_offset);
	G_OBJECT_CLASS (klass)->constructor = audience_widgets_playlist_popover_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_widgets_playlist_popover_finalize;
}

static void
audience_widgets_playlist_popover_instance_init (AudienceWidgetsPlaylistPopover * self,
                                                 gpointer klass)
{
	self->priv = audience_widgets_playlist_popover_get_instance_private (self);
	self->priv->current = 0;
}

static void
audience_widgets_playlist_popover_finalize (GObject * obj)
{
	AudienceWidgetsPlaylistPopover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_WIDGETS_TYPE_PLAYLIST_POPOVER, AudienceWidgetsPlaylistPopover);
	audience_widgets_playlist_popover_save_playlist (self);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->playlist);
	_g_object_unref0 (self->priv->dvd);
	G_OBJECT_CLASS (audience_widgets_playlist_popover_parent_class)->finalize (obj);
}

static GType
audience_widgets_playlist_popover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceWidgetsPlaylistPopoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_widgets_playlist_popover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceWidgetsPlaylistPopover), 0, (GInstanceInitFunc) audience_widgets_playlist_popover_instance_init, NULL };
	GType audience_widgets_playlist_popover_type_id;
	audience_widgets_playlist_popover_type_id = g_type_register_static (gtk_popover_get_type (), "AudienceWidgetsPlaylistPopover", &g_define_type_info, 0);
	AudienceWidgetsPlaylistPopover_private_offset = g_type_add_instance_private (audience_widgets_playlist_popover_type_id, sizeof (AudienceWidgetsPlaylistPopoverPrivate));
	return audience_widgets_playlist_popover_type_id;
}

GType
audience_widgets_playlist_popover_get_type (void)
{
	static volatile gsize audience_widgets_playlist_popover_type_id__once = 0;
	if (g_once_init_enter (&audience_widgets_playlist_popover_type_id__once)) {
		GType audience_widgets_playlist_popover_type_id;
		audience_widgets_playlist_popover_type_id = audience_widgets_playlist_popover_get_type_once ();
		g_once_init_leave (&audience_widgets_playlist_popover_type_id__once, audience_widgets_playlist_popover_type_id);
	}
	return audience_widgets_playlist_popover_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

