/* LibraryPage.c generated by valac 0.56.17, the Vala compiler
 * generated from LibraryPage.vala, do not modify */

/*-
 * Copyright 2016-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <handy.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_LIBRARY_PAGE (audience_library_page_get_type ())
#define AUDIENCE_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage))
#define AUDIENCE_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))
#define AUDIENCE_IS_LIBRARY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_IS_LIBRARY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_PAGE))
#define AUDIENCE_LIBRARY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPageClass))

typedef struct _AudienceLibraryPage AudienceLibraryPage;
typedef struct _AudienceLibraryPageClass AudienceLibraryPageClass;
typedef struct _AudienceLibraryPagePrivate AudienceLibraryPagePrivate;

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;
enum  {
	AUDIENCE_LIBRARY_PAGE_0_PROPERTY,
	AUDIENCE_LIBRARY_PAGE_HAS_ITEMS_PROPERTY,
	AUDIENCE_LIBRARY_PAGE_NUM_PROPERTIES
};
static GParamSpec* audience_library_page_properties[AUDIENCE_LIBRARY_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define AUDIENCE_TYPE_LIBRARY_ITEM (audience_library_item_get_type ())
#define AUDIENCE_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem))
#define AUDIENCE_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))
#define AUDIENCE_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))

typedef struct _AudienceLibraryItem AudienceLibraryItem;
typedef struct _AudienceLibraryItemClass AudienceLibraryItemClass;

#define AUDIENCE_OBJECTS_TYPE_VIDEO (audience_objects_video_get_type ())
#define AUDIENCE_OBJECTS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo))
#define AUDIENCE_OBJECTS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))
#define AUDIENCE_OBJECTS_IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))

typedef struct _AudienceObjectsVideo AudienceObjectsVideo;
typedef struct _AudienceObjectsVideoClass AudienceObjectsVideoClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;
typedef enum  {
	AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES
} AudienceWindowNavigationPage;

#define AUDIENCE_WINDOW_TYPE_NAVIGATION_PAGE (audience_window_navigation_page_get_type ())
typedef enum  {
	AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL,
	AUDIENCE_LIBRARY_ITEM_STYLE_ROW
} AudienceLibraryItemStyle;

#define AUDIENCE_TYPE_LIBRARY_ITEM_STYLE (audience_library_item_style_get_type ())
typedef struct _AudienceLibraryPageRemoveItemData AudienceLibraryPageRemoveItemData;
typedef struct _AudienceLibraryPageRemoveItemFromPathData AudienceLibraryPageRemoveItemFromPathData;
typedef struct _AudienceLibraryPagePosterInitialisationData AudienceLibraryPagePosterInitialisationData;
enum  {
	AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL,
	AUDIENCE_LIBRARY_PAGE_NUM_SIGNALS
};
static guint audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_NUM_SIGNALS] = {0};

struct _AudienceLibraryPage {
	GtkBox parent_instance;
	AudienceLibraryPagePrivate * priv;
};

struct _AudienceLibraryPageClass {
	GtkBoxClass parent_class;
};

struct _AudienceLibraryPagePrivate {
	GListStore* items;
	AudienceServicesLibraryManager* manager;
	GtkSearchEntry* search_entry;
	GraniteWidgetsAlertView* alert_view;
	GtkScrolledWindow* scrolled_window;
	GtkFlowBox* view_movies;
	GtkStack* stack;
	gboolean posters_initialized;
};

struct _AudienceLibraryPageRemoveItemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceLibraryPage* self;
	AudienceLibraryItem* item;
	GeeArrayList* _video_list;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _video_size;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _video_index;
	gint _tmp5_;
	gint _tmp6_;
	AudienceObjectsVideo* video;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	AudienceServicesLibraryManager* _tmp9_;
	AudienceObjectsVideo* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	guint pos;
	GListStore* _tmp13_;
	guint _tmp14_;
	GListStore* _tmp15_;
};

struct _AudienceLibraryPageRemoveItemFromPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceLibraryPage* self;
	gchar* path;
	gint i;
	gboolean _tmp0_;
	gint _tmp1_;
	GListStore* _tmp2_;
	AudienceLibraryItem* item;
	GListStore* _tmp3_;
	GObject* _tmp4_;
	gboolean _tmp5_;
	AudienceLibraryItem* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	AudienceLibraryItem* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	gpointer _tmp14_;
	AudienceObjectsVideo* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	AudienceLibraryItem* _tmp20_;
	HdyDeck* deck;
	GtkWidget* _tmp21_;
	HdyDeck* _tmp22_;
	gboolean _tmp23_;
	HdyDeck* _tmp24_;
	GtkWidget* _tmp25_;
	GtkWidget* _tmp26_;
	GListStore* _tmp27_;
	HdyDeck* _tmp28_;
};

struct _AudienceLibraryPagePosterInitialisationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceLibraryPage* self;
	gint i;
	gboolean _tmp0_;
	gint _tmp1_;
	GListStore* _tmp2_;
	AudienceLibraryItem* item;
	GListStore* _tmp3_;
	GObject* _tmp4_;
	AudienceObjectsVideo* first_episode;
	AudienceLibraryItem* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	gpointer _tmp8_;
	AudienceObjectsVideo* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	AudienceObjectsVideo* _tmp12_;
};

static gint AudienceLibraryPage_private_offset;
static gpointer audience_library_page_parent_class = NULL;
VALA_EXTERN AudienceLibraryPage* audience_library_page_instance;
AudienceLibraryPage* audience_library_page_instance = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_library_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryPage, g_object_unref)
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceLibraryPage* audience_library_page_get_instance (void);
VALA_EXTERN AudienceLibraryPage* audience_library_page_new (void);
VALA_EXTERN AudienceLibraryPage* audience_library_page_construct (GType object_type);
VALA_EXTERN void audience_library_page_search (AudienceLibraryPage* self);
static void audience_library_page_play_video (AudienceLibraryPage* self,
                                       GtkFlowBoxChild* item);
VALA_EXTERN GType audience_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryItem, g_object_unref)
VALA_EXTERN GType audience_objects_video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsVideo, g_object_unref)
VALA_EXTERN GeeArrayList* audience_library_item_get_episodes (AudienceLibraryItem* self);
VALA_EXTERN GFile* audience_objects_video_get_video_file (AudienceObjectsVideo* self);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN void audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                                   GFile* file);
VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
VALA_EXTERN GType audience_window_navigation_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void audience_window_play_file (AudienceWindow* self,
                                const gchar* uri,
                                AudienceWindowNavigationPage origin,
                                gboolean from_beginning);
VALA_EXTERN void audience_library_page_add_item (AudienceLibraryPage* self,
                                     AudienceObjectsVideo* video);
VALA_EXTERN const gchar* audience_objects_video_get_container (AudienceObjectsVideo* self);
VALA_EXTERN void audience_library_item_add_episode (AudienceLibraryItem* self,
                                        AudienceObjectsVideo* episode);
VALA_EXTERN GType audience_library_item_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AudienceLibraryItem* audience_library_item_new (AudienceObjectsVideo* video,
                                                AudienceLibraryItemStyle item_style);
VALA_EXTERN AudienceLibraryItem* audience_library_item_construct (GType object_type,
                                                      AudienceObjectsVideo* video,
                                                      AudienceLibraryItemStyle item_style);
VALA_EXTERN void audience_objects_video_initialize_poster (AudienceObjectsVideo* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void audience_objects_video_initialize_poster_finish (AudienceObjectsVideo* self,
                                                      GAsyncResult* _res_);
static void audience_library_page_remove_item_data_free (gpointer _data);
static void audience_library_page_remove_item (AudienceLibraryPage* self,
                                        AudienceLibraryItem* item,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void audience_library_page_remove_item_finish (AudienceLibraryPage* self,
                                               GAsyncResult* _res_);
static gboolean audience_library_page_remove_item_co (AudienceLibraryPageRemoveItemData* _data_);
VALA_EXTERN void audience_services_library_manager_clear_cache (AudienceServicesLibraryManager* self,
                                                    const gchar* cache_file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void audience_services_library_manager_clear_cache_finish (AudienceServicesLibraryManager* self,
                                                           GAsyncResult* _res_);
VALA_EXTERN const gchar* audience_objects_video_get_poster_cache_file (AudienceObjectsVideo* self);
static void audience_library_page_remove_item_from_path_data_free (gpointer _data);
static void audience_library_page_remove_item_from_path (AudienceLibraryPage* self,
                                                  const gchar* path,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void audience_library_page_remove_item_from_path_finish (AudienceLibraryPage* self,
                                                         GAsyncResult* _res_);
static gboolean audience_library_page_remove_item_from_path_co (AudienceLibraryPageRemoveItemFromPathData* _data_);
static void audience_library_page_poster_initialisation_data_free (gpointer _data);
static void audience_library_page_poster_initialisation (AudienceLibraryPage* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void audience_library_page_poster_initialisation_finish (AudienceLibraryPage* self,
                                                         GAsyncResult* _res_);
static gboolean audience_library_page_poster_initialisation_co (AudienceLibraryPagePosterInitialisationData* _data_);
VALA_EXTERN gboolean audience_objects_video_get_poster_initialized (AudienceObjectsVideo* self);
static gboolean audience_library_page_video_filter_func (AudienceLibraryPage* self,
                                                  GtkFlowBoxChild* child);
VALA_EXTERN gchar* audience_library_item_get_title (AudienceLibraryItem* self);
static gint audience_library_page_video_sort_func (AudienceLibraryPage* self,
                                            GObject* item1,
                                            GObject* item2);
VALA_EXTERN void audience_library_page_filter (AudienceLibraryPage* self);
VALA_EXTERN gboolean audience_library_page_has_child (AudienceLibraryPage* self);
VALA_EXTERN AudienceWindowNavigationPage audience_library_page_prepare_to_play (AudienceLibraryPage* self,
                                                                    const gchar* file);
VALA_EXTERN gboolean audience_library_page_get_has_items (AudienceLibraryPage* self);
static void g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GObject * audience_library_page_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static gint _audience_library_page_video_sort_func_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                                    GtkFlowBoxChild* child2,
                                                                    gpointer self);
static gboolean _audience_library_page_video_filter_func_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                                            gpointer self);
static GtkWidget* _audience_library_page___lambda68_ (AudienceLibraryPage* self,
                                               GObject* item);
static GtkWidget* __audience_library_page___lambda68__gtk_flow_box_create_widget_func (gpointer item,
                                                                                gpointer self);
static void _audience_library_page_play_video_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                     GtkFlowBoxChild* child,
                                                                     gpointer self);
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
static void _audience_library_page_add_item_audience_services_library_manager_video_file_detected (AudienceServicesLibraryManager* _sender,
                                                                                            AudienceObjectsVideo* video,
                                                                                            gpointer self);
static void _audience_library_page_remove_item_from_path_audience_services_library_manager_video_file_deleted (AudienceServicesLibraryManager* _sender,
                                                                                                        const gchar* path,
                                                                                                        gpointer self);
VALA_EXTERN void audience_services_library_manager_begin_scan (AudienceServicesLibraryManager* self);
static void _audience_library_page___lambda69_ (AudienceLibraryPage* self);
static void __audience_library_page___lambda69__gtk_widget_map (GtkWidget* _sender,
                                                         gpointer self);
static void _audience_library_page___lambda70_ (AudienceLibraryPage* self);
static void __audience_library_page___lambda70__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _audience_library_page___lambda71_ (AudienceLibraryPage* self);
static void __audience_library_page___lambda71__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                          gpointer self);
static gboolean _audience_library_page___lambda72_ (AudienceLibraryPage* self,
                                             GdkEventKey* event);
static gboolean __audience_library_page___lambda72__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                         GdkEventKey* event,
                                                                         gpointer self);
static void audience_library_page_finalize (GObject * obj);
static GType audience_library_page_get_type_once (void);
static void _vala_audience_library_page_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
audience_library_page_get_instance_private (AudienceLibraryPage* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceLibraryPage_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AudienceLibraryPage*
audience_library_page_get_instance (void)
{
	AudienceLibraryPage* _tmp0_;
	AudienceLibraryPage* _tmp2_;
	AudienceLibraryPage* _tmp3_;
	AudienceLibraryPage* result;
	_tmp0_ = audience_library_page_instance;
	if (_tmp0_ == NULL) {
		AudienceLibraryPage* _tmp1_;
		_tmp1_ = audience_library_page_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (audience_library_page_instance);
		audience_library_page_instance = _tmp1_;
	}
	_tmp2_ = audience_library_page_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

void
audience_library_page_search (AudienceLibraryPage* self)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static void
audience_library_page_play_video (AudienceLibraryPage* self,
                                  GtkFlowBoxChild* item)
{
	AudienceLibraryItem* selected = NULL;
	AudienceLibraryItem* _tmp0_;
	AudienceLibraryItem* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (AUDIENCE_IS_LIBRARY_ITEM (item) ? ((AudienceLibraryItem*) item) : NULL);
	selected = _tmp0_;
	_tmp1_ = selected;
	_tmp2_ = audience_library_item_get_episodes (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 1) {
		gchar* uri = NULL;
		AudienceLibraryItem* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _tmp8_;
		gpointer _tmp9_;
		AudienceObjectsVideo* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean same_video = FALSE;
		const gchar* _tmp15_;
		GSettings* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gboolean _tmp19_;
		gboolean playback_complete = FALSE;
		GSettings* _tmp20_;
		gboolean _tmp21_ = FALSE;
		gboolean from_beginning = FALSE;
		AudiencePlaybackManager* _tmp23_;
		const gchar* _tmp24_;
		GFile* _tmp25_;
		GFile* _tmp26_;
		AudienceWindow* window = NULL;
		GApplication* _tmp27_;
		GtkWindow* _tmp28_;
		GtkWindow* _tmp29_;
		AudienceWindow* _tmp30_;
		AudienceWindow* _tmp31_;
		const gchar* _tmp32_;
		_tmp6_ = selected;
		_tmp7_ = audience_library_item_get_episodes (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_list_first ((GeeList*) _tmp8_);
		_tmp10_ = (AudienceObjectsVideo*) _tmp9_;
		_tmp11_ = audience_objects_video_get_video_file (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_uri (_tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp10_);
		uri = _tmp14_;
		_tmp15_ = uri;
		_tmp16_ = audience_settings;
		_tmp17_ = g_settings_get_string (_tmp16_, "current-video");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strcmp0 (_tmp15_, _tmp18_) == 0;
		_g_free0 (_tmp18_);
		same_video = _tmp19_;
		_tmp20_ = audience_settings;
		playback_complete = ((gdouble) g_settings_get_int64 (_tmp20_, "last-stopped")) == 0.0;
		if (!same_video) {
			_tmp21_ = TRUE;
		} else {
			_tmp21_ = playback_complete;
		}
		from_beginning = _tmp21_;
		if (from_beginning) {
			AudiencePlaybackManager* _tmp22_;
			_tmp22_ = audience_playback_manager_get_default ();
			g_signal_emit_by_name (_tmp22_, "clear-playlist", TRUE);
		}
		_tmp23_ = audience_playback_manager_get_default ();
		_tmp24_ = uri;
		_tmp25_ = g_file_new_for_uri (_tmp24_);
		_tmp26_ = _tmp25_;
		audience_playback_manager_append_to_playlist (_tmp23_, _tmp26_);
		_g_object_unref0 (_tmp26_);
		_tmp27_ = g_application_get_default ();
		_tmp28_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_application_get_type (), GtkApplication));
		_tmp29_ = _tmp28_;
		_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, AUDIENCE_TYPE_WINDOW, AudienceWindow));
		window = _tmp30_;
		_tmp31_ = window;
		_tmp32_ = uri;
		audience_window_play_file (_tmp31_, _tmp32_, AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY, from_beginning);
		_g_object_unref0 (window);
		_g_free0 (uri);
	} else {
		AudienceLibraryItem* _tmp33_;
		_tmp33_ = selected;
		g_signal_emit (self, audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL], 0, _tmp33_, FALSE);
	}
	_g_object_unref0 (selected);
}

void
audience_library_page_add_item (AudienceLibraryPage* self,
                                AudienceObjectsVideo* video)
{
	AudienceLibraryItem* new_container = NULL;
	AudienceLibraryItem* _tmp19_;
	GListStore* _tmp20_;
	AudienceLibraryItem* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (video != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				AudienceLibraryItem* item = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->items;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->items;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
				_tmp6_ = audience_objects_video_get_container (video);
				_tmp7_ = _tmp6_;
				if (g_strcmp0 (_tmp7_, "") != 0) {
					AudienceLibraryItem* _tmp8_;
					GeeArrayList* _tmp9_;
					GeeArrayList* _tmp10_;
					gpointer _tmp11_;
					AudienceObjectsVideo* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					_tmp8_ = item;
					_tmp9_ = audience_library_item_get_episodes (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = gee_list_first ((GeeList*) _tmp10_);
					_tmp12_ = (AudienceObjectsVideo*) _tmp11_;
					_tmp13_ = audience_objects_video_get_container (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = audience_objects_video_get_container (video);
					_tmp16_ = _tmp15_;
					_tmp5_ = g_strcmp0 (_tmp14_, _tmp16_) == 0;
					_g_object_unref0 (_tmp12_);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					AudienceLibraryItem* _tmp17_;
					GtkFlowBox* _tmp18_;
					_tmp17_ = item;
					audience_library_item_add_episode (_tmp17_, video);
					_tmp18_ = self->priv->view_movies;
					gtk_flow_box_invalidate_sort (_tmp18_);
					_g_object_unref0 (item);
					return;
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp19_ = audience_library_item_new (video, AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL);
	g_object_ref_sink (_tmp19_);
	new_container = _tmp19_;
	_tmp20_ = self->priv->items;
	_tmp21_ = new_container;
	g_list_store_append (_tmp20_, (GObject*) _tmp21_);
	if (self->priv->posters_initialized) {
		AudienceLibraryItem* _tmp22_;
		audience_objects_video_initialize_poster (video, NULL, NULL);
		_tmp22_ = new_container;
		gtk_widget_show_all ((GtkWidget*) _tmp22_);
	}
	_g_object_unref0 (new_container);
}

static void
audience_library_page_remove_item_data_free (gpointer _data)
{
	AudienceLibraryPageRemoveItemData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->item);
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceLibraryPageRemoveItemData, _data_);
}

static void
audience_library_page_remove_item (AudienceLibraryPage* self,
                                   AudienceLibraryItem* item,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	AudienceLibraryPageRemoveItemData* _data_;
	AudienceLibraryPage* _tmp0_;
	AudienceLibraryItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_data_ = g_slice_new0 (AudienceLibraryPageRemoveItemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_library_page_remove_item_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (item);
	_g_object_unref0 (_data_->item);
	_data_->item = _tmp1_;
	audience_library_page_remove_item_co (_data_);
}

static void
audience_library_page_remove_item_finish (AudienceLibraryPage* self,
                                          GAsyncResult* _res_)
{
	AudienceLibraryPageRemoveItemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
audience_library_page_remove_item_co (AudienceLibraryPageRemoveItemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = audience_library_item_get_episodes (_data_->item);
		_data_->_tmp1_ = _data_->_tmp0_;
		_data_->_video_list = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->_video_list;
		_data_->_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_video_size = _data_->_tmp4_;
		_data_->_video_index = -1;
		while (TRUE) {
			_data_->_video_index = _data_->_video_index + 1;
			_data_->_tmp5_ = _data_->_video_index;
			_data_->_tmp6_ = _data_->_video_size;
			if (!(_data_->_tmp5_ < _data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_video_list;
			_data_->_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp7_, _data_->_video_index);
			_data_->video = (AudienceObjectsVideo*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->self->priv->manager;
			_data_->_tmp10_ = _data_->video;
			_data_->_tmp11_ = audience_objects_video_get_poster_cache_file (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			audience_services_library_manager_clear_cache (_data_->_tmp9_, _data_->_tmp12_, NULL, NULL);
			_g_object_unref0 (_data_->video);
		}
	}
	_data_->_tmp13_ = _data_->self->priv->items;
	_data_->_tmp14_ = 0U;
	g_list_store_find (_data_->_tmp13_, (GObject*) _data_->item, &_data_->_tmp14_);
	_data_->pos = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->items;
	g_list_store_remove (_data_->_tmp15_, _data_->pos);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
audience_library_page_remove_item_from_path_data_free (gpointer _data)
{
	AudienceLibraryPageRemoveItemFromPathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceLibraryPageRemoveItemFromPathData, _data_);
}

static void
audience_library_page_remove_item_from_path (AudienceLibraryPage* self,
                                             const gchar* path,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	AudienceLibraryPageRemoveItemFromPathData* _data_;
	AudienceLibraryPage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (AudienceLibraryPageRemoveItemFromPathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_library_page_remove_item_from_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	audience_library_page_remove_item_from_path_co (_data_);
}

static void
audience_library_page_remove_item_from_path_finish (AudienceLibraryPage* self,
                                                    GAsyncResult* _res_)
{
	AudienceLibraryPageRemoveItemFromPathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
audience_library_page_remove_item_from_path_co (AudienceLibraryPageRemoveItemFromPathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->i = 0;
		{
			_data_->_tmp0_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp0_) {
					_data_->_tmp1_ = _data_->i;
					_data_->i = _data_->_tmp1_ + 1;
				}
				_data_->_tmp0_ = FALSE;
				_data_->_tmp2_ = _data_->self->priv->items;
				if (!(((guint) _data_->i) < g_list_model_get_n_items ((GListModel*) _data_->_tmp2_))) {
					break;
				}
				_data_->_tmp3_ = _data_->self->priv->items;
				_data_->_tmp4_ = g_list_model_get_item ((GListModel*) _data_->_tmp3_, (guint) _data_->i);
				_data_->item = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
				_data_->_tmp6_ = _data_->item;
				_data_->_tmp7_ = audience_library_item_get_episodes (_data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				if (_data_->_tmp10_ == 0) {
					_data_->_tmp5_ = TRUE;
				} else {
					_data_->_tmp11_ = _data_->item;
					_data_->_tmp12_ = audience_library_item_get_episodes (_data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					_data_->_tmp14_ = gee_list_first ((GeeList*) _data_->_tmp13_);
					_data_->_tmp15_ = (AudienceObjectsVideo*) _data_->_tmp14_;
					_data_->_tmp16_ = audience_objects_video_get_video_file (_data_->_tmp15_);
					_data_->_tmp17_ = _data_->_tmp16_;
					_data_->_tmp18_ = g_file_get_path (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp5_ = g_str_has_prefix (_data_->_tmp19_, _data_->path);
					_g_free0 (_data_->_tmp19_);
					_g_object_unref0 (_data_->_tmp15_);
				}
				if (_data_->_tmp5_) {
					_data_->_tmp20_ = _data_->item;
					audience_library_page_remove_item (_data_->self, _data_->_tmp20_, NULL, NULL);
				}
				_g_object_unref0 (_data_->item);
			}
		}
	}
	_data_->_tmp21_ = gtk_widget_get_ancestor ((GtkWidget*) _data_->self, hdy_deck_get_type ());
	_data_->_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, hdy_deck_get_type (), HdyDeck));
	_data_->deck = _data_->_tmp22_;
	_data_->_tmp24_ = _data_->deck;
	_data_->_tmp25_ = hdy_deck_get_visible_child (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	if (_data_->_tmp26_ == G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget)) {
		_data_->_tmp27_ = _data_->self->priv->items;
		_data_->_tmp23_ = g_list_model_get_n_items ((GListModel*) _data_->_tmp27_) == ((guint) 0);
	} else {
		_data_->_tmp23_ = FALSE;
	}
	if (_data_->_tmp23_) {
		_data_->_tmp28_ = _data_->deck;
		hdy_deck_navigate (_data_->_tmp28_, HDY_NAVIGATION_DIRECTION_BACK);
	}
	_g_object_unref0 (_data_->deck);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
audience_library_page_poster_initialisation_data_free (gpointer _data)
{
	AudienceLibraryPagePosterInitialisationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceLibraryPagePosterInitialisationData, _data_);
}

static void
audience_library_page_poster_initialisation (AudienceLibraryPage* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	AudienceLibraryPagePosterInitialisationData* _data_;
	AudienceLibraryPage* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AudienceLibraryPagePosterInitialisationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_library_page_poster_initialisation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	audience_library_page_poster_initialisation_co (_data_);
}

static void
audience_library_page_poster_initialisation_finish (AudienceLibraryPage* self,
                                                    GAsyncResult* _res_)
{
	AudienceLibraryPagePosterInitialisationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
audience_library_page_poster_initialisation_co (AudienceLibraryPagePosterInitialisationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->i = 0;
		{
			_data_->_tmp0_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp0_) {
					_data_->_tmp1_ = _data_->i;
					_data_->i = _data_->_tmp1_ + 1;
				}
				_data_->_tmp0_ = FALSE;
				_data_->_tmp2_ = _data_->self->priv->items;
				if (!(((guint) _data_->i) < g_list_model_get_n_items ((GListModel*) _data_->_tmp2_))) {
					break;
				}
				_data_->_tmp3_ = _data_->self->priv->items;
				_data_->_tmp4_ = g_list_model_get_item ((GListModel*) _data_->_tmp3_, (guint) _data_->i);
				_data_->item = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
				_data_->_tmp5_ = _data_->item;
				_data_->_tmp6_ = audience_library_item_get_episodes (_data_->_tmp5_);
				_data_->_tmp7_ = _data_->_tmp6_;
				_data_->_tmp8_ = gee_list_first ((GeeList*) _data_->_tmp7_);
				_data_->first_episode = (AudienceObjectsVideo*) _data_->_tmp8_;
				_data_->_tmp9_ = _data_->first_episode;
				_data_->_tmp10_ = audience_objects_video_get_poster_initialized (_data_->_tmp9_);
				_data_->_tmp11_ = _data_->_tmp10_;
				if (!_data_->_tmp11_) {
					_data_->_tmp12_ = _data_->first_episode;
					audience_objects_video_initialize_poster (_data_->_tmp12_, NULL, NULL);
				}
				_g_object_unref0 (_data_->first_episode);
				_g_object_unref0 (_data_->item);
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
audience_library_page_video_filter_func (AudienceLibraryPage* self,
                                         GtkFlowBoxChild* child)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar** filter_elements = NULL;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint filter_elements_length1;
	gint _filter_elements_size_;
	gchar* video_title = NULL;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->search_entry;
	_tmp6_ = gtk_entry_get_text ((GtkEntry*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
	filter_elements = _tmp9_;
	filter_elements_length1 = _vala_array_length (_tmp8_);
	_filter_elements_size_ = filter_elements_length1;
	_tmp10_ = audience_library_item_get_title (G_TYPE_CHECK_INSTANCE_CAST (child, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	video_title = _tmp10_;
	_tmp11_ = filter_elements;
	_tmp11__length1 = filter_elements_length1;
	{
		gchar** filter_element_collection = NULL;
		gint filter_element_collection_length1 = 0;
		gint _filter_element_collection_size_ = 0;
		gint filter_element_it = 0;
		filter_element_collection = _tmp11_;
		filter_element_collection_length1 = _tmp11__length1;
		for (filter_element_it = 0; filter_element_it < filter_element_collection_length1; filter_element_it = filter_element_it + 1) {
			gchar* _tmp12_;
			gchar* filter_element = NULL;
			_tmp12_ = g_strdup (filter_element_collection[filter_element_it]);
			filter_element = _tmp12_;
			{
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp13_ = video_title;
				_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
				_tmp15_ = _tmp14_;
				_tmp16_ = filter_element;
				_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
				_tmp18_ = _tmp17_;
				_tmp19_ = !string_contains (_tmp15_, _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				if (_tmp19_) {
					result = FALSE;
					_g_free0 (filter_element);
					_g_free0 (video_title);
					filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (filter_element);
			}
		}
	}
	result = TRUE;
	_g_free0 (video_title);
	filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
audience_library_page_video_sort_func (AudienceLibraryPage* self,
                                       GObject* item1,
                                       GObject* item2)
{
	AudienceLibraryItem* library_item1 = NULL;
	AudienceLibraryItem* _tmp0_;
	AudienceLibraryItem* library_item2 = NULL;
	AudienceLibraryItem* _tmp1_;
	gboolean _tmp2_ = FALSE;
	AudienceLibraryItem* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (item1 != NULL, 0);
	g_return_val_if_fail (item2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item1, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	library_item1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item2, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	library_item2 = _tmp1_;
	_tmp3_ = library_item1;
	if (_tmp3_ != NULL) {
		AudienceLibraryItem* _tmp4_;
		_tmp4_ = library_item2;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		AudienceLibraryItem* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		AudienceLibraryItem* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gint _tmp11_;
		_tmp5_ = library_item1;
		_tmp6_ = audience_library_item_get_title (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = library_item2;
		_tmp9_ = audience_library_item_get_title (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_utf8_collate (_tmp7_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp7_);
		result = _tmp11_;
		_g_object_unref0 (library_item2);
		_g_object_unref0 (library_item1);
		return result;
	}
	result = 0;
	_g_object_unref0 (library_item2);
	_g_object_unref0 (library_item1);
	return result;
}

void
audience_library_page_filter (AudienceLibraryPage* self)
{
	GtkFlowBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view_movies;
	gtk_flow_box_invalidate_filter (_tmp0_);
	if (!audience_library_page_has_child (self)) {
		GtkStack* _tmp1_;
		GraniteWidgetsAlertView* _tmp2_;
		GraniteWidgetsAlertView* _tmp3_;
		GtkSearchEntry* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->stack;
		_tmp2_ = self->priv->alert_view;
		gtk_stack_set_visible_child (_tmp1_, (GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->alert_view;
		_tmp4_ = self->priv->search_entry;
		_tmp5_ = gtk_entry_get_text ((GtkEntry*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf (_ ("No Results for “%s”"), _tmp6_);
		_tmp8_ = _tmp7_;
		granite_widgets_alert_view_set_title (_tmp3_, _tmp8_);
		_g_free0 (_tmp8_);
	} else {
		GtkStack* _tmp9_;
		GtkScrolledWindow* _tmp10_;
		_tmp9_ = self->priv->stack;
		_tmp10_ = self->priv->scrolled_window;
		gtk_stack_set_visible_child (_tmp9_, (GtkWidget*) _tmp10_);
	}
}

gboolean
audience_library_page_has_child (AudienceLibraryPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				AudienceLibraryItem* item = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				AudienceLibraryItem* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->items;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->items;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
				_tmp5_ = item;
				if (gtk_widget_get_child_visible ((GtkWidget*) _tmp5_)) {
					result = TRUE;
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	return result;
}

AudienceWindowNavigationPage
audience_library_page_prepare_to_play (AudienceLibraryPage* self,
                                       const gchar* file)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_;
	AudienceWindowNavigationPage result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (file != NULL, 0);
	_tmp0_ = g_file_new_for_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	_tmp3_ = g_file_new_for_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = !g_file_has_prefix (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp1_);
	if (_tmp5_) {
		result = AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GListStore* _tmp8_;
				AudienceLibraryItem* item = NULL;
				GListStore* _tmp9_;
				GObject* _tmp10_;
				GeeArrayList* episodes = NULL;
				AudienceLibraryItem* _tmp11_;
				GeeArrayList* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp14_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = self->priv->items;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp8_))) {
					break;
				}
				_tmp9_ = self->priv->items;
				_tmp10_ = g_list_model_get_item ((GListModel*) _tmp9_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
				_tmp11_ = item;
				_tmp12_ = audience_library_item_get_episodes (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _g_object_ref0 (_tmp13_);
				episodes = _tmp14_;
				{
					GeeArrayList* _episode_list = NULL;
					GeeArrayList* _tmp15_;
					gint _episode_size = 0;
					GeeArrayList* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gint _episode_index = 0;
					_tmp15_ = episodes;
					_episode_list = _tmp15_;
					_tmp16_ = _episode_list;
					_tmp17_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp16_);
					_tmp18_ = _tmp17_;
					_episode_size = _tmp18_;
					_episode_index = -1;
					while (TRUE) {
						gint _tmp19_;
						gint _tmp20_;
						AudienceObjectsVideo* episode = NULL;
						GeeArrayList* _tmp21_;
						gpointer _tmp22_;
						gchar* ep_file = NULL;
						AudienceObjectsVideo* _tmp23_;
						GFile* _tmp24_;
						GFile* _tmp25_;
						gchar* _tmp26_;
						const gchar* _tmp27_;
						_episode_index = _episode_index + 1;
						_tmp19_ = _episode_index;
						_tmp20_ = _episode_size;
						if (!(_tmp19_ < _tmp20_)) {
							break;
						}
						_tmp21_ = _episode_list;
						_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _episode_index);
						episode = (AudienceObjectsVideo*) _tmp22_;
						_tmp23_ = episode;
						_tmp24_ = audience_objects_video_get_video_file (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = g_file_get_uri (_tmp25_);
						ep_file = _tmp26_;
						_tmp27_ = ep_file;
						if (g_strcmp0 (_tmp27_, file) == 0) {
							GeeArrayList* _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
							_tmp28_ = episodes;
							_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
							_tmp30_ = _tmp29_;
							if (_tmp30_ > 1) {
								AudienceObjectsVideo* first_episode = NULL;
								GeeArrayList* _tmp31_;
								gpointer _tmp32_;
								AudienceObjectsVideo* _tmp33_;
								gboolean _tmp34_;
								gboolean _tmp35_;
								AudienceLibraryItem* _tmp37_;
								_tmp31_ = episodes;
								_tmp32_ = gee_list_first ((GeeList*) _tmp31_);
								first_episode = (AudienceObjectsVideo*) _tmp32_;
								_tmp33_ = first_episode;
								_tmp34_ = audience_objects_video_get_poster_initialized (_tmp33_);
								_tmp35_ = _tmp34_;
								if (!_tmp35_) {
									AudienceObjectsVideo* _tmp36_;
									_tmp36_ = first_episode;
									audience_objects_video_initialize_poster (_tmp36_, NULL, NULL);
								}
								_tmp37_ = item;
								g_signal_emit (self, audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL], 0, _tmp37_, TRUE);
								result = AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES;
								_g_object_unref0 (first_episode);
								_g_free0 (ep_file);
								_g_object_unref0 (episode);
								_g_object_unref0 (episodes);
								_g_object_unref0 (item);
								return result;
							} else {
								result = AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY;
								_g_free0 (ep_file);
								_g_object_unref0 (episode);
								_g_object_unref0 (episodes);
								_g_object_unref0 (item);
								return result;
							}
						}
						_g_free0 (ep_file);
						_g_object_unref0 (episode);
					}
				}
				_g_object_unref0 (episodes);
				_g_object_unref0 (item);
			}
		}
	}
	result = AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME;
	return result;
}

AudienceLibraryPage*
audience_library_page_construct (GType object_type)
{
	AudienceLibraryPage * self = NULL;
	self = (AudienceLibraryPage*) g_object_new (object_type, NULL);
	return self;
}

AudienceLibraryPage*
audience_library_page_new (void)
{
	return audience_library_page_construct (AUDIENCE_TYPE_LIBRARY_PAGE);
}

gboolean
audience_library_page_get_has_items (AudienceLibraryPage* self)
{
	gboolean result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->items;
	result = g_list_model_get_n_items ((GListModel*) _tmp0_) > ((guint) 0);
	return result;
}

static void
g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static gint
_audience_library_page_video_sort_func_gtk_flow_box_sort_func (GtkFlowBoxChild* child1,
                                                               GtkFlowBoxChild* child2,
                                                               gpointer self)
{
	gint result;
	result = audience_library_page_video_sort_func ((AudienceLibraryPage*) self, child1, child2);
	return result;
}

static gboolean
_audience_library_page_video_filter_func_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                                   gpointer self)
{
	gboolean result;
	result = audience_library_page_video_filter_func ((AudienceLibraryPage*) self, child);
	return result;
}

static GtkWidget*
_audience_library_page___lambda68_ (AudienceLibraryPage* self,
                                    GObject* item)
{
	GtkWidget* _tmp0_;
	GtkWidget* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = _g_object_ref0 ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (item, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	result = _tmp0_;
	return result;
}

static GtkWidget*
__audience_library_page___lambda68__gtk_flow_box_create_widget_func (gpointer item,
                                                                     gpointer self)
{
	GtkWidget* result;
	result = _audience_library_page___lambda68_ ((AudienceLibraryPage*) self, item);
	return result;
}

static void
_audience_library_page_play_video_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                GtkFlowBoxChild* child,
                                                                gpointer self)
{
	audience_library_page_play_video ((AudienceLibraryPage*) self, child);
}

static void
_audience_library_page_add_item_audience_services_library_manager_video_file_detected (AudienceServicesLibraryManager* _sender,
                                                                                       AudienceObjectsVideo* video,
                                                                                       gpointer self)
{
	audience_library_page_add_item ((AudienceLibraryPage*) self, video);
}

static void
_audience_library_page_remove_item_from_path_audience_services_library_manager_video_file_deleted (AudienceServicesLibraryManager* _sender,
                                                                                                   const gchar* path,
                                                                                                   gpointer self)
{
	audience_library_page_remove_item_from_path ((AudienceLibraryPage*) self, path, NULL, NULL);
}

static void
_audience_library_page___lambda69_ (AudienceLibraryPage* self)
{
	gboolean _tmp0_ = FALSE;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	if (!self->priv->posters_initialized) {
		self->priv->posters_initialized = TRUE;
		audience_library_page_poster_initialisation (self, NULL, NULL);
	}
	_tmp1_ = self->priv->search_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		_tmp0_ = !audience_library_page_has_child (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkSearchEntry* _tmp4_;
		_tmp4_ = self->priv->search_entry;
		gtk_entry_set_text ((GtkEntry*) _tmp4_, "");
	}
}

static void
__audience_library_page___lambda69__gtk_widget_map (GtkWidget* _sender,
                                                    gpointer self)
{
	_audience_library_page___lambda69_ ((AudienceLibraryPage*) self);
}

static void
_audience_library_page___lambda70_ (AudienceLibraryPage* self)
{
	GtkWidget* _tmp0_;
	_tmp0_ = gtk_widget_get_ancestor ((GtkWidget*) self, hdy_deck_get_type ());
	hdy_deck_navigate (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, hdy_deck_get_type (), HdyDeck), HDY_NAVIGATION_DIRECTION_BACK);
}

static void
__audience_library_page___lambda70__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_audience_library_page___lambda70_ ((AudienceLibraryPage*) self);
}

static void
_audience_library_page___lambda71_ (AudienceLibraryPage* self)
{
	audience_library_page_filter (self);
}

static void
__audience_library_page___lambda71__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                     gpointer self)
{
	_audience_library_page___lambda71_ ((AudienceLibraryPage*) self);
}

static gboolean
_audience_library_page___lambda72_ (AudienceLibraryPage* self,
                                    GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == GDK_KEY_Escape) {
		GtkSearchEntry* _tmp0_;
		_tmp0_ = self->priv->search_entry;
		gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__audience_library_page___lambda72__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                GdkEventKey* event,
                                                                gpointer self)
{
	gboolean result;
	result = _audience_library_page___lambda72_ ((AudienceLibraryPage*) self, event);
	return result;
}

static GObject *
audience_library_page_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceLibraryPage * self;
	GListStore* _tmp0_;
	GtkButton* navigation_button = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	gchar* _tmp4_;
	GtkSearchEntry* _tmp5_ = NULL;
	HdyHeaderBar* header_bar = NULL;
	gchar* _tmp6_;
	HdyHeaderBar* _tmp7_ = NULL;
	HdyHeaderBar* _tmp8_;
	GtkButton* _tmp9_;
	HdyHeaderBar* _tmp10_;
	GtkSearchEntry* _tmp11_;
	HdyHeaderBar* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkFlowBox* _tmp14_ = NULL;
	GtkFlowBox* _tmp15_;
	GtkFlowBox* _tmp16_;
	GtkFlowBox* _tmp17_;
	GListStore* _tmp18_;
	GtkFlowBox* _tmp19_;
	GtkWidget* _tmp20_;
	GtkScrolledWindow* _tmp21_ = NULL;
	GraniteWidgetsAlertView* _tmp22_;
	GtkStack* _tmp23_;
	GtkStack* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkStack* _tmp26_;
	GraniteWidgetsAlertView* _tmp27_;
	HdyHeaderBar* _tmp28_;
	GtkStack* _tmp29_;
	GtkFlowBox* _tmp30_;
	AudienceServicesLibraryManager* _tmp31_;
	AudienceServicesLibraryManager* _tmp32_;
	AudienceServicesLibraryManager* _tmp33_;
	AudienceServicesLibraryManager* _tmp34_;
	GtkButton* _tmp35_;
	GtkSearchEntry* _tmp36_;
	GtkSearchEntry* _tmp37_;
	parent_class = G_OBJECT_CLASS (audience_library_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage);
	_tmp0_ = g_list_store_new (AUDIENCE_TYPE_LIBRARY_ITEM);
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("Back"));
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	navigation_button = _tmp1_;
	_tmp2_ = navigation_button;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_BACK_BUTTON);
	_tmp4_ = g_strdup (_ ("Search Videos"));
	_tmp5_ = (GtkSearchEntry*) gtk_search_entry_new ();
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp5_;
	_tmp6_ = g_strdup (_ ("Library"));
	_tmp7_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp7_, TRUE);
	hdy_header_bar_set_title (_tmp7_, _tmp6_);
	_g_free0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	header_bar = _tmp7_;
	_tmp8_ = header_bar;
	_tmp9_ = navigation_button;
	hdy_header_bar_pack_start (_tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = header_bar;
	_tmp11_ = self->priv->search_entry;
	hdy_header_bar_pack_end (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = header_bar;
	_tmp13_ = gtk_widget_get_style_context ((GtkWidget*) _tmp12_);
	gtk_style_context_add_class (_tmp13_, GTK_STYLE_CLASS_FLAT);
	_tmp14_ = (GtkFlowBox*) gtk_flow_box_new ();
	gtk_flow_box_set_column_spacing (_tmp14_, (guint) 12);
	gtk_flow_box_set_row_spacing (_tmp14_, (guint) 12);
	gtk_flow_box_set_homogeneous (_tmp14_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp14_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp14_, 24);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp14_, 24);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp14_, 24);
	gtk_flow_box_set_selection_mode (_tmp14_, GTK_SELECTION_NONE);
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->view_movies);
	self->priv->view_movies = _tmp14_;
	_tmp15_ = self->priv->view_movies;
	gtk_flow_box_set_sort_func (_tmp15_, _audience_library_page_video_sort_func_gtk_flow_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp16_ = self->priv->view_movies;
	gtk_flow_box_set_filter_func (_tmp16_, _audience_library_page_video_filter_func_gtk_flow_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp17_ = self->priv->view_movies;
	_tmp18_ = self->priv->items;
	gtk_flow_box_bind_model (_tmp17_, (GListModel*) _tmp18_, __audience_library_page___lambda68__gtk_flow_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp19_ = self->priv->view_movies;
	_tmp20_ = _g_object_ref0 ((GtkWidget*) _tmp19_);
	_tmp21_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp21_, TRUE);
	g_object_set ((GtkContainer*) _tmp21_, "child", _tmp20_, NULL);
	_g_object_unref0 (_tmp20_);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp21_;
	_tmp22_ = granite_widgets_alert_view_new ("", _ ("Try changing search terms."), "edit-find-symbolic");
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->alert_view);
	self->priv->alert_view = _tmp22_;
	_tmp23_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp23_;
	_tmp24_ = self->priv->stack;
	_tmp25_ = self->priv->scrolled_window;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->stack;
	_tmp27_ = self->priv->alert_view;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp28_ = header_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp29_);
	_tmp30_ = self->priv->view_movies;
	g_signal_connect_object (_tmp30_, "child-activated", (GCallback) _audience_library_page_play_video_gtk_flow_box_child_activated, self, 0);
	_tmp31_ = audience_services_library_manager_get_instance ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp31_;
	_tmp32_ = self->priv->manager;
	g_signal_connect_object (_tmp32_, "video-file-detected", (GCallback) _audience_library_page_add_item_audience_services_library_manager_video_file_detected, self, 0);
	_tmp33_ = self->priv->manager;
	g_signal_connect_object (_tmp33_, "video-file-deleted", (GCallback) _audience_library_page_remove_item_from_path_audience_services_library_manager_video_file_deleted, self, 0);
	_tmp34_ = self->priv->manager;
	audience_services_library_manager_begin_scan (_tmp34_);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __audience_library_page___lambda69__gtk_widget_map, self, 0);
	_tmp35_ = navigation_button;
	g_signal_connect_object (_tmp35_, "clicked", (GCallback) __audience_library_page___lambda70__gtk_button_clicked, self, 0);
	_tmp36_ = self->priv->search_entry;
	g_signal_connect_object (_tmp36_, "search-changed", (GCallback) __audience_library_page___lambda71__gtk_search_entry_search_changed, self, 0);
	_tmp37_ = self->priv->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp37_, "key-press-event", (GCallback) __audience_library_page___lambda72__gtk_widget_key_press_event, self, 0);
	_g_object_unref0 (header_bar);
	_g_object_unref0 (navigation_button);
	return obj;
}

static void
audience_library_page_class_init (AudienceLibraryPageClass * klass,
                                  gpointer klass_data)
{
	audience_library_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceLibraryPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_library_page_get_property;
	G_OBJECT_CLASS (klass)->constructor = audience_library_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_library_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_LIBRARY_PAGE_HAS_ITEMS_PROPERTY, audience_library_page_properties[AUDIENCE_LIBRARY_PAGE_HAS_ITEMS_PROPERTY] = g_param_spec_boolean ("has-items", "has-items", "has-items", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	audience_library_page_signals[AUDIENCE_LIBRARY_PAGE_SHOW_EPISODES_SIGNAL] = g_signal_new ("show-episodes", AUDIENCE_TYPE_LIBRARY_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_BOOLEAN, G_TYPE_NONE, 2, AUDIENCE_TYPE_LIBRARY_ITEM, G_TYPE_BOOLEAN);
}

static void
audience_library_page_instance_init (AudienceLibraryPage * self,
                                     gpointer klass)
{
	self->priv = audience_library_page_get_instance_private (self);
	self->priv->posters_initialized = FALSE;
}

static void
audience_library_page_finalize (GObject * obj)
{
	AudienceLibraryPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->alert_view);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->view_movies);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (audience_library_page_parent_class)->finalize (obj);
}

static GType
audience_library_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceLibraryPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_library_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceLibraryPage), 0, (GInstanceInitFunc) audience_library_page_instance_init, NULL };
	GType audience_library_page_type_id;
	audience_library_page_type_id = g_type_register_static (gtk_box_get_type (), "AudienceLibraryPage", &g_define_type_info, 0);
	AudienceLibraryPage_private_offset = g_type_add_instance_private (audience_library_page_type_id, sizeof (AudienceLibraryPagePrivate));
	return audience_library_page_type_id;
}

GType
audience_library_page_get_type (void)
{
	static volatile gsize audience_library_page_type_id__once = 0;
	if (g_once_init_enter (&audience_library_page_type_id__once)) {
		GType audience_library_page_type_id;
		audience_library_page_type_id = audience_library_page_get_type_once ();
		g_once_init_leave (&audience_library_page_type_id__once, audience_library_page_type_id);
	}
	return audience_library_page_type_id__once;
}

static void
_vala_audience_library_page_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	AudienceLibraryPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_LIBRARY_PAGE, AudienceLibraryPage);
	switch (property_id) {
		case AUDIENCE_LIBRARY_PAGE_HAS_ITEMS_PROPERTY:
		g_value_set_boolean (value, audience_library_page_get_has_items (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

