/* LibraryItem.c generated by valac 0.56.17, the Vala compiler
 * generated from LibraryItem.vala, do not modify */

/*-
 * Copyright 2016-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <handy.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <granite.h>

#define AUDIENCE_SERVICES_POSTER_HEIGHT 240
#define AUDIENCE_SERVICES_POSTER_WIDTH 170
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL,
	AUDIENCE_LIBRARY_ITEM_STYLE_ROW
} AudienceLibraryItemStyle;

#define AUDIENCE_TYPE_LIBRARY_ITEM_STYLE (audience_library_item_style_get_type ())

#define AUDIENCE_TYPE_LIBRARY_ITEM (audience_library_item_get_type ())
#define AUDIENCE_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem))
#define AUDIENCE_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))
#define AUDIENCE_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))

typedef struct _AudienceLibraryItem AudienceLibraryItem;
typedef struct _AudienceLibraryItemClass AudienceLibraryItemClass;
typedef struct _AudienceLibraryItemPrivate AudienceLibraryItemPrivate;

#define AUDIENCE_OBJECTS_TYPE_VIDEO (audience_objects_video_get_type ())
#define AUDIENCE_OBJECTS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo))
#define AUDIENCE_OBJECTS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))
#define AUDIENCE_OBJECTS_IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))

typedef struct _AudienceObjectsVideo AudienceObjectsVideo;
typedef struct _AudienceObjectsVideoClass AudienceObjectsVideoClass;

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;
enum  {
	AUDIENCE_LIBRARY_ITEM_0_PROPERTY,
	AUDIENCE_LIBRARY_ITEM_VIDEO_PROPERTY,
	AUDIENCE_LIBRARY_ITEM_ITEM_STYLE_PROPERTY,
	AUDIENCE_LIBRARY_ITEM_POSTER_PROPERTY,
	AUDIENCE_LIBRARY_ITEM_EPISODES_PROPERTY,
	AUDIENCE_LIBRARY_ITEM_NUM_PROPERTIES
};
static GParamSpec* audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block11Data Block11Data;

#define AUDIENCE_TYPE_APP (audience_app_get_type ())
#define AUDIENCE_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_APP, AudienceApp))
#define AUDIENCE_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_APP, AudienceAppClass))
#define AUDIENCE_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_APP))
#define AUDIENCE_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_APP))
#define AUDIENCE_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_APP, AudienceAppClass))

typedef struct _AudienceApp AudienceApp;
typedef struct _AudienceAppClass AudienceAppClass;
typedef struct _AudienceAppPrivate AudienceAppPrivate;

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block12Data Block12Data;

struct _AudienceLibraryItem {
	GtkFlowBoxChild parent_instance;
	AudienceLibraryItemPrivate * priv;
};

struct _AudienceLibraryItemClass {
	GtkFlowBoxChildClass parent_class;
};

struct _AudienceLibraryItemPrivate {
	AudienceObjectsVideo* _video;
	AudienceLibraryItemStyle _item_style;
	GtkImage* _poster;
	GeeArrayList* _episodes;
	AudienceServicesLibraryManager* manager;
	GtkStack* spinner_stack;
	GtkLabel* title_label;
	GtkMenu* context_menu;
	gchar* episode_poster_path;
	gchar* poster_cache_file;
};

struct _Block11Data {
	int _ref_count_;
	AudienceLibraryItem* self;
	GtkFileChooserNative* filechooser;
};

struct _AudienceApp {
	GtkApplication parent_instance;
	AudienceAppPrivate * priv;
	AudienceWindow* mainwindow;
	GVolumeMonitor* monitor;
};

struct _AudienceAppClass {
	GtkApplicationClass parent_class;
};

struct _Block12Data {
	int _ref_count_;
	AudienceLibraryItem* self;
	AudienceObjectsVideo* episode;
};

static gint AudienceLibraryItem_private_offset;
static gpointer audience_library_item_parent_class = NULL;

VALA_EXTERN GType audience_library_item_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType audience_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryItem, g_object_unref)
VALA_EXTERN GType audience_objects_video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsVideo, g_object_unref)
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceLibraryItem* audience_library_item_new (AudienceObjectsVideo* video,
                                                AudienceLibraryItemStyle item_style);
VALA_EXTERN AudienceLibraryItem* audience_library_item_construct (GType object_type,
                                                      AudienceObjectsVideo* video,
                                                      AudienceLibraryItemStyle item_style);
static void audience_library_item_poster_visibility (AudienceLibraryItem* self);
VALA_EXTERN GtkImage* audience_library_item_get_poster (AudienceLibraryItem* self);
static gboolean audience_library_item_show_context_menu (AudienceLibraryItem* self,
                                                  GtkWidget* sender,
                                                  GdkEventButton* evt);
static void audience_library_item_set_new_cover (AudienceLibraryItem* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN GType audience_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceApp, g_object_unref)
VALA_EXTERN AudienceApp* audience_app_get_instance (void);
VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
static void __lambda11_ (Block11Data* _data11_,
                  gint response);
VALA_EXTERN GdkPixbuf* audience_services_library_manager_get_poster_from_file (AudienceServicesLibraryManager* self,
                                                                   const gchar* poster_path);
VALA_EXTERN GeeArrayList* audience_library_item_get_episodes (AudienceLibraryItem* self);
VALA_EXTERN GFile* audience_objects_video_get_video_file (AudienceObjectsVideo* self);
VALA_EXTERN void audience_objects_video_set_new_poster (AudienceObjectsVideo* self,
                                            GdkPixbuf* new_poster);
VALA_EXTERN void audience_objects_video_initialize_poster (AudienceObjectsVideo* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void audience_objects_video_initialize_poster_finish (AudienceObjectsVideo* self,
                                                      GAsyncResult* _res_);
VALA_EXTERN void audience_services_library_manager_clear_cache (AudienceServicesLibraryManager* self,
                                                    const gchar* cache_file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void audience_services_library_manager_clear_cache_finish (AudienceServicesLibraryManager* self,
                                                           GAsyncResult* _res_);
static void audience_library_item_create_episode_poster (AudienceLibraryItem* self);
static void ___lambda11__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                              gint response_id,
                                              gpointer self);
static void audience_library_item_move_video_to_trash (AudienceLibraryItem* self);
VALA_EXTERN void audience_services_library_manager_deleted_items (AudienceServicesLibraryManager* self,
                                                      const gchar* path);
VALA_EXTERN void audience_library_item_add_episode (AudienceLibraryItem* self,
                                        AudienceObjectsVideo* episode);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda12_ (Block12Data* _data12_);
static void ___lambda12__audience_objects_video_trashed (AudienceObjectsVideo* _sender,
                                                  gpointer self);
VALA_EXTERN const gchar* audience_objects_video_get_title (AudienceObjectsVideo* self);
VALA_EXTERN const gchar* audience_objects_video_get_container (AudienceObjectsVideo* self);
VALA_EXTERN gchar* audience_library_item_get_title (AudienceLibraryItem* self);
VALA_EXTERN AudienceObjectsVideo* audience_library_item_get_video (AudienceLibraryItem* self);
static void audience_library_item_set_video (AudienceLibraryItem* self,
                                      AudienceObjectsVideo* value);
VALA_EXTERN AudienceLibraryItemStyle audience_library_item_get_item_style (AudienceLibraryItem* self);
static void audience_library_item_set_item_style (AudienceLibraryItem* self,
                                           AudienceLibraryItemStyle value);
VALA_EXTERN void audience_library_item_set_poster (AudienceLibraryItem* self,
                                       GtkImage* value);
static void audience_library_item_set_episodes (AudienceLibraryItem* self,
                                         GeeArrayList* value);
static GObject * audience_library_item_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
VALA_EXTERN gchar* audience_app_get_cache_directory (AudienceApp* self);
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
static void _audience_library_item_move_video_to_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static void _audience_library_item_set_new_cover_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                  gpointer self);
static void _audience_library_item_poster_visibility_gtk_widget_map (GtkWidget* _sender,
                                                              gpointer self);
static void _audience_library_item_poster_visibility_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static gboolean _audience_library_item_show_context_menu_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                 GdkEventButton* event,
                                                                                 gpointer self);
static void _audience_library_item___lambda13_ (AudienceLibraryItem* self);
static void __audience_library_item___lambda13__audience_objects_video_title_changed (AudienceObjectsVideo* _sender,
                                                                               AudienceObjectsVideo* sender,
                                                                               gpointer self);
static void _audience_library_item___lambda14_ (AudienceLibraryItem* self);
VALA_EXTERN GdkPixbuf* audience_objects_video_get_poster (AudienceObjectsVideo* self);
static void __audience_library_item___lambda14__audience_objects_video_poster_changed (AudienceObjectsVideo* _sender,
                                                                                AudienceObjectsVideo* sender,
                                                                                gpointer self);
static void audience_library_item_finalize (GObject * obj);
static GType audience_library_item_get_type_once (void);
static void _vala_audience_library_item_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_audience_library_item_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static GType
audience_library_item_style_get_type_once (void)
{
	static const GEnumValue values[] = {{AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL, "AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL", "thumbnail"}, {AUDIENCE_LIBRARY_ITEM_STYLE_ROW, "AUDIENCE_LIBRARY_ITEM_STYLE_ROW", "row"}, {0, NULL, NULL}};
	GType audience_library_item_style_type_id;
	audience_library_item_style_type_id = g_enum_register_static ("AudienceLibraryItemStyle", values);
	return audience_library_item_style_type_id;
}

GType
audience_library_item_style_get_type (void)
{
	static volatile gsize audience_library_item_style_type_id__once = 0;
	if (g_once_init_enter (&audience_library_item_style_type_id__once)) {
		GType audience_library_item_style_type_id;
		audience_library_item_style_type_id = audience_library_item_style_get_type_once ();
		g_once_init_leave (&audience_library_item_style_type_id__once, audience_library_item_style_type_id);
	}
	return audience_library_item_style_type_id__once;
}

static inline gpointer
audience_library_item_get_instance_private (AudienceLibraryItem* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceLibraryItem_private_offset);
}

AudienceLibraryItem*
audience_library_item_construct (GType object_type,
                                 AudienceObjectsVideo* video,
                                 AudienceLibraryItemStyle item_style)
{
	AudienceLibraryItem * self = NULL;
	g_return_val_if_fail (video != NULL, NULL);
	self = (AudienceLibraryItem*) g_object_new (object_type, "item-style", item_style, "video", video, NULL);
	return self;
}

AudienceLibraryItem*
audience_library_item_new (AudienceObjectsVideo* video,
                           AudienceLibraryItemStyle item_style)
{
	return audience_library_item_construct (AUDIENCE_TYPE_LIBRARY_ITEM, video, item_style);
}

static void
audience_library_item_poster_visibility (AudienceLibraryItem* self)
{
	GtkImage* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_poster;
	g_object_get (_tmp0_, "pixbuf", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		GtkStack* _tmp5_;
		GtkImage* _tmp6_;
		_tmp5_ = self->priv->spinner_stack;
		gtk_stack_set_visible_child_name (_tmp5_, "poster");
		_tmp6_ = self->priv->_poster;
		gtk_widget_show_all ((GtkWidget*) _tmp6_);
	} else {
		GtkStack* _tmp7_;
		_tmp7_ = self->priv->spinner_stack;
		gtk_stack_set_visible_child_name (_tmp7_, "spinner");
	}
}

static gboolean
audience_library_item_show_context_menu (AudienceLibraryItem* self,
                                         GtkWidget* sender,
                                         GdkEventButton* evt)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if (evt->type == GDK_BUTTON_PRESS) {
		_tmp0_ = evt->button == ((guint) 3);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMenu* _tmp1_;
		_tmp1_ = self->priv->context_menu;
		gtk_menu_popup_at_pointer (_tmp1_, (GdkEvent*) evt);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		AudienceLibraryItem* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->filechooser);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda11_ (Block11Data* _data11_,
             gint response)
{
	AudienceLibraryItem* self;
	GError* _inner_error0_ = NULL;
	self = _data11_->self;
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		GdkPixbuf* pixbuf = NULL;
		AudienceServicesLibraryManager* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp0_ = self->priv->manager;
		_tmp1_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _data11_->filechooser);
		_tmp2_ = _tmp1_;
		_tmp3_ = audience_services_library_manager_get_poster_from_file (_tmp0_, _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		pixbuf = _tmp4_;
		_tmp5_ = pixbuf;
		if (_tmp5_ != NULL) {
			{
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp6_ = self->priv->_episodes;
				_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ == 1) {
					GdkPixbuf* _tmp9_;
					GeeArrayList* _tmp10_;
					gpointer _tmp11_;
					AudienceObjectsVideo* _tmp12_;
					GFile* _tmp13_;
					GFile* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					GeeArrayList* _tmp19_;
					gpointer _tmp20_;
					AudienceObjectsVideo* _tmp21_;
					GdkPixbuf* _tmp22_;
					GeeArrayList* _tmp23_;
					gpointer _tmp24_;
					AudienceObjectsVideo* _tmp25_;
					_tmp9_ = pixbuf;
					_tmp10_ = self->priv->_episodes;
					_tmp11_ = gee_list_first ((GeeList*) _tmp10_);
					_tmp12_ = (AudienceObjectsVideo*) _tmp11_;
					_tmp13_ = audience_objects_video_get_video_file (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_file_get_path (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp16_, ".jpg", NULL);
					_tmp18_ = _tmp17_;
					gdk_pixbuf_save (_tmp9_, _tmp18_, "jpeg", &_inner_error0_, NULL);
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
					_g_object_unref0 (_tmp12_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp19_ = self->priv->_episodes;
					_tmp20_ = gee_list_first ((GeeList*) _tmp19_);
					_tmp21_ = (AudienceObjectsVideo*) _tmp20_;
					_tmp22_ = pixbuf;
					audience_objects_video_set_new_poster (_tmp21_, _tmp22_);
					_g_object_unref0 (_tmp21_);
					_tmp23_ = self->priv->_episodes;
					_tmp24_ = gee_list_first ((GeeList*) _tmp23_);
					_tmp25_ = (AudienceObjectsVideo*) _tmp24_;
					audience_objects_video_initialize_poster (_tmp25_, NULL, NULL);
					_g_object_unref0 (_tmp25_);
				} else {
					AudienceServicesLibraryManager* _tmp26_;
					const gchar* _tmp27_;
					GdkPixbuf* _tmp28_;
					const gchar* _tmp29_;
					_tmp26_ = self->priv->manager;
					_tmp27_ = self->priv->poster_cache_file;
					audience_services_library_manager_clear_cache (_tmp26_, _tmp27_, NULL, NULL);
					_tmp28_ = pixbuf;
					_tmp29_ = self->priv->episode_poster_path;
					gdk_pixbuf_save (_tmp28_, _tmp29_, "jpeg", &_inner_error0_, NULL);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					audience_library_item_create_episode_poster (self);
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp30_;
				const gchar* _tmp31_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp30_ = e;
				_tmp31_ = _tmp30_->message;
				g_warning ("LibraryItem.vala:198: %s", _tmp31_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (pixbuf);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_g_object_unref0 (pixbuf);
	}
	gtk_native_dialog_destroy ((GtkNativeDialog*) _data11_->filechooser);
}

static void
___lambda11__gtk_native_dialog_response (GtkNativeDialog* _sender,
                                         gint response_id,
                                         gpointer self)
{
	__lambda11_ (self, response_id);
}

static void
audience_library_item_set_new_cover (AudienceLibraryItem* self)
{
	Block11Data* _data11_;
	GtkFileFilter* image_filter = NULL;
	GtkFileFilter* _tmp0_;
	AudienceApp* _tmp1_;
	AudienceApp* _tmp2_;
	AudienceWindow* _tmp3_;
	GtkFileChooserNative* _tmp4_;
	GtkFileChooserNative* _tmp5_;
	GtkFileFilter* _tmp6_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp0_);
	image_filter = _tmp0_;
	gtk_file_filter_set_name (image_filter, _ ("Image files"));
	gtk_file_filter_add_mime_type (image_filter, "image/*");
	_tmp1_ = audience_app_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->mainwindow;
	_tmp4_ = gtk_file_chooser_native_new (_ ("Open"), (GtkWindow*) _tmp3_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Open"), _ ("_Cancel"));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_data11_->filechooser = _tmp5_;
	_tmp6_ = _g_object_ref0 (image_filter);
	gtk_file_chooser_add_filter ((GtkFileChooser*) _data11_->filechooser, _tmp6_);
	g_signal_connect_data ((GtkNativeDialog*) _data11_->filechooser, "response", (GCallback) ___lambda11__gtk_native_dialog_response, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	gtk_native_dialog_show ((GtkNativeDialog*) _data11_->filechooser);
	_g_object_unref0 (image_filter);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
audience_library_item_move_video_to_trash (AudienceLibraryItem* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_episodes;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("%i", _tmp2_);
	_tmp4_ = _tmp3_;
	g_debug ("LibraryItem.vala:210: %s", _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->priv->_episodes;
	_tmp6_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 1) {
		AudienceObjectsVideo* video = NULL;
		GeeArrayList* _tmp8_;
		gpointer _tmp9_;
		AudienceObjectsVideo* _tmp10_;
		_tmp8_ = self->priv->_episodes;
		_tmp9_ = gee_list_first ((GeeList*) _tmp8_);
		video = (AudienceObjectsVideo*) _tmp9_;
		_tmp10_ = video;
		g_signal_emit_by_name (_tmp10_, "trashed");
		{
			AudienceObjectsVideo* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			AudienceServicesLibraryManager* _tmp14_;
			AudienceObjectsVideo* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp11_ = video;
			_tmp12_ = audience_objects_video_get_video_file (_tmp11_);
			_tmp13_ = _tmp12_;
			g_file_trash (_tmp13_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp14_ = self->priv->manager;
			_tmp15_ = video;
			_tmp16_ = audience_objects_video_get_video_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_file_get_path (_tmp17_);
			_tmp19_ = _tmp18_;
			audience_services_library_manager_deleted_items (_tmp14_, _tmp19_);
			_g_free0 (_tmp19_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp20_;
			const gchar* _tmp21_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp20_ = e;
			_tmp21_ = _tmp20_->message;
			g_warning ("LibraryItem.vala:218: %s", _tmp21_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (video);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (video);
	} else {
		{
			GeeArrayList* _tmp22_;
			gpointer _tmp23_;
			AudienceObjectsVideo* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
			GFile* _tmp27_;
			GFile* _tmp28_;
			AudienceServicesLibraryManager* _tmp29_;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			AudienceObjectsVideo* _tmp32_;
			GFile* _tmp33_;
			GFile* _tmp34_;
			GFile* _tmp35_;
			GFile* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp22_ = self->priv->_episodes;
			_tmp23_ = gee_list_first ((GeeList*) _tmp22_);
			_tmp24_ = (AudienceObjectsVideo*) _tmp23_;
			_tmp25_ = audience_objects_video_get_video_file (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_file_get_parent (_tmp26_);
			_tmp28_ = _tmp27_;
			g_file_trash (_tmp28_, NULL, &_inner_error0_);
			_g_object_unref0 (_tmp28_);
			_g_object_unref0 (_tmp24_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp29_ = self->priv->manager;
			_tmp30_ = self->priv->_episodes;
			_tmp31_ = gee_list_first ((GeeList*) _tmp30_);
			_tmp32_ = (AudienceObjectsVideo*) _tmp31_;
			_tmp33_ = audience_objects_video_get_video_file (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_file_get_parent (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_file_get_path (_tmp36_);
			_tmp38_ = _tmp37_;
			audience_services_library_manager_deleted_items (_tmp29_, _tmp38_);
			_g_free0 (_tmp38_);
			_g_object_unref0 (_tmp36_);
			_g_object_unref0 (_tmp32_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp39_;
			const gchar* _tmp40_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp39_ = e;
			_tmp40_ = _tmp39_->message;
			g_warning ("LibraryItem.vala:225: %s", _tmp40_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		AudienceLibraryItem* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->episode);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda12_ (Block12Data* _data12_)
{
	AudienceLibraryItem* self;
	GeeArrayList* _tmp0_;
	self = _data12_->self;
	_tmp0_ = self->priv->_episodes;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _data12_->episode);
}

static void
___lambda12__audience_objects_video_trashed (AudienceObjectsVideo* _sender,
                                             gpointer self)
{
	__lambda12_ (self);
}

void
audience_library_item_add_episode (AudienceLibraryItem* self,
                                   AudienceObjectsVideo* episode)
{
	Block12Data* _data12_;
	AudienceObjectsVideo* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (episode != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (episode);
	_g_object_unref0 (_data12_->episode);
	_data12_->episode = _tmp0_;
	g_signal_connect_data (_data12_->episode, "trashed", (GCallback) ___lambda12__audience_objects_video_trashed, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp1_ = self->priv->_episodes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _data12_->episode);
	_tmp2_ = self->priv->_episodes;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 1) {
		GtkLabel* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->title_label;
		_tmp6_ = audience_objects_video_get_title (_data12_->episode);
		_tmp7_ = _tmp6_;
		gtk_label_set_label (_tmp5_, _tmp7_);
	} else {
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = self->priv->_episodes;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == 2) {
			GtkLabel* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = self->priv->title_label;
			_tmp12_ = audience_objects_video_get_container (_data12_->episode);
			_tmp13_ = _tmp12_;
			gtk_label_set_label (_tmp11_, _tmp13_);
			audience_library_item_create_episode_poster (self);
		}
	}
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

gchar*
audience_library_item_get_title (AudienceLibraryItem* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->title_label;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
audience_library_item_create_episode_poster (AudienceLibraryItem* self)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->poster_cache_file;
	if (g_file_test (_tmp0_, G_FILE_TEST_EXISTS)) {
		{
			GdkPixbuf* _tmp1_ = NULL;
			const gchar* _tmp2_;
			GdkPixbuf* _tmp3_;
			GtkImage* _tmp4_;
			_tmp2_ = self->priv->poster_cache_file;
			_tmp3_ = gdk_pixbuf_new_from_file (_tmp2_, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = self->priv->_poster;
			g_object_set (_tmp4_, "pixbuf", _tmp1_, NULL);
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			g_warning ("LibraryItem.vala:252: %s", _tmp6_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		const gchar* _tmp7_;
		_tmp7_ = self->priv->episode_poster_path;
		if (g_file_test (_tmp7_, G_FILE_TEST_EXISTS)) {
			GdkPixbuf* pixbuf = NULL;
			AudienceServicesLibraryManager* _tmp8_;
			const gchar* _tmp9_;
			GdkPixbuf* _tmp10_;
			GtkImage* _tmp11_;
			GdkPixbuf* _tmp12_;
			_tmp8_ = self->priv->manager;
			_tmp9_ = self->priv->episode_poster_path;
			_tmp10_ = audience_services_library_manager_get_poster_from_file (_tmp8_, _tmp9_);
			pixbuf = _tmp10_;
			_tmp11_ = self->priv->_poster;
			_tmp12_ = pixbuf;
			g_object_set (_tmp11_, "pixbuf", _tmp12_, NULL);
			{
				GdkPixbuf* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = pixbuf;
				_tmp14_ = self->priv->poster_cache_file;
				gdk_pixbuf_save (_tmp13_, _tmp14_, "jpeg", &_inner_error0_, NULL);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp15_;
				const gchar* _tmp16_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp15_ = e;
				_tmp16_ = _tmp15_->message;
				g_warning ("LibraryItem.vala:260: %s", _tmp16_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (pixbuf);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (pixbuf);
		}
	}
}

AudienceObjectsVideo*
audience_library_item_get_video (AudienceLibraryItem* self)
{
	AudienceObjectsVideo* result;
	AudienceObjectsVideo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_video;
	result = _tmp0_;
	return result;
}

static void
audience_library_item_set_video (AudienceLibraryItem* self,
                                 AudienceObjectsVideo* value)
{
	AudienceObjectsVideo* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_library_item_get_video (self);
	if (old_value != value) {
		AudienceObjectsVideo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_video);
		self->priv->_video = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_VIDEO_PROPERTY]);
	}
}

AudienceLibraryItemStyle
audience_library_item_get_item_style (AudienceLibraryItem* self)
{
	AudienceLibraryItemStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_item_style;
	return result;
}

static void
audience_library_item_set_item_style (AudienceLibraryItem* self,
                                      AudienceLibraryItemStyle value)
{
	AudienceLibraryItemStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_library_item_get_item_style (self);
	if (old_value != value) {
		self->priv->_item_style = value;
		g_object_notify_by_pspec ((GObject *) self, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_ITEM_STYLE_PROPERTY]);
	}
}

GtkImage*
audience_library_item_get_poster (AudienceLibraryItem* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_poster;
	result = _tmp0_;
	return result;
}

void
audience_library_item_set_poster (AudienceLibraryItem* self,
                                  GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_library_item_get_poster (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_poster);
		self->priv->_poster = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_POSTER_PROPERTY]);
	}
}

GeeArrayList*
audience_library_item_get_episodes (AudienceLibraryItem* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_episodes;
	result = _tmp0_;
	return result;
}

static void
audience_library_item_set_episodes (AudienceLibraryItem* self,
                                    GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_library_item_get_episodes (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_episodes);
		self->priv->_episodes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_EPISODES_PROPERTY]);
	}
}

static void
_audience_library_item_move_video_to_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	audience_library_item_move_video_to_trash ((AudienceLibraryItem*) self);
}

static void
_audience_library_item_set_new_cover_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                             gpointer self)
{
	audience_library_item_set_new_cover ((AudienceLibraryItem*) self);
}

static void
_audience_library_item_poster_visibility_gtk_widget_map (GtkWidget* _sender,
                                                         gpointer self)
{
	audience_library_item_poster_visibility ((AudienceLibraryItem*) self);
}

static void
_audience_library_item_poster_visibility_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	audience_library_item_poster_visibility ((AudienceLibraryItem*) self);
}

static gboolean
_audience_library_item_show_context_menu_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                        GdkEventButton* event,
                                                                        gpointer self)
{
	gboolean result;
	result = audience_library_item_show_context_menu ((AudienceLibraryItem*) self, _sender, event);
	return result;
}

static void
_audience_library_item___lambda13_ (AudienceLibraryItem* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->_episodes;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 1) {
		GtkLabel* _tmp3_;
		AudienceObjectsVideo* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp3_ = self->priv->title_label;
		_tmp4_ = self->priv->_video;
		_tmp5_ = audience_objects_video_get_title (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp3_, _tmp6_);
	} else {
		GtkLabel* _tmp7_;
		AudienceObjectsVideo* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = self->priv->title_label;
		_tmp8_ = self->priv->_video;
		_tmp9_ = audience_objects_video_get_container (_tmp8_);
		_tmp10_ = _tmp9_;
		gtk_label_set_label (_tmp7_, _tmp10_);
	}
}

static void
__audience_library_item___lambda13__audience_objects_video_title_changed (AudienceObjectsVideo* _sender,
                                                                          AudienceObjectsVideo* sender,
                                                                          gpointer self)
{
	_audience_library_item___lambda13_ ((AudienceLibraryItem*) self);
}

static void
_audience_library_item___lambda14_ (AudienceLibraryItem* self)
{
	gboolean _tmp0_ = FALSE;
	AudienceLibraryItemStyle _tmp1_;
	_tmp1_ = self->priv->_item_style;
	if (_tmp1_ == AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL) {
		gboolean _tmp2_ = FALSE;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->_episodes;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == 1) {
			_tmp2_ = TRUE;
		} else {
			GtkImage* _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			GdkPixbuf* _tmp9_;
			_tmp6_ = self->priv->_poster;
			g_object_get (_tmp6_, "pixbuf", &_tmp7_, NULL);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			_tmp2_ = _tmp9_ == NULL;
			_g_object_unref0 (_tmp9_);
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkImage* _tmp10_;
		AudienceObjectsVideo* _tmp11_;
		GdkPixbuf* _tmp12_;
		GdkPixbuf* _tmp13_;
		_tmp10_ = self->priv->_poster;
		_tmp11_ = self->priv->_video;
		_tmp12_ = audience_objects_video_get_poster (_tmp11_);
		_tmp13_ = _tmp12_;
		g_object_set (_tmp10_, "pixbuf", _tmp13_, NULL);
	}
}

static void
__audience_library_item___lambda14__audience_objects_video_poster_changed (AudienceObjectsVideo* _sender,
                                                                           AudienceObjectsVideo* sender,
                                                                           gpointer self)
{
	_audience_library_item___lambda14_ ((AudienceLibraryItem*) self);
}

static GObject *
audience_library_item_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceLibraryItem * self;
	GFile* video_file_parent = NULL;
	AudienceObjectsVideo* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* hash = NULL;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	AudienceApp* _tmp23_;
	AudienceApp* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp32_;
	AudienceServicesLibraryManager* _tmp33_;
	GtkLabel* _tmp34_;
	GtkBox* box = NULL;
	GtkBox* _tmp35_ = NULL;
	GtkMenu* _tmp36_;
	GtkMenuItem* move_to_trash = NULL;
	GtkMenuItem* _tmp37_;
	GtkMenuItem* _tmp38_;
	AudienceLibraryItemStyle _tmp39_;
	GtkMenu* _tmp69_;
	GtkMenuItem* _tmp70_;
	GtkMenu* _tmp71_;
	GtkEventBox* event_box = NULL;
	GtkBox* _tmp72_;
	GtkWidget* _tmp73_;
	GtkEventBox* _tmp74_ = NULL;
	GtkEventBox* _tmp75_;
	GtkEventBox* _tmp76_;
	AudienceObjectsVideo* _tmp77_;
	AudienceObjectsVideo* _tmp78_;
	AudienceObjectsVideo* _tmp79_;
	parent_class = G_OBJECT_CLASS (audience_library_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	_tmp0_ = self->priv->_video;
	_tmp1_ = audience_objects_video_get_video_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_get_parent (_tmp2_);
	video_file_parent = _tmp3_;
	_tmp4_ = video_file_parent;
	_tmp5_ = g_file_get_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = video_file_parent;
	_tmp8_ = g_file_get_basename (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, ".jpg", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_build_filename (_tmp6_, _tmp11_, NULL);
	_g_free0 (self->priv->episode_poster_path);
	self->priv->episode_poster_path = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_tmp13_ = video_file_parent;
	_tmp14_ = g_file_get_uri (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = video_file_parent;
	_tmp17_ = g_file_get_uri (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = strlen (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp15_, (gsize) _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	hash = _tmp22_;
	_tmp23_ = audience_app_get_instance ();
	_tmp24_ = _tmp23_;
	_tmp25_ = audience_app_get_cache_directory (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = hash;
	_tmp28_ = g_strconcat (_tmp27_, ".jpg", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_build_filename (_tmp26_, _tmp29_, NULL);
	_g_free0 (self->priv->poster_cache_file);
	self->priv->poster_cache_file = _tmp30_;
	_g_free0 (_tmp29_);
	_g_free0 (_tmp26_);
	_g_object_unref0 (_tmp24_);
	_tmp31_ = gee_array_list_new (AUDIENCE_OBJECTS_TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp32_ = _tmp31_;
	audience_library_item_set_episodes (self, _tmp32_);
	_g_object_unref0 (_tmp32_);
	_tmp33_ = audience_services_library_manager_get_instance ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp33_;
	_tmp34_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->title_label);
	self->priv->title_label = _tmp34_;
	_tmp35_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp35_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp35_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp35_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp35_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp35_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp35_, 12);
	g_object_ref_sink (_tmp35_);
	box = _tmp35_;
	_tmp36_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->context_menu);
	self->priv->context_menu = _tmp36_;
	_tmp37_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Move to Trash"));
	g_object_ref_sink (_tmp37_);
	move_to_trash = _tmp37_;
	_tmp38_ = move_to_trash;
	g_signal_connect_object (_tmp38_, "activate", (GCallback) _audience_library_item_move_video_to_trash_gtk_menu_item_activate, self, 0);
	_tmp39_ = self->priv->_item_style;
	if (_tmp39_ == AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL) {
		GtkLabel* _tmp40_;
		GtkLabel* _tmp41_;
		GtkLabel* _tmp42_;
		GtkMenuItem* new_cover = NULL;
		GtkMenuItem* _tmp43_;
		GtkMenu* _tmp44_;
		GtkMenuItem* _tmp45_;
		GtkMenu* _tmp46_;
		GtkSeparatorMenuItem* _tmp47_;
		GtkSeparatorMenuItem* _tmp48_;
		GtkImage* _tmp49_;
		GtkImage* _tmp50_;
		GtkImage* _tmp51_;
		GtkSpinner* spinner = NULL;
		GtkSpinner* _tmp52_ = NULL;
		GtkStack* _tmp53_ = NULL;
		GtkStack* _tmp54_;
		GtkStyleContext* _tmp55_;
		GtkStack* _tmp56_;
		GtkSpinner* _tmp57_;
		GtkStack* _tmp58_;
		GtkImage* _tmp59_;
		GtkBox* _tmp60_;
		GtkStack* _tmp61_;
		GtkBox* _tmp62_;
		GtkLabel* _tmp63_;
		GtkMenuItem* _tmp64_;
		GtkImage* _tmp65_;
		_tmp40_ = self->priv->title_label;
		g_object_set (_tmp40_, "wrap", TRUE, NULL);
		_tmp41_ = self->priv->title_label;
		gtk_label_set_max_width_chars (_tmp41_, 0);
		_tmp42_ = self->priv->title_label;
		gtk_label_set_justify (_tmp42_, GTK_JUSTIFY_CENTER);
		_tmp43_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Set Artwork"));
		g_object_ref_sink (_tmp43_);
		new_cover = _tmp43_;
		_tmp44_ = self->priv->context_menu;
		_tmp45_ = new_cover;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp44_, _tmp45_);
		_tmp46_ = self->priv->context_menu;
		_tmp47_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp47_);
		_tmp48_ = _tmp47_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp46_, (GtkMenuItem*) _tmp48_);
		_g_object_unref0 (_tmp48_);
		_tmp49_ = (GtkImage*) gtk_image_new ();
		g_object_ref_sink (_tmp49_);
		_tmp50_ = _tmp49_;
		audience_library_item_set_poster (self, _tmp50_);
		_g_object_unref0 (_tmp50_);
		_tmp51_ = self->priv->_poster;
		g_object_set (_tmp51_, "pixbuf", NULL, NULL);
		_tmp52_ = (GtkSpinner*) gtk_spinner_new ();
		g_object_set (_tmp52_, "active", TRUE, NULL);
		gtk_widget_set_hexpand ((GtkWidget*) _tmp52_, TRUE);
		gtk_widget_set_vexpand ((GtkWidget*) _tmp52_, TRUE);
		gtk_widget_set_halign ((GtkWidget*) _tmp52_, GTK_ALIGN_CENTER);
		gtk_widget_set_valign ((GtkWidget*) _tmp52_, GTK_ALIGN_CENTER);
		g_object_set ((GtkWidget*) _tmp52_, "height-request", 32, NULL);
		g_object_set ((GtkWidget*) _tmp52_, "width-request", 32, NULL);
		g_object_ref_sink (_tmp52_);
		spinner = _tmp52_;
		_tmp53_ = (GtkStack*) gtk_stack_new ();
		g_object_set ((GtkWidget*) _tmp53_, "height-request", AUDIENCE_SERVICES_POSTER_HEIGHT, NULL);
		g_object_set ((GtkWidget*) _tmp53_, "width-request", AUDIENCE_SERVICES_POSTER_WIDTH, NULL);
		gtk_widget_set_halign ((GtkWidget*) _tmp53_, GTK_ALIGN_CENTER);
		g_object_ref_sink (_tmp53_);
		_g_object_unref0 (self->priv->spinner_stack);
		self->priv->spinner_stack = _tmp53_;
		_tmp54_ = self->priv->spinner_stack;
		_tmp55_ = gtk_widget_get_style_context ((GtkWidget*) _tmp54_);
		gtk_style_context_add_class (_tmp55_, GRANITE_STYLE_CLASS_CARD);
		_tmp56_ = self->priv->spinner_stack;
		_tmp57_ = spinner;
		gtk_stack_add_named (_tmp56_, (GtkWidget*) _tmp57_, "spinner");
		_tmp58_ = self->priv->spinner_stack;
		_tmp59_ = self->priv->_poster;
		gtk_stack_add_named (_tmp58_, (GtkWidget*) _tmp59_, "poster");
		_tmp60_ = box;
		_tmp61_ = self->priv->spinner_stack;
		gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
		_tmp62_ = box;
		_tmp63_ = self->priv->title_label;
		gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
		_tmp64_ = new_cover;
		g_signal_connect_object (_tmp64_, "activate", (GCallback) _audience_library_item_set_new_cover_gtk_menu_item_activate, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) _audience_library_item_poster_visibility_gtk_widget_map, self, 0);
		_tmp65_ = self->priv->_poster;
		g_signal_connect_object ((GObject*) _tmp65_, "notify::pixbuf", (GCallback) _audience_library_item_poster_visibility_g_object_notify, self, 0);
		_g_object_unref0 (spinner);
		_g_object_unref0 (new_cover);
	} else {
		GtkBox* _tmp66_;
		GtkLabel* _tmp67_;
		GtkLabel* _tmp68_;
		_tmp66_ = box;
		_tmp67_ = self->priv->title_label;
		gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
		_tmp68_ = self->priv->title_label;
		gtk_widget_set_halign ((GtkWidget*) _tmp68_, GTK_ALIGN_START);
	}
	_tmp69_ = self->priv->context_menu;
	_tmp70_ = move_to_trash;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp69_, _tmp70_);
	_tmp71_ = self->priv->context_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp71_);
	_tmp72_ = box;
	_tmp73_ = _g_object_ref0 ((GtkWidget*) _tmp72_);
	_tmp74_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_set ((GtkContainer*) _tmp74_, "child", _tmp73_, NULL);
	_g_object_unref0 (_tmp73_);
	g_object_ref_sink (_tmp74_);
	event_box = _tmp74_;
	_tmp75_ = event_box;
	g_signal_connect_object ((GtkWidget*) _tmp75_, "button-press-event", (GCallback) _audience_library_item_show_context_menu_gtk_widget_button_press_event, self, 0);
	_tmp76_ = event_box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp76_, NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp77_ = self->priv->_video;
	audience_library_item_add_episode (self, _tmp77_);
	_tmp78_ = self->priv->_video;
	g_signal_connect_object (_tmp78_, "title-changed", (GCallback) __audience_library_item___lambda13__audience_objects_video_title_changed, self, 0);
	_tmp79_ = self->priv->_video;
	g_signal_connect_object (_tmp79_, "poster-changed", (GCallback) __audience_library_item___lambda14__audience_objects_video_poster_changed, self, 0);
	_g_object_unref0 (event_box);
	_g_object_unref0 (move_to_trash);
	_g_object_unref0 (box);
	_g_free0 (hash);
	_g_object_unref0 (video_file_parent);
	return obj;
}

static void
audience_library_item_class_init (AudienceLibraryItemClass * klass,
                                  gpointer klass_data)
{
	audience_library_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceLibraryItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_library_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_audience_library_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = audience_library_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_library_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_LIBRARY_ITEM_VIDEO_PROPERTY, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_VIDEO_PROPERTY] = g_param_spec_object ("video", "video", "video", AUDIENCE_OBJECTS_TYPE_VIDEO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_LIBRARY_ITEM_ITEM_STYLE_PROPERTY, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_ITEM_STYLE_PROPERTY] = g_param_spec_enum ("item-style", "item-style", "item-style", AUDIENCE_TYPE_LIBRARY_ITEM_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_LIBRARY_ITEM_POSTER_PROPERTY, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_POSTER_PROPERTY] = g_param_spec_object ("poster", "poster", "poster", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_LIBRARY_ITEM_EPISODES_PROPERTY, audience_library_item_properties[AUDIENCE_LIBRARY_ITEM_EPISODES_PROPERTY] = g_param_spec_object ("episodes", "episodes", "episodes", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
audience_library_item_instance_init (AudienceLibraryItem * self,
                                     gpointer klass)
{
	self->priv = audience_library_item_get_instance_private (self);
}

static void
audience_library_item_finalize (GObject * obj)
{
	AudienceLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	_g_object_unref0 (self->priv->_video);
	_g_object_unref0 (self->priv->_poster);
	_g_object_unref0 (self->priv->_episodes);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->spinner_stack);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->context_menu);
	_g_free0 (self->priv->episode_poster_path);
	_g_free0 (self->priv->poster_cache_file);
	G_OBJECT_CLASS (audience_library_item_parent_class)->finalize (obj);
}

static GType
audience_library_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceLibraryItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_library_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceLibraryItem), 0, (GInstanceInitFunc) audience_library_item_instance_init, NULL };
	GType audience_library_item_type_id;
	audience_library_item_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "AudienceLibraryItem", &g_define_type_info, 0);
	AudienceLibraryItem_private_offset = g_type_add_instance_private (audience_library_item_type_id, sizeof (AudienceLibraryItemPrivate));
	return audience_library_item_type_id;
}

GType
audience_library_item_get_type (void)
{
	static volatile gsize audience_library_item_type_id__once = 0;
	if (g_once_init_enter (&audience_library_item_type_id__once)) {
		GType audience_library_item_type_id;
		audience_library_item_type_id = audience_library_item_get_type_once ();
		g_once_init_leave (&audience_library_item_type_id__once, audience_library_item_type_id);
	}
	return audience_library_item_type_id__once;
}

static void
_vala_audience_library_item_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	AudienceLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	switch (property_id) {
		case AUDIENCE_LIBRARY_ITEM_VIDEO_PROPERTY:
		g_value_set_object (value, audience_library_item_get_video (self));
		break;
		case AUDIENCE_LIBRARY_ITEM_ITEM_STYLE_PROPERTY:
		g_value_set_enum (value, audience_library_item_get_item_style (self));
		break;
		case AUDIENCE_LIBRARY_ITEM_POSTER_PROPERTY:
		g_value_set_object (value, audience_library_item_get_poster (self));
		break;
		case AUDIENCE_LIBRARY_ITEM_EPISODES_PROPERTY:
		g_value_set_object (value, audience_library_item_get_episodes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_audience_library_item_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	AudienceLibraryItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
	switch (property_id) {
		case AUDIENCE_LIBRARY_ITEM_VIDEO_PROPERTY:
		audience_library_item_set_video (self, g_value_get_object (value));
		break;
		case AUDIENCE_LIBRARY_ITEM_ITEM_STYLE_PROPERTY:
		audience_library_item_set_item_style (self, g_value_get_enum (value));
		break;
		case AUDIENCE_LIBRARY_ITEM_POSTER_PROPERTY:
		audience_library_item_set_poster (self, g_value_get_object (value));
		break;
		case AUDIENCE_LIBRARY_ITEM_EPISODES_PROPERTY:
		audience_library_item_set_episodes (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

