/* EpisodesPage.c generated by valac 0.56.17, the Vala compiler
 * generated from EpisodesPage.vala, do not modify */

/*-
 * Copyright 2016-2021 elementary, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <handy.h>
#include <granite.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_EPISODES_PAGE (audience_episodes_page_get_type ())
#define AUDIENCE_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage))
#define AUDIENCE_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))
#define AUDIENCE_IS_EPISODES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_IS_EPISODES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_EPISODES_PAGE))
#define AUDIENCE_EPISODES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPageClass))

typedef struct _AudienceEpisodesPage AudienceEpisodesPage;
typedef struct _AudienceEpisodesPageClass AudienceEpisodesPageClass;
typedef struct _AudienceEpisodesPagePrivate AudienceEpisodesPagePrivate;

#define AUDIENCE_OBJECTS_TYPE_VIDEO (audience_objects_video_get_type ())
#define AUDIENCE_OBJECTS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo))
#define AUDIENCE_OBJECTS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))
#define AUDIENCE_OBJECTS_IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))

typedef struct _AudienceObjectsVideo AudienceObjectsVideo;
typedef struct _AudienceObjectsVideoClass AudienceObjectsVideoClass;
enum  {
	AUDIENCE_EPISODES_PAGE_0_PROPERTY,
	AUDIENCE_EPISODES_PAGE_POSTER_PROPERTY,
	AUDIENCE_EPISODES_PAGE_NUM_PROPERTIES
};
static GParamSpec* audience_episodes_page_properties[AUDIENCE_EPISODES_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	AUDIENCE_LIBRARY_ITEM_STYLE_THUMBNAIL,
	AUDIENCE_LIBRARY_ITEM_STYLE_ROW
} AudienceLibraryItemStyle;

#define AUDIENCE_TYPE_LIBRARY_ITEM_STYLE (audience_library_item_style_get_type ())

#define AUDIENCE_TYPE_LIBRARY_ITEM (audience_library_item_get_type ())
#define AUDIENCE_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem))
#define AUDIENCE_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))
#define AUDIENCE_IS_LIBRARY_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_IS_LIBRARY_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_LIBRARY_ITEM))
#define AUDIENCE_LIBRARY_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItemClass))

typedef struct _AudienceLibraryItem AudienceLibraryItem;
typedef struct _AudienceLibraryItemClass AudienceLibraryItemClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define AUDIENCE_TYPE_PLAYBACK_MANAGER (audience_playback_manager_get_type ())
#define AUDIENCE_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManager))
#define AUDIENCE_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))
#define AUDIENCE_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_PLAYBACK_MANAGER))
#define AUDIENCE_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_PLAYBACK_MANAGER, AudiencePlaybackManagerClass))

typedef struct _AudiencePlaybackManager AudiencePlaybackManager;
typedef struct _AudiencePlaybackManagerClass AudiencePlaybackManagerClass;

#define AUDIENCE_TYPE_WINDOW (audience_window_get_type ())
#define AUDIENCE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindow))
#define AUDIENCE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))
#define AUDIENCE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_WINDOW))
#define AUDIENCE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_WINDOW, AudienceWindowClass))

typedef struct _AudienceWindow AudienceWindow;
typedef struct _AudienceWindowClass AudienceWindowClass;

#define AUDIENCE_TYPE_APP (audience_app_get_type ())
#define AUDIENCE_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_APP, AudienceApp))
#define AUDIENCE_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_APP, AudienceAppClass))
#define AUDIENCE_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_APP))
#define AUDIENCE_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_APP))
#define AUDIENCE_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_APP, AudienceAppClass))

typedef struct _AudienceApp AudienceApp;
typedef struct _AudienceAppClass AudienceAppClass;
typedef struct _AudienceAppPrivate AudienceAppPrivate;
typedef enum  {
	AUDIENCE_WINDOW_NAVIGATION_PAGE_WELCOME,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_LIBRARY,
	AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES
} AudienceWindowNavigationPage;

#define AUDIENCE_WINDOW_TYPE_NAVIGATION_PAGE (audience_window_navigation_page_get_type ())
typedef struct _AudienceEpisodesPageRemoveItemFromPathData AudienceEpisodesPageRemoveItemFromPathData;

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;

struct _AudienceEpisodesPage {
	GtkBox parent_instance;
	AudienceEpisodesPagePrivate * priv;
};

struct _AudienceEpisodesPageClass {
	GtkBoxClass parent_class;
};

struct _AudienceEpisodesPagePrivate {
	GtkImage* _poster;
	GListStore* items;
	GtkSearchEntry* search_entry;
	HdyHeaderBar* header_bar;
	GtkFlowBox* view_episodes;
	GraniteWidgetsAlertView* alert_view;
	AudienceObjectsVideo* poster_source;
};

struct _AudienceApp {
	GtkApplication parent_instance;
	AudienceAppPrivate * priv;
	AudienceWindow* mainwindow;
	GVolumeMonitor* monitor;
};

struct _AudienceAppClass {
	GtkApplicationClass parent_class;
};

struct _AudienceEpisodesPageRemoveItemFromPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceEpisodesPage* self;
	gchar* path;
	gint i;
	gboolean _tmp0_;
	gint _tmp1_;
	GListStore* _tmp2_;
	AudienceLibraryItem* item;
	GListStore* _tmp3_;
	GObject* _tmp4_;
	gboolean _tmp5_;
	AudienceLibraryItem* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	AudienceLibraryItem* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	gpointer _tmp14_;
	AudienceObjectsVideo* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GListStore* _tmp20_;
	HdyDeck* deck;
	GtkWidget* _tmp21_;
	HdyDeck* _tmp22_;
	gboolean _tmp23_;
	HdyDeck* _tmp24_;
	GtkWidget* _tmp25_;
	GtkWidget* _tmp26_;
	GListStore* _tmp27_;
	HdyDeck* _tmp28_;
};

static gint AudienceEpisodesPage_private_offset;
static gpointer audience_episodes_page_parent_class = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_episodes_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceEpisodesPage, g_object_unref)
VALA_EXTERN GType audience_objects_video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsVideo, g_object_unref)
VALA_EXTERN void audience_episodes_page_search (AudienceEpisodesPage* self);
VALA_EXTERN void audience_episodes_page_set_episodes_items (AudienceEpisodesPage* self,
                                                GeeArrayList* episodes);
VALA_EXTERN GType audience_library_item_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AudienceLibraryItem* audience_library_item_new (AudienceObjectsVideo* video,
                                                AudienceLibraryItemStyle item_style);
VALA_EXTERN AudienceLibraryItem* audience_library_item_construct (GType object_type,
                                                      AudienceObjectsVideo* video,
                                                      AudienceLibraryItemStyle item_style);
VALA_EXTERN GType audience_library_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceLibraryItem, g_object_unref)
static gint audience_episodes_page_episode_sort_func (AudienceEpisodesPage* self,
                                               GObject* item1,
                                               GObject* item2);
static gint _audience_episodes_page_episode_sort_func_gcompare_data_func (gconstpointer a,
                                                                   gconstpointer b,
                                                                   gpointer self);
static void audience_episodes_page_update_poster (AudienceEpisodesPage* self,
                                           AudienceObjectsVideo* episode);
static void _audience_episodes_page_update_poster_audience_objects_video_poster_changed (AudienceObjectsVideo* _sender,
                                                                                  AudienceObjectsVideo* sender,
                                                                                  gpointer self);
VALA_EXTERN const gchar* audience_objects_video_get_container (AudienceObjectsVideo* self);
VALA_EXTERN GtkImage* audience_episodes_page_get_poster (AudienceEpisodesPage* self);
VALA_EXTERN GdkPixbuf* audience_objects_video_get_poster (AudienceObjectsVideo* self);
static void audience_episodes_page_play_video (AudienceEpisodesPage* self,
                                        GtkFlowBoxChild* item);
VALA_EXTERN GeeArrayList* audience_library_item_get_episodes (AudienceLibraryItem* self);
VALA_EXTERN GFile* audience_objects_video_get_video_file (AudienceObjectsVideo* self);
VALA_EXTERN GType audience_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudiencePlaybackManager, g_object_unref)
VALA_EXTERN AudiencePlaybackManager* audience_playback_manager_get_default (void);
VALA_EXTERN void audience_playback_manager_append_to_playlist (AudiencePlaybackManager* self,
                                                   GFile* file);
VALA_EXTERN GType audience_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceWindow, g_object_unref)
VALA_EXTERN GType audience_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceApp, g_object_unref)
VALA_EXTERN AudienceApp* audience_app_get_instance (void);
VALA_EXTERN GType audience_window_navigation_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void audience_window_play_file (AudienceWindow* self,
                                const gchar* uri,
                                AudienceWindowNavigationPage origin,
                                gboolean from_beginning);
VALA_EXTERN AudienceObjectsVideo* audience_library_item_get_video (AudienceLibraryItem* self);
static void audience_episodes_page_filter (AudienceEpisodesPage* self);
static gboolean audience_episodes_page_has_child (AudienceEpisodesPage* self);
static gboolean audience_episodes_page_episodes_filter_func (AudienceEpisodesPage* self,
                                                      GtkFlowBoxChild* child);
VALA_EXTERN gchar* audience_library_item_get_title (AudienceLibraryItem* self);
VALA_EXTERN const gchar* audience_objects_video_get_file (AudienceObjectsVideo* self);
static void audience_episodes_page_add_item (AudienceEpisodesPage* self,
                                      AudienceObjectsVideo* episode);
static void audience_episodes_page_remove_item_from_path_data_free (gpointer _data);
static void audience_episodes_page_remove_item_from_path (AudienceEpisodesPage* self,
                                                   const gchar* path,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static void audience_episodes_page_remove_item_from_path_finish (AudienceEpisodesPage* self,
                                                          GAsyncResult* _res_);
static gboolean audience_episodes_page_remove_item_from_path_co (AudienceEpisodesPageRemoveItemFromPathData* _data_);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_new (void);
VALA_EXTERN AudienceEpisodesPage* audience_episodes_page_construct (GType object_type);
static void audience_episodes_page_set_poster (AudienceEpisodesPage* self,
                                        GtkImage* value);
static GObject * audience_episodes_page_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gboolean _audience_episodes_page_episodes_filter_func_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                                                gpointer self);
static GtkWidget* _audience_episodes_page___lambda78_ (AudienceEpisodesPage* self,
                                                GObject* item);
static GtkWidget* __audience_episodes_page___lambda78__gtk_flow_box_create_widget_func (gpointer item,
                                                                                 gpointer self);
static void _audience_episodes_page___lambda79_ (AudienceEpisodesPage* self);
static void __audience_episodes_page___lambda79__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void _audience_episodes_page_play_video_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                      GtkFlowBoxChild* child,
                                                                      gpointer self);
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
static void _audience_episodes_page_remove_item_from_path_audience_services_library_manager_video_file_deleted (AudienceServicesLibraryManager* _sender,
                                                                                                         const gchar* path,
                                                                                                         gpointer self);
static void _audience_episodes_page_add_item_audience_services_library_manager_video_file_detected (AudienceServicesLibraryManager* _sender,
                                                                                             AudienceObjectsVideo* video,
                                                                                             gpointer self);
static void _audience_episodes_page_filter_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                     gpointer self);
static gboolean _audience_episodes_page___lambda80_ (AudienceEpisodesPage* self,
                                              GdkEventKey* event);
static gboolean __audience_episodes_page___lambda80__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                          GdkEventKey* event,
                                                                          gpointer self);
static void audience_episodes_page_finalize (GObject * obj);
static GType audience_episodes_page_get_type_once (void);
static void _vala_audience_episodes_page_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_audience_episodes_page_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
audience_episodes_page_get_instance_private (AudienceEpisodesPage* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceEpisodesPage_private_offset);
}

void
audience_episodes_page_search (AudienceEpisodesPage* self)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

static gint
_audience_episodes_page_episode_sort_func_gcompare_data_func (gconstpointer a,
                                                              gconstpointer b,
                                                              gpointer self)
{
	gint result;
	result = audience_episodes_page_episode_sort_func ((AudienceEpisodesPage*) self, (GObject*) a, (GObject*) b);
	return result;
}

static void
_audience_episodes_page_update_poster_audience_objects_video_poster_changed (AudienceObjectsVideo* _sender,
                                                                             AudienceObjectsVideo* sender,
                                                                             gpointer self)
{
	audience_episodes_page_update_poster ((AudienceEpisodesPage*) self, sender);
}

void
audience_episodes_page_set_episodes_items (AudienceEpisodesPage* self,
                                           GeeArrayList* episodes)
{
	GListStore* _tmp0_;
	AudienceObjectsVideo* _tmp12_;
	gpointer _tmp15_;
	AudienceObjectsVideo* _tmp16_;
	AudienceObjectsVideo* _tmp17_;
	GtkSearchEntry* _tmp18_;
	HdyHeaderBar* _tmp19_;
	gpointer _tmp20_;
	AudienceObjectsVideo* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (episodes != NULL);
	_tmp0_ = self->priv->items;
	g_list_store_remove_all (_tmp0_);
	{
		GeeArrayList* _episode_list = NULL;
		gint _episode_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _episode_index = 0;
		_episode_list = episodes;
		_tmp1_ = _episode_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_episode_size = _tmp3_;
		_episode_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			AudienceObjectsVideo* episode = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GListStore* _tmp8_;
			AudienceObjectsVideo* _tmp9_;
			AudienceLibraryItem* _tmp10_;
			AudienceLibraryItem* _tmp11_;
			_episode_index = _episode_index + 1;
			_tmp4_ = _episode_index;
			_tmp5_ = _episode_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _episode_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _episode_index);
			episode = (AudienceObjectsVideo*) _tmp7_;
			_tmp8_ = self->priv->items;
			_tmp9_ = episode;
			_tmp10_ = audience_library_item_new (_tmp9_, AUDIENCE_LIBRARY_ITEM_STYLE_ROW);
			g_object_ref_sink (_tmp10_);
			_tmp11_ = _tmp10_;
			g_list_store_insert_sorted (_tmp8_, (GObject*) _tmp11_, _audience_episodes_page_episode_sort_func_gcompare_data_func, self);
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (episode);
		}
	}
	_tmp12_ = self->priv->poster_source;
	if (_tmp12_ != NULL) {
		AudienceObjectsVideo* _tmp13_;
		guint _tmp14_;
		_tmp13_ = self->priv->poster_source;
		g_signal_parse_name ("poster-changed", AUDIENCE_OBJECTS_TYPE_VIDEO, &_tmp14_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _audience_episodes_page_update_poster_audience_objects_video_poster_changed, self);
	}
	_tmp15_ = gee_list_first ((GeeList*) episodes);
	_g_object_unref0 (self->priv->poster_source);
	self->priv->poster_source = (AudienceObjectsVideo*) _tmp15_;
	_tmp16_ = self->priv->poster_source;
	audience_episodes_page_update_poster (self, _tmp16_);
	_tmp17_ = self->priv->poster_source;
	g_signal_connect_object (_tmp17_, "poster-changed", (GCallback) _audience_episodes_page_update_poster_audience_objects_video_poster_changed, self, 0);
	_tmp18_ = self->priv->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp18_, "");
	_tmp19_ = self->priv->header_bar;
	_tmp20_ = gee_list_first ((GeeList*) episodes);
	_tmp21_ = (AudienceObjectsVideo*) _tmp20_;
	_tmp22_ = audience_objects_video_get_container (_tmp21_);
	_tmp23_ = _tmp22_;
	hdy_header_bar_set_title (_tmp19_, _tmp23_);
	_g_object_unref0 (_tmp21_);
}

static void
audience_episodes_page_update_poster (AudienceEpisodesPage* self,
                                      AudienceObjectsVideo* episode)
{
	GtkImage* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (episode != NULL);
	_tmp0_ = self->priv->_poster;
	_tmp1_ = audience_objects_video_get_poster (episode);
	_tmp2_ = _tmp1_;
	g_object_set (_tmp0_, "pixbuf", _tmp2_, NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
audience_episodes_page_play_video (AudienceEpisodesPage* self,
                                   GtkFlowBoxChild* item)
{
	AudienceLibraryItem* selected = NULL;
	AudienceLibraryItem* _tmp0_;
	AudienceObjectsVideo* video = NULL;
	AudienceLibraryItem* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gpointer _tmp4_;
	AudienceObjectsVideo* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = _g_object_ref0 (AUDIENCE_IS_LIBRARY_ITEM (item) ? ((AudienceLibraryItem*) item) : NULL);
	selected = _tmp0_;
	_tmp1_ = selected;
	_tmp2_ = audience_library_item_get_episodes (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_list_first ((GeeList*) _tmp3_);
	video = (AudienceObjectsVideo*) _tmp4_;
	_tmp5_ = video;
	_tmp6_ = audience_objects_video_get_video_file (_tmp5_);
	_tmp7_ = _tmp6_;
	if (g_file_query_exists (_tmp7_, NULL)) {
		gchar* uri = NULL;
		AudienceObjectsVideo* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gboolean from_beginning = FALSE;
		const gchar* _tmp12_;
		GSettings* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gboolean _tmp16_;
		AudiencePlaybackManager* playback_manager = NULL;
		AudiencePlaybackManager* _tmp17_;
		AudiencePlaybackManager* _tmp18_;
		AudiencePlaybackManager* _tmp19_;
		AudiencePlaybackManager* _tmp20_;
		AudienceObjectsVideo* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		AudienceWindow* window = NULL;
		AudienceApp* _tmp24_;
		AudienceApp* _tmp25_;
		AudienceWindow* _tmp26_;
		AudienceWindow* _tmp27_;
		AudienceWindow* _tmp28_;
		AudienceWindow* _tmp29_;
		const gchar* _tmp30_;
		GSettings* _tmp31_;
		_tmp8_ = video;
		_tmp9_ = audience_objects_video_get_video_file (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_uri (_tmp10_);
		uri = _tmp11_;
		_tmp12_ = uri;
		_tmp13_ = audience_settings;
		_tmp14_ = g_settings_get_string (_tmp13_, "current-video");
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strcmp0 (_tmp12_, _tmp15_) != 0;
		_g_free0 (_tmp15_);
		from_beginning = _tmp16_;
		_tmp17_ = audience_playback_manager_get_default ();
		_tmp18_ = _g_object_ref0 (_tmp17_);
		playback_manager = _tmp18_;
		_tmp19_ = playback_manager;
		g_signal_emit_by_name (_tmp19_, "clear-playlist", TRUE);
		_tmp20_ = playback_manager;
		_tmp21_ = video;
		_tmp22_ = audience_objects_video_get_video_file (_tmp21_);
		_tmp23_ = _tmp22_;
		audience_playback_manager_append_to_playlist (_tmp20_, _tmp23_);
		_tmp24_ = audience_app_get_instance ();
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_->mainwindow;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp25_);
		window = _tmp28_;
		_tmp29_ = window;
		_tmp30_ = uri;
		audience_window_play_file (_tmp29_, _tmp30_, AUDIENCE_WINDOW_NAVIGATION_PAGE_EPISODES, from_beginning);
		_tmp31_ = audience_settings;
		if (g_settings_get_boolean (_tmp31_, "autoqueue-next")) {
			guint played_index = 0U;
			GListStore* _tmp32_;
			AudienceLibraryItem* _tmp33_;
			guint _tmp34_ = 0U;
			_tmp32_ = self->priv->items;
			_tmp33_ = selected;
			g_list_store_find (_tmp32_, (GObject*) _tmp33_, &_tmp34_);
			played_index = _tmp34_;
			{
				guint _tmp35_;
				gboolean _tmp36_ = FALSE;
				_tmp35_ = played_index;
				played_index = _tmp35_ + 1;
				_tmp36_ = TRUE;
				while (TRUE) {
					GListStore* _tmp38_;
					AudienceLibraryItem* library_item = NULL;
					GListStore* _tmp39_;
					GObject* _tmp40_;
					AudiencePlaybackManager* _tmp41_;
					AudienceLibraryItem* _tmp42_;
					AudienceObjectsVideo* _tmp43_;
					AudienceObjectsVideo* _tmp44_;
					GFile* _tmp45_;
					GFile* _tmp46_;
					if (!_tmp36_) {
						guint _tmp37_;
						_tmp37_ = played_index;
						played_index = _tmp37_ + 1;
					}
					_tmp36_ = FALSE;
					_tmp38_ = self->priv->items;
					if (!(played_index < g_list_model_get_n_items ((GListModel*) _tmp38_))) {
						break;
					}
					_tmp39_ = self->priv->items;
					_tmp40_ = g_list_model_get_item ((GListModel*) _tmp39_, played_index);
					library_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
					_tmp41_ = playback_manager;
					_tmp42_ = library_item;
					_tmp43_ = audience_library_item_get_video (_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = audience_objects_video_get_video_file (_tmp44_);
					_tmp46_ = _tmp45_;
					audience_playback_manager_append_to_playlist (_tmp41_, _tmp46_);
					_g_object_unref0 (library_item);
				}
			}
		}
		_g_object_unref0 (window);
		_g_object_unref0 (playback_manager);
		_g_free0 (uri);
	}
	_g_object_unref0 (video);
	_g_object_unref0 (selected);
}

static void
audience_episodes_page_filter (AudienceEpisodesPage* self)
{
	GtkFlowBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->view_episodes;
	gtk_flow_box_invalidate_filter (_tmp0_);
	if (!audience_episodes_page_has_child (self)) {
		GraniteWidgetsAlertView* _tmp1_;
		GtkSearchEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GraniteWidgetsAlertView* _tmp7_;
		_tmp1_ = self->priv->alert_view;
		_tmp2_ = self->priv->search_entry;
		_tmp3_ = gtk_entry_get_text ((GtkEntry*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf (_ ("No Results for “%s”"), _tmp4_);
		_tmp6_ = _tmp5_;
		granite_widgets_alert_view_set_title (_tmp1_, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->alert_view;
		gtk_widget_show ((GtkWidget*) _tmp7_);
	} else {
		GraniteWidgetsAlertView* _tmp8_;
		_tmp8_ = self->priv->alert_view;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
audience_episodes_page_episodes_filter_func (AudienceEpisodesPage* self,
                                             GtkFlowBoxChild* child)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar** filter_elements = NULL;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint filter_elements_length1;
	gint _filter_elements_size_;
	gchar* video_title = NULL;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == 0) {
		result = TRUE;
		return result;
	}
	_tmp5_ = self->priv->search_entry;
	_tmp6_ = gtk_entry_get_text ((GtkEntry*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, " ", 0);
	filter_elements = _tmp9_;
	filter_elements_length1 = _vala_array_length (_tmp8_);
	_filter_elements_size_ = filter_elements_length1;
	_tmp10_ = audience_library_item_get_title (G_TYPE_CHECK_INSTANCE_CAST (child, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	video_title = _tmp10_;
	_tmp11_ = filter_elements;
	_tmp11__length1 = filter_elements_length1;
	{
		gchar** filter_element_collection = NULL;
		gint filter_element_collection_length1 = 0;
		gint _filter_element_collection_size_ = 0;
		gint filter_element_it = 0;
		filter_element_collection = _tmp11_;
		filter_element_collection_length1 = _tmp11__length1;
		for (filter_element_it = 0; filter_element_it < filter_element_collection_length1; filter_element_it = filter_element_it + 1) {
			gchar* _tmp12_;
			gchar* filter_element = NULL;
			_tmp12_ = g_strdup (filter_element_collection[filter_element_it]);
			filter_element = _tmp12_;
			{
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp13_ = video_title;
				_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) -1);
				_tmp15_ = _tmp14_;
				_tmp16_ = filter_element;
				_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
				_tmp18_ = _tmp17_;
				_tmp19_ = !string_contains (_tmp15_, _tmp18_);
				_g_free0 (_tmp18_);
				_g_free0 (_tmp15_);
				if (_tmp19_) {
					result = FALSE;
					_g_free0 (filter_element);
					_g_free0 (video_title);
					filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (filter_element);
			}
		}
	}
	result = TRUE;
	_g_free0 (video_title);
	filter_elements = (_vala_array_free (filter_elements, filter_elements_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
audience_episodes_page_episode_sort_func (AudienceEpisodesPage* self,
                                          GObject* item1,
                                          GObject* item2)
{
	AudienceLibraryItem* library_item1 = NULL;
	AudienceLibraryItem* _tmp0_;
	AudienceLibraryItem* library_item2 = NULL;
	AudienceLibraryItem* _tmp1_;
	gboolean _tmp2_ = FALSE;
	AudienceLibraryItem* _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (item1 != NULL, 0);
	g_return_val_if_fail (item2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item1, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	library_item1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item2, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	library_item2 = _tmp1_;
	_tmp3_ = library_item1;
	if (_tmp3_ != NULL) {
		AudienceLibraryItem* _tmp4_;
		_tmp4_ = library_item2;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		AudienceLibraryItem* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		gpointer _tmp8_;
		AudienceObjectsVideo* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		AudienceLibraryItem* _tmp12_;
		GeeArrayList* _tmp13_;
		GeeArrayList* _tmp14_;
		gpointer _tmp15_;
		AudienceObjectsVideo* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		_tmp5_ = library_item1;
		_tmp6_ = audience_library_item_get_episodes (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = gee_list_first ((GeeList*) _tmp7_);
		_tmp9_ = (AudienceObjectsVideo*) _tmp8_;
		_tmp10_ = audience_objects_video_get_file (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = library_item2;
		_tmp13_ = audience_library_item_get_episodes (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_list_first ((GeeList*) _tmp14_);
		_tmp16_ = (AudienceObjectsVideo*) _tmp15_;
		_tmp17_ = audience_objects_video_get_file (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_utf8_collate (_tmp11_, _tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (_tmp9_);
		result = _tmp19_;
		_g_object_unref0 (library_item2);
		_g_object_unref0 (library_item1);
		return result;
	}
	result = 0;
	_g_object_unref0 (library_item2);
	_g_object_unref0 (library_item1);
	return result;
}

static void
audience_episodes_page_add_item (AudienceEpisodesPage* self,
                                 AudienceObjectsVideo* episode)
{
	GListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (episode != NULL);
	_tmp0_ = self->priv->items;
	if (g_list_model_get_n_items ((GListModel*) _tmp0_) > ((guint) 0)) {
		AudienceLibraryItem* first = NULL;
		GListStore* _tmp1_;
		GObject* _tmp2_;
		gboolean _tmp3_ = FALSE;
		AudienceLibraryItem* _tmp4_;
		_tmp1_ = self->priv->items;
		_tmp2_ = g_list_model_get_item ((GListModel*) _tmp1_, (guint) 0);
		first = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
		_tmp4_ = first;
		if (_tmp4_ != NULL) {
			AudienceLibraryItem* _tmp5_;
			GeeArrayList* _tmp6_;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			AudienceObjectsVideo* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp5_ = first;
			_tmp6_ = audience_library_item_get_episodes (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_list_first ((GeeList*) _tmp7_);
			_tmp9_ = (AudienceObjectsVideo*) _tmp8_;
			_tmp10_ = audience_objects_video_get_video_file (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_file_get_parent (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_file_get_path (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = audience_objects_video_get_video_file (episode);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_file_get_parent (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_file_get_path (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp3_ = g_strcmp0 (_tmp15_, _tmp21_) == 0;
			_g_free0 (_tmp21_);
			_g_object_unref0 (_tmp19_);
			_g_free0 (_tmp15_);
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp9_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GListStore* _tmp22_;
			AudienceLibraryItem* _tmp23_;
			AudienceLibraryItem* _tmp24_;
			_tmp22_ = self->priv->items;
			_tmp23_ = audience_library_item_new (episode, AUDIENCE_LIBRARY_ITEM_STYLE_ROW);
			g_object_ref_sink (_tmp23_);
			_tmp24_ = _tmp23_;
			g_list_store_insert_sorted (_tmp22_, (GObject*) _tmp24_, _audience_episodes_page_episode_sort_func_gcompare_data_func, self);
			_g_object_unref0 (_tmp24_);
		}
		_g_object_unref0 (first);
	}
}

static void
audience_episodes_page_remove_item_from_path_data_free (gpointer _data)
{
	AudienceEpisodesPageRemoveItemFromPathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceEpisodesPageRemoveItemFromPathData, _data_);
}

static void
audience_episodes_page_remove_item_from_path (AudienceEpisodesPage* self,
                                              const gchar* path,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	AudienceEpisodesPageRemoveItemFromPathData* _data_;
	AudienceEpisodesPage* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (AudienceEpisodesPageRemoveItemFromPathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_episodes_page_remove_item_from_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	audience_episodes_page_remove_item_from_path_co (_data_);
}

static void
audience_episodes_page_remove_item_from_path_finish (AudienceEpisodesPage* self,
                                                     GAsyncResult* _res_)
{
	AudienceEpisodesPageRemoveItemFromPathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
audience_episodes_page_remove_item_from_path_co (AudienceEpisodesPageRemoveItemFromPathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->i = 0;
		{
			_data_->_tmp0_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp0_) {
					_data_->_tmp1_ = _data_->i;
					_data_->i = _data_->_tmp1_ + 1;
				}
				_data_->_tmp0_ = FALSE;
				_data_->_tmp2_ = _data_->self->priv->items;
				if (!(((guint) _data_->i) < g_list_model_get_n_items ((GListModel*) _data_->_tmp2_))) {
					break;
				}
				_data_->_tmp3_ = _data_->self->priv->items;
				_data_->_tmp4_ = g_list_model_get_item ((GListModel*) _data_->_tmp3_, (guint) _data_->i);
				_data_->item = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
				_data_->_tmp6_ = _data_->item;
				_data_->_tmp7_ = audience_library_item_get_episodes (_data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				_data_->_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				if (_data_->_tmp10_ == 0) {
					_data_->_tmp5_ = TRUE;
				} else {
					_data_->_tmp11_ = _data_->item;
					_data_->_tmp12_ = audience_library_item_get_episodes (_data_->_tmp11_);
					_data_->_tmp13_ = _data_->_tmp12_;
					_data_->_tmp14_ = gee_list_first ((GeeList*) _data_->_tmp13_);
					_data_->_tmp15_ = (AudienceObjectsVideo*) _data_->_tmp14_;
					_data_->_tmp16_ = audience_objects_video_get_video_file (_data_->_tmp15_);
					_data_->_tmp17_ = _data_->_tmp16_;
					_data_->_tmp18_ = g_file_get_path (_data_->_tmp17_);
					_data_->_tmp19_ = _data_->_tmp18_;
					_data_->_tmp5_ = g_str_has_prefix (_data_->_tmp19_, _data_->path);
					_g_free0 (_data_->_tmp19_);
					_g_object_unref0 (_data_->_tmp15_);
				}
				if (_data_->_tmp5_) {
					_data_->_tmp20_ = _data_->self->priv->items;
					g_list_store_remove (_data_->_tmp20_, (guint) _data_->i);
				}
				_g_object_unref0 (_data_->item);
			}
		}
	}
	_data_->_tmp21_ = gtk_widget_get_ancestor ((GtkWidget*) _data_->self, hdy_deck_get_type ());
	_data_->_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, hdy_deck_get_type (), HdyDeck));
	_data_->deck = _data_->_tmp22_;
	_data_->_tmp24_ = _data_->deck;
	_data_->_tmp25_ = hdy_deck_get_visible_child (_data_->_tmp24_);
	_data_->_tmp26_ = _data_->_tmp25_;
	if (_data_->_tmp26_ == G_TYPE_CHECK_INSTANCE_CAST (_data_->self, gtk_widget_get_type (), GtkWidget)) {
		_data_->_tmp27_ = _data_->self->priv->items;
		_data_->_tmp23_ = g_list_model_get_n_items ((GListModel*) _data_->_tmp27_) == ((guint) 0);
	} else {
		_data_->_tmp23_ = FALSE;
	}
	if (_data_->_tmp23_) {
		_data_->_tmp28_ = _data_->deck;
		hdy_deck_navigate (_data_->_tmp28_, HDY_NAVIGATION_DIRECTION_BACK);
	}
	_g_object_unref0 (_data_->deck);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
audience_episodes_page_has_child (AudienceEpisodesPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GListStore* _tmp2_;
				AudienceLibraryItem* item = NULL;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				AudienceLibraryItem* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->items;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp2_))) {
					break;
				}
				_tmp3_ = self->priv->items;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem);
				_tmp5_ = item;
				if (gtk_widget_get_child_visible ((GtkWidget*) _tmp5_)) {
					result = TRUE;
					_g_object_unref0 (item);
					return result;
				}
				_g_object_unref0 (item);
			}
		}
	}
	result = FALSE;
	return result;
}

AudienceEpisodesPage*
audience_episodes_page_construct (GType object_type)
{
	AudienceEpisodesPage * self = NULL;
	self = (AudienceEpisodesPage*) g_object_new (object_type, NULL);
	return self;
}

AudienceEpisodesPage*
audience_episodes_page_new (void)
{
	return audience_episodes_page_construct (AUDIENCE_TYPE_EPISODES_PAGE);
}

GtkImage*
audience_episodes_page_get_poster (AudienceEpisodesPage* self)
{
	GtkImage* result;
	GtkImage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_poster;
	result = _tmp0_;
	return result;
}

static void
audience_episodes_page_set_poster (AudienceEpisodesPage* self,
                                   GtkImage* value)
{
	GtkImage* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_episodes_page_get_poster (self);
	if (old_value != value) {
		GtkImage* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_poster);
		self->priv->_poster = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_episodes_page_properties[AUDIENCE_EPISODES_PAGE_POSTER_PROPERTY]);
	}
}

static gboolean
_audience_episodes_page_episodes_filter_func_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                                       gpointer self)
{
	gboolean result;
	result = audience_episodes_page_episodes_filter_func ((AudienceEpisodesPage*) self, child);
	return result;
}

static GtkWidget*
_audience_episodes_page___lambda78_ (AudienceEpisodesPage* self,
                                     GObject* item)
{
	AudienceLibraryItem* library_item = NULL;
	AudienceLibraryItem* _tmp0_;
	AudienceLibraryItem* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, AUDIENCE_TYPE_LIBRARY_ITEM, AudienceLibraryItem));
	library_item = _tmp0_;
	_tmp1_ = library_item;
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
	result = (GtkWidget*) library_item;
	return result;
}

static GtkWidget*
__audience_episodes_page___lambda78__gtk_flow_box_create_widget_func (gpointer item,
                                                                      gpointer self)
{
	GtkWidget* result;
	result = _audience_episodes_page___lambda78_ ((AudienceEpisodesPage*) self, item);
	return result;
}

static void
_audience_episodes_page___lambda79_ (AudienceEpisodesPage* self)
{
	GtkWidget* _tmp0_;
	_tmp0_ = gtk_widget_get_ancestor ((GtkWidget*) self, hdy_deck_get_type ());
	hdy_deck_navigate (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, hdy_deck_get_type (), HdyDeck), HDY_NAVIGATION_DIRECTION_BACK);
}

static void
__audience_episodes_page___lambda79__gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	_audience_episodes_page___lambda79_ ((AudienceEpisodesPage*) self);
}

static void
_audience_episodes_page_play_video_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                 GtkFlowBoxChild* child,
                                                                 gpointer self)
{
	audience_episodes_page_play_video ((AudienceEpisodesPage*) self, child);
}

static void
_audience_episodes_page_remove_item_from_path_audience_services_library_manager_video_file_deleted (AudienceServicesLibraryManager* _sender,
                                                                                                    const gchar* path,
                                                                                                    gpointer self)
{
	audience_episodes_page_remove_item_from_path ((AudienceEpisodesPage*) self, path, NULL, NULL);
}

static void
_audience_episodes_page_add_item_audience_services_library_manager_video_file_detected (AudienceServicesLibraryManager* _sender,
                                                                                        AudienceObjectsVideo* video,
                                                                                        gpointer self)
{
	audience_episodes_page_add_item ((AudienceEpisodesPage*) self, video);
}

static void
_audience_episodes_page_filter_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                gpointer self)
{
	audience_episodes_page_filter ((AudienceEpisodesPage*) self);
}

static gboolean
_audience_episodes_page___lambda80_ (AudienceEpisodesPage* self,
                                     GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == GDK_KEY_Escape) {
		GtkSearchEntry* _tmp0_;
		_tmp0_ = self->priv->search_entry;
		gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
__audience_episodes_page___lambda80__gtk_widget_key_press_event (GtkWidget* _sender,
                                                                 GdkEventKey* event,
                                                                 gpointer self)
{
	gboolean result;
	result = _audience_episodes_page___lambda80_ ((AudienceEpisodesPage*) self, event);
	return result;
}

static GObject *
audience_episodes_page_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceEpisodesPage * self;
	GListStore* _tmp0_;
	GtkButton* navigation_button = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkButton* _tmp2_;
	GtkStyleContext* _tmp3_;
	gchar* _tmp4_;
	GtkSearchEntry* _tmp5_ = NULL;
	GraniteModeSwitch* autoqueue_next = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GraniteModeSwitch* _tmp8_ = NULL;
	GSettings* _tmp9_;
	GraniteModeSwitch* _tmp10_;
	HdyHeaderBar* _tmp11_ = NULL;
	HdyHeaderBar* _tmp12_;
	GtkButton* _tmp13_;
	HdyHeaderBar* _tmp14_;
	GtkSearchEntry* _tmp15_;
	HdyHeaderBar* _tmp16_;
	GraniteModeSwitch* _tmp17_;
	HdyHeaderBar* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkImage* _tmp20_ = NULL;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkStyleContext* _tmp23_;
	GtkFlowBox* _tmp24_ = NULL;
	GtkFlowBox* _tmp25_;
	GtkFlowBox* _tmp26_;
	GListStore* _tmp27_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkFlowBox* _tmp28_;
	GtkWidget* _tmp29_;
	GtkScrolledWindow* _tmp30_ = NULL;
	GraniteWidgetsAlertView* _tmp31_;
	GraniteWidgetsAlertView* _tmp32_;
	GtkStyleContext* _tmp33_;
	GraniteWidgetsAlertView* _tmp34_;
	GraniteWidgetsAlertView* _tmp35_;
	GraniteWidgetsAlertView* _tmp36_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp37_ = NULL;
	GtkGrid* _tmp38_;
	GtkImage* _tmp39_;
	GtkGrid* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkGrid* _tmp42_;
	GraniteWidgetsAlertView* _tmp43_;
	HdyHeaderBar* _tmp44_;
	GtkGrid* _tmp45_;
	GtkButton* _tmp46_;
	GtkFlowBox* _tmp47_;
	AudienceServicesLibraryManager* manager = NULL;
	AudienceServicesLibraryManager* _tmp48_;
	AudienceServicesLibraryManager* _tmp49_;
	AudienceServicesLibraryManager* _tmp50_;
	GtkSearchEntry* _tmp51_;
	GtkSearchEntry* _tmp52_;
	parent_class = G_OBJECT_CLASS (audience_episodes_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage);
	_tmp0_ = g_list_store_new (AUDIENCE_TYPE_LIBRARY_ITEM);
	_g_object_unref0 (self->priv->items);
	self->priv->items = _tmp0_;
	_g_object_unref0 (self->priv->poster_source);
	self->priv->poster_source = NULL;
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("Library"));
	gtk_widget_set_valign ((GtkWidget*) _tmp1_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp1_);
	navigation_button = _tmp1_;
	_tmp2_ = navigation_button;
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) _tmp2_);
	gtk_style_context_add_class (_tmp3_, GRANITE_STYLE_CLASS_BACK_BUTTON);
	_tmp4_ = g_strdup (_ ("Search Videos"));
	_tmp5_ = (GtkSearchEntry*) gtk_search_entry_new ();
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp5_;
	_tmp6_ = g_strdup (_ ("Play one video"));
	_tmp7_ = g_strdup (_ ("Automatically play next videos"));
	_tmp8_ = granite_mode_switch_new_from_icon_name ("media-playlist-repeat-one-symbolic", "media-playlist-consecutive-symbolic");
	granite_mode_switch_set_primary_icon_tooltip_text (_tmp8_, _tmp6_);
	_g_free0 (_tmp6_);
	granite_mode_switch_set_secondary_icon_tooltip_text (_tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp8_);
	autoqueue_next = _tmp8_;
	_tmp9_ = audience_settings;
	_tmp10_ = autoqueue_next;
	g_settings_bind (_tmp9_, "autoqueue-next", (GObject*) _tmp10_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_show_close_button (_tmp11_, TRUE);
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->header_bar);
	self->priv->header_bar = _tmp11_;
	_tmp12_ = self->priv->header_bar;
	_tmp13_ = navigation_button;
	hdy_header_bar_pack_start (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->header_bar;
	_tmp15_ = self->priv->search_entry;
	hdy_header_bar_pack_end (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->header_bar;
	_tmp17_ = autoqueue_next;
	hdy_header_bar_pack_end (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->header_bar;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	gtk_style_context_add_class (_tmp19_, GTK_STYLE_CLASS_FLAT);
	_tmp20_ = (GtkImage*) gtk_image_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp20_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 24);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp20_, 24);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp20_, 0);
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	audience_episodes_page_set_poster (self, _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = self->priv->_poster;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	gtk_style_context_add_class (_tmp23_, GRANITE_STYLE_CLASS_CARD);
	_tmp24_ = (GtkFlowBox*) gtk_flow_box_new ();
	gtk_flow_box_set_homogeneous (_tmp24_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp24_, 24);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp24_, 24);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp24_, 24);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp24_, 24);
	gtk_flow_box_set_max_children_per_line (_tmp24_, (guint) 1);
	gtk_flow_box_set_selection_mode (_tmp24_, GTK_SELECTION_NONE);
	gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->view_episodes);
	self->priv->view_episodes = _tmp24_;
	_tmp25_ = self->priv->view_episodes;
	gtk_flow_box_set_filter_func (_tmp25_, _audience_episodes_page_episodes_filter_func_gtk_flow_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp26_ = self->priv->view_episodes;
	_tmp27_ = self->priv->items;
	gtk_flow_box_bind_model (_tmp26_, (GListModel*) _tmp27_, __audience_episodes_page___lambda78__gtk_flow_box_create_widget_func, g_object_ref (self), g_object_unref);
	_tmp28_ = self->priv->view_episodes;
	_tmp29_ = _g_object_ref0 ((GtkWidget*) _tmp28_);
	_tmp30_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp30_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp30_, TRUE);
	g_object_set ((GtkContainer*) _tmp30_, "child", _tmp29_, NULL);
	_g_object_unref0 (_tmp29_);
	g_object_ref_sink (_tmp30_);
	scrolled_window = _tmp30_;
	_tmp31_ = granite_widgets_alert_view_new ("", _ ("Try changing search terms."), "edit-find-symbolic");
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->alert_view);
	self->priv->alert_view = _tmp31_;
	_tmp32_ = self->priv->alert_view;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	gtk_style_context_remove_class (_tmp33_, GTK_STYLE_CLASS_VIEW);
	_tmp34_ = self->priv->alert_view;
	gtk_widget_show_all ((GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->alert_view;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp35_, TRUE);
	_tmp36_ = self->priv->alert_view;
	gtk_widget_hide ((GtkWidget*) _tmp36_);
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp37_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp37_, TRUE);
	g_object_ref_sink (_tmp37_);
	grid = _tmp37_;
	_tmp38_ = grid;
	_tmp39_ = self->priv->_poster;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp39_, 0, 1, 1, 1);
	_tmp40_ = grid;
	_tmp41_ = scrolled_window;
	gtk_grid_attach (_tmp40_, (GtkWidget*) _tmp41_, 1, 1, 1, 1);
	_tmp42_ = grid;
	_tmp43_ = self->priv->alert_view;
	gtk_grid_attach (_tmp42_, (GtkWidget*) _tmp43_, 1, 1, 1, 1);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp44_ = self->priv->header_bar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp44_);
	_tmp45_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp45_);
	_tmp46_ = navigation_button;
	g_signal_connect_object (_tmp46_, "clicked", (GCallback) __audience_episodes_page___lambda79__gtk_button_clicked, self, 0);
	_tmp47_ = self->priv->view_episodes;
	g_signal_connect_object (_tmp47_, "child-activated", (GCallback) _audience_episodes_page_play_video_gtk_flow_box_child_activated, self, 0);
	_tmp48_ = audience_services_library_manager_get_instance ();
	manager = _tmp48_;
	_tmp49_ = manager;
	g_signal_connect_object (_tmp49_, "video-file-deleted", (GCallback) _audience_episodes_page_remove_item_from_path_audience_services_library_manager_video_file_deleted, self, 0);
	_tmp50_ = manager;
	g_signal_connect_object (_tmp50_, "video-file-detected", (GCallback) _audience_episodes_page_add_item_audience_services_library_manager_video_file_detected, self, 0);
	_tmp51_ = self->priv->search_entry;
	g_signal_connect_object (_tmp51_, "search-changed", (GCallback) _audience_episodes_page_filter_gtk_search_entry_search_changed, self, 0);
	_tmp52_ = self->priv->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp52_, "key-press-event", (GCallback) __audience_episodes_page___lambda80__gtk_widget_key_press_event, self, 0);
	_g_object_unref0 (manager);
	_g_object_unref0 (grid);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (autoqueue_next);
	_g_object_unref0 (navigation_button);
	return obj;
}

static void
audience_episodes_page_class_init (AudienceEpisodesPageClass * klass,
                                   gpointer klass_data)
{
	audience_episodes_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceEpisodesPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_episodes_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_audience_episodes_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = audience_episodes_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_episodes_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_EPISODES_PAGE_POSTER_PROPERTY, audience_episodes_page_properties[AUDIENCE_EPISODES_PAGE_POSTER_PROPERTY] = g_param_spec_object ("poster", "poster", "poster", gtk_image_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
audience_episodes_page_instance_init (AudienceEpisodesPage * self,
                                      gpointer klass)
{
	self->priv = audience_episodes_page_get_instance_private (self);
}

static void
audience_episodes_page_finalize (GObject * obj)
{
	AudienceEpisodesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage);
	_g_object_unref0 (self->priv->_poster);
	_g_object_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->header_bar);
	_g_object_unref0 (self->priv->view_episodes);
	_g_object_unref0 (self->priv->alert_view);
	_g_object_unref0 (self->priv->poster_source);
	G_OBJECT_CLASS (audience_episodes_page_parent_class)->finalize (obj);
}

static GType
audience_episodes_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceEpisodesPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_episodes_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceEpisodesPage), 0, (GInstanceInitFunc) audience_episodes_page_instance_init, NULL };
	GType audience_episodes_page_type_id;
	audience_episodes_page_type_id = g_type_register_static (gtk_box_get_type (), "AudienceEpisodesPage", &g_define_type_info, 0);
	AudienceEpisodesPage_private_offset = g_type_add_instance_private (audience_episodes_page_type_id, sizeof (AudienceEpisodesPagePrivate));
	return audience_episodes_page_type_id;
}

GType
audience_episodes_page_get_type (void)
{
	static volatile gsize audience_episodes_page_type_id__once = 0;
	if (g_once_init_enter (&audience_episodes_page_type_id__once)) {
		GType audience_episodes_page_type_id;
		audience_episodes_page_type_id = audience_episodes_page_get_type_once ();
		g_once_init_leave (&audience_episodes_page_type_id__once, audience_episodes_page_type_id);
	}
	return audience_episodes_page_type_id__once;
}

static void
_vala_audience_episodes_page_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	AudienceEpisodesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage);
	switch (property_id) {
		case AUDIENCE_EPISODES_PAGE_POSTER_PROPERTY:
		g_value_set_object (value, audience_episodes_page_get_poster (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_audience_episodes_page_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	AudienceEpisodesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_TYPE_EPISODES_PAGE, AudienceEpisodesPage);
	switch (property_id) {
		case AUDIENCE_EPISODES_PAGE_POSTER_PROPERTY:
		audience_episodes_page_set_poster (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

