/* LibraryManager.c generated by valac 0.56.17, the Vala compiler
 * generated from LibraryManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016-2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>

#define AUDIENCE_SERVICES_POSTER_WIDTH 170
#define AUDIENCE_SERVICES_POSTER_HEIGHT 240
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;
typedef struct _AudienceServicesLibraryManagerPrivate AudienceServicesLibraryManagerPrivate;

#define AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER (audience_services_dbus_thumbnailer_get_type ())
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailer))
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailerClass))
#define AUDIENCE_SERVICES_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER))
#define AUDIENCE_SERVICES_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER))
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailerClass))

typedef struct _AudienceServicesDbusThumbnailer AudienceServicesDbusThumbnailer;
typedef struct _AudienceServicesDbusThumbnailerClass AudienceServicesDbusThumbnailerClass;

#define AUDIENCE_SERVICES_TYPE_DIRECTORY_MONITORING (audience_services_directory_monitoring_get_type ())
#define AUDIENCE_SERVICES_DIRECTORY_MONITORING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_DIRECTORY_MONITORING, AudienceServicesDirectoryMonitoring))
#define AUDIENCE_SERVICES_DIRECTORY_MONITORING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_DIRECTORY_MONITORING, AudienceServicesDirectoryMonitoringClass))
#define AUDIENCE_SERVICES_IS_DIRECTORY_MONITORING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_DIRECTORY_MONITORING))
#define AUDIENCE_SERVICES_IS_DIRECTORY_MONITORING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_DIRECTORY_MONITORING))
#define AUDIENCE_SERVICES_DIRECTORY_MONITORING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_DIRECTORY_MONITORING, AudienceServicesDirectoryMonitoringClass))

typedef struct _AudienceServicesDirectoryMonitoring AudienceServicesDirectoryMonitoring;
typedef struct _AudienceServicesDirectoryMonitoringClass AudienceServicesDirectoryMonitoringClass;
enum  {
	AUDIENCE_SERVICES_LIBRARY_MANAGER_0_PROPERTY,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_REGEX_YEAR_PROPERTY,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_THUMBLER_PROPERTY,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_HAS_ITEMS_PROPERTY,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_IS_SCANNING_PROPERTY,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_NUM_PROPERTIES
};
static GParamSpec* audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AudienceServicesLibraryManagerDetectVideoFilesData AudienceServicesLibraryManagerDetectVideoFilesData;

#define AUDIENCE_OBJECTS_TYPE_VIDEO (audience_objects_video_get_type ())
#define AUDIENCE_OBJECTS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo))
#define AUDIENCE_OBJECTS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))
#define AUDIENCE_OBJECTS_IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))

typedef struct _AudienceObjectsVideo AudienceObjectsVideo;
typedef struct _AudienceObjectsVideoClass AudienceObjectsVideoClass;
typedef struct _AudienceServicesLibraryManagerClearCacheData AudienceServicesLibraryManagerClearCacheData;
typedef struct _Block6Data Block6Data;

#define AUDIENCE_TYPE_APP (audience_app_get_type ())
#define AUDIENCE_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_APP, AudienceApp))
#define AUDIENCE_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_APP, AudienceAppClass))
#define AUDIENCE_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_APP))
#define AUDIENCE_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_APP))
#define AUDIENCE_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_APP, AudienceAppClass))

typedef struct _AudienceApp AudienceApp;
typedef struct _AudienceAppClass AudienceAppClass;
typedef struct _AudienceServicesLibraryManagerClearUnusedCacheFilesData AudienceServicesLibraryManagerClearUnusedCacheFilesData;
enum  {
	AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_FILE_DETECTED_SIGNAL,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_FILE_DELETED_SIGNAL,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_MOVED_TO_TRASH_SIGNAL,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_FINISHED_SIGNAL,
	AUDIENCE_SERVICES_LIBRARY_MANAGER_NUM_SIGNALS
};
static guint audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_NUM_SIGNALS] = {0};

struct _AudienceServicesLibraryManager {
	GObject parent_instance;
	AudienceServicesLibraryManagerPrivate * priv;
};

struct _AudienceServicesLibraryManagerClass {
	GObjectClass parent_class;
};

struct _AudienceServicesLibraryManagerPrivate {
	GRegex* _regex_year;
	AudienceServicesDbusThumbnailer* _thumbler;
	gboolean _has_items;
	gboolean _is_scanning;
	GeeArrayList* poster_hash;
	GeeArrayList* monitoring_directories;
	GeeQueue* unchecked_directories;
	GeeArrayList* trashed_files;
};

struct _AudienceServicesLibraryManagerDetectVideoFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceServicesLibraryManager* self;
	GeeQueue* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* source;
	GeeQueue* _tmp3_;
	gpointer _tmp4_;
	GFile* directory;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFileEnumerator* children;
	GFile* _tmp7_;
	GFileEnumerator* _tmp8_;
	gboolean videos_found;
	GFileInfo* file_info;
	GFileInfo* _tmp9_;
	GFileEnumerator* _tmp10_;
	GFileInfo* _tmp11_;
	GFileInfo* _tmp12_;
	GFileInfo* _tmp13_;
	GFileInfo* _tmp14_;
	GeeQueue* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GFileInfo* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GFileInfo* _tmp23_;
	GFileInfo* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GFile* _tmp27_;
	GError* e;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError* _inner_error0_;
};

struct _AudienceServicesLibraryManagerClearCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceServicesLibraryManager* self;
	gchar* cache_file;
	GFile* file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	AudienceServicesLibraryManager* self;
	GFile* directory;
	gpointer _async_data_;
};

struct _AudienceServicesLibraryManagerClearUnusedCacheFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceServicesLibraryManager* self;
	Block6Data* _data6_;
	GApplication* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
};

static gint AudienceServicesLibraryManager_private_offset;
static gpointer audience_services_library_manager_parent_class = NULL;
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_instance;
AudienceServicesLibraryManager* audience_services_library_manager_instance = NULL;

VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN GType audience_services_dbus_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesDbusThumbnailer, g_object_unref)
VALA_EXTERN GType audience_services_directory_monitoring_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesDirectoryMonitoring, g_object_unref)
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
static AudienceServicesLibraryManager* audience_services_library_manager_new (void);
static AudienceServicesLibraryManager* audience_services_library_manager_construct (GType object_type);
VALA_EXTERN void audience_services_library_manager_begin_scan (AudienceServicesLibraryManager* self);
VALA_EXTERN void audience_services_library_manager_detect_video_files (AudienceServicesLibraryManager* self,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN void audience_services_library_manager_detect_video_files_finish (AudienceServicesLibraryManager* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static void audience_services_library_manager_monitored_directory_changed (AudienceServicesLibraryManager* self,
                                                                    GFileMonitor* monitor,
                                                                    GFile* src,
                                                                    GFile* dest,
                                                                    GFileMonitorEvent event);
VALA_EXTERN const gchar* audience_services_directory_monitoring_get_path (AudienceServicesDirectoryMonitoring* self);
VALA_EXTERN GFileMonitor* audience_services_directory_monitoring_get_monitor (AudienceServicesDirectoryMonitoring* self);
VALA_EXTERN gboolean audience_services_library_manager_get_is_scanning (AudienceServicesLibraryManager* self);
static gboolean audience_services_library_manager_is_file_valid (AudienceServicesLibraryManager* self,
                                                          GFileInfo* file_info);
static void audience_services_library_manager_create_video_object (AudienceServicesLibraryManager* self,
                                                            GFileInfo* file_info,
                                                            const gchar* source,
                                                            const gchar* name);
static void audience_services_library_manager_monitor_directory (AudienceServicesLibraryManager* self,
                                                          const gchar* path,
                                                          GFile* directory);
VALA_EXTERN AudienceServicesDirectoryMonitoring* audience_services_directory_monitoring_new (const gchar* path,
                                                                                 GFileMonitor* monitor);
VALA_EXTERN AudienceServicesDirectoryMonitoring* audience_services_directory_monitoring_construct (GType object_type,
                                                                                       const gchar* path,
                                                                                       GFileMonitor* monitor);
static void _audience_services_library_manager_monitored_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                            GFile* file,
                                                                                            GFile* other_file,
                                                                                            GFileMonitorEvent event_type,
                                                                                            gpointer self);
static void audience_services_library_manager_detect_video_files_data_free (gpointer _data);
static gboolean audience_services_library_manager_detect_video_files_co (AudienceServicesLibraryManagerDetectVideoFilesData* _data_);
static void audience_services_library_manager_set_is_scanning (AudienceServicesLibraryManager* self,
                                                        gboolean value);
static gboolean _audience_services_library_manager_detect_video_files_co_gsource_func (gpointer self);
VALA_EXTERN GType audience_objects_video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsVideo, g_object_unref)
VALA_EXTERN AudienceObjectsVideo* audience_objects_video_new (const gchar* directory,
                                                  const gchar* file,
                                                  const gchar* mime_type);
VALA_EXTERN AudienceObjectsVideo* audience_objects_video_construct (GType object_type,
                                                        const gchar* directory,
                                                        const gchar* file,
                                                        const gchar* mime_type);
VALA_EXTERN const gchar* audience_objects_video_get_hash_file_poster (AudienceObjectsVideo* self);
VALA_EXTERN const gchar* audience_objects_video_get_hash_episode_poster (AudienceObjectsVideo* self);
static void audience_services_library_manager_set_has_items (AudienceServicesLibraryManager* self,
                                                      gboolean value);
static void audience_services_library_manager_clear_cache_data_free (gpointer _data);
VALA_EXTERN void audience_services_library_manager_clear_cache (AudienceServicesLibraryManager* self,
                                                    const gchar* cache_file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void audience_services_library_manager_clear_cache_finish (AudienceServicesLibraryManager* self,
                                                           GAsyncResult* _res_);
static gboolean audience_services_library_manager_clear_cache_co (AudienceServicesLibraryManagerClearCacheData* _data_);
static void audience_services_library_manager_clear_cache_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void audience_services_library_manager_clear_unused_cache_files_data_free (gpointer _data);
VALA_EXTERN void audience_services_library_manager_clear_unused_cache_files (AudienceServicesLibraryManager* self,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
VALA_EXTERN void audience_services_library_manager_clear_unused_cache_files_finish (AudienceServicesLibraryManager* self,
                                                                        GAsyncResult* _res_);
static gboolean audience_services_library_manager_clear_unused_cache_files_co (AudienceServicesLibraryManagerClearUnusedCacheFilesData* _data_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN GType audience_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceApp, g_object_unref)
VALA_EXTERN gchar* audience_app_get_cache_directory (AudienceApp* self);
static void __lambda5_ (Block6Data* _data6_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN void audience_services_library_manager_deleted_items (AudienceServicesLibraryManager* self,
                                                      const gchar* path);
VALA_EXTERN void audience_services_library_manager_undo_delete_item (AudienceServicesLibraryManager* self);
VALA_EXTERN GdkPixbuf* audience_services_library_manager_get_poster_from_file (AudienceServicesLibraryManager* self,
                                                                   const gchar* poster_path);
VALA_EXTERN GRegex* audience_services_library_manager_get_regex_year (AudienceServicesLibraryManager* self);
VALA_EXTERN void audience_services_library_manager_set_regex_year (AudienceServicesLibraryManager* self,
                                                       GRegex* value);
VALA_EXTERN AudienceServicesDbusThumbnailer* audience_services_library_manager_get_thumbler (AudienceServicesLibraryManager* self);
VALA_EXTERN void audience_services_library_manager_set_thumbler (AudienceServicesLibraryManager* self,
                                                     AudienceServicesDbusThumbnailer* value);
VALA_EXTERN gboolean audience_services_library_manager_get_has_items (AudienceServicesLibraryManager* self);
static GObject * audience_services_library_manager_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
VALA_EXTERN AudienceServicesDbusThumbnailer* audience_services_dbus_thumbnailer_new (void);
VALA_EXTERN AudienceServicesDbusThumbnailer* audience_services_dbus_thumbnailer_construct (GType object_type);
static void _audience_services_library_manager___lambda6_ (AudienceServicesLibraryManager* self);
static void __audience_services_library_manager___lambda6__audience_services_library_manager_finished (AudienceServicesLibraryManager* _sender,
                                                                                                gpointer self);
static void audience_services_library_manager_finalize (GObject * obj);
static GType audience_services_library_manager_get_type_once (void);
static void _vala_audience_services_library_manager_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_audience_services_library_manager_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);

static inline gpointer
audience_services_library_manager_get_instance_private (AudienceServicesLibraryManager* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceServicesLibraryManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AudienceServicesLibraryManager*
audience_services_library_manager_get_instance (void)
{
	AudienceServicesLibraryManager* _tmp0_;
	AudienceServicesLibraryManager* _tmp2_;
	AudienceServicesLibraryManager* _tmp3_;
	AudienceServicesLibraryManager* result;
	_tmp0_ = audience_services_library_manager_instance;
	if (_tmp0_ == NULL) {
		AudienceServicesLibraryManager* _tmp1_;
		_tmp1_ = audience_services_library_manager_new ();
		_g_object_unref0 (audience_services_library_manager_instance);
		audience_services_library_manager_instance = _tmp1_;
	}
	_tmp2_ = audience_services_library_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static AudienceServicesLibraryManager*
audience_services_library_manager_construct (GType object_type)
{
	AudienceServicesLibraryManager * self = NULL;
	self = (AudienceServicesLibraryManager*) g_object_new (object_type, NULL);
	return self;
}

static AudienceServicesLibraryManager*
audience_services_library_manager_new (void)
{
	return audience_services_library_manager_construct (AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER);
}

void
audience_services_library_manager_begin_scan (AudienceServicesLibraryManager* self)
{
	GeeQueue* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unchecked_directories;
	_tmp1_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	gee_queue_offer (_tmp0_, _tmp1_);
	audience_services_library_manager_detect_video_files (self, NULL, NULL);
}

static void
audience_services_library_manager_monitored_directory_changed (AudienceServicesLibraryManager* self,
                                                               GFileMonitor* monitor,
                                                               GFile* src,
                                                               GFile* dest,
                                                               GFileMonitorEvent event)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (src != NULL);
	if (event == G_FILE_MONITOR_EVENT_DELETED) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_file_get_path (src);
		_tmp1_ = _tmp0_;
		g_signal_emit (self, audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_FILE_DELETED_SIGNAL], 0, _tmp1_);
		_g_free0 (_tmp1_);
		{
			GeeArrayList* _item_list = NULL;
			GeeArrayList* _tmp2_;
			gint _item_size = 0;
			GeeArrayList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _item_index = 0;
			_tmp2_ = self->priv->monitoring_directories;
			_item_list = _tmp2_;
			_tmp3_ = _item_list;
			_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_item_size = _tmp5_;
			_item_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				AudienceServicesDirectoryMonitoring* item = NULL;
				GeeArrayList* _tmp8_;
				gpointer _tmp9_;
				AudienceServicesDirectoryMonitoring* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gboolean _tmp15_;
				_item_index = _item_index + 1;
				_tmp6_ = _item_index;
				_tmp7_ = _item_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _item_list;
				_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _item_index);
				item = (AudienceServicesDirectoryMonitoring*) _tmp9_;
				_tmp10_ = item;
				_tmp11_ = audience_services_directory_monitoring_get_path (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_file_get_path (src);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strcmp0 (_tmp12_, _tmp14_) == 0;
				_g_free0 (_tmp14_);
				if (_tmp15_) {
					AudienceServicesDirectoryMonitoring* _tmp16_;
					GFileMonitor* _tmp17_;
					GFileMonitor* _tmp18_;
					_tmp16_ = item;
					_tmp17_ = audience_services_directory_monitoring_get_monitor (_tmp16_);
					_tmp18_ = _tmp17_;
					g_file_monitor_cancel (_tmp18_);
				}
				_g_object_unref0 (item);
			}
		}
	} else {
		if (event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
			GFileInfo* file_info = NULL;
			GFileInfo* _tmp24_;
			{
				GFileInfo* _tmp19_ = NULL;
				GFileInfo* _tmp20_;
				GFileInfo* _tmp21_;
				_tmp20_ = g_file_query_info (src, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_TYPE, 0, NULL, &_inner_error0_);
				_tmp19_ = _tmp20_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp21_ = _tmp19_;
				_tmp19_ = NULL;
				_g_object_unref0 (file_info);
				file_info = _tmp21_;
				_g_object_unref0 (_tmp19_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp22_;
				const gchar* _tmp23_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp22_ = e;
				_tmp23_ = _tmp22_->message;
				g_warning ("LibraryManager.vala:91: %s", _tmp23_);
				_g_error_free0 (e);
				_g_object_unref0 (file_info);
				return;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_info);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp24_ = file_info;
			if (g_file_info_get_file_type (_tmp24_) == G_FILE_TYPE_DIRECTORY) {
				GeeQueue* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gboolean _tmp28_;
				_tmp25_ = self->priv->unchecked_directories;
				_tmp26_ = g_file_get_path (src);
				_tmp27_ = _tmp26_;
				gee_queue_offer (_tmp25_, _tmp27_);
				_g_free0 (_tmp27_);
				_tmp28_ = self->priv->_is_scanning;
				if (!_tmp28_) {
					audience_services_library_manager_detect_video_files (self, NULL, NULL);
				}
			} else {
				GFileInfo* _tmp29_;
				_tmp29_ = file_info;
				if (audience_services_library_manager_is_file_valid (self, _tmp29_)) {
					gchar* src_path = NULL;
					gchar* _tmp30_;
					GFileInfo* _tmp31_;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					const gchar* _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp30_ = g_file_get_path (src);
					src_path = _tmp30_;
					_tmp31_ = file_info;
					_tmp32_ = src_path;
					_tmp33_ = g_path_get_dirname (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = src_path;
					_tmp36_ = g_path_get_basename (_tmp35_);
					_tmp37_ = _tmp36_;
					audience_services_library_manager_create_video_object (self, _tmp31_, _tmp34_, _tmp37_);
					_g_free0 (_tmp37_);
					_g_free0 (_tmp34_);
					_g_free0 (src_path);
				}
			}
			_g_object_unref0 (file_info);
		}
	}
}

static void
_audience_services_library_manager_monitored_directory_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                                       GFile* file,
                                                                                       GFile* other_file,
                                                                                       GFileMonitorEvent event_type,
                                                                                       gpointer self)
{
	audience_services_library_manager_monitored_directory_changed ((AudienceServicesLibraryManager*) self, _sender, file, other_file, event_type);
}

static void
audience_services_library_manager_monitor_directory (AudienceServicesLibraryManager* self,
                                                     const gchar* path,
                                                     GFile* directory)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (directory != NULL);
	{
		GFileMonitor* _tmp0_ = NULL;
		GFileMonitor* _tmp1_;
		AudienceServicesDirectoryMonitoring* dir_monitor = NULL;
		AudienceServicesDirectoryMonitoring* _tmp2_;
		AudienceServicesDirectoryMonitoring* _tmp3_;
		GFileMonitor* _tmp4_;
		GFileMonitor* _tmp5_;
		GeeArrayList* _tmp6_;
		AudienceServicesDirectoryMonitoring* _tmp7_;
		_tmp1_ = g_file_monitor (directory, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = audience_services_directory_monitoring_new (path, _tmp0_);
		dir_monitor = _tmp2_;
		_tmp3_ = dir_monitor;
		_tmp4_ = audience_services_directory_monitoring_get_monitor (_tmp3_);
		_tmp5_ = _tmp4_;
		g_signal_connect_object (_tmp5_, "changed", (GCallback) _audience_services_library_manager_monitored_directory_changed_g_file_monitor_changed, self, 0);
		_tmp6_ = self->priv->monitoring_directories;
		_tmp7_ = dir_monitor;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
		_g_object_unref0 (dir_monitor);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("LibraryManager.vala:112: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
audience_services_library_manager_detect_video_files_data_free (gpointer _data)
{
	AudienceServicesLibraryManagerDetectVideoFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceServicesLibraryManagerDetectVideoFilesData, _data_);
}

void
audience_services_library_manager_detect_video_files (AudienceServicesLibraryManager* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	AudienceServicesLibraryManagerDetectVideoFilesData* _data_;
	AudienceServicesLibraryManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AudienceServicesLibraryManagerDetectVideoFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_services_library_manager_detect_video_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	audience_services_library_manager_detect_video_files_co (_data_);
}

void
audience_services_library_manager_detect_video_files_finish (AudienceServicesLibraryManager* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	AudienceServicesLibraryManagerDetectVideoFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
_audience_services_library_manager_detect_video_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = audience_services_library_manager_detect_video_files_co (self);
	return result;
}

static gboolean
audience_services_library_manager_detect_video_files_co (AudienceServicesLibraryManagerDetectVideoFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	audience_services_library_manager_set_is_scanning (_data_->self, TRUE);
	while (TRUE) {
		_data_->_tmp0_ = _data_->self->priv->unchecked_directories;
		_data_->_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		if (!(!_data_->_tmp2_)) {
			break;
		}
		_data_->_tmp3_ = _data_->self->priv->unchecked_directories;
		_data_->_tmp4_ = gee_queue_poll (_data_->_tmp3_);
		_data_->source = (gchar*) _data_->_tmp4_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _audience_services_library_manager_detect_video_files_co_gsource_func, _data_, NULL);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		{
			_data_->_tmp5_ = _data_->source;
			_data_->_tmp6_ = g_file_new_for_path (_data_->_tmp5_);
			_data_->directory = _data_->_tmp6_;
			_data_->_tmp7_ = _data_->directory;
			_data_->_tmp8_ = g_file_enumerate_children (_data_->_tmp7_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN, 0, NULL, &_data_->_inner_error0_);
			_data_->children = _data_->_tmp8_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->directory);
				goto __catch0_g_error;
			}
			_data_->videos_found = FALSE;
			while (TRUE) {
				_data_->_tmp10_ = _data_->children;
				_data_->_tmp11_ = g_file_enumerator_next_file (_data_->_tmp10_, NULL, &_data_->_inner_error0_);
				_data_->_tmp9_ = _data_->_tmp11_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->file_info);
					_g_object_unref0 (_data_->children);
					_g_object_unref0 (_data_->directory);
					goto __catch0_g_error;
				}
				_data_->_tmp12_ = _data_->_tmp9_;
				_data_->_tmp9_ = NULL;
				_g_object_unref0 (_data_->file_info);
				_data_->file_info = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->file_info;
				if (!(_data_->_tmp13_ != NULL)) {
					_g_object_unref0 (_data_->_tmp9_);
					break;
				}
				_data_->_tmp14_ = _data_->file_info;
				if (g_file_info_get_file_type (_data_->_tmp14_) == G_FILE_TYPE_DIRECTORY) {
					_data_->_tmp15_ = _data_->self->priv->unchecked_directories;
					_data_->_tmp16_ = _data_->source;
					_data_->_tmp17_ = g_strconcat (_data_->_tmp16_, "/", NULL);
					_data_->_tmp18_ = _data_->_tmp17_;
					_data_->_tmp19_ = _data_->file_info;
					_data_->_tmp20_ = g_file_info_get_name (_data_->_tmp19_);
					_data_->_tmp21_ = g_strconcat (_data_->_tmp18_, _data_->_tmp20_, NULL);
					_data_->_tmp22_ = _data_->_tmp21_;
					gee_queue_offer (_data_->_tmp15_, _data_->_tmp22_);
					_g_free0 (_data_->_tmp22_);
					_g_free0 (_data_->_tmp18_);
					_g_object_unref0 (_data_->_tmp9_);
					continue;
				}
				_data_->_tmp23_ = _data_->file_info;
				if (audience_services_library_manager_is_file_valid (_data_->self, _data_->_tmp23_)) {
					_data_->_tmp24_ = _data_->file_info;
					_data_->_tmp25_ = _data_->source;
					audience_services_library_manager_create_video_object (_data_->self, _data_->_tmp24_, _data_->_tmp25_, "");
					_data_->videos_found = TRUE;
				}
				_g_object_unref0 (_data_->_tmp9_);
			}
			if (_data_->videos_found) {
				_data_->_tmp26_ = _data_->source;
				_data_->_tmp27_ = _data_->directory;
				audience_services_library_manager_monitor_directory (_data_->self, _data_->_tmp26_, _data_->_tmp27_);
			}
			_g_object_unref0 (_data_->file_info);
			_g_object_unref0 (_data_->children);
			_g_object_unref0 (_data_->directory);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp28_ = _data_->e;
			_data_->_tmp29_ = _data_->_tmp28_->message;
			g_warning ("LibraryManager.vala:146: %s", _data_->_tmp29_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->source);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->source);
	}
	g_signal_emit (_data_->self, audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_FINISHED_SIGNAL], 0);
	audience_services_library_manager_set_is_scanning (_data_->self, FALSE);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
audience_services_library_manager_is_file_valid (AudienceServicesLibraryManager* self,
                                                 GFileInfo* file_info)
{
	gchar* mime_type = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file_info != NULL, FALSE);
	_tmp0_ = g_file_info_get_content_type (file_info);
	_tmp1_ = g_strdup (_tmp0_);
	mime_type = _tmp1_;
	if (!g_file_info_get_is_hidden (file_info)) {
		const gchar* _tmp3_;
		_tmp3_ = mime_type;
		_tmp2_ = string_contains (_tmp3_, "video");
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (mime_type);
	return result;
}

static void
audience_services_library_manager_create_video_object (AudienceServicesLibraryManager* self,
                                                       GFileInfo* file_info,
                                                       const gchar* source,
                                                       const gchar* name)
{
	AudienceObjectsVideo* video = NULL;
	const gchar* _tmp1_;
	AudienceObjectsVideo* _tmp2_;
	GeeArrayList* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file_info != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (name != NULL);
	if (g_strcmp0 (name, "") == 0) {
		const gchar* _tmp0_;
		_tmp0_ = g_file_info_get_name (file_info);
		name = _tmp0_;
	}
	_tmp1_ = g_file_info_get_content_type (file_info);
	_tmp2_ = audience_objects_video_new (source, name, _tmp1_);
	video = _tmp2_;
	g_signal_emit (self, audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_FILE_DETECTED_SIGNAL], 0, video);
	_tmp3_ = self->priv->poster_hash;
	_tmp4_ = audience_objects_video_get_hash_file_poster (video);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp5_, ".jpg", NULL);
	_tmp7_ = _tmp6_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->poster_hash;
	_tmp9_ = audience_objects_video_get_hash_episode_poster (video);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, ".jpg", NULL);
	_tmp12_ = _tmp11_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp12_);
	_g_free0 (_tmp12_);
	audience_services_library_manager_set_has_items (self, TRUE);
	_g_object_unref0 (video);
}

static void
audience_services_library_manager_clear_cache_data_free (gpointer _data)
{
	AudienceServicesLibraryManagerClearCacheData* _data_;
	_data_ = _data;
	_g_free0 (_data_->cache_file);
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceServicesLibraryManagerClearCacheData, _data_);
}

void
audience_services_library_manager_clear_cache (AudienceServicesLibraryManager* self,
                                               const gchar* cache_file,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	AudienceServicesLibraryManagerClearCacheData* _data_;
	AudienceServicesLibraryManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cache_file != NULL);
	_data_ = g_slice_new0 (AudienceServicesLibraryManagerClearCacheData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_services_library_manager_clear_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (cache_file);
	_g_free0 (_data_->cache_file);
	_data_->cache_file = _tmp1_;
	audience_services_library_manager_clear_cache_co (_data_);
}

void
audience_services_library_manager_clear_cache_finish (AudienceServicesLibraryManager* self,
                                                      GAsyncResult* _res_)
{
	AudienceServicesLibraryManagerClearCacheData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
audience_services_library_manager_clear_cache_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	AudienceServicesLibraryManagerClearCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	audience_services_library_manager_clear_cache_co (_data_);
}

static gboolean
audience_services_library_manager_clear_cache_co (AudienceServicesLibraryManagerClearCacheData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_file_new_for_path (_data_->cache_file);
	_data_->file = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->file;
	if (g_file_query_exists (_data_->_tmp1_, NULL)) {
		{
			_data_->_tmp2_ = _data_->file;
			_data_->_state_ = 1;
			g_file_delete_async (_data_->_tmp2_, G_PRIORITY_DEFAULT, NULL, audience_services_library_manager_clear_cache_ready, _data_);
			return FALSE;
			_state_1:
			g_file_delete_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp3_ = _data_->e;
			_data_->_tmp4_ = _data_->_tmp3_->message;
			g_warning ("LibraryManager.vala:176: %s", _data_->_tmp4_);
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->file);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
audience_services_library_manager_clear_unused_cache_files_data_free (gpointer _data)
{
	AudienceServicesLibraryManagerClearUnusedCacheFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceServicesLibraryManagerClearUnusedCacheFilesData, _data_);
}

void
audience_services_library_manager_clear_unused_cache_files (AudienceServicesLibraryManager* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	AudienceServicesLibraryManagerClearUnusedCacheFilesData* _data_;
	AudienceServicesLibraryManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AudienceServicesLibraryManagerClearUnusedCacheFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_services_library_manager_clear_unused_cache_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	audience_services_library_manager_clear_unused_cache_files_co (_data_);
}

void
audience_services_library_manager_clear_unused_cache_files_finish (AudienceServicesLibraryManager* self,
                                                                   GAsyncResult* _res_)
{
	AudienceServicesLibraryManagerClearUnusedCacheFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		AudienceServicesLibraryManager* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->directory);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda5_ (Block6Data* _data6_,
            GObject* obj,
            GAsyncResult* res)
{
	AudienceServicesLibraryManager* self;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		GFileEnumerator* children = NULL;
		GFileEnumerator* _tmp0_;
		GFileInfo* file_info = NULL;
		_tmp0_ = g_file_enumerate_children_finish (_data6_->directory, res, &_inner_error0_);
		children = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GeeArrayList* _tmp6_;
			GFileInfo* _tmp7_;
			const gchar* _tmp8_;
			_tmp2_ = children;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_info);
				_g_object_unref0 (children);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp4_;
			_tmp5_ = file_info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = self->priv->poster_hash;
			_tmp7_ = file_info;
			_tmp8_ = g_file_info_get_name (_tmp7_);
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp6_, _tmp8_)) {
				GFile* to_delete = NULL;
				GFileEnumerator* _tmp9_;
				GFileInfo* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp9_ = children;
				_tmp10_ = file_info;
				_tmp11_ = g_file_enumerator_get_child (_tmp9_, _tmp10_);
				to_delete = _tmp11_;
				_tmp12_ = to_delete;
				_tmp13_ = g_file_get_path (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat ("rm ", _tmp14_, NULL);
				_tmp16_ = _tmp15_;
				g_spawn_command_line_async (_tmp16_, &_inner_error0_);
				_g_free0 (_tmp16_);
				_g_free0 (_tmp14_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (to_delete);
					_g_object_unref0 (_tmp1_);
					_g_object_unref0 (file_info);
					_g_object_unref0 (children);
					goto __catch0_g_error;
				}
				_g_object_unref0 (to_delete);
			}
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (file_info);
		_g_object_unref0 (children);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("LibraryManager.vala:194: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda5_ (self, source_object, res);
	block6_data_unref (self);
}

static gboolean
audience_services_library_manager_clear_unused_cache_files_co (AudienceServicesLibraryManagerClearUnusedCacheFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data6_ = g_slice_new0 (Block6Data);
	_data_->_data6_->_ref_count_ = 1;
	_data_->_data6_->self = g_object_ref (_data_->self);
	_data_->_data6_->_async_data_ = _data_;
	_data_->_tmp0_ = g_application_get_default ();
	_data_->_tmp1_ = audience_app_get_cache_directory (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, AUDIENCE_TYPE_APP, AudienceApp));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_g_free0 (_data_->_tmp2_);
	_data_->_data6_->directory = _data_->_tmp4_;
	g_file_enumerate_children_async (_data_->_data6_->directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, ___lambda5__gasync_ready_callback, block6_data_ref (_data_->_data6_));
	block6_data_unref (_data_->_data6_);
	_data_->_data6_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
audience_services_library_manager_deleted_items (AudienceServicesLibraryManager* self,
                                                 const gchar* path)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->trashed_files;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, path);
	g_signal_emit (self, audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_MOVED_TO_TRASH_SIGNAL], 0, path);
}

void
audience_services_library_manager_undo_delete_item (AudienceServicesLibraryManager* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->trashed_files;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		gchar* restore = NULL;
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		GFile* trash = NULL;
		GFile* _tmp5_;
		_tmp3_ = self->priv->trashed_files;
		_tmp4_ = gee_list_last ((GeeList*) _tmp3_);
		restore = (gchar*) _tmp4_;
		_tmp5_ = g_file_new_for_uri ("trash:///");
		trash = _tmp5_;
		{
			GFileEnumerator* children = NULL;
			GFile* _tmp6_;
			GFileEnumerator* _tmp7_;
			GFileInfo* file_info = NULL;
			_tmp6_ = trash;
			_tmp7_ = g_file_enumerate_children (_tmp6_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH "," G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
			children = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp8_ = NULL;
				GFileEnumerator* _tmp9_;
				GFileInfo* _tmp10_;
				GFileInfo* _tmp11_;
				GFileInfo* _tmp12_;
				gchar* orinal_path = NULL;
				GFileInfo* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp9_ = children;
				_tmp10_ = g_file_enumerator_next_file (_tmp9_, NULL, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file_info);
					_g_object_unref0 (children);
					goto __catch0_g_error;
				}
				_tmp11_ = _tmp8_;
				_tmp8_ = NULL;
				_g_object_unref0 (file_info);
				file_info = _tmp11_;
				_tmp12_ = file_info;
				if (!(_tmp12_ != NULL)) {
					_g_object_unref0 (_tmp8_);
					break;
				}
				_tmp13_ = file_info;
				_tmp14_ = g_file_info_get_attribute_as_string (_tmp13_, G_FILE_ATTRIBUTE_TRASH_ORIG_PATH);
				orinal_path = _tmp14_;
				_tmp15_ = orinal_path;
				_tmp16_ = restore;
				if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
					GFile* restore_file = NULL;
					GFileEnumerator* _tmp17_;
					GFileInfo* _tmp18_;
					GFile* _tmp19_;
					GFile* _tmp20_;
					const gchar* _tmp21_;
					GFile* _tmp22_;
					GFile* _tmp23_;
					GeeArrayList* _tmp24_;
					const gchar* _tmp25_;
					_tmp17_ = children;
					_tmp18_ = file_info;
					_tmp19_ = g_file_enumerator_get_child (_tmp17_, _tmp18_);
					restore_file = _tmp19_;
					_tmp20_ = restore_file;
					_tmp21_ = restore;
					_tmp22_ = g_file_new_for_path (_tmp21_);
					_tmp23_ = _tmp22_;
					g_file_move (_tmp20_, _tmp23_, 0, NULL, NULL, NULL, &_inner_error0_);
					_g_object_unref0 (_tmp23_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (restore_file);
						_g_free0 (orinal_path);
						_g_object_unref0 (_tmp8_);
						_g_object_unref0 (file_info);
						_g_object_unref0 (children);
						goto __catch0_g_error;
					}
					_tmp24_ = self->priv->trashed_files;
					_tmp25_ = restore;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp24_, _tmp25_);
					_g_object_unref0 (restore_file);
					_g_free0 (orinal_path);
					_g_object_unref0 (_tmp8_);
					_g_object_unref0 (file_info);
					_g_object_unref0 (children);
					_g_object_unref0 (trash);
					_g_free0 (restore);
					return;
				}
				_g_free0 (orinal_path);
				_g_object_unref0 (_tmp8_);
			}
			_g_object_unref0 (file_info);
			_g_object_unref0 (children);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning ("LibraryManager.vala:221: %s", _tmp27_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (trash);
			_g_free0 (restore);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (trash);
		_g_free0 (restore);
	}
}

GdkPixbuf*
audience_services_library_manager_get_poster_from_file (AudienceServicesLibraryManager* self,
                                                        const gchar* poster_path)
{
	GdkPixbuf* pixbuf = NULL;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (poster_path != NULL, NULL);
	pixbuf = NULL;
	if (g_file_test (poster_path, G_FILE_TEST_EXISTS)) {
		GdkPixbuf* _tmp5_;
		gint width = 0;
		GdkPixbuf* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		{
			GdkPixbuf* _tmp0_ = NULL;
			GdkPixbuf* _tmp1_;
			GdkPixbuf* _tmp2_;
			_tmp1_ = gdk_pixbuf_new_from_file_at_scale (poster_path, -1, AUDIENCE_SERVICES_POSTER_HEIGHT, TRUE, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("LibraryManager.vala:232: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = pixbuf;
		if (_tmp5_ == NULL) {
			result = NULL;
			_g_object_unref0 (pixbuf);
			return result;
		}
		_tmp6_ = pixbuf;
		_tmp7_ = gdk_pixbuf_get_width (_tmp6_);
		_tmp8_ = _tmp7_;
		width = _tmp8_;
		if (width > AUDIENCE_SERVICES_POSTER_WIDTH) {
			gint x_offset = 0;
			GdkPixbuf* _tmp9_;
			GdkPixbuf* _tmp10_;
			x_offset = (width - AUDIENCE_SERVICES_POSTER_WIDTH) / 2;
			_tmp9_ = pixbuf;
			_tmp10_ = gdk_pixbuf_new_subpixbuf (_tmp9_, x_offset, 0, AUDIENCE_SERVICES_POSTER_WIDTH, AUDIENCE_SERVICES_POSTER_HEIGHT);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp10_;
		}
	}
	result = pixbuf;
	return result;
}

GRegex*
audience_services_library_manager_get_regex_year (AudienceServicesLibraryManager* self)
{
	GRegex* result;
	GRegex* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_regex_year;
	result = _tmp0_;
	return result;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

void
audience_services_library_manager_set_regex_year (AudienceServicesLibraryManager* self,
                                                  GRegex* value)
{
	GRegex* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_services_library_manager_get_regex_year (self);
	if (old_value != value) {
		GRegex* _tmp0_;
		_tmp0_ = _g_regex_ref0 (value);
		_g_regex_unref0 (self->priv->_regex_year);
		self->priv->_regex_year = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_REGEX_YEAR_PROPERTY]);
	}
}

AudienceServicesDbusThumbnailer*
audience_services_library_manager_get_thumbler (AudienceServicesLibraryManager* self)
{
	AudienceServicesDbusThumbnailer* result;
	AudienceServicesDbusThumbnailer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_thumbler;
	result = _tmp0_;
	return result;
}

void
audience_services_library_manager_set_thumbler (AudienceServicesLibraryManager* self,
                                                AudienceServicesDbusThumbnailer* value)
{
	AudienceServicesDbusThumbnailer* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_services_library_manager_get_thumbler (self);
	if (old_value != value) {
		AudienceServicesDbusThumbnailer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_thumbler);
		self->priv->_thumbler = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_THUMBLER_PROPERTY]);
	}
}

gboolean
audience_services_library_manager_get_has_items (AudienceServicesLibraryManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_items;
	return result;
}

static void
audience_services_library_manager_set_has_items (AudienceServicesLibraryManager* self,
                                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_services_library_manager_get_has_items (self);
	if (old_value != value) {
		self->priv->_has_items = value;
		g_object_notify_by_pspec ((GObject *) self, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_HAS_ITEMS_PROPERTY]);
	}
}

gboolean
audience_services_library_manager_get_is_scanning (AudienceServicesLibraryManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_scanning;
	return result;
}

static void
audience_services_library_manager_set_is_scanning (AudienceServicesLibraryManager* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_services_library_manager_get_is_scanning (self);
	if (old_value != value) {
		self->priv->_is_scanning = value;
		g_object_notify_by_pspec ((GObject *) self, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_IS_SCANNING_PROPERTY]);
	}
}

static void
_audience_services_library_manager___lambda6_ (AudienceServicesLibraryManager* self)
{
	audience_services_library_manager_clear_unused_cache_files (self, NULL, NULL);
}

static void
__audience_services_library_manager___lambda6__audience_services_library_manager_finished (AudienceServicesLibraryManager* _sender,
                                                                                           gpointer self)
{
	_audience_services_library_manager___lambda6_ ((AudienceServicesLibraryManager*) self);
}

static GObject *
audience_services_library_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceServicesLibraryManager * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeUnrolledLinkedList* _tmp3_;
	AudienceServicesDbusThumbnailer* _tmp8_;
	AudienceServicesDbusThumbnailer* _tmp9_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (audience_services_library_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->trashed_files);
	self->priv->trashed_files = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->poster_hash);
	self->priv->poster_hash = _tmp1_;
	_tmp2_ = gee_array_list_new (AUDIENCE_SERVICES_TYPE_DIRECTORY_MONITORING, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->monitoring_directories);
	self->priv->monitoring_directories = _tmp2_;
	_tmp3_ = gee_unrolled_linked_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->unchecked_directories);
	self->priv->unchecked_directories = (GeeQueue*) _tmp3_;
	{
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		_tmp5_ = g_regex_new ("\\(\\d\\d\\d\\d(?=(\\)$))", 0, 0, &_inner_error0_);
		_tmp4_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		audience_services_library_manager_set_regex_year (self, _tmp4_);
		_g_regex_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("LibraryManager.vala:65: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp8_ = audience_services_dbus_thumbnailer_new ();
	_tmp9_ = _tmp8_;
	audience_services_library_manager_set_thumbler (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	g_signal_connect_object (self, "finished", (GCallback) __audience_services_library_manager___lambda6__audience_services_library_manager_finished, self, 0);
	return obj;
}

static void
audience_services_library_manager_class_init (AudienceServicesLibraryManagerClass * klass,
                                              gpointer klass_data)
{
	audience_services_library_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceServicesLibraryManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_services_library_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_audience_services_library_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = audience_services_library_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_services_library_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_SERVICES_LIBRARY_MANAGER_REGEX_YEAR_PROPERTY, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_REGEX_YEAR_PROPERTY] = g_param_spec_boxed ("regex-year", "regex-year", "regex-year", G_TYPE_REGEX, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_SERVICES_LIBRARY_MANAGER_THUMBLER_PROPERTY, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_THUMBLER_PROPERTY] = g_param_spec_object ("thumbler", "thumbler", "thumbler", AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_SERVICES_LIBRARY_MANAGER_HAS_ITEMS_PROPERTY, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_HAS_ITEMS_PROPERTY] = g_param_spec_boolean ("has-items", "has-items", "has-items", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_SERVICES_LIBRARY_MANAGER_IS_SCANNING_PROPERTY, audience_services_library_manager_properties[AUDIENCE_SERVICES_LIBRARY_MANAGER_IS_SCANNING_PROPERTY] = g_param_spec_boolean ("is-scanning", "is-scanning", "is-scanning", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_FILE_DETECTED_SIGNAL] = g_signal_new ("video-file-detected", AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AUDIENCE_OBJECTS_TYPE_VIDEO);
	audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_FILE_DELETED_SIGNAL] = g_signal_new ("video-file-deleted", AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_VIDEO_MOVED_TO_TRASH_SIGNAL] = g_signal_new ("video-moved-to-trash", AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	audience_services_library_manager_signals[AUDIENCE_SERVICES_LIBRARY_MANAGER_FINISHED_SIGNAL] = g_signal_new ("finished", AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
audience_services_library_manager_instance_init (AudienceServicesLibraryManager * self,
                                                 gpointer klass)
{
	self->priv = audience_services_library_manager_get_instance_private (self);
}

static void
audience_services_library_manager_finalize (GObject * obj)
{
	AudienceServicesLibraryManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager);
	_g_regex_unref0 (self->priv->_regex_year);
	_g_object_unref0 (self->priv->_thumbler);
	_g_object_unref0 (self->priv->poster_hash);
	_g_object_unref0 (self->priv->monitoring_directories);
	_g_object_unref0 (self->priv->unchecked_directories);
	_g_object_unref0 (self->priv->trashed_files);
	G_OBJECT_CLASS (audience_services_library_manager_parent_class)->finalize (obj);
}

static GType
audience_services_library_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceServicesLibraryManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_services_library_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceServicesLibraryManager), 0, (GInstanceInitFunc) audience_services_library_manager_instance_init, NULL };
	GType audience_services_library_manager_type_id;
	audience_services_library_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "AudienceServicesLibraryManager", &g_define_type_info, 0);
	AudienceServicesLibraryManager_private_offset = g_type_add_instance_private (audience_services_library_manager_type_id, sizeof (AudienceServicesLibraryManagerPrivate));
	return audience_services_library_manager_type_id;
}

GType
audience_services_library_manager_get_type (void)
{
	static volatile gsize audience_services_library_manager_type_id__once = 0;
	if (g_once_init_enter (&audience_services_library_manager_type_id__once)) {
		GType audience_services_library_manager_type_id;
		audience_services_library_manager_type_id = audience_services_library_manager_get_type_once ();
		g_once_init_leave (&audience_services_library_manager_type_id__once, audience_services_library_manager_type_id);
	}
	return audience_services_library_manager_type_id__once;
}

static void
_vala_audience_services_library_manager_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	AudienceServicesLibraryManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager);
	switch (property_id) {
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_REGEX_YEAR_PROPERTY:
		g_value_set_boxed (value, audience_services_library_manager_get_regex_year (self));
		break;
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_THUMBLER_PROPERTY:
		g_value_set_object (value, audience_services_library_manager_get_thumbler (self));
		break;
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_HAS_ITEMS_PROPERTY:
		g_value_set_boolean (value, audience_services_library_manager_get_has_items (self));
		break;
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_IS_SCANNING_PROPERTY:
		g_value_set_boolean (value, audience_services_library_manager_get_is_scanning (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_audience_services_library_manager_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	AudienceServicesLibraryManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager);
	switch (property_id) {
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_REGEX_YEAR_PROPERTY:
		audience_services_library_manager_set_regex_year (self, g_value_get_boxed (value));
		break;
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_THUMBLER_PROPERTY:
		audience_services_library_manager_set_thumbler (self, g_value_get_object (value));
		break;
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_HAS_ITEMS_PROPERTY:
		audience_services_library_manager_set_has_items (self, g_value_get_boolean (value));
		break;
		case AUDIENCE_SERVICES_LIBRARY_MANAGER_IS_SCANNING_PROPERTY:
		audience_services_library_manager_set_is_scanning (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

