/* Video.c generated by valac 0.56.17, the Vala compiler
 * generated from Video.vala, do not modify */

/*-
 * Copyright 2016-2022 elementary, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Artem Anufrij <artem.anufrij@live.de>
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib/gstdio.h>
#include <gee.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_OBJECTS_TYPE_VIDEO (audience_objects_video_get_type ())
#define AUDIENCE_OBJECTS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo))
#define AUDIENCE_OBJECTS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))
#define AUDIENCE_OBJECTS_IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_OBJECTS_TYPE_VIDEO))
#define AUDIENCE_OBJECTS_VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideoClass))

typedef struct _AudienceObjectsVideo AudienceObjectsVideo;
typedef struct _AudienceObjectsVideoClass AudienceObjectsVideoClass;
typedef struct _AudienceObjectsVideoPrivate AudienceObjectsVideoPrivate;

#define AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER (audience_services_library_manager_get_type ())
#define AUDIENCE_SERVICES_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManager))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_IS_LIBRARY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER))
#define AUDIENCE_SERVICES_LIBRARY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_LIBRARY_MANAGER, AudienceServicesLibraryManagerClass))

typedef struct _AudienceServicesLibraryManager AudienceServicesLibraryManager;
typedef struct _AudienceServicesLibraryManagerClass AudienceServicesLibraryManagerClass;
enum  {
	AUDIENCE_OBJECTS_VIDEO_0_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_DIRECTORY_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_FILE_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_MIME_TYPE_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_VIDEO_FILE_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_POSTER_INITIALIZED_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_POSTER_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_CONTAINER_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_HASH_EPISODE_POSTER_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_HASH_FILE_POSTER_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_POSTER_CACHE_FILE_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_TITLE_PROPERTY,
	AUDIENCE_OBJECTS_VIDEO_NUM_PROPERTIES
};
static GParamSpec* audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _AudienceObjectsVideoInitializePosterData AudienceObjectsVideoInitializePosterData;
typedef struct _Block5Data Block5Data;

#define AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER (audience_services_dbus_thumbnailer_get_type ())
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailer))
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailerClass))
#define AUDIENCE_SERVICES_IS_DBUS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER))
#define AUDIENCE_SERVICES_IS_DBUS_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER))
#define AUDIENCE_SERVICES_DBUS_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_SERVICES_TYPE_DBUS_THUMBNAILER, AudienceServicesDbusThumbnailerClass))

typedef struct _AudienceServicesDbusThumbnailer AudienceServicesDbusThumbnailer;
typedef struct _AudienceServicesDbusThumbnailerClass AudienceServicesDbusThumbnailerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _AudienceObjectsVideoInitializePosterThreadData AudienceObjectsVideoInitializePosterThreadData;
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define AUDIENCE_TYPE_APP (audience_app_get_type ())
#define AUDIENCE_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_APP, AudienceApp))
#define AUDIENCE_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_APP, AudienceAppClass))
#define AUDIENCE_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_APP))
#define AUDIENCE_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_APP))
#define AUDIENCE_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_APP, AudienceAppClass))

typedef struct _AudienceApp AudienceApp;
typedef struct _AudienceAppClass AudienceAppClass;
enum  {
	AUDIENCE_OBJECTS_VIDEO_POSTER_CHANGED_SIGNAL,
	AUDIENCE_OBJECTS_VIDEO_TITLE_CHANGED_SIGNAL,
	AUDIENCE_OBJECTS_VIDEO_TRASHED_SIGNAL,
	AUDIENCE_OBJECTS_VIDEO_NUM_SIGNALS
};
static guint audience_objects_video_signals[AUDIENCE_OBJECTS_VIDEO_NUM_SIGNALS] = {0};

struct _AudienceObjectsVideo {
	GObject parent_instance;
	AudienceObjectsVideoPrivate * priv;
};

struct _AudienceObjectsVideoClass {
	GObjectClass parent_class;
};

struct _AudienceObjectsVideoPrivate {
	gchar* _directory;
	gchar* _file;
	gchar* _mime_type;
	GFile* _video_file;
	gboolean _poster_initialized;
	GdkPixbuf* _poster;
	gchar* _container;
	gchar* _hash_episode_poster;
	gchar* _hash_file_poster;
	gchar* _poster_cache_file;
	gchar* _title;
	AudienceServicesLibraryManager* manager;
	gchar* thumbnail_large_path;
	gchar* thumbnail_normal_path;
};

struct _AudienceObjectsVideoInitializePosterData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceObjectsVideo* self;
};

struct _Block5Data {
	int _ref_count_;
	AudienceObjectsVideo* self;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GdkPixbuf* pixbuf;
	gpointer _async_data_;
};

struct _AudienceObjectsVideoInitializePosterThreadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AudienceObjectsVideo* self;
	GdkPixbuf* result;
	Block5Data* _data5_;
	GThreadFunc run;
	gpointer run_target;
	GThreadFunc _tmp0_;
	gpointer _tmp0__target;
	GThread* _tmp1_;
	GThread* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GdkPixbuf* _tmp5_;
	GError* _inner_error0_;
};

static gint AudienceObjectsVideo_private_offset;
static gpointer audience_objects_video_parent_class = NULL;
VALA_EXTERN GSettings* audience_settings;

VALA_EXTERN GType audience_objects_video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceObjectsVideo, g_object_unref)
VALA_EXTERN GType audience_services_library_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesLibraryManager, g_object_unref)
VALA_EXTERN AudienceObjectsVideo* audience_objects_video_new (const gchar* directory,
                                                  const gchar* file,
                                                  const gchar* mime_type);
VALA_EXTERN AudienceObjectsVideo* audience_objects_video_construct (GType object_type,
                                                        const gchar* directory,
                                                        const gchar* file,
                                                        const gchar* mime_type);
static void audience_objects_video_initialize_poster_data_free (gpointer _data);
VALA_EXTERN void audience_objects_video_initialize_poster (AudienceObjectsVideo* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN void audience_objects_video_initialize_poster_finish (AudienceObjectsVideo* self,
                                                      GAsyncResult* _res_);
static gboolean audience_objects_video_initialize_poster_co (AudienceObjectsVideoInitializePosterData* _data_);
static void audience_objects_video_set_poster_initialized (AudienceObjectsVideo* self,
                                                    gboolean value);
static void audience_objects_video_initialize_poster_thread (AudienceObjectsVideo* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static GdkPixbuf* audience_objects_video_initialize_poster_thread_finish (AudienceObjectsVideo* self,
                                                                   GAsyncResult* _res_);
static void __lambda8_ (AudienceObjectsVideo* self,
                 GObject* obj,
                 GAsyncResult* res);
static void audience_objects_video_set_poster (AudienceObjectsVideo* self,
                                        GdkPixbuf* value);
static void audience_objects_video_set_pixbufs (AudienceObjectsVideo* self);
static void ___lambda8__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void audience_objects_video_initialize_poster_thread_data_free (gpointer _data);
static gboolean audience_objects_video_initialize_poster_thread_co (AudienceObjectsVideoInitializePosterThreadData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean _audience_objects_video_initialize_poster_thread_co_gsource_func (gpointer self);
static void* __lambda7_ (Block5Data* _data5_);
VALA_EXTERN GFile* audience_objects_video_get_video_file (AudienceObjectsVideo* self);
VALA_EXTERN const gchar* audience_objects_video_get_mime_type (AudienceObjectsVideo* self);
VALA_EXTERN GType audience_services_dbus_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceServicesDbusThumbnailer, g_object_unref)
VALA_EXTERN AudienceServicesDbusThumbnailer* audience_services_library_manager_get_thumbler (AudienceServicesLibraryManager* self);
VALA_EXTERN void audience_services_dbus_thumbnailer_instand (AudienceServicesDbusThumbnailer* self,
                                                 GeeArrayList* uris,
                                                 GeeArrayList* mimes,
                                                 const gchar* size);
VALA_EXTERN const gchar* audience_objects_video_get_poster_cache_file (AudienceObjectsVideo* self);
VALA_EXTERN GdkPixbuf* audience_services_library_manager_get_poster_from_file (AudienceServicesLibraryManager* self,
                                                                   const gchar* poster_path);
static gchar* audience_objects_video_get_native_poster_path (AudienceObjectsVideo* self);
static gpointer ___lambda7__gthread_func (gpointer self);
VALA_EXTERN GdkPixbuf* audience_objects_video_get_poster (AudienceObjectsVideo* self);
VALA_EXTERN const gchar* audience_objects_video_get_directory (AudienceObjectsVideo* self);
VALA_EXTERN const gchar* audience_objects_video_get_file (AudienceObjectsVideo* self);
VALA_EXTERN gchar* audience_get_title (const gchar* filename);
VALA_EXTERN void audience_objects_video_set_new_poster (AudienceObjectsVideo* self,
                                            GdkPixbuf* new_poster);
VALA_EXTERN void audience_services_library_manager_clear_cache (AudienceServicesLibraryManager* self,
                                                    const gchar* cache_file,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN void audience_services_library_manager_clear_cache_finish (AudienceServicesLibraryManager* self,
                                                           GAsyncResult* _res_);
static void audience_objects_video_set_directory (AudienceObjectsVideo* self,
                                           const gchar* value);
static void audience_objects_video_set_file (AudienceObjectsVideo* self,
                                      const gchar* value);
static void audience_objects_video_set_mime_type (AudienceObjectsVideo* self,
                                           const gchar* value);
static void audience_objects_video_set_video_file (AudienceObjectsVideo* self,
                                            GFile* value);
VALA_EXTERN gboolean audience_objects_video_get_poster_initialized (AudienceObjectsVideo* self);
VALA_EXTERN const gchar* audience_objects_video_get_container (AudienceObjectsVideo* self);
static void audience_objects_video_set_container (AudienceObjectsVideo* self,
                                           const gchar* value);
VALA_EXTERN const gchar* audience_objects_video_get_hash_episode_poster (AudienceObjectsVideo* self);
static void audience_objects_video_set_hash_episode_poster (AudienceObjectsVideo* self,
                                                     const gchar* value);
VALA_EXTERN const gchar* audience_objects_video_get_hash_file_poster (AudienceObjectsVideo* self);
static void audience_objects_video_set_hash_file_poster (AudienceObjectsVideo* self,
                                                  const gchar* value);
static void audience_objects_video_set_poster_cache_file (AudienceObjectsVideo* self,
                                                   const gchar* value);
VALA_EXTERN const gchar* audience_objects_video_get_title (AudienceObjectsVideo* self);
static void audience_objects_video_set_title (AudienceObjectsVideo* self,
                                       const gchar* value);
static GObject * audience_objects_video_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN AudienceServicesLibraryManager* audience_services_library_manager_get_instance (void);
static void _audience_objects_video_set_pixbufs_audience_services_dbus_thumbnailer_finished (AudienceServicesDbusThumbnailer* _sender,
                                                                                      guint handle,
                                                                                      gpointer self);
VALA_EXTERN GRegex* audience_services_library_manager_get_regex_year (AudienceServicesLibraryManager* self);
VALA_EXTERN GType audience_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceApp, g_object_unref)
VALA_EXTERN AudienceApp* audience_app_get_instance (void);
VALA_EXTERN gchar* audience_app_get_cache_directory (AudienceApp* self);
static void _audience_objects_video___lambda9_ (AudienceObjectsVideo* self);
static void __audience_objects_video___lambda9__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _audience_objects_video___lambda10_ (AudienceObjectsVideo* self);
static void __audience_objects_video___lambda10__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void audience_objects_video_finalize (GObject * obj);
static GType audience_objects_video_get_type_once (void);
static void _vala_audience_objects_video_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_audience_objects_video_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
audience_objects_video_get_instance_private (AudienceObjectsVideo* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceObjectsVideo_private_offset);
}

AudienceObjectsVideo*
audience_objects_video_construct (GType object_type,
                                  const gchar* directory,
                                  const gchar* file,
                                  const gchar* mime_type)
{
	AudienceObjectsVideo * self = NULL;
	g_return_val_if_fail (directory != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (mime_type != NULL, NULL);
	self = (AudienceObjectsVideo*) g_object_new (object_type, "directory", directory, "file", file, "mime-type", mime_type, NULL);
	return self;
}

AudienceObjectsVideo*
audience_objects_video_new (const gchar* directory,
                            const gchar* file,
                            const gchar* mime_type)
{
	return audience_objects_video_construct (AUDIENCE_OBJECTS_TYPE_VIDEO, directory, file, mime_type);
}

static void
audience_objects_video_initialize_poster_data_free (gpointer _data)
{
	AudienceObjectsVideoInitializePosterData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceObjectsVideoInitializePosterData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
audience_objects_video_initialize_poster (AudienceObjectsVideo* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	AudienceObjectsVideoInitializePosterData* _data_;
	AudienceObjectsVideo* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AudienceObjectsVideoInitializePosterData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_objects_video_initialize_poster_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	audience_objects_video_initialize_poster_co (_data_);
}

void
audience_objects_video_initialize_poster_finish (AudienceObjectsVideo* self,
                                                 GAsyncResult* _res_)
{
	AudienceObjectsVideoInitializePosterData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
__lambda8_ (AudienceObjectsVideo* self,
            GObject* obj,
            GAsyncResult* res)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = audience_objects_video_initialize_poster_thread_finish (self, res);
	_tmp1_ = _tmp0_;
	audience_objects_video_set_poster (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	audience_objects_video_set_pixbufs (self);
}

static void
___lambda8__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda8_ ((AudienceObjectsVideo*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
audience_objects_video_initialize_poster_co (AudienceObjectsVideoInitializePosterData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	audience_objects_video_set_poster_initialized (_data_->self, TRUE);
	audience_objects_video_initialize_poster_thread (_data_->self, ___lambda8__gasync_ready_callback, g_object_ref (_data_->self));
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
audience_objects_video_initialize_poster_thread_data_free (gpointer _data)
{
	AudienceObjectsVideoInitializePosterThreadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AudienceObjectsVideoInitializePosterThreadData, _data_);
}

static void
audience_objects_video_initialize_poster_thread (AudienceObjectsVideo* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	AudienceObjectsVideoInitializePosterThreadData* _data_;
	AudienceObjectsVideo* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (AudienceObjectsVideoInitializePosterThreadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, audience_objects_video_initialize_poster_thread_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	audience_objects_video_initialize_poster_thread_co (_data_);
}

static GdkPixbuf*
audience_objects_video_initialize_poster_thread_finish (AudienceObjectsVideo* self,
                                                        GAsyncResult* _res_)
{
	GdkPixbuf* result;
	AudienceObjectsVideoInitializePosterThreadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		AudienceObjectsVideo* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->pixbuf);
		(_data5_->callback_target_destroy_notify == NULL) ? NULL : (_data5_->callback_target_destroy_notify (_data5_->callback_target), NULL);
		_data5_->callback = NULL;
		_data5_->callback_target = NULL;
		_data5_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
_audience_objects_video_initialize_poster_thread_co_gsource_func (gpointer self)
{
	gboolean result;
	result = audience_objects_video_initialize_poster_thread_co (self);
	return result;
}

static void*
__lambda7_ (Block5Data* _data5_)
{
	AudienceObjectsVideo* self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* poster_path = NULL;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	AudienceServicesLibraryManager* _tmp23_;
	const gchar* _tmp24_;
	GdkPixbuf* _tmp25_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp36_;
	GSourceFunc _tmp41_;
	gpointer _tmp41__target;
	GDestroyNotify _tmp41__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	void* result;
	self = _data5_->self;
	_tmp1_ = self->priv->thumbnail_large_path;
	if (!g_file_test (_tmp1_, G_FILE_TEST_EXISTS)) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->thumbnail_normal_path;
		_tmp0_ = !g_file_test (_tmp2_, G_FILE_TEST_EXISTS);
	}
	if (_tmp0_) {
		GeeArrayList* uris = NULL;
		GeeArrayList* _tmp3_;
		GeeArrayList* mimes = NULL;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GeeArrayList* _tmp9_;
		const gchar* _tmp10_;
		AudienceServicesLibraryManager* _tmp11_;
		AudienceServicesDbusThumbnailer* _tmp12_;
		AudienceServicesDbusThumbnailer* _tmp13_;
		GeeArrayList* _tmp14_;
		GeeArrayList* _tmp15_;
		AudienceServicesLibraryManager* _tmp16_;
		AudienceServicesDbusThumbnailer* _tmp17_;
		AudienceServicesDbusThumbnailer* _tmp18_;
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		uris = _tmp3_;
		_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		mimes = _tmp4_;
		_tmp5_ = uris;
		_tmp6_ = self->priv->_video_file;
		_tmp7_ = g_file_get_uri (_tmp6_);
		_tmp8_ = _tmp7_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = mimes;
		_tmp10_ = self->priv->_mime_type;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp10_);
		_tmp11_ = self->priv->manager;
		_tmp12_ = audience_services_library_manager_get_thumbler (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = uris;
		_tmp15_ = mimes;
		audience_services_dbus_thumbnailer_instand (_tmp13_, _tmp14_, _tmp15_, "large");
		_tmp16_ = self->priv->manager;
		_tmp17_ = audience_services_library_manager_get_thumbler (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = uris;
		_tmp20_ = mimes;
		audience_services_dbus_thumbnailer_instand (_tmp18_, _tmp19_, _tmp20_, "normal");
		_g_object_unref0 (mimes);
		_g_object_unref0 (uris);
	}
	_tmp21_ = self->priv->_poster_cache_file;
	_tmp22_ = g_strdup (_tmp21_);
	poster_path = _tmp22_;
	_tmp23_ = self->priv->manager;
	_tmp24_ = poster_path;
	_tmp25_ = audience_services_library_manager_get_poster_from_file (_tmp23_, _tmp24_);
	_g_object_unref0 (_data5_->pixbuf);
	_data5_->pixbuf = _tmp25_;
	if (_data5_->pixbuf != NULL) {
		GSourceFunc _tmp26_;
		gpointer _tmp26__target;
		GDestroyNotify _tmp26__target_destroy_notify;
		_tmp26_ = _data5_->callback;
		_tmp26__target = _data5_->callback_target;
		_tmp26__target_destroy_notify = _data5_->callback_target_destroy_notify;
		_data5_->callback = NULL;
		_data5_->callback_target = NULL;
		_data5_->callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp26_, _tmp26__target, _tmp26__target_destroy_notify);
		result = NULL;
		_g_free0 (poster_path);
		return result;
	}
	_tmp27_ = audience_objects_video_get_native_poster_path (self);
	_g_free0 (poster_path);
	poster_path = _tmp27_;
	_tmp28_ = poster_path;
	if (_tmp28_ != NULL) {
		AudienceServicesLibraryManager* _tmp29_;
		const gchar* _tmp30_;
		GdkPixbuf* _tmp31_;
		_tmp29_ = self->priv->manager;
		_tmp30_ = poster_path;
		_tmp31_ = audience_services_library_manager_get_poster_from_file (_tmp29_, _tmp30_);
		_g_object_unref0 (_data5_->pixbuf);
		_data5_->pixbuf = _tmp31_;
	}
	if (_data5_->pixbuf != NULL) {
		GSourceFunc _tmp35_;
		gpointer _tmp35__target;
		GDestroyNotify _tmp35__target_destroy_notify;
		{
			const gchar* _tmp32_;
			_tmp32_ = self->priv->_poster_cache_file;
			gdk_pixbuf_save (_data5_->pixbuf, _tmp32_, "jpeg", &_inner_error0_, NULL);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp33_;
			const gchar* _tmp34_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp33_ = e;
			_tmp34_ = _tmp33_->message;
			g_warning ("Video.vala:126: %s", _tmp34_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (poster_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp35_ = _data5_->callback;
		_tmp35__target = _data5_->callback_target;
		_tmp35__target_destroy_notify = _data5_->callback_target_destroy_notify;
		_data5_->callback = NULL;
		_data5_->callback_target = NULL;
		_data5_->callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp35_, _tmp35__target, _tmp35__target_destroy_notify);
		result = NULL;
		_g_free0 (poster_path);
		return result;
	}
	_tmp36_ = self->priv->thumbnail_large_path;
	if (g_file_test (_tmp36_, G_FILE_TEST_EXISTS)) {
		AudienceServicesLibraryManager* _tmp37_;
		const gchar* _tmp38_;
		GdkPixbuf* _tmp39_;
		GSourceFunc _tmp40_;
		gpointer _tmp40__target;
		GDestroyNotify _tmp40__target_destroy_notify;
		_tmp37_ = self->priv->manager;
		_tmp38_ = self->priv->thumbnail_large_path;
		_tmp39_ = audience_services_library_manager_get_poster_from_file (_tmp37_, _tmp38_);
		_g_object_unref0 (_data5_->pixbuf);
		_data5_->pixbuf = _tmp39_;
		_tmp40_ = _data5_->callback;
		_tmp40__target = _data5_->callback_target;
		_tmp40__target_destroy_notify = _data5_->callback_target_destroy_notify;
		_data5_->callback = NULL;
		_data5_->callback_target = NULL;
		_data5_->callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp40_, _tmp40__target, _tmp40__target_destroy_notify);
		result = NULL;
		_g_free0 (poster_path);
		return result;
	}
	_tmp41_ = _data5_->callback;
	_tmp41__target = _data5_->callback_target;
	_tmp41__target_destroy_notify = _data5_->callback_target_destroy_notify;
	_data5_->callback = NULL;
	_data5_->callback_target = NULL;
	_data5_->callback_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp41_, _tmp41__target, _tmp41__target_destroy_notify);
	result = NULL;
	_g_free0 (poster_path);
	return result;
}

static gpointer
___lambda7__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda7_ (self);
	block5_data_unref (self);
	return result;
}

static gboolean
audience_objects_video_initialize_poster_thread_co (AudienceObjectsVideoInitializePosterThreadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_data_->_data5_->_async_data_ = _data_;
	_data_->_data5_->callback = _audience_objects_video_initialize_poster_thread_co_gsource_func;
	_data_->_data5_->callback_target = _data_;
	_data_->_data5_->callback_target_destroy_notify = NULL;
	_data_->_data5_->pixbuf = NULL;
	_data_->run = ___lambda7__gthread_func;
	_data_->run_target = block5_data_ref (_data_->_data5_);
	{
		_data_->_tmp0_ = _data_->run;
		_data_->_tmp0__target = _data_->run_target;
		_data_->run = NULL;
		_data_->run_target = NULL;
		_data_->_tmp1_ = g_thread_try_new (NULL, _data_->_tmp0_, _data_->_tmp0__target, &_data_->_inner_error0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_g_thread_unref0 (_data_->_tmp2_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("Video.vala:145: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp5_ = _g_object_ref0 (_data_->_data5_->pixbuf);
	_data_->result = _data_->_tmp5_;
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
audience_objects_video_set_pixbufs (AudienceObjectsVideo* self)
{
	gboolean _tmp0_ = FALSE;
	GdkPixbuf* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_poster;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->thumbnail_large_path;
		_tmp0_ = g_file_test (_tmp2_, G_FILE_TEST_EXISTS);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AudienceServicesLibraryManager* _tmp3_;
		const gchar* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		_tmp3_ = self->priv->manager;
		_tmp4_ = self->priv->thumbnail_large_path;
		_tmp5_ = audience_services_library_manager_get_poster_from_file (_tmp3_, _tmp4_);
		_tmp6_ = _tmp5_;
		audience_objects_video_set_poster (self, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
}

static gchar*
audience_objects_video_get_native_poster_path (AudienceObjectsVideo* self)
{
	gchar* poster_path = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* file_poster = NULL;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GSettings* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	_tmp1_ = self->priv->_file;
	_tmp2_ = g_build_filename (_tmp0_, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".jpg", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	poster_path = _tmp5_;
	_tmp6_ = poster_path;
	_tmp7_ = g_file_new_for_path (_tmp6_);
	file_poster = _tmp7_;
	_tmp8_ = file_poster;
	if (g_file_query_exists (_tmp8_, NULL)) {
		result = poster_path;
		_g_object_unref0 (file_poster);
		return result;
	}
	_tmp9_ = self->priv->_directory;
	_tmp10_ = self->priv->_file;
	_tmp11_ = audience_get_title (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, ".jpg", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_build_filename (_tmp9_, _tmp14_, NULL);
	_g_free0 (poster_path);
	poster_path = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp16_ = poster_path;
	_tmp17_ = g_file_new_for_path (_tmp16_);
	_g_object_unref0 (file_poster);
	file_poster = _tmp17_;
	_tmp18_ = file_poster;
	if (g_file_query_exists (_tmp18_, NULL)) {
		result = poster_path;
		_g_object_unref0 (file_poster);
		return result;
	}
	_tmp19_ = audience_settings;
	_tmp21_ = _tmp20_ = g_settings_get_strv (_tmp19_, "poster-names");
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp21_;
		s_collection_length1 = _vala_array_length (_tmp20_);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			gchar* _tmp22_;
			gchar* s = NULL;
			_tmp22_ = g_strdup (s_collection[s_it]);
			s = _tmp22_;
			{
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				const gchar* _tmp26_;
				GFile* _tmp27_;
				GFile* _tmp28_;
				_tmp23_ = self->priv->_directory;
				_tmp24_ = s;
				_tmp25_ = g_build_filename (_tmp23_, _tmp24_, NULL);
				_g_free0 (poster_path);
				poster_path = _tmp25_;
				_tmp26_ = poster_path;
				_tmp27_ = g_file_new_for_path (_tmp26_);
				_g_object_unref0 (file_poster);
				file_poster = _tmp27_;
				_tmp28_ = file_poster;
				if (g_file_query_exists (_tmp28_, NULL)) {
					result = poster_path;
					_g_free0 (s);
					s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (file_poster);
					return result;
				}
				_g_free0 (s);
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = NULL;
	_g_object_unref0 (file_poster);
	_g_free0 (poster_path);
	return result;
}

void
audience_objects_video_set_new_poster (AudienceObjectsVideo* self,
                                       GdkPixbuf* new_poster)
{
	AudienceServicesLibraryManager* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = self->priv->_poster_cache_file;
	audience_services_library_manager_clear_cache (_tmp0_, _tmp1_, NULL, NULL);
	audience_objects_video_set_poster (self, new_poster);
}

const gchar*
audience_objects_video_get_directory (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_directory (AudienceObjectsVideo* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_directory (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_directory);
		self->priv->_directory = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_DIRECTORY_PROPERTY]);
	}
}

const gchar*
audience_objects_video_get_file (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_file (AudienceObjectsVideo* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_file (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_FILE_PROPERTY]);
	}
}

const gchar*
audience_objects_video_get_mime_type (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mime_type;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_mime_type (AudienceObjectsVideo* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_mime_type (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_mime_type);
		self->priv->_mime_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_MIME_TYPE_PROPERTY]);
	}
}

GFile*
audience_objects_video_get_video_file (AudienceObjectsVideo* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_video_file;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_video_file (AudienceObjectsVideo* self,
                                       GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_video_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_video_file);
		self->priv->_video_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_VIDEO_FILE_PROPERTY]);
	}
}

gboolean
audience_objects_video_get_poster_initialized (AudienceObjectsVideo* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_poster_initialized;
	return result;
}

static void
audience_objects_video_set_poster_initialized (AudienceObjectsVideo* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_poster_initialized (self);
	if (old_value != value) {
		self->priv->_poster_initialized = value;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_POSTER_INITIALIZED_PROPERTY]);
	}
}

GdkPixbuf*
audience_objects_video_get_poster (AudienceObjectsVideo* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_poster;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_poster (AudienceObjectsVideo* self,
                                   GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_poster (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_poster);
		self->priv->_poster = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_POSTER_PROPERTY]);
	}
}

const gchar*
audience_objects_video_get_container (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_container (AudienceObjectsVideo* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_container (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_container);
		self->priv->_container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_CONTAINER_PROPERTY]);
	}
}

const gchar*
audience_objects_video_get_hash_episode_poster (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hash_episode_poster;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_hash_episode_poster (AudienceObjectsVideo* self,
                                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_hash_episode_poster (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_hash_episode_poster);
		self->priv->_hash_episode_poster = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_HASH_EPISODE_POSTER_PROPERTY]);
	}
}

const gchar*
audience_objects_video_get_hash_file_poster (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hash_file_poster;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_hash_file_poster (AudienceObjectsVideo* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_hash_file_poster (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_hash_file_poster);
		self->priv->_hash_file_poster = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_HASH_FILE_POSTER_PROPERTY]);
	}
}

const gchar*
audience_objects_video_get_poster_cache_file (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_poster_cache_file;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_poster_cache_file (AudienceObjectsVideo* self,
                                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_poster_cache_file (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_poster_cache_file);
		self->priv->_poster_cache_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_POSTER_CACHE_FILE_PROPERTY]);
	}
}

const gchar*
audience_objects_video_get_title (AudienceObjectsVideo* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
audience_objects_video_set_title (AudienceObjectsVideo* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = audience_objects_video_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_TITLE_PROPERTY]);
	}
}

static void
_audience_objects_video_set_pixbufs_audience_services_dbus_thumbnailer_finished (AudienceServicesDbusThumbnailer* _sender,
                                                                                 guint handle,
                                                                                 gpointer self)
{
	audience_objects_video_set_pixbufs ((AudienceObjectsVideo*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_audience_objects_video___lambda9_ (AudienceObjectsVideo* self)
{
	g_signal_emit (self, audience_objects_video_signals[AUDIENCE_OBJECTS_VIDEO_POSTER_CHANGED_SIGNAL], 0, self);
}

static void
__audience_objects_video___lambda9__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_audience_objects_video___lambda9_ ((AudienceObjectsVideo*) self);
}

static void
_audience_objects_video___lambda10_ (AudienceObjectsVideo* self)
{
	g_signal_emit (self, audience_objects_video_signals[AUDIENCE_OBJECTS_VIDEO_TITLE_CHANGED_SIGNAL], 0, self);
}

static void
__audience_objects_video___lambda10__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	_audience_objects_video___lambda10_ ((AudienceObjectsVideo*) self);
}

static GObject *
audience_objects_video_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceObjectsVideo * self;
	AudienceServicesLibraryManager* _tmp0_;
	AudienceServicesLibraryManager* _tmp1_;
	AudienceServicesDbusThumbnailer* _tmp2_;
	AudienceServicesDbusThumbnailer* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GMatchInfo* info = NULL;
	AudienceServicesLibraryManager* _tmp7_;
	GRegex* _tmp8_;
	GRegex* _tmp9_;
	const gchar* _tmp10_;
	GMatchInfo* _tmp11_ = NULL;
	gboolean _tmp12_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GFile* _tmp27_;
	GFile* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GFile* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gint _tmp40_;
	gint _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GFile* _tmp49_;
	GFile* _tmp50_;
	GFile* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	AudienceApp* _tmp68_;
	AudienceApp* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	parent_class = G_OBJECT_CLASS (audience_objects_video_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo);
	_tmp0_ = audience_services_library_manager_get_instance ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp0_;
	_tmp1_ = self->priv->manager;
	_tmp2_ = audience_services_library_manager_get_thumbler (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "finished", (GCallback) _audience_objects_video_set_pixbufs_audience_services_dbus_thumbnailer_finished, self, 0);
	_tmp4_ = self->priv->_file;
	_tmp5_ = audience_get_title (_tmp4_);
	_tmp6_ = _tmp5_;
	audience_objects_video_set_title (self, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->manager;
	_tmp8_ = audience_services_library_manager_get_regex_year (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_title;
	_tmp12_ = g_regex_match (_tmp9_, _tmp10_, 0, &_tmp11_);
	_g_match_info_unref0 (info);
	info = _tmp11_;
	if (_tmp12_) {
		const gchar* _tmp13_;
		GMatchInfo* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = self->priv->_title;
		_tmp14_ = info;
		_tmp15_ = g_match_info_fetch (_tmp14_, 0);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, ")", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_replace (_tmp13_, _tmp18_, "");
		_tmp20_ = _tmp19_;
		_tmp21_ = string_strip (_tmp20_);
		_tmp22_ = _tmp21_;
		audience_objects_video_set_title (self, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
	}
	_tmp23_ = self->priv->_directory;
	_tmp24_ = self->priv->_file;
	_tmp25_ = g_build_filename (_tmp23_, _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_file_new_for_path (_tmp26_);
	_tmp28_ = _tmp27_;
	audience_objects_video_set_video_file (self, _tmp28_);
	_g_object_unref0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp29_ = self->priv->_directory;
	_tmp30_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
	if (g_strcmp0 (_tmp29_, _tmp30_) != 0) {
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		_tmp31_ = self->priv->_directory;
		_tmp32_ = g_path_get_basename (_tmp31_);
		_tmp33_ = _tmp32_;
		audience_objects_video_set_container (self, _tmp33_);
		_g_free0 (_tmp33_);
	}
	_tmp34_ = self->priv->_video_file;
	_tmp35_ = g_file_get_uri (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = self->priv->_video_file;
	_tmp38_ = g_file_get_uri (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = strlen (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp36_, (gsize) _tmp41_);
	_tmp43_ = _tmp42_;
	audience_objects_video_set_hash_file_poster (self, _tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp36_);
	_tmp44_ = self->priv->_video_file;
	_tmp45_ = g_file_get_parent (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_file_get_uri (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = self->priv->_video_file;
	_tmp50_ = g_file_get_parent (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_file_get_uri (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = strlen (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp48_, (gsize) _tmp55_);
	_tmp57_ = _tmp56_;
	audience_objects_video_set_hash_episode_poster (self, _tmp57_);
	_g_free0 (_tmp57_);
	_g_free0 (_tmp53_);
	_g_object_unref0 (_tmp51_);
	_g_free0 (_tmp48_);
	_g_object_unref0 (_tmp46_);
	_tmp58_ = g_get_user_cache_dir ();
	_tmp59_ = self->priv->_hash_file_poster;
	_tmp60_ = g_strconcat (_tmp59_, ".png", NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = g_build_filename (_tmp58_, "thumbnails", "large", _tmp61_, NULL);
	_g_free0 (self->priv->thumbnail_large_path);
	self->priv->thumbnail_large_path = _tmp62_;
	_g_free0 (_tmp61_);
	_tmp63_ = g_get_user_cache_dir ();
	_tmp64_ = self->priv->_hash_file_poster;
	_tmp65_ = g_strconcat (_tmp64_, ".png", NULL);
	_tmp66_ = _tmp65_;
	_tmp67_ = g_build_filename (_tmp63_, "thumbnails", "normal", _tmp66_, NULL);
	_g_free0 (self->priv->thumbnail_normal_path);
	self->priv->thumbnail_normal_path = _tmp67_;
	_g_free0 (_tmp66_);
	_tmp68_ = audience_app_get_instance ();
	_tmp69_ = _tmp68_;
	_tmp70_ = audience_app_get_cache_directory (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = self->priv->_hash_file_poster;
	_tmp73_ = g_strconcat (_tmp72_, ".jpg", NULL);
	_tmp74_ = _tmp73_;
	_tmp75_ = g_build_filename (_tmp71_, _tmp74_, NULL);
	_tmp76_ = _tmp75_;
	audience_objects_video_set_poster_cache_file (self, _tmp76_);
	_g_free0 (_tmp76_);
	_g_free0 (_tmp74_);
	_g_free0 (_tmp71_);
	_g_object_unref0 (_tmp69_);
	g_signal_connect_object ((GObject*) self, "notify::poster", (GCallback) __audience_objects_video___lambda9__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::title", (GCallback) __audience_objects_video___lambda10__g_object_notify, self, 0);
	_g_match_info_unref0 (info);
	return obj;
}

static void
audience_objects_video_class_init (AudienceObjectsVideoClass * klass,
                                   gpointer klass_data)
{
	audience_objects_video_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceObjectsVideo_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_audience_objects_video_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_audience_objects_video_set_property;
	G_OBJECT_CLASS (klass)->constructor = audience_objects_video_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_objects_video_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_DIRECTORY_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_DIRECTORY_PROPERTY] = g_param_spec_string ("directory", "directory", "directory", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_FILE_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_FILE_PROPERTY] = g_param_spec_string ("file", "file", "file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_MIME_TYPE_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_MIME_TYPE_PROPERTY] = g_param_spec_string ("mime-type", "mime-type", "mime-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_VIDEO_FILE_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_VIDEO_FILE_PROPERTY] = g_param_spec_object ("video-file", "video-file", "video-file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_POSTER_INITIALIZED_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_POSTER_INITIALIZED_PROPERTY] = g_param_spec_boolean ("poster-initialized", "poster-initialized", "poster-initialized", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_POSTER_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_POSTER_PROPERTY] = g_param_spec_object ("poster", "poster", "poster", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_CONTAINER_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_CONTAINER_PROPERTY] = g_param_spec_string ("container", "container", "container", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_HASH_EPISODE_POSTER_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_HASH_EPISODE_POSTER_PROPERTY] = g_param_spec_string ("hash-episode-poster", "hash-episode-poster", "hash-episode-poster", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_HASH_FILE_POSTER_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_HASH_FILE_POSTER_PROPERTY] = g_param_spec_string ("hash-file-poster", "hash-file-poster", "hash-file-poster", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_POSTER_CACHE_FILE_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_POSTER_CACHE_FILE_PROPERTY] = g_param_spec_string ("poster-cache-file", "poster-cache-file", "poster-cache-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AUDIENCE_OBJECTS_VIDEO_TITLE_PROPERTY, audience_objects_video_properties[AUDIENCE_OBJECTS_VIDEO_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	audience_objects_video_signals[AUDIENCE_OBJECTS_VIDEO_POSTER_CHANGED_SIGNAL] = g_signal_new ("poster-changed", AUDIENCE_OBJECTS_TYPE_VIDEO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AUDIENCE_OBJECTS_TYPE_VIDEO);
	audience_objects_video_signals[AUDIENCE_OBJECTS_VIDEO_TITLE_CHANGED_SIGNAL] = g_signal_new ("title-changed", AUDIENCE_OBJECTS_TYPE_VIDEO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, AUDIENCE_OBJECTS_TYPE_VIDEO);
	audience_objects_video_signals[AUDIENCE_OBJECTS_VIDEO_TRASHED_SIGNAL] = g_signal_new ("trashed", AUDIENCE_OBJECTS_TYPE_VIDEO, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
audience_objects_video_instance_init (AudienceObjectsVideo * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	self->priv = audience_objects_video_get_instance_private (self);
	self->priv->_poster_initialized = FALSE;
	self->priv->_poster = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_container = _tmp0_;
}

static void
audience_objects_video_finalize (GObject * obj)
{
	AudienceObjectsVideo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo);
	_g_free0 (self->priv->_directory);
	_g_free0 (self->priv->_file);
	_g_free0 (self->priv->_mime_type);
	_g_object_unref0 (self->priv->_video_file);
	_g_object_unref0 (self->priv->_poster);
	_g_free0 (self->priv->_container);
	_g_free0 (self->priv->_hash_episode_poster);
	_g_free0 (self->priv->_hash_file_poster);
	_g_free0 (self->priv->_poster_cache_file);
	_g_free0 (self->priv->_title);
	_g_object_unref0 (self->priv->manager);
	_g_free0 (self->priv->thumbnail_large_path);
	_g_free0 (self->priv->thumbnail_normal_path);
	G_OBJECT_CLASS (audience_objects_video_parent_class)->finalize (obj);
}

static GType
audience_objects_video_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceObjectsVideoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_objects_video_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceObjectsVideo), 0, (GInstanceInitFunc) audience_objects_video_instance_init, NULL };
	GType audience_objects_video_type_id;
	audience_objects_video_type_id = g_type_register_static (G_TYPE_OBJECT, "AudienceObjectsVideo", &g_define_type_info, 0);
	AudienceObjectsVideo_private_offset = g_type_add_instance_private (audience_objects_video_type_id, sizeof (AudienceObjectsVideoPrivate));
	return audience_objects_video_type_id;
}

GType
audience_objects_video_get_type (void)
{
	static volatile gsize audience_objects_video_type_id__once = 0;
	if (g_once_init_enter (&audience_objects_video_type_id__once)) {
		GType audience_objects_video_type_id;
		audience_objects_video_type_id = audience_objects_video_get_type_once ();
		g_once_init_leave (&audience_objects_video_type_id__once, audience_objects_video_type_id);
	}
	return audience_objects_video_type_id__once;
}

static void
_vala_audience_objects_video_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	AudienceObjectsVideo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo);
	switch (property_id) {
		case AUDIENCE_OBJECTS_VIDEO_DIRECTORY_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_directory (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_FILE_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_file (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_MIME_TYPE_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_mime_type (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_VIDEO_FILE_PROPERTY:
		g_value_set_object (value, audience_objects_video_get_video_file (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_POSTER_INITIALIZED_PROPERTY:
		g_value_set_boolean (value, audience_objects_video_get_poster_initialized (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_POSTER_PROPERTY:
		g_value_set_object (value, audience_objects_video_get_poster (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_CONTAINER_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_container (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_HASH_EPISODE_POSTER_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_hash_episode_poster (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_HASH_FILE_POSTER_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_hash_file_poster (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_POSTER_CACHE_FILE_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_poster_cache_file (self));
		break;
		case AUDIENCE_OBJECTS_VIDEO_TITLE_PROPERTY:
		g_value_set_string (value, audience_objects_video_get_title (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_audience_objects_video_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	AudienceObjectsVideo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, AUDIENCE_OBJECTS_TYPE_VIDEO, AudienceObjectsVideo);
	switch (property_id) {
		case AUDIENCE_OBJECTS_VIDEO_DIRECTORY_PROPERTY:
		audience_objects_video_set_directory (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_FILE_PROPERTY:
		audience_objects_video_set_file (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_MIME_TYPE_PROPERTY:
		audience_objects_video_set_mime_type (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_VIDEO_FILE_PROPERTY:
		audience_objects_video_set_video_file (self, g_value_get_object (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_POSTER_INITIALIZED_PROPERTY:
		audience_objects_video_set_poster_initialized (self, g_value_get_boolean (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_POSTER_PROPERTY:
		audience_objects_video_set_poster (self, g_value_get_object (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_CONTAINER_PROPERTY:
		audience_objects_video_set_container (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_HASH_EPISODE_POSTER_PROPERTY:
		audience_objects_video_set_hash_episode_poster (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_HASH_FILE_POSTER_PROPERTY:
		audience_objects_video_set_hash_file_poster (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_POSTER_CACHE_FILE_PROPERTY:
		audience_objects_video_set_poster_cache_file (self, g_value_get_string (value));
		break;
		case AUDIENCE_OBJECTS_VIDEO_TITLE_PROPERTY:
		audience_objects_video_set_title (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

