/* DiskManager.c generated by valac 0.56.17, the Vala compiler
 * generated from DiskManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2013-2014 Audience Developers (http://launchpad.net/pantheon-chat)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define AUDIENCE_TYPE_DISK_MANAGER (audience_disk_manager_get_type ())
#define AUDIENCE_DISK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManager))
#define AUDIENCE_DISK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManagerClass))
#define AUDIENCE_IS_DISK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUDIENCE_TYPE_DISK_MANAGER))
#define AUDIENCE_IS_DISK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUDIENCE_TYPE_DISK_MANAGER))
#define AUDIENCE_DISK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManagerClass))

typedef struct _AudienceDiskManager AudienceDiskManager;
typedef struct _AudienceDiskManagerClass AudienceDiskManagerClass;
typedef struct _AudienceDiskManagerPrivate AudienceDiskManagerPrivate;
enum  {
	AUDIENCE_DISK_MANAGER_0_PROPERTY,
	AUDIENCE_DISK_MANAGER_NUM_PROPERTIES
};
static GParamSpec* audience_disk_manager_properties[AUDIENCE_DISK_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	AUDIENCE_DISK_MANAGER_VOLUME_FOUND_SIGNAL,
	AUDIENCE_DISK_MANAGER_VOLUME_REMOVED_SIGNAL,
	AUDIENCE_DISK_MANAGER_NUM_SIGNALS
};
static guint audience_disk_manager_signals[AUDIENCE_DISK_MANAGER_NUM_SIGNALS] = {0};

struct _AudienceDiskManager {
	GObject parent_instance;
	AudienceDiskManagerPrivate * priv;
};

struct _AudienceDiskManagerClass {
	GObjectClass parent_class;
};

struct _AudienceDiskManagerPrivate {
	GVolumeMonitor* monitor;
	GeeTreeSet* volumes;
};

static gint AudienceDiskManager_private_offset;
static gpointer audience_disk_manager_parent_class = NULL;
static AudienceDiskManager* audience_disk_manager_disk_manager;
static AudienceDiskManager* audience_disk_manager_disk_manager = NULL;

VALA_EXTERN GType audience_disk_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AudienceDiskManager, g_object_unref)
VALA_EXTERN AudienceDiskManager* audience_disk_manager_get_default (void);
static AudienceDiskManager* audience_disk_manager_new (void);
static AudienceDiskManager* audience_disk_manager_construct (GType object_type);
VALA_EXTERN GeeTreeSet* audience_disk_manager_get_volumes (AudienceDiskManager* self);
VALA_EXTERN GeeTreeSet* audience_disk_manager_get_media_volumes (AudienceDiskManager* self);
static gboolean audience_disk_manager_has_dvd_media (AudienceDiskManager* self,
                                              GVolume* volume);
VALA_EXTERN gboolean audience_disk_manager_has_media_volumes (AudienceDiskManager* self);
static void audience_disk_manager_check_for_volume (AudienceDiskManager* self,
                                             GVolume* volume);
static GObject * audience_disk_manager_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static void _audience_disk_manager___lambda36_ (AudienceDiskManager* self,
                                         GVolume* volume);
static void __audience_disk_manager___lambda36__gfunc (gconstpointer data,
                                                gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _audience_disk_manager___lambda37_ (AudienceDiskManager* self,
                                         GDrive* drive);
static void __audience_disk_manager___lambda37__g_volume_monitor_drive_changed (GVolumeMonitor* _sender,
                                                                         GDrive* drive,
                                                                         gpointer self);
static void _audience_disk_manager___lambda38_ (AudienceDiskManager* self,
                                         GDrive* drive);
static void __audience_disk_manager___lambda38__g_volume_monitor_drive_connected (GVolumeMonitor* _sender,
                                                                           GDrive* drive,
                                                                           gpointer self);
static void _audience_disk_manager___lambda39_ (AudienceDiskManager* self,
                                         GDrive* drive);
static void __audience_disk_manager___lambda39__g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender,
                                                                              GDrive* drive,
                                                                              gpointer self);
static void _audience_disk_manager___lambda40_ (AudienceDiskManager* self,
                                         GDrive* drive);
static void __audience_disk_manager___lambda40__g_volume_monitor_drive_eject_button (GVolumeMonitor* _sender,
                                                                              GDrive* drive,
                                                                              gpointer self);
static void _audience_disk_manager___lambda41_ (AudienceDiskManager* self,
                                         GDrive* drive);
static void __audience_disk_manager___lambda41__g_volume_monitor_drive_stop_button (GVolumeMonitor* _sender,
                                                                             GDrive* drive,
                                                                             gpointer self);
static void _audience_disk_manager___lambda42_ (AudienceDiskManager* self,
                                         GVolume* volume);
static void __audience_disk_manager___lambda42__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                        GVolume* volume,
                                                                        gpointer self);
static void _audience_disk_manager___lambda43_ (AudienceDiskManager* self,
                                         GVolume* volume);
static void __audience_disk_manager___lambda43__g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                          GVolume* volume,
                                                                          gpointer self);
static void _audience_disk_manager___lambda44_ (AudienceDiskManager* self,
                                         GVolume* volume);
static void __audience_disk_manager___lambda44__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                          GVolume* volume,
                                                                          gpointer self);
static void audience_disk_manager_finalize (GObject * obj);
static GType audience_disk_manager_get_type_once (void);

static inline gpointer
audience_disk_manager_get_instance_private (AudienceDiskManager* self)
{
	return G_STRUCT_MEMBER_P (self, AudienceDiskManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

AudienceDiskManager*
audience_disk_manager_get_default (void)
{
	AudienceDiskManager* _tmp0_;
	AudienceDiskManager* _tmp2_;
	AudienceDiskManager* _tmp3_;
	AudienceDiskManager* result;
	_tmp0_ = audience_disk_manager_disk_manager;
	if (_tmp0_ == NULL) {
		AudienceDiskManager* _tmp1_;
		_tmp1_ = audience_disk_manager_new ();
		_g_object_unref0 (audience_disk_manager_disk_manager);
		audience_disk_manager_disk_manager = _tmp1_;
	}
	_tmp2_ = audience_disk_manager_disk_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static AudienceDiskManager*
audience_disk_manager_construct (GType object_type)
{
	AudienceDiskManager * self = NULL;
	self = (AudienceDiskManager*) g_object_new (object_type, NULL);
	return self;
}

static AudienceDiskManager*
audience_disk_manager_new (void)
{
	return audience_disk_manager_construct (AUDIENCE_TYPE_DISK_MANAGER);
}

GeeTreeSet*
audience_disk_manager_get_volumes (AudienceDiskManager* self)
{
	GeeTreeSet* _tmp0_;
	GeeTreeSet* _tmp1_;
	GeeTreeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->volumes;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GeeTreeSet*
audience_disk_manager_get_media_volumes (AudienceDiskManager* self)
{
	GeeTreeSet* return_value = NULL;
	GeeTreeSet* _tmp0_;
	GeeTreeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_tree_set_new (g_volume_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	return_value = _tmp0_;
	{
		GeeIterator* _volume_it = NULL;
		GeeTreeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->volumes;
		_tmp2_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp1_);
		_volume_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GVolume* volume = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GVolume* _tmp6_;
			_tmp3_ = _volume_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _volume_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			volume = (GVolume*) _tmp5_;
			_tmp6_ = volume;
			if (audience_disk_manager_has_dvd_media (self, _tmp6_)) {
				GeeTreeSet* _tmp7_;
				GVolume* _tmp8_;
				_tmp7_ = return_value;
				_tmp8_ = volume;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, _tmp8_);
			}
			_g_object_unref0 (volume);
		}
		_g_object_unref0 (_volume_it);
	}
	result = return_value;
	return result;
}

gboolean
audience_disk_manager_has_media_volumes (AudienceDiskManager* self)
{
	GeeTreeSet* _tmp0_;
	GeeTreeSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = audience_disk_manager_get_media_volumes (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ > 0;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static void
audience_disk_manager_check_for_volume (AudienceDiskManager* self,
                                        GVolume* volume)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (volume != NULL);
	if (audience_disk_manager_has_dvd_media (self, volume)) {
		GeeTreeSet* _tmp0_;
		_tmp0_ = self->priv->volumes;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, volume);
		g_signal_emit (self, audience_disk_manager_signals[AUDIENCE_DISK_MANAGER_VOLUME_FOUND_SIGNAL], 0, volume);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
audience_disk_manager_has_dvd_media (AudienceDiskManager* self,
                                     GVolume* volume)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* icon_name = NULL;
	GIcon* _tmp2_;
	GIcon* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GDrive* _tmp8_;
	GDrive* _tmp9_;
	gboolean _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (volume != NULL, FALSE);
	_tmp0_ = g_volume_get_name (volume);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:111: Check DVD media for: %s", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_volume_get_icon (volume);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_icon_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	icon_name = _tmp5_;
	_tmp6_ = icon_name;
	if (!string_contains (_tmp6_, "optical")) {
		result = FALSE;
		_g_free0 (icon_name);
		return result;
	}
	_tmp8_ = g_volume_get_drive (volume);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_ != NULL;
	_g_object_unref0 (_tmp9_);
	if (_tmp10_) {
		GDrive* _tmp11_;
		GDrive* _tmp12_;
		_tmp11_ = g_volume_get_drive (volume);
		_tmp12_ = _tmp11_;
		_tmp7_ = g_drive_has_media (_tmp12_);
		_g_object_unref0 (_tmp12_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GFile* root = NULL;
		GMount* _tmp13_;
		GMount* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp13_ = g_volume_get_mount (volume);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_mount_get_default_location (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		root = _tmp16_;
		_tmp17_ = root;
		if (_tmp17_ != NULL) {
			GFile* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			GFile* video = NULL;
			GFile* _tmp21_;
			GFile* _tmp22_;
			GFile* bdmv = NULL;
			GFile* _tmp23_;
			GFile* _tmp24_;
			gboolean _tmp25_ = FALSE;
			GFile* _tmp26_;
			_tmp18_ = root;
			_tmp19_ = g_file_get_uri (_tmp18_);
			_tmp20_ = _tmp19_;
			g_debug ("DiskManager.vala:121: Activation root: %s", _tmp20_);
			_g_free0 (_tmp20_);
			_tmp21_ = root;
			_tmp22_ = g_file_get_child (_tmp21_, "VIDEO_TS");
			video = _tmp22_;
			_tmp23_ = root;
			_tmp24_ = g_file_get_child (_tmp23_, "BDMV");
			bdmv = _tmp24_;
			_tmp26_ = video;
			if (g_file_query_exists (_tmp26_, NULL)) {
				_tmp25_ = TRUE;
			} else {
				GFile* _tmp27_;
				_tmp27_ = bdmv;
				_tmp25_ = g_file_query_exists (_tmp27_, NULL);
			}
			if (_tmp25_) {
				result = TRUE;
				_g_object_unref0 (bdmv);
				_g_object_unref0 (video);
				_g_object_unref0 (root);
				_g_free0 (icon_name);
				return result;
			}
			_g_object_unref0 (bdmv);
			_g_object_unref0 (video);
		}
		_g_object_unref0 (root);
	}
	result = FALSE;
	_g_free0 (icon_name);
	return result;
}

static void
_audience_disk_manager___lambda36_ (AudienceDiskManager* self,
                                    GVolume* volume)
{
	GeeTreeSet* _tmp0_;
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->volumes;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, volume);
}

static void
__audience_disk_manager___lambda36__gfunc (gconstpointer data,
                                           gpointer self)
{
	_audience_disk_manager___lambda36_ ((AudienceDiskManager*) self, (GVolume*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_audience_disk_manager___lambda37_ (AudienceDiskManager* self,
                                    GDrive* drive)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (drive != NULL);
	_tmp0_ = g_drive_get_name (drive);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:48: Drive changed: %s\n", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
__audience_disk_manager___lambda37__g_volume_monitor_drive_changed (GVolumeMonitor* _sender,
                                                                    GDrive* drive,
                                                                    gpointer self)
{
	_audience_disk_manager___lambda37_ ((AudienceDiskManager*) self, drive);
}

static void
_audience_disk_manager___lambda38_ (AudienceDiskManager* self,
                                    GDrive* drive)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (drive != NULL);
	_tmp0_ = g_drive_get_name (drive);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:52: Drive connected: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
__audience_disk_manager___lambda38__g_volume_monitor_drive_connected (GVolumeMonitor* _sender,
                                                                      GDrive* drive,
                                                                      gpointer self)
{
	_audience_disk_manager___lambda38_ ((AudienceDiskManager*) self, drive);
}

static void
_audience_disk_manager___lambda39_ (AudienceDiskManager* self,
                                    GDrive* drive)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (drive != NULL);
	_tmp0_ = g_drive_get_name (drive);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:56: Drive disconnected: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
__audience_disk_manager___lambda39__g_volume_monitor_drive_disconnected (GVolumeMonitor* _sender,
                                                                         GDrive* drive,
                                                                         gpointer self)
{
	_audience_disk_manager___lambda39_ ((AudienceDiskManager*) self, drive);
}

static void
_audience_disk_manager___lambda40_ (AudienceDiskManager* self,
                                    GDrive* drive)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (drive != NULL);
	_tmp0_ = g_drive_get_name (drive);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:60: Drive eject-button: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
__audience_disk_manager___lambda40__g_volume_monitor_drive_eject_button (GVolumeMonitor* _sender,
                                                                         GDrive* drive,
                                                                         gpointer self)
{
	_audience_disk_manager___lambda40_ ((AudienceDiskManager*) self, drive);
}

static void
_audience_disk_manager___lambda41_ (AudienceDiskManager* self,
                                    GDrive* drive)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (drive != NULL);
	_tmp0_ = g_drive_get_name (drive);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:64: Drive stop-button:%s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
__audience_disk_manager___lambda41__g_volume_monitor_drive_stop_button (GVolumeMonitor* _sender,
                                                                        GDrive* drive,
                                                                        gpointer self)
{
	_audience_disk_manager___lambda41_ ((AudienceDiskManager*) self, drive);
}

static void
_audience_disk_manager___lambda42_ (AudienceDiskManager* self,
                                    GVolume* volume)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (volume != NULL);
	audience_disk_manager_check_for_volume (self, volume);
	_tmp0_ = g_volume_get_name (volume);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:69: Volume added: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
__audience_disk_manager___lambda42__g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                   GVolume* volume,
                                                                   gpointer self)
{
	_audience_disk_manager___lambda42_ ((AudienceDiskManager*) self, volume);
}

static void
_audience_disk_manager___lambda43_ (AudienceDiskManager* self,
                                    GVolume* volume)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (volume != NULL);
	audience_disk_manager_check_for_volume (self, volume);
	_tmp0_ = g_volume_get_name (volume);
	_tmp1_ = _tmp0_;
	g_debug ("DiskManager.vala:74: Volume changed: %s", _tmp1_);
	_g_free0 (_tmp1_);
}

static void
__audience_disk_manager___lambda43__g_volume_monitor_volume_changed (GVolumeMonitor* _sender,
                                                                     GVolume* volume,
                                                                     gpointer self)
{
	_audience_disk_manager___lambda43_ ((AudienceDiskManager*) self, volume);
}

static void
_audience_disk_manager___lambda44_ (AudienceDiskManager* self,
                                    GVolume* volume)
{
	GeeTreeSet* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (volume != NULL);
	_tmp0_ = self->priv->volumes;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, volume);
	g_signal_emit (self, audience_disk_manager_signals[AUDIENCE_DISK_MANAGER_VOLUME_REMOVED_SIGNAL], 0, volume);
	_tmp1_ = g_volume_get_name (volume);
	_tmp2_ = _tmp1_;
	g_debug ("DiskManager.vala:80: Volume removed: %s", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__audience_disk_manager___lambda44__g_volume_monitor_volume_removed (GVolumeMonitor* _sender,
                                                                     GVolume* volume,
                                                                     gpointer self)
{
	_audience_disk_manager___lambda44_ ((AudienceDiskManager*) self, volume);
}

static GObject *
audience_disk_manager_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AudienceDiskManager * self;
	GVolumeMonitor* _tmp0_;
	GeeTreeSet* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GVolumeMonitor* _tmp5_;
	GVolumeMonitor* _tmp6_;
	GVolumeMonitor* _tmp7_;
	GVolumeMonitor* _tmp8_;
	GVolumeMonitor* _tmp9_;
	GVolumeMonitor* _tmp10_;
	GVolumeMonitor* _tmp11_;
	GVolumeMonitor* _tmp12_;
	parent_class = G_OBJECT_CLASS (audience_disk_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManager);
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp0_;
	_tmp1_ = gee_tree_set_new (g_volume_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->volumes);
	self->priv->volumes = _tmp1_;
	_tmp2_ = self->priv->monitor;
	_tmp3_ = g_volume_monitor_get_volumes (_tmp2_);
	_tmp4_ = _tmp3_;
	g_list_foreach (_tmp4_, __audience_disk_manager___lambda36__gfunc, self);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (_g_list_free__g_object_unref0_ (_tmp4_), NULL));
	_tmp5_ = self->priv->monitor;
	g_signal_connect_object (_tmp5_, "drive-changed", (GCallback) __audience_disk_manager___lambda37__g_volume_monitor_drive_changed, self, 0);
	_tmp6_ = self->priv->monitor;
	g_signal_connect_object (_tmp6_, "drive-connected", (GCallback) __audience_disk_manager___lambda38__g_volume_monitor_drive_connected, self, 0);
	_tmp7_ = self->priv->monitor;
	g_signal_connect_object (_tmp7_, "drive-disconnected", (GCallback) __audience_disk_manager___lambda39__g_volume_monitor_drive_disconnected, self, 0);
	_tmp8_ = self->priv->monitor;
	g_signal_connect_object (_tmp8_, "drive-eject-button", (GCallback) __audience_disk_manager___lambda40__g_volume_monitor_drive_eject_button, self, 0);
	_tmp9_ = self->priv->monitor;
	g_signal_connect_object (_tmp9_, "drive-stop-button", (GCallback) __audience_disk_manager___lambda41__g_volume_monitor_drive_stop_button, self, 0);
	_tmp10_ = self->priv->monitor;
	g_signal_connect_object (_tmp10_, "volume-added", (GCallback) __audience_disk_manager___lambda42__g_volume_monitor_volume_added, self, 0);
	_tmp11_ = self->priv->monitor;
	g_signal_connect_object (_tmp11_, "volume-changed", (GCallback) __audience_disk_manager___lambda43__g_volume_monitor_volume_changed, self, 0);
	_tmp12_ = self->priv->monitor;
	g_signal_connect_object (_tmp12_, "volume-removed", (GCallback) __audience_disk_manager___lambda44__g_volume_monitor_volume_removed, self, 0);
	return obj;
}

static void
audience_disk_manager_class_init (AudienceDiskManagerClass * klass,
                                  gpointer klass_data)
{
	audience_disk_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AudienceDiskManager_private_offset);
	G_OBJECT_CLASS (klass)->constructor = audience_disk_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = audience_disk_manager_finalize;
	audience_disk_manager_signals[AUDIENCE_DISK_MANAGER_VOLUME_FOUND_SIGNAL] = g_signal_new ("volume-found", AUDIENCE_TYPE_DISK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_volume_get_type ());
	audience_disk_manager_signals[AUDIENCE_DISK_MANAGER_VOLUME_REMOVED_SIGNAL] = g_signal_new ("volume-removed", AUDIENCE_TYPE_DISK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, g_volume_get_type ());
}

static void
audience_disk_manager_instance_init (AudienceDiskManager * self,
                                     gpointer klass)
{
	self->priv = audience_disk_manager_get_instance_private (self);
}

static void
audience_disk_manager_finalize (GObject * obj)
{
	AudienceDiskManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, AUDIENCE_TYPE_DISK_MANAGER, AudienceDiskManager);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->volumes);
	G_OBJECT_CLASS (audience_disk_manager_parent_class)->finalize (obj);
}

static GType
audience_disk_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AudienceDiskManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) audience_disk_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AudienceDiskManager), 0, (GInstanceInitFunc) audience_disk_manager_instance_init, NULL };
	GType audience_disk_manager_type_id;
	audience_disk_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "AudienceDiskManager", &g_define_type_info, 0);
	AudienceDiskManager_private_offset = g_type_add_instance_private (audience_disk_manager_type_id, sizeof (AudienceDiskManagerPrivate));
	return audience_disk_manager_type_id;
}

GType
audience_disk_manager_get_type (void)
{
	static volatile gsize audience_disk_manager_type_id__once = 0;
	if (g_once_init_enter (&audience_disk_manager_type_id__once)) {
		GType audience_disk_manager_type_id;
		audience_disk_manager_type_id = audience_disk_manager_get_type_once ();
		g_once_init_leave (&audience_disk_manager_type_id__once, audience_disk_manager_type_id);
	}
	return audience_disk_manager_type_id__once;
}

