/* SourceRow.c generated by valac 0.56.16, the Vala compiler
 * generated from SourceRow.vala, do not modify */

/*
 * Copyright 2019-2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_WIDGETS_TYPE_SOURCE_ROW (tasks_widgets_source_row_get_type ())
#define TASKS_WIDGETS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow))
#define TASKS_WIDGETS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))
#define TASKS_WIDGETS_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))

typedef struct _TasksWidgetsSourceRow TasksWidgetsSourceRow;
typedef struct _TasksWidgetsSourceRowClass TasksWidgetsSourceRowClass;
typedef struct _TasksWidgetsSourceRowPrivate TasksWidgetsSourceRowPrivate;
enum  {
	TASKS_WIDGETS_SOURCE_ROW_0_PROPERTY,
	TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY,
	TASKS_WIDGETS_SOURCE_ROW_NUM_PROPERTIES
};
static GParamSpec* tasks_widgets_source_row_properties[TASKS_WIDGETS_SOURCE_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TasksWidgetsSourceRowOnDragDropMoveTasksData TasksWidgetsSourceRowOnDragDropMoveTasksData;
typedef struct _Block12Data Block12Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TasksWidgetsSourceRow {
	GtkListBoxRow parent_instance;
	TasksWidgetsSourceRowPrivate * priv;
};

struct _TasksWidgetsSourceRowClass {
	GtkListBoxRowClass parent_class;
};

struct _TasksWidgetsSourceRowPrivate {
	ESource* _source;
	GtkGrid* source_color;
	GtkImage* status_image;
	GtkLabel* display_name_label;
	GtkStack* status_stack;
	GtkRevealer* revealer;
	GeeHashMultiMap* received_drag_data;
};

struct _TasksWidgetsSourceRowOnDragDropMoveTasksData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TasksWidgetsSourceRow* self;
	gboolean result;
	ESourceRegistry* registry;
	TasksTaskModel* _tmp0_;
	ESourceRegistry* _tmp1_;
	gboolean move_successful;
	GeeSet* source_uids;
	GeeHashMultiMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeIterator* _source_uid_it;
	GeeSet* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	gchar* source_uid;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	ESource* src_source;
	ESourceRegistry* _tmp9_;
	const gchar* _tmp10_;
	ESource* _tmp11_;
	GeeCollection* component_uids;
	GeeHashMultiMap* _tmp12_;
	const gchar* _tmp13_;
	GeeCollection* _tmp14_;
	GeeIterator* _component_uid_it;
	GeeCollection* _tmp15_;
	GeeIterator* _tmp16_;
	GeeIterator* _tmp17_;
	gchar* component_uid;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	gboolean _tmp20_;
	TasksTaskModel* _tmp21_;
	ESource* _tmp22_;
	ESource* _tmp23_;
	const gchar* _tmp24_;
	GError* _inner_error0_;
};

struct _Block12Data {
	int _ref_count_;
	TasksWidgetsSourceRow* self;
	gboolean drop_successful;
	gboolean move_successful;
	GdkDragContext* context;
	guint time;
};

static gint TasksWidgetsSourceRow_private_offset;
static gpointer tasks_widgets_source_row_parent_class = NULL;
static GtkCssProvider* tasks_widgets_source_row_listrow_provider;
static GtkCssProvider* tasks_widgets_source_row_listrow_provider = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;

VALA_EXTERN GType tasks_widgets_source_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsSourceRow, g_object_unref)
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_new (ESource* source);
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_construct (GType object_type,
                                                           ESource* source);
static void tasks_widgets_source_row_build_drag_and_drop (TasksWidgetsSourceRow* self);
static gboolean tasks_widgets_source_row_on_drag_motion (TasksWidgetsSourceRow* self,
                                                  GdkDragContext* context,
                                                  gint x,
                                                  gint y,
                                                  guint time);
static gboolean _tasks_widgets_source_row_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                          GdkDragContext* context,
                                                                          gint x,
                                                                          gint y,
                                                                          guint time_,
                                                                          gpointer self);
static gboolean tasks_widgets_source_row_on_drag_drop (TasksWidgetsSourceRow* self,
                                                GdkDragContext* context,
                                                gint x,
                                                gint y,
                                                guint time);
static gboolean _tasks_widgets_source_row_on_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                                      GdkDragContext* context,
                                                                      gint x,
                                                                      gint y,
                                                                      guint time_,
                                                                      gpointer self);
static void tasks_widgets_source_row_on_drag_data_received (TasksWidgetsSourceRow* self,
                                                     GdkDragContext* context,
                                                     gint x,
                                                     gint y,
                                                     GtkSelectionData* selection_data,
                                                     guint info,
                                                     guint time);
static void _tasks_widgets_source_row_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                    GdkDragContext* context,
                                                                                    gint x,
                                                                                    gint y,
                                                                                    GtkSelectionData* selection_data,
                                                                                    guint info,
                                                                                    guint time_,
                                                                                    gpointer self);
static void tasks_widgets_source_row_on_drag_leave (TasksWidgetsSourceRow* self,
                                             GdkDragContext* context,
                                             guint time_);
static void _tasks_widgets_source_row_on_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                                    GdkDragContext* context,
                                                                    guint time_,
                                                                    gpointer self);
static void tasks_widgets_source_row_on_drag_drop_move_tasks_data_free (gpointer _data);
static void tasks_widgets_source_row_on_drag_drop_move_tasks (TasksWidgetsSourceRow* self,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean tasks_widgets_source_row_on_drag_drop_move_tasks_finish (TasksWidgetsSourceRow* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static gboolean tasks_widgets_source_row_on_drag_drop_move_tasks_co (TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_);
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
VALA_EXTERN void tasks_task_model_get_registry (TasksTaskModel* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN ESourceRegistry* tasks_task_model_get_registry_finish (TasksTaskModel* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void tasks_widgets_source_row_on_drag_drop_move_tasks_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
VALA_EXTERN void tasks_task_model_move_task (TasksTaskModel* self,
                                 ESource* source_list,
                                 ESource* destination_list,
                                 const gchar* task_uid,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN gboolean tasks_task_model_move_task_finish (TasksTaskModel* self,
                                            GAsyncResult* _res_,
                                            GError** error);
VALA_EXTERN ESource* tasks_widgets_source_row_get_source (TasksWidgetsSourceRow* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void ___lambda27_ (Block12Data* _data12_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda27__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
VALA_EXTERN void tasks_widgets_source_row_update_request (TasksWidgetsSourceRow* self);
VALA_EXTERN void tasks_application_set_task_color (ESource* source,
                                       GtkWidget* widget);
VALA_EXTERN void tasks_widgets_source_row_remove_request (TasksWidgetsSourceRow* self);
static gboolean __lambda28_ (TasksWidgetsSourceRow* self);
static gboolean ___lambda28__gsource_func (gpointer self);
static void tasks_widgets_source_row_set_source (TasksWidgetsSourceRow* self,
                                          ESource* value);
static GObject * tasks_widgets_source_row_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
static void tasks_widgets_source_row_finalize (GObject * obj);
static GType tasks_widgets_source_row_get_type_once (void);
static void _vala_tasks_widgets_source_row_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_tasks_widgets_source_row_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const GtkTargetEntry TASKS_APPLICATION_DRAG_AND_DROP_TASK_DATA[1];

static inline gpointer
tasks_widgets_source_row_get_instance_private (TasksWidgetsSourceRow* self)
{
	return G_STRUCT_MEMBER_P (self, TasksWidgetsSourceRow_private_offset);
}

TasksWidgetsSourceRow*
tasks_widgets_source_row_construct (GType object_type,
                                    ESource* source)
{
	TasksWidgetsSourceRow * self = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	self = (TasksWidgetsSourceRow*) g_object_new (object_type, "source", source, NULL);
	return self;
}

TasksWidgetsSourceRow*
tasks_widgets_source_row_new (ESource* source)
{
	return tasks_widgets_source_row_construct (TASKS_WIDGETS_TYPE_SOURCE_ROW, source);
}

static gboolean
_tasks_widgets_source_row_on_drag_motion_gtk_widget_drag_motion (GtkWidget* _sender,
                                                                 GdkDragContext* context,
                                                                 gint x,
                                                                 gint y,
                                                                 guint time_,
                                                                 gpointer self)
{
	gboolean result;
	result = tasks_widgets_source_row_on_drag_motion ((TasksWidgetsSourceRow*) self, context, x, y, time_);
	return result;
}

static gboolean
_tasks_widgets_source_row_on_drag_drop_gtk_widget_drag_drop (GtkWidget* _sender,
                                                             GdkDragContext* context,
                                                             gint x,
                                                             gint y,
                                                             guint time_,
                                                             gpointer self)
{
	gboolean result;
	result = tasks_widgets_source_row_on_drag_drop ((TasksWidgetsSourceRow*) self, context, x, y, time_);
	return result;
}

static void
_tasks_widgets_source_row_on_drag_data_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                               GdkDragContext* context,
                                                                               gint x,
                                                                               gint y,
                                                                               GtkSelectionData* selection_data,
                                                                               guint info,
                                                                               guint time_,
                                                                               gpointer self)
{
	tasks_widgets_source_row_on_drag_data_received ((TasksWidgetsSourceRow*) self, context, x, y, selection_data, info, time_);
}

static void
_tasks_widgets_source_row_on_drag_leave_gtk_widget_drag_leave (GtkWidget* _sender,
                                                               GdkDragContext* context,
                                                               guint time_,
                                                               gpointer self)
{
	tasks_widgets_source_row_on_drag_leave ((TasksWidgetsSourceRow*) self, context, time_);
}

static void
tasks_widgets_source_row_build_drag_and_drop (TasksWidgetsSourceRow* self)
{
	g_return_if_fail (self != NULL);
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_MOTION, TASKS_APPLICATION_DRAG_AND_DROP_TASK_DATA, (gint) G_N_ELEMENTS (TASKS_APPLICATION_DRAG_AND_DROP_TASK_DATA), GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) self, "drag-motion", (GCallback) _tasks_widgets_source_row_on_drag_motion_gtk_widget_drag_motion, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-drop", (GCallback) _tasks_widgets_source_row_on_drag_drop_gtk_widget_drag_drop, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _tasks_widgets_source_row_on_drag_data_received_gtk_widget_drag_data_received, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-leave", (GCallback) _tasks_widgets_source_row_on_drag_leave_gtk_widget_drag_leave, self, 0);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
tasks_widgets_source_row_on_drag_motion (TasksWidgetsSourceRow* self,
                                         GdkDragContext* context,
                                         gint x,
                                         gint y,
                                         guint time)
{
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	_tmp2_ = style_context;
	if (!gtk_style_context_has_class (_tmp2_, "drop-hover")) {
		GtkStyleContext* _tmp3_;
		_tmp3_ = style_context;
		gtk_style_context_add_class (_tmp3_, "drop-hover");
	}
	result = TRUE;
	_g_object_unref0 (style_context);
	return result;
}

static void
tasks_widgets_source_row_on_drag_leave (TasksWidgetsSourceRow* self,
                                        GdkDragContext* context,
                                        guint time_)
{
	GtkStyleContext* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp0_, "drop-hover");
}

static void
tasks_widgets_source_row_on_drag_drop_move_tasks_data_free (gpointer _data)
{
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TasksWidgetsSourceRowOnDragDropMoveTasksData, _data_);
}

static void
tasks_widgets_source_row_on_drag_drop_move_tasks (TasksWidgetsSourceRow* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	TasksWidgetsSourceRow* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (TasksWidgetsSourceRowOnDragDropMoveTasksData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tasks_widgets_source_row_on_drag_drop_move_tasks_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tasks_widgets_source_row_on_drag_drop_move_tasks_co (_data_);
}

static gboolean
tasks_widgets_source_row_on_drag_drop_move_tasks_finish (TasksWidgetsSourceRow* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	gboolean result;
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
tasks_widgets_source_row_on_drag_drop_move_tasks_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tasks_widgets_source_row_on_drag_drop_move_tasks_co (_data_);
}

static gboolean
tasks_widgets_source_row_on_drag_drop_move_tasks_co (TasksWidgetsSourceRowOnDragDropMoveTasksData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = tasks_application_model;
	_data_->_state_ = 1;
	tasks_task_model_get_registry (_data_->_tmp0_, tasks_widgets_source_row_on_drag_drop_move_tasks_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = tasks_task_model_get_registry_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->registry = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->move_successful = TRUE;
	_data_->_tmp2_ = _data_->self->priv->received_drag_data;
	_data_->_tmp3_ = gee_multi_map_get_keys ((GeeMultiMap*) _data_->_tmp2_);
	_data_->source_uids = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->source_uids;
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
		_data_->_source_uid_it = _data_->_tmp5_;
		while (TRUE) {
			_data_->_tmp6_ = _data_->_source_uid_it;
			if (!gee_iterator_next (_data_->_tmp6_)) {
				break;
			}
			_data_->_tmp7_ = _data_->_source_uid_it;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->source_uid = (gchar*) _data_->_tmp8_;
			_data_->_tmp9_ = _data_->registry;
			_data_->_tmp10_ = _data_->source_uid;
			_data_->_tmp11_ = e_source_registry_ref_source (_data_->_tmp9_, _data_->_tmp10_);
			_data_->src_source = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->self->priv->received_drag_data;
			_data_->_tmp13_ = _data_->source_uid;
			_data_->_tmp14_ = gee_multi_map_get ((GeeMultiMap*) _data_->_tmp12_, _data_->_tmp13_);
			_data_->component_uids = _data_->_tmp14_;
			{
				_data_->_tmp15_ = _data_->component_uids;
				_data_->_tmp16_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp15_);
				_data_->_component_uid_it = _data_->_tmp16_;
				while (TRUE) {
					_data_->_tmp17_ = _data_->_component_uid_it;
					if (!gee_iterator_next (_data_->_tmp17_)) {
						break;
					}
					_data_->_tmp18_ = _data_->_component_uid_it;
					_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
					_data_->component_uid = (gchar*) _data_->_tmp19_;
					_data_->_tmp21_ = tasks_application_model;
					_data_->_tmp22_ = _data_->src_source;
					_data_->_tmp23_ = _data_->self->priv->_source;
					_data_->_tmp24_ = _data_->component_uid;
					_data_->_state_ = 2;
					tasks_task_model_move_task (_data_->_tmp21_, _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, tasks_widgets_source_row_on_drag_drop_move_tasks_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp20_ = tasks_task_model_move_task_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_free0 (_data_->component_uid);
						_g_object_unref0 (_data_->_component_uid_it);
						_g_object_unref0 (_data_->component_uids);
						_g_object_unref0 (_data_->src_source);
						_g_free0 (_data_->source_uid);
						_g_object_unref0 (_data_->_source_uid_it);
						_g_object_unref0 (_data_->source_uids);
						_g_object_unref0 (_data_->registry);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					if (!_data_->_tmp20_) {
						_data_->move_successful = FALSE;
					}
					_g_free0 (_data_->component_uid);
				}
				_g_object_unref0 (_data_->_component_uid_it);
			}
			_g_object_unref0 (_data_->component_uids);
			_g_object_unref0 (_data_->src_source);
			_g_free0 (_data_->source_uid);
		}
		_g_object_unref0 (_data_->_source_uid_it);
	}
	_data_->result = _data_->move_successful;
	_g_object_unref0 (_data_->source_uids);
	_g_object_unref0 (_data_->registry);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		TasksWidgetsSourceRow* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->context);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
___lambda27_ (Block12Data* _data12_,
              GObject* obj,
              GAsyncResult* res)
{
	TasksWidgetsSourceRow* self;
	GError* _inner_error0_ = NULL;
	self = _data12_->self;
	g_return_if_fail (res != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = tasks_widgets_source_row_on_drag_drop_move_tasks_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data12_->move_successful = _tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GraniteMessageDialog* error_dialog = NULL;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_message_dialog_new (_ ("Moving task failed"), _ ("There was an error while moving the task to the desired list."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		error_dialog = _tmp4_;
		_tmp5_ = error_dialog;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		granite_message_dialog_show_error_details (_tmp5_, _tmp7_);
		_tmp8_ = error_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp8_);
		_tmp9_ = error_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp9_);
		_g_object_unref0 (error_dialog);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		gtk_drag_finish (_data12_->context, _data12_->drop_successful, _data12_->move_successful, (guint32) _data12_->time);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda27__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda27_ (self, source_object, res);
	block12_data_unref (self);
}

static gboolean
tasks_widgets_source_row_on_drag_drop (TasksWidgetsSourceRow* self,
                                       GdkDragContext* context,
                                       gint x,
                                       gint y,
                                       guint time)
{
	Block12Data* _data12_;
	GdkDragContext* _tmp0_;
	GdkAtom target = (GdkAtom) 0U;
	gboolean _tmp1_ = FALSE;
	GeeHashMultiMap* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (_data12_->context);
	_data12_->context = _tmp0_;
	_data12_->time = time;
	target = gtk_drag_dest_find_target ((GtkWidget*) self, _data12_->context, NULL);
	if (target != GDK_NONE) {
		gtk_drag_get_data ((GtkWidget*) self, _data12_->context, target, (guint32) _data12_->time);
	}
	_data12_->drop_successful = FALSE;
	_data12_->move_successful = FALSE;
	_tmp2_ = self->priv->received_drag_data;
	if (_tmp2_ != NULL) {
		GeeHashMultiMap* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->priv->received_drag_data;
		_tmp4_ = gee_multi_map_get_size ((GeeMultiMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_data12_->drop_successful = TRUE;
		tasks_widgets_source_row_on_drag_drop_move_tasks (self, ____lambda27__gasync_ready_callback, block12_data_ref (_data12_));
	}
	result = _data12_->drop_successful;
	block12_data_unref (_data12_);
	_data12_ = NULL;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
tasks_widgets_source_row_on_drag_data_received (TasksWidgetsSourceRow* self,
                                                GdkDragContext* context,
                                                gint x,
                                                gint y,
                                                GtkSelectionData* selection_data,
                                                guint info,
                                                guint time)
{
	GeeHashMultiMap* _tmp0_;
	gchar* uri_scheme = NULL;
	gchar* _tmp1_;
	gchar** uris = NULL;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint uris_length1;
	gint _uris_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->received_drag_data);
	self->priv->received_drag_data = _tmp0_;
	_tmp1_ = g_strdup ("task://");
	uri_scheme = _tmp1_;
	_tmp3_ = _tmp2_ = gtk_selection_data_get_uris (selection_data);
	uris = _tmp3_;
	uris_length1 = _vala_array_length (_tmp2_);
	_uris_size_ = uris_length1;
	_tmp4_ = uris;
	_tmp4__length1 = uris_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp4_;
		uri_collection_length1 = _tmp4__length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			gchar* _tmp5_;
			gchar* uri = NULL;
			_tmp5_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp5_;
			{
				gchar* source_uid = NULL;
				gchar* component_uid = NULL;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gboolean _tmp24_ = FALSE;
				const gchar* _tmp25_;
				source_uid = NULL;
				component_uid = NULL;
				_tmp6_ = uri;
				_tmp7_ = uri_scheme;
				if (g_str_has_prefix (_tmp6_, _tmp7_)) {
					gchar** uri_parts = NULL;
					const gchar* _tmp8_;
					const gchar* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					gchar** _tmp14_;
					gchar** _tmp15_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					gint uri_parts_length1;
					gint _uri_parts_size_;
					gchar** _tmp17_;
					gint _tmp17__length1;
					_tmp8_ = uri;
					_tmp9_ = uri_scheme;
					_tmp10_ = strlen (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = string_substring (_tmp8_, (glong) _tmp11_, (glong) -1);
					_tmp13_ = _tmp12_;
					_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 0);
					_tmp16_ = _tmp15_;
					_tmp16__length1 = _vala_array_length (_tmp14_);
					_g_free0 (_tmp13_);
					uri_parts = _tmp16_;
					uri_parts_length1 = _tmp16__length1;
					_uri_parts_size_ = uri_parts_length1;
					_tmp17_ = uri_parts;
					_tmp17__length1 = uri_parts_length1;
					if (_tmp17__length1 == 2) {
						gchar** _tmp18_;
						gint _tmp18__length1;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						gchar** _tmp21_;
						gint _tmp21__length1;
						const gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp18_ = uri_parts;
						_tmp18__length1 = uri_parts_length1;
						_tmp19_ = _tmp18_[0];
						_tmp20_ = g_strdup (_tmp19_);
						_g_free0 (source_uid);
						source_uid = _tmp20_;
						_tmp21_ = uri_parts;
						_tmp21__length1 = uri_parts_length1;
						_tmp22_ = _tmp21_[1];
						_tmp23_ = g_strdup (_tmp22_);
						_g_free0 (component_uid);
						component_uid = _tmp23_;
					}
					uri_parts = (_vala_array_free (uri_parts, uri_parts_length1, (GDestroyNotify) g_free), NULL);
				}
				_tmp25_ = source_uid;
				if (_tmp25_ == NULL) {
					_tmp24_ = TRUE;
				} else {
					const gchar* _tmp26_;
					_tmp26_ = component_uid;
					_tmp24_ = _tmp26_ == NULL;
				}
				if (_tmp24_) {
					const gchar* _tmp27_;
					_tmp27_ = uri;
					g_warning ("SourceRow.vala:172: Can't handle drop data: Unexpected uri format: %s", _tmp27_);
				} else {
					const gchar* _tmp28_;
					ESource* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					_tmp28_ = source_uid;
					_tmp29_ = self->priv->_source;
					_tmp30_ = e_source_get_uid (_tmp29_);
					_tmp31_ = _tmp30_;
					if (g_strcmp0 (_tmp28_, _tmp31_) == 0) {
						g_debug ("SourceRow.vala:175: Dropped task onto the same list, so we have nothin" \
"g to do.");
					} else {
						GeeHashMultiMap* _tmp32_;
						const gchar* _tmp33_;
						const gchar* _tmp34_;
						_tmp32_ = self->priv->received_drag_data;
						_tmp33_ = source_uid;
						_tmp34_ = component_uid;
						gee_multi_map_set ((GeeMultiMap*) _tmp32_, _tmp33_, _tmp34_);
					}
				}
				_g_free0 (component_uid);
				_g_free0 (source_uid);
				_g_free0 (uri);
			}
		}
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (uri_scheme);
}

void
tasks_widgets_source_row_update_request (TasksWidgetsSourceRow* self)
{
	ESource* _tmp0_;
	GtkGrid* _tmp1_;
	GtkLabel* _tmp2_;
	ESource* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	ESource* _tmp6_;
	ESourceConnectionStatus _tmp7_;
	ESourceConnectionStatus _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source;
	_tmp1_ = self->priv->source_color;
	tasks_application_set_task_color (_tmp0_, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->display_name_label;
	_tmp3_ = self->priv->_source;
	_tmp4_ = e_source_get_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_label (_tmp2_, _tmp5_);
	_tmp6_ = self->priv->_source;
	_tmp7_ = e_source_get_connection_status (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == E_SOURCE_CONNECTION_STATUS_CONNECTING) {
		GtkStack* _tmp9_;
		_tmp9_ = self->priv->status_stack;
		gtk_stack_set_visible_child_name (_tmp9_, "spinner");
	} else {
		GtkStack* _tmp10_;
		ESource* _tmp11_;
		ESourceConnectionStatus _tmp12_;
		ESourceConnectionStatus _tmp13_;
		_tmp10_ = self->priv->status_stack;
		gtk_stack_set_visible_child_name (_tmp10_, "image");
		_tmp11_ = self->priv->_source;
		_tmp12_ = e_source_get_connection_status (_tmp11_);
		_tmp13_ = _tmp12_;
		switch (_tmp13_) {
			case E_SOURCE_CONNECTION_STATUS_AWAITING_CREDENTIALS:
			{
				GtkImage* _tmp14_;
				GtkImage* _tmp15_;
				_tmp14_ = self->priv->status_image;
				g_object_set (_tmp14_, "icon-name", "dialog-password-symbolic", NULL);
				_tmp15_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _ ("Waiting for login credentials"));
				break;
			}
			case E_SOURCE_CONNECTION_STATUS_DISCONNECTED:
			{
				GtkImage* _tmp16_;
				GtkImage* _tmp17_;
				_tmp16_ = self->priv->status_image;
				g_object_set (_tmp16_, "icon-name", "network-offline-symbolic", NULL);
				_tmp17_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _ ("Currently disconnected from the (possibly remote) data store"));
				break;
			}
			case E_SOURCE_CONNECTION_STATUS_SSL_FAILED:
			{
				GtkImage* _tmp18_;
				GtkImage* _tmp19_;
				_tmp18_ = self->priv->status_image;
				g_object_set (_tmp18_, "icon-name", "security-low-symbolic", NULL);
				_tmp19_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _ ("SSL certificate trust was rejected for the connection"));
				break;
			}
			default:
			{
				GtkImage* _tmp20_;
				GtkImage* _tmp21_;
				_tmp20_ = self->priv->status_image;
				g_object_set (_tmp20_, "gicon", NULL, NULL);
				_tmp21_ = self->priv->status_image;
				gtk_widget_set_tooltip_text ((GtkWidget*) _tmp21_, NULL);
				break;
			}
		}
	}
}

static gboolean
__lambda28_ (TasksWidgetsSourceRow* self)
{
	gboolean result;
	gtk_widget_destroy ((GtkWidget*) self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda28__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda28_ ((TasksWidgetsSourceRow*) self);
	return result;
}

void
tasks_widgets_source_row_remove_request (TasksWidgetsSourceRow* self)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->revealer;
	_tmp2_ = gtk_revealer_get_transition_duration (_tmp1_);
	_tmp3_ = _tmp2_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp3_, ___lambda28__gsource_func, g_object_ref (self), g_object_unref);
}

ESource*
tasks_widgets_source_row_get_source (TasksWidgetsSourceRow* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

static void
tasks_widgets_source_row_set_source (TasksWidgetsSourceRow* self,
                                     ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasks_widgets_source_row_get_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasks_widgets_source_row_properties[TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY]);
	}
}

static GObject *
tasks_widgets_source_row_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksWidgetsSourceRow * self;
	GtkGrid* _tmp0_ = NULL;
	GtkStyleContext* source_color_context = NULL;
	GtkGrid* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkCssProvider* _tmp5_;
	ESource* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkLabel* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkImage* _tmp11_;
	GtkStyleContext* _tmp12_;
	GtkCssProvider* _tmp13_;
	GtkSpinner* spinner = NULL;
	gchar* _tmp14_;
	GtkSpinner* _tmp15_ = NULL;
	GtkStack* _tmp16_;
	GtkStack* _tmp17_;
	GtkImage* _tmp18_;
	GtkStack* _tmp19_;
	GtkSpinner* _tmp20_;
	GtkBox* box = NULL;
	GtkBox* _tmp21_ = NULL;
	GtkBox* _tmp22_;
	GtkGrid* _tmp23_;
	GtkBox* _tmp24_;
	GtkLabel* _tmp25_;
	GtkBox* _tmp26_;
	GtkStack* _tmp27_;
	GtkRevealer* _tmp28_ = NULL;
	GtkRevealer* _tmp29_;
	GtkBox* _tmp30_;
	GtkRevealer* _tmp31_;
	GtkStyleContext* _tmp32_;
	GtkCssProvider* _tmp33_;
	parent_class = G_OBJECT_CLASS (tasks_widgets_source_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->source_color);
	self->priv->source_color = _tmp0_;
	_tmp1_ = self->priv->source_color;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	source_color_context = _tmp2_;
	_tmp3_ = source_color_context;
	gtk_style_context_add_class (_tmp3_, "source-color");
	_tmp4_ = source_color_context;
	_tmp5_ = tasks_widgets_source_row_listrow_provider;
	gtk_style_context_add_provider (_tmp4_, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp6_ = self->priv->_source;
	_tmp7_ = e_source_get_display_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = (GtkLabel*) gtk_label_new (_tmp8_);
	gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp9_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp9_, 9);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->display_name_label);
	self->priv->display_name_label = _tmp9_;
	_tmp10_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp10_, 16);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->status_image);
	self->priv->status_image = _tmp10_;
	_tmp11_ = self->priv->status_image;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	_tmp13_ = tasks_widgets_source_row_listrow_provider;
	gtk_style_context_add_provider (_tmp12_, (GtkStyleProvider*) _tmp13_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp14_ = g_strdup (_ ("Connecting…"));
	_tmp15_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_set (_tmp15_, "active", TRUE, NULL);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp15_, _tmp14_);
	_g_free0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	spinner = _tmp15_;
	_tmp16_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->status_stack);
	self->priv->status_stack = _tmp16_;
	_tmp17_ = self->priv->status_stack;
	_tmp18_ = self->priv->status_image;
	gtk_stack_add_named (_tmp17_, (GtkWidget*) _tmp18_, "image");
	_tmp19_ = self->priv->status_stack;
	_tmp20_ = spinner;
	gtk_stack_add_named (_tmp19_, (GtkWidget*) _tmp20_, "spinner");
	_tmp21_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp21_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp21_, 6);
	g_object_ref_sink (_tmp21_);
	box = _tmp21_;
	_tmp22_ = box;
	_tmp23_ = self->priv->source_color;
	gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
	_tmp24_ = box;
	_tmp25_ = self->priv->display_name_label;
	gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = box;
	_tmp27_ = self->priv->status_stack;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_reveal_child (_tmp28_, TRUE);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->revealer);
	self->priv->revealer = _tmp28_;
	_tmp29_ = self->priv->revealer;
	_tmp30_ = box;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = self->priv->revealer;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp31_);
	_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp33_ = tasks_widgets_source_row_listrow_provider;
	gtk_style_context_add_provider (_tmp32_, (GtkStyleProvider*) _tmp33_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	tasks_widgets_source_row_build_drag_and_drop (self);
	tasks_widgets_source_row_update_request (self);
	_g_object_unref0 (box);
	_g_object_unref0 (spinner);
	return obj;
}

static void
tasks_widgets_source_row_class_init (TasksWidgetsSourceRowClass * klass,
                                     gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	tasks_widgets_source_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksWidgetsSourceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tasks_widgets_source_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tasks_widgets_source_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = tasks_widgets_source_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_widgets_source_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY, tasks_widgets_source_row_properties[TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (tasks_widgets_source_row_listrow_provider);
	tasks_widgets_source_row_listrow_provider = _tmp0_;
	_tmp1_ = tasks_widgets_source_row_listrow_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "io/elementary/tasks/SourceRow.css");
}

static void
tasks_widgets_source_row_instance_init (TasksWidgetsSourceRow * self,
                                        gpointer klass)
{
	self->priv = tasks_widgets_source_row_get_instance_private (self);
}

static void
tasks_widgets_source_row_finalize (GObject * obj)
{
	TasksWidgetsSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	_g_object_unref0 (self->priv->_source);
	_g_object_unref0 (self->priv->source_color);
	_g_object_unref0 (self->priv->status_image);
	_g_object_unref0 (self->priv->display_name_label);
	_g_object_unref0 (self->priv->status_stack);
	_g_object_unref0 (self->priv->revealer);
	_g_object_unref0 (self->priv->received_drag_data);
	G_OBJECT_CLASS (tasks_widgets_source_row_parent_class)->finalize (obj);
}

static GType
tasks_widgets_source_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksWidgetsSourceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_widgets_source_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksWidgetsSourceRow), 0, (GInstanceInitFunc) tasks_widgets_source_row_instance_init, NULL };
	GType tasks_widgets_source_row_type_id;
	tasks_widgets_source_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "TasksWidgetsSourceRow", &g_define_type_info, 0);
	TasksWidgetsSourceRow_private_offset = g_type_add_instance_private (tasks_widgets_source_row_type_id, sizeof (TasksWidgetsSourceRowPrivate));
	return tasks_widgets_source_row_type_id;
}

GType
tasks_widgets_source_row_get_type (void)
{
	static volatile gsize tasks_widgets_source_row_type_id__once = 0;
	if (g_once_init_enter (&tasks_widgets_source_row_type_id__once)) {
		GType tasks_widgets_source_row_type_id;
		tasks_widgets_source_row_type_id = tasks_widgets_source_row_get_type_once ();
		g_once_init_leave (&tasks_widgets_source_row_type_id__once, tasks_widgets_source_row_type_id);
	}
	return tasks_widgets_source_row_type_id__once;
}

static void
_vala_tasks_widgets_source_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	TasksWidgetsSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	switch (property_id) {
		case TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY:
		g_value_set_object (value, tasks_widgets_source_row_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tasks_widgets_source_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	TasksWidgetsSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow);
	switch (property_id) {
		case TASKS_WIDGETS_SOURCE_ROW_SOURCE_PROPERTY:
		tasks_widgets_source_row_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

