/* MainWindow.c generated by valac 0.56.16, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * Copyright 2019-2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <handy.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <pango/pango.h>
#include <cairo-gobject.h>

#define TASKS_MAIN_WINDOW_ACTION_GROUP_PREFIX "win"
#define TASKS_MAIN_WINDOW_ACTION_PREFIX TASKS_MAIN_WINDOW_ACTION_GROUP_PREFIX "."
#define TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST "action-delete-selected-list"
#define TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID "scheduled"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_TYPE_MAIN_WINDOW (tasks_main_window_get_type ())
#define TASKS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindow))
#define TASKS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))
#define TASKS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))

typedef struct _TasksMainWindow TasksMainWindow;
typedef struct _TasksMainWindowClass TasksMainWindowClass;
typedef struct _TasksMainWindowPrivate TasksMainWindowPrivate;

#define TASKS_WIDGETS_TYPE_SOURCE_ROW (tasks_widgets_source_row_get_type ())
#define TASKS_WIDGETS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow))
#define TASKS_WIDGETS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))
#define TASKS_WIDGETS_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SOURCE_ROW))
#define TASKS_WIDGETS_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRowClass))

typedef struct _TasksWidgetsSourceRow TasksWidgetsSourceRow;
typedef struct _TasksWidgetsSourceRowClass TasksWidgetsSourceRowClass;
enum  {
	TASKS_MAIN_WINDOW_0_PROPERTY,
	TASKS_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* tasks_main_window_properties[TASKS_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;

#define TASKS_WIDGETS_TYPE_TASK_LIST_GRID (tasks_widgets_task_list_grid_get_type ())
#define TASKS_WIDGETS_TASK_LIST_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_TASK_LIST_GRID, TasksWidgetsTaskListGrid))
#define TASKS_WIDGETS_TASK_LIST_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_TASK_LIST_GRID, TasksWidgetsTaskListGridClass))
#define TASKS_WIDGETS_IS_TASK_LIST_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_TASK_LIST_GRID))
#define TASKS_WIDGETS_IS_TASK_LIST_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_TASK_LIST_GRID))
#define TASKS_WIDGETS_TASK_LIST_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_TASK_LIST_GRID, TasksWidgetsTaskListGridClass))

typedef struct _TasksWidgetsTaskListGrid TasksWidgetsTaskListGrid;
typedef struct _TasksWidgetsTaskListGridClass TasksWidgetsTaskListGridClass;

#define TASKS_WIDGETS_TYPE_SCHEDULED_ROW (tasks_widgets_scheduled_row_get_type ())
#define TASKS_WIDGETS_SCHEDULED_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_ROW, TasksWidgetsScheduledRow))
#define TASKS_WIDGETS_SCHEDULED_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_ROW, TasksWidgetsScheduledRowClass))
#define TASKS_WIDGETS_IS_SCHEDULED_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_ROW))
#define TASKS_WIDGETS_IS_SCHEDULED_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_ROW))
#define TASKS_WIDGETS_SCHEDULED_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_ROW, TasksWidgetsScheduledRowClass))

typedef struct _TasksWidgetsScheduledRow TasksWidgetsScheduledRow;
typedef struct _TasksWidgetsScheduledRowClass TasksWidgetsScheduledRowClass;
typedef struct _Block5Data Block5Data;

#define TASKS_TYPE_APPLICATION (tasks_application_get_type ())
#define TASKS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_APPLICATION, TasksApplication))
#define TASKS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_APPLICATION, TasksApplicationClass))
#define TASKS_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_APPLICATION))
#define TASKS_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_APPLICATION))
#define TASKS_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_APPLICATION, TasksApplicationClass))

typedef struct _TasksApplication TasksApplication;
typedef struct _TasksApplicationClass TasksApplicationClass;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

#define TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX (tasks_widgets_scheduled_task_list_box_get_type ())
#define TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBox))
#define TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBoxClass))
#define TASKS_WIDGETS_IS_SCHEDULED_TASK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX))
#define TASKS_WIDGETS_IS_SCHEDULED_TASK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX))
#define TASKS_WIDGETS_SCHEDULED_TASK_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBoxClass))

typedef struct _TasksWidgetsScheduledTaskListBox TasksWidgetsScheduledTaskListBox;
typedef struct _TasksWidgetsScheduledTaskListBoxClass TasksWidgetsScheduledTaskListBoxClass;
typedef struct _Block8Data Block8Data;

struct _TasksMainWindow {
	HdyApplicationWindow parent_instance;
	TasksMainWindowPrivate * priv;
};

struct _TasksMainWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _TasksMainWindowPrivate {
	guint configure_id;
	GtkListBox* listbox;
	GeeHashMap* source_rows;
	GeeCollection* collection_sources;
	GtkStack* task_list_grid_stack;
	GtkButtonBox* add_tasklist_buttonbox;
};

struct _Block2Data {
	int _ref_count_;
	TasksMainWindow* self;
	gchar* error_dialog_primary_text;
	gchar* error_dialog_secondary_text;
};

struct _Block3Data {
	int _ref_count_;
	TasksMainWindow* self;
	gchar* error_message;
	gchar* primary_text;
	gchar* secondary_text;
};

struct _Block4Data {
	int _ref_count_;
	TasksMainWindow* self;
	ESource* collection_source;
};

struct _Block5Data {
	int _ref_count_;
	TasksMainWindow* self;
	TasksWidgetsScheduledRow* scheduled_row;
};

struct _Block6Data {
	int _ref_count_;
	Block5Data * _data5_;
	gchar* last_selected_list;
	GAsyncResult* res;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	ESource* source;
};

struct _Block8Data {
	int _ref_count_;
	Block6Data * _data6_;
	ESource* default_task_list;
};

static gint TasksMainWindow_private_offset;
static gpointer tasks_main_window_parent_class = NULL;
static GeeMultiMap* tasks_main_window_action_accelerators;
static GeeMultiMap* tasks_main_window_action_accelerators = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;
VALA_EXTERN GSettings* tasks_application_settings;

VALA_EXTERN GType tasks_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksMainWindow, g_object_unref)
VALA_EXTERN GType tasks_widgets_source_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsSourceRow, g_object_unref)
static void tasks_main_window_action_delete_selected_list (TasksMainWindow* self);
static void _tasks_main_window_action_delete_selected_list_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                      GVariant* parameter,
                                                                                      gpointer self);
VALA_EXTERN TasksMainWindow* tasks_main_window_new (GtkApplication* application);
VALA_EXTERN TasksMainWindow* tasks_main_window_construct (GType object_type,
                                              GtkApplication* application);
static void tasks_main_window_add_new_list (TasksMainWindow* self,
                                     ESource* collection_source);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
VALA_EXTERN void tasks_task_model_add_task_list (TasksTaskModel* self,
                                     ESource* task_list,
                                     ESource* collection_or_sibling,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void tasks_task_model_add_task_list_finish (TasksTaskModel* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void ___lambda31_ (Block2Data* _data2_,
                   GObject* obj,
                   GAsyncResult* res);
static void tasks_main_window_show_error_dialog (TasksMainWindow* self,
                                          const gchar* primary_text,
                                          const gchar* secondary_text,
                                          GError* e);
static void ____lambda31__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda30_ (Block3Data* _data3_);
static gboolean ___lambda30__gsource_func (gpointer self);
VALA_EXTERN ESource* tasks_widgets_source_row_get_source (TasksWidgetsSourceRow* self);
VALA_EXTERN gboolean tasks_task_model_is_remove_task_list_supported (TasksTaskModel* self,
                                                         ESource* source);
VALA_EXTERN void tasks_task_model_remove_task_list (TasksTaskModel* self,
                                        ESource* task_list,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void tasks_task_model_remove_task_list_finish (TasksTaskModel* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void ____lambda29_ (TasksMainWindow* self,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda29__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void tasks_main_window_header_update_func (TasksMainWindow* self,
                                           GtkListBoxRow* lbrow,
                                           GtkListBoxRow* lbbefore);
VALA_EXTERN gchar* tasks_util_get_esource_collection_display_name (ESource* source);
static gint tasks_main_window_sort_function (GtkListBoxRow* lbrow,
                                      GtkListBoxRow* lbbefore,
                                      TasksMainWindow* self);
static void tasks_main_window_add_collection_source (TasksMainWindow* self,
                                              ESource* collection_source);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN guint tasks_util_esource_hash_func (ESource* source);
static guint _tasks_util_esource_hash_func_gee_hash_data_func (gconstpointer v,
                                                        gpointer self);
VALA_EXTERN gboolean tasks_util_esource_equal_func (ESource* a,
                                        ESource* b);
static gboolean _tasks_util_esource_equal_func_gee_equal_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self);
VALA_EXTERN gboolean tasks_task_model_is_add_task_list_supported (TasksTaskModel* self,
                                                      ESource* source);
static void __lambda32_ (Block4Data* _data4_);
static void ___lambda32__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void tasks_main_window_add_source (TasksMainWindow* self,
                                   ESource* source);
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_new (ESource* source);
VALA_EXTERN TasksWidgetsSourceRow* tasks_widgets_source_row_construct (GType object_type,
                                                           ESource* source);
static gboolean ___lambda33_ (TasksMainWindow* self);
static gboolean ____lambda33__gsource_func (gpointer self);
static void tasks_main_window_update_source (TasksMainWindow* self,
                                      ESource* source);
static void tasks_main_window_remove_source (TasksMainWindow* self,
                                      ESource* source);
VALA_EXTERN void tasks_widgets_source_row_update_request (TasksWidgetsSourceRow* self);
VALA_EXTERN GType tasks_widgets_task_list_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsTaskListGrid, g_object_unref)
VALA_EXTERN void tasks_widgets_task_list_grid_update_request (TasksWidgetsTaskListGrid* self);
static gboolean ____lambda102_ (TasksMainWindow* self);
static gboolean _____lambda102__gsource_func (gpointer self);
VALA_EXTERN void tasks_widgets_source_row_remove_request (TasksWidgetsSourceRow* self);
static gboolean __lambda34_ (TasksMainWindow* self);
static gboolean ___lambda34__gsource_func (gpointer self);
static gboolean tasks_main_window_real_configure_event (GtkWidget* base,
                                                 GdkEventConfigure* event);
static gboolean __lambda103_ (TasksMainWindow* self);
static gboolean ___lambda103__gsource_func (gpointer self);
static GObject * tasks_main_window_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN GType tasks_widgets_scheduled_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsScheduledRow, g_object_unref)
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gint _tasks_main_window_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                              GtkListBoxRow* row2,
                                                              gpointer self);
VALA_EXTERN TasksWidgetsScheduledRow* tasks_widgets_scheduled_row_new (void);
VALA_EXTERN TasksWidgetsScheduledRow* tasks_widgets_scheduled_row_construct (GType object_type);
static gboolean _tasks_main_window___lambda104_ (TasksMainWindow* self);
VALA_EXTERN GType tasks_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksApplication, g_object_unref)
VALA_EXTERN void tasks_application_request_background (TasksApplication* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void tasks_application_request_background_finish (TasksApplication* self,
                                                  GAsyncResult* _res_);
static void __lambda105_ (TasksMainWindow* self);
static void ___lambda105__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean __tasks_main_window___lambda104__gtk_widget_delete_event (GtkWidget* _sender,
                                                                   GdkEventAny* event,
                                                                   gpointer self);
static void _tasks_main_window___lambda106_ (TasksMainWindow* self);
static void __tasks_main_window___lambda106__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _tasks_main_window_add_source_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                     ESource* task_list,
                                                                     gpointer self);
static void _tasks_main_window_update_source_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                           ESource* task_list,
                                                                           gpointer self);
static void _tasks_main_window_remove_source_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                          ESource* task_list,
                                                                          gpointer self);
VALA_EXTERN void tasks_task_model_get_registry (TasksTaskModel* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN ESourceRegistry* tasks_task_model_get_registry_finish (TasksTaskModel* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void _tasks_main_window___lambda107_ (Block5Data* _data5_,
                                      GObject* obj,
                                      GAsyncResult* res);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void _tasks_main_window_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                            GtkListBoxRow* before,
                                                                            gpointer self);
static void __lambda108_ (Block6Data* _data6_,
                   GtkListBoxRow* row);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
VALA_EXTERN void tasks_task_model_refresh_task_list (TasksTaskModel* self,
                                         ESource* task_list,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN gboolean tasks_task_model_refresh_task_list_finish (TasksTaskModel* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void ____lambda109_ (Block7Data* _data7_);
static void _____lambda109__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
VALA_EXTERN TasksWidgetsTaskListGrid* tasks_widgets_task_list_grid_new (ESource* source);
VALA_EXTERN TasksWidgetsTaskListGrid* tasks_widgets_task_list_grid_construct (GType object_type,
                                                                  ESource* source);
VALA_EXTERN GType tasks_widgets_scheduled_task_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsScheduledTaskListBox, g_object_unref)
VALA_EXTERN TasksWidgetsScheduledTaskListBox* tasks_widgets_scheduled_task_list_box_new (TasksTaskModel* model);
VALA_EXTERN TasksWidgetsScheduledTaskListBox* tasks_widgets_scheduled_task_list_box_construct (GType object_type,
                                                                                   TasksTaskModel* model);
static void ___lambda108__gtk_list_box_row_selected (GtkListBox* _sender,
                                              GtkListBoxRow* row,
                                              gpointer self);
static void __lambda125_ (TasksMainWindow* self,
                   ESource* collection_source);
static void ___lambda125__gfunc (gconstpointer data,
                          gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void ___lambda126_ (Block8Data* _data8_,
                    ESource* source);
static void ____lambda126__gfunc (gconstpointer data,
                           gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __tasks_main_window___lambda107__gasync_ready_callback (GObject* source_object,
                                                             GAsyncResult* res,
                                                             gpointer self);
static void tasks_main_window_finalize (GObject * obj);
static GType tasks_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry TASKS_MAIN_WINDOW_ACTION_ENTRIES[1] = {{TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST, _tasks_main_window_action_delete_selected_list_gsimple_action_activate_callback}};

static inline gpointer
tasks_main_window_get_instance_private (TasksMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, TasksMainWindow_private_offset);
}

static void
_tasks_main_window_action_delete_selected_list_gsimple_action_activate_callback (GSimpleAction* action,
                                                                                 GVariant* parameter,
                                                                                 gpointer self)
{
	tasks_main_window_action_delete_selected_list ((TasksMainWindow*) self);
}

TasksMainWindow*
tasks_main_window_construct (GType object_type,
                             GtkApplication* application)
{
	TasksMainWindow * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (TasksMainWindow*) g_object_new (object_type, "application", application, "icon-name", "io.elementary.tasks", "title", _ ("Tasks"), NULL);
	return self;
}

TasksMainWindow*
tasks_main_window_new (GtkApplication* application)
{
	return tasks_main_window_construct (TASKS_TYPE_MAIN_WINDOW, application);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data2_->self;
		_g_free0 (_data2_->error_dialog_secondary_text);
		_g_free0 (_data2_->error_dialog_primary_text);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda31_ (Block2Data* _data2_,
              GObject* obj,
              GAsyncResult* res)
{
	TasksMainWindow* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_add_task_list_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("MainWindow.vala:269: %s", _tmp2_);
		_tmp3_ = e;
		tasks_main_window_show_error_dialog (self, _data2_->error_dialog_primary_text, _data2_->error_dialog_secondary_text, _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda31__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda31_ (self, source_object, res);
	block2_data_unref (self);
}

static void
tasks_main_window_add_new_list (TasksMainWindow* self,
                                ESource* collection_source)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection_source != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Creating a new task list failed"));
	_data2_->error_dialog_primary_text = _tmp0_;
	_tmp1_ = g_strdup (_ ("The task list registry may be unavailable or unable to be written to."));
	_data2_->error_dialog_secondary_text = _tmp1_;
	{
		ESource* new_source = NULL;
		ESource* _tmp2_;
		ESourceTaskList* new_source_tasklist_extension = NULL;
		ESourceExtension* _tmp3_;
		ESourceTaskList* _tmp4_;
		ESourceTaskList* _tmp5_;
		TasksTaskModel* _tmp6_;
		_tmp2_ = e_source_new (NULL, NULL, &_inner_error0_);
		new_source = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = e_source_get_extension (new_source, E_SOURCE_EXTENSION_TASK_LIST);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_task_list_get_type (), ESourceTaskList));
		new_source_tasklist_extension = _tmp4_;
		e_source_set_display_name (new_source, _ ("New list"));
		_tmp5_ = new_source_tasklist_extension;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp5_, "#0e9a83");
		_tmp6_ = tasks_application_model;
		tasks_task_model_add_task_list (_tmp6_, new_source, collection_source, ____lambda31__gasync_ready_callback, block2_data_ref (_data2_));
		_g_object_unref0 (new_source_tasklist_extension);
		_g_object_unref0 (new_source);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		GError* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("MainWindow.vala:275: %s", _tmp8_);
		_tmp9_ = e;
		tasks_main_window_show_error_dialog (self, _data2_->error_dialog_primary_text, _data2_->error_dialog_secondary_text, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data3_->self;
		_g_free0 (_data3_->error_message);
		_g_free0 (_data3_->primary_text);
		_g_free0 (_data3_->secondary_text);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda30_ (Block3Data* _data3_)
{
	TasksMainWindow* self;
	GraniteMessageDialog* error_dialog = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GtkWindow* _tmp2_;
	GraniteMessageDialog* _tmp3_ = NULL;
	GraniteMessageDialog* _tmp4_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 ((GtkWindow*) self);
	_tmp3_ = granite_message_dialog_new (_data3_->primary_text, _data3_->secondary_text, (GIcon*) _tmp1_, GTK_BUTTONS_CLOSE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	error_dialog = _tmp4_;
	granite_message_dialog_show_error_details (error_dialog, _data3_->error_message);
	gtk_dialog_run ((GtkDialog*) error_dialog);
	gtk_widget_destroy ((GtkWidget*) error_dialog);
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (error_dialog);
	return result;
}

static gboolean
___lambda30__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda30_ (self);
	return result;
}

static void
tasks_main_window_show_error_dialog (TasksMainWindow* self,
                                     const gchar* primary_text,
                                     const gchar* secondary_text,
                                     GError* e)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (primary_text != NULL);
	g_return_if_fail (secondary_text != NULL);
	g_return_if_fail (e != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = g_strdup (primary_text);
	_g_free0 (_data3_->primary_text);
	_data3_->primary_text = _tmp0_;
	_tmp1_ = g_strdup (secondary_text);
	_g_free0 (_data3_->secondary_text);
	_data3_->secondary_text = _tmp1_;
	_tmp2_ = e->message;
	_tmp3_ = g_strdup (_tmp2_);
	_data3_->error_message = _tmp3_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda30__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
____lambda29_ (TasksMainWindow* self,
               GObject* obj,
               GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_remove_task_list_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("MainWindow.vala:326: %s", _tmp2_);
		_tmp3_ = e;
		tasks_main_window_show_error_dialog (self, _ ("Deleting the task list failed"), _ ("The task list registry may be unavailable or unable to be written to."), _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda29__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda29_ ((TasksMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
tasks_main_window_action_delete_selected_list (TasksMainWindow* self)
{
	TasksWidgetsSourceRow* list_row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	TasksWidgetsSourceRow* _tmp2_;
	ESource* source = NULL;
	TasksWidgetsSourceRow* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	ESource* _tmp6_;
	TasksTaskModel* _tmp7_;
	ESource* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
	list_row = _tmp2_;
	_tmp3_ = list_row;
	_tmp4_ = tasks_widgets_source_row_get_source (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	source = _tmp6_;
	_tmp7_ = tasks_application_model;
	_tmp8_ = source;
	if (tasks_task_model_is_remove_task_list_supported (_tmp7_, _tmp8_)) {
		GraniteMessageDialog* message_dialog = NULL;
		ESource* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GThemedIcon* _tmp14_;
		GtkWindow* _tmp15_;
		GraniteMessageDialog* _tmp16_ = NULL;
		GraniteMessageDialog* _tmp17_;
		GtkWidget* trash_button = NULL;
		GraniteMessageDialog* _tmp18_;
		GtkWidget* _tmp19_;
		GtkWidget* _tmp20_;
		GtkStyleContext* _tmp21_;
		GtkResponseType response = 0;
		GraniteMessageDialog* _tmp22_;
		GraniteMessageDialog* _tmp23_;
		_tmp9_ = source;
		_tmp10_ = e_source_get_display_name (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf (_ ("Delete “%s”?"), _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = (GThemedIcon*) g_themed_icon_new ("dialog-question");
		_tmp15_ = _g_object_ref0 ((GtkWindow*) self);
		_tmp16_ = granite_message_dialog_new_with_image_from_icon_name (_tmp13_, _ ("The list and all its tasks will be permanently deleted. If you've shar" \
"ed this list, other people will no longer have access."), "edit-delete", GTK_BUTTONS_CANCEL);
		granite_message_dialog_set_badge_icon (_tmp16_, (GIcon*) _tmp14_);
		_g_object_unref0 (_tmp14_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp16_, _tmp15_);
		_g_object_unref0 (_tmp15_);
		g_object_ref_sink (_tmp16_);
		_tmp17_ = _tmp16_;
		_g_free0 (_tmp13_);
		message_dialog = _tmp17_;
		_tmp18_ = message_dialog;
		_tmp19_ = gtk_dialog_add_button ((GtkDialog*) _tmp18_, _ ("Delete Anyway"), (gint) GTK_RESPONSE_YES);
		trash_button = _tmp19_;
		_tmp20_ = trash_button;
		_tmp21_ = gtk_widget_get_style_context (_tmp20_);
		gtk_style_context_add_class (_tmp21_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
		_tmp22_ = message_dialog;
		response = (GtkResponseType) gtk_dialog_run ((GtkDialog*) _tmp22_);
		_tmp23_ = message_dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp23_);
		if (response == GTK_RESPONSE_YES) {
			TasksTaskModel* _tmp24_;
			ESource* _tmp25_;
			_tmp24_ = tasks_application_model;
			_tmp25_ = source;
			tasks_task_model_remove_task_list (_tmp24_, _tmp25_, _____lambda29__gasync_ready_callback, g_object_ref (self));
		}
		_g_object_unref0 (message_dialog);
	} else {
		gdk_beep ();
	}
	_g_object_unref0 (source);
	_g_object_unref0 (list_row);
}

static void
tasks_main_window_header_update_func (TasksMainWindow* self,
                                      GtkListBoxRow* lbrow,
                                      GtkListBoxRow* lbbefore)
{
	TasksWidgetsSourceRow* row = NULL;
	TasksWidgetsSourceRow* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GraniteHeaderLabel* header_label = NULL;
	TasksWidgetsSourceRow* _tmp14_;
	ESource* _tmp15_;
	ESource* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GraniteHeaderLabel* _tmp19_ = NULL;
	GraniteHeaderLabel* _tmp20_;
	TasksWidgetsSourceRow* _tmp21_;
	GraniteHeaderLabel* _tmp22_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbrow != NULL);
	if (!TASKS_WIDGETS_IS_SOURCE_ROW (lbrow)) {
		return;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
	row = _tmp0_;
	if (lbbefore != NULL) {
		_tmp1_ = TASKS_WIDGETS_IS_SOURCE_ROW (lbbefore);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		TasksWidgetsSourceRow* before = NULL;
		TasksWidgetsSourceRow* _tmp2_;
		TasksWidgetsSourceRow* _tmp3_;
		ESource* _tmp4_;
		ESource* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		TasksWidgetsSourceRow* _tmp8_;
		ESource* _tmp9_;
		ESource* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
		before = _tmp2_;
		_tmp3_ = row;
		_tmp4_ = tasks_widgets_source_row_get_source (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = e_source_get_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = before;
		_tmp9_ = tasks_widgets_source_row_get_source (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e_source_get_parent (_tmp10_);
		_tmp12_ = _tmp11_;
		if (g_strcmp0 (_tmp7_, _tmp12_) == 0) {
			TasksWidgetsSourceRow* _tmp13_;
			_tmp13_ = row;
			gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp13_, NULL);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_g_object_unref0 (before);
	}
	_tmp14_ = row;
	_tmp15_ = tasks_widgets_source_row_get_source (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = tasks_util_get_esource_collection_display_name (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = granite_header_label_new (_tmp18_);
	gtk_label_set_ellipsize ((GtkLabel*) _tmp19_, PANGO_ELLIPSIZE_MIDDLE);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp19_, 6);
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	header_label = _tmp20_;
	_tmp21_ = row;
	_tmp22_ = header_label;
	gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp21_, (GtkWidget*) _tmp22_);
	_g_object_unref0 (header_label);
	_g_object_unref0 (row);
}

static gint
tasks_main_window_sort_function (GtkListBoxRow* lbrow,
                                 GtkListBoxRow* lbbefore,
                                 TasksMainWindow* self)
{
	TasksWidgetsSourceRow* row = NULL;
	TasksWidgetsSourceRow* _tmp0_;
	TasksWidgetsSourceRow* before = NULL;
	TasksWidgetsSourceRow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	TasksWidgetsSourceRow* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (lbrow != NULL, 0);
	g_return_val_if_fail (lbbefore != NULL, 0);
	if (!TASKS_WIDGETS_IS_SOURCE_ROW (lbrow)) {
		result = -1;
		return result;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
	row = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
	before = _tmp1_;
	_tmp3_ = row;
	_tmp4_ = tasks_widgets_source_row_get_source (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_source_get_parent (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		TasksWidgetsSourceRow* _tmp8_;
		ESource* _tmp9_;
		ESource* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp8_ = before;
		_tmp9_ = tasks_widgets_source_row_get_source (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e_source_get_parent (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp2_ = _tmp12_ == NULL;
	}
	if (_tmp2_) {
		result = -1;
		_g_object_unref0 (before);
		_g_object_unref0 (row);
		return result;
	} else {
		TasksWidgetsSourceRow* _tmp13_;
		ESource* _tmp14_;
		ESource* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		TasksWidgetsSourceRow* _tmp18_;
		ESource* _tmp19_;
		ESource* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp13_ = row;
		_tmp14_ = tasks_widgets_source_row_get_source (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = e_source_get_parent (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = before;
		_tmp19_ = tasks_widgets_source_row_get_source (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = e_source_get_parent (_tmp20_);
		_tmp22_ = _tmp21_;
		if (g_strcmp0 (_tmp17_, _tmp22_) == 0) {
			TasksWidgetsSourceRow* _tmp23_;
			ESource* _tmp24_;
			ESource* _tmp25_;
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			TasksWidgetsSourceRow* _tmp28_;
			ESource* _tmp29_;
			ESource* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			_tmp23_ = row;
			_tmp24_ = tasks_widgets_source_row_get_source (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = e_source_get_display_name (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = before;
			_tmp29_ = tasks_widgets_source_row_get_source (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = e_source_get_display_name (_tmp30_);
			_tmp32_ = _tmp31_;
			result = g_utf8_collate (_tmp27_, _tmp32_);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return result;
		} else {
			TasksWidgetsSourceRow* _tmp33_;
			ESource* _tmp34_;
			ESource* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			TasksWidgetsSourceRow* _tmp38_;
			ESource* _tmp39_;
			ESource* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp33_ = row;
			_tmp34_ = tasks_widgets_source_row_get_source (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = e_source_get_parent (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = before;
			_tmp39_ = tasks_widgets_source_row_get_source (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = e_source_get_parent (_tmp40_);
			_tmp42_ = _tmp41_;
			result = g_utf8_collate (_tmp37_, _tmp42_);
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return result;
		}
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->collection_source);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static guint
_tasks_util_esource_hash_func_gee_hash_data_func (gconstpointer v,
                                                  gpointer self)
{
	guint result;
	result = tasks_util_esource_hash_func ((ESource*) v);
	return result;
}

static gboolean
_tasks_util_esource_equal_func_gee_equal_data_func (gconstpointer a,
                                                    gconstpointer b,
                                                    gpointer self)
{
	gboolean result;
	result = tasks_util_esource_equal_func ((ESource*) a, (ESource*) b);
	return result;
}

static void
__lambda32_ (Block4Data* _data4_)
{
	TasksMainWindow* self;
	self = _data4_->self;
	tasks_main_window_add_new_list (self, _data4_->collection_source);
}

static void
___lambda32__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda32_ (self);
}

static void
tasks_main_window_add_collection_source (TasksMainWindow* self,
                                         ESource* collection_source)
{
	Block4Data* _data4_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	ESourceTaskList* collection_source_tasklist_extension = NULL;
	ESourceExtension* _tmp3_;
	ESourceTaskList* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp13_;
	GtkModelButton* source_button = NULL;
	gchar* _tmp14_;
	TasksTaskModel* _tmp15_;
	GtkModelButton* _tmp16_ = NULL;
	GtkModelButton* _tmp17_;
	GtkButtonBox* _tmp18_;
	GtkModelButton* _tmp19_;
	GtkButtonBox* _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (collection_source != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (collection_source);
	_g_object_unref0 (_data4_->collection_source);
	_data4_->collection_source = _tmp0_;
	_tmp1_ = self->priv->collection_sources;
	if (_tmp1_ == NULL) {
		GeeHashSet* _tmp2_;
		_tmp2_ = gee_hash_set_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tasks_util_esource_hash_func_gee_hash_data_func, NULL, NULL, _tasks_util_esource_equal_func_gee_equal_data_func, NULL, NULL);
		_g_object_unref0 (self->priv->collection_sources);
		self->priv->collection_sources = (GeeCollection*) _tmp2_;
	}
	_tmp3_ = e_source_get_extension (_data4_->collection_source, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_task_list_get_type (), ESourceTaskList));
	collection_source_tasklist_extension = _tmp4_;
	_tmp7_ = self->priv->collection_sources;
	if (gee_collection_contains (_tmp7_, _data4_->collection_source)) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp8_ = e_source_get_enabled (_data4_->collection_source);
		_tmp9_ = _tmp8_;
		_tmp6_ = !_tmp9_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ESourceTaskList* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = collection_source_tasklist_extension;
		_tmp11_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp5_ = !_tmp12_;
	}
	if (_tmp5_) {
		_g_object_unref0 (collection_source_tasklist_extension);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp13_ = self->priv->collection_sources;
	gee_collection_add (_tmp13_, _data4_->collection_source);
	_tmp14_ = tasks_util_get_esource_collection_display_name (_data4_->collection_source);
	_tmp15_ = tasks_application_model;
	_tmp16_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp16_, "text", _tmp14_, NULL);
	_g_free0 (_tmp14_);
	gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, tasks_task_model_is_add_task_list_supported (_tmp15_, _data4_->collection_source));
	g_object_ref_sink (_tmp16_);
	source_button = _tmp16_;
	_tmp17_ = source_button;
	g_signal_connect_data ((GtkButton*) _tmp17_, "clicked", (GCallback) ___lambda32__gtk_button_clicked, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp18_ = self->priv->add_tasklist_buttonbox;
	_tmp19_ = source_button;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->add_tasklist_buttonbox;
	gtk_widget_show_all ((GtkWidget*) _tmp20_);
	_g_object_unref0 (source_button);
	_g_object_unref0 (collection_source_tasklist_extension);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static gboolean
___lambda33_ (TasksMainWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	gboolean result;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->listbox;
	gtk_list_box_invalidate_headers (_tmp1_);
	_tmp2_ = self->priv->listbox;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda33__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda33_ ((TasksMainWindow*) self);
	return result;
}

static void
tasks_main_window_add_source (TasksMainWindow* self,
                              ESource* source)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeHashMap* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->source_rows;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TASKS_WIDGETS_TYPE_SOURCE_ROW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->source_rows);
		self->priv->source_rows = _tmp1_;
	}
	_tmp2_ = e_source_dup_display_name (source);
	_tmp3_ = _tmp2_;
	g_debug ("MainWindow.vala:407: Adding row '%s'", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->source_rows;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, source)) {
		GeeHashMap* _tmp5_;
		TasksWidgetsSourceRow* _tmp6_;
		TasksWidgetsSourceRow* _tmp7_;
		GtkListBox* _tmp8_;
		GeeHashMap* _tmp9_;
		gpointer _tmp10_;
		TasksWidgetsSourceRow* _tmp11_;
		_tmp5_ = self->priv->source_rows;
		_tmp6_ = tasks_widgets_source_row_new (source);
		g_object_ref_sink (_tmp6_);
		_tmp7_ = _tmp6_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, source, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_tmp8_ = self->priv->listbox;
		_tmp9_ = self->priv->source_rows;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, source);
		_tmp11_ = (TasksWidgetsSourceRow*) _tmp10_;
		gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda33__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gboolean
____lambda102_ (TasksMainWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->listbox;
	gtk_list_box_invalidate_headers (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_____lambda102__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda102_ ((TasksMainWindow*) self);
	return result;
}

static void
tasks_main_window_update_source (TasksMainWindow* self,
                                 ESource* source)
{
	ESourceTaskList* list = NULL;
	ESourceExtension* _tmp0_;
	ESourceTaskList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESourceTaskList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_task_list_get_type (), ESourceTaskList));
	list = _tmp1_;
	_tmp3_ = list;
	_tmp4_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != TRUE) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = e_source_get_enabled (source);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ != TRUE;
	}
	if (_tmp2_) {
		tasks_main_window_remove_source (self, source);
	} else {
		GeeHashMap* _tmp8_;
		_tmp8_ = self->priv->source_rows;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp8_, source)) {
			tasks_main_window_add_source (self, source);
		} else {
			GeeHashMap* _tmp9_;
			gpointer _tmp10_;
			TasksWidgetsSourceRow* _tmp11_;
			TasksWidgetsTaskListGrid* task_list_grid = NULL;
			GtkStack* _tmp12_;
			GtkWidget* _tmp13_;
			TasksWidgetsTaskListGrid* _tmp14_;
			TasksWidgetsTaskListGrid* _tmp15_;
			_tmp9_ = self->priv->source_rows;
			_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, source);
			_tmp11_ = (TasksWidgetsSourceRow*) _tmp10_;
			tasks_widgets_source_row_update_request (_tmp11_);
			_g_object_unref0 (_tmp11_);
			_tmp12_ = self->priv->task_list_grid_stack;
			_tmp13_ = gtk_stack_get_visible_child (_tmp12_);
			_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TASKS_WIDGETS_TYPE_TASK_LIST_GRID, TasksWidgetsTaskListGrid));
			task_list_grid = _tmp14_;
			_tmp15_ = task_list_grid;
			if (_tmp15_ != NULL) {
				TasksWidgetsTaskListGrid* _tmp16_;
				_tmp16_ = task_list_grid;
				tasks_widgets_task_list_grid_update_request (_tmp16_);
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda102__gsource_func, g_object_ref (self), g_object_unref);
			_g_object_unref0 (task_list_grid);
		}
	}
	_g_object_unref0 (list);
}

static gboolean
__lambda34_ (TasksMainWindow* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->listbox;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->listbox;
	gtk_list_box_invalidate_headers (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda34__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda34_ ((TasksMainWindow*) self);
	return result;
}

static void
tasks_main_window_remove_source (TasksMainWindow* self,
                                 ESource* source)
{
	GtkListBox* _tmp0_;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	TasksWidgetsSourceRow* _tmp3_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	TasksWidgetsSourceRow* _tmp6_;
	GeeHashMap* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = self->priv->source_rows;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, source);
	_tmp3_ = (TasksWidgetsSourceRow*) _tmp2_;
	gtk_list_box_unselect_row (_tmp0_, (GtkListBoxRow*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->source_rows;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, source);
	_tmp6_ = (TasksWidgetsSourceRow*) _tmp5_;
	tasks_widgets_source_row_remove_request (_tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->source_rows;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp7_, source, NULL);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda34__gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
__lambda103_ (TasksMainWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self->priv->configure_id = (guint) 0;
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = tasks_application_settings;
		g_settings_set_boolean (_tmp2_, "window-maximized", TRUE);
	} else {
		GSettings* _tmp3_;
		GdkRectangle rect = {0};
		GtkAllocation _tmp4_ = {0};
		GSettings* _tmp5_;
		GdkRectangle _tmp6_;
		GdkRectangle _tmp7_;
		gint root_x = 0;
		gint root_y = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GSettings* _tmp10_;
		_tmp3_ = tasks_application_settings;
		g_settings_set_boolean (_tmp3_, "window-maximized", FALSE);
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
		rect = _tmp4_;
		_tmp5_ = tasks_application_settings;
		_tmp6_ = rect;
		_tmp7_ = rect;
		g_settings_set (_tmp5_, "window-size", "(ii)", _tmp6_.width, _tmp7_.height);
		gtk_window_get_position ((GtkWindow*) self, &_tmp8_, &_tmp9_);
		root_x = _tmp8_;
		root_y = _tmp9_;
		_tmp10_ = tasks_application_settings;
		g_settings_set (_tmp10_, "window-position", "(ii)", root_x, root_y);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda103__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda103_ ((TasksMainWindow*) self);
	return result;
}

static gboolean
tasks_main_window_real_configure_event (GtkWidget* base,
                                        GdkEventConfigure* event)
{
	TasksMainWindow * self;
	gboolean result;
	self = (TasksMainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->configure_id != ((guint) 0)) {
		g_source_remove (self->priv->configure_id);
	}
	self->priv->configure_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda103__gsource_func, g_object_ref (self), g_object_unref);
	result = GTK_WIDGET_CLASS (tasks_main_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->scheduled_row);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gint
_tasks_main_window_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                         GtkListBoxRow* row2,
                                                         gpointer self)
{
	gint result;
	result = tasks_main_window_sort_function (row1, row2, (TasksMainWindow*) self);
	return result;
}

static void
__lambda105_ (TasksMainWindow* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda105__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda105_ ((TasksMainWindow*) self);
	g_object_unref (self);
}

static gboolean
_tasks_main_window___lambda104_ (TasksMainWindow* self)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	tasks_application_request_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TASKS_TYPE_APPLICATION, TasksApplication), ___lambda105__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__tasks_main_window___lambda104__gtk_widget_delete_event (GtkWidget* _sender,
                                                          GdkEventAny* event,
                                                          gpointer self)
{
	gboolean result;
	result = _tasks_main_window___lambda104_ ((TasksMainWindow*) self);
	return result;
}

static void
_tasks_main_window___lambda106_ (TasksMainWindow* self)
{
	GError* _inner_error0_ = NULL;
	{
		g_app_info_launch_default_for_uri ("settings://accounts/online", NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("MainWindow.vala:148: Failed to open account settings: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__tasks_main_window___lambda106__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_tasks_main_window___lambda106_ ((TasksMainWindow*) self);
}

static void
_tasks_main_window_add_source_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                ESource* task_list,
                                                                gpointer self)
{
	tasks_main_window_add_source ((TasksMainWindow*) self, task_list);
}

static void
_tasks_main_window_update_source_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                      ESource* task_list,
                                                                      gpointer self)
{
	tasks_main_window_update_source ((TasksMainWindow*) self, task_list);
}

static void
_tasks_main_window_remove_source_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                     ESource* task_list,
                                                                     gpointer self)
{
	tasks_main_window_remove_source ((TasksMainWindow*) self, task_list);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data6_->_data5_->self;
		_g_free0 (_data6_->last_selected_list);
		_g_object_unref0 (_data6_->res);
		block5_data_unref (_data6_->_data5_);
		_data6_->_data5_ = NULL;
		g_slice_free (Block6Data, _data6_);
	}
}

static void
_tasks_main_window_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                       GtkListBoxRow* before,
                                                                       gpointer self)
{
	tasks_main_window_header_update_func ((TasksMainWindow*) self, row, before);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data7_->_data6_->_data5_->self;
		_g_object_unref0 (_data7_->source);
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static void
____lambda109_ (Block7Data* _data7_)
{
	Block6Data* _data6_;
	Block5Data* _data5_;
	TasksMainWindow* self;
	GError* _inner_error0_ = NULL;
	_data6_ = _data7_->_data6_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_refresh_task_list_finish (_tmp0_, _data6_->res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		ESource* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data7_->source;
		_tmp2_ = e_source_dup_display_name (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("MainWindow.vala:181: Error syncing task list '%s': %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda109__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	____lambda109_ (self);
	block7_data_unref (self);
}

static void
__lambda108_ (Block6Data* _data6_,
              GtkListBoxRow* row)
{
	Block5Data* _data5_;
	TasksMainWindow* self;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	if (row != NULL) {
		TasksWidgetsTaskListGrid* task_list_grid = NULL;
		TasksWidgetsTaskListGrid* _tmp35_;
		if (TASKS_WIDGETS_IS_SOURCE_ROW (row)) {
			Block7Data* _data7_;
			ESource* _tmp0_;
			ESource* _tmp1_;
			ESource* _tmp2_;
			gchar* source_uid = NULL;
			ESource* _tmp3_;
			gchar* _tmp4_;
			TasksTaskModel* _tmp5_;
			ESource* _tmp6_;
			GtkStack* _tmp7_;
			const gchar* _tmp8_;
			GtkWidget* _tmp9_;
			TasksWidgetsTaskListGrid* _tmp10_;
			TasksWidgetsTaskListGrid* _tmp11_;
			GtkStack* _tmp17_;
			const gchar* _tmp18_;
			GSettings* _tmp19_;
			const gchar* _tmp20_;
			GAction* _tmp21_;
			TasksTaskModel* _tmp22_;
			ESource* _tmp23_;
			_data7_ = g_slice_new0 (Block7Data);
			_data7_->_ref_count_ = 1;
			_data7_->_data6_ = block6_data_ref (_data6_);
			_tmp0_ = tasks_widgets_source_row_get_source (G_TYPE_CHECK_INSTANCE_CAST (row, TASKS_WIDGETS_TYPE_SOURCE_ROW, TasksWidgetsSourceRow));
			_tmp1_ = _tmp0_;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			_data7_->source = _tmp2_;
			_tmp3_ = _data7_->source;
			_tmp4_ = e_source_dup_uid (_tmp3_);
			source_uid = _tmp4_;
			_tmp5_ = tasks_application_model;
			_tmp6_ = _data7_->source;
			tasks_task_model_refresh_task_list (_tmp5_, _tmp6_, NULL, _____lambda109__gasync_ready_callback, block7_data_ref (_data7_));
			_tmp7_ = self->priv->task_list_grid_stack;
			_tmp8_ = source_uid;
			_tmp9_ = gtk_stack_get_child_by_name (_tmp7_, _tmp8_);
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TASKS_WIDGETS_TYPE_TASK_LIST_GRID, TasksWidgetsTaskListGrid));
			_g_object_unref0 (task_list_grid);
			task_list_grid = _tmp10_;
			_tmp11_ = task_list_grid;
			if (_tmp11_ == NULL) {
				ESource* _tmp12_;
				TasksWidgetsTaskListGrid* _tmp13_;
				GtkStack* _tmp14_;
				TasksWidgetsTaskListGrid* _tmp15_;
				const gchar* _tmp16_;
				_tmp12_ = _data7_->source;
				_tmp13_ = tasks_widgets_task_list_grid_new (_tmp12_);
				g_object_ref_sink (_tmp13_);
				_g_object_unref0 (task_list_grid);
				task_list_grid = _tmp13_;
				_tmp14_ = self->priv->task_list_grid_stack;
				_tmp15_ = task_list_grid;
				_tmp16_ = source_uid;
				gtk_stack_add_named (_tmp14_, (GtkWidget*) _tmp15_, _tmp16_);
			}
			_tmp17_ = self->priv->task_list_grid_stack;
			_tmp18_ = source_uid;
			gtk_stack_set_visible_child_name (_tmp17_, _tmp18_);
			_tmp19_ = tasks_application_settings;
			_tmp20_ = source_uid;
			g_settings_set_string (_tmp19_, "selected-list", _tmp20_);
			_tmp21_ = g_action_map_lookup_action ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
			_tmp22_ = tasks_application_model;
			_tmp23_ = _data7_->source;
			g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, g_simple_action_get_type (), GSimpleAction), tasks_task_model_is_remove_task_list_supported (_tmp22_, _tmp23_));
			_g_free0 (source_uid);
			block7_data_unref (_data7_);
			_data7_ = NULL;
		} else {
			if (TASKS_WIDGETS_IS_SCHEDULED_ROW (row)) {
				TasksWidgetsScheduledTaskListBox* scheduled_task_list_grid = NULL;
				GtkStack* _tmp24_;
				GtkWidget* _tmp25_;
				TasksWidgetsScheduledTaskListBox* _tmp26_;
				TasksWidgetsScheduledTaskListBox* _tmp27_;
				GtkStack* _tmp32_;
				GSettings* _tmp33_;
				GAction* _tmp34_;
				_tmp24_ = self->priv->task_list_grid_stack;
				_tmp25_ = gtk_stack_get_child_by_name (_tmp24_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TASKS_WIDGETS_TYPE_SCHEDULED_TASK_LIST_BOX, TasksWidgetsScheduledTaskListBox));
				scheduled_task_list_grid = _tmp26_;
				_tmp27_ = scheduled_task_list_grid;
				if (_tmp27_ == NULL) {
					TasksTaskModel* _tmp28_;
					TasksWidgetsScheduledTaskListBox* _tmp29_;
					GtkStack* _tmp30_;
					TasksWidgetsScheduledTaskListBox* _tmp31_;
					_tmp28_ = tasks_application_model;
					_tmp29_ = tasks_widgets_scheduled_task_list_box_new (_tmp28_);
					g_object_ref_sink (_tmp29_);
					_g_object_unref0 (scheduled_task_list_grid);
					scheduled_task_list_grid = _tmp29_;
					_tmp30_ = self->priv->task_list_grid_stack;
					_tmp31_ = scheduled_task_list_grid;
					gtk_stack_add_named (_tmp30_, (GtkWidget*) _tmp31_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				}
				_tmp32_ = self->priv->task_list_grid_stack;
				gtk_stack_set_visible_child_name (_tmp32_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				_tmp33_ = tasks_application_settings;
				g_settings_set_string (_tmp33_, "selected-list", TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID);
				_tmp34_ = g_action_map_lookup_action ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
				g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, g_simple_action_get_type (), GSimpleAction), FALSE);
				_g_object_unref0 (scheduled_task_list_grid);
			}
		}
		_tmp35_ = task_list_grid;
		if (_tmp35_ != NULL) {
			TasksWidgetsTaskListGrid* _tmp36_;
			_tmp36_ = task_list_grid;
			tasks_widgets_task_list_grid_update_request (_tmp36_);
		}
		_g_object_unref0 (task_list_grid);
	} else {
		GAction* _tmp37_;
		GtkListBoxRow* first_row = NULL;
		GtkListBox* _tmp38_;
		GtkListBoxRow* _tmp39_;
		GtkListBoxRow* _tmp40_;
		GtkListBoxRow* _tmp41_;
		_tmp37_ = g_action_map_lookup_action ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, g_simple_action_get_type (), GSimpleAction), FALSE);
		_tmp38_ = self->priv->listbox;
		_tmp39_ = gtk_list_box_get_row_at_index (_tmp38_, 0);
		_tmp40_ = _g_object_ref0 (_tmp39_);
		first_row = _tmp40_;
		_tmp41_ = first_row;
		if (_tmp41_ != NULL) {
			GtkListBox* _tmp42_;
			GtkListBoxRow* _tmp43_;
			_tmp42_ = self->priv->listbox;
			_tmp43_ = first_row;
			gtk_list_box_select_row (_tmp42_, _tmp43_);
		}
		_g_object_unref0 (first_row);
	}
}

static void
___lambda108__gtk_list_box_row_selected (GtkListBox* _sender,
                                         GtkListBoxRow* row,
                                         gpointer self)
{
	__lambda108_ (self, row);
}

static void
__lambda125_ (TasksMainWindow* self,
              ESource* collection_source)
{
	g_return_if_fail (collection_source != NULL);
	tasks_main_window_add_collection_source (self, collection_source);
}

static void
___lambda125__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda125_ ((TasksMainWindow*) self, (ESource*) data);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		TasksMainWindow* self;
		self = _data8_->_data6_->_data5_->self;
		_g_object_unref0 (_data8_->default_task_list);
		block6_data_unref (_data8_->_data6_);
		_data8_->_data6_ = NULL;
		g_slice_free (Block8Data, _data8_);
	}
}

static void
___lambda126_ (Block8Data* _data8_,
               ESource* source)
{
	Block6Data* _data6_;
	Block5Data* _data5_;
	TasksMainWindow* self;
	ESourceTaskList* list = NULL;
	ESourceExtension* _tmp0_;
	ESourceTaskList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ESourceTaskList* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	_data6_ = _data8_->_data6_;
	_data5_ = _data6_->_data5_;
	self = _data5_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_task_list_get_type (), ESourceTaskList));
	list = _tmp1_;
	_tmp4_ = list;
	_tmp5_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == TRUE) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = e_source_get_enabled (source);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp8_ == TRUE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !e_source_has_extension (source, E_SOURCE_EXTENSION_COLLECTION);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		tasks_main_window_add_source (self, source);
		_tmp10_ = _data6_->last_selected_list;
		if (g_strcmp0 (_tmp10_, "") == 0) {
			ESource* _tmp11_;
			_tmp11_ = _data8_->default_task_list;
			_tmp9_ = _tmp11_ == source;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkListBox* _tmp12_;
			GeeHashMap* _tmp13_;
			gpointer _tmp14_;
			TasksWidgetsSourceRow* _tmp15_;
			_tmp12_ = self->priv->listbox;
			_tmp13_ = self->priv->source_rows;
			_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, source);
			_tmp15_ = (TasksWidgetsSourceRow*) _tmp14_;
			gtk_list_box_select_row (_tmp12_, (GtkListBoxRow*) _tmp15_);
			_g_object_unref0 (_tmp15_);
		} else {
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp16_ = _data6_->last_selected_list;
			_tmp17_ = e_source_get_uid (source);
			_tmp18_ = _tmp17_;
			if (g_strcmp0 (_tmp16_, _tmp18_) == 0) {
				GtkListBox* _tmp19_;
				GeeHashMap* _tmp20_;
				gpointer _tmp21_;
				TasksWidgetsSourceRow* _tmp22_;
				_tmp19_ = self->priv->listbox;
				_tmp20_ = self->priv->source_rows;
				_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, source);
				_tmp22_ = (TasksWidgetsSourceRow*) _tmp21_;
				gtk_list_box_select_row (_tmp19_, (GtkListBoxRow*) _tmp22_);
				_g_object_unref0 (_tmp22_);
			}
		}
	}
	_g_object_unref0 (list);
}

static void
____lambda126__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda126_ (self, (ESource*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_tasks_main_window___lambda107_ (Block5Data* _data5_,
                                 GObject* obj,
                                 GAsyncResult* res)
{
	TasksMainWindow* self;
	Block6Data* _data6_;
	GAsyncResult* _tmp0_;
	ESourceRegistry* registry = NULL;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	ESourceRegistry* _tmp9_;
	ESource* _tmp10_;
	ESource* _tmp11_;
	GList* task_list_collections = NULL;
	ESourceRegistry* _tmp12_;
	GList* _tmp13_;
	GList* _tmp14_;
	GSettings* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->_data5_ = block5_data_ref (_data5_);
	_tmp0_ = _g_object_ref0 (res);
	_g_object_unref0 (_data6_->res);
	_data6_->res = _tmp0_;
	{
		ESourceRegistry* _tmp1_ = NULL;
		TasksTaskModel* _tmp2_;
		ESourceRegistry* _tmp3_;
		ESourceRegistry* _tmp4_;
		_tmp2_ = tasks_application_model;
		_tmp3_ = tasks_task_model_get_registry_finish (_tmp2_, _data6_->res, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (registry);
		registry = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_critical ("MainWindow.vala:163: %s", _tmp6_);
		_g_error_free0 (e);
		_g_object_unref0 (registry);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (registry);
		block6_data_unref (_data6_);
		_data6_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = self->priv->listbox;
	gtk_list_box_set_header_func (_tmp7_, _tasks_main_window_header_update_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp8_ = self->priv->listbox;
	g_signal_connect_data (_tmp8_, "row-selected", (GCallback) ___lambda108__gtk_list_box_row_selected, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	_tmp9_ = registry;
	_tmp10_ = e_source_registry_ref_builtin_task_list (_tmp9_);
	_tmp11_ = _tmp10_;
	tasks_main_window_add_collection_source (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = registry;
	_tmp13_ = e_source_registry_list_sources (_tmp12_, E_SOURCE_EXTENSION_COLLECTION);
	task_list_collections = _tmp13_;
	_tmp14_ = task_list_collections;
	g_list_foreach (_tmp14_, ___lambda125__gfunc, self);
	_tmp15_ = tasks_application_settings;
	_tmp16_ = g_settings_get_string (_tmp15_, "selected-list");
	_data6_->last_selected_list = _tmp16_;
	_tmp17_ = _data6_->last_selected_list;
	if (g_strcmp0 (_tmp17_, TASKS_MAIN_WINDOW_SCHEDULED_LIST_UID) == 0) {
		GtkListBox* _tmp18_;
		TasksWidgetsScheduledRow* _tmp19_;
		GtkListBox* _tmp20_;
		TasksWidgetsScheduledRow* _tmp21_;
		_tmp18_ = self->priv->listbox;
		_tmp19_ = _data5_->scheduled_row;
		gtk_list_box_select_row (_tmp18_, (GtkListBoxRow*) _tmp19_);
		_tmp20_ = self->priv->listbox;
		_tmp21_ = _data5_->scheduled_row;
		g_signal_emit_by_name (_tmp20_, "row-selected", (GtkListBoxRow*) _tmp21_);
	} else {
		Block8Data* _data8_;
		ESourceRegistry* _tmp22_;
		ESource* _tmp23_;
		ESource* _tmp24_;
		GList* task_lists = NULL;
		ESourceRegistry* _tmp25_;
		GList* _tmp26_;
		GList* _tmp27_;
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->_data6_ = block6_data_ref (_data6_);
		_tmp22_ = registry;
		g_object_get (_tmp22_, "default-task-list", &_tmp23_, NULL);
		_tmp24_ = _tmp23_;
		_data8_->default_task_list = _tmp24_;
		_tmp25_ = registry;
		_tmp26_ = e_source_registry_list_sources (_tmp25_, E_SOURCE_EXTENSION_TASK_LIST);
		task_lists = _tmp26_;
		_tmp27_ = task_lists;
		g_list_foreach (_tmp27_, ____lambda126__gfunc, _data8_);
		(task_lists == NULL) ? NULL : (task_lists = (_g_list_free__g_object_unref0_ (task_lists), NULL));
		block8_data_unref (_data8_);
		_data8_ = NULL;
	}
	(task_list_collections == NULL) ? NULL : (task_list_collections = (_g_list_free__g_object_unref0_ (task_list_collections), NULL));
	_g_object_unref0 (registry);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static void
__tasks_main_window___lambda107__gasync_ready_callback (GObject* source_object,
                                                        GAsyncResult* res,
                                                        gpointer self)
{
	_tasks_main_window___lambda107_ (self, source_object, res);
	block5_data_unref (self);
}

static GObject *
tasks_main_window_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksMainWindow * self;
	Block5Data* _data5_;
	GtkApplication* application_instance = NULL;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	HdyHeaderBar* sidebar_header = NULL;
	HdyHeaderBar* _tmp21_ = NULL;
	GtkStyleContext* sidebar_header_context = NULL;
	HdyHeaderBar* _tmp22_;
	GtkStyleContext* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	HdyHeaderBar* main_header = NULL;
	HdyHeaderBar* _tmp26_ = NULL;
	HdyHeaderGroup* header_group = NULL;
	HdyHeaderGroup* _tmp27_;
	HdyHeaderGroup* _tmp28_;
	HdyHeaderBar* _tmp29_;
	HdyHeaderGroup* _tmp30_;
	HdyHeaderBar* _tmp31_;
	GtkStyleContext* main_header_context = NULL;
	HdyHeaderBar* _tmp32_;
	GtkStyleContext* _tmp33_;
	GtkStyleContext* _tmp34_;
	GtkStyleContext* _tmp35_;
	GtkListBox* _tmp36_;
	GtkListBox* _tmp37_;
	TasksWidgetsScheduledRow* _tmp38_;
	GtkListBox* _tmp39_;
	TasksWidgetsScheduledRow* _tmp40_;
	GtkScrolledWindow* scrolledwindow = NULL;
	GtkScrolledWindow* _tmp41_ = NULL;
	GtkScrolledWindow* _tmp42_;
	GtkListBox* _tmp43_;
	GtkButtonBox* _tmp44_ = NULL;
	GtkModelButton* online_accounts_button = NULL;
	gchar* _tmp45_;
	GtkModelButton* _tmp46_ = NULL;
	GtkBox* add_tasklist_box = NULL;
	GtkBox* _tmp47_ = NULL;
	GtkBox* _tmp48_;
	GtkButtonBox* _tmp49_;
	GtkBox* _tmp50_;
	GtkSeparator* _tmp51_;
	GtkSeparator* _tmp52_;
	GtkBox* _tmp53_;
	GtkModelButton* _tmp54_;
	GtkBox* _tmp55_;
	GtkPopover* add_tasklist_popover = NULL;
	GtkPopover* _tmp56_;
	GtkPopover* _tmp57_;
	GtkBox* _tmp58_;
	GtkMenuButton* add_tasklist_button = NULL;
	gchar* _tmp59_;
	GtkImage* _tmp60_;
	GtkPopover* _tmp61_;
	GtkPopover* _tmp62_;
	GtkMenuButton* _tmp63_ = NULL;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp64_;
	GtkActionBar* _tmp65_;
	GtkMenuButton* _tmp66_;
	GtkStyleContext* actionbar_style_context = NULL;
	GtkActionBar* _tmp67_;
	GtkStyleContext* _tmp68_;
	GtkStyleContext* _tmp69_;
	GtkBox* sidebar = NULL;
	GtkBox* _tmp70_;
	GtkBox* _tmp71_;
	GtkStyleContext* _tmp72_;
	GtkBox* _tmp73_;
	HdyHeaderBar* _tmp74_;
	GtkBox* _tmp75_;
	GtkScrolledWindow* _tmp76_;
	GtkBox* _tmp77_;
	GtkActionBar* _tmp78_;
	GtkStack* _tmp79_;
	GtkBox* main_box = NULL;
	GtkBox* _tmp80_;
	GtkBox* _tmp81_;
	GtkStyleContext* _tmp82_;
	GtkBox* _tmp83_;
	HdyHeaderBar* _tmp84_;
	GtkBox* _tmp85_;
	GtkStack* _tmp86_;
	GtkPaned* paned = NULL;
	GtkPaned* _tmp87_;
	GtkPaned* _tmp88_;
	GtkBox* _tmp89_;
	GtkPaned* _tmp90_;
	GtkBox* _tmp91_;
	GtkPaned* _tmp92_;
	GtkModelButton* _tmp93_;
	GSettings* _tmp94_;
	GtkPaned* _tmp95_;
	TasksTaskModel* _tmp96_;
	TasksTaskModel* _tmp97_;
	TasksTaskModel* _tmp98_;
	TasksTaskModel* _tmp99_;
	parent_class = G_OBJECT_CLASS (tasks_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_MAIN_WINDOW, TasksMainWindow);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	g_action_map_add_action_entries ((GActionMap*) self, TASKS_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (TASKS_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	application_instance = _tmp1_;
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp2_ = tasks_main_window_action_accelerators;
		_tmp3_ = gee_multi_map_get_keys (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_action_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gchar* action = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GtkApplication* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GeeMultiMap* _tmp14_;
			const gchar* _tmp15_;
			GeeCollection* _tmp16_;
			GeeCollection* _tmp17_;
			gint _tmp18_ = 0;
			gpointer* _tmp19_;
			gchar** _tmp20_;
			gint _tmp20__length1;
			_tmp7_ = _action_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _action_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			action = (gchar*) _tmp9_;
			_tmp10_ = application_instance;
			_tmp11_ = action;
			_tmp12_ = g_strconcat (TASKS_MAIN_WINDOW_ACTION_PREFIX, _tmp11_, NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = tasks_main_window_action_accelerators;
			_tmp15_ = action;
			_tmp16_ = gee_multi_map_get (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp19_ = gee_collection_to_array (_tmp17_, &_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp20__length1 = _tmp18_;
			gtk_application_set_accels_for_action (_tmp10_, _tmp13_, _tmp20_);
			_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp17_);
			_g_free0 (_tmp13_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	_tmp21_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_has_subtitle (_tmp21_, FALSE);
	hdy_header_bar_set_show_close_button (_tmp21_, TRUE);
	g_object_ref_sink (_tmp21_);
	sidebar_header = _tmp21_;
	_tmp22_ = sidebar_header;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	sidebar_header_context = _tmp23_;
	_tmp24_ = sidebar_header_context;
	gtk_style_context_add_class (_tmp24_, "default-decoration");
	_tmp25_ = sidebar_header_context;
	gtk_style_context_add_class (_tmp25_, GTK_STYLE_CLASS_FLAT);
	_tmp26_ = (HdyHeaderBar*) hdy_header_bar_new ();
	hdy_header_bar_set_has_subtitle (_tmp26_, FALSE);
	hdy_header_bar_set_show_close_button (_tmp26_, TRUE);
	g_object_ref_sink (_tmp26_);
	main_header = _tmp26_;
	_tmp27_ = hdy_header_group_new ();
	header_group = _tmp27_;
	_tmp28_ = header_group;
	_tmp29_ = sidebar_header;
	hdy_header_group_add_header_bar (_tmp28_, _tmp29_);
	_tmp30_ = header_group;
	_tmp31_ = main_header;
	hdy_header_group_add_header_bar (_tmp30_, _tmp31_);
	_tmp32_ = main_header;
	_tmp33_ = gtk_widget_get_style_context ((GtkWidget*) _tmp32_);
	main_header_context = _tmp33_;
	_tmp34_ = main_header_context;
	gtk_style_context_add_class (_tmp34_, "default-decoration");
	_tmp35_ = main_header_context;
	gtk_style_context_add_class (_tmp35_, GTK_STYLE_CLASS_FLAT);
	_tmp36_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->listbox);
	self->priv->listbox = _tmp36_;
	_tmp37_ = self->priv->listbox;
	gtk_list_box_set_sort_func (_tmp37_, _tasks_main_window_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp38_ = tasks_widgets_scheduled_row_new ();
	g_object_ref_sink (_tmp38_);
	_data5_->scheduled_row = _tmp38_;
	_tmp39_ = self->priv->listbox;
	_tmp40_ = _data5_->scheduled_row;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp41_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp41_, TRUE);
	g_object_set (_tmp41_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp41_);
	scrolledwindow = _tmp41_;
	_tmp42_ = scrolledwindow;
	_tmp43_ = self->priv->listbox;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_VERTICAL);
	g_object_set (_tmp44_, "layout-style", GTK_BUTTONBOX_EXPAND, NULL);
	g_object_ref_sink (_tmp44_);
	_g_object_unref0 (self->priv->add_tasklist_buttonbox);
	self->priv->add_tasklist_buttonbox = _tmp44_;
	_tmp45_ = g_strdup (_ ("Online Accounts Settings…"));
	_tmp46_ = (GtkModelButton*) gtk_model_button_new ();
	g_object_set (_tmp46_, "text", _tmp45_, NULL);
	_g_free0 (_tmp45_);
	g_object_ref_sink (_tmp46_);
	online_accounts_button = _tmp46_;
	_tmp47_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp47_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp47_, 3);
	g_object_ref_sink (_tmp47_);
	add_tasklist_box = _tmp47_;
	_tmp48_ = add_tasklist_box;
	_tmp49_ = self->priv->add_tasklist_buttonbox;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = add_tasklist_box;
	_tmp51_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp51_);
	_tmp52_ = _tmp51_;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp52_);
	_g_object_unref0 (_tmp52_);
	_tmp53_ = add_tasklist_box;
	_tmp54_ = online_accounts_button;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = add_tasklist_box;
	gtk_widget_show_all ((GtkWidget*) _tmp55_);
	_tmp56_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_ref_sink (_tmp56_);
	add_tasklist_popover = _tmp56_;
	_tmp57_ = add_tasklist_popover;
	_tmp58_ = add_tasklist_box;
	gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = g_strdup (_ ("Add Task List…"));
	_tmp60_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp60_);
	_tmp61_ = add_tasklist_popover;
	_tmp62_ = _g_object_ref0 (_tmp61_);
	_tmp63_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_label ((GtkButton*) _tmp63_, _tmp59_);
	_g_free0 (_tmp59_);
	gtk_button_set_image ((GtkButton*) _tmp63_, (GtkWidget*) _tmp60_);
	_g_object_unref0 (_tmp60_);
	gtk_button_set_always_show_image ((GtkButton*) _tmp63_, TRUE);
	gtk_menu_button_set_popover (_tmp63_, _tmp62_);
	_g_object_unref0 (_tmp62_);
	g_object_ref_sink (_tmp63_);
	add_tasklist_button = _tmp63_;
	_tmp64_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp64_);
	actionbar = _tmp64_;
	_tmp65_ = actionbar;
	_tmp66_ = add_tasklist_button;
	gtk_container_add ((GtkContainer*) _tmp65_, (GtkWidget*) _tmp66_);
	_tmp67_ = actionbar;
	_tmp68_ = gtk_widget_get_style_context ((GtkWidget*) _tmp67_);
	actionbar_style_context = _tmp68_;
	_tmp69_ = actionbar_style_context;
	gtk_style_context_add_class (_tmp69_, GTK_STYLE_CLASS_FLAT);
	_tmp70_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp70_);
	sidebar = _tmp70_;
	_tmp71_ = sidebar;
	_tmp72_ = gtk_widget_get_style_context ((GtkWidget*) _tmp71_);
	gtk_style_context_add_class (_tmp72_, GTK_STYLE_CLASS_SIDEBAR);
	_tmp73_ = sidebar;
	_tmp74_ = sidebar_header;
	gtk_container_add ((GtkContainer*) _tmp73_, (GtkWidget*) _tmp74_);
	_tmp75_ = sidebar;
	_tmp76_ = scrolledwindow;
	gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
	_tmp77_ = sidebar;
	_tmp78_ = actionbar;
	gtk_container_add ((GtkContainer*) _tmp77_, (GtkWidget*) _tmp78_);
	_tmp79_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp79_);
	_g_object_unref0 (self->priv->task_list_grid_stack);
	self->priv->task_list_grid_stack = _tmp79_;
	_tmp80_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp80_);
	main_box = _tmp80_;
	_tmp81_ = main_box;
	_tmp82_ = gtk_widget_get_style_context ((GtkWidget*) _tmp81_);
	gtk_style_context_add_class (_tmp82_, GTK_STYLE_CLASS_BACKGROUND);
	_tmp83_ = main_box;
	_tmp84_ = main_header;
	gtk_container_add ((GtkContainer*) _tmp83_, (GtkWidget*) _tmp84_);
	_tmp85_ = main_box;
	_tmp86_ = self->priv->task_list_grid_stack;
	gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp87_);
	paned = _tmp87_;
	_tmp88_ = paned;
	_tmp89_ = sidebar;
	gtk_paned_pack1 (_tmp88_, (GtkWidget*) _tmp89_, FALSE, FALSE);
	_tmp90_ = paned;
	_tmp91_ = main_box;
	gtk_paned_pack2 (_tmp90_, (GtkWidget*) _tmp91_, TRUE, FALSE);
	_tmp92_ = paned;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp92_);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) __tasks_main_window___lambda104__gtk_widget_delete_event, self, 0);
	_tmp93_ = online_accounts_button;
	g_signal_connect_object ((GtkButton*) _tmp93_, "clicked", (GCallback) __tasks_main_window___lambda106__gtk_button_clicked, self, 0);
	_tmp94_ = tasks_application_settings;
	_tmp95_ = paned;
	g_settings_bind (_tmp94_, "pane-position", (GObject*) _tmp95_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp96_ = tasks_application_model;
	g_signal_connect_object (_tmp96_, "task-list-added", (GCallback) _tasks_main_window_add_source_tasks_task_model_task_list_added, self, 0);
	_tmp97_ = tasks_application_model;
	g_signal_connect_object (_tmp97_, "task-list-modified", (GCallback) _tasks_main_window_update_source_tasks_task_model_task_list_modified, self, 0);
	_tmp98_ = tasks_application_model;
	g_signal_connect_object (_tmp98_, "task-list-removed", (GCallback) _tasks_main_window_remove_source_tasks_task_model_task_list_removed, self, 0);
	_tmp99_ = tasks_application_model;
	tasks_task_model_get_registry (_tmp99_, __tasks_main_window___lambda107__gasync_ready_callback, block5_data_ref (_data5_));
	_g_object_unref0 (paned);
	_g_object_unref0 (main_box);
	_g_object_unref0 (sidebar);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_tasklist_button);
	_g_object_unref0 (add_tasklist_popover);
	_g_object_unref0 (add_tasklist_box);
	_g_object_unref0 (online_accounts_button);
	_g_object_unref0 (scrolledwindow);
	_g_object_unref0 (header_group);
	_g_object_unref0 (main_header);
	_g_object_unref0 (sidebar_header);
	_g_object_unref0 (application_instance);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
tasks_main_window_class_init (TasksMainWindowClass * klass,
                              gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	tasks_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksMainWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) tasks_main_window_real_configure_event;
	G_OBJECT_CLASS (klass)->constructor = tasks_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_main_window_finalize;
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	tasks_main_window_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = tasks_main_window_action_accelerators;
	gee_multi_map_set (_tmp1_, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST, "<Control>BackSpace");
}

static void
tasks_main_window_instance_init (TasksMainWindow * self,
                                 gpointer klass)
{
	self->priv = tasks_main_window_get_instance_private (self);
}

static void
tasks_main_window_finalize (GObject * obj)
{
	TasksMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_MAIN_WINDOW, TasksMainWindow);
	_g_object_unref0 (self->priv->listbox);
	_g_object_unref0 (self->priv->source_rows);
	_g_object_unref0 (self->priv->collection_sources);
	_g_object_unref0 (self->priv->task_list_grid_stack);
	_g_object_unref0 (self->priv->add_tasklist_buttonbox);
	G_OBJECT_CLASS (tasks_main_window_parent_class)->finalize (obj);
}

static GType
tasks_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksMainWindow), 0, (GInstanceInitFunc) tasks_main_window_instance_init, NULL };
	GType tasks_main_window_type_id;
	tasks_main_window_type_id = g_type_register_static (hdy_application_window_get_type (), "TasksMainWindow", &g_define_type_info, 0);
	TasksMainWindow_private_offset = g_type_add_instance_private (tasks_main_window_type_id, sizeof (TasksMainWindowPrivate));
	return tasks_main_window_type_id;
}

GType
tasks_main_window_get_type (void)
{
	static volatile gsize tasks_main_window_type_id__once = 0;
	if (g_once_init_enter (&tasks_main_window_type_id__once)) {
		GType tasks_main_window_type_id;
		tasks_main_window_type_id = tasks_main_window_get_type_once ();
		g_once_init_leave (&tasks_main_window_type_id__once, tasks_main_window_type_id);
	}
	return tasks_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

