/* Location.c generated by valac 0.56.16, the Vala compiler
 * generated from Location.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_TYPE_LOCATION (tasks_location_get_type ())
typedef struct _TasksLocation TasksLocation;
typedef enum  {
	TASKS_LOCATION_PROXIMITY_ARRIVE,
	TASKS_LOCATION_PROXIMITY_DEPART
} TasksLocationProximity;

#define TASKS_TYPE_LOCATION_PROXIMITY (tasks_location_proximity_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

struct _TasksLocation {
	gchar* postal_address;
	gchar* display_name;
	gdouble longitude;
	gdouble latitude;
	gint accuracy;
	TasksLocationProximity proximity;
};

VALA_EXTERN GType tasks_location_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tasks_location_proximity_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TasksLocation* tasks_location_dup (const TasksLocation* self);
VALA_EXTERN void tasks_location_free (TasksLocation* self);
VALA_EXTERN void tasks_location_copy (const TasksLocation* self,
                          TasksLocation* dest);
VALA_EXTERN void tasks_location_destroy (TasksLocation* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TasksLocation, tasks_location_destroy)
VALA_EXTERN TasksLocationProximity tasks_location_proximity_from_string (const gchar* val);
VALA_EXTERN const gchar* tasks_location_proximity_to_string (TasksLocationProximity self);

void
tasks_location_copy (const TasksLocation* self,
                     TasksLocation* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).postal_address;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).postal_address);
	(*dest).postal_address = _tmp1_;
	_tmp2_ = (*self).display_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).display_name);
	(*dest).display_name = _tmp3_;
	(*dest).longitude = (*self).longitude;
	(*dest).latitude = (*self).latitude;
	(*dest).accuracy = (*self).accuracy;
	(*dest).proximity = (*self).proximity;
}

void
tasks_location_destroy (TasksLocation* self)
{
	_g_free0 ((*self).postal_address);
	_g_free0 ((*self).display_name);
}

TasksLocation*
tasks_location_dup (const TasksLocation* self)
{
	TasksLocation* dup;
	dup = g_new0 (TasksLocation, 1);
	tasks_location_copy (self, dup);
	return dup;
}

void
tasks_location_free (TasksLocation* self)
{
	tasks_location_destroy (self);
	g_free (self);
}

static GType
tasks_location_get_type_once (void)
{
	GType tasks_location_type_id;
	tasks_location_type_id = g_boxed_type_register_static ("TasksLocation", (GBoxedCopyFunc) tasks_location_dup, (GBoxedFreeFunc) tasks_location_free);
	return tasks_location_type_id;
}

GType
tasks_location_get_type (void)
{
	static volatile gsize tasks_location_type_id__once = 0;
	if (g_once_init_enter (&tasks_location_type_id__once)) {
		GType tasks_location_type_id;
		tasks_location_type_id = tasks_location_get_type_once ();
		g_once_init_leave (&tasks_location_type_id__once, tasks_location_type_id);
	}
	return tasks_location_type_id__once;
}

TasksLocationProximity
tasks_location_proximity_from_string (const gchar* val)
{
	TasksLocationProximity result;
	g_return_val_if_fail (val != NULL, 0);
	if (g_strcmp0 (val, "DEPART") == 0) {
		result = TASKS_LOCATION_PROXIMITY_DEPART;
		return result;
	} else {
		result = TASKS_LOCATION_PROXIMITY_ARRIVE;
		return result;
	}
}

const gchar*
tasks_location_proximity_to_string (TasksLocationProximity self)
{
	const gchar* result;
	switch (self) {
		case TASKS_LOCATION_PROXIMITY_DEPART:
		{
			result = "DEPART";
			return result;
		}
		default:
		case TASKS_LOCATION_PROXIMITY_ARRIVE:
		{
			result = "ARRIVE";
			return result;
		}
	}
}

static GType
tasks_location_proximity_get_type_once (void)
{
	static const GEnumValue values[] = {{TASKS_LOCATION_PROXIMITY_ARRIVE, "TASKS_LOCATION_PROXIMITY_ARRIVE", "arrive"}, {TASKS_LOCATION_PROXIMITY_DEPART, "TASKS_LOCATION_PROXIMITY_DEPART", "depart"}, {0, NULL, NULL}};
	GType tasks_location_proximity_type_id;
	tasks_location_proximity_type_id = g_enum_register_static ("TasksLocationProximity", values);
	return tasks_location_proximity_type_id;
}

GType
tasks_location_proximity_get_type (void)
{
	static volatile gsize tasks_location_proximity_type_id__once = 0;
	if (g_once_init_enter (&tasks_location_proximity_type_id__once)) {
		GType tasks_location_proximity_type_id;
		tasks_location_proximity_type_id = tasks_location_proximity_get_type_once ();
		g_once_init_leave (&tasks_location_proximity_type_id__once, tasks_location_proximity_type_id);
	}
	return tasks_location_proximity_type_id__once;
}

