/* SearchBar.c generated by valac 0.56.14, the Vala compiler
 * generated from SearchBar.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Lucas Baudin <xapantu@gmail.com>
 *               2013      Mario Guerriero <mario@elementaryos.org>
                 2014-2023 elementary, Inc. (https://elementary.io)
 *
 * This file is part of Code.
 *
 * Code is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Code is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "codecore.h"
#include <gtk/gtk.h>
#include <granite.h>
#include <gtksourceview/gtksource.h>
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

enum  {
	SCRATCH_WIDGETS_SEARCH_BAR_0_PROPERTY,
	SCRATCH_WIDGETS_SEARCH_BAR_WINDOW_PROPERTY,
	SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_CONTEXT_PROPERTY,
	SCRATCH_WIDGETS_SEARCH_BAR_NUM_PROPERTIES
};
static GParamSpec* scratch_widgets_search_bar_properties[SCRATCH_WIDGETS_SEARCH_BAR_NUM_PROPERTIES];
typedef enum  {
	SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_NEVER,
	SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_MIXED,
	SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_ALWAYS
} ScratchWidgetsSearchBarCaseSensitiveMode;

#define SCRATCH_WIDGETS_SEARCH_BAR_TYPE_CASE_SENSITIVE_MODE (scratch_widgets_search_bar_case_sensitive_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
enum  {
	SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_EMPTY_SIGNAL,
	SCRATCH_WIDGETS_SEARCH_BAR_NUM_SIGNALS
};
static guint scratch_widgets_search_bar_signals[SCRATCH_WIDGETS_SEARCH_BAR_NUM_SIGNALS] = {0};

struct _ScratchWidgetsSearchBarPrivate {
	ScratchMainWindow* _window;
	GtkButton* tool_arrow_up;
	GtkButton* tool_arrow_down;
	GraniteSwitchModelButton* cycle_search_button;
	GtkComboBoxText* case_sensitive_search_button;
	GraniteSwitchModelButton* regex_search_button;
	GraniteSwitchModelButton* whole_word_search_button;
	GtkLabel* search_occurence_count_label;
	GtkButton* replace_tool_button;
	GtkButton* replace_all_tool_button;
	ScratchWidgetsSourceView* text_view;
	GtkTextBuffer* text_buffer;
	GtkSourceSearchContext* _search_context;
	guint update_search_label_timeout_id;
};

static gint ScratchWidgetsSearchBar_private_offset;
static gpointer scratch_widgets_search_bar_parent_class = NULL;

static GType scratch_widgets_search_bar_case_sensitive_mode_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void scratch_widgets_search_bar_cancel_update_search_widgets (ScratchWidgetsSearchBar* self);
static void scratch_widgets_search_bar_set_search_context (ScratchWidgetsSearchBar* self,
                                                    GtkSourceSearchContext* value);
static void scratch_widgets_search_bar_on_text_buffer_changed (ScratchWidgetsSearchBar* self);
static void _scratch_widgets_search_bar_on_text_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                                 gpointer self);
static void scratch_widgets_search_bar_on_selection_changed (ScratchWidgetsSearchBar* self);
static void _scratch_widgets_search_bar_on_selection_changed_scratch_widgets_source_view_selection_changed (ScratchWidgetsSourceView* _sender,
                                                                                                     GtkTextIter* start_iter,
                                                                                                     GtkTextIter* end_iter,
                                                                                                     gpointer self);
static void scratch_widgets_search_bar_update_search_widgets (ScratchWidgetsSearchBar* self);
static void scratch_widgets_search_bar_on_replace_entry_activate (ScratchWidgetsSearchBar* self);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static GtkTextIter* _vala_GtkTextIter_copy (GtkTextIter* self);
static gboolean scratch_widgets_search_bar_search_for_iter (ScratchWidgetsSearchBar* self,
                                                     GtkTextIter* start_iter,
                                                     GtkTextIter** end_iter);
static void scratch_widgets_search_bar_on_replace_all_entry_activate (ScratchWidgetsSearchBar* self);
static void scratch_widgets_search_bar_on_search_entry_text_changed (ScratchWidgetsSearchBar* self);
static gboolean scratch_widgets_search_bar_on_search_entry_focused_in (ScratchWidgetsSearchBar* self,
                                                                GdkEventFocus* event);
static gboolean scratch_widgets_search_bar_has_matches (ScratchWidgetsSearchBar* self);
static gboolean scratch_widgets_search_bar_search_for_iter_backward (ScratchWidgetsSearchBar* self,
                                                              GtkTextIter* start_iter,
                                                              GtkTextIter** end_iter);
static gboolean scratch_widgets_search_bar_on_search_entry_key_press (ScratchWidgetsSearchBar* self,
                                                               GdkEventKey* event);
static gboolean scratch_widgets_search_bar_on_replace_entry_key_press (ScratchWidgetsSearchBar* self,
                                                                GdkEventKey* event);
static gboolean __lambda120_ (ScratchWidgetsSearchBar* self);
static gboolean ___lambda120__gsource_func (gpointer self);
static GObject * scratch_widgets_search_bar_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void _scratch_widgets_search_bar_search_next_gtk_button_clicked (GtkButton* _sender,
                                                                 gpointer self);
static void _scratch_widgets_search_bar_search_previous_gtk_button_clicked (GtkButton* _sender,
                                                                     gpointer self);
static void _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                         gpointer self);
static void _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                     gpointer self);
static void _scratch_widgets_search_bar_on_replace_entry_activate_gtk_button_clicked (GtkButton* _sender,
                                                                               gpointer self);
static void _scratch_widgets_search_bar_on_replace_all_entry_activate_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self);
static void _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                                    gpointer self);
static gboolean _scratch_widgets_search_bar_on_search_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                           GdkEventKey* event,
                                                                                           gpointer self);
static gboolean _scratch_widgets_search_bar_on_search_entry_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                                           GdkEventFocus* event,
                                                                                           gpointer self);
static void _scratch_widgets_search_bar_update_search_widgets_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                        gpointer self);
static void _scratch_widgets_search_bar___lambda121_ (ScratchWidgetsSearchBar* self,
                                               GtkEntryIconPosition p0,
                                               GdkEvent* p1);
static void __scratch_widgets_search_bar___lambda121__gtk_entry_icon_release (GtkEntry* _sender,
                                                                       GtkEntryIconPosition icon_pos,
                                                                       GdkEvent* event,
                                                                       gpointer self);
static void _scratch_widgets_search_bar_on_replace_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                               gpointer self);
static gboolean _scratch_widgets_search_bar_on_replace_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                            GdkEventKey* event,
                                                                                            gpointer self);
static void scratch_widgets_search_bar_finalize (GObject * obj);
static GType scratch_widgets_search_bar_get_type_once (void);
static void _vala_scratch_widgets_search_bar_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_scratch_widgets_search_bar_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
scratch_widgets_search_bar_get_instance_private (ScratchWidgetsSearchBar* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchWidgetsSearchBar_private_offset);
}

static GType
scratch_widgets_search_bar_case_sensitive_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_NEVER, "SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_NEVER", "never"}, {SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_MIXED, "SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_MIXED", "mixed"}, {SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_ALWAYS, "SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_ALWAYS", "always"}, {0, NULL, NULL}};
	GType scratch_widgets_search_bar_case_sensitive_mode_type_id;
	scratch_widgets_search_bar_case_sensitive_mode_type_id = g_enum_register_static ("ScratchWidgetsSearchBarCaseSensitiveMode", values);
	return scratch_widgets_search_bar_case_sensitive_mode_type_id;
}

static GType
scratch_widgets_search_bar_case_sensitive_mode_get_type (void)
{
	static volatile gsize scratch_widgets_search_bar_case_sensitive_mode_type_id__once = 0;
	if (g_once_init_enter (&scratch_widgets_search_bar_case_sensitive_mode_type_id__once)) {
		GType scratch_widgets_search_bar_case_sensitive_mode_type_id;
		scratch_widgets_search_bar_case_sensitive_mode_type_id = scratch_widgets_search_bar_case_sensitive_mode_get_type_once ();
		g_once_init_leave (&scratch_widgets_search_bar_case_sensitive_mode_type_id__once, scratch_widgets_search_bar_case_sensitive_mode_type_id);
	}
	return scratch_widgets_search_bar_case_sensitive_mode_type_id__once;
}

/**
         * Create a new SearchBar widget.
         *
         * following actions : Fetch, ShowGoTo, ShowReplace, or null.
         **/
ScratchWidgetsSearchBar*
scratch_widgets_search_bar_construct (GType object_type,
                                      ScratchMainWindow* window)
{
	ScratchWidgetsSearchBar * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (ScratchWidgetsSearchBar*) g_object_new (object_type, "window", window, NULL);
	return self;
}

ScratchWidgetsSearchBar*
scratch_widgets_search_bar_new (ScratchMainWindow* window)
{
	return scratch_widgets_search_bar_construct (SCRATCH_WIDGETS_TYPE_SEARCH_BAR, window);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_scratch_widgets_search_bar_on_text_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                            gpointer self)
{
	scratch_widgets_search_bar_on_text_buffer_changed ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar_on_selection_changed_scratch_widgets_source_view_selection_changed (ScratchWidgetsSourceView* _sender,
                                                                                                GtkTextIter* start_iter,
                                                                                                GtkTextIter* end_iter,
                                                                                                gpointer self)
{
	scratch_widgets_search_bar_on_selection_changed ((ScratchWidgetsSearchBar*) self);
}

void
scratch_widgets_search_bar_set_text_view (ScratchWidgetsSearchBar* self,
                                          ScratchWidgetsSourceView* text_view)
{
	ScratchWidgetsSourceView* _tmp0_;
	ScratchWidgetsSourceView* _tmp1_;
	ScratchWidgetsSourceView* _tmp7_;
	ScratchWidgetsSourceView* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkSourceSearchContext* _tmp13_;
	GtkSourceSearchContext* _tmp14_;
	GtkSourceSearchContext* _tmp15_;
	GtkSourceSearchSettings* _tmp16_;
	GtkSourceSearchSettings* _tmp17_;
	GraniteSwitchModelButton* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GtkSourceSearchContext* _tmp21_;
	GtkSourceSearchSettings* _tmp22_;
	GtkSourceSearchSettings* _tmp23_;
	GraniteSwitchModelButton* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	GtkSourceSearchContext* _tmp27_;
	GtkSourceSearchSettings* _tmp28_;
	GtkSourceSearchSettings* _tmp29_;
	GtkSearchEntry* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text_view;
	if (_tmp0_ == text_view) {
		return;
	}
	scratch_widgets_search_bar_cancel_update_search_widgets (self);
	_tmp1_ = _g_object_ref0 (text_view);
	_g_object_unref0 (self->priv->text_view);
	self->priv->text_view = _tmp1_;
	if (text_view == NULL) {
		g_warning ("SearchBar.vala:231: No SourceView is associated with SearchManager!");
		scratch_widgets_search_bar_set_search_context (self, NULL);
		return;
	} else {
		GtkTextBuffer* _tmp2_;
		_tmp2_ = self->priv->text_buffer;
		if (_tmp2_ != NULL) {
			GtkTextBuffer* _tmp3_;
			guint _tmp4_;
			ScratchWidgetsSourceView* _tmp5_;
			guint _tmp6_;
			_tmp3_ = self->priv->text_buffer;
			g_signal_parse_name ("changed", gtk_text_buffer_get_type (), &_tmp4_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _scratch_widgets_search_bar_on_text_buffer_changed_gtk_text_buffer_changed, self);
			_tmp5_ = self->priv->text_view;
			g_signal_parse_name ("selection-changed", SCRATCH_WIDGETS_TYPE_SOURCE_VIEW, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _scratch_widgets_search_bar_on_selection_changed_scratch_widgets_source_view_selection_changed, self);
		}
	}
	_tmp7_ = _g_object_ref0 (text_view);
	_g_object_unref0 (self->priv->text_view);
	self->priv->text_view = _tmp7_;
	_tmp8_ = self->priv->text_view;
	g_signal_connect_object (_tmp8_, "selection-changed", (GCallback) _scratch_widgets_search_bar_on_selection_changed_scratch_widgets_source_view_selection_changed, self, 0);
	_tmp9_ = gtk_text_view_get_buffer ((GtkTextView*) text_view);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->priv->text_buffer);
	self->priv->text_buffer = _tmp10_;
	_tmp11_ = self->priv->text_buffer;
	g_signal_connect_object (_tmp11_, "changed", (GCallback) _scratch_widgets_search_bar_on_text_buffer_changed_gtk_text_buffer_changed, self, 0);
	_tmp12_ = self->priv->text_buffer;
	_tmp13_ = gtk_source_search_context_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, gtk_source_buffer_get_type ()) ? ((GtkSourceBuffer*) _tmp12_) : NULL, NULL);
	_tmp14_ = _tmp13_;
	scratch_widgets_search_bar_set_search_context (self, _tmp14_);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = self->priv->_search_context;
	_tmp16_ = gtk_source_search_context_get_settings (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->cycle_search_button;
	_tmp19_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp18_);
	_tmp20_ = _tmp19_;
	gtk_source_search_settings_set_wrap_around (_tmp17_, _tmp20_);
	_tmp21_ = self->priv->_search_context;
	_tmp22_ = gtk_source_search_context_get_settings (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->regex_search_button;
	_tmp25_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp24_);
	_tmp26_ = _tmp25_;
	gtk_source_search_settings_set_regex_enabled (_tmp23_, _tmp26_);
	_tmp27_ = self->priv->_search_context;
	_tmp28_ = gtk_source_search_context_get_settings (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->search_entry;
	_tmp31_ = gtk_entry_get_text ((GtkEntry*) _tmp30_);
	_tmp32_ = _tmp31_;
	gtk_source_search_settings_set_search_text (_tmp29_, _tmp32_);
	scratch_widgets_search_bar_on_text_buffer_changed (self);
}

static void
scratch_widgets_search_bar_on_text_buffer_changed (ScratchWidgetsSearchBar* self)
{
	g_return_if_fail (self != NULL);
	scratch_widgets_search_bar_update_search_widgets (self);
}

static void
scratch_widgets_search_bar_on_selection_changed (ScratchWidgetsSearchBar* self)
{
	gchar* selected_text = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	gchar* _tmp1_;
	gboolean clear_required = FALSE;
	GtkSourceSearchContext* _tmp2_;
	GtkSourceSearchSettings* _tmp3_;
	GtkSourceSearchSettings* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text_view;
	_tmp1_ = scratch_widgets_source_view_get_selected_text (_tmp0_, TRUE);
	selected_text = _tmp1_;
	_tmp2_ = self->priv->_search_context;
	_tmp3_ = gtk_source_search_context_get_settings (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_source_search_settings_get_case_sensitive (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		GtkSearchEntry* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp7_ = selected_text;
		_tmp8_ = self->search_entry;
		_tmp9_ = gtk_entry_get_text ((GtkEntry*) _tmp8_);
		_tmp10_ = _tmp9_;
		clear_required = g_strcmp0 (_tmp7_, _tmp10_) != 0;
	} else {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GtkSearchEntry* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp11_ = selected_text;
		_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->search_entry;
		_tmp15_ = gtk_entry_get_text ((GtkEntry*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_utf8_strdown (_tmp16_, (gssize) -1);
		_tmp18_ = _tmp17_;
		clear_required = g_strcmp0 (_tmp13_, _tmp18_) != 0;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp13_);
	}
	if (clear_required) {
		GtkSearchEntry* _tmp19_;
		_tmp19_ = self->search_entry;
		gtk_entry_set_text ((GtkEntry*) _tmp19_, "");
	}
	_g_free0 (selected_text);
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static GtkTextIter*
_vala_GtkTextIter_copy (GtkTextIter* self)
{
	return g_boxed_copy (gtk_text_iter_get_type (), self);
}

static gpointer
__vala_GtkTextIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTextIter_copy (self) : NULL;
}

static void
scratch_widgets_search_bar_on_replace_entry_activate (ScratchWidgetsSearchBar* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
	GtkTextIter* _tmp7_;
	GtkTextIter* _tmp8_;
	GtkTextIter* _tmp9_ = NULL;
	gboolean _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text_buffer;
	if (_tmp0_ == NULL) {
		g_warning ("SearchBar.vala:271: No valid buffer to replace");
		return;
	}
	_tmp1_ = self->priv->text_buffer;
	_tmp2_ = self->priv->text_buffer;
	g_object_get (_tmp2_, "cursor-position", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	gtk_text_buffer_get_iter_at_offset (_tmp1_, &_tmp5_, _tmp4_);
	__vala_GtkTextIter_free0 (start_iter);
	_tmp6_ = _tmp5_;
	_tmp7_ = __vala_GtkTextIter_copy0 (&_tmp6_);
	start_iter = _tmp7_;
	_tmp8_ = start_iter;
	_tmp10_ = scratch_widgets_search_bar_search_for_iter (self, _tmp8_, &_tmp9_);
	__vala_GtkTextIter_free0 (end_iter);
	end_iter = _tmp9_;
	if (_tmp10_) {
		gchar* replace_string = NULL;
		GtkSearchEntry* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp11_ = self->replace_entry;
		_tmp12_ = gtk_entry_get_text ((GtkEntry*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		replace_string = _tmp14_;
		{
			GtkSourceSearchContext* _tmp15_;
			GtkTextIter* _tmp16_;
			GtkTextIter* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			GtkTextIter _tmp22_;
			GtkTextIter _tmp23_;
			GtkSearchEntry* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			GtkSearchEntry* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			scratch_widgets_search_bar_cancel_update_search_widgets (self);
			_tmp15_ = self->priv->_search_context;
			_tmp16_ = start_iter;
			_tmp17_ = end_iter;
			_tmp18_ = replace_string;
			_tmp19_ = replace_string;
			_tmp20_ = strlen (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = *_tmp16_;
			_tmp23_ = *_tmp17_;
			gtk_source_search_context_replace (_tmp15_, &_tmp22_, &_tmp23_, _tmp18_, _tmp21_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			scratch_widgets_search_bar_update_search_widgets (self);
			_tmp24_ = self->search_entry;
			_tmp25_ = gtk_entry_get_text ((GtkEntry*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = self->replace_entry;
			_tmp28_ = gtk_entry_get_text ((GtkEntry*) _tmp27_);
			_tmp29_ = _tmp28_;
			g_debug ("SearchBar.vala:284: Replaced \"%s\" with \"%s\"", _tmp26_, _tmp29_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp30_;
			const gchar* _tmp31_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp30_ = e;
			_tmp31_ = _tmp30_->message;
			g_critical ("SearchBar.vala:286: %s", _tmp31_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (replace_string);
			__vala_GtkTextIter_free0 (end_iter);
			__vala_GtkTextIter_free0 (start_iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (replace_string);
	}
	__vala_GtkTextIter_free0 (end_iter);
	__vala_GtkTextIter_free0 (start_iter);
}

static void
scratch_widgets_search_bar_on_replace_all_entry_activate (ScratchWidgetsSearchBar* self)
{
	gboolean _tmp0_ = FALSE;
	GtkTextBuffer* _tmp1_;
	gchar* replace_string = NULL;
	GtkSearchEntry* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	ScratchMainWindow* _tmp9_;
	ScratchServicesDocument* _tmp10_;
	ScratchServicesDocument* _tmp11_;
	ScratchMainWindow* _tmp19_;
	ScratchServicesDocument* _tmp20_;
	ScratchServicesDocument* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->text_buffer;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ScratchMainWindow* _tmp2_;
		ScratchServicesDocument* _tmp3_;
		ScratchServicesDocument* _tmp4_;
		_tmp2_ = self->priv->_window;
		_tmp3_ = scratch_main_window_get_current_document (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == NULL;
		_g_object_unref0 (_tmp4_);
	}
	if (_tmp0_) {
		g_debug ("SearchBar.vala:293: No valid buffer to replace");
		return;
	}
	_tmp5_ = self->replace_entry;
	_tmp6_ = gtk_entry_get_text ((GtkEntry*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup (_tmp7_);
	replace_string = _tmp8_;
	_tmp9_ = self->priv->_window;
	_tmp10_ = scratch_main_window_get_current_document (_tmp9_);
	_tmp11_ = _tmp10_;
	scratch_services_document_toggle_changed_handlers (_tmp11_, FALSE);
	_g_object_unref0 (_tmp11_);
	{
		GtkSourceSearchContext* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		scratch_widgets_search_bar_cancel_update_search_widgets (self);
		_tmp12_ = self->priv->_search_context;
		_tmp13_ = replace_string;
		_tmp14_ = replace_string;
		_tmp15_ = strlen (_tmp14_);
		_tmp16_ = _tmp15_;
		gtk_source_search_context_replace_all (_tmp12_, _tmp13_, _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		scratch_widgets_search_bar_update_search_widgets (self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_critical ("SearchBar.vala:304: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (replace_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp19_ = self->priv->_window;
	_tmp20_ = scratch_main_window_get_current_document (_tmp19_);
	_tmp21_ = _tmp20_;
	scratch_services_document_toggle_changed_handlers (_tmp21_, TRUE);
	_g_object_unref0 (_tmp21_);
	_g_free0 (replace_string);
}

static void
scratch_widgets_search_bar_on_search_entry_text_changed (ScratchWidgetsSearchBar* self)
{
	GtkSourceSearchContext* _tmp0_;
	gchar* search_string = NULL;
	GtkSearchEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GtkSourceSearchContext* _tmp5_;
	GtkSourceSearchSettings* _tmp6_;
	GtkSourceSearchSettings* _tmp7_;
	const gchar* _tmp8_;
	ScratchWidgetsSearchBarCaseSensitiveMode case_mode = 0;
	GtkComboBoxText* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GtkSourceSearchContext* _tmp31_;
	GtkSourceSearchSettings* _tmp32_;
	GtkSourceSearchSettings* _tmp33_;
	GraniteSwitchModelButton* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GtkSourceSearchContext* _tmp37_;
	GtkSourceSearchSettings* _tmp38_;
	GtkSourceSearchSettings* _tmp39_;
	GraniteSwitchModelButton* _tmp40_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	GtkSearchEntry* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		g_debug ("SearchBar.vala:312: search entry changed with null context");
		return;
	}
	_tmp1_ = self->search_entry;
	_tmp2_ = gtk_entry_get_text ((GtkEntry*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	search_string = _tmp4_;
	_tmp5_ = self->priv->_search_context;
	_tmp6_ = gtk_source_search_context_get_settings (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = search_string;
	gtk_source_search_settings_set_search_text (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->case_sensitive_search_button;
	_tmp10_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp9_);
	_tmp11_ = _tmp10_;
	case_mode = (ScratchWidgetsSearchBarCaseSensitiveMode) _tmp11_;
	switch (case_mode) {
		case SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_NEVER:
		{
			GtkSourceSearchContext* _tmp12_;
			GtkSourceSearchSettings* _tmp13_;
			GtkSourceSearchSettings* _tmp14_;
			_tmp12_ = self->priv->_search_context;
			_tmp13_ = gtk_source_search_context_get_settings (_tmp12_);
			_tmp14_ = _tmp13_;
			gtk_source_search_settings_set_case_sensitive (_tmp14_, FALSE);
			break;
		}
		case SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_MIXED:
		{
			gboolean _tmp15_ = FALSE;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			gboolean _tmp20_;
			GtkSourceSearchContext* _tmp25_;
			GtkSourceSearchSettings* _tmp26_;
			GtkSourceSearchSettings* _tmp27_;
			_tmp16_ = search_string;
			_tmp17_ = g_utf8_strup (_tmp16_, (gssize) -1);
			_tmp18_ = _tmp17_;
			_tmp19_ = search_string;
			_tmp20_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
			_g_free0 (_tmp18_);
			if (_tmp20_) {
				_tmp15_ = TRUE;
			} else {
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				_tmp21_ = search_string;
				_tmp22_ = g_utf8_strdown (_tmp21_, (gssize) -1);
				_tmp23_ = _tmp22_;
				_tmp24_ = search_string;
				_tmp15_ = g_strcmp0 (_tmp23_, _tmp24_) == 0;
				_g_free0 (_tmp23_);
			}
			_tmp25_ = self->priv->_search_context;
			_tmp26_ = gtk_source_search_context_get_settings (_tmp25_);
			_tmp27_ = _tmp26_;
			gtk_source_search_settings_set_case_sensitive (_tmp27_, !_tmp15_);
			break;
		}
		case SCRATCH_WIDGETS_SEARCH_BAR_CASE_SENSITIVE_MODE_ALWAYS:
		{
			GtkSourceSearchContext* _tmp28_;
			GtkSourceSearchSettings* _tmp29_;
			GtkSourceSearchSettings* _tmp30_;
			_tmp28_ = self->priv->_search_context;
			_tmp29_ = gtk_source_search_context_get_settings (_tmp28_);
			_tmp30_ = _tmp29_;
			gtk_source_search_settings_set_case_sensitive (_tmp30_, TRUE);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp31_ = self->priv->_search_context;
	_tmp32_ = gtk_source_search_context_get_settings (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->priv->whole_word_search_button;
	_tmp35_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp34_);
	_tmp36_ = _tmp35_;
	gtk_source_search_settings_set_at_word_boundaries (_tmp33_, _tmp36_);
	_tmp37_ = self->priv->_search_context;
	_tmp38_ = gtk_source_search_context_get_settings (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = self->priv->regex_search_button;
	_tmp41_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp40_);
	_tmp42_ = _tmp41_;
	gtk_source_search_settings_set_regex_enabled (_tmp39_, _tmp42_);
	scratch_widgets_search_bar_update_search_widgets (self);
	_tmp43_ = self->search_entry;
	_tmp44_ = gtk_entry_get_text ((GtkEntry*) _tmp43_);
	_tmp45_ = _tmp44_;
	if (g_strcmp0 (_tmp45_, "") == 0) {
		g_signal_emit (self, scratch_widgets_search_bar_signals[SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_EMPTY_SIGNAL], 0);
	}
	_g_free0 (search_string);
}

static gboolean
scratch_widgets_search_bar_on_search_entry_focused_in (ScratchWidgetsSearchBar* self,
                                                       GdkEventFocus* event)
{
	GtkTextBuffer* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->text_buffer;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	scratch_widgets_search_bar_update_search_widgets (self);
	result = FALSE;
	return result;
}

gboolean
scratch_widgets_search_bar_search (ScratchWidgetsSearchBar* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceSearchContext* _tmp2_;
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkTextIter _tmp7_ = {0};
	GtkTextIter _tmp8_;
	GtkTextIter* _tmp9_;
	GtkTextIter* _tmp10_;
	GtkTextIter* _tmp11_ = NULL;
	gboolean _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_search_context;
	gtk_source_search_context_set_highlight (_tmp1_, FALSE);
	if (!scratch_widgets_search_bar_has_matches (self)) {
		g_debug ("SearchBar.vala:360: Can't search anything in a non-existent buffer and" \
"/or without anything to search.");
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_search_context;
	gtk_source_search_context_set_highlight (_tmp2_, TRUE);
	_tmp3_ = self->priv->text_buffer;
	_tmp4_ = self->priv->text_buffer;
	g_object_get (_tmp4_, "cursor-position", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	gtk_text_buffer_get_iter_at_offset (_tmp3_, &_tmp7_, _tmp6_);
	__vala_GtkTextIter_free0 (start_iter);
	_tmp8_ = _tmp7_;
	_tmp9_ = __vala_GtkTextIter_copy0 (&_tmp8_);
	start_iter = _tmp9_;
	_tmp10_ = start_iter;
	_tmp12_ = scratch_widgets_search_bar_search_for_iter (self, _tmp10_, &_tmp11_);
	__vala_GtkTextIter_free0 (end_iter);
	end_iter = _tmp11_;
	if (_tmp12_) {
		GtkSearchEntry* _tmp13_;
		GtkStyleContext* _tmp14_;
		GtkSearchEntry* _tmp15_;
		_tmp13_ = self->search_entry;
		_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) _tmp13_);
		gtk_style_context_remove_class (_tmp14_, GTK_STYLE_CLASS_ERROR);
		_tmp15_ = self->search_entry;
		g_object_set ((GtkEntry*) _tmp15_, "primary-icon-name", "edit-find-symbolic", NULL);
	} else {
		GtkTextBuffer* _tmp16_;
		GtkTextIter _tmp17_ = {0};
		GtkTextIter _tmp18_;
		GtkTextIter* _tmp19_;
		GtkTextIter* _tmp20_;
		GtkTextIter* _tmp21_ = NULL;
		gboolean _tmp22_;
		_tmp16_ = self->priv->text_buffer;
		gtk_text_buffer_get_start_iter (_tmp16_, &_tmp17_);
		__vala_GtkTextIter_free0 (start_iter);
		_tmp18_ = _tmp17_;
		_tmp19_ = __vala_GtkTextIter_copy0 (&_tmp18_);
		start_iter = _tmp19_;
		_tmp20_ = start_iter;
		_tmp22_ = scratch_widgets_search_bar_search_for_iter (self, _tmp20_, &_tmp21_);
		__vala_GtkTextIter_free0 (end_iter);
		end_iter = _tmp21_;
		if (_tmp22_) {
			GtkSearchEntry* _tmp23_;
			GtkStyleContext* _tmp24_;
			GtkSearchEntry* _tmp25_;
			_tmp23_ = self->search_entry;
			_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
			gtk_style_context_remove_class (_tmp24_, GTK_STYLE_CLASS_ERROR);
			_tmp25_ = self->search_entry;
			g_object_set ((GtkEntry*) _tmp25_, "primary-icon-name", "edit-find-symbolic", NULL);
		} else {
			GtkSearchEntry* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			GtkTextIter* _tmp29_;
			GtkTextBuffer* _tmp30_;
			GtkTextIter* _tmp31_;
			GtkTextIter* _tmp32_;
			GtkTextIter _tmp33_;
			GtkTextIter _tmp34_;
			GtkSearchEntry* _tmp35_;
			GtkStyleContext* _tmp36_;
			GtkSearchEntry* _tmp37_;
			_tmp26_ = self->search_entry;
			_tmp27_ = gtk_entry_get_text ((GtkEntry*) _tmp26_);
			_tmp28_ = _tmp27_;
			g_debug ("SearchBar.vala:378: Not found: \"%s\"", _tmp28_);
			_tmp29_ = start_iter;
			gtk_text_iter_set_offset (_tmp29_, -1);
			_tmp30_ = self->priv->text_buffer;
			_tmp31_ = start_iter;
			_tmp32_ = start_iter;
			_tmp33_ = *_tmp31_;
			_tmp34_ = *_tmp32_;
			gtk_text_buffer_select_range (_tmp30_, &_tmp33_, &_tmp34_);
			_tmp35_ = self->search_entry;
			_tmp36_ = gtk_widget_get_style_context ((GtkWidget*) _tmp35_);
			gtk_style_context_add_class (_tmp36_, GTK_STYLE_CLASS_ERROR);
			_tmp37_ = self->search_entry;
			g_object_set ((GtkEntry*) _tmp37_, "primary-icon-name", "dialog-error-symbolic", NULL);
			result = FALSE;
			__vala_GtkTextIter_free0 (end_iter);
			__vala_GtkTextIter_free0 (start_iter);
			return result;
		}
	}
	result = TRUE;
	__vala_GtkTextIter_free0 (end_iter);
	__vala_GtkTextIter_free0 (start_iter);
	return result;
}

void
scratch_widgets_search_bar_highlight_none (ScratchWidgetsSearchBar* self)
{
	GtkSourceSearchContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ != NULL) {
		GtkSourceSearchContext* _tmp1_;
		_tmp1_ = self->priv->_search_context;
		gtk_source_search_context_set_highlight (_tmp1_, FALSE);
	}
}

static gboolean
scratch_widgets_search_bar_has_matches (ScratchWidgetsSearchBar* self)
{
	gboolean _tmp0_ = FALSE;
	GtkTextBuffer* _tmp1_;
	gboolean has_wrapped_around = FALSE;
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	GtkTextIter* _tmp8_;
	GtkSourceSearchContext* _tmp9_;
	GtkTextIter* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextIter _tmp12_ = {0};
	GtkTextIter _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_;
	GtkTextIter _tmp16_;
	GtkTextIter* _tmp17_;
	GtkTextIter _tmp18_;
	GtkTextIter* _tmp19_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->text_buffer;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkSearchEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->search_entry;
		_tmp3_ = gtk_entry_get_text ((GtkEntry*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->text_buffer;
	gtk_text_buffer_get_start_iter (_tmp5_, &_tmp6_);
	__vala_GtkTextIter_free0 (start_iter);
	_tmp7_ = _tmp6_;
	_tmp8_ = __vala_GtkTextIter_copy0 (&_tmp7_);
	start_iter = _tmp8_;
	_tmp9_ = self->priv->_search_context;
	_tmp10_ = start_iter;
	_tmp11_ = *_tmp10_;
	_tmp15_ = gtk_source_search_context_forward (_tmp9_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
	__vala_GtkTextIter_free0 (start_iter);
	_tmp16_ = _tmp12_;
	_tmp17_ = __vala_GtkTextIter_copy0 (&_tmp16_);
	start_iter = _tmp17_;
	__vala_GtkTextIter_free0 (end_iter);
	_tmp18_ = _tmp13_;
	_tmp19_ = __vala_GtkTextIter_copy0 (&_tmp18_);
	end_iter = _tmp19_;
	has_wrapped_around = _tmp14_;
	result = _tmp15_;
	__vala_GtkTextIter_free0 (end_iter);
	__vala_GtkTextIter_free0 (start_iter);
	return result;
}

static gboolean
scratch_widgets_search_bar_search_for_iter (ScratchWidgetsSearchBar* self,
                                            GtkTextIter* start_iter,
                                            GtkTextIter** end_iter)
{
	GtkTextIter* _vala_end_iter = NULL;
	GtkTextIter* _tmp0_;
	GtkSourceSearchContext* _tmp1_;
	gboolean has_wrapped_around = FALSE;
	gboolean found = FALSE;
	GtkSourceSearchContext* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = __vala_GtkTextIter_copy0 (start_iter);
	__vala_GtkTextIter_free0 (_vala_end_iter);
	_vala_end_iter = _tmp0_;
	_tmp1_ = self->priv->_search_context;
	if (_tmp1_ == NULL) {
		g_critical ("SearchBar.vala:411: Trying to search forwards with no search context");
		result = FALSE;
		if (end_iter) {
			*end_iter = _vala_end_iter;
		} else {
			__vala_GtkTextIter_free0 (_vala_end_iter);
		}
		return result;
	}
	_tmp2_ = self->priv->_search_context;
	_tmp3_ = *start_iter;
	_tmp7_ = gtk_source_search_context_forward (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_tmp8_ = _tmp4_;
	start_iter = &_tmp8_;
	__vala_GtkTextIter_free0 (_vala_end_iter);
	_tmp9_ = _tmp5_;
	_tmp10_ = __vala_GtkTextIter_copy0 (&_tmp9_);
	_vala_end_iter = _tmp10_;
	has_wrapped_around = _tmp6_;
	found = _tmp7_;
	if (found) {
		GtkTextBuffer* _tmp11_;
		GtkTextIter* _tmp12_;
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		ScratchWidgetsSourceView* _tmp15_;
		GtkTextIter _tmp16_;
		_tmp11_ = self->priv->text_buffer;
		_tmp12_ = _vala_end_iter;
		_tmp13_ = *start_iter;
		_tmp14_ = *_tmp12_;
		gtk_text_buffer_select_range (_tmp11_, &_tmp13_, &_tmp14_);
		if (has_wrapped_around) {
			gtk_text_iter_backward_lines (start_iter, 3);
		} else {
			gtk_text_iter_forward_lines (start_iter, 3);
		}
		_tmp15_ = self->priv->text_view;
		_tmp16_ = *start_iter;
		gtk_text_view_scroll_to_iter ((GtkTextView*) _tmp15_, &_tmp16_, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
	}
	result = found;
	if (end_iter) {
		*end_iter = _vala_end_iter;
	} else {
		__vala_GtkTextIter_free0 (_vala_end_iter);
	}
	return result;
}

static gboolean
scratch_widgets_search_bar_search_for_iter_backward (ScratchWidgetsSearchBar* self,
                                                     GtkTextIter* start_iter,
                                                     GtkTextIter** end_iter)
{
	GtkTextIter* _vala_end_iter = NULL;
	GtkTextIter* _tmp0_;
	GtkSourceSearchContext* _tmp1_;
	gboolean has_wrapped_around = FALSE;
	gboolean found = FALSE;
	GtkSourceSearchContext* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	GtkTextIter* _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = __vala_GtkTextIter_copy0 (start_iter);
	__vala_GtkTextIter_free0 (_vala_end_iter);
	_vala_end_iter = _tmp0_;
	_tmp1_ = self->priv->_search_context;
	if (_tmp1_ == NULL) {
		g_critical ("SearchBar.vala:434: Trying to search backwards with no search context");
		result = FALSE;
		if (end_iter) {
			*end_iter = _vala_end_iter;
		} else {
			__vala_GtkTextIter_free0 (_vala_end_iter);
		}
		return result;
	}
	_tmp2_ = self->priv->_search_context;
	_tmp3_ = *start_iter;
	_tmp7_ = gtk_source_search_context_backward (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_tmp8_ = _tmp4_;
	start_iter = &_tmp8_;
	__vala_GtkTextIter_free0 (_vala_end_iter);
	_tmp9_ = _tmp5_;
	_tmp10_ = __vala_GtkTextIter_copy0 (&_tmp9_);
	_vala_end_iter = _tmp10_;
	has_wrapped_around = _tmp6_;
	found = _tmp7_;
	if (found) {
		GtkTextBuffer* _tmp11_;
		GtkTextIter* _tmp12_;
		GtkTextIter _tmp13_;
		GtkTextIter _tmp14_;
		ScratchWidgetsSourceView* _tmp15_;
		GtkTextIter _tmp16_;
		_tmp11_ = self->priv->text_buffer;
		_tmp12_ = _vala_end_iter;
		_tmp13_ = *start_iter;
		_tmp14_ = *_tmp12_;
		gtk_text_buffer_select_range (_tmp11_, &_tmp13_, &_tmp14_);
		if (has_wrapped_around) {
			gtk_text_iter_forward_lines (start_iter, 3);
		} else {
			gtk_text_iter_backward_lines (start_iter, 3);
		}
		_tmp15_ = self->priv->text_view;
		_tmp16_ = *start_iter;
		gtk_text_view_scroll_to_iter ((GtkTextView*) _tmp15_, &_tmp16_, (gdouble) 0, FALSE, (gdouble) 0, (gdouble) 0);
	}
	result = found;
	if (end_iter) {
		*end_iter = _vala_end_iter;
	} else {
		__vala_GtkTextIter_free0 (_vala_end_iter);
	}
	return result;
}

void
scratch_widgets_search_bar_search_previous (ScratchWidgetsSearchBar* self)
{
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text_buffer;
	if (_tmp0_ != NULL) {
		GtkTextBuffer* _tmp1_;
		GtkTextIter _tmp2_ = {0};
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_;
		GtkTextIter* _tmp5_;
		GtkTextIter _tmp6_;
		GtkTextIter* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GtkTextIter* _tmp9_;
		GtkTextIter* _tmp10_ = NULL;
		gboolean _tmp11_;
		_tmp1_ = self->priv->text_buffer;
		gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
		__vala_GtkTextIter_free0 (start_iter);
		_tmp4_ = _tmp2_;
		_tmp5_ = __vala_GtkTextIter_copy0 (&_tmp4_);
		start_iter = _tmp5_;
		__vala_GtkTextIter_free0 (end_iter);
		_tmp6_ = _tmp3_;
		_tmp7_ = __vala_GtkTextIter_copy0 (&_tmp6_);
		end_iter = _tmp7_;
		_tmp9_ = start_iter;
		_tmp11_ = scratch_widgets_search_bar_search_for_iter_backward (self, _tmp9_, &_tmp10_);
		__vala_GtkTextIter_free0 (end_iter);
		end_iter = _tmp10_;
		if (!_tmp11_) {
			GraniteSwitchModelButton* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = self->priv->cycle_search_button;
			_tmp13_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkTextBuffer* _tmp15_;
			GtkTextIter _tmp16_ = {0};
			GtkTextIter _tmp17_;
			GtkTextIter* _tmp18_;
			GtkTextIter* _tmp19_;
			GtkTextIter* _tmp20_ = NULL;
			_tmp15_ = self->priv->text_buffer;
			gtk_text_buffer_get_end_iter (_tmp15_, &_tmp16_);
			__vala_GtkTextIter_free0 (start_iter);
			_tmp17_ = _tmp16_;
			_tmp18_ = __vala_GtkTextIter_copy0 (&_tmp17_);
			start_iter = _tmp18_;
			_tmp19_ = start_iter;
			scratch_widgets_search_bar_search_for_iter_backward (self, _tmp19_, &_tmp20_);
			__vala_GtkTextIter_free0 (end_iter);
			end_iter = _tmp20_;
		}
		scratch_widgets_search_bar_update_search_widgets (self);
	}
	__vala_GtkTextIter_free0 (end_iter);
	__vala_GtkTextIter_free0 (start_iter);
}

void
scratch_widgets_search_bar_search_next (ScratchWidgetsSearchBar* self)
{
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextIter* end_iter_tmp = NULL;
	GtkTextBuffer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->text_buffer;
	if (_tmp0_ != NULL) {
		GtkTextBuffer* _tmp1_;
		GtkTextIter _tmp2_ = {0};
		GtkTextIter _tmp3_ = {0};
		GtkTextIter _tmp4_;
		GtkTextIter* _tmp5_;
		GtkTextIter _tmp6_;
		GtkTextIter* _tmp7_;
		gboolean _tmp8_ = FALSE;
		GtkTextIter* _tmp9_;
		GtkTextIter* _tmp10_ = NULL;
		gboolean _tmp11_;
		_tmp1_ = self->priv->text_buffer;
		gtk_text_buffer_get_selection_bounds (_tmp1_, &_tmp2_, &_tmp3_);
		__vala_GtkTextIter_free0 (start_iter);
		_tmp4_ = _tmp2_;
		_tmp5_ = __vala_GtkTextIter_copy0 (&_tmp4_);
		start_iter = _tmp5_;
		__vala_GtkTextIter_free0 (end_iter);
		_tmp6_ = _tmp3_;
		_tmp7_ = __vala_GtkTextIter_copy0 (&_tmp6_);
		end_iter = _tmp7_;
		_tmp9_ = end_iter;
		_tmp11_ = scratch_widgets_search_bar_search_for_iter (self, _tmp9_, &_tmp10_);
		__vala_GtkTextIter_free0 (end_iter_tmp);
		end_iter_tmp = _tmp10_;
		if (!_tmp11_) {
			GraniteSwitchModelButton* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp12_ = self->priv->cycle_search_button;
			_tmp13_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = _tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			GtkTextBuffer* _tmp15_;
			GtkTextIter _tmp16_ = {0};
			GtkTextIter _tmp17_;
			GtkTextIter* _tmp18_;
			GtkTextIter* _tmp19_;
			GtkTextIter* _tmp20_ = NULL;
			_tmp15_ = self->priv->text_buffer;
			gtk_text_buffer_get_start_iter (_tmp15_, &_tmp16_);
			__vala_GtkTextIter_free0 (start_iter);
			_tmp17_ = _tmp16_;
			_tmp18_ = __vala_GtkTextIter_copy0 (&_tmp17_);
			start_iter = _tmp18_;
			_tmp19_ = start_iter;
			scratch_widgets_search_bar_search_for_iter (self, _tmp19_, &_tmp20_);
			__vala_GtkTextIter_free0 (end_iter);
			end_iter = _tmp20_;
		}
		scratch_widgets_search_bar_update_search_widgets (self);
	}
	__vala_GtkTextIter_free0 (end_iter_tmp);
	__vala_GtkTextIter_free0 (end_iter);
	__vala_GtkTextIter_free0 (start_iter);
}

static gboolean
scratch_widgets_search_bar_on_search_entry_key_press (ScratchWidgetsSearchBar* self,
                                                      GdkEventKey* event)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* key = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GQuark _tmp10_ = 0U;
	static GQuark _tmp9_label0 = 0;
	static GQuark _tmp9_label1 = 0;
	static GQuark _tmp9_label2 = 0;
	static GQuark _tmp9_label3 = 0;
	static GQuark _tmp9_label4 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gdk_keyval_name (event->keyval);
	_tmp4_ = g_strdup (_tmp3_);
	key = _tmp4_;
	if ((event->state & GDK_SHIFT_MASK) == GDK_SHIFT_MASK) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = key;
		_tmp6_ = g_strconcat ("<Shift>", _tmp5_, NULL);
		_g_free0 (key);
		key = _tmp6_;
	}
	_tmp7_ = key;
	_tmp8_ = _tmp7_;
	_tmp10_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
	if ((_tmp10_ == ((0 != _tmp9_label0) ? _tmp9_label0 : (_tmp9_label0 = g_quark_from_static_string ("<Shift>Return")))) || (_tmp10_ == ((0 != _tmp9_label1) ? _tmp9_label1 : (_tmp9_label1 = g_quark_from_static_string ("Up"))))) {
		switch (0) {
			default:
			{
				scratch_widgets_search_bar_search_previous (self);
				result = TRUE;
				_g_free0 (key);
				return result;
			}
		}
	} else if ((_tmp10_ == ((0 != _tmp9_label2) ? _tmp9_label2 : (_tmp9_label2 = g_quark_from_static_string ("Return")))) || (_tmp10_ == ((0 != _tmp9_label3) ? _tmp9_label3 : (_tmp9_label3 = g_quark_from_static_string ("Down"))))) {
		switch (0) {
			default:
			{
				scratch_widgets_search_bar_search_next (self);
				result = TRUE;
				_g_free0 (key);
				return result;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp9_label4) ? _tmp9_label4 : (_tmp9_label4 = g_quark_from_static_string ("Tab")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = self->search_entry;
				g_object_get ((GtkWidget*) _tmp11_, "is-focus", &_tmp12_, NULL);
				_tmp13_ = _tmp12_;
				if (_tmp13_) {
					GtkSearchEntry* _tmp14_;
					_tmp14_ = self->replace_entry;
					gtk_widget_grab_focus ((GtkWidget*) _tmp14_);
				}
				result = TRUE;
				_g_free0 (key);
				return result;
			}
		}
	}
	result = FALSE;
	_g_free0 (key);
	return result;
}

static gboolean
scratch_widgets_search_bar_on_replace_entry_key_press (ScratchWidgetsSearchBar* self,
                                                       GdkEventKey* event)
{
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "") == 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gdk_keyval_name (event->keyval);
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("Up")))) {
		switch (0) {
			default:
			{
				scratch_widgets_search_bar_search_previous (self);
				result = TRUE;
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("Down")))) {
		switch (0) {
			default:
			{
				scratch_widgets_search_bar_search_next (self);
				result = TRUE;
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("Tab")))) {
		switch (0) {
			default:
			{
				GtkSearchEntry* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				_tmp7_ = self->replace_entry;
				g_object_get ((GtkWidget*) _tmp7_, "is-focus", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					GtkSearchEntry* _tmp10_;
					_tmp10_ = self->search_entry;
					gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
				}
				result = TRUE;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static void
scratch_widgets_search_bar_cancel_update_search_widgets (ScratchWidgetsSearchBar* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->update_search_label_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->update_search_label_timeout_id);
		self->priv->update_search_label_timeout_id = (guint) 0;
	}
}

static gboolean
__lambda120_ (ScratchWidgetsSearchBar* self)
{
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter* iter = NULL;
	GtkTextIter* start_iter = NULL;
	GtkTextIter* end_iter = NULL;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GtkTextIter _tmp9_ = {0};
	GtkTextIter _tmp10_;
	GtkTextIter* _tmp11_;
	gint count_of_search = 0;
	GtkSourceSearchContext* _tmp12_;
	gint location_of_search = 0;
	gboolean found = FALSE;
	GtkSourceSearchContext* _tmp13_;
	GtkTextIter* _tmp14_;
	GtkTextIter _tmp15_;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter _tmp17_ = {0};
	gboolean _tmp18_;
	GtkTextIter _tmp19_;
	GtkTextIter* _tmp20_;
	GtkTextIter _tmp21_;
	GtkTextIter* _tmp22_;
	gboolean _tmp23_ = FALSE;
	GtkButton* _tmp33_;
	GtkButton* _tmp34_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	GtkTextBuffer* _tmp37_;
	GtkStyleContext* ctx = NULL;
	GtkSearchEntry* _tmp93_;
	GtkStyleContext* _tmp94_;
	GtkStyleContext* _tmp95_;
	gboolean _tmp96_ = FALSE;
	GtkSearchEntry* _tmp97_;
	const gchar* _tmp98_;
	const gchar* _tmp99_;
	gboolean result;
	self->priv->update_search_label_timeout_id = (guint) 0;
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		GtkButton* _tmp4_;
		g_debug ("SearchBar.vala:548: update occurrence with null context");
		_tmp1_ = self->priv->replace_tool_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
		_tmp2_ = self->priv->replace_all_tool_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
		_tmp3_ = self->priv->tool_arrow_up;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
		_tmp4_ = self->priv->tool_arrow_down;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
		result = G_SOURCE_REMOVE;
		return result;
	}
	_tmp5_ = self->priv->text_buffer;
	_tmp6_ = self->priv->text_buffer;
	g_object_get (_tmp6_, "cursor-position", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	gtk_text_buffer_get_iter_at_offset (_tmp5_, &_tmp9_, _tmp8_);
	__vala_GtkTextIter_free0 (iter);
	_tmp10_ = _tmp9_;
	_tmp11_ = __vala_GtkTextIter_copy0 (&_tmp10_);
	iter = _tmp11_;
	_tmp12_ = self->priv->_search_context;
	count_of_search = gtk_source_search_context_get_occurrences_count (_tmp12_);
	location_of_search = 0;
	_tmp13_ = self->priv->_search_context;
	_tmp14_ = iter;
	_tmp15_ = *_tmp14_;
	_tmp18_ = gtk_source_search_context_forward (_tmp13_, &_tmp15_, &_tmp16_, &_tmp17_, NULL);
	__vala_GtkTextIter_free0 (start_iter);
	_tmp19_ = _tmp16_;
	_tmp20_ = __vala_GtkTextIter_copy0 (&_tmp19_);
	start_iter = _tmp20_;
	__vala_GtkTextIter_free0 (end_iter);
	_tmp21_ = _tmp17_;
	_tmp22_ = __vala_GtkTextIter_copy0 (&_tmp21_);
	end_iter = _tmp22_;
	found = _tmp18_;
	if (count_of_search > 0) {
		_tmp23_ = found;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GtkSourceSearchContext* _tmp24_;
		GtkTextIter* _tmp25_;
		GtkTextIter* _tmp26_;
		GtkTextIter _tmp27_;
		GtkTextIter _tmp28_;
		_tmp24_ = self->priv->_search_context;
		_tmp25_ = start_iter;
		_tmp26_ = end_iter;
		_tmp27_ = *_tmp25_;
		_tmp28_ = *_tmp26_;
		location_of_search = gtk_source_search_context_get_occurrence_position (_tmp24_, &_tmp27_, &_tmp28_);
	}
	if (count_of_search > -1) {
		if (count_of_search > 0) {
			GtkLabel* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp29_ = self->priv->search_occurence_count_label;
			_tmp30_ = g_strdup_printf (_ ("%d of %d"), location_of_search, count_of_search);
			_tmp31_ = _tmp30_;
			gtk_label_set_label (_tmp29_, _tmp31_);
			_g_free0 (_tmp31_);
		} else {
			GtkLabel* _tmp32_;
			_tmp32_ = self->priv->search_occurence_count_label;
			gtk_label_set_label (_tmp32_, _ ("no results"));
		}
	}
	_tmp33_ = self->priv->replace_tool_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, location_of_search > 0);
	_tmp34_ = self->priv->replace_all_tool_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp34_, count_of_search > 0);
	_tmp37_ = self->priv->text_buffer;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		GtkSearchEntry* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp38_ = self->search_entry;
		_tmp39_ = gtk_entry_get_text ((GtkEntry*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp36_ = g_strcmp0 (_tmp40_, "") == 0;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = count_of_search == 0;
	}
	if (_tmp35_) {
		GtkButton* _tmp41_;
		GtkButton* _tmp42_;
		_tmp41_ = self->priv->tool_arrow_up;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp41_, FALSE);
		_tmp42_ = self->priv->tool_arrow_down;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp42_, FALSE);
	} else {
		GraniteSwitchModelButton* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp43_ = self->priv->cycle_search_button;
		_tmp44_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_) {
			GtkButton* _tmp46_;
			GtkButton* _tmp47_;
			_tmp46_ = self->priv->tool_arrow_down;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp46_, TRUE);
			_tmp47_ = self->priv->tool_arrow_up;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp47_, TRUE);
		} else {
			GtkTextIter* tmp_start_iter = NULL;
			GtkTextIter* tmp_end_iter = NULL;
			gboolean is_in_start = FALSE;
			gboolean is_in_end = FALSE;
			GtkTextBuffer* _tmp48_;
			GtkTextIter _tmp49_ = {0};
			GtkTextIter _tmp50_;
			GtkTextIter* _tmp51_;
			GtkTextBuffer* _tmp52_;
			GtkTextIter _tmp53_ = {0};
			GtkTextIter _tmp54_;
			GtkTextIter* _tmp55_;
			GtkTextBuffer* _tmp56_;
			GtkTextIter _tmp57_ = {0};
			GtkTextIter _tmp58_ = {0};
			GtkTextIter _tmp59_;
			GtkTextIter* _tmp60_;
			GtkTextIter _tmp61_;
			GtkTextIter* _tmp62_;
			GtkTextIter* _tmp63_;
			GtkTextIter* _tmp64_;
			GtkTextIter _tmp65_;
			GtkTextIter* _tmp66_;
			GtkTextIter* _tmp67_;
			GtkTextIter _tmp68_;
			_tmp48_ = self->priv->text_buffer;
			gtk_text_buffer_get_start_iter (_tmp48_, &_tmp49_);
			__vala_GtkTextIter_free0 (tmp_start_iter);
			_tmp50_ = _tmp49_;
			_tmp51_ = __vala_GtkTextIter_copy0 (&_tmp50_);
			tmp_start_iter = _tmp51_;
			_tmp52_ = self->priv->text_buffer;
			gtk_text_buffer_get_end_iter (_tmp52_, &_tmp53_);
			__vala_GtkTextIter_free0 (tmp_end_iter);
			_tmp54_ = _tmp53_;
			_tmp55_ = __vala_GtkTextIter_copy0 (&_tmp54_);
			tmp_end_iter = _tmp55_;
			_tmp56_ = self->priv->text_buffer;
			gtk_text_buffer_get_selection_bounds (_tmp56_, &_tmp57_, &_tmp58_);
			__vala_GtkTextIter_free0 (start_iter);
			_tmp59_ = _tmp57_;
			_tmp60_ = __vala_GtkTextIter_copy0 (&_tmp59_);
			start_iter = _tmp60_;
			__vala_GtkTextIter_free0 (end_iter);
			_tmp61_ = _tmp58_;
			_tmp62_ = __vala_GtkTextIter_copy0 (&_tmp61_);
			end_iter = _tmp62_;
			_tmp63_ = start_iter;
			_tmp64_ = tmp_start_iter;
			_tmp65_ = *_tmp64_;
			is_in_start = gtk_text_iter_compare (_tmp63_, &_tmp65_) == 0;
			_tmp66_ = end_iter;
			_tmp67_ = tmp_end_iter;
			_tmp68_ = *_tmp67_;
			is_in_end = gtk_text_iter_compare (_tmp66_, &_tmp68_) == 0;
			if (!is_in_end) {
				GtkButton* _tmp69_;
				GtkSourceSearchContext* _tmp70_;
				GtkTextIter* _tmp71_;
				GtkTextIter _tmp72_;
				GtkTextIter _tmp73_ = {0};
				GtkTextIter _tmp74_ = {0};
				gboolean _tmp75_;
				GtkTextIter _tmp76_;
				GtkTextIter* _tmp77_;
				GtkTextIter _tmp78_;
				GtkTextIter* _tmp79_;
				_tmp69_ = self->priv->tool_arrow_down;
				_tmp70_ = self->priv->_search_context;
				_tmp71_ = end_iter;
				_tmp72_ = *_tmp71_;
				_tmp75_ = gtk_source_search_context_forward (_tmp70_, &_tmp72_, &_tmp73_, &_tmp74_, NULL);
				__vala_GtkTextIter_free0 (tmp_start_iter);
				_tmp76_ = _tmp73_;
				_tmp77_ = __vala_GtkTextIter_copy0 (&_tmp76_);
				tmp_start_iter = _tmp77_;
				__vala_GtkTextIter_free0 (tmp_end_iter);
				_tmp78_ = _tmp74_;
				_tmp79_ = __vala_GtkTextIter_copy0 (&_tmp78_);
				tmp_end_iter = _tmp79_;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp69_, _tmp75_);
			} else {
				GtkButton* _tmp80_;
				_tmp80_ = self->priv->tool_arrow_down;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp80_, FALSE);
			}
			if (!is_in_start) {
				GtkButton* _tmp81_;
				GtkSourceSearchContext* _tmp82_;
				GtkTextIter* _tmp83_;
				GtkTextIter _tmp84_;
				GtkTextIter _tmp85_ = {0};
				GtkTextIter _tmp86_ = {0};
				gboolean _tmp87_;
				GtkTextIter _tmp88_;
				GtkTextIter* _tmp89_;
				GtkTextIter _tmp90_;
				GtkTextIter* _tmp91_;
				_tmp81_ = self->priv->tool_arrow_up;
				_tmp82_ = self->priv->_search_context;
				_tmp83_ = start_iter;
				_tmp84_ = *_tmp83_;
				_tmp87_ = gtk_source_search_context_backward (_tmp82_, &_tmp84_, &_tmp85_, &_tmp86_, NULL);
				__vala_GtkTextIter_free0 (tmp_start_iter);
				_tmp88_ = _tmp85_;
				_tmp89_ = __vala_GtkTextIter_copy0 (&_tmp88_);
				tmp_start_iter = _tmp89_;
				__vala_GtkTextIter_free0 (end_iter);
				_tmp90_ = _tmp86_;
				_tmp91_ = __vala_GtkTextIter_copy0 (&_tmp90_);
				end_iter = _tmp91_;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp81_, _tmp87_);
			} else {
				GtkButton* _tmp92_;
				_tmp92_ = self->priv->tool_arrow_up;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp92_, FALSE);
			}
			__vala_GtkTextIter_free0 (tmp_end_iter);
			__vala_GtkTextIter_free0 (tmp_start_iter);
		}
	}
	_tmp93_ = self->search_entry;
	_tmp94_ = gtk_widget_get_style_context ((GtkWidget*) _tmp93_);
	_tmp95_ = _g_object_ref0 (_tmp94_);
	ctx = _tmp95_;
	_tmp97_ = self->search_entry;
	_tmp98_ = gtk_entry_get_text ((GtkEntry*) _tmp97_);
	_tmp99_ = _tmp98_;
	if (g_strcmp0 (_tmp99_, "") != 0) {
		_tmp96_ = count_of_search == 0;
	} else {
		_tmp96_ = FALSE;
	}
	if (_tmp96_) {
		GtkStyleContext* _tmp100_;
		GtkSearchEntry* _tmp101_;
		_tmp100_ = ctx;
		gtk_style_context_add_class (_tmp100_, GTK_STYLE_CLASS_ERROR);
		_tmp101_ = self->search_entry;
		g_object_set ((GtkEntry*) _tmp101_, "primary-icon-name", "dialog-error-symbolic", NULL);
	} else {
		GtkStyleContext* _tmp102_;
		_tmp102_ = ctx;
		if (gtk_style_context_has_class (_tmp102_, GTK_STYLE_CLASS_ERROR)) {
			GtkStyleContext* _tmp103_;
			GtkSearchEntry* _tmp104_;
			_tmp103_ = ctx;
			gtk_style_context_remove_class (_tmp103_, GTK_STYLE_CLASS_ERROR);
			_tmp104_ = self->search_entry;
			g_object_set ((GtkEntry*) _tmp104_, "primary-icon-name", "edit-find-symbolic", NULL);
		}
	}
	result = G_SOURCE_REMOVE;
	_g_object_unref0 (ctx);
	__vala_GtkTextIter_free0 (end_iter);
	__vala_GtkTextIter_free0 (start_iter);
	__vala_GtkTextIter_free0 (iter);
	return result;
}

static gboolean
___lambda120__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda120_ ((ScratchWidgetsSearchBar*) self);
	return result;
}

static void
scratch_widgets_search_bar_update_search_widgets (ScratchWidgetsSearchBar* self)
{
	g_return_if_fail (self != NULL);
	scratch_widgets_search_bar_cancel_update_search_widgets (self);
	self->priv->update_search_label_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda120__gsource_func, g_object_ref (self), g_object_unref);
}

ScratchMainWindow*
scratch_widgets_search_bar_get_window (ScratchWidgetsSearchBar* self)
{
	ScratchMainWindow* result;
	ScratchMainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
scratch_widgets_search_bar_set_window (ScratchWidgetsSearchBar* self,
                                       ScratchMainWindow* value)
{
	ScratchMainWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_widgets_search_bar_get_window (self);
	if (old_value != value) {
		self->priv->_window = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_widgets_search_bar_properties[SCRATCH_WIDGETS_SEARCH_BAR_WINDOW_PROPERTY]);
	}
}

GtkSourceSearchContext*
scratch_widgets_search_bar_get_search_context (ScratchWidgetsSearchBar* self)
{
	GtkSourceSearchContext* result;
	GtkSourceSearchContext* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_context;
	result = _tmp0_;
	return result;
}

static void
scratch_widgets_search_bar_set_search_context (ScratchWidgetsSearchBar* self,
                                               GtkSourceSearchContext* value)
{
	GtkSourceSearchContext* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_widgets_search_bar_get_search_context (self);
	if (old_value != value) {
		GtkSourceSearchContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_search_context);
		self->priv->_search_context = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_widgets_search_bar_properties[SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_CONTEXT_PROPERTY]);
	}
}

static void
_scratch_widgets_search_bar_search_next_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self)
{
	scratch_widgets_search_bar_search_next ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar_search_previous_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self)
{
	scratch_widgets_search_bar_search_previous ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar_on_search_entry_text_changed_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                    gpointer self)
{
	scratch_widgets_search_bar_on_search_entry_text_changed ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar_on_search_entry_text_changed_gtk_combo_box_changed (GtkComboBox* _sender,
                                                                                gpointer self)
{
	scratch_widgets_search_bar_on_search_entry_text_changed ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar_on_replace_entry_activate_gtk_button_clicked (GtkButton* _sender,
                                                                          gpointer self)
{
	scratch_widgets_search_bar_on_replace_entry_activate ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar_on_replace_all_entry_activate_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self)
{
	scratch_widgets_search_bar_on_replace_all_entry_activate ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar_on_search_entry_text_changed_gtk_editable_changed (GtkEditable* _sender,
                                                                               gpointer self)
{
	scratch_widgets_search_bar_on_search_entry_text_changed ((ScratchWidgetsSearchBar*) self);
}

static gboolean
_scratch_widgets_search_bar_on_search_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                  GdkEventKey* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = scratch_widgets_search_bar_on_search_entry_key_press ((ScratchWidgetsSearchBar*) self, event);
	return result;
}

static gboolean
_scratch_widgets_search_bar_on_search_entry_focused_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                                  GdkEventFocus* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = scratch_widgets_search_bar_on_search_entry_focused_in ((ScratchWidgetsSearchBar*) self, event);
	return result;
}

static void
_scratch_widgets_search_bar_update_search_widgets_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                   gpointer self)
{
	scratch_widgets_search_bar_update_search_widgets ((ScratchWidgetsSearchBar*) self);
}

static void
_scratch_widgets_search_bar___lambda121_ (ScratchWidgetsSearchBar* self,
                                          GtkEntryIconPosition p0,
                                          GdkEvent* p1)
{
	g_return_if_fail (p1 != NULL);
	if (p0 == GTK_ENTRY_ICON_PRIMARY) {
		scratch_widgets_search_bar_search_next (self);
	}
}

static void
__scratch_widgets_search_bar___lambda121__gtk_entry_icon_release (GtkEntry* _sender,
                                                                  GtkEntryIconPosition icon_pos,
                                                                  GdkEvent* event,
                                                                  gpointer self)
{
	_scratch_widgets_search_bar___lambda121_ ((ScratchWidgetsSearchBar*) self, icon_pos, event);
}

static void
_scratch_widgets_search_bar_on_replace_entry_activate_gtk_entry_activate (GtkEntry* _sender,
                                                                          gpointer self)
{
	scratch_widgets_search_bar_on_replace_entry_activate ((ScratchWidgetsSearchBar*) self);
}

static gboolean
_scratch_widgets_search_bar_on_replace_entry_key_press_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                   GdkEventKey* event,
                                                                                   gpointer self)
{
	gboolean result;
	result = scratch_widgets_search_bar_on_replace_entry_key_press ((ScratchWidgetsSearchBar*) self, event);
	return result;
}

static GObject *
scratch_widgets_search_bar_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchWidgetsSearchBar * self;
	gchar* _tmp0_;
	GtkSearchEntry* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	ScratchApplication* app_instance = NULL;
	GApplication* _tmp5_;
	ScratchApplication* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	ScratchApplication* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkButton* _tmp17_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* _tmp20_;
	ScratchApplication* _tmp21_;
	gchar** _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	gchar* _tmp26_;
	GraniteSwitchModelButton* _tmp27_;
	GtkComboBoxText* _tmp28_;
	GtkComboBoxText* _tmp29_;
	GtkComboBoxText* _tmp30_;
	GtkComboBoxText* _tmp31_;
	GtkComboBoxText* _tmp32_;
	GtkLabel* case_sensitive_search_label = NULL;
	GtkLabel* _tmp33_;
	GtkBox* case_sensitive_box = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkLabel* _tmp36_;
	GtkBox* _tmp37_;
	GtkComboBoxText* _tmp38_;
	GtkBox* _tmp39_;
	GtkStyleContext* _tmp40_;
	GraniteSwitchModelButton* _tmp41_;
	GraniteSwitchModelButton* _tmp42_;
	GtkBox* search_option_box = NULL;
	GtkBox* _tmp43_ = NULL;
	GtkBox* _tmp44_;
	GraniteSwitchModelButton* _tmp45_;
	GtkBox* _tmp46_;
	GtkBox* _tmp47_;
	GtkBox* _tmp48_;
	GraniteSwitchModelButton* _tmp49_;
	GtkBox* _tmp50_;
	GraniteSwitchModelButton* _tmp51_;
	GtkPopover* search_popover = NULL;
	GtkPopover* _tmp52_;
	GtkPopover* _tmp53_;
	GtkBox* _tmp54_;
	GtkPopover* _tmp55_;
	GtkBox* search_buttonbox = NULL;
	GtkBox* _tmp56_;
	GtkBox* _tmp57_;
	GtkLabel* _tmp58_;
	GtkBox* _tmp59_;
	GtkImage* _tmp60_;
	GtkImage* _tmp61_;
	GtkMenuButton* search_menubutton = NULL;
	GtkPopover* _tmp62_;
	GtkPopover* _tmp63_;
	gchar* _tmp64_;
	GtkMenuButton* _tmp65_ = NULL;
	GtkMenuButton* _tmp66_;
	GtkBox* _tmp67_;
	GraniteSwitchModelButton* _tmp68_;
	GtkComboBoxText* _tmp69_;
	GraniteSwitchModelButton* _tmp70_;
	GraniteSwitchModelButton* _tmp71_;
	GSettings* _tmp72_;
	GraniteSwitchModelButton* _tmp73_;
	GSettings* _tmp74_;
	GraniteSwitchModelButton* _tmp75_;
	GSettings* _tmp76_;
	GraniteSwitchModelButton* _tmp77_;
	GSettings* _tmp78_;
	GtkComboBoxText* _tmp79_;
	GtkBox* search_box = NULL;
	GtkBox* _tmp80_ = NULL;
	GtkBox* _tmp81_;
	GtkStyleContext* _tmp82_;
	GtkBox* _tmp83_;
	GtkSearchEntry* _tmp84_;
	GtkBox* _tmp85_;
	GtkButton* _tmp86_;
	GtkBox* _tmp87_;
	GtkButton* _tmp88_;
	GtkBox* _tmp89_;
	GtkMenuButton* _tmp90_;
	GtkFlowBoxChild* search_flow_box_child = NULL;
	GtkFlowBoxChild* _tmp91_;
	GtkFlowBoxChild* _tmp92_;
	GtkFlowBoxChild* _tmp93_;
	GtkBox* _tmp94_;
	GtkSearchEntry* _tmp95_;
	GtkSearchEntry* _tmp96_;
	GtkSearchEntry* _tmp97_;
	GtkSearchEntry* _tmp98_;
	GtkButton* _tmp99_;
	GtkButton* _tmp100_;
	GtkButton* _tmp101_;
	GtkButton* _tmp102_;
	GtkGrid* replace_grid = NULL;
	GtkGrid* _tmp103_ = NULL;
	GtkGrid* _tmp104_;
	GtkStyleContext* _tmp105_;
	GtkGrid* _tmp106_;
	GtkSearchEntry* _tmp107_;
	GtkGrid* _tmp108_;
	GtkButton* _tmp109_;
	GtkGrid* _tmp110_;
	GtkButton* _tmp111_;
	GtkFlowBoxChild* replace_flow_box_child = NULL;
	GtkFlowBoxChild* _tmp112_;
	GtkFlowBoxChild* _tmp113_;
	GtkFlowBoxChild* _tmp114_;
	GtkGrid* _tmp115_;
	GtkSearchEntry* _tmp116_;
	GtkSearchEntry* _tmp117_;
	GtkSearchEntry* _tmp118_;
	GtkSearchEntry* _tmp119_;
	GtkSearchEntry* _tmp120_;
	GtkSearchEntry* _tmp121_;
	GtkSearchEntry* _tmp122_;
	GtkWidgetPath* entry_path = NULL;
	GtkWidgetPath* _tmp123_;
	GtkWidgetPath* _tmp124_;
	GtkStyleContext* entry_context = NULL;
	GtkStyleContext* _tmp125_;
	GtkStyleContext* _tmp126_;
	GtkWidgetPath* _tmp127_;
	GtkStyleContext* _tmp128_;
	GtkStyleContext* _tmp129_;
	GtkFlowBoxChild* _tmp130_;
	GtkFlowBoxChild* _tmp131_;
	parent_class = G_OBJECT_CLASS (scratch_widgets_search_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_WIDGETS_TYPE_SEARCH_BAR, ScratchWidgetsSearchBar);
	_tmp0_ = g_strdup (_ ("Find"));
	_tmp1_ = (GtkSearchEntry*) gtk_search_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp1_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("No Results"));
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->search_occurence_count_label);
	self->priv->search_occurence_count_label = _tmp2_;
	_tmp3_ = self->priv->search_occurence_count_label;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	gtk_style_context_add_class (_tmp4_, GRANITE_STYLE_CLASS_SMALL_LABEL);
	_tmp5_ = g_application_get_default ();
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, SCRATCH_TYPE_APPLICATION, ScratchApplication));
	app_instance = _tmp6_;
	_tmp7_ = (GtkButton*) gtk_button_new_from_icon_name ("go-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->tool_arrow_down);
	self->priv->tool_arrow_down = _tmp7_;
	_tmp8_ = self->priv->tool_arrow_down;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) _scratch_widgets_search_bar_search_next_gtk_button_clicked, self, 0);
	_tmp9_ = self->priv->tool_arrow_down;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
	_tmp10_ = self->priv->tool_arrow_down;
	_tmp11_ = app_instance;
	_tmp13_ = _tmp12_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp11_, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND_NEXT);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _vala_array_length (_tmp12_);
	_tmp15_ = granite_markup_accel_tooltip (_tmp14_, (gint) _vala_array_length (_tmp12_), _ ("Search next"));
	_tmp16_ = _tmp15_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp10_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	_tmp17_ = (GtkButton*) gtk_button_new_from_icon_name ("go-up-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->tool_arrow_up);
	self->priv->tool_arrow_up = _tmp17_;
	_tmp18_ = self->priv->tool_arrow_up;
	g_signal_connect_object (_tmp18_, "clicked", (GCallback) _scratch_widgets_search_bar_search_previous_gtk_button_clicked, self, 0);
	_tmp19_ = self->priv->tool_arrow_up;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
	_tmp20_ = self->priv->tool_arrow_up;
	_tmp21_ = app_instance;
	_tmp23_ = _tmp22_ = gtk_application_get_accels_for_action ((GtkApplication*) _tmp21_, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND_PREVIOUS);
	_tmp24_ = _tmp23_;
	_tmp24__length1 = _vala_array_length (_tmp22_);
	_tmp25_ = granite_markup_accel_tooltip (_tmp24_, (gint) _vala_array_length (_tmp22_), _ ("Search previous"));
	_tmp26_ = _tmp25_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp20_, _tmp26_);
	_g_free0 (_tmp26_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = granite_switch_model_button_new (_ ("Cyclic Search"));
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->cycle_search_button);
	self->priv->cycle_search_button = _tmp27_;
	_tmp28_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->case_sensitive_search_button);
	self->priv->case_sensitive_search_button = _tmp28_;
	_tmp29_ = self->priv->case_sensitive_search_button;
	gtk_combo_box_text_append (_tmp29_, "never", _ ("Never"));
	_tmp30_ = self->priv->case_sensitive_search_button;
	gtk_combo_box_text_append (_tmp30_, "mixed", _ ("Mixed Case"));
	_tmp31_ = self->priv->case_sensitive_search_button;
	gtk_combo_box_text_append (_tmp31_, "always", _ ("Always"));
	_tmp32_ = self->priv->case_sensitive_search_button;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp32_, 1);
	_tmp33_ = (GtkLabel*) gtk_label_new (_ ("Case Sensitive"));
	g_object_ref_sink (_tmp33_);
	case_sensitive_search_label = _tmp33_;
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp34_);
	case_sensitive_box = _tmp34_;
	_tmp35_ = case_sensitive_box;
	_tmp36_ = case_sensitive_search_label;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp36_);
	_tmp37_ = case_sensitive_box;
	_tmp38_ = self->priv->case_sensitive_search_button;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = case_sensitive_box;
	_tmp40_ = gtk_widget_get_style_context ((GtkWidget*) _tmp39_);
	gtk_style_context_add_class (_tmp40_, GTK_STYLE_CLASS_MENUITEM);
	_tmp41_ = granite_switch_model_button_new (_ ("Use Regular Expressions"));
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->regex_search_button);
	self->priv->regex_search_button = _tmp41_;
	_tmp42_ = granite_switch_model_button_new (_ ("Match Whole Words"));
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (self->priv->whole_word_search_button);
	self->priv->whole_word_search_button = _tmp42_;
	_tmp43_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp43_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp43_, 3);
	g_object_ref_sink (_tmp43_);
	search_option_box = _tmp43_;
	_tmp44_ = search_option_box;
	_tmp45_ = self->priv->cycle_search_button;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = search_option_box;
	_tmp47_ = case_sensitive_box;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = search_option_box;
	_tmp49_ = self->priv->whole_word_search_button;
	gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
	_tmp50_ = search_option_box;
	_tmp51_ = self->priv->regex_search_button;
	gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_ref_sink (_tmp52_);
	search_popover = _tmp52_;
	_tmp53_ = search_popover;
	_tmp54_ = search_option_box;
	gtk_container_add ((GtkContainer*) _tmp53_, (GtkWidget*) _tmp54_);
	_tmp55_ = search_popover;
	gtk_widget_show_all ((GtkWidget*) _tmp55_);
	_tmp56_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp56_);
	search_buttonbox = _tmp56_;
	_tmp57_ = search_buttonbox;
	_tmp58_ = self->priv->search_occurence_count_label;
	gtk_container_add ((GtkContainer*) _tmp57_, (GtkWidget*) _tmp58_);
	_tmp59_ = search_buttonbox;
	_tmp60_ = (GtkImage*) gtk_image_new_from_icon_name ("pan-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp60_);
	_tmp61_ = _tmp60_;
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp61_);
	_g_object_unref0 (_tmp61_);
	_tmp62_ = search_popover;
	_tmp63_ = _g_object_ref0 (_tmp62_);
	_tmp64_ = g_strdup (_ ("Search Options"));
	_tmp65_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_popover (_tmp65_, _tmp63_);
	_g_object_unref0 (_tmp63_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp65_, _tmp64_);
	_g_free0 (_tmp64_);
	g_object_ref_sink (_tmp65_);
	search_menubutton = _tmp65_;
	_tmp66_ = search_menubutton;
	_tmp67_ = search_buttonbox;
	gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
	_tmp68_ = self->priv->cycle_search_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp68_, "toggled", (GCallback) _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_toggle_button_toggled, self, 0);
	_tmp69_ = self->priv->case_sensitive_search_button;
	g_signal_connect_object ((GtkComboBox*) _tmp69_, "changed", (GCallback) _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_combo_box_changed, self, 0);
	_tmp70_ = self->priv->whole_word_search_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp70_, "toggled", (GCallback) _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_toggle_button_toggled, self, 0);
	_tmp71_ = self->priv->regex_search_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp71_, "toggled", (GCallback) _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_toggle_button_toggled, self, 0);
	_tmp72_ = scratch_settings;
	_tmp73_ = self->priv->cycle_search_button;
	g_settings_bind (_tmp72_, "cyclic-search", (GObject*) _tmp73_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp74_ = scratch_settings;
	_tmp75_ = self->priv->whole_word_search_button;
	g_settings_bind (_tmp74_, "wholeword-search", (GObject*) _tmp75_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp76_ = scratch_settings;
	_tmp77_ = self->priv->regex_search_button;
	g_settings_bind (_tmp76_, "regex-search", (GObject*) _tmp77_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp78_ = scratch_settings;
	_tmp79_ = self->priv->case_sensitive_search_button;
	g_settings_bind (_tmp78_, "case-sensitive-search", (GObject*) _tmp79_, "active-id", G_SETTINGS_BIND_DEFAULT);
	_tmp80_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp80_, 3);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp80_, 3);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp80_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp80_, 6);
	g_object_ref_sink (_tmp80_);
	search_box = _tmp80_;
	_tmp81_ = search_box;
	_tmp82_ = gtk_widget_get_style_context ((GtkWidget*) _tmp81_);
	gtk_style_context_add_class (_tmp82_, GTK_STYLE_CLASS_LINKED);
	_tmp83_ = search_box;
	_tmp84_ = self->search_entry;
	gtk_container_add ((GtkContainer*) _tmp83_, (GtkWidget*) _tmp84_);
	_tmp85_ = search_box;
	_tmp86_ = self->priv->tool_arrow_down;
	gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
	_tmp87_ = search_box;
	_tmp88_ = self->priv->tool_arrow_up;
	gtk_container_add ((GtkContainer*) _tmp87_, (GtkWidget*) _tmp88_);
	_tmp89_ = search_box;
	_tmp90_ = search_menubutton;
	gtk_container_add ((GtkContainer*) _tmp89_, (GtkWidget*) _tmp90_);
	_tmp91_ = (GtkFlowBoxChild*) gtk_flow_box_child_new ();
	g_object_ref_sink (_tmp91_);
	search_flow_box_child = _tmp91_;
	_tmp92_ = search_flow_box_child;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp92_, FALSE);
	_tmp93_ = search_flow_box_child;
	_tmp94_ = search_box;
	gtk_container_add ((GtkContainer*) _tmp93_, (GtkWidget*) _tmp94_);
	_tmp95_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp95_);
	_g_object_unref0 (self->replace_entry);
	self->replace_entry = _tmp95_;
	_tmp96_ = self->replace_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp96_, TRUE);
	_tmp97_ = self->replace_entry;
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp97_, _ ("Replace With"));
	_tmp98_ = self->replace_entry;
	gtk_entry_set_icon_from_icon_name ((GtkEntry*) _tmp98_, GTK_ENTRY_ICON_PRIMARY, "edit-symbolic");
	_tmp99_ = (GtkButton*) gtk_button_new_with_label (_ ("Replace"));
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->replace_tool_button);
	self->priv->replace_tool_button = _tmp99_;
	_tmp100_ = self->priv->replace_tool_button;
	g_signal_connect_object (_tmp100_, "clicked", (GCallback) _scratch_widgets_search_bar_on_replace_entry_activate_gtk_button_clicked, self, 0);
	_tmp101_ = (GtkButton*) gtk_button_new_with_label (_ ("Replace all"));
	g_object_ref_sink (_tmp101_);
	_g_object_unref0 (self->priv->replace_all_tool_button);
	self->priv->replace_all_tool_button = _tmp101_;
	_tmp102_ = self->priv->replace_all_tool_button;
	g_signal_connect_object (_tmp102_, "clicked", (GCallback) _scratch_widgets_search_bar_on_replace_all_entry_activate_gtk_button_clicked, self, 0);
	_tmp103_ = (GtkGrid*) gtk_grid_new ();
	gtk_widget_set_margin_top ((GtkWidget*) _tmp103_, 3);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp103_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp103_, 3);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp103_, 3);
	g_object_ref_sink (_tmp103_);
	replace_grid = _tmp103_;
	_tmp104_ = replace_grid;
	_tmp105_ = gtk_widget_get_style_context ((GtkWidget*) _tmp104_);
	gtk_style_context_add_class (_tmp105_, GTK_STYLE_CLASS_LINKED);
	_tmp106_ = replace_grid;
	_tmp107_ = self->replace_entry;
	gtk_container_add ((GtkContainer*) _tmp106_, (GtkWidget*) _tmp107_);
	_tmp108_ = replace_grid;
	_tmp109_ = self->priv->replace_tool_button;
	gtk_container_add ((GtkContainer*) _tmp108_, (GtkWidget*) _tmp109_);
	_tmp110_ = replace_grid;
	_tmp111_ = self->priv->replace_all_tool_button;
	gtk_container_add ((GtkContainer*) _tmp110_, (GtkWidget*) _tmp111_);
	_tmp112_ = (GtkFlowBoxChild*) gtk_flow_box_child_new ();
	g_object_ref_sink (_tmp112_);
	replace_flow_box_child = _tmp112_;
	_tmp113_ = replace_flow_box_child;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp113_, FALSE);
	_tmp114_ = replace_flow_box_child;
	_tmp115_ = replace_grid;
	gtk_container_add ((GtkContainer*) _tmp114_, (GtkWidget*) _tmp115_);
	_tmp116_ = self->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp116_, "changed", (GCallback) _scratch_widgets_search_bar_on_search_entry_text_changed_gtk_editable_changed, self, 0);
	_tmp117_ = self->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp117_, "key-press-event", (GCallback) _scratch_widgets_search_bar_on_search_entry_key_press_gtk_widget_key_press_event, self, 0);
	_tmp118_ = self->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp118_, "focus-in-event", (GCallback) _scratch_widgets_search_bar_on_search_entry_focused_in_gtk_widget_focus_in_event, self, 0);
	_tmp119_ = self->search_entry;
	g_signal_connect_object (_tmp119_, "search-changed", (GCallback) _scratch_widgets_search_bar_update_search_widgets_gtk_search_entry_search_changed, self, 0);
	_tmp120_ = self->search_entry;
	g_signal_connect_object ((GtkEntry*) _tmp120_, "icon-release", (GCallback) __scratch_widgets_search_bar___lambda121__gtk_entry_icon_release, self, 0);
	_tmp121_ = self->replace_entry;
	g_signal_connect_object ((GtkEntry*) _tmp121_, "activate", (GCallback) _scratch_widgets_search_bar_on_replace_entry_activate_gtk_entry_activate, self, 0);
	_tmp122_ = self->replace_entry;
	g_signal_connect_object ((GtkWidget*) _tmp122_, "key-press-event", (GCallback) _scratch_widgets_search_bar_on_replace_entry_key_press_gtk_widget_key_press_event, self, 0);
	_tmp123_ = gtk_widget_path_new ();
	entry_path = _tmp123_;
	_tmp124_ = entry_path;
	gtk_widget_path_append_type (_tmp124_, gtk_widget_get_type ());
	_tmp125_ = gtk_style_context_new ();
	entry_context = _tmp125_;
	_tmp126_ = entry_context;
	_tmp127_ = entry_path;
	gtk_style_context_set_path (_tmp126_, _tmp127_);
	_tmp128_ = entry_context;
	gtk_style_context_add_class (_tmp128_, "entry");
	gtk_flow_box_set_selection_mode ((GtkFlowBox*) self, GTK_SELECTION_NONE);
	gtk_flow_box_set_column_spacing ((GtkFlowBox*) self, (guint) 6);
	gtk_flow_box_set_max_children_per_line ((GtkFlowBox*) self, (guint) 2);
	_tmp129_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp129_, "search-bar");
	_tmp130_ = search_flow_box_child;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp130_);
	_tmp131_ = replace_flow_box_child;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp131_);
	scratch_widgets_search_bar_update_search_widgets (self);
	_g_object_unref0 (entry_context);
	_gtk_widget_path_unref0 (entry_path);
	_g_object_unref0 (replace_flow_box_child);
	_g_object_unref0 (replace_grid);
	_g_object_unref0 (search_flow_box_child);
	_g_object_unref0 (search_box);
	_g_object_unref0 (search_menubutton);
	_g_object_unref0 (search_buttonbox);
	_g_object_unref0 (search_popover);
	_g_object_unref0 (search_option_box);
	_g_object_unref0 (case_sensitive_box);
	_g_object_unref0 (case_sensitive_search_label);
	_g_object_unref0 (app_instance);
	return obj;
}

static void
scratch_widgets_search_bar_class_init (ScratchWidgetsSearchBarClass * klass,
                                       gpointer klass_data)
{
	scratch_widgets_search_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchWidgetsSearchBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_widgets_search_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_widgets_search_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_widgets_search_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_widgets_search_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_SEARCH_BAR_WINDOW_PROPERTY, scratch_widgets_search_bar_properties[SCRATCH_WIDGETS_SEARCH_BAR_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", SCRATCH_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_CONTEXT_PROPERTY, scratch_widgets_search_bar_properties[SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_CONTEXT_PROPERTY] = g_param_spec_object ("search-context", "search-context", "search-context", gtk_source_search_context_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	scratch_widgets_search_bar_signals[SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_EMPTY_SIGNAL] = g_signal_new ("search-empty", SCRATCH_WIDGETS_TYPE_SEARCH_BAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
scratch_widgets_search_bar_instance_init (ScratchWidgetsSearchBar * self,
                                          gpointer klass)
{
	self->priv = scratch_widgets_search_bar_get_instance_private (self);
	self->priv->text_view = NULL;
	self->priv->text_buffer = NULL;
	self->priv->_search_context = NULL;
	self->priv->update_search_label_timeout_id = (guint) 0;
}

static void
scratch_widgets_search_bar_finalize (GObject * obj)
{
	ScratchWidgetsSearchBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_WIDGETS_TYPE_SEARCH_BAR, ScratchWidgetsSearchBar);
	_g_object_unref0 (self->priv->tool_arrow_up);
	_g_object_unref0 (self->priv->tool_arrow_down);
	_g_object_unref0 (self->priv->cycle_search_button);
	_g_object_unref0 (self->priv->case_sensitive_search_button);
	_g_object_unref0 (self->priv->regex_search_button);
	_g_object_unref0 (self->priv->whole_word_search_button);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->replace_entry);
	_g_object_unref0 (self->priv->search_occurence_count_label);
	_g_object_unref0 (self->priv->replace_tool_button);
	_g_object_unref0 (self->priv->replace_all_tool_button);
	_g_object_unref0 (self->priv->text_view);
	_g_object_unref0 (self->priv->text_buffer);
	_g_object_unref0 (self->priv->_search_context);
	G_OBJECT_CLASS (scratch_widgets_search_bar_parent_class)->finalize (obj);
}

static GType
scratch_widgets_search_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchWidgetsSearchBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_widgets_search_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchWidgetsSearchBar), 0, (GInstanceInitFunc) scratch_widgets_search_bar_instance_init, NULL };
	GType scratch_widgets_search_bar_type_id;
	scratch_widgets_search_bar_type_id = g_type_register_static (gtk_flow_box_get_type (), "ScratchWidgetsSearchBar", &g_define_type_info, 0);
	ScratchWidgetsSearchBar_private_offset = g_type_add_instance_private (scratch_widgets_search_bar_type_id, sizeof (ScratchWidgetsSearchBarPrivate));
	return scratch_widgets_search_bar_type_id;
}

GType
scratch_widgets_search_bar_get_type (void)
{
	static volatile gsize scratch_widgets_search_bar_type_id__once = 0;
	if (g_once_init_enter (&scratch_widgets_search_bar_type_id__once)) {
		GType scratch_widgets_search_bar_type_id;
		scratch_widgets_search_bar_type_id = scratch_widgets_search_bar_get_type_once ();
		g_once_init_leave (&scratch_widgets_search_bar_type_id__once, scratch_widgets_search_bar_type_id);
	}
	return scratch_widgets_search_bar_type_id__once;
}

static void
_vala_scratch_widgets_search_bar_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	ScratchWidgetsSearchBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_WIDGETS_TYPE_SEARCH_BAR, ScratchWidgetsSearchBar);
	switch (property_id) {
		case SCRATCH_WIDGETS_SEARCH_BAR_WINDOW_PROPERTY:
		g_value_set_object (value, scratch_widgets_search_bar_get_window (self));
		break;
		case SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_CONTEXT_PROPERTY:
		g_value_set_object (value, scratch_widgets_search_bar_get_search_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_widgets_search_bar_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	ScratchWidgetsSearchBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_WIDGETS_TYPE_SEARCH_BAR, ScratchWidgetsSearchBar);
	switch (property_id) {
		case SCRATCH_WIDGETS_SEARCH_BAR_WINDOW_PROPERTY:
		scratch_widgets_search_bar_set_window (self, g_value_get_object (value));
		break;
		case SCRATCH_WIDGETS_SEARCH_BAR_SEARCH_CONTEXT_PROPERTY:
		scratch_widgets_search_bar_set_search_context (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

