/* DocumentView.c generated by valac 0.56.14, the Vala compiler
 * generated from DocumentView.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/

#include "codecore.h"
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtksourceview/gtksource.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

enum  {
	SCRATCH_WIDGETS_DOCUMENT_VIEW_0_PROPERTY,
	SCRATCH_WIDGETS_DOCUMENT_VIEW_WINDOW_PROPERTY,
	SCRATCH_WIDGETS_DOCUMENT_VIEW_CURRENT_DOCUMENT_PROPERTY,
	SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_VISIBLE_PROPERTY,
	SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_WIDTH_PROPERTY,
	SCRATCH_WIDGETS_DOCUMENT_VIEW_NUM_PROPERTIES
};
static GParamSpec* scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block30Data Block30Data;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;
typedef struct _Block33Data Block33Data;
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	SCRATCH_WIDGETS_DOCUMENT_VIEW_DOCUMENT_CHANGE_SIGNAL,
	SCRATCH_WIDGETS_DOCUMENT_VIEW_REQUEST_PLACEHOLDER_SIGNAL,
	SCRATCH_WIDGETS_DOCUMENT_VIEW_NUM_SIGNALS
};
static guint scratch_widgets_document_view_signals[SCRATCH_WIDGETS_DOCUMENT_VIEW_NUM_SIGNALS] = {0};

struct _ScratchWidgetsDocumentViewPrivate {
	ScratchMainWindow* _window;
	gboolean _outline_visible;
	gint _outline_width;
	GtkCssProvider* style_provider;
};

struct _Block30Data {
	int _ref_count_;
	ScratchWidgetsDocumentView* self;
	ScratchServicesDocument* doc;
	gboolean focus;
	gint cursor_position;
	SelectionRange range;
};

struct _Block31Data {
	int _ref_count_;
	ScratchWidgetsDocumentView* self;
	ScratchServicesDocument* doc;
};

struct _Block32Data {
	int _ref_count_;
	ScratchWidgetsDocumentView* self;
	ScratchServicesDocument* doc;
	ScratchMainWindow* other_window;
};

struct _Block33Data {
	int _ref_count_;
	ScratchWidgetsDocumentView* self;
	GVariantBuilder* vb;
};

static gint ScratchWidgetsDocumentView_private_offset;
static gpointer scratch_widgets_document_view_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda112_ (ScratchWidgetsDocumentView* self,
                   ScratchServicesDocument* doc);
static void ___lambda112__gfunc (gconstpointer data,
                          gpointer self);
static void scratch_widgets_document_view_update_inline_tab_colors (ScratchWidgetsDocumentView* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gchar* scratch_widgets_document_view_unsaved_file_path_builder (ScratchWidgetsDocumentView* self,
                                                                const gchar* extension);
static gchar* scratch_widgets_document_view_unsaved_duplicated_file_path_builder (ScratchWidgetsDocumentView* self,
                                                                           const gchar* original_filename);
static void scratch_widgets_document_view_insert_document (ScratchWidgetsDocumentView* self,
                                                    ScratchServicesDocument* doc,
                                                    gint pos);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static gboolean _selection_range_equal (const SelectionRange * s1,
                                 const SelectionRange * s2);
static gboolean _______lambda25_ (Block30Data* _data30_);
static gboolean ________lambda25__gsource_func (gpointer self);
static gboolean __lambda35_ (Block30Data* _data30_);
static void __lambda40_ (Block30Data* _data30_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda40__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean ___lambda35__gsource_func (gpointer self);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda41_ (Block31Data* _data31_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda41__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void scratch_widgets_document_view_rename_tabs_with_same_title (ScratchWidgetsDocumentView* self,
                                                                ScratchServicesDocument* doc);
static void scratch_widgets_document_view_on_doc_added (ScratchWidgetsDocumentView* self,
                                                 GraniteWidgetsTab* tab);
static gboolean scratch_widgets_document_view_on_focus_in_event (ScratchWidgetsDocumentView* self);
static gboolean _scratch_widgets_document_view_on_focus_in_event_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                                     GdkEventFocus* event,
                                                                                     gpointer self);
static void scratch_widgets_document_view_on_doc_removed (ScratchWidgetsDocumentView* self,
                                                   GraniteWidgetsTab* tab);
static void scratch_widgets_document_view_on_doc_moved (ScratchWidgetsDocumentView* self,
                                                 GraniteWidgetsTab* tab,
                                                 gint x,
                                                 gint y);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static gboolean __lambda113_ (Block32Data* _data32_);
static gboolean ___lambda113__gsource_func (gpointer self);
static void scratch_widgets_document_view_on_doc_reordered (ScratchWidgetsDocumentView* self,
                                                     GraniteWidgetsTab* tab,
                                                     gint new_pos);
static void scratch_widgets_document_view_drag_received (ScratchWidgetsDocumentView* self,
                                                  GtkWidget* w,
                                                  GdkDragContext* ctx,
                                                  gint x,
                                                  gint y,
                                                  GtkSelectionData* sel,
                                                  guint info,
                                                  guint time);
static Block33Data* block33_data_ref (Block33Data* _data33_);
static void block33_data_unref (void * _userdata_);
static void ___lambda27_ (Block33Data* _data33_,
                   GraniteWidgetsTab* tab);
static void ____lambda27__gfunc (gconstpointer data,
                          gpointer self);
static void scratch_widgets_document_view_save_focused_document_uri (ScratchWidgetsDocumentView* self,
                                                              ScratchServicesDocument* current_document);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * scratch_widgets_document_view_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _scratch_widgets_document_view_on_doc_added_granite_widgets_dynamic_notebook_tab_added (GraniteWidgetsDynamicNotebook* _sender,
                                                                                             GraniteWidgetsTab* tab,
                                                                                             gpointer self);
static void _scratch_widgets_document_view_on_doc_removed_granite_widgets_dynamic_notebook_tab_removed (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                 GraniteWidgetsTab* tab,
                                                                                                 gpointer self);
static void _scratch_widgets_document_view_on_doc_reordered_granite_widgets_dynamic_notebook_tab_reordered (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                     GraniteWidgetsTab* tab,
                                                                                                     gint new_pos,
                                                                                                     gpointer self);
static void _scratch_widgets_document_view_on_doc_moved_granite_widgets_dynamic_notebook_tab_moved (GraniteWidgetsDynamicNotebook* _sender,
                                                                                             GraniteWidgetsTab* tab,
                                                                                             gint x,
                                                                                             gint y,
                                                                                             gpointer self);
static void _scratch_widgets_document_view___lambda114_ (ScratchWidgetsDocumentView* self);
static void __scratch_widgets_document_view___lambda114__granite_widgets_dynamic_notebook_new_tab_requested (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                      gpointer self);
static gboolean _scratch_widgets_document_view___lambda115_ (ScratchWidgetsDocumentView* self,
                                                      GraniteWidgetsTab* tab);
static gboolean __scratch_widgets_document_view___lambda115__granite_widgets_dynamic_notebook_close_tab_requested (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                            GraniteWidgetsTab* tab,
                                                                                                            gpointer self);
static void _scratch_widgets_document_view___lambda116_ (ScratchWidgetsDocumentView* self,
                                                  GraniteWidgetsTab* old_tab,
                                                  GraniteWidgetsTab* new_tab);
static void __scratch_widgets_document_view___lambda116__granite_widgets_dynamic_notebook_tab_switched (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                 GraniteWidgetsTab* old_tab,
                                                                                                 GraniteWidgetsTab* new_tab,
                                                                                                 gpointer self);
static void _scratch_widgets_document_view___lambda117_ (ScratchWidgetsDocumentView* self,
                                                  const gchar* label,
                                                  const gchar* restore_data,
                                                  GIcon* icon);
static void __scratch_widgets_document_view___lambda117__granite_widgets_dynamic_notebook_tab_restored (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                 const gchar* label,
                                                                                                 const gchar* data,
                                                                                                 GIcon* icon,
                                                                                                 gpointer self);
static void _scratch_widgets_document_view___lambda118_ (ScratchWidgetsDocumentView* self,
                                                  GraniteWidgetsTab* tab);
static void __scratch_widgets_document_view___lambda118__granite_widgets_dynamic_notebook_tab_duplicated (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                   GraniteWidgetsTab* duplicated_tab,
                                                                                                   gpointer self);
static void _scratch_widgets_document_view_update_inline_tab_colors_g_settings_changed (GSettings* _sender,
                                                                                 const gchar* key,
                                                                                 gpointer self);
static void _scratch_widgets_document_view_update_inline_tab_colors_g_object_notify (GObject* _sender,
                                                                              GParamSpec* pspec,
                                                                              gpointer self);
static void _scratch_widgets_document_view_update_outline_visible_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self);
static void _scratch_widgets_document_view___lambda119_ (ScratchWidgetsDocumentView* self);
static void __scratch_widgets_document_view___lambda119__g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _scratch_widgets_document_view_drag_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                                 GdkDragContext* context,
                                                                                 gint x,
                                                                                 gint y,
                                                                                 GtkSelectionData* selection_data,
                                                                                 guint info,
                                                                                 guint time_,
                                                                                 gpointer self);
static void scratch_widgets_document_view_finalize (GObject * obj);
static GType scratch_widgets_document_view_get_type_once (void);
static void _vala_scratch_widgets_document_view_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_scratch_widgets_document_view_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

VALA_EXTERN const SelectionRange SELECTION_RANGE_EMPTY;

static inline gpointer
scratch_widgets_document_view_get_instance_private (ScratchWidgetsDocumentView* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchWidgetsDocumentView_private_offset);
}

static GType
scratch_widgets_document_view_target_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SCRATCH_WIDGETS_DOCUMENT_VIEW_TARGET_TYPE_URI_LIST, "SCRATCH_WIDGETS_DOCUMENT_VIEW_TARGET_TYPE_URI_LIST", "uri-list"}, {0, NULL, NULL}};
	GType scratch_widgets_document_view_target_type_type_id;
	scratch_widgets_document_view_target_type_type_id = g_enum_register_static ("ScratchWidgetsDocumentViewTargetType", values);
	return scratch_widgets_document_view_target_type_type_id;
}

GType
scratch_widgets_document_view_target_type_get_type (void)
{
	static volatile gsize scratch_widgets_document_view_target_type_type_id__once = 0;
	if (g_once_init_enter (&scratch_widgets_document_view_target_type_type_id__once)) {
		GType scratch_widgets_document_view_target_type_type_id;
		scratch_widgets_document_view_target_type_type_id = scratch_widgets_document_view_target_type_get_type_once ();
		g_once_init_leave (&scratch_widgets_document_view_target_type_type_id__once, scratch_widgets_document_view_target_type_type_id);
	}
	return scratch_widgets_document_view_target_type_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

ScratchWidgetsDocumentView*
scratch_widgets_document_view_construct (GType object_type,
                                         ScratchMainWindow* window)
{
	ScratchWidgetsDocumentView * self = NULL;
	g_return_val_if_fail (window != NULL, NULL);
	self = (ScratchWidgetsDocumentView*) granite_widgets_dynamic_notebook_construct (object_type);
	granite_widgets_dynamic_notebook_set_allow_restoring ((GraniteWidgetsDynamicNotebook*) self, TRUE);
	granite_widgets_dynamic_notebook_set_allow_new_window ((GraniteWidgetsDynamicNotebook*) self, TRUE);
	granite_widgets_dynamic_notebook_set_allow_drag ((GraniteWidgetsDynamicNotebook*) self, TRUE);
	granite_widgets_dynamic_notebook_set_allow_duplication ((GraniteWidgetsDynamicNotebook*) self, TRUE);
	granite_widgets_dynamic_notebook_set_group_name ((GraniteWidgetsDynamicNotebook*) self, CONSTANTS_PROJECT_NAME);
	scratch_widgets_document_view_set_window (self, window);
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	return self;
}

ScratchWidgetsDocumentView*
scratch_widgets_document_view_new (ScratchMainWindow* window)
{
	return scratch_widgets_document_view_construct (SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW, window);
}

static void
__lambda112_ (ScratchWidgetsDocumentView* self,
              ScratchServicesDocument* doc)
{
	gboolean _tmp0_;
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->priv->_outline_visible;
	scratch_services_document_show_outline (doc, _tmp0_);
}

static void
___lambda112__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda112_ ((ScratchWidgetsDocumentView*) self, (ScratchServicesDocument*) data);
}

void
scratch_widgets_document_view_update_outline_visible (ScratchWidgetsDocumentView* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->docs;
	g_list_foreach (_tmp0_, ___lambda112__gfunc, self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
scratch_widgets_document_view_update_inline_tab_colors (ScratchWidgetsDocumentView* self)
{
	gchar* style_scheme = NULL;
	gchar* _tmp0_;
	GSettings* _tmp1_;
	GtkSourceStyleSchemeManager* sssm = NULL;
	GtkSourceStyleSchemeManager* _tmp9_;
	GtkSourceStyleSchemeManager* _tmp10_;
	const gchar* _tmp11_;
	GtkSourceStyleSchemeManager* _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	style_scheme = _tmp0_;
	_tmp1_ = scratch_settings;
	if (g_settings_get_boolean (_tmp1_, "follow-system-style")) {
		gboolean system_prefers_dark = FALSE;
		GraniteSettings* _tmp2_;
		GraniteSettingsColorScheme _tmp3_;
		GraniteSettingsColorScheme _tmp4_;
		_tmp2_ = granite_settings_get_default ();
		_tmp3_ = granite_settings_get_prefers_color_scheme (_tmp2_);
		_tmp4_ = _tmp3_;
		system_prefers_dark = _tmp4_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK;
		if (system_prefers_dark) {
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("elementary-dark");
			_g_free0 (style_scheme);
			style_scheme = _tmp5_;
		} else {
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("elementary-light");
			_g_free0 (style_scheme);
			style_scheme = _tmp6_;
		}
	} else {
		GSettings* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = scratch_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, "style-scheme");
		_g_free0 (style_scheme);
		style_scheme = _tmp8_;
	}
	_tmp9_ = gtk_source_style_scheme_manager_get_default ();
	_tmp10_ = _g_object_ref0 (_tmp9_);
	sssm = _tmp10_;
	_tmp11_ = style_scheme;
	_tmp12_ = sssm;
	_tmp13_ = gtk_source_style_scheme_manager_get_scheme_ids (_tmp12_);
	_tmp13__length1 = _vala_array_length (_tmp13_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	if (_vala_string_array_contains (_tmp14_, _tmp14__length1, _tmp11_)) {
		GtkSourceStyleScheme* theme = NULL;
		GtkSourceStyleSchemeManager* _tmp15_;
		const gchar* _tmp16_;
		GtkSourceStyleScheme* _tmp17_;
		GtkSourceStyleScheme* _tmp18_;
		GtkSourceStyle* text_color_data = NULL;
		GtkSourceStyleScheme* _tmp19_;
		GtkSourceStyle* _tmp20_;
		GtkSourceStyle* _tmp21_;
		gchar* color = NULL;
		gchar* _tmp22_;
		GtkSourceStyle* _tmp23_;
		gchar* define = NULL;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp15_ = sssm;
		_tmp16_ = style_scheme;
		_tmp17_ = gtk_source_style_scheme_manager_get_scheme (_tmp15_, _tmp16_);
		_tmp18_ = _g_object_ref0 (_tmp17_);
		theme = _tmp18_;
		_tmp19_ = theme;
		_tmp20_ = gtk_source_style_scheme_get_style (_tmp19_, "text");
		_tmp21_ = _g_object_ref0 (_tmp20_);
		text_color_data = _tmp21_;
		_tmp22_ = g_strdup ("#FFFFFF");
		color = _tmp22_;
		_tmp23_ = text_color_data;
		if (_tmp23_ != NULL) {
			GtkSourceStyle* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = text_color_data;
			g_object_get (_tmp24_, "background", &_tmp25_, NULL);
			_tmp26_ = _tmp25_;
			_g_free0 (color);
			color = _tmp26_;
		}
		_tmp27_ = color;
		_tmp28_ = g_strdup_printf ("@define-color tab_base_color %s;", _tmp27_);
		define = _tmp28_;
		{
			GtkCssProvider* _tmp29_;
			const gchar* _tmp30_;
			_tmp29_ = self->priv->style_provider;
			_tmp30_ = define;
			gtk_css_provider_load_from_data (_tmp29_, _tmp30_, (gssize) -1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_critical ("DocumentView.vala:159: Unable to set inline tab styling, going back to" \
" classic notebook tabs");
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (define);
			_g_free0 (color);
			_g_object_unref0 (text_color_data);
			_g_object_unref0 (theme);
			_g_object_unref0 (sssm);
			_g_free0 (style_scheme);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (define);
		_g_free0 (color);
		_g_object_unref0 (text_color_data);
		_g_object_unref0 (theme);
	}
	_g_object_unref0 (sssm);
	_g_free0 (style_scheme);
}

static gchar*
scratch_widgets_document_view_unsaved_file_path_builder (ScratchWidgetsDocumentView* self,
                                                         const gchar* extension)
{
	GDateTime* timestamp = NULL;
	GDateTime* _tmp0_;
	gchar* new_text_file = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ScratchMainWindow* _tmp5_;
	ScratchApplication* _tmp6_;
	ScratchApplication* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (extension != NULL, NULL);
	_tmp0_ = g_date_time_new_now_local ();
	timestamp = _tmp0_;
	_tmp1_ = g_date_time_format (timestamp, "%Y-%m-%d %H:%M:%S");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Text file from %s:%d"), _tmp2_, g_date_time_get_microsecond (timestamp));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	new_text_file = _tmp4_;
	_tmp5_ = self->priv->_window;
	_tmp6_ = scratch_main_window_get_app (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = scratch_application_get_data_home_folder_unsaved (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_build_filename (_tmp9_, new_text_file, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, ".", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, extension, NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = _tmp15_;
	_g_free0 (new_text_file);
	_g_date_time_unref0 (timestamp);
	return result;
}

static gchar*
scratch_widgets_document_view_unsaved_duplicated_file_path_builder (ScratchWidgetsDocumentView* self,
                                                                    const gchar* original_filename)
{
	gchar* extension = NULL;
	gchar* _tmp0_;
	gchar** parts = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original_filename != NULL, NULL);
	_tmp0_ = g_strdup ("txt");
	extension = _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (original_filename, ".", 2);
	parts = _tmp2_;
	parts_length1 = _vala_array_length (_tmp1_);
	_parts_size_ = parts_length1;
	_tmp3_ = parts;
	_tmp3__length1 = parts_length1;
	if (_tmp3__length1 > 1) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp4_ = parts;
		_tmp4__length1 = parts_length1;
		_tmp5_ = parts;
		_tmp5__length1 = parts_length1;
		_tmp6_ = _tmp4_[_tmp5__length1 - 1];
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (extension);
		extension = _tmp7_;
	}
	_tmp8_ = extension;
	_tmp9_ = scratch_widgets_document_view_unsaved_file_path_builder (self, _tmp8_);
	result = _tmp9_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (extension);
	return result;
}

static void
scratch_widgets_document_view_insert_document (ScratchWidgetsDocumentView* self,
                                               ScratchServicesDocument* doc,
                                               gint pos)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	granite_widgets_dynamic_notebook_insert_tab ((GraniteWidgetsDynamicNotebook*) self, (GraniteWidgetsTab*) doc, pos);
	_tmp0_ = scratch_saved_state;
	if (g_settings_get_boolean (_tmp0_, "outline-visible")) {
		g_debug ("DocumentView.vala:187: setting outline visible");
		scratch_services_document_show_outline (doc, TRUE);
	}
}

void
scratch_widgets_document_view_new_document (ScratchWidgetsDocumentView* self)
{
	GFile* file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = scratch_widgets_document_view_unsaved_file_path_builder (self, "txt");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	file = _tmp3_;
	{
		GFileOutputStream* _tmp4_;
		GFileOutputStream* _tmp5_;
		ScratchServicesDocument* doc = NULL;
		ScratchMainWindow* _tmp6_;
		GSimpleActionGroup* _tmp7_;
		GSimpleActionGroup* _tmp8_;
		ScratchServicesDocument* _tmp9_;
		ScratchServicesDocument* _tmp10_;
		_tmp4_ = g_file_create (file, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = self->priv->_window;
		_tmp7_ = scratch_main_window_get_actions (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = scratch_services_document_new (_tmp8_, file);
		g_object_ref_sink (_tmp9_);
		doc = _tmp9_;
		_tmp10_ = doc;
		scratch_widgets_document_view_open_document (self, _tmp10_, TRUE, 0, &SELECTION_RANGE_EMPTY);
		_g_object_unref0 (doc);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_critical ("DocumentView.vala:201: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

void
scratch_widgets_document_view_new_document_from_clipboard (ScratchWidgetsDocumentView* self,
                                                           const gchar* clipboard)
{
	GFile* file = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	_tmp0_ = scratch_widgets_document_view_unsaved_file_path_builder (self, "txt");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	file = _tmp3_;
	{
		GFile* _tmp4_;
		GFileOutputStream* _tmp5_;
		GFileOutputStream* _tmp6_;
		GFile* _tmp7_;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_ = 0;
		guint8* _tmp10_;
		gint _tmp10__length1;
		ScratchServicesDocument* doc = NULL;
		ScratchMainWindow* _tmp11_;
		GSimpleActionGroup* _tmp12_;
		GSimpleActionGroup* _tmp13_;
		GFile* _tmp14_;
		ScratchServicesDocument* _tmp15_;
		ScratchServicesDocument* _tmp16_;
		_tmp4_ = file;
		_tmp5_ = g_file_create (_tmp4_, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = file;
		_tmp8_ = string_get_data (clipboard, &_tmp9_);
		_tmp8__length1 = _tmp9_;
		_tmp10_ = _tmp8_;
		_tmp10__length1 = _tmp8__length1;
		g_file_replace_contents (_tmp7_, _tmp10_, (gsize) _tmp10__length1, NULL, FALSE, 0, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = self->priv->_window;
		_tmp12_ = scratch_main_window_get_actions (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = file;
		_tmp15_ = scratch_services_document_new (_tmp13_, _tmp14_);
		g_object_ref_sink (_tmp15_);
		doc = _tmp15_;
		_tmp16_ = doc;
		scratch_widgets_document_view_open_document (self, _tmp16_, TRUE, 0, &SELECTION_RANGE_EMPTY);
		_g_object_unref0 (doc);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_critical ("DocumentView.vala:218: Cannot insert clipboard: %s", clipboard);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		ScratchWidgetsDocumentView* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->doc);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static gboolean
_selection_range_equal (const SelectionRange * s1,
                        const SelectionRange * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->start_line != s2->start_line) {
		return FALSE;
	}
	if (s1->start_column != s2->start_column) {
		return FALSE;
	}
	if (s1->end_line != s2->end_line) {
		return FALSE;
	}
	if (s1->end_column != s2->end_column) {
		return FALSE;
	}
	return TRUE;
}

static gboolean
_______lambda25_ (Block30Data* _data30_)
{
	ScratchWidgetsDocumentView* self;
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	ScratchWidgetsSourceView* _tmp2_;
	SelectionRange _tmp3_;
	gboolean result;
	self = _data30_->self;
	_tmp0_ = scratch_widgets_document_view_get_current_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->source_view;
	_tmp3_ = _data30_->range;
	scratch_widgets_source_view_select_range (_tmp2_, &_tmp3_);
	scratch_widgets_document_view_save_opened_files (self);
	result = FALSE;
	return result;
}

static gboolean
________lambda25__gsource_func (gpointer self)
{
	gboolean result;
	result = _______lambda25_ (self);
	return result;
}

static void
__lambda40_ (Block30Data* _data30_,
             GObject* obj,
             GAsyncResult* res)
{
	ScratchWidgetsDocumentView* self;
	gboolean _tmp0_ = FALSE;
	SelectionRange _tmp3_;
	self = _data30_->self;
	g_return_if_fail (res != NULL);
	scratch_services_document_open_finish (_data30_->doc, res);
	if (_data30_->focus) {
		ScratchServicesDocument* _tmp1_;
		ScratchServicesDocument* _tmp2_;
		_tmp1_ = scratch_widgets_document_view_get_current_document (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _data30_->doc == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		scratch_services_document_focus (_data30_->doc);
	}
	_tmp3_ = _data30_->range;
	if (_selection_range_equal (&_tmp3_, &SELECTION_RANGE_EMPTY) != TRUE) {
		ScratchWidgetsSourceView* _tmp4_;
		SelectionRange _tmp5_;
		_tmp4_ = _data30_->doc->source_view;
		_tmp5_ = _data30_->range;
		scratch_widgets_source_view_select_range (_tmp4_, &_tmp5_);
	} else {
		if (_data30_->cursor_position > 0) {
			ScratchWidgetsSourceView* _tmp6_;
			_tmp6_ = _data30_->doc->source_view;
			scratch_widgets_source_view_set_cursor_position (_tmp6_, _data30_->cursor_position);
		}
	}
	scratch_widgets_document_view_save_opened_files (self);
}

static void
___lambda40__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda40_ (self, source_object, res);
	block30_data_unref (self);
}

static gboolean
__lambda35_ (Block30Data* _data30_)
{
	ScratchWidgetsDocumentView* self;
	gboolean result;
	self = _data30_->self;
	scratch_services_document_open (_data30_->doc, FALSE, ___lambda40__gasync_ready_callback, block30_data_ref (_data30_));
	result = FALSE;
	return result;
}

static gboolean
___lambda35__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda35_ (self);
	return result;
}

void
scratch_widgets_document_view_open_document (ScratchWidgetsDocumentView* self,
                                             ScratchServicesDocument* doc,
                                             gboolean focus,
                                             gint cursor_position,
                                             SelectionRange* range)
{
	Block30Data* _data30_;
	ScratchServicesDocument* _tmp0_;
	SelectionRange _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	g_return_if_fail (range != NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	_data30_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (doc);
	_g_object_unref0 (_data30_->doc);
	_data30_->doc = _tmp0_;
	_data30_->focus = focus;
	_data30_->cursor_position = cursor_position;
	_tmp1_ = *range;
	_data30_->range = _tmp1_;
	{
		gint n = 0;
		n = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GList* _tmp4_;
				ScratchServicesDocument* nth_doc = NULL;
				GList* _tmp5_;
				gconstpointer _tmp6_;
				ScratchServicesDocument* _tmp7_;
				ScratchServicesDocument* _tmp8_;
				gboolean _tmp9_ = FALSE;
				ScratchServicesDocument* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = n;
					n = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->docs;
				if (!(((guint) n) <= g_list_length (_tmp4_))) {
					break;
				}
				_tmp5_ = self->docs;
				_tmp6_ = g_list_nth_data (_tmp5_, (guint) n);
				_tmp7_ = _g_object_ref0 ((ScratchServicesDocument*) _tmp6_);
				nth_doc = _tmp7_;
				_tmp8_ = nth_doc;
				if (_tmp8_ == NULL) {
					_g_object_unref0 (nth_doc);
					continue;
				}
				_tmp10_ = nth_doc;
				_tmp11_ = scratch_services_document_get_file (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ != NULL) {
					ScratchServicesDocument* _tmp13_;
					GFile* _tmp14_;
					GFile* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					GFile* _tmp18_;
					GFile* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp13_ = nth_doc;
					_tmp14_ = scratch_services_document_get_file (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = g_file_get_uri (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp18_ = scratch_services_document_get_file (_data30_->doc);
					_tmp19_ = _tmp18_;
					_tmp20_ = g_file_get_uri (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp9_ = g_strcmp0 (_tmp17_, _tmp21_) == 0;
					_g_free0 (_tmp21_);
					_g_free0 (_tmp17_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					SelectionRange _tmp23_;
					if (_data30_->focus) {
						ScratchServicesDocument* _tmp22_;
						_tmp22_ = nth_doc;
						scratch_widgets_document_view_set_current_document (self, _tmp22_);
					}
					g_debug ("DocumentView.vala:234: This Document was already opened! Not opening a" \
" duplicate!");
					_tmp23_ = _data30_->range;
					if (_selection_range_equal (&_tmp23_, &SELECTION_RANGE_EMPTY) != TRUE) {
						g_idle_add_full (G_PRIORITY_LOW, ________lambda25__gsource_func, block30_data_ref (_data30_), block30_data_unref);
					}
					_g_object_unref0 (nth_doc);
					block30_data_unref (_data30_);
					_data30_ = NULL;
					return;
				}
				_g_object_unref0 (nth_doc);
			}
		}
	}
	scratch_widgets_document_view_insert_document (self, _data30_->doc, -1);
	if (_data30_->focus) {
		scratch_widgets_document_view_set_current_document (self, _data30_->doc);
	}
	g_idle_add_full (G_PRIORITY_LOW, ___lambda35__gsource_func, block30_data_ref (_data30_), block30_data_unref);
	block30_data_unref (_data30_);
	_data30_ = NULL;
}

void
scratch_widgets_document_view_duplicate_document (ScratchWidgetsDocumentView* self,
                                                  ScratchServicesDocument* original)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (original != NULL);
	{
		GFile* file = NULL;
		GFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFileOutputStream* _tmp8_;
		GFileOutputStream* _tmp9_;
		ScratchServicesDocument* doc = NULL;
		ScratchMainWindow* _tmp10_;
		GSimpleActionGroup* _tmp11_;
		GSimpleActionGroup* _tmp12_;
		ScratchServicesDocument* _tmp13_;
		ScratchServicesDocument* _tmp14_;
		ScratchWidgetsSourceView* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		ScratchServicesDocument* _tmp18_;
		ScratchWidgetsSourceView* _tmp19_;
		ScratchWidgetsSourceView* _tmp20_;
		GtkSourceLanguage* _tmp21_;
		GtkSourceLanguage* _tmp22_;
		GSettings* _tmp23_;
		ScratchServicesDocument* _tmp25_;
		ScratchServicesDocument* _tmp26_;
		ScratchServicesDocument* _tmp27_;
		_tmp0_ = scratch_services_document_get_file (original);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_get_basename (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = scratch_widgets_document_view_unsaved_duplicated_file_path_builder (self, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		file = _tmp7_;
		_tmp8_ = g_file_create (file, G_FILE_CREATE_PRIVATE, NULL, &_inner_error0_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp10_ = self->priv->_window;
		_tmp11_ = scratch_main_window_get_actions (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = scratch_services_document_new (_tmp12_, file);
		g_object_ref_sink (_tmp13_);
		doc = _tmp13_;
		_tmp14_ = doc;
		_tmp15_ = _tmp14_->source_view;
		_tmp16_ = scratch_services_document_get_text (original);
		_tmp17_ = _tmp16_;
		scratch_widgets_source_view_set_text (_tmp15_, _tmp17_, TRUE);
		_g_free0 (_tmp17_);
		_tmp18_ = doc;
		_tmp19_ = _tmp18_->source_view;
		_tmp20_ = original->source_view;
		_tmp21_ = scratch_widgets_source_view_get_language (_tmp20_);
		_tmp22_ = _tmp21_;
		scratch_widgets_source_view_set_language (_tmp19_, _tmp22_);
		_tmp23_ = scratch_settings;
		if (g_settings_get_boolean (_tmp23_, "autosave")) {
			ScratchServicesDocument* _tmp24_;
			_tmp24_ = doc;
			scratch_services_document_save_with_hold (_tmp24_, TRUE, FALSE, NULL, NULL);
		}
		_tmp25_ = doc;
		scratch_widgets_document_view_insert_document (self, _tmp25_, -1);
		_tmp26_ = doc;
		scratch_widgets_document_view_set_current_document (self, _tmp26_);
		_tmp27_ = doc;
		scratch_services_document_focus (_tmp27_);
		_g_object_unref0 (doc);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = scratch_services_document_get_basename (original);
		_tmp29_ = _tmp28_;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->message;
		g_warning ("DocumentView.vala:290: Cannot copy \"%s\": %s", _tmp29_, _tmp31_);
		_g_free0 (_tmp29_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
scratch_widgets_document_view_next_document (ScratchWidgetsDocumentView* self)
{
	guint current_index = 0U;
	GList* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	ScratchServicesDocument* _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->docs;
	_tmp1_ = scratch_widgets_document_view_get_current_document (self);
	_tmp2_ = _tmp1_;
	current_index = (guint) (g_list_index (_tmp0_, _tmp2_) + 1);
	_tmp3_ = self->docs;
	if (current_index < g_list_length (_tmp3_)) {
		ScratchServicesDocument* next_doc = NULL;
		GList* _tmp4_;
		guint _tmp5_;
		gconstpointer _tmp6_;
		ScratchServicesDocument* _tmp7_;
		ScratchServicesDocument* _tmp8_;
		ScratchServicesDocument* _tmp9_;
		_tmp4_ = self->docs;
		_tmp5_ = current_index;
		current_index = _tmp5_ + 1;
		_tmp6_ = g_list_nth_data (_tmp4_, _tmp5_);
		_tmp7_ = _g_object_ref0 ((ScratchServicesDocument*) _tmp6_);
		next_doc = _tmp7_;
		_tmp8_ = next_doc;
		scratch_widgets_document_view_set_current_document (self, _tmp8_);
		_tmp9_ = next_doc;
		scratch_services_document_focus (_tmp9_);
		_g_object_unref0 (next_doc);
	} else {
		GList* _tmp10_;
		_tmp10_ = self->docs;
		if (g_list_length (_tmp10_) > ((guint) 0)) {
			ScratchServicesDocument* next_doc = NULL;
			GList* _tmp11_;
			gconstpointer _tmp12_;
			ScratchServicesDocument* _tmp13_;
			ScratchServicesDocument* _tmp14_;
			ScratchServicesDocument* _tmp15_;
			_tmp11_ = self->docs;
			_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
			_tmp13_ = _g_object_ref0 ((ScratchServicesDocument*) _tmp12_);
			next_doc = _tmp13_;
			_tmp14_ = next_doc;
			scratch_widgets_document_view_set_current_document (self, _tmp14_);
			_tmp15_ = next_doc;
			scratch_services_document_focus (_tmp15_);
			_g_object_unref0 (next_doc);
		}
	}
}

void
scratch_widgets_document_view_previous_document (ScratchWidgetsDocumentView* self)
{
	guint current_index = 0U;
	GList* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	ScratchServicesDocument* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->docs;
	_tmp1_ = scratch_widgets_document_view_get_current_document (self);
	_tmp2_ = _tmp1_;
	current_index = (guint) g_list_index (_tmp0_, _tmp2_);
	if (current_index > ((guint) 0)) {
		ScratchServicesDocument* previous_doc = NULL;
		GList* _tmp3_;
		guint _tmp4_;
		gconstpointer _tmp5_;
		ScratchServicesDocument* _tmp6_;
		ScratchServicesDocument* _tmp7_;
		ScratchServicesDocument* _tmp8_;
		_tmp3_ = self->docs;
		current_index = current_index - 1;
		_tmp4_ = current_index;
		_tmp5_ = g_list_nth_data (_tmp3_, _tmp4_);
		_tmp6_ = _g_object_ref0 ((ScratchServicesDocument*) _tmp5_);
		previous_doc = _tmp6_;
		_tmp7_ = previous_doc;
		scratch_widgets_document_view_set_current_document (self, _tmp7_);
		_tmp8_ = previous_doc;
		scratch_services_document_focus (_tmp8_);
		_g_object_unref0 (previous_doc);
	} else {
		GList* _tmp9_;
		_tmp9_ = self->docs;
		if (g_list_length (_tmp9_) > ((guint) 0)) {
			ScratchServicesDocument* previous_doc = NULL;
			GList* _tmp10_;
			GList* _tmp11_;
			gconstpointer _tmp12_;
			ScratchServicesDocument* _tmp13_;
			ScratchServicesDocument* _tmp14_;
			ScratchServicesDocument* _tmp15_;
			_tmp10_ = self->docs;
			_tmp11_ = self->docs;
			_tmp12_ = g_list_nth_data (_tmp10_, g_list_length (_tmp11_) - 1);
			_tmp13_ = _g_object_ref0 ((ScratchServicesDocument*) _tmp12_);
			previous_doc = _tmp13_;
			_tmp14_ = previous_doc;
			scratch_widgets_document_view_set_current_document (self, _tmp14_);
			_tmp15_ = previous_doc;
			scratch_services_document_focus (_tmp15_);
			_g_object_unref0 (previous_doc);
		}
	}
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		ScratchWidgetsDocumentView* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->doc);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
__lambda41_ (Block31Data* _data31_,
             GObject* obj,
             GAsyncResult* res)
{
	ScratchWidgetsDocumentView* self;
	self = _data31_->self;
	g_return_if_fail (res != NULL);
	if (scratch_services_document_do_close_finish (_data31_->doc, res)) {
		granite_widgets_dynamic_notebook_remove_tab ((GraniteWidgetsDynamicNotebook*) self, (GraniteWidgetsTab*) _data31_->doc);
	}
}

static void
___lambda41__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda41_ (self, source_object, res);
	block31_data_unref (self);
}

void
scratch_widgets_document_view_close_document (ScratchWidgetsDocumentView* self,
                                              ScratchServicesDocument* doc)
{
	Block31Data* _data31_;
	ScratchServicesDocument* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (doc);
	_g_object_unref0 (_data31_->doc);
	_data31_->doc = _tmp0_;
	scratch_services_document_do_close (_data31_->doc, FALSE, ___lambda41__gasync_ready_callback, block31_data_ref (_data31_));
	block31_data_unref (_data31_);
	_data31_ = NULL;
}

void
scratch_widgets_document_view_request_placeholder_if_empty (ScratchWidgetsDocumentView* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->docs;
	if (g_list_length (_tmp0_) == ((guint) 0)) {
		g_signal_emit (self, scratch_widgets_document_view_signals[SCRATCH_WIDGETS_DOCUMENT_VIEW_REQUEST_PLACEHOLDER_SIGNAL], 0);
	}
}

void
scratch_widgets_document_view_focus (ScratchWidgetsDocumentView* self)
{
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = scratch_widgets_document_view_get_current_document (self);
	_tmp1_ = _tmp0_;
	scratch_services_document_focus (_tmp1_);
}

static void
scratch_widgets_document_view_rename_tabs_with_same_title (ScratchWidgetsDocumentView* self,
                                                           ScratchServicesDocument* doc)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gchar* doc_tab_name = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	GList* _tmp5_;
	const gchar* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = scratch_services_document_get_is_file_temporary (doc);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = scratch_services_document_get_file (doc);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_basename (_tmp3_);
	doc_tab_name = _tmp4_;
	_tmp5_ = self->docs;
	{
		GList* d_collection = NULL;
		GList* d_it = NULL;
		d_collection = _tmp5_;
		for (d_it = d_collection; d_it != NULL; d_it = d_it->next) {
			ScratchServicesDocument* _tmp6_;
			ScratchServicesDocument* d = NULL;
			_tmp6_ = _g_object_ref0 ((ScratchServicesDocument*) d_it->data);
			d = _tmp6_;
			{
				ScratchServicesDocument* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gchar* new_tabname_doc = NULL;
				gchar* new_tabname_d = NULL;
				ScratchServicesDocument* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gboolean _tmp17_;
				_tmp7_ = d;
				_tmp8_ = scratch_services_document_get_is_file_temporary (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_) {
					_g_object_unref0 (d);
					continue;
				}
				_tmp10_ = d;
				_tmp11_ = scratch_services_document_get_file (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = scratch_services_document_get_file (doc);
				_tmp14_ = _tmp13_;
				_tmp17_ = scratch_utils_find_unique_path (_tmp12_, _tmp14_, &_tmp15_, &_tmp16_);
				_g_free0 (new_tabname_d);
				new_tabname_d = _tmp15_;
				_g_free0 (new_tabname_doc);
				new_tabname_doc = _tmp16_;
				if (_tmp17_) {
					ScratchServicesDocument* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					const gchar* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					const gchar* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					_tmp18_ = d;
					_tmp19_ = granite_widgets_tab_get_label ((GraniteWidgetsTab*) _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = strlen (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = new_tabname_d;
					_tmp24_ = strlen (_tmp23_);
					_tmp25_ = _tmp24_;
					if (_tmp22_ < _tmp25_) {
						ScratchServicesDocument* _tmp26_;
						const gchar* _tmp27_;
						_tmp26_ = d;
						_tmp27_ = new_tabname_d;
						scratch_services_document_set_tab_name (_tmp26_, _tmp27_);
					}
					_tmp28_ = doc_tab_name;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = new_tabname_doc;
					_tmp32_ = strlen (_tmp31_);
					_tmp33_ = _tmp32_;
					if (_tmp30_ < _tmp33_) {
						const gchar* _tmp34_;
						gchar* _tmp35_;
						_tmp34_ = new_tabname_doc;
						_tmp35_ = g_strdup (_tmp34_);
						_g_free0 (doc_tab_name);
						doc_tab_name = _tmp35_;
					}
				}
				_g_free0 (new_tabname_d);
				_g_free0 (new_tabname_doc);
				_g_object_unref0 (d);
			}
		}
	}
	_tmp36_ = doc_tab_name;
	scratch_services_document_set_tab_name (doc, _tmp36_);
	_g_free0 (doc_tab_name);
}

static gboolean
_scratch_widgets_document_view_on_focus_in_event_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                            GdkEventFocus* event,
                                                                            gpointer self)
{
	gboolean result;
	result = scratch_widgets_document_view_on_focus_in_event ((ScratchWidgetsDocumentView*) self);
	return result;
}

static void
scratch_widgets_document_view_on_doc_added (ScratchWidgetsDocumentView* self,
                                            GraniteWidgetsTab* tab)
{
	ScratchServicesDocument* doc = NULL;
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	ScratchMainWindow* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GSimpleActionGroup* _tmp4_;
	ScratchServicesDocument* _tmp5_;
	ScratchServicesDocument* _tmp6_;
	ScratchServicesDocumentManager* _tmp7_;
	ScratchServicesDocumentManager* _tmp8_;
	ScratchServicesDocument* _tmp9_;
	ScratchServicesDocument* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	ScratchServicesDocument* _tmp14_;
	ScratchWidgetsSourceView* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = _g_object_ref0 (SCRATCH_SERVICES_IS_DOCUMENT (tab) ? ((ScratchServicesDocument*) tab) : NULL);
	doc = _tmp0_;
	_tmp1_ = doc;
	_tmp2_ = self->priv->_window;
	_tmp3_ = scratch_main_window_get_actions (_tmp2_);
	_tmp4_ = _tmp3_;
	scratch_services_document_set_actions (_tmp1_, _tmp4_);
	_tmp5_ = doc;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	self->docs = g_list_append (self->docs, _tmp6_);
	_tmp7_ = scratch_services_document_manager_get_instance ();
	_tmp8_ = _tmp7_;
	_tmp9_ = doc;
	scratch_services_document_manager_add_open_document (_tmp8_, _tmp9_);
	_g_object_unref0 (_tmp8_);
	_tmp10_ = doc;
	_tmp11_ = scratch_services_document_get_is_file_temporary (_tmp10_);
	_tmp12_ = _tmp11_;
	if (!_tmp12_) {
		ScratchServicesDocument* _tmp13_;
		_tmp13_ = doc;
		scratch_widgets_document_view_rename_tabs_with_same_title (self, _tmp13_);
	}
	_tmp14_ = doc;
	_tmp15_ = _tmp14_->source_view;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "focus-in-event", (GCallback) _scratch_widgets_document_view_on_focus_in_event_gtk_widget_focus_in_event, self, G_CONNECT_AFTER);
	_g_object_unref0 (doc);
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
scratch_widgets_document_view_on_doc_removed (ScratchWidgetsDocumentView* self,
                                              GraniteWidgetsTab* tab)
{
	ScratchServicesDocument* doc = NULL;
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	ScratchServicesDocumentManager* _tmp2_;
	ScratchServicesDocumentManager* _tmp3_;
	ScratchServicesDocument* _tmp4_;
	ScratchServicesDocument* _tmp5_;
	ScratchWidgetsSourceView* _tmp6_;
	guint _tmp7_;
	GList* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = _g_object_ref0 (SCRATCH_SERVICES_IS_DOCUMENT (tab) ? ((ScratchServicesDocument*) tab) : NULL);
	doc = _tmp0_;
	_tmp1_ = doc;
	self->docs = vala_g_list_remove_full (self->docs, _tmp1_, _g_object_unref0_);
	_tmp2_ = scratch_services_document_manager_get_instance ();
	_tmp3_ = _tmp2_;
	_tmp4_ = doc;
	scratch_services_document_manager_remove_open_document (_tmp3_, _tmp4_);
	_g_object_unref0 (_tmp3_);
	_tmp5_ = doc;
	_tmp6_ = _tmp5_->source_view;
	g_signal_parse_name ("focus-in-event", gtk_widget_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _scratch_widgets_document_view_on_focus_in_event_gtk_widget_focus_in_event, self);
	scratch_widgets_document_view_request_placeholder_if_empty (self);
	_tmp8_ = self->docs;
	if (g_list_length (_tmp8_) > ((guint) 0)) {
		ScratchServicesDocument* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = doc;
		_tmp10_ = scratch_services_document_get_is_file_temporary (_tmp9_);
		_tmp11_ = _tmp10_;
		if (!_tmp11_) {
			GList* _tmp12_;
			_tmp12_ = self->docs;
			{
				GList* d_collection = NULL;
				GList* d_it = NULL;
				d_collection = _tmp12_;
				for (d_it = d_collection; d_it != NULL; d_it = d_it->next) {
					ScratchServicesDocument* _tmp13_;
					ScratchServicesDocument* d = NULL;
					_tmp13_ = _g_object_ref0 ((ScratchServicesDocument*) d_it->data);
					d = _tmp13_;
					{
						ScratchServicesDocument* _tmp14_;
						_tmp14_ = d;
						scratch_widgets_document_view_rename_tabs_with_same_title (self, _tmp14_);
						_g_object_unref0 (d);
					}
				}
			}
		}
	}
	if (!self->is_closing) {
		scratch_widgets_document_view_save_opened_files (self);
	}
	_g_object_unref0 (doc);
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		ScratchWidgetsDocumentView* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->other_window);
		_g_object_unref0 (_data32_->doc);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static gboolean
__lambda113_ (Block32Data* _data32_)
{
	ScratchWidgetsDocumentView* self;
	ScratchWidgetsDocumentView* _tmp0_;
	gboolean result;
	self = _data32_->self;
	granite_widgets_dynamic_notebook_remove_tab ((GraniteWidgetsDynamicNotebook*) self, (GraniteWidgetsTab*) _data32_->doc);
	_tmp0_ = _data32_->other_window->document_view;
	scratch_widgets_document_view_insert_document (_tmp0_, _data32_->doc, -1);
	result = FALSE;
	return result;
}

static gboolean
___lambda113__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda113_ (self);
	return result;
}

static void
scratch_widgets_document_view_on_doc_moved (ScratchWidgetsDocumentView* self,
                                            GraniteWidgetsTab* tab,
                                            gint x,
                                            gint y)
{
	Block32Data* _data32_;
	ScratchServicesDocument* _tmp0_;
	ScratchMainWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (SCRATCH_SERVICES_IS_DOCUMENT (tab) ? ((ScratchServicesDocument*) tab) : NULL);
	_data32_->doc = _tmp0_;
	_tmp1_ = scratch_main_window_new (FALSE);
	g_object_ref_sink (_tmp1_);
	_data32_->other_window = _tmp1_;
	gtk_window_move ((GtkWindow*) _data32_->other_window, x, y);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda113__gsource_func, block32_data_ref (_data32_), block32_data_unref);
	block32_data_unref (_data32_);
	_data32_ = NULL;
}

static void
scratch_widgets_document_view_on_doc_reordered (ScratchWidgetsDocumentView* self,
                                                GraniteWidgetsTab* tab,
                                                gint new_pos)
{
	ScratchServicesDocument* doc = NULL;
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab != NULL);
	_tmp0_ = _g_object_ref0 (SCRATCH_SERVICES_IS_DOCUMENT (tab) ? ((ScratchServicesDocument*) tab) : NULL);
	doc = _tmp0_;
	self->docs = vala_g_list_remove_full (self->docs, doc, _g_object_unref0_);
	_tmp1_ = _g_object_ref0 (doc);
	self->docs = g_list_insert (self->docs, _tmp1_, new_pos);
	scratch_services_document_focus (doc);
	scratch_widgets_document_view_save_opened_files (self);
	_g_object_unref0 (doc);
}

static gboolean
scratch_widgets_document_view_on_focus_in_event (ScratchWidgetsDocumentView* self)
{
	ScratchServicesDocument* doc = NULL;
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	ScratchServicesDocument* _tmp2_;
	ScratchServicesDocument* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = scratch_widgets_document_view_get_current_document (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doc = _tmp2_;
	_tmp3_ = doc;
	if (_tmp3_ == NULL) {
		g_warning ("DocumentView.vala:432: Focus event callback cannot get current documen" \
"t");
	} else {
		ScratchServicesDocument* _tmp4_;
		_tmp4_ = doc;
		g_signal_emit (self, scratch_widgets_document_view_signals[SCRATCH_WIDGETS_DOCUMENT_VIEW_DOCUMENT_CHANGE_SIGNAL], 0, _tmp4_, self);
	}
	result = FALSE;
	_g_object_unref0 (doc);
	return result;
}

static void
scratch_widgets_document_view_drag_received (ScratchWidgetsDocumentView* self,
                                             GtkWidget* w,
                                             GdkDragContext* ctx,
                                             gint x,
                                             gint y,
                                             GtkSelectionData* sel,
                                             guint info,
                                             guint time)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel != NULL);
	if (info == ((guint) SCRATCH_WIDGETS_DOCUMENT_VIEW_TARGET_TYPE_URI_LIST)) {
		gchar** uris = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint uris_length1;
		gint _uris_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (sel);
		uris = _tmp1_;
		uris_length1 = _vala_array_length (_tmp0_);
		_uris_size_ = uris_length1;
		_tmp2_ = uris;
		_tmp2__length1 = uris_length1;
		{
			gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it = 0;
			filename_collection = _tmp2_;
			filename_collection_length1 = _tmp2__length1;
			for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
				gchar* _tmp3_;
				gchar* filename = NULL;
				_tmp3_ = g_strdup (filename_collection[filename_it]);
				filename = _tmp3_;
				{
					GFile* file = NULL;
					const gchar* _tmp4_;
					GFile* _tmp5_;
					ScratchServicesDocument* doc = NULL;
					ScratchMainWindow* _tmp6_;
					GSimpleActionGroup* _tmp7_;
					GSimpleActionGroup* _tmp8_;
					GFile* _tmp9_;
					ScratchServicesDocument* _tmp10_;
					ScratchServicesDocument* _tmp11_;
					_tmp4_ = filename;
					_tmp5_ = g_file_new_for_uri (_tmp4_);
					file = _tmp5_;
					_tmp6_ = self->priv->_window;
					_tmp7_ = scratch_main_window_get_actions (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = file;
					_tmp10_ = scratch_services_document_new (_tmp8_, _tmp9_);
					g_object_ref_sink (_tmp10_);
					doc = _tmp10_;
					_tmp11_ = doc;
					scratch_widgets_document_view_open_document (self, _tmp11_, TRUE, 0, &SELECTION_RANGE_EMPTY);
					_g_object_unref0 (doc);
					_g_object_unref0 (file);
					_g_free0 (filename);
				}
			}
		}
		gtk_drag_finish (ctx, TRUE, FALSE, (guint32) time);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	}
}

static Block33Data*
block33_data_ref (Block33Data* _data33_)
{
	g_atomic_int_inc (&_data33_->_ref_count_);
	return _data33_;
}

static void
block33_data_unref (void * _userdata_)
{
	Block33Data* _data33_;
	_data33_ = (Block33Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data33_->_ref_count_)) {
		ScratchWidgetsDocumentView* self;
		self = _data33_->self;
		_g_variant_builder_unref0 (_data33_->vb);
		_g_object_unref0 (self);
		g_slice_free (Block33Data, _data33_);
	}
}

static void
___lambda27_ (Block33Data* _data33_,
              GraniteWidgetsTab* tab)
{
	ScratchWidgetsDocumentView* self;
	ScratchServicesDocument* doc = NULL;
	ScratchServicesDocument* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ScratchServicesDocument* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	self = _data33_->self;
	g_return_if_fail (tab != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (tab, SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocument));
	doc = _tmp0_;
	_tmp2_ = doc;
	_tmp3_ = scratch_services_document_get_file (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ScratchServicesDocument* _tmp5_;
		_tmp5_ = doc;
		_tmp1_ = scratch_services_document_exists (_tmp5_, NULL);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GVariantBuilder* _tmp6_;
		ScratchServicesDocument* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		ScratchServicesDocument* _tmp12_;
		ScratchWidgetsSourceView* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		_tmp6_ = _data33_->vb;
		_tmp7_ = doc;
		_tmp8_ = scratch_services_document_get_file (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = doc;
		_tmp13_ = _tmp12_->source_view;
		_tmp14_ = scratch_widgets_source_view_get_cursor_position (_tmp13_);
		_tmp15_ = _tmp14_;
		g_variant_builder_add (_tmp6_, "(si)", _tmp11_, _tmp15_, NULL);
		_g_free0 (_tmp11_);
	}
	_g_object_unref0 (doc);
}

static void
____lambda27__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda27_ (self, (GraniteWidgetsTab*) data);
}

void
scratch_widgets_document_view_save_opened_files (ScratchWidgetsDocumentView* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = scratch_privacy_settings;
	if (g_settings_get_boolean (_tmp0_, "remember-recent-files")) {
		Block33Data* _data33_;
		GVariantType* _tmp1_;
		GVariantType* _tmp2_;
		GVariantBuilder* _tmp3_;
		GVariantBuilder* _tmp4_;
		GList* _tmp5_;
		GList* _tmp6_;
		GSettings* _tmp7_;
		GVariantBuilder* _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		_data33_ = g_slice_new0 (Block33Data);
		_data33_->_ref_count_ = 1;
		_data33_->self = g_object_ref (self);
		_tmp1_ = g_variant_type_new ("a(si)");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_variant_builder_new (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_variant_type_free0 (_tmp2_);
		_data33_->vb = _tmp4_;
		_tmp5_ = granite_widgets_dynamic_notebook_get_tabs ((GraniteWidgetsDynamicNotebook*) self);
		_tmp6_ = _tmp5_;
		g_list_foreach (_tmp6_, ____lambda27__gfunc, _data33_);
		_tmp7_ = scratch_settings;
		_tmp8_ = _data33_->vb;
		_tmp9_ = g_variant_builder_end (_tmp8_);
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		g_settings_set_value (_tmp7_, "opened-files", _tmp10_);
		_g_variant_unref0 (_tmp10_);
		block33_data_unref (_data33_);
		_data33_ = NULL;
	}
}

static void
scratch_widgets_document_view_save_focused_document_uri (ScratchWidgetsDocumentView* self,
                                                         ScratchServicesDocument* current_document)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = scratch_privacy_settings;
	if (g_settings_get_boolean (_tmp0_, "remember-recent-files")) {
		gchar* file_uri = NULL;
		gchar* _tmp1_;
		GSettings* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = g_strdup ("");
		file_uri = _tmp1_;
		if (current_document != NULL) {
			GFile* _tmp2_;
			GFile* _tmp3_;
			gchar* _tmp4_;
			_tmp2_ = scratch_services_document_get_file (current_document);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_file_get_uri (_tmp3_);
			_g_free0 (file_uri);
			file_uri = _tmp4_;
		}
		_tmp5_ = scratch_settings;
		_tmp6_ = file_uri;
		g_settings_set_string (_tmp5_, "focused-document", _tmp6_);
		_g_free0 (file_uri);
	}
}

ScratchMainWindow*
scratch_widgets_document_view_get_window (ScratchWidgetsDocumentView* self)
{
	ScratchMainWindow* result;
	ScratchMainWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

void
scratch_widgets_document_view_set_window (ScratchWidgetsDocumentView* self,
                                          ScratchMainWindow* value)
{
	ScratchMainWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_widgets_document_view_get_window (self);
	if (old_value != value) {
		self->priv->_window = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_WINDOW_PROPERTY]);
	}
}

ScratchServicesDocument*
scratch_widgets_document_view_get_current_document (ScratchWidgetsDocumentView* self)
{
	ScratchServicesDocument* result;
	GraniteWidgetsTab* _tmp0_;
	GraniteWidgetsTab* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = granite_widgets_dynamic_notebook_get_current ((GraniteWidgetsDynamicNotebook*) self);
	_tmp1_ = _tmp0_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocument);
	return result;
}

void
scratch_widgets_document_view_set_current_document (ScratchWidgetsDocumentView* self,
                                                    ScratchServicesDocument* value)
{
	g_return_if_fail (self != NULL);
	granite_widgets_dynamic_notebook_set_current ((GraniteWidgetsDynamicNotebook*) self, (GraniteWidgetsTab*) value);
	g_object_notify_by_pspec ((GObject *) self, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_CURRENT_DOCUMENT_PROPERTY]);
}

gboolean
scratch_widgets_document_view_get_outline_visible (ScratchWidgetsDocumentView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_outline_visible;
	return result;
}

void
scratch_widgets_document_view_set_outline_visible (ScratchWidgetsDocumentView* self,
                                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_widgets_document_view_get_outline_visible (self);
	if (old_value != value) {
		self->priv->_outline_visible = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_VISIBLE_PROPERTY]);
	}
}

gint
scratch_widgets_document_view_get_outline_width (ScratchWidgetsDocumentView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_outline_width;
	return result;
}

void
scratch_widgets_document_view_set_outline_width (ScratchWidgetsDocumentView* self,
                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_widgets_document_view_get_outline_width (self);
	if (old_value != value) {
		self->priv->_outline_width = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_WIDTH_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
_scratch_widgets_document_view_on_doc_added_granite_widgets_dynamic_notebook_tab_added (GraniteWidgetsDynamicNotebook* _sender,
                                                                                        GraniteWidgetsTab* tab,
                                                                                        gpointer self)
{
	scratch_widgets_document_view_on_doc_added ((ScratchWidgetsDocumentView*) self, tab);
}

static void
_scratch_widgets_document_view_on_doc_removed_granite_widgets_dynamic_notebook_tab_removed (GraniteWidgetsDynamicNotebook* _sender,
                                                                                            GraniteWidgetsTab* tab,
                                                                                            gpointer self)
{
	scratch_widgets_document_view_on_doc_removed ((ScratchWidgetsDocumentView*) self, tab);
}

static void
_scratch_widgets_document_view_on_doc_reordered_granite_widgets_dynamic_notebook_tab_reordered (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                GraniteWidgetsTab* tab,
                                                                                                gint new_pos,
                                                                                                gpointer self)
{
	scratch_widgets_document_view_on_doc_reordered ((ScratchWidgetsDocumentView*) self, tab, new_pos);
}

static void
_scratch_widgets_document_view_on_doc_moved_granite_widgets_dynamic_notebook_tab_moved (GraniteWidgetsDynamicNotebook* _sender,
                                                                                        GraniteWidgetsTab* tab,
                                                                                        gint x,
                                                                                        gint y,
                                                                                        gpointer self)
{
	scratch_widgets_document_view_on_doc_moved ((ScratchWidgetsDocumentView*) self, tab, x, y);
}

static void
_scratch_widgets_document_view___lambda114_ (ScratchWidgetsDocumentView* self)
{
	scratch_widgets_document_view_new_document (self);
}

static void
__scratch_widgets_document_view___lambda114__granite_widgets_dynamic_notebook_new_tab_requested (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                 gpointer self)
{
	_scratch_widgets_document_view___lambda114_ ((ScratchWidgetsDocumentView*) self);
}

static gboolean
_scratch_widgets_document_view___lambda115_ (ScratchWidgetsDocumentView* self,
                                             GraniteWidgetsTab* tab)
{
	ScratchServicesDocument* document = NULL;
	ScratchServicesDocument* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ScratchServicesDocument* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	ScratchServicesDocument* _tmp11_;
	gboolean result;
	g_return_val_if_fail (tab != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (SCRATCH_SERVICES_IS_DOCUMENT (tab) ? ((ScratchServicesDocument*) tab) : NULL);
	document = _tmp0_;
	_tmp2_ = document;
	_tmp3_ = scratch_services_document_get_is_file_temporary (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		ScratchServicesDocument* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp5_ = document;
		_tmp6_ = scratch_services_document_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = _tmp7_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ScratchServicesDocument* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = document;
		_tmp9_ = scratch_services_document_get_uri (_tmp8_);
		_tmp10_ = _tmp9_;
		granite_widgets_tab_set_restore_data (tab, _tmp10_);
		_g_free0 (_tmp10_);
	}
	_tmp11_ = document;
	scratch_widgets_document_view_close_document (self, _tmp11_);
	result = FALSE;
	_g_object_unref0 (document);
	return result;
}

static gboolean
__scratch_widgets_document_view___lambda115__granite_widgets_dynamic_notebook_close_tab_requested (GraniteWidgetsDynamicNotebook* _sender,
                                                                                                   GraniteWidgetsTab* tab,
                                                                                                   gpointer self)
{
	gboolean result;
	result = _scratch_widgets_document_view___lambda115_ ((ScratchWidgetsDocumentView*) self, tab);
	return result;
}

static void
_scratch_widgets_document_view___lambda116_ (ScratchWidgetsDocumentView* self,
                                             GraniteWidgetsTab* old_tab,
                                             GraniteWidgetsTab* new_tab)
{
	ScratchServicesDocument* doc = NULL;
	ScratchServicesDocument* _tmp0_;
	ScratchServicesDocument* _tmp1_;
	ScratchServicesDocument* _tmp2_;
	g_return_if_fail (new_tab != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (new_tab, SCRATCH_SERVICES_TYPE_DOCUMENT, ScratchServicesDocument));
	doc = _tmp0_;
	_tmp1_ = doc;
	g_signal_emit (self, scratch_widgets_document_view_signals[SCRATCH_WIDGETS_DOCUMENT_VIEW_DOCUMENT_CHANGE_SIGNAL], 0, _tmp1_, self);
	_tmp2_ = doc;
	scratch_widgets_document_view_save_focused_document_uri (self, _tmp2_);
	_g_object_unref0 (doc);
}

static void
__scratch_widgets_document_view___lambda116__granite_widgets_dynamic_notebook_tab_switched (GraniteWidgetsDynamicNotebook* _sender,
                                                                                            GraniteWidgetsTab* old_tab,
                                                                                            GraniteWidgetsTab* new_tab,
                                                                                            gpointer self)
{
	_scratch_widgets_document_view___lambda116_ ((ScratchWidgetsDocumentView*) self, old_tab, new_tab);
}

static void
_scratch_widgets_document_view___lambda117_ (ScratchWidgetsDocumentView* self,
                                             const gchar* label,
                                             const gchar* restore_data,
                                             GIcon* icon)
{
	ScratchServicesDocument* doc = NULL;
	ScratchMainWindow* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	ScratchServicesDocument* _tmp5_;
	ScratchServicesDocument* _tmp6_;
	ScratchServicesDocument* _tmp7_;
	g_return_if_fail (label != NULL);
	g_return_if_fail (restore_data != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = scratch_main_window_get_actions (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_uri (restore_data);
	_tmp4_ = _tmp3_;
	_tmp5_ = scratch_services_document_new (_tmp2_, _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	doc = _tmp6_;
	_tmp7_ = doc;
	scratch_widgets_document_view_open_document (self, _tmp7_, TRUE, 0, &SELECTION_RANGE_EMPTY);
	_g_object_unref0 (doc);
}

static void
__scratch_widgets_document_view___lambda117__granite_widgets_dynamic_notebook_tab_restored (GraniteWidgetsDynamicNotebook* _sender,
                                                                                            const gchar* label,
                                                                                            const gchar* data,
                                                                                            GIcon* icon,
                                                                                            gpointer self)
{
	_scratch_widgets_document_view___lambda117_ ((ScratchWidgetsDocumentView*) self, label, data, icon);
}

static void
_scratch_widgets_document_view___lambda118_ (ScratchWidgetsDocumentView* self,
                                             GraniteWidgetsTab* tab)
{
	g_return_if_fail (tab != NULL);
	scratch_widgets_document_view_duplicate_document (self, SCRATCH_SERVICES_IS_DOCUMENT (tab) ? ((ScratchServicesDocument*) tab) : NULL);
}

static void
__scratch_widgets_document_view___lambda118__granite_widgets_dynamic_notebook_tab_duplicated (GraniteWidgetsDynamicNotebook* _sender,
                                                                                              GraniteWidgetsTab* duplicated_tab,
                                                                                              gpointer self)
{
	_scratch_widgets_document_view___lambda118_ ((ScratchWidgetsDocumentView*) self, duplicated_tab);
}

static void
_scratch_widgets_document_view_update_inline_tab_colors_g_settings_changed (GSettings* _sender,
                                                                            const gchar* key,
                                                                            gpointer self)
{
	scratch_widgets_document_view_update_inline_tab_colors ((ScratchWidgetsDocumentView*) self);
}

static void
_scratch_widgets_document_view_update_inline_tab_colors_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self)
{
	scratch_widgets_document_view_update_inline_tab_colors ((ScratchWidgetsDocumentView*) self);
}

static void
_scratch_widgets_document_view_update_outline_visible_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self)
{
	scratch_widgets_document_view_update_outline_visible ((ScratchWidgetsDocumentView*) self);
}

static void
_scratch_widgets_document_view___lambda119_ (ScratchWidgetsDocumentView* self)
{
	GList* _tmp0_;
	_tmp0_ = self->docs;
	{
		GList* doc_collection = NULL;
		GList* doc_it = NULL;
		doc_collection = _tmp0_;
		for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
			ScratchServicesDocument* _tmp1_;
			ScratchServicesDocument* doc = NULL;
			_tmp1_ = _g_object_ref0 ((ScratchServicesDocument*) doc_it->data);
			doc = _tmp1_;
			{
				ScratchServicesDocument* _tmp2_;
				gint _tmp3_;
				_tmp2_ = doc;
				_tmp3_ = self->priv->_outline_width;
				scratch_services_document_set_outline_width (_tmp2_, _tmp3_);
				_g_object_unref0 (doc);
			}
		}
	}
}

static void
__scratch_widgets_document_view___lambda119__g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	_scratch_widgets_document_view___lambda119_ ((ScratchWidgetsDocumentView*) self);
}

static void
_scratch_widgets_document_view_drag_received_gtk_widget_drag_data_received (GtkWidget* _sender,
                                                                            GdkDragContext* context,
                                                                            gint x,
                                                                            gint y,
                                                                            GtkSelectionData* selection_data,
                                                                            guint info,
                                                                            guint time_,
                                                                            gpointer self)
{
	scratch_widgets_document_view_drag_received ((ScratchWidgetsDocumentView*) self, _sender, context, x, y, selection_data, info, time_);
}

static GObject *
scratch_widgets_document_view_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchWidgetsDocumentView * self;
	GtkCssProvider* _tmp0_;
	GdkScreen* _tmp1_;
	GtkCssProvider* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GraniteSettings* granite_settings = NULL;
	GraniteSettings* _tmp5_;
	GraniteSettings* _tmp6_;
	GraniteSettings* _tmp7_;
	GSettings* _tmp8_;
	GtkTargetEntry uris = {0};
	GtkTargetEntry _tmp9_ = {0};
	GtkTargetEntry _tmp10_;
	GtkTargetEntry* _tmp11_;
	GtkTargetEntry* _tmp12_;
	gint _tmp12__length1;
	parent_class = G_OBJECT_CLASS (scratch_widgets_document_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW, ScratchWidgetsDocumentView);
	(self->docs == NULL) ? NULL : (self->docs = (_g_list_free__g_object_unref0_ (self->docs), NULL));
	self->docs = NULL;
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "tab-added", (GCallback) _scratch_widgets_document_view_on_doc_added_granite_widgets_dynamic_notebook_tab_added, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "tab-removed", (GCallback) _scratch_widgets_document_view_on_doc_removed_granite_widgets_dynamic_notebook_tab_removed, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "tab-reordered", (GCallback) _scratch_widgets_document_view_on_doc_reordered_granite_widgets_dynamic_notebook_tab_reordered, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "tab-moved", (GCallback) _scratch_widgets_document_view_on_doc_moved_granite_widgets_dynamic_notebook_tab_moved, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "new-tab-requested", (GCallback) __scratch_widgets_document_view___lambda114__granite_widgets_dynamic_notebook_new_tab_requested, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "close-tab-requested", (GCallback) __scratch_widgets_document_view___lambda115__granite_widgets_dynamic_notebook_close_tab_requested, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "tab-switched", (GCallback) __scratch_widgets_document_view___lambda116__granite_widgets_dynamic_notebook_tab_switched, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "tab-restored", (GCallback) __scratch_widgets_document_view___lambda117__granite_widgets_dynamic_notebook_tab_restored, self, 0);
	g_signal_connect_object ((GraniteWidgetsDynamicNotebook*) self, "tab-duplicated", (GCallback) __scratch_widgets_document_view___lambda118__granite_widgets_dynamic_notebook_tab_duplicated, self, 0);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->style_provider);
	self->priv->style_provider = _tmp0_;
	_tmp1_ = gdk_screen_get_default ();
	_tmp2_ = self->priv->style_provider;
	gtk_style_context_add_provider_for_screen (_tmp1_, (GtkStyleProvider*) _tmp2_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	scratch_widgets_document_view_update_inline_tab_colors (self);
	_tmp3_ = scratch_settings;
	g_signal_connect_object (_tmp3_, "changed::style-scheme", (GCallback) _scratch_widgets_document_view_update_inline_tab_colors_g_settings_changed, self, 0);
	_tmp4_ = scratch_settings;
	g_signal_connect_object (_tmp4_, "changed::follow-system-style", (GCallback) _scratch_widgets_document_view_update_inline_tab_colors_g_settings_changed, self, 0);
	_tmp5_ = granite_settings_get_default ();
	_tmp6_ = _g_object_ref0 (_tmp5_);
	granite_settings = _tmp6_;
	_tmp7_ = granite_settings;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::prefers-color-scheme", (GCallback) _scratch_widgets_document_view_update_inline_tab_colors_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::outline-visible", (GCallback) _scratch_widgets_document_view_update_outline_visible_g_object_notify, self, 0);
	_tmp8_ = scratch_saved_state;
	g_settings_bind (_tmp8_, "outline-width", (GObject*) self, "outline-width", G_SETTINGS_BIND_DEFAULT);
	g_signal_connect_object ((GObject*) self, "notify::outline-width", (GCallback) __scratch_widgets_document_view___lambda119__g_object_notify, self, 0);
	_tmp9_.target = "text/uri-list";
	_tmp9_.flags = (guint) 0;
	_tmp9_.info = (guint) SCRATCH_WIDGETS_DOCUMENT_VIEW_TARGET_TYPE_URI_LIST;
	uris = _tmp9_;
	_tmp10_ = uris;
	_tmp11_ = g_new0 (GtkTargetEntry, 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp12_, (gint) 1, GDK_ACTION_COPY);
	_tmp12_ = (g_free (_tmp12_), NULL);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) _scratch_widgets_document_view_drag_received_gtk_widget_drag_data_received, self, 0);
	_g_object_unref0 (granite_settings);
	return obj;
}

static void
scratch_widgets_document_view_class_init (ScratchWidgetsDocumentViewClass * klass,
                                          gpointer klass_data)
{
	scratch_widgets_document_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchWidgetsDocumentView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_widgets_document_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_widgets_document_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_widgets_document_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_widgets_document_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_DOCUMENT_VIEW_WINDOW_PROPERTY, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", SCRATCH_TYPE_MAIN_WINDOW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_DOCUMENT_VIEW_CURRENT_DOCUMENT_PROPERTY, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_CURRENT_DOCUMENT_PROPERTY] = g_param_spec_object ("current-document", "current-document", "current-document", SCRATCH_SERVICES_TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_VISIBLE_PROPERTY, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_VISIBLE_PROPERTY] = g_param_spec_boolean ("outline-visible", "outline-visible", "outline-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_WIDTH_PROPERTY, scratch_widgets_document_view_properties[SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_WIDTH_PROPERTY] = g_param_spec_int ("outline-width", "outline-width", "outline-width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	scratch_widgets_document_view_signals[SCRATCH_WIDGETS_DOCUMENT_VIEW_DOCUMENT_CHANGE_SIGNAL] = g_signal_new ("document-change", SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, SCRATCH_SERVICES_TYPE_DOCUMENT, SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW);
	scratch_widgets_document_view_signals[SCRATCH_WIDGETS_DOCUMENT_VIEW_REQUEST_PLACEHOLDER_SIGNAL] = g_signal_new ("request-placeholder", SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
scratch_widgets_document_view_instance_init (ScratchWidgetsDocumentView * self,
                                             gpointer klass)
{
	self->priv = scratch_widgets_document_view_get_instance_private (self);
	self->is_closing = FALSE;
	self->priv->_outline_visible = FALSE;
}

static void
scratch_widgets_document_view_finalize (GObject * obj)
{
	ScratchWidgetsDocumentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW, ScratchWidgetsDocumentView);
	(self->docs == NULL) ? NULL : (self->docs = (_g_list_free__g_object_unref0_ (self->docs), NULL));
	_g_object_unref0 (self->priv->style_provider);
	G_OBJECT_CLASS (scratch_widgets_document_view_parent_class)->finalize (obj);
}

/***
  BEGIN LICENSE

  Copyright (C) 2013 Mario Guerriero <mario@elementaryos.org>
  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License version 3, as published
  by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranties of
  MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program.  If not, see <http://www.gnu.org/licenses/>

  END LICENSE
***/
static GType
scratch_widgets_document_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchWidgetsDocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_widgets_document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchWidgetsDocumentView), 0, (GInstanceInitFunc) scratch_widgets_document_view_instance_init, NULL };
	GType scratch_widgets_document_view_type_id;
	scratch_widgets_document_view_type_id = g_type_register_static (GRANITE_WIDGETS_TYPE_DYNAMIC_NOTEBOOK, "ScratchWidgetsDocumentView", &g_define_type_info, 0);
	ScratchWidgetsDocumentView_private_offset = g_type_add_instance_private (scratch_widgets_document_view_type_id, sizeof (ScratchWidgetsDocumentViewPrivate));
	return scratch_widgets_document_view_type_id;
}

GType
scratch_widgets_document_view_get_type (void)
{
	static volatile gsize scratch_widgets_document_view_type_id__once = 0;
	if (g_once_init_enter (&scratch_widgets_document_view_type_id__once)) {
		GType scratch_widgets_document_view_type_id;
		scratch_widgets_document_view_type_id = scratch_widgets_document_view_get_type_once ();
		g_once_init_leave (&scratch_widgets_document_view_type_id__once, scratch_widgets_document_view_type_id);
	}
	return scratch_widgets_document_view_type_id__once;
}

static void
_vala_scratch_widgets_document_view_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	ScratchWidgetsDocumentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW, ScratchWidgetsDocumentView);
	switch (property_id) {
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_WINDOW_PROPERTY:
		g_value_set_object (value, scratch_widgets_document_view_get_window (self));
		break;
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_CURRENT_DOCUMENT_PROPERTY:
		g_value_set_object (value, scratch_widgets_document_view_get_current_document (self));
		break;
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_VISIBLE_PROPERTY:
		g_value_set_boolean (value, scratch_widgets_document_view_get_outline_visible (self));
		break;
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_WIDTH_PROPERTY:
		g_value_set_int (value, scratch_widgets_document_view_get_outline_width (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_widgets_document_view_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	ScratchWidgetsDocumentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_WIDGETS_TYPE_DOCUMENT_VIEW, ScratchWidgetsDocumentView);
	switch (property_id) {
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_WINDOW_PROPERTY:
		scratch_widgets_document_view_set_window (self, g_value_get_object (value));
		break;
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_CURRENT_DOCUMENT_PROPERTY:
		scratch_widgets_document_view_set_current_document (self, g_value_get_object (value));
		break;
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_VISIBLE_PROPERTY:
		scratch_widgets_document_view_set_outline_visible (self, g_value_get_boolean (value));
		break;
		case SCRATCH_WIDGETS_DOCUMENT_VIEW_OUTLINE_WIDTH_PROPERTY:
		scratch_widgets_document_view_set_outline_width (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

