/* Utils.c generated by valac 0.56.14, the Vala compiler
 * generated from Utils.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*
* Copyright (c) 2013 Mario Guerriero <mefrio.g@gmail.com>
*               2017 elementary LLC. <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "codecore.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <pango/pango.h>

#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

gchar* scratch_utils_last_path = NULL;

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GSimpleAction*
scratch_utils_action_from_group (const gchar* action_name,
                                 GSimpleActionGroup* action_group)
{
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* result;
	g_return_val_if_fail (action_name != NULL, NULL);
	g_return_val_if_fail (action_group != NULL, NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) action_group, action_name);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, g_simple_action_get_type (), GSimpleAction));
	result = _tmp1_;
	return result;
}

gchar*
scratch_utils_pango_font_description_to_css (PangoFontDescription* font_descr)
{
	GString* sb = NULL;
	GString* _tmp0_;
	PangoFontMask mask = 0U;
	GString* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (font_descr != NULL, NULL);
	_tmp0_ = g_string_new ("");
	sb = _tmp0_;
	mask = pango_font_description_get_set_fields (font_descr);
	if ((mask & PANGO_FONT_MASK_FAMILY) == PANGO_FONT_MASK_FAMILY) {
		const gchar* family = NULL;
		const gchar* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = pango_font_description_get_family (font_descr);
		family = _tmp1_;
		_tmp2_ = sb;
		_tmp3_ = family;
		g_string_append_printf (_tmp2_, "font-family: \"%s\";", _tmp3_);
	}
	if ((mask & PANGO_FONT_MASK_STYLE) == PANGO_FONT_MASK_STYLE) {
		PangoStyle style = 0;
		style = pango_font_description_get_style (font_descr);
		switch (style) {
			case PANGO_STYLE_NORMAL:
			{
				GString* _tmp4_;
				_tmp4_ = sb;
				g_string_append (_tmp4_, "font-style: normal;");
				break;
			}
			case PANGO_STYLE_ITALIC:
			{
				GString* _tmp5_;
				_tmp5_ = sb;
				g_string_append (_tmp5_, "font-style: italic;");
				break;
			}
			case PANGO_STYLE_OBLIQUE:
			{
				GString* _tmp6_;
				_tmp6_ = sb;
				g_string_append (_tmp6_, "font-style: bold;");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if ((mask & PANGO_FONT_MASK_VARIANT) == PANGO_FONT_MASK_VARIANT) {
		PangoVariant variant = 0;
		variant = pango_font_description_get_variant (font_descr);
		switch (variant) {
			case PANGO_VARIANT_NORMAL:
			{
				GString* _tmp7_;
				_tmp7_ = sb;
				g_string_append (_tmp7_, "font-variant: normal;");
				break;
			}
			case PANGO_VARIANT_SMALL_CAPS:
			{
				GString* _tmp8_;
				_tmp8_ = sb;
				g_string_append (_tmp8_, "font-variant: small-caps");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if ((mask & PANGO_FONT_MASK_WEIGHT) == PANGO_FONT_MASK_WEIGHT) {
		gint weight = 0;
		GString* _tmp9_;
		weight = CLAMP ((gint) ((pango_font_description_get_weight (font_descr) / 100) * 100), 100, 900);
		_tmp9_ = sb;
		g_string_append_printf (_tmp9_, "font-weight: %i;", weight);
	}
	if ((mask & PANGO_FONT_MASK_STRETCH) == PANGO_FONT_MASK_STRETCH) {
		PangoStretch stretch = 0;
		stretch = pango_font_description_get_stretch (font_descr);
		switch (stretch) {
			case PANGO_STRETCH_NORMAL:
			{
				GString* _tmp10_;
				_tmp10_ = sb;
				g_string_append_printf (_tmp10_, "font-stretch: %s;", "normal");
				break;
			}
			case PANGO_STRETCH_ULTRA_CONDENSED:
			{
				GString* _tmp11_;
				_tmp11_ = sb;
				g_string_append_printf (_tmp11_, "font-stretch: %s;", "condensed");
				break;
			}
			case PANGO_STRETCH_EXTRA_CONDENSED:
			{
				GString* _tmp12_;
				_tmp12_ = sb;
				g_string_append_printf (_tmp12_, "font-stretch: %s;", "extra-condensed");
				break;
			}
			case PANGO_STRETCH_CONDENSED:
			{
				GString* _tmp13_;
				_tmp13_ = sb;
				g_string_append_printf (_tmp13_, "font-stretch: %s;", "condensed");
				break;
			}
			case PANGO_STRETCH_SEMI_CONDENSED:
			{
				GString* _tmp14_;
				_tmp14_ = sb;
				g_string_append_printf (_tmp14_, "font-stretch: %s;", "normal");
				break;
			}
			case PANGO_STRETCH_SEMI_EXPANDED:
			{
				GString* _tmp15_;
				_tmp15_ = sb;
				g_string_append_printf (_tmp15_, "font-stretch: %s;", "semi-expanded");
				break;
			}
			case PANGO_STRETCH_EXPANDED:
			{
				GString* _tmp16_;
				_tmp16_ = sb;
				g_string_append_printf (_tmp16_, "font-stretch: %s;", "expanded");
				break;
			}
			case PANGO_STRETCH_EXTRA_EXPANDED:
			{
				GString* _tmp17_;
				_tmp17_ = sb;
				g_string_append_printf (_tmp17_, "font-stretch: %s;", "extra-expanded");
				break;
			}
			case PANGO_STRETCH_ULTRA_EXPANDED:
			{
				GString* _tmp18_;
				_tmp18_ = sb;
				g_string_append_printf (_tmp18_, "font-stretch: %s;", "ultra-expanded");
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if ((mask & PANGO_FONT_MASK_SIZE) == PANGO_FONT_MASK_SIZE) {
		gint font_size = 0;
		GString* _tmp19_;
		font_size = pango_font_description_get_size (font_descr) / PANGO_SCALE;
		_tmp19_ = sb;
		g_string_append_printf (_tmp19_, "font-size: %dpt;", font_size);
	}
	_tmp20_ = sb;
	_tmp21_ = _tmp20_->str;
	_tmp22_ = g_strdup (_tmp21_);
	result = _tmp22_;
	_g_string_free0 (sb);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
scratch_utils_replace_home_with_tilde (const gchar* path)
{
	gchar* home_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	home_dir = _tmp1_;
	_tmp2_ = home_dir;
	if (g_str_has_prefix (path, _tmp2_)) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp3_ = home_dir;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (path, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("~", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		_g_free0 (home_dir);
		return result;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (path);
		result = _tmp10_;
		_g_free0 (home_dir);
		return result;
	}
}

gboolean
scratch_utils_find_unique_path (GFile* f1,
                                GFile* f2,
                                gchar** path1,
                                gchar** path2)
{
	gchar* _vala_path1 = NULL;
	gchar* _vala_path2 = NULL;
	GFile* f1_parent = NULL;
	GFile* _tmp0_;
	GFile* f2_parent = NULL;
	GFile* _tmp1_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	GFile* _tmp15_;
	gchar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (f1 != NULL, FALSE);
	g_return_val_if_fail (f2 != NULL, FALSE);
	if (g_file_equal (f1, f2)) {
		_g_free0 (_vala_path1);
		_vala_path1 = NULL;
		_g_free0 (_vala_path2);
		_vala_path2 = NULL;
		result = FALSE;
		if (path1) {
			*path1 = _vala_path1;
		} else {
			_g_free0 (_vala_path1);
		}
		if (path2) {
			*path2 = _vala_path2;
		} else {
			_g_free0 (_vala_path2);
		}
		return result;
	}
	_tmp0_ = g_file_get_parent (f1);
	f1_parent = _tmp0_;
	_tmp1_ = g_file_get_parent (f2);
	f2_parent = _tmp1_;
	while (TRUE) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		_tmp2_ = f1_parent;
		_tmp3_ = g_file_get_relative_path (_tmp2_, f1);
		_tmp4_ = _tmp3_;
		_tmp5_ = f2_parent;
		_tmp6_ = g_file_get_relative_path (_tmp5_, f2);
		_tmp7_ = _tmp6_;
		_tmp8_ = !(g_strcmp0 (_tmp4_, _tmp7_) == 0);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp4_);
		if (_tmp8_) {
			break;
		}
		_tmp9_ = f1_parent;
		_tmp10_ = g_file_get_parent (_tmp9_);
		_g_object_unref0 (f1_parent);
		f1_parent = _tmp10_;
		_tmp11_ = f2_parent;
		_tmp12_ = g_file_get_parent (_tmp11_);
		_g_object_unref0 (f2_parent);
		f2_parent = _tmp12_;
	}
	_tmp13_ = f1_parent;
	_tmp14_ = g_file_get_relative_path (_tmp13_, f1);
	_g_free0 (_vala_path1);
	_vala_path1 = _tmp14_;
	_tmp15_ = f2_parent;
	_tmp16_ = g_file_get_relative_path (_tmp15_, f2);
	_g_free0 (_vala_path2);
	_vala_path2 = _tmp16_;
	result = TRUE;
	_g_object_unref0 (f2_parent);
	_g_object_unref0 (f1_parent);
	if (path1) {
		*path1 = _vala_path1;
	} else {
		_g_free0 (_vala_path1);
	}
	if (path2) {
		*path2 = _vala_path2;
	} else {
		_g_free0 (_vala_path2);
	}
	return result;
}

gboolean
scratch_utils_check_if_valid_text_file (const gchar* path,
                                        GFileInfo* info)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (info != NULL, FALSE);
	if (g_str_has_prefix (path, ".goutputstream")) {
		result = FALSE;
		return result;
	}
	if (g_file_info_get_is_backup (info)) {
		result = FALSE;
		return result;
	}
	if (g_file_info_get_file_type (info) == G_FILE_TYPE_REGULAR) {
		const gchar* _tmp1_;
		_tmp1_ = g_file_info_get_content_type (info);
		_tmp0_ = g_content_type_is_a (_tmp1_, "text/*");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

