/* LocationJumpManager.c generated by valac 0.56.14, the Vala compiler
 * generated from LocationJumpManager.vala, do not modify */

/*  
 * SPDX-License-Identifier: GPL-3.0-or-later  
 * SPDX-FileCopyrightText: 2023 elementary, Inc. <https://elementary.io>  
 *
 * Authored by: Colin Kiama <colinkiama@gmail.com>
 */

#include "codecore.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib-object.h>

enum  {
	SCRATCH_LOCATION_JUMP_MANAGER_0_PROPERTY,
	SCRATCH_LOCATION_JUMP_MANAGER_FILE_PROPERTY,
	SCRATCH_LOCATION_JUMP_MANAGER_RANGE_PROPERTY,
	SCRATCH_LOCATION_JUMP_MANAGER_NUM_PROPERTIES
};
static GParamSpec* scratch_location_jump_manager_properties[SCRATCH_LOCATION_JUMP_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ScratchLocationJumpManagerPrivate {
	GFile* _file;
	SelectionRange _range;
};

static gint ScratchLocationJumpManager_private_offset;
static gpointer scratch_location_jump_manager_parent_class = NULL;

static gboolean _selection_range_equal (const SelectionRange * s1,
                                 const SelectionRange * s2);
static void scratch_location_jump_manager_parse_go_to_range_from_match_info (GMatchInfo* match_info,
                                                                      SelectionRange* result);
static gint scratch_location_jump_manager_parse_num_from_match_info (GMatchInfo* match_info,
                                                              const gchar* match_name);
static void scratch_location_jump_manager_finalize (GObject * obj);
static GType scratch_location_jump_manager_get_type_once (void);
static void _vala_scratch_location_jump_manager_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_scratch_location_jump_manager_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

VALA_EXTERN const SelectionRange SELECTION_RANGE_EMPTY;
static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
scratch_location_jump_manager_get_instance_private (ScratchLocationJumpManager* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchLocationJumpManager_private_offset);
}

gboolean
scratch_location_jump_manager_has_override_target (ScratchLocationJumpManager* self)
{
	GFile* _tmp0_;
	gboolean is_override_target = FALSE;
	GSettings* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_file;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	is_override_target = FALSE;
	_tmp1_ = scratch_privacy_settings;
	if (g_settings_get_boolean (_tmp1_, "remember-recent-files")) {
		GVariant* doc_infos = NULL;
		GSettings* _tmp2_;
		GVariant* _tmp3_;
		GVariantIter* doc_info_iter = NULL;
		GVariant* _tmp4_;
		GVariantIter* _tmp5_;
		gchar* uri = NULL;
		gint pos = 0;
		_tmp2_ = scratch_settings;
		_tmp3_ = g_settings_get_value (_tmp2_, "opened-files");
		doc_infos = _tmp3_;
		_tmp4_ = doc_infos;
		_tmp5_ = g_variant_iter_new (_tmp4_);
		doc_info_iter = _tmp5_;
		while (TRUE) {
			GVariantIter* _tmp6_;
			gchar* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gboolean _tmp9_;
			const gchar* _tmp10_;
			_tmp6_ = doc_info_iter;
			_tmp9_ = g_variant_iter_next (_tmp6_, "(si)", &_tmp7_, &_tmp8_, NULL);
			_g_free0 (uri);
			uri = _tmp7_;
			pos = _tmp8_;
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = uri;
			if (g_strcmp0 (_tmp10_, "") != 0) {
				GFile* file_to_restore = NULL;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gboolean _tmp14_;
				gboolean _tmp19_ = FALSE;
				GFile* _tmp20_;
				_tmp11_ = uri;
				_tmp12_ = g_uri_parse_scheme (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_ != NULL;
				_g_free0 (_tmp13_);
				if (_tmp14_) {
					const gchar* _tmp15_;
					GFile* _tmp16_;
					_tmp15_ = uri;
					_tmp16_ = g_file_new_for_uri (_tmp15_);
					_g_object_unref0 (file_to_restore);
					file_to_restore = _tmp16_;
				} else {
					const gchar* _tmp17_;
					GFile* _tmp18_;
					_tmp17_ = uri;
					_tmp18_ = g_file_new_for_commandline_arg (_tmp17_);
					_g_object_unref0 (file_to_restore);
					file_to_restore = _tmp18_;
				}
				_tmp20_ = file_to_restore;
				if (g_file_query_exists (_tmp20_, NULL)) {
					GFile* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					GFile* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp21_ = file_to_restore;
					_tmp22_ = g_file_get_path (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = self->priv->_file;
					_tmp25_ = g_file_get_path (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp19_ = g_strcmp0 (_tmp23_, _tmp26_) == 0;
					_g_free0 (_tmp26_);
					_g_free0 (_tmp23_);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					is_override_target = TRUE;
					_g_object_unref0 (file_to_restore);
					break;
				}
				_g_object_unref0 (file_to_restore);
			}
		}
		_g_free0 (uri);
		_g_variant_iter_free0 (doc_info_iter);
		_g_variant_unref0 (doc_infos);
	}
	result = is_override_target;
	return result;
}

RestoreOverride*
scratch_location_jump_manager_create_restore_override (ScratchLocationJumpManager* self)
{
	GFile* _tmp0_;
	SelectionRange _tmp1_;
	RestoreOverride* _tmp2_;
	RestoreOverride* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	_tmp1_ = self->priv->_range;
	_tmp2_ = restore_override_new (_tmp0_, &_tmp1_);
	result = _tmp2_;
	return result;
}

void
scratch_location_jump_manager_clear (ScratchLocationJumpManager* self)
{
	g_return_if_fail (self != NULL);
	scratch_location_jump_manager_set_range (self, &SELECTION_RANGE_EMPTY);
	scratch_location_jump_manager_set_file (self, NULL);
}

static gboolean
_selection_range_equal (const SelectionRange * s1,
                        const SelectionRange * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->start_line != s2->start_line) {
		return FALSE;
	}
	if (s1->start_column != s2->start_column) {
		return FALSE;
	}
	if (s1->end_line != s2->end_line) {
		return FALSE;
	}
	if (s1->end_column != s2->end_column) {
		return FALSE;
	}
	return TRUE;
}

gboolean
scratch_location_jump_manager_has_selection_range (ScratchLocationJumpManager* self)
{
	SelectionRange _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_range;
	result = _selection_range_equal (&_tmp0_, &SELECTION_RANGE_EMPTY) != TRUE;
	return result;
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

gboolean
scratch_location_jump_manager_parse_selection_range_string (ScratchLocationJumpManager* self,
                                                            const gchar* selection_range_string)
{
	GRegex* go_to_line_regex = NULL;
	GRegex* _tmp0_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp1_;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (selection_range_string != NULL, FALSE);
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "^(?<start_line>[0-9]+)+(?:\\.(?<start_column>[0-9]+)+)?(?:-(?:(?<end_line>[0-9]+)+(?:\\.(?<end_column>[0-9]+)+)?))?$", 0));
	go_to_line_regex = _tmp0_;
	_tmp1_ = go_to_line_regex;
	_tmp3_ = g_regex_match (_tmp1_, selection_range_string, 0, &_tmp2_);
	_g_match_info_unref0 (match_info);
	match_info = _tmp2_;
	if (_tmp3_) {
		GMatchInfo* _tmp4_;
		SelectionRange _tmp5_ = {0};
		SelectionRange _tmp6_;
		SelectionRange _tmp7_;
		SelectionRange _tmp8_;
		SelectionRange _tmp9_;
		_tmp4_ = match_info;
		scratch_location_jump_manager_parse_go_to_range_from_match_info (_tmp4_, &_tmp5_);
		scratch_location_jump_manager_set_range (self, &_tmp5_);
		_tmp6_ = self->priv->_range;
		g_debug ("LocationJumpManager.vala:64: Selection Range - start_line: %d", _tmp6_.start_line);
		_tmp7_ = self->priv->_range;
		g_debug ("LocationJumpManager.vala:65: Selection Range - start_column: %d", _tmp7_.start_column);
		_tmp8_ = self->priv->_range;
		g_debug ("LocationJumpManager.vala:66: Selection Range - end_line: %d", _tmp8_.end_line);
		_tmp9_ = self->priv->_range;
		g_debug ("LocationJumpManager.vala:67: Selection Range - end_column: %d", _tmp9_.end_column);
	}
	result = TRUE;
	_g_match_info_unref0 (match_info);
	_g_regex_unref0 (go_to_line_regex);
	return result;
}

static void
scratch_location_jump_manager_parse_go_to_range_from_match_info (GMatchInfo* match_info,
                                                                 SelectionRange* result)
{
	SelectionRange _tmp0_ = {0};
	g_return_if_fail (match_info != NULL);
	memset (&_tmp0_, 0, sizeof (SelectionRange));
	_tmp0_.start_line = scratch_location_jump_manager_parse_num_from_match_info (match_info, "start_line");
	_tmp0_.end_line = scratch_location_jump_manager_parse_num_from_match_info (match_info, "end_line");
	_tmp0_.start_column = scratch_location_jump_manager_parse_num_from_match_info (match_info, "start_column");
	_tmp0_.end_column = scratch_location_jump_manager_parse_num_from_match_info (match_info, "end_column");
	*result = _tmp0_;
	return;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gint
scratch_location_jump_manager_parse_num_from_match_info (GMatchInfo* match_info,
                                                         const gchar* match_name)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gint num = 0;
	const gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (match_info != NULL, 0);
	g_return_val_if_fail (match_name != NULL, 0);
	_tmp0_ = g_match_info_fetch_named (match_info, match_name);
	str = _tmp0_;
	num = 0;
	_tmp1_ = str;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gint _tmp3_ = 0;
		_tmp2_ = str;
		int_try_parse (_tmp2_, &_tmp3_, NULL, (guint) 0);
		num = _tmp3_;
	}
	result = num;
	_g_free0 (str);
	return result;
}

ScratchLocationJumpManager*
scratch_location_jump_manager_construct (GType object_type)
{
	ScratchLocationJumpManager * self = NULL;
	self = (ScratchLocationJumpManager*) g_object_new (object_type, NULL);
	return self;
}

ScratchLocationJumpManager*
scratch_location_jump_manager_new (void)
{
	return scratch_location_jump_manager_construct (SCRATCH_TYPE_LOCATION_JUMP_MANAGER);
}

GFile*
scratch_location_jump_manager_get_file (ScratchLocationJumpManager* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
scratch_location_jump_manager_set_file (ScratchLocationJumpManager* self,
                                        GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_location_jump_manager_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_location_jump_manager_properties[SCRATCH_LOCATION_JUMP_MANAGER_FILE_PROPERTY]);
	}
}

void
scratch_location_jump_manager_get_range (ScratchLocationJumpManager* self,
                                         SelectionRange * result)
{
	SelectionRange _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_range;
	*result = _tmp0_;
	return;
}

void
scratch_location_jump_manager_set_range (ScratchLocationJumpManager* self,
                                         SelectionRange * value)
{
	SelectionRange old_value;
	g_return_if_fail (self != NULL);
	scratch_location_jump_manager_get_range (self, &old_value);
	if (_selection_range_equal (value, &old_value) != TRUE) {
		SelectionRange _tmp0_;
		_tmp0_ = *value;
		self->priv->_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_location_jump_manager_properties[SCRATCH_LOCATION_JUMP_MANAGER_RANGE_PROPERTY]);
	}
}

static void
scratch_location_jump_manager_class_init (ScratchLocationJumpManagerClass * klass,
                                          gpointer klass_data)
{
	scratch_location_jump_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchLocationJumpManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_location_jump_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_location_jump_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = scratch_location_jump_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_LOCATION_JUMP_MANAGER_FILE_PROPERTY, scratch_location_jump_manager_properties[SCRATCH_LOCATION_JUMP_MANAGER_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_LOCATION_JUMP_MANAGER_RANGE_PROPERTY, scratch_location_jump_manager_properties[SCRATCH_LOCATION_JUMP_MANAGER_RANGE_PROPERTY] = g_param_spec_boxed ("range", "range", "range", TYPE_SELECTION_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
scratch_location_jump_manager_instance_init (ScratchLocationJumpManager * self,
                                             gpointer klass)
{
	self->priv = scratch_location_jump_manager_get_instance_private (self);
}

static void
scratch_location_jump_manager_finalize (GObject * obj)
{
	ScratchLocationJumpManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_LOCATION_JUMP_MANAGER, ScratchLocationJumpManager);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (scratch_location_jump_manager_parent_class)->finalize (obj);
}

static GType
scratch_location_jump_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchLocationJumpManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_location_jump_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchLocationJumpManager), 0, (GInstanceInitFunc) scratch_location_jump_manager_instance_init, NULL };
	GType scratch_location_jump_manager_type_id;
	scratch_location_jump_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchLocationJumpManager", &g_define_type_info, 0);
	ScratchLocationJumpManager_private_offset = g_type_add_instance_private (scratch_location_jump_manager_type_id, sizeof (ScratchLocationJumpManagerPrivate));
	return scratch_location_jump_manager_type_id;
}

GType
scratch_location_jump_manager_get_type (void)
{
	static volatile gsize scratch_location_jump_manager_type_id__once = 0;
	if (g_once_init_enter (&scratch_location_jump_manager_type_id__once)) {
		GType scratch_location_jump_manager_type_id;
		scratch_location_jump_manager_type_id = scratch_location_jump_manager_get_type_once ();
		g_once_init_leave (&scratch_location_jump_manager_type_id__once, scratch_location_jump_manager_type_id);
	}
	return scratch_location_jump_manager_type_id__once;
}

static void
_vala_scratch_location_jump_manager_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	ScratchLocationJumpManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_LOCATION_JUMP_MANAGER, ScratchLocationJumpManager);
	switch (property_id) {
		case SCRATCH_LOCATION_JUMP_MANAGER_FILE_PROPERTY:
		g_value_set_object (value, scratch_location_jump_manager_get_file (self));
		break;
		case SCRATCH_LOCATION_JUMP_MANAGER_RANGE_PROPERTY:
		{
			SelectionRange boxed;
			scratch_location_jump_manager_get_range (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_location_jump_manager_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	ScratchLocationJumpManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_LOCATION_JUMP_MANAGER, ScratchLocationJumpManager);
	switch (property_id) {
		case SCRATCH_LOCATION_JUMP_MANAGER_FILE_PROPERTY:
		scratch_location_jump_manager_set_file (self, g_value_get_object (value));
		break;
		case SCRATCH_LOCATION_JUMP_MANAGER_RANGE_PROPERTY:
		scratch_location_jump_manager_set_range (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

