/* ProjectFolderItem.c generated by valac 0.56.14, the Vala compiler
 * generated from ProjectFolderItem.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC. (https://elementary.io),
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include "codecore.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgit2-glib/ggit.h>
#include <glib/gstdio.h>

#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_VISIBLE_ITEM (scratch_folder_manager_project_folder_item_visible_item_get_type ())
typedef struct _ScratchFolderManagerProjectFolderItemVisibleItem ScratchFolderManagerProjectFolderItemVisibleItem;
enum  {
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU (scratch_folder_manager_project_folder_item_change_branch_menu_get_type ())
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, ScratchFolderManagerProjectFolderItemChangeBranchMenu))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, ScratchFolderManagerProjectFolderItemChangeBranchMenuClass))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_CHANGE_BRANCH_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_CHANGE_BRANCH_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, ScratchFolderManagerProjectFolderItemChangeBranchMenuClass))

typedef struct _ScratchFolderManagerProjectFolderItemChangeBranchMenu ScratchFolderManagerProjectFolderItemChangeBranchMenu;
typedef struct _ScratchFolderManagerProjectFolderItemChangeBranchMenuClass ScratchFolderManagerProjectFolderItemChangeBranchMenuClass;
typedef struct _Block12Data Block12Data;
#define _scratch_folder_manager_project_folder_item_visible_item_free0(var) ((var == NULL) ? NULL : (var = (scratch_folder_manager_project_folder_item_visible_item_free (var), NULL)))
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GgitStatusOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitStatusOptions_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ScratchFolderManagerProjectFolderItemChangeBranchMenuPrivate ScratchFolderManagerProjectFolderItemChangeBranchMenuPrivate;
enum  {
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_MONITORED_REPO_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_PROJECT_FOLDER_PROPERTY,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_project_folder_item_change_branch_menu_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_NUM_PROPERTIES];
typedef struct _Block16Data Block16Data;
enum  {
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSE_ALL_EXCEPT_SIGNAL,
	SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_SIGNALS
};
static guint scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScratchFolderManagerProjectFolderItemVisibleItem {
	gchar* rel_path;
	ScratchFolderManagerItem* item;
};

struct _ScratchFolderManagerProjectFolderItemPrivate {
	ScratchServicesMonitoredRepository* _monitored_repo;
	GList* visible_item_list;
};

struct _Block12Data {
	int _ref_count_;
	ScratchFolderManagerProjectFolderItem* self;
	gboolean is_new;
	gchar* start_path;
};

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	ScratchFolderManagerItem* item;
	ScratchFolderManagerProjectFolderItemVisibleItem* visible_item;
};

struct _Block14Data {
	int _ref_count_;
	ScratchFolderManagerProjectFolderItem* self;
	GraniteMessageDialog* dialog;
};

struct _Block15Data {
	int _ref_count_;
	ScratchFolderManagerProjectFolderItem* self;
	gchar* search_term;
	gboolean use_regex;
	gboolean recurse_subfolders;
	gboolean check_is_text;
	gboolean case_sensitive;
	GRegex* pattern;
	ScratchDialogsGlobalSearchDialog* dialog;
	GFile* start_folder;
	gchar* term;
};

struct _ScratchFolderManagerProjectFolderItemChangeBranchMenu {
	GtkMenuItem parent_instance;
	ScratchFolderManagerProjectFolderItemChangeBranchMenuPrivate * priv;
};

struct _ScratchFolderManagerProjectFolderItemChangeBranchMenuClass {
	GtkMenuItemClass parent_class;
};

struct _ScratchFolderManagerProjectFolderItemChangeBranchMenuPrivate {
	ScratchFolderManagerProjectFolderItem* _project_folder;
};

struct _Block16Data {
	int _ref_count_;
	ScratchFolderManagerProjectFolderItemChangeBranchMenu* self;
	const gchar* branch_name;
};

static gint ScratchFolderManagerProjectFolderItem_private_offset;
static gpointer scratch_folder_manager_project_folder_item_parent_class = NULL;
static GIcon* scratch_folder_manager_project_folder_item_added_icon;
static GIcon* scratch_folder_manager_project_folder_item_added_icon = NULL;
static GIcon* scratch_folder_manager_project_folder_item_modified_icon;
static GIcon* scratch_folder_manager_project_folder_item_modified_icon = NULL;
static gint ScratchFolderManagerProjectFolderItemChangeBranchMenu_private_offset;
static gpointer scratch_folder_manager_project_folder_item_change_branch_menu_parent_class = NULL;

static GType scratch_folder_manager_project_folder_item_visible_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ScratchFolderManagerProjectFolderItemVisibleItem* scratch_folder_manager_project_folder_item_visible_item_dup (const ScratchFolderManagerProjectFolderItemVisibleItem* self);
static void scratch_folder_manager_project_folder_item_visible_item_free (ScratchFolderManagerProjectFolderItemVisibleItem* self);
static void scratch_folder_manager_project_folder_item_visible_item_copy (const ScratchFolderManagerProjectFolderItemVisibleItem* self,
                                                                   ScratchFolderManagerProjectFolderItemVisibleItem* dest);
static void scratch_folder_manager_project_folder_item_visible_item_destroy (ScratchFolderManagerProjectFolderItemVisibleItem* self);
static void _scratch_folder_manager_project_folder_item_visible_item_free0_ (gpointer var);
static inline void _g_list_free__scratch_folder_manager_project_folder_item_visible_item_free0_ (GList* self);
static void scratch_folder_manager_project_folder_item_branch_or_name_changed (ScratchFolderManagerProjectFolderItem* self);
static void scratch_folder_manager_project_folder_item_real_on_changed (ScratchFolderManagerFolderItem* base,
                                                                 GFile* source,
                                                                 GFile* dest,
                                                                 GFileMonitorEvent event);
static void scratch_folder_manager_project_folder_item_deprioritize_git_ignored (ScratchFolderManagerProjectFolderItem* self);
static GtkMenu* scratch_folder_manager_project_folder_item_real_get_context_menu (GraniteWidgetsSourceListItem* base);
static void __lambda91_ (ScratchFolderManagerProjectFolderItem* self);
static void ___lambda91__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda92_ (ScratchFolderManagerProjectFolderItem* self);
static void ___lambda92__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda93_ (ScratchFolderManagerProjectFolderItem* self);
static void ___lambda93__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static GType scratch_folder_manager_project_folder_item_change_branch_menu_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ScratchFolderManagerProjectFolderItemChangeBranchMenu* scratch_folder_manager_project_folder_item_change_branch_menu_new (ScratchFolderManagerProjectFolderItem* project_folder);
static ScratchFolderManagerProjectFolderItemChangeBranchMenu* scratch_folder_manager_project_folder_item_change_branch_menu_construct (GType object_type,
                                                                                                                                ScratchFolderManagerProjectFolderItem* project_folder);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda81_ (Block12Data* _data12_,
                  ScratchFolderManagerProjectFolderItemVisibleItem* visible_item);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static gboolean __lambda82_ (Block13Data* _data13_,
                      GeeMapEntry* entry);
static gboolean ___lambda82__gee_forall_func (gpointer g,
                                       gpointer self);
static void ___lambda81__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda83_ (ScratchFolderManagerProjectFolderItem* self,
                  ScratchFolderManagerProjectFolderItemVisibleItem* visible_item);
static void ___lambda83__gfunc (gconstpointer data,
                         gpointer self);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void ___lambda78_ (Block14Data* _data14_);
static void ____lambda78__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void __lambda75_ (Block15Data* _data15_,
                  gint response);
static void ___lambda75__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static gint ____lambda76_ (Block15Data* _data15_,
                    const gchar* rel_path,
                    GgitStatusFlags status);
static void scratch_folder_manager_project_folder_item_perform_match (ScratchFolderManagerProjectFolderItem* self,
                                                               GFile* target,
                                                               GRegex* pattern,
                                                               gboolean check_is_text,
                                                               GFileInfo* target_info);
static gint _____lambda76__ggit_status_callback (const gchar* path,
                                          GgitStatusFlags status_flags,
                                          gpointer self);
static void _vala_GgitStatusOptions_free (GgitStatusOptions* self);
static void scratch_folder_manager_project_folder_item_search_folder_children (ScratchFolderManagerProjectFolderItem* self,
                                                                        GFile* start_folder,
                                                                        GRegex* pattern,
                                                                        gboolean recurse_subfolders);
static void scratch_folder_manager_project_folder_item_set_monitored_repo (ScratchFolderManagerProjectFolderItem* self,
                                                                    ScratchServicesMonitoredRepository* value);
static GgitRepository* scratch_folder_manager_project_folder_item_get_git_repo (ScratchFolderManagerProjectFolderItem* self);
static ScratchServicesMonitoredRepository* scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (ScratchFolderManagerProjectFolderItemChangeBranchMenu* self);
static ScratchFolderManagerProjectFolderItem* scratch_folder_manager_project_folder_item_change_branch_menu_get_project_folder (ScratchFolderManagerProjectFolderItemChangeBranchMenu* self);
static void scratch_folder_manager_project_folder_item_change_branch_menu_set_project_folder (ScratchFolderManagerProjectFolderItemChangeBranchMenu* self,
                                                                                       ScratchFolderManagerProjectFolderItem* value);
static GObject * scratch_folder_manager_project_folder_item_change_branch_menu_constructor (GType type,
                                                                                     guint n_construct_properties,
                                                                                     GObjectConstructParam * construct_properties);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void _scratch_folder_manager_project_folder_item_change_branch_menu_____lambda94_ (Block16Data* _data16_);
static void __scratch_folder_manager_project_folder_item_change_branch_menu_____lambda94__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                                                                gpointer self);
static GVariant* _variant_new10 (gchar* value);
static void scratch_folder_manager_project_folder_item_change_branch_menu_finalize (GObject * obj);
static GType scratch_folder_manager_project_folder_item_change_branch_menu_get_type_once (void);
static void _vala_scratch_folder_manager_project_folder_item_change_branch_menu_get_property (GObject * object,
                                                                                       guint property_id,
                                                                                       GValue * value,
                                                                                       GParamSpec * pspec);
static void _vala_scratch_folder_manager_project_folder_item_change_branch_menu_set_property (GObject * object,
                                                                                       guint property_id,
                                                                                       const GValue * value,
                                                                                       GParamSpec * pspec);
static GObject * scratch_folder_manager_project_folder_item_constructor (GType type,
                                                                  guint n_construct_properties,
                                                                  GObjectConstructParam * construct_properties);
static void _scratch_folder_manager_project_folder_item_branch_or_name_changed_g_object_notify (GObject* _sender,
                                                                                         GParamSpec* pspec,
                                                                                         gpointer self);
static void _scratch_folder_manager_project_folder_item_branch_or_name_changed_scratch_services_monitored_repository_branch_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                              gpointer self);
static void _scratch_folder_manager_project_folder_item_deprioritize_git_ignored_scratch_services_monitored_repository_ignored_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                                 gpointer self);
static void _scratch_folder_manager_project_folder_item____lambda95_ (ScratchFolderManagerProjectFolderItem* self);
static void __scratch_folder_manager_project_folder_item____lambda95__scratch_services_monitored_repository_file_status_change (ScratchServicesMonitoredRepository* _sender,
                                                                                                                         gpointer self);
static void scratch_folder_manager_project_folder_item_finalize (GObject * obj);
static GType scratch_folder_manager_project_folder_item_get_type_once (void);
static void _vala_scratch_folder_manager_project_folder_item_get_property (GObject * object,
                                                                    guint property_id,
                                                                    GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_scratch_folder_manager_project_folder_item_set_property (GObject * object,
                                                                    guint property_id,
                                                                    const GValue * value,
                                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
scratch_folder_manager_project_folder_item_get_instance_private (ScratchFolderManagerProjectFolderItem* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerProjectFolderItem_private_offset);
}

static void
_scratch_folder_manager_project_folder_item_visible_item_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (scratch_folder_manager_project_folder_item_visible_item_free (var), NULL));
}

static inline void
_g_list_free__scratch_folder_manager_project_folder_item_visible_item_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _scratch_folder_manager_project_folder_item_visible_item_free0_);
}

ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_project_folder_item_construct (GType object_type,
                                                      ScratchFolderManagerFile* file,
                                                      ScratchFolderManagerFileView* view)
{
	ScratchFolderManagerProjectFolderItem * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	_vala_return_val_if_fail (scratch_folder_manager_file_is_valid_directory, "file.is_valid_directory", NULL);
	self = (ScratchFolderManagerProjectFolderItem*) g_object_new (object_type, "file", file, "view", view, NULL);
	return self;
}

ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_project_folder_item_new (ScratchFolderManagerFile* file,
                                                ScratchFolderManagerFileView* view)
{
	return scratch_folder_manager_project_folder_item_construct (SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, file, view);
}

static void
scratch_folder_manager_project_folder_item_branch_or_name_changed (ScratchFolderManagerProjectFolderItem* self)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	if (_tmp0_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->_monitored_repo;
		_tmp2_ = scratch_services_monitored_repository_get_head_is_branch (_tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			ScratchServicesMonitoredRepository* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp4_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) self);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->priv->_monitored_repo;
			_tmp7_ = scratch_services_monitored_repository_get_branch_name (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strdup_printf ("%s <span size='small' weight='normal'>%s</span>", _tmp5_, _tmp8_);
			_tmp10_ = _tmp9_;
			granite_widgets_source_list_item_set_markup ((GraniteWidgetsSourceListItem*) self, _tmp10_);
			_g_free0 (_tmp10_);
		} else {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			ScratchServicesMonitoredRepository* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp11_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->_monitored_repo;
			_tmp14_ = scratch_services_monitored_repository_get_branch_name (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strdup_printf ("%s <span size='small' weight='normal' style='italic'>%s</span>", _tmp12_, _tmp15_);
			_tmp17_ = _tmp16_;
			granite_widgets_source_list_item_set_markup ((GraniteWidgetsSourceListItem*) self, _tmp17_);
			_g_free0 (_tmp17_);
		}
	}
}

static void
scratch_folder_manager_project_folder_item_real_on_changed (ScratchFolderManagerFolderItem* base,
                                                            GFile* source,
                                                            GFile* dest,
                                                            GFileMonitorEvent event)
{
	ScratchFolderManagerProjectFolderItem * self;
	gboolean _tmp0_ = FALSE;
	ScratchFolderManagerFile* _tmp1_;
	ScratchFolderManagerFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	self = (ScratchFolderManagerProjectFolderItem*) base;
	g_return_if_fail (source != NULL);
	_tmp1_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = scratch_folder_manager_file_get_file (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_file_equal (source, _tmp4_)) {
		_tmp0_ = event == G_FILE_MONITOR_EVENT_DELETED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL], 0);
	} else {
		SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_CLASS (scratch_folder_manager_project_folder_item_parent_class)->on_changed (G_TYPE_CHECK_INSTANCE_CAST (self, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem), source, dest, event);
	}
}

void
scratch_folder_manager_project_folder_item_child_folder_changed (ScratchFolderManagerProjectFolderItem* self,
                                                                 ScratchFolderManagerFolderItem* folder)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	if (_tmp0_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp1_;
		_tmp1_ = self->priv->_monitored_repo;
		scratch_services_monitored_repository_update_status_map (_tmp1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_scratch_folder_manager_project_folder_item_visible_item_dup0 (gpointer self)
{
	return self ? scratch_folder_manager_project_folder_item_visible_item_dup (self) : NULL;
}

void
scratch_folder_manager_project_folder_item_child_folder_loaded (ScratchFolderManagerProjectFolderItem* self,
                                                                ScratchFolderManagerFolderItem* folder)
{
	ScratchServicesMonitoredRepository* _tmp31_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	{
		GeeIterator* _child_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = granite_widgets_source_list_expandable_item_get_children ((GraniteWidgetsSourceListExpandableItem*) folder);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_child_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GraniteWidgetsSourceListItem* _tmp8_;
			_tmp5_ = _child_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _child_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			child = (GraniteWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = child;
			if (SCRATCH_FOLDER_MANAGER_IS_ITEM (_tmp8_)) {
				ScratchFolderManagerItem* item = NULL;
				GraniteWidgetsSourceListItem* _tmp9_;
				ScratchFolderManagerItem* _tmp10_;
				gchar* rel_path = NULL;
				ScratchFolderManagerFile* _tmp11_;
				ScratchFolderManagerFile* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				ScratchFolderManagerItem* _tmp15_;
				ScratchFolderManagerFile* _tmp16_;
				ScratchFolderManagerFile* _tmp17_;
				GFile* _tmp18_;
				GFile* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp21_ = FALSE;
				const gchar* _tmp22_;
				_tmp9_ = child;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
				item = _tmp10_;
				_tmp11_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
				_tmp12_ = _tmp11_;
				_tmp13_ = scratch_folder_manager_file_get_file (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = item;
				_tmp16_ = scratch_folder_manager_item_get_file (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = scratch_folder_manager_file_get_file (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_file_get_relative_path (_tmp14_, _tmp19_);
				rel_path = _tmp20_;
				_tmp22_ = rel_path;
				if (_tmp22_ != NULL) {
					const gchar* _tmp23_;
					_tmp23_ = rel_path;
					_tmp21_ = g_strcmp0 (_tmp23_, "") != 0;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					const gchar* _tmp24_;
					gchar* _tmp25_;
					ScratchFolderManagerItem* _tmp26_;
					ScratchFolderManagerItem* _tmp27_;
					ScratchFolderManagerProjectFolderItemVisibleItem _tmp28_ = {0};
					ScratchFolderManagerProjectFolderItemVisibleItem _tmp29_;
					ScratchFolderManagerProjectFolderItemVisibleItem* _tmp30_;
					_tmp24_ = rel_path;
					_tmp25_ = g_strdup (_tmp24_);
					_tmp26_ = item;
					_tmp27_ = _g_object_ref0 (_tmp26_);
					_g_free0 (_tmp28_.rel_path);
					_tmp28_.rel_path = _tmp25_;
					_g_object_unref0 (_tmp28_.item);
					_tmp28_.item = _tmp27_;
					_tmp29_ = _tmp28_;
					_tmp30_ = _scratch_folder_manager_project_folder_item_visible_item_dup0 (&_tmp29_);
					self->priv->visible_item_list = g_list_prepend (self->priv->visible_item_list, _tmp30_);
					scratch_folder_manager_project_folder_item_visible_item_destroy (&_tmp29_);
				}
				_g_free0 (rel_path);
				_g_object_unref0 (item);
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp31_ = self->priv->_monitored_repo;
	if (_tmp31_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp32_;
		_tmp32_ = self->priv->_monitored_repo;
		scratch_services_monitored_repository_update_status_map (_tmp32_);
		scratch_folder_manager_project_folder_item_update_item_status (self, folder);
		scratch_folder_manager_project_folder_item_deprioritize_git_ignored (self);
	}
}

static void
__lambda91_ (ScratchFolderManagerProjectFolderItem* self)
{
	g_signal_emit (self, scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL], 0);
}

static void
___lambda91__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda91_ ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
__lambda92_ (ScratchFolderManagerProjectFolderItem* self)
{
	g_signal_emit (self, scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSE_ALL_EXCEPT_SIGNAL], 0);
}

static void
___lambda92__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda92_ ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
__lambda93_ (ScratchFolderManagerProjectFolderItem* self)
{
	g_signal_emit (self, scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL], 0);
	scratch_folder_manager_item_trash ((ScratchFolderManagerItem*) self);
}

static void
___lambda93__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda93_ ((ScratchFolderManagerProjectFolderItem*) self);
}

static GtkMenu*
scratch_folder_manager_project_folder_item_real_get_context_menu (GraniteWidgetsSourceListItem* base)
{
	ScratchFolderManagerProjectFolderItem * self;
	GraniteAccelLabel* open_in_terminal_pane_label = NULL;
	GraniteAccelLabel* _tmp0_;
	GtkMenuItem* open_in_terminal_pane_item = NULL;
	gchar* _tmp1_;
	ScratchFolderManagerFile* _tmp2_;
	ScratchFolderManagerFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GVariant* _tmp8_;
	GtkMenuItem* _tmp9_ = NULL;
	GtkMenuItem* _tmp10_;
	GtkMenuItem* close_folder_item = NULL;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* close_all_except_item = NULL;
	GtkMenuItem* _tmp12_;
	ScratchFolderManagerFileView* _tmp13_;
	ScratchFolderManagerFileView* _tmp14_;
	GraniteWidgetsSourceListExpandableItem* _tmp15_;
	GraniteWidgetsSourceListExpandableItem* _tmp16_;
	GeeCollection* _tmp17_;
	GeeCollection* _tmp18_;
	GeeCollection* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	guint n_open = 0U;
	ScratchServicesDocumentManager* _tmp22_;
	ScratchServicesDocumentManager* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	guint _tmp27_;
	gchar* open_text = NULL;
	gchar* _tmp28_;
	GraniteAccelLabel* close_accellabel = NULL;
	GraniteAccelLabel* _tmp29_;
	GtkMenuItem* close_item = NULL;
	gchar* _tmp30_;
	ScratchFolderManagerFile* _tmp31_;
	ScratchFolderManagerFile* _tmp32_;
	GFile* _tmp33_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GVariant* _tmp37_;
	GtkMenuItem* _tmp38_ = NULL;
	GtkMenuItem* _tmp39_;
	gchar* hide_text = NULL;
	gchar* _tmp40_;
	GraniteAccelLabel* hide_accellabel = NULL;
	GraniteAccelLabel* _tmp41_;
	GtkMenuItem* hide_item = NULL;
	gchar* _tmp42_;
	ScratchFolderManagerFile* _tmp43_;
	ScratchFolderManagerFile* _tmp44_;
	GFile* _tmp45_;
	GFile* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GVariant* _tmp49_;
	GtkMenuItem* _tmp50_ = NULL;
	GtkMenuItem* _tmp51_;
	guint n_restorable = 0U;
	ScratchServicesDocumentManager* _tmp52_;
	ScratchServicesDocumentManager* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	guint _tmp57_;
	gchar* restore_text = NULL;
	gchar* _tmp58_;
	GraniteAccelLabel* restore_accellabel = NULL;
	GraniteAccelLabel* _tmp59_;
	GtkMenuItem* restore_item = NULL;
	gchar* _tmp60_;
	ScratchFolderManagerFile* _tmp61_;
	ScratchFolderManagerFile* _tmp62_;
	GFile* _tmp63_;
	GFile* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	GVariant* _tmp67_;
	GtkMenuItem* _tmp68_ = NULL;
	GtkMenuItem* _tmp69_;
	GtkMenuItem* delete_item = NULL;
	GtkMenuItem* _tmp70_;
	GraniteAccelLabel* search_accellabel = NULL;
	GraniteAccelLabel* _tmp71_;
	GtkMenuItem* search_item = NULL;
	gchar* _tmp72_;
	ScratchFolderManagerFile* _tmp73_;
	ScratchFolderManagerFile* _tmp74_;
	GFile* _tmp75_;
	GFile* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	GVariant* _tmp79_;
	GtkMenuItem* _tmp80_ = NULL;
	GtkMenuItem* _tmp81_;
	GFileInfo* info = NULL;
	const gchar* file_type = NULL;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp93_;
	GtkMenu* _tmp94_;
	GtkMenu* _tmp95_;
	GFileInfo* _tmp96_;
	const gchar* _tmp97_;
	GtkMenuItem* _tmp98_;
	GtkMenuItem* _tmp99_;
	GtkMenu* _tmp100_;
	GtkSeparatorMenuItem* _tmp101_;
	GtkSeparatorMenuItem* _tmp102_;
	GtkMenu* _tmp103_;
	GtkMenuItem* _tmp104_;
	GtkMenuItem* _tmp105_;
	ScratchServicesMonitoredRepository* _tmp106_;
	GtkMenu* _tmp113_;
	GtkSeparatorMenuItem* _tmp114_;
	GtkSeparatorMenuItem* _tmp115_;
	GtkMenu* _tmp116_;
	GtkMenu* _tmp117_;
	GtkMenu* _tmp118_;
	GtkSeparatorMenuItem* _tmp119_;
	GtkSeparatorMenuItem* _tmp120_;
	GtkMenu* _tmp127_;
	GtkMenu* _tmp128_;
	GtkSeparatorMenuItem* _tmp129_;
	GtkSeparatorMenuItem* _tmp130_;
	GtkMenu* _tmp131_;
	GtkMenu* _tmp132_;
	GError* _inner_error0_ = NULL;
	GtkMenu* result;
	self = (ScratchFolderManagerProjectFolderItem*) base;
	_tmp0_ = granite_accel_label_new_from_action_name (_ ("Open in Terminal Pane"), SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_OPEN_IN_TERMINAL "::");
	g_object_ref_sink (_tmp0_);
	open_in_terminal_pane_label = _tmp0_;
	_tmp1_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_OPEN_IN_TERMINAL);
	_tmp2_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = scratch_folder_manager_file_get_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_file_get_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_variant_new_string (_tmp7_);
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp9_, _tmp1_);
	_g_free0 (_tmp1_);
	g_object_set ((GtkActionable*) _tmp9_, "action-target", _tmp8_, NULL);
	_g_variant_unref0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp7_);
	open_in_terminal_pane_item = _tmp10_;
	gtk_container_add ((GtkContainer*) open_in_terminal_pane_item, (GtkWidget*) open_in_terminal_pane_label);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Close Folder"));
	g_object_ref_sink (_tmp11_);
	close_folder_item = _tmp11_;
	g_signal_connect_object (close_folder_item, "activate", (GCallback) ___lambda91__gtk_menu_item_activate, self, 0);
	_tmp12_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Close Other Folders"));
	g_object_ref_sink (_tmp12_);
	close_all_except_item = _tmp12_;
	g_signal_connect_object (close_all_except_item, "activate", (GCallback) ___lambda92__gtk_menu_item_activate, self, 0);
	_tmp13_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp14_ = _tmp13_;
	_tmp15_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = granite_widgets_source_list_expandable_item_get_children (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = gee_collection_get_size (_tmp19_);
	_tmp21_ = _tmp20_;
	gtk_widget_set_sensitive ((GtkWidget*) close_all_except_item, _tmp21_ > 1);
	_g_object_unref0 (_tmp19_);
	_tmp22_ = scratch_services_document_manager_get_instance ();
	_tmp23_ = _tmp22_;
	_tmp24_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp27_ = scratch_services_document_manager_open_for_project (_tmp23_, _tmp26_);
	_g_free0 (_tmp26_);
	_g_object_unref0 (_tmp23_);
	n_open = _tmp27_;
	_tmp28_ = g_strdup_printf (ngettext ("Close %u Open Document", "Close %u Open Documents", (gulong) n_open), n_open);
	open_text = _tmp28_;
	_tmp29_ = granite_accel_label_new_from_action_name (open_text, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS "::");
	g_object_ref_sink (_tmp29_);
	close_accellabel = _tmp29_;
	_tmp30_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS);
	_tmp31_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp32_ = _tmp31_;
	_tmp33_ = scratch_folder_manager_file_get_file (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_file_get_path (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_variant_new_string (_tmp36_);
	g_variant_ref_sink (_tmp37_);
	_tmp38_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp38_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_set ((GtkActionable*) _tmp38_, "action-target", _tmp37_, NULL);
	_g_variant_unref0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	_tmp39_ = _tmp38_;
	_g_free0 (_tmp36_);
	close_item = _tmp39_;
	gtk_container_add ((GtkContainer*) close_item, (GtkWidget*) close_accellabel);
	_tmp40_ = g_strdup_printf (ngettext ("Hide %u Open Document", "Hide %u Open Documents", (gulong) n_open), n_open);
	hide_text = _tmp40_;
	_tmp41_ = granite_accel_label_new_from_action_name (hide_text, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_HIDE_PROJECT_DOCS "::");
	g_object_ref_sink (_tmp41_);
	hide_accellabel = _tmp41_;
	_tmp42_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_HIDE_PROJECT_DOCS);
	_tmp43_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = scratch_folder_manager_file_get_file (_tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = g_file_get_path (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = g_variant_new_string (_tmp48_);
	g_variant_ref_sink (_tmp49_);
	_tmp50_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp50_, _tmp42_);
	_g_free0 (_tmp42_);
	g_object_set ((GtkActionable*) _tmp50_, "action-target", _tmp49_, NULL);
	_g_variant_unref0 (_tmp49_);
	g_object_ref_sink (_tmp50_);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp48_);
	hide_item = _tmp51_;
	gtk_container_add ((GtkContainer*) hide_item, (GtkWidget*) hide_accellabel);
	_tmp52_ = scratch_services_document_manager_get_instance ();
	_tmp53_ = _tmp52_;
	_tmp54_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) self);
	_tmp55_ = _tmp54_;
	_tmp56_ = _tmp55_;
	_tmp57_ = scratch_services_document_manager_restorable_for_project (_tmp53_, _tmp56_);
	_g_free0 (_tmp56_);
	_g_object_unref0 (_tmp53_);
	n_restorable = _tmp57_;
	_tmp58_ = g_strdup_printf (ngettext ("Restore %u Hidden Document", "Restore %u Hidden Documents", (gulong) n_restorable), n_restorable);
	restore_text = _tmp58_;
	_tmp59_ = granite_accel_label_new_from_action_name (restore_text, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_RESTORE_PROJECT_DOCS "::");
	g_object_ref_sink (_tmp59_);
	restore_accellabel = _tmp59_;
	_tmp60_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_RESTORE_PROJECT_DOCS);
	_tmp61_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp62_ = _tmp61_;
	_tmp63_ = scratch_folder_manager_file_get_file (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = g_file_get_path (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = g_variant_new_string (_tmp66_);
	g_variant_ref_sink (_tmp67_);
	_tmp68_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp68_, _tmp60_);
	_g_free0 (_tmp60_);
	g_object_set ((GtkActionable*) _tmp68_, "action-target", _tmp67_, NULL);
	_g_variant_unref0 (_tmp67_);
	g_object_ref_sink (_tmp68_);
	_tmp69_ = _tmp68_;
	_g_free0 (_tmp66_);
	restore_item = _tmp69_;
	gtk_container_add ((GtkContainer*) restore_item, (GtkWidget*) restore_accellabel);
	_tmp70_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Move to Trash"));
	g_object_ref_sink (_tmp70_);
	delete_item = _tmp70_;
	g_signal_connect_object (delete_item, "activate", (GCallback) ___lambda93__gtk_menu_item_activate, self, 0);
	_tmp71_ = granite_accel_label_new_from_action_name (_ ("Find in Project…"), SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND_GLOBAL "::");
	g_object_ref_sink (_tmp71_);
	search_accellabel = _tmp71_;
	_tmp72_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND_GLOBAL);
	_tmp73_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = scratch_folder_manager_file_get_file (_tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = g_file_get_path (_tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = g_variant_new_string (_tmp78_);
	g_variant_ref_sink (_tmp79_);
	_tmp80_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp80_, _tmp72_);
	_g_free0 (_tmp72_);
	g_object_set ((GtkActionable*) _tmp80_, "action-target", _tmp79_, NULL);
	_g_variant_unref0 (_tmp79_);
	g_object_ref_sink (_tmp80_);
	_tmp81_ = _tmp80_;
	_g_free0 (_tmp78_);
	search_item = _tmp81_;
	gtk_container_add ((GtkContainer*) search_item, (GtkWidget*) search_accellabel);
	info = NULL;
	file_type = NULL;
	{
		GFileInfo* _tmp82_ = NULL;
		ScratchFolderManagerFile* _tmp83_;
		ScratchFolderManagerFile* _tmp84_;
		GFile* _tmp85_;
		GFile* _tmp86_;
		GFileInfo* _tmp87_;
		GFileInfo* _tmp88_;
		GFileInfo* _tmp89_;
		const gchar* _tmp90_;
		_tmp83_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
		_tmp84_ = _tmp83_;
		_tmp85_ = scratch_folder_manager_file_get_file (_tmp84_);
		_tmp86_ = _tmp85_;
		_tmp87_ = g_file_query_info (_tmp86_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp82_ = _tmp87_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp88_ = _tmp82_;
		_tmp82_ = NULL;
		_g_object_unref0 (info);
		info = _tmp88_;
		_tmp89_ = info;
		_tmp90_ = g_file_info_get_content_type (_tmp89_);
		file_type = _tmp90_;
		_g_object_unref0 (_tmp82_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp91_;
		const gchar* _tmp92_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp91_ = e;
		_tmp92_ = _tmp91_->message;
		g_warning ("ProjectFolderItem.vala:205: %s", _tmp92_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (search_item);
		_g_object_unref0 (search_accellabel);
		_g_object_unref0 (delete_item);
		_g_object_unref0 (restore_item);
		_g_object_unref0 (restore_accellabel);
		_g_free0 (restore_text);
		_g_object_unref0 (hide_item);
		_g_object_unref0 (hide_accellabel);
		_g_free0 (hide_text);
		_g_object_unref0 (close_item);
		_g_object_unref0 (close_accellabel);
		_g_free0 (open_text);
		_g_object_unref0 (close_all_except_item);
		_g_object_unref0 (close_folder_item);
		_g_object_unref0 (open_in_terminal_pane_item);
		_g_object_unref0 (open_in_terminal_pane_label);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp93_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp93_);
	menu = _tmp93_;
	_tmp94_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp94_, open_in_terminal_pane_item);
	_tmp95_ = menu;
	_tmp96_ = info;
	_tmp97_ = file_type;
	_tmp98_ = scratch_folder_manager_folder_item_create_submenu_for_open_in ((ScratchFolderManagerFolderItem*) self, _tmp96_, _tmp97_);
	_tmp99_ = _tmp98_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp95_, _tmp99_);
	_g_object_unref0 (_tmp99_);
	_tmp100_ = menu;
	_tmp101_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp101_);
	_tmp102_ = _tmp101_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp100_, (GtkMenuItem*) _tmp102_);
	_g_object_unref0 (_tmp102_);
	_tmp103_ = menu;
	_tmp104_ = scratch_folder_manager_folder_item_create_submenu_for_new ((ScratchFolderManagerFolderItem*) self);
	_tmp105_ = _tmp104_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp103_, _tmp105_);
	_g_object_unref0 (_tmp105_);
	_tmp106_ = self->priv->_monitored_repo;
	if (_tmp106_ != NULL) {
		ScratchFolderManagerProjectFolderItemChangeBranchMenu* branch_menu = NULL;
		ScratchServicesMonitoredRepository* _tmp107_;
		gboolean _tmp108_;
		gboolean _tmp109_;
		ScratchFolderManagerProjectFolderItemChangeBranchMenu* _tmp110_ = NULL;
		GtkMenu* _tmp111_;
		ScratchFolderManagerProjectFolderItemChangeBranchMenu* _tmp112_;
		_tmp107_ = self->priv->_monitored_repo;
		_tmp108_ = scratch_services_monitored_repository_get_has_uncommitted (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = scratch_folder_manager_project_folder_item_change_branch_menu_new (self);
		gtk_widget_set_sensitive ((GtkWidget*) _tmp110_, !_tmp109_);
		g_object_ref_sink (_tmp110_);
		branch_menu = _tmp110_;
		_tmp111_ = menu;
		_tmp112_ = branch_menu;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp111_, (GtkMenuItem*) _tmp112_);
		_g_object_unref0 (branch_menu);
	}
	_tmp113_ = menu;
	_tmp114_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp114_);
	_tmp115_ = _tmp114_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp113_, (GtkMenuItem*) _tmp115_);
	_g_object_unref0 (_tmp115_);
	_tmp116_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp116_, close_folder_item);
	_tmp117_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp117_, close_all_except_item);
	_tmp118_ = menu;
	_tmp119_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp119_);
	_tmp120_ = _tmp119_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp118_, (GtkMenuItem*) _tmp120_);
	_g_object_unref0 (_tmp120_);
	if (n_restorable > ((guint) 0)) {
		GtkMenu* _tmp121_;
		_tmp121_ = menu;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp121_, restore_item);
	}
	if (n_open > ((guint) 0)) {
		GtkMenu* _tmp122_;
		GtkMenu* _tmp123_;
		_tmp122_ = menu;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp122_, hide_item);
		_tmp123_ = menu;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp123_, close_item);
	}
	if ((n_restorable + n_open) > ((guint) 1)) {
		GtkMenu* _tmp124_;
		GtkSeparatorMenuItem* _tmp125_;
		GtkSeparatorMenuItem* _tmp126_;
		_tmp124_ = menu;
		_tmp125_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp125_);
		_tmp126_ = _tmp125_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp124_, (GtkMenuItem*) _tmp126_);
		_g_object_unref0 (_tmp126_);
	}
	_tmp127_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp127_, delete_item);
	_tmp128_ = menu;
	_tmp129_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp129_);
	_tmp130_ = _tmp129_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp128_, (GtkMenuItem*) _tmp130_);
	_g_object_unref0 (_tmp130_);
	_tmp131_ = menu;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp131_, search_item);
	_tmp132_ = menu;
	gtk_widget_show_all ((GtkWidget*) _tmp132_);
	result = menu;
	_g_object_unref0 (info);
	_g_object_unref0 (search_item);
	_g_object_unref0 (search_accellabel);
	_g_object_unref0 (delete_item);
	_g_object_unref0 (restore_item);
	_g_object_unref0 (restore_accellabel);
	_g_free0 (restore_text);
	_g_object_unref0 (hide_item);
	_g_object_unref0 (hide_accellabel);
	_g_free0 (hide_text);
	_g_object_unref0 (close_item);
	_g_object_unref0 (close_accellabel);
	_g_free0 (open_text);
	_g_object_unref0 (close_all_except_item);
	_g_object_unref0 (close_folder_item);
	_g_object_unref0 (open_in_terminal_pane_item);
	_g_object_unref0 (open_in_terminal_pane_label);
	return result;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data12_->self;
		_g_free0 (_data12_->start_path);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data13_->_data12_->self;
		_g_object_unref0 (_data13_->item);
		_scratch_folder_manager_project_folder_item_visible_item_free0 (_data13_->visible_item);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static gboolean
__lambda82_ (Block13Data* _data13_,
             GeeMapEntry* entry)
{
	Block12Data* _data12_;
	ScratchFolderManagerProjectFolderItem* self;
	gboolean match = FALSE;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_key (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = (*_data13_->visible_item).rel_path;
	match = g_str_has_prefix ((const gchar*) _tmp1_, _tmp2_);
	if (match) {
		gconstpointer _tmp3_;
		gconstpointer _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ScratchFolderManagerItem* _tmp7_;
		gboolean _tmp14_ = FALSE;
		ScratchFolderManagerItem* _tmp15_;
		_tmp3_ = gee_map_entry_get_value (entry);
		_tmp4_ = _tmp3_;
		_data12_->is_new = ((*((GgitStatusFlags*) _tmp4_)) & (GGIT_STATUS_WORKING_TREE_NEW | GGIT_STATUS_INDEX_NEW)) > 0;
		_tmp7_ = _data13_->item;
		if (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp7_)) {
			_tmp6_ = _data12_->is_new;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ScratchFolderManagerItem* _tmp8_;
			GIcon* _tmp9_;
			GIcon* _tmp10_;
			_tmp8_ = _data13_->item;
			_tmp9_ = granite_widgets_source_list_item_get_activatable ((GraniteWidgetsSourceListItem*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp5_ = _tmp10_ == NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ScratchFolderManagerItem* _tmp11_;
			GIcon* _tmp12_;
			ScratchFolderManagerItem* _tmp13_;
			_tmp11_ = _data13_->item;
			_tmp12_ = scratch_folder_manager_project_folder_item_added_icon;
			granite_widgets_source_list_item_set_activatable ((GraniteWidgetsSourceListItem*) _tmp11_, _tmp12_);
			_tmp13_ = _data13_->item;
			granite_widgets_source_list_item_set_activatable_tooltip ((GraniteWidgetsSourceListItem*) _tmp13_, _ ("New"));
			result = TRUE;
			_g_object_unref0 (entry);
			return result;
		}
		_tmp15_ = _data13_->item;
		if (!SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp15_)) {
			_tmp14_ = TRUE;
		} else {
			ScratchFolderManagerItem* _tmp16_;
			gboolean _tmp17_;
			gboolean _tmp18_;
			_tmp16_ = _data13_->item;
			_tmp17_ = granite_widgets_source_list_expandable_item_get_expanded ((GraniteWidgetsSourceListExpandableItem*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp14_ = !_tmp18_;
		}
		if (_tmp14_) {
			GIcon* _tmp19_ = NULL;
			ScratchFolderManagerItem* _tmp22_;
			const gchar* _tmp23_ = NULL;
			ScratchFolderManagerItem* _tmp24_;
			if (_data12_->is_new) {
				GIcon* _tmp20_;
				_tmp20_ = scratch_folder_manager_project_folder_item_added_icon;
				_tmp19_ = _tmp20_;
			} else {
				GIcon* _tmp21_;
				_tmp21_ = scratch_folder_manager_project_folder_item_modified_icon;
				_tmp19_ = _tmp21_;
			}
			_tmp22_ = _data13_->item;
			granite_widgets_source_list_item_set_activatable ((GraniteWidgetsSourceListItem*) _tmp22_, _tmp19_);
			if (_data12_->is_new) {
				_tmp23_ = _ ("New");
			} else {
				_tmp23_ = _ ("Modified");
			}
			_tmp24_ = _data13_->item;
			granite_widgets_source_list_item_set_activatable_tooltip ((GraniteWidgetsSourceListItem*) _tmp24_, _tmp23_);
		}
		result = FALSE;
		_g_object_unref0 (entry);
		return result;
	} else {
		result = TRUE;
		_g_object_unref0 (entry);
		return result;
	}
}

static gboolean
___lambda82__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda82_ (self, (GeeMapEntry*) g);
	return result;
}

static void
__lambda81_ (Block12Data* _data12_,
             ScratchFolderManagerProjectFolderItemVisibleItem* visible_item)
{
	ScratchFolderManagerProjectFolderItem* self;
	Block13Data* _data13_;
	ScratchFolderManagerProjectFolderItemVisibleItem* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ScratchFolderManagerItem* _tmp3_;
	ScratchFolderManagerItem* _tmp4_;
	ScratchFolderManagerItem* _tmp5_;
	ScratchServicesMonitoredRepository* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeSet* _tmp9_;
	self = _data12_->self;
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->_data12_ = block12_data_ref (_data12_);
	_tmp0_ = _scratch_folder_manager_project_folder_item_visible_item_dup0 (visible_item);
	_scratch_folder_manager_project_folder_item_visible_item_free0 (_data13_->visible_item);
	_data13_->visible_item = _tmp0_;
	_tmp1_ = _data12_->start_path;
	_tmp2_ = (*_data13_->visible_item).rel_path;
	if (g_str_has_prefix (_tmp1_, _tmp2_)) {
		block13_data_unref (_data13_);
		_data13_ = NULL;
		return;
	}
	_tmp3_ = (*_data13_->visible_item).item;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_data13_->item = _tmp4_;
	_tmp5_ = _data13_->item;
	granite_widgets_source_list_item_set_activatable ((GraniteWidgetsSourceListItem*) _tmp5_, NULL);
	_tmp6_ = self->priv->_monitored_repo;
	_tmp7_ = scratch_services_monitored_repository_get_non_current_entries (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	gee_traversable_foreach ((GeeTraversable*) _tmp9_, ___lambda82__gee_forall_func, _data13_);
	_g_object_unref0 (_tmp9_);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

static void
___lambda81__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda81_ (self, (ScratchFolderManagerProjectFolderItemVisibleItem*) data);
}

void
scratch_folder_manager_project_folder_item_update_item_status (ScratchFolderManagerProjectFolderItem* self,
                                                               ScratchFolderManagerFolderItem* start_folder)
{
	Block12Data* _data12_;
	ScratchServicesMonitoredRepository* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = self->priv->_monitored_repo;
	if (_tmp0_ == NULL) {
		g_debug ("ProjectFolderItem.vala:248: Ignore non-git folders");
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_data12_->is_new = FALSE;
	if (start_folder != NULL) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) start_folder);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp3_;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp1_);
		_tmp1_ = _tmp4_;
	}
	_tmp5_ = g_strdup (_tmp1_);
	_data12_->start_path = _tmp5_;
	_tmp6_ = self->priv->visible_item_list;
	g_list_foreach (_tmp6_, ___lambda81__gfunc, _data12_);
	_g_free0 (_tmp1_);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

gboolean
scratch_folder_manager_project_folder_item_contains_file (ScratchFolderManagerProjectFolderItem* self,
                                                          GFile* descendant)
{
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (descendant != NULL, FALSE);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_relative_path (_tmp3_, descendant);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_g_free0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static void
__lambda83_ (ScratchFolderManagerProjectFolderItem* self,
             ScratchFolderManagerProjectFolderItemVisibleItem* visible_item)
{
	ScratchFolderManagerItem* item = NULL;
	ScratchFolderManagerItem* _tmp0_;
	ScratchFolderManagerItem* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = (*visible_item).item;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	item = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		ScratchServicesMonitoredRepository* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = (*visible_item).rel_path;
		_tmp2_ = scratch_services_monitored_repository_path_is_ignored (_tmp3_, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp2_) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) item);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_markup_printf_escaped ("<span fgalpha='75&#37;'><i>%s</i></span>", _tmp6_);
			_tmp8_ = _tmp7_;
			granite_widgets_source_list_item_set_markup ((GraniteWidgetsSourceListItem*) item, _tmp8_);
			_g_free0 (_tmp8_);
		} else {
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) item);
			_tmp10_ = _tmp9_;
			granite_widgets_source_list_item_set_markup ((GraniteWidgetsSourceListItem*) item, _tmp10_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) item);
		_tmp12_ = _tmp11_;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("ProjectFolderItem.vala:300: An error occurred while checking if item '" \
"%s' is git-ignored: %s", _tmp12_, _tmp14_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (item);
}

static void
___lambda83__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda83_ ((ScratchFolderManagerProjectFolderItem*) self, (ScratchFolderManagerProjectFolderItemVisibleItem*) data);
}

static void
scratch_folder_manager_project_folder_item_deprioritize_git_ignored (ScratchFolderManagerProjectFolderItem* self)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	_vala_return_if_fail (_tmp0_ != NULL, "monitored_repo != null");
	_tmp1_ = self->priv->visible_item_list;
	g_list_foreach (_tmp1_, ___lambda83__gfunc, self);
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
___lambda78_ (Block14Data* _data14_)
{
	ScratchFolderManagerProjectFolderItem* self;
	GraniteMessageDialog* _tmp0_;
	self = _data14_->self;
	_tmp0_ = _data14_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda78__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda78_ (self);
}

void
scratch_folder_manager_project_folder_item_new_branch (ScratchFolderManagerProjectFolderItem* self,
                                                       const gchar* branch_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (branch_name != NULL);
	{
		ScratchServicesMonitoredRepository* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = self->priv->_monitored_repo;
		_tmp1_ = scratch_services_monitored_repository_get_head_is_branch (_tmp0_);
		_tmp2_ = _tmp1_;
		if (_tmp2_) {
			ScratchServicesMonitoredRepository* _tmp3_;
			_tmp3_ = self->priv->_monitored_repo;
			scratch_services_monitored_repository_create_new_branch (_tmp3_, branch_name, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_FOUND, "Cannot create a new branch when head is detached");
			_inner_error0_ = _tmp4_;
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block14Data* _data14_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		GThemedIcon* _tmp9_;
		GThemedIcon* _tmp10_;
		GThemedIcon* _tmp11_;
		GraniteMessageDialog* _tmp12_ = NULL;
		GraniteMessageDialog* _tmp13_;
		GraniteMessageDialog* _tmp14_;
		ScratchFolderManagerFileView* _tmp15_;
		ScratchFolderManagerFileView* _tmp16_;
		GtkWidget* _tmp17_;
		GraniteMessageDialog* _tmp18_;
		GraniteMessageDialog* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data14_ = g_slice_new0 (Block14Data);
		_data14_->_ref_count_ = 1;
		_data14_->self = g_object_ref (self);
		_tmp5_ = g_strdup_printf (_ ("Error while creating new branch: “%s”"), branch_name);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = (GThemedIcon*) g_themed_icon_new ("git");
		_tmp10_ = _tmp9_;
		_tmp11_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp12_ = granite_message_dialog_new (_tmp6_, _tmp8_, (GIcon*) _tmp10_, GTK_BUTTONS_CLOSE);
		granite_message_dialog_set_badge_icon (_tmp12_, (GIcon*) _tmp11_);
		_g_object_unref0 (_tmp11_);
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp10_);
		_g_free0 (_tmp6_);
		_data14_->dialog = _tmp13_;
		_tmp14_ = _data14_->dialog;
		_tmp15_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp16_);
		gtk_window_set_transient_for ((GtkWindow*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_window_get_type (), GtkWindow));
		_tmp18_ = _data14_->dialog;
		g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) ____lambda78__gtk_dialog_response, block14_data_ref (_data14_), (GClosureNotify) block14_data_unref, 0);
		_tmp19_ = _data14_->dialog;
		gtk_dialog_run ((GtkDialog*) _tmp19_);
		_g_error_free0 (e);
		block14_data_unref (_data14_);
		_data14_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GList*
scratch_folder_manager_project_folder_item_get_branch_names (ScratchFolderManagerProjectFolderItem* self)
{
	GList* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = scratch_services_monitored_repository_get_local_branches (_tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

gboolean
scratch_folder_manager_project_folder_item_has_local_branch_name (ScratchFolderManagerProjectFolderItem* self,
                                                                  const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp0_ = scratch_services_monitored_repository_has_local_branch_name (_tmp3_, name);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gchar*
scratch_folder_manager_project_folder_item_get_current_branch_name (ScratchFolderManagerProjectFolderItem* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = scratch_services_monitored_repository_get_branch_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = "";
	}
	_tmp6_ = g_strdup (_tmp0_);
	result = _tmp6_;
	return result;
}

gboolean
scratch_folder_manager_project_folder_item_is_valid_new_branch_name (ScratchFolderManagerProjectFolderItem* self,
                                                                     const gchar* new_name)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (new_name != NULL, FALSE);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp0_ = scratch_services_monitored_repository_is_valid_new_local_branch_name (_tmp3_, new_name);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItem* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->dialog);
		_g_regex_unref0 (_data15_->pattern);
		_g_free0 (_data15_->search_term);
		_g_object_unref0 (_data15_->start_folder);
		_g_free0 (_data15_->term);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda75_ (Block15Data* _data15_,
             gint response)
{
	ScratchFolderManagerProjectFolderItem* self;
	ScratchDialogsGlobalSearchDialog* _tmp11_;
	self = _data15_->self;
	switch (response) {
		case GTK_RESPONSE_ACCEPT:
		{
			ScratchDialogsGlobalSearchDialog* _tmp0_;
			const gchar* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			ScratchDialogsGlobalSearchDialog* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			ScratchDialogsGlobalSearchDialog* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp0_ = _data15_->dialog;
			_tmp1_ = scratch_dialogs_global_search_dialog_get_search_term (_tmp0_);
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup (_tmp2_);
			_g_free0 (_data15_->search_term);
			_data15_->search_term = _tmp3_;
			_tmp4_ = _data15_->dialog;
			_tmp5_ = scratch_dialogs_global_search_dialog_get_use_regex (_tmp4_);
			_tmp6_ = _tmp5_;
			_data15_->use_regex = _tmp6_;
			_tmp7_ = _data15_->dialog;
			_tmp8_ = scratch_dialogs_global_search_dialog_get_case_sensitive (_tmp7_);
			_tmp9_ = _tmp8_;
			_data15_->case_sensitive = _tmp9_;
			break;
		}
		default:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup (NULL);
			_g_free0 (_data15_->term);
			_data15_->term = _tmp10_;
			break;
		}
	}
	_tmp11_ = _data15_->dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
}

static void
___lambda75__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda75_ (self, response_id);
}

static gint
____lambda76_ (Block15Data* _data15_,
               const gchar* rel_path,
               GgitStatusFlags status)
{
	ScratchFolderManagerProjectFolderItem* self;
	GFile* target = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint result;
	self = _data15_->self;
	g_return_val_if_fail (rel_path != NULL, 0);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_resolve_relative_path (_tmp3_, rel_path);
	target = _tmp4_;
	if (_data15_->check_is_text) {
		_tmp5_ = g_str_has_prefix (rel_path, "po/");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = 0;
		_g_object_unref0 (target);
		return result;
	}
	if (_data15_->recurse_subfolders) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = target;
		_tmp9_ = g_file_get_relative_path (_data15_->start_folder, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp7_ = _tmp10_ != NULL;
		_g_free0 (_tmp10_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		_tmp11_ = target;
		_tmp12_ = g_file_get_parent (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp6_ = g_file_equal (_data15_->start_folder, _tmp13_);
		_g_object_unref0 (_tmp13_);
	}
	if (_tmp6_) {
		GFile* _tmp14_;
		GRegex* _tmp15_;
		_tmp14_ = target;
		_tmp15_ = _data15_->pattern;
		scratch_folder_manager_project_folder_item_perform_match (self, _tmp14_, _tmp15_, _data15_->check_is_text, NULL);
	}
	result = 0;
	_g_object_unref0 (target);
	return result;
}

static gint
_____lambda76__ggit_status_callback (const gchar* path,
                                     GgitStatusFlags status_flags,
                                     gpointer self)
{
	gint result;
	result = ____lambda76_ (self, path, status_flags);
	return result;
}

static void
_vala_GgitStatusOptions_free (GgitStatusOptions* self)
{
	g_boxed_free (ggit_status_options_get_type (), self);
}

void
scratch_folder_manager_project_folder_item_global_search (ScratchFolderManagerProjectFolderItem* self,
                                                          GFile* start_folder,
                                                          const gchar* term,
                                                          gboolean is_explicit)
{
	Block15Data* _data15_;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gboolean search_tracked_only = FALSE;
	gchar** path_spec = NULL;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint path_spec_length1;
	gint _path_spec_size_;
	gboolean modified_only = FALSE;
	gchar* folder_name = NULL;
	gchar* _tmp4_;
	ScratchFolderManagerFile* _tmp5_;
	ScratchFolderManagerFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gboolean _tmp12_ = FALSE;
	ScratchServicesMonitoredRepository* _tmp13_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	ScratchDialogsGlobalSearchDialog* _tmp19_ = NULL;
	ScratchDialogsGlobalSearchDialog* _tmp20_;
	ScratchDialogsGlobalSearchDialog* _tmp21_;
	const gchar* _tmp22_;
	GgitStatusOption status_scope = 0U;
	GgitStatusOptions* status_options = NULL;
	gchar** _tmp44_;
	gint _tmp44__length1;
	GgitStatusOptions* _tmp45_;
	gboolean _tmp46_ = FALSE;
	ScratchServicesMonitoredRepository* _tmp47_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_folder != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (start_folder);
	_g_object_unref0 (_data15_->start_folder);
	_data15_->start_folder = _tmp0_;
	_tmp1_ = g_strdup (term);
	_g_free0 (_data15_->term);
	_data15_->term = _tmp1_;
	_data15_->search_term = NULL;
	_data15_->use_regex = FALSE;
	search_tracked_only = FALSE;
	_data15_->recurse_subfolders = TRUE;
	_data15_->check_is_text = TRUE;
	_tmp2_ = g_strdup ("*.*");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	path_spec = _tmp3_;
	path_spec_length1 = 1;
	_path_spec_size_ = path_spec_length1;
	modified_only = FALSE;
	_data15_->case_sensitive = FALSE;
	_data15_->pattern = NULL;
	_tmp4_ = g_file_get_basename (_data15_->start_folder);
	folder_name = _tmp4_;
	_tmp5_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = scratch_folder_manager_file_get_file (_tmp6_);
	_tmp8_ = _tmp7_;
	if (g_file_equal (_tmp8_, _data15_->start_folder)) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (folder_name);
		folder_name = _tmp11_;
	}
	_tmp13_ = self->priv->_monitored_repo;
	if (_tmp13_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp14_;
		GgitRepository* _tmp15_;
		GgitRepository* _tmp16_;
		_tmp14_ = self->priv->_monitored_repo;
		_tmp15_ = scratch_services_monitored_repository_get_git_repo (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp12_ = _tmp16_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp17_ = folder_name;
	_tmp18_ = g_strdup (_data15_->term);
	_tmp19_ = scratch_dialogs_global_search_dialog_new (_tmp17_, _tmp12_);
	scratch_dialogs_global_search_dialog_set_case_sensitive (_tmp19_, _data15_->case_sensitive);
	scratch_dialogs_global_search_dialog_set_use_regex (_tmp19_, _data15_->use_regex);
	scratch_dialogs_global_search_dialog_set_search_term (_tmp19_, _tmp18_);
	_g_free0 (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_data15_->dialog = _tmp19_;
	_tmp20_ = _data15_->dialog;
	g_signal_connect_data ((GtkDialog*) _tmp20_, "response", (GCallback) ___lambda75__gtk_dialog_response, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp21_ = _data15_->dialog;
	gtk_dialog_run ((GtkDialog*) _tmp21_);
	_tmp22_ = _data15_->search_term;
	if (_tmp22_ != NULL) {
		GVariant* search_variant = NULL;
		const gchar* _tmp23_;
		GVariant* _tmp24_;
		GtkApplication* app = NULL;
		GApplication* _tmp25_;
		GtkApplication* _tmp26_;
		ScratchMainWindow* win = NULL;
		GtkApplication* _tmp27_;
		GtkWindow* _tmp28_;
		ScratchMainWindow* _tmp29_;
		ScratchMainWindow* _tmp30_;
		GSimpleActionGroup* _tmp31_;
		GSimpleActionGroup* _tmp32_;
		GAction* _tmp33_;
		GVariant* _tmp34_;
		_tmp23_ = _data15_->search_term;
		_tmp24_ = g_variant_new_string (_tmp23_);
		g_variant_ref_sink (_tmp24_);
		search_variant = _tmp24_;
		_tmp25_ = g_application_get_default ();
		_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_application_get_type (), GtkApplication));
		app = _tmp26_;
		_tmp27_ = app;
		_tmp28_ = gtk_application_get_active_window (_tmp27_);
		_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindow));
		win = _tmp29_;
		_tmp30_ = win;
		_tmp31_ = scratch_main_window_get_actions (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_action_map_lookup_action ((GActionMap*) _tmp32_, "action_find");
		_tmp34_ = search_variant;
		g_action_activate (_tmp33_, _tmp34_);
		if (!_data15_->use_regex) {
			const gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp35_ = _data15_->search_term;
			_tmp36_ = g_regex_escape_string (_tmp35_, -1);
			_g_free0 (_data15_->search_term);
			_data15_->search_term = _tmp36_;
		}
		{
			GRegexCompileFlags flags = 0U;
			GRegex* _tmp37_ = NULL;
			const gchar* _tmp38_;
			GRegex* _tmp39_;
			GRegex* _tmp40_;
			flags = G_REGEX_MULTILINE;
			if (!_data15_->case_sensitive) {
				flags |= G_REGEX_CASELESS;
			}
			_tmp38_ = _data15_->search_term;
			_tmp39_ = g_regex_new (_tmp38_, flags, 0, &_inner_error0_);
			_tmp37_ = _tmp39_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp40_ = _tmp37_;
			_tmp37_ = NULL;
			_g_regex_unref0 (_data15_->pattern);
			_data15_->pattern = _tmp40_;
			_g_regex_unref0 (_tmp37_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp41_;
			GError* _tmp42_;
			const gchar* _tmp43_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp41_ = _data15_->search_term;
			_tmp42_ = e;
			_tmp43_ = _tmp42_->message;
			g_critical ("ProjectFolderItem.vala:413: Error creating regex from '%s': %s", _tmp41_, _tmp43_);
			_g_error_free0 (e);
			_g_object_unref0 (win);
			_g_object_unref0 (app);
			_g_variant_unref0 (search_variant);
			_g_free0 (folder_name);
			path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (win);
			_g_object_unref0 (app);
			_g_variant_unref0 (search_variant);
			_g_free0 (folder_name);
			path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_object_unref0 (win);
		_g_object_unref0 (app);
		_g_variant_unref0 (search_variant);
	} else {
		_g_free0 (folder_name);
		path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
		block15_data_unref (_data15_);
		_data15_ = NULL;
		return;
	}
	status_scope = GGIT_STATUS_OPTION_DEFAULT;
	if (!modified_only) {
		status_scope |= GGIT_STATUS_OPTION_INCLUDE_UNMODIFIED;
	}
	if (!search_tracked_only) {
		status_scope |= GGIT_STATUS_OPTION_INCLUDE_UNTRACKED;
	}
	_tmp44_ = path_spec;
	_tmp44__length1 = path_spec_length1;
	_tmp45_ = ggit_status_options_new (status_scope, GGIT_STATUS_SHOW_WORKDIR_ONLY, _tmp44_);
	status_options = _tmp45_;
	scratch_folder_manager_folder_item_remove_all_badges ((ScratchFolderManagerFolderItem*) self);
	granite_widgets_source_list_expandable_item_collapse_all ((GraniteWidgetsSourceListExpandableItem*) self, TRUE, TRUE);
	_tmp47_ = self->priv->_monitored_repo;
	if (_tmp47_ != NULL) {
		_tmp46_ = !is_explicit;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		{
			ScratchServicesMonitoredRepository* _tmp48_;
			GgitRepository* _tmp49_;
			GgitRepository* _tmp50_;
			GgitStatusOptions* _tmp51_;
			_tmp48_ = self->priv->_monitored_repo;
			_tmp49_ = scratch_services_monitored_repository_get_git_repo (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = status_options;
			ggit_repository_file_status_foreach (_tmp50_, _tmp51_, _____lambda76__ggit_status_callback, _data15_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp52_;
			const gchar* _tmp53_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp52_ = err;
			_tmp53_ = _tmp52_->message;
			g_warning ("ProjectFolderItem.vala:453: Error getting file status: %s", _tmp53_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			__vala_GgitStatusOptions_free0 (status_options);
			_g_free0 (folder_name);
			path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
			block15_data_unref (_data15_);
			_data15_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	} else {
		GRegex* _tmp54_;
		_tmp54_ = _data15_->pattern;
		scratch_folder_manager_project_folder_item_search_folder_children (self, _data15_->start_folder, _tmp54_, _data15_->recurse_subfolders);
	}
	__vala_GgitStatusOptions_free0 (status_options);
	_g_free0 (folder_name);
	path_spec = (_vala_array_free (path_spec, path_spec_length1, (GDestroyNotify) g_free), NULL);
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return;
}

static void
scratch_folder_manager_project_folder_item_search_folder_children (ScratchFolderManagerProjectFolderItem* self,
                                                                   GFile* start_folder,
                                                                   GRegex* pattern,
                                                                   gboolean recurse_subfolders)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_folder != NULL);
	g_return_if_fail (pattern != NULL);
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		GFileInfo* info = NULL;
		GFile* child = NULL;
		_tmp0_ = g_file_enumerate_children (start_folder, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		info = NULL;
		child = NULL;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			GFileEnumerator* _tmp3_;
			GFileInfo* _tmp4_ = NULL;
			GFile* _tmp5_ = NULL;
			gboolean _tmp6_;
			gboolean _tmp8_ = FALSE;
			GFileInfo* _tmp9_;
			_tmp3_ = enumerator;
			_tmp6_ = g_file_enumerator_iterate (_tmp3_, &_tmp4_, &_tmp5_, NULL, &_inner_error0_);
			info = _tmp4_;
			child = _tmp5_;
			_tmp2_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			if (_tmp2_) {
				GFileInfo* _tmp7_;
				_tmp7_ = info;
				_tmp1_ = _tmp7_ != NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp9_ = info;
			if (_tmp9_ != NULL) {
				GFileInfo* _tmp10_;
				_tmp10_ = info;
				_tmp8_ = g_file_info_has_attribute (_tmp10_, G_FILE_ATTRIBUTE_STANDARD_TYPE);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GFileInfo* _tmp11_;
				_tmp11_ = info;
				if (g_file_info_get_file_type (_tmp11_) == G_FILE_TYPE_DIRECTORY) {
					if (recurse_subfolders) {
						GFile* _tmp12_;
						_tmp12_ = child;
						scratch_folder_manager_project_folder_item_search_folder_children (self, _tmp12_, pattern, recurse_subfolders);
					}
				} else {
					GFile* _tmp13_;
					GFileInfo* _tmp14_;
					_tmp13_ = child;
					_tmp14_ = info;
					scratch_folder_manager_project_folder_item_perform_match (self, _tmp13_, pattern, TRUE, _tmp14_);
				}
			}
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* enumerate_error = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		enumerate_error = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = g_file_get_path (start_folder);
		_tmp16_ = _tmp15_;
		_tmp17_ = enumerate_error;
		_tmp18_ = _tmp17_->message;
		g_warning ("ProjectFolderItem.vala:484: Error enumerating children of %s: %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp16_);
		_g_error_free0 (enumerate_error);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
scratch_folder_manager_project_folder_item_perform_match (ScratchFolderManagerProjectFolderItem* self,
                                                          GFile* target,
                                                          GRegex* pattern,
                                                          gboolean check_is_text,
                                                          GFileInfo* target_info)
{
	gchar* contents = NULL;
	gchar* target_path = NULL;
	gchar* _tmp0_;
	GMatchInfo* match_info = NULL;
	gint match_count = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	g_return_if_fail (pattern != NULL);
	_tmp0_ = g_file_get_path (target);
	target_path = _tmp0_;
	if (check_is_text) {
		GFileInfo* info = NULL;
		GFileInfo* _tmp9_;
		gchar* type = NULL;
		GFileInfo* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		info = NULL;
		if (target_info == NULL) {
			{
				GFileInfo* _tmp1_ = NULL;
				GFileInfo* _tmp2_;
				GFileInfo* _tmp3_;
				_tmp2_ = g_file_query_info (target, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
				_tmp1_ = _tmp2_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp3_ = _tmp1_;
				_tmp1_ = NULL;
				_g_object_unref0 (info);
				info = _tmp3_;
				_g_object_unref0 (_tmp1_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* query_error = NULL;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GError* _tmp6_;
				const gchar* _tmp7_;
				query_error = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp4_ = g_file_get_path (target);
				_tmp5_ = _tmp4_;
				_tmp6_ = query_error;
				_tmp7_ = _tmp6_->message;
				g_warning ("ProjectFolderItem.vala:504: Error getting file info for %s: %s.  Ignor" \
"ing.", _tmp5_, _tmp7_);
				_g_free0 (_tmp5_);
				_g_error_free0 (query_error);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_free0 (target_path);
				_g_free0 (contents);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			GFileInfo* _tmp8_;
			_tmp8_ = _g_object_ref0 (target_info);
			_g_object_unref0 (info);
			info = _tmp8_;
		}
		_tmp9_ = info;
		if (_tmp9_ == NULL) {
			_g_object_unref0 (info);
			_g_free0 (target_path);
			_g_free0 (contents);
			return;
		}
		_tmp10_ = info;
		_tmp11_ = g_file_info_get_content_type (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		type = _tmp12_;
		_tmp14_ = type;
		if (!g_content_type_is_mime_type (_tmp14_, "text/*")) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = type;
			_tmp13_ = g_content_type_is_mime_type (_tmp15_, "image/*");
		}
		if (_tmp13_) {
			_g_free0 (type);
			_g_object_unref0 (info);
			_g_free0 (target_path);
			_g_free0 (contents);
			return;
		}
		_g_free0 (type);
		_g_object_unref0 (info);
	}
	{
		const gchar* _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp16_ = target_path;
		g_file_get_contents (_tmp16_, &_tmp17_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("ProjectFolderItem.vala:526: error getting contents: %s", _tmp19_);
		_g_error_free0 (e);
		_g_free0 (target_path);
		_g_free0 (contents);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (target_path);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	match_info = NULL;
	match_count = 0;
	{
		{
			const gchar* _tmp20_;
			GMatchInfo* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			_tmp20_ = contents;
			g_regex_match (pattern, _tmp20_, 0, &_tmp21_);
			_g_match_info_unref0 (match_info);
			match_info = _tmp21_;
			_tmp22_ = TRUE;
			while (TRUE) {
				GMatchInfo* _tmp24_;
				gint _tmp25_;
				if (!_tmp22_) {
					GMatchInfo* _tmp23_;
					_tmp23_ = match_info;
					g_match_info_next (_tmp23_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_REGEX_ERROR) {
							goto __catch2_g_regex_error;
						}
						_g_match_info_unref0 (match_info);
						_g_free0 (target_path);
						_g_free0 (contents);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp22_ = FALSE;
				_tmp24_ = match_info;
				if (!g_match_info_matches (_tmp24_)) {
					break;
				}
				_tmp25_ = match_count;
				match_count = _tmp25_ + 1;
			}
		}
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* next_error = NULL;
		GError* _tmp26_;
		const gchar* _tmp27_;
		next_error = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = next_error;
		_tmp27_ = _tmp26_->message;
		g_critical ("ProjectFolderItem.vala:540: Error getting next match: %s", _tmp27_);
		_g_error_free0 (next_error);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		_g_free0 (target_path);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (match_count > 0) {
		GraniteWidgetsSourceListItem* item = NULL;
		ScratchFolderManagerFileView* _tmp28_;
		ScratchFolderManagerFileView* _tmp29_;
		const gchar* _tmp30_;
		GraniteWidgetsSourceListItem* _tmp31_;
		GraniteWidgetsSourceListItem* _tmp32_;
		_tmp28_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
		_tmp29_ = _tmp28_;
		_tmp30_ = target_path;
		_tmp31_ = scratch_folder_manager_file_view_expand_to_path (_tmp29_, _tmp30_);
		item = _tmp31_;
		_tmp32_ = item;
		if (_tmp32_ != NULL) {
			GraniteWidgetsSourceListItem* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp33_ = item;
			_tmp34_ = g_strdup_printf ("%i", match_count);
			_tmp35_ = _tmp34_;
			granite_widgets_source_list_item_set_badge (_tmp33_, _tmp35_);
			_g_free0 (_tmp35_);
		}
	}
	_g_match_info_unref0 (match_info);
	_g_free0 (target_path);
	_g_free0 (contents);
	return;
}

void
scratch_folder_manager_project_folder_item_refresh_diff (ScratchFolderManagerProjectFolderItem* self,
                                                         GeeHashMap** line_status_map,
                                                         const gchar* doc_path)
{
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*line_status_map != NULL);
	g_return_if_fail (doc_path != NULL);
	_tmp0_ = self->priv->_monitored_repo;
	scratch_services_monitored_repository_refresh_diff (_tmp0_, doc_path, line_status_map);
}

ScratchServicesMonitoredRepository*
scratch_folder_manager_project_folder_item_get_monitored_repo (ScratchFolderManagerProjectFolderItem* self)
{
	ScratchServicesMonitoredRepository* result;
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_monitored_repo;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_project_folder_item_set_monitored_repo (ScratchFolderManagerProjectFolderItem* self,
                                                               ScratchServicesMonitoredRepository* value)
{
	ScratchServicesMonitoredRepository* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_project_folder_item_get_monitored_repo (self);
	if (old_value != value) {
		ScratchServicesMonitoredRepository* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_monitored_repo);
		self->priv->_monitored_repo = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY]);
	}
}

gboolean
scratch_folder_manager_project_folder_item_get_is_git_repo (ScratchFolderManagerProjectFolderItem* self)
{
	gboolean result;
	ScratchServicesMonitoredRepository* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_monitored_repo;
	result = _tmp0_ != NULL;
	return result;
}

static GgitRepository*
scratch_folder_manager_project_folder_item_get_git_repo (ScratchFolderManagerProjectFolderItem* self)
{
	GgitRepository* result;
	GgitRepository* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = scratch_folder_manager_project_folder_item_get_is_git_repo (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ScratchServicesMonitoredRepository* _tmp3_;
		GgitRepository* _tmp4_;
		GgitRepository* _tmp5_;
		_tmp3_ = self->priv->_monitored_repo;
		_tmp4_ = scratch_services_monitored_repository_get_git_repo (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static inline gpointer
scratch_folder_manager_project_folder_item_change_branch_menu_get_instance_private (ScratchFolderManagerProjectFolderItemChangeBranchMenu* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerProjectFolderItemChangeBranchMenu_private_offset);
}

static ScratchFolderManagerProjectFolderItemChangeBranchMenu*
scratch_folder_manager_project_folder_item_change_branch_menu_construct (GType object_type,
                                                                         ScratchFolderManagerProjectFolderItem* project_folder)
{
	ScratchFolderManagerProjectFolderItemChangeBranchMenu * self = NULL;
	g_return_val_if_fail (project_folder != NULL, NULL);
	self = (ScratchFolderManagerProjectFolderItemChangeBranchMenu*) g_object_new (object_type, "project-folder", project_folder, NULL);
	return self;
}

static ScratchFolderManagerProjectFolderItemChangeBranchMenu*
scratch_folder_manager_project_folder_item_change_branch_menu_new (ScratchFolderManagerProjectFolderItem* project_folder)
{
	return scratch_folder_manager_project_folder_item_change_branch_menu_construct (SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, project_folder);
}

static ScratchServicesMonitoredRepository*
scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (ScratchFolderManagerProjectFolderItemChangeBranchMenu* self)
{
	ScratchServicesMonitoredRepository* result;
	ScratchFolderManagerProjectFolderItem* _tmp0_;
	ScratchServicesMonitoredRepository* _tmp1_;
	ScratchServicesMonitoredRepository* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_folder;
	_tmp1_ = scratch_folder_manager_project_folder_item_get_monitored_repo (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_project_folder_item_change_branch_menu_get_project_folder (ScratchFolderManagerProjectFolderItemChangeBranchMenu* self)
{
	ScratchFolderManagerProjectFolderItem* result;
	ScratchFolderManagerProjectFolderItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_folder;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_project_folder_item_change_branch_menu_set_project_folder (ScratchFolderManagerProjectFolderItemChangeBranchMenu* self,
                                                                                  ScratchFolderManagerProjectFolderItem* value)
{
	ScratchFolderManagerProjectFolderItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_project_folder_item_change_branch_menu_get_project_folder (self);
	if (old_value != value) {
		ScratchFolderManagerProjectFolderItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_project_folder);
		self->priv->_project_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_project_folder_item_change_branch_menu_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_PROJECT_FOLDER_PROPERTY]);
	}
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		ScratchFolderManagerProjectFolderItemChangeBranchMenu* self;
		self = _data16_->self;
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
_scratch_folder_manager_project_folder_item_change_branch_menu_____lambda94_ (Block16Data* _data16_)
{
	ScratchFolderManagerProjectFolderItemChangeBranchMenu* self;
	GError* _inner_error0_ = NULL;
	self = _data16_->self;
	{
		ScratchServicesMonitoredRepository* _tmp0_;
		ScratchServicesMonitoredRepository* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _data16_->branch_name;
		scratch_services_monitored_repository_change_branch (_tmp1_, _tmp2_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = gtk_widget_get_name ((GtkWidget*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("ProjectFolderItem.vala:589: Failed to change branch to %s. %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
__scratch_folder_manager_project_folder_item_change_branch_menu_____lambda94__gtk_check_menu_item_toggled (GtkCheckMenuItem* _sender,
                                                                                                           gpointer self)
{
	_scratch_folder_manager_project_folder_item_change_branch_menu_____lambda94_ (self);
}

static GVariant*
_variant_new10 (gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GObject *
scratch_folder_manager_project_folder_item_change_branch_menu_constructor (GType type,
                                                                           guint n_construct_properties,
                                                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerProjectFolderItemChangeBranchMenu * self;
	ScratchServicesMonitoredRepository* _tmp0_;
	ScratchServicesMonitoredRepository* _tmp1_;
	const gchar* current_branch_name = NULL;
	ScratchServicesMonitoredRepository* _tmp2_;
	ScratchServicesMonitoredRepository* _tmp3_;
	const gchar* _tmp4_;
	GtkMenu* change_branch_menu = NULL;
	GtkMenu* _tmp5_;
	ScratchServicesMonitoredRepository* _tmp6_;
	ScratchServicesMonitoredRepository* _tmp7_;
	GList* _tmp8_;
	ScratchMainWindow* main_window = NULL;
	GApplication* _tmp18_;
	GtkWindow* _tmp19_;
	ScratchMainWindow* _tmp20_;
	ScratchMainWindow* _tmp21_;
	GSimpleActionGroup* _tmp22_;
	GSimpleActionGroup* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	ScratchServicesMonitoredRepository* _tmp26_;
	ScratchServicesMonitoredRepository* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GraniteAccelLabel* accel_label = NULL;
	GraniteAccelLabel* _tmp30_;
	GtkMenuItem* branch_item = NULL;
	gchar* _tmp31_;
	ScratchFolderManagerProjectFolderItem* _tmp32_;
	ScratchFolderManagerFile* _tmp33_;
	ScratchFolderManagerFile* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GVariant* _tmp39_;
	GtkMenuItem* _tmp40_ = NULL;
	GtkMenuItem* _tmp41_;
	GtkMenuItem* _tmp42_;
	GraniteAccelLabel* _tmp43_;
	GtkMenu* _tmp44_;
	GtkSeparatorMenuItem* _tmp45_;
	GtkSeparatorMenuItem* _tmp46_;
	GtkMenu* _tmp47_;
	GtkMenuItem* _tmp48_;
	GtkMenu* _tmp49_;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_project_folder_item_change_branch_menu_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, ScratchFolderManagerProjectFolderItemChangeBranchMenu);
	_tmp0_ = scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (self);
	_tmp1_ = _tmp0_;
	g_assert_nonnull (_tmp1_);
	_tmp2_ = scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = scratch_services_monitored_repository_get_current_branch (_tmp3_);
	current_branch_name = _tmp4_;
	_tmp5_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp5_);
	change_branch_menu = _tmp5_;
	_tmp6_ = scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = scratch_services_monitored_repository_get_local_branches (_tmp7_);
	{
		GList* branch_name_collection = NULL;
		GList* branch_name_it = NULL;
		branch_name_collection = _tmp8_;
		for (branch_name_it = branch_name_collection; branch_name_it != NULL; branch_name_it = branch_name_it->next) {
			const gchar* branch_name = NULL;
			branch_name = (const gchar*) branch_name_it->data;
			{
				Block16Data* _data16_;
				GtkCheckMenuItem* branch_item = NULL;
				const gchar* _tmp9_;
				GtkCheckMenuItem* _tmp10_;
				GtkCheckMenuItem* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				GtkMenu* _tmp15_;
				GtkCheckMenuItem* _tmp16_;
				GtkCheckMenuItem* _tmp17_;
				_data16_ = g_slice_new0 (Block16Data);
				_data16_->_ref_count_ = 1;
				_data16_->self = g_object_ref (self);
				_data16_->branch_name = branch_name;
				_tmp9_ = _data16_->branch_name;
				_tmp10_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_tmp9_);
				g_object_ref_sink (_tmp10_);
				branch_item = _tmp10_;
				_tmp11_ = branch_item;
				gtk_check_menu_item_set_draw_as_radio (_tmp11_, TRUE);
				_tmp12_ = _data16_->branch_name;
				_tmp13_ = current_branch_name;
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					GtkCheckMenuItem* _tmp14_;
					_tmp14_ = branch_item;
					gtk_check_menu_item_set_active (_tmp14_, TRUE);
				}
				_tmp15_ = change_branch_menu;
				_tmp16_ = branch_item;
				gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
				_tmp17_ = branch_item;
				g_signal_connect_data (_tmp17_, "toggled", (GCallback) __scratch_folder_manager_project_folder_item_change_branch_menu_____lambda94__gtk_check_menu_item_toggled, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
				_g_object_unref0 (branch_item);
				block16_data_unref (_data16_);
				_data16_ = NULL;
			}
		}
	}
	_tmp18_ = g_application_get_default ();
	_tmp19_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_application_get_type (), GtkApplication));
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindow));
	main_window = _tmp20_;
	_tmp21_ = main_window;
	_tmp22_ = scratch_main_window_get_actions (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = scratch_utils_action_from_group (SCRATCH_MAIN_WINDOW_ACTION_NEW_BRANCH, _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = scratch_services_monitored_repository_get_head_is_branch (_tmp27_);
	_tmp29_ = _tmp28_;
	g_simple_action_set_enabled (_tmp25_, _tmp29_);
	_g_object_unref0 (_tmp25_);
	_tmp30_ = granite_accel_label_new_from_action_name (_ ("New Branch…"), SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_NEW_BRANCH "::");
	g_object_ref_sink (_tmp30_);
	accel_label = _tmp30_;
	_tmp31_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_NEW_BRANCH);
	_tmp32_ = self->priv->_project_folder;
	_tmp33_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = scratch_folder_manager_file_get_file (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_file_get_path (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _variant_new10 (_tmp38_);
	_tmp40_ = (GtkMenuItem*) gtk_menu_item_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp40_, _tmp31_);
	_g_free0 (_tmp31_);
	g_object_set ((GtkActionable*) _tmp40_, "action-target", _tmp39_, NULL);
	_g_variant_unref0 (_tmp39_);
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	_g_free0 (_tmp38_);
	branch_item = _tmp41_;
	_tmp42_ = branch_item;
	_tmp43_ = accel_label;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = change_branch_menu;
	_tmp45_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp45_);
	_tmp46_ = _tmp45_;
	gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp46_);
	_g_object_unref0 (_tmp46_);
	_tmp47_ = change_branch_menu;
	_tmp48_ = branch_item;
	gtk_container_add ((GtkContainer*) _tmp47_, (GtkWidget*) _tmp48_);
	gtk_menu_item_set_label ((GtkMenuItem*) self, _ ("Branch"));
	_tmp49_ = change_branch_menu;
	gtk_menu_item_set_submenu ((GtkMenuItem*) self, _tmp49_);
	_g_object_unref0 (branch_item);
	_g_object_unref0 (accel_label);
	_g_object_unref0 (main_window);
	_g_object_unref0 (change_branch_menu);
	return obj;
}

static void
scratch_folder_manager_project_folder_item_change_branch_menu_class_init (ScratchFolderManagerProjectFolderItemChangeBranchMenuClass * klass,
                                                                          gpointer klass_data)
{
	scratch_folder_manager_project_folder_item_change_branch_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerProjectFolderItemChangeBranchMenu_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_project_folder_item_change_branch_menu_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_project_folder_item_change_branch_menu_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_project_folder_item_change_branch_menu_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_project_folder_item_change_branch_menu_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_MONITORED_REPO_PROPERTY, scratch_folder_manager_project_folder_item_change_branch_menu_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_MONITORED_REPO_PROPERTY] = g_param_spec_object ("monitored-repo", "monitored-repo", "monitored-repo", SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_PROJECT_FOLDER_PROPERTY, scratch_folder_manager_project_folder_item_change_branch_menu_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_PROJECT_FOLDER_PROPERTY] = g_param_spec_object ("project-folder", "project-folder", "project-folder", SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
scratch_folder_manager_project_folder_item_change_branch_menu_instance_init (ScratchFolderManagerProjectFolderItemChangeBranchMenu * self,
                                                                             gpointer klass)
{
	self->priv = scratch_folder_manager_project_folder_item_change_branch_menu_get_instance_private (self);
}

static void
scratch_folder_manager_project_folder_item_change_branch_menu_finalize (GObject * obj)
{
	ScratchFolderManagerProjectFolderItemChangeBranchMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, ScratchFolderManagerProjectFolderItemChangeBranchMenu);
	_g_object_unref0 (self->priv->_project_folder);
	G_OBJECT_CLASS (scratch_folder_manager_project_folder_item_change_branch_menu_parent_class)->finalize (obj);
}

static GType
scratch_folder_manager_project_folder_item_change_branch_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerProjectFolderItemChangeBranchMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_project_folder_item_change_branch_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerProjectFolderItemChangeBranchMenu), 0, (GInstanceInitFunc) scratch_folder_manager_project_folder_item_change_branch_menu_instance_init, NULL };
	GType scratch_folder_manager_project_folder_item_change_branch_menu_type_id;
	scratch_folder_manager_project_folder_item_change_branch_menu_type_id = g_type_register_static (gtk_menu_item_get_type (), "ScratchFolderManagerProjectFolderItemChangeBranchMenu", &g_define_type_info, 0);
	ScratchFolderManagerProjectFolderItemChangeBranchMenu_private_offset = g_type_add_instance_private (scratch_folder_manager_project_folder_item_change_branch_menu_type_id, sizeof (ScratchFolderManagerProjectFolderItemChangeBranchMenuPrivate));
	return scratch_folder_manager_project_folder_item_change_branch_menu_type_id;
}

static GType
scratch_folder_manager_project_folder_item_change_branch_menu_get_type (void)
{
	static volatile gsize scratch_folder_manager_project_folder_item_change_branch_menu_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_project_folder_item_change_branch_menu_type_id__once)) {
		GType scratch_folder_manager_project_folder_item_change_branch_menu_type_id;
		scratch_folder_manager_project_folder_item_change_branch_menu_type_id = scratch_folder_manager_project_folder_item_change_branch_menu_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_project_folder_item_change_branch_menu_type_id__once, scratch_folder_manager_project_folder_item_change_branch_menu_type_id);
	}
	return scratch_folder_manager_project_folder_item_change_branch_menu_type_id__once;
}

static void
_vala_scratch_folder_manager_project_folder_item_change_branch_menu_get_property (GObject * object,
                                                                                  guint property_id,
                                                                                  GValue * value,
                                                                                  GParamSpec * pspec)
{
	ScratchFolderManagerProjectFolderItemChangeBranchMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, ScratchFolderManagerProjectFolderItemChangeBranchMenu);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_MONITORED_REPO_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_project_folder_item_change_branch_menu_get_monitored_repo (self));
		break;
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_PROJECT_FOLDER_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_project_folder_item_change_branch_menu_get_project_folder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_project_folder_item_change_branch_menu_set_property (GObject * object,
                                                                                  guint property_id,
                                                                                  const GValue * value,
                                                                                  GParamSpec * pspec)
{
	ScratchFolderManagerProjectFolderItemChangeBranchMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_TYPE_CHANGE_BRANCH_MENU, ScratchFolderManagerProjectFolderItemChangeBranchMenu);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CHANGE_BRANCH_MENU_PROJECT_FOLDER_PROPERTY:
		scratch_folder_manager_project_folder_item_change_branch_menu_set_project_folder (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
scratch_folder_manager_project_folder_item_visible_item_copy (const ScratchFolderManagerProjectFolderItemVisibleItem* self,
                                                              ScratchFolderManagerProjectFolderItemVisibleItem* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	ScratchFolderManagerItem* _tmp2_;
	ScratchFolderManagerItem* _tmp3_;
	_tmp0_ = (*self).rel_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).rel_path);
	(*dest).rel_path = _tmp1_;
	_tmp2_ = (*self).item;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).item);
	(*dest).item = _tmp3_;
}

static void
scratch_folder_manager_project_folder_item_visible_item_destroy (ScratchFolderManagerProjectFolderItemVisibleItem* self)
{
	_g_free0 ((*self).rel_path);
	_g_object_unref0 ((*self).item);
}

static ScratchFolderManagerProjectFolderItemVisibleItem*
scratch_folder_manager_project_folder_item_visible_item_dup (const ScratchFolderManagerProjectFolderItemVisibleItem* self)
{
	ScratchFolderManagerProjectFolderItemVisibleItem* dup;
	dup = g_new0 (ScratchFolderManagerProjectFolderItemVisibleItem, 1);
	scratch_folder_manager_project_folder_item_visible_item_copy (self, dup);
	return dup;
}

static void
scratch_folder_manager_project_folder_item_visible_item_free (ScratchFolderManagerProjectFolderItemVisibleItem* self)
{
	scratch_folder_manager_project_folder_item_visible_item_destroy (self);
	g_free (self);
}

static GType
scratch_folder_manager_project_folder_item_visible_item_get_type_once (void)
{
	GType scratch_folder_manager_project_folder_item_visible_item_type_id;
	scratch_folder_manager_project_folder_item_visible_item_type_id = g_boxed_type_register_static ("ScratchFolderManagerProjectFolderItemVisibleItem", (GBoxedCopyFunc) scratch_folder_manager_project_folder_item_visible_item_dup, (GBoxedFreeFunc) scratch_folder_manager_project_folder_item_visible_item_free);
	return scratch_folder_manager_project_folder_item_visible_item_type_id;
}

static GType
scratch_folder_manager_project_folder_item_visible_item_get_type (void)
{
	static volatile gsize scratch_folder_manager_project_folder_item_visible_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_project_folder_item_visible_item_type_id__once)) {
		GType scratch_folder_manager_project_folder_item_visible_item_type_id;
		scratch_folder_manager_project_folder_item_visible_item_type_id = scratch_folder_manager_project_folder_item_visible_item_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_project_folder_item_visible_item_type_id__once, scratch_folder_manager_project_folder_item_visible_item_type_id);
	}
	return scratch_folder_manager_project_folder_item_visible_item_type_id__once;
}

static void
_scratch_folder_manager_project_folder_item_branch_or_name_changed_g_object_notify (GObject* _sender,
                                                                                    GParamSpec* pspec,
                                                                                    gpointer self)
{
	scratch_folder_manager_project_folder_item_branch_or_name_changed ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
_scratch_folder_manager_project_folder_item_branch_or_name_changed_scratch_services_monitored_repository_branch_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                         gpointer self)
{
	scratch_folder_manager_project_folder_item_branch_or_name_changed ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
_scratch_folder_manager_project_folder_item_deprioritize_git_ignored_scratch_services_monitored_repository_ignored_changed (ScratchServicesMonitoredRepository* _sender,
                                                                                                                            gpointer self)
{
	scratch_folder_manager_project_folder_item_deprioritize_git_ignored ((ScratchFolderManagerProjectFolderItem*) self);
}

static void
_scratch_folder_manager_project_folder_item____lambda95_ (ScratchFolderManagerProjectFolderItem* self)
{
	scratch_folder_manager_project_folder_item_update_item_status (self, NULL);
}

static void
__scratch_folder_manager_project_folder_item____lambda95__scratch_services_monitored_repository_file_status_change (ScratchServicesMonitoredRepository* _sender,
                                                                                                                    gpointer self)
{
	_scratch_folder_manager_project_folder_item____lambda95_ ((ScratchFolderManagerProjectFolderItem*) self);
}

static GObject *
scratch_folder_manager_project_folder_item_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerProjectFolderItem * self;
	ScratchServicesGitManager* _tmp0_;
	ScratchServicesGitManager* _tmp1_;
	ScratchServicesMonitoredRepository* _tmp2_;
	ScratchServicesMonitoredRepository* _tmp3_;
	ScratchServicesMonitoredRepository* _tmp4_;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_project_folder_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	_tmp0_ = scratch_services_git_manager_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_services_git_manager_add_project (_tmp1_, self);
	_tmp3_ = _tmp2_;
	scratch_folder_manager_project_folder_item_set_monitored_repo (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	g_signal_connect_object ((GObject*) self, "notify::name", (GCallback) _scratch_folder_manager_project_folder_item_branch_or_name_changed_g_object_notify, self, 0);
	_tmp4_ = self->priv->_monitored_repo;
	if (_tmp4_ != NULL) {
		ScratchServicesMonitoredRepository* _tmp5_;
		ScratchServicesMonitoredRepository* _tmp6_;
		ScratchServicesMonitoredRepository* _tmp7_;
		ScratchServicesMonitoredRepository* _tmp8_;
		ScratchServicesMonitoredRepository* _tmp9_;
		_tmp5_ = self->priv->_monitored_repo;
		g_signal_connect_object (_tmp5_, "branch-changed", (GCallback) _scratch_folder_manager_project_folder_item_branch_or_name_changed_scratch_services_monitored_repository_branch_changed, self, 0);
		_tmp6_ = self->priv->_monitored_repo;
		g_signal_connect_object (_tmp6_, "ignored-changed", (GCallback) _scratch_folder_manager_project_folder_item_deprioritize_git_ignored_scratch_services_monitored_repository_ignored_changed, self, 0);
		_tmp7_ = self->priv->_monitored_repo;
		g_signal_connect_object (_tmp7_, "file-status-change", (GCallback) __scratch_folder_manager_project_folder_item____lambda95__scratch_services_monitored_repository_file_status_change, self, 0);
		_tmp8_ = self->priv->_monitored_repo;
		scratch_services_monitored_repository_update_status_map (_tmp8_);
		_tmp9_ = self->priv->_monitored_repo;
		g_signal_emit_by_name (_tmp9_, "branch-changed");
	}
	return obj;
}

static void
scratch_folder_manager_project_folder_item_class_init (ScratchFolderManagerProjectFolderItemClass * klass,
                                                       gpointer klass_data)
{
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	scratch_folder_manager_project_folder_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerProjectFolderItem_private_offset);
	((ScratchFolderManagerFolderItemClass *) klass)->on_changed = (void (*) (ScratchFolderManagerFolderItem*, GFile*, GFile*, GFileMonitorEvent)) scratch_folder_manager_project_folder_item_real_on_changed;
	((GraniteWidgetsSourceListItemClass *) klass)->get_context_menu = (GtkMenu* (*) (GraniteWidgetsSourceListItem*)) scratch_folder_manager_project_folder_item_real_get_context_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_project_folder_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_project_folder_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_project_folder_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_project_folder_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY, scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY] = g_param_spec_object ("monitored-repo", "monitored-repo", "monitored-repo", SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY, scratch_folder_manager_project_folder_item_properties[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY] = g_param_spec_boolean ("is-git-repo", "is-git-repo", "is-git-repo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSED_SIGNAL] = g_signal_new ("closed", SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scratch_folder_manager_project_folder_item_signals[SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLOSE_ALL_EXCEPT_SIGNAL] = g_signal_new ("close-all-except", SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("user-available");
	_g_object_unref0 (scratch_folder_manager_project_folder_item_added_icon);
	scratch_folder_manager_project_folder_item_added_icon = (GIcon*) _tmp0_;
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("user-away");
	_g_object_unref0 (scratch_folder_manager_project_folder_item_modified_icon);
	scratch_folder_manager_project_folder_item_modified_icon = (GIcon*) _tmp1_;
}

static void
scratch_folder_manager_project_folder_item_instance_init (ScratchFolderManagerProjectFolderItem * self,
                                                          gpointer klass)
{
	self->priv = scratch_folder_manager_project_folder_item_get_instance_private (self);
	self->priv->_monitored_repo = NULL;
	self->priv->visible_item_list = NULL;
}

static void
scratch_folder_manager_project_folder_item_finalize (GObject * obj)
{
	ScratchFolderManagerProjectFolderItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	_g_object_unref0 (self->priv->_monitored_repo);
	(self->priv->visible_item_list == NULL) ? NULL : (self->priv->visible_item_list = (_g_list_free__scratch_folder_manager_project_folder_item_visible_item_free0_ (self->priv->visible_item_list), NULL));
	G_OBJECT_CLASS (scratch_folder_manager_project_folder_item_parent_class)->finalize (obj);
}

static GType
scratch_folder_manager_project_folder_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerProjectFolderItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_project_folder_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerProjectFolderItem), 0, (GInstanceInitFunc) scratch_folder_manager_project_folder_item_instance_init, NULL };
	GType scratch_folder_manager_project_folder_item_type_id;
	scratch_folder_manager_project_folder_item_type_id = g_type_register_static (SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, "ScratchFolderManagerProjectFolderItem", &g_define_type_info, 0);
	ScratchFolderManagerProjectFolderItem_private_offset = g_type_add_instance_private (scratch_folder_manager_project_folder_item_type_id, sizeof (ScratchFolderManagerProjectFolderItemPrivate));
	return scratch_folder_manager_project_folder_item_type_id;
}

GType
scratch_folder_manager_project_folder_item_get_type (void)
{
	static volatile gsize scratch_folder_manager_project_folder_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_project_folder_item_type_id__once)) {
		GType scratch_folder_manager_project_folder_item_type_id;
		scratch_folder_manager_project_folder_item_type_id = scratch_folder_manager_project_folder_item_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_project_folder_item_type_id__once, scratch_folder_manager_project_folder_item_type_id);
	}
	return scratch_folder_manager_project_folder_item_type_id__once;
}

static void
_vala_scratch_folder_manager_project_folder_item_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec)
{
	ScratchFolderManagerProjectFolderItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_project_folder_item_get_monitored_repo (self));
		break;
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_IS_GIT_REPO_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_project_folder_item_get_is_git_repo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_project_folder_item_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec)
{
	ScratchFolderManagerProjectFolderItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_MONITORED_REPO_PROPERTY:
		scratch_folder_manager_project_folder_item_set_monitored_repo (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

