/* Item.c generated by valac 0.56.14, the Vala compiler
 * generated from Item.vala, do not modify */

/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io),
 *               2013 Julien Spautz <spautz.julien@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Julien Spautz <spautz.julien@gmail.com>, Andrei-Costin Zisu <matzipan@gmail.com>
 */

#include "codecore.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

enum  {
	SCRATCH_FOLDER_MANAGER_ITEM_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_ITEM_FILE_PROPERTY,
	SCRATCH_FOLDER_MANAGER_ITEM_VIEW_PROPERTY,
	SCRATCH_FOLDER_MANAGER_ITEM_PATH_PROPERTY,
	SCRATCH_FOLDER_MANAGER_ITEM_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_item_properties[SCRATCH_FOLDER_MANAGER_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM (scratch_folder_manager_rename_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_RENAME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItem))
#define SCRATCH_FOLDER_MANAGER_RENAME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_RENAME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_RENAME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM))
#define SCRATCH_FOLDER_MANAGER_RENAME_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItemClass))

typedef struct _ScratchFolderManagerRenameItem ScratchFolderManagerRenameItem;
typedef struct _ScratchFolderManagerRenameItemClass ScratchFolderManagerRenameItemClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScratchFolderManagerItemPrivate {
	ScratchFolderManagerFile* _file;
	ScratchFolderManagerFileView* _view;
};

static gint ScratchFolderManagerItem_private_offset;
static gpointer scratch_folder_manager_item_parent_class = NULL;
static GraniteWidgetsSourceListSortableIface * scratch_folder_manager_item_granite_widgets_source_list_sortable_parent_iface = NULL;

static gint scratch_folder_manager_item_real_compare (GraniteWidgetsSourceListSortable* base,
                                               GraniteWidgetsSourceListItem* a,
                                               GraniteWidgetsSourceListItem* b);
VALA_EXTERN GType scratch_folder_manager_rename_item_get_type (void) G_GNUC_CONST ;
static gboolean scratch_folder_manager_item_real_allow_dnd_sorting (GraniteWidgetsSourceListSortable* base);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GObject * scratch_folder_manager_item_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _scratch_folder_manager_item_rename_granite_widgets_source_list_item_edited (GraniteWidgetsSourceListItem* _sender,
                                                                                  const gchar* new_name,
                                                                                  gpointer self);
static void _scratch_folder_manager_item___lambda80_ (ScratchFolderManagerItem* self);
static void __scratch_folder_manager_item___lambda80__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void scratch_folder_manager_item_finalize (GObject * obj);
static GType scratch_folder_manager_item_get_type_once (void);
static void _vala_scratch_folder_manager_item_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_scratch_folder_manager_item_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
scratch_folder_manager_item_get_instance_private (ScratchFolderManagerItem* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerItem_private_offset);
}

void
scratch_folder_manager_item_rename (ScratchFolderManagerItem* self,
                                    const gchar* new_name)
{
	ScratchFolderManagerFile* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_name != NULL);
	_tmp0_ = self->priv->_file;
	scratch_folder_manager_file_rename (_tmp0_, new_name);
}

void
scratch_folder_manager_item_trash (ScratchFolderManagerItem* self)
{
	ScratchFolderManagerFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_file;
	scratch_folder_manager_file_trash (_tmp0_);
}

static gint
scratch_folder_manager_item_real_compare (GraniteWidgetsSourceListSortable* base,
                                          GraniteWidgetsSourceListItem* a,
                                          GraniteWidgetsSourceListItem* b)
{
	ScratchFolderManagerItem * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ScratchFolderManagerFile* _tmp3_;
	ScratchFolderManagerFile* _tmp4_;
	gint result;
	self = (ScratchFolderManagerItem*) base;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (SCRATCH_FOLDER_MANAGER_IS_RENAME_ITEM (a)) {
		result = -1;
		return result;
	} else {
		if (SCRATCH_FOLDER_MANAGER_IS_RENAME_ITEM (b)) {
			result = 1;
			return result;
		}
	}
	if (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (a)) {
		_tmp0_ = SCRATCH_FOLDER_MANAGER_IS_FILE_ITEM (b);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = -1;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (SCRATCH_FOLDER_MANAGER_IS_FILE_ITEM (a)) {
			_tmp1_ = SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (b);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			result = 1;
			return result;
		}
	}
	if (SCRATCH_FOLDER_MANAGER_IS_ITEM (a)) {
		_tmp2_ = SCRATCH_FOLDER_MANAGER_IS_ITEM (b);
	} else {
		_tmp2_ = FALSE;
	}
	_vala_assert (_tmp2_, "a is Item && b is Item");
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (a, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem)->priv->_file;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (b, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem)->priv->_file;
	result = scratch_folder_manager_file_compare (_tmp3_, _tmp4_);
	return result;
}

static gboolean
scratch_folder_manager_item_real_allow_dnd_sorting (GraniteWidgetsSourceListSortable* base)
{
	ScratchFolderManagerItem * self;
	gboolean result;
	self = (ScratchFolderManagerItem*) base;
	result = FALSE;
	return result;
}

void
scratch_folder_manager_item_show_app_chooser (ScratchFolderManagerItem* self,
                                              ScratchFolderManagerFile* file)
{
	GtkAppChooserDialog* dialog = NULL;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GtkAppChooserDialog* _tmp4_;
	GtkAppChooserDialog* _tmp5_;
	GtkAppChooserDialog* _tmp6_;
	GtkAppChooserDialog* _tmp7_;
	GtkAppChooserDialog* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (file);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkAppChooserDialog*) gtk_app_chooser_dialog_new (_tmp1_, GTK_DIALOG_MODAL, _tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	dialog = _tmp5_;
	_tmp6_ = dialog;
	gtk_window_set_deletable ((GtkWindow*) _tmp6_, FALSE);
	_tmp7_ = dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp7_) == ((gint) GTK_RESPONSE_OK)) {
		GAppInfo* app_info = NULL;
		GtkAppChooserDialog* _tmp8_;
		GAppInfo* _tmp9_;
		GAppInfo* _tmp10_;
		_tmp8_ = dialog;
		_tmp9_ = gtk_app_chooser_get_app_info ((GtkAppChooser*) _tmp8_);
		app_info = _tmp9_;
		_tmp10_ = app_info;
		if (_tmp10_ != NULL) {
			GAppInfo* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			_tmp11_ = app_info;
			_tmp12_ = scratch_folder_manager_file_get_file (file);
			_tmp13_ = _tmp12_;
			scratch_folder_manager_item_launch_app_with_file (self, _tmp11_, _tmp13_);
		}
		_g_object_unref0 (app_info);
	}
	_tmp14_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp14_);
	_g_object_unref0 (dialog);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
scratch_folder_manager_item_launch_app_with_file (ScratchFolderManagerItem* self,
                                                  GAppInfo* app_info,
                                                  GFile* file)
{
	GList* file_list = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (app_info != NULL);
	g_return_if_fail (file != NULL);
	file_list = NULL;
	_tmp0_ = _g_object_ref0 (file);
	file_list = g_list_append (file_list, _tmp0_);
	{
		g_app_info_launch (app_info, file_list, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("Item.vala:101: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		(file_list == NULL) ? NULL : (file_list = (_g_list_free__g_object_unref0_ (file_list), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	(file_list == NULL) ? NULL : (file_list = (_g_list_free__g_object_unref0_ (file_list), NULL));
}

ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_item_get_root_folder (ScratchFolderManagerItem* self,
                                             GraniteWidgetsSourceListExpandableItem* start)
{
	ScratchFolderManagerProjectFolderItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (start == NULL) {
		start = (GraniteWidgetsSourceListExpandableItem*) self;
	}
	if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (start)) {
		ScratchFolderManagerProjectFolderItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (start) ? ((ScratchFolderManagerProjectFolderItem*) start) : NULL);
		result = _tmp0_;
		return result;
	} else {
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		_tmp1_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) start);
		_tmp2_ = _tmp1_;
		if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp2_)) {
			GraniteWidgetsSourceListExpandableItem* _tmp3_;
			GraniteWidgetsSourceListExpandableItem* _tmp4_;
			ScratchFolderManagerProjectFolderItem* _tmp5_;
			_tmp3_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) start);
			_tmp4_ = _tmp3_;
			_tmp5_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp4_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp4_) : NULL);
			result = _tmp5_;
			return result;
		} else {
			GraniteWidgetsSourceListExpandableItem* _tmp6_;
			GraniteWidgetsSourceListExpandableItem* _tmp7_;
			_tmp6_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) start);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				GraniteWidgetsSourceListExpandableItem* _tmp8_;
				GraniteWidgetsSourceListExpandableItem* _tmp9_;
				ScratchFolderManagerProjectFolderItem* _tmp10_;
				_tmp8_ = granite_widgets_source_list_item_get_parent ((GraniteWidgetsSourceListItem*) start);
				_tmp9_ = _tmp8_;
				_tmp10_ = scratch_folder_manager_item_get_root_folder (self, _tmp9_);
				result = _tmp10_;
				return result;
			} else {
				result = NULL;
				return result;
			}
		}
	}
}

ScratchFolderManagerItem*
scratch_folder_manager_item_construct (GType object_type)
{
	ScratchFolderManagerItem * self = NULL;
	self = (ScratchFolderManagerItem*) granite_widgets_source_list_expandable_item_construct (object_type, "");
	return self;
}

ScratchFolderManagerFile*
scratch_folder_manager_item_get_file (ScratchFolderManagerItem* self)
{
	ScratchFolderManagerFile* result;
	ScratchFolderManagerFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_item_set_file (ScratchFolderManagerItem* self,
                                      ScratchFolderManagerFile* value)
{
	ScratchFolderManagerFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_item_get_file (self);
	if (old_value != value) {
		ScratchFolderManagerFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_item_properties[SCRATCH_FOLDER_MANAGER_ITEM_FILE_PROPERTY]);
	}
}

ScratchFolderManagerFileView*
scratch_folder_manager_item_get_view (ScratchFolderManagerItem* self)
{
	ScratchFolderManagerFileView* result;
	ScratchFolderManagerFileView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_item_set_view (ScratchFolderManagerItem* self,
                                      ScratchFolderManagerFileView* value)
{
	ScratchFolderManagerFileView* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_item_get_view (self);
	if (old_value != value) {
		ScratchFolderManagerFileView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_item_properties[SCRATCH_FOLDER_MANAGER_ITEM_VIEW_PROPERTY]);
	}
}

gchar*
scratch_folder_manager_item_get_path (ScratchFolderManagerItem* self)
{
	gchar* result;
	ScratchFolderManagerFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	_tmp1_ = scratch_folder_manager_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
scratch_folder_manager_item_set_path (ScratchFolderManagerItem* self,
                                      const gchar* value)
{
	ScratchFolderManagerFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_file;
	scratch_folder_manager_file_set_path (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_item_properties[SCRATCH_FOLDER_MANAGER_ITEM_PATH_PROPERTY]);
}

static void
_scratch_folder_manager_item_rename_granite_widgets_source_list_item_edited (GraniteWidgetsSourceListItem* _sender,
                                                                             const gchar* new_name,
                                                                             gpointer self)
{
	scratch_folder_manager_item_rename ((ScratchFolderManagerItem*) self, new_name);
}

static void
_scratch_folder_manager_item___lambda80_ (ScratchFolderManagerItem* self)
{
	ScratchFolderManagerFile* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	_tmp0_ = self->priv->_file;
	_tmp1_ = scratch_folder_manager_file_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = scratch_utils_replace_home_with_tilde (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = granite_widgets_source_list_item_get_activatable_tooltip ((GraniteWidgetsSourceListItem*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%s\n" GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp5_, _tmp7_);
	_tmp9_ = _tmp8_;
	granite_widgets_source_list_item_set_tooltip ((GraniteWidgetsSourceListItem*) self, _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
}

static void
__scratch_folder_manager_item___lambda80__g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	_scratch_folder_manager_item___lambda80_ ((ScratchFolderManagerItem*) self);
}

static GObject *
scratch_folder_manager_item_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerItem * self;
	ScratchFolderManagerFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	ScratchFolderManagerFile* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	ScratchFolderManagerFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem);
	granite_widgets_source_list_item_set_selectable ((GraniteWidgetsSourceListItem*) self, TRUE);
	granite_widgets_source_list_item_set_editable ((GraniteWidgetsSourceListItem*) self, TRUE);
	_tmp0_ = self->priv->_file;
	_tmp1_ = scratch_folder_manager_file_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	granite_widgets_source_list_item_set_name ((GraniteWidgetsSourceListItem*) self, _tmp2_);
	_tmp3_ = self->priv->_file;
	_tmp4_ = scratch_folder_manager_file_get_icon (_tmp3_);
	_tmp5_ = _tmp4_;
	granite_widgets_source_list_item_set_icon ((GraniteWidgetsSourceListItem*) self, _tmp5_);
	g_signal_connect_object ((GraniteWidgetsSourceListItem*) self, "edited", (GCallback) _scratch_folder_manager_item_rename_granite_widgets_source_list_item_edited, self, 0);
	_tmp6_ = self->priv->_file;
	_tmp7_ = scratch_folder_manager_file_get_path (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = scratch_utils_replace_home_with_tilde (_tmp9_);
	_tmp11_ = _tmp10_;
	granite_widgets_source_list_item_set_tooltip ((GraniteWidgetsSourceListItem*) self, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	g_signal_connect_object ((GObject*) self, "notify::activatable-tooltip", (GCallback) __scratch_folder_manager_item___lambda80__g_object_notify, self, 0);
	return obj;
}

static void
scratch_folder_manager_item_class_init (ScratchFolderManagerItemClass * klass,
                                        gpointer klass_data)
{
	scratch_folder_manager_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_ITEM_FILE_PROPERTY, scratch_folder_manager_item_properties[SCRATCH_FOLDER_MANAGER_ITEM_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", SCRATCH_FOLDER_MANAGER_TYPE_FILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_ITEM_VIEW_PROPERTY, scratch_folder_manager_item_properties[SCRATCH_FOLDER_MANAGER_ITEM_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_ITEM_PATH_PROPERTY, scratch_folder_manager_item_properties[SCRATCH_FOLDER_MANAGER_ITEM_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
scratch_folder_manager_item_granite_widgets_source_list_sortable_interface_init (GraniteWidgetsSourceListSortableIface * iface,
                                                                                 gpointer iface_data)
{
	scratch_folder_manager_item_granite_widgets_source_list_sortable_parent_iface = g_type_interface_peek_parent (iface);
	iface->compare = (gint (*) (GraniteWidgetsSourceListSortable*, GraniteWidgetsSourceListItem*, GraniteWidgetsSourceListItem*)) scratch_folder_manager_item_real_compare;
	iface->allow_dnd_sorting = (gboolean (*) (GraniteWidgetsSourceListSortable*)) scratch_folder_manager_item_real_allow_dnd_sorting;
}

static void
scratch_folder_manager_item_instance_init (ScratchFolderManagerItem * self,
                                           gpointer klass)
{
	self->priv = scratch_folder_manager_item_get_instance_private (self);
}

static void
scratch_folder_manager_item_finalize (GObject * obj)
{
	ScratchFolderManagerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->_view);
	G_OBJECT_CLASS (scratch_folder_manager_item_parent_class)->finalize (obj);
}

/**
     * Common abstract class for file and folder items.
     */
static GType
scratch_folder_manager_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerItem), 0, (GInstanceInitFunc) scratch_folder_manager_item_instance_init, NULL };
	static const GInterfaceInfo granite_widgets_source_list_sortable_info = { (GInterfaceInitFunc) scratch_folder_manager_item_granite_widgets_source_list_sortable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType scratch_folder_manager_item_type_id;
	scratch_folder_manager_item_type_id = g_type_register_static (GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, "ScratchFolderManagerItem", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (scratch_folder_manager_item_type_id, GRANITE_WIDGETS_TYPE_SOURCE_LIST_SORTABLE, &granite_widgets_source_list_sortable_info);
	ScratchFolderManagerItem_private_offset = g_type_add_instance_private (scratch_folder_manager_item_type_id, sizeof (ScratchFolderManagerItemPrivate));
	return scratch_folder_manager_item_type_id;
}

GType
scratch_folder_manager_item_get_type (void)
{
	static volatile gsize scratch_folder_manager_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_item_type_id__once)) {
		GType scratch_folder_manager_item_type_id;
		scratch_folder_manager_item_type_id = scratch_folder_manager_item_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_item_type_id__once, scratch_folder_manager_item_type_id);
	}
	return scratch_folder_manager_item_type_id__once;
}

static void
_vala_scratch_folder_manager_item_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ScratchFolderManagerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_ITEM_FILE_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_item_get_file (self));
		break;
		case SCRATCH_FOLDER_MANAGER_ITEM_VIEW_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_item_get_view (self));
		break;
		case SCRATCH_FOLDER_MANAGER_ITEM_PATH_PROPERTY:
		g_value_take_string (value, scratch_folder_manager_item_get_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_item_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ScratchFolderManagerItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_ITEM_FILE_PROPERTY:
		scratch_folder_manager_item_set_file (self, g_value_get_object (value));
		break;
		case SCRATCH_FOLDER_MANAGER_ITEM_VIEW_PROPERTY:
		scratch_folder_manager_item_set_view (self, g_value_get_object (value));
		break;
		case SCRATCH_FOLDER_MANAGER_ITEM_PATH_PROPERTY:
		scratch_folder_manager_item_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

