/* FolderItem.c generated by valac 0.56.14, the Vala compiler
 * generated from FolderItem.vala, do not modify */

/*-
 * Copyright (c) 2017-2018 elementary LLC. (https://elementary.io),
 *               2013 Julien Spautz <spautz.julien@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Julien Spautz <spautz.julien@gmail.com>, Andrei-Costin Zisu <matzipan@gmail.com>
 */

#include "codecore.h"
#include <gio/gio.h>
#include <glib.h>
#include <granite.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_folder_item_properties[SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block10Data Block10Data;

#define SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM (scratch_folder_manager_rename_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_RENAME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItem))
#define SCRATCH_FOLDER_MANAGER_RENAME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_RENAME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_RENAME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM))
#define SCRATCH_FOLDER_MANAGER_RENAME_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItemClass))

typedef struct _ScratchFolderManagerRenameItem ScratchFolderManagerRenameItem;
typedef struct _ScratchFolderManagerRenameItemClass ScratchFolderManagerRenameItemClass;
typedef struct _Block11Data Block11Data;
typedef struct _ScratchFolderManagerRenameItemPrivate ScratchFolderManagerRenameItemPrivate;
enum  {
	SCRATCH_FOLDER_MANAGER_RENAME_ITEM_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_RENAME_ITEM_IS_FOLDER_PROPERTY,
	SCRATCH_FOLDER_MANAGER_RENAME_ITEM_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_rename_item_properties[SCRATCH_FOLDER_MANAGER_RENAME_ITEM_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ScratchFolderManagerFolderItemPrivate {
	GFileMonitor* monitor;
	gboolean children_loaded;
	gboolean has_dummy;
	GraniteWidgetsSourceListItem* dummy;
};

struct _Block10Data {
	int _ref_count_;
	ScratchFolderManagerFolderItem* self;
	GAppInfo* app_info;
};

struct _Block11Data {
	int _ref_count_;
	ScratchFolderManagerFolderItem* self;
	ScratchFolderManagerRenameItem* rename_item;
	gboolean is_folder;
};

struct _ScratchFolderManagerRenameItem {
	GraniteWidgetsSourceListItem parent_instance;
	ScratchFolderManagerRenameItemPrivate * priv;
};

struct _ScratchFolderManagerRenameItemClass {
	GraniteWidgetsSourceListItemClass parent_class;
};

struct _ScratchFolderManagerRenameItemPrivate {
	gboolean _is_folder;
};

static gint ScratchFolderManagerFolderItem_private_offset;
static gpointer scratch_folder_manager_folder_item_parent_class = NULL;
static gint ScratchFolderManagerRenameItem_private_offset;
static gpointer scratch_folder_manager_rename_item_parent_class = NULL;

static void scratch_folder_manager_folder_item_on_toggled (ScratchFolderManagerFolderItem* self);
static GtkMenu* scratch_folder_manager_folder_item_real_get_context_menu (GraniteWidgetsSourceListItem* base);
static void __lambda84_ (ScratchFolderManagerFolderItem* self);
static void ___lambda84__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void _scratch_folder_manager_item_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                gpointer self);
static void __lambda85_ (ScratchFolderManagerFolderItem* self);
static void ___lambda85__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void _____lambda86_ (Block10Data* _data10_);
static void ______lambda86__gtk_menu_item_activate (GtkMenuItem* _sender,
                                             gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda87_ (ScratchFolderManagerFolderItem* self);
static void scratch_folder_manager_folder_item_on_add_new (ScratchFolderManagerFolderItem* self,
                                                    gboolean is_folder);
static void ___lambda87__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda90_ (ScratchFolderManagerFolderItem* self);
static void ___lambda90__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void scratch_folder_manager_folder_item_remove_badge (ScratchFolderManagerFolderItem* self,
                                                      GraniteWidgetsSourceListItem* item);
VALA_EXTERN GType scratch_folder_manager_rename_item_get_type (void) G_GNUC_CONST ;
static void scratch_folder_manager_folder_item_real_on_changed (ScratchFolderManagerFolderItem* self,
                                                         GFile* source,
                                                         GFile* dest,
                                                         GFileMonitorEvent event);
static ScratchFolderManagerItem* scratch_folder_manager_folder_item_find_item_for_path (ScratchFolderManagerFolderItem* self,
                                                                                 const gchar* path);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN ScratchFolderManagerRenameItem* scratch_folder_manager_rename_item_new (const gchar* name,
                                                                        gboolean is_folder);
VALA_EXTERN ScratchFolderManagerRenameItem* scratch_folder_manager_rename_item_construct (GType object_type,
                                                                              const gchar* name,
                                                                              gboolean is_folder);
static gboolean __lambda88_ (Block11Data* _data11_);
static gboolean __lambda89_ (Block11Data* _data11_);
static gboolean ___lambda89__gsource_func (gpointer self);
static gboolean ___lambda88__gsource_func (gpointer self);
static GObject * scratch_folder_manager_folder_item_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void _scratch_folder_manager_folder_item_on_toggled_granite_widgets_source_list_expandable_item_toggled (GraniteWidgetsSourceListExpandableItem* _sender,
                                                                                                         gpointer self);
static void _scratch_folder_manager_folder_item_on_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                            GFile* file,
                                                                            GFile* other_file,
                                                                            GFileMonitorEvent event_type,
                                                                            gpointer self);
static void scratch_folder_manager_folder_item_finalize (GObject * obj);
static GType scratch_folder_manager_folder_item_get_type_once (void);
static void scratch_folder_manager_rename_item_on_edited (ScratchFolderManagerRenameItem* self,
                                                   const gchar* new_name);
VALA_EXTERN gboolean scratch_folder_manager_rename_item_get_is_folder (ScratchFolderManagerRenameItem* self);
static void scratch_folder_manager_rename_item_set_is_folder (ScratchFolderManagerRenameItem* self,
                                                       gboolean value);
static GObject * scratch_folder_manager_rename_item_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void _scratch_folder_manager_rename_item_on_edited_granite_widgets_source_list_item_edited (GraniteWidgetsSourceListItem* _sender,
                                                                                            const gchar* new_name,
                                                                                            gpointer self);
static void scratch_folder_manager_rename_item_finalize (GObject * obj);
static GType scratch_folder_manager_rename_item_get_type_once (void);
static void _vala_scratch_folder_manager_rename_item_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_scratch_folder_manager_rename_item_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
scratch_folder_manager_folder_item_get_instance_private (ScratchFolderManagerFolderItem* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerFolderItem_private_offset);
}

ScratchFolderManagerFolderItem*
scratch_folder_manager_folder_item_construct (GType object_type,
                                              ScratchFolderManagerFile* file,
                                              ScratchFolderManagerFileView* view)
{
	ScratchFolderManagerFolderItem * self = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	_vala_return_val_if_fail (scratch_folder_manager_file_is_valid_directory, "file.is_valid_directory", NULL);
	self = (ScratchFolderManagerFolderItem*) g_object_new (object_type, "file", file, "view", view, NULL);
	return self;
}

ScratchFolderManagerFolderItem*
scratch_folder_manager_folder_item_new (ScratchFolderManagerFile* file,
                                        ScratchFolderManagerFileView* view)
{
	return scratch_folder_manager_folder_item_construct (SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, file, view);
}

static void
scratch_folder_manager_folder_item_on_toggled (ScratchFolderManagerFolderItem* self)
{
	ScratchFolderManagerProjectFolderItem* root = NULL;
	ScratchFolderManagerProjectFolderItem* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = scratch_folder_manager_item_get_root_folder ((ScratchFolderManagerItem*) self, NULL);
	root = _tmp0_;
	if (!self->priv->children_loaded) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = granite_widgets_source_list_expandable_item_get_expanded ((GraniteWidgetsSourceListExpandableItem*) self);
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		guint _tmp6_;
		guint _tmp7_;
		_tmp6_ = granite_widgets_source_list_expandable_item_get_n_children ((GraniteWidgetsSourceListExpandableItem*) self);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ <= ((guint) 1);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ScratchFolderManagerFile* _tmp8_;
		ScratchFolderManagerFile* _tmp9_;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp8_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = scratch_folder_manager_file_get_children (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_collection_get_size (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp1_ = _tmp14_ > 0;
		_g_object_unref0 (_tmp12_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ScratchFolderManagerProjectFolderItem* _tmp39_;
		{
			GeeIterator* _child_it = NULL;
			ScratchFolderManagerFile* _tmp15_;
			ScratchFolderManagerFile* _tmp16_;
			GeeCollection* _tmp17_;
			GeeCollection* _tmp18_;
			GeeCollection* _tmp19_;
			GeeIterator* _tmp20_;
			GeeIterator* _tmp21_;
			_tmp15_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
			_tmp16_ = _tmp15_;
			_tmp17_ = scratch_folder_manager_file_get_children (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			_tmp20_ = gee_iterable_iterator ((GeeIterable*) _tmp19_);
			_tmp21_ = _tmp20_;
			_g_object_unref0 (_tmp19_);
			_child_it = _tmp21_;
			while (TRUE) {
				GeeIterator* _tmp22_;
				ScratchFolderManagerFile* child = NULL;
				GeeIterator* _tmp23_;
				gpointer _tmp24_;
				GraniteWidgetsSourceListItem* item = NULL;
				ScratchFolderManagerFile* _tmp25_;
				GraniteWidgetsSourceListItem* _tmp37_;
				_tmp22_ = _child_it;
				if (!gee_iterator_next (_tmp22_)) {
					break;
				}
				_tmp23_ = _child_it;
				_tmp24_ = gee_iterator_get (_tmp23_);
				child = (ScratchFolderManagerFile*) _tmp24_;
				item = NULL;
				_tmp25_ = child;
				if (scratch_folder_manager_file_is_valid_directory (_tmp25_, TRUE)) {
					ScratchFolderManagerFile* _tmp26_;
					ScratchFolderManagerFileView* _tmp27_;
					ScratchFolderManagerFileView* _tmp28_;
					ScratchFolderManagerFolderItem* _tmp29_;
					_tmp26_ = child;
					_tmp27_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = scratch_folder_manager_folder_item_new (_tmp26_, _tmp28_);
					_g_object_unref0 (item);
					item = (GraniteWidgetsSourceListItem*) _tmp29_;
				} else {
					ScratchFolderManagerFile* _tmp30_;
					gboolean _tmp31_;
					gboolean _tmp32_;
					_tmp30_ = child;
					_tmp31_ = scratch_folder_manager_file_get_is_valid_textfile (_tmp30_);
					_tmp32_ = _tmp31_;
					if (_tmp32_) {
						ScratchFolderManagerFile* _tmp33_;
						ScratchFolderManagerFileView* _tmp34_;
						ScratchFolderManagerFileView* _tmp35_;
						ScratchFolderManagerFileItem* _tmp36_;
						_tmp33_ = child;
						_tmp34_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
						_tmp35_ = _tmp34_;
						_tmp36_ = scratch_folder_manager_file_item_new (_tmp33_, _tmp35_);
						_g_object_unref0 (item);
						item = (GraniteWidgetsSourceListItem*) _tmp36_;
					}
				}
				_tmp37_ = item;
				if (_tmp37_ != NULL) {
					GraniteWidgetsSourceListItem* _tmp38_;
					_tmp38_ = item;
					scratch_folder_manager_folder_item_add (self, _tmp38_);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (child);
			}
			_g_object_unref0 (_child_it);
		}
		self->priv->children_loaded = TRUE;
		_tmp39_ = root;
		if (_tmp39_ != NULL) {
			ScratchFolderManagerProjectFolderItem* _tmp40_;
			_tmp40_ = root;
			scratch_folder_manager_project_folder_item_child_folder_loaded (_tmp40_, self);
		}
	} else {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_;
		gboolean _tmp44_;
		_tmp43_ = granite_widgets_source_list_expandable_item_get_expanded ((GraniteWidgetsSourceListExpandableItem*) self);
		_tmp44_ = _tmp43_;
		if (!_tmp44_) {
			ScratchFolderManagerProjectFolderItem* _tmp45_;
			_tmp45_ = root;
			_tmp42_ = _tmp45_ != NULL;
		} else {
			_tmp42_ = FALSE;
		}
		if (_tmp42_) {
			ScratchFolderManagerProjectFolderItem* _tmp46_;
			ScratchServicesMonitoredRepository* _tmp47_;
			ScratchServicesMonitoredRepository* _tmp48_;
			_tmp46_ = root;
			_tmp47_ = scratch_folder_manager_project_folder_item_get_monitored_repo (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp41_ = _tmp48_ != NULL;
		} else {
			_tmp41_ = FALSE;
		}
		if (_tmp41_) {
			ScratchFolderManagerProjectFolderItem* _tmp49_;
			_tmp49_ = root;
			scratch_folder_manager_project_folder_item_update_item_status (_tmp49_, self);
		}
	}
	_g_object_unref0 (root);
}

static void
__lambda84_ (ScratchFolderManagerFolderItem* self)
{
	ScratchFolderManagerFileView* _tmp0_;
	ScratchFolderManagerFileView* _tmp1_;
	ScratchFolderManagerFileView* _tmp2_;
	ScratchFolderManagerFileView* _tmp3_;
	_tmp0_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	scratch_folder_manager_file_view_set_ignore_next_select (_tmp1_, TRUE);
	_tmp2_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp3_ = _tmp2_;
	granite_widgets_source_list_start_editing_item ((GraniteWidgetsSourceList*) _tmp3_, (GraniteWidgetsSourceListItem*) self);
}

static void
___lambda84__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda84_ ((ScratchFolderManagerFolderItem*) self);
}

static void
_scratch_folder_manager_item_trash_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                           gpointer self)
{
	scratch_folder_manager_item_trash ((ScratchFolderManagerItem*) self);
}

static GtkMenu*
scratch_folder_manager_folder_item_real_get_context_menu (GraniteWidgetsSourceListItem* base)
{
	ScratchFolderManagerFolderItem * self;
	GtkMenuItem* open_in_terminal_pane_item = NULL;
	gchar* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	ScratchFolderManagerFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GVariant* _tmp6_;
	GtkMenuItem* _tmp7_ = NULL;
	GtkMenuItem* _tmp8_;
	GtkMenu* contractor_menu = NULL;
	GtkMenu* _tmp9_;
	GFileInfo* info = NULL;
	const gchar* file_type = NULL;
	GFileInfo* _tmp21_;
	GtkMenuItem* contractor_item = NULL;
	GtkMenuItem* _tmp43_;
	GtkMenu* _tmp44_;
	GtkMenuItem* rename_menu_item = NULL;
	GtkMenuItem* _tmp45_;
	GtkMenuItem* delete_item = NULL;
	GtkMenuItem* _tmp46_;
	GtkMenuItem* search_item = NULL;
	gchar* _tmp47_;
	ScratchFolderManagerFile* _tmp48_;
	ScratchFolderManagerFile* _tmp49_;
	GFile* _tmp50_;
	GFile* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GVariant* _tmp54_;
	GtkMenuItem* _tmp55_ = NULL;
	GtkMenuItem* _tmp56_;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp57_;
	GtkMenuItem* _tmp58_;
	GFileInfo* _tmp59_;
	const gchar* _tmp60_;
	GtkMenuItem* _tmp61_;
	GtkMenuItem* _tmp62_;
	GtkSeparatorMenuItem* _tmp63_;
	GtkSeparatorMenuItem* _tmp64_;
	GtkMenuItem* _tmp65_;
	GtkMenuItem* _tmp66_;
	GtkSeparatorMenuItem* _tmp67_;
	GtkSeparatorMenuItem* _tmp68_;
	GError* _inner_error0_ = NULL;
	GtkMenu* result;
	self = (ScratchFolderManagerFolderItem*) base;
	_tmp0_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_OPEN_IN_TERMINAL);
	_tmp1_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = scratch_folder_manager_file_get_path (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_new_string (_tmp5_);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in Terminal Pane"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp7_, _tmp0_);
	_g_free0 (_tmp0_);
	g_object_set ((GtkActionable*) _tmp7_, "action-target", _tmp6_, NULL);
	_g_variant_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	open_in_terminal_pane_item = _tmp8_;
	_tmp9_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp9_);
	contractor_menu = _tmp9_;
	info = NULL;
	file_type = NULL;
	{
		GFileInfo* _tmp10_ = NULL;
		ScratchFolderManagerFile* _tmp11_;
		ScratchFolderManagerFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFileInfo* _tmp15_;
		GFileInfo* _tmp16_;
		GFileInfo* _tmp17_;
		const gchar* _tmp18_;
		_tmp11_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = scratch_folder_manager_file_get_file (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_query_info (_tmp14_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp10_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = _tmp10_;
		_tmp10_ = NULL;
		_g_object_unref0 (info);
		info = _tmp16_;
		_tmp17_ = info;
		_tmp18_ = g_file_info_get_content_type (_tmp17_);
		file_type = _tmp18_;
		_g_object_unref0 (_tmp10_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("FolderItem.vala:105: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (contractor_menu);
		_g_object_unref0 (open_in_terminal_pane_item);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp21_ = info;
	if (_tmp21_ != NULL) {
		{
			GeeList* contracts = NULL;
			const gchar* _tmp22_;
			GeeList* _tmp23_;
			_tmp22_ = file_type;
			_tmp23_ = granite_services_contractor_proxy_get_contracts_by_mime (_tmp22_, &_inner_error0_);
			contracts = _tmp23_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			{
				GeeList* _contract_list = NULL;
				GeeList* _tmp24_;
				gint _contract_size = 0;
				GeeList* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				gint _contract_index = 0;
				_tmp24_ = contracts;
				_contract_list = _tmp24_;
				_tmp25_ = _contract_list;
				_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
				_tmp27_ = _tmp26_;
				_contract_size = _tmp27_;
				_contract_index = -1;
				while (TRUE) {
					gint _tmp28_;
					gint _tmp29_;
					GraniteServicesContract* contract = NULL;
					GeeList* _tmp30_;
					gpointer _tmp31_;
					ContractMenuItem* menu_item = NULL;
					GraniteServicesContract* _tmp32_;
					ScratchFolderManagerFile* _tmp33_;
					ScratchFolderManagerFile* _tmp34_;
					GFile* _tmp35_;
					GFile* _tmp36_;
					ContractMenuItem* _tmp37_;
					GtkMenu* _tmp38_;
					ContractMenuItem* _tmp39_;
					ContractMenuItem* _tmp40_;
					_contract_index = _contract_index + 1;
					_tmp28_ = _contract_index;
					_tmp29_ = _contract_size;
					if (!(_tmp28_ < _tmp29_)) {
						break;
					}
					_tmp30_ = _contract_list;
					_tmp31_ = gee_list_get (_tmp30_, _contract_index);
					contract = (GraniteServicesContract*) _tmp31_;
					_tmp32_ = contract;
					_tmp33_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
					_tmp34_ = _tmp33_;
					_tmp35_ = scratch_folder_manager_file_get_file (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = contract_menu_item_new (_tmp32_, _tmp36_);
					g_object_ref_sink (_tmp37_);
					menu_item = _tmp37_;
					_tmp38_ = contractor_menu;
					_tmp39_ = menu_item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp38_, (GtkMenuItem*) _tmp39_);
					_tmp40_ = menu_item;
					gtk_widget_show_all ((GtkWidget*) _tmp40_);
					_g_object_unref0 (menu_item);
					_g_object_unref0 (contract);
				}
			}
			_g_object_unref0 (contracts);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp41_;
			const gchar* _tmp42_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			g_warning ("FolderItem.vala:117: %s", _tmp42_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (contractor_menu);
			_g_object_unref0 (open_in_terminal_pane_item);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp43_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Other Actions"));
	g_object_ref_sink (_tmp43_);
	contractor_item = _tmp43_;
	_tmp44_ = contractor_menu;
	gtk_menu_item_set_submenu (contractor_item, _tmp44_);
	_tmp45_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Rename"));
	g_object_ref_sink (_tmp45_);
	rename_menu_item = _tmp45_;
	g_signal_connect_object (rename_menu_item, "activate", (GCallback) ___lambda84__gtk_menu_item_activate, self, 0);
	_tmp46_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Move to Trash"));
	g_object_ref_sink (_tmp46_);
	delete_item = _tmp46_;
	g_signal_connect_object (delete_item, "activate", (GCallback) _scratch_folder_manager_item_trash_gtk_menu_item_activate, (ScratchFolderManagerItem*) self, 0);
	_tmp47_ = g_strdup ("win.action_find_global");
	_tmp48_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = scratch_folder_manager_file_get_file (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_file_get_path (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = g_variant_new_string (_tmp53_);
	g_variant_ref_sink (_tmp54_);
	_tmp55_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Find in Folder…"));
	gtk_actionable_set_action_name ((GtkActionable*) _tmp55_, _tmp47_);
	_g_free0 (_tmp47_);
	g_object_set ((GtkActionable*) _tmp55_, "action-target", _tmp54_, NULL);
	_g_variant_unref0 (_tmp54_);
	g_object_ref_sink (_tmp55_);
	_tmp56_ = _tmp55_;
	_g_free0 (_tmp53_);
	search_item = _tmp56_;
	_tmp57_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp57_);
	menu = _tmp57_;
	_tmp58_ = open_in_terminal_pane_item;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp58_);
	_tmp59_ = info;
	_tmp60_ = file_type;
	_tmp61_ = scratch_folder_manager_folder_item_create_submenu_for_open_in (self, _tmp59_, _tmp60_);
	_tmp62_ = _tmp61_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp62_);
	_g_object_unref0 (_tmp62_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, contractor_item);
	_tmp63_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp63_);
	_tmp64_ = _tmp63_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) _tmp64_);
	_g_object_unref0 (_tmp64_);
	_tmp65_ = scratch_folder_manager_folder_item_create_submenu_for_new (self);
	_tmp66_ = _tmp65_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, _tmp66_);
	_g_object_unref0 (_tmp66_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, rename_menu_item);
	gtk_menu_shell_append ((GtkMenuShell*) menu, delete_item);
	_tmp67_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp67_);
	_tmp68_ = _tmp67_;
	gtk_menu_shell_append ((GtkMenuShell*) menu, (GtkMenuItem*) _tmp68_);
	_g_object_unref0 (_tmp68_);
	gtk_menu_shell_append ((GtkMenuShell*) menu, search_item);
	gtk_widget_show_all ((GtkWidget*) menu);
	result = menu;
	_g_object_unref0 (search_item);
	_g_object_unref0 (delete_item);
	_g_object_unref0 (rename_menu_item);
	_g_object_unref0 (contractor_item);
	_g_object_unref0 (info);
	_g_object_unref0 (contractor_menu);
	_g_object_unref0 (open_in_terminal_pane_item);
	return result;
}

static void
__lambda85_ (ScratchFolderManagerFolderItem* self)
{
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	scratch_folder_manager_item_show_app_chooser ((ScratchFolderManagerItem*) self, _tmp1_);
}

static void
___lambda85__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda85_ ((ScratchFolderManagerFolderItem*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ScratchFolderManagerFolderItem* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->app_info);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
_____lambda86_ (Block10Data* _data10_)
{
	ScratchFolderManagerFolderItem* self;
	GAppInfo* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	ScratchFolderManagerFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	self = _data10_->self;
	_tmp0_ = _data10_->app_info;
	_tmp1_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = scratch_folder_manager_file_get_file (_tmp2_);
	_tmp4_ = _tmp3_;
	scratch_folder_manager_item_launch_app_with_file ((ScratchFolderManagerItem*) self, _tmp0_, _tmp4_);
}

static void
______lambda86__gtk_menu_item_activate (GtkMenuItem* _sender,
                                        gpointer self)
{
	_____lambda86_ (self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GtkMenuItem*
scratch_folder_manager_folder_item_create_submenu_for_open_in (ScratchFolderManagerFolderItem* self,
                                                               GFileInfo* info,
                                                               const gchar* file_type)
{
	GtkMenuItem* other_menuitem = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* _tmp1_;
	const gchar* _tmp2_ = NULL;
	GtkMenu* open_in_menu = NULL;
	GtkMenu* _tmp3_;
	GtkMenu* _tmp32_;
	GList* _tmp33_;
	GList* _tmp34_;
	gboolean _tmp35_;
	GtkMenu* _tmp39_;
	GtkMenuItem* _tmp40_;
	GtkMenuItem* open_in_item = NULL;
	GtkMenuItem* _tmp41_;
	GtkMenu* _tmp42_;
	GtkMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Other Application…"));
	g_object_ref_sink (_tmp0_);
	other_menuitem = _tmp0_;
	_tmp1_ = other_menuitem;
	g_signal_connect_object (_tmp1_, "activate", (GCallback) ___lambda85__gtk_menu_item_activate, self, 0);
	_tmp2_ = file_type;
	if (_tmp2_ == NULL) {
		_tmp2_ = "inode/directory";
	}
	file_type = _tmp2_;
	_tmp3_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp3_);
	open_in_menu = _tmp3_;
	if (info != NULL) {
		GList* external_apps = NULL;
		GList* _tmp4_;
		gchar* this_id = NULL;
		GApplication* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GList* _tmp9_;
		_tmp4_ = g_app_info_get_all_for_type (file_type);
		external_apps = _tmp4_;
		_tmp5_ = g_application_get_default ();
		_tmp6_ = g_application_get_application_id (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, ".desktop", NULL);
		this_id = _tmp8_;
		_tmp9_ = external_apps;
		{
			GList* app_info_collection = NULL;
			GList* app_info_it = NULL;
			app_info_collection = _tmp9_;
			for (app_info_it = app_info_collection; app_info_it != NULL; app_info_it = app_info_it->next) {
				GAppInfo* _tmp10_;
				GAppInfo* app_info = NULL;
				_tmp10_ = _g_object_ref0 ((GAppInfo*) app_info_it->data);
				app_info = _tmp10_;
				{
					Block10Data* _data10_;
					GAppInfo* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GtkImage* menuitem_icon = NULL;
					GAppInfo* _tmp14_;
					GIcon* _tmp15_;
					GtkImage* _tmp16_;
					GtkImage* _tmp17_;
					GtkGrid* menuitem_grid = NULL;
					GtkGrid* _tmp18_;
					GtkGrid* _tmp19_;
					GtkImage* _tmp20_;
					GtkGrid* _tmp21_;
					GAppInfo* _tmp22_;
					const gchar* _tmp23_;
					GtkLabel* _tmp24_;
					GtkLabel* _tmp25_;
					GtkMenuItem* item_app = NULL;
					GtkMenuItem* _tmp26_;
					GtkMenuItem* _tmp27_;
					GtkGrid* _tmp28_;
					GtkMenuItem* _tmp29_;
					GtkMenu* _tmp30_;
					GtkMenuItem* _tmp31_;
					_data10_ = g_slice_new0 (Block10Data);
					_data10_->_ref_count_ = 1;
					_data10_->self = g_object_ref (self);
					_data10_->app_info = app_info;
					_tmp11_ = _data10_->app_info;
					_tmp12_ = g_app_info_get_id (_tmp11_);
					_tmp13_ = this_id;
					if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
						block10_data_unref (_data10_);
						_data10_ = NULL;
						continue;
					}
					_tmp14_ = _data10_->app_info;
					_tmp15_ = g_app_info_get_icon (_tmp14_);
					_tmp16_ = (GtkImage*) gtk_image_new_from_gicon (_tmp15_, (GtkIconSize) GTK_ICON_SIZE_MENU);
					g_object_ref_sink (_tmp16_);
					menuitem_icon = _tmp16_;
					_tmp17_ = menuitem_icon;
					gtk_image_set_pixel_size (_tmp17_, 16);
					_tmp18_ = (GtkGrid*) gtk_grid_new ();
					g_object_ref_sink (_tmp18_);
					menuitem_grid = _tmp18_;
					_tmp19_ = menuitem_grid;
					_tmp20_ = menuitem_icon;
					gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
					_tmp21_ = menuitem_grid;
					_tmp22_ = _data10_->app_info;
					_tmp23_ = g_app_info_get_name (_tmp22_);
					_tmp24_ = (GtkLabel*) gtk_label_new (_tmp23_);
					g_object_ref_sink (_tmp24_);
					_tmp25_ = _tmp24_;
					gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp25_);
					_g_object_unref0 (_tmp25_);
					_tmp26_ = (GtkMenuItem*) gtk_menu_item_new ();
					g_object_ref_sink (_tmp26_);
					item_app = _tmp26_;
					_tmp27_ = item_app;
					_tmp28_ = menuitem_grid;
					gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
					_tmp29_ = item_app;
					g_signal_connect_data (_tmp29_, "activate", (GCallback) ______lambda86__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
					_tmp30_ = open_in_menu;
					_tmp31_ = item_app;
					gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
					_g_object_unref0 (item_app);
					_g_object_unref0 (menuitem_grid);
					_g_object_unref0 (menuitem_icon);
					block10_data_unref (_data10_);
					_data10_ = NULL;
				}
			}
		}
		_g_free0 (this_id);
		(external_apps == NULL) ? NULL : (external_apps = (_g_list_free__g_object_unref0_ (external_apps), NULL));
	}
	_tmp32_ = open_in_menu;
	_tmp33_ = gtk_container_get_children ((GtkContainer*) _tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_list_length (_tmp34_) > ((guint) 0);
	(_tmp34_ == NULL) ? NULL : (_tmp34_ = (g_list_free (_tmp34_), NULL));
	if (_tmp35_) {
		GtkMenu* _tmp36_;
		GtkSeparatorMenuItem* _tmp37_;
		GtkSeparatorMenuItem* _tmp38_;
		_tmp36_ = open_in_menu;
		_tmp37_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp37_);
		_tmp38_ = _tmp37_;
		gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp38_);
		_g_object_unref0 (_tmp38_);
	}
	_tmp39_ = open_in_menu;
	_tmp40_ = other_menuitem;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open In"));
	g_object_ref_sink (_tmp41_);
	open_in_item = _tmp41_;
	_tmp42_ = open_in_menu;
	gtk_menu_item_set_submenu (open_in_item, _tmp42_);
	result = open_in_item;
	_g_object_unref0 (open_in_menu);
	_g_object_unref0 (other_menuitem);
	return result;
}

static void
__lambda87_ (ScratchFolderManagerFolderItem* self)
{
	scratch_folder_manager_folder_item_on_add_new (self, TRUE);
}

static void
___lambda87__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda87_ ((ScratchFolderManagerFolderItem*) self);
}

static void
__lambda90_ (ScratchFolderManagerFolderItem* self)
{
	scratch_folder_manager_folder_item_on_add_new (self, FALSE);
}

static void
___lambda90__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda90_ ((ScratchFolderManagerFolderItem*) self);
}

GtkMenuItem*
scratch_folder_manager_folder_item_create_submenu_for_new (ScratchFolderManagerFolderItem* self)
{
	GtkMenuItem* new_folder_item = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* new_file_item = NULL;
	GtkMenuItem* _tmp1_;
	GtkMenu* new_menu = NULL;
	GtkMenu* _tmp2_;
	GtkMenuItem* new_item = NULL;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Folder"));
	g_object_ref_sink (_tmp0_);
	new_folder_item = _tmp0_;
	g_signal_connect_object (new_folder_item, "activate", (GCallback) ___lambda87__gtk_menu_item_activate, self, 0);
	_tmp1_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Empty File"));
	g_object_ref_sink (_tmp1_);
	new_file_item = _tmp1_;
	g_signal_connect_object (new_file_item, "activate", (GCallback) ___lambda90__gtk_menu_item_activate, self, 0);
	_tmp2_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp2_);
	new_menu = _tmp2_;
	gtk_menu_shell_append ((GtkMenuShell*) new_menu, new_folder_item);
	gtk_menu_shell_append ((GtkMenuShell*) new_menu, new_file_item);
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("New"));
	g_object_ref_sink (_tmp3_);
	new_item = _tmp3_;
	gtk_menu_item_set_submenu (new_item, new_menu);
	result = new_item;
	_g_object_unref0 (new_menu);
	_g_object_unref0 (new_file_item);
	_g_object_unref0 (new_folder_item);
	return result;
}

void
scratch_folder_manager_folder_item_remove_all_badges (ScratchFolderManagerFolderItem* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _child_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = granite_widgets_source_list_expandable_item_get_children ((GraniteWidgetsSourceListExpandableItem*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_child_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GraniteWidgetsSourceListItem* _tmp8_;
			_tmp5_ = _child_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _child_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			child = (GraniteWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = child;
			scratch_folder_manager_folder_item_remove_badge (self, _tmp8_);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

static void
scratch_folder_manager_folder_item_remove_badge (ScratchFolderManagerFolderItem* self,
                                                 GraniteWidgetsSourceListItem* item)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (item)) {
		scratch_folder_manager_folder_item_remove_all_badges (G_TYPE_CHECK_INSTANCE_CAST (item, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem));
	}
	granite_widgets_source_list_item_set_badge (item, "");
}

void
scratch_folder_manager_folder_item_add (ScratchFolderManagerFolderItem* self,
                                        GraniteWidgetsSourceListItem* item)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (self->priv->has_dummy) {
		guint _tmp1_;
		guint _tmp2_;
		_tmp1_ = granite_widgets_source_list_expandable_item_get_n_children ((GraniteWidgetsSourceListExpandableItem*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == ((guint) 1);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GraniteWidgetsSourceListItem* _tmp3_;
		_tmp3_ = self->priv->dummy;
		granite_widgets_source_list_expandable_item_remove (G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem), _tmp3_);
		self->priv->has_dummy = FALSE;
	}
	granite_widgets_source_list_expandable_item_add (G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem), item);
}

void
scratch_folder_manager_folder_item_remove (ScratchFolderManagerFolderItem* self,
                                           GraniteWidgetsSourceListItem* item)
{
	ScratchFolderManagerFileView* _tmp12_;
	ScratchFolderManagerFileView* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	if (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (item)) {
		ScratchFolderManagerFolderItem* folder = NULL;
		ScratchFolderManagerFolderItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (item, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem));
		folder = _tmp0_;
		{
			GeeIterator* _child_it = NULL;
			ScratchFolderManagerFolderItem* _tmp1_;
			GeeCollection* _tmp2_;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeIterator* _tmp5_;
			GeeIterator* _tmp6_;
			_tmp1_ = folder;
			_tmp2_ = granite_widgets_source_list_expandable_item_get_children ((GraniteWidgetsSourceListExpandableItem*) _tmp1_);
			_tmp3_ = _tmp2_;
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			_child_it = _tmp6_;
			while (TRUE) {
				GeeIterator* _tmp7_;
				GraniteWidgetsSourceListItem* child = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				ScratchFolderManagerFolderItem* _tmp10_;
				GraniteWidgetsSourceListItem* _tmp11_;
				_tmp7_ = _child_it;
				if (!gee_iterator_next (_tmp7_)) {
					break;
				}
				_tmp8_ = _child_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				child = (GraniteWidgetsSourceListItem*) _tmp9_;
				_tmp10_ = folder;
				_tmp11_ = child;
				scratch_folder_manager_folder_item_remove (_tmp10_, _tmp11_);
				_g_object_unref0 (child);
			}
			_g_object_unref0 (_child_it);
		}
		_g_object_unref0 (folder);
	}
	_tmp12_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp13_ = _tmp12_;
	scratch_folder_manager_file_view_set_ignore_next_select (_tmp13_, TRUE);
	granite_widgets_source_list_expandable_item_remove (G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem), item);
	if (SCRATCH_FOLDER_MANAGER_IS_RENAME_ITEM (item)) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = self->priv->has_dummy;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		guint _tmp16_;
		guint _tmp17_;
		_tmp16_ = granite_widgets_source_list_expandable_item_get_n_children ((GraniteWidgetsSourceListExpandableItem*) self);
		_tmp17_ = _tmp16_;
		_tmp14_ = _tmp17_ > ((guint) 0);
	}
	if (!_tmp14_) {
		GraniteWidgetsSourceListItem* _tmp18_;
		_tmp18_ = self->priv->dummy;
		granite_widgets_source_list_expandable_item_add (G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem), _tmp18_);
		self->priv->has_dummy = TRUE;
	}
}

void
scratch_folder_manager_folder_item_clear (ScratchFolderManagerFolderItem* self)
{
	g_return_if_fail (self != NULL);
	granite_widgets_source_list_expandable_item_clear (G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem));
	self->priv->has_dummy = FALSE;
}

static void
scratch_folder_manager_folder_item_real_on_changed (ScratchFolderManagerFolderItem* self,
                                                    GFile* source,
                                                    GFile* dest,
                                                    GFileMonitorEvent event)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	ScratchFolderManagerFileView* _tmp3_;
	ScratchFolderManagerFileView* _tmp4_;
	g_return_if_fail (source != NULL);
	_tmp0_ = g_file_get_basename (source);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_str_has_prefix (_tmp1_, ".goutputstream");
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp4_ = _tmp3_;
	scratch_folder_manager_file_view_folder_item_update_hook (_tmp4_, source, dest, event);
	if (!self->priv->children_loaded) {
		switch (event) {
			case G_FILE_MONITOR_EVENT_DELETED:
			{
				ScratchFolderManagerFile* _tmp5_;
				ScratchFolderManagerFile* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp5_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
				_tmp6_ = _tmp5_;
				scratch_folder_manager_file_invalidate_cache (_tmp6_);
				_tmp7_ = granite_widgets_source_list_expandable_item_get_expanded ((GraniteWidgetsSourceListExpandableItem*) self);
				_tmp8_ = _tmp7_;
				if (_tmp8_) {
					g_signal_emit_by_name ((GraniteWidgetsSourceListExpandableItem*) self, "toggled");
				}
				break;
			}
			case G_FILE_MONITOR_EVENT_CREATED:
			{
				ScratchFolderManagerFile* _tmp9_;
				ScratchFolderManagerFile* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp9_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
				_tmp10_ = _tmp9_;
				scratch_folder_manager_file_invalidate_cache (_tmp10_);
				_tmp11_ = granite_widgets_source_list_expandable_item_get_expanded ((GraniteWidgetsSourceListExpandableItem*) self);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					g_signal_emit_by_name ((GraniteWidgetsSourceListExpandableItem*) self, "toggled");
				}
				break;
			}
			case G_FILE_MONITOR_EVENT_RENAMED:
			case G_FILE_MONITOR_EVENT_PRE_UNMOUNT:
			case G_FILE_MONITOR_EVENT_UNMOUNTED:
			case G_FILE_MONITOR_EVENT_CHANGED:
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
			case G_FILE_MONITOR_EVENT_MOVED:
			case G_FILE_MONITOR_EVENT_MOVED_IN:
			case G_FILE_MONITOR_EVENT_MOVED_OUT:
			case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
			{
				break;
			}
			default:
			break;
		}
	} else {
		switch (event) {
			case G_FILE_MONITOR_EVENT_DELETED:
			{
				ScratchFolderManagerItem* path_item = NULL;
				gchar* _tmp13_;
				gchar* _tmp14_;
				ScratchFolderManagerItem* _tmp15_;
				ScratchFolderManagerItem* _tmp16_;
				ScratchFolderManagerItem* _tmp17_;
				_tmp13_ = g_file_get_path (source);
				_tmp14_ = _tmp13_;
				_tmp15_ = scratch_folder_manager_folder_item_find_item_for_path (self, _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				path_item = _tmp16_;
				_tmp17_ = path_item;
				if (_tmp17_ != NULL) {
					ScratchFolderManagerItem* _tmp18_;
					_tmp18_ = path_item;
					scratch_folder_manager_folder_item_remove (self, (GraniteWidgetsSourceListItem*) _tmp18_);
				}
				_g_object_unref0 (path_item);
				break;
			}
			case G_FILE_MONITOR_EVENT_CREATED:
			{
				ScratchFolderManagerItem* path_item = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_;
				ScratchFolderManagerItem* _tmp21_;
				ScratchFolderManagerItem* _tmp22_;
				ScratchFolderManagerItem* _tmp23_;
				if (g_file_query_exists (source, NULL) == FALSE) {
					return;
				}
				_tmp19_ = g_file_get_path (source);
				_tmp20_ = _tmp19_;
				_tmp21_ = scratch_folder_manager_folder_item_find_item_for_path (self, _tmp20_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				path_item = _tmp22_;
				_tmp23_ = path_item;
				if (_tmp23_ == NULL) {
					ScratchFolderManagerFile* file = NULL;
					gchar* _tmp24_;
					gchar* _tmp25_;
					ScratchFolderManagerFile* _tmp26_;
					ScratchFolderManagerFile* _tmp27_;
					ScratchFolderManagerFile* _tmp28_;
					ScratchFolderManagerItem* _tmp40_;
					_tmp24_ = g_file_get_path (source);
					_tmp25_ = _tmp24_;
					_tmp26_ = scratch_folder_manager_file_new (_tmp25_);
					_tmp27_ = _tmp26_;
					_g_free0 (_tmp25_);
					file = _tmp27_;
					_tmp28_ = file;
					if (scratch_folder_manager_file_is_valid_directory (_tmp28_, TRUE)) {
						ScratchFolderManagerFile* _tmp29_;
						ScratchFolderManagerFileView* _tmp30_;
						ScratchFolderManagerFileView* _tmp31_;
						ScratchFolderManagerFolderItem* _tmp32_;
						_tmp29_ = file;
						_tmp30_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
						_tmp31_ = _tmp30_;
						_tmp32_ = scratch_folder_manager_folder_item_new (_tmp29_, _tmp31_);
						_g_object_unref0 (path_item);
						path_item = (ScratchFolderManagerItem*) _tmp32_;
					} else {
						ScratchFolderManagerFile* _tmp33_;
						gboolean _tmp34_;
						gboolean _tmp35_;
						_tmp33_ = file;
						_tmp34_ = scratch_folder_manager_file_get_is_temporary (_tmp33_);
						_tmp35_ = _tmp34_;
						if (!_tmp35_) {
							ScratchFolderManagerFile* _tmp36_;
							ScratchFolderManagerFileView* _tmp37_;
							ScratchFolderManagerFileView* _tmp38_;
							ScratchFolderManagerFileItem* _tmp39_;
							_tmp36_ = file;
							_tmp37_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
							_tmp38_ = _tmp37_;
							_tmp39_ = scratch_folder_manager_file_item_new (_tmp36_, _tmp38_);
							_g_object_unref0 (path_item);
							path_item = (ScratchFolderManagerItem*) _tmp39_;
						} else {
							_g_object_unref0 (file);
							_g_object_unref0 (path_item);
							break;
						}
					}
					_tmp40_ = path_item;
					scratch_folder_manager_folder_item_add (self, (GraniteWidgetsSourceListItem*) _tmp40_);
					_g_object_unref0 (file);
				}
				_g_object_unref0 (path_item);
				break;
			}
			case G_FILE_MONITOR_EVENT_RENAMED:
			case G_FILE_MONITOR_EVENT_PRE_UNMOUNT:
			case G_FILE_MONITOR_EVENT_UNMOUNTED:
			case G_FILE_MONITOR_EVENT_CHANGED:
			case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
			case G_FILE_MONITOR_EVENT_MOVED:
			case G_FILE_MONITOR_EVENT_MOVED_IN:
			case G_FILE_MONITOR_EVENT_MOVED_OUT:
			case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
			{
				break;
			}
			default:
			break;
		}
	}
	if (event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
		ScratchFolderManagerProjectFolderItem* root = NULL;
		ScratchFolderManagerProjectFolderItem* _tmp41_;
		ScratchFolderManagerProjectFolderItem* _tmp42_;
		_tmp41_ = scratch_folder_manager_item_get_root_folder ((ScratchFolderManagerItem*) self, (GraniteWidgetsSourceListExpandableItem*) self);
		root = _tmp41_;
		_tmp42_ = root;
		if (_tmp42_ != NULL) {
			ScratchFolderManagerProjectFolderItem* _tmp43_;
			_tmp43_ = root;
			scratch_folder_manager_project_folder_item_child_folder_changed (_tmp43_, self);
		}
		_g_object_unref0 (root);
	}
}

void
scratch_folder_manager_folder_item_on_changed (ScratchFolderManagerFolderItem* self,
                                               GFile* source,
                                               GFile* dest,
                                               GFileMonitorEvent event)
{
	ScratchFolderManagerFolderItemClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_GET_CLASS (self);
	if (_klass_->on_changed) {
		_klass_->on_changed (self, source, dest, event);
	}
}

static ScratchFolderManagerItem*
scratch_folder_manager_folder_item_find_item_for_path (ScratchFolderManagerFolderItem* self,
                                                       const gchar* path)
{
	ScratchFolderManagerItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = granite_widgets_source_list_expandable_item_get_children ((GraniteWidgetsSourceListExpandableItem*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_item_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			GraniteWidgetsSourceListItem* _tmp9_;
			_tmp5_ = _item_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _item_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			item = (GraniteWidgetsSourceListItem*) _tmp7_;
			_tmp9_ = item;
			if (SCRATCH_FOLDER_MANAGER_IS_ITEM (_tmp9_)) {
				GraniteWidgetsSourceListItem* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp10_ = item;
				_tmp11_ = scratch_folder_manager_item_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
				_tmp12_ = _tmp11_;
				_tmp13_ = _tmp12_;
				_tmp8_ = g_strcmp0 (_tmp13_, path) == 0;
				_g_free0 (_tmp13_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GraniteWidgetsSourceListItem* _tmp14_;
				ScratchFolderManagerItem* _tmp15_;
				_tmp14_ = item;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
				result = _tmp15_;
				_g_object_unref0 (item);
				_g_object_unref0 (_item_it);
				return result;
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	result = NULL;
	return result;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ScratchFolderManagerFolderItem* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->rename_item);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
__lambda89_ (Block11Data* _data11_)
{
	ScratchFolderManagerFolderItem* self;
	ScratchFolderManagerFileView* _tmp0_;
	ScratchFolderManagerFileView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = _data11_->self;
	_tmp0_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = granite_widgets_source_list_get_editing ((GraniteWidgetsSourceList*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		result = G_SOURCE_CONTINUE;
		return result;
	} else {
		gchar* new_name = NULL;
		ScratchFolderManagerRenameItem* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		ScratchFolderManagerFileView* _tmp8_;
		ScratchFolderManagerFileView* _tmp9_;
		_tmp4_ = _data11_->rename_item;
		_tmp5_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		new_name = _tmp7_;
		_tmp8_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
		_tmp9_ = _tmp8_;
		scratch_folder_manager_file_view_set_ignore_next_select (_tmp9_, TRUE);
		{
			GFile* gfile = NULL;
			ScratchFolderManagerFile* _tmp10_;
			ScratchFolderManagerFile* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			const gchar* _tmp14_;
			GFile* _tmp15_;
			_tmp10_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = scratch_folder_manager_file_get_file (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = new_name;
			_tmp15_ = g_file_get_child_for_display_name (_tmp13_, _tmp14_, &_inner_error0_);
			gfile = _tmp15_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			if (_data11_->is_folder) {
				GFile* _tmp16_;
				_tmp16_ = gfile;
				g_file_make_directory (_tmp16_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (gfile);
					goto __catch0_g_error;
				}
			} else {
				GFile* _tmp17_;
				GFileOutputStream* _tmp18_;
				GFileOutputStream* _tmp19_;
				ScratchFolderManagerFileView* _tmp20_;
				ScratchFolderManagerFileView* _tmp21_;
				GFile* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp17_ = gfile;
				_tmp18_ = g_file_create (_tmp17_, G_FILE_CREATE_NONE, NULL, &_inner_error0_);
				_tmp19_ = _tmp18_;
				_g_object_unref0 (_tmp19_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (gfile);
					goto __catch0_g_error;
				}
				_tmp20_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
				_tmp21_ = _tmp20_;
				_tmp22_ = gfile;
				_tmp23_ = g_file_get_path (_tmp22_);
				_tmp24_ = _tmp23_;
				g_signal_emit_by_name (_tmp21_, "select", _tmp24_);
				_g_free0 (_tmp24_);
			}
			_g_object_unref0 (gfile);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp25_;
			const gchar* _tmp26_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp25_ = e;
			_tmp26_ = _tmp25_->message;
			g_warning ("FolderItem.vala:400: %s", _tmp26_);
			_g_error_free0 (e);
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			ScratchFolderManagerRenameItem* _tmp27_;
			_tmp27_ = _data11_->rename_item;
			scratch_folder_manager_folder_item_remove (self, (GraniteWidgetsSourceListItem*) _tmp27_);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp28_ = FALSE;
			_g_free0 (new_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp28_;
		}
		_g_free0 (new_name);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda89__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda89_ (self);
	return result;
}

static gboolean
__lambda88_ (Block11Data* _data11_)
{
	ScratchFolderManagerFolderItem* self;
	ScratchFolderManagerFileView* _tmp0_;
	ScratchFolderManagerFileView* _tmp1_;
	ScratchFolderManagerRenameItem* _tmp2_;
	gboolean result;
	self = _data11_->self;
	_tmp0_ = scratch_folder_manager_item_get_view ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _data11_->rename_item;
	granite_widgets_source_list_start_editing_item ((GraniteWidgetsSourceList*) _tmp1_, (GraniteWidgetsSourceListItem*) _tmp2_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda89__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda88__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda88_ (self);
	return result;
}

static void
scratch_folder_manager_folder_item_on_add_new (ScratchFolderManagerFolderItem* self,
                                               gboolean is_folder)
{
	Block11Data* _data11_;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* name = NULL;
	GFile* new_file = NULL;
	ScratchFolderManagerFile* _tmp5_;
	ScratchFolderManagerFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	gint n = 0;
	GFile* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	ScratchFolderManagerRenameItem* _tmp24_;
	ScratchFolderManagerRenameItem* _tmp25_;
	ScratchFolderManagerRenameItem* _tmp26_;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->is_folder = is_folder;
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_is_executable (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		g_warning ("FolderItem.vala:366: Unable to open parent folder");
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	if (_data11_->is_folder) {
		_tmp4_ = _ ("untitled folder");
	} else {
		_tmp4_ = _ ("new file");
	}
	name = _tmp4_;
	_tmp5_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = scratch_folder_manager_file_get_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = name;
	_tmp10_ = g_file_get_child (_tmp8_, _tmp9_);
	new_file = _tmp10_;
	n = 1;
	while (TRUE) {
		GFile* _tmp11_;
		ScratchFolderManagerFile* _tmp12_;
		ScratchFolderManagerFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GFile* _tmp19_;
		gint _tmp20_;
		_tmp11_ = new_file;
		if (!g_file_query_exists (_tmp11_, NULL)) {
			break;
		}
		_tmp12_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = scratch_folder_manager_file_get_file (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = name;
		_tmp17_ = g_strdup_printf ("%s %d", _tmp16_, n);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_file_get_child (_tmp15_, _tmp18_);
		_g_object_unref0 (new_file);
		new_file = _tmp19_;
		_g_free0 (_tmp18_);
		_tmp20_ = n;
		n = _tmp20_ + 1;
	}
	granite_widgets_source_list_expandable_item_set_expanded ((GraniteWidgetsSourceListExpandableItem*) self, TRUE);
	_tmp21_ = new_file;
	_tmp22_ = g_file_get_basename (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = scratch_folder_manager_rename_item_new (_tmp23_, _data11_->is_folder);
	_tmp25_ = _tmp24_;
	_g_free0 (_tmp23_);
	_data11_->rename_item = _tmp25_;
	_tmp26_ = _data11_->rename_item;
	scratch_folder_manager_folder_item_add (self, (GraniteWidgetsSourceListItem*) _tmp26_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda88__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	_g_object_unref0 (new_file);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
_scratch_folder_manager_folder_item_on_toggled_granite_widgets_source_list_expandable_item_toggled (GraniteWidgetsSourceListExpandableItem* _sender,
                                                                                                    gpointer self)
{
	scratch_folder_manager_folder_item_on_toggled ((ScratchFolderManagerFolderItem*) self);
}

static void
_scratch_folder_manager_folder_item_on_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                                       GFile* file,
                                                                       GFile* other_file,
                                                                       GFileMonitorEvent event_type,
                                                                       gpointer self)
{
	scratch_folder_manager_folder_item_on_changed ((ScratchFolderManagerFolderItem*) self, file, other_file, event_type);
}

static GObject *
scratch_folder_manager_folder_item_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerFolderItem * self;
	GraniteWidgetsSourceListItem* _tmp0_;
	GraniteWidgetsSourceListItem* _tmp1_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_folder_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem);
	granite_widgets_source_list_item_set_selectable ((GraniteWidgetsSourceListItem*) self, FALSE);
	_tmp0_ = granite_widgets_source_list_item_new ("");
	_g_object_unref0 (self->priv->dummy);
	self->priv->dummy = _tmp0_;
	_tmp1_ = self->priv->dummy;
	granite_widgets_source_list_expandable_item_add (G_TYPE_CHECK_INSTANCE_CAST (self, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem), _tmp1_);
	self->priv->has_dummy = TRUE;
	g_signal_connect_object ((GraniteWidgetsSourceListExpandableItem*) self, "toggled", (GCallback) _scratch_folder_manager_folder_item_on_toggled_granite_widgets_source_list_expandable_item_toggled, self, 0);
	{
		GFileMonitor* _tmp2_ = NULL;
		ScratchFolderManagerFile* _tmp3_;
		ScratchFolderManagerFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFileMonitor* _tmp7_;
		GFileMonitor* _tmp8_;
		GFileMonitor* _tmp9_;
		_tmp3_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = scratch_folder_manager_file_get_file (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_monitor_directory (_tmp6_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp2_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp8_;
		_tmp9_ = self->priv->monitor;
		g_signal_connect_object (_tmp9_, "changed", (GCallback) _scratch_folder_manager_folder_item_on_changed_g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("FolderItem.vala:54: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
scratch_folder_manager_folder_item_class_init (ScratchFolderManagerFolderItemClass * klass,
                                               gpointer klass_data)
{
	scratch_folder_manager_folder_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerFolderItem_private_offset);
	((GraniteWidgetsSourceListItemClass *) klass)->get_context_menu = (GtkMenu* (*) (GraniteWidgetsSourceListItem*)) scratch_folder_manager_folder_item_real_get_context_menu;
	((ScratchFolderManagerFolderItemClass *) klass)->on_changed = (void (*) (ScratchFolderManagerFolderItem*, GFile*, GFile*, GFileMonitorEvent)) scratch_folder_manager_folder_item_real_on_changed;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_folder_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_folder_item_finalize;
}

static void
scratch_folder_manager_folder_item_instance_init (ScratchFolderManagerFolderItem * self,
                                                  gpointer klass)
{
	self->priv = scratch_folder_manager_folder_item_get_instance_private (self);
	self->priv->children_loaded = FALSE;
}

static void
scratch_folder_manager_folder_item_finalize (GObject * obj)
{
	ScratchFolderManagerFolderItem * self;
	GFileMonitor* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem);
	_tmp0_ = self->priv->monitor;
	g_file_monitor_cancel (_tmp0_);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->dummy);
	G_OBJECT_CLASS (scratch_folder_manager_folder_item_parent_class)->finalize (obj);
}

/**
     * Expandable item in the source list, represents a folder.
     * Monitored for changes inside the directory.
     */
static GType
scratch_folder_manager_folder_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerFolderItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_folder_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerFolderItem), 0, (GInstanceInitFunc) scratch_folder_manager_folder_item_instance_init, NULL };
	GType scratch_folder_manager_folder_item_type_id;
	scratch_folder_manager_folder_item_type_id = g_type_register_static (SCRATCH_FOLDER_MANAGER_TYPE_ITEM, "ScratchFolderManagerFolderItem", &g_define_type_info, 0);
	ScratchFolderManagerFolderItem_private_offset = g_type_add_instance_private (scratch_folder_manager_folder_item_type_id, sizeof (ScratchFolderManagerFolderItemPrivate));
	return scratch_folder_manager_folder_item_type_id;
}

GType
scratch_folder_manager_folder_item_get_type (void)
{
	static volatile gsize scratch_folder_manager_folder_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_folder_item_type_id__once)) {
		GType scratch_folder_manager_folder_item_type_id;
		scratch_folder_manager_folder_item_type_id = scratch_folder_manager_folder_item_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_folder_item_type_id__once, scratch_folder_manager_folder_item_type_id);
	}
	return scratch_folder_manager_folder_item_type_id__once;
}

static inline gpointer
scratch_folder_manager_rename_item_get_instance_private (ScratchFolderManagerRenameItem* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerRenameItem_private_offset);
}

ScratchFolderManagerRenameItem*
scratch_folder_manager_rename_item_construct (GType object_type,
                                              const gchar* name,
                                              gboolean is_folder)
{
	ScratchFolderManagerRenameItem * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ScratchFolderManagerRenameItem*) g_object_new (object_type, "name", name, "is-folder", is_folder, NULL);
	return self;
}

ScratchFolderManagerRenameItem*
scratch_folder_manager_rename_item_new (const gchar* name,
                                        gboolean is_folder)
{
	return scratch_folder_manager_rename_item_construct (SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, name, is_folder);
}

static void
scratch_folder_manager_rename_item_on_edited (ScratchFolderManagerRenameItem* self,
                                              const gchar* new_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_name != NULL);
	if (g_strcmp0 (new_name, "") != 0) {
		granite_widgets_source_list_item_set_name ((GraniteWidgetsSourceListItem*) self, new_name);
	}
}

gboolean
scratch_folder_manager_rename_item_get_is_folder (ScratchFolderManagerRenameItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_folder;
	return result;
}

static void
scratch_folder_manager_rename_item_set_is_folder (ScratchFolderManagerRenameItem* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_rename_item_get_is_folder (self);
	if (old_value != value) {
		self->priv->_is_folder = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_rename_item_properties[SCRATCH_FOLDER_MANAGER_RENAME_ITEM_IS_FOLDER_PROPERTY]);
	}
}

static void
_scratch_folder_manager_rename_item_on_edited_granite_widgets_source_list_item_edited (GraniteWidgetsSourceListItem* _sender,
                                                                                       const gchar* new_name,
                                                                                       gpointer self)
{
	scratch_folder_manager_rename_item_on_edited ((ScratchFolderManagerRenameItem*) self, new_name);
}

static GObject *
scratch_folder_manager_rename_item_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerRenameItem * self;
	gboolean _tmp0_;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_rename_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItem);
	granite_widgets_source_list_item_set_editable ((GraniteWidgetsSourceListItem*) self, TRUE);
	g_signal_connect_object ((GraniteWidgetsSourceListItem*) self, "edited", (GCallback) _scratch_folder_manager_rename_item_on_edited_granite_widgets_source_list_item_edited, self, 0);
	_tmp0_ = self->priv->_is_folder;
	if (_tmp0_) {
		GIcon* _tmp1_;
		GIcon* _tmp2_;
		_tmp1_ = g_content_type_get_icon ("inode/directory");
		_tmp2_ = _tmp1_;
		granite_widgets_source_list_item_set_icon ((GraniteWidgetsSourceListItem*) self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	} else {
		GIcon* _tmp3_;
		GIcon* _tmp4_;
		_tmp3_ = g_content_type_get_icon ("text");
		_tmp4_ = _tmp3_;
		granite_widgets_source_list_item_set_icon ((GraniteWidgetsSourceListItem*) self, _tmp4_);
		_g_object_unref0 (_tmp4_);
	}
	return obj;
}

static void
scratch_folder_manager_rename_item_class_init (ScratchFolderManagerRenameItemClass * klass,
                                               gpointer klass_data)
{
	scratch_folder_manager_rename_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerRenameItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_rename_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_rename_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_rename_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_rename_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_RENAME_ITEM_IS_FOLDER_PROPERTY, scratch_folder_manager_rename_item_properties[SCRATCH_FOLDER_MANAGER_RENAME_ITEM_IS_FOLDER_PROPERTY] = g_param_spec_boolean ("is-folder", "is-folder", "is-folder", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
scratch_folder_manager_rename_item_instance_init (ScratchFolderManagerRenameItem * self,
                                                  gpointer klass)
{
	self->priv = scratch_folder_manager_rename_item_get_instance_private (self);
}

static void
scratch_folder_manager_rename_item_finalize (GObject * obj)
{
	ScratchFolderManagerRenameItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItem);
	G_OBJECT_CLASS (scratch_folder_manager_rename_item_parent_class)->finalize (obj);
}

static GType
scratch_folder_manager_rename_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerRenameItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_rename_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerRenameItem), 0, (GInstanceInitFunc) scratch_folder_manager_rename_item_instance_init, NULL };
	GType scratch_folder_manager_rename_item_type_id;
	scratch_folder_manager_rename_item_type_id = g_type_register_static (GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, "ScratchFolderManagerRenameItem", &g_define_type_info, 0);
	ScratchFolderManagerRenameItem_private_offset = g_type_add_instance_private (scratch_folder_manager_rename_item_type_id, sizeof (ScratchFolderManagerRenameItemPrivate));
	return scratch_folder_manager_rename_item_type_id;
}

GType
scratch_folder_manager_rename_item_get_type (void)
{
	static volatile gsize scratch_folder_manager_rename_item_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_rename_item_type_id__once)) {
		GType scratch_folder_manager_rename_item_type_id;
		scratch_folder_manager_rename_item_type_id = scratch_folder_manager_rename_item_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_rename_item_type_id__once, scratch_folder_manager_rename_item_type_id);
	}
	return scratch_folder_manager_rename_item_type_id__once;
}

static void
_vala_scratch_folder_manager_rename_item_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	ScratchFolderManagerRenameItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_RENAME_ITEM_IS_FOLDER_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_rename_item_get_is_folder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_rename_item_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	ScratchFolderManagerRenameItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_RENAME_ITEM, ScratchFolderManagerRenameItem);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_RENAME_ITEM_IS_FOLDER_PROPERTY:
		scratch_folder_manager_rename_item_set_is_folder (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

