/* File.c generated by valac 0.56.14, the Vala compiler
 * generated from File.vala, do not modify */

/*-
 * Copyright (c) 2017 elementary LLC. (https://elementary.io),
 *               2013 Julien Spautz <spautz.julien@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Julien Spautz <spautz.julien@gmail.com>, Andrei-Costin Zisu <matzipan@gmail.com>
 */

#include "codecore.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	SCRATCH_FOLDER_MANAGER_FILE_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_FILE_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_PATH_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_NAME_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_ICON_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_EXISTS_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_IS_TEMPORARY_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_IS_VALID_TEXTFILE_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_IS_EXECUTABLE_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_CHILDREN_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ScratchFolderManagerFilePrivate {
	GFile* _file;
	GFileInfo* info;
	gchar* _name;
	GIcon* _icon;
	gboolean children_valid;
	GeeArrayList* _children;
};

static gint ScratchFolderManagerFile_private_offset;
static gpointer scratch_folder_manager_file_parent_class = NULL;

static gboolean scratch_folder_manager_file_get_boolean_file_attribute (ScratchFolderManagerFile* self,
                                                                 const gchar* attribute,
                                                                 GError** error);
static void scratch_folder_manager_file_load_file_for_path (ScratchFolderManagerFile* self,
                                                     const gchar* path);
static void scratch_folder_manager_file_set_file (ScratchFolderManagerFile* self,
                                           GFile* value);
static void scratch_folder_manager_file_finalize (GObject * obj);
static GType scratch_folder_manager_file_get_type_once (void);
static void _vala_scratch_folder_manager_file_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_scratch_folder_manager_file_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
scratch_folder_manager_file_get_instance_private (ScratchFolderManagerFile* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerFile_private_offset);
}

ScratchFolderManagerFile*
scratch_folder_manager_file_construct (GType object_type,
                                       const gchar* path)
{
	ScratchFolderManagerFile * self = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (ScratchFolderManagerFile*) g_object_new (object_type, "path", path, NULL);
	return self;
}

ScratchFolderManagerFile*
scratch_folder_manager_file_new (const gchar* path)
{
	return scratch_folder_manager_file_construct (SCRATCH_FOLDER_MANAGER_TYPE_FILE, path);
}

gboolean
scratch_folder_manager_file_is_valid_directory (ScratchFolderManagerFile* self,
                                                gboolean allow_hidden)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GFileInfo* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!allow_hidden) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = scratch_folder_manager_file_get_name (self);
		_tmp3_ = _tmp2_;
		_tmp1_ = g_str_has_prefix (_tmp3_, ".");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GFileInfo* _tmp4_;
		_tmp4_ = self->priv->info;
		_tmp0_ = g_file_info_get_is_backup (_tmp4_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = self->priv->info;
	if (g_file_info_get_file_type (_tmp5_) == G_FILE_TYPE_DIRECTORY) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
scratch_folder_manager_file_get_boolean_file_attribute (ScratchFolderManagerFile* self,
                                                        const gchar* attribute,
                                                        GError** error)
{
	GFileInfo* info = NULL;
	GFile* _tmp0_;
	GFileInfo* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (attribute != NULL, FALSE);
	_tmp0_ = self->priv->_file;
	_tmp1_ = g_file_query_info (_tmp0_, attribute, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	info = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp2_;
	}
	result = g_file_info_get_attribute_boolean (info, attribute);
	_g_object_unref0 (info);
	return result;
}

static void
scratch_folder_manager_file_load_file_for_path (ScratchFolderManagerFile* self,
                                                const gchar* path)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = g_file_new_for_path (path);
	_tmp1_ = _tmp0_;
	scratch_folder_manager_file_set_file (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_file_info_new ();
	_g_object_unref0 (self->priv->info);
	self->priv->info = _tmp2_;
	{
		gchar* query_string = NULL;
		gchar* _tmp3_;
		GFileInfo* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		_tmp3_ = g_strdup (G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE);
		query_string = _tmp3_;
		_tmp5_ = self->priv->_file;
		_tmp6_ = g_file_query_info (_tmp5_, query_string, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (query_string);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->info);
		self->priv->info = _tmp7_;
		_g_object_unref0 (_tmp4_);
		_g_free0 (query_string);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_g_object_unref0 (self->priv->info);
		self->priv->info = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("File.vala:175: %s", _tmp9_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
scratch_folder_manager_file_rename (ScratchFolderManagerFile* self,
                                    const gchar* name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	{
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = scratch_folder_manager_file_get_exists (self);
		_tmp1_ = _tmp0_;
		if (_tmp1_) {
			GFile* _tmp2_;
			GFile* _tmp3_;
			GFile* _tmp4_;
			_tmp2_ = self->priv->_file;
			_tmp3_ = g_file_set_display_name (_tmp2_, name, NULL, &_inner_error0_);
			_tmp4_ = _tmp3_;
			_g_object_unref0 (_tmp4_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning ("File.vala:185: %s", _tmp6_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
scratch_folder_manager_file_trash (ScratchFolderManagerFile* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFile* _tmp0_;
		_tmp0_ = self->priv->_file;
		g_file_trash (_tmp0_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("File.vala:193: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gint
scratch_folder_manager_file_compare (ScratchFolderManagerFile* a,
                                     ScratchFolderManagerFile* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GCompareFunc _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp17_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	if (scratch_folder_manager_file_is_valid_directory (a, TRUE)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = scratch_folder_manager_file_get_is_valid_textfile (b);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = -1;
		return result;
	}
	_tmp4_ = scratch_folder_manager_file_get_is_valid_textfile (a);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp3_ = scratch_folder_manager_file_is_valid_directory (b, TRUE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = 1;
		return result;
	}
	_tmp6_ = ((GCompareFunc) g_strcmp0);
	_tmp7_ = scratch_folder_manager_file_get_path (a);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp10_ = g_utf8_collate_key_for_filename (_tmp9_, (gssize) -1);
	_tmp11_ = _tmp10_;
	_tmp12_ = scratch_folder_manager_file_get_path (b);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = g_utf8_collate_key_for_filename (_tmp14_, (gssize) -1);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp6_ (_tmp11_, _tmp16_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	result = _tmp17_;
	return result;
}

void
scratch_folder_manager_file_invalidate_cache (ScratchFolderManagerFile* self)
{
	g_return_if_fail (self != NULL);
	self->priv->children_valid = FALSE;
}

GFile*
scratch_folder_manager_file_get_file (ScratchFolderManagerFile* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
scratch_folder_manager_file_set_file (ScratchFolderManagerFile* self,
                                      GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_file_get_file (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_file);
		self->priv->_file = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_FILE_PROPERTY]);
	}
}

gchar*
scratch_folder_manager_file_get_path (ScratchFolderManagerFile* self)
{
	gchar* result;
	GFile* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	_tmp1_ = g_file_get_path (_tmp0_);
	result = _tmp1_;
	return result;
}

void
scratch_folder_manager_file_set_path (ScratchFolderManagerFile* self,
                                      const gchar* value)
{
	g_return_if_fail (self != NULL);
	scratch_folder_manager_file_load_file_for_path (self, value);
	g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_PATH_PROPERTY]);
}

const gchar*
scratch_folder_manager_file_get_name (ScratchFolderManagerFile* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	GFileInfo* _tmp2_;
	const gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_name;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->info;
	if (_tmp2_ == NULL) {
		GFile* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->_file;
		_tmp4_ = g_file_get_basename (_tmp3_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp4_;
	} else {
		GFileInfo* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->priv->info;
		_tmp6_ = g_file_info_get_display_name (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp7_;
	}
	_tmp8_ = self->priv->_name;
	result = _tmp8_;
	return result;
}

GIcon*
scratch_folder_manager_file_get_icon (ScratchFolderManagerFile* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	if (_tmp0_ != NULL) {
		GIcon* _tmp1_;
		_tmp1_ = self->priv->_icon;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->info;
	_tmp3_ = g_file_info_get_content_type (_tmp2_);
	_tmp4_ = g_content_type_get_icon (_tmp3_);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp4_;
	_tmp5_ = self->priv->_icon;
	result = _tmp5_;
	return result;
}

gboolean
scratch_folder_manager_file_get_exists (ScratchFolderManagerFile* self)
{
	gboolean result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_file;
	result = g_file_query_exists (_tmp0_, NULL);
	return result;
}

gboolean
scratch_folder_manager_file_get_is_temporary (ScratchFolderManagerFile* self)
{
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = scratch_folder_manager_file_get_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_suffix (_tmp2_, "~");
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
scratch_folder_manager_file_get_is_valid_textfile (ScratchFolderManagerFile* self)
{
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFileInfo* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = scratch_folder_manager_file_get_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->info;
	_tmp4_ = scratch_utils_check_if_valid_text_file (_tmp2_, _tmp3_);
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

gboolean
scratch_folder_manager_file_get_is_executable (ScratchFolderManagerFile* self)
{
	gboolean result;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = scratch_folder_manager_file_get_boolean_file_attribute (self, G_FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp1_;
}

GeeCollection*
scratch_folder_manager_file_get_children (ScratchFolderManagerFile* self)
{
	GeeCollection* result;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp29_;
	GeeCollection* _tmp30_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->children_valid) {
		GeeArrayList* _tmp0_;
		GeeCollection* _tmp1_;
		_tmp0_ = self->priv->_children;
		_tmp1_ = _g_object_ref0 ((GeeCollection*) _tmp0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_children;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
	{
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp3_;
		GFileEnumerator* _tmp4_;
		GFileInfo* file_info = NULL;
		GFileInfo* _tmp5_;
		_tmp3_ = self->priv->_file;
		_tmp4_ = g_file_enumerate_children (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = g_file_info_new ();
		file_info = _tmp5_;
		while (TRUE) {
			GFileInfo* _tmp6_ = NULL;
			GFileEnumerator* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp10_;
			GFile* child = NULL;
			GFile* _tmp11_;
			GFileInfo* _tmp12_;
			const gchar* _tmp13_;
			GFile* _tmp14_;
			ScratchFolderManagerFile* child_file = NULL;
			GFile* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			ScratchFolderManagerFile* _tmp18_;
			ScratchFolderManagerFile* _tmp19_;
			gboolean _tmp20_ = FALSE;
			ScratchFolderManagerFile* _tmp21_;
			_tmp7_ = enumerator;
			_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error0_);
			_tmp6_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file_info);
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp9_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp9_;
			_tmp10_ = file_info;
			if (!(_tmp10_ != NULL)) {
				_g_object_unref0 (_tmp6_);
				break;
			}
			_tmp11_ = self->priv->_file;
			_tmp12_ = file_info;
			_tmp13_ = g_file_info_get_name (_tmp12_);
			_tmp14_ = g_file_get_child (_tmp11_, _tmp13_);
			child = _tmp14_;
			_tmp15_ = child;
			_tmp16_ = g_file_get_path (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = scratch_folder_manager_file_new (_tmp17_);
			_tmp19_ = _tmp18_;
			_g_free0 (_tmp17_);
			child_file = _tmp19_;
			_tmp21_ = child_file;
			if (scratch_folder_manager_file_is_valid_directory (_tmp21_, TRUE)) {
				_tmp20_ = TRUE;
			} else {
				ScratchFolderManagerFile* _tmp22_;
				gboolean _tmp23_;
				gboolean _tmp24_;
				_tmp22_ = child_file;
				_tmp23_ = scratch_folder_manager_file_get_is_valid_textfile (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp20_ = _tmp24_;
			}
			if (_tmp20_) {
				GeeArrayList* _tmp25_;
				ScratchFolderManagerFile* _tmp26_;
				_tmp25_ = self->priv->_children;
				_tmp26_ = child_file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
			}
			_g_object_unref0 (child_file);
			_g_object_unref0 (child);
			_g_object_unref0 (_tmp6_);
		}
		self->priv->children_valid = TRUE;
		_g_object_unref0 (file_info);
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = _error_;
		_tmp28_ = _tmp27_->message;
		g_warning ("File.vala:148: %s", _tmp28_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp29_ = self->priv->_children;
	_tmp30_ = _g_object_ref0 ((GeeCollection*) _tmp29_);
	result = _tmp30_;
	return result;
}

static void
scratch_folder_manager_file_class_init (ScratchFolderManagerFileClass * klass,
                                        gpointer klass_data)
{
	scratch_folder_manager_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerFile_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_file_set_property;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_FILE_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_FILE_PROPERTY] = g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_PATH_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_PATH_PROPERTY] = g_param_spec_string ("path", "path", "path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_NAME_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_ICON_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_EXISTS_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_EXISTS_PROPERTY] = g_param_spec_boolean ("exists", "exists", "exists", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_IS_TEMPORARY_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_IS_TEMPORARY_PROPERTY] = g_param_spec_boolean ("is-temporary", "is-temporary", "is-temporary", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_IS_VALID_TEXTFILE_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_IS_VALID_TEXTFILE_PROPERTY] = g_param_spec_boolean ("is-valid-textfile", "is-valid-textfile", "is-valid-textfile", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_IS_EXECUTABLE_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_IS_EXECUTABLE_PROPERTY] = g_param_spec_boolean ("is-executable", "is-executable", "is-executable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_CHILDREN_PROPERTY, scratch_folder_manager_file_properties[SCRATCH_FOLDER_MANAGER_FILE_CHILDREN_PROPERTY] = g_param_spec_object ("children", "children", "children", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
scratch_folder_manager_file_instance_init (ScratchFolderManagerFile * self,
                                           gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = scratch_folder_manager_file_get_instance_private (self);
	self->priv->_icon = NULL;
	self->priv->children_valid = FALSE;
	_tmp0_ = gee_array_list_new (SCRATCH_FOLDER_MANAGER_TYPE_FILE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_children = _tmp0_;
}

static void
scratch_folder_manager_file_finalize (GObject * obj)
{
	ScratchFolderManagerFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFile);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->info);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_children);
	G_OBJECT_CLASS (scratch_folder_manager_file_parent_class)->finalize (obj);
}

/**
     * Class for easily dealing with files.
     */
static GType
scratch_folder_manager_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerFile), 0, (GInstanceInitFunc) scratch_folder_manager_file_instance_init, NULL };
	GType scratch_folder_manager_file_type_id;
	scratch_folder_manager_file_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchFolderManagerFile", &g_define_type_info, 0);
	ScratchFolderManagerFile_private_offset = g_type_add_instance_private (scratch_folder_manager_file_type_id, sizeof (ScratchFolderManagerFilePrivate));
	return scratch_folder_manager_file_type_id;
}

GType
scratch_folder_manager_file_get_type (void)
{
	static volatile gsize scratch_folder_manager_file_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_file_type_id__once)) {
		GType scratch_folder_manager_file_type_id;
		scratch_folder_manager_file_type_id = scratch_folder_manager_file_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_file_type_id__once, scratch_folder_manager_file_type_id);
	}
	return scratch_folder_manager_file_type_id__once;
}

static void
_vala_scratch_folder_manager_file_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ScratchFolderManagerFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFile);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_FILE_FILE_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_file_get_file (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_PATH_PROPERTY:
		g_value_take_string (value, scratch_folder_manager_file_get_path (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_NAME_PROPERTY:
		g_value_set_string (value, scratch_folder_manager_file_get_name (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_ICON_PROPERTY:
		g_value_set_object (value, scratch_folder_manager_file_get_icon (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_EXISTS_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_file_get_exists (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_IS_TEMPORARY_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_file_get_is_temporary (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_IS_VALID_TEXTFILE_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_file_get_is_valid_textfile (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_IS_EXECUTABLE_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_file_get_is_executable (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_CHILDREN_PROPERTY:
		g_value_take_object (value, scratch_folder_manager_file_get_children (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_file_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ScratchFolderManagerFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFile);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_FILE_FILE_PROPERTY:
		scratch_folder_manager_file_set_file (self, g_value_get_object (value));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_PATH_PROPERTY:
		scratch_folder_manager_file_set_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

