/* PreferencesDialog.c generated by valac 0.56.14, the Vala compiler
 * generated from PreferencesDialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*
* Copyright (c) 2011-2017 elementary LLC (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA.
*
* Authored by: Giulio Collura <random.cpp@gmail.com>
*              Mario Guerriero <mario@elementaryos.org>
*              Fabio Zaramella <ffabio.96.x@gmail.com>
*/

#include "codecore.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

enum  {
	SCRATCH_DIALOGS_PREFERENCES_0_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_preferences_properties[SCRATCH_DIALOGS_PREFERENCES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_LABEL (scratch_dialogs_preferences_settings_label_get_type ())
#define SCRATCH_DIALOGS_PREFERENCES_SETTINGS_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_LABEL, ScratchDialogsPreferencesSettingsLabel))
#define SCRATCH_DIALOGS_PREFERENCES_SETTINGS_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_LABEL, ScratchDialogsPreferencesSettingsLabelClass))
#define SCRATCH_DIALOGS_PREFERENCES_IS_SETTINGS_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_LABEL))
#define SCRATCH_DIALOGS_PREFERENCES_IS_SETTINGS_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_LABEL))
#define SCRATCH_DIALOGS_PREFERENCES_SETTINGS_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_LABEL, ScratchDialogsPreferencesSettingsLabelClass))

typedef struct _ScratchDialogsPreferencesSettingsLabel ScratchDialogsPreferencesSettingsLabel;
typedef struct _ScratchDialogsPreferencesSettingsLabelClass ScratchDialogsPreferencesSettingsLabelClass;

#define SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_SWITCH (scratch_dialogs_preferences_settings_switch_get_type ())
#define SCRATCH_DIALOGS_PREFERENCES_SETTINGS_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_SWITCH, ScratchDialogsPreferencesSettingsSwitch))
#define SCRATCH_DIALOGS_PREFERENCES_SETTINGS_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_SWITCH, ScratchDialogsPreferencesSettingsSwitchClass))
#define SCRATCH_DIALOGS_PREFERENCES_IS_SETTINGS_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_SWITCH))
#define SCRATCH_DIALOGS_PREFERENCES_IS_SETTINGS_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_SWITCH))
#define SCRATCH_DIALOGS_PREFERENCES_SETTINGS_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_SWITCH, ScratchDialogsPreferencesSettingsSwitchClass))

typedef struct _ScratchDialogsPreferencesSettingsSwitch ScratchDialogsPreferencesSettingsSwitch;
typedef struct _ScratchDialogsPreferencesSettingsSwitchClass ScratchDialogsPreferencesSettingsSwitchClass;

#define SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH (scratch_dialogs_preferences_draw_spaces_switch_get_type ())
#define SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH, ScratchDialogsPreferencesDrawSpacesSwitch))
#define SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH, ScratchDialogsPreferencesDrawSpacesSwitchClass))
#define SCRATCH_DIALOGS_PREFERENCES_IS_DRAW_SPACES_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH))
#define SCRATCH_DIALOGS_PREFERENCES_IS_DRAW_SPACES_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH))
#define SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH, ScratchDialogsPreferencesDrawSpacesSwitchClass))

typedef struct _ScratchDialogsPreferencesDrawSpacesSwitch ScratchDialogsPreferencesDrawSpacesSwitch;
typedef struct _ScratchDialogsPreferencesDrawSpacesSwitchClass ScratchDialogsPreferencesDrawSpacesSwitchClass;
typedef struct _ScratchDialogsPreferencesSettingsLabelPrivate ScratchDialogsPreferencesSettingsLabelPrivate;
enum  {
	SCRATCH_DIALOGS_PREFERENCES_SETTINGS_LABEL_0_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_SETTINGS_LABEL_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_preferences_settings_label_properties[SCRATCH_DIALOGS_PREFERENCES_SETTINGS_LABEL_NUM_PROPERTIES];
typedef struct _ScratchDialogsPreferencesSettingsSwitchPrivate ScratchDialogsPreferencesSettingsSwitchPrivate;
enum  {
	SCRATCH_DIALOGS_PREFERENCES_SETTINGS_SWITCH_0_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_SETTINGS_SWITCH_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_preferences_settings_switch_properties[SCRATCH_DIALOGS_PREFERENCES_SETTINGS_SWITCH_NUM_PROPERTIES];
typedef struct _ScratchDialogsPreferencesDrawSpacesSwitchPrivate ScratchDialogsPreferencesDrawSpacesSwitchPrivate;
enum  {
	SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_0_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_STRING_VALUE_PROPERTY,
	SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_NUM_PROPERTIES
};
static GParamSpec* scratch_dialogs_preferences_draw_spaces_switch_properties[SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_NUM_PROPERTIES];

struct _ScratchDialogsPreferencesPrivate {
	GtkStack* main_stack;
	GtkSwitch* highlight_matching_brackets;
	GtkSwitch* use_custom_font;
	GtkFontButton* select_font;
	GtkSwitch* show_mini_map;
};

struct _ScratchDialogsPreferencesSettingsLabel {
	GtkLabel parent_instance;
	ScratchDialogsPreferencesSettingsLabelPrivate * priv;
};

struct _ScratchDialogsPreferencesSettingsLabelClass {
	GtkLabelClass parent_class;
};

struct _ScratchDialogsPreferencesSettingsSwitch {
	GtkSwitch parent_instance;
	ScratchDialogsPreferencesSettingsSwitchPrivate * priv;
};

struct _ScratchDialogsPreferencesSettingsSwitchClass {
	GtkSwitchClass parent_class;
};

struct _ScratchDialogsPreferencesDrawSpacesSwitch {
	GtkSwitch parent_instance;
	ScratchDialogsPreferencesDrawSpacesSwitchPrivate * priv;
};

struct _ScratchDialogsPreferencesDrawSpacesSwitchClass {
	GtkSwitchClass parent_class;
};

static gint ScratchDialogsPreferences_private_offset;
static gpointer scratch_dialogs_preferences_parent_class = NULL;
static gpointer scratch_dialogs_preferences_settings_label_parent_class = NULL;
static gpointer scratch_dialogs_preferences_settings_switch_parent_class = NULL;
static gpointer scratch_dialogs_preferences_draw_spaces_switch_parent_class = NULL;

static void scratch_dialogs_preferences_create_layout (ScratchDialogsPreferences* self,
                                                ScratchServicesPluginsManager* plugins);
static GtkWidget* scratch_dialogs_preferences_get_editor_box (ScratchDialogsPreferences* self);
static GType scratch_dialogs_preferences_settings_label_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ScratchDialogsPreferencesSettingsLabel* scratch_dialogs_preferences_settings_label_new (const gchar* text);
static ScratchDialogsPreferencesSettingsLabel* scratch_dialogs_preferences_settings_label_construct (GType object_type,
                                                                                              const gchar* text);
static ScratchDialogsPreferencesSettingsSwitch* scratch_dialogs_preferences_settings_switch_new (const gchar* setting);
static ScratchDialogsPreferencesSettingsSwitch* scratch_dialogs_preferences_settings_switch_construct (GType object_type,
                                                                                                const gchar* setting);
static GType scratch_dialogs_preferences_settings_switch_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType scratch_dialogs_preferences_draw_spaces_switch_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ScratchDialogsPreferencesDrawSpacesSwitch* scratch_dialogs_preferences_draw_spaces_switch_new (void);
static ScratchDialogsPreferencesDrawSpacesSwitch* scratch_dialogs_preferences_draw_spaces_switch_construct (GType object_type);
static GType scratch_dialogs_preferences_settings_label_get_type_once (void);
static GType scratch_dialogs_preferences_settings_switch_get_type_once (void);
static void __lambda56_ (ScratchDialogsPreferencesDrawSpacesSwitch* self);
static void scratch_dialogs_preferences_draw_spaces_switch_set_string_value (ScratchDialogsPreferencesDrawSpacesSwitch* self,
                                                                      const gchar* value);
static void ___lambda56__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static const gchar* scratch_dialogs_preferences_draw_spaces_switch_get_string_value (ScratchDialogsPreferencesDrawSpacesSwitch* self);
static GType scratch_dialogs_preferences_draw_spaces_switch_get_type_once (void);
static void _vala_scratch_dialogs_preferences_draw_spaces_switch_get_property (GObject * object,
                                                                        guint property_id,
                                                                        GValue * value,
                                                                        GParamSpec * pspec);
static void _vala_scratch_dialogs_preferences_draw_spaces_switch_set_property (GObject * object,
                                                                        guint property_id,
                                                                        const GValue * value,
                                                                        GParamSpec * pspec);
static GObject * scratch_dialogs_preferences_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _scratch_dialogs_preferences___lambda57_ (ScratchDialogsPreferences* self);
static void __scratch_dialogs_preferences___lambda57__gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void scratch_dialogs_preferences_finalize (GObject * obj);
static GType scratch_dialogs_preferences_get_type_once (void);

static inline gpointer
scratch_dialogs_preferences_get_instance_private (ScratchDialogsPreferences* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchDialogsPreferences_private_offset);
}

ScratchDialogsPreferences*
scratch_dialogs_preferences_construct (GType object_type,
                                       GtkWindow* parent,
                                       ScratchServicesPluginsManager* plugins)
{
	ScratchDialogsPreferences * self = NULL;
	g_return_val_if_fail (plugins != NULL, NULL);
	self = (ScratchDialogsPreferences*) g_object_new (object_type, "deletable", FALSE, "resizable", FALSE, "title", _ ("Preferences"), "transient-for", parent, NULL);
	scratch_dialogs_preferences_create_layout (self, plugins);
	return self;
}

ScratchDialogsPreferences*
scratch_dialogs_preferences_new (GtkWindow* parent,
                                 ScratchServicesPluginsManager* plugins)
{
	return scratch_dialogs_preferences_construct (SCRATCH_DIALOGS_TYPE_PREFERENCES, parent, plugins);
}

static void
scratch_dialogs_preferences_create_layout (ScratchDialogsPreferences* self,
                                           ScratchServicesPluginsManager* plugins)
{
	PeasEngine* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugins != NULL);
	g_signal_emit_by_name (plugins, "hook-preferences-dialog", self);
	_tmp0_ = peas_engine_get_default ();
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	if (g_list_length (_tmp1_) > ((guint) 0)) {
		GtkWidget* pbox = NULL;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		GtkStack* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp2_ = scratch_services_plugins_manager_get_view (plugins);
		pbox = _tmp2_;
		_tmp3_ = pbox;
		gtk_widget_set_vexpand (_tmp3_, TRUE);
		_tmp4_ = self->priv->main_stack;
		_tmp5_ = pbox;
		gtk_stack_add_titled (_tmp4_, _tmp5_, "extensions", _ ("Extensions"));
		_g_object_unref0 (pbox);
	}
}

static GtkWidget*
scratch_dialogs_preferences_get_editor_box (ScratchDialogsPreferences* self)
{
	GtkGrid* content = NULL;
	GtkGrid* _tmp0_;
	GraniteHeaderLabel* editor_header = NULL;
	GraniteHeaderLabel* _tmp1_;
	ScratchDialogsPreferencesSettingsLabel* highlight_matching_brackets_label = NULL;
	ScratchDialogsPreferencesSettingsLabel* _tmp2_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp3_;
	ScratchDialogsPreferencesSettingsLabel* line_wrap_label = NULL;
	ScratchDialogsPreferencesSettingsLabel* _tmp4_;
	ScratchDialogsPreferencesSettingsSwitch* line_wrap = NULL;
	ScratchDialogsPreferencesSettingsSwitch* _tmp5_;
	ScratchDialogsPreferencesSettingsLabel* draw_spaces_label = NULL;
	ScratchDialogsPreferencesSettingsLabel* _tmp6_;
	ScratchDialogsPreferencesDrawSpacesSwitch* draw_spaces_switch = NULL;
	ScratchDialogsPreferencesDrawSpacesSwitch* _tmp7_ = NULL;
	ScratchDialogsPreferencesSettingsLabel* show_mini_map_label = NULL;
	ScratchDialogsPreferencesSettingsLabel* _tmp8_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp9_;
	ScratchDialogsPreferencesSettingsLabel* show_right_margin_label = NULL;
	ScratchDialogsPreferencesSettingsLabel* _tmp10_;
	ScratchDialogsPreferencesSettingsSwitch* show_right_margin = NULL;
	ScratchDialogsPreferencesSettingsSwitch* _tmp11_;
	GtkSpinButton* right_margin_position = NULL;
	GtkSpinButton* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp14_;
	GraniteHeaderLabel* font_header = NULL;
	GraniteHeaderLabel* _tmp15_;
	ScratchDialogsPreferencesSettingsLabel* use_custom_font_label = NULL;
	ScratchDialogsPreferencesSettingsLabel* _tmp16_;
	GtkSwitch* _tmp17_;
	GtkSwitch* _tmp18_;
	GtkSwitch* _tmp19_;
	GSettings* _tmp20_;
	GtkSwitch* _tmp21_;
	GtkFontButton* _tmp22_;
	GtkFontButton* _tmp23_;
	GSettings* _tmp24_;
	GtkFontButton* _tmp25_;
	GSettings* _tmp26_;
	GtkFontButton* _tmp27_;
	GtkSwitch* _tmp28_;
	GtkSwitch* _tmp29_;
	GtkSwitch* _tmp30_;
	GtkFontButton* _tmp31_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	content = _tmp0_;
	gtk_grid_set_row_spacing (content, 6);
	gtk_grid_set_column_spacing (content, 12);
	_tmp1_ = granite_header_label_new (_ ("Editor"));
	g_object_ref_sink (_tmp1_);
	editor_header = _tmp1_;
	_tmp2_ = scratch_dialogs_preferences_settings_label_new (_ ("Highlight matching brackets:"));
	g_object_ref_sink (_tmp2_);
	highlight_matching_brackets_label = _tmp2_;
	_tmp3_ = scratch_dialogs_preferences_settings_switch_new ("highlight-matching-brackets");
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->highlight_matching_brackets);
	self->priv->highlight_matching_brackets = (GtkSwitch*) _tmp3_;
	_tmp4_ = scratch_dialogs_preferences_settings_label_new (_ ("Line wrap:"));
	g_object_ref_sink (_tmp4_);
	line_wrap_label = _tmp4_;
	_tmp5_ = scratch_dialogs_preferences_settings_switch_new ("line-wrap");
	g_object_ref_sink (_tmp5_);
	line_wrap = _tmp5_;
	_tmp6_ = scratch_dialogs_preferences_settings_label_new (_ ("Visible whitespace:"));
	g_object_ref_sink (_tmp6_);
	draw_spaces_label = _tmp6_;
	_tmp7_ = scratch_dialogs_preferences_draw_spaces_switch_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp7_);
	draw_spaces_switch = _tmp7_;
	_tmp8_ = scratch_dialogs_preferences_settings_label_new (_ ("Show Mini Map:"));
	g_object_ref_sink (_tmp8_);
	show_mini_map_label = _tmp8_;
	_tmp9_ = scratch_dialogs_preferences_settings_switch_new ("show-mini-map");
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->show_mini_map);
	self->priv->show_mini_map = (GtkSwitch*) _tmp9_;
	_tmp10_ = scratch_dialogs_preferences_settings_label_new (_ ("Line width guide:"));
	g_object_ref_sink (_tmp10_);
	show_right_margin_label = _tmp10_;
	_tmp11_ = scratch_dialogs_preferences_settings_switch_new ("show-right-margin");
	g_object_ref_sink (_tmp11_);
	show_right_margin = _tmp11_;
	_tmp12_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 250, (gdouble) 1);
	g_object_ref_sink (_tmp12_);
	right_margin_position = _tmp12_;
	gtk_widget_set_hexpand ((GtkWidget*) right_margin_position, TRUE);
	_tmp13_ = scratch_settings;
	g_settings_bind (_tmp13_, "right-margin-position", (GObject*) right_margin_position, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp14_ = scratch_settings;
	g_settings_bind (_tmp14_, "show-right-margin", (GObject*) right_margin_position, "sensitive", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = granite_header_label_new (_ ("Font"));
	g_object_ref_sink (_tmp15_);
	font_header = _tmp15_;
	_tmp16_ = scratch_dialogs_preferences_settings_label_new (_ ("Custom font:"));
	g_object_ref_sink (_tmp16_);
	use_custom_font_label = _tmp16_;
	_tmp17_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->use_custom_font);
	self->priv->use_custom_font = _tmp17_;
	_tmp18_ = self->priv->use_custom_font;
	gtk_widget_set_halign ((GtkWidget*) _tmp18_, GTK_ALIGN_START);
	_tmp19_ = self->priv->use_custom_font;
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_CENTER);
	_tmp20_ = scratch_settings;
	_tmp21_ = self->priv->use_custom_font;
	g_settings_bind (_tmp20_, "use-system-font", (GObject*) _tmp21_, "active", G_SETTINGS_BIND_INVERT_BOOLEAN);
	_tmp22_ = (GtkFontButton*) gtk_font_button_new ();
	g_object_ref_sink (_tmp22_);
	_g_object_unref0 (self->priv->select_font);
	self->priv->select_font = _tmp22_;
	_tmp23_ = self->priv->select_font;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp23_, TRUE);
	_tmp24_ = scratch_settings;
	_tmp25_ = self->priv->select_font;
	g_settings_bind (_tmp24_, "font", (GObject*) _tmp25_, "font-name", G_SETTINGS_BIND_DEFAULT);
	_tmp26_ = scratch_settings;
	_tmp27_ = self->priv->select_font;
	g_settings_bind (_tmp26_, "use-system-font", (GObject*) _tmp27_, "sensitive", G_SETTINGS_BIND_INVERT_BOOLEAN);
	gtk_grid_attach (content, (GtkWidget*) editor_header, 0, 0, 3, 1);
	gtk_grid_attach (content, (GtkWidget*) highlight_matching_brackets_label, 0, 2, 1, 1);
	_tmp28_ = self->priv->highlight_matching_brackets;
	gtk_grid_attach (content, (GtkWidget*) _tmp28_, 1, 2, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) line_wrap_label, 0, 3, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) line_wrap, 1, 3, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) draw_spaces_label, 0, 4, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) draw_spaces_switch, 1, 4, 2, 1);
	gtk_grid_attach (content, (GtkWidget*) show_mini_map_label, 0, 5, 1, 1);
	_tmp29_ = self->priv->show_mini_map;
	gtk_grid_attach (content, (GtkWidget*) _tmp29_, 1, 5, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) show_right_margin_label, 0, 6, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) show_right_margin, 1, 6, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) right_margin_position, 2, 7, 1, 1);
	gtk_grid_attach (content, (GtkWidget*) font_header, 0, 7, 3, 1);
	gtk_grid_attach (content, (GtkWidget*) use_custom_font_label, 0, 9, 1, 1);
	_tmp30_ = self->priv->use_custom_font;
	gtk_grid_attach (content, (GtkWidget*) _tmp30_, 1, 9, 1, 1);
	_tmp31_ = self->priv->select_font;
	gtk_grid_attach (content, (GtkWidget*) _tmp31_, 2, 9, 1, 1);
	result = (GtkWidget*) content;
	_g_object_unref0 (use_custom_font_label);
	_g_object_unref0 (font_header);
	_g_object_unref0 (right_margin_position);
	_g_object_unref0 (show_right_margin);
	_g_object_unref0 (show_right_margin_label);
	_g_object_unref0 (show_mini_map_label);
	_g_object_unref0 (draw_spaces_switch);
	_g_object_unref0 (draw_spaces_label);
	_g_object_unref0 (line_wrap);
	_g_object_unref0 (line_wrap_label);
	_g_object_unref0 (highlight_matching_brackets_label);
	_g_object_unref0 (editor_header);
	return result;
}

static ScratchDialogsPreferencesSettingsLabel*
scratch_dialogs_preferences_settings_label_construct (GType object_type,
                                                      const gchar* text)
{
	ScratchDialogsPreferencesSettingsLabel * self = NULL;
	g_return_val_if_fail (text != NULL, NULL);
	self = (ScratchDialogsPreferencesSettingsLabel*) g_object_new (object_type, NULL);
	gtk_label_set_label ((GtkLabel*) self, text);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_END);
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	return self;
}

static ScratchDialogsPreferencesSettingsLabel*
scratch_dialogs_preferences_settings_label_new (const gchar* text)
{
	return scratch_dialogs_preferences_settings_label_construct (SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_LABEL, text);
}

static void
scratch_dialogs_preferences_settings_label_class_init (ScratchDialogsPreferencesSettingsLabelClass * klass,
                                                       gpointer klass_data)
{
	scratch_dialogs_preferences_settings_label_parent_class = g_type_class_peek_parent (klass);
}

static void
scratch_dialogs_preferences_settings_label_instance_init (ScratchDialogsPreferencesSettingsLabel * self,
                                                          gpointer klass)
{
}

static GType
scratch_dialogs_preferences_settings_label_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsPreferencesSettingsLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_preferences_settings_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsPreferencesSettingsLabel), 0, (GInstanceInitFunc) scratch_dialogs_preferences_settings_label_instance_init, NULL };
	GType scratch_dialogs_preferences_settings_label_type_id;
	scratch_dialogs_preferences_settings_label_type_id = g_type_register_static (gtk_label_get_type (), "ScratchDialogsPreferencesSettingsLabel", &g_define_type_info, 0);
	return scratch_dialogs_preferences_settings_label_type_id;
}

static GType
scratch_dialogs_preferences_settings_label_get_type (void)
{
	static volatile gsize scratch_dialogs_preferences_settings_label_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_preferences_settings_label_type_id__once)) {
		GType scratch_dialogs_preferences_settings_label_type_id;
		scratch_dialogs_preferences_settings_label_type_id = scratch_dialogs_preferences_settings_label_get_type_once ();
		g_once_init_leave (&scratch_dialogs_preferences_settings_label_type_id__once, scratch_dialogs_preferences_settings_label_type_id);
	}
	return scratch_dialogs_preferences_settings_label_type_id__once;
}

static ScratchDialogsPreferencesSettingsSwitch*
scratch_dialogs_preferences_settings_switch_construct (GType object_type,
                                                       const gchar* setting)
{
	ScratchDialogsPreferencesSettingsSwitch * self = NULL;
	GSettings* _tmp0_;
	g_return_val_if_fail (setting != NULL, NULL);
	self = (ScratchDialogsPreferencesSettingsSwitch*) g_object_new (object_type, NULL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	_tmp0_ = scratch_settings;
	g_settings_bind (_tmp0_, setting, (GObject*) self, "active", G_SETTINGS_BIND_DEFAULT);
	return self;
}

static ScratchDialogsPreferencesSettingsSwitch*
scratch_dialogs_preferences_settings_switch_new (const gchar* setting)
{
	return scratch_dialogs_preferences_settings_switch_construct (SCRATCH_DIALOGS_PREFERENCES_TYPE_SETTINGS_SWITCH, setting);
}

static void
scratch_dialogs_preferences_settings_switch_class_init (ScratchDialogsPreferencesSettingsSwitchClass * klass,
                                                        gpointer klass_data)
{
	scratch_dialogs_preferences_settings_switch_parent_class = g_type_class_peek_parent (klass);
}

static void
scratch_dialogs_preferences_settings_switch_instance_init (ScratchDialogsPreferencesSettingsSwitch * self,
                                                           gpointer klass)
{
}

static GType
scratch_dialogs_preferences_settings_switch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsPreferencesSettingsSwitchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_preferences_settings_switch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsPreferencesSettingsSwitch), 0, (GInstanceInitFunc) scratch_dialogs_preferences_settings_switch_instance_init, NULL };
	GType scratch_dialogs_preferences_settings_switch_type_id;
	scratch_dialogs_preferences_settings_switch_type_id = g_type_register_static (gtk_switch_get_type (), "ScratchDialogsPreferencesSettingsSwitch", &g_define_type_info, 0);
	return scratch_dialogs_preferences_settings_switch_type_id;
}

static GType
scratch_dialogs_preferences_settings_switch_get_type (void)
{
	static volatile gsize scratch_dialogs_preferences_settings_switch_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_preferences_settings_switch_type_id__once)) {
		GType scratch_dialogs_preferences_settings_switch_type_id;
		scratch_dialogs_preferences_settings_switch_type_id = scratch_dialogs_preferences_settings_switch_get_type_once ();
		g_once_init_leave (&scratch_dialogs_preferences_settings_switch_type_id__once, scratch_dialogs_preferences_settings_switch_type_id);
	}
	return scratch_dialogs_preferences_settings_switch_type_id__once;
}

static void
__lambda56_ (ScratchDialogsPreferencesDrawSpacesSwitch* self)
{
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp1_ = gtk_switch_get_active ((GtkSwitch*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = "Always";
	} else {
		_tmp0_ = "For Selection";
	}
	scratch_dialogs_preferences_draw_spaces_switch_set_string_value (self, _tmp0_);
}

static void
___lambda56__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda56_ ((ScratchDialogsPreferencesDrawSpacesSwitch*) self);
}

static ScratchDialogsPreferencesDrawSpacesSwitch*
scratch_dialogs_preferences_draw_spaces_switch_construct (GType object_type)
{
	ScratchDialogsPreferencesDrawSpacesSwitch * self = NULL;
	GSettings* _tmp0_;
	self = (ScratchDialogsPreferencesDrawSpacesSwitch*) g_object_new (object_type, NULL);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	g_signal_connect_object ((GObject*) self, "notify::active", (GCallback) ___lambda56__g_object_notify, self, 0);
	_tmp0_ = scratch_settings;
	g_settings_bind (_tmp0_, "draw-spaces", (GObject*) self, "string_value", G_SETTINGS_BIND_DEFAULT);
	return self;
}

static ScratchDialogsPreferencesDrawSpacesSwitch*
scratch_dialogs_preferences_draw_spaces_switch_new (void)
{
	return scratch_dialogs_preferences_draw_spaces_switch_construct (SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH);
}

static const gchar*
scratch_dialogs_preferences_draw_spaces_switch_get_string_value (ScratchDialogsPreferencesDrawSpacesSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gtk_switch_get_active ((GtkSwitch*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		_tmp0_ = "Always";
	} else {
		_tmp0_ = "For Selection";
	}
	result = _tmp0_;
	return result;
}

static void
scratch_dialogs_preferences_draw_spaces_switch_set_string_value (ScratchDialogsPreferencesDrawSpacesSwitch* self,
                                                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	gtk_switch_set_active ((GtkSwitch*) self, g_strcmp0 (value, "Always") == 0);
	g_object_notify_by_pspec ((GObject *) self, scratch_dialogs_preferences_draw_spaces_switch_properties[SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_STRING_VALUE_PROPERTY]);
}

static void
scratch_dialogs_preferences_draw_spaces_switch_class_init (ScratchDialogsPreferencesDrawSpacesSwitchClass * klass,
                                                           gpointer klass_data)
{
	scratch_dialogs_preferences_draw_spaces_switch_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_dialogs_preferences_draw_spaces_switch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_dialogs_preferences_draw_spaces_switch_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_STRING_VALUE_PROPERTY, scratch_dialogs_preferences_draw_spaces_switch_properties[SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_STRING_VALUE_PROPERTY] = g_param_spec_string ("string-value", "string-value", "string-value", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
scratch_dialogs_preferences_draw_spaces_switch_instance_init (ScratchDialogsPreferencesDrawSpacesSwitch * self,
                                                              gpointer klass)
{
}

static GType
scratch_dialogs_preferences_draw_spaces_switch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsPreferencesDrawSpacesSwitchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_preferences_draw_spaces_switch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsPreferencesDrawSpacesSwitch), 0, (GInstanceInitFunc) scratch_dialogs_preferences_draw_spaces_switch_instance_init, NULL };
	GType scratch_dialogs_preferences_draw_spaces_switch_type_id;
	scratch_dialogs_preferences_draw_spaces_switch_type_id = g_type_register_static (gtk_switch_get_type (), "ScratchDialogsPreferencesDrawSpacesSwitch", &g_define_type_info, 0);
	return scratch_dialogs_preferences_draw_spaces_switch_type_id;
}

static GType
scratch_dialogs_preferences_draw_spaces_switch_get_type (void)
{
	static volatile gsize scratch_dialogs_preferences_draw_spaces_switch_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_preferences_draw_spaces_switch_type_id__once)) {
		GType scratch_dialogs_preferences_draw_spaces_switch_type_id;
		scratch_dialogs_preferences_draw_spaces_switch_type_id = scratch_dialogs_preferences_draw_spaces_switch_get_type_once ();
		g_once_init_leave (&scratch_dialogs_preferences_draw_spaces_switch_type_id__once, scratch_dialogs_preferences_draw_spaces_switch_type_id);
	}
	return scratch_dialogs_preferences_draw_spaces_switch_type_id__once;
}

static void
_vala_scratch_dialogs_preferences_draw_spaces_switch_get_property (GObject * object,
                                                                   guint property_id,
                                                                   GValue * value,
                                                                   GParamSpec * pspec)
{
	ScratchDialogsPreferencesDrawSpacesSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH, ScratchDialogsPreferencesDrawSpacesSwitch);
	switch (property_id) {
		case SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_STRING_VALUE_PROPERTY:
		g_value_set_string (value, scratch_dialogs_preferences_draw_spaces_switch_get_string_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_dialogs_preferences_draw_spaces_switch_set_property (GObject * object,
                                                                   guint property_id,
                                                                   const GValue * value,
                                                                   GParamSpec * pspec)
{
	ScratchDialogsPreferencesDrawSpacesSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_DIALOGS_PREFERENCES_TYPE_DRAW_SPACES_SWITCH, ScratchDialogsPreferencesDrawSpacesSwitch);
	switch (property_id) {
		case SCRATCH_DIALOGS_PREFERENCES_DRAW_SPACES_SWITCH_STRING_VALUE_PROPERTY:
		scratch_dialogs_preferences_draw_spaces_switch_set_string_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_scratch_dialogs_preferences___lambda57_ (ScratchDialogsPreferences* self)
{
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
__scratch_dialogs_preferences___lambda57__gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	_scratch_dialogs_preferences___lambda57_ ((ScratchDialogsPreferences*) self);
}

static GObject *
scratch_dialogs_preferences_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchDialogsPreferences * self;
	GtkImage* smart_cut_copy_info = NULL;
	GtkImage* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkSpinButton* indent_width = NULL;
	GtkSpinButton* _tmp3_;
	GSettings* _tmp4_;
	GtkSpinButton* _tmp5_;
	GtkGrid* general_grid = NULL;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GraniteHeaderLabel* _tmp10_;
	GraniteHeaderLabel* _tmp11_;
	GtkGrid* _tmp12_;
	ScratchDialogsPreferencesSettingsLabel* _tmp13_;
	ScratchDialogsPreferencesSettingsLabel* _tmp14_;
	GtkGrid* _tmp15_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp16_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp17_;
	GtkGrid* _tmp18_;
	ScratchDialogsPreferencesSettingsLabel* _tmp19_;
	ScratchDialogsPreferencesSettingsLabel* _tmp20_;
	GtkGrid* _tmp21_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp22_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp23_;
	GtkGrid* _tmp24_;
	GtkImage* _tmp25_;
	GtkGrid* _tmp26_;
	GraniteHeaderLabel* _tmp27_;
	GraniteHeaderLabel* _tmp28_;
	GtkGrid* _tmp29_;
	ScratchDialogsPreferencesSettingsLabel* _tmp30_;
	ScratchDialogsPreferencesSettingsLabel* _tmp31_;
	GtkGrid* _tmp32_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp33_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp34_;
	GtkGrid* _tmp35_;
	ScratchDialogsPreferencesSettingsLabel* _tmp36_;
	ScratchDialogsPreferencesSettingsLabel* _tmp37_;
	GtkGrid* _tmp38_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp39_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp40_;
	GtkGrid* _tmp41_;
	ScratchDialogsPreferencesSettingsLabel* _tmp42_;
	ScratchDialogsPreferencesSettingsLabel* _tmp43_;
	GtkGrid* _tmp44_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp45_;
	ScratchDialogsPreferencesSettingsSwitch* _tmp46_;
	GtkGrid* _tmp47_;
	ScratchDialogsPreferencesSettingsLabel* _tmp48_;
	ScratchDialogsPreferencesSettingsLabel* _tmp49_;
	GtkGrid* _tmp50_;
	GtkSpinButton* _tmp51_;
	GtkStack* _tmp52_ = NULL;
	GtkStack* _tmp53_;
	GtkGrid* _tmp54_;
	GtkStack* _tmp55_;
	GtkWidget* _tmp56_;
	GtkWidget* _tmp57_;
	GtkStackSwitcher* main_stackswitcher = NULL;
	GtkStackSwitcher* _tmp58_;
	GtkStackSwitcher* _tmp59_;
	GtkStack* _tmp60_;
	GtkStackSwitcher* _tmp61_;
	GtkGrid* main_grid = NULL;
	GtkGrid* _tmp62_ = NULL;
	GtkGrid* _tmp63_;
	GtkStackSwitcher* _tmp64_;
	GtkGrid* _tmp65_;
	GtkStack* _tmp66_;
	GtkBox* _tmp67_;
	GtkGrid* _tmp68_;
	GtkButton* close_button = NULL;
	GtkWidget* _tmp69_;
	GtkButton* _tmp70_;
	GtkButton* _tmp71_;
	parent_class = G_OBJECT_CLASS (scratch_dialogs_preferences_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferences);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-information-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	smart_cut_copy_info = _tmp0_;
	_tmp1_ = smart_cut_copy_info;
	gtk_widget_set_halign ((GtkWidget*) _tmp1_, GTK_ALIGN_START);
	_tmp2_ = smart_cut_copy_info;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Cutting or copying without an active selection will cut or copy the en" \
"tire current line"));
	_tmp3_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 24, (gdouble) 1);
	g_object_ref_sink (_tmp3_);
	indent_width = _tmp3_;
	_tmp4_ = scratch_settings;
	_tmp5_ = indent_width;
	g_settings_bind (_tmp4_, "indent-width", (GObject*) _tmp5_, "value", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp6_);
	general_grid = _tmp6_;
	_tmp7_ = general_grid;
	gtk_grid_set_column_spacing (_tmp7_, 12);
	_tmp8_ = general_grid;
	gtk_grid_set_row_spacing (_tmp8_, 6);
	_tmp9_ = general_grid;
	_tmp10_ = granite_header_label_new (_ ("General"));
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp11_, 0, 0, 3, 1);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = general_grid;
	_tmp13_ = scratch_dialogs_preferences_settings_label_new (_ ("Save files when changed:"));
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp14_, 0, 1, 1, 1);
	_g_object_unref0 (_tmp14_);
	_tmp15_ = general_grid;
	_tmp16_ = scratch_dialogs_preferences_settings_switch_new ("autosave");
	g_object_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	gtk_grid_attach (_tmp15_, (GtkWidget*) _tmp17_, 1, 1, 2, 1);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = general_grid;
	_tmp19_ = scratch_dialogs_preferences_settings_label_new (_ ("Smart cut/copy lines:"));
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	gtk_grid_attach (_tmp18_, (GtkWidget*) _tmp20_, 0, 2, 1, 1);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = general_grid;
	_tmp22_ = scratch_dialogs_preferences_settings_switch_new ("smart-cut-copy");
	g_object_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp23_, 1, 2, 1, 1);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = general_grid;
	_tmp25_ = smart_cut_copy_info;
	gtk_grid_attach (_tmp24_, (GtkWidget*) _tmp25_, 2, 2, 1, 1);
	_tmp26_ = general_grid;
	_tmp27_ = granite_header_label_new (_ ("Tabs"));
	g_object_ref_sink (_tmp27_);
	_tmp28_ = _tmp27_;
	gtk_grid_attach (_tmp26_, (GtkWidget*) _tmp28_, 0, 3, 3, 1);
	_g_object_unref0 (_tmp28_);
	_tmp29_ = general_grid;
	_tmp30_ = scratch_dialogs_preferences_settings_label_new (_ ("Automatic indentation:"));
	g_object_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp31_, 0, 4, 1, 1);
	_g_object_unref0 (_tmp31_);
	_tmp32_ = general_grid;
	_tmp33_ = scratch_dialogs_preferences_settings_switch_new ("auto-indent");
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	gtk_grid_attach (_tmp32_, (GtkWidget*) _tmp34_, 1, 4, 2, 1);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = general_grid;
	_tmp36_ = scratch_dialogs_preferences_settings_label_new (_ ("Insert spaces instead of tabs:"));
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	gtk_grid_attach (_tmp35_, (GtkWidget*) _tmp37_, 0, 5, 1, 1);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = general_grid;
	_tmp39_ = scratch_dialogs_preferences_settings_switch_new ("spaces-instead-of-tabs");
	g_object_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	gtk_grid_attach (_tmp38_, (GtkWidget*) _tmp40_, 1, 5, 2, 1);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = general_grid;
	_tmp42_ = scratch_dialogs_preferences_settings_label_new (_ ("Strip trailing whitespace:"));
	g_object_ref_sink (_tmp42_);
	_tmp43_ = _tmp42_;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp43_, 0, 6, 1, 1);
	_g_object_unref0 (_tmp43_);
	_tmp44_ = general_grid;
	_tmp45_ = scratch_dialogs_preferences_settings_switch_new ("strip-trailing-on-save");
	g_object_ref_sink (_tmp45_);
	_tmp46_ = _tmp45_;
	gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp46_, 1, 6, 2, 1);
	_g_object_unref0 (_tmp46_);
	_tmp47_ = general_grid;
	_tmp48_ = scratch_dialogs_preferences_settings_label_new (_ ("Tab width:"));
	g_object_ref_sink (_tmp48_);
	_tmp49_ = _tmp48_;
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp49_, 0, 7, 1, 1);
	_g_object_unref0 (_tmp49_);
	_tmp50_ = general_grid;
	_tmp51_ = indent_width;
	gtk_grid_attach (_tmp50_, (GtkWidget*) _tmp51_, 1, 7, 2, 1);
	_tmp52_ = (GtkStack*) gtk_stack_new ();
	g_object_set ((GtkWidget*) _tmp52_, "margin", 12, NULL);
	g_object_ref_sink (_tmp52_);
	_g_object_unref0 (self->priv->main_stack);
	self->priv->main_stack = _tmp52_;
	_tmp53_ = self->priv->main_stack;
	_tmp54_ = general_grid;
	gtk_stack_add_titled (_tmp53_, (GtkWidget*) _tmp54_, "behavior", _ ("Behavior"));
	_tmp55_ = self->priv->main_stack;
	_tmp56_ = scratch_dialogs_preferences_get_editor_box (self);
	_tmp57_ = _tmp56_;
	gtk_stack_add_titled (_tmp55_, _tmp57_, "interface", _ ("Interface"));
	_g_object_unref0 (_tmp57_);
	_tmp58_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	g_object_ref_sink (_tmp58_);
	main_stackswitcher = _tmp58_;
	_tmp59_ = main_stackswitcher;
	_tmp60_ = self->priv->main_stack;
	gtk_stack_switcher_set_stack (_tmp59_, _tmp60_);
	_tmp61_ = main_stackswitcher;
	gtk_widget_set_halign ((GtkWidget*) _tmp61_, GTK_ALIGN_CENTER);
	_tmp62_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_row_spacing (_tmp62_, 12);
	g_object_ref_sink (_tmp62_);
	main_grid = _tmp62_;
	_tmp63_ = main_grid;
	_tmp64_ = main_stackswitcher;
	gtk_grid_attach (_tmp63_, (GtkWidget*) _tmp64_, 0, 0, 1, 1);
	_tmp65_ = main_grid;
	_tmp66_ = self->priv->main_stack;
	gtk_grid_attach (_tmp65_, (GtkWidget*) _tmp66_, 0, 1, 1, 1);
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 0);
	_tmp67_ = gtk_dialog_get_content_area ((GtkDialog*) self);
	_tmp68_ = main_grid;
	gtk_container_add ((GtkContainer*) _tmp67_, (GtkWidget*) _tmp68_);
	_tmp69_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_button_get_type (), GtkButton));
	close_button = _tmp70_;
	_tmp71_ = close_button;
	g_signal_connect_object (_tmp71_, "clicked", (GCallback) __scratch_dialogs_preferences___lambda57__gtk_button_clicked, self, 0);
	_g_object_unref0 (close_button);
	_g_object_unref0 (main_grid);
	_g_object_unref0 (main_stackswitcher);
	_g_object_unref0 (general_grid);
	_g_object_unref0 (indent_width);
	_g_object_unref0 (smart_cut_copy_info);
	return obj;
}

static void
scratch_dialogs_preferences_class_init (ScratchDialogsPreferencesClass * klass,
                                        gpointer klass_data)
{
	scratch_dialogs_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchDialogsPreferences_private_offset);
	G_OBJECT_CLASS (klass)->constructor = scratch_dialogs_preferences_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_dialogs_preferences_finalize;
}

static void
scratch_dialogs_preferences_instance_init (ScratchDialogsPreferences * self,
                                           gpointer klass)
{
	self->priv = scratch_dialogs_preferences_get_instance_private (self);
}

static void
scratch_dialogs_preferences_finalize (GObject * obj)
{
	ScratchDialogsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_DIALOGS_TYPE_PREFERENCES, ScratchDialogsPreferences);
	_g_object_unref0 (self->priv->main_stack);
	_g_object_unref0 (self->priv->highlight_matching_brackets);
	_g_object_unref0 (self->priv->use_custom_font);
	_g_object_unref0 (self->priv->select_font);
	_g_object_unref0 (self->priv->show_mini_map);
	G_OBJECT_CLASS (scratch_dialogs_preferences_parent_class)->finalize (obj);
}

static GType
scratch_dialogs_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchDialogsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_dialogs_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchDialogsPreferences), 0, (GInstanceInitFunc) scratch_dialogs_preferences_instance_init, NULL };
	GType scratch_dialogs_preferences_type_id;
	scratch_dialogs_preferences_type_id = g_type_register_static (GRANITE_TYPE_DIALOG, "ScratchDialogsPreferences", &g_define_type_info, 0);
	ScratchDialogsPreferences_private_offset = g_type_add_instance_private (scratch_dialogs_preferences_type_id, sizeof (ScratchDialogsPreferencesPrivate));
	return scratch_dialogs_preferences_type_id;
}

GType
scratch_dialogs_preferences_get_type (void)
{
	static volatile gsize scratch_dialogs_preferences_type_id__once = 0;
	if (g_once_init_enter (&scratch_dialogs_preferences_type_id__once)) {
		GType scratch_dialogs_preferences_type_id;
		scratch_dialogs_preferences_type_id = scratch_dialogs_preferences_get_type_once ();
		g_once_init_leave (&scratch_dialogs_preferences_type_id__once, scratch_dialogs_preferences_type_id);
	}
	return scratch_dialogs_preferences_type_id__once;
}

