/* Application.c generated by valac 0.56.14, the Vala compiler
 * generated from Application.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*
* Copyright (c) 2011-2012 Giulio Collura <random.cpp@gmail.com>
*               2013 Mario Guerriero <mefrio.g@gmail.com>
*               2017 elementary LLC. <https://elementary.io>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "codecore.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <locale.h>

enum  {
	SCRATCH_APPLICATION_0_PROPERTY,
	SCRATCH_APPLICATION_DATA_HOME_FOLDER_UNSAVED_PROPERTY,
	SCRATCH_APPLICATION_DEFAULT_FONT_PROPERTY,
	SCRATCH_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* scratch_application_properties[SCRATCH_APPLICATION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _ScratchApplicationPrivate {
	gchar* _default_font;
	ScratchLocationJumpManager* location_jump_manager;
};

GSettings* scratch_saved_state = NULL;
GSettings* scratch_settings = NULL;
GSettings* scratch_service_settings = NULL;
GSettings* scratch_privacy_settings = NULL;
static gint ScratchApplication_private_offset;
static gpointer scratch_application_parent_class = NULL;
static gchar* scratch_application__data_home_folder_unsaved;
static gchar* scratch_application__data_home_folder_unsaved = NULL;
static gboolean scratch_application_create_new_tab;
static gboolean scratch_application_create_new_tab = FALSE;
static gboolean scratch_application_create_new_window;
static gboolean scratch_application_create_new_window = FALSE;

static gint scratch_application_real_handle_local_options (GApplication* base,
                                                    GVariantDict* options);
static gint scratch_application_real_command_line (GApplication* base,
                                            GApplicationCommandLine* command_line);
static void _vala_array_add1 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void scratch_application_real_activate (GApplication* base);
static void scratch_application_real_open (GApplication* base,
                                    GFile** files,
                                    gint files_length1,
                                    const gchar* hint);
static GObject * scratch_application_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void scratch_application_finalize (GObject * obj);
static GType scratch_application_get_type_once (void);
static void _vala_scratch_application_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_scratch_application_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry SCRATCH_APPLICATION_ENTRIES[6] = {{"new-tab", 't', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("New Tab"), NULL}, {"new-window", 'n', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("New Window"), NULL}, {"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Print version info and exit"), NULL}, {"go-to", 'g', (gint) 0, G_OPTION_ARG_STRING, NULL, "Open file at specified selection range", "<start_line[.start_column][-end_line[.end_column]]>"}, {G_OPTION_REMAINING, (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY, NULL, NULL, N_ ("[FILE…]")}, {NULL}};

static inline gpointer
scratch_application_get_instance_private (ScratchApplication* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchApplication_private_offset);
}

static gint
scratch_application_real_handle_local_options (GApplication* base,
                                               GVariantDict* options)
{
	ScratchApplication * self;
	gint result;
	self = (ScratchApplication*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "Code %s\n", CONSTANTS_VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static void
_vala_array_add1 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gint
scratch_application_real_command_line (GApplication* base,
                                       GApplicationCommandLine* command_line)
{
	ScratchApplication * self;
	gboolean _tmp0_ = FALSE;
	GVariantDict* options = NULL;
	GVariantDict* _tmp2_;
	GVariantDict* _tmp3_;
	ScratchLocationJumpManager* _tmp4_;
	GVariantDict* _tmp5_;
	GVariantDict* _tmp6_;
	GVariantDict* _tmp7_;
	gboolean _tmp17_ = FALSE;
	ScratchLocationJumpManager* _tmp18_;
	GVariantDict* _tmp34_;
	gint result;
	self = (ScratchApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	if (getuid () == ((uid_t) 0)) {
		const gchar* _tmp1_;
		_tmp1_ = g_getenv ("PKEXEC_UID");
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_warning ("Application.vala:94: Running Code using sudo is not possible. Use: pke" \
"xec io.elementary.code");
		g_application_quit ((GApplication*) self);
		result = 1;
		return result;
	}
	_tmp2_ = g_application_command_line_get_options_dict (command_line);
	_tmp3_ = _g_variant_dict_ref0 (_tmp2_);
	options = _tmp3_;
	_tmp4_ = self->priv->location_jump_manager;
	scratch_location_jump_manager_clear (_tmp4_);
	_tmp5_ = options;
	if (g_variant_dict_contains (_tmp5_, "new-tab")) {
		scratch_application_create_new_tab = TRUE;
	}
	_tmp6_ = options;
	if (g_variant_dict_contains (_tmp6_, "new-window")) {
		scratch_application_create_new_window = TRUE;
	}
	_tmp7_ = options;
	if (g_variant_dict_contains (_tmp7_, "go-to")) {
		GVariant* go_to_string_variant = NULL;
		GVariantDict* _tmp8_;
		const GVariantType* _tmp9_;
		GVariant* _tmp10_;
		gchar* selection_range_string = NULL;
		GVariant* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		ScratchLocationJumpManager* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp8_ = options;
		_tmp9_ = G_VARIANT_TYPE_STRING;
		_tmp10_ = g_variant_dict_lookup_value (_tmp8_, "go-to", _tmp9_);
		go_to_string_variant = _tmp10_;
		_tmp11_ = go_to_string_variant;
		_tmp12_ = g_variant_get_string (_tmp11_, NULL);
		_tmp13_ = g_strdup ((const gchar*) _tmp12_);
		selection_range_string = _tmp13_;
		_tmp14_ = self->priv->location_jump_manager;
		_tmp15_ = selection_range_string;
		scratch_location_jump_manager_parse_selection_range_string (_tmp14_, _tmp15_);
		_tmp16_ = selection_range_string;
		g_debug ("Application.vala:115: go-to arg value: %s", _tmp16_);
		_g_free0 (selection_range_string);
		_g_variant_unref0 (go_to_string_variant);
	}
	_tmp18_ = self->priv->location_jump_manager;
	if (scratch_location_jump_manager_has_selection_range (_tmp18_)) {
		GVariantDict* _tmp19_;
		_tmp19_ = options;
		_tmp17_ = g_variant_dict_contains (_tmp19_, G_OPTION_REMAINING);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		const gchar** file_list = NULL;
		GVariantDict* _tmp20_;
		const GVariantType* _tmp21_;
		GVariant* _tmp22_;
		GVariant* _tmp23_;
		gsize _tmp24_ = 0;
		const gchar** _tmp25_;
		const gchar** _tmp26_;
		gint _tmp26__length1;
		gint file_list_length1;
		gint _file_list_size_;
		const gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp20_ = options;
		_tmp21_ = G_VARIANT_TYPE_BYTESTRING_ARRAY;
		_tmp22_ = g_variant_dict_lookup_value (_tmp20_, G_OPTION_REMAINING, _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp25_ = g_variant_get_bytestring_array (_tmp23_, &_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp26__length1 = _tmp24_;
		_g_variant_unref0 (_tmp23_);
		file_list = _tmp26_;
		file_list_length1 = _tmp26__length1;
		_file_list_size_ = file_list_length1;
		_tmp27_ = file_list;
		_tmp27__length1 = file_list_length1;
		if (_tmp27__length1 == 1) {
			const gchar* selection_range_file_path = NULL;
			const gchar** _tmp28_;
			gint _tmp28__length1;
			const gchar* _tmp29_;
			ScratchLocationJumpManager* _tmp30_;
			const gchar* _tmp31_;
			GFile* _tmp32_;
			GFile* _tmp33_;
			_tmp28_ = file_list;
			_tmp28__length1 = file_list_length1;
			_tmp29_ = _tmp28_[0];
			selection_range_file_path = _tmp29_;
			_tmp30_ = self->priv->location_jump_manager;
			_tmp31_ = selection_range_file_path;
			_tmp32_ = g_application_command_line_create_file_for_arg (command_line, _tmp31_);
			_tmp33_ = _tmp32_;
			scratch_location_jump_manager_set_file (_tmp30_, _tmp33_);
			_g_object_unref0 (_tmp33_);
		}
		file_list = (g_free (file_list), NULL);
	}
	g_application_activate ((GApplication*) self);
	_tmp34_ = options;
	if (g_variant_dict_contains (_tmp34_, G_OPTION_REMAINING)) {
		GFile** files = NULL;
		GFile** _tmp35_;
		gint files_length1;
		gint _files_size_;
		const gchar** remaining = NULL;
		GVariantDict* _tmp36_;
		const GVariantType* _tmp37_;
		GVariant* _tmp38_;
		GVariant* _tmp39_;
		gsize _tmp40_ = 0;
		const gchar** _tmp41_;
		const gchar** _tmp42_;
		gint _tmp42__length1;
		gint remaining_length1;
		gint _remaining_size_;
		GFile** _tmp50_;
		gint _tmp50__length1;
		_tmp35_ = g_new0 (GFile*, 0 + 1);
		files = _tmp35_;
		files_length1 = 0;
		_files_size_ = files_length1;
		_tmp36_ = options;
		_tmp37_ = G_VARIANT_TYPE_BYTESTRING_ARRAY;
		_tmp38_ = g_variant_dict_lookup_value (_tmp36_, G_OPTION_REMAINING, _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp41_ = g_variant_get_bytestring_array (_tmp39_, &_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp42__length1 = _tmp40_;
		_g_variant_unref0 (_tmp39_);
		remaining = _tmp42_;
		remaining_length1 = _tmp42__length1;
		_remaining_size_ = remaining_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp43_ = FALSE;
				_tmp43_ = TRUE;
				while (TRUE) {
					const gchar** _tmp45_;
					gint _tmp45__length1;
					const gchar* file = NULL;
					const gchar** _tmp46_;
					gint _tmp46__length1;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					GFile* _tmp49_;
					if (!_tmp43_) {
						gint _tmp44_;
						_tmp44_ = i;
						i = _tmp44_ + 1;
					}
					_tmp43_ = FALSE;
					_tmp45_ = remaining;
					_tmp45__length1 = remaining_length1;
					if (!(i < _tmp45__length1)) {
						break;
					}
					_tmp46_ = remaining;
					_tmp46__length1 = remaining_length1;
					_tmp47_ = _tmp46_[i];
					file = _tmp47_;
					_tmp48_ = file;
					_tmp49_ = g_application_command_line_create_file_for_arg (command_line, _tmp48_);
					_vala_array_add1 (&files, &files_length1, &_files_size_, _tmp49_);
				}
			}
		}
		_tmp50_ = files;
		_tmp50__length1 = files_length1;
		g_application_open ((GApplication*) self, _tmp50_, (gint) _tmp50__length1, "");
		remaining = (g_free (remaining), NULL);
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	result = EXIT_SUCCESS;
	_g_variant_dict_unref0 (options);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
scratch_application_real_activate (GApplication* base)
{
	ScratchApplication * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp14_;
	GtkWindow* _tmp15_;
	self = (ScratchApplication*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gboolean _tmp2_ = FALSE;
		ScratchLocationJumpManager* _tmp3_;
		_tmp3_ = self->priv->location_jump_manager;
		if (scratch_location_jump_manager_has_selection_range (_tmp3_)) {
			ScratchLocationJumpManager* _tmp4_;
			_tmp4_ = self->priv->location_jump_manager;
			_tmp2_ = scratch_location_jump_manager_has_override_target (_tmp4_);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			RestoreOverride* restore_override = NULL;
			ScratchLocationJumpManager* _tmp5_;
			RestoreOverride* _tmp6_;
			RestoreOverride* _tmp7_;
			ScratchMainWindow* _tmp8_;
			ScratchMainWindow* _tmp9_;
			_tmp5_ = self->priv->location_jump_manager;
			_tmp6_ = scratch_location_jump_manager_create_restore_override (_tmp5_);
			restore_override = _tmp6_;
			_tmp7_ = restore_override;
			_tmp8_ = scratch_main_window_new_with_restore_override (TRUE, _tmp7_);
			g_object_ref_sink (_tmp8_);
			_tmp9_ = _tmp8_;
			gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp9_);
			_g_object_unref0 (_tmp9_);
			_g_object_unref0 (restore_override);
		} else {
			ScratchMainWindow* _tmp10_;
			ScratchMainWindow* _tmp11_;
			_tmp10_ = scratch_main_window_new (TRUE);
			g_object_ref_sink (_tmp10_);
			_tmp11_ = _tmp10_;
			gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp11_);
			_g_object_unref0 (_tmp11_);
		}
	} else {
		if (scratch_application_create_new_window) {
			ScratchMainWindow* _tmp12_;
			ScratchMainWindow* _tmp13_;
			scratch_application_create_new_window = FALSE;
			_tmp12_ = scratch_main_window_new (FALSE);
			g_object_ref_sink (_tmp12_);
			_tmp13_ = _tmp12_;
			gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp13_);
			_g_object_unref0 (_tmp13_);
		}
	}
	_tmp14_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp15_ = _tmp14_;
	gtk_window_present (_tmp15_);
	if (scratch_application_create_new_tab) {
		GActionGroup* active_window_action_group = NULL;
		GtkWindow* _tmp16_;
		GtkWindow* _tmp17_;
		GActionGroup* _tmp18_;
		GActionGroup* _tmp19_;
		GActionGroup* _tmp20_;
		scratch_application_create_new_tab = FALSE;
		_tmp16_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = gtk_widget_get_action_group ((GtkWidget*) _tmp17_, SCRATCH_MAIN_WINDOW_ACTION_GROUP);
		_tmp19_ = _g_object_ref0 (_tmp18_);
		active_window_action_group = _tmp19_;
		_tmp20_ = active_window_action_group;
		g_action_group_activate_action (_tmp20_, SCRATCH_MAIN_WINDOW_ACTION_NEW_TAB, NULL);
		_g_object_unref0 (active_window_action_group);
	}
}

static void
scratch_application_real_open (GApplication* base,
                               GFile** files,
                               gint files_length1,
                               const gchar* hint)
{
	ScratchApplication * self;
	ScratchMainWindow* window = NULL;
	ScratchMainWindow* _tmp0_;
	self = (ScratchApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = scratch_application_get_last_window (self);
	window = _tmp0_;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				gboolean is_folder = FALSE;
				GFile* _tmp2_;
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_;
				_tmp2_ = file;
				_tmp4_ = scratch_services_file_handler_can_open_file (_tmp2_, &_tmp3_);
				is_folder = _tmp3_;
				if (_tmp4_) {
					if (is_folder) {
						ScratchMainWindow* _tmp5_;
						GFile* _tmp6_;
						_tmp5_ = window;
						_tmp6_ = file;
						scratch_main_window_open_folder (_tmp5_, _tmp6_);
					} else {
						ScratchServicesDocument* doc = NULL;
						ScratchMainWindow* _tmp7_;
						GSimpleActionGroup* _tmp8_;
						GSimpleActionGroup* _tmp9_;
						GFile* _tmp10_;
						ScratchServicesDocument* _tmp11_;
						gboolean _tmp12_ = FALSE;
						ScratchLocationJumpManager* _tmp13_;
						g_debug ("Application.vala:182: Files length: %d\n", files_length1);
						_tmp7_ = window;
						_tmp8_ = scratch_main_window_get_actions (_tmp7_);
						_tmp9_ = _tmp8_;
						_tmp10_ = file;
						_tmp11_ = scratch_services_document_new (_tmp9_, _tmp10_);
						g_object_ref_sink (_tmp11_);
						doc = _tmp11_;
						_tmp13_ = self->priv->location_jump_manager;
						if (scratch_location_jump_manager_has_selection_range != NULL) {
							_tmp12_ = files_length1 == 1;
						} else {
							_tmp12_ = FALSE;
						}
						if (_tmp12_) {
							ScratchMainWindow* _tmp14_;
							ScratchServicesDocument* _tmp15_;
							ScratchLocationJumpManager* _tmp16_;
							SelectionRange _tmp17_ = {0};
							SelectionRange _tmp18_;
							_tmp14_ = window;
							_tmp15_ = doc;
							_tmp16_ = self->priv->location_jump_manager;
							scratch_location_jump_manager_get_range (_tmp16_, &_tmp17_);
							_tmp18_ = _tmp17_;
							scratch_main_window_open_document_at_selected_range (_tmp14_, _tmp15_, TRUE, &_tmp18_, FALSE);
						} else {
							ScratchMainWindow* _tmp19_;
							ScratchServicesDocument* _tmp20_;
							_tmp19_ = window;
							_tmp20_ = doc;
							scratch_main_window_open_document (_tmp19_, _tmp20_, TRUE, 0);
						}
						_g_object_unref0 (doc);
					}
				}
				_g_object_unref0 (file);
			}
		}
	}
	_g_object_unref0 (window);
}

ScratchMainWindow*
scratch_application_get_last_window (ScratchApplication* self)
{
	GList* windows = NULL;
	GList* _tmp0_;
	ScratchMainWindow* _tmp1_ = NULL;
	GList* _tmp2_;
	ScratchMainWindow* _tmp7_;
	ScratchMainWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	windows = _tmp0_;
	_tmp2_ = windows;
	if (g_list_length (_tmp2_) > ((guint) 0)) {
		GList* _tmp3_;
		GList* _tmp4_;
		gconstpointer _tmp5_;
		GtkWindow* _tmp6_;
		_tmp3_ = windows;
		_tmp4_ = g_list_last (_tmp3_);
		_tmp5_ = _tmp4_->data;
		_tmp6_ = (GtkWindow*) _tmp5_;
		_tmp1_ = SCRATCH_IS_MAIN_WINDOW (_tmp6_) ? ((ScratchMainWindow*) _tmp6_) : NULL;
	} else {
		_tmp1_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp1_);
	result = _tmp7_;
	return result;
}

static gint
scratch_application_main (gchar** args,
                          gint args_length1)
{
	ScratchApplication* _tmp0_;
	ScratchApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = scratch_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return scratch_application_main (argv, argc);
}

ScratchApplication*
scratch_application_construct (GType object_type)
{
	ScratchApplication * self = NULL;
	self = (ScratchApplication*) g_object_new (object_type, NULL);
	return self;
}

ScratchApplication*
scratch_application_new (void)
{
	return scratch_application_construct (SCRATCH_TYPE_APPLICATION);
}

const gchar*
scratch_application_get_data_home_folder_unsaved (ScratchApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = scratch_application__data_home_folder_unsaved;
	result = _tmp0_;
	return result;
}

const gchar*
scratch_application_get_default_font (ScratchApplication* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_font;
	result = _tmp0_;
	return result;
}

void
scratch_application_set_default_font (ScratchApplication* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_application_get_default_font (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_default_font);
		self->priv->_default_font = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_application_properties[SCRATCH_APPLICATION_DEFAULT_FONT_PROPERTY]);
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static GObject *
scratch_application_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchApplication * self;
	GApplicationFlags _tmp0_;
	GApplicationFlags _tmp1_;
	GApplicationFlags _tmp2_;
	GApplicationFlags _tmp3_;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GSettings* _tmp18_;
	GSettings* _tmp19_;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	ScratchLocationJumpManager* _tmp22_;
	parent_class = G_OBJECT_CLASS (scratch_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_APPLICATION, ScratchApplication);
	_tmp0_ = g_application_get_flags ((GApplication*) self);
	_tmp1_ = _tmp0_;
	g_application_set_flags ((GApplication*) self, _tmp1_ | G_APPLICATION_HANDLES_OPEN);
	_tmp2_ = g_application_get_flags ((GApplication*) self);
	_tmp3_ = _tmp2_;
	g_application_set_flags ((GApplication*) self, _tmp3_ | G_APPLICATION_HANDLES_COMMAND_LINE);
	g_application_set_application_id ((GApplication*) self, CONSTANTS_PROJECT_NAME);
	if (g_strcmp0 (CONSTANTS_BRANCH, "") != 0) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp4_ = g_application_get_application_id ((GApplication*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = string_replace (CONSTANTS_BRANCH, "/", ".");
		_tmp7_ = _tmp6_;
		_tmp8_ = string_replace (_tmp7_, "-", "_");
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (".", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp5_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		g_application_set_application_id ((GApplication*) self, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
	}
	g_application_add_main_option_entries ((GApplication*) self, SCRATCH_APPLICATION_ENTRIES);
	_tmp14_ = g_settings_new ("org.gnome.desktop.interface");
	_tmp15_ = _tmp14_;
	_tmp16_ = g_settings_get_string (_tmp15_, "monospace-font-name");
	_tmp17_ = _tmp16_;
	scratch_application_set_default_font (self, _tmp17_);
	_g_free0 (_tmp17_);
	_g_object_unref0 (_tmp15_);
	_tmp18_ = g_settings_new (CONSTANTS_PROJECT_NAME ".saved-state");
	_g_object_unref0 (scratch_saved_state);
	scratch_saved_state = _tmp18_;
	_tmp19_ = g_settings_new (CONSTANTS_PROJECT_NAME ".settings");
	_g_object_unref0 (scratch_settings);
	scratch_settings = _tmp19_;
	_tmp20_ = g_settings_new (CONSTANTS_PROJECT_NAME ".services");
	_g_object_unref0 (scratch_service_settings);
	scratch_service_settings = _tmp20_;
	_tmp21_ = g_settings_new ("org.gnome.desktop.privacy");
	_g_object_unref0 (scratch_privacy_settings);
	scratch_privacy_settings = _tmp21_;
	_tmp22_ = scratch_location_jump_manager_new ();
	_g_object_unref0 (self->priv->location_jump_manager);
	self->priv->location_jump_manager = _tmp22_;
	g_setenv ("GTK_USE_PORTAL", "1", TRUE);
	setlocale (LC_ALL, "");
	bindtextdomain (CONSTANTS_GETTEXT_PACKAGE, CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	textdomain (CONSTANTS_GETTEXT_PACKAGE);
	return obj;
}

static void
scratch_application_class_init (ScratchApplicationClass * klass,
                                gpointer klass_data)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	scratch_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchApplication_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) scratch_application_real_handle_local_options;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) scratch_application_real_command_line;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) scratch_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) scratch_application_real_open;
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_application_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_application_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_application_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_APPLICATION_DATA_HOME_FOLDER_UNSAVED_PROPERTY, scratch_application_properties[SCRATCH_APPLICATION_DATA_HOME_FOLDER_UNSAVED_PROPERTY] = g_param_spec_string ("data-home-folder-unsaved", "data-home-folder-unsaved", "data-home-folder-unsaved", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_APPLICATION_DEFAULT_FONT_PROPERTY, scratch_application_properties[SCRATCH_APPLICATION_DEFAULT_FONT_PROPERTY] = g_param_spec_string ("default-font", "default-font", "default-font", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, CONSTANTS_PROJECT_NAME, "unsaved", NULL);
	_g_free0 (scratch_application__data_home_folder_unsaved);
	scratch_application__data_home_folder_unsaved = _tmp1_;
}

static void
scratch_application_instance_init (ScratchApplication * self,
                                   gpointer klass)
{
	self->priv = scratch_application_get_instance_private (self);
}

static void
scratch_application_finalize (GObject * obj)
{
	ScratchApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_APPLICATION, ScratchApplication);
	_g_free0 (self->priv->_default_font);
	_g_object_unref0 (self->priv->location_jump_manager);
	G_OBJECT_CLASS (scratch_application_parent_class)->finalize (obj);
}

static GType
scratch_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchApplication), 0, (GInstanceInitFunc) scratch_application_instance_init, NULL };
	GType scratch_application_type_id;
	scratch_application_type_id = g_type_register_static (gtk_application_get_type (), "ScratchApplication", &g_define_type_info, 0);
	ScratchApplication_private_offset = g_type_add_instance_private (scratch_application_type_id, sizeof (ScratchApplicationPrivate));
	return scratch_application_type_id;
}

GType
scratch_application_get_type (void)
{
	static volatile gsize scratch_application_type_id__once = 0;
	if (g_once_init_enter (&scratch_application_type_id__once)) {
		GType scratch_application_type_id;
		scratch_application_type_id = scratch_application_get_type_once ();
		g_once_init_leave (&scratch_application_type_id__once, scratch_application_type_id);
	}
	return scratch_application_type_id__once;
}

static void
_vala_scratch_application_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ScratchApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_APPLICATION, ScratchApplication);
	switch (property_id) {
		case SCRATCH_APPLICATION_DATA_HOME_FOLDER_UNSAVED_PROPERTY:
		g_value_set_string (value, scratch_application_get_data_home_folder_unsaved (self));
		break;
		case SCRATCH_APPLICATION_DEFAULT_FONT_PROPERTY:
		g_value_set_string (value, scratch_application_get_default_font (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_application_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ScratchApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_APPLICATION, ScratchApplication);
	switch (property_id) {
		case SCRATCH_APPLICATION_DEFAULT_FONT_PROPERTY:
		scratch_application_set_default_font (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

