/* Terminal.c generated by valac 0.56.14, the Vala compiler
 * generated from Terminal.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022 elementary, Inc. (https://elementary.io)
 *                         2011-2013 Mario Guerriero <mario@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <vte/vte.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#define CODE_TERMINAL_MAX_SCALE 5.0
#define CODE_TERMINAL_MIN_SCALE 0.2
#define CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA "org.pantheon.terminal.settings"
#define CODE_TERMINAL_SETTINGS_SCHEMA "io.elementary.terminal.settings"
#define SCRATCH_MAIN_WINDOW_ACTION_GROUP "win"
#define SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_GROUP "."
#define SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_TERMINAL "action-toggle-terminal"
#define CONSTANTS_PROJECT_NAME "io.elementary.code"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CODE_TYPE_TERMINAL (code_terminal_get_type ())
#define CODE_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CODE_TYPE_TERMINAL, CodeTerminal))
#define CODE_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CODE_TYPE_TERMINAL, CodeTerminalClass))
#define CODE_IS_TERMINAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CODE_TYPE_TERMINAL))
#define CODE_IS_TERMINAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CODE_TYPE_TERMINAL))
#define CODE_TERMINAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CODE_TYPE_TERMINAL, CodeTerminalClass))

typedef struct _CodeTerminal CodeTerminal;
typedef struct _CodeTerminalClass CodeTerminalClass;
typedef struct _CodeTerminalPrivate CodeTerminalPrivate;
enum  {
	CODE_TERMINAL_0_PROPERTY,
	CODE_TERMINAL_TERMINAL_PROPERTY,
	CODE_TERMINAL_NUM_PROPERTIES
};
static GParamSpec* code_terminal_properties[CODE_TERMINAL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _Block40Data Block40Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))

struct _CodeTerminal {
	GtkBox parent_instance;
	CodeTerminalPrivate * priv;
};

struct _CodeTerminalClass {
	GtkBoxClass parent_class;
};

struct _CodeTerminalPrivate {
	GPid child_pid;
	VteTerminal* _terminal;
};

struct _Block40Data {
	int _ref_count_;
	CodeTerminal* self;
	GtkMenu* menu;
	GSettings* settings;
};

static gint CodeTerminal_private_offset;
static gpointer code_terminal_parent_class = NULL;

VALA_EXTERN GType code_terminal_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CodeTerminal, g_object_unref)
static void code_terminal_spawn_shell (CodeTerminal* self,
                                const gchar* dir);
VALA_EXTERN VteTerminal* code_terminal_get_terminal (CodeTerminal* self);
VALA_EXTERN void code_terminal_change_location (CodeTerminal* self,
                                    const gchar* dir);
static gchar* code_terminal_get_shell_location (CodeTerminal* self);
static void code_terminal_update_terminal_settings (CodeTerminal* self,
                                             const gchar* settings_schema);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN void code_terminal_increment_size (CodeTerminal* self);
VALA_EXTERN void code_terminal_decrement_size (CodeTerminal* self);
VALA_EXTERN void code_terminal_set_default_font_size (CodeTerminal* self);
VALA_EXTERN CodeTerminal* code_terminal_new (void);
VALA_EXTERN CodeTerminal* code_terminal_construct (GType object_type);
static void code_terminal_set_terminal (CodeTerminal* self,
                                 VteTerminal* value);
static GObject * code_terminal_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static Block40Data* block40_data_ref (Block40Data* _data40_);
static void block40_data_unref (void * _userdata_);
static void _code_terminal___lambda123_ (CodeTerminal* self);
static void __code_terminal___lambda123__vte_terminal_child_exited (VteTerminal* _sender,
                                                             gint status,
                                                             gpointer self);
static void _code_terminal___lambda124_ (CodeTerminal* self);
static void __code_terminal___lambda124__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self);
static void _code_terminal___lambda125_ (CodeTerminal* self);
static void __code_terminal___lambda125__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                          gpointer self);
static gboolean _code_terminal___lambda126_ (Block40Data* _data40_,
                                      GdkEventButton* event);
static gboolean __code_terminal___lambda126__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                     GdkEventButton* event,
                                                                     gpointer self);
static void _code_terminal___lambda127_ (Block40Data* _data40_);
static void __code_terminal___lambda127__gtk_widget_destroy (GtkWidget* _sender,
                                                      gpointer self);
static void code_terminal_finalize (GObject * obj);
static GType code_terminal_get_type_once (void);
static void _vala_code_terminal_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_code_terminal_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
code_terminal_get_instance_private (CodeTerminal* self)
{
	return G_STRUCT_MEMBER_P (self, CodeTerminal_private_offset);
}

static void
code_terminal_spawn_shell (CodeTerminal* self,
                           const gchar* dir)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	{
		VteTerminal* _tmp0_;
		gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		GPid _tmp4_ = 0;
		_tmp0_ = self->priv->_terminal;
		_tmp1_ = vte_get_user_shell ();
		_tmp2_ = g_new0 (gchar*, 1 + 1);
		_tmp2_[0] = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 1;
		vte_terminal_spawn_sync (_tmp0_, VTE_PTY_DEFAULT, dir, _tmp3_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, NULL, &_inner_error0_);
		self->priv->child_pid = _tmp4_;
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("Terminal.vala:90: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
code_terminal_change_location (CodeTerminal* self,
                               const gchar* dir)
{
	VteTerminal* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	kill ((pid_t) self->priv->child_pid, (gint) SIGTERM);
	_tmp0_ = self->priv->_terminal;
	vte_terminal_reset (_tmp0_, TRUE, TRUE);
	code_terminal_spawn_shell (self, dir);
}

static gchar*
code_terminal_get_shell_location (CodeTerminal* self)
{
	gint pid = 0;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	pid = (gint) ((GPid) self->priv->child_pid);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_strdup_printf ("/proc/%d/cwd", pid);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_read_link (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = _error_;
		_tmp7_ = _tmp6_->message;
		g_warning ("Terminal.vala:105: An error occurred while fetching the current dir of" \
" shell: %s", _tmp7_);
		_tmp8_ = g_strdup ("");
		result = _tmp8_;
		_g_error_free0 (_error_);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
code_terminal_update_terminal_settings (CodeTerminal* self,
                                        const gchar* settings_schema)
{
	GSettings* pantheon_terminal_settings = NULL;
	GSettings* _tmp0_;
	gchar* font_name = NULL;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	PangoFontDescription* fd = NULL;
	const gchar* _tmp7_;
	PangoFontDescription* _tmp8_;
	VteTerminal* _tmp9_;
	PangoFontDescription* _tmp10_;
	gboolean audible_bell_setting = FALSE;
	GSettings* _tmp11_;
	VteTerminal* _tmp12_;
	gchar* cursor_shape_setting = NULL;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	GQuark _tmp18_ = 0U;
	static GQuark _tmp17_label0 = 0;
	static GQuark _tmp17_label1 = 0;
	static GQuark _tmp17_label2 = 0;
	gchar* background_setting = NULL;
	GSettings* _tmp22_;
	gchar* _tmp23_;
	GdkRGBA background_color = {0};
	const gchar* _tmp24_;
	gchar* foreground_setting = NULL;
	GSettings* _tmp25_;
	gchar* _tmp26_;
	GdkRGBA foreground_color = {0};
	const gchar* _tmp27_;
	gchar* palette_setting = NULL;
	GSettings* _tmp28_;
	gchar* _tmp29_;
	gchar** hex_palette = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gint hex_palette_length1;
	gint _hex_palette_size_;
	gchar* current_string = NULL;
	gchar* _tmp47_;
	gint current_color = 0;
	GdkRGBA* palette = NULL;
	GdkRGBA* _tmp64_;
	gint palette_length1;
	gint _palette_size_;
	VteTerminal* _tmp72_;
	GdkRGBA _tmp73_;
	GdkRGBA _tmp74_;
	GdkRGBA* _tmp75_;
	gint _tmp75__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings_schema != NULL);
	_tmp0_ = g_settings_new (settings_schema);
	pantheon_terminal_settings = _tmp0_;
	_tmp1_ = pantheon_terminal_settings;
	_tmp2_ = g_settings_get_string (_tmp1_, "font");
	font_name = _tmp2_;
	_tmp3_ = font_name;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GSettings* system_settings = NULL;
		GSettings* _tmp4_;
		GSettings* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = g_settings_new ("org.gnome.desktop.interface");
		system_settings = _tmp4_;
		_tmp5_ = system_settings;
		_tmp6_ = g_settings_get_string (_tmp5_, "monospace-font-name");
		_g_free0 (font_name);
		font_name = _tmp6_;
		_g_object_unref0 (system_settings);
	}
	_tmp7_ = font_name;
	_tmp8_ = pango_font_description_from_string (_tmp7_);
	fd = _tmp8_;
	_tmp9_ = self->priv->_terminal;
	_tmp10_ = fd;
	vte_terminal_set_font (_tmp9_, _tmp10_);
	_tmp11_ = pantheon_terminal_settings;
	audible_bell_setting = g_settings_get_boolean (_tmp11_, "audible-bell");
	_tmp12_ = self->priv->_terminal;
	vte_terminal_set_audible_bell (_tmp12_, audible_bell_setting);
	_tmp13_ = pantheon_terminal_settings;
	_tmp14_ = g_settings_get_string (_tmp13_, "cursor-shape");
	cursor_shape_setting = _tmp14_;
	_tmp15_ = cursor_shape_setting;
	_tmp16_ = _tmp15_;
	_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
	if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("Block")))) {
		switch (0) {
			default:
			{
				VteTerminal* _tmp19_;
				_tmp19_ = self->priv->_terminal;
				vte_terminal_set_cursor_shape (_tmp19_, VTE_CURSOR_SHAPE_BLOCK);
				break;
			}
		}
	} else if (_tmp18_ == ((0 != _tmp17_label1) ? _tmp17_label1 : (_tmp17_label1 = g_quark_from_static_string ("I-Beam")))) {
		switch (0) {
			default:
			{
				VteTerminal* _tmp20_;
				_tmp20_ = self->priv->_terminal;
				vte_terminal_set_cursor_shape (_tmp20_, VTE_CURSOR_SHAPE_IBEAM);
				break;
			}
		}
	} else if (_tmp18_ == ((0 != _tmp17_label2) ? _tmp17_label2 : (_tmp17_label2 = g_quark_from_static_string ("Underline")))) {
		switch (0) {
			default:
			{
				VteTerminal* _tmp21_;
				_tmp21_ = self->priv->_terminal;
				vte_terminal_set_cursor_shape (_tmp21_, VTE_CURSOR_SHAPE_UNDERLINE);
				break;
			}
		}
	}
	_tmp22_ = pantheon_terminal_settings;
	_tmp23_ = g_settings_get_string (_tmp22_, "background");
	background_setting = _tmp23_;
	memset (&background_color, 0, sizeof (GdkRGBA));
	_tmp24_ = background_setting;
	gdk_rgba_parse (&background_color, _tmp24_);
	_tmp25_ = pantheon_terminal_settings;
	_tmp26_ = g_settings_get_string (_tmp25_, "foreground");
	foreground_setting = _tmp26_;
	memset (&foreground_color, 0, sizeof (GdkRGBA));
	_tmp27_ = foreground_setting;
	gdk_rgba_parse (&foreground_color, _tmp27_);
	_tmp28_ = pantheon_terminal_settings;
	_tmp29_ = g_settings_get_string (_tmp28_, "palette");
	palette_setting = _tmp29_;
	_tmp30_ = g_strdup ("#000000");
	_tmp31_ = g_strdup ("#FF6C60");
	_tmp32_ = g_strdup ("#A8FF60");
	_tmp33_ = g_strdup ("#FFFFCC");
	_tmp34_ = g_strdup ("#96CBFE");
	_tmp35_ = g_strdup ("#FF73FE");
	_tmp36_ = g_strdup ("#C6C5FE");
	_tmp37_ = g_strdup ("#EEEEEE");
	_tmp38_ = g_strdup ("#000000");
	_tmp39_ = g_strdup ("#FF6C60");
	_tmp40_ = g_strdup ("#A8FF60");
	_tmp41_ = g_strdup ("#FFFFB6");
	_tmp42_ = g_strdup ("#96CBFE");
	_tmp43_ = g_strdup ("#FF73FE");
	_tmp44_ = g_strdup ("#C6C5FE");
	_tmp45_ = g_strdup ("#EEEEEE");
	_tmp46_ = g_new0 (gchar*, 16 + 1);
	_tmp46_[0] = _tmp30_;
	_tmp46_[1] = _tmp31_;
	_tmp46_[2] = _tmp32_;
	_tmp46_[3] = _tmp33_;
	_tmp46_[4] = _tmp34_;
	_tmp46_[5] = _tmp35_;
	_tmp46_[6] = _tmp36_;
	_tmp46_[7] = _tmp37_;
	_tmp46_[8] = _tmp38_;
	_tmp46_[9] = _tmp39_;
	_tmp46_[10] = _tmp40_;
	_tmp46_[11] = _tmp41_;
	_tmp46_[12] = _tmp42_;
	_tmp46_[13] = _tmp43_;
	_tmp46_[14] = _tmp44_;
	_tmp46_[15] = _tmp45_;
	hex_palette = _tmp46_;
	hex_palette_length1 = 16;
	_hex_palette_size_ = hex_palette_length1;
	_tmp47_ = g_strdup ("");
	current_string = _tmp47_;
	current_color = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp48_ = FALSE;
			_tmp48_ = TRUE;
			while (TRUE) {
				const gchar* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				const gchar* _tmp53_;
				if (!_tmp48_) {
					gint _tmp49_;
					_tmp49_ = i;
					i = _tmp49_ + 1;
				}
				_tmp48_ = FALSE;
				_tmp50_ = palette_setting;
				_tmp51_ = strlen (_tmp50_);
				_tmp52_ = _tmp51_;
				if (!(i < _tmp52_)) {
					break;
				}
				_tmp53_ = palette_setting;
				if (string_get (_tmp53_, (glong) i) == ':') {
					gchar** _tmp54_;
					gint _tmp54__length1;
					const gchar* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gint _tmp58_;
					_tmp54_ = hex_palette;
					_tmp54__length1 = hex_palette_length1;
					_tmp55_ = current_string;
					_tmp56_ = g_strdup (_tmp55_);
					_g_free0 (_tmp54_[current_color]);
					_tmp54_[current_color] = _tmp56_;
					_tmp57_ = g_strdup ("");
					_g_free0 (current_string);
					current_string = _tmp57_;
					_tmp58_ = current_color;
					current_color = _tmp58_ + 1;
				} else {
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					_tmp59_ = current_string;
					_tmp60_ = palette_setting;
					_tmp61_ = g_strdup_printf ("%c", string_get (_tmp60_, (glong) i));
					_tmp62_ = _tmp61_;
					_tmp63_ = g_strconcat (_tmp59_, _tmp62_, NULL);
					_g_free0 (current_string);
					current_string = _tmp63_;
					_g_free0 (_tmp62_);
				}
			}
		}
	}
	_tmp64_ = g_new0 (GdkRGBA, 16);
	palette = _tmp64_;
	palette_length1 = 16;
	_palette_size_ = palette_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				gchar** _tmp67_;
				gint _tmp67__length1;
				GdkRGBA new_color = {0};
				gchar** _tmp68_;
				gint _tmp68__length1;
				const gchar* _tmp69_;
				GdkRGBA* _tmp70_;
				gint _tmp70__length1;
				GdkRGBA _tmp71_;
				if (!_tmp65_) {
					gint _tmp66_;
					_tmp66_ = i;
					i = _tmp66_ + 1;
				}
				_tmp65_ = FALSE;
				_tmp67_ = hex_palette;
				_tmp67__length1 = hex_palette_length1;
				if (!(i < _tmp67__length1)) {
					break;
				}
				memset (&new_color, 0, sizeof (GdkRGBA));
				_tmp68_ = hex_palette;
				_tmp68__length1 = hex_palette_length1;
				_tmp69_ = _tmp68_[i];
				gdk_rgba_parse (&new_color, _tmp69_);
				_tmp70_ = palette;
				_tmp70__length1 = palette_length1;
				_tmp71_ = new_color;
				_tmp70_[i] = _tmp71_;
			}
		}
	}
	_tmp72_ = self->priv->_terminal;
	_tmp73_ = foreground_color;
	_tmp74_ = background_color;
	_tmp75_ = palette;
	_tmp75__length1 = palette_length1;
	vte_terminal_set_colors (_tmp72_, &_tmp73_, &_tmp74_, _tmp75_, (gsize) _tmp75__length1);
	palette = (g_free (palette), NULL);
	_g_free0 (current_string);
	hex_palette = (_vala_array_free (hex_palette, hex_palette_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (palette_setting);
	_g_free0 (foreground_setting);
	_g_free0 (background_setting);
	_g_free0 (cursor_shape_setting);
	__vala_PangoFontDescription_free0 (fd);
	_g_free0 (font_name);
	_g_object_unref0 (pantheon_terminal_settings);
}

void
code_terminal_increment_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	VteTerminal* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = self->priv->_terminal;
	_tmp2_ = vte_terminal_get_font_scale (_tmp1_);
	_tmp3_ = _tmp2_;
	vte_terminal_set_font_scale (_tmp0_, CLAMP (_tmp3_ + 0.1, CODE_TERMINAL_MIN_SCALE, CODE_TERMINAL_MAX_SCALE));
}

void
code_terminal_decrement_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	VteTerminal* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	_tmp1_ = self->priv->_terminal;
	_tmp2_ = vte_terminal_get_font_scale (_tmp1_);
	_tmp3_ = _tmp2_;
	vte_terminal_set_font_scale (_tmp0_, CLAMP (_tmp3_ - 0.1, CODE_TERMINAL_MIN_SCALE, CODE_TERMINAL_MAX_SCALE));
}

void
code_terminal_set_default_font_size (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_terminal;
	vte_terminal_set_font_scale (_tmp0_, 1.0);
}

CodeTerminal*
code_terminal_construct (GType object_type)
{
	CodeTerminal * self = NULL;
	self = (CodeTerminal*) g_object_new (object_type, NULL);
	return self;
}

CodeTerminal*
code_terminal_new (void)
{
	return code_terminal_construct (CODE_TYPE_TERMINAL);
}

VteTerminal*
code_terminal_get_terminal (CodeTerminal* self)
{
	VteTerminal* result;
	VteTerminal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_terminal;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
code_terminal_set_terminal (CodeTerminal* self,
                            VteTerminal* value)
{
	VteTerminal* old_value;
	g_return_if_fail (self != NULL);
	old_value = code_terminal_get_terminal (self);
	if (old_value != value) {
		VteTerminal* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_terminal);
		self->priv->_terminal = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_terminal_properties[CODE_TERMINAL_TERMINAL_PROPERTY]);
	}
}

static Block40Data*
block40_data_ref (Block40Data* _data40_)
{
	g_atomic_int_inc (&_data40_->_ref_count_);
	return _data40_;
}

static void
block40_data_unref (void * _userdata_)
{
	Block40Data* _data40_;
	_data40_ = (Block40Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data40_->_ref_count_)) {
		CodeTerminal* self;
		self = _data40_->self;
		_g_object_unref0 (_data40_->settings);
		_g_object_unref0 (_data40_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block40Data, _data40_);
	}
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

static void
_code_terminal___lambda123_ (CodeTerminal* self)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	g_action_group_activate_action ((GActionGroup*) _tmp0_, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_TERMINAL, NULL);
}

static void
__code_terminal___lambda123__vte_terminal_child_exited (VteTerminal* _sender,
                                                        gint status,
                                                        gpointer self)
{
	_code_terminal___lambda123_ ((CodeTerminal*) self);
}

static void
_code_terminal___lambda124_ (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	_tmp0_ = self->priv->_terminal;
	vte_terminal_copy_clipboard (_tmp0_);
}

static void
__code_terminal___lambda124__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self)
{
	_code_terminal___lambda124_ ((CodeTerminal*) self);
}

static void
_code_terminal___lambda125_ (CodeTerminal* self)
{
	VteTerminal* _tmp0_;
	_tmp0_ = self->priv->_terminal;
	vte_terminal_paste_clipboard (_tmp0_);
}

static void
__code_terminal___lambda125__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                     gpointer self)
{
	_code_terminal___lambda125_ ((CodeTerminal*) self);
}

static gboolean
_code_terminal___lambda126_ (Block40Data* _data40_,
                             GdkEventButton* event)
{
	CodeTerminal* self;
	gboolean result;
	self = _data40_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 3)) {
		GtkMenu* _tmp0_;
		GtkMenu* _tmp1_;
		_tmp0_ = _data40_->menu;
		gtk_menu_shell_select_first ((GtkMenuShell*) _tmp0_, FALSE);
		_tmp1_ = _data40_->menu;
		gtk_menu_popup_at_pointer (_tmp1_, (GdkEvent*) event);
	}
	result = FALSE;
	return result;
}

static gboolean
__code_terminal___lambda126__gtk_widget_button_press_event (GtkWidget* _sender,
                                                            GdkEventButton* event,
                                                            gpointer self)
{
	gboolean result;
	result = _code_terminal___lambda126_ (self, event);
	return result;
}

static void
_code_terminal___lambda127_ (Block40Data* _data40_)
{
	CodeTerminal* self;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	self = _data40_->self;
	_tmp0_ = _data40_->settings;
	_tmp1_ = code_terminal_get_shell_location (self);
	_tmp2_ = _tmp1_;
	g_settings_set_string (_tmp0_, "last-opened-path", _tmp2_);
	_g_free0 (_tmp2_);
}

static void
__code_terminal___lambda127__gtk_widget_destroy (GtkWidget* _sender,
                                                 gpointer self)
{
	_code_terminal___lambda127_ (self);
}

static GObject *
code_terminal_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CodeTerminal * self;
	Block40Data* _data40_;
	VteTerminal* _tmp0_ = NULL;
	VteTerminal* _tmp1_;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSettingsSchema* terminal_schema = NULL;
	GSettingsSchemaSource* _tmp4_;
	GSettingsSchema* _tmp5_;
	GSettingsSchema* _tmp6_;
	VteTerminal* _tmp10_;
	GtkMenuItem* copy = NULL;
	GtkMenuItem* _tmp11_;
	GtkMenuItem* _tmp12_;
	GtkMenuItem* paste = NULL;
	GtkMenuItem* _tmp13_;
	GtkMenuItem* _tmp14_;
	GtkMenu* _tmp15_;
	GtkMenu* _tmp16_;
	GtkMenuItem* _tmp17_;
	GtkMenu* _tmp18_;
	GtkMenuItem* _tmp19_;
	GtkMenu* _tmp20_;
	VteTerminal* _tmp21_;
	GSettings* _tmp22_;
	GSettings* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GtkScrolledWindow* scrolled_window = NULL;
	VteTerminal* _tmp26_;
	GtkAdjustment* _tmp27_;
	GtkScrolledWindow* _tmp28_;
	GtkScrolledWindow* _tmp29_;
	VteTerminal* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	parent_class = G_OBJECT_CLASS (code_terminal_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_TERMINAL, CodeTerminal);
	_data40_ = g_slice_new0 (Block40Data);
	_data40_->_ref_count_ = 1;
	_data40_->self = g_object_ref (self);
	_tmp0_ = (VteTerminal*) vte_terminal_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp0_, TRUE);
	vte_terminal_set_scrollback_lines (_tmp0_, (guint) -1);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	code_terminal_set_terminal (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	schema_source = _tmp3_;
	_tmp4_ = schema_source;
	_tmp5_ = g_settings_schema_source_lookup (_tmp4_, CODE_TERMINAL_SETTINGS_SCHEMA, TRUE);
	terminal_schema = _tmp5_;
	_tmp6_ = terminal_schema;
	if (_tmp6_ != NULL) {
		code_terminal_update_terminal_settings (self, CODE_TERMINAL_SETTINGS_SCHEMA);
	} else {
		GSettingsSchema* legacy_terminal_schema = NULL;
		GSettingsSchemaSource* _tmp7_;
		GSettingsSchema* _tmp8_;
		GSettingsSchema* _tmp9_;
		_tmp7_ = schema_source;
		_tmp8_ = g_settings_schema_source_lookup (_tmp7_, CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA, TRUE);
		legacy_terminal_schema = _tmp8_;
		_tmp9_ = legacy_terminal_schema;
		if (_tmp9_ != NULL) {
			code_terminal_update_terminal_settings (self, CODE_TERMINAL_LEGACY_SETTINGS_SCHEMA);
		}
		_g_settings_schema_unref0 (legacy_terminal_schema);
	}
	_tmp10_ = self->priv->_terminal;
	g_signal_connect_object (_tmp10_, "child-exited", (GCallback) __code_terminal___lambda123__vte_terminal_child_exited, self, 0);
	_tmp11_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Copy"));
	g_object_ref_sink (_tmp11_);
	copy = _tmp11_;
	_tmp12_ = copy;
	g_signal_connect_object (_tmp12_, "activate", (GCallback) __code_terminal___lambda124__gtk_menu_item_activate, self, 0);
	_tmp13_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Paste"));
	g_object_ref_sink (_tmp13_);
	paste = _tmp13_;
	_tmp14_ = paste;
	g_signal_connect_object (_tmp14_, "activate", (GCallback) __code_terminal___lambda125__gtk_menu_item_activate, self, 0);
	_tmp15_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp15_);
	_data40_->menu = _tmp15_;
	_tmp16_ = _data40_->menu;
	_tmp17_ = copy;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp16_, _tmp17_);
	_tmp18_ = _data40_->menu;
	_tmp19_ = paste;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp18_, _tmp19_);
	_tmp20_ = _data40_->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp20_);
	_tmp21_ = self->priv->_terminal;
	g_signal_connect_data ((GtkWidget*) _tmp21_, "button-press-event", (GCallback) __code_terminal___lambda126__gtk_widget_button_press_event, block40_data_ref (_data40_), (GClosureNotify) block40_data_unref, 0);
	_tmp22_ = g_settings_new (CONSTANTS_PROJECT_NAME ".saved-state");
	_data40_->settings = _tmp22_;
	_tmp23_ = _data40_->settings;
	_tmp24_ = g_settings_get_string (_tmp23_, "last-opened-path");
	_tmp25_ = _tmp24_;
	code_terminal_spawn_shell (self, _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->priv->_terminal;
	_tmp27_ = gtk_scrollable_get_vadjustment ((GtkScrollable*) _tmp26_);
	_tmp28_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, _tmp27_);
	g_object_ref_sink (_tmp28_);
	scrolled_window = _tmp28_;
	_tmp29_ = scrolled_window;
	_tmp30_ = self->priv->_terminal;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp31_);
	g_signal_connect_data ((GtkWidget*) self, "destroy", (GCallback) __code_terminal___lambda127__gtk_widget_destroy, block40_data_ref (_data40_), (GClosureNotify) block40_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (paste);
	_g_object_unref0 (copy);
	_g_settings_schema_unref0 (terminal_schema);
	_g_settings_schema_source_unref0 (schema_source);
	block40_data_unref (_data40_);
	_data40_ = NULL;
	return obj;
}

static void
code_terminal_class_init (CodeTerminalClass * klass,
                          gpointer klass_data)
{
	code_terminal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodeTerminal_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_code_terminal_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_terminal_set_property;
	G_OBJECT_CLASS (klass)->constructor = code_terminal_constructor;
	G_OBJECT_CLASS (klass)->finalize = code_terminal_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_TERMINAL_TERMINAL_PROPERTY, code_terminal_properties[CODE_TERMINAL_TERMINAL_PROPERTY] = g_param_spec_object ("terminal", "terminal", "terminal", vte_terminal_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
code_terminal_instance_init (CodeTerminal * self,
                             gpointer klass)
{
	self->priv = code_terminal_get_instance_private (self);
}

static void
code_terminal_finalize (GObject * obj)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_TYPE_TERMINAL, CodeTerminal);
	_g_object_unref0 (self->priv->_terminal);
	G_OBJECT_CLASS (code_terminal_parent_class)->finalize (obj);
}

static GType
code_terminal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodeTerminalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_terminal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodeTerminal), 0, (GInstanceInitFunc) code_terminal_instance_init, NULL };
	GType code_terminal_type_id;
	code_terminal_type_id = g_type_register_static (gtk_box_get_type (), "CodeTerminal", &g_define_type_info, 0);
	CodeTerminal_private_offset = g_type_add_instance_private (code_terminal_type_id, sizeof (CodeTerminalPrivate));
	return code_terminal_type_id;
}

GType
code_terminal_get_type (void)
{
	static volatile gsize code_terminal_type_id__once = 0;
	if (g_once_init_enter (&code_terminal_type_id__once)) {
		GType code_terminal_type_id;
		code_terminal_type_id = code_terminal_get_type_once ();
		g_once_init_leave (&code_terminal_type_id__once, code_terminal_type_id);
	}
	return code_terminal_type_id__once;
}

static void
_vala_code_terminal_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_TERMINAL, CodeTerminal);
	switch (property_id) {
		case CODE_TERMINAL_TERMINAL_PROPERTY:
		g_value_set_object (value, code_terminal_get_terminal (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_terminal_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	CodeTerminal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_TYPE_TERMINAL, CodeTerminal);
	switch (property_id) {
		case CODE_TERMINAL_TERMINAL_PROPERTY:
		code_terminal_set_terminal (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

