/* GitManager.c generated by valac 0.56.14, the Vala compiler
 * generated from GitManager.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2020 elementary LLC. (https://elementary.io),
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jeremy Wootten <jeremy@elementaryos.org>
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <granite.h>
#include <libgit2-glib/ggit.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SCRATCH_SERVICES_TYPE_GIT_MANAGER (scratch_services_git_manager_get_type ())
#define SCRATCH_SERVICES_GIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager))
#define SCRATCH_SERVICES_GIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManagerClass))
#define SCRATCH_SERVICES_IS_GIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_GIT_MANAGER))
#define SCRATCH_SERVICES_IS_GIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_GIT_MANAGER))
#define SCRATCH_SERVICES_GIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManagerClass))

typedef struct _ScratchServicesGitManager ScratchServicesGitManager;
typedef struct _ScratchServicesGitManagerClass ScratchServicesGitManagerClass;
typedef struct _ScratchServicesGitManagerPrivate ScratchServicesGitManagerPrivate;
enum  {
	SCRATCH_SERVICES_GIT_MANAGER_0_PROPERTY,
	SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY,
	SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY,
	SCRATCH_SERVICES_GIT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY (scratch_services_monitored_repository_get_type ())
#define SCRATCH_SERVICES_MONITORED_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepository))
#define SCRATCH_SERVICES_MONITORED_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepositoryClass))
#define SCRATCH_SERVICES_IS_MONITORED_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY))
#define SCRATCH_SERVICES_IS_MONITORED_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY))
#define SCRATCH_SERVICES_MONITORED_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, ScratchServicesMonitoredRepositoryClass))

typedef struct _ScratchServicesMonitoredRepository ScratchServicesMonitoredRepository;
typedef struct _ScratchServicesMonitoredRepositoryClass ScratchServicesMonitoredRepositoryClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_ITEM (scratch_folder_manager_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem))
#define SCRATCH_FOLDER_MANAGER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_ITEM))
#define SCRATCH_FOLDER_MANAGER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItemClass))

typedef struct _ScratchFolderManagerItem ScratchFolderManagerItem;
typedef struct _ScratchFolderManagerItemClass ScratchFolderManagerItemClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM (scratch_folder_manager_folder_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem))
#define SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItemClass))

typedef struct _ScratchFolderManagerFolderItem ScratchFolderManagerFolderItem;
typedef struct _ScratchFolderManagerFolderItemClass ScratchFolderManagerFolderItemClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM (scratch_folder_manager_project_folder_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItemClass))

typedef struct _ScratchFolderManagerProjectFolderItem ScratchFolderManagerProjectFolderItem;
typedef struct _ScratchFolderManagerProjectFolderItemClass ScratchFolderManagerProjectFolderItemClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_FILE (scratch_folder_manager_file_get_type ())
#define SCRATCH_FOLDER_MANAGER_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFile))
#define SCRATCH_FOLDER_MANAGER_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFileClass))
#define SCRATCH_FOLDER_MANAGER_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE))
#define SCRATCH_FOLDER_MANAGER_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE))
#define SCRATCH_FOLDER_MANAGER_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFileClass))

typedef struct _ScratchFolderManagerFile ScratchFolderManagerFile;
typedef struct _ScratchFolderManagerFileClass ScratchFolderManagerFileClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ScratchServicesGitManager {
	GObject parent_instance;
	ScratchServicesGitManagerPrivate * priv;
};

struct _ScratchServicesGitManagerClass {
	GObjectClass parent_class;
};

struct _ScratchServicesGitManagerPrivate {
	GListStore* _project_liststore;
	gchar* _active_project_path;
};

static gint ScratchServicesGitManager_private_offset;
static gpointer scratch_services_git_manager_parent_class = NULL;
static GeeHashMap* scratch_services_git_manager_project_gitrepo_map;
static GeeHashMap* scratch_services_git_manager_project_gitrepo_map = NULL;
static ScratchServicesGitManager* scratch_services_git_manager_instance;
static ScratchServicesGitManager* scratch_services_git_manager_instance = NULL;

VALA_EXTERN GType scratch_services_git_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesGitManager, g_object_unref)
VALA_EXTERN GType scratch_services_monitored_repository_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesMonitoredRepository, g_object_unref)
VALA_EXTERN ScratchServicesMonitoredRepository* scratch_services_git_manager_get_monitored_repository (const gchar* root_path);
VALA_EXTERN ScratchServicesGitManager* scratch_services_git_manager_get_instance (void);
static ScratchServicesGitManager* scratch_services_git_manager_new (void);
static ScratchServicesGitManager* scratch_services_git_manager_construct (GType object_type);
VALA_EXTERN GType scratch_folder_manager_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerItem, g_object_unref)
VALA_EXTERN GType scratch_folder_manager_folder_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerFolderItem, g_object_unref)
VALA_EXTERN GType scratch_folder_manager_project_folder_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerProjectFolderItem, g_object_unref)
static void scratch_services_git_manager_set_project_liststore (ScratchServicesGitManager* self,
                                                         GListStore* value);
VALA_EXTERN ScratchServicesMonitoredRepository* scratch_services_git_manager_add_project (ScratchServicesGitManager* self,
                                                                              ScratchFolderManagerProjectFolderItem* root_folder);
VALA_EXTERN GType scratch_folder_manager_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerFile, g_object_unref)
VALA_EXTERN ScratchFolderManagerFile* scratch_folder_manager_item_get_file (ScratchFolderManagerItem* self);
VALA_EXTERN GFile* scratch_folder_manager_file_get_file (ScratchFolderManagerFile* self);
VALA_EXTERN ScratchServicesMonitoredRepository* scratch_services_monitored_repository_new (GgitRepository* _git_repo);
VALA_EXTERN ScratchServicesMonitoredRepository* scratch_services_monitored_repository_construct (GType object_type,
                                                                                     GgitRepository* _git_repo);
VALA_EXTERN GListStore* scratch_services_git_manager_get_project_liststore (ScratchServicesGitManager* self);
static gint scratch_services_git_manager_project_sort_func (ScratchFolderManagerProjectFolderItem* a,
                                                     ScratchFolderManagerProjectFolderItem* b,
                                                     ScratchServicesGitManager* self);
VALA_EXTERN void scratch_services_git_manager_set_active_project_path (ScratchServicesGitManager* self,
                                                           const gchar* value);
VALA_EXTERN void scratch_services_git_manager_remove_project (ScratchServicesGitManager* self,
                                                  ScratchFolderManagerProjectFolderItem* root_folder);
VALA_EXTERN const gchar* scratch_services_git_manager_get_active_project_path (ScratchServicesGitManager* self);
static void scratch_services_git_manager_finalize (GObject * obj);
static GType scratch_services_git_manager_get_type_once (void);
static void _vala_scratch_services_git_manager_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_scratch_services_git_manager_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
scratch_services_git_manager_get_instance_private (ScratchServicesGitManager* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchServicesGitManager_private_offset);
}

ScratchServicesMonitoredRepository*
scratch_services_git_manager_get_monitored_repository (const gchar* root_path)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	ScratchServicesMonitoredRepository* result;
	g_return_val_if_fail (root_path != NULL, NULL);
	_tmp0_ = scratch_services_git_manager_project_gitrepo_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, root_path);
	result = (ScratchServicesMonitoredRepository*) _tmp1_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ScratchServicesGitManager*
scratch_services_git_manager_get_instance (void)
{
	ScratchServicesGitManager* _tmp0_;
	ScratchServicesGitManager* _tmp2_;
	ScratchServicesGitManager* _tmp3_;
	ScratchServicesGitManager* result;
	_tmp0_ = scratch_services_git_manager_instance;
	if (_tmp0_ == NULL) {
		ScratchServicesGitManager* _tmp1_;
		_tmp1_ = scratch_services_git_manager_new ();
		_g_object_unref0 (scratch_services_git_manager_instance);
		scratch_services_git_manager_instance = _tmp1_;
	}
	_tmp2_ = scratch_services_git_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static ScratchServicesGitManager*
scratch_services_git_manager_construct (GType object_type)
{
	ScratchServicesGitManager * self = NULL;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	self = (ScratchServicesGitManager*) g_object_new (object_type, NULL);
	_tmp0_ = g_list_store_new (SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM);
	_tmp1_ = _tmp0_;
	scratch_services_git_manager_set_project_liststore (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

static ScratchServicesGitManager*
scratch_services_git_manager_new (void)
{
	return scratch_services_git_manager_construct (SCRATCH_SERVICES_TYPE_GIT_MANAGER);
}

ScratchServicesMonitoredRepository*
scratch_services_git_manager_add_project (ScratchServicesGitManager* self,
                                          ScratchFolderManagerProjectFolderItem* root_folder)
{
	gchar* root_path = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	ScratchServicesMonitoredRepository* monitored_repo = NULL;
	const gchar* _tmp25_;
	GeeHashMap* _tmp26_;
	const gchar* _tmp27_;
	gpointer _tmp28_;
	GError* _inner_error0_ = NULL;
	ScratchServicesMonitoredRepository* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (root_folder != NULL, NULL);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) root_folder);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	root_path = _tmp4_;
	monitored_repo = NULL;
	{
		GgitRepository* git_repo = NULL;
		ScratchFolderManagerFile* _tmp5_;
		ScratchFolderManagerFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		GgitRepository* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		_tmp5_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) root_folder);
		_tmp6_ = _tmp5_;
		_tmp7_ = scratch_folder_manager_file_get_file (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ggit_repository_open (_tmp8_, &_inner_error0_);
		git_repo = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = scratch_services_git_manager_project_gitrepo_map;
		_tmp11_ = root_path;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp11_)) {
			GgitRepository* _tmp12_;
			ScratchServicesMonitoredRepository* _tmp13_;
			GeeHashMap* _tmp14_;
			const gchar* _tmp15_;
			ScratchServicesMonitoredRepository* _tmp16_;
			GeeHashMap* _tmp17_;
			const gchar* _tmp18_;
			gpointer _tmp19_;
			_tmp12_ = git_repo;
			_tmp13_ = scratch_services_monitored_repository_new (_tmp12_);
			_g_object_unref0 (monitored_repo);
			monitored_repo = _tmp13_;
			_tmp14_ = scratch_services_git_manager_project_gitrepo_map;
			_tmp15_ = root_path;
			_tmp16_ = monitored_repo;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp15_, _tmp16_);
			_tmp17_ = scratch_services_git_manager_project_gitrepo_map;
			_tmp18_ = root_path;
			_tmp19_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp18_);
			result = (ScratchServicesMonitoredRepository*) _tmp19_;
			_g_object_unref0 (git_repo);
			{
				GError* _inner_error0_ = NULL;
				GListStore* _tmp20_;
				_tmp20_ = self->priv->_project_liststore;
				g_list_store_insert_sorted (_tmp20_, (GObject*) root_folder, (GCompareDataFunc) scratch_services_git_manager_project_sort_func, self);
			}
			_g_object_unref0 (monitored_repo);
			_g_free0 (root_path);
			return result;
		}
		_g_object_unref0 (git_repo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = root_path;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		g_debug ("GitManager.vala:63: Error opening git repo for %s, means this probably" \
" isn't one: %s", _tmp21_, _tmp23_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		GListStore* _tmp24_;
		_tmp24_ = self->priv->_project_liststore;
		g_list_store_insert_sorted (_tmp24_, (GObject*) root_folder, (GCompareDataFunc) scratch_services_git_manager_project_sort_func, self);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (monitored_repo);
		_g_free0 (root_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp25_ = root_path;
	scratch_services_git_manager_set_active_project_path (self, _tmp25_);
	_tmp26_ = scratch_services_git_manager_project_gitrepo_map;
	_tmp27_ = root_path;
	_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, _tmp27_);
	result = (ScratchServicesMonitoredRepository*) _tmp28_;
	_g_object_unref0 (monitored_repo);
	_g_free0 (root_path);
	return result;
}

static gint
scratch_services_git_manager_project_sort_func (ScratchFolderManagerProjectFolderItem* a,
                                                ScratchFolderManagerProjectFolderItem* b,
                                                ScratchServicesGitManager* self)
{
	GFile* file_a = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* file_b = NULL;
	ScratchFolderManagerFile* _tmp5_;
	ScratchFolderManagerFile* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) a);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	file_a = _tmp4_;
	_tmp5_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) b);
	_tmp6_ = _tmp5_;
	_tmp7_ = scratch_folder_manager_file_get_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	file_b = _tmp9_;
	_tmp10_ = g_file_get_path (file_a);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_path_get_basename (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_file_get_path (file_b);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_path_get_basename (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_utf8_collate (_tmp13_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = _tmp18_;
	_g_object_unref0 (file_b);
	_g_object_unref0 (file_a);
	return result;
}

void
scratch_services_git_manager_remove_project (ScratchServicesGitManager* self,
                                             ScratchFolderManagerProjectFolderItem* root_folder)
{
	gchar* root_path = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	guint position = 0U;
	GListStore* _tmp5_;
	guint _tmp6_ = 0U;
	gboolean _tmp7_;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_folder != NULL);
	_tmp0_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) root_folder);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_path (_tmp3_);
	root_path = _tmp4_;
	_tmp5_ = self->priv->_project_liststore;
	_tmp7_ = g_list_store_find (_tmp5_, (GObject*) root_folder, &_tmp6_);
	position = _tmp6_;
	if (_tmp7_) {
		GListStore* _tmp8_;
		_tmp8_ = self->priv->_project_liststore;
		g_list_store_remove (_tmp8_, position);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = root_path;
		g_critical ("GitManager.vala:94: Can't remove: %s", _tmp9_);
	}
	_tmp10_ = scratch_services_git_manager_project_gitrepo_map;
	_tmp11_ = root_path;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp10_, _tmp11_)) {
		GeeHashMap* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = scratch_services_git_manager_project_gitrepo_map;
		_tmp13_ = root_path;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, _tmp13_, NULL);
	}
	_g_free0 (root_path);
}

GListStore*
scratch_services_git_manager_get_project_liststore (ScratchServicesGitManager* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_liststore;
	result = _tmp0_;
	return result;
}

static void
scratch_services_git_manager_set_project_liststore (ScratchServicesGitManager* self,
                                                    GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_git_manager_get_project_liststore (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_project_liststore);
		self->priv->_project_liststore = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY]);
	}
}

const gchar*
scratch_services_git_manager_get_active_project_path (ScratchServicesGitManager* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_project_path;
	result = _tmp0_;
	return result;
}

void
scratch_services_git_manager_set_active_project_path (ScratchServicesGitManager* self,
                                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_services_git_manager_get_active_project_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_active_project_path);
		self->priv->_active_project_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY]);
	}
}

static void
scratch_services_git_manager_class_init (ScratchServicesGitManagerClass * klass,
                                         gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	scratch_services_git_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchServicesGitManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_services_git_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_services_git_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = scratch_services_git_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY] = g_param_spec_object ("project-liststore", "project-liststore", "project-liststore", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY, scratch_services_git_manager_properties[SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY] = g_param_spec_string ("active-project-path", "active-project-path", "active-project-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ggit_init ();
	_g_object_unref0 (scratch_services_git_manager_instance);
	scratch_services_git_manager_instance = NULL;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SCRATCH_SERVICES_TYPE_MONITORED_REPOSITORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (scratch_services_git_manager_project_gitrepo_map);
	scratch_services_git_manager_project_gitrepo_map = _tmp0_;
}

static void
scratch_services_git_manager_instance_init (ScratchServicesGitManager * self,
                                            gpointer klass)
{
	gchar* _tmp0_;
	self->priv = scratch_services_git_manager_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_active_project_path = _tmp0_;
}

static void
scratch_services_git_manager_finalize (GObject * obj)
{
	ScratchServicesGitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager);
	_g_object_unref0 (self->priv->_project_liststore);
	_g_free0 (self->priv->_active_project_path);
	G_OBJECT_CLASS (scratch_services_git_manager_parent_class)->finalize (obj);
}

static GType
scratch_services_git_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchServicesGitManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_services_git_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchServicesGitManager), 0, (GInstanceInitFunc) scratch_services_git_manager_instance_init, NULL };
	GType scratch_services_git_manager_type_id;
	scratch_services_git_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "ScratchServicesGitManager", &g_define_type_info, 0);
	ScratchServicesGitManager_private_offset = g_type_add_instance_private (scratch_services_git_manager_type_id, sizeof (ScratchServicesGitManagerPrivate));
	return scratch_services_git_manager_type_id;
}

GType
scratch_services_git_manager_get_type (void)
{
	static volatile gsize scratch_services_git_manager_type_id__once = 0;
	if (g_once_init_enter (&scratch_services_git_manager_type_id__once)) {
		GType scratch_services_git_manager_type_id;
		scratch_services_git_manager_type_id = scratch_services_git_manager_get_type_once ();
		g_once_init_leave (&scratch_services_git_manager_type_id__once, scratch_services_git_manager_type_id);
	}
	return scratch_services_git_manager_type_id__once;
}

static void
_vala_scratch_services_git_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchServicesGitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager);
	switch (property_id) {
		case SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY:
		g_value_set_object (value, scratch_services_git_manager_get_project_liststore (self));
		break;
		case SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY:
		g_value_set_string (value, scratch_services_git_manager_get_active_project_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_services_git_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchServicesGitManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager);
	switch (property_id) {
		case SCRATCH_SERVICES_GIT_MANAGER_PROJECT_LISTSTORE_PROPERTY:
		scratch_services_git_manager_set_project_liststore (self, g_value_get_object (value));
		break;
		case SCRATCH_SERVICES_GIT_MANAGER_ACTIVE_PROJECT_PATH_PROPERTY:
		scratch_services_git_manager_set_active_project_path (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

