/* FileView.c generated by valac 0.56.14, the Vala compiler
 * generated from FileView.vala, do not modify */

/*-
 * Copyright (c) 2017 - 2022 elementary LLC. (https://elementary.io),
 *               2013 Julien Spautz <spautz.julien@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * as published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Julien Spautz <spautz.julien@gmail.com>, Andrei-Costin Zisu <matzipan@gmail.com>
 */

#include <granite.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#define SCRATCH_MAIN_WINDOW_ACTION_HIDE_PROJECT_DOCS "action_hide_project_docs"
#define SCRATCH_MAIN_WINDOW_ACTION_RESTORE_PROJECT_DOCS "action_restore_project_docs"
#define SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS "action_close_project_docs"
#define SCRATCH_MAIN_WINDOW_ACTION_GROUP "win"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CODE_TYPE_PANE_SWITCHER (code_pane_switcher_get_type ())
#define CODE_PANE_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CODE_TYPE_PANE_SWITCHER, CodePaneSwitcher))
#define CODE_IS_PANE_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CODE_TYPE_PANE_SWITCHER))
#define CODE_PANE_SWITCHER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CODE_TYPE_PANE_SWITCHER, CodePaneSwitcherIface))

typedef struct _CodePaneSwitcher CodePaneSwitcher;
typedef struct _CodePaneSwitcherIface CodePaneSwitcherIface;

#define SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW (scratch_folder_manager_file_view_get_type ())
#define SCRATCH_FOLDER_MANAGER_FILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView))
#define SCRATCH_FOLDER_MANAGER_FILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileViewClass))
#define SCRATCH_FOLDER_MANAGER_IS_FILE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW))
#define SCRATCH_FOLDER_MANAGER_IS_FILE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW))
#define SCRATCH_FOLDER_MANAGER_FILE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileViewClass))

typedef struct _ScratchFolderManagerFileView ScratchFolderManagerFileView;
typedef struct _ScratchFolderManagerFileViewClass ScratchFolderManagerFileViewClass;
typedef struct _ScratchFolderManagerFileViewPrivate ScratchFolderManagerFileViewPrivate;

#define SCRATCH_SERVICES_TYPE_GIT_MANAGER (scratch_services_git_manager_get_type ())
#define SCRATCH_SERVICES_GIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManager))
#define SCRATCH_SERVICES_GIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManagerClass))
#define SCRATCH_SERVICES_IS_GIT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_GIT_MANAGER))
#define SCRATCH_SERVICES_IS_GIT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_GIT_MANAGER))
#define SCRATCH_SERVICES_GIT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_GIT_MANAGER, ScratchServicesGitManagerClass))

typedef struct _ScratchServicesGitManager ScratchServicesGitManager;
typedef struct _ScratchServicesGitManagerClass ScratchServicesGitManagerClass;

#define SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER (scratch_services_plugins_manager_get_type ())
#define SCRATCH_SERVICES_PLUGINS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManager))
#define SCRATCH_SERVICES_PLUGINS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManagerClass))
#define SCRATCH_SERVICES_IS_PLUGINS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER))
#define SCRATCH_SERVICES_IS_PLUGINS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER))
#define SCRATCH_SERVICES_PLUGINS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_SERVICES_TYPE_PLUGINS_MANAGER, ScratchServicesPluginsManagerClass))

typedef struct _ScratchServicesPluginsManager ScratchServicesPluginsManager;
typedef struct _ScratchServicesPluginsManagerClass ScratchServicesPluginsManagerClass;
enum  {
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_0_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_IGNORE_NEXT_SELECT_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIVE_PROJECT_PATH_PROPERTY,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_PROPERTIES
};
static GParamSpec* scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define SCRATCH_FOLDER_MANAGER_TYPE_ITEM (scratch_folder_manager_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem))
#define SCRATCH_FOLDER_MANAGER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_ITEM))
#define SCRATCH_FOLDER_MANAGER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItemClass))

typedef struct _ScratchFolderManagerItem ScratchFolderManagerItem;
typedef struct _ScratchFolderManagerItemClass ScratchFolderManagerItemClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_FILE_ITEM (scratch_folder_manager_file_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE_ITEM, ScratchFolderManagerFileItem))
#define SCRATCH_FOLDER_MANAGER_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE_ITEM, ScratchFolderManagerFileItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE_ITEM))
#define SCRATCH_FOLDER_MANAGER_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE_ITEM, ScratchFolderManagerFileItemClass))

typedef struct _ScratchFolderManagerFileItem ScratchFolderManagerFileItem;
typedef struct _ScratchFolderManagerFileItemClass ScratchFolderManagerFileItemClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_FILE (scratch_folder_manager_file_get_type ())
#define SCRATCH_FOLDER_MANAGER_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFile))
#define SCRATCH_FOLDER_MANAGER_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFileClass))
#define SCRATCH_FOLDER_MANAGER_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE))
#define SCRATCH_FOLDER_MANAGER_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FILE))
#define SCRATCH_FOLDER_MANAGER_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FILE, ScratchFolderManagerFileClass))

typedef struct _ScratchFolderManagerFile ScratchFolderManagerFile;
typedef struct _ScratchFolderManagerFileClass ScratchFolderManagerFileClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM (scratch_folder_manager_folder_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem))
#define SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_FOLDER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItemClass))

typedef struct _ScratchFolderManagerFolderItem ScratchFolderManagerFolderItem;
typedef struct _ScratchFolderManagerFolderItemClass ScratchFolderManagerFolderItemClass;

#define SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM (scratch_folder_manager_project_folder_item_get_type ())
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItemClass))
#define SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM))
#define SCRATCH_FOLDER_MANAGER_PROJECT_FOLDER_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItemClass))

typedef struct _ScratchFolderManagerProjectFolderItem ScratchFolderManagerProjectFolderItem;
typedef struct _ScratchFolderManagerProjectFolderItemClass ScratchFolderManagerProjectFolderItemClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define SCRATCH_DIALOGS_TYPE_NEW_BRANCH_DIALOG (scratch_dialogs_new_branch_dialog_get_type ())
#define SCRATCH_DIALOGS_NEW_BRANCH_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCRATCH_DIALOGS_TYPE_NEW_BRANCH_DIALOG, ScratchDialogsNewBranchDialog))
#define SCRATCH_DIALOGS_NEW_BRANCH_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCRATCH_DIALOGS_TYPE_NEW_BRANCH_DIALOG, ScratchDialogsNewBranchDialogClass))
#define SCRATCH_DIALOGS_IS_NEW_BRANCH_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCRATCH_DIALOGS_TYPE_NEW_BRANCH_DIALOG))
#define SCRATCH_DIALOGS_IS_NEW_BRANCH_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SCRATCH_DIALOGS_TYPE_NEW_BRANCH_DIALOG))
#define SCRATCH_DIALOGS_NEW_BRANCH_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCRATCH_DIALOGS_TYPE_NEW_BRANCH_DIALOG, ScratchDialogsNewBranchDialogClass))

typedef struct _ScratchDialogsNewBranchDialog ScratchDialogsNewBranchDialog;
typedef struct _ScratchDialogsNewBranchDialogClass ScratchDialogsNewBranchDialogClass;
typedef struct _Block9Data Block9Data;
enum  {
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_SELECT_SIGNAL,
	SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_SIGNALS
};
static guint scratch_folder_manager_file_view_signals[SCRATCH_FOLDER_MANAGER_FILE_VIEW_NUM_SIGNALS] = {0};

struct _CodePaneSwitcherIface {
	GTypeInterface parent_iface;
	const gchar* (*get_icon_name) (CodePaneSwitcher* self);
	void (*set_icon_name) (CodePaneSwitcher* self, const gchar* value);
	const gchar* (*get_title) (CodePaneSwitcher* self);
	void (*set_title) (CodePaneSwitcher* self, const gchar* value);
};

struct _ScratchFolderManagerFileView {
	GraniteWidgetsSourceList parent_instance;
	ScratchFolderManagerFileViewPrivate * priv;
};

struct _ScratchFolderManagerFileViewClass {
	GraniteWidgetsSourceListClass parent_class;
};

struct _ScratchFolderManagerFileViewPrivate {
	GSettings* settings;
	ScratchServicesGitManager* git_manager;
	GActionGroup* toplevel_action_group;
	ScratchServicesPluginsManager* plugins;
	gboolean _ignore_next_select;
	gchar* _icon_name;
	gchar* _title;
};

struct _Block9Data {
	int _ref_count_;
	ScratchFolderManagerFileView* self;
	ScratchFolderManagerProjectFolderItem* folder_root;
};

static gint ScratchFolderManagerFileView_private_offset;
static gpointer scratch_folder_manager_file_view_parent_class = NULL;
static CodePaneSwitcherIface * scratch_folder_manager_file_view_code_pane_switcher_parent_iface = NULL;

VALA_EXTERN GType code_pane_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CodePaneSwitcher, g_object_unref)
VALA_EXTERN GType scratch_folder_manager_file_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerFileView, g_object_unref)
VALA_EXTERN GType scratch_services_git_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesGitManager, g_object_unref)
VALA_EXTERN GType scratch_services_plugins_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchServicesPluginsManager, g_object_unref)
VALA_EXTERN ScratchFolderManagerFileView* scratch_folder_manager_file_view_new (ScratchServicesPluginsManager* plugins_manager);
VALA_EXTERN ScratchFolderManagerFileView* scratch_folder_manager_file_view_construct (GType object_type,
                                                                          ScratchServicesPluginsManager* plugins_manager);
static void scratch_folder_manager_file_view_on_item_selected (ScratchFolderManagerFileView* self,
                                                        GraniteWidgetsSourceListItem* item);
VALA_EXTERN gboolean scratch_folder_manager_file_view_get_ignore_next_select (ScratchFolderManagerFileView* self);
VALA_EXTERN void scratch_folder_manager_file_view_set_ignore_next_select (ScratchFolderManagerFileView* self,
                                                              gboolean value);
VALA_EXTERN GType scratch_folder_manager_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerItem, g_object_unref)
VALA_EXTERN GType scratch_folder_manager_file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerFileItem, g_object_unref)
VALA_EXTERN GType scratch_folder_manager_file_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerFile, g_object_unref)
VALA_EXTERN ScratchFolderManagerFile* scratch_folder_manager_item_get_file (ScratchFolderManagerItem* self);
VALA_EXTERN gchar* scratch_folder_manager_file_get_path (ScratchFolderManagerFile* self);
VALA_EXTERN void scratch_folder_manager_file_view_restore_saved_state (ScratchFolderManagerFileView* self);
static void scratch_folder_manager_file_view_add_folder (ScratchFolderManagerFileView* self,
                                                  ScratchFolderManagerFile* folder,
                                                  gboolean expand);
VALA_EXTERN ScratchFolderManagerFile* scratch_folder_manager_file_new (const gchar* path);
VALA_EXTERN ScratchFolderManagerFile* scratch_folder_manager_file_construct (GType object_type,
                                                                 const gchar* path);
VALA_EXTERN void scratch_folder_manager_file_view_open_folder (ScratchFolderManagerFileView* self,
                                                   ScratchFolderManagerFile* folder);
static gboolean scratch_folder_manager_file_view_is_open (ScratchFolderManagerFileView* self,
                                                   ScratchFolderManagerFile* folder);
static GraniteWidgetsSourceListItem* scratch_folder_manager_file_view_find_path (ScratchFolderManagerFileView* self,
                                                                          GraniteWidgetsSourceListExpandableItem* list,
                                                                          const gchar* path,
                                                                          gboolean expand);
VALA_EXTERN void scratch_folder_manager_file_view_collapse_all (ScratchFolderManagerFileView* self);
VALA_EXTERN GType scratch_folder_manager_folder_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerFolderItem, g_object_unref)
VALA_EXTERN GType scratch_folder_manager_project_folder_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchFolderManagerProjectFolderItem, g_object_unref)
VALA_EXTERN void scratch_folder_manager_file_view_order_folders (ScratchFolderManagerFileView* self);
static gint __lambda73_ (ScratchFolderManagerFileView* self,
                  ScratchFolderManagerProjectFolderItem* a,
                  ScratchFolderManagerProjectFolderItem* b);
static gint ___lambda73__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN void scratch_folder_manager_file_view_select_path (ScratchFolderManagerFileView* self,
                                                   const gchar* path);
static void _scratch_folder_manager_file_view_on_item_selected_granite_widgets_source_list_item_selected (GraniteWidgetsSourceList* _sender,
                                                                                                   GraniteWidgetsSourceListItem* item,
                                                                                                   gpointer self);
VALA_EXTERN void scratch_folder_manager_file_view_collapse_other_projects (ScratchFolderManagerFileView* self,
                                                               const gchar* keep_open_path);
VALA_EXTERN const gchar* scratch_services_git_manager_get_active_project_path (ScratchServicesGitManager* self);
VALA_EXTERN void scratch_services_git_manager_set_active_project_path (ScratchServicesGitManager* self,
                                                           const gchar* value);
VALA_EXTERN gchar* scratch_folder_manager_item_get_path (ScratchFolderManagerItem* self);
VALA_EXTERN ScratchFolderManagerProjectFolderItem* scratch_folder_manager_file_view_get_project_for_file (ScratchFolderManagerFileView* self,
                                                                                              GFile* file);
VALA_EXTERN gboolean scratch_folder_manager_project_folder_item_contains_file (ScratchFolderManagerProjectFolderItem* self,
                                                                   GFile* descendant);
VALA_EXTERN GraniteWidgetsSourceListItem* scratch_folder_manager_file_view_expand_to_path (ScratchFolderManagerFileView* self,
                                                                               const gchar* path);
VALA_EXTERN void scratch_folder_manager_file_view_search_global (ScratchFolderManagerFileView* self,
                                                     const gchar* path,
                                                     const gchar* term);
VALA_EXTERN ScratchFolderManagerProjectFolderItem* scratch_folder_manager_item_get_root_folder (ScratchFolderManagerItem* self,
                                                                                    GraniteWidgetsSourceListExpandableItem* start);
VALA_EXTERN GFile* scratch_folder_manager_file_get_file (ScratchFolderManagerFile* self);
VALA_EXTERN void scratch_folder_manager_project_folder_item_global_search (ScratchFolderManagerProjectFolderItem* self,
                                                               GFile* start_folder,
                                                               const gchar* term,
                                                               gboolean is_explicit);
VALA_EXTERN void scratch_folder_manager_file_view_clear_badges (ScratchFolderManagerFileView* self);
VALA_EXTERN void scratch_folder_manager_folder_item_remove_all_badges (ScratchFolderManagerFolderItem* self);
VALA_EXTERN void scratch_folder_manager_file_view_new_branch (ScratchFolderManagerFileView* self,
                                                  const gchar* active_project_path);
VALA_EXTERN gboolean scratch_folder_manager_project_folder_item_get_is_git_repo (ScratchFolderManagerProjectFolderItem* self);
VALA_EXTERN GType scratch_dialogs_new_branch_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScratchDialogsNewBranchDialog, g_object_unref)
VALA_EXTERN ScratchDialogsNewBranchDialog* scratch_dialogs_new_branch_dialog_new (ScratchFolderManagerProjectFolderItem* project);
VALA_EXTERN ScratchDialogsNewBranchDialog* scratch_dialogs_new_branch_dialog_construct (GType object_type,
                                                                            ScratchFolderManagerProjectFolderItem* project);
VALA_EXTERN const gchar* scratch_dialogs_new_branch_dialog_get_new_branch_name (ScratchDialogsNewBranchDialog* self);
VALA_EXTERN void scratch_folder_manager_project_folder_item_new_branch (ScratchFolderManagerProjectFolderItem* self,
                                                            const gchar* branch_name);
VALA_EXTERN void scratch_folder_manager_file_view_folder_item_update_hook (ScratchFolderManagerFileView* self,
                                                               GFile* source,
                                                               GFile* dest,
                                                               GFileMonitorEvent event);
static void scratch_folder_manager_file_view_rename_items_with_same_name (ScratchFolderManagerFileView* self,
                                                                   ScratchFolderManagerItem* item);
VALA_EXTERN const gchar* scratch_folder_manager_file_get_name (ScratchFolderManagerFile* self);
VALA_EXTERN gboolean scratch_utils_find_unique_path (GFile* f1,
                                         GFile* f2,
                                         gchar** path1,
                                         gchar** path2);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
VALA_EXTERN gboolean scratch_folder_manager_file_is_valid_directory (ScratchFolderManagerFile* self,
                                                         gboolean allow_hidden);
VALA_EXTERN ScratchFolderManagerProjectFolderItem* scratch_folder_manager_project_folder_item_new (ScratchFolderManagerFile* file,
                                                                                       ScratchFolderManagerFileView* view);
VALA_EXTERN ScratchFolderManagerProjectFolderItem* scratch_folder_manager_project_folder_item_construct (GType object_type,
                                                                                             ScratchFolderManagerFile* file,
                                                                                             ScratchFolderManagerFileView* view);
static void __lambda71_ (Block9Data* _data9_);
VALA_EXTERN ScratchServicesGitManager* scratch_services_git_manager_get_instance (void);
VALA_EXTERN void scratch_services_git_manager_remove_project (ScratchServicesGitManager* self,
                                                  ScratchFolderManagerProjectFolderItem* root_folder);
static void scratch_folder_manager_file_view_write_settings (ScratchFolderManagerFileView* self);
static void ___lambda71__scratch_folder_manager_project_folder_item_closed (ScratchFolderManagerProjectFolderItem* _sender,
                                                                     gpointer self);
static void __lambda72_ (Block9Data* _data9_);
static void ___lambda72__scratch_folder_manager_project_folder_item_close_all_except (ScratchFolderManagerProjectFolderItem* _sender,
                                                                               gpointer self);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN const gchar* scratch_folder_manager_file_view_get_active_project_path (ScratchFolderManagerFileView* self);
static GObject * scratch_folder_manager_file_view_constructor (GType type,
                                                        guint n_construct_properties,
                                                        GObjectConstructParam * construct_properties);
VALA_EXTERN void code_pane_switcher_set_icon_name (CodePaneSwitcher* self,
                                       const gchar* value);
VALA_EXTERN void code_pane_switcher_set_title (CodePaneSwitcher* self,
                                   const gchar* value);
static void _scratch_folder_manager_file_view___lambda79_ (ScratchFolderManagerFileView* self);
static void __scratch_folder_manager_file_view___lambda79__gtk_widget_realize (GtkWidget* _sender,
                                                                        gpointer self);
VALA_EXTERN const gchar* code_pane_switcher_get_icon_name (CodePaneSwitcher* self);
VALA_EXTERN const gchar* code_pane_switcher_get_title (CodePaneSwitcher* self);
static void scratch_folder_manager_file_view_finalize (GObject * obj);
static GType scratch_folder_manager_file_view_get_type_once (void);
static void _vala_scratch_folder_manager_file_view_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_scratch_folder_manager_file_view_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
scratch_folder_manager_file_view_get_instance_private (ScratchFolderManagerFileView* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchFolderManagerFileView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ScratchFolderManagerFileView*
scratch_folder_manager_file_view_construct (GType object_type,
                                            ScratchServicesPluginsManager* plugins_manager)
{
	ScratchFolderManagerFileView * self = NULL;
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	ScratchServicesPluginsManager* _tmp2_;
	g_return_val_if_fail (plugins_manager != NULL, NULL);
	_tmp0_ = granite_widgets_source_list_expandable_item_new ("");
	_tmp1_ = _tmp0_;
	self = (ScratchFolderManagerFileView*) granite_widgets_source_list_construct (object_type, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = _g_object_ref0 (plugins_manager);
	_g_object_unref0 (self->priv->plugins);
	self->priv->plugins = _tmp2_;
	return self;
}

ScratchFolderManagerFileView*
scratch_folder_manager_file_view_new (ScratchServicesPluginsManager* plugins_manager)
{
	return scratch_folder_manager_file_view_construct (SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, plugins_manager);
}

static void
scratch_folder_manager_file_view_on_item_selected (ScratchFolderManagerFileView* self,
                                                   GraniteWidgetsSourceListItem* item)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_ignore_next_select;
	if (_tmp0_) {
		scratch_folder_manager_file_view_set_ignore_next_select (self, FALSE);
		return;
	}
	if (SCRATCH_FOLDER_MANAGER_IS_FILE_ITEM (item)) {
		ScratchFolderManagerFile* _tmp1_;
		ScratchFolderManagerFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) G_TYPE_CHECK_INSTANCE_CAST (item, SCRATCH_FOLDER_MANAGER_TYPE_FILE_ITEM, ScratchFolderManagerFileItem));
		_tmp2_ = _tmp1_;
		_tmp3_ = scratch_folder_manager_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		g_signal_emit (self, scratch_folder_manager_file_view_signals[SCRATCH_FOLDER_MANAGER_FILE_VIEW_SELECT_SIGNAL], 0, _tmp5_);
		_g_free0 (_tmp5_);
	}
}

void
scratch_folder_manager_file_view_restore_saved_state (ScratchFolderManagerFileView* self)
{
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "opened-folders");
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp2_;
		path_collection_length1 = _vala_array_length (_tmp1_);
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			const gchar* path = NULL;
			path = path_collection[path_it];
			{
				const gchar* _tmp3_;
				ScratchFolderManagerFile* _tmp4_;
				ScratchFolderManagerFile* _tmp5_;
				_tmp3_ = path;
				_tmp4_ = scratch_folder_manager_file_new (_tmp3_);
				_tmp5_ = _tmp4_;
				scratch_folder_manager_file_view_add_folder (self, _tmp5_, FALSE);
				_g_object_unref0 (_tmp5_);
			}
		}
		path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

void
scratch_folder_manager_file_view_open_folder (ScratchFolderManagerFileView* self,
                                              ScratchFolderManagerFile* folder)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	if (scratch_folder_manager_file_view_is_open (self, folder)) {
		GraniteWidgetsSourceListItem* existing = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp0_;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GraniteWidgetsSourceListItem* _tmp5_;
		GraniteWidgetsSourceListItem* _tmp6_;
		GraniteWidgetsSourceListItem* _tmp7_;
		GraniteWidgetsSourceListItem* _tmp8_;
		_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = scratch_folder_manager_file_get_path (folder);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, _tmp4_, FALSE);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp4_);
		existing = _tmp7_;
		_tmp8_ = existing;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM)) {
			GraniteWidgetsSourceListItem* _tmp9_;
			_tmp9_ = existing;
			granite_widgets_source_list_expandable_item_set_expanded (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM, GraniteWidgetsSourceListExpandableItem), TRUE);
		}
		_g_object_unref0 (existing);
		return;
	}
	scratch_folder_manager_file_view_add_folder (self, folder, TRUE);
}

void
scratch_folder_manager_file_view_collapse_all (ScratchFolderManagerFileView* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp0_;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = granite_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_child_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GraniteWidgetsSourceListItem* _tmp10_;
			_tmp7_ = _child_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _child_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			child = (GraniteWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = child;
			granite_widgets_source_list_expandable_item_collapse_all ((GraniteWidgetsSourceListExpandableItem*) G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem), TRUE, TRUE);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

static gint
__lambda73_ (ScratchFolderManagerFileView* self,
             ScratchFolderManagerProjectFolderItem* a,
             ScratchFolderManagerProjectFolderItem* b)
{
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp1_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) a);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_tmp5_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) b);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strcmp0 (_tmp4_, _tmp8_) > 0;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp4_);
	if (_tmp9_) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = -1;
	}
	result = _tmp0_;
	return result;
}

static gint
___lambda73__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda73_ ((ScratchFolderManagerFileView*) self, (ScratchFolderManagerProjectFolderItem*) a, (ScratchFolderManagerProjectFolderItem*) b);
	return result;
}

void
scratch_folder_manager_file_view_order_folders (ScratchFolderManagerFileView* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp1_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_widgets_source_list_expandable_item_get_children (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_child_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			GraniteWidgetsSourceListExpandableItem* _tmp11_;
			GraniteWidgetsSourceListExpandableItem* _tmp12_;
			GraniteWidgetsSourceListItem* _tmp13_;
			GeeArrayList* _tmp14_;
			GraniteWidgetsSourceListItem* _tmp15_;
			_tmp8_ = _child_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _child_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			child = (GraniteWidgetsSourceListItem*) _tmp10_;
			_tmp11_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
			_tmp12_ = _tmp11_;
			_tmp13_ = child;
			granite_widgets_source_list_expandable_item_remove (_tmp12_, (GraniteWidgetsSourceListItem*) (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp13_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp13_) : NULL));
			_tmp14_ = list;
			_tmp15_ = child;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp15_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp15_) : NULL);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp16_ = list;
	gee_list_sort ((GeeList*) _tmp16_, ___lambda73__gcompare_data_func, g_object_ref (self), g_object_unref);
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp17_;
		gint _item_size = 0;
		GeeArrayList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _item_index = 0;
		_tmp17_ = list;
		_item_list = _tmp17_;
		_tmp18_ = _item_list;
		_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_item_size = _tmp20_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ScratchFolderManagerProjectFolderItem* item = NULL;
			GeeArrayList* _tmp23_;
			gpointer _tmp24_;
			GraniteWidgetsSourceListExpandableItem* _tmp25_;
			GraniteWidgetsSourceListExpandableItem* _tmp26_;
			ScratchFolderManagerProjectFolderItem* _tmp27_;
			_item_index = _item_index + 1;
			_tmp21_ = _item_index;
			_tmp22_ = _item_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _item_list;
			_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _item_index);
			item = (ScratchFolderManagerProjectFolderItem*) _tmp24_;
			_tmp25_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
			_tmp26_ = _tmp25_;
			_tmp27_ = item;
			granite_widgets_source_list_expandable_item_add (_tmp26_, (GraniteWidgetsSourceListItem*) _tmp27_);
			_g_object_unref0 (item);
		}
	}
	_g_object_unref0 (list);
}

static void
_scratch_folder_manager_file_view_on_item_selected_granite_widgets_source_list_item_selected (GraniteWidgetsSourceList* _sender,
                                                                                              GraniteWidgetsSourceListItem* item,
                                                                                              gpointer self)
{
	scratch_folder_manager_file_view_on_item_selected ((ScratchFolderManagerFileView*) self, item);
}

void
scratch_folder_manager_file_view_select_path (ScratchFolderManagerFileView* self,
                                              const gchar* path)
{
	guint _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GraniteWidgetsSourceListExpandableItem* _tmp2_;
	GraniteWidgetsSourceListItem* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_signal_parse_name ("item-selected", GRANITE_WIDGETS_TYPE_SOURCE_LIST, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GraniteWidgetsSourceList*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _scratch_folder_manager_file_view_on_item_selected_granite_widgets_source_list_item_selected, self);
	_tmp1_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = scratch_folder_manager_file_view_find_path (self, _tmp2_, path, FALSE);
	granite_widgets_source_list_set_selected ((GraniteWidgetsSourceList*) self, _tmp3_);
	g_signal_connect_object ((GraniteWidgetsSourceList*) self, "item-selected", (GCallback) _scratch_folder_manager_file_view_on_item_selected_granite_widgets_source_list_item_selected, self, 0);
}

void
scratch_folder_manager_file_view_collapse_other_projects (ScratchFolderManagerFileView* self,
                                                          const gchar* keep_open_path)
{
	const gchar* path = NULL;
	g_return_if_fail (self != NULL);
	if (keep_open_path == NULL) {
		ScratchServicesGitManager* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = self->priv->git_manager;
		_tmp1_ = scratch_services_git_manager_get_active_project_path (_tmp0_);
		_tmp2_ = _tmp1_;
		path = _tmp2_;
	} else {
		ScratchServicesGitManager* _tmp3_;
		const gchar* _tmp4_;
		path = keep_open_path;
		_tmp3_ = self->priv->git_manager;
		_tmp4_ = path;
		scratch_services_git_manager_set_active_project_path (_tmp3_, _tmp4_);
	}
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp5_;
		GraniteWidgetsSourceListExpandableItem* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp5_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = granite_widgets_source_list_expandable_item_get_children (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_child_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			ScratchFolderManagerProjectFolderItem* project_folder = NULL;
			GraniteWidgetsSourceListItem* _tmp15_;
			ScratchFolderManagerProjectFolderItem* _tmp16_;
			ScratchFolderManagerProjectFolderItem* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			gboolean _tmp22_;
			_tmp12_ = _child_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _child_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			child = (GraniteWidgetsSourceListItem*) _tmp14_;
			_tmp15_ = child;
			_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
			project_folder = _tmp16_;
			_tmp17_ = project_folder;
			_tmp18_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_;
			_tmp21_ = path;
			_tmp22_ = g_strcmp0 (_tmp20_, _tmp21_) != 0;
			_g_free0 (_tmp20_);
			if (_tmp22_) {
				ScratchFolderManagerProjectFolderItem* _tmp23_;
				GActionGroup* _tmp24_;
				ScratchFolderManagerProjectFolderItem* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				GVariant* _tmp29_;
				GVariant* _tmp30_;
				_tmp23_ = project_folder;
				granite_widgets_source_list_expandable_item_set_expanded ((GraniteWidgetsSourceListExpandableItem*) _tmp23_, FALSE);
				_tmp24_ = self->priv->toplevel_action_group;
				_tmp25_ = project_folder;
				_tmp26_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp27_;
				_tmp29_ = g_variant_new_string (_tmp28_);
				g_variant_ref_sink (_tmp29_);
				_tmp30_ = _tmp29_;
				g_action_group_activate_action (_tmp24_, SCRATCH_MAIN_WINDOW_ACTION_HIDE_PROJECT_DOCS, _tmp30_);
				_g_variant_unref0 (_tmp30_);
				_g_free0 (_tmp28_);
			} else {
				ScratchFolderManagerProjectFolderItem* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				gboolean _tmp36_;
				_tmp31_ = project_folder;
				_tmp32_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = _tmp33_;
				_tmp35_ = path;
				_tmp36_ = g_strcmp0 (_tmp34_, _tmp35_) == 0;
				_g_free0 (_tmp34_);
				if (_tmp36_) {
					ScratchFolderManagerProjectFolderItem* _tmp37_;
					GActionGroup* _tmp38_;
					ScratchFolderManagerProjectFolderItem* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					GVariant* _tmp43_;
					GVariant* _tmp44_;
					_tmp37_ = project_folder;
					granite_widgets_source_list_expandable_item_set_expanded ((GraniteWidgetsSourceListExpandableItem*) _tmp37_, TRUE);
					_tmp38_ = self->priv->toplevel_action_group;
					_tmp39_ = project_folder;
					_tmp40_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = _tmp41_;
					_tmp43_ = g_variant_new_string (_tmp42_);
					g_variant_ref_sink (_tmp43_);
					_tmp44_ = _tmp43_;
					g_action_group_activate_action (_tmp38_, SCRATCH_MAIN_WINDOW_ACTION_RESTORE_PROJECT_DOCS, _tmp44_);
					_g_variant_unref0 (_tmp44_);
					_g_free0 (_tmp42_);
				}
			}
			_g_object_unref0 (project_folder);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

static GraniteWidgetsSourceListItem*
scratch_folder_manager_file_view_find_path (ScratchFolderManagerFileView* self,
                                            GraniteWidgetsSourceListExpandableItem* list,
                                            const gchar* path,
                                            gboolean expand)
{
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	{
		GeeIterator* _item_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = granite_widgets_source_list_expandable_item_get_children (list);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_item_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GraniteWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GraniteWidgetsSourceListItem* _tmp8_;
			_tmp5_ = _item_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _item_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			item = (GraniteWidgetsSourceListItem*) _tmp7_;
			_tmp8_ = item;
			if (SCRATCH_FOLDER_MANAGER_IS_ITEM (_tmp8_)) {
				ScratchFolderManagerItem* code_item = NULL;
				GraniteWidgetsSourceListItem* _tmp9_;
				ScratchFolderManagerItem* _tmp10_;
				ScratchFolderManagerItem* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gboolean _tmp15_;
				GraniteWidgetsSourceListItem* _tmp17_;
				_tmp9_ = item;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
				code_item = _tmp10_;
				_tmp11_ = code_item;
				_tmp12_ = scratch_folder_manager_item_get_path (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strcmp0 (_tmp14_, path) == 0;
				_g_free0 (_tmp14_);
				if (_tmp15_) {
					GraniteWidgetsSourceListItem* _tmp16_;
					_tmp16_ = item;
					result = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GRANITE_WIDGETS_SOURCE_LIST_TYPE_ITEM, GraniteWidgetsSourceListItem);
					_g_object_unref0 (code_item);
					_g_object_unref0 (item);
					_g_object_unref0 (_item_it);
					return result;
				}
				_tmp17_ = item;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM)) {
					GraniteWidgetsSourceListExpandableItem* expander = NULL;
					GraniteWidgetsSourceListItem* _tmp18_;
					GraniteWidgetsSourceListExpandableItem* _tmp19_;
					ScratchFolderManagerItem* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gboolean _tmp24_;
					GraniteWidgetsSourceListExpandableItem* _tmp25_;
					gboolean _tmp26_;
					gboolean _tmp27_;
					GraniteWidgetsSourceListItem* recurse_item = NULL;
					GraniteWidgetsSourceListExpandableItem* _tmp29_;
					GraniteWidgetsSourceListItem* _tmp30_;
					GraniteWidgetsSourceListItem* _tmp31_;
					_tmp18_ = item;
					_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, GRANITE_WIDGETS_SOURCE_LIST_TYPE_EXPANDABLE_ITEM) ? ((GraniteWidgetsSourceListExpandableItem*) _tmp18_) : NULL);
					expander = _tmp19_;
					_tmp20_ = code_item;
					_tmp21_ = scratch_folder_manager_item_get_path (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = _tmp22_;
					_tmp24_ = !g_str_has_prefix (path, _tmp23_);
					_g_free0 (_tmp23_);
					if (_tmp24_) {
						_g_object_unref0 (expander);
						_g_object_unref0 (code_item);
						_g_object_unref0 (item);
						continue;
					}
					_tmp25_ = expander;
					_tmp26_ = granite_widgets_source_list_expandable_item_get_expanded (_tmp25_);
					_tmp27_ = _tmp26_;
					if (!_tmp27_) {
						if (expand) {
							GraniteWidgetsSourceListExpandableItem* _tmp28_;
							_tmp28_ = expander;
							granite_widgets_source_list_expandable_item_set_expanded (_tmp28_, TRUE);
						} else {
							_g_object_unref0 (expander);
							_g_object_unref0 (code_item);
							_g_object_unref0 (item);
							continue;
						}
					}
					_tmp29_ = expander;
					_tmp30_ = scratch_folder_manager_file_view_find_path (self, _tmp29_, path, expand);
					recurse_item = _tmp30_;
					_tmp31_ = recurse_item;
					if (_tmp31_ != NULL) {
						GraniteWidgetsSourceListItem* _tmp32_;
						_tmp32_ = recurse_item;
						result = _tmp32_;
						_g_object_unref0 (expander);
						_g_object_unref0 (code_item);
						_g_object_unref0 (item);
						_g_object_unref0 (_item_it);
						return result;
					}
					_g_object_unref0 (expander);
				}
				_g_object_unref0 (code_item);
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	result = NULL;
	return result;
}

ScratchFolderManagerProjectFolderItem*
scratch_folder_manager_file_view_get_project_for_file (ScratchFolderManagerFileView* self,
                                                       GFile* file)
{
	ScratchFolderManagerProjectFolderItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	{
		GeeIterator* _item_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp0_;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = granite_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_item_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GraniteWidgetsSourceListItem* item = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GraniteWidgetsSourceListItem* _tmp10_;
			_tmp7_ = _item_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _item_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			item = (GraniteWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = item;
			if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp10_)) {
				ScratchFolderManagerProjectFolderItem* folder = NULL;
				GraniteWidgetsSourceListItem* _tmp11_;
				ScratchFolderManagerProjectFolderItem* _tmp12_;
				ScratchFolderManagerProjectFolderItem* _tmp13_;
				_tmp11_ = item;
				_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
				folder = _tmp12_;
				_tmp13_ = folder;
				if (scratch_folder_manager_project_folder_item_contains_file (_tmp13_, file)) {
					result = folder;
					_g_object_unref0 (item);
					_g_object_unref0 (_item_it);
					return result;
				}
				_g_object_unref0 (folder);
			}
			_g_object_unref0 (item);
		}
		_g_object_unref0 (_item_it);
	}
	result = NULL;
	return result;
}

GraniteWidgetsSourceListItem*
scratch_folder_manager_file_view_expand_to_path (ScratchFolderManagerFileView* self,
                                                 const gchar* path)
{
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	GraniteWidgetsSourceListItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, path, TRUE);
	result = _tmp2_;
	return result;
}

void
scratch_folder_manager_file_view_search_global (ScratchFolderManagerFileView* self,
                                                const gchar* path,
                                                const gchar* term)
{
	ScratchFolderManagerItem* item_for_path = NULL;
	GraniteWidgetsSourceListItem* _tmp0_;
	ScratchFolderManagerItem* _tmp1_;
	ScratchFolderManagerItem* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = scratch_folder_manager_file_view_expand_to_path (self, path);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
	item_for_path = _tmp1_;
	_tmp2_ = item_for_path;
	if (_tmp2_ != NULL) {
		ScratchFolderManagerProjectFolderItem* search_root = NULL;
		ScratchFolderManagerItem* _tmp3_;
		ScratchFolderManagerProjectFolderItem* _tmp4_;
		ScratchFolderManagerProjectFolderItem* _tmp5_;
		_tmp3_ = item_for_path;
		_tmp4_ = scratch_folder_manager_item_get_root_folder (_tmp3_, NULL);
		search_root = _tmp4_;
		_tmp5_ = search_root;
		if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp5_)) {
			GFile* _tmp6_ = NULL;
			ScratchFolderManagerItem* _tmp7_;
			GFile* start_folder = NULL;
			GFile* _tmp18_;
			gboolean is_explicit = FALSE;
			ScratchFolderManagerItem* _tmp19_;
			ScratchFolderManagerProjectFolderItem* _tmp20_;
			GFile* _tmp21_;
			_tmp7_ = item_for_path;
			if (SCRATCH_FOLDER_MANAGER_IS_FOLDER_ITEM (_tmp7_)) {
				ScratchFolderManagerItem* _tmp8_;
				ScratchFolderManagerFile* _tmp9_;
				ScratchFolderManagerFile* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				_tmp8_ = item_for_path;
				_tmp9_ = scratch_folder_manager_item_get_file (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = scratch_folder_manager_file_get_file (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp6_ = _tmp12_;
			} else {
				ScratchFolderManagerProjectFolderItem* _tmp13_;
				ScratchFolderManagerFile* _tmp14_;
				ScratchFolderManagerFile* _tmp15_;
				GFile* _tmp16_;
				GFile* _tmp17_;
				_tmp13_ = search_root;
				_tmp14_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = scratch_folder_manager_file_get_file (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp6_ = _tmp17_;
			}
			_tmp18_ = _g_object_ref0 (_tmp6_);
			start_folder = _tmp18_;
			_tmp19_ = item_for_path;
			is_explicit = !SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp19_);
			_tmp20_ = search_root;
			_tmp21_ = start_folder;
			scratch_folder_manager_project_folder_item_global_search (_tmp20_, _tmp21_, term, is_explicit);
			_g_object_unref0 (start_folder);
		}
		_g_object_unref0 (search_root);
	}
	_g_object_unref0 (item_for_path);
}

void
scratch_folder_manager_file_view_clear_badges (ScratchFolderManagerFileView* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp0_;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = granite_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_child_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			GraniteWidgetsSourceListItem* _tmp10_;
			_tmp7_ = _child_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _child_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			child = (GraniteWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = child;
			if (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp10_)) {
				GraniteWidgetsSourceListItem* _tmp11_;
				_tmp11_ = child;
				scratch_folder_manager_folder_item_remove_all_badges (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SCRATCH_FOLDER_MANAGER_TYPE_FOLDER_ITEM, ScratchFolderManagerFolderItem));
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}

void
scratch_folder_manager_file_view_new_branch (ScratchFolderManagerFileView* self,
                                             const gchar* active_project_path)
{
	ScratchFolderManagerProjectFolderItem* active_project = NULL;
	GraniteWidgetsSourceListExpandableItem* _tmp0_;
	GraniteWidgetsSourceListExpandableItem* _tmp1_;
	GraniteWidgetsSourceListItem* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ScratchFolderManagerProjectFolderItem* _tmp4_;
	gchar* branch_name = NULL;
	ScratchDialogsNewBranchDialog* dialog = NULL;
	ScratchFolderManagerProjectFolderItem* _tmp8_;
	ScratchDialogsNewBranchDialog* _tmp9_;
	ScratchDialogsNewBranchDialog* _tmp10_;
	ScratchDialogsNewBranchDialog* _tmp11_;
	ScratchDialogsNewBranchDialog* _tmp16_;
	const gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (active_project_path != NULL);
	_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_view_find_path (self, _tmp1_, active_project_path, FALSE);
	active_project = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem);
	_tmp4_ = active_project;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		ScratchFolderManagerProjectFolderItem* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = active_project;
		_tmp6_ = scratch_folder_manager_project_folder_item_get_is_git_repo (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = !_tmp7_;
	}
	if (_tmp3_) {
		gdk_beep ();
		return;
	}
	branch_name = NULL;
	_tmp8_ = active_project;
	_tmp9_ = scratch_dialogs_new_branch_dialog_new (_tmp8_);
	g_object_ref_sink (_tmp9_);
	dialog = _tmp9_;
	_tmp10_ = dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp10_);
	_tmp11_ = dialog;
	if (gtk_dialog_run ((GtkDialog*) _tmp11_) == ((gint) GTK_RESPONSE_APPLY)) {
		ScratchDialogsNewBranchDialog* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp12_ = dialog;
		_tmp13_ = scratch_dialogs_new_branch_dialog_get_new_branch_name (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (branch_name);
		branch_name = _tmp15_;
	}
	_tmp16_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp16_);
	_tmp17_ = branch_name;
	if (_tmp17_ != NULL) {
		ScratchFolderManagerProjectFolderItem* _tmp18_;
		const gchar* _tmp19_;
		_tmp18_ = active_project;
		_tmp19_ = branch_name;
		scratch_folder_manager_project_folder_item_new_branch (_tmp18_, _tmp19_);
	}
	_g_object_unref0 (dialog);
	_g_free0 (branch_name);
}

void
scratch_folder_manager_file_view_folder_item_update_hook (ScratchFolderManagerFileView* self,
                                                          GFile* source,
                                                          GFile* dest,
                                                          GFileMonitorEvent event)
{
	ScratchServicesPluginsManager* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->plugins;
	g_signal_emit_by_name (_tmp0_, "hook-folder-item-change", source, dest, event);
}

static void
scratch_folder_manager_file_view_rename_items_with_same_name (ScratchFolderManagerFileView* self,
                                                              ScratchFolderManagerItem* item)
{
	gchar* item_name = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchFolderManagerFile* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = scratch_folder_manager_item_get_file (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = scratch_folder_manager_file_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	item_name = _tmp4_;
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp5_;
		GraniteWidgetsSourceListExpandableItem* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeCollection* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
		_tmp5_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = granite_widgets_source_list_expandable_item_get_children (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp9_);
		_child_it = _tmp11_;
		while (TRUE) {
			GeeIterator* _tmp12_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			gchar* new_other_item_name = NULL;
			gchar* new_item_name = NULL;
			ScratchFolderManagerProjectFolderItem* other_item = NULL;
			GraniteWidgetsSourceListItem* _tmp15_;
			ScratchFolderManagerProjectFolderItem* _tmp16_;
			ScratchFolderManagerFile* _tmp17_;
			ScratchFolderManagerFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			ScratchFolderManagerProjectFolderItem* _tmp21_;
			ScratchFolderManagerFile* _tmp22_;
			ScratchFolderManagerFile* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gboolean _tmp28_;
			_tmp12_ = _child_it;
			if (!gee_iterator_next (_tmp12_)) {
				break;
			}
			_tmp13_ = _child_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			child = (GraniteWidgetsSourceListItem*) _tmp14_;
			_tmp15_ = child;
			_tmp16_ = _g_object_ref0 (SCRATCH_FOLDER_MANAGER_IS_PROJECT_FOLDER_ITEM (_tmp15_) ? ((ScratchFolderManagerProjectFolderItem*) _tmp15_) : NULL);
			other_item = _tmp16_;
			_tmp17_ = scratch_folder_manager_item_get_file (item);
			_tmp18_ = _tmp17_;
			_tmp19_ = scratch_folder_manager_file_get_file (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = other_item;
			_tmp22_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = scratch_folder_manager_file_get_file (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp28_ = scratch_utils_find_unique_path (_tmp20_, _tmp25_, &_tmp26_, &_tmp27_);
			_g_free0 (new_item_name);
			new_item_name = _tmp26_;
			_g_free0 (new_other_item_name);
			new_other_item_name = _tmp27_;
			if (_tmp28_) {
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				const gchar* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ScratchFolderManagerProjectFolderItem* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				const gchar* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				_tmp29_ = item_name;
				_tmp30_ = strlen (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = new_item_name;
				_tmp33_ = strlen (_tmp32_);
				_tmp34_ = _tmp33_;
				if (_tmp31_ < _tmp34_) {
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp35_ = new_item_name;
					_tmp36_ = g_strdup (_tmp35_);
					_g_free0 (item_name);
					item_name = _tmp36_;
				}
				_tmp37_ = other_item;
				_tmp38_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = strlen (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = new_other_item_name;
				_tmp43_ = strlen (_tmp42_);
				_tmp44_ = _tmp43_;
				if (_tmp41_ < _tmp44_) {
					ScratchFolderManagerProjectFolderItem* _tmp45_;
					const gchar* _tmp46_;
					_tmp45_ = other_item;
					_tmp46_ = new_other_item_name;
					granite_widgets_source_list_item_set_name ((GraniteWidgetsSourceListItem*) _tmp45_, _tmp46_);
				}
			}
			_g_object_unref0 (other_item);
			_g_free0 (new_item_name);
			_g_free0 (new_other_item_name);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp47_ = item_name;
	granite_widgets_source_list_item_set_name ((GraniteWidgetsSourceListItem*) item, _tmp47_);
	_g_free0 (item_name);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ScratchFolderManagerFileView* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->folder_root);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
__lambda71_ (Block9Data* _data9_)
{
	ScratchFolderManagerFileView* self;
	GActionGroup* _tmp0_;
	ScratchFolderManagerProjectFolderItem* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GraniteWidgetsSourceListExpandableItem* _tmp7_;
	GraniteWidgetsSourceListExpandableItem* _tmp8_;
	ScratchFolderManagerProjectFolderItem* _tmp9_;
	ScratchServicesGitManager* _tmp31_;
	ScratchServicesGitManager* _tmp32_;
	ScratchFolderManagerProjectFolderItem* _tmp33_;
	self = _data9_->self;
	_tmp0_ = self->priv->toplevel_action_group;
	_tmp1_ = _data9_->folder_root;
	_tmp2_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_new_string (_tmp4_);
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	g_action_group_activate_action (_tmp0_, SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS, _tmp6_);
	_g_variant_unref0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp7_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _data9_->folder_root;
	granite_widgets_source_list_expandable_item_remove (_tmp8_, (GraniteWidgetsSourceListItem*) _tmp9_);
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp10_;
		GraniteWidgetsSourceListExpandableItem* _tmp11_;
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeIterator* _tmp15_;
		GeeIterator* _tmp16_;
		_tmp10_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = granite_widgets_source_list_expandable_item_get_children (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_child_it = _tmp16_;
		while (TRUE) {
			GeeIterator* _tmp17_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp18_;
			gpointer _tmp19_;
			ScratchFolderManagerProjectFolderItem* child_folder = NULL;
			GraniteWidgetsSourceListItem* _tmp20_;
			ScratchFolderManagerProjectFolderItem* _tmp21_;
			ScratchFolderManagerProjectFolderItem* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			ScratchFolderManagerProjectFolderItem* _tmp25_;
			ScratchFolderManagerFile* _tmp26_;
			ScratchFolderManagerFile* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp17_ = _child_it;
			if (!gee_iterator_next (_tmp17_)) {
				break;
			}
			_tmp18_ = _child_it;
			_tmp19_ = gee_iterator_get (_tmp18_);
			child = (GraniteWidgetsSourceListItem*) _tmp19_;
			_tmp20_ = child;
			_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
			child_folder = _tmp21_;
			_tmp22_ = child_folder;
			_tmp23_ = granite_widgets_source_list_item_get_name ((GraniteWidgetsSourceListItem*) _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = child_folder;
			_tmp26_ = scratch_folder_manager_item_get_file ((ScratchFolderManagerItem*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = scratch_folder_manager_file_get_name (_tmp27_);
			_tmp29_ = _tmp28_;
			if (g_strcmp0 (_tmp24_, _tmp29_) != 0) {
				ScratchFolderManagerProjectFolderItem* _tmp30_;
				_tmp30_ = child_folder;
				scratch_folder_manager_file_view_rename_items_with_same_name (self, (ScratchFolderManagerItem*) _tmp30_);
			}
			_g_object_unref0 (child_folder);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	_tmp31_ = scratch_services_git_manager_get_instance ();
	_tmp32_ = _tmp31_;
	_tmp33_ = _data9_->folder_root;
	scratch_services_git_manager_remove_project (_tmp32_, _tmp33_);
	_g_object_unref0 (_tmp32_);
	scratch_folder_manager_file_view_write_settings (self);
}

static void
___lambda71__scratch_folder_manager_project_folder_item_closed (ScratchFolderManagerProjectFolderItem* _sender,
                                                                gpointer self)
{
	__lambda71_ (self);
}

static void
__lambda72_ (Block9Data* _data9_)
{
	ScratchFolderManagerFileView* self;
	self = _data9_->self;
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp0_;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = granite_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_child_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			ScratchFolderManagerProjectFolderItem* project_folder_item = NULL;
			GraniteWidgetsSourceListItem* _tmp10_;
			ScratchFolderManagerProjectFolderItem* _tmp11_;
			ScratchFolderManagerProjectFolderItem* _tmp12_;
			ScratchFolderManagerProjectFolderItem* _tmp13_;
			_tmp7_ = _child_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _child_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			child = (GraniteWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = child;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, SCRATCH_FOLDER_MANAGER_TYPE_PROJECT_FOLDER_ITEM, ScratchFolderManagerProjectFolderItem));
			project_folder_item = _tmp11_;
			_tmp12_ = project_folder_item;
			_tmp13_ = _data9_->folder_root;
			if (_tmp12_ != _tmp13_) {
				GActionGroup* _tmp14_;
				ScratchFolderManagerProjectFolderItem* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				GVariant* _tmp19_;
				GVariant* _tmp20_;
				GraniteWidgetsSourceListExpandableItem* _tmp21_;
				GraniteWidgetsSourceListExpandableItem* _tmp22_;
				ScratchFolderManagerProjectFolderItem* _tmp23_;
				ScratchServicesGitManager* _tmp24_;
				ScratchServicesGitManager* _tmp25_;
				ScratchFolderManagerProjectFolderItem* _tmp26_;
				_tmp14_ = self->priv->toplevel_action_group;
				_tmp15_ = project_folder_item;
				_tmp16_ = scratch_folder_manager_item_get_path ((ScratchFolderManagerItem*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_;
				_tmp19_ = g_variant_new_string (_tmp18_);
				g_variant_ref_sink (_tmp19_);
				_tmp20_ = _tmp19_;
				g_action_group_activate_action (_tmp14_, SCRATCH_MAIN_WINDOW_ACTION_CLOSE_PROJECT_DOCS, _tmp20_);
				_g_variant_unref0 (_tmp20_);
				_g_free0 (_tmp18_);
				_tmp21_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
				_tmp22_ = _tmp21_;
				_tmp23_ = project_folder_item;
				granite_widgets_source_list_expandable_item_remove (_tmp22_, (GraniteWidgetsSourceListItem*) _tmp23_);
				_tmp24_ = scratch_services_git_manager_get_instance ();
				_tmp25_ = _tmp24_;
				_tmp26_ = project_folder_item;
				scratch_services_git_manager_remove_project (_tmp25_, _tmp26_);
				_g_object_unref0 (_tmp25_);
			}
			_g_object_unref0 (project_folder_item);
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	scratch_folder_manager_file_view_write_settings (self);
}

static void
___lambda72__scratch_folder_manager_project_folder_item_close_all_except (ScratchFolderManagerProjectFolderItem* _sender,
                                                                          gpointer self)
{
	__lambda72_ (self);
}

static void
scratch_folder_manager_file_view_add_folder (ScratchFolderManagerFileView* self,
                                             ScratchFolderManagerFile* folder,
                                             gboolean expand)
{
	Block9Data* _data9_;
	ScratchFolderManagerProjectFolderItem* _tmp3_;
	GraniteWidgetsSourceListExpandableItem* _tmp4_;
	GraniteWidgetsSourceListExpandableItem* _tmp5_;
	ScratchFolderManagerProjectFolderItem* _tmp6_;
	ScratchFolderManagerProjectFolderItem* _tmp7_;
	ScratchFolderManagerProjectFolderItem* _tmp8_;
	ScratchFolderManagerProjectFolderItem* _tmp9_;
	ScratchFolderManagerProjectFolderItem* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (folder != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	if (scratch_folder_manager_file_view_is_open (self, folder)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = scratch_folder_manager_file_get_path (folder);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		g_warning ("FileView.vala:265: Folder '%s' is already open.", _tmp2_);
		_g_free0 (_tmp2_);
		block9_data_unref (_data9_);
		_data9_ = NULL;
		return;
	} else {
		if (!scratch_folder_manager_file_is_valid_directory (folder, TRUE)) {
			g_warning ("FileView.vala:268: Cannot open invalid directory.");
			block9_data_unref (_data9_);
			_data9_ = NULL;
			return;
		}
	}
	_tmp3_ = scratch_folder_manager_project_folder_item_new (folder, self);
	_data9_->folder_root = _tmp3_;
	_tmp4_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _data9_->folder_root;
	granite_widgets_source_list_expandable_item_add (_tmp5_, (GraniteWidgetsSourceListItem*) _tmp6_);
	_tmp7_ = _data9_->folder_root;
	scratch_folder_manager_file_view_rename_items_with_same_name (self, (ScratchFolderManagerItem*) _tmp7_);
	_tmp8_ = _data9_->folder_root;
	granite_widgets_source_list_expandable_item_set_expanded ((GraniteWidgetsSourceListExpandableItem*) _tmp8_, expand);
	_tmp9_ = _data9_->folder_root;
	g_signal_connect_data (_tmp9_, "closed", (GCallback) ___lambda71__scratch_folder_manager_project_folder_item_closed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp10_ = _data9_->folder_root;
	g_signal_connect_data (_tmp10_, "close-all-except", (GCallback) ___lambda72__scratch_folder_manager_project_folder_item_close_all_except, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	scratch_folder_manager_file_view_write_settings (self);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static gboolean
scratch_folder_manager_file_view_is_open (ScratchFolderManagerFileView* self,
                                          ScratchFolderManagerFile* folder)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (folder != NULL, FALSE);
	{
		GeeIterator* _child_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp0_;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp0_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = granite_widgets_source_list_expandable_item_get_children (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_child_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GraniteWidgetsSourceListItem* child = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GraniteWidgetsSourceListItem* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			_tmp7_ = _child_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _child_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			child = (GraniteWidgetsSourceListItem*) _tmp9_;
			_tmp10_ = scratch_folder_manager_file_get_path (folder);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp13_ = child;
			_tmp14_ = scratch_folder_manager_item_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strcmp0 (_tmp12_, _tmp16_) == 0;
			_g_free0 (_tmp16_);
			_g_free0 (_tmp12_);
			if (_tmp17_) {
				result = TRUE;
				_g_object_unref0 (child);
				_g_object_unref0 (_child_it);
				return result;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
	result = FALSE;
	return result;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
scratch_folder_manager_file_view_write_settings (ScratchFolderManagerFileView* self)
{
	gchar** to_save = NULL;
	gchar** _tmp0_;
	gint to_save_length1;
	gint _to_save_size_;
	GSettings* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	to_save = _tmp0_;
	to_save_length1 = 0;
	_to_save_size_ = to_save_length1;
	{
		GeeIterator* _main_folder_it = NULL;
		GraniteWidgetsSourceListExpandableItem* _tmp1_;
		GraniteWidgetsSourceListExpandableItem* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp1_ = granite_widgets_source_list_get_root ((GraniteWidgetsSourceList*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_widgets_source_list_expandable_item_get_children (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_main_folder_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			GraniteWidgetsSourceListItem* main_folder = NULL;
			GeeIterator* _tmp9_;
			gpointer _tmp10_;
			gboolean saved = FALSE;
			gchar* folder_path = NULL;
			GraniteWidgetsSourceListItem* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			_tmp8_ = _main_folder_it;
			if (!gee_iterator_next (_tmp8_)) {
				break;
			}
			_tmp9_ = _main_folder_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			main_folder = (GraniteWidgetsSourceListItem*) _tmp10_;
			saved = FALSE;
			_tmp11_ = main_folder;
			_tmp12_ = scratch_folder_manager_item_get_path (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, SCRATCH_FOLDER_MANAGER_TYPE_ITEM, ScratchFolderManagerItem));
			_tmp13_ = _tmp12_;
			folder_path = _tmp13_;
			_tmp14_ = to_save;
			_tmp14__length1 = to_save_length1;
			{
				gchar** saved_folder_collection = NULL;
				gint saved_folder_collection_length1 = 0;
				gint _saved_folder_collection_size_ = 0;
				gint saved_folder_it = 0;
				saved_folder_collection = _tmp14_;
				saved_folder_collection_length1 = _tmp14__length1;
				for (saved_folder_it = 0; saved_folder_it < saved_folder_collection_length1; saved_folder_it = saved_folder_it + 1) {
					gchar* _tmp15_;
					gchar* saved_folder = NULL;
					_tmp15_ = g_strdup (saved_folder_collection[saved_folder_it]);
					saved_folder = _tmp15_;
					{
						const gchar* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = folder_path;
						_tmp17_ = saved_folder;
						if (g_strcmp0 (_tmp16_, _tmp17_) == 0) {
							saved = TRUE;
							_g_free0 (saved_folder);
							break;
						}
						_g_free0 (saved_folder);
					}
				}
			}
			if (!saved) {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = folder_path;
				_tmp19_ = g_strdup (_tmp18_);
				_vala_array_add3 (&to_save, &to_save_length1, &_to_save_size_, _tmp19_);
			}
			_g_free0 (folder_path);
			_g_object_unref0 (main_folder);
		}
		_g_object_unref0 (_main_folder_it);
	}
	_tmp20_ = self->priv->settings;
	_tmp21_ = to_save;
	_tmp21__length1 = to_save_length1;
	g_settings_set_strv (_tmp20_, "opened-folders", _tmp21_);
	to_save = (_vala_array_free (to_save, to_save_length1, (GDestroyNotify) g_free), NULL);
}

gboolean
scratch_folder_manager_file_view_get_ignore_next_select (ScratchFolderManagerFileView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_ignore_next_select;
	return result;
}

void
scratch_folder_manager_file_view_set_ignore_next_select (ScratchFolderManagerFileView* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_folder_manager_file_view_get_ignore_next_select (self);
	if (old_value != value) {
		self->priv->_ignore_next_select = value;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_IGNORE_NEXT_SELECT_PROPERTY]);
	}
}

static const gchar*
scratch_folder_manager_file_view_real_get_icon_name (CodePaneSwitcher* base)
{
	const gchar* result;
	ScratchFolderManagerFileView* self;
	const gchar* _tmp0_;
	self = (ScratchFolderManagerFileView*) base;
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_file_view_real_set_icon_name (CodePaneSwitcher* base,
                                                     const gchar* value)
{
	ScratchFolderManagerFileView* self;
	gchar* old_value;
	self = (ScratchFolderManagerFileView*) base;
	old_value = scratch_folder_manager_file_view_real_get_icon_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY]);
	}
}

static const gchar*
scratch_folder_manager_file_view_real_get_title (CodePaneSwitcher* base)
{
	const gchar* result;
	ScratchFolderManagerFileView* self;
	const gchar* _tmp0_;
	self = (ScratchFolderManagerFileView*) base;
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

static void
scratch_folder_manager_file_view_real_set_title (CodePaneSwitcher* base,
                                                 const gchar* value)
{
	ScratchFolderManagerFileView* self;
	gchar* old_value;
	self = (ScratchFolderManagerFileView*) base;
	old_value = scratch_folder_manager_file_view_real_get_title (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY]);
	}
}

const gchar*
scratch_folder_manager_file_view_get_active_project_path (ScratchFolderManagerFileView* self)
{
	const gchar* result;
	ScratchServicesGitManager* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->git_manager;
	_tmp1_ = scratch_services_git_manager_get_active_project_path (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
_scratch_folder_manager_file_view___lambda79_ (ScratchFolderManagerFileView* self)
{
	GActionGroup* _tmp0_;
	GActionGroup* _tmp1_;
	GActionGroup* _tmp2_;
	_tmp0_ = gtk_widget_get_action_group ((GtkWidget*) self, SCRATCH_MAIN_WINDOW_ACTION_GROUP);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->toplevel_action_group);
	self->priv->toplevel_action_group = _tmp1_;
	_tmp2_ = self->priv->toplevel_action_group;
	g_assert_nonnull (_tmp2_);
}

static void
__scratch_folder_manager_file_view___lambda79__gtk_widget_realize (GtkWidget* _sender,
                                                                   gpointer self)
{
	_scratch_folder_manager_file_view___lambda79_ ((ScratchFolderManagerFileView*) self);
}

static GObject *
scratch_folder_manager_file_view_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchFolderManagerFileView * self;
	GSettings* _tmp0_;
	ScratchServicesGitManager* _tmp1_;
	parent_class = G_OBJECT_CLASS (scratch_folder_manager_file_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	code_pane_switcher_set_icon_name ((CodePaneSwitcher*) self, "folder-symbolic");
	code_pane_switcher_set_title ((CodePaneSwitcher*) self, _ ("Folders"));
	g_signal_connect_object ((GraniteWidgetsSourceList*) self, "item-selected", (GCallback) _scratch_folder_manager_file_view_on_item_selected_granite_widgets_source_list_item_selected, self, 0);
	_tmp0_ = g_settings_new ("io.elementary.code.folder-manager");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = scratch_services_git_manager_get_instance ();
	_g_object_unref0 (self->priv->git_manager);
	self->priv->git_manager = _tmp1_;
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) __scratch_folder_manager_file_view___lambda79__gtk_widget_realize, self, 0);
	return obj;
}

static void
scratch_folder_manager_file_view_class_init (ScratchFolderManagerFileViewClass * klass,
                                             gpointer klass_data)
{
	scratch_folder_manager_file_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchFolderManagerFileView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_folder_manager_file_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_folder_manager_file_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_folder_manager_file_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_folder_manager_file_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_IGNORE_NEXT_SELECT_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_IGNORE_NEXT_SELECT_PROPERTY] = g_param_spec_boolean ("ignore-next-select", "ignore-next-select", "ignore-next-select", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIVE_PROJECT_PATH_PROPERTY, scratch_folder_manager_file_view_properties[SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIVE_PROJECT_PATH_PROPERTY] = g_param_spec_string ("active-project-path", "active-project-path", "active-project-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	scratch_folder_manager_file_view_signals[SCRATCH_FOLDER_MANAGER_FILE_VIEW_SELECT_SIGNAL] = g_signal_new ("select", SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
scratch_folder_manager_file_view_code_pane_switcher_interface_init (CodePaneSwitcherIface * iface,
                                                                    gpointer iface_data)
{
	scratch_folder_manager_file_view_code_pane_switcher_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_icon_name = scratch_folder_manager_file_view_real_get_icon_name;
	iface->set_icon_name = scratch_folder_manager_file_view_real_set_icon_name;
	iface->get_title = scratch_folder_manager_file_view_real_get_title;
	iface->set_title = scratch_folder_manager_file_view_real_set_title;
}

static void
scratch_folder_manager_file_view_instance_init (ScratchFolderManagerFileView * self,
                                                gpointer klass)
{
	self->priv = scratch_folder_manager_file_view_get_instance_private (self);
	self->priv->toplevel_action_group = NULL;
	self->priv->_ignore_next_select = FALSE;
}

static void
scratch_folder_manager_file_view_finalize (GObject * obj)
{
	ScratchFolderManagerFileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->git_manager);
	_g_object_unref0 (self->priv->toplevel_action_group);
	_g_object_unref0 (self->priv->plugins);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_title);
	G_OBJECT_CLASS (scratch_folder_manager_file_view_parent_class)->finalize (obj);
}

/**
 * SourceList that displays folders and their contents.
 */
static GType
scratch_folder_manager_file_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchFolderManagerFileViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_folder_manager_file_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchFolderManagerFileView), 0, (GInstanceInitFunc) scratch_folder_manager_file_view_instance_init, NULL };
	static const GInterfaceInfo code_pane_switcher_info = { (GInterfaceInitFunc) scratch_folder_manager_file_view_code_pane_switcher_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType scratch_folder_manager_file_view_type_id;
	scratch_folder_manager_file_view_type_id = g_type_register_static (GRANITE_WIDGETS_TYPE_SOURCE_LIST, "ScratchFolderManagerFileView", &g_define_type_info, 0);
	g_type_add_interface_static (scratch_folder_manager_file_view_type_id, CODE_TYPE_PANE_SWITCHER, &code_pane_switcher_info);
	ScratchFolderManagerFileView_private_offset = g_type_add_instance_private (scratch_folder_manager_file_view_type_id, sizeof (ScratchFolderManagerFileViewPrivate));
	return scratch_folder_manager_file_view_type_id;
}

GType
scratch_folder_manager_file_view_get_type (void)
{
	static volatile gsize scratch_folder_manager_file_view_type_id__once = 0;
	if (g_once_init_enter (&scratch_folder_manager_file_view_type_id__once)) {
		GType scratch_folder_manager_file_view_type_id;
		scratch_folder_manager_file_view_type_id = scratch_folder_manager_file_view_get_type_once ();
		g_once_init_leave (&scratch_folder_manager_file_view_type_id__once, scratch_folder_manager_file_view_type_id);
	}
	return scratch_folder_manager_file_view_type_id__once;
}

static void
_vala_scratch_folder_manager_file_view_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	ScratchFolderManagerFileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_IGNORE_NEXT_SELECT_PROPERTY:
		g_value_set_boolean (value, scratch_folder_manager_file_view_get_ignore_next_select (self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY:
		g_value_set_string (value, code_pane_switcher_get_icon_name ((CodePaneSwitcher*) self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY:
		g_value_set_string (value, code_pane_switcher_get_title ((CodePaneSwitcher*) self));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_ACTIVE_PROJECT_PATH_PROPERTY:
		g_value_set_string (value, scratch_folder_manager_file_view_get_active_project_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_folder_manager_file_view_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec)
{
	ScratchFolderManagerFileView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_FOLDER_MANAGER_TYPE_FILE_VIEW, ScratchFolderManagerFileView);
	switch (property_id) {
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_IGNORE_NEXT_SELECT_PROPERTY:
		scratch_folder_manager_file_view_set_ignore_next_select (self, g_value_get_boolean (value));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_ICON_NAME_PROPERTY:
		code_pane_switcher_set_icon_name ((CodePaneSwitcher*) self, g_value_get_string (value));
		break;
		case SCRATCH_FOLDER_MANAGER_FILE_VIEW_TITLE_PROPERTY:
		code_pane_switcher_set_title ((CodePaneSwitcher*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

