/* engine.c generated by valac 0.56.14, the Vala compiler
 * generated from engine.vala, do not modify */

/*
 * Copyright (c) 2011 Lucas Baudin <xapantu@gmail.com>
 *
 * This is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */

#include "word-completion.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>

enum  {
	EUCLIDE_COMPLETION_PARSER_0_PROPERTY,
	EUCLIDE_COMPLETION_PARSER_NUM_PROPERTIES
};
static GParamSpec* euclide_completion_parser_properties[EUCLIDE_COMPLETION_PARSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _EuclideCompletionParserPrivate {
	ScratchPluginsPrefixTree* prefix_tree;
	GRecMutex __lock_prefix_tree;
};

static gint EuclideCompletionParser_private_offset;
static gpointer euclide_completion_parser_parent_class = NULL;
static GType euclide_completion_parser_type_id = 0;

static gboolean _euclide_completion_parser_is_delimiter_gtk_text_char_predicate (gunichar ch,
                                                                          gpointer self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static gboolean euclide_completion_parser_parse_string (EuclideCompletionParser* self,
                                                 const gchar* text);
static void euclide_completion_parser_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
euclide_completion_parser_get_instance_private (EuclideCompletionParser* self)
{
	return G_STRUCT_MEMBER_P (self, EuclideCompletionParser_private_offset);
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

gboolean
euclide_completion_parser_is_delimiter (gunichar c)
{
	gboolean result;
	result = string_index_of_char (EUCLIDE_COMPLETION_PARSER_DELIMITERS, c, 0) >= 0;
	return result;
}

static gboolean
_euclide_completion_parser_is_delimiter_gtk_text_char_predicate (gunichar ch,
                                                                 gpointer self)
{
	gboolean result;
	result = euclide_completion_parser_is_delimiter (ch);
	return result;
}

void
euclide_completion_parser_back_to_word_start (GtkTextIter* iter)
{
	g_return_if_fail (iter != NULL);
	gtk_text_iter_backward_find_char (iter, _euclide_completion_parser_is_delimiter_gtk_text_char_predicate, NULL, NULL);
	gtk_text_iter_forward_char (iter);
}

EuclideCompletionParser*
euclide_completion_parser_construct (GType object_type)
{
	EuclideCompletionParser * self = NULL;
	GeeHashMap* _tmp0_;
	ScratchPluginsPrefixTree* _tmp1_;
	self = (EuclideCompletionParser*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (gtk_text_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, SCRATCH_PLUGINS_TYPE_PREFIX_TREE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->text_view_words);
	self->text_view_words = _tmp0_;
	_tmp1_ = scratch_plugins_prefix_tree_new ();
	_g_object_unref0 (self->priv->prefix_tree);
	self->priv->prefix_tree = _tmp1_;
	return self;
}

EuclideCompletionParser*
euclide_completion_parser_new (void)
{
	return euclide_completion_parser_construct (EUCLIDE_COMPLETION_TYPE_PARSER);
}

gboolean
euclide_completion_parser_match (EuclideCompletionParser* self,
                                 const gchar* to_find)
{
	ScratchPluginsPrefixTree* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (to_find != NULL, FALSE);
	_tmp0_ = self->priv->prefix_tree;
	result = scratch_plugins_prefix_tree_find_prefix (_tmp0_, to_find);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

gboolean
euclide_completion_parser_get_for_word (EuclideCompletionParser* self,
                                        const gchar* to_find,
                                        GList** list)
{
	GList* _vala_list = NULL;
	ScratchPluginsPrefixTree* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (to_find != NULL, FALSE);
	_tmp0_ = self->priv->prefix_tree;
	_tmp1_ = scratch_plugins_prefix_tree_get_all_matches (_tmp0_, to_find);
	(_vala_list == NULL) ? NULL : (_vala_list = (_g_list_free__g_free0_ (_vala_list), NULL));
	_vala_list = _tmp1_;
	_tmp2_ = g_list_first (_vala_list);
	result = _tmp2_ != NULL;
	if (list) {
		*list = _vala_list;
	} else {
		(_vala_list == NULL) ? NULL : (_vala_list = (_g_list_free__g_free0_ (_vala_list), NULL));
	}
	return result;
}

void
euclide_completion_parser_rebuild_word_list (EuclideCompletionParser* self,
                                             GtkTextView* view)
{
	ScratchPluginsPrefixTree* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	_tmp0_ = self->priv->prefix_tree;
	scratch_plugins_prefix_tree_clear (_tmp0_);
	euclide_completion_parser_parse_text_view (self, view);
}

void
euclide_completion_parser_parse_text_view (EuclideCompletionParser* self,
                                           GtkTextView* view)
{
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	{
		ScratchPluginsPrefixTree* _tmp0_;
		_tmp0_ = self->priv->prefix_tree;
		g_rec_mutex_lock (&self->priv->__lock_prefix_tree);
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->text_view_words;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, view)) {
				GeeHashMap* _tmp2_;
				gpointer _tmp3_;
				_tmp2_ = self->text_view_words;
				_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, view);
				_g_object_unref0 (self->priv->prefix_tree);
				self->priv->prefix_tree = (ScratchPluginsPrefixTree*) _tmp3_;
			} else {
				ScratchPluginsPrefixTree* _tmp4_;
				_tmp4_ = scratch_plugins_prefix_tree_new ();
				_g_object_unref0 (self->priv->prefix_tree);
				self->priv->prefix_tree = _tmp4_;
			}
		}
		__finally0:
		{
			ScratchPluginsPrefixTree* _tmp5_;
			_tmp5_ = self->priv->prefix_tree;
			g_rec_mutex_unlock (&self->priv->__lock_prefix_tree);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp6_ = gtk_text_view_get_buffer (view);
	_tmp7_ = _tmp6_;
	g_object_get (_tmp7_, "text", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_ > 0;
	_g_free0 (_tmp10_);
	if (_tmp13_) {
		GtkTextBuffer* _tmp14_;
		GtkTextBuffer* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		GeeHashMap* _tmp19_;
		ScratchPluginsPrefixTree* _tmp20_;
		_tmp14_ = gtk_text_view_get_buffer (view);
		_tmp15_ = _tmp14_;
		g_object_get (_tmp15_, "text", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		euclide_completion_parser_parse_string (self, _tmp18_);
		_g_free0 (_tmp18_);
		_tmp19_ = self->text_view_words;
		_tmp20_ = self->priv->prefix_tree;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, view, _tmp20_);
	}
}

void
euclide_completion_parser_add_word (EuclideCompletionParser* self,
                                    const gchar* word)
{
	gint _tmp0_;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (word != NULL);
	_tmp0_ = strlen (word);
	_tmp1_ = _tmp0_;
	if (_tmp1_ < EUCLIDE_COMPLETION_PARSER_MINIMUM_WORD_LENGTH) {
		return;
	}
	{
		ScratchPluginsPrefixTree* _tmp2_;
		_tmp2_ = self->priv->prefix_tree;
		g_rec_mutex_lock (&self->priv->__lock_prefix_tree);
		{
			ScratchPluginsPrefixTree* _tmp3_;
			_tmp3_ = self->priv->prefix_tree;
			scratch_plugins_prefix_tree_insert (_tmp3_, word);
		}
		__finally0:
		{
			ScratchPluginsPrefixTree* _tmp4_;
			_tmp4_ = self->priv->prefix_tree;
			g_rec_mutex_unlock (&self->priv->__lock_prefix_tree);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
euclide_completion_parser_cancel_parsing (EuclideCompletionParser* self)
{
	g_return_if_fail (self != NULL);
	self->parsing_cancelled = TRUE;
}

static gboolean
euclide_completion_parser_parse_string (EuclideCompletionParser* self,
                                        const gchar* text)
{
	gchar** word_array = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint word_array_length1;
	gint _word_array_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	self->parsing_cancelled = FALSE;
	_tmp1_ = _tmp0_ = g_strsplit_set (text, EUCLIDE_COMPLETION_PARSER_DELIMITERS, EUCLIDE_COMPLETION_PARSER_MAX_TOKENS);
	word_array = _tmp1_;
	word_array_length1 = _vala_array_length (_tmp0_);
	_word_array_size_ = word_array_length1;
	_tmp2_ = word_array;
	_tmp2__length1 = word_array_length1;
	{
		gchar** current_word_collection = NULL;
		gint current_word_collection_length1 = 0;
		gint _current_word_collection_size_ = 0;
		gint current_word_it = 0;
		current_word_collection = _tmp2_;
		current_word_collection_length1 = _tmp2__length1;
		for (current_word_it = 0; current_word_it < current_word_collection_length1; current_word_it = current_word_it + 1) {
			gchar* _tmp3_;
			gchar* current_word = NULL;
			_tmp3_ = g_strdup (current_word_collection[current_word_it]);
			current_word = _tmp3_;
			{
				const gchar* _tmp4_;
				if (self->parsing_cancelled) {
					g_debug ("engine.vala:94: Cancelling parse");
					result = FALSE;
					_g_free0 (current_word);
					word_array = (_vala_array_free (word_array, word_array_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp4_ = current_word;
				euclide_completion_parser_add_word (self, _tmp4_);
				_g_free0 (current_word);
			}
		}
	}
	result = TRUE;
	word_array = (_vala_array_free (word_array, word_array_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
euclide_completion_parser_class_init (EuclideCompletionParserClass * klass,
                                      gpointer klass_data)
{
	euclide_completion_parser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EuclideCompletionParser_private_offset);
	G_OBJECT_CLASS (klass)->finalize = euclide_completion_parser_finalize;
}

static void
euclide_completion_parser_instance_init (EuclideCompletionParser * self,
                                         gpointer klass)
{
	self->priv = euclide_completion_parser_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_prefix_tree);
	self->parsing_cancelled = FALSE;
}

static void
euclide_completion_parser_finalize (GObject * obj)
{
	EuclideCompletionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, EUCLIDE_COMPLETION_TYPE_PARSER, EuclideCompletionParser);
	g_rec_mutex_clear (&self->priv->__lock_prefix_tree);
	_g_object_unref0 (self->priv->prefix_tree);
	_g_object_unref0 (self->text_view_words);
	G_OBJECT_CLASS (euclide_completion_parser_parent_class)->finalize (obj);
}

GType
euclide_completion_parser_get_type (void)
{
	return euclide_completion_parser_type_id;
}

GType
euclide_completion_parser_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (EuclideCompletionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) euclide_completion_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EuclideCompletionParser), 0, (GInstanceInitFunc) euclide_completion_parser_instance_init, NULL };
	euclide_completion_parser_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "EuclideCompletionParser", &g_define_type_info, 0);
	EuclideCompletionParser_private_offset = sizeof (EuclideCompletionParserPrivate);
	return euclide_completion_parser_type_id;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

