/* completion-provider.c generated by valac 0.56.14, the Vala compiler
 * generated from completion-provider.vala, do not modify */

/*
 * Copyright (c) 2013 Mario Guerriero <mario@elementaryos.org>
 *
 * This is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; see the file COPYING.  If not,
 * write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 */

#include "word-completion.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>

enum  {
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_0_PROPERTY,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* scratch_plugins_completion_provider_properties[SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))
enum  {
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_CAN_PROPOSE_SIGNAL,
	SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_SIGNALS
};
static guint scratch_plugins_completion_provider_signals[SCRATCH_PLUGINS_COMPLETION_PROVIDER_NUM_SIGNALS] = {0};

struct _ScratchPluginsCompletionProviderPrivate {
	GtkTextView* view;
	GtkTextBuffer* buffer;
	EuclideCompletionParser* parser;
	GtkTextMark* completion_end_mark;
	GtkTextMark* completion_start_mark;
};

static gint ScratchPluginsCompletionProvider_private_offset;
static gpointer scratch_plugins_completion_provider_parent_class = NULL;
static GtkSourceCompletionProviderIface * scratch_plugins_completion_provider_gtk_source_completion_provider_parent_iface = NULL;
static GType scratch_plugins_completion_provider_type_id = 0;

static gchar* scratch_plugins_completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static gint scratch_plugins_completion_provider_real_get_priority (GtkSourceCompletionProvider* base);
static gboolean scratch_plugins_completion_provider_real_match (GtkSourceCompletionProvider* base,
                                                         GtkSourceCompletionContext* context);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static void scratch_plugins_completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                                        GtkSourceCompletionContext* context);
static gboolean scratch_plugins_completion_provider_get_proposals (ScratchPluginsCompletionProvider* self,
                                                            GList** props,
                                                            gboolean no_minimum);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean scratch_plugins_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                                                     GtkSourceCompletionProposal* proposal,
                                                                     GtkTextIter* iter);
static GtkSourceCompletionActivation scratch_plugins_completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static gint scratch_plugins_completion_provider_real_get_interactive_delay (GtkSourceCompletionProvider* base);
static gboolean scratch_plugins_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                                                  GtkSourceCompletionContext* context,
                                                                  GtkSourceCompletionProposal* proposal,
                                                                  GtkTextIter* iter);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void scratch_plugins_completion_provider_finalize (GObject * obj);

static inline gpointer
scratch_plugins_completion_provider_get_instance_private (ScratchPluginsCompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchPluginsCompletionProvider_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ScratchPluginsCompletionProvider*
scratch_plugins_completion_provider_construct (GType object_type,
                                               ScratchPluginsCompletion* completion)
{
	ScratchPluginsCompletionProvider * self = NULL;
	GtkSourceView* _tmp0_;
	GtkSourceView* _tmp1_;
	GtkTextView* _tmp2_;
	GtkSourceView* _tmp3_;
	GtkSourceView* _tmp4_;
	GtkTextBuffer* _tmp5_;
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	EuclideCompletionParser* _tmp8_;
	EuclideCompletionParser* _tmp9_;
	EuclideCompletionParser* _tmp10_;
	GtkTextIter iter = {0};
	GtkTextBuffer* _tmp11_;
	GtkTextIter _tmp12_ = {0};
	GtkTextBuffer* _tmp13_;
	GtkTextIter _tmp14_;
	GtkTextMark* _tmp15_;
	GtkTextMark* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextIter _tmp18_;
	GtkTextMark* _tmp19_;
	GtkTextMark* _tmp20_;
	g_return_val_if_fail (completion != NULL, NULL);
	self = (ScratchPluginsCompletionProvider*) g_object_new (object_type, NULL);
	_tmp0_ = scratch_plugins_completion_get_current_view (completion);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_text_view_get_type ()) ? ((GtkTextView*) _tmp1_) : NULL);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp2_;
	_tmp3_ = scratch_plugins_completion_get_current_view (completion);
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->buffer);
	self->priv->buffer = _tmp7_;
	_tmp8_ = scratch_plugins_completion_get_parser (completion);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (self->priv->parser);
	self->priv->parser = _tmp10_;
	_tmp11_ = self->priv->buffer;
	gtk_text_buffer_get_iter_at_offset (_tmp11_, &_tmp12_, 0);
	iter = _tmp12_;
	_tmp13_ = self->priv->buffer;
	_tmp14_ = iter;
	_tmp15_ = gtk_text_buffer_create_mark (_tmp13_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_END_MARK_NAME, &_tmp14_, FALSE);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	_g_object_unref0 (self->priv->completion_end_mark);
	self->priv->completion_end_mark = _tmp16_;
	_tmp17_ = self->priv->buffer;
	_tmp18_ = iter;
	_tmp19_ = gtk_text_buffer_create_mark (_tmp17_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_START_MARK_NAME, &_tmp18_, FALSE);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	_g_object_unref0 (self->priv->completion_start_mark);
	self->priv->completion_start_mark = _tmp20_;
	return self;
}

ScratchPluginsCompletionProvider*
scratch_plugins_completion_provider_new (ScratchPluginsCompletion* completion)
{
	return scratch_plugins_completion_provider_construct (SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, completion);
}

static gchar*
scratch_plugins_completion_provider_real_get_name (GtkSourceCompletionProvider* base)
{
	ScratchPluginsCompletionProvider * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (ScratchPluginsCompletionProvider*) base;
	_tmp0_ = self->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static gint
scratch_plugins_completion_provider_real_get_priority (GtkSourceCompletionProvider* base)
{
	ScratchPluginsCompletionProvider * self;
	gint result;
	self = (ScratchPluginsCompletionProvider*) base;
	result = self->priority;
	return result;
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static gboolean
scratch_plugins_completion_provider_real_match (GtkSourceCompletionProvider* base,
                                                GtkSourceCompletionContext* context)
{
	ScratchPluginsCompletionProvider * self;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter* _tmp5_;
	GtkTextIter* _tmp6_;
	gchar* text = NULL;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	gchar* _tmp10_;
	EuclideCompletionParser* _tmp11_;
	gboolean result;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = self->priv->buffer;
	g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_iter_at_offset (_tmp0_, &_tmp4_, _tmp3_);
	end = _tmp4_;
	_tmp5_ = gtk_text_iter_copy (&end);
	_tmp6_ = _tmp5_;
	start = *_tmp6_;
	__vala_GtkTextIter_free0 (_tmp6_);
	euclide_completion_parser_back_to_word_start (&start);
	_tmp7_ = self->priv->buffer;
	_tmp8_ = start;
	_tmp9_ = end;
	_tmp10_ = gtk_text_buffer_get_text (_tmp7_, &_tmp8_, &_tmp9_, TRUE);
	text = _tmp10_;
	_tmp11_ = self->priv->parser;
	result = euclide_completion_parser_match (_tmp11_, text);
	_g_free0 (text);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
scratch_plugins_completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                                   GtkSourceCompletionContext* context)
{
	ScratchPluginsCompletionProvider * self;
	GList* file_props = NULL;
	gboolean no_minimum = FALSE;
	GList* _tmp0_ = NULL;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_if_fail (context != NULL);
	no_minimum = gtk_source_completion_context_get_activation (context) == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	scratch_plugins_completion_provider_get_proposals (self, &_tmp0_, no_minimum);
	(file_props == NULL) ? NULL : (file_props = (_g_list_free__g_object_unref0_ (file_props), NULL));
	file_props = _tmp0_;
	gtk_source_completion_context_add_proposals (context, (GtkSourceCompletionProvider*) self, file_props, TRUE);
	(file_props == NULL) ? NULL : (file_props = (_g_list_free__g_object_unref0_ (file_props), NULL));
}

static gboolean
scratch_plugins_completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                                            GtkSourceCompletionProposal* proposal,
                                                            GtkTextIter* iter)
{
	ScratchPluginsCompletionProvider * self;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextMark* mark = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextMark* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextBuffer* _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextMark* _tmp10_;
	GtkTextIter _tmp11_ = {0};
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gboolean result;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = gtk_text_buffer_get_mark (_tmp0_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_END_MARK_NAME);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (mark);
	mark = _tmp2_;
	_tmp3_ = self->priv->buffer;
	_tmp4_ = mark;
	gtk_text_buffer_get_iter_at_mark (_tmp3_, &_tmp5_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = self->priv->buffer;
	_tmp7_ = gtk_text_buffer_get_mark (_tmp6_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_START_MARK_NAME);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (mark);
	mark = _tmp8_;
	_tmp9_ = self->priv->buffer;
	_tmp10_ = mark;
	gtk_text_buffer_get_iter_at_mark (_tmp9_, &_tmp11_, _tmp10_);
	start = _tmp11_;
	_tmp12_ = self->priv->buffer;
	gtk_text_buffer_delete (_tmp12_, &start, &end);
	_tmp13_ = self->priv->buffer;
	_tmp14_ = gtk_source_completion_proposal_get_text (proposal);
	_tmp15_ = _tmp14_;
	_tmp16_ = gtk_source_completion_proposal_get_text (proposal);
	_tmp17_ = _tmp16_;
	_tmp18_ = strlen (_tmp17_);
	_tmp19_ = _tmp18_;
	gtk_text_buffer_insert (_tmp13_, &start, _tmp15_, _tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	result = TRUE;
	_g_object_unref0 (mark);
	return result;
}

static GtkSourceCompletionActivation
scratch_plugins_completion_provider_real_get_activation (GtkSourceCompletionProvider* base)
{
	ScratchPluginsCompletionProvider * self;
	GtkSourceCompletionActivation result;
	self = (ScratchPluginsCompletionProvider*) base;
	result = GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE | GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}

static gint
scratch_plugins_completion_provider_real_get_interactive_delay (GtkSourceCompletionProvider* base)
{
	ScratchPluginsCompletionProvider * self;
	gint result;
	self = (ScratchPluginsCompletionProvider*) base;
	result = 0;
	return result;
}

static gboolean
scratch_plugins_completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                                         GtkSourceCompletionContext* context,
                                                         GtkSourceCompletionProposal* proposal,
                                                         GtkTextIter* iter)
{
	ScratchPluginsCompletionProvider * self;
	GtkTextIter _vala_iter = {0};
	GtkTextMark* mark = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextMark* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextIter cursor_iter = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_;
	gboolean result;
	self = (ScratchPluginsCompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_tmp0_ = self->priv->buffer;
	_tmp1_ = gtk_text_buffer_get_insert (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	mark = _tmp2_;
	_tmp3_ = self->priv->buffer;
	gtk_text_buffer_get_iter_at_mark (_tmp3_, &_tmp4_, mark);
	cursor_iter = _tmp4_;
	_tmp5_ = cursor_iter;
	_vala_iter = _tmp5_;
	euclide_completion_parser_back_to_word_start (&_vala_iter);
	result = TRUE;
	_g_object_unref0 (mark);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static gboolean
scratch_plugins_completion_provider_get_proposals (ScratchPluginsCompletionProvider* self,
                                                   GList** props,
                                                   gboolean no_minimum)
{
	GList* _vala_props = NULL;
	gchar* to_find = NULL;
	gchar* _tmp0_;
	GtkTextBuffer* temp_buffer = NULL;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextBuffer* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GtkTextBuffer* _tmp23_;
	GtkTextIter _tmp24_;
	GtkTextBuffer* _tmp25_;
	GtkTextIter _tmp26_;
	gboolean _tmp27_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	to_find = _tmp0_;
	_tmp1_ = self->priv->buffer;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	temp_buffer = _tmp2_;
	(_vala_props == NULL) ? NULL : (_vala_props = (_g_list_free__g_object_unref0_ (_vala_props), NULL));
	_vala_props = NULL;
	_tmp3_ = self->priv->buffer;
	gtk_text_buffer_get_selection_bounds (_tmp3_, &_tmp4_, &_tmp5_);
	start = _tmp4_;
	end = _tmp5_;
	_tmp6_ = temp_buffer;
	_tmp7_ = start;
	_tmp8_ = end;
	_tmp9_ = gtk_text_buffer_get_text (_tmp6_, &_tmp7_, &_tmp8_, TRUE);
	_g_free0 (to_find);
	to_find = _tmp9_;
	_tmp10_ = to_find;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 0) {
		GtkTextBuffer* _tmp13_;
		GtkTextBuffer* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GtkTextIter _tmp17_ = {0};
		GtkTextIter _tmp18_;
		GtkTextBuffer* _tmp19_;
		GtkTextIter _tmp20_;
		GtkTextIter _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = temp_buffer;
		_tmp14_ = self->priv->buffer;
		g_object_get (_tmp14_, "cursor-position", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		gtk_text_buffer_get_iter_at_offset (_tmp13_, &_tmp17_, _tmp16_);
		end = _tmp17_;
		_tmp18_ = end;
		start = _tmp18_;
		euclide_completion_parser_back_to_word_start (&start);
		_tmp19_ = self->priv->buffer;
		_tmp20_ = start;
		_tmp21_ = end;
		_tmp22_ = gtk_text_buffer_get_text (_tmp19_, &_tmp20_, &_tmp21_, FALSE);
		_g_free0 (to_find);
		to_find = _tmp22_;
	}
	_tmp23_ = self->priv->buffer;
	_tmp24_ = end;
	gtk_text_buffer_move_mark_by_name (_tmp23_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_END_MARK_NAME, &_tmp24_);
	_tmp25_ = self->priv->buffer;
	_tmp26_ = start;
	gtk_text_buffer_move_mark_by_name (_tmp25_, SCRATCH_PLUGINS_COMPLETION_PROVIDER_COMPLETION_START_MARK_NAME, &_tmp26_);
	if (no_minimum) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp28_ = to_find;
		_tmp29_ = strlen (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp27_ = _tmp30_ >= EUCLIDE_COMPLETION_PARSER_MINIMUM_WORD_LENGTH;
	}
	if (_tmp27_) {
		GList* prop_word_list = NULL;
		EuclideCompletionParser* _tmp31_;
		const gchar* _tmp32_;
		GList* _tmp33_ = NULL;
		gboolean _tmp34_;
		_tmp31_ = self->priv->parser;
		_tmp32_ = to_find;
		_tmp34_ = euclide_completion_parser_get_for_word (_tmp31_, _tmp32_, &_tmp33_);
		(prop_word_list == NULL) ? NULL : (prop_word_list = (_g_list_free__g_free0_ (prop_word_list), NULL));
		prop_word_list = _tmp33_;
		if (_tmp34_) {
			GList* _tmp35_;
			_tmp35_ = prop_word_list;
			{
				GList* word_collection = NULL;
				GList* word_it = NULL;
				word_collection = _tmp35_;
				for (word_it = word_collection; word_it != NULL; word_it = word_it->next) {
					gchar* _tmp36_;
					gchar* word = NULL;
					_tmp36_ = g_strdup ((const gchar*) word_it->data);
					word = _tmp36_;
					{
						GtkSourceCompletionItem* item = NULL;
						GtkSourceCompletionItem* _tmp37_;
						GtkSourceCompletionItem* _tmp38_;
						const gchar* _tmp39_;
						GtkSourceCompletionItem* _tmp40_;
						const gchar* _tmp41_;
						GtkSourceCompletionItem* _tmp42_;
						GtkSourceCompletionItem* _tmp43_;
						_tmp37_ = gtk_source_completion_item_new ();
						item = _tmp37_;
						_tmp38_ = item;
						_tmp39_ = word;
						g_object_set (_tmp38_, "label", _tmp39_, NULL);
						_tmp40_ = item;
						_tmp41_ = word;
						g_object_set (_tmp40_, "text", _tmp41_, NULL);
						_tmp42_ = item;
						_tmp43_ = _g_object_ref0 (_tmp42_);
						_vala_props = g_list_append (_vala_props, _tmp43_);
						_g_object_unref0 (item);
						_g_free0 (word);
					}
				}
			}
			result = TRUE;
			(prop_word_list == NULL) ? NULL : (prop_word_list = (_g_list_free__g_free0_ (prop_word_list), NULL));
			_g_object_unref0 (temp_buffer);
			_g_free0 (to_find);
			if (props) {
				*props = _vala_props;
			} else {
				(_vala_props == NULL) ? NULL : (_vala_props = (_g_list_free__g_object_unref0_ (_vala_props), NULL));
			}
			return result;
		}
		(prop_word_list == NULL) ? NULL : (prop_word_list = (_g_list_free__g_free0_ (prop_word_list), NULL));
	}
	result = FALSE;
	_g_object_unref0 (temp_buffer);
	_g_free0 (to_find);
	if (props) {
		*props = _vala_props;
	} else {
		(_vala_props == NULL) ? NULL : (_vala_props = (_g_list_free__g_object_unref0_ (_vala_props), NULL));
	}
	return result;
}

static void
scratch_plugins_completion_provider_class_init (ScratchPluginsCompletionProviderClass * klass,
                                                gpointer klass_data)
{
	scratch_plugins_completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchPluginsCompletionProvider_private_offset);
	G_OBJECT_CLASS (klass)->finalize = scratch_plugins_completion_provider_finalize;
	scratch_plugins_completion_provider_signals[SCRATCH_PLUGINS_COMPLETION_PROVIDER_CAN_PROPOSE_SIGNAL] = g_signal_new ("can-propose", SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
scratch_plugins_completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface,
                                                                                   gpointer iface_data)
{
	scratch_plugins_completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (GtkSourceCompletionProvider*)) scratch_plugins_completion_provider_real_get_name;
	iface->get_priority = (gint (*) (GtkSourceCompletionProvider*)) scratch_plugins_completion_provider_real_get_priority;
	iface->match = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) scratch_plugins_completion_provider_real_match;
	iface->populate = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) scratch_plugins_completion_provider_real_populate;
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) scratch_plugins_completion_provider_real_activate_proposal;
	iface->get_activation = (GtkSourceCompletionActivation (*) (GtkSourceCompletionProvider*)) scratch_plugins_completion_provider_real_get_activation;
	iface->get_interactive_delay = (gint (*) (GtkSourceCompletionProvider*)) scratch_plugins_completion_provider_real_get_interactive_delay;
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) scratch_plugins_completion_provider_real_get_start_iter;
}

static void
scratch_plugins_completion_provider_instance_init (ScratchPluginsCompletionProvider * self,
                                                   gpointer klass)
{
	self->priv = scratch_plugins_completion_provider_get_instance_private (self);
}

static void
scratch_plugins_completion_provider_finalize (GObject * obj)
{
	ScratchPluginsCompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_PLUGINS_TYPE_COMPLETION_PROVIDER, ScratchPluginsCompletionProvider);
	_g_free0 (self->name);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->buffer);
	_g_object_unref0 (self->priv->parser);
	_g_object_unref0 (self->priv->completion_end_mark);
	_g_object_unref0 (self->priv->completion_start_mark);
	G_OBJECT_CLASS (scratch_plugins_completion_provider_parent_class)->finalize (obj);
}

GType
scratch_plugins_completion_provider_get_type (void)
{
	return scratch_plugins_completion_provider_type_id;
}

GType
scratch_plugins_completion_provider_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchPluginsCompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_plugins_completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchPluginsCompletionProvider), 0, (GInstanceInitFunc) scratch_plugins_completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) scratch_plugins_completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	scratch_plugins_completion_provider_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "ScratchPluginsCompletionProvider", &g_define_type_info, 0);
	g_type_module_add_interface (module, scratch_plugins_completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	ScratchPluginsCompletionProvider_private_offset = sizeof (ScratchPluginsCompletionProviderPrivate);
	return scratch_plugins_completion_provider_type_id;
}

