/* markdown-actions.c generated by valac 0.56.14, the Vala compiler
 * generated from markdown-actions.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/

#include "markdown-actions.h"
#include "codecore.h"
#include <glib-object.h>
#include <libpeas/peas.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

enum  {
	CODE_PLUGINS_MARKDOWN_ACTIONS_0_PROPERTY,
	CODE_PLUGINS_MARKDOWN_ACTIONS_OBJECT_PROPERTY,
	CODE_PLUGINS_MARKDOWN_ACTIONS_NUM_PROPERTIES
};
static GParamSpec* code_plugins_markdown_actions_properties[CODE_PLUGINS_MARKDOWN_ACTIONS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CodePluginsMarkdownActionsPrivate {
	ScratchWidgetsSourceView* current_source;
	ScratchServicesInterface* plugins;
	GObject* _object;
};

static gint CodePluginsMarkdownActions_private_offset;
static gpointer code_plugins_markdown_actions_parent_class = NULL;
static PeasActivatableInterface * code_plugins_markdown_actions_peas_activatable_parent_iface = NULL;
static GType code_plugins_markdown_actions_type_id = 0;

static void code_plugins_markdown_actions_real_update_state (PeasActivatable* base);
static void code_plugins_markdown_actions_real_activate (PeasActivatable* base);
static void __lambda4_ (CodePluginsMarkdownActions* self,
                 ScratchServicesDocument* doc);
static gboolean code_plugins_markdown_actions_shortcut_handler (CodePluginsMarkdownActions* self,
                                                         GdkEventKey* evt);
static gboolean _code_plugins_markdown_actions_shortcut_handler_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                     GdkEventKey* event,
                                                                                     gpointer self);
static void code_plugins_markdown_actions_configure_shortcuts (CodePluginsMarkdownActions* self);
static void _code_plugins_markdown_actions_configure_shortcuts_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void ___lambda4__scratch_services_interface_hook_document (ScratchServicesInterface* _sender,
                                                           ScratchServicesDocument* doc,
                                                           gpointer self);
static void code_plugins_markdown_actions_insert_link (CodePluginsMarkdownActions* self);
static gchar* code_plugins_markdown_actions_get_current_line (CodePluginsMarkdownActions* self,
                                                       GtkTextIter* start);
static gboolean code_plugins_markdown_actions_parse_unordered_list_item (CodePluginsMarkdownActions* self,
                                                                  const gchar* line,
                                                                  gchar* ul_marker);
static void code_plugins_markdown_actions_delete_empty_item (CodePluginsMarkdownActions* self);
static gboolean code_plugins_markdown_actions_parse_ordered_list_item (CodePluginsMarkdownActions* self,
                                                                const gchar* line,
                                                                gint* current_number,
                                                                gchar** item_text);
static void code_plugins_markdown_actions_fix_ordered_list_numbering (CodePluginsMarkdownActions* self);
static void code_plugins_markdown_actions_insert_around_selection (CodePluginsMarkdownActions* self,
                                                            const gchar* before,
                                                            const gchar* after);
static void code_plugins_markdown_actions_go_back_n_chars (CodePluginsMarkdownActions* self,
                                                    gint back_chars);
static void code_plugins_markdown_actions_real_deactivate (PeasActivatable* base);
static void code_plugins_markdown_actions_finalize (GObject * obj);
static void _vala_code_plugins_markdown_actions_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_code_plugins_markdown_actions_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
code_plugins_markdown_actions_get_instance_private (CodePluginsMarkdownActions* self)
{
	return G_STRUCT_MEMBER_P (self, CodePluginsMarkdownActions_private_offset);
}

static void
code_plugins_markdown_actions_real_update_state (PeasActivatable* base)
{
	CodePluginsMarkdownActions * self;
	self = (CodePluginsMarkdownActions*) base;
}

static gboolean
_code_plugins_markdown_actions_shortcut_handler_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                            GdkEventKey* event,
                                                                            gpointer self)
{
	gboolean result;
	result = code_plugins_markdown_actions_shortcut_handler ((CodePluginsMarkdownActions*) self, event);
	return result;
}

static void
_code_plugins_markdown_actions_configure_shortcuts_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	code_plugins_markdown_actions_configure_shortcuts ((CodePluginsMarkdownActions*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda4_ (CodePluginsMarkdownActions* self,
            ScratchServicesDocument* doc)
{
	ScratchWidgetsSourceView* _tmp0_;
	ScratchWidgetsSourceView* _tmp6_;
	ScratchWidgetsSourceView* _tmp7_;
	ScratchWidgetsSourceView* _tmp8_;
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->priv->current_source;
	if (_tmp0_ != NULL) {
		ScratchWidgetsSourceView* _tmp1_;
		guint _tmp2_;
		ScratchWidgetsSourceView* _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
		_tmp1_ = self->priv->current_source;
		g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _code_plugins_markdown_actions_shortcut_handler_gtk_widget_key_press_event, self);
		_tmp3_ = self->priv->current_source;
		g_signal_parse_name ("notify::language", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _code_plugins_markdown_actions_configure_shortcuts_g_object_notify, self);
	}
	_tmp6_ = doc->source_view;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->current_source);
	self->priv->current_source = _tmp7_;
	code_plugins_markdown_actions_configure_shortcuts (self);
	_tmp8_ = self->priv->current_source;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::language", (GCallback) _code_plugins_markdown_actions_configure_shortcuts_g_object_notify, self, 0);
}

static void
___lambda4__scratch_services_interface_hook_document (ScratchServicesInterface* _sender,
                                                      ScratchServicesDocument* doc,
                                                      gpointer self)
{
	__lambda4_ ((CodePluginsMarkdownActions*) self, doc);
}

static void
code_plugins_markdown_actions_real_activate (PeasActivatable* base)
{
	CodePluginsMarkdownActions * self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ScratchServicesInterface* _tmp2_;
	self = (CodePluginsMarkdownActions*) base;
	g_object_get ((PeasActivatable*) self, "object", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->plugins);
	self->priv->plugins = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	_tmp2_ = self->priv->plugins;
	g_signal_connect_object (_tmp2_, "hook-document", (GCallback) ___lambda4__scratch_services_interface_hook_document, self, 0);
}

static void
code_plugins_markdown_actions_configure_shortcuts (CodePluginsMarkdownActions* self)
{
	GtkSourceLanguage* lang = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkSourceLanguage* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	GtkSourceLanguage* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GtkSourceLanguage* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = scratch_widgets_source_view_get_language (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	lang = _tmp3_;
	_tmp5_ = lang;
	if (_tmp5_ != NULL) {
		GtkSourceLanguage* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = lang;
		_tmp7_ = gtk_source_language_get_id (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = g_strcmp0 (_tmp8_, "markdown") == 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ScratchWidgetsSourceView* _tmp9_;
		_tmp9_ = self->priv->current_source;
		g_signal_connect_object ((GtkWidget*) _tmp9_, "key-press-event", (GCallback) _code_plugins_markdown_actions_shortcut_handler_gtk_widget_key_press_event, self, 0);
	} else {
		ScratchWidgetsSourceView* _tmp10_;
		guint _tmp11_;
		_tmp10_ = self->priv->current_source;
		g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp11_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) _code_plugins_markdown_actions_shortcut_handler_gtk_widget_key_press_event, self);
	}
	_g_object_unref0 (lang);
}

static gboolean
code_plugins_markdown_actions_shortcut_handler (CodePluginsMarkdownActions* self,
                                                GdkEventKey* evt)
{
	gboolean control = FALSE;
	gboolean shift = FALSE;
	gboolean other_mods = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	control = (evt->state & GDK_CONTROL_MASK) != 0;
	shift = (evt->state & GDK_SHIFT_MASK) != 0;
	other_mods = (((evt->state & gtk_accelerator_get_default_mod_mask ()) & (~GDK_SHIFT_MASK)) & (~GDK_CONTROL_MASK)) != 0;
	if (evt->is_modifier == ((guint) 1)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = other_mods == TRUE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	if (control) {
		_tmp1_ = shift;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		switch (evt->keyval) {
			case GDK_KEY_B:
			{
				code_plugins_markdown_actions_add_markdown_tag (self, "**");
				result = TRUE;
				return result;
			}
			case GDK_KEY_I:
			{
				code_plugins_markdown_actions_add_markdown_tag (self, "_");
				result = TRUE;
				return result;
			}
			case GDK_KEY_K:
			{
				code_plugins_markdown_actions_insert_link (self);
				break;
			}
			default:
			break;
		}
	}
	if (evt->keyval == GDK_KEY_Return) {
		gchar ul_marker = '\0';
		gint ol_number = 0;
		gchar* item_text = NULL;
		gchar* line = NULL;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar _tmp4_ = '\0';
		gboolean _tmp5_;
		ol_number = 1;
		_tmp2_ = code_plugins_markdown_actions_get_current_line (self, NULL);
		line = _tmp2_;
		_tmp3_ = line;
		_tmp5_ = code_plugins_markdown_actions_parse_unordered_list_item (self, _tmp3_, &_tmp4_);
		ul_marker = _tmp4_;
		if (_tmp5_) {
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp6_ = line;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ <= 3) {
				code_plugins_markdown_actions_delete_empty_item (self);
			} else {
				gchar* to_insert = NULL;
				gchar* _tmp9_;
				ScratchWidgetsSourceView* _tmp10_;
				GtkTextBuffer* _tmp11_;
				GtkTextBuffer* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				_tmp9_ = g_strdup_printf ("\n%c ", (gint) ul_marker);
				to_insert = _tmp9_;
				_tmp10_ = self->priv->current_source;
				_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = to_insert;
				_tmp14_ = to_insert;
				_tmp15_ = strlen (_tmp14_);
				_tmp16_ = _tmp15_;
				gtk_text_buffer_insert_at_cursor (_tmp12_, _tmp13_, _tmp16_);
				_g_free0 (to_insert);
			}
			result = TRUE;
			_g_free0 (line);
			_g_free0 (item_text);
			return result;
		} else {
			const gchar* _tmp17_;
			gchar* _tmp18_ = NULL;
			gboolean _tmp19_;
			_tmp17_ = line;
			_tmp19_ = code_plugins_markdown_actions_parse_ordered_list_item (self, _tmp17_, &ol_number, &_tmp18_);
			_g_free0 (item_text);
			item_text = _tmp18_;
			if (_tmp19_) {
				const gchar* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				_tmp20_ = item_text;
				_tmp21_ = strlen (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ == 0) {
					code_plugins_markdown_actions_delete_empty_item (self);
				} else {
					gchar* to_insert = NULL;
					gchar* _tmp23_;
					ScratchWidgetsSourceView* _tmp24_;
					GtkTextBuffer* _tmp25_;
					GtkTextBuffer* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					_tmp23_ = g_strdup_printf ("\n%d. ", ol_number + 1);
					to_insert = _tmp23_;
					_tmp24_ = self->priv->current_source;
					_tmp25_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = to_insert;
					_tmp28_ = to_insert;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					gtk_text_buffer_insert_at_cursor (_tmp26_, _tmp27_, _tmp30_);
					code_plugins_markdown_actions_fix_ordered_list_numbering (self);
					_g_free0 (to_insert);
				}
				result = TRUE;
				_g_free0 (line);
				_g_free0 (item_text);
				return result;
			}
		}
		_g_free0 (line);
		_g_free0 (item_text);
	}
	result = FALSE;
	return result;
}

static void
code_plugins_markdown_actions_delete_empty_item (CodePluginsMarkdownActions* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* current_buffer = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_buffer = _tmp3_;
	g_object_get (current_buffer, "cursor-position", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_iter_at_offset (current_buffer, &_tmp6_, _tmp5_);
	start = _tmp6_;
	gtk_text_iter_backward_chars (&start, gtk_text_iter_get_line_offset (&start));
	_tmp7_ = start;
	end = _tmp7_;
	gtk_text_iter_forward_to_line_end (&end);
	gtk_text_buffer_delete (current_buffer, &start, &end);
	gtk_text_buffer_insert_at_cursor (current_buffer, "\n", 1);
	_g_object_unref0 (current_buffer);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
code_plugins_markdown_actions_fix_ordered_list_numbering (CodePluginsMarkdownActions* self)
{
	GtkTextIter next = {0};
	GtkTextBuffer* current_buffer = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gint count = 0;
	gchar* item_text = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_buffer = _tmp3_;
	_tmp4_ = current_buffer;
	_tmp5_ = current_buffer;
	g_object_get (_tmp5_, "cursor-position", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	gtk_text_buffer_get_iter_at_offset (_tmp4_, &_tmp8_, _tmp7_);
	next = _tmp8_;
	_tmp9_ = next;
	_tmp10_ = code_plugins_markdown_actions_get_current_line (self, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_strip (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	line = _tmp13_;
	count = 1;
	_tmp14_ = line;
	code_plugins_markdown_actions_parse_ordered_list_item (self, _tmp14_, &count, &_tmp15_);
	_g_free0 (item_text);
	item_text = _tmp15_;
	while (TRUE) {
		gint _tmp16_;
		GtkTextIter _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		GtkTextMark* next_mark = NULL;
		GtkTextBuffer* _tmp24_;
		GtkTextIter _tmp25_;
		GtkTextMark* _tmp26_;
		GtkTextMark* _tmp27_;
		gint point_offset = 0;
		const gchar* _tmp28_;
		GtkTextIter start = {0};
		GtkTextIter _tmp29_;
		GtkTextIter end = {0};
		GtkTextIter _tmp30_;
		GtkTextBuffer* _tmp31_;
		GtkTextBuffer* _tmp32_;
		GtkTextMark* _tmp33_;
		GtkTextIter _tmp34_ = {0};
		gchar* to_insert = NULL;
		gchar* _tmp35_;
		GtkTextBuffer* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		if (!gtk_text_iter_forward_line (&next)) {
			break;
		}
		_tmp16_ = count;
		count = _tmp16_ + 1;
		_tmp17_ = next;
		_tmp18_ = code_plugins_markdown_actions_get_current_line (self, &_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = string_strip (_tmp19_);
		_g_free0 (line);
		line = _tmp20_;
		_g_free0 (_tmp19_);
		_tmp21_ = line;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == 0) {
			break;
		}
		_tmp24_ = current_buffer;
		_tmp25_ = next;
		_tmp26_ = gtk_text_buffer_create_mark (_tmp24_, NULL, &_tmp25_, TRUE);
		_tmp27_ = _g_object_ref0 (_tmp26_);
		next_mark = _tmp27_;
		_tmp28_ = line;
		point_offset = string_index_of_char (_tmp28_, (gunichar) '.', 0);
		_tmp29_ = next;
		start = _tmp29_;
		_tmp30_ = start;
		end = _tmp30_;
		gtk_text_iter_forward_chars (&end, point_offset);
		_tmp31_ = current_buffer;
		gtk_text_buffer_delete (_tmp31_, &start, &end);
		_tmp32_ = current_buffer;
		_tmp33_ = next_mark;
		gtk_text_buffer_get_iter_at_mark (_tmp32_, &_tmp34_, _tmp33_);
		next = _tmp34_;
		_tmp35_ = g_strdup_printf ("%d", count);
		to_insert = _tmp35_;
		_tmp36_ = current_buffer;
		_tmp37_ = to_insert;
		_tmp38_ = to_insert;
		_tmp39_ = strlen (_tmp38_);
		_tmp40_ = _tmp39_;
		gtk_text_buffer_insert (_tmp36_, &next, _tmp37_, _tmp40_);
		_g_free0 (to_insert);
		_g_object_unref0 (next_mark);
	}
	_g_free0 (item_text);
	_g_free0 (line);
	_g_object_unref0 (current_buffer);
}

static gchar*
code_plugins_markdown_actions_get_current_line (CodePluginsMarkdownActions* self,
                                                GtkTextIter* start)
{
	GtkTextBuffer* current_buffer = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextIter _tmp12_;
	gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_buffer = _tmp3_;
	if (start == NULL) {
		GtkTextBuffer* _tmp4_;
		GtkTextBuffer* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GtkTextIter _tmp8_ = {0};
		GtkTextIter _tmp9_;
		_tmp4_ = current_buffer;
		_tmp5_ = current_buffer;
		g_object_get (_tmp5_, "cursor-position", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		gtk_text_buffer_get_iter_at_offset (_tmp4_, &_tmp8_, _tmp7_);
		_tmp9_ = _tmp8_;
		start = &_tmp9_;
	}
	gtk_text_iter_backward_chars (start, gtk_text_iter_get_line_offset (start));
	end = *start;
	gtk_text_iter_forward_to_line_end (&end);
	_tmp10_ = current_buffer;
	_tmp11_ = end;
	_tmp12_ = *start;
	_tmp13_ = gtk_text_buffer_get_text (_tmp10_, &_tmp12_, &_tmp11_, FALSE);
	result = _tmp13_;
	_g_object_unref0 (current_buffer);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
int_try_parse (const gchar* str,
               gint* _result_,
               const gchar** unparsed,
               guint _base)
{
	gint _vala__result_ = 0;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	glong long_result = 0L;
	gchar* _tmp0_ = NULL;
	glong _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	glong _tmp6_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = strtol (str, &_tmp0_, (gint) _base);
	endptr = _tmp0_;
	long_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
	}
	_tmp6_ = long_result;
	if ((((glong) G_MININT) <= _tmp6_) && (_tmp6_ <= ((glong) G_MAXINT))) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_vala__result_ = (gint) long_result;
		if (errno != ERANGE) {
			_tmp8_ = errno != EINVAL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = _vala_unparsed;
			_tmp10_ = endptr;
			_tmp7_ = _tmp9_ != _tmp10_;
		} else {
			_tmp7_ = FALSE;
		}
		result = _tmp7_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		_vala__result_ = G_MAXINT;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
code_plugins_markdown_actions_parse_ordered_list_item (CodePluginsMarkdownActions* self,
                                                       const gchar* line,
                                                       gint* current_number,
                                                       gchar** item_text)
{
	gchar* _vala_item_text = NULL;
	gchar* _tmp0_;
	gint first_point_character = 0;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* line_start = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_item_text);
	_vala_item_text = _tmp0_;
	first_point_character = string_index_of_char (line, (gunichar) '.', 0);
	if (first_point_character < 0) {
		result = FALSE;
		if (item_text) {
			*item_text = _vala_item_text;
		} else {
			_g_free0 (_vala_item_text);
		}
		return result;
	}
	_tmp1_ = string_substring (line, (glong) (first_point_character + 1), (glong) -1);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_strip (_tmp2_);
	_g_free0 (_vala_item_text);
	_vala_item_text = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = string_substring (line, (glong) 0, (glong) first_point_character);
	line_start = _tmp4_;
	_tmp5_ = line_start;
	_tmp7_ = int_try_parse (_tmp5_, &_tmp6_, NULL, (guint) 0);
	*current_number = _tmp6_;
	if (!_tmp7_) {
		result = FALSE;
		_g_free0 (line_start);
		if (item_text) {
			*item_text = _vala_item_text;
		} else {
			_g_free0 (_vala_item_text);
		}
		return result;
	}
	result = TRUE;
	_g_free0 (line_start);
	if (item_text) {
		*item_text = _vala_item_text;
	} else {
		_g_free0 (_vala_item_text);
	}
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
code_plugins_markdown_actions_parse_unordered_list_item (CodePluginsMarkdownActions* self,
                                                         const gchar* line,
                                                         gchar* ul_marker)
{
	gchar _vala_ul_marker = '\0';
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (string_get (line, (glong) 0) == '*') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = string_get (line, (glong) 0) == '-';
	}
	if (_tmp1_) {
		_tmp0_ = string_get (line, (glong) 1) == ' ';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_vala_ul_marker = string_get (line, (glong) 0);
		result = TRUE;
		if (ul_marker) {
			*ul_marker = _vala_ul_marker;
		}
		return result;
	}
	_vala_ul_marker = '\0';
	result = FALSE;
	if (ul_marker) {
		*ul_marker = _vala_ul_marker;
	}
	return result;
}

static void
code_plugins_markdown_actions_insert_link (CodePluginsMarkdownActions* self)
{
	GtkTextBuffer* current_buffer = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GtkTextBuffer* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_buffer = _tmp3_;
	_tmp4_ = current_buffer;
	gtk_text_buffer_begin_user_action (_tmp4_);
	_tmp5_ = current_buffer;
	_tmp6_ = gtk_text_buffer_get_has_selection (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		GtkTextBuffer* _tmp8_;
		code_plugins_markdown_actions_insert_around_selection (self, "[", "]");
		_tmp8_ = current_buffer;
		gtk_text_buffer_insert_at_cursor (_tmp8_, "()", 2);
		code_plugins_markdown_actions_go_back_n_chars (self, 1);
	} else {
		GtkTextBuffer* _tmp9_;
		GtkTextBuffer* _tmp10_;
		_tmp9_ = current_buffer;
		gtk_text_buffer_insert_at_cursor (_tmp9_, "[]", 2);
		_tmp10_ = current_buffer;
		gtk_text_buffer_insert_at_cursor (_tmp10_, "()", 2);
		code_plugins_markdown_actions_go_back_n_chars (self, 3);
	}
	_tmp11_ = current_buffer;
	gtk_text_buffer_end_user_action (_tmp11_);
	_g_object_unref0 (current_buffer);
}

static void
code_plugins_markdown_actions_go_back_n_chars (CodePluginsMarkdownActions* self,
                                               gint back_chars)
{
	GtkTextIter insert_position = {0};
	GtkTextBuffer* current_buffer = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_buffer = _tmp3_;
	g_object_get (current_buffer, "cursor-position", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_get_iter_at_offset (current_buffer, &_tmp6_, _tmp5_ - back_chars);
	insert_position = _tmp6_;
	_tmp7_ = insert_position;
	gtk_text_buffer_place_cursor (current_buffer, &_tmp7_);
	_g_object_unref0 (current_buffer);
}

static void
code_plugins_markdown_actions_insert_around_selection (CodePluginsMarkdownActions* self,
                                                       const gchar* before,
                                                       const gchar* after)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* current_buffer = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextMark* mark_end = NULL;
	GtkTextMark* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GtkTextIter _tmp11_ = {0};
	GtkTextIter _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (before != NULL);
	g_return_if_fail (after != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_buffer = _tmp3_;
	gtk_text_buffer_get_selection_bounds (current_buffer, &_tmp4_, &_tmp5_);
	start = _tmp4_;
	end = _tmp5_;
	_tmp6_ = gtk_text_mark_new (NULL, FALSE);
	mark_end = _tmp6_;
	_tmp7_ = end;
	gtk_text_buffer_add_mark (current_buffer, mark_end, &_tmp7_);
	_tmp8_ = start;
	gtk_text_buffer_place_cursor (current_buffer, &_tmp8_);
	_tmp9_ = strlen (before);
	_tmp10_ = _tmp9_;
	gtk_text_buffer_insert_at_cursor (current_buffer, before, _tmp10_);
	gtk_text_buffer_get_iter_at_mark (current_buffer, &_tmp11_, mark_end);
	end = _tmp11_;
	_tmp12_ = end;
	gtk_text_buffer_place_cursor (current_buffer, &_tmp12_);
	_tmp13_ = strlen (after);
	_tmp14_ = _tmp13_;
	gtk_text_buffer_insert_at_cursor (current_buffer, after, _tmp14_);
	_g_object_unref0 (mark_end);
	_g_object_unref0 (current_buffer);
}

void
code_plugins_markdown_actions_add_markdown_tag (CodePluginsMarkdownActions* self,
                                                const gchar* tag)
{
	GtkTextBuffer* current_buffer = NULL;
	ScratchWidgetsSourceView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextBuffer* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GtkTextBuffer* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	current_buffer = _tmp3_;
	_tmp4_ = current_buffer;
	gtk_text_buffer_begin_user_action (_tmp4_);
	_tmp5_ = current_buffer;
	_tmp6_ = gtk_text_buffer_get_has_selection (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		code_plugins_markdown_actions_insert_around_selection (self, tag, tag);
	} else {
		GtkTextBuffer* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		GtkTextBuffer* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp8_ = current_buffer;
		_tmp9_ = strlen (tag);
		_tmp10_ = _tmp9_;
		gtk_text_buffer_insert_at_cursor (_tmp8_, tag, _tmp10_);
		_tmp11_ = current_buffer;
		_tmp12_ = strlen (tag);
		_tmp13_ = _tmp12_;
		gtk_text_buffer_insert_at_cursor (_tmp11_, tag, _tmp13_);
	}
	_tmp14_ = current_buffer;
	gtk_text_buffer_end_user_action (_tmp14_);
	_tmp15_ = strlen (tag);
	_tmp16_ = _tmp15_;
	code_plugins_markdown_actions_go_back_n_chars (self, _tmp16_);
	_g_object_unref0 (current_buffer);
}

static void
code_plugins_markdown_actions_real_deactivate (PeasActivatable* base)
{
	CodePluginsMarkdownActions * self;
	ScratchWidgetsSourceView* _tmp0_;
	self = (CodePluginsMarkdownActions*) base;
	_tmp0_ = self->priv->current_source;
	if (_tmp0_ != NULL) {
		ScratchWidgetsSourceView* _tmp1_;
		guint _tmp2_;
		ScratchWidgetsSourceView* _tmp3_;
		guint _tmp4_;
		GQuark _tmp5_;
		_tmp1_ = self->priv->current_source;
		g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _code_plugins_markdown_actions_shortcut_handler_gtk_widget_key_press_event, self);
		_tmp3_ = self->priv->current_source;
		g_signal_parse_name ("notify::language", G_TYPE_OBJECT, &_tmp4_, &_tmp5_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, _tmp5_, NULL, (GCallback) _code_plugins_markdown_actions_configure_shortcuts_g_object_notify, self);
	}
}

CodePluginsMarkdownActions*
code_plugins_markdown_actions_construct (GType object_type)
{
	CodePluginsMarkdownActions * self = NULL;
	self = (CodePluginsMarkdownActions*) g_object_new (object_type, NULL);
	return self;
}

CodePluginsMarkdownActions*
code_plugins_markdown_actions_new (void)
{
	return code_plugins_markdown_actions_construct (CODE_PLUGINS_TYPE_MARKDOWN_ACTIONS);
}

static GObject*
code_plugins_markdown_actions_real_get_object (PeasActivatable* base)
{
	GObject* result;
	CodePluginsMarkdownActions* self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	self = (CodePluginsMarkdownActions*) base;
	_tmp0_ = self->priv->_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
code_plugins_markdown_actions_real_set_object (PeasActivatable* base,
                                               GObject* value)
{
	CodePluginsMarkdownActions* self;
	GObject* old_value;
	self = (CodePluginsMarkdownActions*) base;
	old_value = code_plugins_markdown_actions_real_get_object (base);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_object);
		self->priv->_object = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, code_plugins_markdown_actions_properties[CODE_PLUGINS_MARKDOWN_ACTIONS_OBJECT_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static void
code_plugins_markdown_actions_class_init (CodePluginsMarkdownActionsClass * klass,
                                          gpointer klass_data)
{
	code_plugins_markdown_actions_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CodePluginsMarkdownActions_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_code_plugins_markdown_actions_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_code_plugins_markdown_actions_set_property;
	G_OBJECT_CLASS (klass)->finalize = code_plugins_markdown_actions_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CODE_PLUGINS_MARKDOWN_ACTIONS_OBJECT_PROPERTY, code_plugins_markdown_actions_properties[CODE_PLUGINS_MARKDOWN_ACTIONS_OBJECT_PROPERTY] = g_param_spec_object ("object", "object", "object", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
code_plugins_markdown_actions_peas_activatable_interface_init (PeasActivatableInterface * iface,
                                                               gpointer iface_data)
{
	code_plugins_markdown_actions_peas_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_state = (void (*) (PeasActivatable*)) code_plugins_markdown_actions_real_update_state;
	iface->activate = (void (*) (PeasActivatable*)) code_plugins_markdown_actions_real_activate;
	iface->deactivate = (void (*) (PeasActivatable*)) code_plugins_markdown_actions_real_deactivate;
}

static void
code_plugins_markdown_actions_instance_init (CodePluginsMarkdownActions * self,
                                             gpointer klass)
{
	self->priv = code_plugins_markdown_actions_get_instance_private (self);
}

static void
code_plugins_markdown_actions_finalize (GObject * obj)
{
	CodePluginsMarkdownActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CODE_PLUGINS_TYPE_MARKDOWN_ACTIONS, CodePluginsMarkdownActions);
	_g_object_unref0 (self->priv->current_source);
	_g_object_unref0 (self->priv->plugins);
	_g_object_unref0 (self->priv->_object);
	G_OBJECT_CLASS (code_plugins_markdown_actions_parent_class)->finalize (obj);
}

/***
  BEGIN LICENSE

  Copyright (C) 2020 Igor Montagner <igordsm@gmail.com>
  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU Lesser General Public License version 3, as published
  by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranties of
  MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
  PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program.  If not, see <http://www.gnu.org/licenses/>

  END LICENSE
***/
GType
code_plugins_markdown_actions_get_type (void)
{
	return code_plugins_markdown_actions_type_id;
}

GType
code_plugins_markdown_actions_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (CodePluginsMarkdownActionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) code_plugins_markdown_actions_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CodePluginsMarkdownActions), 0, (GInstanceInitFunc) code_plugins_markdown_actions_instance_init, NULL };
	static const GInterfaceInfo peas_activatable_info = { (GInterfaceInitFunc) code_plugins_markdown_actions_peas_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	code_plugins_markdown_actions_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "CodePluginsMarkdownActions", &g_define_type_info, 0);
	g_type_module_add_interface (module, code_plugins_markdown_actions_type_id, peas_activatable_get_type (), &peas_activatable_info);
	CodePluginsMarkdownActions_private_offset = sizeof (CodePluginsMarkdownActionsPrivate);
	return code_plugins_markdown_actions_type_id;
}

static void
_vala_code_plugins_markdown_actions_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	CodePluginsMarkdownActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_PLUGINS_TYPE_MARKDOWN_ACTIONS, CodePluginsMarkdownActions);
	switch (property_id) {
		case CODE_PLUGINS_MARKDOWN_ACTIONS_OBJECT_PROPERTY:
		g_value_take_object (value, code_plugins_markdown_actions_real_get_object ((PeasActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_code_plugins_markdown_actions_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	CodePluginsMarkdownActions * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CODE_PLUGINS_TYPE_MARKDOWN_ACTIONS, CodePluginsMarkdownActions);
	switch (property_id) {
		case CODE_PLUGINS_MARKDOWN_ACTIONS_OBJECT_PROPERTY:
		code_plugins_markdown_actions_real_set_object ((PeasActivatable*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	code_plugins_markdown_actions_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, peas_activatable_get_type (), CODE_PLUGINS_TYPE_MARKDOWN_ACTIONS);
	_g_object_unref0 (objmodule);
}

