/* fuzzy-search.c generated by valac 0.56.14, the Vala compiler
 * generated from fuzzy-search.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. <https://elementary.io>
 *
 * Authored by: Marvin Ahlgrimm
 */

#include "fuzzy-search.h"
#include <glib-object.h>
#include "codecore.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <libpeas/peas.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#define SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_KEY GDK_KEY_F
#define SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_MODTYPE GDK_MOD1_MASK

enum  {
	SCRATCH_PLUGINS_FUZZY_SEARCH_0_PROPERTY,
	SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY,
	SCRATCH_PLUGINS_FUZZY_SEARCH_NUM_PROPERTIES
};
static GParamSpec* scratch_plugins_fuzzy_search_properties[SCRATCH_PLUGINS_FUZZY_SEARCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _ScratchPluginsFuzzySearchPrivate {
	GObject* _object;
	ScratchServicesFuzzySearchIndexer* indexer;
	ScratchMainWindow* window;
	ScratchServicesInterface* plugins;
	GtkEventControllerKey* key_controller;
	GtkMenuItem* fuzzy_menuitem;
	GCancellable* cancellable;
};

struct _Block1Data {
	int _ref_count_;
	ScratchPluginsFuzzySearch* self;
	ScratchFuzzySearchPopover* popover;
};

static gint ScratchPluginsFuzzySearch_private_offset;
static gpointer scratch_plugins_fuzzy_search_parent_class = NULL;
static PeasActivatableInterface * scratch_plugins_fuzzy_search_peas_activatable_parent_iface = NULL;
static GType scratch_plugins_fuzzy_search_type_id = 0;

static void scratch_plugins_fuzzy_search_real_update_state (PeasActivatable* base);
static void scratch_plugins_fuzzy_search_real_activate (PeasActivatable* base);
static void __lambda17_ (ScratchPluginsFuzzySearch* self,
                  ScratchMainWindow* w);
static void __lambda18_ (ScratchPluginsFuzzySearch* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda18__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean scratch_plugins_fuzzy_search_on_window_key_press_event (ScratchPluginsFuzzySearch* self,
                                                                 guint keyval,
                                                                 guint keycode,
                                                                 GdkModifierType state);
static gboolean _scratch_plugins_fuzzy_search_on_window_key_press_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                                       guint keyval,
                                                                                                       guint keycode,
                                                                                                       GdkModifierType state,
                                                                                                       gpointer self);
static void scratch_plugins_fuzzy_search_fuzzy_find (ScratchPluginsFuzzySearch* self);
static void _scratch_plugins_fuzzy_search_fuzzy_find_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                      gpointer self);
static void ___lambda17__scratch_services_interface_hook_window (ScratchServicesInterface* _sender,
                                                          ScratchMainWindow* window,
                                                          gpointer self);
static void __lambda29_ (ScratchPluginsFuzzySearch* self,
                  GFile* src,
                  GFile* dest,
                  GFileMonitorEvent event);
static void ___lambda29__scratch_services_interface_hook_folder_item_change (ScratchServicesInterface* _sender,
                                                                      GFile* file,
                                                                      GFile* other_file,
                                                                      GFileMonitorEvent event_type,
                                                                      gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda27_ (Block1Data* _data1_,
                  const gchar* filepath);
static void ___lambda27__scratch_fuzzy_search_popover_open_file (ScratchFuzzySearchPopover* _sender,
                                                          const gchar* filepath,
                                                          gpointer self);
static void __lambda28_ (Block1Data* _data1_);
static void ___lambda28__scratch_fuzzy_search_popover_close_search (ScratchFuzzySearchPopover* _sender,
                                                             gpointer self);
static void scratch_plugins_fuzzy_search_real_deactivate (PeasActivatable* base);
static void scratch_plugins_fuzzy_search_finalize (GObject * obj);
static void _vala_scratch_plugins_fuzzy_search_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_scratch_plugins_fuzzy_search_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
GType scratch_services_fuzzy_finder_register_type (GTypeModule * module);
GType scratch_services_fuzzy_finder_recursive_finder_register_type (GTypeModule * module);
GType scratch_services_fuzzy_search_indexer_register_type (GTypeModule * module);
GType scratch_services_search_project_register_type (GTypeModule * module);
GType scratch_fuzzy_search_popover_register_type (GTypeModule * module);
GType file_item_register_type (GTypeModule * module);
GType indexer_message_register_type (GTypeModule * module);
GType initial_index_request_register_type (GTypeModule * module);
GType project_update_register_type (GTypeModule * module);
GType search_result_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
scratch_plugins_fuzzy_search_get_instance_private (ScratchPluginsFuzzySearch* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchPluginsFuzzySearch_private_offset);
}

static void
scratch_plugins_fuzzy_search_real_update_state (PeasActivatable* base)
{
	ScratchPluginsFuzzySearch * self;
	self = (ScratchPluginsFuzzySearch*) base;
}

static void
__lambda18_ (ScratchPluginsFuzzySearch* self,
             GObject* obj,
             GAsyncResult* res)
{
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	g_return_if_fail (res != NULL);
	_tmp0_ = self->priv->indexer;
	scratch_services_fuzzy_search_indexer_start_finish (_tmp0_, res);
}

static void
___lambda18__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda18_ ((ScratchPluginsFuzzySearch*) self, source_object, res);
	g_object_unref (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_scratch_plugins_fuzzy_search_on_window_key_press_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                              guint keyval,
                                                                                              guint keycode,
                                                                                              GdkModifierType state,
                                                                                              gpointer self)
{
	gboolean result;
	result = scratch_plugins_fuzzy_search_on_window_key_press_event ((ScratchPluginsFuzzySearch*) self, keyval, keycode, state);
	return result;
}

static void
_scratch_plugins_fuzzy_search_fuzzy_find_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                 gpointer self)
{
	scratch_plugins_fuzzy_search_fuzzy_find ((ScratchPluginsFuzzySearch*) self);
}

static void
__lambda17_ (ScratchPluginsFuzzySearch* self,
             ScratchMainWindow* w)
{
	ScratchMainWindow* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	ScratchServicesFuzzySearchIndexer* _tmp3_;
	ScratchServicesFuzzySearchIndexer* _tmp4_;
	ScratchMainWindow* _tmp5_;
	ScratchMainWindow* _tmp6_;
	GtkEventControllerKey* _tmp7_ = NULL;
	GtkEventControllerKey* _tmp8_;
	GtkMenuItem* _tmp9_;
	GtkWidget* child = NULL;
	GtkMenuItem* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkMenuItem* _tmp15_;
	GtkMenuItem* _tmp16_;
	ScratchMainWindow* _tmp17_;
	CodeSidebar* _tmp18_;
	GtkMenu* _tmp19_;
	GtkMenu* _tmp20_;
	GtkMenuItem* _tmp21_;
	g_return_if_fail (w != NULL);
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp1_;
	_tmp2_ = self->priv->cancellable;
	_tmp3_ = scratch_services_fuzzy_search_indexer_new (_tmp2_);
	_g_object_unref0 (self->priv->indexer);
	self->priv->indexer = _tmp3_;
	_tmp4_ = self->priv->indexer;
	scratch_services_fuzzy_search_indexer_start_async (_tmp4_, ___lambda18__gasync_ready_callback, g_object_ref (self));
	_tmp5_ = _g_object_ref0 (w);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp5_;
	_tmp6_ = self->priv->window;
	_tmp7_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) _tmp6_);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp7_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp7_;
	_tmp8_ = self->priv->key_controller;
	g_signal_connect_object (_tmp8_, "key-pressed", (GCallback) _scratch_plugins_fuzzy_search_on_window_key_press_event_gtk_event_controller_key_key_pressed, self, 0);
	_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Find Project Files"));
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->fuzzy_menuitem);
	self->priv->fuzzy_menuitem = _tmp9_;
	_tmp10_ = self->priv->fuzzy_menuitem;
	_tmp11_ = gtk_bin_get_child (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_bin_get_type (), GtkBin));
	_tmp12_ = _g_object_ref0 (_tmp11_);
	child = _tmp12_;
	_tmp13_ = child;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, gtk_accel_label_get_type ())) {
		GtkWidget* _tmp14_;
		_tmp14_ = child;
		gtk_accel_label_set_accel (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_accel_label_get_type (), GtkAccelLabel), SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_KEY, SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_MODTYPE);
	}
	_tmp15_ = self->priv->fuzzy_menuitem;
	g_signal_connect_object (_tmp15_, "activate", (GCallback) _scratch_plugins_fuzzy_search_fuzzy_find_gtk_menu_item_activate, self, 0);
	_tmp16_ = self->priv->fuzzy_menuitem;
	gtk_widget_show ((GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->window;
	_tmp18_ = _tmp17_->sidebar;
	_tmp19_ = code_sidebar_get_project_menu (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = self->priv->fuzzy_menuitem;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp20_, _tmp21_);
	_g_object_unref0 (child);
}

static void
___lambda17__scratch_services_interface_hook_window (ScratchServicesInterface* _sender,
                                                     ScratchMainWindow* window,
                                                     gpointer self)
{
	__lambda17_ ((ScratchPluginsFuzzySearch*) self, window);
}

static void
__lambda29_ (ScratchPluginsFuzzySearch* self,
             GFile* src,
             GFile* dest,
             GFileMonitorEvent event)
{
	ScratchServicesFuzzySearchIndexer* _tmp0_;
	ScratchServicesFuzzySearchIndexer* _tmp1_;
	g_return_if_fail (src != NULL);
	_tmp0_ = self->priv->indexer;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->indexer;
	scratch_services_fuzzy_search_indexer_handle_folder_item_change (_tmp1_, src, dest, event);
}

static void
___lambda29__scratch_services_interface_hook_folder_item_change (ScratchServicesInterface* _sender,
                                                                 GFile* file,
                                                                 GFile* other_file,
                                                                 GFileMonitorEvent event_type,
                                                                 gpointer self)
{
	__lambda29_ ((ScratchPluginsFuzzySearch*) self, file, other_file, event_type);
}

static void
scratch_plugins_fuzzy_search_real_activate (PeasActivatable* base)
{
	ScratchPluginsFuzzySearch * self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	ScratchServicesInterface* _tmp2_;
	ScratchServicesInterface* _tmp3_;
	self = (ScratchPluginsFuzzySearch*) base;
	g_object_get ((PeasActivatable*) self, "object", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->plugins);
	self->priv->plugins = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, SCRATCH_SERVICES_TYPE_INTERFACE, ScratchServicesInterface);
	_tmp2_ = self->priv->plugins;
	g_signal_connect_object (_tmp2_, "hook-window", (GCallback) ___lambda17__scratch_services_interface_hook_window, self, 0);
	_tmp3_ = self->priv->plugins;
	g_signal_connect_object (_tmp3_, "hook-folder-item-change", (GCallback) ___lambda29__scratch_services_interface_hook_folder_item_change, self, 0);
}

static gboolean
scratch_plugins_fuzzy_search_on_window_key_press_event (ScratchPluginsFuzzySearch* self,
                                                        guint keyval,
                                                        guint keycode,
                                                        GdkModifierType state)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	switch (gdk_keyval_to_upper (keyval)) {
		case SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_KEY:
		{
			if (state == SCRATCH_PLUGINS_FUZZY_SEARCH_ACCEL_MODTYPE) {
				scratch_plugins_fuzzy_search_fuzzy_find (self);
				result = TRUE;
				return result;
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ScratchPluginsFuzzySearch* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->popover);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda27_ (Block1Data* _data1_,
             const gchar* filepath)
{
	ScratchPluginsFuzzySearch* self;
	ScratchFolderManagerFile* file = NULL;
	ScratchFolderManagerFile* _tmp0_;
	ScratchServicesDocument* doc = NULL;
	ScratchMainWindow* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GSimpleActionGroup* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	ScratchServicesDocument* _tmp6_;
	ScratchMainWindow* _tmp7_;
	ScratchFuzzySearchPopover* _tmp8_;
	self = _data1_->self;
	g_return_if_fail (filepath != NULL);
	_tmp0_ = scratch_folder_manager_file_new (filepath);
	file = _tmp0_;
	_tmp1_ = self->priv->window;
	_tmp2_ = scratch_main_window_get_actions (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = scratch_folder_manager_file_get_file (file);
	_tmp5_ = _tmp4_;
	_tmp6_ = scratch_services_document_new (_tmp3_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	doc = _tmp6_;
	_tmp7_ = self->priv->window;
	scratch_main_window_open_document (_tmp7_, doc, TRUE, 0);
	_tmp8_ = _data1_->popover;
	gtk_popover_popdown ((GtkPopover*) _tmp8_);
	_g_object_unref0 (doc);
	_g_object_unref0 (file);
}

static void
___lambda27__scratch_fuzzy_search_popover_open_file (ScratchFuzzySearchPopover* _sender,
                                                     const gchar* filepath,
                                                     gpointer self)
{
	__lambda27_ (self, filepath);
}

static void
__lambda28_ (Block1Data* _data1_)
{
	ScratchPluginsFuzzySearch* self;
	ScratchFuzzySearchPopover* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->popover;
	gtk_popover_popdown ((GtkPopover*) _tmp0_);
}

static void
___lambda28__scratch_fuzzy_search_popover_close_search (ScratchFuzzySearchPopover* _sender,
                                                        gpointer self)
{
	__lambda28_ (self);
}

static void
scratch_plugins_fuzzy_search_fuzzy_find (ScratchPluginsFuzzySearch* self)
{
	Block1Data* _data1_;
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gchar** opened_folders = NULL;
	GSettings* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint opened_folders_length1;
	gint _opened_folders_size_;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	ScratchServicesFuzzySearchIndexer* _tmp7_;
	ScratchMainWindow* _tmp8_;
	ScratchFuzzySearchPopover* _tmp9_;
	ScratchFuzzySearchPopover* _tmp10_;
	ScratchFuzzySearchPopover* _tmp11_;
	ScratchFuzzySearchPopover* _tmp12_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("io.elementary.code.folder-manager");
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp3_ = _tmp2_ = g_settings_get_strv (_tmp1_, "opened-folders");
	opened_folders = _tmp3_;
	opened_folders_length1 = _vala_array_length (_tmp2_);
	_opened_folders_size_ = opened_folders_length1;
	_tmp5_ = opened_folders;
	_tmp5__length1 = opened_folders_length1;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = opened_folders;
		_tmp6__length1 = opened_folders_length1;
		_tmp4_ = _tmp6__length1 < 1;
	}
	if (_tmp4_) {
		opened_folders = (_vala_array_free (opened_folders, opened_folders_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (settings);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return;
	}
	_tmp7_ = self->priv->indexer;
	_tmp8_ = self->priv->window;
	_tmp9_ = scratch_fuzzy_search_popover_new (_tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	_data1_->popover = _tmp9_;
	_tmp10_ = _data1_->popover;
	g_signal_connect_data (_tmp10_, "open-file", (GCallback) ___lambda27__scratch_fuzzy_search_popover_open_file, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp11_ = _data1_->popover;
	g_signal_connect_data (_tmp11_, "close-search", (GCallback) ___lambda28__scratch_fuzzy_search_popover_close_search, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp12_ = _data1_->popover;
	gtk_popover_popup ((GtkPopover*) _tmp12_);
	opened_folders = (_vala_array_free (opened_folders, opened_folders_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
scratch_plugins_fuzzy_search_real_deactivate (PeasActivatable* base)
{
	ScratchPluginsFuzzySearch * self;
	GtkEventControllerKey* _tmp0_;
	guint _tmp1_;
	ScratchMainWindow* _tmp2_;
	CodeSidebar* _tmp3_;
	GtkMenu* _tmp4_;
	GtkMenu* _tmp5_;
	GtkMenuItem* _tmp6_;
	GCancellable* _tmp7_;
	self = (ScratchPluginsFuzzySearch*) base;
	_tmp0_ = self->priv->key_controller;
	g_signal_parse_name ("key-pressed", gtk_event_controller_key_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _scratch_plugins_fuzzy_search_on_window_key_press_event_gtk_event_controller_key_key_pressed, self);
	_tmp2_ = self->priv->window;
	_tmp3_ = _tmp2_->sidebar;
	_tmp4_ = code_sidebar_get_project_menu (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->fuzzy_menuitem;
	gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->cancellable;
	if (_tmp7_ != NULL) {
		GCancellable* _tmp8_;
		_tmp8_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp8_);
	}
}

ScratchPluginsFuzzySearch*
scratch_plugins_fuzzy_search_construct (GType object_type)
{
	ScratchPluginsFuzzySearch * self = NULL;
	self = (ScratchPluginsFuzzySearch*) g_object_new (object_type, NULL);
	return self;
}

ScratchPluginsFuzzySearch*
scratch_plugins_fuzzy_search_new (void)
{
	return scratch_plugins_fuzzy_search_construct (SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH);
}

static GObject*
scratch_plugins_fuzzy_search_real_get_object (PeasActivatable* base)
{
	GObject* result;
	ScratchPluginsFuzzySearch* self;
	GObject* _tmp0_;
	GObject* _tmp1_;
	self = (ScratchPluginsFuzzySearch*) base;
	_tmp0_ = self->priv->_object;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
scratch_plugins_fuzzy_search_real_set_object (PeasActivatable* base,
                                              GObject* value)
{
	ScratchPluginsFuzzySearch* self;
	GObject* old_value;
	self = (ScratchPluginsFuzzySearch*) base;
	old_value = scratch_plugins_fuzzy_search_real_get_object (base);
	if (old_value != value) {
		GObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_object);
		self->priv->_object = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_plugins_fuzzy_search_properties[SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY]);
	}
	_g_object_unref0 (old_value);
}

static void
scratch_plugins_fuzzy_search_class_init (ScratchPluginsFuzzySearchClass * klass,
                                         gpointer klass_data)
{
	scratch_plugins_fuzzy_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchPluginsFuzzySearch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_plugins_fuzzy_search_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_plugins_fuzzy_search_set_property;
	G_OBJECT_CLASS (klass)->finalize = scratch_plugins_fuzzy_search_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY, scratch_plugins_fuzzy_search_properties[SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY] = g_param_spec_object ("object", "object", "object", G_TYPE_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
scratch_plugins_fuzzy_search_peas_activatable_interface_init (PeasActivatableInterface * iface,
                                                              gpointer iface_data)
{
	scratch_plugins_fuzzy_search_peas_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_state = (void (*) (PeasActivatable*)) scratch_plugins_fuzzy_search_real_update_state;
	iface->activate = (void (*) (PeasActivatable*)) scratch_plugins_fuzzy_search_real_activate;
	iface->deactivate = (void (*) (PeasActivatable*)) scratch_plugins_fuzzy_search_real_deactivate;
}

static void
scratch_plugins_fuzzy_search_instance_init (ScratchPluginsFuzzySearch * self,
                                            gpointer klass)
{
	self->priv = scratch_plugins_fuzzy_search_get_instance_private (self);
	self->priv->window = NULL;
}

static void
scratch_plugins_fuzzy_search_finalize (GObject * obj)
{
	ScratchPluginsFuzzySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH, ScratchPluginsFuzzySearch);
	_g_object_unref0 (self->priv->_object);
	_g_object_unref0 (self->priv->indexer);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->plugins);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->fuzzy_menuitem);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (scratch_plugins_fuzzy_search_parent_class)->finalize (obj);
}

GType
scratch_plugins_fuzzy_search_get_type (void)
{
	return scratch_plugins_fuzzy_search_type_id;
}

GType
scratch_plugins_fuzzy_search_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchPluginsFuzzySearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_plugins_fuzzy_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchPluginsFuzzySearch), 0, (GInstanceInitFunc) scratch_plugins_fuzzy_search_instance_init, NULL };
	static const GInterfaceInfo peas_activatable_info = { (GInterfaceInitFunc) scratch_plugins_fuzzy_search_peas_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	scratch_plugins_fuzzy_search_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "ScratchPluginsFuzzySearch", &g_define_type_info, 0);
	g_type_module_add_interface (module, scratch_plugins_fuzzy_search_type_id, peas_activatable_get_type (), &peas_activatable_info);
	ScratchPluginsFuzzySearch_private_offset = sizeof (ScratchPluginsFuzzySearchPrivate);
	return scratch_plugins_fuzzy_search_type_id;
}

static void
_vala_scratch_plugins_fuzzy_search_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchPluginsFuzzySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH, ScratchPluginsFuzzySearch);
	switch (property_id) {
		case SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY:
		g_value_take_object (value, scratch_plugins_fuzzy_search_real_get_object ((PeasActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_plugins_fuzzy_search_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	ScratchPluginsFuzzySearch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH, ScratchPluginsFuzzySearch);
	switch (property_id) {
		case SCRATCH_PLUGINS_FUZZY_SEARCH_OBJECT_PROPERTY:
		scratch_plugins_fuzzy_search_real_set_object ((PeasActivatable*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	scratch_plugins_fuzzy_search_register_type (module);
	scratch_services_fuzzy_finder_register_type (module);
	scratch_services_fuzzy_finder_recursive_finder_register_type (module);
	scratch_services_fuzzy_search_indexer_register_type (module);
	scratch_services_search_project_register_type (module);
	scratch_fuzzy_search_popover_register_type (module);
	file_item_register_type (module);
	indexer_message_register_type (module);
	initial_index_request_register_type (module);
	project_update_register_type (module);
	search_result_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, peas_activatable_get_type (), SCRATCH_PLUGINS_TYPE_FUZZY_SEARCH);
	_g_object_unref0 (objmodule);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

