/* MainWindow.c generated by valac 0.56.17, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/*
 * Copyright (c) 2011-2016 elementary LLC. (https://github.com/elementary/camera)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Marcus Wichelmann <marcus.wichelmann@hotmail.de>
 */

#include <handy.h>
#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <granite.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gst/gst.h>

#define CAMERA_MAIN_WINDOW_ACTION_PREFIX "win."
#define CAMERA_MAIN_WINDOW_ACTION_FULLSCREEN "fullscreen"
#define CAMERA_MAIN_WINDOW_ACTION_TAKE_PHOTO "take_photo"
#define CAMERA_MAIN_WINDOW_ACTION_RECORD "record"
#define CAMERA_MAIN_WINDOW_ACTION_CHANGE_CAMERA "change_camera"
#define CAMERA_MAIN_WINDOW_PHOTO_ICON_SYMBOLIC "view-list-images-symbolic"
#define CAMERA_MAIN_WINDOW_VIDEO_ICON_SYMBOLIC "view-list-video-symbolic"
#define CAMERA_MAIN_WINDOW_STOP_ICON_SYMBOLIC "media-playback-stop-symbolic"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CAMERA_TYPE_MAIN_WINDOW (camera_main_window_get_type ())
#define CAMERA_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_TYPE_MAIN_WINDOW, CameraMainWindow))
#define CAMERA_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_TYPE_MAIN_WINDOW, CameraMainWindowClass))
#define CAMERA_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_TYPE_MAIN_WINDOW))
#define CAMERA_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_TYPE_MAIN_WINDOW))
#define CAMERA_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_TYPE_MAIN_WINDOW, CameraMainWindowClass))

typedef struct _CameraMainWindow CameraMainWindow;
typedef struct _CameraMainWindowClass CameraMainWindowClass;
typedef struct _CameraMainWindowPrivate CameraMainWindowPrivate;

#define CAMERA_WIDGETS_TYPE_CAMERA_VIEW (camera_widgets_camera_view_get_type ())
#define CAMERA_WIDGETS_CAMERA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraView))
#define CAMERA_WIDGETS_CAMERA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraViewClass))
#define CAMERA_WIDGETS_IS_CAMERA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_WIDGETS_TYPE_CAMERA_VIEW))
#define CAMERA_WIDGETS_IS_CAMERA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_WIDGETS_TYPE_CAMERA_VIEW))
#define CAMERA_WIDGETS_CAMERA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_WIDGETS_TYPE_CAMERA_VIEW, CameraWidgetsCameraViewClass))

typedef struct _CameraWidgetsCameraView CameraWidgetsCameraView;
typedef struct _CameraWidgetsCameraViewClass CameraWidgetsCameraViewClass;

#define CAMERA_WIDGETS_TYPE_TIMER_BUTTON (camera_widgets_timer_button_get_type ())
#define CAMERA_WIDGETS_TIMER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_WIDGETS_TYPE_TIMER_BUTTON, CameraWidgetsTimerButton))
#define CAMERA_WIDGETS_TIMER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_WIDGETS_TYPE_TIMER_BUTTON, CameraWidgetsTimerButtonClass))
#define CAMERA_WIDGETS_IS_TIMER_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_WIDGETS_TYPE_TIMER_BUTTON))
#define CAMERA_WIDGETS_IS_TIMER_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_WIDGETS_TYPE_TIMER_BUTTON))
#define CAMERA_WIDGETS_TIMER_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_WIDGETS_TYPE_TIMER_BUTTON, CameraWidgetsTimerButtonClass))

typedef struct _CameraWidgetsTimerButton CameraWidgetsTimerButton;
typedef struct _CameraWidgetsTimerButtonClass CameraWidgetsTimerButtonClass;
enum  {
	CAMERA_MAIN_WINDOW_0_PROPERTY,
	CAMERA_MAIN_WINDOW_RECORDING_PROPERTY,
	CAMERA_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* camera_main_window_properties[CAMERA_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CAMERA_TYPE_APPLICATION (camera_application_get_type ())
#define CAMERA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CAMERA_TYPE_APPLICATION, CameraApplication))
#define CAMERA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CAMERA_TYPE_APPLICATION, CameraApplicationClass))
#define CAMERA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CAMERA_TYPE_APPLICATION))
#define CAMERA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CAMERA_TYPE_APPLICATION))
#define CAMERA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CAMERA_TYPE_APPLICATION, CameraApplicationClass))

typedef struct _CameraApplication CameraApplication;
typedef struct _CameraApplicationClass CameraApplicationClass;
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	CAMERA_UTILS_ACTION_TYPE_PHOTO,
	CAMERA_UTILS_ACTION_TYPE_VIDEO
} CameraUtilsActionType;

#define CAMERA_UTILS_TYPE_ACTION_TYPE (camera_utils_action_type_get_type ())
typedef enum  {
	CAMERA_WIDGETS_TIMER_BUTTON_DELAY_DISABLED = 0,
	CAMERA_WIDGETS_TIMER_BUTTON_DELAY_3_SEC = 3,
	CAMERA_WIDGETS_TIMER_BUTTON_DELAY_5_SEC = 5,
	CAMERA_WIDGETS_TIMER_BUTTON_DELAY_10_SEC = 10
} CameraWidgetsTimerButtonDelay;

#define CAMERA_WIDGETS_TIMER_BUTTON_TYPE_DELAY (camera_widgets_timer_button_delay_get_type ())
typedef struct _CameraWidgetsTimerButtonPrivate CameraWidgetsTimerButtonPrivate;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CameraMainWindow {
	HdyApplicationWindow parent_instance;
	CameraMainWindowPrivate * priv;
};

struct _CameraMainWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _CameraMainWindowPrivate {
	guint configure_id;
	CameraWidgetsCameraView* camera_view;
	GMenu* camera_options;
	GtkButton* take_button;
	GtkImage* take_image;
	GtkLabel* take_timer_label;
	GtkRevealer* camera_menu_revealer;
	GtkRevealer* video_timer_revealer;
	CameraWidgetsTimerButton* timer_button;
	GraniteModeSwitch* mode_switch;
	GtkMenuButton* menu_button;
	GtkBox* linked_box;
	gboolean timer_running;
	gboolean _recording;
	guint recording_timeout;
};

struct _Block2Data {
	int _ref_count_;
	CameraMainWindow* self;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
};

struct _CameraWidgetsTimerButton {
	GtkButton parent_instance;
	CameraWidgetsTimerButtonPrivate * priv;
	CameraWidgetsTimerButtonDelay delay;
};

struct _CameraWidgetsTimerButtonClass {
	GtkButtonClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	CameraMainWindow* self;
	gint time;
};

struct _Block4Data {
	int _ref_count_;
	CameraMainWindow* self;
	gint seconds;
};

struct _Block5Data {
	int _ref_count_;
	CameraMainWindow* self;
	GraniteWidgetsToast* recording_finished_toast;
	GraniteWidgetsToast* recording_finished_fail_toast;
};

static gint CameraMainWindow_private_offset;
static gpointer camera_main_window_parent_class = NULL;
VALA_EXTERN GSettings* camera_application_settings;

VALA_EXTERN GType camera_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraMainWindow, g_object_unref)
VALA_EXTERN GType camera_widgets_camera_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraWidgetsCameraView, g_object_unref)
VALA_EXTERN GType camera_widgets_timer_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraWidgetsTimerButton, g_object_unref)
static void camera_main_window_on_fullscreen (CameraMainWindow* self);
static void _camera_main_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void camera_main_window_on_take_photo (CameraMainWindow* self);
static void _camera_main_window_on_take_photo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void camera_main_window_on_record (CameraMainWindow* self,
                                   GSimpleAction* action,
                                   GVariant* parameter);
static void _camera_main_window_on_record_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void camera_main_window_on_change_camera (CameraMainWindow* self,
                                          GSimpleAction* action,
                                          GVariant* parameter);
static void _camera_main_window_on_change_camera_gsimple_action_activate_callback (GSimpleAction* action,
                                                                            GVariant* parameter,
                                                                            gpointer self);
VALA_EXTERN GType camera_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CameraApplication, g_object_unref)
VALA_EXTERN CameraMainWindow* camera_main_window_new (CameraApplication* application);
VALA_EXTERN CameraMainWindow* camera_main_window_construct (GType object_type,
                                                CameraApplication* application);
static GtkHeaderBar* camera_main_window_construct_headerbar (CameraMainWindow* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN CameraWidgetsTimerButton* camera_widgets_timer_button_new (void);
VALA_EXTERN CameraWidgetsTimerButton* camera_widgets_timer_button_construct (GType object_type);
static void __lambda14_ (CameraMainWindow* self);
VALA_EXTERN GType camera_utils_action_type_get_type (void) G_GNUC_CONST ;
static void ___lambda14__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda15_ (CameraMainWindow* self,
                  const gchar* key);
static void ___lambda15__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda16_ (Block2Data* _data2_);
VALA_EXTERN void camera_widgets_camera_view_change_color_balance (CameraWidgetsCameraView* self,
                                                      gdouble brightnesss,
                                                      gdouble contrast);
static void ___lambda16__gtk_range_value_changed (GtkRange* _sender,
                                           gpointer self);
static void __lambda17_ (Block2Data* _data2_);
static void ___lambda17__gtk_range_value_changed (GtkRange* _sender,
                                           gpointer self);
static void __lambda18_ (CameraMainWindow* self);
VALA_EXTERN gboolean camera_main_window_get_recording (CameraMainWindow* self);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void camera_main_window_enable_header (CameraMainWindow* self,
                                       gboolean enable);
VALA_EXTERN GType camera_widgets_timer_button_delay_get_type (void) G_GNUC_CONST ;
static void camera_main_window_start_timeout (CameraMainWindow* self,
                                       gint time);
static gboolean __lambda12_ (CameraMainWindow* self);
VALA_EXTERN void camera_widgets_camera_view_take_photo (CameraWidgetsCameraView* self);
static gboolean ___lambda12__gsource_func (gpointer self);
VALA_EXTERN void camera_widgets_camera_view_stop_recording (CameraWidgetsCameraView* self);
static void camera_main_window_stop_recording_time (CameraMainWindow* self);
VALA_EXTERN void camera_widgets_camera_view_start_recording (CameraWidgetsCameraView* self);
static void camera_main_window_start_recording_time (CameraMainWindow* self);
static gboolean camera_main_window_real_configure_event (GtkWidget* base,
                                                  GdkEventConfigure* event);
static gboolean __lambda19_ (CameraMainWindow* self);
static gboolean ___lambda19__gsource_func (gpointer self);
static void camera_main_window_add_camera_option (CameraMainWindow* self,
                                           GstDevice* camera);
static void camera_main_window_update_take_button (CameraMainWindow* self);
VALA_EXTERN void camera_widgets_camera_view_change_camera (CameraWidgetsCameraView* self,
                                               GstDevice* camera);
static void camera_main_window_remove_camera_option (CameraMainWindow* self,
                                              GstDevice* camera);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean ___lambda11_ (Block3Data* _data3_);
static gboolean ____lambda11__gsource_func (gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void camera_main_window_set_recording (CameraMainWindow* self,
                                       gboolean value);
static gboolean __lambda13_ (Block4Data* _data4_);
static gboolean ___lambda13__gsource_func (gpointer self);
static GObject * camera_main_window_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
VALA_EXTERN CameraWidgetsCameraView* camera_widgets_camera_view_new (void);
VALA_EXTERN CameraWidgetsCameraView* camera_widgets_camera_view_construct (GType object_type);
static void _camera_main_window_add_camera_option_camera_widgets_camera_view_camera_added (CameraWidgetsCameraView* _sender,
                                                                                    GstDevice* camera,
                                                                                    gpointer self);
static void _camera_main_window_remove_camera_option_camera_widgets_camera_view_camera_removed (CameraWidgetsCameraView* _sender,
                                                                                         GstDevice* camera,
                                                                                         gpointer self);
static void _camera_main_window___lambda20_ (Block5Data* _data5_);
static void __camera_main_window___lambda20__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                            gpointer self);
static void _camera_main_window___lambda21_ (Block5Data* _data5_,
                                      const gchar* file_path);
static void __camera_main_window___lambda21__camera_widgets_camera_view_recording_finished (CameraWidgetsCameraView* _sender,
                                                                                     const gchar* file_path,
                                                                                     gpointer self);
VALA_EXTERN void camera_widgets_camera_view_start (CameraWidgetsCameraView* self);
static void camera_main_window_finalize (GObject * obj);
static GType camera_main_window_get_type_once (void);
static void _vala_camera_main_window_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_camera_main_window_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry CAMERA_MAIN_WINDOW_ACTION_ENTRIES[4] = {{CAMERA_MAIN_WINDOW_ACTION_FULLSCREEN, _camera_main_window_on_fullscreen_gsimple_action_activate_callback}, {CAMERA_MAIN_WINDOW_ACTION_TAKE_PHOTO, _camera_main_window_on_take_photo_gsimple_action_activate_callback}, {CAMERA_MAIN_WINDOW_ACTION_RECORD, _camera_main_window_on_record_gsimple_action_activate_callback, NULL, "false", NULL}, {CAMERA_MAIN_WINDOW_ACTION_CHANGE_CAMERA, _camera_main_window_on_change_camera_gsimple_action_activate_callback, "s", "''"}};

static inline gpointer
camera_main_window_get_instance_private (CameraMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, CameraMainWindow_private_offset);
}

static void
_camera_main_window_on_fullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	camera_main_window_on_fullscreen ((CameraMainWindow*) self);
}

static void
_camera_main_window_on_take_photo_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	camera_main_window_on_take_photo ((CameraMainWindow*) self);
}

static void
_camera_main_window_on_record_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	camera_main_window_on_record ((CameraMainWindow*) self, action, parameter);
}

static void
_camera_main_window_on_change_camera_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self)
{
	camera_main_window_on_change_camera ((CameraMainWindow*) self, action, parameter);
}

CameraMainWindow*
camera_main_window_construct (GType object_type,
                              CameraApplication* application)
{
	CameraMainWindow * self = NULL;
	GtkApplication* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (application != NULL, NULL);
	self = (CameraMainWindow*) g_object_new (object_type, "application", application, NULL);
	g_action_map_add_action_entries ((GActionMap*) self, CAMERA_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (CAMERA_MAIN_WINDOW_ACTION_ENTRIES), self);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = g_strdup ("F11");
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	gtk_application_set_accels_for_action (_tmp0_, CAMERA_MAIN_WINDOW_ACTION_PREFIX CAMERA_MAIN_WINDOW_ACTION_FULLSCREEN, _tmp3_);
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	return self;
}

CameraMainWindow*
camera_main_window_new (CameraApplication* application)
{
	return camera_main_window_construct (CAMERA_TYPE_MAIN_WINDOW, application);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CameraMainWindow* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->contrast_scale);
		_g_object_unref0 (_data2_->brightness_scale);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda14_ (CameraMainWindow* self)
{
	GraniteModeSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->mode_switch;
	_tmp1_ = granite_mode_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSettings* _tmp3_;
		GtkButton* _tmp4_;
		GtkImage* _tmp5_;
		CameraWidgetsTimerButton* _tmp6_;
		_tmp3_ = camera_application_settings;
		g_settings_set_enum (_tmp3_, "mode", (gint) CAMERA_UTILS_ACTION_TYPE_VIDEO);
		_tmp4_ = self->priv->take_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp4_, CAMERA_MAIN_WINDOW_ACTION_PREFIX CAMERA_MAIN_WINDOW_ACTION_RECORD);
		_tmp5_ = self->priv->take_image;
		g_object_set (_tmp5_, "icon-name", CAMERA_MAIN_WINDOW_VIDEO_ICON_SYMBOLIC, NULL);
		_tmp6_ = self->priv->timer_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
	} else {
		GSettings* _tmp7_;
		GtkButton* _tmp8_;
		GtkImage* _tmp9_;
		CameraWidgetsTimerButton* _tmp10_;
		_tmp7_ = camera_application_settings;
		g_settings_set_enum (_tmp7_, "mode", (gint) CAMERA_UTILS_ACTION_TYPE_PHOTO);
		_tmp8_ = self->priv->take_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp8_, CAMERA_MAIN_WINDOW_ACTION_PREFIX CAMERA_MAIN_WINDOW_ACTION_TAKE_PHOTO);
		_tmp9_ = self->priv->take_image;
		g_object_set (_tmp9_, "icon-name", CAMERA_MAIN_WINDOW_PHOTO_ICON_SYMBOLIC, NULL);
		_tmp10_ = self->priv->timer_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, TRUE);
	}
}

static void
___lambda14__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda14_ ((CameraMainWindow*) self);
}

static void
__lambda15_ (CameraMainWindow* self,
             const gchar* key)
{
	GraniteModeSwitch* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->mode_switch;
	_tmp1_ = camera_application_settings;
	granite_mode_switch_set_active (_tmp0_, g_settings_get_enum (_tmp1_, "mode") == ((gint) CAMERA_UTILS_ACTION_TYPE_VIDEO));
}

static void
___lambda15__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
	__lambda15_ ((CameraMainWindow*) self, key);
}

static void
__lambda16_ (Block2Data* _data2_)
{
	CameraMainWindow* self;
	CameraWidgetsCameraView* _tmp0_;
	self = _data2_->self;
	_tmp0_ = self->priv->camera_view;
	camera_widgets_camera_view_change_color_balance (_tmp0_, gtk_range_get_value ((GtkRange*) _data2_->brightness_scale), gtk_range_get_value ((GtkRange*) _data2_->contrast_scale));
}

static void
___lambda16__gtk_range_value_changed (GtkRange* _sender,
                                      gpointer self)
{
	__lambda16_ (self);
}

static void
__lambda17_ (Block2Data* _data2_)
{
	CameraMainWindow* self;
	CameraWidgetsCameraView* _tmp0_;
	self = _data2_->self;
	_tmp0_ = self->priv->camera_view;
	camera_widgets_camera_view_change_color_balance (_tmp0_, gtk_range_get_value ((GtkRange*) _data2_->brightness_scale), gtk_range_get_value ((GtkRange*) _data2_->contrast_scale));
}

static void
___lambda17__gtk_range_value_changed (GtkRange* _sender,
                                      gpointer self)
{
	__lambda17_ (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda18_ (CameraMainWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	CameraWidgetsTimerButton* _tmp5_;
	GraniteModeSwitch* _tmp6_;
	gboolean _tmp7_;
	GtkRevealer* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	_tmp1_ = self->priv->_recording;
	if (!_tmp1_) {
		GraniteModeSwitch* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->mode_switch;
		_tmp3_ = granite_mode_switch_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = self->priv->timer_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, _tmp0_);
	_tmp6_ = self->priv->mode_switch;
	_tmp7_ = self->priv->_recording;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, !_tmp7_);
	_tmp8_ = self->priv->video_timer_revealer;
	_tmp9_ = self->priv->_recording;
	gtk_revealer_set_reveal_child (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->_recording;
	if (_tmp10_) {
		GtkImage* _tmp11_;
		_tmp11_ = self->priv->take_image;
		g_object_set (_tmp11_, "icon-name", CAMERA_MAIN_WINDOW_STOP_ICON_SYMBOLIC, NULL);
	} else {
		GtkImage* _tmp12_;
		_tmp12_ = self->priv->take_image;
		g_object_set (_tmp12_, "icon-name", CAMERA_MAIN_WINDOW_VIDEO_ICON_SYMBOLIC, NULL);
	}
}

static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda18_ ((CameraMainWindow*) self);
}

static GtkHeaderBar*
camera_main_window_construct_headerbar (CameraMainWindow* self)
{
	Block2Data* _data2_;
	GtkImage* _tmp0_;
	CameraWidgetsTimerButton* _tmp1_ = NULL;
	gchar* _tmp2_;
	GtkImage* _tmp3_ = NULL;
	GtkLabel* _tmp4_;
	GtkRevealer* _tmp5_ = NULL;
	GtkRevealer* _tmp6_;
	GtkLabel* _tmp7_;
	GtkBox* take_box = NULL;
	GtkBox* _tmp8_ = NULL;
	GtkImage* _tmp9_;
	GtkRevealer* _tmp10_;
	gchar* _tmp11_;
	GtkButton* _tmp12_ = NULL;
	GtkButton* _tmp13_;
	GtkStyleContext* take_button_style_context = NULL;
	GtkButton* _tmp14_;
	GtkStyleContext* _tmp15_;
	GraniteModeSwitch* _tmp16_ = NULL;
	GraniteModeSwitch* _tmp17_;
	GSettings* _tmp18_;
	GraniteModeSwitch* _tmp19_;
	GSettings* _tmp20_;
	GraniteSwitchModelButton* mirror_switch = NULL;
	GraniteSwitchModelButton* _tmp21_;
	CameraWidgetsCameraView* _tmp22_;
	GtkImage* brightness_image = NULL;
	GtkImage* _tmp23_;
	GtkLabel* brightness_label = NULL;
	GtkLabel* _tmp24_ = NULL;
	GtkScale* _tmp25_ = NULL;
	GtkImage* contrast_image = NULL;
	GtkImage* _tmp26_;
	GtkLabel* contrast_label = NULL;
	GtkLabel* _tmp27_ = NULL;
	GtkScale* _tmp28_ = NULL;
	GtkGrid* image_settings = NULL;
	GtkGrid* _tmp29_ = NULL;
	GtkGrid* menu_popover_grid = NULL;
	GtkGrid* _tmp30_ = NULL;
	GtkPopover* popover = NULL;
	GtkPopover* _tmp31_;
	GtkImage* _tmp32_;
	GtkPopover* _tmp33_;
	gchar* _tmp34_;
	GtkMenuButton* _tmp35_ = NULL;
	GMenu* _tmp36_;
	GtkMenuButton* camera_menu_button = NULL;
	GMenu* _tmp37_;
	GMenuModel* _tmp38_;
	GtkMenuButton* _tmp39_ = NULL;
	GtkStyleContext* camera_menu_button_style_context = NULL;
	GtkStyleContext* _tmp40_;
	GtkRevealer* _tmp41_ = NULL;
	GtkRevealer* _tmp42_;
	GtkBox* _tmp43_;
	GtkBox* _tmp44_;
	GtkButton* _tmp45_;
	GtkBox* _tmp46_;
	GtkRevealer* _tmp47_;
	GtkHeaderBar* header_widget = NULL;
	GtkBox* _tmp48_;
	GtkWidget* _tmp49_;
	GtkHeaderBar* _tmp50_ = NULL;
	GtkStyleContext* _tmp51_;
	CameraWidgetsTimerButton* _tmp52_;
	GtkMenuButton* _tmp53_;
	GtkSeparator* _tmp54_;
	GtkSeparator* _tmp55_;
	GraniteModeSwitch* _tmp56_;
	GtkHeaderBar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("timer-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = camera_widgets_timer_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp1_, (GtkWidget*) _tmp0_);
	_g_object_unref0 (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->timer_button);
	self->priv->timer_button = _tmp1_;
	_tmp2_ = g_strdup (CAMERA_MAIN_WINDOW_PHOTO_ICON_SYMBOLIC);
	_tmp3_ = (GtkImage*) gtk_image_new ();
	g_object_set (_tmp3_, "icon-name", _tmp2_, NULL);
	_g_free0 (_tmp2_);
	g_object_set (_tmp3_, "icon-size", (gint) GTK_ICON_SIZE_BUTTON, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->take_image);
	self->priv->take_image = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->take_timer_label);
	self->priv->take_timer_label = _tmp4_;
	_tmp5_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_type (_tmp5_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->video_timer_revealer);
	self->priv->video_timer_revealer = _tmp5_;
	_tmp6_ = self->priv->video_timer_revealer;
	_tmp7_ = self->priv->take_timer_label;
	gtk_container_add ((GtkContainer*) _tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_halign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp8_);
	take_box = _tmp8_;
	_tmp9_ = self->priv->take_image;
	gtk_box_pack_start (take_box, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	_tmp10_ = self->priv->video_timer_revealer;
	gtk_box_pack_start (take_box, (GtkWidget*) _tmp10_, TRUE, TRUE, (guint) 0);
	_tmp11_ = g_strdup (CAMERA_MAIN_WINDOW_ACTION_PREFIX CAMERA_MAIN_WINDOW_ACTION_TAKE_PHOTO);
	_tmp12_ = (GtkButton*) gtk_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp12_, _tmp11_);
	_g_free0 (_tmp11_);
	g_object_set ((GtkWidget*) _tmp12_, "width-request", 54, NULL);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->take_button);
	self->priv->take_button = _tmp12_;
	_tmp13_ = self->priv->take_button;
	gtk_container_add ((GtkContainer*) _tmp13_, (GtkWidget*) take_box);
	_tmp14_ = self->priv->take_button;
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
	take_button_style_context = _tmp15_;
	gtk_style_context_add_class (take_button_style_context, "take-button");
	gtk_style_context_add_class (take_button_style_context, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp16_ = granite_mode_switch_new_from_icon_name (CAMERA_MAIN_WINDOW_PHOTO_ICON_SYMBOLIC, CAMERA_MAIN_WINDOW_VIDEO_ICON_SYMBOLIC);
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->mode_switch);
	self->priv->mode_switch = _tmp16_;
	_tmp17_ = self->priv->mode_switch;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::active", (GCallback) ___lambda14__g_object_notify, self, 0);
	_tmp18_ = camera_application_settings;
	g_signal_connect_object (_tmp18_, "changed::mode", (GCallback) ___lambda15__g_settings_changed, self, 0);
	_tmp19_ = self->priv->mode_switch;
	_tmp20_ = camera_application_settings;
	granite_mode_switch_set_active (_tmp19_, g_settings_get_enum (_tmp20_, "mode") == ((gint) CAMERA_UTILS_ACTION_TYPE_VIDEO));
	_tmp21_ = granite_switch_model_button_new (_ ("Mirror"));
	g_object_ref_sink (_tmp21_);
	mirror_switch = _tmp21_;
	_tmp22_ = self->priv->camera_view;
	g_object_bind_property_with_closures ((GObject*) mirror_switch, "active", (GObject*) _tmp22_, "horizontal-flip", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp23_ = (GtkImage*) gtk_image_new_from_icon_name ("display-brightness-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp23_);
	brightness_image = _tmp23_;
	_tmp24_ = (GtkLabel*) gtk_label_new (_ ("Brightness"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp24_, TRUE);
	gtk_label_set_xalign (_tmp24_, (gfloat) 0);
	g_object_ref_sink (_tmp24_);
	brightness_label = _tmp24_;
	_tmp25_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) -1, (gdouble) 1, 0.1);
	gtk_scale_set_draw_value (_tmp25_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp25_, TRUE);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp25_, 6);
	g_object_ref_sink (_tmp25_);
	_data2_->brightness_scale = _tmp25_;
	gtk_range_set_value ((GtkRange*) _data2_->brightness_scale, (gdouble) 0);
	gtk_scale_add_mark (_data2_->brightness_scale, (gdouble) 0, GTK_POS_BOTTOM, "");
	_tmp26_ = (GtkImage*) gtk_image_new_from_icon_name ("color-contrast-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp26_);
	contrast_image = _tmp26_;
	_tmp27_ = (GtkLabel*) gtk_label_new (_ ("Contrast"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp27_, TRUE);
	gtk_label_set_xalign (_tmp27_, (gfloat) 0);
	g_object_ref_sink (_tmp27_);
	contrast_label = _tmp27_;
	_tmp28_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 2, 0.1);
	gtk_scale_set_draw_value (_tmp28_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp28_, FALSE);
	g_object_ref_sink (_tmp28_);
	_data2_->contrast_scale = _tmp28_;
	gtk_range_set_value ((GtkRange*) _data2_->contrast_scale, (gdouble) 1);
	gtk_scale_add_mark (_data2_->contrast_scale, (gdouble) 1, GTK_POS_BOTTOM, "");
	g_signal_connect_data ((GtkRange*) _data2_->contrast_scale, "value-changed", (GCallback) ___lambda16__gtk_range_value_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	g_signal_connect_data ((GtkRange*) _data2_->brightness_scale, "value-changed", (GCallback) ___lambda17__gtk_range_value_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp29_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp29_, 6);
	gtk_grid_set_row_spacing (_tmp29_, 3);
	g_object_set ((GtkWidget*) _tmp29_, "margin", 12, NULL);
	g_object_ref_sink (_tmp29_);
	image_settings = _tmp29_;
	gtk_grid_attach (image_settings, (GtkWidget*) brightness_image, 0, 0, 1, 1);
	gtk_grid_attach (image_settings, (GtkWidget*) brightness_label, 1, 0, 1, 1);
	gtk_grid_attach (image_settings, (GtkWidget*) _data2_->brightness_scale, 0, 1, 2, 1);
	gtk_grid_attach (image_settings, (GtkWidget*) contrast_image, 0, 2, 1, 1);
	gtk_grid_attach (image_settings, (GtkWidget*) contrast_label, 1, 2, 1, 1);
	gtk_grid_attach (image_settings, (GtkWidget*) _data2_->contrast_scale, 0, 3, 2, 1);
	_tmp30_ = (GtkGrid*) gtk_grid_new ();
	g_object_set ((GtkWidget*) _tmp30_, "width-request", 250, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp30_, 3);
	g_object_ref_sink (_tmp30_);
	menu_popover_grid = _tmp30_;
	gtk_grid_attach (menu_popover_grid, (GtkWidget*) image_settings, 0, 0, 1, 1);
	gtk_grid_attach (menu_popover_grid, (GtkWidget*) mirror_switch, 0, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) menu_popover_grid);
	_tmp31_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_ref_sink (_tmp31_);
	popover = _tmp31_;
	gtk_container_add ((GtkContainer*) popover, (GtkWidget*) menu_popover_grid);
	_tmp32_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp32_);
	_tmp33_ = _g_object_ref0 (popover);
	_tmp34_ = g_strdup (_ ("Settings"));
	_tmp35_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp35_, (GtkWidget*) _tmp32_);
	_g_object_unref0 (_tmp32_);
	gtk_menu_button_set_popover (_tmp35_, _tmp33_);
	_g_object_unref0 (_tmp33_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp35_, _tmp34_);
	_g_free0 (_tmp34_);
	g_object_ref_sink (_tmp35_);
	_g_object_unref0 (self->priv->menu_button);
	self->priv->menu_button = _tmp35_;
	_tmp36_ = g_menu_new ();
	_g_object_unref0 (self->priv->camera_options);
	self->priv->camera_options = _tmp36_;
	_tmp37_ = self->priv->camera_options;
	_tmp38_ = _g_object_ref0 ((GMenuModel*) _tmp37_);
	_tmp39_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_menu_model (_tmp39_, _tmp38_);
	_g_object_unref0 (_tmp38_);
	g_object_ref_sink (_tmp39_);
	camera_menu_button = _tmp39_;
	_tmp40_ = gtk_widget_get_style_context ((GtkWidget*) camera_menu_button);
	camera_menu_button_style_context = _tmp40_;
	gtk_style_context_add_class (camera_menu_button_style_context, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	gtk_style_context_add_class (camera_menu_button_style_context, "camera-menu");
	_tmp41_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_transition_duration (_tmp41_, (guint) 250);
	gtk_revealer_set_transition_type (_tmp41_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	g_object_ref_sink (_tmp41_);
	_g_object_unref0 (self->priv->camera_menu_revealer);
	self->priv->camera_menu_revealer = _tmp41_;
	_tmp42_ = self->priv->camera_menu_revealer;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) camera_menu_button);
	_tmp43_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp43_);
	_g_object_unref0 (self->priv->linked_box);
	self->priv->linked_box = _tmp43_;
	_tmp44_ = self->priv->linked_box;
	_tmp45_ = self->priv->take_button;
	gtk_box_pack_start (_tmp44_, (GtkWidget*) _tmp45_, TRUE, TRUE, (guint) 0);
	_tmp46_ = self->priv->linked_box;
	_tmp47_ = self->priv->camera_menu_revealer;
	gtk_box_pack_start (_tmp46_, (GtkWidget*) _tmp47_, TRUE, TRUE, (guint) 0);
	_tmp48_ = self->priv->linked_box;
	_tmp49_ = _g_object_ref0 ((GtkWidget*) _tmp48_);
	_tmp50_ = (GtkHeaderBar*) gtk_header_bar_new ();
	gtk_header_bar_set_show_close_button (_tmp50_, TRUE);
	gtk_header_bar_set_custom_title (_tmp50_, _tmp49_);
	_g_object_unref0 (_tmp49_);
	g_object_ref_sink (_tmp50_);
	header_widget = _tmp50_;
	_tmp51_ = gtk_widget_get_style_context ((GtkWidget*) header_widget);
	gtk_style_context_add_class (_tmp51_, GTK_STYLE_CLASS_TITLEBAR);
	_tmp52_ = self->priv->timer_button;
	gtk_header_bar_pack_start (header_widget, (GtkWidget*) _tmp52_);
	_tmp53_ = self->priv->menu_button;
	gtk_header_bar_pack_end (header_widget, (GtkWidget*) _tmp53_);
	_tmp54_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp54_);
	_tmp55_ = _tmp54_;
	gtk_header_bar_pack_end (header_widget, (GtkWidget*) _tmp55_);
	_g_object_unref0 (_tmp55_);
	_tmp56_ = self->priv->mode_switch;
	gtk_header_bar_pack_end (header_widget, (GtkWidget*) _tmp56_);
	g_signal_connect_object ((GObject*) self, "notify::recording", (GCallback) ___lambda18__g_object_notify, self, 0);
	camera_main_window_enable_header (self, TRUE);
	result = header_widget;
	_g_object_unref0 (camera_menu_button);
	_g_object_unref0 (popover);
	_g_object_unref0 (menu_popover_grid);
	_g_object_unref0 (image_settings);
	_g_object_unref0 (contrast_label);
	_g_object_unref0 (contrast_image);
	_g_object_unref0 (brightness_label);
	_g_object_unref0 (brightness_image);
	_g_object_unref0 (mirror_switch);
	_g_object_unref0 (take_box);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
camera_main_window_on_fullscreen (CameraMainWindow* self)
{
	GdkWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	if ((gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN) {
		gtk_window_unfullscreen ((GtkWindow*) self);
	} else {
		gtk_window_fullscreen ((GtkWindow*) self);
	}
}

static gboolean
__lambda12_ (CameraMainWindow* self)
{
	CameraWidgetsCameraView* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->camera_view;
	camera_widgets_camera_view_take_photo (_tmp0_);
	self->priv->timer_running = FALSE;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ ((CameraMainWindow*) self);
	return result;
}

static void
camera_main_window_on_take_photo (CameraMainWindow* self)
{
	CameraWidgetsTimerButtonDelay delay = 0;
	CameraWidgetsTimerButton* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->timer_running) {
		return;
	}
	_tmp0_ = self->priv->timer_button;
	delay = _tmp0_->delay;
	camera_main_window_start_timeout (self, (gint) delay);
	self->priv->timer_running = TRUE;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) delay, ___lambda12__gsource_func, g_object_ref (self), g_object_unref);
}

static void
camera_main_window_on_record (CameraMainWindow* self,
                              GSimpleAction* action,
                              GVariant* parameter)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_action_get_state ((GAction*) action);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_boolean (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	if (_tmp3_) {
		CameraWidgetsCameraView* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		_tmp4_ = self->priv->camera_view;
		camera_widgets_camera_view_stop_recording (_tmp4_);
		camera_main_window_stop_recording_time (self);
		_tmp5_ = g_variant_new_boolean (FALSE);
		g_variant_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		g_simple_action_set_state (action, _tmp6_);
		_g_variant_unref0 (_tmp6_);
	} else {
		CameraWidgetsCameraView* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		_tmp7_ = self->priv->camera_view;
		camera_widgets_camera_view_start_recording (_tmp7_);
		camera_main_window_start_recording_time (self);
		_tmp8_ = g_variant_new_boolean (TRUE);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		g_simple_action_set_state (action, _tmp9_);
		_g_variant_unref0 (_tmp9_);
	}
}

static gboolean
__lambda19_ (CameraMainWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self->priv->configure_id = (guint) 0;
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = camera_application_settings;
		g_settings_set_boolean (_tmp2_, "window-maximized", TRUE);
	} else {
		GSettings* _tmp3_;
		gint width = 0;
		gint height = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GSettings* _tmp6_;
		_tmp3_ = camera_application_settings;
		g_settings_set_boolean (_tmp3_, "window-maximized", FALSE);
		gtk_window_get_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
		width = _tmp4_;
		height = _tmp5_;
		_tmp6_ = camera_application_settings;
		g_settings_set (_tmp6_, "window-size", "(ii)", width, height);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda19_ ((CameraMainWindow*) self);
	return result;
}

static gboolean
camera_main_window_real_configure_event (GtkWidget* base,
                                         GdkEventConfigure* event)
{
	CameraMainWindow * self;
	gboolean result;
	self = (CameraMainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->configure_id != ((guint) 0)) {
		g_source_remove (self->priv->configure_id);
	}
	self->priv->configure_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda19__gsource_func, g_object_ref (self), g_object_unref);
	result = GTK_WIDGET_CLASS (camera_main_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	return result;
}

/** Header bar tools management functions from Camera.Widgets.HeaderBar **/
static void
camera_main_window_enable_header (CameraMainWindow* self,
                                  gboolean enable)
{
	GtkBox* _tmp0_;
	GraniteModeSwitch* _tmp1_;
	GtkMenuButton* _tmp2_;
	CameraWidgetsTimerButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->linked_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, enable);
	_tmp1_ = self->priv->mode_switch;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, enable);
	_tmp2_ = self->priv->menu_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, enable);
	_tmp3_ = self->priv->timer_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, enable);
}

static void
camera_main_window_add_camera_option (CameraMainWindow* self,
                                      GstDevice* camera)
{
	GMenu* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GMenu* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GstDevice* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = self->priv->camera_options;
	_tmp1_ = gst_device_get_display_name (camera);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gst_object_get_name ((GstObject*) camera);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s%s('%s')", CAMERA_MAIN_WINDOW_ACTION_PREFIX, CAMERA_MAIN_WINDOW_ACTION_CHANGE_CAMERA, _tmp6_);
	_tmp8_ = _tmp7_;
	g_menu_append (_tmp0_, _tmp3_, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp9_ = self->priv->camera_options;
	_tmp10_ = gst_object_get_name ((GstObject*) camera);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (camera);
	g_object_set_data_full ((GObject*) _tmp9_, _tmp12_, _tmp13_, g_object_unref);
	_g_free0 (_tmp12_);
	_tmp14_ = gst_object_get_name ((GstObject*) camera);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp17_ = g_variant_new_string (_tmp16_);
	g_variant_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	g_action_group_change_action_state ((GActionGroup*) self, CAMERA_MAIN_WINDOW_ACTION_CHANGE_CAMERA, _tmp18_);
	_g_variant_unref0 (_tmp18_);
	_g_free0 (_tmp16_);
	camera_main_window_update_take_button (self);
	camera_main_window_enable_header (self, TRUE);
}

static void
camera_main_window_on_change_camera (CameraMainWindow* self,
                                     GSimpleAction* action,
                                     GVariant* parameter)
{
	CameraWidgetsCameraView* _tmp0_;
	GMenu* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->camera_view;
	_tmp1_ = self->priv->camera_options;
	_tmp2_ = g_variant_get_string (parameter, NULL);
	_tmp3_ = g_object_get_data ((GObject*) _tmp1_, _tmp2_);
	camera_widgets_camera_view_change_camera (_tmp0_, (GstDevice*) _tmp3_);
}

static void
camera_main_window_remove_camera_option (CameraMainWindow* self,
                                         GstDevice* camera)
{
	gint item_count = 0;
	GMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (camera != NULL);
	_tmp0_ = self->priv->camera_options;
	item_count = g_menu_model_get_n_items ((GMenuModel*) _tmp0_);
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GVariant* variant = NULL;
				GMenu* _tmp3_;
				const GVariantType* _tmp4_;
				GVariant* _tmp5_;
				GVariant* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gboolean _tmp11_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = index;
					index = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(index < item_count)) {
					break;
				}
				_tmp3_ = self->priv->camera_options;
				_tmp4_ = G_VARIANT_TYPE_STRING;
				_tmp5_ = g_menu_model_get_item_attribute_value ((GMenuModel*) _tmp3_, index, G_MENU_ATTRIBUTE_TARGET, _tmp4_);
				variant = _tmp5_;
				_tmp6_ = variant;
				_tmp7_ = g_variant_get_string (_tmp6_, NULL);
				_tmp8_ = gst_object_get_name ((GstObject*) camera);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
				_g_free0 (_tmp10_);
				if (_tmp11_) {
					GMenu* _tmp12_;
					gint _tmp13_;
					_tmp12_ = self->priv->camera_options;
					g_menu_remove (_tmp12_, index);
					_tmp13_ = item_count;
					item_count = _tmp13_ - 1;
					_g_variant_unref0 (variant);
					break;
				}
				_g_variant_unref0 (variant);
			}
		}
	}
	camera_main_window_update_take_button (self);
	camera_main_window_enable_header (self, item_count > 0);
}

static void
camera_main_window_update_take_button (CameraMainWindow* self)
{
	GtkStyleContext* take_button_style_context = NULL;
	GtkButton* _tmp0_;
	GtkStyleContext* _tmp1_;
	GMenu* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->take_button;
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) _tmp0_);
	take_button_style_context = _tmp1_;
	_tmp2_ = self->priv->camera_options;
	if (g_menu_model_get_n_items ((GMenuModel*) _tmp2_) > 1) {
		GtkRevealer* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp3_ = self->priv->camera_menu_revealer;
		gtk_revealer_set_reveal_child (_tmp3_, TRUE);
		_tmp4_ = take_button_style_context;
		gtk_style_context_add_class (_tmp4_, "multiple");
	} else {
		GtkRevealer* _tmp5_;
		GtkStyleContext* _tmp6_;
		_tmp5_ = self->priv->camera_menu_revealer;
		gtk_revealer_set_reveal_child (_tmp5_, FALSE);
		_tmp6_ = take_button_style_context;
		gtk_style_context_remove_class (_tmp6_, "multiple");
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CameraMainWindow* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
___lambda11_ (Block3Data* _data3_)
{
	CameraMainWindow* self;
	gboolean result;
	self = _data3_->self;
	camera_main_window_start_timeout (self, _data3_->time - 1);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda11_ (self);
	return result;
}

static void
camera_main_window_start_timeout (CameraMainWindow* self,
                                  gint time)
{
	Block3Data* _data3_;
	gboolean timeout_reached = FALSE;
	GraniteModeSwitch* _tmp0_;
	GtkImage* _tmp1_;
	CameraWidgetsTimerButton* _tmp2_;
	GtkRevealer* _tmp3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->time = time;
	timeout_reached = _data3_->time == 0;
	_tmp0_ = self->priv->mode_switch;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, timeout_reached);
	_tmp1_ = self->priv->take_image;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, timeout_reached);
	_tmp2_ = self->priv->timer_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, timeout_reached);
	_tmp3_ = self->priv->video_timer_revealer;
	gtk_revealer_set_reveal_child (_tmp3_, !timeout_reached);
	if (!timeout_reached) {
		GtkLabel* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->take_timer_label;
		_tmp5_ = g_strdup_printf ("%i", _data3_->time);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda11__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	}
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		CameraMainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gboolean
__lambda13_ (Block4Data* _data4_)
{
	CameraMainWindow* self;
	gint _tmp0_;
	GtkLabel* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean result;
	self = _data4_->self;
	_tmp0_ = _data4_->seconds;
	_data4_->seconds = _tmp0_ + 1;
	_tmp1_ = self->priv->take_timer_label;
	_tmp2_ = granite_date_time_seconds_to_time (_data4_->seconds);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ (self);
	return result;
}

static void
camera_main_window_start_recording_time (CameraMainWindow* self)
{
	Block4Data* _data4_;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	camera_main_window_set_recording (self, TRUE);
	_data4_->seconds = 0;
	_tmp0_ = self->priv->take_timer_label;
	_tmp1_ = granite_date_time_seconds_to_time (_data4_->seconds);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	self->priv->recording_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda13__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
camera_main_window_stop_recording_time (CameraMainWindow* self)
{
	g_return_if_fail (self != NULL);
	camera_main_window_set_recording (self, FALSE);
	if (self->priv->recording_timeout > ((guint) 0)) {
		g_source_remove (self->priv->recording_timeout);
	}
	self->priv->recording_timeout = 0U;
}

gboolean
camera_main_window_get_recording (CameraMainWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_recording;
	return result;
}

static void
camera_main_window_set_recording (CameraMainWindow* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = camera_main_window_get_recording (self);
	if (old_value != value) {
		self->priv->_recording = value;
		g_object_notify_by_pspec ((GObject *) self, camera_main_window_properties[CAMERA_MAIN_WINDOW_RECORDING_PROPERTY]);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		CameraMainWindow* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->recording_finished_fail_toast);
		_g_object_unref0 (_data5_->recording_finished_toast);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_camera_main_window_add_camera_option_camera_widgets_camera_view_camera_added (CameraWidgetsCameraView* _sender,
                                                                               GstDevice* camera,
                                                                               gpointer self)
{
	camera_main_window_add_camera_option ((CameraMainWindow*) self, camera);
}

static void
_camera_main_window_remove_camera_option_camera_widgets_camera_view_camera_removed (CameraWidgetsCameraView* _sender,
                                                                                    GstDevice* camera,
                                                                                    gpointer self)
{
	camera_main_window_remove_camera_option ((CameraMainWindow*) self, camera);
}

static void
_camera_main_window___lambda20_ (Block5Data* _data5_)
{
	CameraMainWindow* self;
	gchar* file_path = NULL;
	GraniteWidgetsToast* _tmp0_;
	gconstpointer _tmp1_;
	gchar* _tmp2_;
	GFile* file = NULL;
	const gchar* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	_tmp0_ = _data5_->recording_finished_toast;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "location");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	file_path = _tmp2_;
	_tmp3_ = file_path;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	file = _tmp4_;
	{
		GdkAppLaunchContext* context = NULL;
		GdkDisplay* _tmp5_;
		GdkAppLaunchContext* _tmp6_;
		GdkAppLaunchContext* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GdkAppLaunchContext* _tmp13_;
		_tmp5_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp6_ = gdk_display_get_app_launch_context (_tmp5_);
		context = _tmp6_;
		_tmp7_ = context;
		gdk_app_launch_context_set_timestamp (_tmp7_, gtk_get_current_event_time ());
		_tmp8_ = file;
		_tmp9_ = g_file_get_parent (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = context;
		g_app_info_launch_default_for_uri (_tmp12_, (GAppLaunchContext*) _tmp13_, &_inner_error0_);
		_g_free0 (_tmp12_);
		_g_object_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (context);
			goto __catch0_g_error;
		}
		_g_object_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("MainWindow.vala:83: Error launching file manager: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		_g_free0 (file_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
	_g_free0 (file_path);
}

static void
__camera_main_window___lambda20__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                                       gpointer self)
{
	_camera_main_window___lambda20_ (self);
}

static void
_camera_main_window___lambda21_ (Block5Data* _data5_,
                                 const gchar* file_path)
{
	CameraMainWindow* self;
	self = _data5_->self;
	g_return_if_fail (file_path != NULL);
	if (g_strcmp0 (file_path, "") == 0) {
		GraniteWidgetsToast* _tmp0_;
		_tmp0_ = _data5_->recording_finished_fail_toast;
		granite_widgets_toast_send_notification (_tmp0_);
	} else {
		GraniteWidgetsToast* _tmp1_;
		gchar* _tmp2_;
		GraniteWidgetsToast* _tmp3_;
		_tmp1_ = _data5_->recording_finished_toast;
		_tmp2_ = g_strdup (file_path);
		g_object_set_data_full ((GObject*) _tmp1_, "location", _tmp2_, g_free);
		_tmp3_ = _data5_->recording_finished_toast;
		granite_widgets_toast_send_notification (_tmp3_);
	}
}

static void
__camera_main_window___lambda21__camera_widgets_camera_view_recording_finished (CameraWidgetsCameraView* _sender,
                                                                                const gchar* file_path,
                                                                                gpointer self)
{
	_camera_main_window___lambda21_ (self, file_path);
}

static GObject *
camera_main_window_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CameraMainWindow * self;
	Block5Data* _data5_;
	CameraWidgetsCameraView* _tmp0_;
	CameraWidgetsCameraView* _tmp1_;
	CameraWidgetsCameraView* _tmp2_;
	GraniteWidgetsToast* _tmp3_;
	GraniteWidgetsToast* _tmp4_;
	GraniteWidgetsToast* _tmp5_;
	gchar* _tmp6_;
	GraniteWidgetsToast* _tmp7_;
	GraniteWidgetsToast* _tmp8_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp9_;
	GtkOverlay* _tmp10_;
	CameraWidgetsCameraView* _tmp11_;
	GtkOverlay* _tmp12_;
	GraniteWidgetsToast* _tmp13_;
	GtkOverlay* _tmp14_;
	GraniteWidgetsToast* _tmp15_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp16_;
	GtkGrid* _tmp17_;
	GtkHeaderBar* _tmp18_;
	GtkHeaderBar* _tmp19_;
	GtkGrid* _tmp20_;
	GtkOverlay* _tmp21_;
	HdyWindowHandle* window_handle = NULL;
	HdyWindowHandle* _tmp22_;
	HdyWindowHandle* _tmp23_;
	GtkGrid* _tmp24_;
	HdyWindowHandle* _tmp25_;
	CameraWidgetsCameraView* _tmp26_;
	HdyWindowHandle* _tmp27_;
	CameraWidgetsCameraView* _tmp28_;
	parent_class = G_OBJECT_CLASS (camera_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAMERA_TYPE_MAIN_WINDOW, CameraMainWindow);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	gtk_window_set_title ((GtkWindow*) self, _ ("Camera"));
	gtk_window_set_icon_name ((GtkWindow*) self, "io.elementary.camera");
	_tmp0_ = camera_widgets_camera_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->camera_view);
	self->priv->camera_view = _tmp0_;
	_tmp1_ = self->priv->camera_view;
	g_signal_connect_object (_tmp1_, "camera-added", (GCallback) _camera_main_window_add_camera_option_camera_widgets_camera_view_camera_added, self, 0);
	_tmp2_ = self->priv->camera_view;
	g_signal_connect_object (_tmp2_, "camera-removed", (GCallback) _camera_main_window_remove_camera_option_camera_widgets_camera_view_camera_removed, self, 0);
	_tmp3_ = granite_widgets_toast_new (_ ("Saved to Videos"));
	g_object_ref_sink (_tmp3_);
	_data5_->recording_finished_toast = _tmp3_;
	_tmp4_ = _data5_->recording_finished_toast;
	granite_widgets_toast_set_default_action (_tmp4_, _ ("View File"));
	_tmp5_ = _data5_->recording_finished_toast;
	_tmp6_ = g_strdup ("");
	g_object_set_data_full ((GObject*) _tmp5_, "location", _tmp6_, g_free);
	_tmp7_ = _data5_->recording_finished_toast;
	g_signal_connect_data (_tmp7_, "default-action", (GCallback) __camera_main_window___lambda20__granite_widgets_toast_default_action, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp8_ = granite_widgets_toast_new (_ ("Recording failed"));
	g_object_ref_sink (_tmp8_);
	_data5_->recording_finished_fail_toast = _tmp8_;
	_tmp9_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp9_);
	overlay = _tmp9_;
	_tmp10_ = overlay;
	_tmp11_ = self->priv->camera_view;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = overlay;
	_tmp13_ = _data5_->recording_finished_toast;
	gtk_overlay_add_overlay (_tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = overlay;
	_tmp15_ = _data5_->recording_finished_fail_toast;
	gtk_overlay_add_overlay (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	grid = _tmp16_;
	_tmp17_ = grid;
	_tmp18_ = camera_main_window_construct_headerbar (self);
	_tmp19_ = _tmp18_;
	gtk_grid_attach (_tmp17_, (GtkWidget*) _tmp19_, 0, 0, 1, 1);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = grid;
	_tmp21_ = overlay;
	gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp21_, 0, 1, 1, 1);
	_tmp22_ = (HdyWindowHandle*) hdy_window_handle_new ();
	g_object_ref_sink (_tmp22_);
	window_handle = _tmp22_;
	_tmp23_ = window_handle;
	_tmp24_ = grid;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = window_handle;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->camera_view;
	g_signal_connect_data (_tmp26_, "recording-finished", (GCallback) __camera_main_window___lambda21__camera_widgets_camera_view_recording_finished, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp27_ = window_handle;
	gtk_widget_show_all ((GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->camera_view;
	camera_widgets_camera_view_start (_tmp28_);
	_g_object_unref0 (window_handle);
	_g_object_unref0 (grid);
	_g_object_unref0 (overlay);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
camera_main_window_class_init (CameraMainWindowClass * klass,
                               gpointer klass_data)
{
	camera_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CameraMainWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) camera_main_window_real_configure_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_camera_main_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_camera_main_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = camera_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = camera_main_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CAMERA_MAIN_WINDOW_RECORDING_PROPERTY, camera_main_window_properties[CAMERA_MAIN_WINDOW_RECORDING_PROPERTY] = g_param_spec_boolean ("recording", "recording", "recording", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
camera_main_window_instance_init (CameraMainWindow * self,
                                  gpointer klass)
{
	self->priv = camera_main_window_get_instance_private (self);
	self->priv->configure_id = (guint) 0;
	self->priv->timer_running = FALSE;
	self->priv->_recording = FALSE;
	self->priv->recording_timeout = 0U;
}

static void
camera_main_window_finalize (GObject * obj)
{
	CameraMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CAMERA_TYPE_MAIN_WINDOW, CameraMainWindow);
	_g_object_unref0 (self->priv->camera_view);
	_g_object_unref0 (self->priv->camera_options);
	_g_object_unref0 (self->priv->take_button);
	_g_object_unref0 (self->priv->take_image);
	_g_object_unref0 (self->priv->take_timer_label);
	_g_object_unref0 (self->priv->camera_menu_revealer);
	_g_object_unref0 (self->priv->video_timer_revealer);
	_g_object_unref0 (self->priv->timer_button);
	_g_object_unref0 (self->priv->mode_switch);
	_g_object_unref0 (self->priv->menu_button);
	_g_object_unref0 (self->priv->linked_box);
	G_OBJECT_CLASS (camera_main_window_parent_class)->finalize (obj);
}

static GType
camera_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CameraMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) camera_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CameraMainWindow), 0, (GInstanceInitFunc) camera_main_window_instance_init, NULL };
	GType camera_main_window_type_id;
	camera_main_window_type_id = g_type_register_static (hdy_application_window_get_type (), "CameraMainWindow", &g_define_type_info, 0);
	CameraMainWindow_private_offset = g_type_add_instance_private (camera_main_window_type_id, sizeof (CameraMainWindowPrivate));
	return camera_main_window_type_id;
}

GType
camera_main_window_get_type (void)
{
	static volatile gsize camera_main_window_type_id__once = 0;
	if (g_once_init_enter (&camera_main_window_type_id__once)) {
		GType camera_main_window_type_id;
		camera_main_window_type_id = camera_main_window_get_type_once ();
		g_once_init_leave (&camera_main_window_type_id__once, camera_main_window_type_id);
	}
	return camera_main_window_type_id__once;
}

static void
_vala_camera_main_window_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	CameraMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAMERA_TYPE_MAIN_WINDOW, CameraMainWindow);
	switch (property_id) {
		case CAMERA_MAIN_WINDOW_RECORDING_PROPERTY:
		g_value_set_boolean (value, camera_main_window_get_recording (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_camera_main_window_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	CameraMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CAMERA_TYPE_MAIN_WINDOW, CameraMainWindow);
	switch (property_id) {
		case CAMERA_MAIN_WINDOW_RECORDING_PROPERTY:
		camera_main_window_set_recording (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

