/* SourceRow.c generated by valac 0.56.16, the Vala compiler
 * generated from SourceRow.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2013-2015 Maya Developers (http://launchpad.net/maya)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <float.h>
#include <math.h>
#include "elementary-calendar.h"
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CALENDAR_TYPE_SOURCE_ROW (calendar_source_row_get_type ())
#define CALENDAR_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow))
#define CALENDAR_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRowClass))
#define CALENDAR_IS_SOURCE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_TYPE_SOURCE_ROW))
#define CALENDAR_IS_SOURCE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_TYPE_SOURCE_ROW))
#define CALENDAR_SOURCE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRowClass))

typedef struct _CalendarSourceRow CalendarSourceRow;
typedef struct _CalendarSourceRowClass CalendarSourceRowClass;
typedef struct _CalendarSourceRowPrivate CalendarSourceRowPrivate;
enum  {
	CALENDAR_SOURCE_ROW_0_PROPERTY,
	CALENDAR_SOURCE_ROW_LOCATION_PROPERTY,
	CALENDAR_SOURCE_ROW_LABEL_PROPERTY,
	CALENDAR_SOURCE_ROW_SOURCE_PROPERTY,
	CALENDAR_SOURCE_ROW_NUM_PROPERTIES
};
static GParamSpec* calendar_source_row_properties[CALENDAR_SOURCE_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block32Data Block32Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	CALENDAR_SOURCE_ROW_REMOVE_REQUEST_SIGNAL,
	CALENDAR_SOURCE_ROW_EDIT_REQUEST_SIGNAL,
	CALENDAR_SOURCE_ROW_NUM_SIGNALS
};
static guint calendar_source_row_signals[CALENDAR_SOURCE_ROW_NUM_SIGNALS] = {0};

struct _CalendarSourceRow {
	GtkListBoxRow parent_instance;
	CalendarSourceRowPrivate * priv;
};

struct _CalendarSourceRowClass {
	GtkListBoxRowClass parent_class;
};

struct _CalendarSourceRowPrivate {
	gchar* _location;
	gchar* _label;
	ESource* _source;
	GtkStack* stack;
	GtkGrid* info_grid;
	GtkButton* delete_button;
	GtkRevealer* delete_revealer;
	GtkButton* edit_button;
	GtkRevealer* edit_revealer;
	GtkLabel* calendar_name_label;
	GtkLabel* message_label;
	GtkCheckButton* visible_checkbutton;
};

struct _Block32Data {
	int _ref_count_;
	CalendarSourceRow* self;
	ESourceCalendar* cal;
	ESource* source;
};

static gint CalendarSourceRow_private_offset;
static gpointer calendar_source_row_parent_class = NULL;

VALA_EXTERN GType calendar_source_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarSourceRow, g_object_unref)
VALA_EXTERN CalendarSourceRow* calendar_source_row_new (ESource* source);
VALA_EXTERN CalendarSourceRow* calendar_source_row_construct (GType object_type,
                                                  ESource* source);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void calendar_source_row_set_source (CalendarSourceRow* self,
                                     ESource* value);
static void calendar_source_row_set_label (CalendarSourceRow* self,
                                    const gchar* value);
static void calendar_source_row_set_location (CalendarSourceRow* self,
                                       const gchar* value);
static void __lambda149_ (Block32Data* _data32_);
static void ___lambda149__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self);
static void calendar_source_row_style_calendar_color (CalendarSourceRow* self,
                                               const gchar* color);
static void __lambda150_ (CalendarSourceRow* self);
static void ___lambda150__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda151_ (Block32Data* _data32_);
static void ___lambda151__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda152_ (Block32Data* _data32_);
static void ___lambda152__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void __lambda153_ (CalendarSourceRow* self);
static void ___lambda153__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static gboolean __lambda154_ (CalendarSourceRow* self,
                       GdkEventCrossing* event);
static gboolean ___lambda154__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self);
static gboolean __lambda155_ (CalendarSourceRow* self,
                       GdkEventCrossing* event);
static gboolean ___lambda155__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self);
VALA_EXTERN void calendar_source_row_source_has_changed (CalendarSourceRow* self);
static void _calendar_source_row_source_has_changed_e_source_changed (ESource* _sender,
                                                               gpointer self);
VALA_EXTERN ESource* calendar_source_row_get_source (CalendarSourceRow* self);
VALA_EXTERN void calendar_source_row_show_calendar_removed (CalendarSourceRow* self);
VALA_EXTERN const gchar* calendar_source_row_get_location (CalendarSourceRow* self);
VALA_EXTERN const gchar* calendar_source_row_get_label (CalendarSourceRow* self);
static void calendar_source_row_finalize (GObject * obj);
static GType calendar_source_row_get_type_once (void);
static void _vala_calendar_source_row_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_calendar_source_row_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
calendar_source_row_get_instance_private (CalendarSourceRow* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarSourceRow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		CalendarSourceRow* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->cal);
		_g_object_unref0 (_data32_->source);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
__lambda149_ (Block32Data* _data32_)
{
	CalendarSourceRow* self;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	ESourceCalendar* _tmp6_;
	GtkCheckButton* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GError* _inner_error0_ = NULL;
	self = _data32_->self;
	_tmp0_ = calendar_event_store_get_default ();
	calmodel = _tmp0_;
	_tmp1_ = self->priv->visible_checkbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == TRUE) {
		CalendarEventStore* _tmp4_;
		_tmp4_ = calmodel;
		calendar_event_store_add_source (_tmp4_, _data32_->source);
	} else {
		CalendarEventStore* _tmp5_;
		_tmp5_ = calmodel;
		calendar_event_store_remove_source (_tmp5_, _data32_->source);
	}
	_tmp6_ = _data32_->cal;
	_tmp7_ = self->priv->visible_checkbutton;
	_tmp8_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp7_);
	_tmp9_ = _tmp8_;
	e_source_selectable_set_selected ((ESourceSelectable*) _tmp6_, _tmp9_);
	{
		e_source_write_sync (_data32_->source, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_critical ("SourceRow.vala:68: %s", _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (calmodel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (calmodel);
}

static void
___lambda149__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                         gpointer self)
{
	__lambda149_ (self);
}

static void
__lambda150_ (CalendarSourceRow* self)
{
	gtk_widget_hide ((GtkWidget*) self);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda150__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda150_ ((CalendarSourceRow*) self);
}

static void
__lambda151_ (Block32Data* _data32_)
{
	CalendarSourceRow* self;
	self = _data32_->self;
	g_signal_emit (self, calendar_source_row_signals[CALENDAR_SOURCE_ROW_REMOVE_REQUEST_SIGNAL], 0, _data32_->source);
}

static void
___lambda151__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda151_ (self);
}

static void
__lambda152_ (Block32Data* _data32_)
{
	CalendarSourceRow* self;
	self = _data32_->self;
	g_signal_emit (self, calendar_source_row_signals[CALENDAR_SOURCE_ROW_EDIT_REQUEST_SIGNAL], 0, _data32_->source);
}

static void
___lambda152__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda152_ (self);
}

static void
__lambda153_ (CalendarSourceRow* self)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	GtkStack* _tmp2_;
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	calendar_event_store_restore_calendar (_tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp2_, "calendar");
}

static void
___lambda153__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
	__lambda153_ ((CalendarSourceRow*) self);
}

static gboolean
__lambda154_ (CalendarSourceRow* self,
              GdkEventCrossing* event)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->delete_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, TRUE);
	_tmp1_ = self->priv->edit_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, TRUE);
	result = FALSE;
	return result;
}

static gboolean
___lambda154__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                             GdkEventCrossing* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda154_ ((CalendarSourceRow*) self, event);
	return result;
}

static gboolean
__lambda155_ (CalendarSourceRow* self,
              GdkEventCrossing* event)
{
	GtkRevealer* _tmp0_;
	GtkRevealer* _tmp1_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->detail == GDK_NOTIFY_INFERIOR) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->delete_revealer;
	gtk_revealer_set_reveal_child (_tmp0_, FALSE);
	_tmp1_ = self->priv->edit_revealer;
	gtk_revealer_set_reveal_child (_tmp1_, FALSE);
	result = FALSE;
	return result;
}

static gboolean
___lambda155__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                             GdkEventCrossing* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda155_ ((CalendarSourceRow*) self, event);
	return result;
}

static void
_calendar_source_row_source_has_changed_e_source_changed (ESource* _sender,
                                                          gpointer self)
{
	calendar_source_row_source_has_changed ((CalendarSourceRow*) self);
}

CalendarSourceRow*
calendar_source_row_construct (GType object_type,
                               ESource* source)
{
	CalendarSourceRow * self = NULL;
	Block32Data* _data32_;
	ESource* _tmp0_;
	ESourceExtension* _tmp1_;
	ESourceCalendar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkCheckButton* _tmp12_;
	GtkCheckButton* _tmp13_;
	ESourceCalendar* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	GtkCheckButton* _tmp17_;
	ESourceCalendar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GtkButton* _tmp21_;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_;
	gboolean _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	GtkButton* _tmp30_;
	GtkStyleContext* _tmp31_;
	GtkRevealer* _tmp32_;
	GtkRevealer* _tmp33_;
	GtkRevealer* _tmp34_;
	GtkButton* _tmp35_;
	GtkRevealer* _tmp36_;
	GtkRevealer* _tmp37_;
	GtkButton* _tmp38_;
	const gchar* _tmp39_ = NULL;
	gboolean _tmp40_;
	gboolean _tmp41_;
	GtkButton* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	gboolean _tmp45_;
	gboolean _tmp46_;
	GtkRevealer* _tmp47_;
	GtkRevealer* _tmp48_;
	GtkRevealer* _tmp49_;
	GtkButton* _tmp50_;
	GtkRevealer* _tmp51_;
	GtkRevealer* _tmp52_;
	GtkGrid* calendar_grid = NULL;
	GtkGrid* _tmp53_;
	GtkCheckButton* _tmp54_;
	GtkLabel* _tmp55_;
	GtkRevealer* _tmp56_;
	GtkRevealer* _tmp57_;
	GtkEventBox* calendar_event_box = NULL;
	GtkEventBox* _tmp58_;
	GtkButton* undo_button = NULL;
	GtkButton* _tmp59_;
	GtkButton* close_button = NULL;
	GtkButton* _tmp60_;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GtkLabel* _tmp65_;
	GtkLabel* _tmp66_;
	GtkLabel* _tmp67_;
	GtkGrid* _tmp68_;
	GtkGrid* _tmp69_;
	GtkGrid* _tmp70_;
	GtkGrid* _tmp71_;
	GtkGrid* _tmp72_;
	GtkLabel* _tmp73_;
	GtkGrid* _tmp74_;
	GtkStack* _tmp75_;
	GtkStack* _tmp76_;
	GtkStack* _tmp77_;
	GtkGrid* _tmp78_;
	GtkStack* _tmp79_;
	GtkStack* _tmp80_;
	GtkStack* _tmp81_;
	GtkButton* _tmp82_;
	GtkButton* _tmp83_;
	g_return_val_if_fail (source != NULL, NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data32_->source);
	_data32_->source = _tmp0_;
	self = (CalendarSourceRow*) g_object_new (object_type, NULL);
	_data32_->self = g_object_ref (self);
	calendar_source_row_set_source (self, _data32_->source);
	_tmp1_ = e_source_get_extension (_data32_->source, E_SOURCE_EXTENSION_CALENDAR);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_calendar_get_type (), ESourceCalendar));
	_data32_->cal = _tmp2_;
	_tmp3_ = e_source_dup_display_name (_data32_->source);
	_tmp4_ = _tmp3_;
	_tmp5_ = (GtkLabel*) gtk_label_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->calendar_name_label);
	self->priv->calendar_name_label = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp6_ = self->priv->calendar_name_label;
	gtk_label_set_xalign (_tmp6_, (gfloat) 0);
	_tmp7_ = self->priv->calendar_name_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = e_source_dup_display_name (_data32_->source);
	_tmp9_ = _tmp8_;
	calendar_source_row_set_label (self, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = maya_util_get_source_location (_data32_->source);
	_tmp11_ = _tmp10_;
	calendar_source_row_set_location (self, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = (GtkCheckButton*) gtk_check_button_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->visible_checkbutton);
	self->priv->visible_checkbutton = _tmp12_;
	_tmp13_ = self->priv->visible_checkbutton;
	_tmp14_ = _data32_->cal;
	_tmp15_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp14_);
	_tmp16_ = _tmp15_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, _tmp16_);
	_tmp17_ = self->priv->visible_checkbutton;
	g_signal_connect_data ((GtkToggleButton*) _tmp17_, "toggled", (GCallback) ___lambda149__gtk_toggle_button_toggled, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	_tmp18_ = _data32_->cal;
	_tmp19_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp18_);
	_tmp20_ = _tmp19_;
	calendar_source_row_style_calendar_color (self, _tmp20_);
	_g_free0 (_tmp20_);
	_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->delete_button);
	self->priv->delete_button = _tmp21_;
	_tmp23_ = e_source_get_removable (_data32_->source);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		_tmp22_ = _ ("Remove");
	} else {
		_tmp22_ = _ ("Not Removable");
	}
	_tmp25_ = self->priv->delete_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _tmp22_);
	_tmp26_ = self->priv->delete_button;
	gtk_button_set_relief (_tmp26_, GTK_RELIEF_NONE);
	_tmp27_ = self->priv->delete_button;
	_tmp28_ = e_source_get_removable (_data32_->source);
	_tmp29_ = _tmp28_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp27_, _tmp29_);
	_tmp30_ = self->priv->delete_button;
	_tmp31_ = gtk_widget_get_style_context ((GtkWidget*) _tmp30_);
	gtk_style_context_add_class (_tmp31_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp32_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->delete_revealer);
	self->priv->delete_revealer = _tmp32_;
	_tmp33_ = self->priv->delete_revealer;
	gtk_revealer_set_transition_type (_tmp33_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	_tmp34_ = self->priv->delete_revealer;
	_tmp35_ = self->priv->delete_button;
	gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
	_tmp36_ = self->priv->delete_revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->delete_revealer;
	gtk_revealer_set_reveal_child (_tmp37_, FALSE);
	_tmp38_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp38_);
	_g_object_unref0 (self->priv->edit_button);
	self->priv->edit_button = _tmp38_;
	_tmp40_ = e_source_get_writable (_data32_->source);
	_tmp41_ = _tmp40_;
	if (_tmp41_) {
		_tmp39_ = _ ("Edit…");
	} else {
		_tmp39_ = _ ("Not Editable");
	}
	_tmp42_ = self->priv->edit_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp42_, _tmp39_);
	_tmp43_ = self->priv->edit_button;
	gtk_button_set_relief (_tmp43_, GTK_RELIEF_NONE);
	_tmp44_ = self->priv->edit_button;
	_tmp45_ = e_source_get_writable (_data32_->source);
	_tmp46_ = _tmp45_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp44_, _tmp46_);
	_tmp47_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp47_);
	_g_object_unref0 (self->priv->edit_revealer);
	self->priv->edit_revealer = _tmp47_;
	_tmp48_ = self->priv->edit_revealer;
	gtk_revealer_set_transition_type (_tmp48_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	_tmp49_ = self->priv->edit_revealer;
	_tmp50_ = self->priv->edit_button;
	gtk_container_add ((GtkContainer*) _tmp49_, (GtkWidget*) _tmp50_);
	_tmp51_ = self->priv->edit_revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->edit_revealer;
	gtk_revealer_set_reveal_child (_tmp52_, FALSE);
	_tmp53_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp53_);
	calendar_grid = _tmp53_;
	gtk_grid_set_column_spacing (calendar_grid, 6);
	gtk_widget_set_margin_start ((GtkWidget*) calendar_grid, 8);
	gtk_widget_set_margin_end ((GtkWidget*) calendar_grid, 6);
	_tmp54_ = self->priv->visible_checkbutton;
	gtk_grid_attach (calendar_grid, (GtkWidget*) _tmp54_, 0, 0, 1, 1);
	_tmp55_ = self->priv->calendar_name_label;
	gtk_grid_attach (calendar_grid, (GtkWidget*) _tmp55_, 2, 0, 1, 1);
	_tmp56_ = self->priv->delete_revealer;
	gtk_grid_attach (calendar_grid, (GtkWidget*) _tmp56_, 3, 0, 1, 1);
	_tmp57_ = self->priv->edit_revealer;
	gtk_grid_attach (calendar_grid, (GtkWidget*) _tmp57_, 4, 0, 1, 1);
	_tmp58_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp58_);
	calendar_event_box = _tmp58_;
	gtk_container_add ((GtkContainer*) calendar_event_box, (GtkWidget*) calendar_grid);
	gtk_widget_show ((GtkWidget*) calendar_event_box);
	_tmp59_ = (GtkButton*) gtk_button_new_with_label (_ ("Undo"));
	g_object_ref_sink (_tmp59_);
	undo_button = _tmp59_;
	gtk_widget_set_margin_end ((GtkWidget*) undo_button, 6);
	_tmp60_ = (GtkButton*) gtk_button_new_from_icon_name ("process-stop-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp60_);
	close_button = _tmp60_;
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	_tmp61_ = e_source_get_display_name (_data32_->source);
	_tmp62_ = _tmp61_;
	_tmp63_ = g_strdup_printf (_ ("\"%s\" removed"), _tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = (GtkLabel*) gtk_label_new (_tmp64_);
	g_object_ref_sink (_tmp65_);
	_g_object_unref0 (self->priv->message_label);
	self->priv->message_label = _tmp65_;
	_g_free0 (_tmp64_);
	_tmp66_ = self->priv->message_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp66_, TRUE);
	_tmp67_ = self->priv->message_label;
	gtk_label_set_xalign (_tmp67_, 0.0f);
	_tmp68_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->info_grid);
	self->priv->info_grid = _tmp68_;
	_tmp69_ = self->priv->info_grid;
	gtk_grid_set_column_spacing (_tmp69_, 12);
	_tmp70_ = self->priv->info_grid;
	gtk_grid_set_row_spacing (_tmp70_, 6);
	_tmp71_ = self->priv->info_grid;
	gtk_container_add ((GtkContainer*) _tmp71_, (GtkWidget*) close_button);
	_tmp72_ = self->priv->info_grid;
	_tmp73_ = self->priv->message_label;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = self->priv->info_grid;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) undo_button);
	_tmp75_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp75_);
	_g_object_unref0 (self->priv->stack);
	self->priv->stack = _tmp75_;
	_tmp76_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp76_, GTK_STACK_TRANSITION_TYPE_OVER_RIGHT_LEFT);
	_tmp77_ = self->priv->stack;
	_tmp78_ = self->priv->info_grid;
	gtk_stack_add_named (_tmp77_, (GtkWidget*) _tmp78_, "info");
	_tmp79_ = self->priv->stack;
	gtk_stack_add_named (_tmp79_, (GtkWidget*) calendar_event_box, "calendar");
	_tmp80_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp80_, "calendar");
	_tmp81_ = self->priv->stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp81_);
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda150__gtk_button_clicked, self, 0);
	_tmp82_ = self->priv->delete_button;
	g_signal_connect_data (_tmp82_, "clicked", (GCallback) ___lambda151__gtk_button_clicked, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	_tmp83_ = self->priv->edit_button;
	g_signal_connect_data (_tmp83_, "clicked", (GCallback) ___lambda152__gtk_button_clicked, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
	g_signal_connect_object (undo_button, "clicked", (GCallback) ___lambda153__gtk_button_clicked, self, 0);
	gtk_widget_add_events ((GtkWidget*) calendar_event_box, (gint) (GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK));
	g_signal_connect_object ((GtkWidget*) calendar_event_box, "enter-notify-event", (GCallback) ___lambda154__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) calendar_event_box, "leave-notify-event", (GCallback) ___lambda155__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object (_data32_->source, "changed", (GCallback) _calendar_source_row_source_has_changed_e_source_changed, self, 0);
	_g_object_unref0 (close_button);
	_g_object_unref0 (undo_button);
	_g_object_unref0 (calendar_event_box);
	_g_object_unref0 (calendar_grid);
	block32_data_unref (_data32_);
	_data32_ = NULL;
	return self;
}

CalendarSourceRow*
calendar_source_row_new (ESource* source)
{
	return calendar_source_row_construct (CALENDAR_TYPE_SOURCE_ROW, source);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
calendar_source_row_style_calendar_color (CalendarSourceRow* self,
                                          const gchar* color)
{
	gchar* css_color = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	_tmp0_ = string_slice (color, (glong) 0, (glong) 7);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("@define-color accent_color %s;", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	css_color = _tmp3_;
	_tmp4_ = gtk_css_provider_new ();
	style_provider = _tmp4_;
	{
		gint _tmp5_;
		gint _tmp6_;
		GtkCheckButton* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp5_ = strlen (css_color);
		_tmp6_ = _tmp5_;
		gtk_css_provider_load_from_data (style_provider, css_color, (gssize) _tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = self->priv->visible_checkbutton;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_add_provider (_tmp8_, (GtkStyleProvider*) style_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_warning ("SourceRow.vala:177: Could not create CSS Provider: %s\n" \
"Stylesheet:\n" \
"%s", _tmp10_, css_color);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (style_provider);
		_g_free0 (css_color);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (style_provider);
	_g_free0 (css_color);
}

void
calendar_source_row_source_has_changed (CalendarSourceRow* self)
{
	GtkLabel* _tmp0_;
	ESource* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	ESource* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	ESourceCalendar* cal = NULL;
	ESource* _tmp10_;
	ESourceExtension* _tmp11_;
	ESourceCalendar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkCheckButton* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->calendar_name_label;
	_tmp1_ = self->priv->_source;
	_tmp2_ = e_source_dup_display_name (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->message_label;
	_tmp5_ = self->priv->_source;
	_tmp6_ = e_source_get_display_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("\"%s\" removed"), _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp4_, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->_source;
	_tmp11_ = e_source_get_extension (_tmp10_, E_SOURCE_EXTENSION_CALENDAR);
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, e_source_calendar_get_type (), ESourceCalendar));
	cal = _tmp12_;
	_tmp13_ = e_source_selectable_dup_color ((ESourceSelectable*) cal);
	_tmp14_ = _tmp13_;
	calendar_source_row_style_calendar_color (self, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->visible_checkbutton;
	_tmp16_ = e_source_selectable_get_selected ((ESourceSelectable*) cal);
	_tmp17_ = _tmp16_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp15_, _tmp17_);
	_g_object_unref0 (cal);
}

void
calendar_source_row_show_calendar_removed (CalendarSourceRow* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp0_, "info");
}

const gchar*
calendar_source_row_get_location (CalendarSourceRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static void
calendar_source_row_set_location (CalendarSourceRow* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_source_row_get_location (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LOCATION_PROPERTY]);
	}
}

const gchar*
calendar_source_row_get_label (CalendarSourceRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
calendar_source_row_set_label (CalendarSourceRow* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_source_row_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LABEL_PROPERTY]);
	}
}

ESource*
calendar_source_row_get_source (CalendarSourceRow* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

static void
calendar_source_row_set_source (CalendarSourceRow* self,
                                ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_source_row_get_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_source);
		self->priv->_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_source_row_properties[CALENDAR_SOURCE_ROW_SOURCE_PROPERTY]);
	}
}

static void
calendar_source_row_class_init (CalendarSourceRowClass * klass,
                                gpointer klass_data)
{
	calendar_source_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarSourceRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_calendar_source_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_calendar_source_row_set_property;
	G_OBJECT_CLASS (klass)->finalize = calendar_source_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_SOURCE_ROW_LOCATION_PROPERTY, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LOCATION_PROPERTY] = g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_SOURCE_ROW_LABEL_PROPERTY, calendar_source_row_properties[CALENDAR_SOURCE_ROW_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_SOURCE_ROW_SOURCE_PROPERTY, calendar_source_row_properties[CALENDAR_SOURCE_ROW_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	calendar_source_row_signals[CALENDAR_SOURCE_ROW_REMOVE_REQUEST_SIGNAL] = g_signal_new ("remove-request", CALENDAR_TYPE_SOURCE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, e_source_get_type ());
	calendar_source_row_signals[CALENDAR_SOURCE_ROW_EDIT_REQUEST_SIGNAL] = g_signal_new ("edit-request", CALENDAR_TYPE_SOURCE_ROW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, e_source_get_type ());
}

static void
calendar_source_row_instance_init (CalendarSourceRow * self,
                                   gpointer klass)
{
	self->priv = calendar_source_row_get_instance_private (self);
}

static void
calendar_source_row_finalize (GObject * obj)
{
	CalendarSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow);
	_g_free0 (self->priv->_location);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_source);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->info_grid);
	_g_object_unref0 (self->priv->delete_button);
	_g_object_unref0 (self->priv->delete_revealer);
	_g_object_unref0 (self->priv->edit_button);
	_g_object_unref0 (self->priv->edit_revealer);
	_g_object_unref0 (self->priv->calendar_name_label);
	_g_object_unref0 (self->priv->message_label);
	_g_object_unref0 (self->priv->visible_checkbutton);
	G_OBJECT_CLASS (calendar_source_row_parent_class)->finalize (obj);
}

static GType
calendar_source_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarSourceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_source_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarSourceRow), 0, (GInstanceInitFunc) calendar_source_row_instance_init, NULL };
	GType calendar_source_row_type_id;
	calendar_source_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "CalendarSourceRow", &g_define_type_info, 0);
	CalendarSourceRow_private_offset = g_type_add_instance_private (calendar_source_row_type_id, sizeof (CalendarSourceRowPrivate));
	return calendar_source_row_type_id;
}

GType
calendar_source_row_get_type (void)
{
	static volatile gsize calendar_source_row_type_id__once = 0;
	if (g_once_init_enter (&calendar_source_row_type_id__once)) {
		GType calendar_source_row_type_id;
		calendar_source_row_type_id = calendar_source_row_get_type_once ();
		g_once_init_leave (&calendar_source_row_type_id__once, calendar_source_row_type_id);
	}
	return calendar_source_row_type_id__once;
}

static void
_vala_calendar_source_row_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	CalendarSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow);
	switch (property_id) {
		case CALENDAR_SOURCE_ROW_LOCATION_PROPERTY:
		g_value_set_string (value, calendar_source_row_get_location (self));
		break;
		case CALENDAR_SOURCE_ROW_LABEL_PROPERTY:
		g_value_set_string (value, calendar_source_row_get_label (self));
		break;
		case CALENDAR_SOURCE_ROW_SOURCE_PROPERTY:
		g_value_set_object (value, calendar_source_row_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_calendar_source_row_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	CalendarSourceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_SOURCE_ROW, CalendarSourceRow);
	switch (property_id) {
		case CALENDAR_SOURCE_ROW_LOCATION_PROPERTY:
		calendar_source_row_set_location (self, g_value_get_string (value));
		break;
		case CALENDAR_SOURCE_ROW_LABEL_PROPERTY:
		calendar_source_row_set_label (self, g_value_get_string (value));
		break;
		case CALENDAR_SOURCE_ROW_SOURCE_PROPERTY:
		calendar_source_row_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

