/* CalendarRow.c generated by valac 0.56.16, the Vala compiler
 * generated from CalendarRow.vala, do not modify */

/*
 * Copyright 2014-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include "elementary-calendar.h"
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#define CALENDAR_ROW_CALENDAR_COLOR_STYLE "\n" \
"        .cal-color {\n" \
"            background-color: %s;\n" \
"            border-radius: 50%;\n" \
"        }\n" \
"    "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CALENDAR_ROW (calendar_row_get_type ())
#define CALENDAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALENDAR_ROW, CalendarRow))
#define CALENDAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALENDAR_ROW, CalendarRowClass))
#define IS_CALENDAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALENDAR_ROW))
#define IS_CALENDAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALENDAR_ROW))
#define CALENDAR_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALENDAR_ROW, CalendarRowClass))

typedef struct _CalendarRow CalendarRow;
typedef struct _CalendarRowClass CalendarRowClass;
typedef struct _CalendarRowPrivate CalendarRowPrivate;
enum  {
	CALENDAR_ROW_0_PROPERTY,
	CALENDAR_ROW_LABEL_PROPERTY,
	CALENDAR_ROW_LOCATION_PROPERTY,
	CALENDAR_ROW_SELECTED_PROPERTY,
	CALENDAR_ROW_SOURCE_PROPERTY,
	CALENDAR_ROW_NUM_PROPERTIES
};
static GParamSpec* calendar_row_properties[CALENDAR_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CalendarRow {
	GtkGrid parent_instance;
	CalendarRowPrivate * priv;
};

struct _CalendarRowClass {
	GtkGridClass parent_class;
};

struct _CalendarRowPrivate {
	gchar* _label;
	gchar* _location;
	gboolean _selected;
	ESource* _source;
	GtkStyleContext* calendar_color_context;
};

static gint CalendarRow_private_offset;
static gpointer calendar_row_parent_class = NULL;

VALA_EXTERN GType calendar_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarRow, g_object_unref)
VALA_EXTERN CalendarRow* calendar_row_new (ESource* source);
VALA_EXTERN CalendarRow* calendar_row_construct (GType object_type,
                                     ESource* source);
static void calendar_row_apply_source (CalendarRow* self);
static void calendar_row_set_label (CalendarRow* self,
                             const gchar* value);
static void calendar_row_set_location (CalendarRow* self,
                                const gchar* value);
VALA_EXTERN const gchar* calendar_row_get_label (CalendarRow* self);
VALA_EXTERN const gchar* calendar_row_get_location (CalendarRow* self);
VALA_EXTERN gboolean calendar_row_get_selected (CalendarRow* self);
VALA_EXTERN void calendar_row_set_selected (CalendarRow* self,
                                gboolean value);
VALA_EXTERN ESource* calendar_row_get_source (CalendarRow* self);
VALA_EXTERN void calendar_row_set_source (CalendarRow* self,
                              ESource* value);
static GObject * calendar_row_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void calendar_row_finalize (GObject * obj);
static GType calendar_row_get_type_once (void);
static void _vala_calendar_row_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_calendar_row_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
calendar_row_get_instance_private (CalendarRow* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarRow_private_offset);
}

CalendarRow*
calendar_row_construct (GType object_type,
                        ESource* source)
{
	CalendarRow * self = NULL;
	g_return_val_if_fail (source != NULL, NULL);
	self = (CalendarRow*) g_object_new (object_type, "source", source, NULL);
	return self;
}

CalendarRow*
calendar_row_new (ESource* source)
{
	return calendar_row_construct (TYPE_CALENDAR_ROW, source);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
calendar_row_apply_source (CalendarRow* self)
{
	ESourceCalendar* cal = NULL;
	ESource* _tmp0_;
	ESourceExtension* _tmp1_;
	ESourceCalendar* _tmp2_;
	ESource* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ESource* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* css_color = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GtkCssProvider* style_provider = NULL;
	GtkCssProvider* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source;
	_tmp1_ = e_source_get_extension (_tmp0_, E_SOURCE_EXTENSION_CALENDAR);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_calendar_get_type (), ESourceCalendar));
	cal = _tmp2_;
	_tmp3_ = self->priv->_source;
	_tmp4_ = e_source_dup_display_name (_tmp3_);
	_tmp5_ = _tmp4_;
	calendar_row_set_label (self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_source;
	_tmp7_ = maya_util_get_source_location (_tmp6_);
	_tmp8_ = _tmp7_;
	calendar_row_set_location (self, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = e_source_selectable_dup_color ((ESourceSelectable*) cal);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup_printf (CALENDAR_ROW_CALENDAR_COLOR_STYLE, _tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	css_color = _tmp12_;
	_tmp13_ = gtk_css_provider_new ();
	style_provider = _tmp13_;
	{
		gint _tmp14_;
		gint _tmp15_;
		GtkStyleContext* _tmp16_;
		_tmp14_ = strlen (css_color);
		_tmp15_ = _tmp14_;
		gtk_css_provider_load_from_data (style_provider, css_color, (gssize) _tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp16_ = self->priv->calendar_color_context;
		gtk_style_context_add_provider (_tmp16_, (GtkStyleProvider*) style_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("CalendarRow.vala:88: Could not create CSS Provider: %s\n" \
"Stylesheet:\n" \
"%s", _tmp18_, css_color);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (style_provider);
		_g_free0 (css_color);
		_g_object_unref0 (cal);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (style_provider);
	_g_free0 (css_color);
	_g_object_unref0 (cal);
}

const gchar*
calendar_row_get_label (CalendarRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

static void
calendar_row_set_label (CalendarRow* self,
                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_row_get_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_label);
		self->priv->_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_row_properties[CALENDAR_ROW_LABEL_PROPERTY]);
	}
}

const gchar*
calendar_row_get_location (CalendarRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}

static void
calendar_row_set_location (CalendarRow* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_row_get_location (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_location);
		self->priv->_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_row_properties[CALENDAR_ROW_LOCATION_PROPERTY]);
	}
}

gboolean
calendar_row_get_selected (CalendarRow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected;
	return result;
}

void
calendar_row_set_selected (CalendarRow* self,
                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_row_get_selected (self);
	if (old_value != value) {
		self->priv->_selected = value;
		g_object_notify_by_pspec ((GObject *) self, calendar_row_properties[CALENDAR_ROW_SELECTED_PROPERTY]);
	}
}

ESource*
calendar_row_get_source (CalendarRow* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

void
calendar_row_set_source (CalendarRow* self,
                         ESource* value)
{
	ESource* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_source);
	self->priv->_source = _tmp0_;
	calendar_row_apply_source (self);
	g_object_notify_by_pspec ((GObject *) self, calendar_row_properties[CALENDAR_ROW_SOURCE_PROPERTY]);
}

static GObject *
calendar_row_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	CalendarRow * self;
	GtkGrid* calendar_color = NULL;
	GtkGrid* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkLabel* calendar_name_label = NULL;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkImage* selection_icon = NULL;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkGrid* _tmp15_;
	GtkLabel* _tmp16_;
	GtkImage* _tmp17_;
	GtkLabel* _tmp18_;
	GtkImage* _tmp19_;
	parent_class = G_OBJECT_CLASS (calendar_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALENDAR_ROW, CalendarRow);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 6);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	calendar_color = _tmp0_;
	_tmp1_ = calendar_color;
	g_object_set ((GtkWidget*) _tmp1_, "height-request", 12, NULL);
	_tmp2_ = calendar_color;
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	_tmp3_ = calendar_color;
	g_object_set ((GtkWidget*) _tmp3_, "width-request", 12, NULL);
	_tmp4_ = calendar_color;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->calendar_color_context);
	self->priv->calendar_color_context = _tmp6_;
	_tmp7_ = self->priv->calendar_color_context;
	gtk_style_context_add_class (_tmp7_, "cal-color");
	_tmp8_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp8_);
	calendar_name_label = _tmp8_;
	_tmp9_ = calendar_name_label;
	gtk_label_set_xalign (_tmp9_, (gfloat) 0);
	_tmp10_ = calendar_name_label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = calendar_name_label;
	gtk_label_set_ellipsize (_tmp11_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("object-select-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp12_);
	selection_icon = _tmp12_;
	_tmp13_ = selection_icon;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp13_, TRUE);
	_tmp14_ = selection_icon;
	gtk_widget_set_visible ((GtkWidget*) _tmp14_, FALSE);
	_tmp15_ = calendar_color;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp15_);
	_tmp16_ = calendar_name_label;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = selection_icon;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = calendar_name_label;
	g_object_bind_property_with_closures ((GObject*) self, "label", (GObject*) _tmp18_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp19_ = selection_icon;
	g_object_bind_property_with_closures ((GObject*) self, "selected", (GObject*) _tmp19_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (selection_icon);
	_g_object_unref0 (calendar_name_label);
	_g_object_unref0 (calendar_color);
	return obj;
}

static void
calendar_row_class_init (CalendarRowClass * klass,
                         gpointer klass_data)
{
	calendar_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarRow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_calendar_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_calendar_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = calendar_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = calendar_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_ROW_LABEL_PROPERTY, calendar_row_properties[CALENDAR_ROW_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_ROW_LOCATION_PROPERTY, calendar_row_properties[CALENDAR_ROW_LOCATION_PROPERTY] = g_param_spec_string ("location", "location", "location", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_ROW_SELECTED_PROPERTY, calendar_row_properties[CALENDAR_ROW_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_ROW_SOURCE_PROPERTY, calendar_row_properties[CALENDAR_ROW_SOURCE_PROPERTY] = g_param_spec_object ("source", "source", "source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
calendar_row_instance_init (CalendarRow * self,
                            gpointer klass)
{
	self->priv = calendar_row_get_instance_private (self);
}

static void
calendar_row_finalize (GObject * obj)
{
	CalendarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALENDAR_ROW, CalendarRow);
	_g_free0 (self->priv->_label);
	_g_free0 (self->priv->_location);
	_g_object_unref0 (self->priv->_source);
	_g_object_unref0 (self->priv->calendar_color_context);
	G_OBJECT_CLASS (calendar_row_parent_class)->finalize (obj);
}

static GType
calendar_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarRow), 0, (GInstanceInitFunc) calendar_row_instance_init, NULL };
	GType calendar_row_type_id;
	calendar_row_type_id = g_type_register_static (gtk_grid_get_type (), "CalendarRow", &g_define_type_info, 0);
	CalendarRow_private_offset = g_type_add_instance_private (calendar_row_type_id, sizeof (CalendarRowPrivate));
	return calendar_row_type_id;
}

GType
calendar_row_get_type (void)
{
	static volatile gsize calendar_row_type_id__once = 0;
	if (g_once_init_enter (&calendar_row_type_id__once)) {
		GType calendar_row_type_id;
		calendar_row_type_id = calendar_row_get_type_once ();
		g_once_init_leave (&calendar_row_type_id__once, calendar_row_type_id);
	}
	return calendar_row_type_id__once;
}

static void
_vala_calendar_row_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	CalendarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CALENDAR_ROW, CalendarRow);
	switch (property_id) {
		case CALENDAR_ROW_LABEL_PROPERTY:
		g_value_set_string (value, calendar_row_get_label (self));
		break;
		case CALENDAR_ROW_LOCATION_PROPERTY:
		g_value_set_string (value, calendar_row_get_location (self));
		break;
		case CALENDAR_ROW_SELECTED_PROPERTY:
		g_value_set_boolean (value, calendar_row_get_selected (self));
		break;
		case CALENDAR_ROW_SOURCE_PROPERTY:
		g_value_set_object (value, calendar_row_get_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_calendar_row_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	CalendarRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CALENDAR_ROW, CalendarRow);
	switch (property_id) {
		case CALENDAR_ROW_LABEL_PROPERTY:
		calendar_row_set_label (self, g_value_get_string (value));
		break;
		case CALENDAR_ROW_LOCATION_PROPERTY:
		calendar_row_set_location (self, g_value_get_string (value));
		break;
		case CALENDAR_ROW_SELECTED_PROPERTY:
		calendar_row_set_selected (self, g_value_get_boolean (value));
		break;
		case CALENDAR_ROW_SOURCE_PROPERTY:
		calendar_row_set_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

