/* CalendarChooser.c generated by valac 0.56.16, the Vala compiler
 * generated from CalendarChooser.vala, do not modify */

/*
 * Copyright 2014-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <granite.h>
#include "elementary-calendar.h"
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER (maya_view_widgets_calendar_chooser_get_type ())
#define MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooser))
#define MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooserClass))
#define MAYA_VIEW_WIDGETS_IS_CALENDAR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER))
#define MAYA_VIEW_WIDGETS_IS_CALENDAR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER))
#define MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooserClass))

typedef struct _MayaViewWidgetsCalendarChooser MayaViewWidgetsCalendarChooser;
typedef struct _MayaViewWidgetsCalendarChooserClass MayaViewWidgetsCalendarChooserClass;
typedef struct _MayaViewWidgetsCalendarChooserPrivate MayaViewWidgetsCalendarChooserPrivate;
enum  {
	MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_0_PROPERTY,
	MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CURRENT_SOURCE_PROPERTY,
	MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_NUM_PROPERTIES
};
static GParamSpec* maya_view_widgets_calendar_chooser_properties[MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CALENDAR_ROW (calendar_row_get_type ())
#define CALENDAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALENDAR_ROW, CalendarRow))
#define CALENDAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALENDAR_ROW, CalendarRowClass))
#define IS_CALENDAR_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALENDAR_ROW))
#define IS_CALENDAR_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALENDAR_ROW))
#define CALENDAR_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALENDAR_ROW, CalendarRowClass))

typedef struct _CalendarRow CalendarRow;
typedef struct _CalendarRowClass CalendarRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block26Data Block26Data;

struct _MayaViewWidgetsCalendarChooser {
	GtkGrid parent_instance;
	MayaViewWidgetsCalendarChooserPrivate * priv;
	GList* sources;
};

struct _MayaViewWidgetsCalendarChooserClass {
	GtkGridClass parent_class;
};

struct _MayaViewWidgetsCalendarChooserPrivate {
	ESource* _current_source;
	GtkSearchEntry* search_entry;
};

struct _Block26Data {
	int _ref_count_;
	MayaViewWidgetsCalendarChooser* self;
	GtkListBox* list_box;
};

static gint MayaViewWidgetsCalendarChooser_private_offset;
static gpointer maya_view_widgets_calendar_chooser_parent_class = NULL;

VALA_EXTERN GType maya_view_widgets_calendar_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewWidgetsCalendarChooser, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean maya_view_widgets_calendar_chooser_filter_function (GtkListBoxRow* row,
                                                             MayaViewWidgetsCalendarChooser* self);
VALA_EXTERN GType calendar_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarRow, g_object_unref)
VALA_EXTERN const gchar* calendar_row_get_label (CalendarRow* self);
static void maya_view_widgets_calendar_chooser_header_update_func (MayaViewWidgetsCalendarChooser* self,
                                                            GtkListBoxRow* row,
                                                            GtkListBoxRow* before);
VALA_EXTERN const gchar* calendar_row_get_location (CalendarRow* self);
VALA_EXTERN void maya_view_widgets_calendar_chooser_clear_search_entry (MayaViewWidgetsCalendarChooser* self);
VALA_EXTERN MayaViewWidgetsCalendarChooser* maya_view_widgets_calendar_chooser_new (void);
VALA_EXTERN MayaViewWidgetsCalendarChooser* maya_view_widgets_calendar_chooser_construct (GType object_type);
VALA_EXTERN ESource* maya_view_widgets_calendar_chooser_get_current_source (MayaViewWidgetsCalendarChooser* self);
VALA_EXTERN void maya_view_widgets_calendar_chooser_set_current_source (MayaViewWidgetsCalendarChooser* self,
                                                            ESource* value);
static GObject * maya_view_widgets_calendar_chooser_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static Block26Data* block26_data_ref (Block26Data* _data26_);
static void block26_data_unref (void * _userdata_);
static gboolean _maya_view_widgets_calendar_chooser_filter_function_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                                       gpointer self);
static void _maya_view_widgets_calendar_chooser_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                             GtkListBoxRow* before,
                                                                                             gpointer self);
static gint _maya_view_widgets_calendar_chooser___lambda19_ (MayaViewWidgetsCalendarChooser* self,
                                                      GtkListBoxRow* row1,
                                                      GtkListBoxRow* row2);
static gint __maya_view_widgets_calendar_chooser___lambda19__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                              GtkListBoxRow* row2,
                                                                              gpointer self);
static void _maya_view_widgets_calendar_chooser___lambda20_ (Block26Data* _data26_,
                                                      GtkMovementStep mvmt,
                                                      gint count);
static void __maya_view_widgets_calendar_chooser___lambda20__gtk_list_box_move_cursor (GtkListBox* _sender,
                                                                                GtkMovementStep step,
                                                                                gint count,
                                                                                gpointer self);
static void _maya_view_widgets_calendar_chooser___lambda21_ (Block26Data* _data26_,
                                                      GtkListBoxRow* row);
VALA_EXTERN ESource* calendar_row_get_source (CalendarRow* self);
VALA_EXTERN void calendar_row_set_selected (CalendarRow* self,
                                gboolean value);
static void __maya_view_widgets_calendar_chooser___lambda21__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                                  GtkListBoxRow* row,
                                                                                  gpointer self);
static void _maya_view_widgets_calendar_chooser___lambda22_ (Block26Data* _data26_);
static void __maya_view_widgets_calendar_chooser___lambda22__gtk_entry_activate (GtkEntry* _sender,
                                                                          gpointer self);
static void _maya_view_widgets_calendar_chooser___lambda23_ (Block26Data* _data26_);
static void __maya_view_widgets_calendar_chooser___lambda23__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                       gpointer self);
VALA_EXTERN CalendarRow* calendar_row_new (ESource* source);
VALA_EXTERN CalendarRow* calendar_row_construct (GType object_type,
                                     ESource* source);
static void maya_view_widgets_calendar_chooser_finalize (GObject * obj);
static GType maya_view_widgets_calendar_chooser_get_type_once (void);
static void _vala_maya_view_widgets_calendar_chooser_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_maya_view_widgets_calendar_chooser_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
maya_view_widgets_calendar_chooser_get_instance_private (MayaViewWidgetsCalendarChooser* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewWidgetsCalendarChooser_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
maya_view_widgets_calendar_chooser_filter_function (GtkListBoxRow* row,
                                                    MayaViewWidgetsCalendarChooser* self)
{
	gchar* search_term = NULL;
	GtkSearchEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkWidget* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (row != NULL, FALSE);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
	search_term = _tmp3_;
	_tmp4_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp5_ = calendar_row_get_label (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CALENDAR_ROW, CalendarRow));
	_tmp6_ = _tmp5_;
	_tmp7_ = g_utf8_strdown (_tmp6_, (gssize) -1);
	_tmp8_ = _tmp7_;
	_tmp9_ = search_term;
	_tmp10_ = string_contains (_tmp8_, _tmp9_);
	_g_free0 (_tmp8_);
	if (_tmp10_) {
		result = TRUE;
		_g_free0 (search_term);
		return result;
	}
	result = FALSE;
	_g_free0 (search_term);
	return result;
}

static void
maya_view_widgets_calendar_chooser_header_update_func (MayaViewWidgetsCalendarChooser* self,
                                                       GtkListBoxRow* row,
                                                       GtkListBoxRow* before)
{
	gchar* row_location = NULL;
	GtkWidget* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GraniteHeaderLabel* header = NULL;
	const gchar* _tmp10_;
	GraniteHeaderLabel* _tmp11_;
	GraniteHeaderLabel* _tmp12_;
	GraniteHeaderLabel* _tmp13_;
	GraniteHeaderLabel* _tmp14_;
	GraniteHeaderLabel* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = calendar_row_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CALENDAR_ROW, CalendarRow));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	row_location = _tmp3_;
	if (before != NULL) {
		gchar* before_row_location = NULL;
		GtkWidget* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = gtk_bin_get_child ((GtkBin*) before);
		_tmp5_ = calendar_row_get_location (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_CALENDAR_ROW, CalendarRow));
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		before_row_location = _tmp7_;
		_tmp8_ = before_row_location;
		_tmp9_ = row_location;
		if (g_strcmp0 (_tmp8_, _tmp9_) == 0) {
			gtk_list_box_row_set_header (row, NULL);
			_g_free0 (before_row_location);
			_g_free0 (row_location);
			return;
		}
		_g_free0 (before_row_location);
	}
	_tmp10_ = row_location;
	_tmp11_ = granite_header_label_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	header = _tmp11_;
	_tmp12_ = header;
	g_object_set ((GtkWidget*) _tmp12_, "margin", 6, NULL);
	_tmp13_ = header;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp13_, 0);
	_tmp14_ = header;
	gtk_list_box_row_set_header (row, (GtkWidget*) _tmp14_);
	_tmp15_ = header;
	gtk_widget_show_all ((GtkWidget*) _tmp15_);
	if (before == NULL) {
		GraniteHeaderLabel* _tmp16_;
		_tmp16_ = header;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 0);
	}
	_g_object_unref0 (header);
	_g_free0 (row_location);
}

void
maya_view_widgets_calendar_chooser_clear_search_entry (MayaViewWidgetsCalendarChooser* self)
{
	GtkSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
}

MayaViewWidgetsCalendarChooser*
maya_view_widgets_calendar_chooser_construct (GType object_type)
{
	MayaViewWidgetsCalendarChooser * self = NULL;
	self = (MayaViewWidgetsCalendarChooser*) g_object_new (object_type, NULL);
	return self;
}

MayaViewWidgetsCalendarChooser*
maya_view_widgets_calendar_chooser_new (void)
{
	return maya_view_widgets_calendar_chooser_construct (MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER);
}

ESource*
maya_view_widgets_calendar_chooser_get_current_source (MayaViewWidgetsCalendarChooser* self)
{
	ESource* result;
	ESource* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_source;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
maya_view_widgets_calendar_chooser_set_current_source (MayaViewWidgetsCalendarChooser* self,
                                                       ESource* value)
{
	ESource* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_widgets_calendar_chooser_get_current_source (self);
	if (old_value != value) {
		ESource* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_source);
		self->priv->_current_source = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_widgets_calendar_chooser_properties[MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CURRENT_SOURCE_PROPERTY]);
	}
}

static Block26Data*
block26_data_ref (Block26Data* _data26_)
{
	g_atomic_int_inc (&_data26_->_ref_count_);
	return _data26_;
}

static void
block26_data_unref (void * _userdata_)
{
	Block26Data* _data26_;
	_data26_ = (Block26Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data26_->_ref_count_)) {
		MayaViewWidgetsCalendarChooser* self;
		self = _data26_->self;
		_g_object_unref0 (_data26_->list_box);
		_g_object_unref0 (self);
		g_slice_free (Block26Data, _data26_);
	}
}

static gboolean
_maya_view_widgets_calendar_chooser_filter_function_gtk_list_box_filter_func (GtkListBoxRow* row,
                                                                              gpointer self)
{
	gboolean result;
	result = maya_view_widgets_calendar_chooser_filter_function (row, (MayaViewWidgetsCalendarChooser*) self);
	return result;
}

static void
_maya_view_widgets_calendar_chooser_header_update_func_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                                        GtkListBoxRow* before,
                                                                                        gpointer self)
{
	maya_view_widgets_calendar_chooser_header_update_func ((MayaViewWidgetsCalendarChooser*) self, row, before);
}

static gint
_maya_view_widgets_calendar_chooser___lambda19_ (MayaViewWidgetsCalendarChooser* self,
                                                 GtkListBoxRow* row1,
                                                 GtkListBoxRow* row2)
{
	CalendarRow* child1 = NULL;
	GtkWidget* _tmp0_;
	CalendarRow* _tmp1_;
	CalendarRow* child2 = NULL;
	GtkWidget* _tmp2_;
	CalendarRow* _tmp3_;
	gint comparison = 0;
	CalendarRow* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	CalendarRow* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint result;
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row1);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CALENDAR_ROW, CalendarRow));
	child1 = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) row2);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CALENDAR_ROW, CalendarRow));
	child2 = _tmp3_;
	_tmp4_ = child1;
	_tmp5_ = calendar_row_get_location (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = child2;
	_tmp8_ = calendar_row_get_location (_tmp7_);
	_tmp9_ = _tmp8_;
	comparison = g_utf8_collate (_tmp6_, _tmp9_);
	if (comparison == 0) {
		CalendarRow* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		CalendarRow* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		_tmp10_ = child1;
		_tmp11_ = calendar_row_get_label (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = child2;
		_tmp14_ = calendar_row_get_label (_tmp13_);
		_tmp15_ = _tmp14_;
		result = g_utf8_collate (_tmp12_, _tmp15_);
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	} else {
		result = comparison;
		_g_object_unref0 (child2);
		_g_object_unref0 (child1);
		return result;
	}
	_g_object_unref0 (child2);
	_g_object_unref0 (child1);
}

static gint
__maya_view_widgets_calendar_chooser___lambda19__gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                         GtkListBoxRow* row2,
                                                                         gpointer self)
{
	gint result;
	result = _maya_view_widgets_calendar_chooser___lambda19_ ((MayaViewWidgetsCalendarChooser*) self, row1, row2);
	return result;
}

static void
_maya_view_widgets_calendar_chooser___lambda20_ (Block26Data* _data26_,
                                                 GtkMovementStep mvmt,
                                                 gint count)
{
	MayaViewWidgetsCalendarChooser* self;
	gint row = 0;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = _data26_->self;
	_tmp0_ = _data26_->list_box;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	row = gtk_list_box_row_get_index (_tmp1_);
	if (row == 0) {
		_tmp2_ = count == -1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkSearchEntry* _tmp3_;
		_tmp3_ = self->priv->search_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	}
}

static void
__maya_view_widgets_calendar_chooser___lambda20__gtk_list_box_move_cursor (GtkListBox* _sender,
                                                                           GtkMovementStep step,
                                                                           gint count,
                                                                           gpointer self)
{
	_maya_view_widgets_calendar_chooser___lambda20_ (self, step, count);
}

static void
_maya_view_widgets_calendar_chooser___lambda21_ (Block26Data* _data26_,
                                                 GtkListBoxRow* row)
{
	MayaViewWidgetsCalendarChooser* self;
	GtkWidget* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	GtkListBox* _tmp3_;
	GList* _tmp4_;
	GtkWidget* calrow = NULL;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	self = _data26_->self;
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp1_ = calendar_row_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_CALENDAR_ROW, CalendarRow));
	_tmp2_ = _tmp1_;
	maya_view_widgets_calendar_chooser_set_current_source (self, _tmp2_);
	_tmp3_ = _data26_->list_box;
	_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
	{
		GList* deselect_row_collection = NULL;
		GList* deselect_row_it = NULL;
		deselect_row_collection = _tmp4_;
		for (deselect_row_it = deselect_row_collection; deselect_row_it != NULL; deselect_row_it = deselect_row_it->next) {
			GtkWidget* deselect_row = NULL;
			deselect_row = (GtkWidget*) deselect_row_it->data;
			{
				GtkWidget* calrow = NULL;
				GtkWidget* _tmp5_;
				GtkWidget* _tmp6_;
				GtkWidget* _tmp7_;
				GtkWidget* _tmp8_;
				_tmp5_ = deselect_row;
				_tmp6_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_list_box_row_get_type (), GtkListBoxRow));
				_tmp7_ = _g_object_ref0 (_tmp6_);
				calrow = _tmp7_;
				_tmp8_ = calrow;
				calendar_row_set_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_CALENDAR_ROW, CalendarRow), FALSE);
				_g_object_unref0 (calrow);
			}
		}
		(deselect_row_collection == NULL) ? NULL : (deselect_row_collection = (g_list_free (deselect_row_collection), NULL));
	}
	_tmp9_ = gtk_bin_get_child ((GtkBin*) row);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	calrow = _tmp10_;
	_tmp11_ = calrow;
	calendar_row_set_selected (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_CALENDAR_ROW, CalendarRow), TRUE);
	_g_object_unref0 (calrow);
}

static void
__maya_view_widgets_calendar_chooser___lambda21__gtk_list_box_row_activated (GtkListBox* _sender,
                                                                             GtkListBoxRow* row,
                                                                             gpointer self)
{
	_maya_view_widgets_calendar_chooser___lambda21_ (self, row);
}

static void
_maya_view_widgets_calendar_chooser___lambda22_ (Block26Data* _data26_)
{
	MayaViewWidgetsCalendarChooser* self;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	self = _data26_->self;
	_tmp0_ = _data26_->list_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp2_;
				_tmp2_ = child;
				if (gtk_widget_get_child_visible (_tmp2_)) {
					GtkWidget* _tmp3_;
					_tmp3_ = child;
					g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_row_get_type (), GtkListBoxRow), "activate");
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
__maya_view_widgets_calendar_chooser___lambda22__gtk_entry_activate (GtkEntry* _sender,
                                                                     gpointer self)
{
	_maya_view_widgets_calendar_chooser___lambda22_ (self);
}

static void
_maya_view_widgets_calendar_chooser___lambda23_ (Block26Data* _data26_)
{
	MayaViewWidgetsCalendarChooser* self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	self = _data26_->self;
	_tmp0_ = _data26_->list_box;
	gtk_list_box_invalidate_filter (_tmp0_);
	_tmp1_ = _data26_->list_box;
	gtk_list_box_unselect_all (_tmp1_);
}

static void
__maya_view_widgets_calendar_chooser___lambda23__gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                                  gpointer self)
{
	_maya_view_widgets_calendar_chooser___lambda23_ (self);
}

static GObject *
maya_view_widgets_calendar_chooser_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewWidgetsCalendarChooser * self;
	Block26Data* _data26_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp0_;
	ESourceRegistry* registry = NULL;
	CalendarEventStore* _tmp1_;
	ESourceRegistry* _tmp2_;
	ESourceRegistry* _tmp3_;
	ESourceRegistry* _tmp4_;
	ESourceRegistry* _tmp5_;
	GList* _tmp6_;
	ESourceRegistry* _tmp20_;
	ESource* _tmp21_;
	ESource* _tmp22_;
	ESource* _tmp23_;
	GtkSearchEntry* _tmp24_;
	GtkSearchEntry* _tmp25_;
	GtkSearchEntry* _tmp26_;
	GtkSearchEntry* _tmp27_;
	GraniteWidgetsAlertView* placeholder = NULL;
	GraniteWidgetsAlertView* _tmp28_;
	GraniteWidgetsAlertView* _tmp29_;
	GtkListBox* _tmp30_;
	GtkListBox* _tmp31_;
	GtkListBox* _tmp32_;
	GraniteWidgetsAlertView* _tmp33_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp34_;
	GtkScrolledWindow* _tmp35_;
	GtkScrolledWindow* _tmp36_;
	GtkListBox* _tmp37_;
	GtkScrolledWindow* _tmp38_;
	GtkScrolledWindow* _tmp39_;
	GtkSearchEntry* _tmp40_;
	GtkScrolledWindow* _tmp41_;
	GtkListBox* _tmp42_;
	GtkListBox* _tmp43_;
	GtkListBox* _tmp44_;
	GtkListBox* _tmp45_;
	GtkListBox* _tmp46_;
	GtkSearchEntry* _tmp47_;
	GtkSearchEntry* _tmp48_;
	GList* _tmp49_;
	parent_class = G_OBJECT_CLASS (maya_view_widgets_calendar_chooser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooser);
	_data26_ = g_slice_new0 (Block26Data);
	_data26_->_ref_count_ = 1;
	_data26_->self = g_object_ref (self);
	(self->sources == NULL) ? NULL : (self->sources = (_g_list_free__g_object_unref0_ (self->sources), NULL));
	self->sources = NULL;
	_tmp0_ = calendar_event_store_get_default ();
	calmodel = _tmp0_;
	_tmp1_ = calmodel;
	_tmp2_ = calendar_event_store_get_registry (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	registry = _tmp4_;
	_tmp5_ = registry;
	_tmp6_ = e_source_registry_list_sources (_tmp5_, E_SOURCE_EXTENSION_CALENDAR);
	{
		GList* src_collection = NULL;
		GList* src_it = NULL;
		src_collection = _tmp6_;
		for (src_it = src_collection; src_it != NULL; src_it = src_it->next) {
			ESource* _tmp7_;
			ESource* src = NULL;
			_tmp7_ = _g_object_ref0 ((ESource*) src_it->data);
			src = _tmp7_;
			{
				gboolean _tmp8_ = FALSE;
				gboolean _tmp9_ = FALSE;
				ESource* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp10_ = src;
				_tmp11_ = e_source_get_writable (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == TRUE) {
					ESource* _tmp13_;
					gboolean _tmp14_;
					gboolean _tmp15_;
					_tmp13_ = src;
					_tmp14_ = e_source_get_enabled (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ == TRUE;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					CalendarEventStore* _tmp16_;
					ESource* _tmp17_;
					_tmp16_ = calmodel;
					_tmp17_ = src;
					_tmp8_ = calendar_event_store_calclient_is_readonly (_tmp16_, _tmp17_) == FALSE;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					ESource* _tmp18_;
					ESource* _tmp19_;
					_tmp18_ = src;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					self->sources = g_list_append (self->sources, _tmp19_);
				}
				_g_object_unref0 (src);
			}
		}
		(src_collection == NULL) ? NULL : (src_collection = (_g_list_free__g_object_unref0_ (src_collection), NULL));
	}
	_tmp20_ = registry;
	g_object_get (_tmp20_, "default-calendar", &_tmp21_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_;
	maya_view_widgets_calendar_chooser_set_current_source (self, _tmp23_);
	_g_object_unref0 (_tmp23_);
	_tmp24_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp24_;
	_tmp25_ = self->priv->search_entry;
	g_object_set ((GtkWidget*) _tmp25_, "margin", 12, NULL);
	_tmp26_ = self->priv->search_entry;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp26_, 6);
	_tmp27_ = self->priv->search_entry;
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp27_, _ ("Search Calendars"));
	_tmp28_ = granite_widgets_alert_view_new (_ ("No Results"), _ ("Try changing search terms."), "");
	g_object_ref_sink (_tmp28_);
	placeholder = _tmp28_;
	_tmp29_ = placeholder;
	gtk_widget_show_all ((GtkWidget*) _tmp29_);
	_tmp30_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp30_);
	_data26_->list_box = _tmp30_;
	_tmp31_ = _data26_->list_box;
	gtk_list_box_set_activate_on_single_click (_tmp31_, TRUE);
	_tmp32_ = _data26_->list_box;
	_tmp33_ = placeholder;
	gtk_list_box_set_placeholder (_tmp32_, (GtkWidget*) _tmp33_);
	_tmp34_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp34_);
	scrolled = _tmp34_;
	_tmp35_ = scrolled;
	g_object_set (_tmp35_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	_tmp36_ = scrolled;
	_tmp37_ = _data26_->list_box;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = scrolled;
	gtk_scrolled_window_set_max_content_height (_tmp38_, 300);
	_tmp39_ = scrolled;
	gtk_scrolled_window_set_propagate_natural_height (_tmp39_, TRUE);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 6);
	_tmp40_ = self->priv->search_entry;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp40_, 0, 0, 1, 1);
	_tmp41_ = scrolled;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp41_, 0, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp42_ = _data26_->list_box;
	gtk_list_box_set_filter_func (_tmp42_, _maya_view_widgets_calendar_chooser_filter_function_gtk_list_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp43_ = _data26_->list_box;
	gtk_list_box_set_header_func (_tmp43_, _maya_view_widgets_calendar_chooser_header_update_func_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp44_ = _data26_->list_box;
	gtk_list_box_set_sort_func (_tmp44_, __maya_view_widgets_calendar_chooser___lambda19__gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp45_ = _data26_->list_box;
	g_signal_connect_data (_tmp45_, "move-cursor", (GCallback) __maya_view_widgets_calendar_chooser___lambda20__gtk_list_box_move_cursor, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp46_ = _data26_->list_box;
	g_signal_connect_data (_tmp46_, "row-activated", (GCallback) __maya_view_widgets_calendar_chooser___lambda21__gtk_list_box_row_activated, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp47_ = self->priv->search_entry;
	g_signal_connect_data ((GtkEntry*) _tmp47_, "activate", (GCallback) __maya_view_widgets_calendar_chooser___lambda22__gtk_entry_activate, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp48_ = self->priv->search_entry;
	g_signal_connect_data (_tmp48_, "search-changed", (GCallback) __maya_view_widgets_calendar_chooser___lambda23__gtk_search_entry_search_changed, block26_data_ref (_data26_), (GClosureNotify) block26_data_unref, 0);
	_tmp49_ = self->sources;
	{
		GList* source_collection = NULL;
		GList* source_it = NULL;
		source_collection = _tmp49_;
		for (source_it = source_collection; source_it != NULL; source_it = source_it->next) {
			ESource* _tmp50_;
			ESource* source = NULL;
			_tmp50_ = _g_object_ref0 ((ESource*) source_it->data);
			source = _tmp50_;
			{
				CalendarRow* calrow = NULL;
				ESource* _tmp51_;
				CalendarRow* _tmp52_;
				CalendarRow* _tmp53_;
				CalendarRow* _tmp54_;
				GtkListBoxRow* row = NULL;
				GtkListBoxRow* _tmp55_;
				GtkListBoxRow* _tmp56_;
				CalendarRow* _tmp57_;
				GtkListBoxRow* _tmp58_;
				GtkListBox* _tmp59_;
				GtkListBoxRow* _tmp60_;
				ESource* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				ESource* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gboolean _tmp67_;
				_tmp51_ = source;
				_tmp52_ = calendar_row_new (_tmp51_);
				g_object_ref_sink (_tmp52_);
				calrow = _tmp52_;
				_tmp53_ = calrow;
				g_object_set ((GtkWidget*) _tmp53_, "margin", 6, NULL);
				_tmp54_ = calrow;
				gtk_widget_set_margin_start ((GtkWidget*) _tmp54_, 12);
				_tmp55_ = (GtkListBoxRow*) gtk_list_box_row_new ();
				g_object_ref_sink (_tmp55_);
				row = _tmp55_;
				_tmp56_ = row;
				_tmp57_ = calrow;
				gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
				_tmp58_ = row;
				gtk_widget_show_all ((GtkWidget*) _tmp58_);
				_tmp59_ = _data26_->list_box;
				_tmp60_ = row;
				gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp60_);
				_tmp61_ = source;
				_tmp62_ = e_source_dup_uid (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = self->priv->_current_source;
				_tmp65_ = e_source_dup_uid (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_strcmp0 (_tmp63_, _tmp66_) == 0;
				_g_free0 (_tmp66_);
				_g_free0 (_tmp63_);
				if (_tmp67_) {
					GtkListBox* _tmp68_;
					GtkListBoxRow* _tmp69_;
					CalendarRow* _tmp70_;
					_tmp68_ = _data26_->list_box;
					_tmp69_ = row;
					gtk_list_box_select_row (_tmp68_, _tmp69_);
					_tmp70_ = calrow;
					calendar_row_set_selected (_tmp70_, TRUE);
				}
				_g_object_unref0 (row);
				_g_object_unref0 (calrow);
				_g_object_unref0 (source);
			}
		}
	}
	_g_object_unref0 (scrolled);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (registry);
	_g_object_unref0 (calmodel);
	block26_data_unref (_data26_);
	_data26_ = NULL;
	return obj;
}

static void
maya_view_widgets_calendar_chooser_class_init (MayaViewWidgetsCalendarChooserClass * klass,
                                               gpointer klass_data)
{
	maya_view_widgets_calendar_chooser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewWidgetsCalendarChooser_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_widgets_calendar_chooser_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_widgets_calendar_chooser_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_widgets_calendar_chooser_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_widgets_calendar_chooser_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CURRENT_SOURCE_PROPERTY, maya_view_widgets_calendar_chooser_properties[MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CURRENT_SOURCE_PROPERTY] = g_param_spec_object ("current-source", "current-source", "current-source", e_source_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
maya_view_widgets_calendar_chooser_instance_init (MayaViewWidgetsCalendarChooser * self,
                                                  gpointer klass)
{
	self->priv = maya_view_widgets_calendar_chooser_get_instance_private (self);
}

static void
maya_view_widgets_calendar_chooser_finalize (GObject * obj)
{
	MayaViewWidgetsCalendarChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooser);
	(self->sources == NULL) ? NULL : (self->sources = (_g_list_free__g_object_unref0_ (self->sources), NULL));
	_g_object_unref0 (self->priv->_current_source);
	_g_object_unref0 (self->priv->search_entry);
	G_OBJECT_CLASS (maya_view_widgets_calendar_chooser_parent_class)->finalize (obj);
}

static GType
maya_view_widgets_calendar_chooser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewWidgetsCalendarChooserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_widgets_calendar_chooser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewWidgetsCalendarChooser), 0, (GInstanceInitFunc) maya_view_widgets_calendar_chooser_instance_init, NULL };
	GType maya_view_widgets_calendar_chooser_type_id;
	maya_view_widgets_calendar_chooser_type_id = g_type_register_static (gtk_grid_get_type (), "MayaViewWidgetsCalendarChooser", &g_define_type_info, 0);
	MayaViewWidgetsCalendarChooser_private_offset = g_type_add_instance_private (maya_view_widgets_calendar_chooser_type_id, sizeof (MayaViewWidgetsCalendarChooserPrivate));
	return maya_view_widgets_calendar_chooser_type_id;
}

GType
maya_view_widgets_calendar_chooser_get_type (void)
{
	static volatile gsize maya_view_widgets_calendar_chooser_type_id__once = 0;
	if (g_once_init_enter (&maya_view_widgets_calendar_chooser_type_id__once)) {
		GType maya_view_widgets_calendar_chooser_type_id;
		maya_view_widgets_calendar_chooser_type_id = maya_view_widgets_calendar_chooser_get_type_once ();
		g_once_init_leave (&maya_view_widgets_calendar_chooser_type_id__once, maya_view_widgets_calendar_chooser_type_id);
	}
	return maya_view_widgets_calendar_chooser_type_id__once;
}

static void
_vala_maya_view_widgets_calendar_chooser_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	MayaViewWidgetsCalendarChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooser);
	switch (property_id) {
		case MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CURRENT_SOURCE_PROPERTY:
		g_value_set_object (value, maya_view_widgets_calendar_chooser_get_current_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_widgets_calendar_chooser_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	MayaViewWidgetsCalendarChooser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooser);
	switch (property_id) {
		case MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CURRENT_SOURCE_PROPERTY:
		maya_view_widgets_calendar_chooser_set_current_source (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

