/* SourceDialog.c generated by valac 0.56.16, the Vala compiler
 * generated from SourceDialog.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jaap Broekhuizen
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "elementary-calendar.h"
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_SOURCE_DIALOG (maya_view_source_dialog_get_type ())
#define MAYA_VIEW_SOURCE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog))
#define MAYA_VIEW_SOURCE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialogClass))
#define MAYA_VIEW_IS_SOURCE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG))
#define MAYA_VIEW_IS_SOURCE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_SOURCE_DIALOG))
#define MAYA_VIEW_SOURCE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialogClass))

typedef struct _MayaViewSourceDialog MayaViewSourceDialog;
typedef struct _MayaViewSourceDialogClass MayaViewSourceDialogClass;
typedef struct _MayaViewSourceDialogPrivate MayaViewSourceDialogPrivate;
typedef enum  {
	MAYA_VIEW_EVENT_TYPE_ADD,
	MAYA_VIEW_EVENT_TYPE_EDIT
} MayaViewEventType;

#define MAYA_VIEW_TYPE_EVENT_TYPE (maya_view_event_type_get_type ())
enum  {
	MAYA_VIEW_SOURCE_DIALOG_0_PROPERTY,
	MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY,
	MAYA_VIEW_SOURCE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* maya_view_source_dialog_properties[MAYA_VIEW_SOURCE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block24Data Block24Data;
enum  {
	MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL,
	MAYA_VIEW_SOURCE_DIALOG_NUM_SIGNALS
};
static guint maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_NUM_SIGNALS] = {0};

struct _MayaViewSourceDialog {
	GtkGrid parent_instance;
	MayaViewSourceDialogPrivate * priv;
};

struct _MayaViewSourceDialogClass {
	GtkGridClass parent_class;
};

struct _MayaViewSourceDialogPrivate {
	MayaViewEventType _event_type;
	GtkEntry* name_entry;
	gchar* hex_color;
	MayaBackend* current_backend;
	GeeCollection* backend_widgets;
	GtkGrid* main_grid;
	GeeHashMap* widgets_checked;
	GtkButton* create_button;
	GtkComboBox* type_combobox;
	GtkListStore* list_store;
	GtkCheckButton* is_default_check;
	ESource* source;
	GtkRadioButton* color_button_blue;
	GtkRadioButton* color_button_mint;
	GtkRadioButton* color_button_green;
	GtkRadioButton* color_button_yellow;
	GtkRadioButton* color_button_orange;
	GtkRadioButton* color_button_red;
	GtkRadioButton* color_button_pink;
	GtkRadioButton* color_button_purple;
	GtkRadioButton* color_button_brown;
	GtkRadioButton* color_button_slate;
	GtkRadioButton* color_button_none;
};

struct _Block24Data {
	int _ref_count_;
	MayaViewSourceDialog* self;
	MayaPlacementWidget* widget;
};

static gint MayaViewSourceDialog_private_offset;
static gpointer maya_view_source_dialog_parent_class = NULL;

VALA_EXTERN GType maya_view_source_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewSourceDialog, g_object_unref)
VALA_EXTERN GType maya_view_event_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void maya_view_source_dialog_set_source (MayaViewSourceDialog* self,
                                         ESource* source);
static void maya_view_source_dialog_set_event_type (MayaViewSourceDialog* self,
                                             MayaViewEventType value);
static gboolean maya_view_source_dialog_tree_foreach (MayaViewSourceDialog* self,
                                               GtkTreeModel* model,
                                               GtkTreePath* path,
                                               GtkTreeIter* iter);
static gboolean _maya_view_source_dialog_tree_foreach_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                            GtkTreePath* path,
                                                                            GtkTreeIter* iter,
                                                                            gpointer self);
static void maya_view_source_dialog_remove_backend_widgets (MayaViewSourceDialog* self);
static void maya_view_source_dialog_add_backend_widgets (MayaViewSourceDialog* self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void _____lambda156_ (Block24Data* _data24_);
static void maya_view_source_dialog_entry_changed (MayaViewSourceDialog* self,
                                            MayaPlacementWidget* widget);
static void ______lambda156__gtk_editable_changed (GtkEditable* _sender,
                                            gpointer self);
static void maya_view_source_dialog_check_can_validate (MayaViewSourceDialog* self);
VALA_EXTERN void maya_view_source_dialog_save (MayaViewSourceDialog* self);
VALA_EXTERN MayaViewEventType maya_view_source_dialog_get_event_type (MayaViewSourceDialog* self);
VALA_EXTERN MayaViewSourceDialog* maya_view_source_dialog_new (void);
VALA_EXTERN MayaViewSourceDialog* maya_view_source_dialog_construct (GType object_type);
static GObject * maya_view_source_dialog_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _maya_view_source_dialog_save_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _maya_view_source_dialog___lambda157_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda157__gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _maya_view_source_dialog___lambda158_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda158__gtk_editable_changed (GtkEditable* _sender,
                                                                  gpointer self);
static void _maya_view_source_dialog___lambda159_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda159__gtk_combo_box_changed (GtkComboBox* _sender,
                                                                   gpointer self);
static void _maya_view_source_dialog___lambda160_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda160__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda161_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda161__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda162_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda162__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda163_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda163__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda164_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda164__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda165_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda165__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda166_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda166__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda167_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda167__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda168_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda168__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void _maya_view_source_dialog___lambda169_ (MayaViewSourceDialog* self);
static void __maya_view_source_dialog___lambda169__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                       gpointer self);
static void maya_view_source_dialog_finalize (GObject * obj);
static GType maya_view_source_dialog_get_type_once (void);
static void _vala_maya_view_source_dialog_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_maya_view_source_dialog_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
maya_view_source_dialog_get_instance_private (MayaViewSourceDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewSourceDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_maya_view_source_dialog_tree_foreach_gtk_tree_model_foreach_func (GtkTreeModel* model,
                                                                   GtkTreePath* path,
                                                                   GtkTreeIter* iter,
                                                                   gpointer self)
{
	gboolean result;
	result = maya_view_source_dialog_tree_foreach ((MayaViewSourceDialog*) self, model, path, iter);
	return result;
}

void
maya_view_source_dialog_set_source (MayaViewSourceDialog* self,
                                    ESource* source)
{
	ESource* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp0_;
	if (source == NULL) {
		GtkEntry* _tmp1_;
		GtkComboBox* _tmp2_;
		GtkRadioButton* _tmp3_;
		GtkButton* _tmp4_;
		GtkCheckButton* _tmp5_;
		GtkCheckButton* _tmp6_;
		maya_view_source_dialog_set_event_type (self, MAYA_VIEW_EVENT_TYPE_ADD);
		_tmp1_ = self->priv->name_entry;
		gtk_entry_set_text (_tmp1_, "");
		_tmp2_ = self->priv->type_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = self->priv->color_button_red;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp3_, TRUE);
		_tmp4_ = self->priv->create_button;
		gtk_button_set_label (_tmp4_, _ ("Create Calendar"));
		_tmp5_ = self->priv->is_default_check;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
		_tmp6_ = self->priv->is_default_check;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp6_, FALSE);
	} else {
		GtkButton* _tmp7_;
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		GtkComboBox* _tmp11_;
		GtkComboBox* _tmp12_;
		GtkListStore* _tmp13_;
		ESourceCalendar* cal = NULL;
		ESourceExtension* _tmp28_;
		ESourceCalendar* _tmp29_;
		ESourceCalendar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GQuark _tmp34_ = 0U;
		static GQuark _tmp33_label0 = 0;
		static GQuark _tmp33_label1 = 0;
		static GQuark _tmp33_label2 = 0;
		static GQuark _tmp33_label3 = 0;
		static GQuark _tmp33_label4 = 0;
		static GQuark _tmp33_label5 = 0;
		static GQuark _tmp33_label6 = 0;
		static GQuark _tmp33_label7 = 0;
		static GQuark _tmp33_label8 = 0;
		static GQuark _tmp33_label9 = 0;
		maya_view_source_dialog_set_event_type (self, MAYA_VIEW_EVENT_TYPE_EDIT);
		_tmp7_ = self->priv->create_button;
		gtk_button_set_label (_tmp7_, _ ("Save"));
		_tmp8_ = self->priv->name_entry;
		_tmp9_ = e_source_get_display_name (source);
		_tmp10_ = _tmp9_;
		gtk_entry_set_text (_tmp8_, _tmp10_);
		_tmp11_ = self->priv->type_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		_tmp12_ = self->priv->type_combobox;
		gtk_combo_box_set_active (_tmp12_, 0);
		_tmp13_ = self->priv->list_store;
		gtk_tree_model_foreach ((GtkTreeModel*) _tmp13_, _maya_view_source_dialog_tree_foreach_gtk_tree_model_foreach_func, self);
		{
			ESourceRegistry* registry = NULL;
			ESourceRegistry* _tmp14_;
			gboolean source_is_default = FALSE;
			ESourceRegistry* _tmp15_;
			ESource* _tmp16_;
			ESource* _tmp17_;
			ESource* _tmp18_;
			gboolean _tmp19_;
			gboolean source_is_readonly = FALSE;
			CalendarEventStore* _tmp20_;
			CalendarEventStore* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_ = FALSE;
			GtkCheckButton* _tmp24_;
			GtkCheckButton* _tmp25_;
			_tmp14_ = e_source_registry_new_sync (NULL, &_inner_error0_);
			registry = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp15_ = registry;
			g_object_get (_tmp15_, "default-calendar", &_tmp16_, NULL);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp19_ = e_source_equal (source, _tmp18_);
			_g_object_unref0 (_tmp18_);
			source_is_default = _tmp19_;
			_tmp20_ = calendar_event_store_get_default ();
			_tmp21_ = _tmp20_;
			_tmp22_ = calendar_event_store_calclient_is_readonly (_tmp21_, source);
			_g_object_unref0 (_tmp21_);
			source_is_readonly = _tmp22_;
			if (source_is_default) {
				_tmp23_ = TRUE;
			} else {
				_tmp23_ = source_is_readonly;
			}
			_tmp24_ = self->priv->is_default_check;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp24_, !_tmp23_);
			_tmp25_ = self->priv->is_default_check;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp25_, source_is_default);
			_g_object_unref0 (registry);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = _error_;
			_tmp27_ = _tmp26_->message;
			g_critical ("SourceDialog.vala:278: %s", _tmp27_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp28_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
		_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp29_;
		_tmp30_ = cal;
		_tmp31_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp34_ = (NULL == _tmp32_) ? 0 : g_quark_from_string (_tmp32_);
		g_free (_tmp32_);
		if (_tmp34_ == ((0 != _tmp33_label0) ? _tmp33_label0 : (_tmp33_label0 = g_quark_from_static_string ("#da3d41")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp35_;
					_tmp35_ = self->priv->color_button_red;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp35_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label1) ? _tmp33_label1 : (_tmp33_label1 = g_quark_from_static_string ("#f37329")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp36_;
					_tmp36_ = self->priv->color_button_orange;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp36_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label2) ? _tmp33_label2 : (_tmp33_label2 = g_quark_from_static_string ("#e6a92a")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp37_;
					_tmp37_ = self->priv->color_button_yellow;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp37_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label3) ? _tmp33_label3 : (_tmp33_label3 = g_quark_from_static_string ("#81c837")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp38_;
					_tmp38_ = self->priv->color_button_green;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp38_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label4) ? _tmp33_label4 : (_tmp33_label4 = g_quark_from_static_string ("#0e9a83")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp39_;
					_tmp39_ = self->priv->color_button_mint;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp39_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label5) ? _tmp33_label5 : (_tmp33_label5 = g_quark_from_static_string ("#3689e6")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp40_;
					_tmp40_ = self->priv->color_button_blue;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp40_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label6) ? _tmp33_label6 : (_tmp33_label6 = g_quark_from_static_string ("#a56de2")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp41_;
					_tmp41_ = self->priv->color_button_purple;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp41_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label7) ? _tmp33_label7 : (_tmp33_label7 = g_quark_from_static_string ("#de3e80")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp42_;
					_tmp42_ = self->priv->color_button_pink;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp42_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label8) ? _tmp33_label8 : (_tmp33_label8 = g_quark_from_static_string ("#8a715e")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp43_;
					_tmp43_ = self->priv->color_button_brown;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp43_, TRUE);
					break;
				}
			}
		} else if (_tmp34_ == ((0 != _tmp33_label9) ? _tmp33_label9 : (_tmp33_label9 = g_quark_from_static_string ("#667885")))) {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp44_;
					_tmp44_ = self->priv->color_button_slate;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp44_, TRUE);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					GtkRadioButton* _tmp45_;
					ESourceCalendar* _tmp46_;
					gchar* _tmp47_;
					_tmp45_ = self->priv->color_button_none;
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp45_, TRUE);
					_tmp46_ = cal;
					_tmp47_ = e_source_selectable_dup_color ((ESourceSelectable*) _tmp46_);
					_g_free0 (self->priv->hex_color);
					self->priv->hex_color = _tmp47_;
					break;
				}
			}
		}
		_g_object_unref0 (cal);
	}
}

static gboolean
maya_view_source_dialog_tree_foreach (MayaViewSourceDialog* self,
                                      GtkTreeModel* model,
                                      GtkTreePath* path,
                                      GtkTreeIter* iter)
{
	GValue backend = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	GValue _tmp2_ = {0};
	MayaBackend* current_backend = NULL;
	GValue _tmp3_;
	MayaBackend* _tmp4_;
	MayaBackend* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ESource* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = self->priv->list_store;
	_tmp1_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp0_, &_tmp1_, 1, &_tmp2_);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
	backend = _tmp2_;
	_tmp3_ = backend;
	_tmp4_ = _g_object_ref0 (g_value_get_object (&_tmp3_));
	current_backend = _tmp4_;
	_tmp5_ = current_backend;
	_tmp6_ = maya_backend_get_uid (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->source;
	_tmp9_ = e_source_dup_parent (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strcmp0 (_tmp7_, _tmp10_) == 0;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp7_);
	if (_tmp11_) {
		GtkComboBox* _tmp12_;
		GtkTreeIter _tmp13_;
		GtkComboBox* _tmp14_;
		_tmp12_ = self->priv->type_combobox;
		_tmp13_ = *iter;
		gtk_combo_box_set_active_iter (_tmp12_, &_tmp13_);
		_tmp14_ = self->priv->type_combobox;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, TRUE);
		result = TRUE;
		_g_object_unref0 (current_backend);
		G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
		return result;
	}
	result = FALSE;
	_g_object_unref0 (current_backend);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
	return result;
}

static void
maya_view_source_dialog_remove_backend_widgets (MayaViewSourceDialog* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->backend_widgets;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		GeeIterator* _widget_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->backend_widgets;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_widget_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			MayaPlacementWidget* widget = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			MayaPlacementWidget* _tmp6_;
			GtkWidget* _tmp7_;
			MayaPlacementWidget* _tmp8_;
			GtkWidget* _tmp9_;
			_tmp3_ = _widget_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _widget_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			widget = (MayaPlacementWidget*) _tmp5_;
			_tmp6_ = widget;
			_tmp7_ = _tmp6_->widget;
			gtk_widget_hide (_tmp7_);
			_tmp8_ = widget;
			_tmp9_ = _tmp8_->widget;
			gtk_widget_destroy (_tmp9_);
			_g_object_unref0 (widget);
		}
		_g_object_unref0 (_widget_it);
	}
	_tmp10_ = self->priv->backend_widgets;
	gee_collection_clear (_tmp10_);
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
	g_atomic_int_inc (&_data24_->_ref_count_);
	return _data24_;
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
		MayaViewSourceDialog* self;
		self = _data24_->self;
		_g_object_unref0 (_data24_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block24Data, _data24_);
	}
}

static void
_____lambda156_ (Block24Data* _data24_)
{
	MayaViewSourceDialog* self;
	MayaPlacementWidget* _tmp0_;
	self = _data24_->self;
	_tmp0_ = _data24_->widget;
	maya_view_source_dialog_entry_changed (self, _tmp0_);
}

static void
______lambda156__gtk_editable_changed (GtkEditable* _sender,
                                       gpointer self)
{
	_____lambda156_ (self);
}

static void
maya_view_source_dialog_add_backend_widgets (MayaViewSourceDialog* self)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->widgets_checked;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	{
		GeeIterator* _widget_it = NULL;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = self->priv->backend_widgets;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_widget_it = _tmp2_;
		while (TRUE) {
			Block24Data* _data24_;
			GeeIterator* _tmp3_;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			GtkGrid* _tmp6_;
			MayaPlacementWidget* _tmp7_;
			GtkWidget* _tmp8_;
			MayaPlacementWidget* _tmp9_;
			MayaPlacementWidget* _tmp10_;
			gboolean _tmp11_ = FALSE;
			MayaPlacementWidget* _tmp12_;
			MayaPlacementWidget* _tmp26_;
			GtkWidget* _tmp27_;
			_data24_ = g_slice_new0 (Block24Data);
			_data24_->_ref_count_ = 1;
			_data24_->self = g_object_ref (self);
			_tmp3_ = _widget_it;
			if (!gee_iterator_next (_tmp3_)) {
				block24_data_unref (_data24_);
				_data24_ = NULL;
				break;
			}
			_tmp4_ = _widget_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			_data24_->widget = (MayaPlacementWidget*) _tmp5_;
			_tmp6_ = self->priv->main_grid;
			_tmp7_ = _data24_->widget;
			_tmp8_ = _tmp7_->widget;
			_tmp9_ = _data24_->widget;
			_tmp10_ = _data24_->widget;
			gtk_grid_attach (_tmp6_, _tmp8_, _tmp9_->column, 4 + _tmp10_->row, 1, 1);
			_tmp12_ = _data24_->widget;
			if (_tmp12_->needed == TRUE) {
				MayaPlacementWidget* _tmp13_;
				GtkWidget* _tmp14_;
				_tmp13_ = _data24_->widget;
				_tmp14_ = _tmp13_->widget;
				_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gtk_entry_get_type ());
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				GtkEntry* entry = NULL;
				MayaPlacementWidget* _tmp15_;
				GtkWidget* _tmp16_;
				GtkEntry* _tmp17_;
				GtkEntry* _tmp18_;
				GeeHashMap* _tmp19_;
				MayaPlacementWidget* _tmp20_;
				const gchar* _tmp21_;
				MayaPlacementWidget* _tmp22_;
				GtkWidget* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				_tmp15_ = _data24_->widget;
				_tmp16_ = _tmp15_->widget;
				_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_entry_get_type ()) ? ((GtkEntry*) _tmp16_) : NULL);
				entry = _tmp17_;
				_tmp18_ = entry;
				g_signal_connect_data ((GtkEditable*) _tmp18_, "changed", (GCallback) ______lambda156__gtk_editable_changed, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
				_tmp19_ = self->priv->widgets_checked;
				_tmp20_ = _data24_->widget;
				_tmp21_ = _tmp20_->ref_name;
				_tmp22_ = _data24_->widget;
				_tmp23_ = _tmp22_->widget;
				_tmp24_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_entry_get_type (), GtkEntry));
				_tmp25_ = _tmp24_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, _tmp21_, (gpointer) ((gintptr) (g_strcmp0 (_tmp25_, "") != 0)));
				_g_object_unref0 (entry);
			}
			_tmp26_ = _data24_->widget;
			_tmp27_ = _tmp26_->widget;
			gtk_widget_show (_tmp27_);
			block24_data_unref (_data24_);
			_data24_ = NULL;
		}
		_g_object_unref0 (_widget_it);
	}
	maya_view_source_dialog_check_can_validate (self);
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static void
maya_view_source_dialog_entry_changed (MayaViewSourceDialog* self,
                                       MayaPlacementWidget* widget)
{
	GeeHashMap* _tmp0_;
	const gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	GtkWidget* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->widgets_checked;
	_tmp1_ = widget->ref_name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, _tmp1_, NULL);
	_tmp2_ = self->priv->widgets_checked;
	_tmp3_ = widget->ref_name;
	_tmp4_ = widget->widget;
	_tmp5_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_entry_get_type (), GtkEntry));
	_tmp6_ = _tmp5_;
	_tmp7_ = string_chug (_tmp6_);
	_tmp8_ = _tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp3_, (gpointer) ((gintptr) (g_utf8_strlen (_tmp8_, (gssize) -1) > 0)));
	_g_free0 (_tmp8_);
	maya_view_source_dialog_check_can_validate (self);
}

static void
maya_view_source_dialog_check_can_validate (MayaViewSourceDialog* self)
{
	GtkEntry* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _valid_it = NULL;
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->widgets_checked;
		_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_valid_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean valid = FALSE;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			_tmp6_ = _valid_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _valid_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			valid = (gboolean) ((gintptr) _tmp8_);
			if (valid == FALSE) {
				GtkButton* _tmp9_;
				_tmp9_ = self->priv->create_button;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
				_g_object_unref0 (_valid_it);
				return;
			}
		}
		_g_object_unref0 (_valid_it);
	}
	_tmp10_ = self->priv->name_entry;
	_tmp11_ = gtk_entry_get_text (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp12_, "") != 0) {
		GtkButton* _tmp13_;
		_tmp13_ = self->priv->create_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
	}
}

void
maya_view_source_dialog_save (MayaViewSourceDialog* self)
{
	MayaViewEventType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_event_type;
	if (_tmp0_ == MAYA_VIEW_EVENT_TYPE_ADD) {
		MayaBackend* _tmp1_;
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GtkCheckButton* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		GeeCollection* _tmp9_;
		_tmp1_ = self->priv->current_backend;
		_tmp2_ = self->priv->name_entry;
		_tmp3_ = gtk_entry_get_text (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->hex_color;
		_tmp6_ = self->priv->is_default_check;
		_tmp7_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->backend_widgets;
		maya_backend_add_new_calendar (_tmp1_, _tmp4_, _tmp5_, _tmp8_, _tmp9_);
		g_signal_emit (self, maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL], 0);
	} else {
		MayaBackend* _tmp10_;
		GtkEntry* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GtkCheckButton* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		GeeCollection* _tmp18_;
		ESource* _tmp19_;
		_tmp10_ = self->priv->current_backend;
		_tmp11_ = self->priv->name_entry;
		_tmp12_ = gtk_entry_get_text (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->hex_color;
		_tmp15_ = self->priv->is_default_check;
		_tmp16_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->backend_widgets;
		_tmp19_ = self->priv->source;
		maya_backend_modify_calendar (_tmp10_, _tmp13_, _tmp14_, _tmp17_, _tmp18_, _tmp19_);
		g_signal_emit (self, maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL], 0);
	}
}

MayaViewSourceDialog*
maya_view_source_dialog_construct (GType object_type)
{
	MayaViewSourceDialog * self = NULL;
	self = (MayaViewSourceDialog*) g_object_new (object_type, NULL);
	return self;
}

MayaViewSourceDialog*
maya_view_source_dialog_new (void)
{
	return maya_view_source_dialog_construct (MAYA_VIEW_TYPE_SOURCE_DIALOG);
}

MayaViewEventType
maya_view_source_dialog_get_event_type (MayaViewSourceDialog* self)
{
	MayaViewEventType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_event_type;
	return result;
}

static void
maya_view_source_dialog_set_event_type (MayaViewSourceDialog* self,
                                        MayaViewEventType value)
{
	MayaViewEventType old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_source_dialog_get_event_type (self);
	if (old_value != value) {
		self->priv->_event_type = value;
		g_object_notify_by_pspec ((GObject *) self, maya_view_source_dialog_properties[MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY]);
	}
}

static void
_maya_view_source_dialog_save_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	maya_view_source_dialog_save ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda157_ (MayaViewSourceDialog* self)
{
	g_signal_emit (self, maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL], 0);
}

static void
__maya_view_source_dialog___lambda157__gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	_maya_view_source_dialog___lambda157_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda158_ (MayaViewSourceDialog* self)
{
	maya_view_source_dialog_check_can_validate (self);
}

static void
__maya_view_source_dialog___lambda158__gtk_editable_changed (GtkEditable* _sender,
                                                             gpointer self)
{
	_maya_view_source_dialog___lambda158_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda159_ (MayaViewSourceDialog* self)
{
	GValue backend = {0};
	GtkTreeIter b_iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GValue _tmp4_ = {0};
	GValue _tmp5_;
	MayaBackend* _tmp6_;
	GValue _tmp7_;
	ESource* _tmp8_;
	GeeCollection* _tmp9_;
	_tmp0_ = self->priv->type_combobox;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	b_iter = _tmp1_;
	_tmp2_ = self->priv->list_store;
	_tmp3_ = b_iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp2_, &_tmp3_, 1, &_tmp4_);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
	backend = _tmp4_;
	_tmp5_ = backend;
	_tmp6_ = _g_object_ref0 (g_value_get_object (&_tmp5_));
	_g_object_unref0 (self->priv->current_backend);
	self->priv->current_backend = _tmp6_;
	maya_view_source_dialog_remove_backend_widgets (self);
	_tmp7_ = backend;
	_tmp8_ = self->priv->source;
	_tmp9_ = maya_backend_get_new_calendar_widget (g_value_get_object (&_tmp7_), _tmp8_);
	_g_object_unref0 (self->priv->backend_widgets);
	self->priv->backend_widgets = _tmp9_;
	maya_view_source_dialog_add_backend_widgets (self);
	G_IS_VALUE (&backend) ? (g_value_unset (&backend), NULL) : NULL;
}

static void
__maya_view_source_dialog___lambda159__gtk_combo_box_changed (GtkComboBox* _sender,
                                                              gpointer self)
{
	_maya_view_source_dialog___lambda159_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda160_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#da3d41");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda160__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda160_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda161_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#f37329");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda161__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda161_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda162_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#e6a92a");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda162__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda162_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda163_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#81c837");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda163__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda163_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda164_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#0e9a83");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda164__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda164_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda165_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#3689e6");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda165__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda165_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda166_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#a56de2");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda166__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda166_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda167_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#de3e80");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda167__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda167_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda168_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#8a715e");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda168__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda168_ ((MayaViewSourceDialog*) self);
}

static void
_maya_view_source_dialog___lambda169_ (MayaViewSourceDialog* self)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("#667885");
	_g_free0 (self->priv->hex_color);
	self->priv->hex_color = _tmp0_;
}

static void
__maya_view_source_dialog___lambda169__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                  gpointer self)
{
	_maya_view_source_dialog___lambda169_ ((MayaViewSourceDialog*) self);
}

static GObject *
maya_view_source_dialog_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewSourceDialog * self;
	GeeHashMap* _tmp0_;
	GtkButton* cancel_button = NULL;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButtonBox* buttonbox = NULL;
	GtkButtonBox* _tmp5_;
	GtkButtonBox* _tmp6_;
	GtkButtonBox* _tmp7_;
	GtkButtonBox* _tmp8_;
	GtkButton* _tmp9_;
	GtkButtonBox* _tmp10_;
	GtkButton* _tmp11_;
	GtkLabel* name_label = NULL;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkEntry* _tmp14_;
	GtkEntry* _tmp15_;
	GtkEntry* _tmp16_;
	GtkListStore* _tmp17_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp18_;
	GtkListStore* _tmp19_;
	GtkComboBox* _tmp20_;
	GtkComboBox* _tmp21_;
	GtkComboBox* _tmp22_;
	GtkCellRendererText* _tmp23_;
	GtkComboBox* _tmp24_;
	GtkCellRendererText* _tmp25_;
	GtkComboBox* _tmp26_;
	GtkLabel* type_label = NULL;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkTreeIter iter = {0};
	MayaBackendsManager* backends_manager = NULL;
	MayaBackendsManager* _tmp29_;
	MayaBackendsManager* _tmp48_;
	GeeArrayList* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GtkComboBox* _tmp54_;
	GtkLabel* color_label = NULL;
	GtkLabel* _tmp55_;
	GtkLabel* _tmp56_;
	GtkRadioButton* _tmp57_;
	GtkStyleContext* color_button_blue_context = NULL;
	GtkRadioButton* _tmp58_;
	GtkStyleContext* _tmp59_;
	GtkStyleContext* _tmp60_;
	GtkStyleContext* _tmp61_;
	GtkStyleContext* _tmp62_;
	GtkRadioButton* _tmp63_;
	GtkRadioButton* _tmp64_;
	GtkStyleContext* color_button_mint_context = NULL;
	GtkRadioButton* _tmp65_;
	GtkStyleContext* _tmp66_;
	GtkStyleContext* _tmp67_;
	GtkStyleContext* _tmp68_;
	GtkStyleContext* _tmp69_;
	GtkRadioButton* _tmp70_;
	GtkRadioButton* _tmp71_;
	GtkStyleContext* color_button_green_context = NULL;
	GtkRadioButton* _tmp72_;
	GtkStyleContext* _tmp73_;
	GtkStyleContext* _tmp74_;
	GtkStyleContext* _tmp75_;
	GtkStyleContext* _tmp76_;
	GtkRadioButton* _tmp77_;
	GtkRadioButton* _tmp78_;
	GtkStyleContext* color_button_yellow_context = NULL;
	GtkRadioButton* _tmp79_;
	GtkStyleContext* _tmp80_;
	GtkStyleContext* _tmp81_;
	GtkStyleContext* _tmp82_;
	GtkStyleContext* _tmp83_;
	GtkRadioButton* _tmp84_;
	GtkRadioButton* _tmp85_;
	GtkStyleContext* color_button_orange_context = NULL;
	GtkRadioButton* _tmp86_;
	GtkStyleContext* _tmp87_;
	GtkStyleContext* _tmp88_;
	GtkStyleContext* _tmp89_;
	GtkStyleContext* _tmp90_;
	GtkRadioButton* _tmp91_;
	GtkRadioButton* _tmp92_;
	GtkStyleContext* color_button_red_context = NULL;
	GtkRadioButton* _tmp93_;
	GtkStyleContext* _tmp94_;
	GtkStyleContext* _tmp95_;
	GtkStyleContext* _tmp96_;
	GtkStyleContext* _tmp97_;
	GtkRadioButton* _tmp98_;
	GtkRadioButton* _tmp99_;
	GtkStyleContext* color_button_pink_context = NULL;
	GtkRadioButton* _tmp100_;
	GtkStyleContext* _tmp101_;
	GtkStyleContext* _tmp102_;
	GtkStyleContext* _tmp103_;
	GtkStyleContext* _tmp104_;
	GtkRadioButton* _tmp105_;
	GtkRadioButton* _tmp106_;
	GtkStyleContext* color_button_purple_context = NULL;
	GtkRadioButton* _tmp107_;
	GtkStyleContext* _tmp108_;
	GtkStyleContext* _tmp109_;
	GtkStyleContext* _tmp110_;
	GtkStyleContext* _tmp111_;
	GtkRadioButton* _tmp112_;
	GtkRadioButton* _tmp113_;
	GtkStyleContext* color_button_brown_context = NULL;
	GtkRadioButton* _tmp114_;
	GtkStyleContext* _tmp115_;
	GtkStyleContext* _tmp116_;
	GtkStyleContext* _tmp117_;
	GtkStyleContext* _tmp118_;
	GtkRadioButton* _tmp119_;
	GtkRadioButton* _tmp120_;
	GtkStyleContext* color_button_slate_context = NULL;
	GtkRadioButton* _tmp121_;
	GtkStyleContext* _tmp122_;
	GtkStyleContext* _tmp123_;
	GtkStyleContext* _tmp124_;
	GtkStyleContext* _tmp125_;
	GtkRadioButton* _tmp126_;
	GtkRadioButton* _tmp127_;
	GtkGrid* color_grid = NULL;
	GtkGrid* _tmp128_ = NULL;
	GtkGrid* _tmp129_;
	GtkRadioButton* _tmp130_;
	GtkGrid* _tmp131_;
	GtkRadioButton* _tmp132_;
	GtkGrid* _tmp133_;
	GtkRadioButton* _tmp134_;
	GtkGrid* _tmp135_;
	GtkRadioButton* _tmp136_;
	GtkGrid* _tmp137_;
	GtkRadioButton* _tmp138_;
	GtkGrid* _tmp139_;
	GtkRadioButton* _tmp140_;
	GtkGrid* _tmp141_;
	GtkRadioButton* _tmp142_;
	GtkGrid* _tmp143_;
	GtkRadioButton* _tmp144_;
	GtkGrid* _tmp145_;
	GtkRadioButton* _tmp146_;
	GtkGrid* _tmp147_;
	GtkRadioButton* _tmp148_;
	GtkCheckButton* _tmp149_;
	GtkRadioButton* _tmp150_;
	GtkRadioButton* _tmp151_;
	GtkRadioButton* _tmp152_;
	GtkRadioButton* _tmp153_;
	GtkRadioButton* _tmp154_;
	GtkRadioButton* _tmp155_;
	GtkRadioButton* _tmp156_;
	GtkRadioButton* _tmp157_;
	GtkRadioButton* _tmp158_;
	GtkRadioButton* _tmp159_;
	GtkGrid* _tmp160_;
	GtkGrid* _tmp161_;
	GtkGrid* _tmp162_;
	GtkGrid* _tmp163_;
	GtkLabel* _tmp164_;
	GtkGrid* _tmp165_;
	GtkComboBox* _tmp166_;
	GtkGrid* _tmp167_;
	GtkLabel* _tmp168_;
	GtkGrid* _tmp169_;
	GtkEntry* _tmp170_;
	GtkGrid* _tmp171_;
	GtkLabel* _tmp172_;
	GtkGrid* _tmp173_;
	GtkGrid* _tmp174_;
	GtkGrid* _tmp175_;
	GtkCheckButton* _tmp176_;
	GtkGrid* _tmp177_;
	GtkButtonBox* _tmp178_;
	parent_class = G_OBJECT_CLASS (maya_view_source_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->widgets_checked);
	self->priv->widgets_checked = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new_with_label (_ ("Cancel"));
	g_object_ref_sink (_tmp1_);
	cancel_button = _tmp1_;
	_tmp2_ = (GtkButton*) gtk_button_new_with_label (_ ("Create"));
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->create_button);
	self->priv->create_button = _tmp2_;
	_tmp3_ = self->priv->create_button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) _maya_view_source_dialog_save_gtk_button_clicked, self, 0);
	_tmp4_ = cancel_button;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) __maya_view_source_dialog___lambda157__gtk_button_clicked, self, 0);
	_tmp5_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp5_);
	buttonbox = _tmp5_;
	_tmp6_ = buttonbox;
	g_object_set (_tmp6_, "layout-style", GTK_BUTTONBOX_END, NULL);
	_tmp7_ = buttonbox;
	gtk_box_set_spacing ((GtkBox*) _tmp7_, 6);
	_tmp8_ = buttonbox;
	_tmp9_ = cancel_button;
	gtk_box_pack_end ((GtkBox*) _tmp8_, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	_tmp10_ = buttonbox;
	_tmp11_ = self->priv->create_button;
	gtk_box_pack_end ((GtkBox*) _tmp10_, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	_tmp12_ = (GtkLabel*) gtk_label_new (_ ("Name:"));
	g_object_ref_sink (_tmp12_);
	name_label = _tmp12_;
	_tmp13_ = name_label;
	gtk_label_set_xalign (_tmp13_, (gfloat) 1);
	_tmp14_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->name_entry);
	self->priv->name_entry = _tmp14_;
	_tmp15_ = self->priv->name_entry;
	gtk_entry_set_placeholder_text (_tmp15_, _ ("Calendar Name"));
	_tmp16_ = self->priv->name_entry;
	g_signal_connect_object ((GtkEditable*) _tmp16_, "changed", (GCallback) __maya_view_source_dialog___lambda158__gtk_editable_changed, self, 0);
	_tmp17_ = gtk_list_store_new (2, G_TYPE_STRING, MAYA_TYPE_BACKEND, -1);
	_g_object_unref0 (self->priv->list_store);
	self->priv->list_store = _tmp17_;
	_tmp18_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp18_);
	renderer = _tmp18_;
	_tmp19_ = self->priv->list_store;
	_tmp20_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp19_);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->type_combobox);
	self->priv->type_combobox = _tmp20_;
	_tmp21_ = self->priv->type_combobox;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp21_, TRUE);
	_tmp22_ = self->priv->type_combobox;
	_tmp23_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp22_, (GtkCellRenderer*) _tmp23_, TRUE);
	_tmp24_ = self->priv->type_combobox;
	_tmp25_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, "text", 0);
	_tmp26_ = self->priv->type_combobox;
	g_signal_connect_object (_tmp26_, "changed", (GCallback) __maya_view_source_dialog___lambda159__gtk_combo_box_changed, self, 0);
	_tmp27_ = (GtkLabel*) gtk_label_new (_ ("Type:"));
	g_object_ref_sink (_tmp27_);
	type_label = _tmp27_;
	_tmp28_ = type_label;
	gtk_label_set_xalign (_tmp28_, 1.0f);
	_tmp29_ = maya_backends_manager_get_default ();
	backends_manager = _tmp29_;
	{
		GeeArrayList* _backend_list = NULL;
		MayaBackendsManager* _tmp30_;
		GeeArrayList* _tmp31_;
		gint _backend_size = 0;
		GeeArrayList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _backend_index = 0;
		_tmp30_ = backends_manager;
		_tmp31_ = _tmp30_->backends;
		_backend_list = _tmp31_;
		_tmp32_ = _backend_list;
		_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_backend_size = _tmp34_;
		_backend_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			MayaBackend* backend = NULL;
			GeeArrayList* _tmp37_;
			gpointer _tmp38_;
			MayaBackend* _tmp39_;
			GtkListStore* _tmp40_;
			GtkTreeIter _tmp41_ = {0};
			GtkListStore* _tmp42_;
			GtkTreeIter _tmp43_;
			MayaBackend* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			MayaBackend* _tmp47_;
			_backend_index = _backend_index + 1;
			_tmp35_ = _backend_index;
			_tmp36_ = _backend_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _backend_list;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, _backend_index);
			_tmp39_ = _g_object_ref0 ((MayaBackend*) _tmp38_);
			backend = _tmp39_;
			_tmp40_ = self->priv->list_store;
			gtk_list_store_append (_tmp40_, &_tmp41_);
			iter = _tmp41_;
			_tmp42_ = self->priv->list_store;
			_tmp43_ = iter;
			_tmp44_ = backend;
			_tmp45_ = maya_backend_get_name (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = backend;
			gtk_list_store_set (_tmp42_, &_tmp43_, 0, _tmp46_, 1, _tmp47_, -1);
			_g_free0 (_tmp46_);
			_g_object_unref0 (backend);
		}
	}
	_tmp48_ = backends_manager;
	_tmp49_ = _tmp48_->backends;
	_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
	_tmp51_ = _tmp50_;
	if (_tmp51_ <= 1) {
		GtkComboBox* _tmp52_;
		GtkLabel* _tmp53_;
		_tmp52_ = self->priv->type_combobox;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp52_, TRUE);
		_tmp53_ = type_label;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp53_, TRUE);
	}
	_tmp54_ = self->priv->type_combobox;
	gtk_combo_box_set_active (_tmp54_, 0);
	_tmp55_ = (GtkLabel*) gtk_label_new (_ ("Color:"));
	g_object_ref_sink (_tmp55_);
	color_label = _tmp55_;
	_tmp56_ = color_label;
	gtk_label_set_xalign (_tmp56_, (gfloat) 1);
	_tmp57_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->color_button_blue);
	self->priv->color_button_blue = _tmp57_;
	_tmp58_ = self->priv->color_button_blue;
	_tmp59_ = gtk_widget_get_style_context ((GtkWidget*) _tmp58_);
	_tmp60_ = _g_object_ref0 (_tmp59_);
	color_button_blue_context = _tmp60_;
	_tmp61_ = color_button_blue_context;
	gtk_style_context_add_class (_tmp61_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp62_ = color_button_blue_context;
	gtk_style_context_add_class (_tmp62_, "blue");
	_tmp63_ = self->priv->color_button_blue;
	_tmp64_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp63_);
	g_object_ref_sink (_tmp64_);
	_g_object_unref0 (self->priv->color_button_mint);
	self->priv->color_button_mint = _tmp64_;
	_tmp65_ = self->priv->color_button_mint;
	_tmp66_ = gtk_widget_get_style_context ((GtkWidget*) _tmp65_);
	_tmp67_ = _g_object_ref0 (_tmp66_);
	color_button_mint_context = _tmp67_;
	_tmp68_ = color_button_mint_context;
	gtk_style_context_add_class (_tmp68_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp69_ = color_button_mint_context;
	gtk_style_context_add_class (_tmp69_, "mint");
	_tmp70_ = self->priv->color_button_blue;
	_tmp71_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp70_);
	g_object_ref_sink (_tmp71_);
	_g_object_unref0 (self->priv->color_button_green);
	self->priv->color_button_green = _tmp71_;
	_tmp72_ = self->priv->color_button_green;
	_tmp73_ = gtk_widget_get_style_context ((GtkWidget*) _tmp72_);
	_tmp74_ = _g_object_ref0 (_tmp73_);
	color_button_green_context = _tmp74_;
	_tmp75_ = color_button_green_context;
	gtk_style_context_add_class (_tmp75_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp76_ = color_button_green_context;
	gtk_style_context_add_class (_tmp76_, "green");
	_tmp77_ = self->priv->color_button_blue;
	_tmp78_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp77_);
	g_object_ref_sink (_tmp78_);
	_g_object_unref0 (self->priv->color_button_yellow);
	self->priv->color_button_yellow = _tmp78_;
	_tmp79_ = self->priv->color_button_yellow;
	_tmp80_ = gtk_widget_get_style_context ((GtkWidget*) _tmp79_);
	_tmp81_ = _g_object_ref0 (_tmp80_);
	color_button_yellow_context = _tmp81_;
	_tmp82_ = color_button_yellow_context;
	gtk_style_context_add_class (_tmp82_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp83_ = color_button_yellow_context;
	gtk_style_context_add_class (_tmp83_, "yellow");
	_tmp84_ = self->priv->color_button_blue;
	_tmp85_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp84_);
	g_object_ref_sink (_tmp85_);
	_g_object_unref0 (self->priv->color_button_orange);
	self->priv->color_button_orange = _tmp85_;
	_tmp86_ = self->priv->color_button_orange;
	_tmp87_ = gtk_widget_get_style_context ((GtkWidget*) _tmp86_);
	_tmp88_ = _g_object_ref0 (_tmp87_);
	color_button_orange_context = _tmp88_;
	_tmp89_ = color_button_orange_context;
	gtk_style_context_add_class (_tmp89_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp90_ = color_button_orange_context;
	gtk_style_context_add_class (_tmp90_, "orange");
	_tmp91_ = self->priv->color_button_blue;
	_tmp92_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp91_);
	g_object_ref_sink (_tmp92_);
	_g_object_unref0 (self->priv->color_button_red);
	self->priv->color_button_red = _tmp92_;
	_tmp93_ = self->priv->color_button_red;
	_tmp94_ = gtk_widget_get_style_context ((GtkWidget*) _tmp93_);
	_tmp95_ = _g_object_ref0 (_tmp94_);
	color_button_red_context = _tmp95_;
	_tmp96_ = color_button_red_context;
	gtk_style_context_add_class (_tmp96_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp97_ = color_button_red_context;
	gtk_style_context_add_class (_tmp97_, "red");
	_tmp98_ = self->priv->color_button_blue;
	_tmp99_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp98_);
	g_object_ref_sink (_tmp99_);
	_g_object_unref0 (self->priv->color_button_pink);
	self->priv->color_button_pink = _tmp99_;
	_tmp100_ = self->priv->color_button_pink;
	_tmp101_ = gtk_widget_get_style_context ((GtkWidget*) _tmp100_);
	_tmp102_ = _g_object_ref0 (_tmp101_);
	color_button_pink_context = _tmp102_;
	_tmp103_ = color_button_pink_context;
	gtk_style_context_add_class (_tmp103_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp104_ = color_button_pink_context;
	gtk_style_context_add_class (_tmp104_, "pink");
	_tmp105_ = self->priv->color_button_blue;
	_tmp106_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp105_);
	g_object_ref_sink (_tmp106_);
	_g_object_unref0 (self->priv->color_button_purple);
	self->priv->color_button_purple = _tmp106_;
	_tmp107_ = self->priv->color_button_purple;
	_tmp108_ = gtk_widget_get_style_context ((GtkWidget*) _tmp107_);
	_tmp109_ = _g_object_ref0 (_tmp108_);
	color_button_purple_context = _tmp109_;
	_tmp110_ = color_button_purple_context;
	gtk_style_context_add_class (_tmp110_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp111_ = color_button_purple_context;
	gtk_style_context_add_class (_tmp111_, "purple");
	_tmp112_ = self->priv->color_button_blue;
	_tmp113_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp112_);
	g_object_ref_sink (_tmp113_);
	_g_object_unref0 (self->priv->color_button_brown);
	self->priv->color_button_brown = _tmp113_;
	_tmp114_ = self->priv->color_button_brown;
	_tmp115_ = gtk_widget_get_style_context ((GtkWidget*) _tmp114_);
	_tmp116_ = _g_object_ref0 (_tmp115_);
	color_button_brown_context = _tmp116_;
	_tmp117_ = color_button_brown_context;
	gtk_style_context_add_class (_tmp117_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp118_ = color_button_brown_context;
	gtk_style_context_add_class (_tmp118_, "brown");
	_tmp119_ = self->priv->color_button_blue;
	_tmp120_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp119_);
	g_object_ref_sink (_tmp120_);
	_g_object_unref0 (self->priv->color_button_slate);
	self->priv->color_button_slate = _tmp120_;
	_tmp121_ = self->priv->color_button_slate;
	_tmp122_ = gtk_widget_get_style_context ((GtkWidget*) _tmp121_);
	_tmp123_ = _g_object_ref0 (_tmp122_);
	color_button_slate_context = _tmp123_;
	_tmp124_ = color_button_slate_context;
	gtk_style_context_add_class (_tmp124_, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	_tmp125_ = color_button_slate_context;
	gtk_style_context_add_class (_tmp125_, "slate");
	_tmp126_ = self->priv->color_button_blue;
	_tmp127_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp126_);
	g_object_ref_sink (_tmp127_);
	_g_object_unref0 (self->priv->color_button_none);
	self->priv->color_button_none = _tmp127_;
	_tmp128_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp128_, 3);
	g_object_ref_sink (_tmp128_);
	color_grid = _tmp128_;
	_tmp129_ = color_grid;
	_tmp130_ = self->priv->color_button_blue;
	gtk_container_add ((GtkContainer*) _tmp129_, (GtkWidget*) _tmp130_);
	_tmp131_ = color_grid;
	_tmp132_ = self->priv->color_button_mint;
	gtk_container_add ((GtkContainer*) _tmp131_, (GtkWidget*) _tmp132_);
	_tmp133_ = color_grid;
	_tmp134_ = self->priv->color_button_green;
	gtk_container_add ((GtkContainer*) _tmp133_, (GtkWidget*) _tmp134_);
	_tmp135_ = color_grid;
	_tmp136_ = self->priv->color_button_yellow;
	gtk_container_add ((GtkContainer*) _tmp135_, (GtkWidget*) _tmp136_);
	_tmp137_ = color_grid;
	_tmp138_ = self->priv->color_button_orange;
	gtk_container_add ((GtkContainer*) _tmp137_, (GtkWidget*) _tmp138_);
	_tmp139_ = color_grid;
	_tmp140_ = self->priv->color_button_red;
	gtk_container_add ((GtkContainer*) _tmp139_, (GtkWidget*) _tmp140_);
	_tmp141_ = color_grid;
	_tmp142_ = self->priv->color_button_pink;
	gtk_container_add ((GtkContainer*) _tmp141_, (GtkWidget*) _tmp142_);
	_tmp143_ = color_grid;
	_tmp144_ = self->priv->color_button_purple;
	gtk_container_add ((GtkContainer*) _tmp143_, (GtkWidget*) _tmp144_);
	_tmp145_ = color_grid;
	_tmp146_ = self->priv->color_button_brown;
	gtk_container_add ((GtkContainer*) _tmp145_, (GtkWidget*) _tmp146_);
	_tmp147_ = color_grid;
	_tmp148_ = self->priv->color_button_slate;
	gtk_container_add ((GtkContainer*) _tmp147_, (GtkWidget*) _tmp148_);
	_tmp149_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Mark as default calendar"));
	g_object_ref_sink (_tmp149_);
	_g_object_unref0 (self->priv->is_default_check);
	self->priv->is_default_check = _tmp149_;
	_tmp150_ = self->priv->color_button_red;
	g_signal_connect_object ((GtkToggleButton*) _tmp150_, "toggled", (GCallback) __maya_view_source_dialog___lambda160__gtk_toggle_button_toggled, self, 0);
	_tmp151_ = self->priv->color_button_orange;
	g_signal_connect_object ((GtkToggleButton*) _tmp151_, "toggled", (GCallback) __maya_view_source_dialog___lambda161__gtk_toggle_button_toggled, self, 0);
	_tmp152_ = self->priv->color_button_yellow;
	g_signal_connect_object ((GtkToggleButton*) _tmp152_, "toggled", (GCallback) __maya_view_source_dialog___lambda162__gtk_toggle_button_toggled, self, 0);
	_tmp153_ = self->priv->color_button_green;
	g_signal_connect_object ((GtkToggleButton*) _tmp153_, "toggled", (GCallback) __maya_view_source_dialog___lambda163__gtk_toggle_button_toggled, self, 0);
	_tmp154_ = self->priv->color_button_mint;
	g_signal_connect_object ((GtkToggleButton*) _tmp154_, "toggled", (GCallback) __maya_view_source_dialog___lambda164__gtk_toggle_button_toggled, self, 0);
	_tmp155_ = self->priv->color_button_blue;
	g_signal_connect_object ((GtkToggleButton*) _tmp155_, "toggled", (GCallback) __maya_view_source_dialog___lambda165__gtk_toggle_button_toggled, self, 0);
	_tmp156_ = self->priv->color_button_purple;
	g_signal_connect_object ((GtkToggleButton*) _tmp156_, "toggled", (GCallback) __maya_view_source_dialog___lambda166__gtk_toggle_button_toggled, self, 0);
	_tmp157_ = self->priv->color_button_pink;
	g_signal_connect_object ((GtkToggleButton*) _tmp157_, "toggled", (GCallback) __maya_view_source_dialog___lambda167__gtk_toggle_button_toggled, self, 0);
	_tmp158_ = self->priv->color_button_brown;
	g_signal_connect_object ((GtkToggleButton*) _tmp158_, "toggled", (GCallback) __maya_view_source_dialog___lambda168__gtk_toggle_button_toggled, self, 0);
	_tmp159_ = self->priv->color_button_slate;
	g_signal_connect_object ((GtkToggleButton*) _tmp159_, "toggled", (GCallback) __maya_view_source_dialog___lambda169__gtk_toggle_button_toggled, self, 0);
	_tmp160_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp160_);
	_g_object_unref0 (self->priv->main_grid);
	self->priv->main_grid = _tmp160_;
	_tmp161_ = self->priv->main_grid;
	gtk_grid_set_row_spacing (_tmp161_, 6);
	_tmp162_ = self->priv->main_grid;
	gtk_grid_set_column_spacing (_tmp162_, 12);
	_tmp163_ = self->priv->main_grid;
	_tmp164_ = type_label;
	gtk_grid_attach (_tmp163_, (GtkWidget*) _tmp164_, 0, 0, 1, 1);
	_tmp165_ = self->priv->main_grid;
	_tmp166_ = self->priv->type_combobox;
	gtk_grid_attach (_tmp165_, (GtkWidget*) _tmp166_, 1, 0, 1, 1);
	_tmp167_ = self->priv->main_grid;
	_tmp168_ = name_label;
	gtk_grid_attach (_tmp167_, (GtkWidget*) _tmp168_, 0, 1, 1, 1);
	_tmp169_ = self->priv->main_grid;
	_tmp170_ = self->priv->name_entry;
	gtk_grid_attach (_tmp169_, (GtkWidget*) _tmp170_, 1, 1, 1, 1);
	_tmp171_ = self->priv->main_grid;
	_tmp172_ = color_label;
	gtk_grid_attach (_tmp171_, (GtkWidget*) _tmp172_, 0, 2, 1, 1);
	_tmp173_ = self->priv->main_grid;
	_tmp174_ = color_grid;
	gtk_grid_attach (_tmp173_, (GtkWidget*) _tmp174_, 1, 2, 1, 1);
	_tmp175_ = self->priv->main_grid;
	_tmp176_ = self->priv->is_default_check;
	gtk_grid_attach (_tmp175_, (GtkWidget*) _tmp176_, 1, 3, 1, 1);
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 8);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 24);
	_tmp177_ = self->priv->main_grid;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp177_, 0, 0, 1, 1);
	_tmp178_ = buttonbox;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp178_, 0, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (color_grid);
	_g_object_unref0 (color_button_slate_context);
	_g_object_unref0 (color_button_brown_context);
	_g_object_unref0 (color_button_purple_context);
	_g_object_unref0 (color_button_pink_context);
	_g_object_unref0 (color_button_red_context);
	_g_object_unref0 (color_button_orange_context);
	_g_object_unref0 (color_button_yellow_context);
	_g_object_unref0 (color_button_green_context);
	_g_object_unref0 (color_button_mint_context);
	_g_object_unref0 (color_button_blue_context);
	_g_object_unref0 (color_label);
	_g_object_unref0 (backends_manager);
	_g_object_unref0 (type_label);
	_g_object_unref0 (renderer);
	_g_object_unref0 (name_label);
	_g_object_unref0 (buttonbox);
	_g_object_unref0 (cancel_button);
	return obj;
}

static void
maya_view_source_dialog_class_init (MayaViewSourceDialogClass * klass,
                                    gpointer klass_data)
{
	maya_view_source_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewSourceDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_source_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_source_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_source_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_source_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY, maya_view_source_dialog_properties[MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY] = g_param_spec_enum ("event-type", "event-type", "event-type", MAYA_VIEW_TYPE_EVENT_TYPE, MAYA_VIEW_EVENT_TYPE_EDIT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	maya_view_source_dialog_signals[MAYA_VIEW_SOURCE_DIALOG_GO_BACK_SIGNAL] = g_signal_new ("go-back", MAYA_VIEW_TYPE_SOURCE_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
maya_view_source_dialog_instance_init (MayaViewSourceDialog * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	self->priv = maya_view_source_dialog_get_instance_private (self);
	self->priv->_event_type = MAYA_VIEW_EVENT_TYPE_EDIT;
	_tmp0_ = g_strdup ("#da3d41");
	self->priv->hex_color = _tmp0_;
	self->priv->source = NULL;
}

static void
maya_view_source_dialog_finalize (GObject * obj)
{
	MayaViewSourceDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	_g_object_unref0 (self->priv->name_entry);
	_g_free0 (self->priv->hex_color);
	_g_object_unref0 (self->priv->current_backend);
	_g_object_unref0 (self->priv->backend_widgets);
	_g_object_unref0 (self->priv->main_grid);
	_g_object_unref0 (self->priv->widgets_checked);
	_g_object_unref0 (self->priv->create_button);
	_g_object_unref0 (self->priv->type_combobox);
	_g_object_unref0 (self->priv->list_store);
	_g_object_unref0 (self->priv->is_default_check);
	_g_object_unref0 (self->priv->source);
	_g_object_unref0 (self->priv->color_button_blue);
	_g_object_unref0 (self->priv->color_button_mint);
	_g_object_unref0 (self->priv->color_button_green);
	_g_object_unref0 (self->priv->color_button_yellow);
	_g_object_unref0 (self->priv->color_button_orange);
	_g_object_unref0 (self->priv->color_button_red);
	_g_object_unref0 (self->priv->color_button_pink);
	_g_object_unref0 (self->priv->color_button_purple);
	_g_object_unref0 (self->priv->color_button_brown);
	_g_object_unref0 (self->priv->color_button_slate);
	_g_object_unref0 (self->priv->color_button_none);
	G_OBJECT_CLASS (maya_view_source_dialog_parent_class)->finalize (obj);
}

static GType
maya_view_source_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewSourceDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_source_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewSourceDialog), 0, (GInstanceInitFunc) maya_view_source_dialog_instance_init, NULL };
	GType maya_view_source_dialog_type_id;
	maya_view_source_dialog_type_id = g_type_register_static (gtk_grid_get_type (), "MayaViewSourceDialog", &g_define_type_info, 0);
	MayaViewSourceDialog_private_offset = g_type_add_instance_private (maya_view_source_dialog_type_id, sizeof (MayaViewSourceDialogPrivate));
	return maya_view_source_dialog_type_id;
}

GType
maya_view_source_dialog_get_type (void)
{
	static volatile gsize maya_view_source_dialog_type_id__once = 0;
	if (g_once_init_enter (&maya_view_source_dialog_type_id__once)) {
		GType maya_view_source_dialog_type_id;
		maya_view_source_dialog_type_id = maya_view_source_dialog_get_type_once ();
		g_once_init_leave (&maya_view_source_dialog_type_id__once, maya_view_source_dialog_type_id);
	}
	return maya_view_source_dialog_type_id__once;
}

static void
_vala_maya_view_source_dialog_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewSourceDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	switch (property_id) {
		case MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY:
		g_value_set_enum (value, maya_view_source_dialog_get_event_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_source_dialog_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewSourceDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_SOURCE_DIALOG, MayaViewSourceDialog);
	switch (property_id) {
		case MAYA_VIEW_SOURCE_DIALOG_EVENT_TYPE_PROPERTY:
		maya_view_source_dialog_set_event_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

