/* MainWindow.c generated by valac 0.56.16, the Vala compiler
 * generated from MainWindow.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2023 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian <maxwell@elementary.io>
 *              Corentin Noël <corentin@elementary.io>
 */

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <granite.h>
#include <libecal/libecal.h>
#include "elementary-calendar.h"
#include <libedataserver/libedataserver.h>
#include <cairo-gobject.h>

#define MAYA_MAIN_WINDOW_ACTION_PREFIX "win."
#define MAYA_MAIN_WINDOW_ACTION_NEW_EVENT "action_new_event"
#define MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY "action_show_today"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_TYPE_MAIN_WINDOW (maya_main_window_get_type ())
#define MAYA_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindow))
#define MAYA_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))
#define MAYA_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_MAIN_WINDOW))
#define MAYA_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_MAIN_WINDOW, MayaMainWindowClass))

typedef struct _MayaMainWindow MayaMainWindow;
typedef struct _MayaMainWindowClass MayaMainWindowClass;
typedef struct _MayaMainWindowPrivate MayaMainWindowPrivate;

#define MAYA_VIEW_TYPE_CALENDAR_VIEW (maya_view_calendar_view_get_type ())
#define MAYA_VIEW_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView))
#define MAYA_VIEW_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))
#define MAYA_VIEW_IS_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_IS_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_CALENDAR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))

typedef struct _MayaViewCalendarView MayaViewCalendarView;
typedef struct _MayaViewCalendarViewClass MayaViewCalendarViewClass;
enum  {
	MAYA_MAIN_WINDOW_0_PROPERTY,
	MAYA_MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* maya_main_window_properties[MAYA_MAIN_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define MAYA_VIEW_TYPE_EVENT_DIALOG (maya_view_event_dialog_get_type ())
#define MAYA_VIEW_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog))
#define MAYA_VIEW_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))
#define MAYA_VIEW_IS_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_IS_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_EVENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))

typedef struct _MayaViewEventDialog MayaViewEventDialog;
typedef struct _MayaViewEventDialogClass MayaViewEventDialogClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))

#define MAYA_TYPE_APPLICATION (maya_application_get_type ())
#define MAYA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_TYPE_APPLICATION, MayaApplication))
#define MAYA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_TYPE_APPLICATION, MayaApplicationClass))
#define MAYA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_TYPE_APPLICATION))
#define MAYA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_TYPE_APPLICATION))
#define MAYA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_TYPE_APPLICATION, MayaApplicationClass))

typedef struct _MayaApplication MayaApplication;
typedef struct _MayaApplicationClass MayaApplicationClass;

#define MAYA_VIEW_TYPE_AGENDA_VIEW (maya_view_agenda_view_get_type ())
#define MAYA_VIEW_AGENDA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaView))
#define MAYA_VIEW_AGENDA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaViewClass))
#define MAYA_VIEW_IS_AGENDA_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW))
#define MAYA_VIEW_IS_AGENDA_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_AGENDA_VIEW))
#define MAYA_VIEW_AGENDA_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_AGENDA_VIEW, MayaViewAgendaViewClass))

typedef struct _MayaViewAgendaView MayaViewAgendaView;
typedef struct _MayaViewAgendaViewClass MayaViewAgendaViewClass;
typedef struct _Block4Data Block4Data;

#define CALENDAR_WIDGETS_TYPE_HEADER_BAR (calendar_widgets_header_bar_get_type ())
#define CALENDAR_WIDGETS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_WIDGETS_TYPE_HEADER_BAR, CalendarWidgetsHeaderBar))
#define CALENDAR_WIDGETS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_WIDGETS_TYPE_HEADER_BAR, CalendarWidgetsHeaderBarClass))
#define CALENDAR_WIDGETS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_WIDGETS_TYPE_HEADER_BAR))
#define CALENDAR_WIDGETS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_WIDGETS_TYPE_HEADER_BAR))
#define CALENDAR_WIDGETS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_WIDGETS_TYPE_HEADER_BAR, CalendarWidgetsHeaderBarClass))

typedef struct _CalendarWidgetsHeaderBar CalendarWidgetsHeaderBar;
typedef struct _CalendarWidgetsHeaderBarClass CalendarWidgetsHeaderBarClass;

#define CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR (calendar_widgets_connectivity_info_bar_get_type ())
#define CALENDAR_WIDGETS_CONNECTIVITY_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR, CalendarWidgetsConnectivityInfoBar))
#define CALENDAR_WIDGETS_CONNECTIVITY_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR, CalendarWidgetsConnectivityInfoBarClass))
#define CALENDAR_WIDGETS_IS_CONNECTIVITY_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR))
#define CALENDAR_WIDGETS_IS_CONNECTIVITY_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR))
#define CALENDAR_WIDGETS_CONNECTIVITY_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CALENDAR_WIDGETS_TYPE_CONNECTIVITY_INFO_BAR, CalendarWidgetsConnectivityInfoBarClass))

typedef struct _CalendarWidgetsConnectivityInfoBar CalendarWidgetsConnectivityInfoBar;
typedef struct _CalendarWidgetsConnectivityInfoBarClass CalendarWidgetsConnectivityInfoBarClass;
typedef struct _Block5Data Block5Data;

struct _MayaMainWindow {
	HdyApplicationWindow parent_instance;
	MayaMainWindowPrivate * priv;
	MayaViewCalendarView* calview;
};

struct _MayaMainWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _MayaMainWindowPrivate {
	guint configure_id;
};

struct _Block4Data {
	int _ref_count_;
	MayaMainWindow* self;
	GtkLabel* error_label;
	GtkInfoBar* error_bar;
	MayaViewAgendaView* sidebar;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	gchar* message;
};

static gint MayaMainWindow_private_offset;
static gpointer maya_main_window_parent_class = NULL;
static GeeMultiMap* maya_main_window_action_accelerators;
static GeeMultiMap* maya_main_window_action_accelerators = NULL;
VALA_EXTERN GSettings* maya_application_saved_state;

VALA_EXTERN GType maya_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaMainWindow, g_object_unref)
VALA_EXTERN GType maya_view_calendar_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewCalendarView, g_object_unref)
static void maya_main_window_action_new_event (MayaMainWindow* self);
static void _maya_main_window_action_new_event_gsimple_action_activate_callback (GSimpleAction* action,
                                                                          GVariant* parameter,
                                                                          gpointer self);
static void maya_main_window_action_show_today (MayaMainWindow* self);
static void _maya_main_window_action_show_today_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
VALA_EXTERN MayaMainWindow* maya_main_window_new (GtkApplication* application);
VALA_EXTERN MayaMainWindow* maya_main_window_construct (GType object_type,
                                            GtkApplication* application);
VALA_EXTERN void maya_main_window_on_tb_add_clicked (MayaMainWindow* self,
                                         GDateTime* dt);
VALA_EXTERN GType maya_view_event_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventDialog, g_object_unref)
VALA_EXTERN MayaViewEventDialog* maya_view_event_dialog_new (ECalComponent* ecal,
                                                 GDateTime* date_time,
                                                 GtkWindow* parent);
VALA_EXTERN MayaViewEventDialog* maya_view_event_dialog_construct (GType object_type,
                                                       ECalComponent* ecal,
                                                       GDateTime* date_time,
                                                       GtkWindow* parent);
VALA_EXTERN GDateTime* maya_view_calendar_view_get_selected_date (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_calendar_view_today (MayaViewCalendarView* self);
static void maya_main_window_on_remove (MayaMainWindow* self,
                                 ECalComponent* comp);
VALA_EXTERN void maya_main_window_on_modified (MayaMainWindow* self,
                                   ECalComponent* comp);
VALA_EXTERN void maya_main_window_on_duplicated (MayaMainWindow* self,
                                     ECalComponent* comp);
static void _vala_ECalComponentId_free (ECalComponentId* self);
static gboolean maya_main_window_real_configure_event (GtkWidget* base,
                                                GdkEventConfigure* event);
static gboolean __lambda145_ (MayaMainWindow* self);
static gboolean ___lambda145__gsource_func (gpointer self);
static gboolean maya_main_window_real_delete_event (GtkWidget* base,
                                             GdkEventAny* event);
VALA_EXTERN GType maya_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaApplication, g_object_unref)
VALA_EXTERN void maya_application_ask_for_background (MayaApplication* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN gboolean maya_application_ask_for_background_finish (MayaApplication* self,
                                                     GAsyncResult* _res_);
static void __lambda146_ (MayaMainWindow* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ___lambda146__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static GObject * maya_main_window_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
VALA_EXTERN GType maya_view_agenda_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewAgendaView, g_object_unref)
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN GType calendar_widgets_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarWidgetsHeaderBar, g_object_unref)
VALA_EXTERN CalendarWidgetsHeaderBar* calendar_widgets_header_bar_new (void);
VALA_EXTERN CalendarWidgetsHeaderBar* calendar_widgets_header_bar_construct (GType object_type);
VALA_EXTERN GType calendar_widgets_connectivity_info_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CalendarWidgetsConnectivityInfoBar, g_object_unref)
VALA_EXTERN CalendarWidgetsConnectivityInfoBar* calendar_widgets_connectivity_info_bar_new (void);
VALA_EXTERN CalendarWidgetsConnectivityInfoBar* calendar_widgets_connectivity_info_bar_construct (GType object_type);
VALA_EXTERN MayaViewAgendaView* maya_view_agenda_view_new (void);
VALA_EXTERN MayaViewAgendaView* maya_view_agenda_view_construct (GType object_type);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_new (void);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_construct (GType object_type);
static void _maya_main_window___lambda192_ (MayaMainWindow* self,
                                     GDateTime* date);
static void __maya_main_window___lambda192__maya_view_calendar_view_on_event_add (MayaViewCalendarView* _sender,
                                                                           GDateTime* date,
                                                                           gpointer self);
static void _maya_main_window___lambda193_ (Block4Data* _data4_,
                                     GDateTime* date);
VALA_EXTERN void maya_view_agenda_view_set_selected_date (MayaViewAgendaView* self,
                                              GDateTime* date);
static void __maya_main_window___lambda193__maya_view_calendar_view_selection_changed (MayaViewCalendarView* _sender,
                                                                                GDateTime* new_date,
                                                                                gpointer self);
static void _maya_main_window___lambda194_ (Block4Data* _data4_,
                                     gint id);
static void __maya_main_window___lambda194__gtk_info_bar_response (GtkInfoBar* _sender,
                                                            gint response_id,
                                                            gpointer self);
static void _maya_main_window_on_remove_maya_view_agenda_view_event_removed (MayaViewAgendaView* _sender,
                                                                      ECalComponent* event,
                                                                      gpointer self);
static void _maya_main_window___lambda195_ (Block4Data* _data4_,
                                     const gchar* message);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda196_ (Block5Data* _data5_);
static gboolean ___lambda196__gsource_func (gpointer self);
static void __maya_main_window___lambda195__calendar_event_store_error_received (CalendarEventStore* _sender,
                                                                          const gchar* _error_,
                                                                          gpointer self);
static void maya_main_window_finalize (GObject * obj);
static GType maya_main_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry MAYA_MAIN_WINDOW_ACTION_ENTRIES[2] = {{MAYA_MAIN_WINDOW_ACTION_NEW_EVENT, _maya_main_window_action_new_event_gsimple_action_activate_callback}, {MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY, _maya_main_window_action_show_today_gsimple_action_activate_callback}};

static inline gpointer
maya_main_window_get_instance_private (MayaMainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MayaMainWindow_private_offset);
}

static void
_maya_main_window_action_new_event_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self)
{
	maya_main_window_action_new_event ((MayaMainWindow*) self);
}

static void
_maya_main_window_action_show_today_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	maya_main_window_action_show_today ((MayaMainWindow*) self);
}

MayaMainWindow*
maya_main_window_construct (GType object_type,
                            GtkApplication* application)
{
	MayaMainWindow * self = NULL;
	g_return_val_if_fail (application != NULL, NULL);
	self = (MayaMainWindow*) g_object_new (object_type, "application", application, "height-request", 400, "icon-name", "io.elementary.calendar", "width-request", 625, NULL);
	return self;
}

MayaMainWindow*
maya_main_window_new (GtkApplication* application)
{
	return maya_main_window_construct (MAYA_TYPE_MAIN_WINDOW, application);
}

void
maya_main_window_on_tb_add_clicked (MayaMainWindow* self,
                                    GDateTime* dt)
{
	MayaViewEventDialog* dialog = NULL;
	MayaViewEventDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dt != NULL);
	_tmp0_ = maya_view_event_dialog_new (NULL, dt, (GtkWindow*) self);
	g_object_ref_sink (_tmp0_);
	dialog = _tmp0_;
	gtk_widget_show_all ((GtkWidget*) dialog);
	_g_object_unref0 (dialog);
}

static void
maya_main_window_action_new_event (MayaMainWindow* self)
{
	MayaViewCalendarView* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->calview;
	_tmp1_ = maya_view_calendar_view_get_selected_date (_tmp0_);
	_tmp2_ = _tmp1_;
	maya_main_window_on_tb_add_clicked (self, _tmp2_);
}

static void
maya_main_window_action_show_today (MayaMainWindow* self)
{
	MayaViewCalendarView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->calview;
	maya_view_calendar_view_today (_tmp0_);
}

static void
maya_main_window_on_remove (MayaMainWindow* self,
                            ECalComponent* comp)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comp != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_object_get_data ((GObject*) comp, "source");
	calendar_event_store_remove_event (_tmp1_, (ESource*) _tmp2_, comp, E_CAL_OBJ_MOD_THIS);
	_g_object_unref0 (_tmp1_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
maya_main_window_on_modified (MayaMainWindow* self,
                              ECalComponent* comp)
{
	ESource* src = NULL;
	gconstpointer _tmp0_;
	ESource* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESource* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comp != NULL);
	_tmp0_ = g_object_get_data ((GObject*) comp, "source");
	_tmp1_ = _g_object_ref0 ((ESource*) _tmp0_);
	src = _tmp1_;
	_tmp3_ = src;
	_tmp4_ = e_source_get_writable (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		CalendarEventStore* _tmp6_;
		CalendarEventStore* _tmp7_;
		ESource* _tmp8_;
		_tmp6_ = calendar_event_store_get_default ();
		_tmp7_ = _tmp6_;
		_tmp8_ = src;
		_tmp2_ = calendar_event_store_calclient_is_readonly (_tmp7_, _tmp8_) == FALSE;
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		MayaViewEventDialog* dialog = NULL;
		MayaViewEventDialog* _tmp9_;
		MayaViewEventDialog* _tmp10_;
		_tmp9_ = maya_view_event_dialog_new (comp, NULL, (GtkWindow*) self);
		g_object_ref_sink (_tmp9_);
		dialog = _tmp9_;
		_tmp10_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp10_);
		_g_object_unref0 (dialog);
	} else {
		gdk_beep ();
	}
	_g_object_unref0 (src);
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

void
maya_main_window_on_duplicated (MayaMainWindow* self,
                                ECalComponent* comp)
{
	ESource* src = NULL;
	gconstpointer _tmp0_;
	ESource* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESource* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comp != NULL);
	_tmp0_ = g_object_get_data ((GObject*) comp, "source");
	_tmp1_ = _g_object_ref0 ((ESource*) _tmp0_);
	src = _tmp1_;
	_tmp3_ = src;
	_tmp4_ = e_source_get_writable (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		CalendarEventStore* _tmp6_;
		CalendarEventStore* _tmp7_;
		ESource* _tmp8_;
		_tmp6_ = calendar_event_store_get_default ();
		_tmp7_ = _tmp6_;
		_tmp8_ = src;
		_tmp2_ = calendar_event_store_calclient_is_readonly (_tmp7_, _tmp8_) == FALSE;
		_g_object_unref0 (_tmp7_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ECalComponent* dup_comp = NULL;
		ECalComponent* _tmp9_;
		ECalComponent* _tmp10_;
		ECalComponentId* _tmp11_;
		ECalComponentId* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		MayaViewEventDialog* dialog = NULL;
		ECalComponent* _tmp16_;
		MayaViewEventDialog* _tmp17_;
		MayaViewEventDialog* _tmp18_;
		MayaViewEventDialog* _tmp19_;
		_tmp9_ = maya_util_copy_ecal_component (comp);
		dup_comp = _tmp9_;
		_tmp10_ = dup_comp;
		_tmp11_ = e_cal_component_get_id (comp);
		_tmp12_ = _tmp11_;
		_tmp13_ = e_cal_component_id_get_uid (_tmp12_);
		_tmp14_ = maya_util_mangle_uid (_tmp13_);
		_tmp15_ = _tmp14_;
		e_cal_component_set_uid (_tmp10_, _tmp15_);
		_g_free0 (_tmp15_);
		__vala_ECalComponentId_free0 (_tmp12_);
		_tmp16_ = dup_comp;
		_tmp17_ = maya_view_event_dialog_new (_tmp16_, NULL, (GtkWindow*) self);
		g_object_ref_sink (_tmp17_);
		dialog = _tmp17_;
		_tmp18_ = dialog;
		gtk_window_set_transient_for ((GtkWindow*) _tmp18_, (GtkWindow*) self);
		_tmp19_ = dialog;
		gtk_window_present ((GtkWindow*) _tmp19_);
		_g_object_unref0 (dialog);
		_g_object_unref0 (dup_comp);
	} else {
		gdk_beep ();
	}
	_g_object_unref0 (src);
}

static gboolean
__lambda145_ (MayaMainWindow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self->priv->configure_id = (guint) 0;
	g_object_get ((GtkWindow*) self, "is-maximized", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GSettings* _tmp2_;
		_tmp2_ = maya_application_saved_state;
		g_settings_set_boolean (_tmp2_, "window-maximized", TRUE);
	} else {
		GSettings* _tmp3_;
		GdkRectangle rect = {0};
		GtkAllocation _tmp4_ = {0};
		GSettings* _tmp5_;
		GdkRectangle _tmp6_;
		GdkRectangle _tmp7_;
		gint root_x = 0;
		gint root_y = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		GSettings* _tmp10_;
		_tmp3_ = maya_application_saved_state;
		g_settings_set_boolean (_tmp3_, "window-maximized", FALSE);
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
		rect = _tmp4_;
		_tmp5_ = maya_application_saved_state;
		_tmp6_ = rect;
		_tmp7_ = rect;
		g_settings_set (_tmp5_, "window-size", "(ii)", _tmp6_.width, _tmp7_.height);
		gtk_window_get_position ((GtkWindow*) self, &_tmp8_, &_tmp9_);
		root_x = _tmp8_;
		root_y = _tmp9_;
		_tmp10_ = maya_application_saved_state;
		g_settings_set (_tmp10_, "window-position", "(ii)", root_x, root_y);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda145__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda145_ ((MayaMainWindow*) self);
	return result;
}

static gboolean
maya_main_window_real_configure_event (GtkWidget* base,
                                       GdkEventConfigure* event)
{
	MayaMainWindow * self;
	gboolean result;
	self = (MayaMainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->configure_id != ((guint) 0)) {
		g_source_remove (self->priv->configure_id);
	}
	self->priv->configure_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda145__gsource_func, g_object_ref (self), g_object_unref);
	result = GTK_WIDGET_CLASS (maya_main_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, hdy_application_window_get_type (), HdyApplicationWindow), event);
	return result;
}

static void
__lambda146_ (MayaMainWindow* self,
              GObject* obj,
              GAsyncResult* res)
{
	MayaApplication* app = NULL;
	MayaApplication* _tmp0_;
	g_return_if_fail (res != NULL);
	app = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_APPLICATION, MayaApplication);
	_tmp0_ = app;
	if (maya_application_ask_for_background_finish (_tmp0_, res)) {
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_destroy ((GtkWidget*) self);
	}
}

static void
___lambda146__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda146_ ((MayaMainWindow*) self, source_object, res);
	g_object_unref (self);
}

static gboolean
maya_main_window_real_delete_event (GtkWidget* base,
                                    GdkEventAny* event)
{
	MayaMainWindow * self;
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	gboolean result;
	self = (MayaMainWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	maya_application_ask_for_background (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, MAYA_TYPE_APPLICATION, MayaApplication), ___lambda146__gasync_ready_callback, g_object_ref (self));
	result = GDK_EVENT_STOP;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		MayaMainWindow* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->sidebar);
		_g_object_unref0 (_data4_->error_bar);
		_g_object_unref0 (_data4_->error_label);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
_maya_main_window___lambda192_ (MayaMainWindow* self,
                                GDateTime* date)
{
	g_return_if_fail (date != NULL);
	maya_main_window_on_tb_add_clicked (self, date);
}

static void
__maya_main_window___lambda192__maya_view_calendar_view_on_event_add (MayaViewCalendarView* _sender,
                                                                      GDateTime* date,
                                                                      gpointer self)
{
	_maya_main_window___lambda192_ ((MayaMainWindow*) self, date);
}

static void
_maya_main_window___lambda193_ (Block4Data* _data4_,
                                GDateTime* date)
{
	MayaMainWindow* self;
	MayaViewAgendaView* _tmp0_;
	self = _data4_->self;
	g_return_if_fail (date != NULL);
	_tmp0_ = _data4_->sidebar;
	maya_view_agenda_view_set_selected_date (_tmp0_, date);
}

static void
__maya_main_window___lambda193__maya_view_calendar_view_selection_changed (MayaViewCalendarView* _sender,
                                                                           GDateTime* new_date,
                                                                           gpointer self)
{
	_maya_main_window___lambda193_ (self, new_date);
}

static void
_maya_main_window___lambda194_ (Block4Data* _data4_,
                                gint id)
{
	MayaMainWindow* self;
	GtkInfoBar* _tmp0_;
	self = _data4_->self;
	_tmp0_ = _data4_->error_bar;
	gtk_info_bar_set_revealed (_tmp0_, FALSE);
}

static void
__maya_main_window___lambda194__gtk_info_bar_response (GtkInfoBar* _sender,
                                                       gint response_id,
                                                       gpointer self)
{
	_maya_main_window___lambda194_ (self, response_id);
}

static void
_maya_main_window_on_remove_maya_view_agenda_view_event_removed (MayaViewAgendaView* _sender,
                                                                 ECalComponent* event,
                                                                 gpointer self)
{
	maya_main_window_on_remove ((MayaMainWindow*) self, event);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		MayaMainWindow* self;
		self = _data5_->_data4_->self;
		_g_free0 (_data5_->message);
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda196_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	MayaMainWindow* self;
	GtkLabel* _tmp0_;
	GtkInfoBar* _tmp1_;
	gboolean result;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = _data4_->error_label;
	gtk_label_set_label (_tmp0_, _data5_->message);
	_tmp1_ = _data4_->error_bar;
	gtk_info_bar_set_revealed (_tmp1_, TRUE);
	result = FALSE;
	return result;
}

static gboolean
___lambda196__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda196_ (self);
	return result;
}

static void
_maya_main_window___lambda195_ (Block4Data* _data4_,
                                const gchar* message)
{
	MayaMainWindow* self;
	Block5Data* _data5_;
	gchar* _tmp0_;
	self = _data4_->self;
	g_return_if_fail (message != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->_data4_ = block4_data_ref (_data4_);
	_tmp0_ = g_strdup (message);
	_g_free0 (_data5_->message);
	_data5_->message = _tmp0_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda196__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static void
__maya_main_window___lambda195__calendar_event_store_error_received (CalendarEventStore* _sender,
                                                                     const gchar* _error_,
                                                                     gpointer self)
{
	_maya_main_window___lambda195_ (self, _error_);
}

static GObject *
maya_main_window_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaMainWindow * self;
	Block4Data* _data4_;
	GtkIconTheme* default_theme = NULL;
	GtkIconTheme* _tmp19_;
	GtkIconTheme* _tmp20_;
	CalendarWidgetsHeaderBar* headerbar = NULL;
	CalendarWidgetsHeaderBar* _tmp21_;
	GtkLabel* _tmp22_;
	GtkLabel* _tmp23_;
	GtkInfoBar* _tmp24_ = NULL;
	GtkInfoBar* _tmp25_;
	GtkContainer* _tmp26_;
	GtkLabel* _tmp27_;
	CalendarWidgetsConnectivityInfoBar* info_bar = NULL;
	CalendarWidgetsConnectivityInfoBar* _tmp28_;
	MayaViewAgendaView* _tmp29_ = NULL;
	MayaViewAgendaView* _tmp30_;
	MayaViewCalendarView* _tmp31_ = NULL;
	GtkPaned* hpaned = NULL;
	GtkPaned* _tmp32_;
	GtkPaned* _tmp33_;
	MayaViewCalendarView* _tmp34_;
	GtkPaned* _tmp35_;
	MayaViewAgendaView* _tmp36_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp37_;
	GtkGrid* _tmp38_;
	GtkGrid* _tmp39_;
	CalendarWidgetsHeaderBar* _tmp40_;
	GtkGrid* _tmp41_;
	GtkInfoBar* _tmp42_;
	GtkGrid* _tmp43_;
	CalendarWidgetsConnectivityInfoBar* _tmp44_;
	GtkGrid* _tmp45_;
	GtkPaned* _tmp46_;
	GtkGrid* _tmp47_;
	MayaViewCalendarView* _tmp48_;
	MayaViewCalendarView* _tmp49_;
	GtkInfoBar* _tmp50_;
	MayaViewAgendaView* _tmp51_;
	GSettings* _tmp52_;
	GtkPaned* _tmp53_;
	CalendarEventStore* _tmp54_;
	CalendarEventStore* _tmp55_;
	parent_class = G_OBJECT_CLASS (maya_main_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_MAIN_WINDOW, MayaMainWindow);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	hdy_init ();
	g_action_map_add_action_entries ((GActionMap*) self, MAYA_MAIN_WINDOW_ACTION_ENTRIES, (gint) G_N_ELEMENTS (MAYA_MAIN_WINDOW_ACTION_ENTRIES), self);
	{
		GeeIterator* _action_it = NULL;
		GeeMultiMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = maya_main_window_action_accelerators;
		_tmp1_ = gee_multi_map_get_keys (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_action_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gchar* action = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			GApplication* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GeeMultiMap* _tmp12_;
			const gchar* _tmp13_;
			GeeCollection* _tmp14_;
			GeeCollection* _tmp15_;
			gint _tmp16_ = 0;
			gpointer* _tmp17_;
			gchar** _tmp18_;
			gint _tmp18__length1;
			_tmp5_ = _action_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _action_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			action = (gchar*) _tmp7_;
			_tmp8_ = g_application_get_default ();
			_tmp9_ = action;
			_tmp10_ = g_strconcat (MAYA_MAIN_WINDOW_ACTION_PREFIX, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = maya_main_window_action_accelerators;
			_tmp13_ = action;
			_tmp14_ = gee_multi_map_get (_tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp17_ = gee_collection_to_array (_tmp15_, &_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp18__length1 = _tmp16_;
			gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_application_get_type (), GtkApplication), _tmp11_, _tmp18_);
			_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_tmp15_);
			_g_free0 (_tmp11_);
			_g_free0 (action);
		}
		_g_object_unref0 (_action_it);
	}
	_tmp19_ = gtk_icon_theme_get_default ();
	default_theme = _tmp19_;
	_tmp20_ = default_theme;
	gtk_icon_theme_add_resource_path (_tmp20_, "/io/elementary/calendar");
	_tmp21_ = calendar_widgets_header_bar_new ();
	g_object_ref_sink (_tmp21_);
	headerbar = _tmp21_;
	_tmp22_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp22_);
	_data4_->error_label = _tmp22_;
	_tmp23_ = _data4_->error_label;
	gtk_widget_show ((GtkWidget*) _tmp23_);
	_tmp24_ = (GtkInfoBar*) gtk_info_bar_new ();
	gtk_info_bar_set_message_type (_tmp24_, GTK_MESSAGE_ERROR);
	gtk_info_bar_set_revealed (_tmp24_, FALSE);
	gtk_info_bar_set_show_close_button (_tmp24_, TRUE);
	g_object_ref_sink (_tmp24_);
	_data4_->error_bar = _tmp24_;
	_tmp25_ = _data4_->error_bar;
	_tmp26_ = gtk_info_bar_get_content_area (_tmp25_);
	_tmp27_ = _data4_->error_label;
	gtk_container_add (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = calendar_widgets_connectivity_info_bar_new ();
	g_object_ref_sink (_tmp28_);
	info_bar = _tmp28_;
	_tmp29_ = maya_view_agenda_view_new ();
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp29_, TRUE);
	g_object_set ((GtkWidget*) _tmp29_, "width-request", 160, NULL);
	g_object_ref_sink (_tmp29_);
	_data4_->sidebar = _tmp29_;
	_tmp30_ = _data4_->sidebar;
	gtk_widget_show ((GtkWidget*) _tmp30_);
	_tmp31_ = maya_view_calendar_view_new ();
	gtk_widget_set_vexpand ((GtkWidget*) _tmp31_, TRUE);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->calview);
	self->calview = _tmp31_;
	_tmp32_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp32_);
	hpaned = _tmp32_;
	_tmp33_ = hpaned;
	_tmp34_ = self->calview;
	gtk_paned_pack1 (_tmp33_, (GtkWidget*) _tmp34_, TRUE, FALSE);
	_tmp35_ = hpaned;
	_tmp36_ = _data4_->sidebar;
	gtk_paned_pack2 (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE);
	_tmp37_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp37_);
	grid = _tmp37_;
	_tmp38_ = grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp38_, GTK_ORIENTATION_VERTICAL);
	_tmp39_ = grid;
	_tmp40_ = headerbar;
	gtk_container_add ((GtkContainer*) _tmp39_, (GtkWidget*) _tmp40_);
	_tmp41_ = grid;
	_tmp42_ = _data4_->error_bar;
	gtk_container_add ((GtkContainer*) _tmp41_, (GtkWidget*) _tmp42_);
	_tmp43_ = grid;
	_tmp44_ = info_bar;
	gtk_container_add ((GtkContainer*) _tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = grid;
	_tmp46_ = hpaned;
	gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp47_);
	_tmp48_ = self->calview;
	g_signal_connect_object (_tmp48_, "on-event-add", (GCallback) __maya_main_window___lambda192__maya_view_calendar_view_on_event_add, self, 0);
	_tmp49_ = self->calview;
	g_signal_connect_data (_tmp49_, "selection-changed", (GCallback) __maya_main_window___lambda193__maya_view_calendar_view_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp50_ = _data4_->error_bar;
	g_signal_connect_data (_tmp50_, "response", (GCallback) __maya_main_window___lambda194__gtk_info_bar_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp51_ = _data4_->sidebar;
	g_signal_connect_object (_tmp51_, "event-removed", (GCallback) _maya_main_window_on_remove_maya_view_agenda_view_event_removed, self, 0);
	_tmp52_ = maya_application_saved_state;
	_tmp53_ = hpaned;
	g_settings_bind (_tmp52_, "hpaned-position", (GObject*) _tmp53_, "position", G_SETTINGS_BIND_DEFAULT);
	_tmp54_ = calendar_event_store_get_default ();
	_tmp55_ = _tmp54_;
	g_signal_connect_data (_tmp55_, "error-received", (GCallback) __maya_main_window___lambda195__calendar_event_store_error_received, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_g_object_unref0 (_tmp55_);
	_g_object_unref0 (grid);
	_g_object_unref0 (hpaned);
	_g_object_unref0 (info_bar);
	_g_object_unref0 (headerbar);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return obj;
}

static void
maya_main_window_class_init (MayaMainWindowClass * klass,
                             gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeMultiMap* _tmp1_;
	GeeMultiMap* _tmp2_;
	maya_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaMainWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) maya_main_window_real_configure_event;
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) maya_main_window_real_delete_event;
	G_OBJECT_CLASS (klass)->constructor = maya_main_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_main_window_finalize;
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	maya_main_window_action_accelerators = (GeeMultiMap*) _tmp0_;
	_tmp1_ = maya_main_window_action_accelerators;
	gee_multi_map_set (_tmp1_, MAYA_MAIN_WINDOW_ACTION_NEW_EVENT, "<Control>n");
	_tmp2_ = maya_main_window_action_accelerators;
	gee_multi_map_set (_tmp2_, MAYA_MAIN_WINDOW_ACTION_SHOW_TODAY, "<Control>t");
}

static void
maya_main_window_instance_init (MayaMainWindow * self,
                                gpointer klass)
{
	self->priv = maya_main_window_get_instance_private (self);
}

static void
maya_main_window_finalize (GObject * obj)
{
	MayaMainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_MAIN_WINDOW, MayaMainWindow);
	_g_object_unref0 (self->calview);
	G_OBJECT_CLASS (maya_main_window_parent_class)->finalize (obj);
}

static GType
maya_main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaMainWindow), 0, (GInstanceInitFunc) maya_main_window_instance_init, NULL };
	GType maya_main_window_type_id;
	maya_main_window_type_id = g_type_register_static (hdy_application_window_get_type (), "MayaMainWindow", &g_define_type_info, 0);
	MayaMainWindow_private_offset = g_type_add_instance_private (maya_main_window_type_id, sizeof (MayaMainWindowPrivate));
	return maya_main_window_type_id;
}

GType
maya_main_window_get_type (void)
{
	static volatile gsize maya_main_window_type_id__once = 0;
	if (g_once_init_enter (&maya_main_window_type_id__once)) {
		GType maya_main_window_type_id;
		maya_main_window_type_id = maya_main_window_get_type_once ();
		g_once_init_leave (&maya_main_window_type_id__once, maya_main_window_type_id);
	}
	return maya_main_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

