/* ImportDialog.c generated by valac 0.56.16, the Vala compiler
 * generated from ImportDialog.vala, do not modify */

/*-
 * Copyright (c) 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementaryos.org>
 */

#include <granite.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libedataserver/libedataserver.h>
#include "elementary-calendar.h"
#include <libical-glib/libical-glib.h>
#include <libecal/libecal.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_IMPORT_DIALOG (maya_view_import_dialog_get_type ())
#define MAYA_VIEW_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialog))
#define MAYA_VIEW_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialogClass))
#define MAYA_VIEW_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG))
#define MAYA_VIEW_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_IMPORT_DIALOG))
#define MAYA_VIEW_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialogClass))

typedef struct _MayaViewImportDialog MayaViewImportDialog;
typedef struct _MayaViewImportDialogClass MayaViewImportDialogClass;
typedef struct _MayaViewImportDialogPrivate MayaViewImportDialogPrivate;

#define MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER (maya_view_widgets_calendar_chooser_get_type ())
#define MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooser))
#define MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooserClass))
#define MAYA_VIEW_WIDGETS_IS_CALENDAR_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER))
#define MAYA_VIEW_WIDGETS_IS_CALENDAR_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER))
#define MAYA_VIEW_WIDGETS_CALENDAR_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_WIDGETS_TYPE_CALENDAR_CHOOSER, MayaViewWidgetsCalendarChooserClass))

typedef struct _MayaViewWidgetsCalendarChooser MayaViewWidgetsCalendarChooser;
typedef struct _MayaViewWidgetsCalendarChooserClass MayaViewWidgetsCalendarChooserClass;
enum  {
	MAYA_VIEW_IMPORT_DIALOG_0_PROPERTY,
	MAYA_VIEW_IMPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* maya_view_import_dialog_properties[MAYA_VIEW_IMPORT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MayaViewImportDialog {
	GraniteMessageDialog parent_instance;
	MayaViewImportDialogPrivate * priv;
};

struct _MayaViewImportDialogClass {
	GraniteMessageDialogClass parent_class;
};

struct _MayaViewImportDialogPrivate {
	GFile** files;
	gint files_length1;
	gint _files_size_;
	MayaViewWidgetsCalendarChooser* calchooser;
};

static gint MayaViewImportDialog_private_offset;
static gpointer maya_view_import_dialog_parent_class = NULL;

VALA_EXTERN GType maya_view_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewImportDialog, g_object_unref)
VALA_EXTERN GType maya_view_widgets_calendar_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewWidgetsCalendarChooser, g_object_unref)
VALA_EXTERN MayaViewImportDialog* maya_view_import_dialog_new (GFile** files,
                                                   gint files_length1);
VALA_EXTERN MayaViewImportDialog* maya_view_import_dialog_construct (GType object_type,
                                                         GFile** files,
                                                         gint files_length1);
static GFile** _vala_array_dup1 (GFile** self,
                          gssize length);
VALA_EXTERN MayaViewWidgetsCalendarChooser* maya_view_widgets_calendar_chooser_new (void);
VALA_EXTERN MayaViewWidgetsCalendarChooser* maya_view_widgets_calendar_chooser_construct (GType object_type);
static void __lambda178_ (MayaViewImportDialog* self,
                   gint response_id);
static void maya_view_import_dialog_import_files (MayaViewImportDialog* self);
static void ___lambda178__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN ESource* maya_view_widgets_calendar_chooser_get_current_source (MayaViewWidgetsCalendarChooser* self);
static void maya_view_import_dialog_finalize (GObject * obj);
static GType maya_view_import_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
maya_view_import_dialog_get_instance_private (MayaViewImportDialog* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewImportDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GFile**
_vala_array_dup1 (GFile** self,
                  gssize length)
{
	if (length >= 0) {
		GFile** result;
		gssize i;
		result = g_new0 (GFile*, length + 1);
		for (i = 0; i < length; i++) {
			GFile* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
__lambda178_ (MayaViewImportDialog* self,
              gint response_id)
{
	if (response_id == ((gint) GTK_RESPONSE_APPLY)) {
		maya_view_import_dialog_import_files (self);
	}
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda178__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	__lambda178_ ((MayaViewImportDialog*) self, response_id);
}

MayaViewImportDialog*
maya_view_import_dialog_construct (GType object_type,
                                   GFile** files,
                                   gint files_length1)
{
	MayaViewImportDialog * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GFile** _tmp2_;
	gint _tmp2__length1;
	MayaViewWidgetsCalendarChooser* _tmp18_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp19_;
	MayaViewWidgetsCalendarChooser* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkBin* _tmp22_;
	GtkBin* _tmp23_;
	GtkButton* ok_button = NULL;
	GtkWidget* _tmp24_;
	GtkButton* _tmp25_;
	GtkStyleContext* _tmp26_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("document-import");
	_tmp1_ = _tmp0_;
	self = (MayaViewImportDialog*) g_object_new (object_type, "buttons", GTK_BUTTONS_CANCEL, "image-icon", _tmp1_, "primary-text", _ ("Select a Calendar to Import Into"), NULL);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (files != NULL) ? _vala_array_dup1 (files, files_length1) : files;
	_tmp2__length1 = files_length1;
	self->priv->files = (_vala_array_free (self->priv->files, self->priv->files_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->files = _tmp2_;
	self->priv->files_length1 = _tmp2__length1;
	self->priv->_files_size_ = self->priv->files_length1;
	if (files_length1 == 1) {
		gchar* name = NULL;
		gchar* _tmp3_;
		GFile* file = NULL;
		GFile* _tmp4_;
		GFile* _tmp5_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp3_ = g_strdup ("");
		name = _tmp3_;
		_tmp4_ = files[0];
		_tmp5_ = _g_object_ref0 (_tmp4_);
		file = _tmp5_;
		{
			GFileInfo* fileinfo = NULL;
			GFile* _tmp6_;
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = file;
			_tmp7_ = g_file_query_info (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			fileinfo = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = fileinfo;
			_tmp9_ = g_file_info_get_display_name (_tmp8_);
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (name);
			name = _tmp10_;
			_g_object_unref0 (fileinfo);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_critical ("ImportDialog.vala:41: %s", _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp13_ = name;
		_tmp14_ = g_strdup_printf (_ ("Events from \"%s\" will be merged with this calendar:"), _tmp13_);
		_tmp15_ = _tmp14_;
		granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, _tmp15_);
		_g_free0 (_tmp15_);
		_g_object_unref0 (file);
		_g_free0 (name);
	} else {
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = g_strdup_printf (ngettext ("Events from %d file will be merged with this calendar:", "Events from %d files will be merged with this calendar:", (gulong) files_length1), files_length1);
		_tmp17_ = _tmp16_;
		granite_message_dialog_set_secondary_text ((GraniteMessageDialog*) self, _tmp17_);
		_g_free0 (_tmp17_);
	}
	_tmp18_ = maya_view_widgets_calendar_chooser_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->calchooser);
	self->priv->calchooser = _tmp18_;
	_tmp19_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp19_);
	frame = _tmp19_;
	_tmp20_ = self->priv->calchooser;
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) _tmp20_);
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) frame);
	gtk_style_context_add_class (_tmp21_, GTK_STYLE_CLASS_VIEW);
	_tmp22_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp23_ = _tmp22_;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) frame);
	_tmp24_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Import"), (gint) GTK_RESPONSE_APPLY);
	_tmp25_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_button_get_type (), GtkButton));
	ok_button = _tmp25_;
	_tmp26_ = gtk_widget_get_style_context ((GtkWidget*) ok_button);
	gtk_style_context_add_class (_tmp26_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) ___lambda178__gtk_dialog_response, self, 0);
	_g_object_unref0 (ok_button);
	_g_object_unref0 (frame);
	return self;
}

MayaViewImportDialog*
maya_view_import_dialog_new (GFile** files,
                             gint files_length1)
{
	return maya_view_import_dialog_construct (MAYA_VIEW_TYPE_IMPORT_DIALOG, files, files_length1);
}

static void
maya_view_import_dialog_import_files (MayaViewImportDialog* self)
{
	ESource* source = NULL;
	MayaViewWidgetsCalendarChooser* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	ESource* _tmp3_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp4_;
	GFile** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->calchooser;
	_tmp1_ = maya_view_widgets_calendar_chooser_get_current_source (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	source = _tmp3_;
	_tmp4_ = calendar_event_store_get_default ();
	calmodel = _tmp4_;
	_tmp5_ = self->priv->files;
	_tmp5__length1 = self->priv->files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp5_;
		file_collection_length1 = _tmp5__length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp6_;
			GFile* file = NULL;
			_tmp6_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp6_;
			{
				ICalComponent* ical = NULL;
				GFile* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				ICalComponent* _tmp10_;
				ICalComponent* _tmp11_;
				ICalComponent* _tmp12_;
				_tmp7_ = file;
				_tmp8_ = g_file_get_path (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = e_cal_util_parse_ics_file (_tmp9_);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp9_);
				ical = _tmp11_;
				_tmp12_ = ical;
				if (i_cal_component_is_valid (_tmp12_)) {
					{
						ICalComponent* comp = NULL;
						ICalComponent* _tmp13_;
						ICalComponent* _tmp14_;
						_tmp13_ = ical;
						_tmp14_ = i_cal_component_get_first_component (_tmp13_, I_CAL_VEVENT_COMPONENT);
						comp = _tmp14_;
						{
							gboolean _tmp15_ = FALSE;
							_tmp15_ = TRUE;
							while (TRUE) {
								ICalComponent* _tmp18_;
								ECalComponent* ecal = NULL;
								ICalComponent* _tmp19_;
								gchar* _tmp20_;
								gchar* _tmp21_;
								ECalComponent* _tmp22_;
								ECalComponent* _tmp23_;
								CalendarEventStore* _tmp24_;
								ESource* _tmp25_;
								ECalComponent* _tmp26_;
								if (!_tmp15_) {
									ICalComponent* _tmp16_;
									ICalComponent* _tmp17_;
									_tmp16_ = ical;
									_tmp17_ = i_cal_component_get_next_component (_tmp16_, I_CAL_VEVENT_COMPONENT);
									_g_object_unref0 (comp);
									comp = _tmp17_;
								}
								_tmp15_ = FALSE;
								_tmp18_ = comp;
								if (!(_tmp18_ != NULL)) {
									break;
								}
								_tmp19_ = comp;
								_tmp20_ = i_cal_component_as_ical_string (_tmp19_);
								_tmp21_ = _tmp20_;
								_tmp22_ = e_cal_component_new_from_string (_tmp21_);
								_tmp23_ = _tmp22_;
								_g_free0 (_tmp21_);
								ecal = _tmp23_;
								_tmp24_ = calmodel;
								_tmp25_ = source;
								_tmp26_ = ecal;
								calendar_event_store_add_event (_tmp24_, _tmp25_, _tmp26_);
								_g_object_unref0 (ecal);
							}
						}
						_g_object_unref0 (comp);
					}
				}
				_g_object_unref0 (ical);
				_g_object_unref0 (file);
			}
		}
	}
	_g_object_unref0 (calmodel);
	_g_object_unref0 (source);
}

static void
maya_view_import_dialog_class_init (MayaViewImportDialogClass * klass,
                                    gpointer klass_data)
{
	maya_view_import_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewImportDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_view_import_dialog_finalize;
}

static void
maya_view_import_dialog_instance_init (MayaViewImportDialog * self,
                                       gpointer klass)
{
	self->priv = maya_view_import_dialog_get_instance_private (self);
}

static void
maya_view_import_dialog_finalize (GObject * obj)
{
	MayaViewImportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_IMPORT_DIALOG, MayaViewImportDialog);
	self->priv->files = (_vala_array_free (self->priv->files, self->priv->files_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->calchooser);
	G_OBJECT_CLASS (maya_view_import_dialog_parent_class)->finalize (obj);
}

static GType
maya_view_import_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewImportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_import_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewImportDialog), 0, (GInstanceInitFunc) maya_view_import_dialog_instance_init, NULL };
	GType maya_view_import_dialog_type_id;
	maya_view_import_dialog_type_id = g_type_register_static (GRANITE_TYPE_MESSAGE_DIALOG, "MayaViewImportDialog", &g_define_type_info, 0);
	MayaViewImportDialog_private_offset = g_type_add_instance_private (maya_view_import_dialog_type_id, sizeof (MayaViewImportDialogPrivate));
	return maya_view_import_dialog_type_id;
}

GType
maya_view_import_dialog_get_type (void)
{
	static volatile gsize maya_view_import_dialog_type_id__once = 0;
	if (g_once_init_enter (&maya_view_import_dialog_type_id__once)) {
		GType maya_view_import_dialog_type_id;
		maya_view_import_dialog_type_id = maya_view_import_dialog_get_type_once ();
		g_once_init_leave (&maya_view_import_dialog_type_id__once, maya_view_import_dialog_type_id);
	}
	return maya_view_import_dialog_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

