/* WeekLabels.c generated by valac 0.56.16, the Vala compiler
 * generated from WeekLabels.vala, do not modify */

/*-
 * Copyright (c) 2011-2019 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_WEEK_LABELS (maya_view_week_labels_get_type ())
#define MAYA_VIEW_WEEK_LABELS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabels))
#define MAYA_VIEW_WEEK_LABELS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabelsClass))
#define MAYA_VIEW_IS_WEEK_LABELS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_WEEK_LABELS))
#define MAYA_VIEW_IS_WEEK_LABELS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_WEEK_LABELS))
#define MAYA_VIEW_WEEK_LABELS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabelsClass))

typedef struct _MayaViewWeekLabels MayaViewWeekLabels;
typedef struct _MayaViewWeekLabelsClass MayaViewWeekLabelsClass;
typedef struct _MayaViewWeekLabelsPrivate MayaViewWeekLabelsPrivate;
enum  {
	MAYA_VIEW_WEEK_LABELS_0_PROPERTY,
	MAYA_VIEW_WEEK_LABELS_NUM_PROPERTIES
};
static GParamSpec* maya_view_week_labels_properties[MAYA_VIEW_WEEK_LABELS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _MayaViewWeekLabels {
	GtkRevealer parent_instance;
	MayaViewWeekLabelsPrivate * priv;
};

struct _MayaViewWeekLabelsClass {
	GtkRevealerClass parent_class;
};

struct _MayaViewWeekLabelsPrivate {
	GtkGrid* day_grid;
	GtkLabel** labels;
	gint labels_length1;
	gint _labels_size_;
	gint nr_of_weeks;
};

static gint MayaViewWeekLabels_private_offset;
static gpointer maya_view_week_labels_parent_class = NULL;
static GSettings* maya_view_week_labels_show_weeks;
static GSettings* maya_view_week_labels_show_weeks = NULL;
static GtkCssProvider* maya_view_week_labels_style_provider;
static GtkCssProvider* maya_view_week_labels_style_provider = NULL;
VALA_EXTERN GSettings* maya_application_wingpanel_settings;
VALA_EXTERN GSettings* maya_application_saved_state;

VALA_EXTERN GType maya_view_week_labels_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewWeekLabels, g_object_unref)
VALA_EXTERN void maya_view_week_labels_update (MayaViewWeekLabels* self,
                                   GDateTime* date,
                                   gint nr_of_weeks);
VALA_EXTERN void maya_view_week_labels_set_nr_of_weeks (MayaViewWeekLabels* self,
                                            gint new_number);
VALA_EXTERN gint maya_view_week_labels_get_nr_of_weeks (MayaViewWeekLabels* self);
VALA_EXTERN MayaViewWeekLabels* maya_view_week_labels_new (void);
VALA_EXTERN MayaViewWeekLabels* maya_view_week_labels_construct (GType object_type);
static GObject * maya_view_week_labels_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static gboolean _maya_view_week_labels___lambda5_ (MayaViewWeekLabels* self,
                                            GdkEventButton* event);
static void ___lambda6_ (MayaViewWeekLabels* self);
static void ____lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static gboolean __maya_view_week_labels___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self);
static void maya_view_week_labels_finalize (GObject * obj);
static GType maya_view_week_labels_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
maya_view_week_labels_get_instance_private (MayaViewWeekLabels* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewWeekLabels_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
maya_view_week_labels_update (MayaViewWeekLabels* self,
                              GDateTime* date,
                              gint nr_of_weeks)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	_tmp0_ = maya_view_week_labels_show_weeks;
	if (g_settings_get_boolean (_tmp0_, "show-weeks")) {
		GtkLabel** _tmp1_;
		gint _tmp1__length1;
		GtkLabel** _tmp5_;
		GDateTime* next = NULL;
		GDateTime* _tmp25_;
		gint days_to_add = 0;
		GDateTime* _tmp26_;
		GDateTime* _tmp27_;
		GDateTime* _tmp28_;
		GtkLabel** _tmp29_;
		gint _tmp29__length1;
		_tmp1_ = self->priv->labels;
		_tmp1__length1 = self->priv->labels_length1;
		if (_tmp1_ != NULL) {
			GtkLabel** _tmp2_;
			gint _tmp2__length1;
			_tmp2_ = self->priv->labels;
			_tmp2__length1 = self->priv->labels_length1;
			{
				GtkLabel** label_collection = NULL;
				gint label_collection_length1 = 0;
				gint _label_collection_size_ = 0;
				gint label_it = 0;
				label_collection = _tmp2_;
				label_collection_length1 = _tmp2__length1;
				for (label_it = 0; label_it < label_collection_length1; label_it = label_it + 1) {
					GtkLabel* _tmp3_;
					GtkLabel* label = NULL;
					_tmp3_ = _g_object_ref0 (label_collection[label_it]);
					label = _tmp3_;
					{
						GtkLabel* _tmp4_;
						_tmp4_ = label;
						gtk_widget_destroy ((GtkWidget*) _tmp4_);
						_g_object_unref0 (label);
					}
				}
			}
		}
		_tmp5_ = g_new0 (GtkLabel*, nr_of_weeks + 1);
		self->priv->labels = (_vala_array_free (self->priv->labels, self->priv->labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->labels = _tmp5_;
		self->priv->labels_length1 = nr_of_weeks;
		self->priv->_labels_size_ = self->priv->labels_length1;
		{
			gint c = 0;
			c = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GtkLabel** _tmp8_;
					gint _tmp8__length1;
					GtkLabel* _tmp9_;
					GtkLabel** _tmp10_;
					gint _tmp10__length1;
					GtkLabel* _tmp11_;
					GtkLabel** _tmp12_;
					gint _tmp12__length1;
					GtkLabel* _tmp13_;
					GtkStyleContext* label_context = NULL;
					GtkLabel** _tmp14_;
					gint _tmp14__length1;
					GtkLabel* _tmp15_;
					GtkStyleContext* _tmp16_;
					GtkStyleContext* _tmp17_;
					GtkCssProvider* _tmp18_;
					GtkStyleContext* _tmp19_;
					GtkGrid* _tmp20_;
					GtkLabel** _tmp21_;
					gint _tmp21__length1;
					GtkLabel* _tmp22_;
					GtkLabel** _tmp23_;
					gint _tmp23__length1;
					GtkLabel* _tmp24_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = c;
						c = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					if (!(c < nr_of_weeks)) {
						break;
					}
					_tmp8_ = self->priv->labels;
					_tmp8__length1 = self->priv->labels_length1;
					_tmp9_ = (GtkLabel*) gtk_label_new ("");
					g_object_ref_sink (_tmp9_);
					_g_object_unref0 (_tmp8_[c]);
					_tmp8_[c] = _tmp9_;
					_tmp10_ = self->priv->labels;
					_tmp10__length1 = self->priv->labels_length1;
					_tmp11_ = _tmp10_[c];
					gtk_widget_set_valign ((GtkWidget*) _tmp11_, GTK_ALIGN_START);
					_tmp12_ = self->priv->labels;
					_tmp12__length1 = self->priv->labels_length1;
					_tmp13_ = _tmp12_[c];
					gtk_label_set_width_chars (_tmp13_, 2);
					_tmp14_ = self->priv->labels;
					_tmp14__length1 = self->priv->labels_length1;
					_tmp15_ = _tmp14_[c];
					_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
					label_context = _tmp16_;
					_tmp17_ = label_context;
					_tmp18_ = maya_view_week_labels_style_provider;
					gtk_style_context_add_provider (_tmp17_, (GtkStyleProvider*) _tmp18_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
					_tmp19_ = label_context;
					gtk_style_context_add_class (_tmp19_, "weeklabel");
					_tmp20_ = self->priv->day_grid;
					_tmp21_ = self->priv->labels;
					_tmp21__length1 = self->priv->labels_length1;
					_tmp22_ = _tmp21_[c];
					gtk_grid_attach (_tmp20_, (GtkWidget*) _tmp22_, 0, c, 1, 1);
					_tmp23_ = self->priv->labels;
					_tmp23__length1 = self->priv->labels_length1;
					_tmp24_ = _tmp23_[c];
					gtk_widget_show ((GtkWidget*) _tmp24_);
				}
			}
		}
		_tmp25_ = _g_date_time_ref0 (date);
		next = _tmp25_;
		_tmp26_ = next;
		days_to_add = (8 - g_date_time_get_day_of_week (_tmp26_)) % 7;
		_tmp27_ = next;
		_tmp28_ = g_date_time_add_days (_tmp27_, days_to_add);
		_g_date_time_unref0 (next);
		next = _tmp28_;
		_tmp29_ = self->priv->labels;
		_tmp29__length1 = self->priv->labels_length1;
		{
			GtkLabel** label_collection = NULL;
			gint label_collection_length1 = 0;
			gint _label_collection_size_ = 0;
			gint label_it = 0;
			label_collection = _tmp29_;
			label_collection_length1 = _tmp29__length1;
			for (label_it = 0; label_it < label_collection_length1; label_it = label_it + 1) {
				GtkLabel* _tmp30_;
				GtkLabel* label = NULL;
				_tmp30_ = _g_object_ref0 (label_collection[label_it]);
				label = _tmp30_;
				{
					GtkLabel* _tmp31_;
					GDateTime* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					GDateTime* _tmp35_;
					GDateTime* _tmp36_;
					_tmp31_ = label;
					_tmp32_ = next;
					_tmp33_ = g_strdup_printf ("%i", g_date_time_get_week_of_year (_tmp32_));
					_tmp34_ = _tmp33_;
					gtk_label_set_label (_tmp31_, _tmp34_);
					_g_free0 (_tmp34_);
					_tmp35_ = next;
					_tmp36_ = g_date_time_add_weeks (_tmp35_, 1);
					_g_date_time_unref0 (next);
					next = _tmp36_;
					_g_object_unref0 (label);
				}
			}
		}
		_g_date_time_unref0 (next);
	}
}

void
maya_view_week_labels_set_nr_of_weeks (MayaViewWeekLabels* self,
                                       gint new_number)
{
	GtkGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->day_grid;
	gtk_grid_insert_row (_tmp0_, new_number);
	self->priv->nr_of_weeks = new_number;
}

gint
maya_view_week_labels_get_nr_of_weeks (MayaViewWeekLabels* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->nr_of_weeks;
	return result;
}

MayaViewWeekLabels*
maya_view_week_labels_construct (GType object_type)
{
	MayaViewWeekLabels * self = NULL;
	self = (MayaViewWeekLabels*) g_object_new (object_type, NULL);
	return self;
}

MayaViewWeekLabels*
maya_view_week_labels_new (void)
{
	return maya_view_week_labels_construct (MAYA_VIEW_TYPE_WEEK_LABELS);
}

static void
___lambda6_ (MayaViewWeekLabels* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	_tmp0_ = maya_view_week_labels_show_weeks;
	_tmp1_ = maya_view_week_labels_show_weeks;
	g_settings_set_boolean (_tmp0_, "show-weeks", !g_settings_get_boolean (_tmp1_, "show-weeks"));
}

static void
____lambda6__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	___lambda6_ ((MayaViewWeekLabels*) self);
}

static gboolean
_maya_view_week_labels___lambda5_ (MayaViewWeekLabels* self,
                                   GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->type == GDK_BUTTON_PRESS) {
		_tmp0_ = event->button == ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMenuItem* show_weeks_menuitem = NULL;
		GtkMenuItem* _tmp1_;
		GSettings* _tmp2_;
		GtkMenuItem* _tmp5_;
		GtkMenu* menu = NULL;
		GtkMenu* _tmp6_;
		GtkMenu* _tmp7_;
		GtkMenu* _tmp8_;
		GtkMenuItem* _tmp9_;
		GtkMenu* _tmp10_;
		GtkMenu* _tmp11_;
		_tmp1_ = (GtkMenuItem*) gtk_menu_item_new ();
		g_object_ref_sink (_tmp1_);
		show_weeks_menuitem = _tmp1_;
		_tmp2_ = maya_view_week_labels_show_weeks;
		if (g_settings_get_boolean (_tmp2_, "show-weeks")) {
			GtkMenuItem* _tmp3_;
			_tmp3_ = show_weeks_menuitem;
			gtk_menu_item_set_label (_tmp3_, _ ("Hide Week Numbers"));
		} else {
			GtkMenuItem* _tmp4_;
			_tmp4_ = show_weeks_menuitem;
			gtk_menu_item_set_label (_tmp4_, _ ("Show Week Numbers"));
		}
		_tmp5_ = show_weeks_menuitem;
		g_signal_connect_object (_tmp5_, "activate", (GCallback) ____lambda6__gtk_menu_item_activate, self, 0);
		_tmp6_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp6_);
		menu = _tmp6_;
		_tmp7_ = menu;
		gtk_menu_attach_to_widget (_tmp7_, (GtkWidget*) self, NULL);
		_tmp8_ = menu;
		_tmp9_ = show_weeks_menuitem;
		gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
		_tmp10_ = menu;
		gtk_widget_show_all ((GtkWidget*) _tmp10_);
		_tmp11_ = menu;
		gtk_menu_popup_at_pointer (_tmp11_, (GdkEvent*) event);
		_g_object_unref0 (menu);
		_g_object_unref0 (show_weeks_menuitem);
	}
	result = FALSE;
	return result;
}

static gboolean
__maya_view_week_labels___lambda5__gtk_widget_button_press_event (GtkWidget* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
	gboolean result;
	result = _maya_view_week_labels___lambda5_ ((MayaViewWeekLabels*) self, event);
	return result;
}

static GObject *
maya_view_week_labels_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewWeekLabels * self;
	GdkEventMask _tmp0_;
	GdkEventMask _tmp1_;
	GtkGrid* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkStyleContext* day_grid_context = NULL;
	GtkGrid* _tmp8_;
	GtkStyleContext* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkCssProvider* _tmp11_;
	GtkStyleContext* _tmp12_;
	GSettings* _tmp13_;
	GtkGrid* _tmp14_;
	parent_class = G_OBJECT_CLASS (maya_view_week_labels_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabels);
	_tmp0_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp1_ = _tmp0_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp1_ | GDK_BUTTON_PRESS_MASK);
	gtk_revealer_set_transition_type ((GtkRevealer*) self, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->day_grid);
	self->priv->day_grid = _tmp2_;
	maya_view_week_labels_set_nr_of_weeks (self, 5);
	_tmp3_ = self->priv->day_grid;
	gtk_grid_insert_row (_tmp3_, 1);
	_tmp4_ = self->priv->day_grid;
	gtk_grid_set_column_homogeneous (_tmp4_, TRUE);
	_tmp5_ = self->priv->day_grid;
	gtk_grid_set_row_homogeneous (_tmp5_, TRUE);
	_tmp6_ = self->priv->day_grid;
	gtk_grid_set_row_spacing (_tmp6_, 0);
	_tmp7_ = self->priv->day_grid;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->day_grid;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	day_grid_context = _tmp9_;
	_tmp10_ = day_grid_context;
	_tmp11_ = maya_view_week_labels_style_provider;
	gtk_style_context_add_provider (_tmp10_, (GtkStyleProvider*) _tmp11_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp12_ = day_grid_context;
	gtk_style_context_add_class (_tmp12_, "weeks");
	_tmp13_ = maya_view_week_labels_show_weeks;
	g_settings_bind (_tmp13_, "show-weeks", (GObject*) self, "reveal-child", G_SETTINGS_BIND_DEFAULT);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) __maya_view_week_labels___lambda5__gtk_widget_button_press_event, self, 0);
	_tmp14_ = self->priv->day_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp14_);
	return obj;
}

static void
maya_view_week_labels_class_init (MayaViewWeekLabelsClass * klass,
                                  gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GSettings* _tmp2_;
	maya_view_week_labels_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewWeekLabels_private_offset);
	G_OBJECT_CLASS (klass)->constructor = maya_view_week_labels_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_week_labels_finalize;
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (maya_view_week_labels_style_provider);
	maya_view_week_labels_style_provider = _tmp0_;
	_tmp1_ = maya_view_week_labels_style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/calendar/WeekLabels.css");
	_tmp2_ = maya_application_wingpanel_settings;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp3_ = maya_application_wingpanel_settings;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (maya_view_week_labels_show_weeks);
		maya_view_week_labels_show_weeks = _tmp4_;
	} else {
		GSettings* _tmp5_;
		GSettings* _tmp6_;
		_tmp5_ = maya_application_saved_state;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (maya_view_week_labels_show_weeks);
		maya_view_week_labels_show_weeks = _tmp6_;
	}
}

static void
maya_view_week_labels_instance_init (MayaViewWeekLabels * self,
                                     gpointer klass)
{
	self->priv = maya_view_week_labels_get_instance_private (self);
}

static void
maya_view_week_labels_finalize (GObject * obj)
{
	MayaViewWeekLabels * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabels);
	_g_object_unref0 (self->priv->day_grid);
	self->priv->labels = (_vala_array_free (self->priv->labels, self->priv->labels_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (maya_view_week_labels_parent_class)->finalize (obj);
}

/**
 * Represent the week labels at the left side of the grid.
 */
static GType
maya_view_week_labels_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewWeekLabelsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_week_labels_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewWeekLabels), 0, (GInstanceInitFunc) maya_view_week_labels_instance_init, NULL };
	GType maya_view_week_labels_type_id;
	maya_view_week_labels_type_id = g_type_register_static (gtk_revealer_get_type (), "MayaViewWeekLabels", &g_define_type_info, 0);
	MayaViewWeekLabels_private_offset = g_type_add_instance_private (maya_view_week_labels_type_id, sizeof (MayaViewWeekLabelsPrivate));
	return maya_view_week_labels_type_id;
}

GType
maya_view_week_labels_get_type (void)
{
	static volatile gsize maya_view_week_labels_type_id__once = 0;
	if (g_once_init_enter (&maya_view_week_labels_type_id__once)) {
		GType maya_view_week_labels_type_id;
		maya_view_week_labels_type_id = maya_view_week_labels_get_type_once ();
		g_once_init_leave (&maya_view_week_labels_type_id__once, maya_view_week_labels_type_id);
	}
	return maya_view_week_labels_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

