/* CalendarView.c generated by valac 0.56.16, the Vala compiler
 * generated from CalendarView.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2015 Maya Developers (http://launchpad.net/maya)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Maxwell Barvian
 *              Corentin Noël <corentin@elementaryos.org>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include "elementary-calendar.h"
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <libecal/libecal.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_TYPE_CALENDAR_VIEW (maya_view_calendar_view_get_type ())
#define MAYA_VIEW_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView))
#define MAYA_VIEW_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))
#define MAYA_VIEW_IS_CALENDAR_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_IS_CALENDAR_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_CALENDAR_VIEW))
#define MAYA_VIEW_CALENDAR_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarViewClass))

typedef struct _MayaViewCalendarView MayaViewCalendarView;
typedef struct _MayaViewCalendarViewClass MayaViewCalendarViewClass;
typedef struct _MayaViewCalendarViewPrivate MayaViewCalendarViewPrivate;

#define MAYA_VIEW_TYPE_WEEK_LABELS (maya_view_week_labels_get_type ())
#define MAYA_VIEW_WEEK_LABELS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabels))
#define MAYA_VIEW_WEEK_LABELS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabelsClass))
#define MAYA_VIEW_IS_WEEK_LABELS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_WEEK_LABELS))
#define MAYA_VIEW_IS_WEEK_LABELS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_WEEK_LABELS))
#define MAYA_VIEW_WEEK_LABELS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_WEEK_LABELS, MayaViewWeekLabelsClass))

typedef struct _MayaViewWeekLabels MayaViewWeekLabels;
typedef struct _MayaViewWeekLabelsClass MayaViewWeekLabelsClass;

#define MAYA_VIEW_TYPE_HEADER (maya_view_header_get_type ())
#define MAYA_VIEW_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_HEADER, MayaViewHeader))
#define MAYA_VIEW_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_HEADER, MayaViewHeaderClass))
#define MAYA_VIEW_IS_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_HEADER))
#define MAYA_VIEW_IS_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_HEADER))
#define MAYA_VIEW_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_HEADER, MayaViewHeaderClass))

typedef struct _MayaViewHeader MayaViewHeader;
typedef struct _MayaViewHeaderClass MayaViewHeaderClass;

#define MAYA_VIEW_TYPE_GRID (maya_view_grid_get_type ())
#define MAYA_VIEW_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_GRID, MayaViewGrid))
#define MAYA_VIEW_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_GRID, MayaViewGridClass))
#define MAYA_VIEW_IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_GRID))
#define MAYA_VIEW_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_GRID))
#define MAYA_VIEW_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_GRID, MayaViewGridClass))

typedef struct _MayaViewGrid MayaViewGrid;
typedef struct _MayaViewGridClass MayaViewGridClass;
enum  {
	MAYA_VIEW_CALENDAR_VIEW_0_PROPERTY,
	MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY,
	MAYA_VIEW_CALENDAR_VIEW_NUM_PROPERTIES
};
static GParamSpec* maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;
typedef struct _Block21Data Block21Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	MAYA_VIEW_CALENDAR_VIEW_ON_EVENT_ADD_SIGNAL,
	MAYA_VIEW_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL,
	MAYA_VIEW_CALENDAR_VIEW_NUM_SIGNALS
};
static guint maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MayaViewCalendarView {
	GtkGrid parent_instance;
	MayaViewCalendarViewPrivate * priv;
};

struct _MayaViewCalendarViewClass {
	GtkGridClass parent_class;
};

struct _MayaViewCalendarViewPrivate {
	GDateTime* _selected_date;
	MayaViewWeekLabels* _weeks;
	MayaViewHeader* _header;
	MayaViewGrid* _days_grid;
	GtkStack* _stack;
	GtkLabel* _spacer;
};

struct _Block19Data {
	int _ref_count_;
	MayaViewCalendarView* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block20Data {
	int _ref_count_;
	MayaViewCalendarView* self;
	ESource* source;
	GeeCollection* events;
};

struct _Block21Data {
	int _ref_count_;
	MayaViewCalendarView* self;
	ESource* source;
	GeeCollection* events;
};

static gint MayaViewCalendarView_private_offset;
static gpointer maya_view_calendar_view_parent_class = NULL;
static GSettings* maya_view_calendar_view_show_weeks;
static GSettings* maya_view_calendar_view_show_weeks = NULL;
static GtkCssProvider* maya_view_calendar_view_style_provider;
static GtkCssProvider* maya_view_calendar_view_style_provider = NULL;
VALA_EXTERN GSettings* maya_application_wingpanel_settings;
VALA_EXTERN GSettings* maya_application_saved_state;

VALA_EXTERN GType maya_view_calendar_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewCalendarView, g_object_unref)
VALA_EXTERN GType maya_view_week_labels_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewWeekLabels, g_object_unref)
VALA_EXTERN GType maya_view_header_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewHeader, g_object_unref)
VALA_EXTERN GType maya_view_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewGrid, g_object_unref)
static gboolean maya_view_calendar_view_real_scroll_event (GtkWidget* base,
                                                    GdkEventScroll* event);
VALA_EXTERN void maya_view_calendar_view_today (MayaViewCalendarView* self);
static void maya_view_calendar_view_sync_with_model (MayaViewCalendarView* self);
static MayaViewGrid* maya_view_calendar_view_get_days_grid (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_grid_focus_date (MayaViewGrid* self,
                                GDateTime* date);
static void maya_view_calendar_view_on_show_weeks_changed (MayaViewCalendarView* self);
static MayaViewWeekLabels* maya_view_calendar_view_get_weeks (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_week_labels_update (MayaViewWeekLabels* self,
                                   GDateTime* date,
                                   gint nr_of_weeks);
static void maya_view_calendar_view_update_spacer_visible (MayaViewCalendarView* self);
static GtkLabel* maya_view_calendar_view_get_spacer (MayaViewCalendarView* self);
static void maya_view_calendar_view_on_events_added (MayaViewCalendarView* self,
                                              ESource* source,
                                              GeeCollection* events);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static gboolean __lambda139_ (Block19Data* _data19_);
static void maya_view_calendar_view_add_event (MayaViewCalendarView* self,
                                        ESource* source,
                                        ECalComponent* event);
static gboolean ___lambda139__gsource_func (gpointer self);
static void maya_view_calendar_view_on_events_updated (MayaViewCalendarView* self,
                                                ESource* source,
                                                GeeCollection* events);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static gboolean __lambda140_ (Block20Data* _data20_);
static void maya_view_calendar_view_update_event (MayaViewCalendarView* self,
                                           ESource* source,
                                           ECalComponent* event);
static gboolean ___lambda140__gsource_func (gpointer self);
static void maya_view_calendar_view_on_events_removed (MayaViewCalendarView* self,
                                                ESource* source,
                                                GeeCollection* events);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gboolean __lambda141_ (Block21Data* _data21_);
static void maya_view_calendar_view_remove_event (MayaViewCalendarView* self,
                                           ESource* source,
                                           ECalComponent* event);
static gboolean ___lambda141__gsource_func (gpointer self);
static void maya_view_calendar_view_on_model_parameters_changed (MayaViewCalendarView* self);
VALA_EXTERN CalendarUtilDateRange* maya_view_grid_get_grid_range (MayaViewGrid* self);
static gboolean __lambda142_ (MayaViewCalendarView* self);
static void maya_view_calendar_view_remove_all_events (MayaViewCalendarView* self);
static gboolean ___lambda142__gsource_func (gpointer self);
static GtkGrid* maya_view_calendar_view_create_big_grid (MayaViewCalendarView* self);
static void maya_view_calendar_view_set_spacer (MayaViewCalendarView* self,
                                         GtkLabel* value);
VALA_EXTERN MayaViewWeekLabels* maya_view_week_labels_new (void);
VALA_EXTERN MayaViewWeekLabels* maya_view_week_labels_construct (GType object_type);
static void maya_view_calendar_view_set_weeks (MayaViewCalendarView* self,
                                        MayaViewWeekLabels* value);
VALA_EXTERN MayaViewHeader* maya_view_header_new (void);
VALA_EXTERN MayaViewHeader* maya_view_header_construct (GType object_type);
static void maya_view_calendar_view_set_header (MayaViewCalendarView* self,
                                         MayaViewHeader* value);
VALA_EXTERN MayaViewGrid* maya_view_grid_new (void);
VALA_EXTERN MayaViewGrid* maya_view_grid_construct (GType object_type);
static void maya_view_calendar_view_set_days_grid (MayaViewCalendarView* self,
                                            MayaViewGrid* value);
VALA_EXTERN GDateTime* maya_view_calendar_view_get_selected_date (MayaViewCalendarView* self);
static void __lambda137_ (MayaViewCalendarView* self,
                   GDateTime* date);
static void ___lambda137__maya_view_grid_on_event_add (MayaViewGrid* _sender,
                                                GDateTime* date,
                                                gpointer self);
static void __lambda138_ (MayaViewCalendarView* self,
                   GDateTime* date);
static void maya_view_calendar_view_set_selected_date (MayaViewCalendarView* self,
                                                GDateTime* value);
static void ___lambda138__maya_view_grid_selection_changed (MayaViewGrid* _sender,
                                                     GDateTime* new_date,
                                                     gpointer self);
static MayaViewHeader* maya_view_calendar_view_get_header (MayaViewCalendarView* self);
static GtkStack* maya_view_calendar_view_get_stack (MayaViewCalendarView* self);
VALA_EXTERN void maya_view_header_update_columns (MayaViewHeader* self,
                                      gint week_starts_on);
VALA_EXTERN void maya_view_grid_set_range (MayaViewGrid* self,
                               CalendarUtilDateRange* new_range,
                               GDateTime* month_start);
VALA_EXTERN void maya_view_grid_add_event (MayaViewGrid* self,
                               ECalComponent* event);
VALA_EXTERN void maya_view_grid_update_event (MayaViewGrid* self,
                                  ECalComponent* event);
VALA_EXTERN void maya_view_grid_remove_event (MayaViewGrid* self,
                                  ECalComponent* event);
VALA_EXTERN void maya_view_grid_remove_all_events (MayaViewGrid* self);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_new (void);
VALA_EXTERN MayaViewCalendarView* maya_view_calendar_view_construct (GType object_type);
static void maya_view_calendar_view_set_stack (MayaViewCalendarView* self,
                                        GtkStack* value);
static GObject * maya_view_calendar_view_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
VALA_EXTERN GDateTime* maya_application_get_selected_datetime (void);
static void _maya_view_calendar_view_on_model_parameters_changed_calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                                   gpointer self);
static void _maya_view_calendar_view_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                                 ESource* source,
                                                                                 GeeCollection* events,
                                                                                 gpointer self);
static void _maya_view_calendar_view_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                                     ESource* source,
                                                                                     GeeCollection* events,
                                                                                     gpointer self);
static void _maya_view_calendar_view_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                                     ESource* source,
                                                                                     GeeCollection* events,
                                                                                     gpointer self);
static void _maya_view_calendar_view___lambda143_ (MayaViewCalendarView* self);
static void ___lambda144_ (MayaViewCalendarView* self,
                    GtkWidget* child);
static void ____lambda144__gfunc (gconstpointer data,
                           gpointer self);
static void __maya_view_calendar_view___lambda143__g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void _maya_view_calendar_view_on_show_weeks_changed_g_settings_changed (GSettings* _sender,
                                                                        const gchar* key,
                                                                        gpointer self);
static void maya_view_calendar_view_finalize (GObject * obj);
static GType maya_view_calendar_view_get_type_once (void);
static void _vala_maya_view_calendar_view_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_maya_view_calendar_view_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
maya_view_calendar_view_get_instance_private (MayaViewCalendarView* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewCalendarView_private_offset);
}

static gboolean
maya_view_calendar_view_real_scroll_event (GtkWidget* base,
                                           GdkEventScroll* event)
{
	MayaViewCalendarView * self;
	gboolean result;
	self = (MayaViewCalendarView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = maya_gestures_utils_on_scroll_event (event);
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
maya_view_calendar_view_today (MayaViewCalendarView* self)
{
	GDateTime* today = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	CalendarEventStore* calmodel = NULL;
	CalendarEventStore* _tmp4_;
	GDateTime* start = NULL;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	CalendarEventStore* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	MayaViewGrid* _tmp14_;
	GDateTime* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = calendar_util_datetime_strip_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	today = _tmp3_;
	_tmp4_ = calendar_event_store_get_default ();
	calmodel = _tmp4_;
	_tmp5_ = today;
	_tmp6_ = _g_date_time_ref0 (_tmp5_);
	_tmp7_ = calendar_util_datetime_get_start_of_month (_tmp6_);
	start = _tmp7_;
	_tmp8_ = start;
	_tmp9_ = calmodel;
	_tmp10_ = calendar_event_store_get_month_start (_tmp9_);
	_tmp11_ = _tmp10_;
	if (!g_date_time_equal (_tmp8_, _tmp11_)) {
		CalendarEventStore* _tmp12_;
		GDateTime* _tmp13_;
		_tmp12_ = calmodel;
		_tmp13_ = start;
		calendar_event_store_set_month_start (_tmp12_, _tmp13_);
	}
	maya_view_calendar_view_sync_with_model (self);
	_tmp14_ = self->priv->_days_grid;
	_tmp15_ = today;
	maya_view_grid_focus_date (_tmp14_, _tmp15_);
	_g_date_time_unref0 (start);
	_g_object_unref0 (calmodel);
	_g_date_time_unref0 (today);
}

static void
maya_view_calendar_view_on_show_weeks_changed (MayaViewCalendarView* self)
{
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp0_;
	MayaViewWeekLabels* _tmp1_;
	CalendarUtilDateRange* _tmp2_;
	CalendarUtilDateRange* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	model = _tmp0_;
	_tmp1_ = self->priv->_weeks;
	_tmp2_ = calendar_event_store_get_data_range (model);
	_tmp3_ = _tmp2_;
	_tmp4_ = calendar_util_date_range_get_first_dt (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = calendar_event_store_get_num_weeks (model);
	_tmp7_ = _tmp6_;
	maya_view_week_labels_update (_tmp1_, _tmp5_, _tmp7_);
	maya_view_calendar_view_update_spacer_visible (self);
	_g_object_unref0 (model);
}

static void
maya_view_calendar_view_update_spacer_visible (MayaViewCalendarView* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = maya_view_calendar_view_show_weeks;
	if (g_settings_get_boolean (_tmp0_, "show-weeks")) {
		GtkLabel* _tmp1_;
		_tmp1_ = self->priv->_spacer;
		gtk_widget_show ((GtkWidget*) _tmp1_);
	} else {
		GtkLabel* _tmp2_;
		_tmp2_ = self->priv->_spacer;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
	g_atomic_int_inc (&_data19_->_ref_count_);
	return _data19_;
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data19_->self;
		_g_object_unref0 (_data19_->source);
		_g_object_unref0 (_data19_->events);
		_g_object_unref0 (self);
		g_slice_free (Block19Data, _data19_);
	}
}

static gboolean
__lambda139_ (Block19Data* _data19_)
{
	MayaViewCalendarView* self;
	gboolean result;
	self = _data19_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data19_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			maya_view_calendar_view_add_event (self, _data19_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda139__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda139_ (self);
	return result;
}

static void
maya_view_calendar_view_on_events_added (MayaViewCalendarView* self,
                                         ESource* source,
                                         GeeCollection* events)
{
	Block19Data* _data19_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data19_ = g_slice_new0 (Block19Data);
	_data19_->_ref_count_ = 1;
	_data19_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data19_->source);
	_data19_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data19_->events);
	_data19_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda139__gsource_func, block19_data_ref (_data19_), block19_data_unref);
	block19_data_unref (_data19_);
	_data19_ = NULL;
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
	g_atomic_int_inc (&_data20_->_ref_count_);
	return _data20_;
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data20_->self;
		_g_object_unref0 (_data20_->source);
		_g_object_unref0 (_data20_->events);
		_g_object_unref0 (self);
		g_slice_free (Block20Data, _data20_);
	}
}

static gboolean
__lambda140_ (Block20Data* _data20_)
{
	MayaViewCalendarView* self;
	gboolean result;
	self = _data20_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data20_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			maya_view_calendar_view_update_event (self, _data20_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda140__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda140_ (self);
	return result;
}

static void
maya_view_calendar_view_on_events_updated (MayaViewCalendarView* self,
                                           ESource* source,
                                           GeeCollection* events)
{
	Block20Data* _data20_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data20_ = g_slice_new0 (Block20Data);
	_data20_->_ref_count_ = 1;
	_data20_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data20_->source);
	_data20_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data20_->events);
	_data20_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda140__gsource_func, block20_data_ref (_data20_), block20_data_unref);
	block20_data_unref (_data20_);
	_data20_ = NULL;
}

static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
	g_atomic_int_inc (&_data21_->_ref_count_);
	return _data21_;
}

static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
		MayaViewCalendarView* self;
		self = _data21_->self;
		_g_object_unref0 (_data21_->source);
		_g_object_unref0 (_data21_->events);
		_g_object_unref0 (self);
		g_slice_free (Block21Data, _data21_);
	}
}

static gboolean
__lambda141_ (Block21Data* _data21_)
{
	MayaViewCalendarView* self;
	gboolean result;
	self = _data21_->self;
	{
		GeeIterator* _event_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) _data21_->events);
		_event_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			ECalComponent* _tmp4_;
			_tmp1_ = _event_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _event_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			event = (ECalComponent*) _tmp3_;
			_tmp4_ = event;
			maya_view_calendar_view_remove_event (self, _data21_->source, _tmp4_);
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda141__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda141_ (self);
	return result;
}

static void
maya_view_calendar_view_on_events_removed (MayaViewCalendarView* self,
                                           ESource* source,
                                           GeeCollection* events)
{
	Block21Data* _data21_;
	ESource* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (events != NULL);
	_data21_ = g_slice_new0 (Block21Data);
	_data21_->_ref_count_ = 1;
	_data21_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data21_->source);
	_data21_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (events);
	_g_object_unref0 (_data21_->events);
	_data21_->events = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda141__gsource_func, block21_data_ref (_data21_), block21_data_unref);
	block21_data_unref (_data21_);
	_data21_ = NULL;
}

static gboolean
__lambda142_ (MayaViewCalendarView* self)
{
	gboolean result;
	maya_view_calendar_view_remove_all_events (self);
	maya_view_calendar_view_sync_with_model (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda142__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda142_ ((MayaViewCalendarView*) self);
	return result;
}

static void
maya_view_calendar_view_on_model_parameters_changed (MayaViewCalendarView* self)
{
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MayaViewGrid* _tmp2_;
	CalendarUtilDateRange* _tmp3_;
	CalendarUtilDateRange* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	model = _tmp0_;
	_tmp2_ = self->priv->_days_grid;
	_tmp3_ = maya_view_grid_get_grid_range (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		CalendarEventStore* _tmp5_;
		CalendarUtilDateRange* _tmp6_;
		CalendarUtilDateRange* _tmp7_;
		MayaViewGrid* _tmp8_;
		CalendarUtilDateRange* _tmp9_;
		CalendarUtilDateRange* _tmp10_;
		_tmp5_ = model;
		_tmp6_ = calendar_event_store_get_data_range (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->_days_grid;
		_tmp9_ = maya_view_grid_get_grid_range (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp1_ = calendar_util_date_range_equals (_tmp7_, _tmp10_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_g_object_unref0 (model);
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda142__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (model);
}

static void
__lambda137_ (MayaViewCalendarView* self,
              GDateTime* date)
{
	g_return_if_fail (date != NULL);
	g_signal_emit (self, maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_ON_EVENT_ADD_SIGNAL], 0, date);
}

static void
___lambda137__maya_view_grid_on_event_add (MayaViewGrid* _sender,
                                           GDateTime* date,
                                           gpointer self)
{
	__lambda137_ ((MayaViewCalendarView*) self, date);
}

static void
__lambda138_ (MayaViewCalendarView* self,
              GDateTime* date)
{
	g_return_if_fail (date != NULL);
	maya_view_calendar_view_set_selected_date (self, date);
	g_signal_emit (self, maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL], 0, date);
}

static void
___lambda138__maya_view_grid_selection_changed (MayaViewGrid* _sender,
                                                GDateTime* new_date,
                                                gpointer self)
{
	__lambda138_ ((MayaViewCalendarView*) self, new_date);
}

static GtkGrid*
maya_view_calendar_view_create_big_grid (MayaViewCalendarView* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkStyleContext* spacer_context = NULL;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkCssProvider* _tmp5_;
	MayaViewWeekLabels* _tmp6_;
	MayaViewWeekLabels* _tmp7_;
	MayaViewHeader* _tmp8_;
	MayaViewHeader* _tmp9_;
	MayaViewGrid* _tmp10_;
	MayaViewGrid* _tmp11_;
	MayaViewGrid* _tmp12_;
	GDateTime* _tmp13_;
	MayaViewGrid* _tmp14_;
	MayaViewGrid* _tmp15_;
	GtkGrid* new_big_grid = NULL;
	GtkGrid* _tmp16_;
	GtkLabel* _tmp17_;
	MayaViewHeader* _tmp18_;
	MayaViewGrid* _tmp19_;
	MayaViewWeekLabels* _tmp20_;
	GtkGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	maya_view_calendar_view_set_spacer (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_spacer;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->_spacer;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	spacer_context = _tmp4_;
	_tmp5_ = maya_view_calendar_view_style_provider;
	gtk_style_context_add_provider (spacer_context, (GtkStyleProvider*) _tmp5_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	gtk_style_context_add_class (spacer_context, "weeks");
	_tmp6_ = maya_view_week_labels_new ();
	g_object_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	maya_view_calendar_view_set_weeks (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = maya_view_header_new ();
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	maya_view_calendar_view_set_header (self, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = maya_view_grid_new ();
	g_object_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	maya_view_calendar_view_set_days_grid (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = self->priv->_days_grid;
	_tmp13_ = self->priv->_selected_date;
	maya_view_grid_focus_date (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->_days_grid;
	g_signal_connect_object (_tmp14_, "on-event-add", (GCallback) ___lambda137__maya_view_grid_on_event_add, self, 0);
	_tmp15_ = self->priv->_days_grid;
	g_signal_connect_object (_tmp15_, "selection-changed", (GCallback) ___lambda138__maya_view_grid_selection_changed, self, 0);
	_tmp16_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp16_);
	new_big_grid = _tmp16_;
	_tmp17_ = self->priv->_spacer;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp17_, 0, 0, 1, 1);
	_tmp18_ = self->priv->_header;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp18_, 1, 0, 1, 1);
	_tmp19_ = self->priv->_days_grid;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp19_, 1, 1, 1, 1);
	_tmp20_ = self->priv->_weeks;
	gtk_grid_attach (new_big_grid, (GtkWidget*) _tmp20_, 0, 1, 1, 1);
	gtk_widget_show_all ((GtkWidget*) new_big_grid);
	g_object_set ((GtkWidget*) new_big_grid, "expand", TRUE, NULL);
	maya_view_calendar_view_update_spacer_visible (self);
	result = new_big_grid;
	return result;
}

static void
maya_view_calendar_view_sync_with_model (MayaViewCalendarView* self)
{
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp0_;
	GDateTime* previous_first = NULL;
	MayaViewGrid* _tmp1_;
	GtkGrid* big_grid = NULL;
	GtkGrid* _tmp32_;
	GtkStack* _tmp33_;
	GtkGrid* _tmp34_;
	MayaViewHeader* _tmp35_;
	CalendarEventStore* _tmp36_;
	GDateWeekday _tmp37_;
	GDateWeekday _tmp38_;
	MayaViewWeekLabels* _tmp39_;
	CalendarEventStore* _tmp40_;
	CalendarUtilDateRange* _tmp41_;
	CalendarUtilDateRange* _tmp42_;
	GDateTime* _tmp43_;
	GDateTime* _tmp44_;
	CalendarEventStore* _tmp45_;
	gint _tmp46_;
	gint _tmp47_;
	MayaViewGrid* _tmp48_;
	CalendarEventStore* _tmp49_;
	CalendarUtilDateRange* _tmp50_;
	CalendarUtilDateRange* _tmp51_;
	CalendarEventStore* _tmp52_;
	GDateTime* _tmp53_;
	GDateTime* _tmp54_;
	GDateTime* _tmp55_;
	GDateTime* _tmp63_;
	GtkStack* _tmp72_;
	GtkGrid* _tmp73_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_get_default ();
	model = _tmp0_;
	previous_first = NULL;
	_tmp1_ = self->priv->_days_grid;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		MayaViewGrid* _tmp3_;
		CalendarUtilDateRange* _tmp4_;
		CalendarUtilDateRange* _tmp5_;
		MayaViewGrid* _tmp23_;
		CalendarUtilDateRange* _tmp24_;
		CalendarUtilDateRange* _tmp25_;
		_tmp3_ = self->priv->_days_grid;
		_tmp4_ = maya_view_grid_get_grid_range (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			gboolean _tmp6_ = FALSE;
			CalendarEventStore* _tmp7_;
			CalendarUtilDateRange* _tmp8_;
			CalendarUtilDateRange* _tmp9_;
			MayaViewGrid* _tmp10_;
			CalendarUtilDateRange* _tmp11_;
			CalendarUtilDateRange* _tmp12_;
			_tmp7_ = model;
			_tmp8_ = calendar_event_store_get_data_range (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = self->priv->_days_grid;
			_tmp11_ = maya_view_grid_get_grid_range (_tmp10_);
			_tmp12_ = _tmp11_;
			if (calendar_util_date_range_equals (_tmp9_, _tmp12_)) {
				_tmp6_ = TRUE;
			} else {
				MayaViewGrid* _tmp13_;
				CalendarUtilDateRange* _tmp14_;
				CalendarUtilDateRange* _tmp15_;
				GDateTime* _tmp16_;
				GDateTime* _tmp17_;
				CalendarEventStore* _tmp18_;
				CalendarUtilDateRange* _tmp19_;
				CalendarUtilDateRange* _tmp20_;
				GDateTime* _tmp21_;
				GDateTime* _tmp22_;
				_tmp13_ = self->priv->_days_grid;
				_tmp14_ = maya_view_grid_get_grid_range (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = calendar_util_date_range_get_first_dt (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = model;
				_tmp19_ = calendar_event_store_get_data_range (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = calendar_util_date_range_get_first_dt (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp6_ = g_date_time_compare (_tmp17_, _tmp22_) == 0;
			}
			_tmp2_ = _tmp6_;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_g_date_time_unref0 (previous_first);
			_g_object_unref0 (model);
			return;
		}
		_tmp23_ = self->priv->_days_grid;
		_tmp24_ = maya_view_grid_get_grid_range (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ != NULL) {
			MayaViewGrid* _tmp26_;
			CalendarUtilDateRange* _tmp27_;
			CalendarUtilDateRange* _tmp28_;
			GDateTime* _tmp29_;
			GDateTime* _tmp30_;
			GDateTime* _tmp31_;
			_tmp26_ = self->priv->_days_grid;
			_tmp27_ = maya_view_grid_get_grid_range (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = calendar_util_date_range_get_first_dt (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _g_date_time_ref0 (_tmp30_);
			_g_date_time_unref0 (previous_first);
			previous_first = _tmp31_;
		}
	}
	_tmp32_ = maya_view_calendar_view_create_big_grid (self);
	big_grid = _tmp32_;
	_tmp33_ = self->priv->_stack;
	_tmp34_ = big_grid;
	gtk_container_add ((GtkContainer*) _tmp33_, (GtkWidget*) _tmp34_);
	_tmp35_ = self->priv->_header;
	_tmp36_ = model;
	_tmp37_ = calendar_event_store_get_week_starts_on (_tmp36_);
	_tmp38_ = _tmp37_;
	maya_view_header_update_columns (_tmp35_, (gint) _tmp38_);
	_tmp39_ = self->priv->_weeks;
	_tmp40_ = model;
	_tmp41_ = calendar_event_store_get_data_range (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = calendar_util_date_range_get_first_dt (_tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = model;
	_tmp46_ = calendar_event_store_get_num_weeks (_tmp45_);
	_tmp47_ = _tmp46_;
	maya_view_week_labels_update (_tmp39_, _tmp44_, _tmp47_);
	_tmp48_ = self->priv->_days_grid;
	_tmp49_ = model;
	_tmp50_ = calendar_event_store_get_data_range (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = model;
	_tmp53_ = calendar_event_store_get_month_start (_tmp52_);
	_tmp54_ = _tmp53_;
	maya_view_grid_set_range (_tmp48_, _tmp51_, _tmp54_);
	_tmp55_ = self->priv->_selected_date;
	if (_tmp55_ != NULL) {
		GDateTime* bumpdate = NULL;
		CalendarEventStore* _tmp56_;
		GDateTime* _tmp57_;
		GDateTime* _tmp58_;
		GDateTime* _tmp59_;
		GDateTime* _tmp60_;
		MayaViewGrid* _tmp61_;
		GDateTime* _tmp62_;
		_tmp56_ = model;
		_tmp57_ = calendar_event_store_get_month_start (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_selected_date;
		_tmp60_ = g_date_time_add_days (_tmp58_, g_date_time_get_day_of_month (_tmp59_) - 1);
		bumpdate = _tmp60_;
		_tmp61_ = self->priv->_days_grid;
		_tmp62_ = bumpdate;
		maya_view_grid_focus_date (_tmp61_, _tmp62_);
		_g_date_time_unref0 (bumpdate);
	}
	_tmp63_ = previous_first;
	if (_tmp63_ != NULL) {
		GDateTime* _tmp64_;
		MayaViewGrid* _tmp65_;
		CalendarUtilDateRange* _tmp66_;
		CalendarUtilDateRange* _tmp67_;
		GDateTime* _tmp68_;
		GDateTime* _tmp69_;
		_tmp64_ = previous_first;
		_tmp65_ = self->priv->_days_grid;
		_tmp66_ = maya_view_grid_get_grid_range (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = calendar_util_date_range_get_first_dt (_tmp67_);
		_tmp69_ = _tmp68_;
		if (g_date_time_compare (_tmp64_, _tmp69_) == -1) {
			GtkStack* _tmp70_;
			_tmp70_ = self->priv->_stack;
			gtk_stack_set_transition_type (_tmp70_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
		} else {
			GtkStack* _tmp71_;
			_tmp71_ = self->priv->_stack;
			gtk_stack_set_transition_type (_tmp71_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
		}
	}
	_tmp72_ = self->priv->_stack;
	_tmp73_ = big_grid;
	gtk_stack_set_visible_child (_tmp72_, (GtkWidget*) _tmp73_);
	_g_object_unref0 (big_grid);
	_g_date_time_unref0 (previous_first);
	_g_object_unref0 (model);
}

static void
maya_view_calendar_view_add_event (MayaViewCalendarView* self,
                                   ESource* source,
                                   ECalComponent* event)
{
	gconstpointer _tmp0_;
	MayaViewGrid* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = g_object_get_data ((GObject*) event, "source");
	_vala_assert (((ESource*) _tmp0_) != NULL, "event.get_data<E.Source> (\"source\") != null");
	_tmp1_ = self->priv->_days_grid;
	maya_view_grid_add_event (_tmp1_, event);
}

static void
maya_view_calendar_view_update_event (MayaViewCalendarView* self,
                                      ESource* source,
                                      ECalComponent* event)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->_days_grid;
	maya_view_grid_update_event (_tmp0_, event);
}

static void
maya_view_calendar_view_remove_event (MayaViewCalendarView* self,
                                      ESource* source,
                                      ECalComponent* event)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->_days_grid;
	maya_view_grid_remove_event (_tmp0_, event);
}

static void
maya_view_calendar_view_remove_all_events (MayaViewCalendarView* self)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_days_grid;
	maya_view_grid_remove_all_events (_tmp0_);
}

MayaViewCalendarView*
maya_view_calendar_view_construct (GType object_type)
{
	MayaViewCalendarView * self = NULL;
	self = (MayaViewCalendarView*) g_object_new (object_type, NULL);
	return self;
}

MayaViewCalendarView*
maya_view_calendar_view_new (void)
{
	return maya_view_calendar_view_construct (MAYA_VIEW_TYPE_CALENDAR_VIEW);
}

GDateTime*
maya_view_calendar_view_get_selected_date (MayaViewCalendarView* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_date;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_selected_date (MayaViewCalendarView* self,
                                           GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = maya_view_calendar_view_get_selected_date (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_selected_date);
		self->priv->_selected_date = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY]);
	}
}

static MayaViewWeekLabels*
maya_view_calendar_view_get_weeks (MayaViewCalendarView* self)
{
	MayaViewWeekLabels* result;
	MayaViewWeekLabels* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_weeks;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_weeks (MayaViewCalendarView* self,
                                   MayaViewWeekLabels* value)
{
	MayaViewWeekLabels* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_weeks);
	self->priv->_weeks = _tmp0_;
}

static MayaViewHeader*
maya_view_calendar_view_get_header (MayaViewCalendarView* self)
{
	MayaViewHeader* result;
	MayaViewHeader* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_header;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_header (MayaViewCalendarView* self,
                                    MayaViewHeader* value)
{
	MayaViewHeader* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_header);
	self->priv->_header = _tmp0_;
}

static MayaViewGrid*
maya_view_calendar_view_get_days_grid (MayaViewCalendarView* self)
{
	MayaViewGrid* result;
	MayaViewGrid* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_days_grid;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_days_grid (MayaViewCalendarView* self,
                                       MayaViewGrid* value)
{
	MayaViewGrid* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_days_grid);
	self->priv->_days_grid = _tmp0_;
}

static GtkStack*
maya_view_calendar_view_get_stack (MayaViewCalendarView* self)
{
	GtkStack* result;
	GtkStack* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_stack;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_stack (MayaViewCalendarView* self,
                                   GtkStack* value)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_stack);
	self->priv->_stack = _tmp0_;
}

static GtkLabel*
maya_view_calendar_view_get_spacer (MayaViewCalendarView* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_spacer;
	result = _tmp0_;
	return result;
}

static void
maya_view_calendar_view_set_spacer (MayaViewCalendarView* self,
                                    GtkLabel* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_spacer);
	self->priv->_spacer = _tmp0_;
}

static void
_maya_view_calendar_view_on_model_parameters_changed_calendar_event_store_parameters_changed (CalendarEventStore* _sender,
                                                                                              gpointer self)
{
	maya_view_calendar_view_on_model_parameters_changed ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view_on_events_added_calendar_event_store_events_added (CalendarEventStore* _sender,
                                                                            ESource* source,
                                                                            GeeCollection* events,
                                                                            gpointer self)
{
	maya_view_calendar_view_on_events_added ((MayaViewCalendarView*) self, source, events);
}

static void
_maya_view_calendar_view_on_events_updated_calendar_event_store_events_updated (CalendarEventStore* _sender,
                                                                                ESource* source,
                                                                                GeeCollection* events,
                                                                                gpointer self)
{
	maya_view_calendar_view_on_events_updated ((MayaViewCalendarView*) self, source, events);
}

static void
_maya_view_calendar_view_on_events_removed_calendar_event_store_events_removed (CalendarEventStore* _sender,
                                                                                ESource* source,
                                                                                GeeCollection* events,
                                                                                gpointer self)
{
	maya_view_calendar_view_on_events_removed ((MayaViewCalendarView*) self, source, events);
}

static void
___lambda144_ (MayaViewCalendarView* self,
               GtkWidget* child)
{
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (child != NULL);
	_tmp0_ = self->priv->_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (child != _tmp2_) {
		gtk_widget_destroy (child);
	}
}

static void
____lambda144__gfunc (gconstpointer data,
                      gpointer self)
{
	___lambda144_ ((MayaViewCalendarView*) self, (GtkWidget*) data);
}

static void
_maya_view_calendar_view___lambda143_ (MayaViewCalendarView* self)
{
	GtkStack* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->_stack;
	_tmp1_ = gtk_stack_get_transition_running (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == FALSE) {
		GtkStack* _tmp3_;
		GList* _tmp4_;
		GList* _tmp5_;
		_tmp3_ = self->priv->_stack;
		_tmp4_ = gtk_container_get_children ((GtkContainer*) _tmp3_);
		_tmp5_ = _tmp4_;
		g_list_foreach (_tmp5_, ____lambda144__gfunc, self);
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (g_list_free (_tmp5_), NULL));
	}
}

static void
__maya_view_calendar_view___lambda143__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	_maya_view_calendar_view___lambda143_ ((MayaViewCalendarView*) self);
}

static void
_maya_view_calendar_view_on_show_weeks_changed_g_settings_changed (GSettings* _sender,
                                                                   const gchar* key,
                                                                   gpointer self)
{
	maya_view_calendar_view_on_show_weeks_changed ((MayaViewCalendarView*) self);
}

static GObject *
maya_view_calendar_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MayaViewCalendarView * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	GtkStack* _tmp4_;
	GtkStack* _tmp5_;
	CalendarEventStore* model = NULL;
	CalendarEventStore* _tmp6_;
	CalendarEventStore* _tmp7_;
	CalendarEventStore* _tmp8_;
	CalendarEventStore* _tmp9_;
	CalendarEventStore* _tmp10_;
	GtkStack* _tmp11_;
	GSettings* _tmp12_;
	GSettings* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GdkEventMask _tmp16_;
	GdkEventMask _tmp17_;
	GdkEventMask _tmp18_;
	GdkEventMask _tmp19_;
	GdkEventMask _tmp20_;
	GdkEventMask _tmp21_;
	GdkEventMask _tmp22_;
	GdkEventMask _tmp23_;
	GtkStack* _tmp24_;
	parent_class = G_OBJECT_CLASS (maya_view_calendar_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	_tmp0_ = maya_application_get_selected_datetime ();
	_tmp1_ = _tmp0_;
	maya_view_calendar_view_set_selected_date (self, _tmp1_);
	_g_date_time_unref0 (_tmp1_);
	_tmp2_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	maya_view_calendar_view_set_stack (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_stack;
	g_object_set ((GtkWidget*) _tmp4_, "expand", TRUE, NULL);
	maya_view_calendar_view_sync_with_model (self);
	_tmp5_ = self->priv->_stack;
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
	_tmp6_ = calendar_event_store_get_default ();
	model = _tmp6_;
	_tmp7_ = model;
	g_signal_connect_object (_tmp7_, "parameters-changed", (GCallback) _maya_view_calendar_view_on_model_parameters_changed_calendar_event_store_parameters_changed, self, 0);
	_tmp8_ = model;
	g_signal_connect_object (_tmp8_, "events-added", (GCallback) _maya_view_calendar_view_on_events_added_calendar_event_store_events_added, self, 0);
	_tmp9_ = model;
	g_signal_connect_object (_tmp9_, "events-updated", (GCallback) _maya_view_calendar_view_on_events_updated_calendar_event_store_events_updated, self, 0);
	_tmp10_ = model;
	g_signal_connect_object (_tmp10_, "events-removed", (GCallback) _maya_view_calendar_view_on_events_removed_calendar_event_store_events_removed, self, 0);
	_tmp11_ = self->priv->_stack;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::transition-running", (GCallback) __maya_view_calendar_view___lambda143__g_object_notify, self, 0);
	_tmp12_ = maya_view_calendar_view_show_weeks;
	g_signal_connect_object (_tmp12_, "changed::show-weeks", (GCallback) _maya_view_calendar_view_on_show_weeks_changed_g_settings_changed, self, 0);
	_tmp13_ = maya_view_calendar_view_show_weeks;
	_tmp14_ = g_settings_get_value (_tmp13_, "show-weeks");
	_tmp15_ = _tmp14_;
	_g_variant_unref0 (_tmp15_);
	_tmp16_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp17_ = _tmp16_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp17_ | GDK_BUTTON_PRESS_MASK);
	_tmp18_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp19_ = _tmp18_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp19_ | GDK_KEY_PRESS_MASK);
	_tmp20_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp21_ = _tmp20_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp21_ | GDK_SCROLL_MASK);
	_tmp22_ = gtk_widget_get_events ((GtkWidget*) self);
	_tmp23_ = _tmp22_;
	gtk_widget_set_events ((GtkWidget*) self, _tmp23_ | GDK_SMOOTH_SCROLL_MASK);
	_tmp24_ = self->priv->_stack;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp24_);
	_g_object_unref0 (model);
	return obj;
}

static void
maya_view_calendar_view_class_init (MayaViewCalendarViewClass * klass,
                                    gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GSettings* _tmp2_;
	maya_view_calendar_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewCalendarView_private_offset);
	((GtkWidgetClass *) klass)->scroll_event = (gboolean (*) (GtkWidget*, GdkEventScroll*)) maya_view_calendar_view_real_scroll_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_maya_view_calendar_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_maya_view_calendar_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = maya_view_calendar_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = maya_view_calendar_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY, maya_view_calendar_view_properties[MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY] = g_param_spec_boxed ("selected-date", "selected-date", "selected-date", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_ON_EVENT_ADD_SIGNAL] = g_signal_new ("on-event-add", MAYA_VIEW_TYPE_CALENDAR_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	maya_view_calendar_view_signals[MAYA_VIEW_CALENDAR_VIEW_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", MAYA_VIEW_TYPE_CALENDAR_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_DATE_TIME);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (maya_view_calendar_view_style_provider);
	maya_view_calendar_view_style_provider = _tmp0_;
	_tmp1_ = maya_view_calendar_view_style_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/calendar/WeekLabels.css");
	_tmp2_ = maya_application_wingpanel_settings;
	if (_tmp2_ != NULL) {
		GSettings* _tmp3_;
		GSettings* _tmp4_;
		_tmp3_ = maya_application_wingpanel_settings;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (maya_view_calendar_view_show_weeks);
		maya_view_calendar_view_show_weeks = _tmp4_;
	} else {
		GSettings* _tmp5_;
		GSettings* _tmp6_;
		_tmp5_ = maya_application_saved_state;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (maya_view_calendar_view_show_weeks);
		maya_view_calendar_view_show_weeks = _tmp6_;
	}
}

static void
maya_view_calendar_view_instance_init (MayaViewCalendarView * self,
                                       gpointer klass)
{
	self->priv = maya_view_calendar_view_get_instance_private (self);
}

static void
maya_view_calendar_view_finalize (GObject * obj)
{
	MayaViewCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	_g_date_time_unref0 (self->priv->_selected_date);
	_g_object_unref0 (self->priv->_weeks);
	_g_object_unref0 (self->priv->_header);
	_g_object_unref0 (self->priv->_days_grid);
	_g_object_unref0 (self->priv->_stack);
	_g_object_unref0 (self->priv->_spacer);
	G_OBJECT_CLASS (maya_view_calendar_view_parent_class)->finalize (obj);
}

/**
 * Represents the entire calendar, including the headers, the week labels and the grid.
 */
static GType
maya_view_calendar_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewCalendarViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_calendar_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewCalendarView), 0, (GInstanceInitFunc) maya_view_calendar_view_instance_init, NULL };
	GType maya_view_calendar_view_type_id;
	maya_view_calendar_view_type_id = g_type_register_static (gtk_grid_get_type (), "MayaViewCalendarView", &g_define_type_info, 0);
	MayaViewCalendarView_private_offset = g_type_add_instance_private (maya_view_calendar_view_type_id, sizeof (MayaViewCalendarViewPrivate));
	return maya_view_calendar_view_type_id;
}

GType
maya_view_calendar_view_get_type (void)
{
	static volatile gsize maya_view_calendar_view_type_id__once = 0;
	if (g_once_init_enter (&maya_view_calendar_view_type_id__once)) {
		GType maya_view_calendar_view_type_id;
		maya_view_calendar_view_type_id = maya_view_calendar_view_get_type_once ();
		g_once_init_leave (&maya_view_calendar_view_type_id__once, maya_view_calendar_view_type_id);
	}
	return maya_view_calendar_view_type_id__once;
}

static void
_vala_maya_view_calendar_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	switch (property_id) {
		case MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY:
		g_value_set_boxed (value, maya_view_calendar_view_get_selected_date (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_maya_view_calendar_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	MayaViewCalendarView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MAYA_VIEW_TYPE_CALENDAR_VIEW, MayaViewCalendarView);
	switch (property_id) {
		case MAYA_VIEW_CALENDAR_VIEW_SELECTED_DATE_PROPERTY:
		maya_view_calendar_view_set_selected_date (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

