/* ParserEn.c generated by valac 0.56.16, the Vala compiler
 * generated from ParserEn.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011-2015 elementary LLC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Mario Guerriero <marioguerriero33@gmail.com>
 *              pantor
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define MAYA_SERVICES_EVENT_PARSER_HANDLER_FALLBACK_LANG "en"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_SERVICES_TYPE_EVENT_PARSER (maya_services_event_parser_get_type ())
#define MAYA_SERVICES_EVENT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER, MayaServicesEventParser))
#define MAYA_SERVICES_IS_EVENT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER))
#define MAYA_SERVICES_EVENT_PARSER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), MAYA_SERVICES_TYPE_EVENT_PARSER, MayaServicesEventParserIface))

typedef struct _MayaServicesEventParser MayaServicesEventParser;
typedef struct _MayaServicesEventParserIface MayaServicesEventParserIface;

#define MAYA_SERVICES_TYPE_PARSED_EVENT (maya_services_parsed_event_get_type ())
#define MAYA_SERVICES_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEvent))
#define MAYA_SERVICES_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))
#define MAYA_SERVICES_IS_PARSED_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_IS_PARSED_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_SERVICES_TYPE_PARSED_EVENT))
#define MAYA_SERVICES_PARSED_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_SERVICES_TYPE_PARSED_EVENT, MayaServicesParsedEventClass))

typedef struct _MayaServicesParsedEvent MayaServicesParsedEvent;
typedef struct _MayaServicesParsedEventClass MayaServicesParsedEventClass;

#define MAYA_SERVICES_TYPE_PARSER_EN (maya_services_parser_en_get_type ())
#define MAYA_SERVICES_PARSER_EN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_SERVICES_TYPE_PARSER_EN, MayaServicesParserEn))
#define MAYA_SERVICES_PARSER_EN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_SERVICES_TYPE_PARSER_EN, MayaServicesParserEnClass))
#define MAYA_SERVICES_IS_PARSER_EN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_SERVICES_TYPE_PARSER_EN))
#define MAYA_SERVICES_IS_PARSER_EN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_SERVICES_TYPE_PARSER_EN))
#define MAYA_SERVICES_PARSER_EN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_SERVICES_TYPE_PARSER_EN, MayaServicesParserEnClass))

typedef struct _MayaServicesParserEn MayaServicesParserEn;
typedef struct _MayaServicesParserEnClass MayaServicesParserEnClass;
typedef struct _MayaServicesParserEnPrivate MayaServicesParserEnPrivate;
enum  {
	MAYA_SERVICES_PARSER_EN_0_PROPERTY,
	MAYA_SERVICES_PARSER_EN_NUM_PROPERTIES
};
static GParamSpec* maya_services_parser_en_properties[MAYA_SERVICES_PARSER_EN_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define MAYA_SERVICES_PARSER_EN_TYPE_STRING_EVENT (maya_services_parser_en_string_event_get_type ())
typedef struct _MayaServicesParserEnStringEvent MayaServicesParserEnStringEvent;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef void (*MayaServicesParserEntranscribe_analysis) (MayaServicesParserEnStringEvent* data, gpointer user_data);
typedef struct _Block18Data Block18Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MayaServicesParsedEventPrivate MayaServicesParsedEventPrivate;

struct _MayaServicesEventParserIface {
	GTypeInterface parent_iface;
	MayaServicesParsedEvent* (*parse_source) (MayaServicesEventParser* self, const gchar* source);
	gchar* (*get_language) (MayaServicesEventParser* self);
};

struct _MayaServicesParserEn {
	GObject parent_instance;
	MayaServicesParserEnPrivate * priv;
	GDateTime* simulated_dt;
	gchar* source;
};

struct _MayaServicesParserEnClass {
	GObjectClass parent_class;
};

struct _MayaServicesParserEnPrivate {
	gchar* remaining_source;
	gchar** months;
	gint months_length1;
	gint months_length2;
	gchar** weekdays;
	gint weekdays_length1;
	gint weekdays_length2;
	gchar** number_words;
	gint number_words_length1;
	gint number_words_length2;
	gchar* months_regex;
	gchar* weekdays_regex;
	gchar* number_words_regex;
};

struct _MayaServicesParserEnStringEvent {
	gboolean matched;
	gchar* matched_string;
	gint pos;
	gint length;
	GArray* p;
};

struct _Block18Data {
	int _ref_count_;
	MayaServicesParserEn* self;
	MayaServicesParsedEvent* event;
};

struct _MayaServicesParsedEvent {
	GObject parent_instance;
	MayaServicesParsedEventPrivate * priv;
	gchar* title;
	gchar* location;
	gchar* participants;
	GDateTime* from;
	GDateTime* to;
	gboolean* all_day;
	gboolean date_parsed;
	gboolean time_parsed;
};

struct _MayaServicesParsedEventClass {
	GObjectClass parent_class;
};

static gint MayaServicesParserEn_private_offset;
static gpointer maya_services_parser_en_parent_class = NULL;
static MayaServicesEventParserIface * maya_services_parser_en_maya_services_event_parser_parent_iface = NULL;

VALA_EXTERN GType maya_services_parsed_event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesParsedEvent, g_object_unref)
VALA_EXTERN GType maya_services_event_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesEventParser, g_object_unref)
VALA_EXTERN GType maya_services_parser_en_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaServicesParserEn, g_object_unref)
VALA_EXTERN MayaServicesParserEn* maya_services_parser_en_new (GDateTime* _simulated_dt);
VALA_EXTERN MayaServicesParserEn* maya_services_parser_en_construct (GType object_type,
                                                         GDateTime* _simulated_dt);
static gint maya_services_parser_en_get_number_of_month (MayaServicesParserEn* self,
                                                  const gchar* entry);
static gint maya_services_parser_en_get_number_of_weekday (MayaServicesParserEn* self,
                                                    const gchar* entry);
static GType maya_services_parser_en_string_event_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static MayaServicesParserEnStringEvent* maya_services_parser_en_string_event_dup (const MayaServicesParserEnStringEvent* self);
static void maya_services_parser_en_string_event_free (MayaServicesParserEnStringEvent* self);
static void maya_services_parser_en_string_event_copy (const MayaServicesParserEnStringEvent* self,
                                                MayaServicesParserEnStringEvent* dest);
static void maya_services_parser_en_string_event_destroy (MayaServicesParserEnStringEvent* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (MayaServicesParserEnStringEvent, maya_services_parser_en_string_event_destroy)
static void maya_services_parser_en_complete_string (MayaServicesParserEn* self,
                                              const gchar* pattern,
                                              MayaServicesParserEnStringEvent* result);
static void _g_free0_ (gpointer var);
static void _vala_gchar_free_function_content_of (gpointer data);
static void maya_services_parser_en_analyze_pattern (MayaServicesParserEn* self,
                                              const gchar* pattern,
                                              MayaServicesParserEntranscribe_analysis del,
                                              gpointer del_target,
                                              gboolean delete);
static MayaServicesParsedEvent* maya_services_parser_en_real_parse_source (MayaServicesEventParser* base,
                                                                    const gchar* _source);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
VALA_EXTERN MayaServicesParsedEvent* maya_services_parsed_event_new (const gchar* _title,
                                                         GDateTime* _from,
                                                         GDateTime* _to,
                                                         const gchar* _location,
                                                         gboolean* _all_day,
                                                         const gchar* _participants,
                                                         gboolean _date_parsed,
                                                         gboolean _time_parsed);
VALA_EXTERN MayaServicesParsedEvent* maya_services_parsed_event_construct (GType object_type,
                                                               const gchar* _title,
                                                               GDateTime* _from,
                                                               GDateTime* _to,
                                                               const gchar* _location,
                                                               gboolean* _all_day,
                                                               const gchar* _participants,
                                                               gboolean _date_parsed,
                                                               gboolean _time_parsed);
VALA_EXTERN void maya_services_parsed_event_from_set_minute (MayaServicesParsedEvent* self,
                                                 gint minute);
VALA_EXTERN void maya_services_parsed_event_from_set_second (MayaServicesParsedEvent* self,
                                                 gint second);
VALA_EXTERN void maya_services_parsed_event_set_length_to_hours (MayaServicesParsedEvent* self,
                                                     gint hours);
static void __lambda54_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_one_entire_day (MayaServicesParsedEvent* self);
static void ___lambda54__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda55_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda55__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda56_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda56__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda57_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda57__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda58_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_all_day (MayaServicesParsedEvent* self);
static void ___lambda58__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda59_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda59__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda60_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda60__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda61_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda61__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda62_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda62__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda63_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda63__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda64_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda64__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda65_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda65__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda66_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda66__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda67_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda67__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda68_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_from_set_day (MayaServicesParsedEvent* self,
                                              gint day);
VALA_EXTERN void maya_services_parsed_event_from_set_month (MayaServicesParsedEvent* self,
                                                gint month);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_year (MayaServicesParsedEvent* self,
                                                               GDateTime* simulated_dt);
VALA_EXTERN void maya_services_parsed_event_from_set_year (MayaServicesParsedEvent* self,
                                               gint year);
static void ___lambda68__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda69_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda69__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda70_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda70__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda71_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_to_set_day (MayaServicesParsedEvent* self,
                                            gint day);
VALA_EXTERN void maya_services_parsed_event_to_set_month (MayaServicesParsedEvent* self,
                                              gint month);
VALA_EXTERN void maya_services_parsed_event_if_elapsed_delay_to_next_month (MayaServicesParsedEvent* self,
                                                                GDateTime* simulated_dt);
static void ___lambda71__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda72_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda72__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda73_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda73__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda74_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda74__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda75_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda75__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda76_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_from_set_hour (MayaServicesParsedEvent* self,
                                               gint hour,
                                               const gchar* half);
static gboolean* _bool_dup (gboolean* self);
static void ___lambda76__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda77_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda77__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda78_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda78__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda79_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda79__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda80_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda80__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda81_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda81__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda82_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda82__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda83_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda83__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda84_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda84__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda85_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda85__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda86_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda86__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda87_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_to_set_hour (MayaServicesParsedEvent* self,
                                             gint hour,
                                             const gchar* half);
VALA_EXTERN void maya_services_parsed_event_to_set_minute (MayaServicesParsedEvent* self,
                                               gint minute);
static void ___lambda87__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda88_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda88__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda89_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_length_to_minutes (MayaServicesParsedEvent* self,
                                                       gint minutes);
static void ___lambda89__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda90_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda90__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda91_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_length_to_days (MayaServicesParsedEvent* self,
                                                    gint days);
static void ___lambda91__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda92_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
VALA_EXTERN void maya_services_parsed_event_set_length_to_weeks (MayaServicesParsedEvent* self,
                                                     gint weeks);
static void ___lambda92__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda93_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda93__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static void __lambda94_ (Block18Data* _data18_,
                  MayaServicesParserEnStringEvent* data);
static void ___lambda94__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                           gpointer self);
static gchar* maya_services_parser_en_real_get_language (MayaServicesEventParser* base);
VALA_EXTERN MayaServicesParsedEvent* maya_services_event_parser_parse_source (MayaServicesEventParser* self,
                                                                  const gchar* source);
VALA_EXTERN gchar* maya_services_event_parser_get_language (MayaServicesEventParser* self);
static void maya_services_parser_en_finalize (GObject * obj);
static GType maya_services_parser_en_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
maya_services_parser_en_get_instance_private (MayaServicesParserEn* self)
{
	return G_STRUCT_MEMBER_P (self, MayaServicesParserEn_private_offset);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

MayaServicesParserEn*
maya_services_parser_en_construct (GType object_type,
                                   GDateTime* _simulated_dt)
{
	MayaServicesParserEn * self = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	g_return_val_if_fail (_simulated_dt != NULL, NULL);
	self = (MayaServicesParserEn*) g_object_new (object_type, NULL);
	_tmp0_ = _g_date_time_ref0 (_simulated_dt);
	_g_date_time_unref0 (self->simulated_dt);
	self->simulated_dt = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->source);
	self->source = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->remaining_source);
	self->priv->remaining_source = _tmp2_;
	_tmp3_ = g_strdup ("(");
	_g_free0 (self->priv->months_regex);
	self->priv->months_regex = _tmp3_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				const gchar* _tmp6_;
				gchar** _tmp7_;
				gint _tmp7__length1;
				gint _tmp7__length2;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp6_ = self->priv->months_regex;
				_tmp7_ = self->priv->months;
				_tmp7__length1 = self->priv->months_length1;
				_tmp7__length2 = self->priv->months_length2;
				_tmp8_ = _tmp7_[(i * _tmp7__length2) + 0];
				_tmp9_ = g_strconcat (_tmp8_, "|", NULL);
				_tmp10_ = _tmp9_;
				_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
				_g_free0 (self->priv->months_regex);
				self->priv->months_regex = _tmp11_;
				_g_free0 (_tmp10_);
			}
		}
	}
	_tmp12_ = self->priv->months_regex;
	_tmp13_ = string_slice (_tmp12_, (glong) 0, (glong) -1);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp14_, ")", NULL);
	_g_free0 (self->priv->months_regex);
	self->priv->months_regex = _tmp15_;
	_g_free0 (_tmp14_);
	_tmp16_ = g_strdup ("(");
	_g_free0 (self->priv->weekdays_regex);
	self->priv->weekdays_regex = _tmp16_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				gint _tmp20__length2;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				_tmp19_ = self->priv->weekdays_regex;
				_tmp20_ = self->priv->weekdays;
				_tmp20__length1 = self->priv->weekdays_length1;
				_tmp20__length2 = self->priv->weekdays_length2;
				_tmp21_ = _tmp20_[(i * _tmp20__length2) + 0];
				_tmp22_ = g_strconcat (_tmp21_, "|", NULL);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
				_g_free0 (self->priv->weekdays_regex);
				self->priv->weekdays_regex = _tmp24_;
				_g_free0 (_tmp23_);
			}
		}
	}
	_tmp25_ = self->priv->weekdays_regex;
	_tmp26_ = string_slice (_tmp25_, (glong) 0, (glong) -1);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, ")", NULL);
	_g_free0 (self->priv->weekdays_regex);
	self->priv->weekdays_regex = _tmp28_;
	_g_free0 (_tmp27_);
	_tmp29_ = g_strdup ("(");
	_g_free0 (self->priv->number_words_regex);
	self->priv->number_words_regex = _tmp29_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				const gchar* _tmp32_;
				gchar** _tmp33_;
				gint _tmp33__length1;
				gint _tmp33__length2;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				_tmp32_ = self->priv->number_words_regex;
				_tmp33_ = self->priv->number_words;
				_tmp33__length1 = self->priv->number_words_length1;
				_tmp33__length2 = self->priv->number_words_length2;
				_tmp34_ = _tmp33_[(i * _tmp33__length2) + 0];
				_tmp35_ = g_strconcat (_tmp34_, "|", NULL);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat (_tmp32_, _tmp36_, NULL);
				_g_free0 (self->priv->number_words_regex);
				self->priv->number_words_regex = _tmp37_;
				_g_free0 (_tmp36_);
			}
		}
	}
	_tmp38_ = self->priv->number_words_regex;
	_tmp39_ = string_slice (_tmp38_, (glong) 0, (glong) -1);
	_tmp40_ = _tmp39_;
	_tmp41_ = g_strconcat (_tmp40_, ")", NULL);
	_g_free0 (self->priv->number_words_regex);
	self->priv->number_words_regex = _tmp41_;
	_g_free0 (_tmp40_);
	return self;
}

MayaServicesParserEn*
maya_services_parser_en_new (GDateTime* _simulated_dt)
{
	return maya_services_parser_en_construct (MAYA_SERVICES_TYPE_PARSER_EN, _simulated_dt);
}

static gint
maya_services_parser_en_get_number_of_month (MayaServicesParserEn* self,
                                             const gchar* entry)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (entry != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				const gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp2_ = g_utf8_strdown (entry, (gssize) -1);
				_tmp3_ = _tmp2_;
				_tmp4_ = self->priv->months;
				_tmp4__length1 = self->priv->months_length1;
				_tmp4__length2 = self->priv->months_length2;
				_tmp5_ = _tmp4_[(i * _tmp4__length2) + 0];
				_tmp6_ = g_strcmp0 (_tmp3_, _tmp5_) == 0;
				_g_free0 (_tmp3_);
				if (_tmp6_) {
					gchar** _tmp7_;
					gint _tmp7__length1;
					gint _tmp7__length2;
					const gchar* _tmp8_;
					_tmp7_ = self->priv->months;
					_tmp7__length1 = self->priv->months_length1;
					_tmp7__length2 = self->priv->months_length2;
					_tmp8_ = _tmp7_[(i * _tmp7__length2) + 1];
					result = atoi (_tmp8_);
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

static gint
maya_services_parser_en_get_number_of_weekday (MayaServicesParserEn* self,
                                               const gchar* entry)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (entry != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				const gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < 12)) {
					break;
				}
				_tmp2_ = g_utf8_strdown (entry, (gssize) -1);
				_tmp3_ = _tmp2_;
				_tmp4_ = self->priv->weekdays;
				_tmp4__length1 = self->priv->weekdays_length1;
				_tmp4__length2 = self->priv->weekdays_length2;
				_tmp5_ = _tmp4_[(i * _tmp4__length2) + 0];
				_tmp6_ = g_strcmp0 (_tmp3_, _tmp5_) == 0;
				_g_free0 (_tmp3_);
				if (_tmp6_) {
					gchar** _tmp7_;
					gint _tmp7__length1;
					gint _tmp7__length2;
					const gchar* _tmp8_;
					_tmp7_ = self->priv->weekdays;
					_tmp7__length1 = self->priv->weekdays_length1;
					_tmp7__length2 = self->priv->weekdays_length2;
					_tmp8_ = _tmp7_[(i * _tmp7__length2) + 1];
					result = atoi (_tmp8_);
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_gchar_free_function_content_of (gpointer data)
{
	gchar* self;
	self = *((gchar**) data);
	_g_free0_ (self);
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static void
maya_services_parser_en_complete_string (MayaServicesParserEn* self,
                                         const gchar* pattern,
                                         MayaServicesParserEnStringEvent* result)
{
	GRegex* regex = NULL;
	GMatchInfo* match_info = NULL;
	gchar* matched_string = NULL;
	GMatchInfo* _tmp9_;
	gchar* _tmp10_;
	gint pos = 0;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint length = 0;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GArray* p = NULL;
	GArray* _tmp16_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GArray* _tmp30_;
	GArray* _tmp31_;
	MayaServicesParserEnStringEvent _tmp32_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pattern != NULL);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		gboolean is_matched = FALSE;
		GRegex* _tmp3_;
		const gchar* _tmp4_;
		GMatchInfo* _tmp5_ = NULL;
		gboolean _tmp6_;
		_tmp1_ = g_regex_new (pattern, G_REGEX_CASELESS, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (regex);
		regex = _tmp2_;
		_tmp3_ = regex;
		_tmp4_ = self->priv->remaining_source;
		_tmp6_ = g_regex_match (_tmp3_, _tmp4_, 0, &_tmp5_);
		_g_match_info_unref0 (match_info);
		match_info = _tmp5_;
		is_matched = _tmp6_;
		if (!is_matched) {
			MayaServicesParserEnStringEvent _tmp7_ = {0};
			memset (&_tmp7_, 0, sizeof (MayaServicesParserEnStringEvent));
			_tmp7_.matched = FALSE;
			*result = _tmp7_;
			_g_regex_unref0 (_tmp0_);
			_g_match_info_unref0 (match_info);
			_g_regex_unref0 (regex);
			return;
		}
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		MayaServicesParserEnStringEvent _tmp8_ = {0};
		g_clear_error (&_inner_error0_);
		memset (&_tmp8_, 0, sizeof (MayaServicesParserEnStringEvent));
		_tmp8_.matched = FALSE;
		*result = _tmp8_;
		_g_match_info_unref0 (match_info);
		_g_regex_unref0 (regex);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_match_info_unref0 (match_info);
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = match_info;
	_tmp10_ = g_match_info_fetch (_tmp9_, 0);
	matched_string = _tmp10_;
	_tmp11_ = self->priv->remaining_source;
	_tmp12_ = matched_string;
	pos = string_index_of (_tmp11_, _tmp12_, 0);
	_tmp13_ = matched_string;
	_tmp14_ = strlen (_tmp13_);
	_tmp15_ = _tmp14_;
	length = _tmp15_;
	_tmp16_ = g_array_new (TRUE, TRUE, sizeof (gchar*));
	g_array_set_clear_func (_tmp16_, (GDestroyNotify) _vala_gchar_free_function_content_of);
	p = _tmp16_;
	while (TRUE) {
		GMatchInfo* _tmp17_;
		_tmp17_ = match_info;
		if (!g_match_info_matches (_tmp17_)) {
			break;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					GArray* _tmp20_;
					GMatchInfo* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(i < 6)) {
						break;
					}
					_tmp20_ = p;
					_tmp21_ = match_info;
					_tmp22_ = g_strdup_printf ("%i", i + 1);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat ("p", _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					_tmp26_ = g_match_info_fetch_named (_tmp21_, _tmp25_);
					g_array_append_val (_tmp20_, _tmp26_);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp23_);
				}
			}
		}
		{
			GMatchInfo* _tmp27_;
			_tmp27_ = match_info;
			g_match_info_next (_tmp27_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch1_g_regex_error;
				}
				_g_array_unref0 (p);
				_g_free0 (matched_string);
				_g_match_info_unref0 (match_info);
				_g_regex_unref0 (regex);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally1;
		__catch1_g_regex_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_array_unref0 (p);
			_g_free0 (matched_string);
			_g_match_info_unref0 (match_info);
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp28_ = matched_string;
	_tmp29_ = g_strdup (_tmp28_);
	_tmp30_ = p;
	_tmp31_ = _g_array_ref0 (_tmp30_);
	memset (&_tmp32_, 0, sizeof (MayaServicesParserEnStringEvent));
	_tmp32_.matched = TRUE;
	_tmp32_.pos = pos;
	_tmp32_.length = length;
	_g_free0 (_tmp32_.matched_string);
	_tmp32_.matched_string = _tmp29_;
	_g_array_unref0 (_tmp32_.p);
	_tmp32_.p = _tmp31_;
	*result = _tmp32_;
	_g_array_unref0 (p);
	_g_free0 (matched_string);
	_g_match_info_unref0 (match_info);
	_g_regex_unref0 (regex);
	return;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

static void
maya_services_parser_en_analyze_pattern (MayaServicesParserEn* self,
                                         const gchar* pattern,
                                         MayaServicesParserEntranscribe_analysis del,
                                         gpointer del_target,
                                         gboolean delete)
{
	MayaServicesParserEnStringEvent data = {0};
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	MayaServicesParserEnStringEvent _tmp4_ = {0};
	MayaServicesParserEnStringEvent _tmp5_;
	MayaServicesParserEnStringEvent _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pattern != NULL);
	_tmp0_ = g_strconcat ("\\b", pattern, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "\\b", NULL);
	_tmp3_ = _tmp2_;
	maya_services_parser_en_complete_string (self, _tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	data = _tmp5_;
	_tmp6_ = data;
	if (_tmp6_.matched) {
		MayaServicesParserEnStringEvent _tmp12_;
		if (delete) {
			const gchar* _tmp7_;
			MayaServicesParserEnStringEvent _tmp8_;
			MayaServicesParserEnStringEvent _tmp9_;
			MayaServicesParserEnStringEvent _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = self->priv->remaining_source;
			_tmp8_ = data;
			_tmp9_ = data;
			_tmp10_ = data;
			_tmp11_ = string_splice (_tmp7_, (glong) _tmp8_.pos, (glong) (_tmp9_.pos + _tmp10_.length), NULL);
			_g_free0 (self->priv->remaining_source);
			self->priv->remaining_source = _tmp11_;
		}
		_tmp12_ = data;
		del (&_tmp12_, del_target);
	}
	maya_services_parser_en_string_event_destroy (&data);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		MayaServicesParserEn* self;
		self = _data18_->self;
		_g_object_unref0 (_data18_->event);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
__lambda54_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	_tmp0_ = _data18_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, -2);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda54__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda54_ (self, data);
}

static void
__lambda55_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	_tmp0_ = _data18_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, -1);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda55__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda55_ (self, data);
}

static void
__lambda56_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda56__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda56_ (self, data);
}

static void
__lambda57_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	_tmp0_ = _data18_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, 1);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda57__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda57_ (self, data);
}

static void
__lambda58_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint add_days = 0;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = self->simulated_dt;
	add_days = ((6 - g_date_time_get_day_of_week (_tmp0_)) + 7) % 7;
	_data18_->event->date_parsed = TRUE;
	_tmp1_ = _data18_->event->from;
	_tmp2_ = g_date_time_add_days (_tmp1_, add_days);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp2_;
	_tmp3_ = _data18_->event->from;
	_tmp4_ = g_date_time_add_days (_tmp3_, 1);
	_g_date_time_unref0 (_data18_->event->to);
	_data18_->event->to = _tmp4_;
	maya_services_parsed_event_set_all_day (_data18_->event);
}

static void
___lambda58__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda58_ (self, data);
}

static void
__lambda59_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda59__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda59_ (self, data);
}

static void
__lambda60_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda60__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda60_ (self, data);
}

static void
__lambda61_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	_tmp0_ = _data18_->event->from;
	_tmp1_ = g_date_time_add_days (_tmp0_, 7);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp1_;
	maya_services_parsed_event_set_all_day (_data18_->event);
}

static void
___lambda61__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda61_ (self, data);
}

static void
__lambda62_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	_tmp0_ = _data18_->event->from;
	_tmp1_ = g_date_time_add_months (_tmp0_, 1);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp1_;
	maya_services_parsed_event_set_all_day (_data18_->event);
}

static void
___lambda62__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda62_ (self, data);
}

static void
__lambda63_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint days = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	days = atoi (_tmp2_);
	_data18_->event->date_parsed = TRUE;
	_tmp3_ = _data18_->event->from;
	_tmp4_ = g_date_time_add_days (_tmp3_, -days);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp4_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda63__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda63_ (self, data);
}

static void
__lambda64_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint days = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	days = atoi (_tmp2_);
	_data18_->event->date_parsed = TRUE;
	_tmp3_ = _data18_->event->from;
	_tmp4_ = g_date_time_add_days (_tmp3_, days);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp4_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda64__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda64_ (self, data);
}

static void
__lambda65_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint weeks = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weeks = atoi (_tmp2_);
	_data18_->event->date_parsed = TRUE;
	_tmp3_ = _data18_->event->from;
	_tmp4_ = g_date_time_add_weeks (_tmp3_, weeks);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp4_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda65__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda65_ (self, data);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda66_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint weekday = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint add_days = 0;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weekday = maya_services_parser_en_get_number_of_weekday (self, _tmp2_);
	_tmp3_ = self->simulated_dt;
	add_days = ((weekday - g_date_time_get_day_of_week (_tmp3_)) + 7) % 7;
	_data18_->event->date_parsed = TRUE;
	_tmp4_ = _data18_->event->from;
	_tmp5_ = g_date_time_add_days (_tmp4_, add_days);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp5_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda66__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda66_ (self, data);
}

static void
__lambda67_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint weekday_1 = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint add_days_1 = 0;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	MayaServicesParserEnStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weekday_1 = maya_services_parser_en_get_number_of_weekday (self, _tmp2_);
	_tmp3_ = self->simulated_dt;
	add_days_1 = ((weekday_1 - g_date_time_get_day_of_week (_tmp3_)) + 7) % 7;
	_data18_->event->date_parsed = TRUE;
	_tmp4_ = _data18_->event->from;
	_tmp5_ = g_date_time_add_days (_tmp4_, add_days_1);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp5_;
	maya_services_parsed_event_set_all_day (_data18_->event);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 1);
	if (_tmp8_ != NULL) {
		gint weekday_2 = 0;
		MayaServicesParserEnStringEvent _tmp9_;
		GArray* _tmp10_;
		const gchar* _tmp11_;
		gint add_days_2 = 0;
		GDateTime* _tmp12_;
		GDateTime* _tmp13_;
		_tmp9_ = *data;
		_tmp10_ = _tmp9_.p;
		_tmp11_ = g_array_index (_tmp10_, gchar*, (guint) 1);
		weekday_2 = maya_services_parser_en_get_number_of_weekday (self, _tmp11_);
		add_days_2 = ((weekday_2 - weekday_1) + 7) % 7;
		_tmp12_ = _data18_->event->from;
		_tmp13_ = g_date_time_add_days (_tmp12_, add_days_2);
		_g_date_time_unref0 (_data18_->event->to);
		_data18_->event->to = _tmp13_;
	}
}

static void
___lambda67__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda67_ (self, data);
}

static void
__lambda68_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint day = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint month = 0;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	GDateTime* _tmp6_;
	MayaServicesParserEnStringEvent _tmp7_;
	GArray* _tmp8_;
	const gchar* _tmp9_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 2);
	day = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	month = atoi (_tmp5_);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data18_->event, day);
	maya_services_parsed_event_from_set_month (_data18_->event, month);
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
	_tmp6_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data18_->event, _tmp6_);
	_tmp7_ = *data;
	_tmp8_ = _tmp7_.p;
	_tmp9_ = g_array_index (_tmp8_, gchar*, (guint) 0);
	if (_tmp9_ != NULL) {
		gint year = 0;
		MayaServicesParserEnStringEvent _tmp10_;
		GArray* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = *data;
		_tmp11_ = _tmp10_.p;
		_tmp12_ = g_array_index (_tmp11_, gchar*, (guint) 0);
		year = atoi (_tmp12_);
		maya_services_parsed_event_from_set_year (_data18_->event, year);
	}
}

static void
___lambda68__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda68_ (self, data);
}

static void
__lambda69_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint day = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint month = 0;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	GDateTime* _tmp6_;
	MayaServicesParserEnStringEvent _tmp7_;
	GArray* _tmp8_;
	const gchar* _tmp9_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	day = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	month = maya_services_parser_en_get_number_of_month (self, _tmp5_);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data18_->event, day);
	maya_services_parsed_event_from_set_month (_data18_->event, month);
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
	_tmp6_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data18_->event, _tmp6_);
	_tmp7_ = *data;
	_tmp8_ = _tmp7_.p;
	_tmp9_ = g_array_index (_tmp8_, gchar*, (guint) 2);
	if (_tmp9_ != NULL) {
		gint year = 0;
		MayaServicesParserEnStringEvent _tmp10_;
		GArray* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = *data;
		_tmp11_ = _tmp10_.p;
		_tmp12_ = g_array_index (_tmp11_, gchar*, (guint) 2);
		year = atoi (_tmp12_);
		maya_services_parsed_event_from_set_year (_data18_->event, year);
	}
}

static void
___lambda69__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda69_ (self, data);
}

static void
__lambda70_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint day = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint month = 0;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	MayaServicesParserEnStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	GDateTime* _tmp12_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 1);
	day = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 0);
	month = maya_services_parser_en_get_number_of_month (self, _tmp5_);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data18_->event, day);
	maya_services_parsed_event_from_set_month (_data18_->event, month);
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 2);
	if (_tmp8_ != NULL) {
		gint year = 0;
		MayaServicesParserEnStringEvent _tmp9_;
		GArray* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = *data;
		_tmp10_ = _tmp9_.p;
		_tmp11_ = g_array_index (_tmp10_, gchar*, (guint) 2);
		year = atoi (_tmp11_);
		maya_services_parsed_event_from_set_year (_data18_->event, year);
	}
	_tmp12_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data18_->event, _tmp12_);
}

static void
___lambda70__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda70_ (self, data);
}

static void
__lambda71_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint day_1 = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint day_2 = 0;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	MayaServicesParserEnStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	GDateTime* _tmp13_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	day_1 = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	day_2 = atoi (_tmp5_);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data18_->event, day_1);
	maya_services_parsed_event_to_set_day (_data18_->event, day_2);
	maya_services_parsed_event_set_all_day (_data18_->event);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 2);
	if (_tmp8_ != NULL) {
		gint month = 0;
		MayaServicesParserEnStringEvent _tmp9_;
		GArray* _tmp10_;
		const gchar* _tmp11_;
		GDateTime* _tmp12_;
		_tmp9_ = *data;
		_tmp10_ = _tmp9_.p;
		_tmp11_ = g_array_index (_tmp10_, gchar*, (guint) 2);
		month = maya_services_parser_en_get_number_of_month (self, _tmp11_);
		maya_services_parsed_event_from_set_month (_data18_->event, month);
		maya_services_parsed_event_to_set_month (_data18_->event, month);
		_tmp12_ = self->simulated_dt;
		maya_services_parsed_event_if_elapsed_delay_to_next_year (_data18_->event, _tmp12_);
	}
	_tmp13_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_month (_data18_->event, _tmp13_);
}

static void
___lambda71__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda71_ (self, data);
}

static void
__lambda72_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint day_1 = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint day_2 = 0;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gint month_1 = 0;
	MayaServicesParserEnStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	gint month_2 = 0;
	MayaServicesParserEnStringEvent _tmp9_;
	GArray* _tmp10_;
	const gchar* _tmp11_;
	GDateTime* _tmp12_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 1);
	day_1 = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 3);
	day_2 = atoi (_tmp5_);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 0);
	month_1 = atoi (_tmp8_);
	_tmp9_ = *data;
	_tmp10_ = _tmp9_.p;
	_tmp11_ = g_array_index (_tmp10_, gchar*, (guint) 2);
	month_2 = atoi (_tmp11_);
	if (month_2 == 0) {
		month_2 = month_1;
	}
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data18_->event, day_1);
	maya_services_parsed_event_to_set_day (_data18_->event, day_2);
	maya_services_parsed_event_from_set_month (_data18_->event, month_1);
	maya_services_parsed_event_to_set_month (_data18_->event, month_2);
	maya_services_parsed_event_set_all_day (_data18_->event);
	_tmp12_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data18_->event, _tmp12_);
}

static void
___lambda72__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda72_ (self, data);
}

static void
__lambda73_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint day_1 = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint day_2 = 0;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gint month_1 = 0;
	MayaServicesParserEnStringEvent _tmp6_;
	GArray* _tmp7_;
	const gchar* _tmp8_;
	GDateTime* _tmp9_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 1);
	day_1 = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 2);
	day_2 = atoi (_tmp5_);
	_tmp6_ = *data;
	_tmp7_ = _tmp6_.p;
	_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 0);
	month_1 = maya_services_parser_en_get_number_of_month (self, _tmp8_);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_day (_data18_->event, day_1);
	maya_services_parsed_event_to_set_day (_data18_->event, day_2);
	maya_services_parsed_event_from_set_month (_data18_->event, month_1);
	maya_services_parsed_event_to_set_month (_data18_->event, month_1);
	maya_services_parsed_event_set_all_day (_data18_->event);
	_tmp9_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data18_->event, _tmp9_);
}

static void
___lambda73__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda73_ (self, data);
}

static void
__lambda74_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	_tmp0_ = _data18_->event->from;
	_tmp1_ = g_date_time_add_months (_tmp0_, 1);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp1_;
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
}

static void
___lambda74__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda74_ (self, data);
}

static void
__lambda75_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	GDateTime* _tmp0_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_from_set_month (_data18_->event, 12);
	maya_services_parsed_event_from_set_day (_data18_->event, 24);
	maya_services_parsed_event_set_one_entire_day (_data18_->event);
	_tmp0_ = self->simulated_dt;
	maya_services_parsed_event_if_elapsed_delay_to_next_year (_data18_->event, _tmp0_);
}

static void
___lambda75__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda75_ (self, data);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static void
__lambda76_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 8, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda76__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda76_ (self, data);
}

static void
__lambda77_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 13, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda77__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda77_ (self, data);
}

static void
__lambda78_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 19, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda78__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda78_ (self, data);
}

static void
__lambda79_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 9, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda79__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda79_ (self, data);
}

static void
__lambda80_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 11, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda80__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda80_ (self, data);
}

static void
__lambda81_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 12, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda81__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda81_ (self, data);
}

static void
__lambda82_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 15, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda82__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda82_ (self, data);
}

static void
__lambda83_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 18, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda83__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda83_ (self, data);
}

static void
__lambda84_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gboolean _tmp0_;
	gboolean* _tmp1_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_from_set_hour (_data18_->event, 19, "");
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 3);
	_tmp0_ = FALSE;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp1_;
}

static void
___lambda84__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda84_ (self, data);
}

static void
__lambda85_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint hour = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gchar* half = NULL;
	gchar* _tmp9_;
	MayaServicesParserEnStringEvent _tmp10_;
	GArray* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	gboolean* _tmp19_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hour = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	if (_tmp5_ != NULL) {
		gint minute_1 = 0;
		MayaServicesParserEnStringEvent _tmp6_;
		GArray* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = *data;
		_tmp7_ = _tmp6_.p;
		_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 1);
		minute_1 = atoi (_tmp8_);
		maya_services_parsed_event_from_set_minute (_data18_->event, minute_1);
	}
	_tmp9_ = g_strdup ("");
	half = _tmp9_;
	_tmp10_ = *data;
	_tmp11_ = _tmp10_.p;
	_tmp12_ = g_array_index (_tmp11_, gchar*, (guint) 2);
	if (_tmp12_ != NULL) {
		MayaServicesParserEnStringEvent _tmp13_;
		GArray* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = *data;
		_tmp14_ = _tmp13_.p;
		_tmp15_ = g_array_index (_tmp14_, gchar*, (guint) 2);
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (half);
		half = _tmp16_;
	}
	_data18_->event->time_parsed = TRUE;
	_tmp17_ = half;
	maya_services_parsed_event_from_set_hour (_data18_->event, hour, _tmp17_);
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp18_ = FALSE;
	_tmp19_ = __bool_dup0 (&_tmp18_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp19_;
	_g_free0 (half);
}

static void
___lambda85__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda85_ (self, data);
}

static void
__lambda86_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint hour = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gchar* half = NULL;
	gchar* _tmp9_;
	MayaServicesParserEnStringEvent _tmp10_;
	GArray* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	gboolean* _tmp19_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hour = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	if (_tmp5_ != NULL) {
		gint minute_1 = 0;
		MayaServicesParserEnStringEvent _tmp6_;
		GArray* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = *data;
		_tmp7_ = _tmp6_.p;
		_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 1);
		minute_1 = atoi (_tmp8_);
		maya_services_parsed_event_from_set_minute (_data18_->event, minute_1);
	}
	_tmp9_ = g_strdup ("");
	half = _tmp9_;
	_tmp10_ = *data;
	_tmp11_ = _tmp10_.p;
	_tmp12_ = g_array_index (_tmp11_, gchar*, (guint) 2);
	if (_tmp12_ != NULL) {
		MayaServicesParserEnStringEvent _tmp13_;
		GArray* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = *data;
		_tmp14_ = _tmp13_.p;
		_tmp15_ = g_array_index (_tmp14_, gchar*, (guint) 2);
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (half);
		half = _tmp16_;
	}
	_data18_->event->time_parsed = TRUE;
	_tmp17_ = half;
	maya_services_parsed_event_from_set_hour (_data18_->event, hour, _tmp17_);
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp18_ = FALSE;
	_tmp19_ = __bool_dup0 (&_tmp18_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp19_;
	_g_free0 (half);
}

static void
___lambda86__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda86_ (self, data);
}

static void
__lambda87_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint hour_1 = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gint hour_2 = 0;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gchar* half_1 = NULL;
	gchar* _tmp6_;
	MayaServicesParserEnStringEvent _tmp7_;
	GArray* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp14_;
	gchar* half_2 = NULL;
	gchar* _tmp15_;
	MayaServicesParserEnStringEvent _tmp16_;
	GArray* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp23_;
	MayaServicesParserEnStringEvent _tmp24_;
	GArray* _tmp25_;
	const gchar* _tmp26_;
	MayaServicesParserEnStringEvent _tmp30_;
	GArray* _tmp31_;
	const gchar* _tmp32_;
	gboolean _tmp36_;
	gboolean* _tmp37_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hour_1 = atoi (_tmp2_);
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	hour_2 = atoi (_tmp5_);
	_tmp6_ = g_strdup ("");
	half_1 = _tmp6_;
	_tmp7_ = *data;
	_tmp8_ = _tmp7_.p;
	_tmp9_ = g_array_index (_tmp8_, gchar*, (guint) 4);
	if (_tmp9_ != NULL) {
		MayaServicesParserEnStringEvent _tmp10_;
		GArray* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = *data;
		_tmp11_ = _tmp10_.p;
		_tmp12_ = g_array_index (_tmp11_, gchar*, (guint) 4);
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (half_1);
		half_1 = _tmp13_;
	}
	_tmp14_ = half_1;
	maya_services_parsed_event_from_set_hour (_data18_->event, hour_1, _tmp14_);
	_tmp15_ = g_strdup ("");
	half_2 = _tmp15_;
	_tmp16_ = *data;
	_tmp17_ = _tmp16_.p;
	_tmp18_ = g_array_index (_tmp17_, gchar*, (guint) 5);
	if (_tmp18_ != NULL) {
		MayaServicesParserEnStringEvent _tmp19_;
		GArray* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp19_ = *data;
		_tmp20_ = _tmp19_.p;
		_tmp21_ = g_array_index (_tmp20_, gchar*, (guint) 5);
		_tmp22_ = g_strdup (_tmp21_);
		_g_free0 (half_2);
		half_2 = _tmp22_;
	}
	_tmp23_ = half_2;
	maya_services_parsed_event_to_set_hour (_data18_->event, hour_2, _tmp23_);
	_tmp24_ = *data;
	_tmp25_ = _tmp24_.p;
	_tmp26_ = g_array_index (_tmp25_, gchar*, (guint) 2);
	if (_tmp26_ != NULL) {
		gint minute_1 = 0;
		MayaServicesParserEnStringEvent _tmp27_;
		GArray* _tmp28_;
		const gchar* _tmp29_;
		_tmp27_ = *data;
		_tmp28_ = _tmp27_.p;
		_tmp29_ = g_array_index (_tmp28_, gchar*, (guint) 2);
		minute_1 = atoi (_tmp29_);
		maya_services_parsed_event_from_set_minute (_data18_->event, minute_1);
	}
	_tmp30_ = *data;
	_tmp31_ = _tmp30_.p;
	_tmp32_ = g_array_index (_tmp31_, gchar*, (guint) 3);
	if (_tmp32_ != NULL) {
		gint minute_2 = 0;
		MayaServicesParserEnStringEvent _tmp33_;
		GArray* _tmp34_;
		const gchar* _tmp35_;
		_tmp33_ = *data;
		_tmp34_ = _tmp33_.p;
		_tmp35_ = g_array_index (_tmp34_, gchar*, (guint) 3);
		minute_2 = atoi (_tmp35_);
		maya_services_parsed_event_to_set_minute (_data18_->event, minute_2);
	}
	_data18_->event->time_parsed = TRUE;
	_tmp36_ = FALSE;
	_tmp37_ = __bool_dup0 (&_tmp36_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp37_;
	_g_free0 (half_2);
	_g_free0 (half_1);
}

static void
___lambda87__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda87_ (self, data);
}

static void
__lambda88_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint hour = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	MayaServicesParserEnStringEvent _tmp3_;
	GArray* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp9_;
	gboolean* _tmp10_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hour = atoi (_tmp2_);
	maya_services_parsed_event_from_set_hour (_data18_->event, hour, "");
	_tmp3_ = *data;
	_tmp4_ = _tmp3_.p;
	_tmp5_ = g_array_index (_tmp4_, gchar*, (guint) 1);
	if (_tmp5_ != NULL) {
		gint minute_1 = 0;
		MayaServicesParserEnStringEvent _tmp6_;
		GArray* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = *data;
		_tmp7_ = _tmp6_.p;
		_tmp8_ = g_array_index (_tmp7_, gchar*, (guint) 1);
		minute_1 = atoi (_tmp8_);
		maya_services_parsed_event_from_set_minute (_data18_->event, minute_1);
	}
	_data18_->event->time_parsed = TRUE;
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	_tmp9_ = FALSE;
	_tmp10_ = __bool_dup0 (&_tmp9_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp10_;
}

static void
___lambda88__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda88_ (self, data);
}

static void
__lambda89_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint minutes = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean* _tmp4_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	minutes = atoi (_tmp2_);
	_data18_->event->date_parsed = TRUE;
	_data18_->event->time_parsed = TRUE;
	_tmp3_ = FALSE;
	_tmp4_ = __bool_dup0 (&_tmp3_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp4_;
	maya_services_parsed_event_set_length_to_minutes (_data18_->event, minutes);
}

static void
___lambda89__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda89_ (self, data);
}

static void
__lambda90_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint hours = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean* _tmp4_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	hours = atoi (_tmp2_);
	_data18_->event->date_parsed = TRUE;
	_data18_->event->time_parsed = TRUE;
	_tmp3_ = FALSE;
	_tmp4_ = __bool_dup0 (&_tmp3_);
	_g_free0 (_data18_->event->all_day);
	_data18_->event->all_day = _tmp4_;
	maya_services_parsed_event_set_length_to_hours (_data18_->event, hours);
}

static void
___lambda90__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda90_ (self, data);
}

static void
__lambda91_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint days = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	days = atoi (_tmp2_);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_set_length_to_days (_data18_->event, days);
}

static void
___lambda91__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda91_ (self, data);
}

static void
__lambda92_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	gint weeks = 0;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	weeks = atoi (_tmp2_);
	_data18_->event->date_parsed = TRUE;
	maya_services_parsed_event_set_length_to_weeks (_data18_->event, weeks);
}

static void
___lambda92__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda92_ (self, data);
}

static void
__lambda93_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				MayaServicesParserEnStringEvent _tmp2_;
				GArray* _tmp3_;
				const gchar* _tmp4_;
				MayaServicesParserEnStringEvent _tmp5_;
				GArray* _tmp6_;
				const gchar* _tmp7_;
				gchar* _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = *data;
				_tmp3_ = _tmp2_.p;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = _data18_->event->participants;
				_tmp5_ = *data;
				_tmp6_ = _tmp5_.p;
				_tmp7_ = g_array_index (_tmp6_, gchar*, (guint) i);
				_tmp8_ = g_strconcat (_tmp4_, _tmp7_, NULL);
				_g_free0 (_data18_->event->participants);
				_data18_->event->participants = _tmp8_;
			}
		}
	}
}

static void
___lambda93__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda93_ (self, data);
}

static void
__lambda94_ (Block18Data* _data18_,
             MayaServicesParserEnStringEvent* data)
{
	MayaServicesParserEn* self;
	MayaServicesParserEnStringEvent _tmp0_;
	GArray* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	self = _data18_->self;
	g_return_if_fail (data != NULL);
	_tmp0_ = *data;
	_tmp1_ = _tmp0_.p;
	_tmp2_ = g_array_index (_tmp1_, gchar*, (guint) 0);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data18_->event->location);
	_data18_->event->location = _tmp3_;
}

static void
___lambda94__mayaservicesparserentranscribe_analysis (MayaServicesParserEnStringEvent* data,
                                                      gpointer self)
{
	__lambda94_ (self, data);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static MayaServicesParsedEvent*
maya_services_parser_en_real_parse_source (MayaServicesEventParser* base,
                                           const gchar* _source)
{
	MayaServicesParserEn * self;
	Block18Data* _data18_;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	MayaServicesParsedEvent* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	MayaServicesParsedEvent* _tmp34_;
	MayaServicesParsedEvent* result;
	self = (MayaServicesParserEn*) base;
	g_return_val_if_fail (_source != NULL, NULL);
	_data18_ = g_slice_new0 (Block18Data);
	_data18_->_ref_count_ = 1;
	_data18_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_source);
	_g_free0 (self->source);
	self->source = _tmp0_;
	_tmp1_ = self->source;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->priv->remaining_source);
	self->priv->remaining_source = _tmp2_;
	_tmp3_ = maya_services_parsed_event_new ("", NULL, NULL, "", NULL, "", FALSE, FALSE);
	_data18_->event = _tmp3_;
	_tmp4_ = self->simulated_dt;
	_tmp5_ = g_date_time_add_hours (_tmp4_, 1);
	_g_date_time_unref0 (_data18_->event->from);
	_data18_->event->from = _tmp5_;
	maya_services_parsed_event_from_set_minute (_data18_->event, 0);
	maya_services_parsed_event_from_set_second (_data18_->event, 0);
	maya_services_parsed_event_set_length_to_hours (_data18_->event, 1);
	maya_services_parser_en_analyze_pattern (self, "two days ago", ___lambda54__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "yesterday", ___lambda55__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "today", ___lambda56__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "tomorrow", ___lambda57__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "this weekend", ___lambda58__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "all day", ___lambda59__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "the whole day", ___lambda60__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "next week", ___lambda61__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "next month", ___lambda62__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(?<p1>\\d+) days ago", ___lambda63__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "in (?<p1>\\d+) days", ___lambda64__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "in (?<p1>\\d+) weeks", ___lambda65__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_tmp6_ = self->priv->weekdays_regex;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("(next|on) (?<p1>", _tmp7_, ")", NULL);
	_tmp9_ = _tmp8_;
	maya_services_parser_en_analyze_pattern (self, _tmp9_, ___lambda66__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_g_free0 (_tmp9_);
	_tmp10_ = self->priv->weekdays_regex;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = self->priv->weekdays_regex;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = g_strconcat ("(this )?(?<p1>", _tmp11_, ")( to (?<p2>", _tmp13_, "))?", NULL);
	_tmp15_ = _tmp14_;
	maya_services_parser_en_analyze_pattern (self, _tmp15_, ___lambda67__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_g_free0 (_tmp15_);
	maya_services_parser_en_analyze_pattern (self, "on ((?<p1>\\d{2,4})/)?(?<p2>\\d{1,2})/(?<p3>\\d{1,2})(st|nd|rd|th)?", ___lambda68__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_tmp16_ = self->priv->months_regex;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = g_strconcat ("on (?<p1>\\d{1,2})(st|nd|rd|th)? (?<p2>", _tmp17_, ")( (?<p3>\\d{2,4}))?", NULL);
	_tmp19_ = _tmp18_;
	maya_services_parser_en_analyze_pattern (self, _tmp19_, ___lambda69__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_g_free0 (_tmp19_);
	_tmp20_ = self->priv->months_regex;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("on (?<p1>", _tmp21_, ")(,)? (?<p2>\\d{1,2})(st|nd|rd|th)?( (?<p3>\\d{2,4}))?", NULL);
	_tmp23_ = _tmp22_;
	maya_services_parser_en_analyze_pattern (self, _tmp23_, ___lambda70__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_g_free0 (_tmp23_);
	_tmp24_ = self->priv->months_regex;
	_tmp25_ = string_to_string (_tmp24_);
	_tmp26_ = g_strconcat ("from (?<p1>\\d{1,2})(.)? to (?<p2>\\d{1,2}). ((?<p3>", _tmp25_, "))?", NULL);
	_tmp27_ = _tmp26_;
	maya_services_parser_en_analyze_pattern (self, _tmp27_, ___lambda71__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_g_free0 (_tmp27_);
	maya_services_parser_en_analyze_pattern (self, "from (?<p1>\\d{1,2})/(?<p2>\\d{1,2}) - ((?<p3>\\d{1,2})/)?(?<p4>\\d{1," \
"2})", ___lambda72__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_tmp28_ = self->priv->months_regex;
	_tmp29_ = string_to_string (_tmp28_);
	_tmp30_ = g_strconcat ("from (?<p1>", _tmp29_, ") (?<p2>\\d{1,2})(st|nd|rd|th)? - (?<p3>\\d{1,2})(st|nd|rd|th)?", NULL);
	_tmp31_ = _tmp30_;
	maya_services_parser_en_analyze_pattern (self, _tmp31_, ___lambda73__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_g_free0 (_tmp31_);
	maya_services_parser_en_analyze_pattern (self, "in a month", ___lambda74__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "christmas eve", ___lambda75__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "breakfast", ___lambda76__mayaservicesparserentranscribe_analysis, _data18_, FALSE);
	maya_services_parser_en_analyze_pattern (self, "lunch", ___lambda77__mayaservicesparserentranscribe_analysis, _data18_, FALSE);
	maya_services_parser_en_analyze_pattern (self, "dinner", ___lambda78__mayaservicesparserentranscribe_analysis, _data18_, FALSE);
	maya_services_parser_en_analyze_pattern (self, "early", ___lambda79__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(this )?morning", ___lambda80__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(at |this )?noon", ___lambda81__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(this )?afternoon", ___lambda82__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(this )?evening", ___lambda83__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "late", ___lambda84__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(at |@ ?)(?<p1>\\d{1,2})(:(?<p2>\\d{1,2}))?(?<p3>(am|pm|p))?", ___lambda85__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(at |@)(?<p1>\\d{4})", ___lambda86__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(from )?(?<p1>\\d{1,2})(:(?<p3>\\d{1,2}))?(?<p5>(am|pm|p)?)( to |-| - " \
")(?<p2>\\d{1,2})(:(?<p4>\\d{1,2}))?(?<p6>(am|pm|p)?)", ___lambda87__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(?<p1>\\d{1,2})(:(?<p2>\\d{1,2}))? (o'clock|h)", ___lambda88__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "for (?<p1>\\d+)(\\s?min| minutes)", ___lambda89__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "for (?<p1>\\d+)(\\s?h| hours)", ___lambda90__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "for (?<p1>\\d+)(\\s?d| days)", ___lambda91__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "for (?<p1>\\d+) weeks", ___lambda92__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(with)( the)? (?<p1>(\\w\\s?)+)", ___lambda93__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	maya_services_parser_en_analyze_pattern (self, "(at|in)(the)? (?<p1>(\\w\\s?)+)", ___lambda94__mayaservicesparserentranscribe_analysis, _data18_, TRUE);
	_tmp32_ = self->priv->remaining_source;
	_tmp33_ = string_strip (_tmp32_);
	_g_free0 (_data18_->event->title);
	_data18_->event->title = _tmp33_;
	_tmp34_ = _g_object_ref0 (_data18_->event);
	result = _tmp34_;
	block18_data_unref (_data18_);
	_data18_ = NULL;
	return result;
}

static gchar*
maya_services_parser_en_real_get_language (MayaServicesEventParser* base)
{
	MayaServicesParserEn * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaServicesParserEn*) base;
	_tmp0_ = g_strdup (MAYA_SERVICES_EVENT_PARSER_HANDLER_FALLBACK_LANG);
	result = _tmp0_;
	return result;
}

static void
maya_services_parser_en_string_event_copy (const MayaServicesParserEnStringEvent* self,
                                           MayaServicesParserEnStringEvent* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	(*dest).matched = (*self).matched;
	_tmp0_ = (*self).matched_string;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).matched_string);
	(*dest).matched_string = _tmp1_;
	(*dest).pos = (*self).pos;
	(*dest).length = (*self).length;
	_tmp2_ = (*self).p;
	_tmp3_ = _g_array_ref0 (_tmp2_);
	_g_array_unref0 ((*dest).p);
	(*dest).p = _tmp3_;
}

static void
maya_services_parser_en_string_event_destroy (MayaServicesParserEnStringEvent* self)
{
	_g_free0 ((*self).matched_string);
	_g_array_unref0 ((*self).p);
}

static MayaServicesParserEnStringEvent*
maya_services_parser_en_string_event_dup (const MayaServicesParserEnStringEvent* self)
{
	MayaServicesParserEnStringEvent* dup;
	dup = g_new0 (MayaServicesParserEnStringEvent, 1);
	maya_services_parser_en_string_event_copy (self, dup);
	return dup;
}

static void
maya_services_parser_en_string_event_free (MayaServicesParserEnStringEvent* self)
{
	maya_services_parser_en_string_event_destroy (self);
	g_free (self);
}

static GType
maya_services_parser_en_string_event_get_type_once (void)
{
	GType maya_services_parser_en_string_event_type_id;
	maya_services_parser_en_string_event_type_id = g_boxed_type_register_static ("MayaServicesParserEnStringEvent", (GBoxedCopyFunc) maya_services_parser_en_string_event_dup, (GBoxedFreeFunc) maya_services_parser_en_string_event_free);
	return maya_services_parser_en_string_event_type_id;
}

static GType
maya_services_parser_en_string_event_get_type (void)
{
	static volatile gsize maya_services_parser_en_string_event_type_id__once = 0;
	if (g_once_init_enter (&maya_services_parser_en_string_event_type_id__once)) {
		GType maya_services_parser_en_string_event_type_id;
		maya_services_parser_en_string_event_type_id = maya_services_parser_en_string_event_get_type_once ();
		g_once_init_leave (&maya_services_parser_en_string_event_type_id__once, maya_services_parser_en_string_event_type_id);
	}
	return maya_services_parser_en_string_event_type_id__once;
}

static void
maya_services_parser_en_class_init (MayaServicesParserEnClass * klass,
                                    gpointer klass_data)
{
	maya_services_parser_en_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaServicesParserEn_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_services_parser_en_finalize;
}

static void
maya_services_parser_en_maya_services_event_parser_interface_init (MayaServicesEventParserIface * iface,
                                                                   gpointer iface_data)
{
	maya_services_parser_en_maya_services_event_parser_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_source = (MayaServicesParsedEvent* (*) (MayaServicesEventParser*, const gchar*)) maya_services_parser_en_real_parse_source;
	iface->get_language = (gchar* (*) (MayaServicesEventParser*)) maya_services_parser_en_real_get_language;
}

static void
maya_services_parser_en_instance_init (MayaServicesParserEn * self,
                                       gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	gchar* _tmp65_;
	gchar** _tmp66_;
	self->priv = maya_services_parser_en_get_instance_private (self);
	_tmp0_ = g_strdup ("january");
	_tmp1_ = g_strdup ("1");
	_tmp2_ = g_strdup ("february");
	_tmp3_ = g_strdup ("2");
	_tmp4_ = g_strdup ("march");
	_tmp5_ = g_strdup ("3");
	_tmp6_ = g_strdup ("april");
	_tmp7_ = g_strdup ("4");
	_tmp8_ = g_strdup ("may");
	_tmp9_ = g_strdup ("5");
	_tmp10_ = g_strdup ("june");
	_tmp11_ = g_strdup ("6");
	_tmp12_ = g_strdup ("july");
	_tmp13_ = g_strdup ("7");
	_tmp14_ = g_strdup ("august");
	_tmp15_ = g_strdup ("8");
	_tmp16_ = g_strdup ("september");
	_tmp17_ = g_strdup ("9");
	_tmp18_ = g_strdup ("october");
	_tmp19_ = g_strdup ("10");
	_tmp20_ = g_strdup ("november");
	_tmp21_ = g_strdup ("11");
	_tmp22_ = g_strdup ("december");
	_tmp23_ = g_strdup ("12");
	_tmp24_ = g_new0 (gchar*, (12 * 2) + 1);
	_tmp24_[0] = _tmp0_;
	_tmp24_[1] = _tmp1_;
	_tmp24_[2] = _tmp2_;
	_tmp24_[3] = _tmp3_;
	_tmp24_[4] = _tmp4_;
	_tmp24_[5] = _tmp5_;
	_tmp24_[6] = _tmp6_;
	_tmp24_[7] = _tmp7_;
	_tmp24_[8] = _tmp8_;
	_tmp24_[9] = _tmp9_;
	_tmp24_[10] = _tmp10_;
	_tmp24_[11] = _tmp11_;
	_tmp24_[12] = _tmp12_;
	_tmp24_[13] = _tmp13_;
	_tmp24_[14] = _tmp14_;
	_tmp24_[15] = _tmp15_;
	_tmp24_[16] = _tmp16_;
	_tmp24_[17] = _tmp17_;
	_tmp24_[18] = _tmp18_;
	_tmp24_[19] = _tmp19_;
	_tmp24_[20] = _tmp20_;
	_tmp24_[21] = _tmp21_;
	_tmp24_[22] = _tmp22_;
	_tmp24_[23] = _tmp23_;
	self->priv->months = _tmp24_;
	self->priv->months_length1 = 12;
	self->priv->months_length2 = 2;
	_tmp25_ = g_strdup ("monday");
	_tmp26_ = g_strdup ("1");
	_tmp27_ = g_strdup ("tuesday");
	_tmp28_ = g_strdup ("2");
	_tmp29_ = g_strdup ("wednesday");
	_tmp30_ = g_strdup ("3");
	_tmp31_ = g_strdup ("thursday");
	_tmp32_ = g_strdup ("4");
	_tmp33_ = g_strdup ("thu");
	_tmp34_ = g_strdup ("4");
	_tmp35_ = g_strdup ("friday");
	_tmp36_ = g_strdup ("5");
	_tmp37_ = g_strdup ("saturday");
	_tmp38_ = g_strdup ("6");
	_tmp39_ = g_strdup ("sunday");
	_tmp40_ = g_strdup ("7");
	_tmp41_ = g_new0 (gchar*, (8 * 2) + 1);
	_tmp41_[0] = _tmp25_;
	_tmp41_[1] = _tmp26_;
	_tmp41_[2] = _tmp27_;
	_tmp41_[3] = _tmp28_;
	_tmp41_[4] = _tmp29_;
	_tmp41_[5] = _tmp30_;
	_tmp41_[6] = _tmp31_;
	_tmp41_[7] = _tmp32_;
	_tmp41_[8] = _tmp33_;
	_tmp41_[9] = _tmp34_;
	_tmp41_[10] = _tmp35_;
	_tmp41_[11] = _tmp36_;
	_tmp41_[12] = _tmp37_;
	_tmp41_[13] = _tmp38_;
	_tmp41_[14] = _tmp39_;
	_tmp41_[15] = _tmp40_;
	self->priv->weekdays = _tmp41_;
	self->priv->weekdays_length1 = 8;
	self->priv->weekdays_length2 = 2;
	_tmp42_ = g_strdup ("one");
	_tmp43_ = g_strdup ("1");
	_tmp44_ = g_strdup ("two");
	_tmp45_ = g_strdup ("2");
	_tmp46_ = g_strdup ("three");
	_tmp47_ = g_strdup ("3");
	_tmp48_ = g_strdup ("four");
	_tmp49_ = g_strdup ("4");
	_tmp50_ = g_strdup ("five");
	_tmp51_ = g_strdup ("5");
	_tmp52_ = g_strdup ("six");
	_tmp53_ = g_strdup ("6");
	_tmp54_ = g_strdup ("seven");
	_tmp55_ = g_strdup ("7");
	_tmp56_ = g_strdup ("eight");
	_tmp57_ = g_strdup ("8");
	_tmp58_ = g_strdup ("nine");
	_tmp59_ = g_strdup ("9");
	_tmp60_ = g_strdup ("ten");
	_tmp61_ = g_strdup ("10");
	_tmp62_ = g_strdup ("eleven");
	_tmp63_ = g_strdup ("11");
	_tmp64_ = g_strdup ("twelve");
	_tmp65_ = g_strdup ("12");
	_tmp66_ = g_new0 (gchar*, (12 * 2) + 1);
	_tmp66_[0] = _tmp42_;
	_tmp66_[1] = _tmp43_;
	_tmp66_[2] = _tmp44_;
	_tmp66_[3] = _tmp45_;
	_tmp66_[4] = _tmp46_;
	_tmp66_[5] = _tmp47_;
	_tmp66_[6] = _tmp48_;
	_tmp66_[7] = _tmp49_;
	_tmp66_[8] = _tmp50_;
	_tmp66_[9] = _tmp51_;
	_tmp66_[10] = _tmp52_;
	_tmp66_[11] = _tmp53_;
	_tmp66_[12] = _tmp54_;
	_tmp66_[13] = _tmp55_;
	_tmp66_[14] = _tmp56_;
	_tmp66_[15] = _tmp57_;
	_tmp66_[16] = _tmp58_;
	_tmp66_[17] = _tmp59_;
	_tmp66_[18] = _tmp60_;
	_tmp66_[19] = _tmp61_;
	_tmp66_[20] = _tmp62_;
	_tmp66_[21] = _tmp63_;
	_tmp66_[22] = _tmp64_;
	_tmp66_[23] = _tmp65_;
	self->priv->number_words = _tmp66_;
	self->priv->number_words_length1 = 12;
	self->priv->number_words_length2 = 2;
}

static void
maya_services_parser_en_finalize (GObject * obj)
{
	MayaServicesParserEn * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_SERVICES_TYPE_PARSER_EN, MayaServicesParserEn);
	_g_date_time_unref0 (self->simulated_dt);
	_g_free0 (self->source);
	_g_free0 (self->priv->remaining_source);
	self->priv->months = (_vala_array_free (self->priv->months, self->priv->months_length1 * self->priv->months_length2, (GDestroyNotify) g_free), NULL);
	self->priv->weekdays = (_vala_array_free (self->priv->weekdays, self->priv->weekdays_length1 * self->priv->weekdays_length2, (GDestroyNotify) g_free), NULL);
	self->priv->number_words = (_vala_array_free (self->priv->number_words, self->priv->number_words_length1 * self->priv->number_words_length2, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->months_regex);
	_g_free0 (self->priv->weekdays_regex);
	_g_free0 (self->priv->number_words_regex);
	G_OBJECT_CLASS (maya_services_parser_en_parent_class)->finalize (obj);
}

static GType
maya_services_parser_en_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaServicesParserEnClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_services_parser_en_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaServicesParserEn), 0, (GInstanceInitFunc) maya_services_parser_en_instance_init, NULL };
	static const GInterfaceInfo maya_services_event_parser_info = { (GInterfaceInitFunc) maya_services_parser_en_maya_services_event_parser_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType maya_services_parser_en_type_id;
	maya_services_parser_en_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaServicesParserEn", &g_define_type_info, 0);
	g_type_add_interface_static (maya_services_parser_en_type_id, MAYA_SERVICES_TYPE_EVENT_PARSER, &maya_services_event_parser_info);
	MayaServicesParserEn_private_offset = g_type_add_instance_private (maya_services_parser_en_type_id, sizeof (MayaServicesParserEnPrivate));
	return maya_services_parser_en_type_id;
}

GType
maya_services_parser_en_get_type (void)
{
	static volatile gsize maya_services_parser_en_type_id__once = 0;
	if (g_once_init_enter (&maya_services_parser_en_type_id__once)) {
		GType maya_services_parser_en_type_id;
		maya_services_parser_en_type_id = maya_services_parser_en_get_type_once ();
		g_once_init_leave (&maya_services_parser_en_type_id__once, maya_services_parser_en_type_id);
	}
	return maya_services_parser_en_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

