/* RepeatPanel.c generated by valac 0.56.16, the Vala compiler
 * generated from RepeatPanel.vala, do not modify */

/*-
 * Copyright 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jaap Broekhuizen
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <math.h>
#include <float.h>
#include <stdlib.h>
#include <string.h>
#include <libical-glib/libical-glib.h>
#include <libecal/libecal.h>
#include "elementary-calendar.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL (maya_view_event_edition_repeat_panel_get_type ())
#define MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, MayaViewEventEditionRepeatPanel))
#define MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, MayaViewEventEditionRepeatPanelClass))
#define MAYA_VIEW_EVENT_EDITION_IS_REPEAT_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL))
#define MAYA_VIEW_EVENT_EDITION_IS_REPEAT_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL))
#define MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, MayaViewEventEditionRepeatPanelClass))

typedef struct _MayaViewEventEditionRepeatPanel MayaViewEventEditionRepeatPanel;
typedef struct _MayaViewEventEditionRepeatPanelClass MayaViewEventEditionRepeatPanelClass;
typedef struct _MayaViewEventEditionRepeatPanelPrivate MayaViewEventEditionRepeatPanelPrivate;

#define MAYA_VIEW_TYPE_EVENT_DIALOG (maya_view_event_dialog_get_type ())
#define MAYA_VIEW_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog))
#define MAYA_VIEW_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))
#define MAYA_VIEW_IS_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_IS_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_EVENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))

typedef struct _MayaViewEventDialog MayaViewEventDialog;
typedef struct _MayaViewEventDialogClass MayaViewEventDialogClass;
enum  {
	MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL_0_PROPERTY,
	MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL_NUM_PROPERTIES
};
static GParamSpec* maya_view_event_edition_repeat_panel_properties[MAYA_VIEW_EVENT_EDITION_REPEAT_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block16Data Block16Data;
typedef struct _MayaViewEventDialogPrivate MayaViewEventDialogPrivate;

#define MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID (maya_view_event_edition_exception_grid_get_type ())
#define MAYA_VIEW_EVENT_EDITION_EXCEPTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID, MayaViewEventEditionExceptionGrid))
#define MAYA_VIEW_EVENT_EDITION_EXCEPTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID, MayaViewEventEditionExceptionGridClass))
#define MAYA_VIEW_EVENT_EDITION_IS_EXCEPTION_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID))
#define MAYA_VIEW_EVENT_EDITION_IS_EXCEPTION_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID))
#define MAYA_VIEW_EVENT_EDITION_EXCEPTION_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID, MayaViewEventEditionExceptionGridClass))

typedef struct _MayaViewEventEditionExceptionGrid MayaViewEventEditionExceptionGrid;
typedef struct _MayaViewEventEditionExceptionGridClass MayaViewEventEditionExceptionGridClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _MayaViewEventEditionExceptionGridPrivate MayaViewEventEditionExceptionGridPrivate;
enum  {
	MAYA_VIEW_EVENT_EDITION_EXCEPTION_GRID_0_PROPERTY,
	MAYA_VIEW_EVENT_EDITION_EXCEPTION_GRID_NUM_PROPERTIES
};
static GParamSpec* maya_view_event_edition_exception_grid_properties[MAYA_VIEW_EVENT_EDITION_EXCEPTION_GRID_NUM_PROPERTIES];

struct _MayaViewEventEditionRepeatPanel {
	GtkGrid parent_instance;
	MayaViewEventEditionRepeatPanelPrivate * priv;
};

struct _MayaViewEventEditionRepeatPanelClass {
	GtkGridClass parent_class;
};

struct _MayaViewEventEditionRepeatPanelPrivate {
	MayaViewEventDialog* parent_dialog;
	GtkSwitch* repeat_switch;
	GtkComboBoxText* repeat_combobox;
	GtkComboBoxText* ends_combobox;
	GtkSpinButton* end_entry;
	GraniteWidgetsDatePicker* end_datepicker;
	GtkBox* week_box;
	GtkGrid* month_grid;
	GtkSpinButton* every_entry;
	GtkLabel* every_unit_label;
	GtkListBox* exceptions_list;
	GtkToggleButton* mon_button;
	GtkToggleButton* tue_button;
	GtkToggleButton* wed_button;
	GtkToggleButton* thu_button;
	GtkToggleButton* fri_button;
	GtkToggleButton* sat_button;
	GtkToggleButton* sun_button;
	GtkRadioButton* every_radiobutton;
	GtkRadioButton* same_radiobutton;
};

struct _Block16Data {
	int _ref_count_;
	MayaViewEventEditionRepeatPanel* self;
	GtkGrid* every_grid;
	GtkLabel* end_label;
	GtkGrid* ends_grid;
	GtkGrid* exceptions_grid;
	MayaViewEventDialog* parent_dialog;
};

struct _MayaViewEventDialog {
	GraniteDialog parent_instance;
	MayaViewEventDialogPrivate * priv;
	gboolean can_edit;
};

struct _MayaViewEventDialogClass {
	GraniteDialogClass parent_class;
};

struct _MayaViewEventEditionExceptionGrid {
	GtkListBoxRow parent_instance;
	MayaViewEventEditionExceptionGridPrivate * priv;
};

struct _MayaViewEventEditionExceptionGridClass {
	GtkListBoxRowClass parent_class;
};

struct _MayaViewEventEditionExceptionGridPrivate {
	GraniteWidgetsDatePicker* date;
};

static gint MayaViewEventEditionRepeatPanel_private_offset;
static gpointer maya_view_event_edition_repeat_panel_parent_class = NULL;
static gint MayaViewEventEditionExceptionGrid_private_offset;
static gpointer maya_view_event_edition_exception_grid_parent_class = NULL;

VALA_EXTERN GType maya_view_event_edition_repeat_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionRepeatPanel, g_object_unref)
VALA_EXTERN GType maya_view_event_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventDialog, g_object_unref)
VALA_EXTERN MayaViewEventEditionRepeatPanel* maya_view_event_edition_repeat_panel_new (MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionRepeatPanel* maya_view_event_edition_repeat_panel_construct (GType object_type,
                                                                                 MayaViewEventDialog* parent_dialog);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void __lambda47_ (Block16Data* _data16_);
VALA_EXTERN GDateTime* maya_view_event_dialog_get_date_time (MayaViewEventDialog* self);
static void maya_view_event_edition_repeat_panel_set_every_day (MayaViewEventEditionRepeatPanel* self,
                                                         gshort day);
static void ___lambda47__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static void __lambda48_ (MayaViewEventEditionRepeatPanel* self);
static void ___lambda48__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                 gpointer self);
static void __lambda49_ (Block16Data* _data16_);
static void ___lambda49__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static void __lambda50_ (Block16Data* _data16_);
static void ___lambda50__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                 gpointer self);
static void maya_view_event_edition_repeat_panel_create_week_box (MayaViewEventEditionRepeatPanel* self);
static void __lambda51_ (MayaViewEventEditionRepeatPanel* self);
VALA_EXTERN GType maya_view_event_edition_exception_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionExceptionGrid, g_object_unref)
VALA_EXTERN MayaViewEventEditionExceptionGrid* maya_view_event_edition_exception_grid_new (GDateTime* dt);
VALA_EXTERN MayaViewEventEditionExceptionGrid* maya_view_event_edition_exception_grid_construct (GType object_type,
                                                                                     GDateTime* dt);
static void ___lambda51__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda53_ (Block16Data* _data16_);
static void ___lambda53__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void maya_view_event_edition_repeat_panel_load (MayaViewEventEditionRepeatPanel* self);
static void maya_view_event_edition_repeat_panel_load_weekly_recurrence (MayaViewEventEditionRepeatPanel* self,
                                                                  ICalRecurrence* rrule);
static void maya_view_event_edition_repeat_panel_load_monthly_recurrence (MayaViewEventEditionRepeatPanel* self,
                                                                   ICalRecurrence* rrule);
VALA_EXTERN ECalComponent* maya_view_event_dialog_get_ecal (MayaViewEventDialog* self);
static gshort maya_view_event_edition_repeat_panel_encode_day (MayaViewEventEditionRepeatPanel* self,
                                                        ICalRecurrenceWeekday weekday,
                                                        gint position);
VALA_EXTERN void maya_view_event_edition_repeat_panel_save (MayaViewEventEditionRepeatPanel* self);
VALA_EXTERN GDateTime* maya_view_event_edition_exception_grid_get_date (MayaViewEventEditionExceptionGrid* self);
static void maya_view_event_edition_repeat_panel_finalize (GObject * obj);
static GType maya_view_event_edition_repeat_panel_get_type_once (void);
static void __lambda52_ (MayaViewEventEditionExceptionGrid* self);
static void ___lambda52__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void maya_view_event_edition_exception_grid_finalize (GObject * obj);
static GType maya_view_event_edition_exception_grid_get_type_once (void);

static inline gpointer
maya_view_event_edition_repeat_panel_get_instance_private (MayaViewEventEditionRepeatPanel* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewEventEditionRepeatPanel_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		MayaViewEventEditionRepeatPanel* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->exceptions_grid);
		_g_object_unref0 (_data16_->ends_grid);
		_g_object_unref0 (_data16_->end_label);
		_g_object_unref0 (_data16_->every_grid);
		_g_object_unref0 (_data16_->parent_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}

static void
__lambda47_ (Block16Data* _data16_)
{
	MayaViewEventEditionRepeatPanel* self;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkSpinButton* _tmp19_;
	self = _data16_->self;
	_tmp0_ = self->priv->repeat_combobox;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case 1:
		{
			GtkBox* _tmp3_;
			GtkBox* _tmp4_;
			GtkGrid* _tmp5_;
			GtkGrid* _tmp6_;
			_tmp3_ = self->priv->week_box;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, FALSE);
			_tmp4_ = self->priv->week_box;
			gtk_widget_show_all ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->month_grid;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp5_, TRUE);
			_tmp6_ = self->priv->month_grid;
			gtk_widget_hide ((GtkWidget*) _tmp6_);
			break;
		}
		case 2:
		{
			gint day_of_week = 0;
			GDateTime* _tmp7_;
			GDateTime* _tmp8_;
			GDateTime* _tmp9_;
			GDateTime* _tmp10_;
			GtkBox* _tmp11_;
			GtkBox* _tmp12_;
			GtkGrid* _tmp13_;
			GtkGrid* _tmp14_;
			_tmp7_ = maya_view_event_dialog_get_date_time (_data16_->parent_dialog);
			_tmp8_ = _tmp7_;
			day_of_week = g_date_time_get_day_of_week (_tmp8_) + 1;
			if (day_of_week > 7) {
				day_of_week = 1;
			}
			_tmp9_ = maya_view_event_dialog_get_date_time (_data16_->parent_dialog);
			_tmp10_ = _tmp9_;
			maya_view_event_edition_repeat_panel_set_every_day (self, (gshort) (day_of_week + (ceil (((gdouble) g_date_time_get_day_of_month (_tmp10_)) / ((gdouble) 7)) * 8)));
			_tmp11_ = self->priv->week_box;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp11_, TRUE);
			_tmp12_ = self->priv->week_box;
			gtk_widget_hide ((GtkWidget*) _tmp12_);
			_tmp13_ = self->priv->month_grid;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp13_, FALSE);
			_tmp14_ = self->priv->month_grid;
			gtk_widget_show_all ((GtkWidget*) _tmp14_);
			break;
		}
		default:
		{
			GtkGrid* _tmp15_;
			GtkGrid* _tmp16_;
			GtkBox* _tmp17_;
			GtkBox* _tmp18_;
			_tmp15_ = self->priv->month_grid;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp15_, TRUE);
			_tmp16_ = self->priv->month_grid;
			gtk_widget_hide ((GtkWidget*) _tmp16_);
			_tmp17_ = self->priv->week_box;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp17_, TRUE);
			_tmp18_ = self->priv->week_box;
			gtk_widget_hide ((GtkWidget*) _tmp18_);
			break;
		}
	}
	_tmp19_ = self->priv->every_entry;
	g_signal_emit_by_name (_tmp19_, "value-changed");
}

static void
___lambda47__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda47_ (self);
}

static void
__lambda48_ (MayaViewEventEditionRepeatPanel* self)
{
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	_tmp0_ = self->priv->repeat_combobox;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case 0:
		{
			GtkLabel* _tmp3_;
			GtkSpinButton* _tmp4_;
			gdouble _tmp5_;
			gdouble _tmp6_;
			_tmp3_ = self->priv->every_unit_label;
			_tmp4_ = self->priv->every_entry;
			_tmp5_ = gtk_spin_button_get_value (_tmp4_);
			_tmp6_ = _tmp5_;
			gtk_label_set_label (_tmp3_, ngettext ("Day", "Days", (gulong) _tmp6_));
			break;
		}
		case 1:
		{
			GtkLabel* _tmp7_;
			GtkSpinButton* _tmp8_;
			gdouble _tmp9_;
			gdouble _tmp10_;
			_tmp7_ = self->priv->every_unit_label;
			_tmp8_ = self->priv->every_entry;
			_tmp9_ = gtk_spin_button_get_value (_tmp8_);
			_tmp10_ = _tmp9_;
			gtk_label_set_label (_tmp7_, ngettext ("Week", "Weeks", (gulong) _tmp10_));
			break;
		}
		case 2:
		{
			GtkLabel* _tmp11_;
			GtkSpinButton* _tmp12_;
			gdouble _tmp13_;
			gdouble _tmp14_;
			_tmp11_ = self->priv->every_unit_label;
			_tmp12_ = self->priv->every_entry;
			_tmp13_ = gtk_spin_button_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			gtk_label_set_label (_tmp11_, ngettext ("Month", "Months", (gulong) _tmp14_));
			break;
		}
		case 3:
		{
			GtkLabel* _tmp15_;
			GtkSpinButton* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			_tmp15_ = self->priv->every_unit_label;
			_tmp16_ = self->priv->every_entry;
			_tmp17_ = gtk_spin_button_get_value (_tmp16_);
			_tmp18_ = _tmp17_;
			gtk_label_set_label (_tmp15_, ngettext ("Year", "Years", (gulong) _tmp18_));
			break;
		}
		default:
		break;
	}
}

static void
___lambda48__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                            gpointer self)
{
	__lambda48_ ((MayaViewEventEditionRepeatPanel*) self);
}

static void
__lambda49_ (Block16Data* _data16_)
{
	MayaViewEventEditionRepeatPanel* self;
	GtkComboBoxText* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = _data16_->self;
	_tmp0_ = self->priv->ends_combobox;
	_tmp1_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp0_);
	_tmp2_ = _tmp1_;
	switch (_tmp2_) {
		case 0:
		{
			GtkSpinButton* _tmp3_;
			GraniteWidgetsDatePicker* _tmp4_;
			gtk_widget_hide ((GtkWidget*) _data16_->end_label);
			_tmp3_ = self->priv->end_entry;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
			_tmp4_ = self->priv->end_datepicker;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
			break;
		}
		case 1:
		{
			GtkSpinButton* _tmp5_;
			GraniteWidgetsDatePicker* _tmp6_;
			gtk_widget_hide ((GtkWidget*) _data16_->end_label);
			_tmp5_ = self->priv->end_entry;
			gtk_widget_hide ((GtkWidget*) _tmp5_);
			_tmp6_ = self->priv->end_datepicker;
			gtk_widget_show ((GtkWidget*) _tmp6_);
			break;
		}
		case 2:
		{
			GtkSpinButton* _tmp7_;
			GraniteWidgetsDatePicker* _tmp8_;
			gtk_widget_show ((GtkWidget*) _data16_->end_label);
			_tmp7_ = self->priv->end_entry;
			gtk_widget_show ((GtkWidget*) _tmp7_);
			_tmp8_ = self->priv->end_datepicker;
			gtk_widget_hide ((GtkWidget*) _tmp8_);
			break;
		}
		default:
		break;
	}
}

static void
___lambda49__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda49_ (self);
}

static void
__lambda50_ (Block16Data* _data16_)
{
	MayaViewEventEditionRepeatPanel* self;
	GtkSpinButton* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	self = _data16_->self;
	_tmp0_ = self->priv->end_entry;
	_tmp1_ = gtk_spin_button_get_value (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_data16_->end_label, ngettext ("Repeat", "Repeats", (gulong) _tmp2_));
}

static void
___lambda50__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                            gpointer self)
{
	__lambda50_ (self);
}

static void
__lambda51_ (MayaViewEventEditionRepeatPanel* self)
{
	MayaViewEventEditionExceptionGrid* exception_grid = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	MayaViewEventEditionExceptionGrid* _tmp2_;
	MayaViewEventEditionExceptionGrid* _tmp3_;
	GtkListBox* _tmp4_;
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = maya_view_event_edition_exception_grid_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	exception_grid = _tmp3_;
	gtk_widget_show_all ((GtkWidget*) exception_grid);
	_tmp4_ = self->priv->exceptions_list;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) exception_grid);
	_g_object_unref0 (exception_grid);
}

static void
___lambda51__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda51_ ((MayaViewEventEditionRepeatPanel*) self);
}

static void
__lambda53_ (Block16Data* _data16_)
{
	MayaViewEventEditionRepeatPanel* self;
	gboolean active = FALSE;
	GtkSwitch* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkBox* _tmp4_;
	GtkGrid* _tmp5_;
	self = _data16_->self;
	_tmp0_ = self->priv->repeat_switch;
	_tmp1_ = gtk_switch_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	active = _tmp2_;
	_tmp3_ = self->priv->repeat_combobox;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, active);
	gtk_widget_set_sensitive ((GtkWidget*) _data16_->every_grid, active);
	_tmp4_ = self->priv->week_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, active);
	_tmp5_ = self->priv->month_grid;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, active);
	gtk_widget_set_sensitive ((GtkWidget*) _data16_->ends_grid, active);
	gtk_widget_set_sensitive ((GtkWidget*) _data16_->exceptions_grid, active);
}

static void
___lambda53__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda53_ (self);
}

MayaViewEventEditionRepeatPanel*
maya_view_event_edition_repeat_panel_construct (GType object_type,
                                                MayaViewEventDialog* parent_dialog)
{
	MayaViewEventEditionRepeatPanel * self = NULL;
	Block16Data* _data16_;
	MayaViewEventDialog* _tmp0_;
	MayaViewEventDialog* _tmp1_;
	GraniteHeaderLabel* reminder_label = NULL;
	GraniteHeaderLabel* _tmp2_;
	GtkSwitch* _tmp3_;
	GtkComboBoxText* _tmp4_;
	GtkComboBoxText* _tmp5_;
	GtkComboBoxText* _tmp6_;
	GtkComboBoxText* _tmp7_;
	GtkComboBoxText* _tmp8_;
	GtkComboBoxText* _tmp9_;
	GtkComboBoxText* _tmp10_;
	GtkComboBoxText* _tmp11_;
	GtkComboBoxText* _tmp12_;
	GtkGrid* repeat_switch_grid = NULL;
	GtkGrid* _tmp13_;
	GtkSwitch* _tmp14_;
	GtkGrid* repeat_grid = NULL;
	GtkGrid* _tmp15_;
	GtkComboBoxText* _tmp16_;
	GraniteHeaderLabel* every_label = NULL;
	GraniteHeaderLabel* _tmp17_;
	GtkSpinButton* _tmp18_;
	GtkSpinButton* _tmp19_;
	GtkSpinButton* _tmp20_;
	GtkLabel* _tmp21_;
	GtkGrid* _tmp22_;
	GtkSpinButton* _tmp23_;
	GtkLabel* _tmp24_;
	GraniteHeaderLabel* ends_label = NULL;
	GraniteHeaderLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkComboBoxText* _tmp27_;
	GtkComboBoxText* _tmp28_;
	GtkComboBoxText* _tmp29_;
	GtkComboBoxText* _tmp30_;
	GtkComboBoxText* _tmp31_;
	GtkComboBoxText* _tmp32_;
	GtkComboBoxText* _tmp33_;
	GtkSpinButton* _tmp34_;
	GtkSpinButton* _tmp35_;
	GtkSpinButton* _tmp36_;
	GtkSpinButton* _tmp37_;
	gchar* format = NULL;
	gchar* _tmp38_;
	GraniteWidgetsDatePicker* _tmp39_;
	GraniteWidgetsDatePicker* _tmp40_;
	GtkGrid* _tmp41_;
	GtkComboBoxText* _tmp42_;
	GtkSpinButton* _tmp43_;
	GraniteWidgetsDatePicker* _tmp44_;
	GtkBox* _tmp45_;
	GtkRadioButton* _tmp46_;
	GtkRadioButton* _tmp47_;
	GtkRadioButton* _tmp48_;
	GtkGrid* _tmp49_;
	GtkGrid* _tmp50_;
	GtkGrid* _tmp51_;
	GtkGrid* _tmp52_;
	GtkGrid* _tmp53_;
	GtkGrid* _tmp54_;
	GtkRadioButton* _tmp55_;
	GtkGrid* _tmp56_;
	GtkRadioButton* _tmp57_;
	GraniteHeaderLabel* exceptions_label = NULL;
	GraniteHeaderLabel* _tmp58_;
	GtkLabel* no_exceptions_label = NULL;
	GtkLabel* _tmp59_;
	GtkStyleContext* no_exceptions_context = NULL;
	GtkStyleContext* _tmp60_;
	GtkListBox* _tmp61_;
	GtkListBox* _tmp62_;
	GtkListBox* _tmp63_;
	GtkListBox* _tmp64_;
	GtkScrolledWindow* exceptions_scrolled = NULL;
	GtkScrolledWindow* _tmp65_;
	GtkListBox* _tmp66_;
	GtkButton* add_button = NULL;
	GtkButton* _tmp67_;
	GtkImage* _tmp68_;
	GtkImage* _tmp69_;
	GtkStyleContext* _tmp70_;
	GtkActionBar* inline_toolbar = NULL;
	GtkActionBar* _tmp71_;
	GtkStyleContext* _tmp72_;
	GtkGrid* _tmp73_;
	GtkFrame* exceptions_frame = NULL;
	GtkFrame* _tmp74_;
	GtkBox* _tmp75_;
	GtkGrid* _tmp76_;
	GtkSwitch* _tmp77_;
	GtkSwitch* _tmp78_;
	GtkSwitch* _tmp79_;
	g_return_val_if_fail (parent_dialog != NULL, NULL);
	_data16_ = g_slice_new0 (Block16Data);
	_data16_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (parent_dialog);
	_g_object_unref0 (_data16_->parent_dialog);
	_data16_->parent_dialog = _tmp0_;
	self = (MayaViewEventEditionRepeatPanel*) g_object_new (object_type, NULL);
	_data16_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_data16_->parent_dialog);
	_g_object_unref0 (self->priv->parent_dialog);
	self->priv->parent_dialog = _tmp1_;
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 6);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 12);
	gtk_widget_set_sensitive ((GtkWidget*) self, _data16_->parent_dialog->can_edit);
	_tmp2_ = granite_header_label_new (_ ("Repeat:"));
	g_object_ref_sink (_tmp2_);
	reminder_label = _tmp2_;
	_tmp3_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->repeat_switch);
	self->priv->repeat_switch = _tmp3_;
	_tmp4_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->repeat_combobox);
	self->priv->repeat_combobox = _tmp4_;
	_tmp5_ = self->priv->repeat_combobox;
	gtk_combo_box_text_append_text (_tmp5_, _ ("Daily"));
	_tmp6_ = self->priv->repeat_combobox;
	gtk_combo_box_text_append_text (_tmp6_, _ ("Weekly"));
	_tmp7_ = self->priv->repeat_combobox;
	gtk_combo_box_text_append_text (_tmp7_, _ ("Monthly"));
	_tmp8_ = self->priv->repeat_combobox;
	gtk_combo_box_text_append_text (_tmp8_, _ ("Yearly"));
	_tmp9_ = self->priv->repeat_combobox;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp9_, 1);
	_tmp10_ = self->priv->repeat_combobox;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->priv->repeat_combobox;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
	_tmp12_ = self->priv->repeat_combobox;
	g_signal_connect_data ((GtkComboBox*) _tmp12_, "changed", (GCallback) ___lambda47__gtk_combo_box_changed, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp13_);
	repeat_switch_grid = _tmp13_;
	gtk_widget_set_valign ((GtkWidget*) repeat_switch_grid, GTK_ALIGN_CENTER);
	_tmp14_ = self->priv->repeat_switch;
	gtk_container_add ((GtkContainer*) repeat_switch_grid, (GtkWidget*) _tmp14_);
	_tmp15_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp15_);
	repeat_grid = _tmp15_;
	gtk_grid_set_row_spacing (repeat_grid, 6);
	gtk_grid_set_column_spacing (repeat_grid, 12);
	gtk_orientable_set_orientation ((GtkOrientable*) repeat_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_container_add ((GtkContainer*) repeat_grid, (GtkWidget*) repeat_switch_grid);
	_tmp16_ = self->priv->repeat_combobox;
	gtk_container_add ((GtkContainer*) repeat_grid, (GtkWidget*) _tmp16_);
	_tmp17_ = granite_header_label_new (_ ("Every:"));
	g_object_ref_sink (_tmp17_);
	every_label = _tmp17_;
	_tmp18_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 99, (gdouble) 1);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->every_entry);
	self->priv->every_entry = _tmp18_;
	_tmp19_ = self->priv->every_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, TRUE);
	_tmp20_ = self->priv->every_entry;
	g_signal_connect_object (_tmp20_, "value-changed", (GCallback) ___lambda48__gtk_spin_button_value_changed, self, 0);
	_tmp21_ = (GtkLabel*) gtk_label_new (ngettext ("Week", "Weeks", (gulong) 1));
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->every_unit_label);
	self->priv->every_unit_label = _tmp21_;
	_tmp22_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp22_);
	_data16_->every_grid = _tmp22_;
	gtk_grid_set_row_spacing (_data16_->every_grid, 6);
	gtk_grid_set_column_spacing (_data16_->every_grid, 12);
	gtk_orientable_set_orientation ((GtkOrientable*) _data16_->every_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_sensitive ((GtkWidget*) _data16_->every_grid, FALSE);
	_tmp23_ = self->priv->every_entry;
	gtk_container_add ((GtkContainer*) _data16_->every_grid, (GtkWidget*) _tmp23_);
	_tmp24_ = self->priv->every_unit_label;
	gtk_container_add ((GtkContainer*) _data16_->every_grid, (GtkWidget*) _tmp24_);
	_tmp25_ = granite_header_label_new (_ ("Ends:"));
	g_object_ref_sink (_tmp25_);
	ends_label = _tmp25_;
	_tmp26_ = (GtkLabel*) gtk_label_new (ngettext ("Repeat", "Repeats", (gulong) 1));
	g_object_ref_sink (_tmp26_);
	_data16_->end_label = _tmp26_;
	gtk_widget_set_no_show_all ((GtkWidget*) _data16_->end_label, TRUE);
	_tmp27_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->ends_combobox);
	self->priv->ends_combobox = _tmp27_;
	_tmp28_ = self->priv->ends_combobox;
	gtk_combo_box_text_append_text (_tmp28_, _ ("Never"));
	_tmp29_ = self->priv->ends_combobox;
	gtk_combo_box_text_append_text (_tmp29_, _ ("Until"));
	_tmp30_ = self->priv->ends_combobox;
	gtk_combo_box_text_append_text (_tmp30_, _ ("After"));
	_tmp31_ = self->priv->ends_combobox;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp31_, TRUE);
	_tmp32_ = self->priv->ends_combobox;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp32_, 0);
	_tmp33_ = self->priv->ends_combobox;
	g_signal_connect_data ((GtkComboBox*) _tmp33_, "changed", (GCallback) ___lambda49__gtk_combo_box_changed, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp34_ = (GtkSpinButton*) gtk_spin_button_new_with_range ((gdouble) 1, (gdouble) 99, (gdouble) 1);
	g_object_ref_sink (_tmp34_);
	_g_object_unref0 (self->priv->end_entry);
	self->priv->end_entry = _tmp34_;
	_tmp35_ = self->priv->end_entry;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp35_, TRUE);
	_tmp36_ = self->priv->end_entry;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp36_, TRUE);
	_tmp37_ = self->priv->end_entry;
	g_signal_connect_data (_tmp37_, "value-changed", (GCallback) ___lambda50__gtk_spin_button_value_changed, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp38_ = granite_date_time_get_default_date_format (FALSE, TRUE, TRUE);
	format = _tmp38_;
	_tmp39_ = granite_widgets_date_picker_new_with_format (format);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->end_datepicker);
	self->priv->end_datepicker = _tmp39_;
	_tmp40_ = self->priv->end_datepicker;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp40_, TRUE);
	_tmp41_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp41_);
	_data16_->ends_grid = _tmp41_;
	gtk_grid_set_row_spacing (_data16_->ends_grid, 6);
	gtk_grid_set_column_spacing (_data16_->ends_grid, 12);
	gtk_orientable_set_orientation ((GtkOrientable*) _data16_->ends_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_sensitive ((GtkWidget*) _data16_->ends_grid, FALSE);
	_tmp42_ = self->priv->ends_combobox;
	gtk_container_add ((GtkContainer*) _data16_->ends_grid, (GtkWidget*) _tmp42_);
	_tmp43_ = self->priv->end_entry;
	gtk_container_add ((GtkContainer*) _data16_->ends_grid, (GtkWidget*) _tmp43_);
	gtk_container_add ((GtkContainer*) _data16_->ends_grid, (GtkWidget*) _data16_->end_label);
	_tmp44_ = self->priv->end_datepicker;
	gtk_container_add ((GtkContainer*) _data16_->ends_grid, (GtkWidget*) _tmp44_);
	maya_view_event_edition_repeat_panel_create_week_box (self);
	_tmp45_ = self->priv->week_box;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp45_, FALSE);
	_tmp46_ = (GtkRadioButton*) gtk_radio_button_new_with_label (NULL, _ ("The same day every month"));
	g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->same_radiobutton);
	self->priv->same_radiobutton = _tmp46_;
	_tmp47_ = self->priv->same_radiobutton;
	_tmp48_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp47_);
	g_object_ref_sink (_tmp48_);
	_g_object_unref0 (self->priv->every_radiobutton);
	self->priv->every_radiobutton = _tmp48_;
	_tmp49_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp49_);
	_g_object_unref0 (self->priv->month_grid);
	self->priv->month_grid = _tmp49_;
	_tmp50_ = self->priv->month_grid;
	gtk_grid_set_row_spacing (_tmp50_, 6);
	_tmp51_ = self->priv->month_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp51_, GTK_ORIENTATION_VERTICAL);
	_tmp52_ = self->priv->month_grid;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp52_, TRUE);
	_tmp53_ = self->priv->month_grid;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp53_, FALSE);
	_tmp54_ = self->priv->month_grid;
	_tmp55_ = self->priv->same_radiobutton;
	gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
	_tmp56_ = self->priv->month_grid;
	_tmp57_ = self->priv->every_radiobutton;
	gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
	_tmp58_ = granite_header_label_new (_ ("Exceptions:"));
	g_object_ref_sink (_tmp58_);
	exceptions_label = _tmp58_;
	_tmp59_ = (GtkLabel*) gtk_label_new (_ ("No Exceptions"));
	g_object_ref_sink (_tmp59_);
	no_exceptions_label = _tmp59_;
	gtk_widget_show ((GtkWidget*) no_exceptions_label);
	_tmp60_ = gtk_widget_get_style_context ((GtkWidget*) no_exceptions_label);
	no_exceptions_context = _tmp60_;
	gtk_style_context_add_class (no_exceptions_context, GRANITE_STYLE_CLASS_H3_LABEL);
	gtk_style_context_add_class (no_exceptions_context, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp61_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->exceptions_list);
	self->priv->exceptions_list = _tmp61_;
	_tmp62_ = self->priv->exceptions_list;
	g_object_set ((GtkWidget*) _tmp62_, "expand", TRUE, NULL);
	_tmp63_ = self->priv->exceptions_list;
	gtk_list_box_set_selection_mode (_tmp63_, GTK_SELECTION_NONE);
	_tmp64_ = self->priv->exceptions_list;
	gtk_list_box_set_placeholder (_tmp64_, (GtkWidget*) no_exceptions_label);
	_tmp65_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp65_);
	exceptions_scrolled = _tmp65_;
	_tmp66_ = self->priv->exceptions_list;
	gtk_container_add ((GtkContainer*) exceptions_scrolled, (GtkWidget*) _tmp66_);
	g_object_set ((GtkWidget*) exceptions_scrolled, "expand", TRUE, NULL);
	_tmp67_ = (GtkButton*) gtk_button_new_with_label (_ ("Add Exception"));
	g_object_ref_sink (_tmp67_);
	add_button = _tmp67_;
	gtk_button_set_always_show_image (add_button, TRUE);
	_tmp68_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp68_);
	_tmp69_ = _tmp68_;
	gtk_button_set_image (add_button, (GtkWidget*) _tmp69_);
	_g_object_unref0 (_tmp69_);
	g_object_set ((GtkWidget*) add_button, "margin", 3, NULL);
	_tmp70_ = gtk_widget_get_style_context ((GtkWidget*) add_button);
	gtk_style_context_add_class (_tmp70_, GTK_STYLE_CLASS_FLAT);
	_tmp71_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp71_);
	inline_toolbar = _tmp71_;
	_tmp72_ = gtk_widget_get_style_context ((GtkWidget*) inline_toolbar);
	gtk_style_context_add_class (_tmp72_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	gtk_container_add ((GtkContainer*) inline_toolbar, (GtkWidget*) add_button);
	_tmp73_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp73_);
	_data16_->exceptions_grid = _tmp73_;
	gtk_widget_set_sensitive ((GtkWidget*) _data16_->exceptions_grid, FALSE);
	gtk_grid_attach (_data16_->exceptions_grid, (GtkWidget*) exceptions_scrolled, 0, 0, 1, 1);
	gtk_grid_attach (_data16_->exceptions_grid, (GtkWidget*) inline_toolbar, 0, 1, 1, 1);
	_tmp74_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp74_);
	exceptions_frame = _tmp74_;
	gtk_container_add ((GtkContainer*) exceptions_frame, (GtkWidget*) _data16_->exceptions_grid);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) reminder_label, 1, 0, 1, 1);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) repeat_grid, 1, 1, 1, 1);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) every_label, 1, 2, 1, 1);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _data16_->every_grid, 1, 3, 1, 1);
	_tmp75_ = self->priv->week_box;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp75_, 1, 4, 1, 1);
	_tmp76_ = self->priv->month_grid;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp76_, 1, 4, 1, 1);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) ends_label, 1, 5, 1, 1);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _data16_->ends_grid, 1, 6, 1, 1);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) exceptions_label, 1, 7, 1, 1);
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) exceptions_frame, 1, 8, 1, 1);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda51__gtk_button_clicked, self, 0);
	_tmp77_ = self->priv->repeat_switch;
	g_signal_connect_data ((GObject*) _tmp77_, "notify::active", (GCallback) ___lambda53__g_object_notify, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
	_tmp78_ = self->priv->repeat_switch;
	gtk_switch_set_active (_tmp78_, FALSE);
	maya_view_event_edition_repeat_panel_load (self);
	_tmp79_ = self->priv->repeat_switch;
	gtk_widget_grab_focus ((GtkWidget*) _tmp79_);
	_g_object_unref0 (exceptions_frame);
	_g_object_unref0 (inline_toolbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (exceptions_scrolled);
	_g_object_unref0 (no_exceptions_label);
	_g_object_unref0 (exceptions_label);
	_g_free0 (format);
	_g_object_unref0 (ends_label);
	_g_object_unref0 (every_label);
	_g_object_unref0 (repeat_grid);
	_g_object_unref0 (repeat_switch_grid);
	_g_object_unref0 (reminder_label);
	block16_data_unref (_data16_);
	_data16_ = NULL;
	return self;
}

MayaViewEventEditionRepeatPanel*
maya_view_event_edition_repeat_panel_new (MayaViewEventDialog* parent_dialog)
{
	return maya_view_event_edition_repeat_panel_construct (MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, parent_dialog);
}

static void
maya_view_event_edition_repeat_panel_load_weekly_recurrence (MayaViewEventEditionRepeatPanel* self,
                                                             ICalRecurrence* rrule)
{
	GtkComboBoxText* _tmp0_;
	GArray* by_day = NULL;
	GArray* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rrule != NULL);
	_tmp0_ = self->priv->repeat_combobox;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp0_, 1);
	_tmp1_ = i_cal_recurrence_get_by_day_array (rrule);
	by_day = _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_ = FALSE;
				GArray* _tmp5_;
				GArray* _tmp7_;
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = by_day;
				if (i < _tmp5_->len) {
					GArray* _tmp6_;
					_tmp6_ = by_day;
					_tmp4_ = g_array_index (_tmp6_, gshort, i) != I_CAL_RECURRENCE_ARRAY_MAX;
				} else {
					_tmp4_ = FALSE;
				}
				if (!_tmp4_) {
					break;
				}
				_tmp7_ = by_day;
				switch (i_cal_recurrence_day_day_of_week (g_array_index (_tmp7_, gshort, i))) {
					case I_CAL_SUNDAY_WEEKDAY:
					{
						GtkToggleButton* _tmp8_;
						_tmp8_ = self->priv->sun_button;
						gtk_toggle_button_set_active (_tmp8_, TRUE);
						break;
					}
					case I_CAL_MONDAY_WEEKDAY:
					{
						GtkToggleButton* _tmp9_;
						_tmp9_ = self->priv->mon_button;
						gtk_toggle_button_set_active (_tmp9_, TRUE);
						break;
					}
					case I_CAL_TUESDAY_WEEKDAY:
					{
						GtkToggleButton* _tmp10_;
						_tmp10_ = self->priv->tue_button;
						gtk_toggle_button_set_active (_tmp10_, TRUE);
						break;
					}
					case I_CAL_WEDNESDAY_WEEKDAY:
					{
						GtkToggleButton* _tmp11_;
						_tmp11_ = self->priv->wed_button;
						gtk_toggle_button_set_active (_tmp11_, TRUE);
						break;
					}
					case I_CAL_THURSDAY_WEEKDAY:
					{
						GtkToggleButton* _tmp12_;
						_tmp12_ = self->priv->thu_button;
						gtk_toggle_button_set_active (_tmp12_, TRUE);
						break;
					}
					case I_CAL_FRIDAY_WEEKDAY:
					{
						GtkToggleButton* _tmp13_;
						_tmp13_ = self->priv->fri_button;
						gtk_toggle_button_set_active (_tmp13_, TRUE);
						break;
					}
					case I_CAL_SATURDAY_WEEKDAY:
					{
						GtkToggleButton* _tmp14_;
						_tmp14_ = self->priv->sat_button;
						gtk_toggle_button_set_active (_tmp14_, TRUE);
						break;
					}
					default:
					{
						GArray* _tmp15_;
						_tmp15_ = by_day;
						i = _tmp15_->len;
						break;
					}
				}
			}
		}
	}
	_g_array_unref0 (by_day);
}

static void
maya_view_event_edition_repeat_panel_load_monthly_recurrence (MayaViewEventEditionRepeatPanel* self,
                                                              ICalRecurrence* rrule)
{
	GtkComboBoxText* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rrule != NULL);
	_tmp0_ = self->priv->repeat_combobox;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp0_, 2);
	if (i_cal_recurrence_get_by_month_day (rrule, (guint) 0) != I_CAL_RECURRENCE_ARRAY_MAX) {
		GtkRadioButton* _tmp1_;
		_tmp1_ = self->priv->same_radiobutton;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp1_, TRUE);
	} else {
		gshort by_day = 0;
		by_day = i_cal_recurrence_get_by_day (rrule, (guint) 0);
		if (by_day != I_CAL_RECURRENCE_ARRAY_MAX) {
			GtkRadioButton* _tmp2_;
			maya_view_event_edition_repeat_panel_set_every_day (self, by_day);
			_tmp2_ = self->priv->every_radiobutton;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp2_, TRUE);
		}
	}
}

static void
maya_view_event_edition_repeat_panel_load (MayaViewEventEditionRepeatPanel* self)
{
	MayaViewEventDialog* _tmp0_;
	ECalComponent* _tmp1_;
	ECalComponent* _tmp2_;
	ICalComponent* comp = NULL;
	MayaViewEventDialog* _tmp3_;
	ECalComponent* _tmp4_;
	ECalComponent* _tmp5_;
	ICalComponent* _tmp6_;
	ICalProperty* property = NULL;
	ICalComponent* _tmp7_;
	ICalProperty* _tmp8_;
	ICalProperty* _tmp9_;
	ICalComponent* _tmp34_;
	ICalProperty* _tmp35_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parent_dialog;
	_tmp1_ = maya_view_event_dialog_get_ecal (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->parent_dialog;
	_tmp4_ = maya_view_event_dialog_get_ecal (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_cal_component_get_icalcomponent (_tmp5_);
	comp = _tmp6_;
	_tmp7_ = comp;
	_tmp8_ = i_cal_component_get_first_property (_tmp7_, I_CAL_RRULE_PROPERTY);
	_g_object_unref0 (property);
	property = _tmp8_;
	_tmp9_ = property;
	if (_tmp9_ != NULL) {
		GtkSwitch* _tmp10_;
		ICalRecurrence* rrule = NULL;
		ICalProperty* _tmp11_;
		ICalRecurrence* _tmp12_;
		ICalRecurrence* _tmp13_;
		GtkSpinButton* _tmp19_;
		ICalRecurrence* _tmp20_;
		ICalTime* until = NULL;
		ICalRecurrence* _tmp21_;
		ICalTime* _tmp22_;
		ICalTime* _tmp23_;
		ICalRecurrence* _tmp30_;
		_tmp10_ = self->priv->repeat_switch;
		gtk_switch_set_active (_tmp10_, TRUE);
		_tmp11_ = property;
		_tmp12_ = i_cal_property_get_rrule (_tmp11_);
		rrule = _tmp12_;
		_tmp13_ = rrule;
		switch (i_cal_recurrence_get_freq (_tmp13_)) {
			case I_CAL_WEEKLY_RECURRENCE:
			{
				ICalRecurrence* _tmp14_;
				_tmp14_ = rrule;
				maya_view_event_edition_repeat_panel_load_weekly_recurrence (self, _tmp14_);
				break;
			}
			case I_CAL_MONTHLY_RECURRENCE:
			{
				ICalRecurrence* _tmp15_;
				_tmp15_ = rrule;
				maya_view_event_edition_repeat_panel_load_monthly_recurrence (self, _tmp15_);
				break;
			}
			case I_CAL_YEARLY_RECURRENCE:
			{
				GtkComboBoxText* _tmp16_;
				_tmp16_ = self->priv->repeat_combobox;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp16_, 3);
				break;
			}
			default:
			{
				ICalRecurrence* _tmp17_;
				GtkComboBoxText* _tmp18_;
				_tmp17_ = rrule;
				g_warning ("RepeatPanel.vala:345: %d", (gint) i_cal_recurrence_get_freq (_tmp17_));
				_tmp18_ = self->priv->repeat_combobox;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp18_, 0);
				break;
			}
		}
		_tmp19_ = self->priv->every_entry;
		_tmp20_ = rrule;
		gtk_spin_button_set_value (_tmp19_, (gdouble) i_cal_recurrence_get_interval (_tmp20_));
		_tmp21_ = rrule;
		_tmp22_ = i_cal_recurrence_get_until (_tmp21_);
		until = _tmp22_;
		_tmp23_ = until;
		if (i_cal_time_is_null_time (_tmp23_)) {
			GtkComboBoxText* _tmp24_;
			_tmp24_ = self->priv->ends_combobox;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp24_, 0);
		} else {
			GtkComboBoxText* _tmp25_;
			GraniteWidgetsDatePicker* _tmp26_;
			ICalTime* _tmp27_;
			GDateTime* _tmp28_;
			GDateTime* _tmp29_;
			_tmp25_ = self->priv->ends_combobox;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp25_, 1);
			_tmp26_ = self->priv->end_datepicker;
			_tmp27_ = until;
			_tmp28_ = calendar_util_icaltime_to_datetime (_tmp27_);
			_tmp29_ = _tmp28_;
			granite_widgets_date_picker_set_date (_tmp26_, _tmp29_);
			_g_date_time_unref0 (_tmp29_);
		}
		_tmp30_ = rrule;
		if (i_cal_recurrence_get_count (_tmp30_) > 0) {
			GtkSpinButton* _tmp31_;
			ICalRecurrence* _tmp32_;
			GtkComboBoxText* _tmp33_;
			_tmp31_ = self->priv->end_entry;
			_tmp32_ = rrule;
			gtk_spin_button_set_value (_tmp31_, (gdouble) i_cal_recurrence_get_count (_tmp32_));
			_tmp33_ = self->priv->ends_combobox;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp33_, 2);
		}
		_g_object_unref0 (until);
		_g_object_unref0 (rrule);
	}
	_tmp34_ = comp;
	_tmp35_ = i_cal_component_get_first_property (_tmp34_, I_CAL_EXDATE_PROPERTY);
	_g_object_unref0 (property);
	property = _tmp35_;
	while (TRUE) {
		ICalProperty* _tmp36_;
		ICalTime* exdate = NULL;
		ICalProperty* _tmp37_;
		ICalTime* _tmp38_;
		MayaViewEventEditionExceptionGrid* exception_grid = NULL;
		ICalTime* _tmp39_;
		GDateTime* _tmp40_;
		GDateTime* _tmp41_;
		MayaViewEventEditionExceptionGrid* _tmp42_;
		MayaViewEventEditionExceptionGrid* _tmp43_;
		MayaViewEventEditionExceptionGrid* _tmp44_;
		GtkListBox* _tmp45_;
		MayaViewEventEditionExceptionGrid* _tmp46_;
		ICalComponent* _tmp47_;
		ICalProperty* _tmp48_;
		_tmp36_ = property;
		if (!(_tmp36_ != NULL)) {
			break;
		}
		_tmp37_ = property;
		_tmp38_ = i_cal_property_get_exdate (_tmp37_);
		exdate = _tmp38_;
		_tmp39_ = exdate;
		_tmp40_ = calendar_util_icaltime_to_datetime (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = maya_view_event_edition_exception_grid_new (_tmp41_);
		g_object_ref_sink (_tmp42_);
		_tmp43_ = _tmp42_;
		_g_date_time_unref0 (_tmp41_);
		exception_grid = _tmp43_;
		_tmp44_ = exception_grid;
		gtk_widget_show_all ((GtkWidget*) _tmp44_);
		_tmp45_ = self->priv->exceptions_list;
		_tmp46_ = exception_grid;
		gtk_container_add ((GtkContainer*) _tmp45_, (GtkWidget*) _tmp46_);
		_tmp47_ = comp;
		_tmp48_ = i_cal_component_get_next_property (_tmp47_, I_CAL_EXDATE_PROPERTY);
		_g_object_unref0 (property);
		property = _tmp48_;
		_g_object_unref0 (exception_grid);
		_g_object_unref0 (exdate);
	}
	_g_object_unref0 (property);
}

/**
     * This can't be simplified because of some problems with the translation.
     * see https://bugs.launchpad.net/maya/+bug/1405605 for reference.
     */
static void
maya_view_event_edition_repeat_panel_set_every_day (MayaViewEventEditionRepeatPanel* self,
                                                    gshort day)
{
	gint day_position = 0;
	ICalRecurrenceWeekday weekday = 0;
	g_return_if_fail (self != NULL);
	day_position = i_cal_recurrence_day_position (day);
	weekday = i_cal_recurrence_day_day_of_week (day);
	switch (day_position) {
		case -1:
		{
			switch (weekday) {
				case I_CAL_SUNDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp0_;
					_tmp0_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp0_, _ ("Every last Sunday"));
					break;
				}
				case I_CAL_MONDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp1_;
					_tmp1_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp1_, _ ("Every last Monday"));
					break;
				}
				case I_CAL_TUESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp2_;
					_tmp2_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp2_, _ ("Every last Tuesday"));
					break;
				}
				case I_CAL_WEDNESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp3_;
					_tmp3_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp3_, _ ("Every last Wednesday"));
					break;
				}
				case I_CAL_THURSDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp4_;
					_tmp4_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp4_, _ ("Every last Thursday"));
					break;
				}
				case I_CAL_FRIDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp5_;
					_tmp5_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp5_, _ ("Every last Friday"));
					break;
				}
				default:
				{
					GtkRadioButton* _tmp6_;
					_tmp6_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp6_, _ ("Every last Saturday"));
					break;
				}
			}
			break;
		}
		case 1:
		{
			switch (weekday) {
				case I_CAL_SUNDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp7_;
					_tmp7_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp7_, _ ("Every first Sunday"));
					break;
				}
				case I_CAL_MONDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp8_;
					_tmp8_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp8_, _ ("Every first Monday"));
					break;
				}
				case I_CAL_TUESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp9_;
					_tmp9_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp9_, _ ("Every first Tuesday"));
					break;
				}
				case I_CAL_WEDNESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp10_;
					_tmp10_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp10_, _ ("Every first Wednesday"));
					break;
				}
				case I_CAL_THURSDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp11_;
					_tmp11_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp11_, _ ("Every first Thursday"));
					break;
				}
				case I_CAL_FRIDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp12_;
					_tmp12_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp12_, _ ("Every first Friday"));
					break;
				}
				default:
				{
					GtkRadioButton* _tmp13_;
					_tmp13_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp13_, _ ("Every first Saturday"));
					break;
				}
			}
			break;
		}
		case 2:
		{
			switch (weekday) {
				case I_CAL_SUNDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp14_;
					_tmp14_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp14_, _ ("Every second Sunday"));
					break;
				}
				case I_CAL_MONDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp15_;
					_tmp15_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp15_, _ ("Every second Monday"));
					break;
				}
				case I_CAL_TUESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp16_;
					_tmp16_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp16_, _ ("Every second Tuesday"));
					break;
				}
				case I_CAL_WEDNESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp17_;
					_tmp17_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp17_, _ ("Every second Wednesday"));
					break;
				}
				case I_CAL_THURSDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp18_;
					_tmp18_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp18_, _ ("Every second Thursday"));
					break;
				}
				case I_CAL_FRIDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp19_;
					_tmp19_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp19_, _ ("Every second Friday"));
					break;
				}
				default:
				{
					GtkRadioButton* _tmp20_;
					_tmp20_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp20_, _ ("Every second Saturday"));
					break;
				}
			}
			break;
		}
		case 3:
		{
			switch (weekday) {
				case I_CAL_SUNDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp21_;
					_tmp21_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp21_, _ ("Every third Sunday"));
					break;
				}
				case I_CAL_MONDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp22_;
					_tmp22_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp22_, _ ("Every third Monday"));
					break;
				}
				case I_CAL_TUESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp23_;
					_tmp23_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp23_, _ ("Every third Tuesday"));
					break;
				}
				case I_CAL_WEDNESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp24_;
					_tmp24_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp24_, _ ("Every third Wednesday"));
					break;
				}
				case I_CAL_THURSDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp25_;
					_tmp25_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp25_, _ ("Every third Thursday"));
					break;
				}
				case I_CAL_FRIDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp26_;
					_tmp26_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp26_, _ ("Every third Friday"));
					break;
				}
				default:
				{
					GtkRadioButton* _tmp27_;
					_tmp27_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp27_, _ ("Every third Saturday"));
					break;
				}
			}
			break;
		}
		case 4:
		{
			switch (weekday) {
				case I_CAL_SUNDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp28_;
					_tmp28_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp28_, _ ("Every fourth Sunday"));
					break;
				}
				case I_CAL_MONDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp29_;
					_tmp29_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp29_, _ ("Every fourth Monday"));
					break;
				}
				case I_CAL_TUESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp30_;
					_tmp30_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp30_, _ ("Every fourth Tuesday"));
					break;
				}
				case I_CAL_WEDNESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp31_;
					_tmp31_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp31_, _ ("Every fourth Wednesday"));
					break;
				}
				case I_CAL_THURSDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp32_;
					_tmp32_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp32_, _ ("Every fourth Thursday"));
					break;
				}
				case I_CAL_FRIDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp33_;
					_tmp33_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp33_, _ ("Every fourth Friday"));
					break;
				}
				default:
				{
					GtkRadioButton* _tmp34_;
					_tmp34_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp34_, _ ("Every fourth Saturday"));
					break;
				}
			}
			break;
		}
		default:
		{
			switch (weekday) {
				case I_CAL_SUNDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp35_;
					_tmp35_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp35_, _ ("Every fifth Sunday"));
					break;
				}
				case I_CAL_MONDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp36_;
					_tmp36_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp36_, _ ("Every fifth Monday"));
					break;
				}
				case I_CAL_TUESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp37_;
					_tmp37_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp37_, _ ("Every fifth Tuesday"));
					break;
				}
				case I_CAL_WEDNESDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp38_;
					_tmp38_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp38_, _ ("Every fifth Wednesday"));
					break;
				}
				case I_CAL_THURSDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp39_;
					_tmp39_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp39_, _ ("Every fifth Thursday"));
					break;
				}
				case I_CAL_FRIDAY_WEEKDAY:
				{
					GtkRadioButton* _tmp40_;
					_tmp40_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp40_, _ ("Every fifth Friday"));
					break;
				}
				default:
				{
					GtkRadioButton* _tmp41_;
					_tmp41_ = self->priv->every_radiobutton;
					gtk_button_set_label ((GtkButton*) _tmp41_, _ ("Every fifth Saturday"));
					break;
				}
			}
			break;
		}
	}
}

static void
maya_view_event_edition_repeat_panel_create_week_box (MayaViewEventEditionRepeatPanel* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkToggleButton* _tmp5_;
	GtkToggleButton* _tmp6_;
	GtkToggleButton* _tmp7_;
	GtkToggleButton* _tmp8_;
	GtkBox* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkBox* _tmp11_;
	GtkStyleContext* _tmp12_;
	CalendarEventStore* _tmp13_;
	CalendarEventStore* _tmp14_;
	GDateWeekday _tmp15_;
	GDateWeekday _tmp16_;
	GDateWeekday _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->week_box);
	self->priv->week_box = _tmp0_;
	_tmp1_ = self->priv->week_box;
	gtk_box_set_homogeneous (_tmp1_, TRUE);
	_tmp2_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Mon"));
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->mon_button);
	self->priv->mon_button = _tmp2_;
	_tmp3_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Tue"));
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->tue_button);
	self->priv->tue_button = _tmp3_;
	_tmp4_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Wed"));
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->wed_button);
	self->priv->wed_button = _tmp4_;
	_tmp5_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Thu"));
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->thu_button);
	self->priv->thu_button = _tmp5_;
	_tmp6_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Fri"));
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->fri_button);
	self->priv->fri_button = _tmp6_;
	_tmp7_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Sat"));
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->sat_button);
	self->priv->sat_button = _tmp7_;
	_tmp8_ = (GtkToggleButton*) gtk_toggle_button_new_with_label (_ ("Sun"));
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->sun_button);
	self->priv->sun_button = _tmp8_;
	_tmp9_ = self->priv->week_box;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_add_class (_tmp10_, GTK_STYLE_CLASS_LINKED);
	_tmp11_ = self->priv->week_box;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	gtk_style_context_add_class (_tmp12_, "raised");
	_tmp13_ = calendar_event_store_get_default ();
	_tmp14_ = _tmp13_;
	_tmp15_ = calendar_event_store_get_week_starts_on (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp14_);
	switch (_tmp17_) {
		case G_DATE_TUESDAY:
		{
			GtkBox* _tmp18_;
			GtkToggleButton* _tmp19_;
			GtkBox* _tmp20_;
			GtkToggleButton* _tmp21_;
			GtkBox* _tmp22_;
			GtkToggleButton* _tmp23_;
			GtkBox* _tmp24_;
			GtkToggleButton* _tmp25_;
			GtkBox* _tmp26_;
			GtkToggleButton* _tmp27_;
			GtkBox* _tmp28_;
			GtkToggleButton* _tmp29_;
			GtkBox* _tmp30_;
			GtkToggleButton* _tmp31_;
			_tmp18_ = self->priv->week_box;
			_tmp19_ = self->priv->thu_button;
			gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _tmp19_);
			_tmp20_ = self->priv->week_box;
			_tmp21_ = self->priv->fri_button;
			gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
			_tmp22_ = self->priv->week_box;
			_tmp23_ = self->priv->sat_button;
			gtk_container_add ((GtkContainer*) _tmp22_, (GtkWidget*) _tmp23_);
			_tmp24_ = self->priv->week_box;
			_tmp25_ = self->priv->sun_button;
			gtk_container_add ((GtkContainer*) _tmp24_, (GtkWidget*) _tmp25_);
			_tmp26_ = self->priv->week_box;
			_tmp27_ = self->priv->mon_button;
			gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
			_tmp28_ = self->priv->week_box;
			_tmp29_ = self->priv->tue_button;
			gtk_container_add ((GtkContainer*) _tmp28_, (GtkWidget*) _tmp29_);
			_tmp30_ = self->priv->week_box;
			_tmp31_ = self->priv->wed_button;
			gtk_container_add ((GtkContainer*) _tmp30_, (GtkWidget*) _tmp31_);
			break;
		}
		case G_DATE_WEDNESDAY:
		{
			GtkBox* _tmp32_;
			GtkToggleButton* _tmp33_;
			GtkBox* _tmp34_;
			GtkToggleButton* _tmp35_;
			GtkBox* _tmp36_;
			GtkToggleButton* _tmp37_;
			GtkBox* _tmp38_;
			GtkToggleButton* _tmp39_;
			GtkBox* _tmp40_;
			GtkToggleButton* _tmp41_;
			GtkBox* _tmp42_;
			GtkToggleButton* _tmp43_;
			GtkBox* _tmp44_;
			GtkToggleButton* _tmp45_;
			_tmp32_ = self->priv->week_box;
			_tmp33_ = self->priv->wed_button;
			gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
			_tmp34_ = self->priv->week_box;
			_tmp35_ = self->priv->thu_button;
			gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
			_tmp36_ = self->priv->week_box;
			_tmp37_ = self->priv->fri_button;
			gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _tmp37_);
			_tmp38_ = self->priv->week_box;
			_tmp39_ = self->priv->sat_button;
			gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp39_);
			_tmp40_ = self->priv->week_box;
			_tmp41_ = self->priv->sun_button;
			gtk_container_add ((GtkContainer*) _tmp40_, (GtkWidget*) _tmp41_);
			_tmp42_ = self->priv->week_box;
			_tmp43_ = self->priv->mon_button;
			gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
			_tmp44_ = self->priv->week_box;
			_tmp45_ = self->priv->tue_button;
			gtk_container_add ((GtkContainer*) _tmp44_, (GtkWidget*) _tmp45_);
			break;
		}
		case G_DATE_THURSDAY:
		{
			GtkBox* _tmp46_;
			GtkToggleButton* _tmp47_;
			GtkBox* _tmp48_;
			GtkToggleButton* _tmp49_;
			GtkBox* _tmp50_;
			GtkToggleButton* _tmp51_;
			GtkBox* _tmp52_;
			GtkToggleButton* _tmp53_;
			GtkBox* _tmp54_;
			GtkToggleButton* _tmp55_;
			GtkBox* _tmp56_;
			GtkToggleButton* _tmp57_;
			GtkBox* _tmp58_;
			GtkToggleButton* _tmp59_;
			_tmp46_ = self->priv->week_box;
			_tmp47_ = self->priv->thu_button;
			gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
			_tmp48_ = self->priv->week_box;
			_tmp49_ = self->priv->fri_button;
			gtk_container_add ((GtkContainer*) _tmp48_, (GtkWidget*) _tmp49_);
			_tmp50_ = self->priv->week_box;
			_tmp51_ = self->priv->sat_button;
			gtk_container_add ((GtkContainer*) _tmp50_, (GtkWidget*) _tmp51_);
			_tmp52_ = self->priv->week_box;
			_tmp53_ = self->priv->sun_button;
			gtk_container_add ((GtkContainer*) _tmp52_, (GtkWidget*) _tmp53_);
			_tmp54_ = self->priv->week_box;
			_tmp55_ = self->priv->mon_button;
			gtk_container_add ((GtkContainer*) _tmp54_, (GtkWidget*) _tmp55_);
			_tmp56_ = self->priv->week_box;
			_tmp57_ = self->priv->tue_button;
			gtk_container_add ((GtkContainer*) _tmp56_, (GtkWidget*) _tmp57_);
			_tmp58_ = self->priv->week_box;
			_tmp59_ = self->priv->wed_button;
			gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
			break;
		}
		case G_DATE_FRIDAY:
		{
			GtkBox* _tmp60_;
			GtkToggleButton* _tmp61_;
			GtkBox* _tmp62_;
			GtkToggleButton* _tmp63_;
			GtkBox* _tmp64_;
			GtkToggleButton* _tmp65_;
			GtkBox* _tmp66_;
			GtkToggleButton* _tmp67_;
			GtkBox* _tmp68_;
			GtkToggleButton* _tmp69_;
			GtkBox* _tmp70_;
			GtkToggleButton* _tmp71_;
			GtkBox* _tmp72_;
			GtkToggleButton* _tmp73_;
			_tmp60_ = self->priv->week_box;
			_tmp61_ = self->priv->fri_button;
			gtk_container_add ((GtkContainer*) _tmp60_, (GtkWidget*) _tmp61_);
			_tmp62_ = self->priv->week_box;
			_tmp63_ = self->priv->sat_button;
			gtk_container_add ((GtkContainer*) _tmp62_, (GtkWidget*) _tmp63_);
			_tmp64_ = self->priv->week_box;
			_tmp65_ = self->priv->sun_button;
			gtk_container_add ((GtkContainer*) _tmp64_, (GtkWidget*) _tmp65_);
			_tmp66_ = self->priv->week_box;
			_tmp67_ = self->priv->mon_button;
			gtk_container_add ((GtkContainer*) _tmp66_, (GtkWidget*) _tmp67_);
			_tmp68_ = self->priv->week_box;
			_tmp69_ = self->priv->tue_button;
			gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
			_tmp70_ = self->priv->week_box;
			_tmp71_ = self->priv->wed_button;
			gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp71_);
			_tmp72_ = self->priv->week_box;
			_tmp73_ = self->priv->thu_button;
			gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
			break;
		}
		case G_DATE_SATURDAY:
		{
			GtkBox* _tmp74_;
			GtkToggleButton* _tmp75_;
			GtkBox* _tmp76_;
			GtkToggleButton* _tmp77_;
			GtkBox* _tmp78_;
			GtkToggleButton* _tmp79_;
			GtkBox* _tmp80_;
			GtkToggleButton* _tmp81_;
			GtkBox* _tmp82_;
			GtkToggleButton* _tmp83_;
			GtkBox* _tmp84_;
			GtkToggleButton* _tmp85_;
			GtkBox* _tmp86_;
			GtkToggleButton* _tmp87_;
			_tmp74_ = self->priv->week_box;
			_tmp75_ = self->priv->sat_button;
			gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
			_tmp76_ = self->priv->week_box;
			_tmp77_ = self->priv->sun_button;
			gtk_container_add ((GtkContainer*) _tmp76_, (GtkWidget*) _tmp77_);
			_tmp78_ = self->priv->week_box;
			_tmp79_ = self->priv->mon_button;
			gtk_container_add ((GtkContainer*) _tmp78_, (GtkWidget*) _tmp79_);
			_tmp80_ = self->priv->week_box;
			_tmp81_ = self->priv->tue_button;
			gtk_container_add ((GtkContainer*) _tmp80_, (GtkWidget*) _tmp81_);
			_tmp82_ = self->priv->week_box;
			_tmp83_ = self->priv->wed_button;
			gtk_container_add ((GtkContainer*) _tmp82_, (GtkWidget*) _tmp83_);
			_tmp84_ = self->priv->week_box;
			_tmp85_ = self->priv->thu_button;
			gtk_container_add ((GtkContainer*) _tmp84_, (GtkWidget*) _tmp85_);
			_tmp86_ = self->priv->week_box;
			_tmp87_ = self->priv->fri_button;
			gtk_container_add ((GtkContainer*) _tmp86_, (GtkWidget*) _tmp87_);
			break;
		}
		case G_DATE_SUNDAY:
		{
			GtkBox* _tmp88_;
			GtkToggleButton* _tmp89_;
			GtkBox* _tmp90_;
			GtkToggleButton* _tmp91_;
			GtkBox* _tmp92_;
			GtkToggleButton* _tmp93_;
			GtkBox* _tmp94_;
			GtkToggleButton* _tmp95_;
			GtkBox* _tmp96_;
			GtkToggleButton* _tmp97_;
			GtkBox* _tmp98_;
			GtkToggleButton* _tmp99_;
			GtkBox* _tmp100_;
			GtkToggleButton* _tmp101_;
			_tmp88_ = self->priv->week_box;
			_tmp89_ = self->priv->sun_button;
			gtk_container_add ((GtkContainer*) _tmp88_, (GtkWidget*) _tmp89_);
			_tmp90_ = self->priv->week_box;
			_tmp91_ = self->priv->mon_button;
			gtk_container_add ((GtkContainer*) _tmp90_, (GtkWidget*) _tmp91_);
			_tmp92_ = self->priv->week_box;
			_tmp93_ = self->priv->tue_button;
			gtk_container_add ((GtkContainer*) _tmp92_, (GtkWidget*) _tmp93_);
			_tmp94_ = self->priv->week_box;
			_tmp95_ = self->priv->wed_button;
			gtk_container_add ((GtkContainer*) _tmp94_, (GtkWidget*) _tmp95_);
			_tmp96_ = self->priv->week_box;
			_tmp97_ = self->priv->thu_button;
			gtk_container_add ((GtkContainer*) _tmp96_, (GtkWidget*) _tmp97_);
			_tmp98_ = self->priv->week_box;
			_tmp99_ = self->priv->fri_button;
			gtk_container_add ((GtkContainer*) _tmp98_, (GtkWidget*) _tmp99_);
			_tmp100_ = self->priv->week_box;
			_tmp101_ = self->priv->sat_button;
			gtk_container_add ((GtkContainer*) _tmp100_, (GtkWidget*) _tmp101_);
			break;
		}
		default:
		{
			GtkBox* _tmp102_;
			GtkToggleButton* _tmp103_;
			GtkBox* _tmp104_;
			GtkToggleButton* _tmp105_;
			GtkBox* _tmp106_;
			GtkToggleButton* _tmp107_;
			GtkBox* _tmp108_;
			GtkToggleButton* _tmp109_;
			GtkBox* _tmp110_;
			GtkToggleButton* _tmp111_;
			GtkBox* _tmp112_;
			GtkToggleButton* _tmp113_;
			GtkBox* _tmp114_;
			GtkToggleButton* _tmp115_;
			_tmp102_ = self->priv->week_box;
			_tmp103_ = self->priv->mon_button;
			gtk_container_add ((GtkContainer*) _tmp102_, (GtkWidget*) _tmp103_);
			_tmp104_ = self->priv->week_box;
			_tmp105_ = self->priv->tue_button;
			gtk_container_add ((GtkContainer*) _tmp104_, (GtkWidget*) _tmp105_);
			_tmp106_ = self->priv->week_box;
			_tmp107_ = self->priv->wed_button;
			gtk_container_add ((GtkContainer*) _tmp106_, (GtkWidget*) _tmp107_);
			_tmp108_ = self->priv->week_box;
			_tmp109_ = self->priv->thu_button;
			gtk_container_add ((GtkContainer*) _tmp108_, (GtkWidget*) _tmp109_);
			_tmp110_ = self->priv->week_box;
			_tmp111_ = self->priv->fri_button;
			gtk_container_add ((GtkContainer*) _tmp110_, (GtkWidget*) _tmp111_);
			_tmp112_ = self->priv->week_box;
			_tmp113_ = self->priv->sat_button;
			gtk_container_add ((GtkContainer*) _tmp112_, (GtkWidget*) _tmp113_);
			_tmp114_ = self->priv->week_box;
			_tmp115_ = self->priv->sun_button;
			gtk_container_add ((GtkContainer*) _tmp114_, (GtkWidget*) _tmp115_);
			break;
		}
	}
}

static gshort
maya_view_event_edition_repeat_panel_encode_day (MayaViewEventEditionRepeatPanel* self,
                                                 ICalRecurrenceWeekday weekday,
                                                 gint position)
{
	gint _tmp0_ = 0;
	gshort result;
	g_return_val_if_fail (self != NULL, 0);
	if (position < 0) {
		_tmp0_ = -1;
	} else {
		_tmp0_ = 1;
	}
	result = (gshort) ((weekday + (8 * abs (position))) * _tmp0_);
	return result;
}

/**
     * Save the values in the dialog into the component.
     */
void
maya_view_event_edition_repeat_panel_save (MayaViewEventEditionRepeatPanel* self)
{
	ICalComponent* comp = NULL;
	MayaViewEventDialog* _tmp0_;
	ECalComponent* _tmp1_;
	ECalComponent* _tmp2_;
	ICalComponent* _tmp3_;
	gint count = 0;
	ICalComponent* _tmp4_;
	ICalProperty* remove_prop = NULL;
	ICalComponent* _tmp11_;
	ICalProperty* _tmp12_;
	ICalComponent* _tmp13_;
	ICalProperty* _tmp14_;
	GtkSwitch* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	ICalProperty* property = NULL;
	ICalProperty* _tmp18_;
	ICalRecurrence* rrule = NULL;
	ICalRecurrence* _tmp19_;
	GtkComboBoxText* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	GtkComboBoxText* _tmp78_;
	gint _tmp79_;
	gint _tmp80_;
	ICalRecurrence* _tmp97_;
	GtkSpinButton* _tmp98_;
	gdouble _tmp99_;
	gdouble _tmp100_;
	ICalProperty* _tmp101_;
	ICalRecurrence* _tmp102_;
	ICalComponent* _tmp103_;
	ICalProperty* _tmp104_;
	ICalComponent* _tmp105_;
	GtkListBox* _tmp112_;
	GList* _tmp113_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parent_dialog;
	_tmp1_ = maya_view_event_dialog_get_ecal (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = e_cal_component_get_icalcomponent (_tmp2_);
	comp = _tmp3_;
	_tmp4_ = comp;
	count = i_cal_component_count_properties (_tmp4_, I_CAL_RRULE_PROPERTY);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				ICalComponent* _tmp7_;
				ICalProperty* _tmp8_;
				ICalComponent* _tmp9_;
				ICalProperty* _tmp10_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp7_ = comp;
				_tmp8_ = i_cal_component_get_first_property (_tmp7_, I_CAL_RRULE_PROPERTY);
				_g_object_unref0 (remove_prop);
				remove_prop = _tmp8_;
				_tmp9_ = comp;
				_tmp10_ = remove_prop;
				i_cal_component_remove_property (_tmp9_, _tmp10_);
			}
		}
	}
	_tmp11_ = comp;
	_tmp12_ = i_cal_component_get_first_property (_tmp11_, I_CAL_RECURRENCEID_PROPERTY);
	_g_object_unref0 (remove_prop);
	remove_prop = _tmp12_;
	_tmp13_ = comp;
	_tmp14_ = remove_prop;
	i_cal_component_remove_property (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->repeat_switch;
	_tmp16_ = gtk_switch_get_active (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ == FALSE) {
		_g_object_unref0 (remove_prop);
		return;
	}
	_tmp18_ = i_cal_property_new (I_CAL_RRULE_PROPERTY);
	property = _tmp18_;
	_tmp19_ = i_cal_recurrence_new_from_string ("");
	rrule = _tmp19_;
	_tmp20_ = self->priv->repeat_combobox;
	_tmp21_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp20_);
	_tmp22_ = _tmp21_;
	switch (_tmp22_) {
		case 1:
		{
			ICalRecurrence* _tmp23_;
			GArray* array = NULL;
			GArray* _tmp24_;
			GtkToggleButton* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			GtkToggleButton* _tmp29_;
			gboolean _tmp30_;
			gboolean _tmp31_;
			GtkToggleButton* _tmp33_;
			gboolean _tmp34_;
			gboolean _tmp35_;
			GtkToggleButton* _tmp37_;
			gboolean _tmp38_;
			gboolean _tmp39_;
			GtkToggleButton* _tmp41_;
			gboolean _tmp42_;
			gboolean _tmp43_;
			GtkToggleButton* _tmp45_;
			gboolean _tmp46_;
			gboolean _tmp47_;
			GtkToggleButton* _tmp49_;
			gboolean _tmp50_;
			gboolean _tmp51_;
			ICalRecurrence* _tmp53_;
			GArray* _tmp54_;
			_tmp23_ = rrule;
			i_cal_recurrence_set_freq (_tmp23_, I_CAL_WEEKLY_RECURRENCE);
			_tmp24_ = g_array_new (FALSE, FALSE, sizeof (gshort));
			array = _tmp24_;
			_tmp25_ = self->priv->sun_button;
			_tmp26_ = gtk_toggle_button_get_active (_tmp25_);
			_tmp27_ = _tmp26_;
			if (_tmp27_ == TRUE) {
				gshort day = 0;
				GArray* _tmp28_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, I_CAL_SUNDAY_WEEKDAY, 0);
				_tmp28_ = array;
				g_array_append_val (_tmp28_, day);
			}
			_tmp29_ = self->priv->mon_button;
			_tmp30_ = gtk_toggle_button_get_active (_tmp29_);
			_tmp31_ = _tmp30_;
			if (_tmp31_ == TRUE) {
				gshort day = 0;
				GArray* _tmp32_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, I_CAL_MONDAY_WEEKDAY, 0);
				_tmp32_ = array;
				g_array_append_val (_tmp32_, day);
			}
			_tmp33_ = self->priv->tue_button;
			_tmp34_ = gtk_toggle_button_get_active (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ == TRUE) {
				gshort day = 0;
				GArray* _tmp36_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, I_CAL_TUESDAY_WEEKDAY, 0);
				_tmp36_ = array;
				g_array_append_val (_tmp36_, day);
			}
			_tmp37_ = self->priv->wed_button;
			_tmp38_ = gtk_toggle_button_get_active (_tmp37_);
			_tmp39_ = _tmp38_;
			if (_tmp39_ == TRUE) {
				gshort day = 0;
				GArray* _tmp40_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, I_CAL_WEDNESDAY_WEEKDAY, 0);
				_tmp40_ = array;
				g_array_append_val (_tmp40_, day);
			}
			_tmp41_ = self->priv->thu_button;
			_tmp42_ = gtk_toggle_button_get_active (_tmp41_);
			_tmp43_ = _tmp42_;
			if (_tmp43_ == TRUE) {
				gshort day = 0;
				GArray* _tmp44_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, I_CAL_THURSDAY_WEEKDAY, 0);
				_tmp44_ = array;
				g_array_append_val (_tmp44_, day);
			}
			_tmp45_ = self->priv->fri_button;
			_tmp46_ = gtk_toggle_button_get_active (_tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_ == TRUE) {
				gshort day = 0;
				GArray* _tmp48_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, I_CAL_FRIDAY_WEEKDAY, 0);
				_tmp48_ = array;
				g_array_append_val (_tmp48_, day);
			}
			_tmp49_ = self->priv->sat_button;
			_tmp50_ = gtk_toggle_button_get_active (_tmp49_);
			_tmp51_ = _tmp50_;
			if (_tmp51_ == TRUE) {
				gshort day = 0;
				GArray* _tmp52_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, I_CAL_SATURDAY_WEEKDAY, 0);
				_tmp52_ = array;
				g_array_append_val (_tmp52_, day);
			}
			_tmp53_ = rrule;
			_tmp54_ = array;
			i_cal_recurrence_set_by_day_array (_tmp53_, _tmp54_);
			_g_array_unref0 (array);
			break;
		}
		case 2:
		{
			ICalRecurrence* _tmp55_;
			GtkRadioButton* _tmp56_;
			gboolean _tmp57_;
			gboolean _tmp58_;
			_tmp55_ = rrule;
			i_cal_recurrence_set_freq (_tmp55_, I_CAL_MONTHLY_RECURRENCE);
			_tmp56_ = self->priv->every_radiobutton;
			_tmp57_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp56_);
			_tmp58_ = _tmp57_;
			if (_tmp58_ == TRUE) {
				GArray* array = NULL;
				GArray* _tmp59_;
				ICalRecurrenceWeekday weekday = 0;
				MayaViewEventDialog* _tmp60_;
				GDateTime* _tmp61_;
				GDateTime* _tmp62_;
				gshort day = 0;
				MayaViewEventDialog* _tmp63_;
				GDateTime* _tmp64_;
				GDateTime* _tmp65_;
				GArray* _tmp66_;
				ICalRecurrence* _tmp67_;
				GArray* _tmp68_;
				_tmp59_ = g_array_sized_new (FALSE, FALSE, sizeof (gshort), (guint) 1);
				array = _tmp59_;
				_tmp60_ = self->priv->parent_dialog;
				_tmp61_ = maya_view_event_dialog_get_date_time (_tmp60_);
				_tmp62_ = _tmp61_;
				switch (g_date_time_get_day_of_week (_tmp62_)) {
					case 2:
					{
						weekday = I_CAL_TUESDAY_WEEKDAY;
						break;
					}
					case 3:
					{
						weekday = I_CAL_WEDNESDAY_WEEKDAY;
						break;
					}
					case 4:
					{
						weekday = I_CAL_THURSDAY_WEEKDAY;
						break;
					}
					case 5:
					{
						weekday = I_CAL_FRIDAY_WEEKDAY;
						break;
					}
					case 6:
					{
						weekday = I_CAL_SATURDAY_WEEKDAY;
						break;
					}
					case 7:
					{
						weekday = I_CAL_SUNDAY_WEEKDAY;
						break;
					}
					default:
					{
						weekday = I_CAL_MONDAY_WEEKDAY;
						break;
					}
				}
				_tmp63_ = self->priv->parent_dialog;
				_tmp64_ = maya_view_event_dialog_get_date_time (_tmp63_);
				_tmp65_ = _tmp64_;
				day = maya_view_event_edition_repeat_panel_encode_day (self, weekday, (gint) ceil (((gdouble) g_date_time_get_day_of_month (_tmp65_)) / ((gdouble) 7)));
				_tmp66_ = array;
				g_array_append_val (_tmp66_, day);
				_tmp67_ = rrule;
				_tmp68_ = array;
				i_cal_recurrence_set_by_day_array (_tmp67_, _tmp68_);
				_g_array_unref0 (array);
			} else {
				GArray* array = NULL;
				GArray* _tmp69_;
				gshort day_of_month = 0;
				MayaViewEventDialog* _tmp70_;
				GDateTime* _tmp71_;
				GDateTime* _tmp72_;
				GArray* _tmp73_;
				ICalRecurrence* _tmp74_;
				GArray* _tmp75_;
				_tmp69_ = g_array_sized_new (FALSE, FALSE, sizeof (gshort), (guint) 1);
				array = _tmp69_;
				_tmp70_ = self->priv->parent_dialog;
				_tmp71_ = maya_view_event_dialog_get_date_time (_tmp70_);
				_tmp72_ = _tmp71_;
				day_of_month = (gshort) g_date_time_get_day_of_month (_tmp72_);
				_tmp73_ = array;
				g_array_append_val (_tmp73_, day_of_month);
				_tmp74_ = rrule;
				_tmp75_ = array;
				i_cal_recurrence_set_by_month_day_array (_tmp74_, _tmp75_);
				_g_array_unref0 (array);
			}
			break;
		}
		case 3:
		{
			ICalRecurrence* _tmp76_;
			_tmp76_ = rrule;
			i_cal_recurrence_set_freq (_tmp76_, I_CAL_YEARLY_RECURRENCE);
			break;
		}
		default:
		{
			ICalRecurrence* _tmp77_;
			_tmp77_ = rrule;
			i_cal_recurrence_set_freq (_tmp77_, I_CAL_DAILY_RECURRENCE);
			break;
		}
	}
	_tmp78_ = self->priv->ends_combobox;
	_tmp79_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp78_);
	_tmp80_ = _tmp79_;
	if (_tmp80_ == 2) {
		ICalRecurrence* _tmp81_;
		GtkSpinButton* _tmp82_;
		gdouble _tmp83_;
		gdouble _tmp84_;
		_tmp81_ = rrule;
		_tmp82_ = self->priv->end_entry;
		_tmp83_ = gtk_spin_button_get_value (_tmp82_);
		_tmp84_ = _tmp83_;
		i_cal_recurrence_set_count (_tmp81_, (gint) _tmp84_);
	} else {
		GtkComboBoxText* _tmp85_;
		gint _tmp86_;
		gint _tmp87_;
		_tmp85_ = self->priv->ends_combobox;
		_tmp86_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp85_);
		_tmp87_ = _tmp86_;
		if (_tmp87_ == 1) {
			ICalRecurrence* _tmp88_;
			GraniteWidgetsDatePicker* _tmp89_;
			GDateTime* _tmp90_;
			GDateTime* _tmp91_;
			GraniteWidgetsDatePicker* _tmp92_;
			GDateTime* _tmp93_;
			GDateTime* _tmp94_;
			ICalTime* _tmp95_;
			ICalTime* _tmp96_;
			_tmp88_ = rrule;
			_tmp89_ = self->priv->end_datepicker;
			_tmp90_ = granite_widgets_date_picker_get_date (_tmp89_);
			_tmp91_ = _tmp90_;
			_tmp92_ = self->priv->end_datepicker;
			_tmp93_ = granite_widgets_date_picker_get_date (_tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = i_cal_time_new_from_day_of_year (g_date_time_get_day_of_year (_tmp91_), g_date_time_get_year (_tmp94_));
			_tmp96_ = _tmp95_;
			i_cal_recurrence_set_until (_tmp88_, _tmp96_);
			_g_object_unref0 (_tmp96_);
		}
	}
	_tmp97_ = rrule;
	_tmp98_ = self->priv->every_entry;
	_tmp99_ = gtk_spin_button_get_value (_tmp98_);
	_tmp100_ = _tmp99_;
	i_cal_recurrence_set_interval (_tmp97_, (gshort) _tmp100_);
	_tmp101_ = property;
	_tmp102_ = rrule;
	i_cal_property_set_rrule (_tmp101_, _tmp102_);
	_tmp103_ = comp;
	_tmp104_ = property;
	i_cal_component_add_property (_tmp103_, _tmp104_);
	_tmp105_ = comp;
	count = i_cal_component_count_properties (_tmp105_, I_CAL_EXDATE_PROPERTY);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp106_ = FALSE;
			_tmp106_ = TRUE;
			while (TRUE) {
				ICalComponent* _tmp108_;
				ICalProperty* _tmp109_;
				ICalComponent* _tmp110_;
				ICalProperty* _tmp111_;
				if (!_tmp106_) {
					gint _tmp107_;
					_tmp107_ = i;
					i = _tmp107_ + 1;
				}
				_tmp106_ = FALSE;
				if (!(i < count)) {
					break;
				}
				_tmp108_ = comp;
				_tmp109_ = i_cal_component_get_first_property (_tmp108_, I_CAL_EXDATE_PROPERTY);
				_g_object_unref0 (remove_prop);
				remove_prop = _tmp109_;
				_tmp110_ = comp;
				_tmp111_ = remove_prop;
				i_cal_component_remove_property (_tmp110_, _tmp111_);
			}
		}
	}
	_tmp112_ = self->priv->exceptions_list;
	_tmp113_ = gtk_container_get_children ((GtkContainer*) _tmp112_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp113_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GtkWidget* _tmp114_;
				MayaViewEventEditionExceptionGrid* exgrid = NULL;
				GtkWidget* _tmp115_;
				MayaViewEventEditionExceptionGrid* _tmp116_;
				GDateTime* date = NULL;
				MayaViewEventEditionExceptionGrid* _tmp117_;
				GDateTime* _tmp118_;
				ICalProperty* exdate = NULL;
				ICalProperty* _tmp119_;
				ICalProperty* _tmp120_;
				GDateTime* _tmp121_;
				CalendarTimeManager* _tmp122_;
				ICalTimezone* _tmp123_;
				ICalTimezone* _tmp124_;
				ICalTime* _tmp125_;
				ICalTime* _tmp126_;
				ICalComponent* _tmp127_;
				ICalProperty* _tmp128_;
				_tmp114_ = child;
				if (MAYA_VIEW_EVENT_EDITION_IS_EXCEPTION_GRID (_tmp114_) == FALSE) {
					continue;
				}
				_tmp115_ = child;
				_tmp116_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID, MayaViewEventEditionExceptionGrid));
				exgrid = _tmp116_;
				_tmp117_ = exgrid;
				_tmp118_ = maya_view_event_edition_exception_grid_get_date (_tmp117_);
				date = _tmp118_;
				_tmp119_ = i_cal_property_new (I_CAL_EXDATE_PROPERTY);
				exdate = _tmp119_;
				_tmp120_ = exdate;
				_tmp121_ = date;
				_tmp122_ = calendar_time_manager_get_default ();
				_tmp123_ = calendar_time_manager_get_system_timezone (_tmp122_);
				_tmp124_ = _tmp123_;
				_tmp125_ = calendar_util_datetimes_to_icaltime (_tmp121_, NULL, _tmp124_);
				_tmp126_ = _tmp125_;
				i_cal_property_set_exdate (_tmp120_, _tmp126_);
				_g_object_unref0 (_tmp126_);
				_tmp127_ = comp;
				_tmp128_ = exdate;
				i_cal_component_add_property (_tmp127_, _tmp128_);
				_g_object_unref0 (exdate);
				_g_date_time_unref0 (date);
				_g_object_unref0 (exgrid);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_g_object_unref0 (rrule);
	_g_object_unref0 (property);
	_g_object_unref0 (remove_prop);
}

static void
maya_view_event_edition_repeat_panel_class_init (MayaViewEventEditionRepeatPanelClass * klass,
                                                 gpointer klass_data)
{
	maya_view_event_edition_repeat_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewEventEditionRepeatPanel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_view_event_edition_repeat_panel_finalize;
}

static void
maya_view_event_edition_repeat_panel_instance_init (MayaViewEventEditionRepeatPanel * self,
                                                    gpointer klass)
{
	self->priv = maya_view_event_edition_repeat_panel_get_instance_private (self);
}

static void
maya_view_event_edition_repeat_panel_finalize (GObject * obj)
{
	MayaViewEventEditionRepeatPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_EVENT_EDITION_TYPE_REPEAT_PANEL, MayaViewEventEditionRepeatPanel);
	_g_object_unref0 (self->priv->parent_dialog);
	_g_object_unref0 (self->priv->repeat_switch);
	_g_object_unref0 (self->priv->repeat_combobox);
	_g_object_unref0 (self->priv->ends_combobox);
	_g_object_unref0 (self->priv->end_entry);
	_g_object_unref0 (self->priv->end_datepicker);
	_g_object_unref0 (self->priv->week_box);
	_g_object_unref0 (self->priv->month_grid);
	_g_object_unref0 (self->priv->every_entry);
	_g_object_unref0 (self->priv->every_unit_label);
	_g_object_unref0 (self->priv->exceptions_list);
	_g_object_unref0 (self->priv->mon_button);
	_g_object_unref0 (self->priv->tue_button);
	_g_object_unref0 (self->priv->wed_button);
	_g_object_unref0 (self->priv->thu_button);
	_g_object_unref0 (self->priv->fri_button);
	_g_object_unref0 (self->priv->sat_button);
	_g_object_unref0 (self->priv->sun_button);
	_g_object_unref0 (self->priv->every_radiobutton);
	_g_object_unref0 (self->priv->same_radiobutton);
	G_OBJECT_CLASS (maya_view_event_edition_repeat_panel_parent_class)->finalize (obj);
}

static GType
maya_view_event_edition_repeat_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewEventEditionRepeatPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_event_edition_repeat_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewEventEditionRepeatPanel), 0, (GInstanceInitFunc) maya_view_event_edition_repeat_panel_instance_init, NULL };
	GType maya_view_event_edition_repeat_panel_type_id;
	maya_view_event_edition_repeat_panel_type_id = g_type_register_static (gtk_grid_get_type (), "MayaViewEventEditionRepeatPanel", &g_define_type_info, 0);
	MayaViewEventEditionRepeatPanel_private_offset = g_type_add_instance_private (maya_view_event_edition_repeat_panel_type_id, sizeof (MayaViewEventEditionRepeatPanelPrivate));
	return maya_view_event_edition_repeat_panel_type_id;
}

GType
maya_view_event_edition_repeat_panel_get_type (void)
{
	static volatile gsize maya_view_event_edition_repeat_panel_type_id__once = 0;
	if (g_once_init_enter (&maya_view_event_edition_repeat_panel_type_id__once)) {
		GType maya_view_event_edition_repeat_panel_type_id;
		maya_view_event_edition_repeat_panel_type_id = maya_view_event_edition_repeat_panel_get_type_once ();
		g_once_init_leave (&maya_view_event_edition_repeat_panel_type_id__once, maya_view_event_edition_repeat_panel_type_id);
	}
	return maya_view_event_edition_repeat_panel_type_id__once;
}

static inline gpointer
maya_view_event_edition_exception_grid_get_instance_private (MayaViewEventEditionExceptionGrid* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewEventEditionExceptionGrid_private_offset);
}

static void
__lambda52_ (MayaViewEventEditionExceptionGrid* self)
{
	gtk_widget_hide ((GtkWidget*) self);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda52__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda52_ ((MayaViewEventEditionExceptionGrid*) self);
}

MayaViewEventEditionExceptionGrid*
maya_view_event_edition_exception_grid_construct (GType object_type,
                                                  GDateTime* dt)
{
	MayaViewEventEditionExceptionGrid * self = NULL;
	GraniteWidgetsDatePicker* _tmp0_;
	GraniteWidgetsDatePicker* _tmp1_;
	GraniteWidgetsDatePicker* _tmp2_;
	GtkButton* remove_button = NULL;
	GtkButton* _tmp3_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp4_;
	GraniteWidgetsDatePicker* _tmp5_;
	g_return_val_if_fail (dt != NULL, NULL);
	self = (MayaViewEventEditionExceptionGrid*) g_object_new (object_type, NULL);
	gtk_widget_set_margin_top ((GtkWidget*) self, 6);
	gtk_widget_set_margin_start ((GtkWidget*) self, 6);
	gtk_widget_set_margin_end ((GtkWidget*) self, 6);
	_tmp0_ = granite_widgets_date_picker_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->date);
	self->priv->date = _tmp0_;
	_tmp1_ = self->priv->date;
	granite_widgets_date_picker_set_date (_tmp1_, dt);
	_tmp2_ = self->priv->date;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp3_);
	remove_button = _tmp3_;
	gtk_button_set_relief (remove_button, GTK_RELIEF_NONE);
	g_signal_connect_object (remove_button, "clicked", (GCallback) ___lambda52__gtk_button_clicked, self, 0);
	_tmp4_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp4_);
	grid = _tmp4_;
	gtk_grid_set_row_spacing (grid, 6);
	gtk_grid_set_column_spacing (grid, 12);
	_tmp5_ = self->priv->date;
	gtk_grid_attach (grid, (GtkWidget*) _tmp5_, 0, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) remove_button, 2, 0, 1, 1);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_g_object_unref0 (grid);
	_g_object_unref0 (remove_button);
	return self;
}

MayaViewEventEditionExceptionGrid*
maya_view_event_edition_exception_grid_new (GDateTime* dt)
{
	return maya_view_event_edition_exception_grid_construct (MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID, dt);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

GDateTime*
maya_view_event_edition_exception_grid_get_date (MayaViewEventEditionExceptionGrid* self)
{
	GraniteWidgetsDatePicker* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->date;
	_tmp1_ = granite_widgets_date_picker_get_date (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_date_time_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
maya_view_event_edition_exception_grid_class_init (MayaViewEventEditionExceptionGridClass * klass,
                                                   gpointer klass_data)
{
	maya_view_event_edition_exception_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewEventEditionExceptionGrid_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_view_event_edition_exception_grid_finalize;
}

static void
maya_view_event_edition_exception_grid_instance_init (MayaViewEventEditionExceptionGrid * self,
                                                      gpointer klass)
{
	self->priv = maya_view_event_edition_exception_grid_get_instance_private (self);
}

static void
maya_view_event_edition_exception_grid_finalize (GObject * obj)
{
	MayaViewEventEditionExceptionGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_EVENT_EDITION_TYPE_EXCEPTION_GRID, MayaViewEventEditionExceptionGrid);
	_g_object_unref0 (self->priv->date);
	G_OBJECT_CLASS (maya_view_event_edition_exception_grid_parent_class)->finalize (obj);
}

static GType
maya_view_event_edition_exception_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewEventEditionExceptionGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_event_edition_exception_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewEventEditionExceptionGrid), 0, (GInstanceInitFunc) maya_view_event_edition_exception_grid_instance_init, NULL };
	GType maya_view_event_edition_exception_grid_type_id;
	maya_view_event_edition_exception_grid_type_id = g_type_register_static (gtk_list_box_row_get_type (), "MayaViewEventEditionExceptionGrid", &g_define_type_info, 0);
	MayaViewEventEditionExceptionGrid_private_offset = g_type_add_instance_private (maya_view_event_edition_exception_grid_type_id, sizeof (MayaViewEventEditionExceptionGridPrivate));
	return maya_view_event_edition_exception_grid_type_id;
}

GType
maya_view_event_edition_exception_grid_get_type (void)
{
	static volatile gsize maya_view_event_edition_exception_grid_type_id__once = 0;
	if (g_once_init_enter (&maya_view_event_edition_exception_grid_type_id__once)) {
		GType maya_view_event_edition_exception_grid_type_id;
		maya_view_event_edition_exception_grid_type_id = maya_view_event_edition_exception_grid_get_type_once ();
		g_once_init_leave (&maya_view_event_edition_exception_grid_type_id__once, maya_view_event_edition_exception_grid_type_id);
	}
	return maya_view_event_edition_exception_grid_type_id__once;
}

