/* ReminderPanel.c generated by valac 0.56.16, the Vala compiler
 * generated from ReminderPanel.vala, do not modify */

/*
 * Copyright 2011-2020 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Jaap Broekhuizen
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <granite.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <libecal/libecal.h>
#include <libical-glib/libical-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL (maya_view_event_edition_reminder_panel_get_type ())
#define MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, MayaViewEventEditionReminderPanel))
#define MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, MayaViewEventEditionReminderPanelClass))
#define MAYA_VIEW_EVENT_EDITION_IS_REMINDER_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL))
#define MAYA_VIEW_EVENT_EDITION_IS_REMINDER_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL))
#define MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, MayaViewEventEditionReminderPanelClass))

typedef struct _MayaViewEventEditionReminderPanel MayaViewEventEditionReminderPanel;
typedef struct _MayaViewEventEditionReminderPanelClass MayaViewEventEditionReminderPanelClass;
typedef struct _MayaViewEventEditionReminderPanelPrivate MayaViewEventEditionReminderPanelPrivate;

#define MAYA_VIEW_TYPE_EVENT_DIALOG (maya_view_event_dialog_get_type ())
#define MAYA_VIEW_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialog))
#define MAYA_VIEW_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))
#define MAYA_VIEW_IS_EVENT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_IS_EVENT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_TYPE_EVENT_DIALOG))
#define MAYA_VIEW_EVENT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_TYPE_EVENT_DIALOG, MayaViewEventDialogClass))

typedef struct _MayaViewEventDialog MayaViewEventDialog;
typedef struct _MayaViewEventDialogClass MayaViewEventDialogClass;

#define MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID (maya_view_event_edition_reminder_grid_get_type ())
#define MAYA_VIEW_EVENT_EDITION_REMINDER_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID, MayaViewEventEditionReminderGrid))
#define MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID, MayaViewEventEditionReminderGridClass))
#define MAYA_VIEW_EVENT_EDITION_IS_REMINDER_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID))
#define MAYA_VIEW_EVENT_EDITION_IS_REMINDER_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID))
#define MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID, MayaViewEventEditionReminderGridClass))

typedef struct _MayaViewEventEditionReminderGrid MayaViewEventEditionReminderGrid;
typedef struct _MayaViewEventEditionReminderGridClass MayaViewEventEditionReminderGridClass;
enum  {
	MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL_0_PROPERTY,
	MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL_NUM_PROPERTIES
};
static GParamSpec* maya_view_event_edition_reminder_panel_properties[MAYA_VIEW_EVENT_EDITION_REMINDER_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _MayaViewEventDialogPrivate MayaViewEventDialogPrivate;
typedef struct _Block15Data Block15Data;
typedef struct _MayaViewEventEditionReminderGridPrivate MayaViewEventEditionReminderGridPrivate;
#define __vala_ECalComponentAlarmTrigger_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentAlarmTrigger_free (var), NULL)))
#define __vala_ECalComponentAlarm_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentAlarm_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_0_PROPERTY,
	MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_NUM_PROPERTIES
};
static GParamSpec* maya_view_event_edition_reminder_grid_properties[MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_NUM_PROPERTIES];
enum  {
	MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_REMOVED_SIGNAL,
	MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_NUM_SIGNALS
};
static guint maya_view_event_edition_reminder_grid_signals[MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_NUM_SIGNALS] = {0};

struct _MayaViewEventEditionReminderPanel {
	GtkGrid parent_instance;
	MayaViewEventEditionReminderPanelPrivate * priv;
};

struct _MayaViewEventEditionReminderPanelClass {
	GtkGridClass parent_class;
};

struct _MayaViewEventEditionReminderPanelPrivate {
	MayaViewEventDialog* parent_dialog;
	GeeArrayList* reminders;
	GeeArrayList* reminders_to_remove;
	GtkListBox* reminder_list;
};

struct _MayaViewEventDialog {
	GraniteDialog parent_instance;
	MayaViewEventDialogPrivate * priv;
	gboolean can_edit;
};

struct _MayaViewEventDialogClass {
	GraniteDialogClass parent_class;
};

struct _Block15Data {
	int _ref_count_;
	MayaViewEventEditionReminderPanel* self;
	MayaViewEventEditionReminderGrid* reminder;
};

struct _MayaViewEventEditionReminderGrid {
	GtkListBoxRow parent_instance;
	MayaViewEventEditionReminderGridPrivate * priv;
	gboolean change;
	gchar* uid;
};

struct _MayaViewEventEditionReminderGridClass {
	GtkListBoxRowClass parent_class;
};

struct _MayaViewEventEditionReminderGridPrivate {
	gboolean is_human_change;
	GtkComboBoxText* time;
};

static gint MayaViewEventEditionReminderPanel_private_offset;
static gpointer maya_view_event_edition_reminder_panel_parent_class = NULL;
static gint MayaViewEventEditionReminderGrid_private_offset;
static gpointer maya_view_event_edition_reminder_grid_parent_class = NULL;

VALA_EXTERN GType maya_view_event_edition_reminder_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionReminderPanel, g_object_unref)
VALA_EXTERN GType maya_view_event_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventDialog, g_object_unref)
VALA_EXTERN GType maya_view_event_edition_reminder_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MayaViewEventEditionReminderGrid, g_object_unref)
VALA_EXTERN MayaViewEventEditionReminderPanel* maya_view_event_edition_reminder_panel_new (MayaViewEventDialog* parent_dialog);
VALA_EXTERN MayaViewEventEditionReminderPanel* maya_view_event_edition_reminder_panel_construct (GType object_type,
                                                                                     MayaViewEventDialog* parent_dialog);
static void maya_view_event_edition_reminder_panel_load (MayaViewEventEditionReminderPanel* self);
static void __lambda46_ (MayaViewEventEditionReminderPanel* self);
static MayaViewEventEditionReminderGrid* maya_view_event_edition_reminder_panel_add_reminder (MayaViewEventEditionReminderPanel* self,
                                                                                       const gchar* uid);
static void ___lambda46__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
VALA_EXTERN MayaViewEventEditionReminderGrid* maya_view_event_edition_reminder_grid_new (const gchar* uid);
VALA_EXTERN MayaViewEventEditionReminderGrid* maya_view_event_edition_reminder_grid_construct (GType object_type,
                                                                                   const gchar* uid);
static void __lambda45_ (Block15Data* _data15_);
static void ___lambda45__maya_view_event_edition_reminder_grid_removed (MayaViewEventEditionReminderGrid* _sender,
                                                                 gpointer self);
VALA_EXTERN ECalComponent* maya_view_event_dialog_get_ecal (MayaViewEventDialog* self);
static ECalComponentAlarmTrigger* _vala_ECalComponentAlarmTrigger_copy (ECalComponentAlarmTrigger* self);
static void _vala_ECalComponentAlarmTrigger_free (ECalComponentAlarmTrigger* self);
VALA_EXTERN void maya_view_event_edition_reminder_grid_set_duration (MayaViewEventEditionReminderGrid* self,
                                                         ICalDuration* duration);
static void _vala_ECalComponentAlarm_free (ECalComponentAlarm* self);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
VALA_EXTERN void maya_view_event_edition_reminder_panel_save (MayaViewEventEditionReminderPanel* self);
VALA_EXTERN ICalDuration* maya_view_event_edition_reminder_grid_get_duration (MayaViewEventEditionReminderGrid* self);
static void maya_view_event_edition_reminder_panel_finalize (GObject * obj);
static GType maya_view_event_edition_reminder_panel_get_type_once (void);
static void __lambda43_ (MayaViewEventEditionReminderGrid* self);
static void ___lambda43__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static void __lambda44_ (MayaViewEventEditionReminderGrid* self);
static void ___lambda44__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void maya_view_event_edition_reminder_grid_finalize (GObject * obj);
static GType maya_view_event_edition_reminder_grid_get_type_once (void);

static inline gpointer
maya_view_event_edition_reminder_panel_get_instance_private (MayaViewEventEditionReminderPanel* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewEventEditionReminderPanel_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda46_ (MayaViewEventEditionReminderPanel* self)
{
	MayaViewEventEditionReminderGrid* _tmp0_;
	MayaViewEventEditionReminderGrid* _tmp1_;
	_tmp0_ = maya_view_event_edition_reminder_panel_add_reminder (self, "");
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}

static void
___lambda46__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda46_ ((MayaViewEventEditionReminderPanel*) self);
}

MayaViewEventEditionReminderPanel*
maya_view_event_edition_reminder_panel_construct (GType object_type,
                                                  MayaViewEventDialog* parent_dialog)
{
	MayaViewEventEditionReminderPanel * self = NULL;
	MayaViewEventDialog* _tmp0_;
	GraniteHeaderLabel* reminder_label = NULL;
	GraniteHeaderLabel* _tmp1_;
	GtkLabel* no_reminder_label = NULL;
	GtkLabel* _tmp2_;
	GtkStyleContext* no_reminder_context = NULL;
	GtkStyleContext* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GtkListBox* _tmp9_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp10_;
	GtkListBox* _tmp11_;
	GtkButton* add_button = NULL;
	GtkButton* _tmp12_;
	GtkImage* _tmp13_;
	GtkImage* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkActionBar* inline_toolbar = NULL;
	GtkActionBar* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp18_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp19_;
	g_return_val_if_fail (parent_dialog != NULL, NULL);
	self = (MayaViewEventEditionReminderPanel*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (parent_dialog);
	_g_object_unref0 (self->priv->parent_dialog);
	self->priv->parent_dialog = _tmp0_;
	g_object_set ((GtkWidget*) self, "expand", TRUE, NULL);
	gtk_widget_set_margin_end ((GtkWidget*) self, 12);
	gtk_widget_set_margin_start ((GtkWidget*) self, 12);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_sensitive ((GtkWidget*) self, parent_dialog->can_edit);
	_tmp1_ = granite_header_label_new (_ ("Reminders:"));
	g_object_ref_sink (_tmp1_);
	reminder_label = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_ ("No Reminders"));
	g_object_ref_sink (_tmp2_);
	no_reminder_label = _tmp2_;
	gtk_widget_show ((GtkWidget*) no_reminder_label);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) no_reminder_label);
	no_reminder_context = _tmp3_;
	gtk_style_context_add_class (no_reminder_context, GRANITE_STYLE_CLASS_H3_LABEL);
	gtk_style_context_add_class (no_reminder_context, GTK_STYLE_CLASS_DIM_LABEL);
	_tmp4_ = gee_array_list_new (MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->reminders);
	self->priv->reminders = _tmp4_;
	_tmp5_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->reminders_to_remove);
	self->priv->reminders_to_remove = _tmp5_;
	_tmp6_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->reminder_list);
	self->priv->reminder_list = _tmp6_;
	_tmp7_ = self->priv->reminder_list;
	g_object_set ((GtkWidget*) _tmp7_, "expand", TRUE, NULL);
	_tmp8_ = self->priv->reminder_list;
	gtk_list_box_set_selection_mode (_tmp8_, GTK_SELECTION_NONE);
	_tmp9_ = self->priv->reminder_list;
	gtk_list_box_set_placeholder (_tmp9_, (GtkWidget*) no_reminder_label);
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp10_);
	scrolled = _tmp10_;
	_tmp11_ = self->priv->reminder_list;
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) _tmp11_);
	g_object_set ((GtkWidget*) scrolled, "expand", TRUE, NULL);
	_tmp12_ = (GtkButton*) gtk_button_new_with_label (_ ("Add Reminder"));
	g_object_ref_sink (_tmp12_);
	add_button = _tmp12_;
	gtk_button_set_always_show_image (add_button, TRUE);
	_tmp13_ = (GtkImage*) gtk_image_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	gtk_button_set_image (add_button, (GtkWidget*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_set ((GtkWidget*) add_button, "margin", 3, NULL);
	_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) add_button);
	gtk_style_context_add_class (_tmp15_, GTK_STYLE_CLASS_FLAT);
	_tmp16_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp16_);
	inline_toolbar = _tmp16_;
	_tmp17_ = gtk_widget_get_style_context ((GtkWidget*) inline_toolbar);
	gtk_style_context_add_class (_tmp17_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	gtk_container_add ((GtkContainer*) inline_toolbar, (GtkWidget*) add_button);
	_tmp18_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp18_);
	grid = _tmp18_;
	gtk_grid_attach (grid, (GtkWidget*) scrolled, 0, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) inline_toolbar, 0, 1, 1, 1);
	_tmp19_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp19_);
	frame = _tmp19_;
	gtk_widget_set_margin_top ((GtkWidget*) frame, 6);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) grid);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) reminder_label);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) frame);
	maya_view_event_edition_reminder_panel_load (self);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda46__gtk_button_clicked, self, 0);
	_g_object_unref0 (frame);
	_g_object_unref0 (grid);
	_g_object_unref0 (inline_toolbar);
	_g_object_unref0 (add_button);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (no_reminder_label);
	_g_object_unref0 (reminder_label);
	return self;
}

MayaViewEventEditionReminderPanel*
maya_view_event_edition_reminder_panel_new (MayaViewEventDialog* parent_dialog)
{
	return maya_view_event_edition_reminder_panel_construct (MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, parent_dialog);
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		MayaViewEventEditionReminderPanel* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->reminder);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}

static void
__lambda45_ (Block15Data* _data15_)
{
	MayaViewEventEditionReminderPanel* self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	const gchar* _tmp2_;
	self = _data15_->self;
	_tmp0_ = self->priv->reminders;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _data15_->reminder);
	_tmp1_ = self->priv->reminders_to_remove;
	_tmp2_ = _data15_->reminder->uid;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
}

static void
___lambda45__maya_view_event_edition_reminder_grid_removed (MayaViewEventEditionReminderGrid* _sender,
                                                            gpointer self)
{
	__lambda45_ (self);
}

static MayaViewEventEditionReminderGrid*
maya_view_event_edition_reminder_panel_add_reminder (MayaViewEventEditionReminderPanel* self,
                                                     const gchar* uid)
{
	Block15Data* _data15_;
	MayaViewEventEditionReminderGrid* _tmp0_;
	GtkListBox* _tmp1_;
	GeeArrayList* _tmp2_;
	MayaViewEventEditionReminderGrid* _tmp3_;
	MayaViewEventEditionReminderGrid* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = maya_view_event_edition_reminder_grid_new (uid);
	g_object_ref_sink (_tmp0_);
	_data15_->reminder = _tmp0_;
	gtk_widget_show_all ((GtkWidget*) _data15_->reminder);
	_tmp1_ = self->priv->reminder_list;
	gtk_container_add ((GtkContainer*) _tmp1_, (GtkWidget*) _data15_->reminder);
	_tmp2_ = self->priv->reminders;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _data15_->reminder);
	g_signal_connect_data (_data15_->reminder, "removed", (GCallback) ___lambda45__maya_view_event_edition_reminder_grid_removed, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
	_tmp3_ = _g_object_ref0 (_data15_->reminder);
	result = _tmp3_;
	block15_data_unref (_data15_);
	_data15_ = NULL;
	return result;
}

static ECalComponentAlarmTrigger*
_vala_ECalComponentAlarmTrigger_copy (ECalComponentAlarmTrigger* self)
{
	return g_boxed_copy (e_cal_component_alarm_trigger_get_type (), self);
}

static gpointer
__vala_ECalComponentAlarmTrigger_copy0 (gpointer self)
{
	return self ? _vala_ECalComponentAlarmTrigger_copy (self) : NULL;
}

static void
_vala_ECalComponentAlarmTrigger_free (ECalComponentAlarmTrigger* self)
{
	g_boxed_free (e_cal_component_alarm_trigger_get_type (), self);
}

static void
_vala_ECalComponentAlarm_free (ECalComponentAlarm* self)
{
	g_boxed_free (e_cal_component_alarm_get_type (), self);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
maya_view_event_edition_reminder_panel_load (MayaViewEventEditionReminderPanel* self)
{
	MayaViewEventDialog* _tmp0_;
	ECalComponent* _tmp1_;
	ECalComponent* _tmp2_;
	MayaViewEventDialog* _tmp3_;
	ECalComponent* _tmp4_;
	ECalComponent* _tmp5_;
	GSList* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->parent_dialog;
	_tmp1_ = maya_view_event_dialog_get_ecal (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		return;
	}
	_tmp3_ = self->priv->parent_dialog;
	_tmp4_ = maya_view_event_dialog_get_ecal (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_cal_component_get_alarm_uids (_tmp5_);
	{
		GSList* alarm_uid_collection = NULL;
		GSList* alarm_uid_it = NULL;
		alarm_uid_collection = _tmp6_;
		for (alarm_uid_it = alarm_uid_collection; alarm_uid_it != NULL; alarm_uid_it = alarm_uid_it->next) {
			gchar* _tmp7_;
			gchar* alarm_uid = NULL;
			_tmp7_ = g_strdup ((const gchar*) alarm_uid_it->data);
			alarm_uid = _tmp7_;
			{
				ECalComponentAlarm* e_alarm = NULL;
				MayaViewEventDialog* _tmp8_;
				ECalComponent* _tmp9_;
				ECalComponent* _tmp10_;
				const gchar* _tmp11_;
				ECalComponentAlarm* _tmp12_;
				ECalComponentAlarmAction action = 0;
				ECalComponentAlarm* _tmp13_;
				_tmp8_ = self->priv->parent_dialog;
				_tmp9_ = maya_view_event_dialog_get_ecal (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = alarm_uid;
				_tmp12_ = e_cal_component_get_alarm (_tmp10_, _tmp11_);
				e_alarm = _tmp12_;
				_tmp13_ = e_alarm;
				action = e_cal_component_alarm_get_action (_tmp13_);
				switch (action) {
					case E_CAL_COMPONENT_ALARM_DISPLAY:
					{
						ECalComponentAlarmTrigger* trigger = NULL;
						ECalComponentAlarm* _tmp14_;
						ECalComponentAlarmTrigger* _tmp15_;
						ECalComponentAlarmTrigger* _tmp16_;
						ECalComponentAlarmTrigger* _tmp17_;
						_tmp14_ = e_alarm;
						_tmp15_ = e_cal_component_alarm_get_trigger (_tmp14_);
						_tmp16_ = __vala_ECalComponentAlarmTrigger_copy0 (_tmp15_);
						__vala_ECalComponentAlarmTrigger_free0 (trigger);
						trigger = _tmp16_;
						_tmp17_ = trigger;
						if (e_cal_component_alarm_trigger_get_kind (_tmp17_) == E_CAL_COMPONENT_ALARM_TRIGGER_RELATIVE_START) {
							ICalDuration* duration = NULL;
							ECalComponentAlarmTrigger* _tmp18_;
							ICalDuration* _tmp19_;
							ICalDuration* _tmp20_;
							MayaViewEventEditionReminderGrid* reminder = NULL;
							const gchar* _tmp21_;
							MayaViewEventEditionReminderGrid* _tmp22_;
							MayaViewEventEditionReminderGrid* _tmp23_;
							ICalDuration* _tmp24_;
							_tmp18_ = trigger;
							_tmp19_ = e_cal_component_alarm_trigger_get_duration (_tmp18_);
							_tmp20_ = _g_object_ref0 (_tmp19_);
							duration = _tmp20_;
							_tmp21_ = alarm_uid;
							_tmp22_ = maya_view_event_edition_reminder_panel_add_reminder (self, _tmp21_);
							reminder = _tmp22_;
							_tmp23_ = reminder;
							_tmp24_ = duration;
							maya_view_event_edition_reminder_grid_set_duration (_tmp23_, _tmp24_);
							_g_object_unref0 (reminder);
							_g_object_unref0 (duration);
						}
						__vala_ECalComponentAlarmTrigger_free0 (trigger);
						__vala_ECalComponentAlarm_free0 (e_alarm);
						_g_free0 (alarm_uid);
						continue;
					}
					default:
					{
						__vala_ECalComponentAlarm_free0 (e_alarm);
						_g_free0 (alarm_uid);
						continue;
					}
				}
				__vala_ECalComponentAlarm_free0 (e_alarm);
				_g_free0 (alarm_uid);
			}
		}
		(alarm_uid_collection == NULL) ? NULL : (alarm_uid_collection = (_g_slist_free__g_free0_ (alarm_uid_collection), NULL));
	}
}

/**
     * Save the values in the dialog into the component.
     */
void
maya_view_event_edition_reminder_panel_save (MayaViewEventEditionReminderPanel* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _reminder_list = NULL;
		GeeArrayList* _tmp0_;
		gint _reminder_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _reminder_index = 0;
		_tmp0_ = self->priv->reminders;
		_reminder_list = _tmp0_;
		_tmp1_ = _reminder_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_reminder_size = _tmp3_;
		_reminder_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MayaViewEventEditionReminderGrid* reminder = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MayaViewEventEditionReminderGrid* _tmp8_;
			const gchar* _tmp9_;
			_reminder_index = _reminder_index + 1;
			_tmp4_ = _reminder_index;
			_tmp5_ = _reminder_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _reminder_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _reminder_index);
			reminder = (MayaViewEventEditionReminderGrid*) _tmp7_;
			_tmp8_ = reminder;
			_tmp9_ = _tmp8_->uid;
			if (g_strcmp0 (_tmp9_, "") == 0) {
				ECalComponentAlarm* alarm = NULL;
				ECalComponentAlarm* _tmp10_;
				ECalComponentAlarm* _tmp11_;
				ECalComponentAlarmTrigger* trigger = NULL;
				MayaViewEventEditionReminderGrid* _tmp12_;
				ICalDuration* _tmp13_;
				ICalDuration* _tmp14_;
				ECalComponentAlarmTrigger* _tmp15_;
				ECalComponentAlarm* _tmp16_;
				ECalComponentAlarmTrigger* _tmp17_;
				MayaViewEventDialog* _tmp18_;
				ECalComponent* _tmp19_;
				ECalComponent* _tmp20_;
				ECalComponentAlarm* _tmp21_;
				_tmp10_ = e_cal_component_alarm_new ();
				alarm = _tmp10_;
				_tmp11_ = alarm;
				e_cal_component_alarm_set_action (_tmp11_, E_CAL_COMPONENT_ALARM_DISPLAY);
				_tmp12_ = reminder;
				_tmp13_ = maya_view_event_edition_reminder_grid_get_duration (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = e_cal_component_alarm_trigger_new_relative (E_CAL_COMPONENT_ALARM_TRIGGER_RELATIVE_START, _tmp14_);
				__vala_ECalComponentAlarmTrigger_free0 (trigger);
				trigger = _tmp15_;
				_g_object_unref0 (_tmp14_);
				_tmp16_ = alarm;
				_tmp17_ = trigger;
				e_cal_component_alarm_set_trigger (_tmp16_, _tmp17_);
				_tmp18_ = self->priv->parent_dialog;
				_tmp19_ = maya_view_event_dialog_get_ecal (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = alarm;
				e_cal_component_add_alarm (_tmp20_, _tmp21_);
				__vala_ECalComponentAlarmTrigger_free0 (trigger);
				__vala_ECalComponentAlarm_free0 (alarm);
			} else {
				MayaViewEventEditionReminderGrid* _tmp22_;
				_tmp22_ = reminder;
				if (_tmp22_->change == TRUE) {
					ECalComponentAlarm* alarm = NULL;
					MayaViewEventDialog* _tmp23_;
					ECalComponent* _tmp24_;
					ECalComponent* _tmp25_;
					MayaViewEventEditionReminderGrid* _tmp26_;
					const gchar* _tmp27_;
					ECalComponentAlarm* _tmp28_;
					ECalComponentAlarm* _tmp29_;
					ECalComponentAlarm* _tmp30_;
					ECalComponentAlarm* _tmp31_;
					ECalComponentAlarm* _tmp32_;
					ECalComponentAlarmTrigger* trigger = NULL;
					ECalComponentAlarm* _tmp33_;
					ECalComponentAlarmTrigger* _tmp34_;
					ECalComponentAlarmTrigger* _tmp35_;
					ECalComponentAlarmTrigger* _tmp36_;
					ECalComponentAlarmTrigger* _tmp37_;
					MayaViewEventEditionReminderGrid* _tmp38_;
					ICalDuration* _tmp39_;
					ICalDuration* _tmp40_;
					ECalComponentAlarm* _tmp41_;
					ECalComponentAlarmTrigger* _tmp42_;
					MayaViewEventDialog* _tmp43_;
					ECalComponent* _tmp44_;
					ECalComponent* _tmp45_;
					MayaViewEventEditionReminderGrid* _tmp46_;
					const gchar* _tmp47_;
					MayaViewEventDialog* _tmp48_;
					ECalComponent* _tmp49_;
					ECalComponent* _tmp50_;
					ECalComponentAlarm* _tmp51_;
					_tmp23_ = self->priv->parent_dialog;
					_tmp24_ = maya_view_event_dialog_get_ecal (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = reminder;
					_tmp27_ = _tmp26_->uid;
					_tmp28_ = e_cal_component_get_alarm (_tmp25_, _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = e_cal_component_alarm_copy (_tmp29_);
					_tmp31_ = _tmp30_;
					__vala_ECalComponentAlarm_free0 (_tmp29_);
					alarm = _tmp31_;
					_tmp32_ = alarm;
					e_cal_component_alarm_set_action (_tmp32_, E_CAL_COMPONENT_ALARM_DISPLAY);
					_tmp33_ = alarm;
					_tmp34_ = e_cal_component_alarm_get_trigger (_tmp33_);
					_tmp35_ = __vala_ECalComponentAlarmTrigger_copy0 (_tmp34_);
					__vala_ECalComponentAlarmTrigger_free0 (trigger);
					trigger = _tmp35_;
					_tmp36_ = trigger;
					e_cal_component_alarm_trigger_set_kind (_tmp36_, E_CAL_COMPONENT_ALARM_TRIGGER_RELATIVE_START);
					_tmp37_ = trigger;
					_tmp38_ = reminder;
					_tmp39_ = maya_view_event_edition_reminder_grid_get_duration (_tmp38_);
					_tmp40_ = _tmp39_;
					e_cal_component_alarm_trigger_set_duration (_tmp37_, _tmp40_);
					_g_object_unref0 (_tmp40_);
					_tmp41_ = alarm;
					_tmp42_ = trigger;
					e_cal_component_alarm_set_trigger (_tmp41_, _tmp42_);
					_tmp43_ = self->priv->parent_dialog;
					_tmp44_ = maya_view_event_dialog_get_ecal (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = reminder;
					_tmp47_ = _tmp46_->uid;
					e_cal_component_remove_alarm (_tmp45_, _tmp47_);
					_tmp48_ = self->priv->parent_dialog;
					_tmp49_ = maya_view_event_dialog_get_ecal (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = alarm;
					e_cal_component_add_alarm (_tmp50_, _tmp51_);
					__vala_ECalComponentAlarmTrigger_free0 (trigger);
					__vala_ECalComponentAlarm_free0 (alarm);
				}
			}
			_g_object_unref0 (reminder);
		}
	}
	{
		GeeArrayList* _uid_list = NULL;
		GeeArrayList* _tmp52_;
		gint _uid_size = 0;
		GeeArrayList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _uid_index = 0;
		_tmp52_ = self->priv->reminders_to_remove;
		_uid_list = _tmp52_;
		_tmp53_ = _uid_list;
		_tmp54_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_uid_size = _tmp55_;
		_uid_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gchar* uid = NULL;
			GeeArrayList* _tmp58_;
			gpointer _tmp59_;
			MayaViewEventDialog* _tmp60_;
			ECalComponent* _tmp61_;
			ECalComponent* _tmp62_;
			const gchar* _tmp63_;
			_uid_index = _uid_index + 1;
			_tmp56_ = _uid_index;
			_tmp57_ = _uid_size;
			if (!(_tmp56_ < _tmp57_)) {
				break;
			}
			_tmp58_ = _uid_list;
			_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, _uid_index);
			uid = (gchar*) _tmp59_;
			_tmp60_ = self->priv->parent_dialog;
			_tmp61_ = maya_view_event_dialog_get_ecal (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = uid;
			e_cal_component_remove_alarm (_tmp62_, _tmp63_);
			_g_free0 (uid);
		}
	}
}

static void
maya_view_event_edition_reminder_panel_class_init (MayaViewEventEditionReminderPanelClass * klass,
                                                   gpointer klass_data)
{
	maya_view_event_edition_reminder_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewEventEditionReminderPanel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_view_event_edition_reminder_panel_finalize;
}

static void
maya_view_event_edition_reminder_panel_instance_init (MayaViewEventEditionReminderPanel * self,
                                                      gpointer klass)
{
	self->priv = maya_view_event_edition_reminder_panel_get_instance_private (self);
}

static void
maya_view_event_edition_reminder_panel_finalize (GObject * obj)
{
	MayaViewEventEditionReminderPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_PANEL, MayaViewEventEditionReminderPanel);
	_g_object_unref0 (self->priv->parent_dialog);
	_g_object_unref0 (self->priv->reminders);
	_g_object_unref0 (self->priv->reminders_to_remove);
	_g_object_unref0 (self->priv->reminder_list);
	G_OBJECT_CLASS (maya_view_event_edition_reminder_panel_parent_class)->finalize (obj);
}

static GType
maya_view_event_edition_reminder_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewEventEditionReminderPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_event_edition_reminder_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewEventEditionReminderPanel), 0, (GInstanceInitFunc) maya_view_event_edition_reminder_panel_instance_init, NULL };
	GType maya_view_event_edition_reminder_panel_type_id;
	maya_view_event_edition_reminder_panel_type_id = g_type_register_static (gtk_grid_get_type (), "MayaViewEventEditionReminderPanel", &g_define_type_info, 0);
	MayaViewEventEditionReminderPanel_private_offset = g_type_add_instance_private (maya_view_event_edition_reminder_panel_type_id, sizeof (MayaViewEventEditionReminderPanelPrivate));
	return maya_view_event_edition_reminder_panel_type_id;
}

GType
maya_view_event_edition_reminder_panel_get_type (void)
{
	static volatile gsize maya_view_event_edition_reminder_panel_type_id__once = 0;
	if (g_once_init_enter (&maya_view_event_edition_reminder_panel_type_id__once)) {
		GType maya_view_event_edition_reminder_panel_type_id;
		maya_view_event_edition_reminder_panel_type_id = maya_view_event_edition_reminder_panel_get_type_once ();
		g_once_init_leave (&maya_view_event_edition_reminder_panel_type_id__once, maya_view_event_edition_reminder_panel_type_id);
	}
	return maya_view_event_edition_reminder_panel_type_id__once;
}

static inline gpointer
maya_view_event_edition_reminder_grid_get_instance_private (MayaViewEventEditionReminderGrid* self)
{
	return G_STRUCT_MEMBER_P (self, MayaViewEventEditionReminderGrid_private_offset);
}

static void
__lambda43_ (MayaViewEventEditionReminderGrid* self)
{
	if (self->priv->is_human_change == TRUE) {
		self->change = TRUE;
	}
}

static void
___lambda43__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda43_ ((MayaViewEventEditionReminderGrid*) self);
}

static void
__lambda44_ (MayaViewEventEditionReminderGrid* self)
{
	g_signal_emit (self, maya_view_event_edition_reminder_grid_signals[MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_REMOVED_SIGNAL], 0);
	gtk_widget_destroy ((GtkWidget*) self);
}

static void
___lambda44__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda44_ ((MayaViewEventEditionReminderGrid*) self);
}

MayaViewEventEditionReminderGrid*
maya_view_event_edition_reminder_grid_construct (GType object_type,
                                                 const gchar* uid)
{
	MayaViewEventEditionReminderGrid * self = NULL;
	gchar* _tmp0_;
	GtkComboBoxText* _tmp1_;
	GtkComboBoxText* _tmp2_;
	GtkComboBoxText* _tmp3_;
	GtkComboBoxText* _tmp4_;
	GtkComboBoxText* _tmp5_;
	GtkComboBoxText* _tmp6_;
	GtkComboBoxText* _tmp7_;
	GtkComboBoxText* _tmp8_;
	GtkComboBoxText* _tmp9_;
	GtkComboBoxText* _tmp10_;
	GtkComboBoxText* _tmp11_;
	GtkComboBoxText* _tmp12_;
	GtkComboBoxText* _tmp13_;
	GtkComboBoxText* _tmp14_;
	GtkComboBoxText* _tmp15_;
	GtkComboBoxText* _tmp16_;
	GtkComboBoxText* _tmp17_;
	GtkComboBoxText* _tmp18_;
	GtkComboBoxText* _tmp19_;
	GtkComboBoxText* _tmp20_;
	GtkButton* remove_button = NULL;
	GtkButton* _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp23_;
	GtkComboBoxText* _tmp24_;
	g_return_val_if_fail (uid != NULL, NULL);
	self = (MayaViewEventEditionReminderGrid*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (uid);
	_g_free0 (self->uid);
	self->uid = _tmp0_;
	_tmp1_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->time);
	self->priv->time = _tmp1_;
	_tmp2_ = self->priv->time;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp3_, _ ("At time of event"));
	_tmp4_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp4_, _ ("1 minute before"));
	_tmp5_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp5_, _ ("5 minutes before"));
	_tmp6_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp6_, _ ("10 minutes before"));
	_tmp7_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp7_, _ ("15 minutes before"));
	_tmp8_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp8_, _ ("20 minutes before"));
	_tmp9_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp9_, _ ("25 minutes before"));
	_tmp10_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp10_, _ ("30 minutes before"));
	_tmp11_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp11_, _ ("45 minutes before"));
	_tmp12_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp12_, _ ("1 hour before"));
	_tmp13_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp13_, _ ("2 hours before"));
	_tmp14_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp14_, _ ("3 hours before"));
	_tmp15_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp15_, _ ("12 hours before"));
	_tmp16_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp16_, _ ("24 hours before"));
	_tmp17_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp17_, _ ("2 days before"));
	_tmp18_ = self->priv->time;
	gtk_combo_box_text_append_text (_tmp18_, _ ("1 week before"));
	_tmp19_ = self->priv->time;
	gtk_combo_box_set_active ((GtkComboBox*) _tmp19_, 3);
	_tmp20_ = self->priv->time;
	g_signal_connect_object ((GtkComboBox*) _tmp20_, "changed", (GCallback) ___lambda43__gtk_combo_box_changed, self, 0);
	_tmp21_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp21_);
	remove_button = _tmp21_;
	gtk_button_set_relief (remove_button, GTK_RELIEF_NONE);
	_tmp22_ = gtk_widget_get_style_context ((GtkWidget*) remove_button);
	gtk_style_context_add_class (_tmp22_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp23_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp23_);
	grid = _tmp23_;
	g_object_set ((GtkWidget*) grid, "margin", 6, NULL);
	gtk_grid_set_column_spacing (grid, 6);
	_tmp24_ = self->priv->time;
	gtk_grid_attach (grid, (GtkWidget*) _tmp24_, 0, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) remove_button, 2, 0, 1, 1);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	g_signal_connect_object (remove_button, "clicked", (GCallback) ___lambda44__gtk_button_clicked, self, 0);
	_g_object_unref0 (grid);
	_g_object_unref0 (remove_button);
	return self;
}

MayaViewEventEditionReminderGrid*
maya_view_event_edition_reminder_grid_new (const gchar* uid)
{
	return maya_view_event_edition_reminder_grid_construct (MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID, uid);
}

void
maya_view_event_edition_reminder_grid_set_duration (MayaViewEventEditionReminderGrid* self,
                                                    ICalDuration* duration)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (duration != NULL);
	self->priv->is_human_change = FALSE;
	if (i_cal_duration_get_weeks (duration) > ((guint) 0)) {
		GtkComboBoxText* _tmp0_;
		_tmp0_ = self->priv->time;
		gtk_combo_box_set_active ((GtkComboBox*) _tmp0_, 15);
	} else {
		if (i_cal_duration_get_days (duration) > ((guint) 1)) {
			GtkComboBoxText* _tmp1_;
			_tmp1_ = self->priv->time;
			gtk_combo_box_set_active ((GtkComboBox*) _tmp1_, 14);
		} else {
			if (i_cal_duration_get_days (duration) > ((guint) 0)) {
				GtkComboBoxText* _tmp2_;
				_tmp2_ = self->priv->time;
				gtk_combo_box_set_active ((GtkComboBox*) _tmp2_, 13);
			} else {
				if (i_cal_duration_get_hours (duration) > ((guint) 15)) {
					GtkComboBoxText* _tmp3_;
					_tmp3_ = self->priv->time;
					gtk_combo_box_set_active ((GtkComboBox*) _tmp3_, 13);
				} else {
					if (i_cal_duration_get_hours (duration) > ((guint) 5)) {
						GtkComboBoxText* _tmp4_;
						_tmp4_ = self->priv->time;
						gtk_combo_box_set_active ((GtkComboBox*) _tmp4_, 12);
					} else {
						if (i_cal_duration_get_hours (duration) > ((guint) 2)) {
							GtkComboBoxText* _tmp5_;
							_tmp5_ = self->priv->time;
							gtk_combo_box_set_active ((GtkComboBox*) _tmp5_, 11);
						} else {
							if (i_cal_duration_get_hours (duration) > ((guint) 1)) {
								GtkComboBoxText* _tmp6_;
								_tmp6_ = self->priv->time;
								gtk_combo_box_set_active ((GtkComboBox*) _tmp6_, 10);
							} else {
								if (i_cal_duration_get_hours (duration) > ((guint) 0)) {
									GtkComboBoxText* _tmp7_;
									_tmp7_ = self->priv->time;
									gtk_combo_box_set_active ((GtkComboBox*) _tmp7_, 9);
								} else {
									if (i_cal_duration_get_minutes (duration) > ((guint) 30)) {
										GtkComboBoxText* _tmp8_;
										_tmp8_ = self->priv->time;
										gtk_combo_box_set_active ((GtkComboBox*) _tmp8_, 8);
									} else {
										if (i_cal_duration_get_minutes (duration) > ((guint) 25)) {
											GtkComboBoxText* _tmp9_;
											_tmp9_ = self->priv->time;
											gtk_combo_box_set_active ((GtkComboBox*) _tmp9_, 7);
										} else {
											if (i_cal_duration_get_minutes (duration) > ((guint) 20)) {
												GtkComboBoxText* _tmp10_;
												_tmp10_ = self->priv->time;
												gtk_combo_box_set_active ((GtkComboBox*) _tmp10_, 6);
											} else {
												if (i_cal_duration_get_minutes (duration) > ((guint) 15)) {
													GtkComboBoxText* _tmp11_;
													_tmp11_ = self->priv->time;
													gtk_combo_box_set_active ((GtkComboBox*) _tmp11_, 5);
												} else {
													if (i_cal_duration_get_minutes (duration) > ((guint) 10)) {
														GtkComboBoxText* _tmp12_;
														_tmp12_ = self->priv->time;
														gtk_combo_box_set_active ((GtkComboBox*) _tmp12_, 4);
													} else {
														if (i_cal_duration_get_minutes (duration) > ((guint) 5)) {
															GtkComboBoxText* _tmp13_;
															_tmp13_ = self->priv->time;
															gtk_combo_box_set_active ((GtkComboBox*) _tmp13_, 3);
														} else {
															if (i_cal_duration_get_minutes (duration) > ((guint) 1)) {
																GtkComboBoxText* _tmp14_;
																_tmp14_ = self->priv->time;
																gtk_combo_box_set_active ((GtkComboBox*) _tmp14_, 2);
															} else {
																if (i_cal_duration_get_minutes (duration) > ((guint) 0)) {
																	GtkComboBoxText* _tmp15_;
																	_tmp15_ = self->priv->time;
																	gtk_combo_box_set_active ((GtkComboBox*) _tmp15_, 1);
																} else {
																	GtkComboBoxText* _tmp16_;
																	_tmp16_ = self->priv->time;
																	gtk_combo_box_set_active ((GtkComboBox*) _tmp16_, 0);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	self->priv->is_human_change = TRUE;
}

ICalDuration*
maya_view_event_edition_reminder_grid_get_duration (MayaViewEventEditionReminderGrid* self)
{
	ICalDuration* duration = NULL;
	ICalDuration* _tmp0_;
	GtkComboBoxText* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ICalDuration* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = i_cal_duration_new_null_duration ();
	duration = _tmp0_;
	_tmp1_ = self->priv->time;
	_tmp2_ = gtk_combo_box_get_active ((GtkComboBox*) _tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case 1:
		{
			ICalDuration* _tmp4_;
			_tmp4_ = duration;
			i_cal_duration_set_minutes (_tmp4_, (guint) 1);
			break;
		}
		case 2:
		{
			ICalDuration* _tmp5_;
			_tmp5_ = duration;
			i_cal_duration_set_minutes (_tmp5_, (guint) 5);
			break;
		}
		case 3:
		{
			ICalDuration* _tmp6_;
			_tmp6_ = duration;
			i_cal_duration_set_minutes (_tmp6_, (guint) 10);
			break;
		}
		case 4:
		{
			ICalDuration* _tmp7_;
			_tmp7_ = duration;
			i_cal_duration_set_minutes (_tmp7_, (guint) 15);
			break;
		}
		case 5:
		{
			ICalDuration* _tmp8_;
			_tmp8_ = duration;
			i_cal_duration_set_minutes (_tmp8_, (guint) 20);
			break;
		}
		case 6:
		{
			ICalDuration* _tmp9_;
			_tmp9_ = duration;
			i_cal_duration_set_minutes (_tmp9_, (guint) 25);
			break;
		}
		case 7:
		{
			ICalDuration* _tmp10_;
			_tmp10_ = duration;
			i_cal_duration_set_minutes (_tmp10_, (guint) 30);
			break;
		}
		case 8:
		{
			ICalDuration* _tmp11_;
			_tmp11_ = duration;
			i_cal_duration_set_minutes (_tmp11_, (guint) 45);
			break;
		}
		case 9:
		{
			ICalDuration* _tmp12_;
			_tmp12_ = duration;
			i_cal_duration_set_hours (_tmp12_, (guint) 1);
			break;
		}
		case 10:
		{
			ICalDuration* _tmp13_;
			_tmp13_ = duration;
			i_cal_duration_set_hours (_tmp13_, (guint) 2);
			break;
		}
		case 11:
		{
			ICalDuration* _tmp14_;
			_tmp14_ = duration;
			i_cal_duration_set_hours (_tmp14_, (guint) 3);
			break;
		}
		case 12:
		{
			ICalDuration* _tmp15_;
			_tmp15_ = duration;
			i_cal_duration_set_hours (_tmp15_, (guint) 12);
			break;
		}
		case 13:
		{
			ICalDuration* _tmp16_;
			_tmp16_ = duration;
			i_cal_duration_set_hours (_tmp16_, (guint) 24);
			break;
		}
		case 14:
		{
			ICalDuration* _tmp17_;
			_tmp17_ = duration;
			i_cal_duration_set_days (_tmp17_, (guint) 2);
			break;
		}
		case 15:
		{
			ICalDuration* _tmp18_;
			_tmp18_ = duration;
			i_cal_duration_set_weeks (_tmp18_, (guint) 1);
			break;
		}
		default:
		break;
	}
	result = duration;
	return result;
}

static void
maya_view_event_edition_reminder_grid_class_init (MayaViewEventEditionReminderGridClass * klass,
                                                  gpointer klass_data)
{
	maya_view_event_edition_reminder_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaViewEventEditionReminderGrid_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_view_event_edition_reminder_grid_finalize;
	maya_view_event_edition_reminder_grid_signals[MAYA_VIEW_EVENT_EDITION_REMINDER_GRID_REMOVED_SIGNAL] = g_signal_new ("removed", MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
maya_view_event_edition_reminder_grid_instance_init (MayaViewEventEditionReminderGrid * self,
                                                     gpointer klass)
{
	self->priv = maya_view_event_edition_reminder_grid_get_instance_private (self);
	self->change = FALSE;
	self->priv->is_human_change = TRUE;
}

static void
maya_view_event_edition_reminder_grid_finalize (GObject * obj)
{
	MayaViewEventEditionReminderGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_VIEW_EVENT_EDITION_TYPE_REMINDER_GRID, MayaViewEventEditionReminderGrid);
	_g_free0 (self->uid);
	_g_object_unref0 (self->priv->time);
	G_OBJECT_CLASS (maya_view_event_edition_reminder_grid_parent_class)->finalize (obj);
}

static GType
maya_view_event_edition_reminder_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaViewEventEditionReminderGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_view_event_edition_reminder_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaViewEventEditionReminderGrid), 0, (GInstanceInitFunc) maya_view_event_edition_reminder_grid_instance_init, NULL };
	GType maya_view_event_edition_reminder_grid_type_id;
	maya_view_event_edition_reminder_grid_type_id = g_type_register_static (gtk_list_box_row_get_type (), "MayaViewEventEditionReminderGrid", &g_define_type_info, 0);
	MayaViewEventEditionReminderGrid_private_offset = g_type_add_instance_private (maya_view_event_edition_reminder_grid_type_id, sizeof (MayaViewEventEditionReminderGridPrivate));
	return maya_view_event_edition_reminder_grid_type_id;
}

GType
maya_view_event_edition_reminder_grid_get_type (void)
{
	static volatile gsize maya_view_event_edition_reminder_grid_type_id__once = 0;
	if (g_once_init_enter (&maya_view_event_edition_reminder_grid_type_id__once)) {
		GType maya_view_event_edition_reminder_grid_type_id;
		maya_view_event_edition_reminder_grid_type_id = maya_view_event_edition_reminder_grid_get_type_once ();
		g_once_init_leave (&maya_view_event_edition_reminder_grid_type_id__once, maya_view_event_edition_reminder_grid_type_id);
	}
	return maya_view_event_edition_reminder_grid_type_id__once;
}

