/* GoogleBackend.c generated by valac 0.56.16, the Vala compiler
 * generated from GoogleBackend.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2013 Maya Developers (https://launchpad.net/maya)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "google.h"
#include <gmodule.h>
#include "elementary-calendar.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAYA_GOOGLE_BACKEND_0_PROPERTY,
	MAYA_GOOGLE_BACKEND_NUM_PROPERTIES
};
static GParamSpec* maya_google_backend_properties[MAYA_GOOGLE_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

MayaBackend* backend = NULL;
static gpointer maya_google_backend_parent_class = NULL;
static MayaBackendIface * maya_google_backend_maya_backend_parent_iface = NULL;

static gchar* maya_google_backend_real_get_name (MayaBackend* base);
static gchar* maya_google_backend_real_get_uid (MayaBackend* base);
static GeeCollection* maya_google_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                                 ESource* to_edit);
static void maya_google_backend_real_add_new_calendar (MayaBackend* base,
                                                const gchar* name,
                                                const gchar* color,
                                                gboolean set_default,
                                                GeeCollection* widgets);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void maya_google_backend_real_modify_calendar (MayaBackend* base,
                                               const gchar* name,
                                               const gchar* color,
                                               gboolean set_default,
                                               GeeCollection* widgets,
                                               ESource* source);
static GType maya_google_backend_get_type_once (void);

MayaBackend*
get_backend (GModule* module)
{
	MayaGoogleBackend* b = NULL;
	MayaGoogleBackend* _tmp0_;
	MayaBackend* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("GoogleBackend.vala:24: Activating Google Backend");
	_tmp0_ = maya_google_backend_new ();
	b = _tmp0_;
	g_object_ref ((GObject*) b);
	result = (MayaBackend*) b;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MayaGoogleBackend*
maya_google_backend_construct (GType object_type)
{
	MayaGoogleBackend * self = NULL;
	MayaBackend* _tmp0_;
	self = (MayaGoogleBackend*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 ((MayaBackend*) self);
	_g_object_unref0 (backend);
	backend = _tmp0_;
	return self;
}

MayaGoogleBackend*
maya_google_backend_new (void)
{
	return maya_google_backend_construct (MAYA_TYPE_GOOGLE_BACKEND);
}

static gchar*
maya_google_backend_real_get_name (MayaBackend* base)
{
	MayaGoogleBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaGoogleBackend*) base;
	_tmp0_ = g_strdup (_ ("Google"));
	result = _tmp0_;
	return result;
}

static gchar*
maya_google_backend_real_get_uid (MayaBackend* base)
{
	MayaGoogleBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaGoogleBackend*) base;
	_tmp0_ = g_strdup ("google-stub");
	result = _tmp0_;
	return result;
}

static GeeCollection*
maya_google_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                  ESource* to_edit)
{
	MayaGoogleBackend * self;
	GeeLinkedList* collection = NULL;
	GeeLinkedList* _tmp0_;
	gboolean keep_copy = FALSE;
	GeeLinkedList* _tmp6_;
	MayaPlacementWidget* _tmp7_;
	MayaPlacementWidget* _tmp8_;
	gchar* user = NULL;
	gchar* _tmp9_;
	GeeLinkedList* _tmp16_;
	const gchar* _tmp17_;
	GeeLinkedList* _tmp18_;
	GeeLinkedList* _tmp19_;
	GeeCollection* result;
	self = (MayaGoogleBackend*) base;
	_tmp0_ = gee_linked_list_new (MAYA_TYPE_PLACEMENT_WIDGET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	collection = _tmp0_;
	keep_copy = FALSE;
	if (to_edit != NULL) {
		ESourceOffline* source_offline = NULL;
		ESourceExtension* _tmp1_;
		ESourceOffline* _tmp2_;
		ESourceOffline* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_OFFLINE);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_offline_get_type (), ESourceOffline));
		source_offline = _tmp2_;
		_tmp3_ = source_offline;
		_tmp4_ = e_source_offline_get_stay_synchronized (_tmp3_);
		_tmp5_ = _tmp4_;
		keep_copy = _tmp5_;
		_g_object_unref0 (source_offline);
	}
	_tmp6_ = collection;
	_tmp7_ = maya_default_placement_widgets_get_keep_copy (3, keep_copy);
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = g_strdup ("");
	user = _tmp9_;
	if (to_edit != NULL) {
		ESourceAuthentication* auth = NULL;
		ESourceExtension* _tmp10_;
		ESourceAuthentication* _tmp11_;
		ESourceAuthentication* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp10_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp11_;
		_tmp12_ = auth;
		_tmp13_ = e_source_authentication_get_user (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (user);
		user = _tmp15_;
		_g_object_unref0 (auth);
	}
	_tmp16_ = collection;
	_tmp17_ = user;
	_tmp18_ = maya_default_placement_widgets_get_user (4, TRUE, _tmp17_, _ ("user.name or user.name@gmail.com"));
	_tmp19_ = _tmp18_;
	gee_collection_add_all ((GeeCollection*) _tmp16_, (GeeCollection*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	result = (GeeCollection*) collection;
	_g_free0 (user);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
maya_google_backend_real_add_new_calendar (MayaBackend* base,
                                           const gchar* name,
                                           const gchar* color,
                                           gboolean set_default,
                                           GeeCollection* widgets)
{
	MayaGoogleBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaGoogleBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	{
		ESource* new_source = NULL;
		ESource* _tmp0_;
		ESource* _tmp1_;
		ESource* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ESourceCalendar* cal = NULL;
		ESource* _tmp5_;
		ESourceExtension* _tmp6_;
		ESourceCalendar* _tmp7_;
		ESourceCalendar* _tmp8_;
		ESourceCalendar* _tmp9_;
		ESourceWebdav* webdav = NULL;
		ESource* _tmp10_;
		ESourceExtension* _tmp11_;
		ESourceWebdav* _tmp12_;
		ESourceOffline* offline = NULL;
		ESource* _tmp13_;
		ESourceExtension* _tmp14_;
		ESourceOffline* _tmp15_;
		ESourceAuthentication* auth = NULL;
		ESource* _tmp16_;
		ESourceExtension* _tmp17_;
		ESourceAuthentication* _tmp18_;
		CalendarEventStore* calmodel = NULL;
		CalendarEventStore* _tmp51_;
		ESourceRegistry* registry = NULL;
		CalendarEventStore* _tmp52_;
		ESourceRegistry* _tmp53_;
		ESourceRegistry* _tmp54_;
		ESourceRegistry* _tmp55_;
		GList* list = NULL;
		ESource* _tmp56_;
		ESource* _tmp57_;
		ESourceRegistry* _tmp58_;
		GList* _tmp59_;
		CalendarEventStore* _tmp60_;
		ESource* _tmp61_;
		_tmp0_ = e_source_new (NULL, NULL, &_inner_error0_);
		new_source = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = new_source;
		e_source_set_display_name (_tmp1_, name);
		_tmp2_ = new_source;
		_tmp3_ = maya_backend_get_uid ((MayaBackend*) self);
		_tmp4_ = _tmp3_;
		e_source_set_parent (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = new_source;
		_tmp6_ = e_source_get_extension (_tmp5_, E_SOURCE_EXTENSION_CALENDAR);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp7_;
		_tmp8_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp8_, color);
		_tmp9_ = cal;
		e_source_backend_set_backend_name ((ESourceBackend*) _tmp9_, "caldav");
		_tmp10_ = new_source;
		_tmp11_ = e_source_get_extension (_tmp10_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp12_;
		_tmp13_ = new_source;
		_tmp14_ = e_source_get_extension (_tmp13_, E_SOURCE_EXTENSION_OFFLINE);
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp15_;
		_tmp16_ = new_source;
		_tmp17_ = e_source_get_extension (_tmp16_, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp18_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp19_;
			_tmp19_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp19_;
			while (TRUE) {
				GeeIterator* _tmp20_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				MayaPlacementWidget* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				GQuark _tmp27_ = 0U;
				static GQuark _tmp26_label0 = 0;
				static GQuark _tmp26_label1 = 0;
				_tmp20_ = _widget_it;
				if (!gee_iterator_next (_tmp20_)) {
					break;
				}
				_tmp21_ = _widget_it;
				_tmp22_ = gee_iterator_get (_tmp21_);
				widget = (MayaPlacementWidget*) _tmp22_;
				_tmp23_ = widget;
				_tmp24_ = _tmp23_->ref_name;
				_tmp25_ = _tmp24_;
				_tmp27_ = (NULL == _tmp25_) ? 0 : g_quark_from_string (_tmp25_);
				if (_tmp27_ == ((0 != _tmp26_label0) ? _tmp26_label0 : (_tmp26_label0 = g_quark_from_static_string ("user_entry")))) {
					switch (0) {
						default:
						{
							gchar* decoded_user = NULL;
							MayaPlacementWidget* _tmp28_;
							GtkWidget* _tmp29_;
							const gchar* _tmp30_;
							const gchar* _tmp31_;
							gchar* _tmp32_;
							gboolean _tmp33_ = FALSE;
							const gchar* _tmp34_;
							ESourceAuthentication* _tmp38_;
							const gchar* _tmp39_;
							ESourceWebdav* _tmp40_;
							const gchar* _tmp41_;
							gchar* _tmp42_;
							gchar* _tmp43_;
							GUri* _tmp44_;
							GUri* _tmp45_;
							_tmp28_ = widget;
							_tmp29_ = _tmp28_->widget;
							_tmp30_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_entry_get_type (), GtkEntry));
							_tmp31_ = _tmp30_;
							_tmp32_ = g_strdup (_tmp31_);
							decoded_user = _tmp32_;
							_tmp34_ = decoded_user;
							if (!string_contains (_tmp34_, "@")) {
								const gchar* _tmp35_;
								_tmp35_ = decoded_user;
								_tmp33_ = !string_contains (_tmp35_, "%40");
							} else {
								_tmp33_ = FALSE;
							}
							if (_tmp33_) {
								const gchar* _tmp36_;
								gchar* _tmp37_;
								_tmp36_ = decoded_user;
								_tmp37_ = g_strdup_printf ("%s@gmail.com", _tmp36_);
								_g_free0 (decoded_user);
								decoded_user = _tmp37_;
							}
							_tmp38_ = auth;
							_tmp39_ = decoded_user;
							e_source_authentication_set_user (_tmp38_, _tmp39_);
							_tmp40_ = webdav;
							_tmp41_ = decoded_user;
							_tmp42_ = g_strdup_printf ("/calendar/dav/%s/events", _tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = g_uri_build (G_URI_FLAGS_NONE, "https", NULL, "www.google.com", -1, _tmp43_, NULL, NULL);
							_tmp45_ = _tmp44_;
							g_object_set (_tmp40_, "uri", _tmp45_, NULL);
							_g_uri_unref0 (_tmp45_);
							_g_free0 (_tmp43_);
							_g_free0 (decoded_user);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label1) ? _tmp26_label1 : (_tmp26_label1 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp46_;
							MayaPlacementWidget* _tmp47_;
							GtkWidget* _tmp48_;
							gboolean _tmp49_;
							gboolean _tmp50_;
							_tmp46_ = offline;
							_tmp47_ = widget;
							_tmp48_ = _tmp47_->widget;
							_tmp49_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp50_ = _tmp49_;
							e_source_offline_set_stay_synchronized (_tmp46_, _tmp50_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		_tmp51_ = calendar_event_store_get_default ();
		calmodel = _tmp51_;
		_tmp52_ = calmodel;
		_tmp53_ = calendar_event_store_get_registry (_tmp52_);
		_tmp54_ = _tmp53_;
		_tmp55_ = _g_object_ref0 (_tmp54_);
		registry = _tmp55_;
		list = NULL;
		_tmp56_ = new_source;
		_tmp57_ = _g_object_ref0 (_tmp56_);
		list = g_list_append (list, _tmp57_);
		_tmp58_ = registry;
		_tmp59_ = list;
		e_source_registry_create_sources_sync (_tmp58_, _tmp59_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (calmodel);
			_g_object_unref0 (auth);
			_g_object_unref0 (offline);
			_g_object_unref0 (webdav);
			_g_object_unref0 (cal);
			_g_object_unref0 (new_source);
			goto __catch0_g_error;
		}
		_tmp60_ = calmodel;
		_tmp61_ = new_source;
		calendar_event_store_add_source (_tmp60_, _tmp61_);
		if (set_default) {
			ESourceRegistry* _tmp62_;
			ESource* _tmp63_;
			_tmp62_ = registry;
			_tmp63_ = new_source;
			g_object_set (_tmp62_, "default-calendar", _tmp63_, NULL);
		}
		(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
		_g_object_unref0 (registry);
		_g_object_unref0 (calmodel);
		_g_object_unref0 (auth);
		_g_object_unref0 (offline);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
		_g_object_unref0 (new_source);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp64_;
		const gchar* _tmp65_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp64_ = _error_;
		_tmp65_ = _tmp64_->message;
		g_critical ("GoogleBackend.vala:123: %s", _tmp65_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_google_backend_real_modify_calendar (MayaBackend* base,
                                          const gchar* name,
                                          const gchar* color,
                                          gboolean set_default,
                                          GeeCollection* widgets,
                                          ESource* source)
{
	MayaGoogleBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaGoogleBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	g_return_if_fail (source != NULL);
	{
		ESourceCalendar* cal = NULL;
		ESourceExtension* _tmp0_;
		ESourceCalendar* _tmp1_;
		ESourceCalendar* _tmp2_;
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp3_;
		ESourceWebdav* _tmp4_;
		ESourceOffline* offline = NULL;
		ESourceExtension* _tmp5_;
		ESourceOffline* _tmp6_;
		ESourceAuthentication* auth = NULL;
		ESourceExtension* _tmp7_;
		ESourceAuthentication* _tmp8_;
		e_source_set_display_name (source, name);
		_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp1_;
		_tmp2_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp2_, color);
		_tmp3_ = e_source_get_extension (source, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp4_;
		_tmp5_ = e_source_get_extension (source, E_SOURCE_EXTENSION_OFFLINE);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp6_;
		_tmp7_ = e_source_get_extension (source, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp8_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp9_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				MayaPlacementWidget* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				GQuark _tmp17_ = 0U;
				static GQuark _tmp16_label0 = 0;
				static GQuark _tmp16_label1 = 0;
				_tmp10_ = _widget_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _widget_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				widget = (MayaPlacementWidget*) _tmp12_;
				_tmp13_ = widget;
				_tmp14_ = _tmp13_->ref_name;
				_tmp15_ = _tmp14_;
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("user_entry")))) {
					switch (0) {
						default:
						{
							gchar* decoded_user = NULL;
							MayaPlacementWidget* _tmp18_;
							GtkWidget* _tmp19_;
							const gchar* _tmp20_;
							const gchar* _tmp21_;
							gchar* _tmp22_;
							gboolean _tmp23_ = FALSE;
							const gchar* _tmp24_;
							ESourceAuthentication* _tmp28_;
							const gchar* _tmp29_;
							ESourceWebdav* _tmp30_;
							const gchar* _tmp31_;
							gchar* _tmp32_;
							gchar* _tmp33_;
							GUri* _tmp34_;
							GUri* _tmp35_;
							_tmp18_ = widget;
							_tmp19_ = _tmp18_->widget;
							_tmp20_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_entry_get_type (), GtkEntry));
							_tmp21_ = _tmp20_;
							_tmp22_ = g_strdup (_tmp21_);
							decoded_user = _tmp22_;
							_tmp24_ = decoded_user;
							if (!string_contains (_tmp24_, "@")) {
								const gchar* _tmp25_;
								_tmp25_ = decoded_user;
								_tmp23_ = !string_contains (_tmp25_, "%40");
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								const gchar* _tmp26_;
								gchar* _tmp27_;
								_tmp26_ = decoded_user;
								_tmp27_ = g_strdup_printf ("%s@gmail.com", _tmp26_);
								_g_free0 (decoded_user);
								decoded_user = _tmp27_;
							}
							_tmp28_ = auth;
							_tmp29_ = decoded_user;
							e_source_authentication_set_user (_tmp28_, _tmp29_);
							_tmp30_ = webdav;
							_tmp31_ = decoded_user;
							_tmp32_ = g_strdup_printf ("/calendar/dav/%s/events", _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = g_uri_build (G_URI_FLAGS_NONE, "https", NULL, "www.google.com", -1, _tmp33_, NULL, NULL);
							_tmp35_ = _tmp34_;
							g_object_set (_tmp30_, "uri", _tmp35_, NULL);
							_g_uri_unref0 (_tmp35_);
							_g_free0 (_tmp33_);
							_g_free0 (decoded_user);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp36_;
							MayaPlacementWidget* _tmp37_;
							GtkWidget* _tmp38_;
							gboolean _tmp39_;
							gboolean _tmp40_;
							_tmp36_ = offline;
							_tmp37_ = widget;
							_tmp38_ = _tmp37_->widget;
							_tmp39_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp40_ = _tmp39_;
							e_source_offline_set_stay_synchronized (_tmp36_, _tmp40_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		e_source_write (source, NULL, NULL, NULL);
		if (set_default) {
			ESourceRegistry* registry = NULL;
			ESourceRegistry* _tmp41_;
			ESourceRegistry* _tmp42_;
			_tmp41_ = e_source_registry_new_sync (NULL, &_inner_error0_);
			registry = _tmp41_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (auth);
				_g_object_unref0 (offline);
				_g_object_unref0 (webdav);
				_g_object_unref0 (cal);
				goto __catch0_g_error;
			}
			_tmp42_ = registry;
			g_object_set (_tmp42_, "default-calendar", source, NULL);
			_g_object_unref0 (registry);
		}
		_g_object_unref0 (auth);
		_g_object_unref0 (offline);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = _error_;
		_tmp44_ = _tmp43_->message;
		g_critical ("GoogleBackend.vala:177: %s", _tmp44_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_google_backend_class_init (MayaGoogleBackendClass * klass,
                                gpointer klass_data)
{
	maya_google_backend_parent_class = g_type_class_peek_parent (klass);
}

static void
maya_google_backend_maya_backend_interface_init (MayaBackendIface * iface,
                                                 gpointer iface_data)
{
	maya_google_backend_maya_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (MayaBackend*)) maya_google_backend_real_get_name;
	iface->get_uid = (gchar* (*) (MayaBackend*)) maya_google_backend_real_get_uid;
	iface->get_new_calendar_widget = (GeeCollection* (*) (MayaBackend*, ESource*)) maya_google_backend_real_get_new_calendar_widget;
	iface->add_new_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*)) maya_google_backend_real_add_new_calendar;
	iface->modify_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*, ESource*)) maya_google_backend_real_modify_calendar;
}

static void
maya_google_backend_instance_init (MayaGoogleBackend * self,
                                   gpointer klass)
{
}

static GType
maya_google_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaGoogleBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_google_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaGoogleBackend), 0, (GInstanceInitFunc) maya_google_backend_instance_init, NULL };
	static const GInterfaceInfo maya_backend_info = { (GInterfaceInitFunc) maya_google_backend_maya_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType maya_google_backend_type_id;
	maya_google_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaGoogleBackend", &g_define_type_info, 0);
	g_type_add_interface_static (maya_google_backend_type_id, MAYA_TYPE_BACKEND, &maya_backend_info);
	return maya_google_backend_type_id;
}

GType
maya_google_backend_get_type (void)
{
	static volatile gsize maya_google_backend_type_id__once = 0;
	if (g_once_init_enter (&maya_google_backend_type_id__once)) {
		GType maya_google_backend_type_id;
		maya_google_backend_type_id = maya_google_backend_get_type_once ();
		g_once_init_leave (&maya_google_backend_type_id__once, maya_google_backend_type_id);
	}
	return maya_google_backend_type_id__once;
}

