/* TimeManager.c generated by valac 0.56.16, the Vala compiler
 * generated from TimeManager.vala, do not modify */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include "elementary-calendar.h"
#include <libical-glib/libical-glib.h>
#include <libecal/libecal.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define FDO_TYPE_LOGIN_MANAGER (fdo_login_manager_get_type ())
#define FDO_LOGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FDO_TYPE_LOGIN_MANAGER, FDOLoginManager))
#define FDO_IS_LOGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FDO_TYPE_LOGIN_MANAGER))
#define FDO_LOGIN_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FDO_TYPE_LOGIN_MANAGER, FDOLoginManagerIface))

typedef struct _FDOLoginManager FDOLoginManager;
typedef struct _FDOLoginManagerIface FDOLoginManagerIface;

#define FDO_TYPE_LOGIN_MANAGER_PROXY (fdo_login_manager_proxy_get_type ())
enum  {
	FDO_LOGIN_MANAGER_PREPARE_FOR_SLEEP_SIGNAL,
	FDO_LOGIN_MANAGER_NUM_SIGNALS
};
static guint fdo_login_manager_signals[FDO_LOGIN_MANAGER_NUM_SIGNALS] = {0};
typedef GDBusProxy FDOLoginManagerProxy;
typedef GDBusProxyClass FDOLoginManagerProxyClass;

#define FDO_TYPE_TIME_DATE1 (fdo_time_date1_get_type ())
#define FDO_TIME_DATE1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FDO_TYPE_TIME_DATE1, FDOTimeDate1))
#define FDO_IS_TIME_DATE1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FDO_TYPE_TIME_DATE1))
#define FDO_TIME_DATE1_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FDO_TYPE_TIME_DATE1, FDOTimeDate1Iface))

typedef struct _FDOTimeDate1 FDOTimeDate1;
typedef struct _FDOTimeDate1Iface FDOTimeDate1Iface;

#define FDO_TYPE_TIME_DATE1_PROXY (fdo_time_date1_proxy_get_type ())
typedef GDBusProxy FDOTimeDate1Proxy;
typedef GDBusProxyClass FDOTimeDate1ProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CALENDAR_TIME_MANAGER_0_PROPERTY,
	CALENDAR_TIME_MANAGER_SYSTEM_TIMEZONE_PROPERTY,
	CALENDAR_TIME_MANAGER_NUM_PROPERTIES
};
static GParamSpec* calendar_time_manager_properties[CALENDAR_TIME_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
enum  {
	CALENDAR_TIME_MANAGER_ON_UPDATE_TODAY_SIGNAL,
	CALENDAR_TIME_MANAGER_NUM_SIGNALS
};
static guint calendar_time_manager_signals[CALENDAR_TIME_MANAGER_NUM_SIGNALS] = {0};

struct _FDOLoginManagerIface {
	GTypeInterface parent_iface;
};

struct _FDOTimeDate1Iface {
	GTypeInterface parent_iface;
	gchar* (*get_timezone) (FDOTimeDate1* self);
};

struct _CalendarTimeManagerPrivate {
	ICalTimezone* _system_timezone;
	guint timeout_id;
	FDOLoginManager* login_manager;
	FDOTimeDate1* timedate1;
};

static gint CalendarTimeManager_private_offset;
static gpointer calendar_time_manager_parent_class = NULL;
static CalendarTimeManager* calendar_time_manager_instance;
static CalendarTimeManager* calendar_time_manager_instance = NULL;

VALA_EXTERN GType fdo_login_manager_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType fdo_login_manager_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint fdo_login_manager_register_object (void* object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error);
static GType fdo_login_manager_get_type_once (void);
static void fdo_login_manager_proxy_g_signal (GDBusProxy* proxy,
                                       const gchar* sender_name,
                                       const gchar* signal_name,
                                       GVariant* parameters);
static void _dbus_handle_fdo_login_manager_prepare_for_sleep (FDOLoginManager* self,
                                                       GVariant* parameters);
static void fdo_login_manager_proxy_fdo_login_manager_interface_init (FDOLoginManagerIface* iface);
static void fdo_login_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                   const gchar* sender,
                                                   const gchar* object_path,
                                                   const gchar* interface_name,
                                                   const gchar* method_name,
                                                   GVariant* parameters,
                                                   GDBusMethodInvocation* invocation,
                                                   gpointer user_data);
static GVariant* fdo_login_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GError** error,
                                                         gpointer user_data);
static gboolean fdo_login_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data);
static void _dbus_fdo_login_manager_prepare_for_sleep (GObject* _sender,
                                                gboolean start,
                                                gpointer* _data);
static void _fdo_login_manager_unregister_object (gpointer user_data);
VALA_EXTERN GType fdo_time_date1_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType fdo_time_date1_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint fdo_time_date1_register_object (void* object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error);
VALA_EXTERN gchar* fdo_time_date1_get_timezone (FDOTimeDate1* self);
static GType fdo_time_date1_get_type_once (void);
static void fdo_time_date1_proxy_g_signal (GDBusProxy* proxy,
                                    const gchar* sender_name,
                                    const gchar* signal_name,
                                    GVariant* parameters);
static gchar* fdo_time_date1_dbus_proxy_get_timezone (FDOTimeDate1* self);
static void fdo_time_date1_proxy_fdo_time_date1_interface_init (FDOTimeDate1Iface* iface);
static void fdo_time_date1_dbus_interface_method_call (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* method_name,
                                                GVariant* parameters,
                                                GDBusMethodInvocation* invocation,
                                                gpointer user_data);
static GVariant* fdo_time_date1_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data);
static GVariant* _dbus_fdo_time_date1_get_timezone (FDOTimeDate1* self);
static gboolean fdo_time_date1_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data);
static void _fdo_time_date1_unregister_object (gpointer user_data);
static CalendarTimeManager* calendar_time_manager_new (void);
static CalendarTimeManager* calendar_time_manager_construct (GType object_type);
static void ___lambda18_ (CalendarTimeManager* self,
                   gboolean sleeping);
static void calendar_time_manager_setup_today_timeout (CalendarTimeManager* self);
static void ____lambda18__fdo_login_manager_prepare_for_sleep (FDOLoginManager* _sender,
                                                        gboolean start,
                                                        gpointer self);
static void calendar_time_manager_on_settings_watch (CalendarTimeManager* self);
static void _calendar_time_manager_on_settings_watch_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                           const gchar* name,
                                                                           const gchar* name_owner,
                                                                           gpointer self);
static void calendar_time_manager_on_settings_unwatch (CalendarTimeManager* self);
static void _calendar_time_manager_on_settings_unwatch_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                             const gchar* name,
                                                                             gpointer self);
static void calendar_time_manager_set_system_timezone (CalendarTimeManager* self,
                                                ICalTimezone* value);
static gboolean __lambda19_ (CalendarTimeManager* self);
static gboolean ___lambda19__gsource_func (gpointer self);
static void calendar_time_manager_on_timedate_properties_changed (CalendarTimeManager* self,
                                                           GVariant* changed_properties,
                                                           gchar** invalidated_properties,
                                                           gint invalidated_properties_length1);
static void _calendar_time_manager_on_timedate_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                              GVariant* changed_properties,
                                                                                              gchar** invalidated_properties,
                                                                                              gpointer self);
static CalendarTimeManager* calendar_time_manager_new_for_testing (ICalTimezone* system_timezone);
static CalendarTimeManager* calendar_time_manager_construct_for_testing (GType object_type,
                                                                  ICalTimezone* system_timezone);
static void calendar_time_manager_finalize (GObject * obj);
static GType calendar_time_manager_get_type_once (void);
static void _vala_calendar_time_manager_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_calendar_time_manager_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static const GDBusMethodInfo * const _fdo_login_manager_dbus_method_info[] = {NULL};
static const GDBusArgInfo _fdo_login_manager_dbus_arg_info_prepare_for_sleep_start = {-1, "start", "b", NULL};
static const GDBusArgInfo * const _fdo_login_manager_dbus_arg_info_prepare_for_sleep[] = {&_fdo_login_manager_dbus_arg_info_prepare_for_sleep_start, NULL};
static const GDBusSignalInfo _fdo_login_manager_dbus_signal_info_prepare_for_sleep = {-1, "PrepareForSleep", (GDBusArgInfo **) (&_fdo_login_manager_dbus_arg_info_prepare_for_sleep), NULL};
static const GDBusSignalInfo * const _fdo_login_manager_dbus_signal_info[] = {&_fdo_login_manager_dbus_signal_info_prepare_for_sleep, NULL};
static const GDBusPropertyInfo * const _fdo_login_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _fdo_login_manager_dbus_interface_info = {-1, "org.freedesktop.login1.Manager", (GDBusMethodInfo **) (&_fdo_login_manager_dbus_method_info), (GDBusSignalInfo **) (&_fdo_login_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_fdo_login_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _fdo_login_manager_dbus_interface_vtable = {fdo_login_manager_dbus_interface_method_call, fdo_login_manager_dbus_interface_get_property, fdo_login_manager_dbus_interface_set_property};
static const GDBusMethodInfo * const _fdo_time_date1_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _fdo_time_date1_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _fdo_time_date1_dbus_property_info_timezone = {-1, "Timezone", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _fdo_time_date1_dbus_property_info[] = {&_fdo_time_date1_dbus_property_info_timezone, NULL};
static const GDBusInterfaceInfo _fdo_time_date1_dbus_interface_info = {-1, "org.freedesktop.timedate1", (GDBusMethodInfo **) (&_fdo_time_date1_dbus_method_info), (GDBusSignalInfo **) (&_fdo_time_date1_dbus_signal_info), (GDBusPropertyInfo **) (&_fdo_time_date1_dbus_property_info), NULL};
static const GDBusInterfaceVTable _fdo_time_date1_dbus_interface_vtable = {fdo_time_date1_dbus_interface_method_call, fdo_time_date1_dbus_interface_get_property, fdo_time_date1_dbus_interface_set_property};

static void
fdo_login_manager_default_init (FDOLoginManagerIface * iface,
                                gpointer iface_data)
{
	fdo_login_manager_signals[FDO_LOGIN_MANAGER_PREPARE_FOR_SLEEP_SIGNAL] = g_signal_new ("prepare-for-sleep", FDO_TYPE_LOGIN_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static GType
fdo_login_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FDOLoginManagerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fdo_login_manager_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType fdo_login_manager_type_id;
	fdo_login_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "FDOLoginManager", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (fdo_login_manager_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (fdo_login_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) fdo_login_manager_proxy_get_type);
	g_type_set_qdata (fdo_login_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.login1.Manager");
	g_type_set_qdata (fdo_login_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_fdo_login_manager_dbus_interface_info));
	g_type_set_qdata (fdo_login_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) fdo_login_manager_register_object);
	return fdo_login_manager_type_id;
}

GType
fdo_login_manager_get_type (void)
{
	static volatile gsize fdo_login_manager_type_id__once = 0;
	if (g_once_init_enter (&fdo_login_manager_type_id__once)) {
		GType fdo_login_manager_type_id;
		fdo_login_manager_type_id = fdo_login_manager_get_type_once ();
		g_once_init_leave (&fdo_login_manager_type_id__once, fdo_login_manager_type_id);
	}
	return fdo_login_manager_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (FDOLoginManagerProxy, fdo_login_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (FDO_TYPE_LOGIN_MANAGER, fdo_login_manager_proxy_fdo_login_manager_interface_init) )
static void
fdo_login_manager_proxy_class_init (FDOLoginManagerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = fdo_login_manager_proxy_g_signal;
}

static void
_dbus_handle_fdo_login_manager_prepare_for_sleep (FDOLoginManager* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	gboolean start = FALSE;
	GVariant* _tmp0_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	start = g_variant_get_boolean (_tmp0_);
	g_variant_unref (_tmp0_);
	g_signal_emit_by_name (self, "prepare-for-sleep", start);
}

static void
fdo_login_manager_proxy_g_signal (GDBusProxy* proxy,
                                  const gchar* sender_name,
                                  const gchar* signal_name,
                                  GVariant* parameters)
{
	if (strcmp (signal_name, "PrepareForSleep") == 0) {
		_dbus_handle_fdo_login_manager_prepare_for_sleep ((FDOLoginManager*) proxy, parameters);
	}
}

static void
fdo_login_manager_proxy_init (FDOLoginManagerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_fdo_login_manager_dbus_interface_info));
}

static void
fdo_login_manager_proxy_fdo_login_manager_interface_init (FDOLoginManagerIface* iface)
{
}

static void
fdo_login_manager_dbus_interface_method_call (GDBusConnection* connection,
                                              const gchar* sender,
                                              const gchar* object_path,
                                              const gchar* interface_name,
                                              const gchar* method_name,
                                              GVariant* parameters,
                                              GDBusMethodInvocation* invocation,
                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
fdo_login_manager_dbus_interface_get_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
fdo_login_manager_dbus_interface_set_property (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* property_name,
                                               GVariant* value,
                                               GError** error,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_fdo_login_manager_prepare_for_sleep (GObject* _sender,
                                           gboolean start,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (start));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.login1.Manager", "PrepareForSleep", _arguments, NULL);
}

guint
fdo_login_manager_register_object (gpointer object,
                                   GDBusConnection* connection,
                                   const gchar* path,
                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_fdo_login_manager_dbus_interface_info), &_fdo_login_manager_dbus_interface_vtable, data, _fdo_login_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "prepare-for-sleep", (GCallback) _dbus_fdo_login_manager_prepare_for_sleep, data);
	return result;
}

static void
_fdo_login_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_fdo_login_manager_prepare_for_sleep, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gchar*
fdo_time_date1_get_timezone (FDOTimeDate1* self)
{
	FDOTimeDate1Iface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = FDO_TIME_DATE1_GET_INTERFACE (self);
	if (_iface_->get_timezone) {
		return _iface_->get_timezone (self);
	}
	return NULL;
}

static void
fdo_time_date1_default_init (FDOTimeDate1Iface * iface,
                             gpointer iface_data)
{
}

static GType
fdo_time_date1_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FDOTimeDate1Iface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fdo_time_date1_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType fdo_time_date1_type_id;
	fdo_time_date1_type_id = g_type_register_static (G_TYPE_INTERFACE, "FDOTimeDate1", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (fdo_time_date1_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (fdo_time_date1_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) fdo_time_date1_proxy_get_type);
	g_type_set_qdata (fdo_time_date1_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.timedate1");
	g_type_set_qdata (fdo_time_date1_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_fdo_time_date1_dbus_interface_info));
	g_type_set_qdata (fdo_time_date1_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) fdo_time_date1_register_object);
	return fdo_time_date1_type_id;
}

GType
fdo_time_date1_get_type (void)
{
	static volatile gsize fdo_time_date1_type_id__once = 0;
	if (g_once_init_enter (&fdo_time_date1_type_id__once)) {
		GType fdo_time_date1_type_id;
		fdo_time_date1_type_id = fdo_time_date1_get_type_once ();
		g_once_init_leave (&fdo_time_date1_type_id__once, fdo_time_date1_type_id);
	}
	return fdo_time_date1_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (FDOTimeDate1Proxy, fdo_time_date1_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (FDO_TYPE_TIME_DATE1, fdo_time_date1_proxy_fdo_time_date1_interface_init) )
static void
fdo_time_date1_proxy_class_init (FDOTimeDate1ProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = fdo_time_date1_proxy_g_signal;
}

static void
fdo_time_date1_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters)
{
}

static void
fdo_time_date1_proxy_init (FDOTimeDate1Proxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_fdo_time_date1_dbus_interface_info));
}

static gchar*
fdo_time_date1_dbus_proxy_get_timezone (FDOTimeDate1* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Timezone");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.timedate1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Timezone"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
fdo_time_date1_proxy_fdo_time_date1_interface_init (FDOTimeDate1Iface* iface)
{
	iface->get_timezone = fdo_time_date1_dbus_proxy_get_timezone;
}

static void
fdo_time_date1_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_fdo_time_date1_get_timezone (FDOTimeDate1* self)
{
	gchar* result;
	GVariant* _reply;
	result = fdo_time_date1_get_timezone (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
fdo_time_date1_dbus_interface_get_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Timezone") == 0) {
		return _dbus_fdo_time_date1_get_timezone (object);
	}
	return NULL;
}

static gboolean
fdo_time_date1_dbus_interface_set_property (GDBusConnection* connection,
                                            const gchar* sender,
                                            const gchar* object_path,
                                            const gchar* interface_name,
                                            const gchar* property_name,
                                            GVariant* value,
                                            GError** error,
                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
fdo_time_date1_register_object (gpointer object,
                                GDBusConnection* connection,
                                const gchar* path,
                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_fdo_time_date1_dbus_interface_info), &_fdo_time_date1_dbus_interface_vtable, data, _fdo_time_date1_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_fdo_time_date1_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
calendar_time_manager_get_instance_private (CalendarTimeManager* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarTimeManager_private_offset);
}

static void
___lambda18_ (CalendarTimeManager* self,
              gboolean sleeping)
{
	if (!sleeping) {
		g_signal_emit (self, calendar_time_manager_signals[CALENDAR_TIME_MANAGER_ON_UPDATE_TODAY_SIGNAL], 0);
		calendar_time_manager_setup_today_timeout (self);
	}
}

static void
____lambda18__fdo_login_manager_prepare_for_sleep (FDOLoginManager* _sender,
                                                   gboolean start,
                                                   gpointer self)
{
	___lambda18_ ((CalendarTimeManager*) self, start);
}

static void
_calendar_time_manager_on_settings_watch_gbus_name_appeared_callback (GDBusConnection* connection,
                                                                      const gchar* name,
                                                                      const gchar* name_owner,
                                                                      gpointer self)
{
	calendar_time_manager_on_settings_watch ((CalendarTimeManager*) self);
}

static void
_calendar_time_manager_on_settings_unwatch_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                        const gchar* name,
                                                                        gpointer self)
{
	calendar_time_manager_on_settings_unwatch ((CalendarTimeManager*) self);
}

static CalendarTimeManager*
calendar_time_manager_construct (GType object_type)
{
	CalendarTimeManager * self = NULL;
	ICalTimezone* _tmp6_;
	ICalTimezone* _tmp7_;
	ICalTimezone* _tmp8_;
	GError* _inner_error0_ = NULL;
	self = (CalendarTimeManager*) g_object_new (object_type, NULL);
	{
		FDOLoginManager* _tmp0_ = NULL;
		FDOLoginManager* _tmp1_;
		FDOLoginManager* _tmp2_;
		FDOLoginManager* _tmp3_;
		_tmp1_ = (FDOLoginManager*) g_initable_new (FDO_TYPE_LOGIN_MANAGER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.login1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/login1", "g-interface-name", "org.freedesktop.login1.Manager", NULL);
		_tmp0_ = (FDOLoginManager*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->login_manager);
		self->priv->login_manager = _tmp2_;
		_tmp3_ = self->priv->login_manager;
		g_signal_connect_object (_tmp3_, "prepare-for-sleep", (GCallback) ____lambda18__fdo_login_manager_prepare_for_sleep, self, 0);
		g_bus_watch_name_with_closures (G_BUS_TYPE_SYSTEM, "org.freedesktop.timedate1", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_calendar_time_manager_on_settings_watch_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _calendar_time_manager_on_settings_watch_gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_calendar_time_manager_on_settings_unwatch_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _calendar_time_manager_on_settings_unwatch_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("TimeManager.vala:43: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = e_cal_util_get_system_timezone ();
	_tmp7_ = i_cal_timezone_copy (_tmp6_);
	_tmp8_ = _tmp7_;
	calendar_time_manager_set_system_timezone (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	calendar_time_manager_setup_today_timeout (self);
	return self;
}

static CalendarTimeManager*
calendar_time_manager_new (void)
{
	return calendar_time_manager_construct (CALENDAR_TYPE_TIME_MANAGER);
}

/** Set a new timeout for the end of the day */
static gboolean
__lambda19_ (CalendarTimeManager* self)
{
	gboolean result;
	g_signal_emit (self, calendar_time_manager_signals[CALENDAR_TIME_MANAGER_ON_UPDATE_TODAY_SIGNAL], 0);
	calendar_time_manager_setup_today_timeout (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda19_ ((CalendarTimeManager*) self);
	return result;
}

static void
calendar_time_manager_setup_today_timeout (CalendarTimeManager* self)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GDateTime* tomorrow = NULL;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GTimeSpan seconds = 0LL;
	guint interval = 0U;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = g_date_time_add_days (now, 1);
	_tmp2_ = _tmp1_;
	_tmp3_ = calendar_util_datetime_strip_time (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_date_time_unref0 (_tmp2_);
	tomorrow = _tmp4_;
	seconds = (g_date_time_difference (tomorrow, now) / 1000000) + 1;
	interval = (guint) seconds;
	_tmp5_ = g_strdup_printf ("%u", interval);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("Setting new callback to update today in ", _tmp6_, " seconds", NULL);
	_tmp8_ = _tmp7_;
	g_debug ("TimeManager.vala:63: %s", _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, interval, ___lambda19__gsource_func, g_object_ref (self), g_object_unref);
	_g_date_time_unref0 (tomorrow);
	_g_date_time_unref0 (now);
}

static void
calendar_time_manager_on_timedate_properties_changed (CalendarTimeManager* self,
                                                      GVariant* changed_properties,
                                                      gchar** invalidated_properties,
                                                      gint invalidated_properties_length1)
{
	GVariant* timezone = NULL;
	const GVariantType* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* timeusec = NULL;
	const GVariantType* _tmp6_;
	GVariant* _tmp7_;
	gboolean _tmp8_ = FALSE;
	GVariant* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (changed_properties != NULL);
	_tmp0_ = G_VARIANT_TYPE_STRING;
	_tmp1_ = g_variant_lookup_value (changed_properties, "Timezone", _tmp0_);
	timezone = _tmp1_;
	_tmp2_ = timezone;
	if (_tmp2_ != NULL) {
		ICalTimezone* _tmp3_;
		ICalTimezone* _tmp4_;
		ICalTimezone* _tmp5_;
		_tmp3_ = e_cal_util_get_system_timezone ();
		_tmp4_ = i_cal_timezone_copy (_tmp3_);
		_tmp5_ = _tmp4_;
		calendar_time_manager_set_system_timezone (self, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = G_VARIANT_TYPE_UINT64;
	_tmp7_ = g_variant_lookup_value (changed_properties, "TimeUSec", _tmp6_);
	timeusec = _tmp7_;
	_tmp9_ = timezone;
	if (_tmp9_ != NULL) {
		_tmp8_ = TRUE;
	} else {
		GVariant* _tmp10_;
		_tmp10_ = timeusec;
		_tmp8_ = _tmp10_ != NULL;
	}
	if (_tmp8_) {
		g_signal_emit (self, calendar_time_manager_signals[CALENDAR_TIME_MANAGER_ON_UPDATE_TODAY_SIGNAL], 0);
		calendar_time_manager_setup_today_timeout (self);
	}
	_g_variant_unref0 (timeusec);
	_g_variant_unref0 (timezone);
}

/** When time settings server is present, start refreshing quickly */
static void
_calendar_time_manager_on_timedate_properties_changed_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                                         GVariant* changed_properties,
                                                                                         gchar** invalidated_properties,
                                                                                         gpointer self)
{
	calendar_time_manager_on_timedate_properties_changed ((CalendarTimeManager*) self, changed_properties, invalidated_properties, _vala_array_length (invalidated_properties));
}

static void
calendar_time_manager_on_settings_watch (CalendarTimeManager* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		FDOTimeDate1* _tmp0_ = NULL;
		FDOTimeDate1* _tmp1_;
		FDOTimeDate1* _tmp2_;
		FDOTimeDate1* _tmp3_;
		_tmp1_ = (FDOTimeDate1*) g_initable_new (FDO_TYPE_TIME_DATE1_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.timedate1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/timedate1", "g-interface-name", "org.freedesktop.timedate1", NULL);
		_tmp0_ = (FDOTimeDate1*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->timedate1);
		self->priv->timedate1 = _tmp2_;
		_tmp3_ = self->priv->timedate1;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) _calendar_time_manager_on_timedate_properties_changed_g_dbus_proxy_g_properties_changed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("TimeManager.vala:90: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
calendar_time_manager_on_settings_unwatch (CalendarTimeManager* self)
{
	FDOTimeDate1* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->timedate1;
	if (_tmp0_ != NULL) {
		FDOTimeDate1* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->timedate1;
		g_signal_parse_name ("g-properties-changed", g_dbus_proxy_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_dbus_proxy_get_type (), GDBusProxy), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _calendar_time_manager_on_timedate_properties_changed_g_dbus_proxy_g_properties_changed, self);
	}
	_g_object_unref0 (self->priv->timedate1);
	self->priv->timedate1 = NULL;
}

CalendarTimeManager*
calendar_time_manager_get_default (void)
{
	CalendarTimeManager* _tmp0_;
	CalendarTimeManager* _tmp2_;
	CalendarTimeManager* result;
	_tmp0_ = calendar_time_manager_instance;
	if (_tmp0_ == NULL) {
		CalendarTimeManager* _tmp1_;
		_tmp1_ = calendar_time_manager_new ();
		_g_object_unref0 (calendar_time_manager_instance);
		calendar_time_manager_instance = _tmp1_;
	}
	_tmp2_ = calendar_time_manager_instance;
	result = _tmp2_;
	return result;
}

CalendarTimeManager*
calendar_time_manager_setup_test (ICalTimezone* system_timezone)
{
	CalendarTimeManager* _tmp0_;
	CalendarTimeManager* _tmp1_;
	CalendarTimeManager* _tmp2_;
	CalendarTimeManager* result;
	g_return_val_if_fail (system_timezone != NULL, NULL);
	_tmp0_ = calendar_time_manager_instance;
	if (_tmp0_ != NULL) {
		g_warning ("TimeManager.vala:115: Resetting default TimeManager to new testing ins" \
"tance");
	}
	_tmp1_ = calendar_time_manager_new_for_testing (system_timezone);
	_g_object_unref0 (calendar_time_manager_instance);
	calendar_time_manager_instance = _tmp1_;
	_tmp2_ = calendar_time_manager_instance;
	result = _tmp2_;
	return result;
}

static CalendarTimeManager*
calendar_time_manager_construct_for_testing (GType object_type,
                                             ICalTimezone* system_timezone)
{
	CalendarTimeManager * self = NULL;
	g_return_val_if_fail (system_timezone != NULL, NULL);
	self = (CalendarTimeManager*) g_object_new (object_type, NULL);
	calendar_time_manager_set_system_timezone (self, system_timezone);
	return self;
}

static CalendarTimeManager*
calendar_time_manager_new_for_testing (ICalTimezone* system_timezone)
{
	return calendar_time_manager_construct_for_testing (CALENDAR_TYPE_TIME_MANAGER, system_timezone);
}

ICalTimezone*
calendar_time_manager_get_system_timezone (CalendarTimeManager* self)
{
	ICalTimezone* result;
	ICalTimezone* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_system_timezone;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
calendar_time_manager_set_system_timezone (CalendarTimeManager* self,
                                           ICalTimezone* value)
{
	ICalTimezone* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_time_manager_get_system_timezone (self);
	if (old_value != value) {
		ICalTimezone* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_system_timezone);
		self->priv->_system_timezone = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_time_manager_properties[CALENDAR_TIME_MANAGER_SYSTEM_TIMEZONE_PROPERTY]);
	}
}

static void
calendar_time_manager_class_init (CalendarTimeManagerClass * klass,
                                  gpointer klass_data)
{
	calendar_time_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarTimeManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_calendar_time_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_calendar_time_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = calendar_time_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_TIME_MANAGER_SYSTEM_TIMEZONE_PROPERTY, calendar_time_manager_properties[CALENDAR_TIME_MANAGER_SYSTEM_TIMEZONE_PROPERTY] = g_param_spec_object ("system-timezone", "system-timezone", "system-timezone", i_cal_timezone_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	calendar_time_manager_signals[CALENDAR_TIME_MANAGER_ON_UPDATE_TODAY_SIGNAL] = g_signal_new ("on-update-today", CALENDAR_TYPE_TIME_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
calendar_time_manager_instance_init (CalendarTimeManager * self,
                                     gpointer klass)
{
	self->priv = calendar_time_manager_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
	self->priv->login_manager = NULL;
	self->priv->timedate1 = NULL;
}

static void
calendar_time_manager_finalize (GObject * obj)
{
	CalendarTimeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_TYPE_TIME_MANAGER, CalendarTimeManager);
	_g_object_unref0 (self->priv->_system_timezone);
	_g_object_unref0 (self->priv->login_manager);
	_g_object_unref0 (self->priv->timedate1);
	G_OBJECT_CLASS (calendar_time_manager_parent_class)->finalize (obj);
}

/** Manages signals to keep temporal state up to date */
static GType
calendar_time_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarTimeManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_time_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarTimeManager), 0, (GInstanceInitFunc) calendar_time_manager_instance_init, NULL };
	GType calendar_time_manager_type_id;
	calendar_time_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "CalendarTimeManager", &g_define_type_info, 0);
	CalendarTimeManager_private_offset = g_type_add_instance_private (calendar_time_manager_type_id, sizeof (CalendarTimeManagerPrivate));
	return calendar_time_manager_type_id;
}

GType
calendar_time_manager_get_type (void)
{
	static volatile gsize calendar_time_manager_type_id__once = 0;
	if (g_once_init_enter (&calendar_time_manager_type_id__once)) {
		GType calendar_time_manager_type_id;
		calendar_time_manager_type_id = calendar_time_manager_get_type_once ();
		g_once_init_leave (&calendar_time_manager_type_id__once, calendar_time_manager_type_id);
	}
	return calendar_time_manager_type_id__once;
}

static void
_vala_calendar_time_manager_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	CalendarTimeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_TIME_MANAGER, CalendarTimeManager);
	switch (property_id) {
		case CALENDAR_TIME_MANAGER_SYSTEM_TIMEZONE_PROPERTY:
		g_value_set_object (value, calendar_time_manager_get_system_timezone (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_calendar_time_manager_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	CalendarTimeManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_TIME_MANAGER, CalendarTimeManager);
	switch (property_id) {
		case CALENDAR_TIME_MANAGER_SYSTEM_TIMEZONE_PROPERTY:
		calendar_time_manager_set_system_timezone (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

