/* EventStore.c generated by valac 0.56.16, the Vala compiler
 * generated from EventStore.vala, do not modify */

/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "elementary-calendar.h"
#include <libedataserver/libedataserver.h>
#include <glib.h>
#include <libecal/libecal.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib-object.h>
#include <libedataserverui/libedataserverui.h>
#include <gio/gio.h>
#include <libical-glib/libical-glib.h>
#include <langinfo.h>
#include <float.h>
#include <math.h>
#include <time.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CALENDAR_EVENT_STORE_0_PROPERTY,
	CALENDAR_EVENT_STORE_DATA_RANGE_PROPERTY,
	CALENDAR_EVENT_STORE_MONTH_RANGE_PROPERTY,
	CALENDAR_EVENT_STORE_REGISTRY_PROPERTY,
	CALENDAR_EVENT_STORE_MONTH_START_PROPERTY,
	CALENDAR_EVENT_STORE_NUM_WEEKS_PROPERTY,
	CALENDAR_EVENT_STORE_WEEK_STARTS_ON_PROPERTY,
	CALENDAR_EVENT_STORE_DRAG_COMPONENT_PROPERTY,
	CALENDAR_EVENT_STORE_NUM_PROPERTIES
};
static GParamSpec* calendar_event_store_properties[CALENDAR_EVENT_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _CalendarEventStoreOpenData CalendarEventStoreOpenData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CalendarEventStoreAddEventAsyncData CalendarEventStoreAddEventAsyncData;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _CalendarEventStoreAddSourceAsyncData CalendarEventStoreAddSourceAsyncData;
#define __vala_ECalComponentId_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentId_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
enum  {
	CALENDAR_EVENT_STORE_EVENTS_ADDED_SIGNAL,
	CALENDAR_EVENT_STORE_EVENTS_UPDATED_SIGNAL,
	CALENDAR_EVENT_STORE_EVENTS_REMOVED_SIGNAL,
	CALENDAR_EVENT_STORE_CONNECTING_SIGNAL,
	CALENDAR_EVENT_STORE_CONNECTED_SIGNAL,
	CALENDAR_EVENT_STORE_ERROR_RECEIVED_SIGNAL,
	CALENDAR_EVENT_STORE_PARAMETERS_CHANGED_SIGNAL,
	CALENDAR_EVENT_STORE_NUM_SIGNALS
};
static guint calendar_event_store_signals[CALENDAR_EVENT_STORE_NUM_SIGNALS] = {0};

struct _CalendarEventStorePrivate {
	CalendarUtilDateRange* _data_range;
	CalendarUtilDateRange* _month_range;
	ESourceRegistry* _registry;
	GDateTime* _month_start;
	gint _num_weeks;
	GDateWeekday _week_starts_on;
	ECalComponent* _drag_component;
	GHashTable* source_client;
	GRecMutex __lock_source_client;
	GHashTable* source_view;
	GHashTable* source_events;
	ECredentialsPrompter* credentials_prompter;
};

struct _CalendarEventStoreOpenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	CalendarEventStore* self;
	ESourceRegistry* _tmp0_;
	ESourceRegistry* _tmp1_;
	ESourceRegistry* _tmp2_;
	ECredentialsPrompter* _tmp3_;
	ECredentialsPrompter* _tmp4_;
	ESourceRegistry* _tmp5_;
	ESourceRegistry* _tmp6_;
	ESourceRegistry* _tmp7_;
	ESourceRegistry* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GError* _error_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _CalendarEventStoreAddEventAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	CalendarEventStore* self;
	ESource* source;
	ECalComponent* event;
	ICalComponent* comp;
	ICalComponent* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ECalClient* client;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	gconstpointer _tmp8_;
	ECalClient* _tmp9_;
	GHashTable* _tmp10_;
	gchar* uid;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	GError* _error_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	CalendarEventStore* self;
	ECalClient* client;
	ESource* source;
	ECalComponent* event;
};

struct _Block2Data {
	int _ref_count_;
	CalendarEventStore* self;
	ECalClient* client;
};

struct _Block3Data {
	int _ref_count_;
	CalendarEventStore* self;
	GeeArrayList* events;
};

struct _Block4Data {
	int _ref_count_;
	CalendarEventStore* self;
	ECalClient* client;
	ESource* source;
};

struct _Block5Data {
	int _ref_count_;
	CalendarEventStore* self;
	ESource* source;
	gpointer _async_data_;
};

struct _CalendarEventStoreAddSourceAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	CalendarEventStore* self;
	ESource* source;
	Block5Data* _data5_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GCancellable* cancellable;
	GCancellable* _tmp2_;
	EClient* _tmp3_;
	EClient* _tmp4_;
	ECalClient* client;
	ECalClient* _tmp5_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	ECalClient* _tmp9_;
	ECalClient* _tmp10_;
	GError* e;
	GError* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _Block6Data {
	int _ref_count_;
	CalendarEventStore* self;
	GeeTreeMultiMap* events;
	GeeArrayList* added_events;
	ESource* source;
	ECalClient* client;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	const gchar* uid;
};

struct _Block8Data {
	int _ref_count_;
	CalendarEventStore* self;
	GeeArrayList* updated_events;
	GeeArrayList* removed_events;
	GeeArrayList* added_events;
	ESource* source;
	ECalClient* client;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	const gchar* uid;
	GeeTreeMultiMap* events_for_source;
};

struct _Block10Data {
	int _ref_count_;
	CalendarEventStore* self;
	GeeTreeMultiMap* events;
	GeeArrayList* removed_events;
	ESource* source;
};

static gint CalendarEventStore_private_offset;
static gpointer calendar_event_store_parent_class = NULL;
static CalendarEventStore* calendar_event_store_store;
static CalendarEventStore* calendar_event_store_store = NULL;
static GSettings* calendar_event_store_state_settings;
static GSettings* calendar_event_store_state_settings = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
static GDateWeekday calendar_event_store_get_week_start (CalendarEventStore* self);
static GDateTime* calendar_event_store_get_page (CalendarEventStore* self);
static void calendar_event_store_compute_ranges (CalendarEventStore* self);
static void _g_free0_ (gpointer var);
static guint _e_source_hash_ghash_func (gconstpointer key);
static gboolean _e_source_equal_gequal_func (gconstpointer a,
                                      gconstpointer b);
static void calendar_event_store_on_parameter_changed (CalendarEventStore* self);
static void _calendar_event_store_on_parameter_changed_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static void calendar_event_store_open_data_free (gpointer _data);
static gboolean calendar_event_store_open_co (CalendarEventStoreOpenData* _data_);
static void calendar_event_store_open_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static void calendar_event_store_set_registry (CalendarEventStore* self,
                                        ESourceRegistry* value);
static void _calendar_event_store_remove_source_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                           ESource* source,
                                                                           gpointer self);
static void calendar_event_store_on_source_changed (CalendarEventStore* self,
                                             ESource* source);
static void _calendar_event_store_on_source_changed_e_source_registry_source_changed (ESourceRegistry* _sender,
                                                                               ESource* source,
                                                                               gpointer self);
static void _calendar_event_store_add_source_e_source_registry_source_added (ESourceRegistry* _sender,
                                                                      ESource* source,
                                                                      gpointer self);
static void ___lambda14_ (CalendarEventStore* self,
                   ESource* source);
static void ____lambda14__gfunc (gconstpointer data,
                          gpointer self);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void calendar_event_store_add_event_async (CalendarEventStore* self,
                                           ESource* source,
                                           ECalComponent* event,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void calendar_event_store_add_event_finish (CalendarEventStore* self,
                                            GAsyncResult* _res_);
static void calendar_event_store_add_event_async_data_free (gpointer _data);
static gboolean calendar_event_store_add_event_async_co (CalendarEventStoreAddEventAsyncData* _data_);
static void calendar_event_store_add_event_async_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda15_ (Block1Data* _data1_,
                  GObject* obj,
                  GAsyncResult* results);
static void ___lambda15__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda16_ (Block2Data* _data2_,
                  GObject* obj,
                  GAsyncResult* results);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void calendar_event_store_load_source (CalendarEventStore* self,
                                       ESource* source);
static void calendar_event_store_add_source_async (CalendarEventStore* self,
                                            ESource* source,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
static void calendar_event_store_add_source_finish (CalendarEventStore* self,
                                             GAsyncResult* _res_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda17_ (Block3Data* _data3_,
                  ESource* source);
static void ___lambda17__gfunc (gconstpointer data,
                         gpointer self);
static void calendar_event_store_set_month_range (CalendarEventStore* self,
                                           CalendarUtilDateRange* value);
static void calendar_event_store_set_data_range (CalendarEventStore* self,
                                          CalendarUtilDateRange* value);
static void calendar_event_store_set_num_weeks (CalendarEventStore* self,
                                         gint value);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (Block4Data* _data4_,
                 GObject* obj,
                 GAsyncResult* results);
static void ___lambda5_ (Block4Data* _data4_,
                  GSList* objects);
static void calendar_event_store_on_objects_added (CalendarEventStore* self,
                                            ESource* source,
                                            ECalClient* client,
                                            GSList* objects);
static void ____lambda5__e_cal_client_view_objects_added (ECalClientView* _sender,
                                                   GSList* objects,
                                                   gpointer self);
static void ___lambda8_ (Block4Data* _data4_,
                  GSList* objects);
static void calendar_event_store_on_objects_removed (CalendarEventStore* self,
                                              ESource* source,
                                              ECalClient* client,
                                              GSList* cids);
static void ____lambda8__e_cal_client_view_objects_removed (ECalClientView* _sender,
                                                     GSList* uids,
                                                     gpointer self);
static void ___lambda10_ (Block4Data* _data4_,
                   GSList* objects);
static void calendar_event_store_on_objects_modified (CalendarEventStore* self,
                                               ESource* source,
                                               ECalClient* client,
                                               GSList* objects);
static void ____lambda10__e_cal_client_view_objects_modified (ECalClientView* _sender,
                                                       GSList* objects,
                                                       gpointer self);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void calendar_event_store_add_source_async_data_free (gpointer _data);
static gboolean calendar_event_store_add_source_async_co (CalendarEventStoreAddSourceAsyncData* _data_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void calendar_event_store_add_source_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static gboolean __lambda13_ (Block5Data* _data5_);
static gboolean ___lambda13__gsource_func (gpointer self);
static void calendar_event_store_debug_event (CalendarEventStore* self,
                                       ESource* source,
                                       ECalComponent* event,
                                       const gchar* message);
static void _vala_ECalComponentId_free (ECalComponentId* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda6_ (Block6Data* _data6_,
                 ICalComponent* comp);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block7Data* _data7_,
                     ICalComponent* comp,
                     ICalTime* start,
                     ICalTime* end,
                     GError** error);
static gboolean ___lambda7__ecal_recur_instance_cb (ICalComponent* icomp,
                                             ICalTime* instance_start,
                                             ICalTime* instance_end,
                                             gpointer self,
                                             GCancellable* cancellable,
                                             GError** error);
static void ___lambda6__gfunc (gconstpointer data,
                        gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda11_ (Block8Data* _data8_,
                  ICalComponent* comp);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean ___lambda12_ (Block9Data* _data9_,
                       ICalComponent* comp,
                       ICalTime* start,
                       ICalTime* end,
                       GError** error);
static gboolean ____lambda12__ecal_recur_instance_cb (ICalComponent* icomp,
                                               ICalTime* instance_start,
                                               ICalTime* instance_end,
                                               gpointer self,
                                               GCancellable* cancellable,
                                               GError** error);
static void ___lambda11__gfunc (gconstpointer data,
                         gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda9_ (Block10Data* _data10_,
                 ECalComponentId* cid);
static void ___lambda9__gfunc (gconstpointer data,
                        gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void calendar_event_store_finalize (GObject * obj);
static GType calendar_event_store_get_type_once (void);
static void _vala_calendar_event_store_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_calendar_event_store_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
calendar_event_store_get_instance_private (CalendarEventStore* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarEventStore_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

CalendarEventStore*
calendar_event_store_get_default (void)
{
	CalendarEventStore* _tmp0_;
	CalendarEventStore* _tmp2_;
	CalendarEventStore* _tmp3_;
	CalendarEventStore* result;
	_tmp0_ = calendar_event_store_store;
	if (_tmp0_ == NULL) {
		CalendarEventStore* _tmp1_;
		_tmp1_ = calendar_event_store_new ();
		_g_object_unref0 (calendar_event_store_store);
		calendar_event_store_store = _tmp1_;
	}
	_tmp2_ = calendar_event_store_store;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static guint
_e_source_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = e_source_hash (key);
	return result;
}

static gboolean
_e_source_equal_gequal_func (gconstpointer a,
                             gconstpointer b)
{
	gboolean result;
	result = e_source_equal (a, (ESource*) b);
	return result;
}

static void
_calendar_event_store_on_parameter_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	calendar_event_store_on_parameter_changed ((CalendarEventStore*) self);
}

CalendarEventStore*
calendar_event_store_construct (GType object_type)
{
	CalendarEventStore * self = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GQueue* _tmp10_;
	self = (CalendarEventStore*) g_object_new (object_type, NULL);
	calendar_event_store_set_week_starts_on (self, calendar_event_store_get_week_start (self));
	_tmp0_ = calendar_event_store_get_page (self);
	_tmp1_ = calendar_util_datetime_get_start_of_month (_tmp0_);
	_tmp2_ = _tmp1_;
	calendar_event_store_set_month_start (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
	calendar_event_store_compute_ranges (self);
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->source_client);
	self->priv->source_client = _tmp5_;
	_tmp6_ = g_hash_table_new_full (_e_source_hash_ghash_func, _e_source_equal_gequal_func, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->source_events);
	self->priv->source_events = _tmp6_;
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->source_view);
	self->priv->source_view = _tmp9_;
	_tmp10_ = g_queue_new ();
	(self->calendar_trash == NULL) ? NULL : (self->calendar_trash = (_g_queue_free__g_object_unref0_ (self->calendar_trash), NULL));
	self->calendar_trash = _tmp10_;
	g_signal_connect_object ((GObject*) self, "notify::month-start", (GCallback) _calendar_event_store_on_parameter_changed_g_object_notify, self, 0);
	calendar_event_store_open (self, NULL, NULL);
	return self;
}

CalendarEventStore*
calendar_event_store_new (void)
{
	return calendar_event_store_construct (CALENDAR_TYPE_EVENT_STORE);
}

static void
calendar_event_store_open_data_free (gpointer _data)
{
	CalendarEventStoreOpenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (CalendarEventStoreOpenData, _data_);
}

void
calendar_event_store_open (CalendarEventStore* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	CalendarEventStoreOpenData* _data_;
	CalendarEventStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (CalendarEventStoreOpenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, calendar_event_store_open_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	calendar_event_store_open_co (_data_);
}

void
calendar_event_store_open_finish (CalendarEventStore* self,
                                  GAsyncResult* _res_)
{
	CalendarEventStoreOpenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
calendar_event_store_open_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	CalendarEventStoreOpenData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	calendar_event_store_open_co (_data_);
}

static void
_calendar_event_store_remove_source_e_source_registry_source_removed (ESourceRegistry* _sender,
                                                                      ESource* source,
                                                                      gpointer self)
{
	calendar_event_store_remove_source ((CalendarEventStore*) self, source);
}

static void
_calendar_event_store_on_source_changed_e_source_registry_source_changed (ESourceRegistry* _sender,
                                                                          ESource* source,
                                                                          gpointer self)
{
	calendar_event_store_on_source_changed ((CalendarEventStore*) self, source);
}

static void
_calendar_event_store_add_source_e_source_registry_source_added (ESourceRegistry* _sender,
                                                                 ESource* source,
                                                                 gpointer self)
{
	calendar_event_store_add_source ((CalendarEventStore*) self, source);
}

static void
___lambda14_ (CalendarEventStore* self,
              ESource* source)
{
	ESourceCalendar* cal = NULL;
	ESourceExtension* _tmp0_;
	ESourceCalendar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESourceCalendar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
	cal = _tmp1_;
	_tmp3_ = cal;
	_tmp4_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = e_source_get_enabled (source);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ == TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		calendar_event_store_add_source (self, source);
	}
	_g_object_unref0 (cal);
}

static void
____lambda14__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda14_ ((CalendarEventStore*) self, (ESource*) data);
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
calendar_event_store_open_co (CalendarEventStoreOpenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		e_source_registry_new (NULL, calendar_event_store_open_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		calendar_event_store_set_registry (_data_->self, _data_->_tmp0_);
		_data_->_tmp2_ = _data_->self->priv->_registry;
		_data_->_tmp3_ = e_credentials_prompter_new (_data_->_tmp2_);
		_g_object_unref0 (_data_->self->priv->credentials_prompter);
		_data_->self->priv->credentials_prompter = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->self->priv->credentials_prompter;
		e_credentials_prompter_set_auto_prompt (_data_->_tmp4_, TRUE);
		_data_->_tmp5_ = _data_->self->priv->_registry;
		g_signal_connect_object (_data_->_tmp5_, "source-removed", (GCallback) _calendar_event_store_remove_source_e_source_registry_source_removed, _data_->self, 0);
		_data_->_tmp6_ = _data_->self->priv->_registry;
		g_signal_connect_object (_data_->_tmp6_, "source-changed", (GCallback) _calendar_event_store_on_source_changed_e_source_registry_source_changed, _data_->self, 0);
		_data_->_tmp7_ = _data_->self->priv->_registry;
		g_signal_connect_object (_data_->_tmp7_, "source-added", (GCallback) _calendar_event_store_add_source_e_source_registry_source_added, _data_->self, 0);
		_data_->_tmp8_ = _data_->self->priv->_registry;
		_data_->_tmp9_ = e_source_registry_list_sources (_data_->_tmp8_, E_SOURCE_EXTENSION_CALENDAR);
		_data_->_tmp10_ = _data_->_tmp9_;
		g_list_foreach (_data_->_tmp10_, ____lambda14__gfunc, _data_->self);
		(_data_->_tmp10_ == NULL) ? NULL : (_data_->_tmp10_ = (_g_list_free__g_object_unref0_ (_data_->_tmp10_), NULL));
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->_error_;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_critical ("EventStore.vala:108: %s", _data_->_tmp12_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
calendar_event_store_add_event (CalendarEventStore* self,
                                ESource* source,
                                ECalComponent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	calendar_event_store_add_event_async (self, source, event, NULL, NULL);
}

gboolean
calendar_event_store_calclient_is_readonly (CalendarEventStore* self,
                                            ESource* source)
{
	ECalClient* client = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gconstpointer _tmp4_;
			ECalClient* _tmp5_;
			_tmp1_ = self->priv->source_client;
			_tmp2_ = e_source_dup_uid (source);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_hash_table_lookup (_tmp1_, _tmp3_);
			_tmp5_ = _g_object_ref0 ((ECalClient*) _tmp4_);
			_g_object_unref0 (client);
			client = _tmp5_;
			_g_free0 (_tmp3_);
		}
		__finally0:
		{
			GHashTable* _tmp6_;
			_tmp6_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			_g_object_unref0 (client);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp7_;
		}
	}
	if (client != NULL) {
		result = e_client_is_readonly ((EClient*) client);
		_g_object_unref0 (client);
		return result;
	} else {
		g_critical ("EventStore.vala:126: No calendar client was found");
	}
	result = TRUE;
	_g_object_unref0 (client);
	return result;
}

static void
calendar_event_store_add_event_async_data_free (gpointer _data)
{
	CalendarEventStoreAddEventAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->source);
	_g_object_unref0 (_data_->event);
	_g_object_unref0 (_data_->self);
	g_slice_free (CalendarEventStoreAddEventAsyncData, _data_);
}

static void
calendar_event_store_add_event_async (CalendarEventStore* self,
                                      ESource* source,
                                      ECalComponent* event,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	CalendarEventStoreAddEventAsyncData* _data_;
	CalendarEventStore* _tmp0_;
	ESource* _tmp1_;
	ECalComponent* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_data_ = g_slice_new0 (CalendarEventStoreAddEventAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, calendar_event_store_add_event_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	_tmp2_ = _g_object_ref0 (event);
	_g_object_unref0 (_data_->event);
	_data_->event = _tmp2_;
	calendar_event_store_add_event_async_co (_data_);
}

static void
calendar_event_store_add_event_finish (CalendarEventStore* self,
                                       GAsyncResult* _res_)
{
	CalendarEventStoreAddEventAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
calendar_event_store_add_event_async_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	CalendarEventStoreAddEventAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	calendar_event_store_add_event_async_co (_data_);
}

static gboolean
calendar_event_store_add_event_async_co (CalendarEventStoreAddEventAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = e_cal_component_get_icalcomponent (_data_->event);
	_data_->comp = _data_->_tmp0_;
	_data_->_tmp1_ = i_cal_component_get_uid (_data_->comp);
	_data_->_tmp2_ = string_to_string (_data_->_tmp1_);
	_data_->_tmp3_ = g_strconcat ("Adding event '", _data_->_tmp2_, "'", NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_debug ("EventStore.vala:134: %s", _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	{
		_data_->_tmp5_ = _data_->self->priv->source_client;
		g_rec_mutex_lock (&_data_->self->priv->__lock_source_client);
		{
			_data_->_tmp6_ = _data_->self->priv->source_client;
			_data_->_tmp7_ = e_source_get_uid (_data_->source);
			_data_->_tmp8_ = g_hash_table_lookup (_data_->_tmp6_, _data_->_tmp7_);
			_data_->_tmp9_ = _g_object_ref0 ((ECalClient*) _data_->_tmp8_);
			_g_object_unref0 (_data_->client);
			_data_->client = _data_->_tmp9_;
		}
		__finally0:
		{
			_data_->_tmp10_ = _data_->self->priv->source_client;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->client);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->client != NULL) {
		{
			_data_->_tmp11_ = NULL;
			_data_->_state_ = 1;
			e_cal_client_create_object (_data_->client, _data_->comp, E_CAL_OPERATION_FLAG_NONE, NULL, calendar_event_store_add_event_async_ready, _data_);
			return FALSE;
			_state_1:
			e_cal_client_create_object_finish (_data_->client, _data_->_res_, &_data_->_tmp11_, &_data_->_inner_error0_);
			_g_free0 (_data_->uid);
			_data_->uid = _data_->_tmp11_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->uid);
				goto __catch1_g_error;
			}
			_data_->_tmp12_ = _data_->uid;
			if (_data_->_tmp12_ != NULL) {
				_data_->_tmp13_ = _data_->uid;
				i_cal_component_set_uid (_data_->comp, _data_->_tmp13_);
			}
			_g_free0 (_data_->uid);
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp14_ = _data_->_error_;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			g_critical ("EventStore.vala:148: %s", _data_->_tmp15_);
			_g_error_free0 (_data_->_error_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->client);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		g_critical ("EventStore.vala:151: No calendar was found, event not added");
	}
	_g_object_unref0 (_data_->client);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->client);
		_g_object_unref0 (_data1_->source);
		_g_object_unref0 (_data1_->event);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda15_ (Block1Data* _data1_,
             GObject* obj,
             GAsyncResult* results)
{
	CalendarEventStore* self;
	GError* _inner_error0_ = NULL;
	self = _data1_->self;
	g_return_if_fail (results != NULL);
	{
		e_cal_client_modify_object_finish (_data1_->client, results, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = g_strconcat (_tmp1_, " - try to add instead", NULL);
		_tmp3_ = _tmp2_;
		g_warning ("EventStore.vala:167: %s", _tmp3_);
		_g_free0 (_tmp3_);
		calendar_event_store_add_event (self, _data1_->source, _data1_->event);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda15__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda15_ (self, source_object, res);
	block1_data_unref (self);
}

void
calendar_event_store_update_event (CalendarEventStore* self,
                                   ESource* source,
                                   ECalComponent* event,
                                   ECalObjModType mod_type)
{
	Block1Data* _data1_;
	ESource* _tmp0_;
	ECalComponent* _tmp1_;
	ICalComponent* comp = NULL;
	ICalComponent* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFlagsValue* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data1_->source);
	_data1_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (event);
	_g_object_unref0 (_data1_->event);
	_data1_->event = _tmp1_;
	_tmp2_ = e_cal_component_get_icalcomponent (_data1_->event);
	comp = _tmp2_;
	_tmp3_ = i_cal_component_get_uid (comp);
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_flags_get_first_value (g_type_class_ref (e_cal_obj_mod_type_get_type ()), mod_type);
	_tmp6_ = g_strconcat ("Updating event '", _tmp4_, "' [mod_type=", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL, "]", NULL);
	_tmp7_ = _tmp6_;
	g_debug ("EventStore.vala:157: %s", _tmp7_);
	_g_free0 (_tmp7_);
	{
		GHashTable* _tmp8_;
		_tmp8_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp9_;
			const gchar* _tmp10_;
			gconstpointer _tmp11_;
			ECalClient* _tmp12_;
			_tmp9_ = self->priv->source_client;
			_tmp10_ = e_source_get_uid (_data1_->source);
			_tmp11_ = g_hash_table_lookup (_tmp9_, _tmp10_);
			_tmp12_ = _g_object_ref0 ((ECalClient*) _tmp11_);
			_g_object_unref0 (_data1_->client);
			_data1_->client = _tmp12_;
		}
		__finally0:
		{
			GHashTable* _tmp13_;
			_tmp13_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	e_cal_client_modify_object (_data1_->client, comp, mod_type, E_CAL_OPERATION_FLAG_NONE, NULL, ___lambda15__gasync_ready_callback, block1_data_ref (_data1_));
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->client);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda16_ (Block2Data* _data2_,
             GObject* obj,
             GAsyncResult* results)
{
	CalendarEventStore* self;
	GError* _inner_error0_ = NULL;
	self = _data2_->self;
	g_return_if_fail (results != NULL);
	{
		e_cal_client_remove_object_finish (_data2_->client, results, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("EventStore.vala:193: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ (self, source_object, res);
	block2_data_unref (self);
}

void
calendar_event_store_remove_event (CalendarEventStore* self,
                                   ESource* source,
                                   ECalComponent* event,
                                   ECalObjModType mod_type)
{
	Block2Data* _data2_;
	ICalComponent* comp = NULL;
	ICalComponent* _tmp0_;
	gchar* uid = NULL;
	ICalComponent* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* rid = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = e_cal_component_get_icalcomponent (event);
	comp = _tmp0_;
	_tmp1_ = comp;
	_tmp2_ = i_cal_component_get_uid (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	uid = _tmp3_;
	rid = NULL;
	if (e_cal_component_has_recurrences (event)) {
		_tmp4_ = mod_type != E_CAL_OBJ_MOD_ALL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = e_cal_component_get_recurid_as_string (event);
		_g_free0 (rid);
		rid = _tmp5_;
		_tmp6_ = rid;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Removing recurrent event '", _tmp7_, "'", NULL);
		_tmp9_ = _tmp8_;
		g_debug ("EventStore.vala:180: %s", _tmp9_);
		_g_free0 (_tmp9_);
	}
	_tmp10_ = uid;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("Removing event '", _tmp11_, "'", NULL);
	_tmp13_ = _tmp12_;
	g_debug ("EventStore.vala:183: %s", _tmp13_);
	_g_free0 (_tmp13_);
	{
		GHashTable* _tmp14_;
		_tmp14_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp15_;
			const gchar* _tmp16_;
			gconstpointer _tmp17_;
			ECalClient* _tmp18_;
			_tmp15_ = self->priv->source_client;
			_tmp16_ = e_source_get_uid (source);
			_tmp17_ = g_hash_table_lookup (_tmp15_, _tmp16_);
			_tmp18_ = _g_object_ref0 ((ECalClient*) _tmp17_);
			_g_object_unref0 (_data2_->client);
			_data2_->client = _tmp18_;
		}
		__finally0:
		{
			GHashTable* _tmp19_;
			_tmp19_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (rid);
			_g_free0 (uid);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp20_ = uid;
	_tmp21_ = rid;
	e_cal_client_remove_object (_data2_->client, _tmp20_, _tmp21_, mod_type, E_CAL_OPERATION_FLAG_NONE, NULL, ___lambda16__gasync_ready_callback, block2_data_ref (_data2_));
	_g_free0 (rid);
	_g_free0 (uid);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

void
calendar_event_store_trash_calendar (CalendarEventStore* self,
                                     ESource* source)
{
	GQueue* _tmp0_;
	ESource* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->calendar_trash;
	_tmp1_ = _g_object_ref0 (source);
	g_queue_push_tail (_tmp0_, _tmp1_);
	calendar_event_store_remove_source (self, source);
	e_source_set_enabled (source, FALSE);
}

void
calendar_event_store_restore_calendar (CalendarEventStore* self)
{
	GQueue* _tmp0_;
	ESource* source = NULL;
	GQueue* _tmp1_;
	gpointer _tmp2_;
	ESource* _tmp3_;
	ESource* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->calendar_trash;
	if (g_queue_is_empty (_tmp0_)) {
		return;
	}
	_tmp1_ = self->calendar_trash;
	_tmp2_ = g_queue_pop_tail (_tmp1_);
	source = (ESource*) _tmp2_;
	_tmp3_ = source;
	e_source_set_enabled (_tmp3_, TRUE);
	_tmp4_ = source;
	calendar_event_store_add_source (self, _tmp4_);
	_g_object_unref0 (source);
}

void
calendar_event_store_delete_trashed_calendars (CalendarEventStore* self)
{
	ESource* source = NULL;
	GQueue* _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->calendar_trash;
	_tmp1_ = g_queue_pop_tail (_tmp0_);
	source = (ESource*) _tmp1_;
	while (TRUE) {
		ESource* _tmp2_;
		ESource* _tmp3_;
		GQueue* _tmp4_;
		gpointer _tmp5_;
		_tmp2_ = source;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = source;
		e_source_remove (_tmp3_, NULL, NULL, NULL);
		_tmp4_ = self->calendar_trash;
		_tmp5_ = g_queue_pop_tail (_tmp4_);
		_g_object_unref0 (source);
		source = (ESource*) _tmp5_;
	}
	_g_object_unref0 (source);
}

void
calendar_event_store_change_month (CalendarEventStore* self,
                                   gint relative)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_month_start;
	_tmp1_ = g_date_time_add_months (_tmp0_, relative);
	_tmp2_ = _tmp1_;
	calendar_event_store_set_month_start (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
}

void
calendar_event_store_change_year (CalendarEventStore* self,
                                  gint relative)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_month_start;
	_tmp1_ = g_date_time_add_years (_tmp0_, relative);
	_tmp2_ = _tmp1_;
	calendar_event_store_set_month_start (self, _tmp2_);
	_g_date_time_unref0 (_tmp2_);
}

void
calendar_event_store_load_all_sources (CalendarEventStore* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GHashTable* _tmp0_;
		_tmp0_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp1_;
			GList* _tmp2_;
			_tmp1_ = self->priv->source_client;
			_tmp2_ = g_hash_table_get_keys (_tmp1_);
			{
				GList* id_collection = NULL;
				GList* id_it = NULL;
				id_collection = _tmp2_;
				for (id_it = id_collection; id_it != NULL; id_it = id_it->next) {
					const gchar* id = NULL;
					id = (const gchar*) id_it->data;
					{
						ESource* source = NULL;
						ESourceRegistry* _tmp3_;
						const gchar* _tmp4_;
						ESource* _tmp5_;
						ESourceCalendar* cal = NULL;
						ESource* _tmp6_;
						ESourceExtension* _tmp7_;
						ESourceCalendar* _tmp8_;
						gboolean _tmp9_ = FALSE;
						ESourceCalendar* _tmp10_;
						gboolean _tmp11_;
						gboolean _tmp12_;
						_tmp3_ = self->priv->_registry;
						_tmp4_ = id;
						_tmp5_ = e_source_registry_ref_source (_tmp3_, _tmp4_);
						source = _tmp5_;
						_tmp6_ = source;
						_tmp7_ = e_source_get_extension (_tmp6_, E_SOURCE_EXTENSION_CALENDAR);
						_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, e_source_calendar_get_type (), ESourceCalendar));
						cal = _tmp8_;
						_tmp10_ = cal;
						_tmp11_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp10_);
						_tmp12_ = _tmp11_;
						if (_tmp12_ == TRUE) {
							ESource* _tmp13_;
							gboolean _tmp14_;
							gboolean _tmp15_;
							_tmp13_ = source;
							_tmp14_ = e_source_get_enabled (_tmp13_);
							_tmp15_ = _tmp14_;
							_tmp9_ = _tmp15_ == TRUE;
						} else {
							_tmp9_ = FALSE;
						}
						if (_tmp9_) {
							ESource* _tmp16_;
							_tmp16_ = source;
							calendar_event_store_load_source (self, _tmp16_);
						}
						_g_object_unref0 (cal);
						_g_object_unref0 (source);
					}
				}
				(id_collection == NULL) ? NULL : (id_collection = (g_list_free (id_collection), NULL));
			}
		}
		__finally0:
		{
			GHashTable* _tmp17_;
			_tmp17_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
calendar_event_store_add_source (CalendarEventStore* self,
                                 ESource* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	calendar_event_store_add_source_async (self, source, NULL, NULL);
}

void
calendar_event_store_remove_source (CalendarEventStore* self,
                                    ESource* source)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* uid = NULL;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	const gchar* _tmp4_;
	ECalClientView* current_view = NULL;
	GHashTable* _tmp5_;
	const gchar* _tmp6_;
	gconstpointer _tmp7_;
	ECalClientView* _tmp8_;
	GHashTable* _tmp12_;
	const gchar* _tmp13_;
	GeeCollection* events = NULL;
	GHashTable* _tmp18_;
	gconstpointer _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* _tmp22_;
	GeeCollection* _tmp23_;
	GeeCollection* _tmp24_;
	GeeCollection* _tmp25_;
	GHashTable* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_dup_display_name (source);
	_tmp1_ = _tmp0_;
	g_debug ("EventStore.vala:246: Removing source '%s'", _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = e_source_get_uid (source);
	uid = _tmp2_;
	_tmp3_ = self->priv->source_view;
	_tmp4_ = uid;
	if (!g_hash_table_contains (_tmp3_, _tmp4_)) {
		return;
	}
	_tmp5_ = self->priv->source_view;
	_tmp6_ = uid;
	_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
	_tmp8_ = _g_object_ref0 ((ECalClientView*) _tmp7_);
	current_view = _tmp8_;
	{
		ECalClientView* _tmp9_;
		_tmp9_ = current_view;
		e_cal_client_view_stop (_tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("EventStore.vala:257: %s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (current_view);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp12_ = self->priv->source_view;
	_tmp13_ = uid;
	g_hash_table_remove (_tmp12_, _tmp13_);
	{
		GHashTable* _tmp14_;
		_tmp14_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = self->priv->source_client;
			_tmp16_ = uid;
			g_hash_table_remove (_tmp15_, _tmp16_);
		}
		__finally1:
		{
			GHashTable* _tmp17_;
			_tmp17_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (current_view);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp18_ = self->priv->source_events;
	_tmp19_ = g_hash_table_lookup (_tmp18_, source);
	_tmp20_ = gee_multi_map_get_values ((GeeMultiMap*) ((GeeTreeMultiMap*) _tmp19_));
	_tmp21_ = _tmp20_;
	_tmp22_ = gee_collection_get_read_only_view (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp21_);
	events = _tmp24_;
	_tmp25_ = events;
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_REMOVED_SIGNAL], 0, source, _tmp25_);
	_tmp26_ = self->priv->source_events;
	g_hash_table_remove (_tmp26_, source);
	_g_object_unref0 (events);
	_g_object_unref0 (current_view);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->events);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda17_ (Block3Data* _data3_,
             ESource* source)
{
	CalendarEventStore* self;
	ESourceCalendar* cal = NULL;
	ESourceExtension* _tmp0_;
	ESourceCalendar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ESourceCalendar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	self = _data3_->self;
	g_return_if_fail (source != NULL);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
	cal = _tmp1_;
	_tmp3_ = cal;
	_tmp4_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == TRUE) {
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp6_ = e_source_get_enabled (source);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ == TRUE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GHashTable* _tmp8_;
		gconstpointer _tmp9_;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeCollection* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		_tmp8_ = self->priv->source_events;
		_tmp9_ = g_hash_table_lookup (_tmp8_, source);
		_tmp10_ = gee_multi_map_get_values ((GeeMultiMap*) ((GeeTreeMultiMap*) _tmp9_));
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_collection_get_read_only_view (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		gee_array_list_add_all (_data3_->events, _tmp14_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (_tmp11_);
	}
	_g_object_unref0 (cal);
}

static void
___lambda17__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda17_ (self, (ESource*) data);
}

GeeCollection*
calendar_event_store_get_events (CalendarEventStore* self)
{
	Block3Data* _data3_;
	GeeArrayList* _tmp0_;
	ESourceRegistry* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_data3_->events = _tmp0_;
	_tmp1_ = self->priv->_registry;
	_tmp2_ = e_source_registry_list_sources (_tmp1_, E_SOURCE_EXTENSION_CALENDAR);
	_tmp3_ = _tmp2_;
	g_list_foreach (_tmp3_, ___lambda17__gfunc, _data3_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_list_free__g_object_unref0_ (_tmp3_), NULL));
	_tmp4_ = _g_object_ref0 ((GeeCollection*) _data3_->events);
	result = _tmp4_;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

/** Set the week_starts_on property: the first day of the week.
     *
     * Locale handling is based on information from
     * https://sourceware.org/glibc/wiki/Locales
     */
static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GDateWeekday
calendar_event_store_get_week_start (CalendarEventStore* self)
{
	guint week_day1 = 0U;
	const gchar* _tmp0_;
	gint week_1stday = 0;
	gint glib_offset = 0;
	gint week_start_posix = 0;
	const gchar* _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8 _tmp5_;
	gint week_start = 0;
	GDateWeekday result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = nl_langinfo (_NL_TIME_WEEK_1STDAY);
	week_day1 = (guint) _tmp0_;
	week_1stday = 0;
	if (week_day1 == ((guint) 19971130)) {
		week_1stday = 0;
	} else {
		if (week_day1 == ((guint) 19971201)) {
			week_1stday = 1;
		} else {
			g_warning ("EventStore.vala:302: Unknown value of _NL_TIME_WEEK_1STDAY: %u", week_day1);
		}
	}
	glib_offset = week_1stday - 1;
	_tmp1_ = nl_langinfo (_NL_TIME_FIRST_WEEKDAY);
	_tmp2_ = string_get_data (_tmp1_, &_tmp3_);
	_tmp2__length1 = _tmp3_;
	_tmp4_ = _tmp2_;
	_tmp4__length1 = _tmp2__length1;
	_tmp5_ = _tmp4_[0];
	week_start_posix = (gint) _tmp5_;
	week_start = week_start_posix + glib_offset;
	if (week_start == 0) {
		week_start = 7;
	}
	result = (GDateWeekday) week_start;
	return result;
}

static GDateTime*
calendar_event_store_get_page (CalendarEventStore* self)
{
	gchar* month_page = NULL;
	GSettings* _tmp0_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar** numbers = NULL;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint numbers_length1;
	gint _numbers_size_;
	GDateTime* dt = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	month_page = NULL;
	_tmp0_ = calendar_event_store_state_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = calendar_event_store_state_settings;
		_tmp2_ = g_settings_get_string (_tmp1_, "month-page");
		_g_free0 (month_page);
		month_page = _tmp2_;
	}
	_tmp4_ = month_page;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = month_page;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	if (_tmp3_) {
		GDateTime* _tmp6_;
		_tmp6_ = g_date_time_new_now_local ();
		result = _tmp6_;
		_g_free0 (month_page);
		return result;
	}
	_tmp7_ = month_page;
	_tmp9_ = _tmp8_ = g_strsplit (_tmp7_, "-", 2);
	numbers = _tmp9_;
	numbers_length1 = _vala_array_length (_tmp8_);
	_numbers_size_ = numbers_length1;
	_tmp10_ = numbers;
	_tmp10__length1 = numbers_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = g_date_time_new_local (atoi (_tmp11_), 1, 1, 0, 0, (gdouble) 0);
	dt = _tmp12_;
	_tmp13_ = dt;
	_tmp14_ = numbers;
	_tmp14__length1 = numbers_length1;
	_tmp15_ = _tmp14_[1];
	_tmp16_ = g_date_time_add_months (_tmp13_, atoi (_tmp15_) - 1);
	_g_date_time_unref0 (dt);
	dt = _tmp16_;
	result = dt;
	numbers = (_vala_array_free (numbers, numbers_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (month_page);
	return result;
}

/** Set the values of month_range and data_range.
     *
     * month_range contains the entire month starting with month_start.
     *
     * data_range fills in the rest of the visible calendar block, including the
     *  week before the month starts and the week after it ends.
     */
static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
calendar_event_store_compute_ranges (CalendarEventStore* self)
{
	GSettings* _tmp0_;
	GDateTime* month_end = NULL;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	CalendarUtilDateRange* _tmp9_;
	CalendarUtilDateRange* _tmp10_;
	gint dow = 0;
	GDateTime* _tmp11_;
	gint wso = 0;
	GDateWeekday _tmp12_;
	gint offset = 0;
	GDateTime* data_range_first = NULL;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* data_range_last = NULL;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	CalendarUtilDateRange* _tmp19_;
	CalendarUtilDateRange* _tmp20_;
	CalendarUtilDateRange* _tmp21_;
	GeeList* _tmp22_;
	GeeList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GDateTime* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GDateTime* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	GDateTime* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	g_return_if_fail (self != NULL);
	_tmp0_ = calendar_event_store_state_settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		GDateTime* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = calendar_event_store_state_settings;
		_tmp2_ = self->priv->_month_start;
		_tmp3_ = g_date_time_format (_tmp2_, "%Y-%m");
		_tmp4_ = _tmp3_;
		g_settings_set_string (_tmp1_, "month-page", _tmp4_);
		_g_free0 (_tmp4_);
	}
	_tmp5_ = self->priv->_month_start;
	_tmp6_ = g_date_time_add_full (_tmp5_, 0, 1, 0, 0, 0, (gdouble) 0);
	month_end = _tmp6_;
	_tmp7_ = self->priv->_month_start;
	_tmp8_ = month_end;
	_tmp9_ = calendar_util_date_range_new (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	calendar_event_store_set_month_range (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->_month_start;
	dow = g_date_time_get_day_of_week (_tmp11_);
	_tmp12_ = self->priv->_week_starts_on;
	wso = (gint) _tmp12_;
	offset = 0;
	if (wso < dow) {
		offset = dow - wso;
	} else {
		if (wso > dow) {
			offset = (7 + dow) - wso;
		}
	}
	_tmp13_ = self->priv->_month_start;
	_tmp14_ = g_date_time_add_days (_tmp13_, -offset);
	data_range_first = _tmp14_;
	_tmp15_ = month_end;
	dow = g_date_time_get_day_of_week (_tmp15_);
	offset = 0;
	if (wso < dow) {
		offset = dow - wso;
	} else {
		if (wso > dow) {
			offset = (7 + dow) - wso;
		}
	}
	offset = (-offset) + 7;
	_tmp16_ = month_end;
	_tmp17_ = g_date_time_add_days (_tmp16_, offset);
	data_range_last = _tmp17_;
	_tmp18_ = data_range_first;
	_tmp19_ = calendar_util_date_range_new (_tmp18_, data_range_last);
	_tmp20_ = _tmp19_;
	calendar_event_store_set_data_range (self, _tmp20_);
	_g_object_unref0 (_tmp20_);
	_tmp21_ = self->priv->_data_range;
	_tmp22_ = calendar_util_date_range_to_list (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	calendar_event_store_set_num_weeks (self, _tmp25_ / 7);
	_g_object_unref0 (_tmp23_);
	_tmp26_ = data_range_first;
	_tmp27_ = g_date_time_to_string (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = self->priv->_month_start;
	_tmp30_ = g_date_time_to_string (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = month_end;
	_tmp33_ = g_date_time_to_string (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_date_time_to_string (data_range_last);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat ("Date ranges: (", _tmp28_, " <= ", _tmp31_, " < ", _tmp34_, " <= ", _tmp36_, ")", NULL);
	_tmp38_ = _tmp37_;
	g_debug ("EventStore.vala:386: %s", _tmp38_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp28_);
	_g_date_time_unref0 (data_range_last);
	_g_date_time_unref0 (data_range_first);
	_g_date_time_unref0 (month_end);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->client);
		_g_object_unref0 (_data4_->source);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda5_ (Block4Data* _data4_,
             GSList* objects)
{
	CalendarEventStore* self;
	self = _data4_->self;
	calendar_event_store_on_objects_added (self, _data4_->source, _data4_->client, objects);
}

static void
____lambda5__e_cal_client_view_objects_added (ECalClientView* _sender,
                                              GSList* objects,
                                              gpointer self)
{
	___lambda5_ (self, objects);
}

static void
___lambda8_ (Block4Data* _data4_,
             GSList* objects)
{
	CalendarEventStore* self;
	self = _data4_->self;
	calendar_event_store_on_objects_removed (self, _data4_->source, _data4_->client, objects);
}

static void
____lambda8__e_cal_client_view_objects_removed (ECalClientView* _sender,
                                                GSList* uids,
                                                gpointer self)
{
	___lambda8_ (self, uids);
}

static void
___lambda10_ (Block4Data* _data4_,
              GSList* objects)
{
	CalendarEventStore* self;
	self = _data4_->self;
	calendar_event_store_on_objects_modified (self, _data4_->source, _data4_->client, objects);
}

static void
____lambda10__e_cal_client_view_objects_modified (ECalClientView* _sender,
                                                  GSList* objects,
                                                  gpointer self)
{
	___lambda10_ (self, objects);
}

static void
__lambda4_ (Block4Data* _data4_,
            GObject* obj,
            GAsyncResult* results)
{
	CalendarEventStore* self;
	ECalClientView* view = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	ECalClientView* _tmp13_;
	ECalClientView* _tmp14_;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (results != NULL);
	_tmp0_ = e_source_dup_display_name (_data4_->source);
	_tmp1_ = _tmp0_;
	g_debug ("EventStore.vala:411: Received client-view for source '%s'", _tmp1_);
	_g_free0 (_tmp1_);
	{
		ECalClientView* _tmp2_ = NULL;
		ECalClientView* _tmp3_;
		ECalClientView* _tmp4_;
		ECalClientView* _tmp5_;
		ECalClientView* _tmp6_;
		e_cal_client_get_view_finish (_data4_->client, results, &_tmp2_, &_inner_error0_);
		_g_object_unref0 (view);
		view = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = view;
		g_signal_connect_data (_tmp3_, "objects-added", (GCallback) ____lambda5__e_cal_client_view_objects_added, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp4_ = view;
		g_signal_connect_data (_tmp4_, "objects-removed", (GCallback) ____lambda8__e_cal_client_view_objects_removed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp5_ = view;
		g_signal_connect_data (_tmp5_, "objects-modified", (GCallback) ____lambda10__e_cal_client_view_objects_modified, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_tmp6_ = view;
		e_cal_client_view_start (_tmp6_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e_source_dup_display_name (_data4_->source);
		_tmp8_ = _tmp7_;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("EventStore.vala:419: Error from source '%s': %s", _tmp8_, _tmp10_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (view);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = self->priv->source_view;
	_tmp12_ = e_source_dup_uid (_data4_->source);
	_tmp13_ = view;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	g_hash_table_insert (_tmp11_, _tmp12_, _tmp14_);
	_g_object_unref0 (view);
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block4_data_unref (self);
}

static void
calendar_event_store_load_source (CalendarEventStore* self,
                                  ESource* source)
{
	Block4Data* _data4_;
	ESource* _tmp0_;
	GeeTreeMultiMap* events = NULL;
	GCompareFunc _tmp1_;
	GeeTreeMultiMap* _tmp2_;
	GHashTable* _tmp3_;
	ESource* _tmp4_;
	GeeTreeMultiMap* _tmp5_;
	gchar* iso_first = NULL;
	CalendarUtilDateRange* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	gchar* _tmp9_;
	gchar* iso_last = NULL;
	CalendarUtilDateRange* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* query = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data4_->source);
	_data4_->source = _tmp0_;
	_tmp1_ = ((GCompareFunc) g_strcmp0);
	_tmp2_ = gee_tree_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GCompareDataFunc) _tmp1_, NULL, NULL, (GCompareDataFunc) calendar_util_ecalcomponent_compare_func, NULL, NULL);
	events = _tmp2_;
	_tmp3_ = self->priv->source_events;
	_tmp4_ = _g_object_ref0 (_data4_->source);
	_tmp5_ = _g_object_ref0 (events);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = self->priv->_data_range;
	_tmp7_ = calendar_util_date_range_get_first_dt (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = isodate_from_time_t ((time_t) g_date_time_to_unix (_tmp8_));
	iso_first = _tmp9_;
	_tmp10_ = self->priv->_data_range;
	_tmp11_ = calendar_util_date_range_get_last_dt (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_date_time_add_days (_tmp12_, 1);
	_tmp14_ = _tmp13_;
	_tmp15_ = isodate_from_time_t ((time_t) g_date_time_to_unix (_tmp14_));
	_tmp16_ = _tmp15_;
	_g_date_time_unref0 (_tmp14_);
	iso_last = _tmp16_;
	_tmp17_ = string_to_string (iso_first);
	_tmp18_ = string_to_string (iso_last);
	_tmp19_ = g_strconcat ("(occur-in-time-range? (make-time \"", _tmp17_, "\") (make-time \"", _tmp18_, "\"))", NULL);
	query = _tmp19_;
	{
		GHashTable* _tmp20_;
		_tmp20_ = self->priv->source_client;
		g_rec_mutex_lock (&self->priv->__lock_source_client);
		{
			GHashTable* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gconstpointer _tmp24_;
			ECalClient* _tmp25_;
			_tmp21_ = self->priv->source_client;
			_tmp22_ = e_source_dup_uid (_data4_->source);
			_tmp23_ = _tmp22_;
			_tmp24_ = g_hash_table_lookup (_tmp21_, _tmp23_);
			_tmp25_ = _g_object_ref0 ((ECalClient*) _tmp24_);
			_g_object_unref0 (_data4_->client);
			_data4_->client = _tmp25_;
			_g_free0 (_tmp23_);
		}
		__finally0:
		{
			GHashTable* _tmp26_;
			_tmp26_ = self->priv->source_client;
			g_rec_mutex_unlock (&self->priv->__lock_source_client);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (query);
			_g_free0 (iso_last);
			_g_free0 (iso_first);
			_g_object_unref0 (events);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (_data4_->client == NULL) {
		_g_free0 (query);
		_g_free0 (iso_last);
		_g_free0 (iso_first);
		_g_object_unref0 (events);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_tmp27_ = e_source_dup_display_name (_data4_->source);
	_tmp28_ = _tmp27_;
	g_debug ("EventStore.vala:408: Getting client-view for source '%s'", _tmp28_);
	_g_free0 (_tmp28_);
	e_cal_client_get_view (_data4_->client, query, NULL, ___lambda4__gasync_ready_callback, block4_data_ref (_data4_));
	_g_free0 (query);
	_g_free0 (iso_last);
	_g_free0 (iso_first);
	_g_object_unref0 (events);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
calendar_event_store_add_source_async_data_free (gpointer _data)
{
	CalendarEventStoreAddSourceAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (CalendarEventStoreAddSourceAsyncData, _data_);
}

static void
calendar_event_store_add_source_async (CalendarEventStore* self,
                                       ESource* source,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	CalendarEventStoreAddSourceAsyncData* _data_;
	CalendarEventStore* _tmp0_;
	ESource* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (CalendarEventStoreAddSourceAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, calendar_event_store_add_source_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	calendar_event_store_add_source_async_co (_data_);
}

static void
calendar_event_store_add_source_finish (CalendarEventStore* self,
                                        GAsyncResult* _res_)
{
	CalendarEventStoreAddSourceAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->source);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
calendar_event_store_add_source_async_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	CalendarEventStoreAddSourceAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	calendar_event_store_add_source_async_co (_data_);
}

static gboolean
__lambda13_ (Block5Data* _data5_)
{
	CalendarEventStore* self;
	gboolean result;
	self = _data5_->self;
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_CONNECTED_SIGNAL], 0, _data5_->source);
	calendar_event_store_load_source (self, _data5_->source);
	result = FALSE;
	return result;
}

static gboolean
___lambda13__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda13_ (self);
	return result;
}

static gboolean
calendar_event_store_add_source_async_co (CalendarEventStoreAddSourceAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data5_ = g_slice_new0 (Block5Data);
	_data_->_data5_->_ref_count_ = 1;
	_data_->_data5_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data5_->source);
	_data_->_data5_->source = _data_->source;
	_data_->_data5_->_async_data_ = _data_;
	_data_->_tmp0_ = e_source_dup_display_name (_data_->_data5_->source);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_debug ("EventStore.vala:428: Adding source '%s'", _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	{
		_data_->_tmp2_ = g_cancellable_new ();
		_data_->cancellable = _data_->_tmp2_;
		g_signal_emit (_data_->self, calendar_event_store_signals[CALENDAR_EVENT_STORE_CONNECTING_SIGNAL], 0, _data_->_data5_->source, _data_->cancellable);
		_data_->_state_ = 1;
		e_cal_client_connect (_data_->_data5_->source, E_CAL_CLIENT_SOURCE_TYPE_EVENTS, (guint32) -1, _data_->cancellable, calendar_event_store_add_source_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp4_ = e_cal_client_connect_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->cancellable);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, e_cal_client_get_type (), ECalClient));
		_data_->client = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->self->priv->source_client;
		_data_->_tmp7_ = e_source_get_uid (_data_->_data5_->source);
		_data_->_tmp8_ = g_strdup (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->client;
		_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
		g_hash_table_insert (_data_->_tmp6_, _data_->_tmp8_, _data_->_tmp10_);
		_g_object_unref0 (_data_->client);
		_g_object_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->cancellable);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		g_signal_emit (_data_->self, calendar_event_store_signals[CALENDAR_EVENT_STORE_ERROR_RECEIVED_SIGNAL], 0, _data_->_tmp12_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		block5_data_unref (_data_->_data5_);
		_data_->_data5_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda13__gsource_func, block5_data_ref (_data_->_data5_), block5_data_unref);
	block5_data_unref (_data_->_data5_);
	_data_->_data5_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_ECalComponentId_free (ECalComponentId* self)
{
	g_boxed_free (e_cal_component_id_get_type (), self);
}

static void
calendar_event_store_debug_event (CalendarEventStore* self,
                                  ESource* source,
                                  ECalComponent* event,
                                  const gchar* message)
{
	ICalComponent* comp = NULL;
	ICalComponent* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	ICalTime* _tmp9_;
	ICalTime* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ECalComponentId* _tmp16_;
	ECalComponentId* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = e_cal_component_get_icalcomponent (event);
	comp = _tmp0_;
	_tmp1_ = string_to_string (message);
	_tmp2_ = i_cal_component_get_summary (comp);
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = e_source_dup_display_name (source);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = i_cal_component_get_uid (comp);
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = i_cal_component_get_dtstart (comp);
	_tmp10_ = _tmp9_;
	_tmp11_ = i_cal_time_as_ical_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = g_strconcat (_tmp1_, " Event ['", _tmp3_, "', ", _tmp6_, ", UID ", _tmp8_, ", START ", _tmp13_, ", RID %s )]", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = e_cal_component_get_id (event);
	_tmp17_ = _tmp16_;
	_tmp18_ = e_cal_component_id_get_rid (_tmp17_);
	g_debug (_tmp15_, _tmp18_);
	__vala_ECalComponentId_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
	_g_free0 (_tmp5_);
}

static void
calendar_event_store_on_parameter_changed (CalendarEventStore* self)
{
	g_return_if_fail (self != NULL);
	calendar_event_store_compute_ranges (self);
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_PARAMETERS_CHANGED_SIGNAL], 0);
	calendar_event_store_load_all_sources (self);
}

static void
calendar_event_store_on_source_changed (CalendarEventStore* self,
                                        ESource* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->added_events);
		_g_object_unref0 (_data6_->events);
		_g_object_unref0 (_data6_->source);
		_g_object_unref0 (_data6_->client);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data7_->_data6_->self;
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		g_slice_free (Block7Data, _data7_);
	}
}

static gboolean
__lambda7_ (Block7Data* _data7_,
            ICalComponent* comp,
            ICalTime* start,
            ICalTime* end,
            GError** error)
{
	Block6Data* _data6_;
	CalendarEventStore* self;
	ECalComponent* event = NULL;
	ICalComponent* _tmp0_;
	ECalComponent* _tmp1_;
	ECalComponent* _tmp2_;
	gboolean result;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	g_return_val_if_fail (comp != NULL, FALSE);
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (end != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (comp);
	_tmp1_ = e_cal_component_new_from_icalcomponent (_tmp0_);
	event = _tmp1_;
	_tmp2_ = event;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _data6_->added_events, _tmp2_)) {
		ECalComponent* _tmp3_;
		ECalComponent* _tmp4_;
		ESource* _tmp5_;
		ECalComponent* _tmp6_;
		ECalComponent* _tmp7_;
		_tmp3_ = event;
		calendar_event_store_debug_event (self, _data6_->source, _tmp3_, "ADDED");
		_tmp4_ = event;
		_tmp5_ = _g_object_ref0 (_data6_->source);
		g_object_set_data_full ((GObject*) _tmp4_, "source", _tmp5_, g_object_unref);
		_tmp6_ = event;
		gee_multi_map_set ((GeeMultiMap*) _data6_->events, _data7_->uid, _tmp6_);
		_tmp7_ = event;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data6_->added_events, _tmp7_);
	}
	result = TRUE;
	_g_object_unref0 (event);
	return result;
}

static gboolean
___lambda7__ecal_recur_instance_cb (ICalComponent* icomp,
                                    ICalTime* instance_start,
                                    ICalTime* instance_end,
                                    gpointer self,
                                    GCancellable* cancellable,
                                    GError** error)
{
	gboolean result;
	result = __lambda7_ (self, icomp, instance_start, instance_end, error);
	return result;
}

static void
__lambda6_ (Block6Data* _data6_,
            ICalComponent* comp)
{
	CalendarEventStore* self;
	Block7Data* _data7_;
	const gchar* _tmp0_;
	CalendarUtilDateRange* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	CalendarUtilDateRange* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	self = _data6_->self;
	g_return_if_fail (comp != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->_data6_ = block6_data_ref (_data6_);
	_tmp0_ = i_cal_component_get_uid (comp);
	_data7_->uid = _tmp0_;
	_tmp1_ = self->priv->_data_range;
	_tmp2_ = calendar_util_date_range_get_first_dt (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_data_range;
	_tmp5_ = calendar_util_date_range_get_last_dt (_tmp4_);
	_tmp6_ = _tmp5_;
	e_cal_client_generate_instances_for_object_sync (_data6_->client, comp, (time_t) g_date_time_to_unix (_tmp3_), (time_t) g_date_time_to_unix (_tmp6_), NULL, ___lambda7__ecal_recur_instance_cb, _data7_);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
___lambda6__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda6_ (self, (ICalComponent*) data);
}

static void
calendar_event_store_on_objects_added (CalendarEventStore* self,
                                       ESource* source,
                                       ECalClient* client,
                                       GSList* objects)
{
	Block6Data* _data6_;
	ESource* _tmp0_;
	ECalClient* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GHashTable* _tmp8_;
	gconstpointer _tmp9_;
	GeeTreeMultiMap* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeBidirList* _tmp12_;
	GeeBidirList* _tmp13_;
	GeeBidirList* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (client != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data6_->source);
	_data6_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (client);
	_g_object_unref0 (_data6_->client);
	_data6_->client = _tmp1_;
	_tmp2_ = g_strdup_printf ("%u", g_slist_length (objects));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Received ", _tmp3_, " added event(s) for source '%s'", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_source_dup_display_name (_data6_->source);
	_tmp7_ = _tmp6_;
	g_debug (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp8_ = self->priv->source_events;
	_tmp9_ = g_hash_table_lookup (_tmp8_, _data6_->source);
	_tmp10_ = _g_object_ref0 ((GeeTreeMultiMap*) _tmp9_);
	_data6_->events = _tmp10_;
	_tmp11_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) calendar_util_ecalcomponent_equal_func, NULL, NULL);
	_data6_->added_events = _tmp11_;
	g_slist_foreach (objects, ___lambda6__gfunc, _data6_);
	_tmp12_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data6_->added_events);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_ADDED_SIGNAL], 0, _data6_->source, (GeeCollection*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->added_events);
		_g_object_unref0 (_data8_->removed_events);
		_g_object_unref0 (_data8_->updated_events);
		_g_object_unref0 (_data8_->source);
		_g_object_unref0 (_data8_->client);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data9_->_data8_->self;
		_g_object_unref0 (_data9_->events_for_source);
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		g_slice_free (Block9Data, _data9_);
	}
}

static gboolean
___lambda12_ (Block9Data* _data9_,
              ICalComponent* comp,
              ICalTime* start,
              ICalTime* end,
              GError** error)
{
	Block8Data* _data8_;
	CalendarEventStore* self;
	ECalComponent* event = NULL;
	ICalComponent* _tmp0_;
	ECalComponent* _tmp1_;
	ESource* _tmp2_;
	GeeTreeMultiMap* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	g_return_val_if_fail (comp != NULL, FALSE);
	g_return_val_if_fail (start != NULL, FALSE);
	g_return_val_if_fail (end != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (comp);
	_tmp1_ = e_cal_component_new_from_icalcomponent (_tmp0_);
	event = _tmp1_;
	_tmp2_ = _g_object_ref0 (_data8_->source);
	g_object_set_data_full ((GObject*) event, "source", _tmp2_, g_object_unref);
	calendar_event_store_debug_event (self, _data8_->source, event, "MODIFIED - GENERATED");
	_tmp3_ = _data9_->events_for_source;
	_tmp4_ = _data9_->uid;
	gee_multi_map_set ((GeeMultiMap*) _tmp3_, _tmp4_, event);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->added_events, event);
	result = TRUE;
	_g_object_unref0 (event);
	return result;
}

static gboolean
____lambda12__ecal_recur_instance_cb (ICalComponent* icomp,
                                      ICalTime* instance_start,
                                      ICalTime* instance_end,
                                      gpointer self,
                                      GCancellable* cancellable,
                                      GError** error)
{
	gboolean result;
	result = ___lambda12_ (self, icomp, instance_start, instance_end, error);
	return result;
}

static void
__lambda11_ (Block8Data* _data8_,
             ICalComponent* comp)
{
	CalendarEventStore* self;
	Block9Data* _data9_;
	const gchar* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	GeeTreeMultiMap* _tmp3_;
	GeeCollection* events_for_uid = NULL;
	GeeTreeMultiMap* _tmp4_;
	const gchar* _tmp5_;
	GeeCollection* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	GeeCollection* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	self = _data8_->self;
	g_return_if_fail (comp != NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->_data8_ = block8_data_ref (_data8_);
	_tmp0_ = i_cal_component_get_uid (comp);
	_data9_->uid = _tmp0_;
	_tmp1_ = self->priv->source_events;
	_tmp2_ = g_hash_table_lookup (_tmp1_, _data8_->source);
	_tmp3_ = _g_object_ref0 ((GeeTreeMultiMap*) _tmp2_);
	_data9_->events_for_source = _tmp3_;
	_tmp4_ = _data9_->events_for_source;
	_tmp5_ = _data9_->uid;
	_tmp6_ = gee_multi_map_get ((GeeMultiMap*) _tmp4_, _tmp5_);
	events_for_uid = _tmp6_;
	_tmp9_ = events_for_uid;
	_tmp10_ = gee_collection_get_size (_tmp9_);
	_tmp11_ = _tmp10_;
	if (_tmp11_ > 1) {
		_tmp8_ = TRUE;
	} else {
		GeeCollection* _tmp12_;
		gint _tmp13_ = 0;
		gpointer* _tmp14_;
		ECalComponent** _tmp15_;
		gint _tmp15__length1;
		ECalComponent* _tmp16_;
		ICalComponent* _tmp17_;
		ICalTime* _tmp18_;
		ICalTime* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp12_ = events_for_uid;
		_tmp14_ = gee_collection_to_array (_tmp12_, &_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _tmp13_;
		_tmp16_ = _tmp15_[0];
		_tmp17_ = e_cal_component_get_icalcomponent (_tmp16_);
		_tmp18_ = i_cal_component_get_recurrenceid (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = i_cal_time_as_ical_string (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp8_ = _tmp21_ != NULL;
		_g_free0 (_tmp21_);
		_g_object_unref0 (_tmp19_);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_object_unref), NULL);
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		ICalTime* _tmp22_;
		ICalTime* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = i_cal_component_get_recurrenceid (comp);
		_tmp23_ = _tmp22_;
		_tmp24_ = i_cal_time_as_ical_string (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp7_ = _tmp25_ != NULL;
		_g_free0 (_tmp25_);
		_g_object_unref0 (_tmp23_);
	}
	if (_tmp7_) {
		GeeTreeMultiMap* _tmp26_;
		const gchar* _tmp27_;
		CalendarUtilDateRange* _tmp35_;
		GDateTime* _tmp36_;
		GDateTime* _tmp37_;
		CalendarUtilDateRange* _tmp38_;
		GDateTime* _tmp39_;
		GDateTime* _tmp40_;
		_tmp26_ = _data9_->events_for_source;
		_tmp27_ = _data9_->uid;
		gee_multi_map_remove_all ((GeeMultiMap*) _tmp26_, _tmp27_);
		{
			GeeIterator* _event_it = NULL;
			GeeCollection* _tmp28_;
			GeeIterator* _tmp29_;
			_tmp28_ = events_for_uid;
			_tmp29_ = gee_iterable_iterator ((GeeIterable*) _tmp28_);
			_event_it = _tmp29_;
			while (TRUE) {
				GeeIterator* _tmp30_;
				ECalComponent* event = NULL;
				GeeIterator* _tmp31_;
				gpointer _tmp32_;
				ECalComponent* _tmp33_;
				ECalComponent* _tmp34_;
				_tmp30_ = _event_it;
				if (!gee_iterator_next (_tmp30_)) {
					break;
				}
				_tmp31_ = _event_it;
				_tmp32_ = gee_iterator_get (_tmp31_);
				event = (ECalComponent*) _tmp32_;
				_tmp33_ = event;
				calendar_event_store_debug_event (self, _data8_->source, _tmp33_, "MODIFIED - ORIGINAL");
				_tmp34_ = event;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->removed_events, _tmp34_);
				_g_object_unref0 (event);
			}
			_g_object_unref0 (_event_it);
		}
		_tmp35_ = self->priv->_data_range;
		_tmp36_ = calendar_util_date_range_get_first_dt (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = self->priv->_data_range;
		_tmp39_ = calendar_util_date_range_get_last_dt (_tmp38_);
		_tmp40_ = _tmp39_;
		e_cal_client_generate_instances_for_object_sync (_data8_->client, comp, (time_t) g_date_time_to_unix (_tmp37_), (time_t) g_date_time_to_unix (_tmp40_), NULL, ____lambda12__ecal_recur_instance_cb, _data9_);
	} else {
		GeeCollection* _tmp41_;
		gint _tmp42_ = 0;
		gpointer* _tmp43_;
		ECalComponent** _tmp44_;
		gint _tmp44__length1;
		ECalComponent* _tmp45_;
		GeeCollection* _tmp46_;
		gint _tmp47_ = 0;
		gpointer* _tmp48_;
		ECalComponent** _tmp49_;
		gint _tmp49__length1;
		ECalComponent* _tmp50_;
		_tmp41_ = events_for_uid;
		_tmp43_ = gee_collection_to_array (_tmp41_, &_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp44__length1 = _tmp42_;
		_tmp45_ = _tmp44_[0];
		calendar_event_store_debug_event (self, _data8_->source, _tmp45_, "MODIFIED - UPDATED");
		_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_object_unref), NULL);
		_tmp46_ = events_for_uid;
		_tmp48_ = gee_collection_to_array (_tmp46_, &_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp49__length1 = _tmp47_;
		_tmp50_ = _tmp49_[0];
		gee_abstract_collection_add ((GeeAbstractCollection*) _data8_->updated_events, _tmp50_);
		_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_g_object_unref0 (events_for_uid);
	block9_data_unref (_data9_);
	_data9_ = NULL;
}

static void
___lambda11__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda11_ (self, (ICalComponent*) data);
}

static void
calendar_event_store_on_objects_modified (CalendarEventStore* self,
                                          ESource* source,
                                          ECalClient* client,
                                          GSList* objects)
{
	Block8Data* _data8_;
	ESource* _tmp0_;
	ECalClient* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeBidirList* _tmp11_;
	GeeBidirList* _tmp12_;
	GeeBidirList* _tmp13_;
	GeeBidirList* _tmp14_;
	GeeBidirList* _tmp15_;
	GeeBidirList* _tmp16_;
	GeeBidirList* _tmp17_;
	GeeBidirList* _tmp18_;
	GeeBidirList* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (client != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data8_->source);
	_data8_->source = _tmp0_;
	_tmp1_ = _g_object_ref0 (client);
	_g_object_unref0 (_data8_->client);
	_data8_->client = _tmp1_;
	_tmp2_ = g_strdup_printf ("%u", g_slist_length (objects));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Received ", _tmp3_, " modified event(s) for source '%s'", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_source_dup_display_name (_data8_->source);
	_tmp7_ = _tmp6_;
	g_debug (_tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp8_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) calendar_util_ecalcomponent_equal_func, NULL, NULL);
	_data8_->updated_events = _tmp8_;
	_tmp9_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) calendar_util_ecalcomponent_equal_func, NULL, NULL);
	_data8_->removed_events = _tmp9_;
	_tmp10_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) calendar_util_ecalcomponent_equal_func, NULL, NULL);
	_data8_->added_events = _tmp10_;
	g_slist_foreach (objects, ___lambda11__gfunc, _data8_);
	_tmp11_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data8_->removed_events);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_REMOVED_SIGNAL], 0, _data8_->source, (GeeCollection*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data8_->added_events);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_ADDED_SIGNAL], 0, _data8_->source, (GeeCollection*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data8_->updated_events);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_UPDATED_SIGNAL], 0, _data8_->source, (GeeCollection*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		CalendarEventStore* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->removed_events);
		_g_object_unref0 (_data10_->events);
		_g_object_unref0 (_data10_->source);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda9_ (Block10Data* _data10_,
            ECalComponentId* cid)
{
	CalendarEventStore* self;
	GeeCollection* comps = NULL;
	const gchar* _tmp0_;
	GeeCollection* _tmp1_;
	const gchar* _tmp2_;
	self = _data10_->self;
	if (cid == NULL) {
		return;
	}
	_tmp0_ = e_cal_component_id_get_uid (cid);
	_tmp1_ = gee_multi_map_get ((GeeMultiMap*) _data10_->events, _tmp0_);
	comps = _tmp1_;
	_tmp2_ = e_cal_component_id_get_uid (cid);
	gee_multi_map_remove_all ((GeeMultiMap*) _data10_->events, _tmp2_);
	{
		GeeIterator* _event_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = comps;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_event_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			ECalComponent* event = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			ECalComponent* _tmp8_;
			ECalComponent* _tmp9_;
			_tmp5_ = _event_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _event_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			event = (ECalComponent*) _tmp7_;
			_tmp8_ = event;
			gee_abstract_collection_add ((GeeAbstractCollection*) _data10_->removed_events, _tmp8_);
			_tmp9_ = event;
			calendar_event_store_debug_event (self, _data10_->source, _tmp9_, "");
			_g_object_unref0 (event);
		}
		_g_object_unref0 (_event_it);
	}
	_g_object_unref0 (comps);
}

static void
___lambda9__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda9_ (self, (ECalComponentId*) data);
}

static void
calendar_event_store_on_objects_removed (CalendarEventStore* self,
                                         ESource* source,
                                         ECalClient* client,
                                         GSList* cids)
{
	Block10Data* _data10_;
	ESource* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GHashTable* _tmp7_;
	gconstpointer _tmp8_;
	GeeTreeMultiMap* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeBidirList* _tmp11_;
	GeeBidirList* _tmp12_;
	GeeBidirList* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (client != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data10_->source);
	_data10_->source = _tmp0_;
	_tmp1_ = g_strdup_printf ("%u", g_slist_length (cids));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("Received ", _tmp2_, " removed event(s) for source '%s'", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = e_source_dup_display_name (_data10_->source);
	_tmp6_ = _tmp5_;
	g_debug (_tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->source_events;
	_tmp8_ = g_hash_table_lookup (_tmp7_, _data10_->source);
	_tmp9_ = _g_object_ref0 ((GeeTreeMultiMap*) _tmp8_);
	_data10_->events = _tmp9_;
	_tmp10_ = gee_array_list_new (e_cal_component_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeEqualDataFunc) calendar_util_ecalcomponent_equal_func, NULL, NULL);
	_data10_->removed_events = _tmp10_;
	g_slist_foreach (cids, ___lambda9__gfunc, _data10_);
	_tmp11_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _data10_->removed_events);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	g_signal_emit (self, calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_REMOVED_SIGNAL], 0, _data10_->source, (GeeCollection*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

CalendarUtilDateRange*
calendar_event_store_get_data_range (CalendarEventStore* self)
{
	CalendarUtilDateRange* result;
	CalendarUtilDateRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_range;
	result = _tmp0_;
	return result;
}

static void
calendar_event_store_set_data_range (CalendarEventStore* self,
                                     CalendarUtilDateRange* value)
{
	CalendarUtilDateRange* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_event_store_get_data_range (self);
	if (old_value != value) {
		CalendarUtilDateRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_data_range);
		self->priv->_data_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_event_store_properties[CALENDAR_EVENT_STORE_DATA_RANGE_PROPERTY]);
	}
}

CalendarUtilDateRange*
calendar_event_store_get_month_range (CalendarEventStore* self)
{
	CalendarUtilDateRange* result;
	CalendarUtilDateRange* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_month_range;
	result = _tmp0_;
	return result;
}

static void
calendar_event_store_set_month_range (CalendarEventStore* self,
                                      CalendarUtilDateRange* value)
{
	CalendarUtilDateRange* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_event_store_get_month_range (self);
	if (old_value != value) {
		CalendarUtilDateRange* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_month_range);
		self->priv->_month_range = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_event_store_properties[CALENDAR_EVENT_STORE_MONTH_RANGE_PROPERTY]);
	}
}

ESourceRegistry*
calendar_event_store_get_registry (CalendarEventStore* self)
{
	ESourceRegistry* result;
	ESourceRegistry* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_registry;
	result = _tmp0_;
	return result;
}

static void
calendar_event_store_set_registry (CalendarEventStore* self,
                                   ESourceRegistry* value)
{
	ESourceRegistry* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_event_store_get_registry (self);
	if (old_value != value) {
		ESourceRegistry* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_registry);
		self->priv->_registry = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_event_store_properties[CALENDAR_EVENT_STORE_REGISTRY_PROPERTY]);
	}
}

GDateTime*
calendar_event_store_get_month_start (CalendarEventStore* self)
{
	GDateTime* result;
	GDateTime* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_month_start;
	result = _tmp0_;
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

void
calendar_event_store_set_month_start (CalendarEventStore* self,
                                      GDateTime* value)
{
	GDateTime* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_event_store_get_month_start (self);
	if (old_value != value) {
		GDateTime* _tmp0_;
		_tmp0_ = _g_date_time_ref0 (value);
		_g_date_time_unref0 (self->priv->_month_start);
		self->priv->_month_start = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_event_store_properties[CALENDAR_EVENT_STORE_MONTH_START_PROPERTY]);
	}
}

gint
calendar_event_store_get_num_weeks (CalendarEventStore* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_num_weeks;
	return result;
}

static void
calendar_event_store_set_num_weeks (CalendarEventStore* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_event_store_get_num_weeks (self);
	if (old_value != value) {
		self->priv->_num_weeks = value;
		g_object_notify_by_pspec ((GObject *) self, calendar_event_store_properties[CALENDAR_EVENT_STORE_NUM_WEEKS_PROPERTY]);
	}
}

GDateWeekday
calendar_event_store_get_week_starts_on (CalendarEventStore* self)
{
	GDateWeekday result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_week_starts_on;
	return result;
}

void
calendar_event_store_set_week_starts_on (CalendarEventStore* self,
                                         GDateWeekday value)
{
	GDateWeekday old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_event_store_get_week_starts_on (self);
	if (old_value != value) {
		self->priv->_week_starts_on = value;
		g_object_notify_by_pspec ((GObject *) self, calendar_event_store_properties[CALENDAR_EVENT_STORE_WEEK_STARTS_ON_PROPERTY]);
	}
}

ECalComponent*
calendar_event_store_get_drag_component (CalendarEventStore* self)
{
	ECalComponent* result;
	ECalComponent* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drag_component;
	result = _tmp0_;
	return result;
}

void
calendar_event_store_set_drag_component (CalendarEventStore* self,
                                         ECalComponent* value)
{
	ECalComponent* old_value;
	g_return_if_fail (self != NULL);
	old_value = calendar_event_store_get_drag_component (self);
	if (old_value != value) {
		ECalComponent* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_drag_component);
		self->priv->_drag_component = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, calendar_event_store_properties[CALENDAR_EVENT_STORE_DRAG_COMPONENT_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
calendar_event_store_class_init (CalendarEventStoreClass * klass,
                                 gpointer klass_data)
{
	GSettingsSchemaSource* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gboolean _tmp3_;
	calendar_event_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarEventStore_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_calendar_event_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_calendar_event_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = calendar_event_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_EVENT_STORE_DATA_RANGE_PROPERTY, calendar_event_store_properties[CALENDAR_EVENT_STORE_DATA_RANGE_PROPERTY] = g_param_spec_object ("data-range", "data-range", "data-range", CALENDAR_UTIL_TYPE_DATE_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_EVENT_STORE_MONTH_RANGE_PROPERTY, calendar_event_store_properties[CALENDAR_EVENT_STORE_MONTH_RANGE_PROPERTY] = g_param_spec_object ("month-range", "month-range", "month-range", CALENDAR_UTIL_TYPE_DATE_RANGE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_EVENT_STORE_REGISTRY_PROPERTY, calendar_event_store_properties[CALENDAR_EVENT_STORE_REGISTRY_PROPERTY] = g_param_spec_object ("registry", "registry", "registry", e_source_registry_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_EVENT_STORE_MONTH_START_PROPERTY, calendar_event_store_properties[CALENDAR_EVENT_STORE_MONTH_START_PROPERTY] = g_param_spec_boxed ("month-start", "month-start", "month-start", G_TYPE_DATE_TIME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_EVENT_STORE_NUM_WEEKS_PROPERTY, calendar_event_store_properties[CALENDAR_EVENT_STORE_NUM_WEEKS_PROPERTY] = g_param_spec_int ("num-weeks", "num-weeks", "num-weeks", G_MININT, G_MAXINT, 6, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_EVENT_STORE_WEEK_STARTS_ON_PROPERTY, calendar_event_store_properties[CALENDAR_EVENT_STORE_WEEK_STARTS_ON_PROPERTY] = g_param_spec_int ("week-starts-on", "week-starts-on", "week-starts-on", G_MININT, G_MAXINT, G_DATE_MONDAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALENDAR_EVENT_STORE_DRAG_COMPONENT_PROPERTY, calendar_event_store_properties[CALENDAR_EVENT_STORE_DRAG_COMPONENT_PROPERTY] = g_param_spec_object ("drag-component", "drag-component", "drag-component", e_cal_component_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_ADDED_SIGNAL] = g_signal_new ("events-added", CALENDAR_TYPE_EVENT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, e_source_get_type (), GEE_TYPE_COLLECTION);
	calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_UPDATED_SIGNAL] = g_signal_new ("events-updated", CALENDAR_TYPE_EVENT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, e_source_get_type (), GEE_TYPE_COLLECTION);
	calendar_event_store_signals[CALENDAR_EVENT_STORE_EVENTS_REMOVED_SIGNAL] = g_signal_new ("events-removed", CALENDAR_TYPE_EVENT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, e_source_get_type (), GEE_TYPE_COLLECTION);
	calendar_event_store_signals[CALENDAR_EVENT_STORE_CONNECTING_SIGNAL] = g_signal_new ("connecting", CALENDAR_TYPE_EVENT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, e_source_get_type (), g_cancellable_get_type ());
	calendar_event_store_signals[CALENDAR_EVENT_STORE_CONNECTED_SIGNAL] = g_signal_new ("connected", CALENDAR_TYPE_EVENT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, e_source_get_type ());
	calendar_event_store_signals[CALENDAR_EVENT_STORE_ERROR_RECEIVED_SIGNAL] = g_signal_new ("error-received", CALENDAR_TYPE_EVENT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	calendar_event_store_signals[CALENDAR_EVENT_STORE_PARAMETERS_CHANGED_SIGNAL] = g_signal_new ("parameters-changed", CALENDAR_TYPE_EVENT_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_schema_source_get_default ();
	_tmp1_ = g_settings_schema_source_lookup (_tmp0_, "io.elementary.calendar.savedstate", TRUE);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_settings_schema_unref0 (_tmp2_);
	if (_tmp3_) {
		GSettings* _tmp4_;
		_tmp4_ = g_settings_new ("io.elementary.calendar.savedstate");
		_g_object_unref0 (calendar_event_store_state_settings);
		calendar_event_store_state_settings = _tmp4_;
	}
}

static void
calendar_event_store_instance_init (CalendarEventStore * self,
                                    gpointer klass)
{
	self->priv = calendar_event_store_get_instance_private (self);
	self->priv->_num_weeks = 6;
	self->priv->_week_starts_on = G_DATE_MONDAY;
	g_rec_mutex_init (&self->priv->__lock_source_client);
}

static void
calendar_event_store_finalize (GObject * obj)
{
	CalendarEventStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CALENDAR_TYPE_EVENT_STORE, CalendarEventStore);
	_g_object_unref0 (self->priv->_data_range);
	_g_object_unref0 (self->priv->_month_range);
	_g_object_unref0 (self->priv->_registry);
	_g_date_time_unref0 (self->priv->_month_start);
	_g_object_unref0 (self->priv->_drag_component);
	g_rec_mutex_clear (&self->priv->__lock_source_client);
	_g_hash_table_unref0 (self->priv->source_client);
	_g_hash_table_unref0 (self->priv->source_view);
	_g_hash_table_unref0 (self->priv->source_events);
	(self->calendar_trash == NULL) ? NULL : (self->calendar_trash = (_g_queue_free__g_object_unref0_ (self->calendar_trash), NULL));
	_g_object_unref0 (self->priv->credentials_prompter);
	G_OBJECT_CLASS (calendar_event_store_parent_class)->finalize (obj);
}

static GType
calendar_event_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarEventStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_event_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarEventStore), 0, (GInstanceInitFunc) calendar_event_store_instance_init, NULL };
	GType calendar_event_store_type_id;
	calendar_event_store_type_id = g_type_register_static (G_TYPE_OBJECT, "CalendarEventStore", &g_define_type_info, 0);
	CalendarEventStore_private_offset = g_type_add_instance_private (calendar_event_store_type_id, sizeof (CalendarEventStorePrivate));
	return calendar_event_store_type_id;
}

GType
calendar_event_store_get_type (void)
{
	static volatile gsize calendar_event_store_type_id__once = 0;
	if (g_once_init_enter (&calendar_event_store_type_id__once)) {
		GType calendar_event_store_type_id;
		calendar_event_store_type_id = calendar_event_store_get_type_once ();
		g_once_init_leave (&calendar_event_store_type_id__once, calendar_event_store_type_id);
	}
	return calendar_event_store_type_id__once;
}

static void
_vala_calendar_event_store_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	CalendarEventStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_EVENT_STORE, CalendarEventStore);
	switch (property_id) {
		case CALENDAR_EVENT_STORE_DATA_RANGE_PROPERTY:
		g_value_set_object (value, calendar_event_store_get_data_range (self));
		break;
		case CALENDAR_EVENT_STORE_MONTH_RANGE_PROPERTY:
		g_value_set_object (value, calendar_event_store_get_month_range (self));
		break;
		case CALENDAR_EVENT_STORE_REGISTRY_PROPERTY:
		g_value_set_object (value, calendar_event_store_get_registry (self));
		break;
		case CALENDAR_EVENT_STORE_MONTH_START_PROPERTY:
		g_value_set_boxed (value, calendar_event_store_get_month_start (self));
		break;
		case CALENDAR_EVENT_STORE_NUM_WEEKS_PROPERTY:
		g_value_set_int (value, calendar_event_store_get_num_weeks (self));
		break;
		case CALENDAR_EVENT_STORE_WEEK_STARTS_ON_PROPERTY:
		g_value_set_int (value, calendar_event_store_get_week_starts_on (self));
		break;
		case CALENDAR_EVENT_STORE_DRAG_COMPONENT_PROPERTY:
		g_value_set_object (value, calendar_event_store_get_drag_component (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_calendar_event_store_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	CalendarEventStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CALENDAR_TYPE_EVENT_STORE, CalendarEventStore);
	switch (property_id) {
		case CALENDAR_EVENT_STORE_DATA_RANGE_PROPERTY:
		calendar_event_store_set_data_range (self, g_value_get_object (value));
		break;
		case CALENDAR_EVENT_STORE_MONTH_RANGE_PROPERTY:
		calendar_event_store_set_month_range (self, g_value_get_object (value));
		break;
		case CALENDAR_EVENT_STORE_REGISTRY_PROPERTY:
		calendar_event_store_set_registry (self, g_value_get_object (value));
		break;
		case CALENDAR_EVENT_STORE_MONTH_START_PROPERTY:
		calendar_event_store_set_month_start (self, g_value_get_boxed (value));
		break;
		case CALENDAR_EVENT_STORE_NUM_WEEKS_PROPERTY:
		calendar_event_store_set_num_weeks (self, g_value_get_int (value));
		break;
		case CALENDAR_EVENT_STORE_WEEK_STARTS_ON_PROPERTY:
		calendar_event_store_set_week_starts_on (self, g_value_get_int (value));
		break;
		case CALENDAR_EVENT_STORE_DRAG_COMPONENT_PROPERTY:
		calendar_event_store_set_drag_component (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

