/* LocalBackend.c generated by valac 0.56.16, the Vala compiler
 * generated from LocalBackend.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2013 Maya Developers (https://launchpad.net/maya)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "elementary-calendar.h"
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAYA_LOCAL_BACKEND_0_PROPERTY,
	MAYA_LOCAL_BACKEND_NUM_PROPERTIES
};
static GParamSpec* maya_local_backend_properties[MAYA_LOCAL_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MayaLocalBackendAddSourceData MayaLocalBackendAddSourceData;
typedef struct _MayaLocalBackendSetSourceDefaultData MayaLocalBackendSetSourceDefaultData;

struct _MayaLocalBackendPrivate {
	ESourceRegistry* registry;
};

struct _MayaLocalBackendAddSourceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MayaLocalBackend* self;
	ESource* new_source;
	gboolean set_default;
	ESourceRegistry* _tmp0_;
	ESourceRegistry* _tmp1_;
	ESourceRegistry* _tmp2_;
	ESourceRegistry* _tmp3_;
	ESourceRegistry* _tmp4_;
	GError* _error_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _MayaLocalBackendSetSourceDefaultData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MayaLocalBackend* self;
	ESource* source;
	ESourceRegistry* _tmp0_;
	ESourceRegistry* _tmp1_;
	ESourceRegistry* _tmp2_;
	ESourceRegistry* _tmp3_;
	ESourceRegistry* _tmp4_;
	GError* _error_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

static gint MayaLocalBackend_private_offset;
static gpointer maya_local_backend_parent_class = NULL;
static MayaBackendIface * maya_local_backend_maya_backend_parent_iface = NULL;

static gchar* maya_local_backend_real_get_name (MayaBackend* base);
static gchar* maya_local_backend_real_get_uid (MayaBackend* base);
static GeeCollection* maya_local_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                                ESource* to_edit);
static void maya_local_backend_real_add_new_calendar (MayaBackend* base,
                                               const gchar* name,
                                               const gchar* color,
                                               gboolean set_default,
                                               GeeCollection* widgets);
static void maya_local_backend_add_source_data_free (gpointer _data);
static gboolean maya_local_backend_add_source_co (MayaLocalBackendAddSourceData* _data_);
static void maya_local_backend_add_source_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void maya_local_backend_set_source_default_data_free (gpointer _data);
static gboolean maya_local_backend_set_source_default_co (MayaLocalBackendSetSourceDefaultData* _data_);
static void maya_local_backend_set_source_default_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void maya_local_backend_real_modify_calendar (MayaBackend* base,
                                              const gchar* name,
                                              const gchar* color,
                                              gboolean set_default,
                                              GeeCollection* widgets,
                                              ESource* source);
static void maya_local_backend_finalize (GObject * obj);
static GType maya_local_backend_get_type_once (void);

static inline gpointer
maya_local_backend_get_instance_private (MayaLocalBackend* self)
{
	return G_STRUCT_MEMBER_P (self, MayaLocalBackend_private_offset);
}

static gchar*
maya_local_backend_real_get_name (MayaBackend* base)
{
	MayaLocalBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaLocalBackend*) base;
	_tmp0_ = g_strdup (_ ("On this computer"));
	result = _tmp0_;
	return result;
}

static gchar*
maya_local_backend_real_get_uid (MayaBackend* base)
{
	MayaLocalBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaLocalBackend*) base;
	_tmp0_ = g_strdup ("local-stub");
	result = _tmp0_;
	return result;
}

static GeeCollection*
maya_local_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                 ESource* to_edit)
{
	MayaLocalBackend * self;
	GeeLinkedList* _tmp0_;
	GeeCollection* result;
	self = (MayaLocalBackend*) base;
	_tmp0_ = gee_linked_list_new (MAYA_TYPE_PLACEMENT_WIDGET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	result = (GeeCollection*) _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
maya_local_backend_real_add_new_calendar (MayaBackend* base,
                                          const gchar* name,
                                          const gchar* color,
                                          gboolean set_default,
                                          GeeCollection* widgets)
{
	MayaLocalBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaLocalBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	{
		ESource* new_source = NULL;
		ESource* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		ESourceCalendar* cal = NULL;
		ESourceExtension* _tmp3_;
		ESourceCalendar* _tmp4_;
		ESourceCalendar* _tmp5_;
		ESourceCalendar* _tmp6_;
		_tmp0_ = e_source_new (NULL, NULL, &_inner_error0_);
		new_source = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		e_source_set_display_name (new_source, name);
		_tmp1_ = maya_backend_get_uid ((MayaBackend*) self);
		_tmp2_ = _tmp1_;
		e_source_set_parent (new_source, _tmp2_);
		_g_free0 (_tmp2_);
		_tmp3_ = e_source_get_extension (new_source, E_SOURCE_EXTENSION_CALENDAR);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp4_;
		_tmp5_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp5_, color);
		_tmp6_ = cal;
		e_source_backend_set_backend_name ((ESourceBackend*) _tmp6_, "local");
		maya_local_backend_add_source (self, new_source, set_default, NULL, NULL);
		_g_object_unref0 (cal);
		_g_object_unref0 (new_source);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_critical ("LocalBackend.vala:48: %s", _tmp8_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_local_backend_add_source_data_free (gpointer _data)
{
	MayaLocalBackendAddSourceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->new_source);
	_g_object_unref0 (_data_->self);
	g_slice_free (MayaLocalBackendAddSourceData, _data_);
}

void
maya_local_backend_add_source (MayaLocalBackend* self,
                               ESource* new_source,
                               gboolean set_default,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	MayaLocalBackendAddSourceData* _data_;
	MayaLocalBackend* _tmp0_;
	ESource* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_source != NULL);
	_data_ = g_slice_new0 (MayaLocalBackendAddSourceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, maya_local_backend_add_source_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (new_source);
	_g_object_unref0 (_data_->new_source);
	_data_->new_source = _tmp1_;
	_data_->set_default = set_default;
	maya_local_backend_add_source_co (_data_);
}

void
maya_local_backend_add_source_finish (MayaLocalBackend* self,
                                      GAsyncResult* _res_)
{
	MayaLocalBackendAddSourceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
maya_local_backend_add_source_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	MayaLocalBackendAddSourceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	maya_local_backend_add_source_co (_data_);
}

static gboolean
maya_local_backend_add_source_co (MayaLocalBackendAddSourceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->registry;
		if (_data_->_tmp0_ == NULL) {
			_data_->_state_ = 1;
			e_source_registry_new (NULL, maya_local_backend_add_source_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp2_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp1_ = _data_->_tmp2_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp3_ = _data_->_tmp1_;
			_data_->_tmp1_ = NULL;
			_g_object_unref0 (_data_->self->priv->registry);
			_data_->self->priv->registry = _data_->_tmp3_;
			_g_object_unref0 (_data_->_tmp1_);
		}
		_data_->_tmp4_ = _data_->self->priv->registry;
		e_source_registry_commit_source_sync (_data_->_tmp4_, _data_->new_source, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_data_->set_default) {
			_data_->_state_ = 2;
			maya_local_backend_set_source_default (_data_->self, _data_->new_source, maya_local_backend_add_source_ready, _data_);
			return FALSE;
			_state_2:
			maya_local_backend_set_source_default_finish (_data_->self, _data_->_res_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->_error_;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_critical ("LocalBackend.vala:63: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
maya_local_backend_set_source_default_data_free (gpointer _data)
{
	MayaLocalBackendSetSourceDefaultData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->source);
	_g_object_unref0 (_data_->self);
	g_slice_free (MayaLocalBackendSetSourceDefaultData, _data_);
}

void
maya_local_backend_set_source_default (MayaLocalBackend* self,
                                       ESource* source,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	MayaLocalBackendSetSourceDefaultData* _data_;
	MayaLocalBackend* _tmp0_;
	ESource* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_data_ = g_slice_new0 (MayaLocalBackendSetSourceDefaultData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, maya_local_backend_set_source_default_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (_data_->source);
	_data_->source = _tmp1_;
	maya_local_backend_set_source_default_co (_data_);
}

void
maya_local_backend_set_source_default_finish (MayaLocalBackend* self,
                                              GAsyncResult* _res_)
{
	MayaLocalBackendSetSourceDefaultData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
maya_local_backend_set_source_default_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	MayaLocalBackendSetSourceDefaultData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	maya_local_backend_set_source_default_co (_data_);
}

static gboolean
maya_local_backend_set_source_default_co (MayaLocalBackendSetSourceDefaultData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->registry;
		if (_data_->_tmp0_ == NULL) {
			_data_->_state_ = 1;
			e_source_registry_new (NULL, maya_local_backend_set_source_default_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp2_ = e_source_registry_new_finish (_data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp1_ = _data_->_tmp2_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp3_ = _data_->_tmp1_;
			_data_->_tmp1_ = NULL;
			_g_object_unref0 (_data_->self->priv->registry);
			_data_->self->priv->registry = _data_->_tmp3_;
			_g_object_unref0 (_data_->_tmp1_);
		}
		_data_->_tmp4_ = _data_->self->priv->registry;
		g_object_set (_data_->_tmp4_, "default-calendar", _data_->source, NULL);
		_data_->_state_ = 2;
		e_source_write (_data_->source, NULL, maya_local_backend_set_source_default_ready, _data_);
		return FALSE;
		_state_2:
		e_source_write_finish (_data_->source, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->_error_;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_critical ("LocalBackend.vala:76: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->_error_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
maya_local_backend_real_modify_calendar (MayaBackend* base,
                                         const gchar* name,
                                         const gchar* color,
                                         gboolean set_default,
                                         GeeCollection* widgets,
                                         ESource* source)
{
	MayaLocalBackend * self;
	ESourceCalendar* cal = NULL;
	ESourceExtension* _tmp0_;
	ESourceCalendar* _tmp1_;
	ESourceCalendar* _tmp2_;
	self = (MayaLocalBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	g_return_if_fail (source != NULL);
	e_source_set_display_name (source, name);
	_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
	cal = _tmp1_;
	_tmp2_ = cal;
	e_source_selectable_set_color ((ESourceSelectable*) _tmp2_, color);
	e_source_write (source, NULL, NULL, NULL);
	if (set_default) {
		maya_local_backend_set_source_default (self, source, NULL, NULL);
	}
	_g_object_unref0 (cal);
}

MayaLocalBackend*
maya_local_backend_construct (GType object_type)
{
	MayaLocalBackend * self = NULL;
	self = (MayaLocalBackend*) g_object_new (object_type, NULL);
	return self;
}

MayaLocalBackend*
maya_local_backend_new (void)
{
	return maya_local_backend_construct (MAYA_TYPE_LOCAL_BACKEND);
}

static void
maya_local_backend_class_init (MayaLocalBackendClass * klass,
                               gpointer klass_data)
{
	maya_local_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MayaLocalBackend_private_offset);
	G_OBJECT_CLASS (klass)->finalize = maya_local_backend_finalize;
}

static void
maya_local_backend_maya_backend_interface_init (MayaBackendIface * iface,
                                                gpointer iface_data)
{
	maya_local_backend_maya_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (MayaBackend*)) maya_local_backend_real_get_name;
	iface->get_uid = (gchar* (*) (MayaBackend*)) maya_local_backend_real_get_uid;
	iface->get_new_calendar_widget = (GeeCollection* (*) (MayaBackend*, ESource*)) maya_local_backend_real_get_new_calendar_widget;
	iface->add_new_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*)) maya_local_backend_real_add_new_calendar;
	iface->modify_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*, ESource*)) maya_local_backend_real_modify_calendar;
}

static void
maya_local_backend_instance_init (MayaLocalBackend * self,
                                  gpointer klass)
{
	self->priv = maya_local_backend_get_instance_private (self);
}

static void
maya_local_backend_finalize (GObject * obj)
{
	MayaLocalBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MAYA_TYPE_LOCAL_BACKEND, MayaLocalBackend);
	_g_object_unref0 (self->priv->registry);
	G_OBJECT_CLASS (maya_local_backend_parent_class)->finalize (obj);
}

static GType
maya_local_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaLocalBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_local_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaLocalBackend), 0, (GInstanceInitFunc) maya_local_backend_instance_init, NULL };
	static const GInterfaceInfo maya_backend_info = { (GInterfaceInitFunc) maya_local_backend_maya_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType maya_local_backend_type_id;
	maya_local_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaLocalBackend", &g_define_type_info, 0);
	g_type_add_interface_static (maya_local_backend_type_id, MAYA_TYPE_BACKEND, &maya_backend_info);
	MayaLocalBackend_private_offset = g_type_add_instance_private (maya_local_backend_type_id, sizeof (MayaLocalBackendPrivate));
	return maya_local_backend_type_id;
}

GType
maya_local_backend_get_type (void)
{
	static volatile gsize maya_local_backend_type_id__once = 0;
	if (g_once_init_enter (&maya_local_backend_type_id__once)) {
		GType maya_local_backend_type_id;
		maya_local_backend_type_id = maya_local_backend_get_type_once ();
		g_once_init_leave (&maya_local_backend_type_id__once, maya_local_backend_type_id);
	}
	return maya_local_backend_type_id__once;
}

