/* plugin.c generated by valac 0.56.8, the Vala compiler
 * generated from plugin.vala, do not modify */

/*
* Copyright 2020 elementary, Inc.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <switchboard.h>
#include <gee.h>
#include <locale.h>
#include <glib/gi18n-lib.h>

#define SWITCHBOARD_PLUGIN_DBUS_INTERFACE "io.elementary.ApplicationsMenu.Switchboard"
#define SWITCHBOARD_PLUGIN_DBUS_PATH "/io/elementary/applicationsmenu"
#define GETTEXT_PACKAGE "slingshot"
#define LOCALEDIR "/usr/share/locale"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PLUG_INFO (plug_info_get_type ())
typedef struct _PlugInfo PlugInfo;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SWITCHBOARD_PLUGIN (switchboard_plugin_get_type ())
#define SWITCHBOARD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHBOARD_PLUGIN, SwitchboardPlugin))
#define SWITCHBOARD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHBOARD_PLUGIN, SwitchboardPluginClass))
#define IS_SWITCHBOARD_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHBOARD_PLUGIN))
#define IS_SWITCHBOARD_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHBOARD_PLUGIN))
#define SWITCHBOARD_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHBOARD_PLUGIN, SwitchboardPluginClass))

typedef struct _SwitchboardPlugin SwitchboardPlugin;
typedef struct _SwitchboardPluginClass SwitchboardPluginClass;
typedef struct _SwitchboardPluginPrivate SwitchboardPluginPrivate;
enum  {
	SWITCHBOARD_PLUGIN_0_PROPERTY,
	SWITCHBOARD_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* switchboard_plugin_properties[SWITCHBOARD_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _SwitchboardPluginRunDbusData SwitchboardPluginRunDbusData;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _SwitchboardPluginLoadPlugsData SwitchboardPluginLoadPlugsData;
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _PlugInfo {
	gchar* title;
	gchar* icon;
	gchar* uri;
	gchar** path;
	gint path_length1;
};

struct _SwitchboardPlugin {
	GObject parent_instance;
	SwitchboardPluginPrivate * priv;
};

struct _SwitchboardPluginClass {
	GObjectClass parent_class;
};

struct _SwitchboardPluginPrivate {
	GDBusConnection* connection;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _SwitchboardPluginRunDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugin* self;
	const gchar* _tmp0_;
	GDBusConnection* _tmp1_;
	const gchar* _tmp2_;
	GDBusConnection* _tmp3_;
	GDBusConnection* _tmp4_;
	GDBusConnection* _tmp5_;
	GError* e;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

struct _SwitchboardPluginLoadPlugsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugin* self;
	SwitchboardPlugsManager* plugs_manager;
	SwitchboardPlugsManager* _tmp0_;
	GVariant** children;
	GVariant** _tmp1_;
	gint children_length1;
	gint _children_size_;
	GeeIterator* _plug_it;
	SwitchboardPlugsManager* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _tmp7_;
	SwitchboardPlug* plug;
	GeeIterator* _tmp8_;
	gpointer _tmp9_;
	GeeTreeMap* settings;
	SwitchboardPlug* _tmp10_;
	GeeTreeMap* _tmp11_;
	GeeTreeMap* _tmp12_;
	GeeTreeMap* _tmp13_;
	gboolean _tmp14_;
	GeeTreeMap* _tmp15_;
	GeeTreeMap* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	gchar* uri;
	GeeTreeMap* _tmp19_;
	GeeSet* _tmp20_;
	GeeSet* _tmp21_;
	GeeSet* _tmp22_;
	gint _tmp23_;
	gpointer* _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	PlugInfo plug_info;
	SwitchboardPlug* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	SwitchboardPlug* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	gchar** _tmp39_;
	PlugInfo _tmp40_;
	PlugInfo _tmp41_;
	GVariant* _tmp46_;
	GeeTreeMap* search_results;
	SwitchboardPlug* _tmp47_;
	GeeTreeMap* _tmp48_;
	GeeIterator* _result_it;
	GeeTreeMap* _tmp49_;
	GeeSet* _tmp50_;
	GeeSet* _tmp51_;
	GeeSet* _tmp52_;
	GeeIterator* _tmp53_;
	GeeIterator* _tmp54_;
	GeeIterator* _tmp55_;
	GeeMapEntry* _result_;
	GeeIterator* _tmp56_;
	gpointer _tmp57_;
	const gchar* title;
	GeeMapEntry* _tmp58_;
	gconstpointer _tmp59_;
	gconstpointer _tmp60_;
	gchar* view;
	GeeMapEntry* _tmp61_;
	gconstpointer _tmp62_;
	gconstpointer _tmp63_;
	gchar* _tmp64_;
	gchar* sub_uri;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
	GeeIterator* _setting_it;
	GeeTreeMap* _tmp68_;
	GeeSet* _tmp69_;
	GeeSet* _tmp70_;
	GeeSet* _tmp71_;
	GeeIterator* _tmp72_;
	GeeIterator* _tmp73_;
	GeeIterator* _tmp74_;
	GeeMapEntry* setting;
	GeeIterator* _tmp75_;
	gpointer _tmp76_;
	GeeMapEntry* _tmp77_;
	gconstpointer _tmp78_;
	gconstpointer _tmp79_;
	const gchar* _tmp80_;
	GeeMapEntry* _tmp81_;
	gconstpointer _tmp82_;
	gconstpointer _tmp83_;
	gchar* _tmp84_;
	gchar** path;
	const gchar* _tmp85_;
	gchar** _tmp86_;
	gchar** _tmp87_;
	gint path_length1;
	gint _path_size_;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	SwitchboardPlug* _tmp90_;
	const gchar* _tmp91_;
	const gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar** _tmp95_;
	gint _tmp95__length1;
	PlugInfo _tmp96_;
	PlugInfo _tmp97_;
	GVariant* _tmp102_;
	GVariant* parameters;
	GVariantType* _tmp103_;
	GVariantType* _tmp104_;
	GVariant** _tmp105_;
	gint _tmp105__length1;
	GVariant* _tmp106_;
	GVariant** _tmp107_;
	GVariant** _tmp108_;
	gint _tmp108__length1;
	GVariant* _tmp109_;
	GVariant* _tmp110_;
	GDBusConnection* _tmp111_;
	GVariant* _tmp112_;
	GVariant* _tmp113_;
	GError* e;
	GError* _tmp114_;
	const gchar* _tmp115_;
	GSourceFunc _tmp116_;
	gpointer _tmp116__target;
	GSourceFunc _tmp117_;
	gpointer _tmp117__target;
	GDestroyNotify _tmp117__target_destroy_notify;
	GError* _inner_error0_;
};

struct _Block1Data {
	int _ref_count_;
	SwitchboardPlugin* self;
	GMainLoop* loop;
};

VALA_EXTERN gchar* dbus_address;
gchar* dbus_address = NULL;
static gint SwitchboardPlugin_private_offset;
static gpointer switchboard_plugin_parent_class = NULL;

VALA_EXTERN GType plug_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PlugInfo* plug_info_dup (const PlugInfo* self);
VALA_EXTERN void plug_info_free (PlugInfo* self);
VALA_EXTERN void plug_info_copy (const PlugInfo* self,
                     PlugInfo* dest);
VALA_EXTERN void plug_info_destroy (PlugInfo* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (PlugInfo, plug_info_destroy)
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN GType switchboard_plugin_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SwitchboardPlugin, g_object_unref)
static void switchboard_plugin_run_dbus_data_free (gpointer _data);
static void switchboard_plugin_run_dbus (SwitchboardPlugin* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void switchboard_plugin_run_dbus_finish (SwitchboardPlugin* self,
                                         GAsyncResult* _res_);
static gboolean switchboard_plugin_run_dbus_co (SwitchboardPluginRunDbusData* _data_);
static gboolean _switchboard_plugin_run_dbus_co_gsource_func (gpointer self);
static void switchboard_plugin_run_dbus_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static void switchboard_plugin_load_plugs (SwitchboardPlugin* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void switchboard_plugin_load_plugs_finish (SwitchboardPlugin* self,
                                           GAsyncResult* _res_);
static void switchboard_plugin_load_plugs_data_free (gpointer _data);
static gboolean switchboard_plugin_load_plugs_co (SwitchboardPluginLoadPlugsData* _data_);
static GVariant* _variant_new1 (PlugInfo value);
static void _vala_array_add1 (GVariant** * array,
                       gint* length,
                       gint* size,
                       GVariant* value);
static void switchboard_plugin_load_plugs_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static GVariant* _variant_new2 (PlugInfo value);
static void _vala_array_add2 (GVariant** * array,
                       gint* length,
                       gint* size,
                       GVariant* value);
VALA_EXTERN SwitchboardPlugin* switchboard_plugin_new (void);
VALA_EXTERN SwitchboardPlugin* switchboard_plugin_construct (GType object_type);
static GObject * switchboard_plugin_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _switchboard_plugin___lambda4_ (Block1Data* _data1_,
                                     GObject* obj,
                                     GAsyncResult* res);
static void __switchboard_plugin___lambda4__gasync_ready_callback (GObject* source_object,
                                                            GAsyncResult* res,
                                                            gpointer self);
static void switchboard_plugin_finalize (GObject * obj);
static GType switchboard_plugin_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

const GOptionEntry OPTIONS[2] = {{"dbus-address", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &dbus_address, "D-Bus server address", "ADDRESS"}, {NULL}};

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
plug_info_copy (const PlugInfo* self,
                PlugInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	_tmp0_ = (*self).title;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).title);
	(*dest).title = _tmp1_;
	_tmp2_ = (*self).icon;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).icon);
	(*dest).icon = _tmp3_;
	_tmp4_ = (*self).uri;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).uri);
	(*dest).uri = _tmp5_;
	_tmp6_ = (*self).path;
	_tmp6__length1 = (*self).path_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup1 (_tmp6_, _tmp6__length1) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	(*dest).path = (_vala_array_free ((*dest).path, (*dest).path_length1, (GDestroyNotify) g_free), NULL);
	(*dest).path = _tmp7_;
	(*dest).path_length1 = _tmp7__length1;
}

void
plug_info_destroy (PlugInfo* self)
{
	_g_free0 ((*self).title);
	_g_free0 ((*self).icon);
	_g_free0 ((*self).uri);
	(*self).path = (_vala_array_free ((*self).path, (*self).path_length1, (GDestroyNotify) g_free), NULL);
}

PlugInfo*
plug_info_dup (const PlugInfo* self)
{
	PlugInfo* dup;
	dup = g_new0 (PlugInfo, 1);
	plug_info_copy (self, dup);
	return dup;
}

void
plug_info_free (PlugInfo* self)
{
	plug_info_destroy (self);
	g_free (self);
}

static GType
plug_info_get_type_once (void)
{
	GType plug_info_type_id;
	plug_info_type_id = g_boxed_type_register_static ("PlugInfo", (GBoxedCopyFunc) plug_info_dup, (GBoxedFreeFunc) plug_info_free);
	return plug_info_type_id;
}

GType
plug_info_get_type (void)
{
	static volatile gsize plug_info_type_id__once = 0;
	if (g_once_init_enter (&plug_info_type_id__once)) {
		GType plug_info_type_id;
		plug_info_type_id = plug_info_get_type_once ();
		g_once_init_leave (&plug_info_type_id__once, plug_info_type_id);
	}
	return plug_info_type_id__once;
}

static inline gpointer
switchboard_plugin_get_instance_private (SwitchboardPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugin_private_offset);
}

static void
switchboard_plugin_run_dbus_data_free (gpointer _data)
{
	SwitchboardPluginRunDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPluginRunDbusData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
switchboard_plugin_run_dbus (SwitchboardPlugin* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	SwitchboardPluginRunDbusData* _data_;
	SwitchboardPlugin* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwitchboardPluginRunDbusData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plugin_run_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	switchboard_plugin_run_dbus_co (_data_);
}

static void
switchboard_plugin_run_dbus_finish (SwitchboardPlugin* self,
                                    GAsyncResult* _res_)
{
	SwitchboardPluginRunDbusData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_switchboard_plugin_run_dbus_co_gsource_func (gpointer self)
{
	gboolean result;
	result = switchboard_plugin_run_dbus_co (self);
	return result;
}

static void
switchboard_plugin_run_dbus_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	SwitchboardPluginRunDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plugin_run_dbus_co (_data_);
}

static gboolean
switchboard_plugin_run_dbus_co (SwitchboardPluginRunDbusData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	(_data_->self->priv->callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->callback_target_destroy_notify (_data_->self->priv->callback_target), NULL);
	_data_->self->priv->callback = NULL;
	_data_->self->priv->callback_target = NULL;
	_data_->self->priv->callback_target_destroy_notify = NULL;
	_data_->self->priv->callback = _switchboard_plugin_run_dbus_co_gsource_func;
	_data_->self->priv->callback_target = _data_;
	_data_->self->priv->callback_target_destroy_notify = NULL;
	_data_->_tmp0_ = dbus_address;
	g_debug ("plugin.vala:50: Connecting to %s", _data_->_tmp0_);
	{
		_data_->_tmp2_ = dbus_address;
		_data_->_state_ = 1;
		g_dbus_connection_new_for_address (_data_->_tmp2_, G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT | G_DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING, NULL, NULL, switchboard_plugin_run_dbus_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_dbus_connection_new_for_address_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->self->priv->connection);
		_data_->self->priv->connection = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->self->priv->connection;
		g_dbus_connection_start_message_processing (_data_->_tmp5_);
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e->message;
		g_error ("plugin.vala:59: D-Bus failure: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	switchboard_plugin_load_plugs (_data_->self, switchboard_plugin_run_dbus_ready, _data_);
	return FALSE;
	_state_2:
	switchboard_plugin_load_plugs_finish (_data_->self, _data_->_res_);
	_data_->_state_ = 3;
	return FALSE;
	_state_3:
	;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
switchboard_plugin_load_plugs_data_free (gpointer _data)
{
	SwitchboardPluginLoadPlugsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPluginLoadPlugsData, _data_);
}

static void
switchboard_plugin_load_plugs (SwitchboardPlugin* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	SwitchboardPluginLoadPlugsData* _data_;
	SwitchboardPlugin* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (SwitchboardPluginLoadPlugsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plugin_load_plugs_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	switchboard_plugin_load_plugs_co (_data_);
}

static void
switchboard_plugin_load_plugs_finish (SwitchboardPlugin* self,
                                      GAsyncResult* _res_)
{
	SwitchboardPluginLoadPlugsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static GVariant*
_variant_new1 (PlugInfo value)
{
	GVariantBuilder _tmp42_;
	gchar** _tmp43_;
	GVariantBuilder _tmp44_;
	gint _tmp45_;
	g_variant_builder_init (&_tmp42_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp42_, g_variant_new_string (value.title));
	g_variant_builder_add_value (&_tmp42_, g_variant_new_string (value.icon));
	g_variant_builder_add_value (&_tmp42_, g_variant_new_string (value.uri));
	_tmp43_ = value.path;
	g_variant_builder_init (&_tmp44_, G_VARIANT_TYPE ("as"));
	for (_tmp45_ = 0; _tmp45_ < value.path_length1; _tmp45_++) {
		g_variant_builder_add_value (&_tmp44_, g_variant_new_string (*_tmp43_));
		_tmp43_++;
	}
	g_variant_builder_add_value (&_tmp42_, g_variant_builder_end (&_tmp44_));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp42_));
}

static void
_vala_array_add1 (GVariant** * array,
                  gint* length,
                  gint* size,
                  GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
switchboard_plugin_load_plugs_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	SwitchboardPluginLoadPlugsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plugin_load_plugs_co (_data_);
}

static GVariant*
_variant_new2 (PlugInfo value)
{
	GVariantBuilder _tmp98_;
	gchar** _tmp99_;
	GVariantBuilder _tmp100_;
	gint _tmp101_;
	g_variant_builder_init (&_tmp98_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp98_, g_variant_new_string (value.title));
	g_variant_builder_add_value (&_tmp98_, g_variant_new_string (value.icon));
	g_variant_builder_add_value (&_tmp98_, g_variant_new_string (value.uri));
	_tmp99_ = value.path;
	g_variant_builder_init (&_tmp100_, G_VARIANT_TYPE ("as"));
	for (_tmp101_ = 0; _tmp101_ < value.path_length1; _tmp101_++) {
		g_variant_builder_add_value (&_tmp100_, g_variant_new_string (*_tmp99_));
		_tmp99_++;
	}
	g_variant_builder_add_value (&_tmp98_, g_variant_builder_end (&_tmp100_));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp98_));
}

static void
_vala_array_add2 (GVariant** * array,
                  gint* length,
                  gint* size,
                  GVariant* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GVariant*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
switchboard_plugin_load_plugs_co (SwitchboardPluginLoadPlugsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = switchboard_plugs_manager_get_default ();
	_data_->plugs_manager = _data_->_tmp0_;
	_data_->_tmp1_ = g_new0 (GVariant*, 0 + 1);
	_data_->children = _data_->_tmp1_;
	_data_->children_length1 = 0;
	_data_->_children_size_ = _data_->children_length1;
	{
		_data_->_tmp2_ = _data_->plugs_manager;
		_data_->_tmp3_ = switchboard_plugs_manager_get_plugs (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp4_);
		_data_->_plug_it = _data_->_tmp6_;
		while (TRUE) {
			_data_->_tmp7_ = _data_->_plug_it;
			if (!gee_iterator_next (_data_->_tmp7_)) {
				break;
			}
			_data_->_tmp8_ = _data_->_plug_it;
			_data_->_tmp9_ = gee_iterator_get (_data_->_tmp8_);
			_data_->plug = (SwitchboardPlug*) _data_->_tmp9_;
			_data_->_tmp10_ = _data_->plug;
			_data_->_tmp11_ = switchboard_plug_get_supported_settings (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
			_data_->settings = _data_->_tmp13_;
			_data_->_tmp15_ = _data_->settings;
			if (_data_->_tmp15_ == NULL) {
				_data_->_tmp14_ = TRUE;
			} else {
				_data_->_tmp16_ = _data_->settings;
				_data_->_tmp17_ = gee_abstract_map_get_size ((GeeAbstractMap*) _data_->_tmp16_);
				_data_->_tmp18_ = _data_->_tmp17_;
				_data_->_tmp14_ = _data_->_tmp18_ <= 0;
			}
			if (_data_->_tmp14_) {
				_g_object_unref0 (_data_->settings);
				_g_object_unref0 (_data_->plug);
				continue;
			}
			_data_->_tmp19_ = _data_->settings;
			_data_->_tmp20_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp23_ = 0;
			_data_->_tmp24_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp22_, &_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp25__length1 = _data_->_tmp23_;
			_data_->_tmp26_ = _data_->_tmp25_[0];
			_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
			_data_->_tmp28_ = _data_->_tmp27_;
			_data_->_tmp25_ = (_vala_array_free (_data_->_tmp25_, _data_->_tmp25__length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (_data_->_tmp22_);
			_data_->uri = _data_->_tmp28_;
			_data_->_tmp29_ = _data_->plug;
			_data_->_tmp30_ = switchboard_plug_get_display_name (_data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_data_->_tmp32_ = g_strdup (_data_->_tmp31_);
			_data_->_tmp33_ = _data_->plug;
			_data_->_tmp34_ = switchboard_plug_get_icon (_data_->_tmp33_);
			_data_->_tmp35_ = _data_->_tmp34_;
			_data_->_tmp36_ = g_strdup (_data_->_tmp35_);
			_data_->_tmp37_ = _data_->uri;
			_data_->_tmp38_ = g_strdup (_data_->_tmp37_);
			_data_->_tmp39_ = g_new0 (gchar*, 0 + 1);
			memset (&_data_->_tmp40_, 0, sizeof (PlugInfo));
			memset (&_data_->_tmp40_, 0, sizeof (PlugInfo));
			_g_free0 (_data_->_tmp40_.title);
			_data_->_tmp40_.title = _data_->_tmp32_;
			_g_free0 (_data_->_tmp40_.icon);
			_data_->_tmp40_.icon = _data_->_tmp36_;
			_g_free0 (_data_->_tmp40_.uri);
			_data_->_tmp40_.uri = _data_->_tmp38_;
			_data_->_tmp40_.path = (_vala_array_free (_data_->_tmp40_.path, _data_->_tmp40_.path_length1, (GDestroyNotify) g_free), NULL);
			_data_->_tmp40_.path = _data_->_tmp39_;
			_data_->_tmp40_.path_length1 = 0;
			_data_->plug_info = _data_->_tmp40_;
			_data_->_tmp41_ = _data_->plug_info;
			_data_->_tmp46_ = _variant_new1 (_data_->_tmp41_);
			_vala_array_add1 (&_data_->children, &_data_->children_length1, &_data_->_children_size_, _data_->_tmp46_);
			_data_->_tmp47_ = _data_->plug;
			_data_->_state_ = 1;
			switchboard_plug_search (_data_->_tmp47_, "", switchboard_plugin_load_plugs_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp48_ = switchboard_plug_search_finish (_data_->_tmp47_, _data_->_res_);
			_data_->search_results = _data_->_tmp48_;
			{
				_data_->_tmp49_ = _data_->search_results;
				_data_->_tmp50_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _data_->_tmp49_);
				_data_->_tmp51_ = _data_->_tmp50_;
				_data_->_tmp52_ = _data_->_tmp51_;
				_data_->_tmp53_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp52_);
				_data_->_tmp54_ = _data_->_tmp53_;
				_g_object_unref0 (_data_->_tmp52_);
				_data_->_result_it = _data_->_tmp54_;
				while (TRUE) {
					_data_->_tmp55_ = _data_->_result_it;
					if (!gee_iterator_next (_data_->_tmp55_)) {
						break;
					}
					_data_->_tmp56_ = _data_->_result_it;
					_data_->_tmp57_ = gee_iterator_get (_data_->_tmp56_);
					_data_->_result_ = (GeeMapEntry*) _data_->_tmp57_;
					_data_->_tmp58_ = _data_->_result_;
					_data_->_tmp59_ = gee_map_entry_get_key (_data_->_tmp58_);
					_data_->_tmp60_ = _data_->_tmp59_;
					_data_->title = (const gchar*) _data_->_tmp60_;
					_data_->_tmp61_ = _data_->_result_;
					_data_->_tmp62_ = gee_map_entry_get_value (_data_->_tmp61_);
					_data_->_tmp63_ = _data_->_tmp62_;
					_data_->_tmp64_ = g_strdup ((const gchar*) _data_->_tmp63_);
					_data_->view = _data_->_tmp64_;
					_data_->_tmp65_ = _data_->uri;
					_data_->_tmp66_ = g_strdup (_data_->_tmp65_);
					_data_->sub_uri = _data_->_tmp66_;
					_data_->_tmp67_ = _data_->view;
					if (g_strcmp0 (_data_->_tmp67_, "") != 0) {
						{
							_data_->_tmp68_ = _data_->settings;
							_data_->_tmp69_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _data_->_tmp68_);
							_data_->_tmp70_ = _data_->_tmp69_;
							_data_->_tmp71_ = _data_->_tmp70_;
							_data_->_tmp72_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp71_);
							_data_->_tmp73_ = _data_->_tmp72_;
							_g_object_unref0 (_data_->_tmp71_);
							_data_->_setting_it = _data_->_tmp73_;
							while (TRUE) {
								_data_->_tmp74_ = _data_->_setting_it;
								if (!gee_iterator_next (_data_->_tmp74_)) {
									break;
								}
								_data_->_tmp75_ = _data_->_setting_it;
								_data_->_tmp76_ = gee_iterator_get (_data_->_tmp75_);
								_data_->setting = (GeeMapEntry*) _data_->_tmp76_;
								_data_->_tmp77_ = _data_->setting;
								_data_->_tmp78_ = gee_map_entry_get_value (_data_->_tmp77_);
								_data_->_tmp79_ = _data_->_tmp78_;
								_data_->_tmp80_ = _data_->view;
								if (g_strcmp0 ((const gchar*) _data_->_tmp79_, _data_->_tmp80_) == 0) {
									_data_->_tmp81_ = _data_->setting;
									_data_->_tmp82_ = gee_map_entry_get_key (_data_->_tmp81_);
									_data_->_tmp83_ = _data_->_tmp82_;
									_data_->_tmp84_ = g_strdup ((const gchar*) _data_->_tmp83_);
									_g_free0 (_data_->sub_uri);
									_data_->sub_uri = _data_->_tmp84_;
									_g_object_unref0 (_data_->setting);
									break;
								}
								_g_object_unref0 (_data_->setting);
							}
							_g_object_unref0 (_data_->_setting_it);
						}
					}
					_data_->_tmp85_ = _data_->title;
					_data_->_tmp87_ = _data_->_tmp86_ = g_strsplit (_data_->_tmp85_, " → ", 0);
					_data_->path = _data_->_tmp87_;
					_data_->path_length1 = _vala_array_length (_data_->_tmp86_);
					_data_->_path_size_ = _data_->path_length1;
					_data_->_tmp88_ = _data_->title;
					_data_->_tmp89_ = g_strdup (_data_->_tmp88_);
					_data_->_tmp90_ = _data_->plug;
					_data_->_tmp91_ = switchboard_plug_get_icon (_data_->_tmp90_);
					_data_->_tmp92_ = _data_->_tmp91_;
					_data_->_tmp93_ = g_strdup (_data_->_tmp92_);
					_data_->_tmp94_ = _data_->sub_uri;
					_data_->sub_uri = NULL;
					_data_->_tmp95_ = _data_->path;
					_data_->_tmp95__length1 = _data_->path_length1;
					_data_->path = NULL;
					_data_->path_length1 = 0;
					memset (&_data_->_tmp96_, 0, sizeof (PlugInfo));
					memset (&_data_->_tmp96_, 0, sizeof (PlugInfo));
					_g_free0 (_data_->_tmp96_.title);
					_data_->_tmp96_.title = _data_->_tmp89_;
					_g_free0 (_data_->_tmp96_.icon);
					_data_->_tmp96_.icon = _data_->_tmp93_;
					_g_free0 (_data_->_tmp96_.uri);
					_data_->_tmp96_.uri = _data_->_tmp94_;
					_data_->_tmp96_.path = (_vala_array_free (_data_->_tmp96_.path, _data_->_tmp96_.path_length1, (GDestroyNotify) g_free), NULL);
					_data_->_tmp96_.path = _data_->_tmp95_;
					_data_->_tmp96_.path_length1 = _data_->_tmp95__length1;
					plug_info_destroy (&_data_->plug_info);
					_data_->plug_info = _data_->_tmp96_;
					_data_->_tmp97_ = _data_->plug_info;
					_data_->_tmp102_ = _variant_new2 (_data_->_tmp97_);
					_vala_array_add2 (&_data_->children, &_data_->children_length1, &_data_->_children_size_, _data_->_tmp102_);
					_data_->path = (_vala_array_free (_data_->path, _data_->path_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (_data_->sub_uri);
					_g_free0 (_data_->view);
					_g_object_unref0 (_data_->_result_);
				}
				_g_object_unref0 (_data_->_result_it);
			}
			_g_object_unref0 (_data_->search_results);
			plug_info_destroy (&_data_->plug_info);
			_g_free0 (_data_->uri);
			_g_object_unref0 (_data_->settings);
			_g_object_unref0 (_data_->plug);
		}
		_g_object_unref0 (_data_->_plug_it);
	}
	_data_->_tmp103_ = g_variant_type_new ("(sssas)");
	_data_->_tmp104_ = _data_->_tmp103_;
	_data_->_tmp105_ = _data_->children;
	_data_->_tmp105__length1 = _data_->children_length1;
	_data_->_tmp106_ = g_variant_new_array (_data_->_tmp104_, _data_->_tmp105_, _data_->_tmp105__length1);
	g_variant_ref_sink (_data_->_tmp106_);
	_data_->_tmp107_ = g_new0 (GVariant*, 1 + 1);
	_data_->_tmp107_[0] = _data_->_tmp106_;
	_data_->_tmp108_ = _data_->_tmp107_;
	_data_->_tmp108__length1 = 1;
	_data_->_tmp109_ = g_variant_new_tuple (_data_->_tmp108_, 1);
	g_variant_ref_sink (_data_->_tmp109_);
	_data_->_tmp110_ = _data_->_tmp109_;
	_data_->_tmp108_ = (_vala_array_free (_data_->_tmp108_, _data_->_tmp108__length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_variant_type_free0 (_data_->_tmp104_);
	_data_->parameters = _data_->_tmp110_;
	{
		_data_->_tmp111_ = _data_->self->priv->connection;
		_data_->_state_ = 2;
		g_dbus_connection_call (_data_->_tmp111_, NULL, SWITCHBOARD_PLUGIN_DBUS_PATH, SWITCHBOARD_PLUGIN_DBUS_INTERFACE, "SetPlugs", _data_->parameters, NULL, G_DBUS_CALL_FLAGS_NO_AUTO_START, -1, NULL, switchboard_plugin_load_plugs_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp112_ = g_dbus_connection_call_finish (_data_->_tmp111_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp113_ = _data_->_tmp112_;
		_g_variant_unref0 (_data_->_tmp113_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp114_ = _data_->e;
		_data_->_tmp115_ = _data_->_tmp114_->message;
		g_critical ("plugin.vala:117: %s", _data_->_tmp115_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_variant_unref0 (_data_->parameters);
		_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
		_g_object_unref0 (_data_->plugs_manager);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp116_ = _data_->self->priv->callback;
	_data_->_tmp116__target = _data_->self->priv->callback_target;
	if (_data_->_tmp116_ != NULL) {
		_data_->_tmp117_ = _data_->self->priv->callback;
		_data_->_tmp117__target = _data_->self->priv->callback_target;
		_data_->_tmp117__target_destroy_notify = _data_->self->priv->callback_target_destroy_notify;
		_data_->self->priv->callback = NULL;
		_data_->self->priv->callback_target = NULL;
		_data_->self->priv->callback_target_destroy_notify = NULL;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _data_->_tmp117_, _data_->_tmp117__target, _data_->_tmp117__target_destroy_notify);
	}
	_g_variant_unref0 (_data_->parameters);
	_data_->children = (_vala_array_free (_data_->children, _data_->children_length1, (GDestroyNotify) g_variant_unref), NULL);
	_g_object_unref0 (_data_->plugs_manager);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SwitchboardPlugin*
switchboard_plugin_construct (GType object_type)
{
	SwitchboardPlugin * self = NULL;
	self = (SwitchboardPlugin*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugin*
switchboard_plugin_new (void)
{
	return switchboard_plugin_construct (TYPE_SWITCHBOARD_PLUGIN);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SwitchboardPlugin* self;
		self = _data1_->self;
		_g_main_loop_unref0 (_data1_->loop);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_switchboard_plugin___lambda4_ (Block1Data* _data1_,
                                GObject* obj,
                                GAsyncResult* res)
{
	SwitchboardPlugin* self;
	GMainLoop* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	switchboard_plugin_run_dbus_finish (self, res);
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
__switchboard_plugin___lambda4__gasync_ready_callback (GObject* source_object,
                                                       GAsyncResult* res,
                                                       gpointer self)
{
	_switchboard_plugin___lambda4_ (self, source_object, res);
	block1_data_unref (self);
}

static GObject *
switchboard_plugin_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugin * self;
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	GMainLoop* _tmp1_;
	parent_class = G_OBJECT_CLASS (switchboard_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWITCHBOARD_PLUGIN, SwitchboardPlugin);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, TRUE);
	_data1_->loop = _tmp0_;
	switchboard_plugin_run_dbus (self, __switchboard_plugin___lambda4__gasync_ready_callback, block1_data_ref (_data1_));
	_tmp1_ = _data1_->loop;
	g_main_loop_run (_tmp1_);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
switchboard_plugin_class_init (SwitchboardPluginClass * klass,
                               gpointer klass_data)
{
	switchboard_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugin_private_offset);
	G_OBJECT_CLASS (klass)->constructor = switchboard_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plugin_finalize;
}

static void
switchboard_plugin_instance_init (SwitchboardPlugin * self,
                                  gpointer klass)
{
	self->priv = switchboard_plugin_get_instance_private (self);
}

static void
switchboard_plugin_finalize (GObject * obj)
{
	SwitchboardPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWITCHBOARD_PLUGIN, SwitchboardPlugin);
	_g_object_unref0 (self->priv->connection);
	(self->priv->callback_target_destroy_notify == NULL) ? NULL : (self->priv->callback_target_destroy_notify (self->priv->callback_target), NULL);
	self->priv->callback = NULL;
	self->priv->callback_target = NULL;
	self->priv->callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (switchboard_plugin_parent_class)->finalize (obj);
}

static GType
switchboard_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugin), 0, (GInstanceInitFunc) switchboard_plugin_instance_init, NULL };
	GType switchboard_plugin_type_id;
	switchboard_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlugin", &g_define_type_info, 0);
	SwitchboardPlugin_private_offset = g_type_add_instance_private (switchboard_plugin_type_id, sizeof (SwitchboardPluginPrivate));
	return switchboard_plugin_type_id;
}

GType
switchboard_plugin_get_type (void)
{
	static volatile gsize switchboard_plugin_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plugin_type_id__once)) {
		GType switchboard_plugin_type_id;
		switchboard_plugin_type_id = switchboard_plugin_get_type_once ();
		g_once_init_leave (&switchboard_plugin_type_id__once, switchboard_plugin_type_id);
	}
	return switchboard_plugin_type_id__once;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	const gchar* _tmp9_;
	SwitchboardPlugin* _tmp10_;
	SwitchboardPlugin* _tmp11_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("Plugin options");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, OPTIONS, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_printerr ("error: %s\n", _tmp6_);
		_tmp7_ = args[0];
		g_printerr ("Run '%s --help' to see a full list of available command line options.\n", _tmp7_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp9_ = dbus_address;
	if (_tmp9_ == NULL) {
		g_printerr ("The --dbus-address argument is mandatory\n");
		result = 1;
		return result;
	}
	_tmp10_ = switchboard_plugin_new ();
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp11_);
	result = 0;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

