/* command-plugin.c generated by valac 0.56.8, the Vala compiler
 * generated from command-plugin.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2017 elementary LLC.
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

enum  {
	SYNAPSE_COMMAND_PLUGIN_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT (synapse_command_plugin_command_object_get_type ())
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT))
#define SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObjectClass))

typedef struct _SynapseCommandPluginCommandObject SynapseCommandPluginCommandObject;
typedef struct _SynapseCommandPluginCommandObjectClass SynapseCommandPluginCommandObjectClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseCommandPluginSearchData SynapseCommandPluginSearchData;
typedef struct _SynapseCommandPluginCommandObjectPrivate SynapseCommandPluginCommandObjectPrivate;
enum  {
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_0_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY,
	SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES
};
static GParamSpec* synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseCommandPluginPrivate {
	gboolean _enabled;
	GeeSet* past_commands;
	GRegex* split_regex;
};

struct _SynapseCommandPluginSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCommandPlugin* self;
	SynapseQuery q;
	SynapseResultSet* result;
	SynapseQuery _tmp0_;
	SynapseResultSet* _result_;
	SynapseResultSet* _tmp1_;
	gchar* stripped;
	SynapseQuery _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GeeSet* _tmp10_;
	const gchar* _tmp11_;
	GeeIterator* _command_it;
	GeeSet* _tmp12_;
	GeeIterator* _tmp13_;
	GeeIterator* _tmp14_;
	gchar* command;
	GeeIterator* _tmp15_;
	gpointer _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	SynapseResultSet* _tmp19_;
	const gchar* _tmp20_;
	SynapseCommandPluginCommandObject* _tmp21_;
	SynapseCommandPluginCommandObject* _tmp22_;
	gchar** args;
	GRegex* _tmp23_;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint args_length1;
	gint _args_size_;
	gchar* valid_cmd;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	const gchar* _tmp32_;
	SynapseCommandPluginCommandObject* co;
	const gchar* _tmp33_;
	SynapseCommandPluginCommandObject* _tmp34_;
	SynapseCommandPluginCommandObject* _tmp35_;
	SynapseResultSet* _tmp36_;
	SynapseCommandPluginCommandObject* _tmp37_;
	SynapseCommandPluginCommandObject* _tmp38_;
	SynapseResultSet* _tmp39_;
	const gchar* _tmp40_;
	SynapseCommandPluginCommandObject* _tmp41_;
	SynapseCommandPluginCommandObject* _tmp42_;
	GError* _inner_error0_;
};

struct _SynapseCommandPluginCommandObject {
	SynapseMatch parent_instance;
	SynapseCommandPluginCommandObjectPrivate * priv;
};

struct _SynapseCommandPluginCommandObjectClass {
	SynapseMatchClass parent_class;
};

struct _SynapseCommandPluginCommandObjectPrivate {
	GAppInfo* _app_info;
	gboolean _needs_terminal;
	gchar* _filename;
	gchar* _command;
};

static gint SynapseCommandPlugin_private_offset;
static gpointer synapse_command_plugin_parent_class = NULL;
static gint SynapseCommandPluginCommandObject_private_offset;
static gpointer synapse_command_plugin_command_object_parent_class = NULL;
static SynapseApplicationMatchIface * synapse_command_plugin_command_object_synapse_application_match_parent_iface = NULL;
static SynapseActivatableIface * synapse_command_plugin_synapse_activatable_parent_iface = NULL;
static SynapseItemProviderIface * synapse_command_plugin_synapse_item_provider_parent_iface = NULL;

static void synapse_command_plugin_real_activate (SynapseActivatable* base);
static void synapse_command_plugin_real_deactivate (SynapseActivatable* base);
static void synapse_command_plugin_register_plugin (void);
static void _synapse_command_plugin_register_plugin_synapse_plugin_register_func (void);
static GType synapse_command_plugin_command_object_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static SynapseCommandPluginCommandObject* synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                                                     const gchar* exec);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_new (const gchar* cmd);
static SynapseCommandPluginCommandObject* synapse_command_plugin_command_object_construct (GType object_type,
                                                                                    const gchar* cmd);
static void synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                              SynapseMatch* match);
static const gchar* synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self);
static void synapse_command_plugin_real_search_data_free (gpointer _data);
static void synapse_command_plugin_real_search (SynapseItemProvider* base,
                                         SynapseQuery* q,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_);
static gboolean _synapse_command_plugin_real_search_co_gsource_func (gpointer self);
static void _synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                      gpointer self);
static void synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                        const gchar* value);
static void synapse_command_plugin_command_object_finalize (GObject * obj);
static GType synapse_command_plugin_command_object_get_type_once (void);
static void _vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                               guint property_id,
                                                               GValue * value,
                                                               GParamSpec * pspec);
static void _vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                               guint property_id,
                                                               const GValue * value,
                                                               GParamSpec * pspec);
static GObject * synapse_command_plugin_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void synapse_command_plugin_finalize (GObject * obj);
static GType synapse_command_plugin_get_type_once (void);
static void _vala_synapse_command_plugin_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_synapse_command_plugin_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
synapse_command_plugin_get_instance_private (SynapseCommandPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPlugin_private_offset);
}

static void
synapse_command_plugin_real_activate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
	self = (SynapseCommandPlugin*) base;
}

static void
synapse_command_plugin_real_deactivate (SynapseActivatable* base)
{
	SynapseCommandPlugin * self;
	self = (SynapseCommandPlugin*) base;
}

static void
_synapse_command_plugin_register_plugin_synapse_plugin_register_func (void)
{
	synapse_command_plugin_register_plugin ();
}

static void
synapse_command_plugin_register_plugin (void)
{
	SynapseDataSinkPluginRegistry* _tmp0_;
	SynapseDataSinkPluginRegistry* _tmp1_;
	_tmp0_ = synapse_data_sink_plugin_registry_get_default ();
	_tmp1_ = _tmp0_;
	synapse_data_sink_plugin_registry_register_plugin (_tmp1_, SYNAPSE_TYPE_COMMAND_PLUGIN, "Command Search", _ ("Find and execute arbitrary commands."), "system-run", _synapse_command_plugin_register_plugin_synapse_plugin_register_func, TRUE, "");
	_g_object_unref0 (_tmp1_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_create_co (SynapseCommandPlugin* self,
                                  const gchar* exec)
{
	SynapseDesktopFileService* dfs = NULL;
	SynapseDesktopFileService* _tmp0_;
	GeeList* df_list = NULL;
	SynapseDesktopFileService* _tmp1_;
	GeeList* _tmp2_;
	SynapseDesktopFileInfo* dfi = NULL;
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp16_;
	SynapseDesktopFileInfo* _tmp17_;
	SynapseCommandPluginCommandObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exec != NULL, NULL);
	_tmp0_ = synapse_desktop_file_service_get_default ();
	dfs = _tmp0_;
	_tmp1_ = dfs;
	_tmp2_ = synapse_desktop_file_service_get_desktop_files_for_exec (_tmp1_, exec);
	df_list = _tmp2_;
	dfi = NULL;
	{
		GeeList* _df_list = NULL;
		GeeList* _tmp3_;
		gint _df_size = 0;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _df_index = 0;
		_tmp3_ = df_list;
		_df_list = _tmp3_;
		_tmp4_ = _df_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_df_size = _tmp6_;
		_df_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			SynapseDesktopFileInfo* df = NULL;
			GeeList* _tmp9_;
			gpointer _tmp10_;
			SynapseDesktopFileInfo* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			SynapseDesktopFileInfo* _tmp14_;
			SynapseDesktopFileInfo* _tmp15_;
			_df_index = _df_index + 1;
			_tmp7_ = _df_index;
			_tmp8_ = _df_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _df_list;
			_tmp10_ = gee_list_get (_tmp9_, _df_index);
			df = (SynapseDesktopFileInfo*) _tmp10_;
			_tmp11_ = df;
			_tmp12_ = synapse_desktop_file_info_get_is_hidden (_tmp11_);
			_tmp13_ = _tmp12_;
			if (!_tmp13_) {
				result = NULL;
				_g_object_unref0 (df);
				_g_object_unref0 (dfi);
				_g_object_unref0 (df_list);
				_g_object_unref0 (dfs);
				return result;
			}
			_tmp14_ = df;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (dfi);
			dfi = _tmp15_;
			_g_object_unref0 (df);
		}
	}
	_tmp16_ = synapse_command_plugin_command_object_new (exec);
	co = _tmp16_;
	_tmp17_ = dfi;
	if (_tmp17_ != NULL) {
		SynapseCommandPluginCommandObject* _tmp18_;
		SynapseDesktopFileInfo* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		SynapseDesktopFileInfo* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gboolean _tmp29_ = FALSE;
		SynapseDesktopFileInfo* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp18_ = co;
		_tmp19_ = dfi;
		_tmp20_ = synapse_desktop_file_info_get_name (_tmp19_);
		_tmp21_ = _tmp20_;
		synapse_match_set_title ((SynapseMatch*) _tmp18_, _tmp21_);
		_tmp22_ = dfi;
		_tmp23_ = synapse_desktop_file_info_get_comment (_tmp22_);
		_tmp24_ = _tmp23_;
		if (g_strcmp0 (_tmp24_, "") != 0) {
			SynapseCommandPluginCommandObject* _tmp25_;
			SynapseDesktopFileInfo* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			_tmp25_ = co;
			_tmp26_ = dfi;
			_tmp27_ = synapse_desktop_file_info_get_comment (_tmp26_);
			_tmp28_ = _tmp27_;
			synapse_match_set_description ((SynapseMatch*) _tmp25_, _tmp28_);
		}
		_tmp30_ = dfi;
		_tmp31_ = synapse_desktop_file_info_get_icon_name (_tmp30_);
		_tmp32_ = _tmp31_;
		if (_tmp32_ != NULL) {
			SynapseDesktopFileInfo* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			_tmp33_ = dfi;
			_tmp34_ = synapse_desktop_file_info_get_icon_name (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp29_ = g_strcmp0 (_tmp35_, "") != 0;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			SynapseCommandPluginCommandObject* _tmp36_;
			SynapseDesktopFileInfo* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp36_ = co;
			_tmp37_ = dfi;
			_tmp38_ = synapse_desktop_file_info_get_icon_name (_tmp37_);
			_tmp39_ = _tmp38_;
			synapse_match_set_icon_name ((SynapseMatch*) _tmp36_, _tmp39_);
		}
	}
	result = co;
	_g_object_unref0 (dfi);
	_g_object_unref0 (df_list);
	_g_object_unref0 (dfs);
	return result;
}

static void
synapse_command_plugin_command_executed (SynapseCommandPlugin* self,
                                         SynapseMatch* match)
{
	SynapseCommandPluginCommandObject* co = NULL;
	SynapseCommandPluginCommandObject* _tmp0_;
	SynapseCommandPluginCommandObject* _tmp1_;
	GeeSet* _tmp2_;
	SynapseCommandPluginCommandObject* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = _g_object_ref0 (SYNAPSE_COMMAND_PLUGIN_IS_COMMAND_OBJECT (match) ? ((SynapseCommandPluginCommandObject*) match) : NULL);
	co = _tmp0_;
	_tmp1_ = co;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (co);
		return;
	}
	_tmp2_ = self->priv->past_commands;
	_tmp3_ = co;
	_tmp4_ = synapse_command_plugin_command_object_get_command (_tmp3_);
	_tmp5_ = _tmp4_;
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp5_);
	_g_object_unref0 (co);
}

static void
synapse_command_plugin_real_search_data_free (gpointer _data)
{
	SynapseCommandPluginSearchData* _data_;
	_data_ = _data;
	synapse_query_destroy (&_data_->q);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseCommandPluginSearchData, _data_);
}

static void
synapse_command_plugin_real_search (SynapseItemProvider* base,
                                    SynapseQuery* q,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	SynapseCommandPlugin * self;
	SynapseCommandPluginSearchData* _data_;
	SynapseCommandPlugin* _tmp0_;
	SynapseQuery _tmp1_;
	SynapseQuery _tmp2_;
	SynapseQuery _tmp3_ = {0};
	g_return_if_fail (q != NULL);
	self = (SynapseCommandPlugin*) base;
	_data_ = g_slice_new0 (SynapseCommandPluginSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_command_plugin_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = *q;
	_tmp2_ = _tmp1_;
	synapse_query_copy (&_tmp2_, &_tmp3_);
	synapse_query_destroy (&_data_->q);
	_data_->q = _tmp3_;
	synapse_command_plugin_real_search_co (_data_);
}

static SynapseResultSet*
synapse_command_plugin_search_finish (SynapseItemProvider* base,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	SynapseResultSet* result;
	SynapseCommandPluginSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
_synapse_command_plugin_real_search_co_gsource_func (gpointer self)
{
	gboolean result;
	result = synapse_command_plugin_real_search_co (self);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_synapse_command_plugin_command_executed_synapse_match_executed (SynapseMatch* _sender,
                                                                 gpointer self)
{
	synapse_command_plugin_command_executed ((SynapseCommandPlugin*) self, _sender);
}

static gboolean
synapse_command_plugin_real_search_co (SynapseCommandPluginSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->q;
	if (!((_data_->_tmp0_.query_type & SYNAPSE_QUERY_FLAGS_APPLICATIONS) == SYNAPSE_QUERY_FLAGS_APPLICATIONS)) {
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _synapse_command_plugin_real_search_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp1_ = synapse_result_set_new ();
	_data_->_result_ = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->q;
	_data_->_tmp3_ = _data_->_tmp2_.query_string;
	_data_->_tmp4_ = string_strip (_data_->_tmp3_);
	_data_->stripped = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->stripped;
	if (g_strcmp0 (_data_->_tmp5_, "") == 0) {
		_data_->result = NULL;
		_g_free0 (_data_->stripped);
		_g_object_unref0 (_data_->_result_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->stripped;
	if (g_str_has_prefix (_data_->_tmp6_, "~/")) {
		_data_->_tmp7_ = _data_->stripped;
		_data_->_tmp8_ = g_get_home_dir ();
		_data_->_tmp9_ = string_replace (_data_->_tmp7_, "~", _data_->_tmp8_);
		_g_free0 (_data_->stripped);
		_data_->stripped = _data_->_tmp9_;
	}
	_data_->_tmp10_ = _data_->self->priv->past_commands;
	_data_->_tmp11_ = _data_->stripped;
	if (!gee_collection_contains ((GeeCollection*) _data_->_tmp10_, _data_->_tmp11_)) {
		{
			_data_->_tmp12_ = _data_->self->priv->past_commands;
			_data_->_tmp13_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp12_);
			_data_->_command_it = _data_->_tmp13_;
			while (TRUE) {
				_data_->_tmp14_ = _data_->_command_it;
				if (!gee_iterator_next (_data_->_tmp14_)) {
					break;
				}
				_data_->_tmp15_ = _data_->_command_it;
				_data_->_tmp16_ = gee_iterator_get (_data_->_tmp15_);
				_data_->command = (gchar*) _data_->_tmp16_;
				_data_->_tmp17_ = _data_->command;
				_data_->_tmp18_ = _data_->stripped;
				if (g_str_has_prefix (_data_->_tmp17_, _data_->_tmp18_)) {
					_data_->_tmp19_ = _data_->_result_;
					_data_->_tmp20_ = _data_->command;
					_data_->_tmp21_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp20_);
					_data_->_tmp22_ = _data_->_tmp21_;
					synapse_result_set_add (_data_->_tmp19_, (SynapseMatch*) _data_->_tmp22_, (gint) SYNAPSE_MATCH_SCORE_AVERAGE);
					_g_object_unref0 (_data_->_tmp22_);
				}
				_g_free0 (_data_->command);
			}
			_g_object_unref0 (_data_->_command_it);
		}
		_data_->_tmp23_ = _data_->self->priv->split_regex;
		_data_->_tmp24_ = _data_->stripped;
		_data_->_tmp26_ = _data_->_tmp25_ = g_regex_split (_data_->_tmp23_, _data_->_tmp24_, 0);
		_data_->args = _data_->_tmp26_;
		_data_->args_length1 = _vala_array_length (_data_->_tmp25_);
		_data_->_args_size_ = _data_->args_length1;
		_data_->_tmp27_ = _data_->args;
		_data_->_tmp27__length1 = _data_->args_length1;
		_data_->_tmp28_ = _data_->_tmp27_[0];
		_data_->_tmp29_ = g_find_program_in_path (_data_->_tmp28_);
		_data_->valid_cmd = _data_->_tmp29_;
		_data_->_tmp30_ = _data_->valid_cmd;
		if (_data_->_tmp30_ != NULL) {
			_data_->_tmp31_ = _data_->args;
			_data_->_tmp31__length1 = _data_->args_length1;
			_data_->_tmp32_ = _data_->_tmp31_[0];
			if (g_strcmp0 (_data_->_tmp32_, "rm") == 0) {
				_data_->result = NULL;
				_g_free0 (_data_->valid_cmd);
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->stripped);
				_g_object_unref0 (_data_->_result_);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp33_ = _data_->stripped;
			_data_->_tmp34_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp33_);
			_data_->co = _data_->_tmp34_;
			_data_->_tmp35_ = _data_->co;
			if (_data_->_tmp35_ == NULL) {
				_data_->result = NULL;
				_g_object_unref0 (_data_->co);
				_g_free0 (_data_->valid_cmd);
				_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->stripped);
				_g_object_unref0 (_data_->_result_);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp36_ = _data_->_result_;
			_data_->_tmp37_ = _data_->co;
			synapse_result_set_add (_data_->_tmp36_, (SynapseMatch*) _data_->_tmp37_, (gint) SYNAPSE_MATCH_SCORE_POOR);
			_data_->_tmp38_ = _data_->co;
			g_signal_connect_object ((SynapseMatch*) _data_->_tmp38_, "executed", (GCallback) _synapse_command_plugin_command_executed_synapse_match_executed, _data_->self, 0);
			_g_object_unref0 (_data_->co);
		}
		_g_free0 (_data_->valid_cmd);
		_data_->args = (_vala_array_free (_data_->args, _data_->args_length1, (GDestroyNotify) g_free), NULL);
	} else {
		_data_->_tmp39_ = _data_->_result_;
		_data_->_tmp40_ = _data_->stripped;
		_data_->_tmp41_ = synapse_command_plugin_create_co (_data_->self, _data_->_tmp40_);
		_data_->_tmp42_ = _data_->_tmp41_;
		synapse_result_set_add (_data_->_tmp39_, (SynapseMatch*) _data_->_tmp42_, (gint) SYNAPSE_MATCH_SCORE_VERY_GOOD);
		_g_object_unref0 (_data_->_tmp42_);
	}
	synapse_query_check_cancellable (&_data_->q, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if (_data_->_inner_error0_->domain == SYNAPSE_SEARCH_ERROR) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->stripped);
			_g_object_unref0 (_data_->_result_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->stripped);
			_g_object_unref0 (_data_->_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->_result_;
	_g_free0 (_data_->stripped);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SynapseCommandPlugin*
synapse_command_plugin_construct (GType object_type)
{
	SynapseCommandPlugin * self = NULL;
	self = (SynapseCommandPlugin*) g_object_new (object_type, NULL);
	return self;
}

SynapseCommandPlugin*
synapse_command_plugin_new (void)
{
	return synapse_command_plugin_construct (SYNAPSE_TYPE_COMMAND_PLUGIN);
}

static gboolean
synapse_command_plugin_real_get_enabled (SynapseActivatable* base)
{
	gboolean result;
	SynapseCommandPlugin* self;
	self = (SynapseCommandPlugin*) base;
	result = self->priv->_enabled;
	return result;
}

static void
synapse_command_plugin_real_set_enabled (SynapseActivatable* base,
                                         gboolean value)
{
	SynapseCommandPlugin* self;
	gboolean old_value;
	self = (SynapseCommandPlugin*) base;
	old_value = synapse_command_plugin_real_get_enabled (base);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY]);
	}
}

static inline gpointer
synapse_command_plugin_command_object_get_instance_private (SynapseCommandPluginCommandObject* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCommandPluginCommandObject_private_offset);
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_construct (GType object_type,
                                                 const gchar* cmd)
{
	SynapseCommandPluginCommandObject * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = g_strdup_printf (_ ("Execute '%s'"), cmd);
	_tmp1_ = _tmp0_;
	self = (SynapseCommandPluginCommandObject*) g_object_new (object_type, "title", _tmp1_, "description", _ ("Run command"), "command", cmd, "icon-name", "application-x-executable", "match-type", SYNAPSE_MATCH_TYPE_APPLICATION, "needs-terminal", g_str_has_prefix (cmd, "sudo "), NULL);
	_g_free0 (_tmp1_);
	{
		GAppInfo* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GAppInfo* _tmp9_;
		GAppInfo* _tmp10_;
		_tmp3_ = string_replace (cmd, "\"", "\\\"");
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat ("sh -c \"", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, "\"", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_app_info_create_from_commandline (_tmp8_, NULL, 0, &_inner_error0_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_tmp2_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, _tmp2_);
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = err;
		_tmp12_ = _tmp11_->message;
		g_warning ("command-plugin.vala:51: %s", _tmp12_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

static SynapseCommandPluginCommandObject*
synapse_command_plugin_command_object_new (const gchar* cmd)
{
	return synapse_command_plugin_command_object_construct (SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, cmd);
}

static GAppInfo*
synapse_command_plugin_command_object_real_get_app_info (SynapseApplicationMatch* base)
{
	GAppInfo* result;
	SynapseCommandPluginCommandObject* self;
	GAppInfo* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static void
synapse_command_plugin_command_object_real_set_app_info (SynapseApplicationMatch* base,
                                                         GAppInfo* value)
{
	SynapseCommandPluginCommandObject* self;
	GAppInfo* old_value;
	self = (SynapseCommandPluginCommandObject*) base;
	old_value = synapse_command_plugin_command_object_real_get_app_info (base);
	if (old_value != value) {
		GAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY]);
	}
}

static gboolean
synapse_command_plugin_command_object_real_get_needs_terminal (SynapseApplicationMatch* base)
{
	gboolean result;
	SynapseCommandPluginCommandObject* self;
	self = (SynapseCommandPluginCommandObject*) base;
	result = self->priv->_needs_terminal;
	return result;
}

static void
synapse_command_plugin_command_object_real_set_needs_terminal (SynapseApplicationMatch* base,
                                                               gboolean value)
{
	SynapseCommandPluginCommandObject* self;
	gboolean old_value;
	self = (SynapseCommandPluginCommandObject*) base;
	old_value = synapse_command_plugin_command_object_real_get_needs_terminal (base);
	if (old_value != value) {
		self->priv->_needs_terminal = value;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY]);
	}
}

static const gchar*
synapse_command_plugin_command_object_real_get_filename (SynapseApplicationMatch* base)
{
	const gchar* result;
	SynapseCommandPluginCommandObject* self;
	const gchar* _tmp0_;
	self = (SynapseCommandPluginCommandObject*) base;
	_tmp0_ = self->priv->_filename;
	result = _tmp0_;
	return result;
}

static void
synapse_command_plugin_command_object_real_set_filename (SynapseApplicationMatch* base,
                                                         const gchar* value)
{
	SynapseCommandPluginCommandObject* self;
	gchar* old_value;
	self = (SynapseCommandPluginCommandObject*) base;
	old_value = synapse_command_plugin_command_object_real_get_filename (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_filename);
		self->priv->_filename = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY]);
	}
}

static const gchar*
synapse_command_plugin_command_object_get_command (SynapseCommandPluginCommandObject* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_command;
	result = _tmp0_;
	return result;
}

static void
synapse_command_plugin_command_object_set_command (SynapseCommandPluginCommandObject* self,
                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = synapse_command_plugin_command_object_get_command (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_command);
		self->priv->_command = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY]);
	}
}

static void
synapse_command_plugin_command_object_class_init (SynapseCommandPluginCommandObjectClass * klass,
                                                  gpointer klass_data)
{
	synapse_command_plugin_command_object_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCommandPluginCommandObject_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_command_object_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_command_object_set_property;
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_command_object_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", g_app_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY] = g_param_spec_boolean ("needs-terminal", "needs-terminal", "needs-terminal", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY] = g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY, synapse_command_plugin_command_object_properties[SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY] = g_param_spec_string ("command", "command", "command", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
synapse_command_plugin_command_object_synapse_application_match_interface_init (SynapseApplicationMatchIface * iface,
                                                                                gpointer iface_data)
{
	synapse_command_plugin_command_object_synapse_application_match_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_app_info = synapse_command_plugin_command_object_real_get_app_info;
	iface->set_app_info = synapse_command_plugin_command_object_real_set_app_info;
	iface->get_needs_terminal = synapse_command_plugin_command_object_real_get_needs_terminal;
	iface->set_needs_terminal = synapse_command_plugin_command_object_real_set_needs_terminal;
	iface->get_filename = synapse_command_plugin_command_object_real_get_filename;
	iface->set_filename = synapse_command_plugin_command_object_real_set_filename;
}

static void
synapse_command_plugin_command_object_instance_init (SynapseCommandPluginCommandObject * self,
                                                     gpointer klass)
{
	self->priv = synapse_command_plugin_command_object_get_instance_private (self);
	self->priv->_app_info = NULL;
	self->priv->_needs_terminal = FALSE;
	self->priv->_filename = NULL;
}

static void
synapse_command_plugin_command_object_finalize (GObject * obj)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
	_g_object_unref0 (self->priv->_app_info);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_command);
	G_OBJECT_CLASS (synapse_command_plugin_command_object_parent_class)->finalize (obj);
}

static GType
synapse_command_plugin_command_object_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginCommandObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_command_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPluginCommandObject), 0, (GInstanceInitFunc) synapse_command_plugin_command_object_instance_init, NULL };
	static const GInterfaceInfo synapse_application_match_info = { (GInterfaceInitFunc) synapse_command_plugin_command_object_synapse_application_match_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_command_plugin_command_object_type_id;
	synapse_command_plugin_command_object_type_id = g_type_register_static (SYNAPSE_TYPE_MATCH, "SynapseCommandPluginCommandObject", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_command_plugin_command_object_type_id, SYNAPSE_TYPE_APPLICATION_MATCH, &synapse_application_match_info);
	SynapseCommandPluginCommandObject_private_offset = g_type_add_instance_private (synapse_command_plugin_command_object_type_id, sizeof (SynapseCommandPluginCommandObjectPrivate));
	return synapse_command_plugin_command_object_type_id;
}

static GType
synapse_command_plugin_command_object_get_type (void)
{
	static volatile gsize synapse_command_plugin_command_object_type_id__once = 0;
	if (g_once_init_enter (&synapse_command_plugin_command_object_type_id__once)) {
		GType synapse_command_plugin_command_object_type_id;
		synapse_command_plugin_command_object_type_id = synapse_command_plugin_command_object_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_command_object_type_id__once, synapse_command_plugin_command_object_type_id);
	}
	return synapse_command_plugin_command_object_type_id__once;
}

static void
_vala_synapse_command_plugin_command_object_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY:
		g_value_set_object (value, synapse_application_match_get_app_info ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY:
		g_value_set_boolean (value, synapse_application_match_get_needs_terminal ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY:
		g_value_set_string (value, synapse_application_match_get_filename ((SynapseApplicationMatch*) self));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
		g_value_set_string (value, synapse_command_plugin_command_object_get_command (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_command_plugin_command_object_set_property (GObject * object,
                                                          guint property_id,
                                                          const GValue * value,
                                                          GParamSpec * pspec)
{
	SynapseCommandPluginCommandObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_COMMAND_PLUGIN_TYPE_COMMAND_OBJECT, SynapseCommandPluginCommandObject);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_APP_INFO_PROPERTY:
		synapse_application_match_set_app_info ((SynapseApplicationMatch*) self, g_value_get_object (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_NEEDS_TERMINAL_PROPERTY:
		synapse_application_match_set_needs_terminal ((SynapseApplicationMatch*) self, g_value_get_boolean (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_FILENAME_PROPERTY:
		synapse_application_match_set_filename ((SynapseApplicationMatch*) self, g_value_get_string (value));
		break;
		case SYNAPSE_COMMAND_PLUGIN_COMMAND_OBJECT_COMMAND_PROPERTY:
		synapse_command_plugin_command_object_set_command (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GObject *
synapse_command_plugin_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCommandPlugin * self;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_command_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->past_commands);
	self->priv->past_commands = (GeeSet*) _tmp0_;
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp2_ = g_regex_new ("\\s+", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (self->priv->split_regex);
		self->priv->split_regex = _tmp3_;
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_critical ("command-plugin.vala:80: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
synapse_command_plugin_class_init (SynapseCommandPluginClass * klass,
                                   gpointer klass_data)
{
	synapse_command_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCommandPlugin_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_synapse_command_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_synapse_command_plugin_set_property;
	G_OBJECT_CLASS (klass)->constructor = synapse_command_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_command_plugin_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY, synapse_command_plugin_properties[SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	synapse_command_plugin_register_plugin ();
}

static void
synapse_command_plugin_synapse_activatable_interface_init (SynapseActivatableIface * iface,
                                                           gpointer iface_data)
{
	synapse_command_plugin_synapse_activatable_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_activate;
	iface->deactivate = (void (*) (SynapseActivatable*)) synapse_command_plugin_real_deactivate;
	iface->get_enabled = synapse_command_plugin_real_get_enabled;
	iface->set_enabled = synapse_command_plugin_real_set_enabled;
}

static void
synapse_command_plugin_synapse_item_provider_interface_init (SynapseItemProviderIface * iface,
                                                             gpointer iface_data)
{
	synapse_command_plugin_synapse_item_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (SynapseItemProvider*, SynapseQuery*, GAsyncReadyCallback, gpointer)) synapse_command_plugin_real_search;
	iface->search_finish = (SynapseResultSet* (*) (SynapseItemProvider*, GAsyncResult*, GError**)) synapse_command_plugin_search_finish;
}

static void
synapse_command_plugin_instance_init (SynapseCommandPlugin * self,
                                      gpointer klass)
{
	self->priv = synapse_command_plugin_get_instance_private (self);
	self->priv->_enabled = TRUE;
}

static void
synapse_command_plugin_finalize (GObject * obj)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	_g_object_unref0 (self->priv->past_commands);
	_g_regex_unref0 (self->priv->split_regex);
	G_OBJECT_CLASS (synapse_command_plugin_parent_class)->finalize (obj);
}

static GType
synapse_command_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCommandPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_command_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCommandPlugin), 0, (GInstanceInitFunc) synapse_command_plugin_instance_init, NULL };
	static const GInterfaceInfo synapse_activatable_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_activatable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo synapse_item_provider_info = { (GInterfaceInitFunc) synapse_command_plugin_synapse_item_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType synapse_command_plugin_type_id;
	synapse_command_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCommandPlugin", &g_define_type_info, 0);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ACTIVATABLE, &synapse_activatable_info);
	g_type_add_interface_static (synapse_command_plugin_type_id, SYNAPSE_TYPE_ITEM_PROVIDER, &synapse_item_provider_info);
	SynapseCommandPlugin_private_offset = g_type_add_instance_private (synapse_command_plugin_type_id, sizeof (SynapseCommandPluginPrivate));
	return synapse_command_plugin_type_id;
}

GType
synapse_command_plugin_get_type (void)
{
	static volatile gsize synapse_command_plugin_type_id__once = 0;
	if (g_once_init_enter (&synapse_command_plugin_type_id__once)) {
		GType synapse_command_plugin_type_id;
		synapse_command_plugin_type_id = synapse_command_plugin_get_type_once ();
		g_once_init_leave (&synapse_command_plugin_type_id__once, synapse_command_plugin_type_id);
	}
	return synapse_command_plugin_type_id__once;
}

static void
_vala_synapse_command_plugin_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
		g_value_set_boolean (value, synapse_activatable_get_enabled ((SynapseActivatable*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_synapse_command_plugin_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SynapseCommandPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SYNAPSE_TYPE_COMMAND_PLUGIN, SynapseCommandPlugin);
	switch (property_id) {
		case SYNAPSE_COMMAND_PLUGIN_ENABLED_PROPERTY:
		synapse_activatable_set_enabled ((SynapseActivatable*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

