/* calculator-plugin-backend.c generated by valac 0.56.8, the Vala compiler
 * generated from calculator-plugin-backend.vala, do not modify */

/*
* Copyright (c) 2010 Michal Hruby <michal.mhr@gmail.com>
*               2022 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Michal Hruby <michal.mhr@gmail.com>
*/

#include "slingshot.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include <glib-object.h>

enum  {
	SYNAPSE_CALCULATOR_PLUGIN_BACKEND_0_PROPERTY,
	SYNAPSE_CALCULATOR_PLUGIN_BACKEND_NUM_PROPERTIES
};
static GParamSpec* synapse_calculator_plugin_backend_properties[SYNAPSE_CALCULATOR_PLUGIN_BACKEND_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SynapseCalculatorPluginBackendGetSolutionData SynapseCalculatorPluginBackendGetSolutionData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SynapseCalculatorPluginBackendPrivate {
	GRegex* express_regex;
	GRegex* base_regex;
};

struct _SynapseCalculatorPluginBackendGetSolutionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SynapseCalculatorPluginBackend* self;
	gchar* query_string;
	GCancellable* cancellable;
	gdouble result;
	gchar* solution;
	gchar* input;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean matched;
	GRegex* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GRegex* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GPid pid;
	gint read_fd;
	gint write_fd;
	gchar** argv;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	GPid _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GUnixInputStream* read_stream;
	GUnixInputStream* _tmp25_;
	GDataInputStream* bc_output;
	GUnixInputStream* _tmp26_;
	GDataInputStream* _tmp27_;
	GUnixOutputStream* write_stream;
	GUnixOutputStream* _tmp28_;
	GDataOutputStream* bc_input;
	GUnixOutputStream* _tmp29_;
	GDataOutputStream* _tmp30_;
	const gchar* _tmp31_;
	GDataOutputStream* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	GDataOutputStream* _tmp36_;
	gchar* _tmp37_;
	GDataInputStream* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	gboolean _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	GError* _tmp45_;
	const gchar* _tmp46_;
	GError* _inner_error0_;
};

static gint SynapseCalculatorPluginBackend_private_offset;
static gpointer synapse_calculator_plugin_backend_parent_class = NULL;
static SynapseCalculatorPluginBackend* synapse_calculator_plugin_backend_instance;
static SynapseCalculatorPluginBackend* synapse_calculator_plugin_backend_instance = NULL;

static void synapse_calculator_plugin_backend_get_solution_data_free (gpointer _data);
static gboolean synapse_calculator_plugin_backend_get_solution_co (SynapseCalculatorPluginBackendGetSolutionData* _data_);
static void synapse_calculator_plugin_backend_get_solution_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static GObject * synapse_calculator_plugin_backend_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static void synapse_calculator_plugin_backend_finalize (GObject * obj);
static GType synapse_calculator_plugin_backend_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
synapse_calculator_plugin_backend_get_instance_private (SynapseCalculatorPluginBackend* self)
{
	return G_STRUCT_MEMBER_P (self, SynapseCalculatorPluginBackend_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SynapseCalculatorPluginBackend*
synapse_calculator_plugin_backend_get_instance (void)
{
	SynapseCalculatorPluginBackend* _tmp0_;
	SynapseCalculatorPluginBackend* _tmp2_;
	SynapseCalculatorPluginBackend* _tmp3_;
	SynapseCalculatorPluginBackend* result;
	_tmp0_ = synapse_calculator_plugin_backend_instance;
	if (_tmp0_ == NULL) {
		SynapseCalculatorPluginBackend* _tmp1_;
		_tmp1_ = synapse_calculator_plugin_backend_new ();
		_g_object_unref0 (synapse_calculator_plugin_backend_instance);
		synapse_calculator_plugin_backend_instance = _tmp1_;
	}
	_tmp2_ = synapse_calculator_plugin_backend_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
synapse_calculator_plugin_backend_get_solution_data_free (gpointer _data)
{
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SynapseCalculatorPluginBackendGetSolutionData, _data_);
}

void
synapse_calculator_plugin_backend_get_solution (SynapseCalculatorPluginBackend* self,
                                                const gchar* query_string,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	SynapseCalculatorPluginBackend* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query_string != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (SynapseCalculatorPluginBackendGetSolutionData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, synapse_calculator_plugin_backend_get_solution_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query_string);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	synapse_calculator_plugin_backend_get_solution_co (_data_);
}

gdouble
synapse_calculator_plugin_backend_get_solution_finish (SynapseCalculatorPluginBackend* self,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	gdouble result;
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gdouble _tmp0_ = 0.0;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
synapse_calculator_plugin_backend_get_solution_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	SynapseCalculatorPluginBackendGetSolutionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	synapse_calculator_plugin_backend_get_solution_co (_data_);
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gboolean
synapse_calculator_plugin_backend_get_solution_co (SynapseCalculatorPluginBackendGetSolutionData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->solution = NULL;
	_data_->_tmp0_ = string_replace (_data_->query_string, " ", "");
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = string_replace (_data_->_tmp1_, ",", ".");
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = string_replace (_data_->_tmp3_, "x", "*");
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_free0 (_data_->_tmp3_);
	_g_free0 (_data_->_tmp1_);
	_data_->input = _data_->_tmp5_;
	_data_->matched = TRUE;
	_data_->_tmp6_ = _data_->self->priv->base_regex;
	_data_->_tmp7_ = _data_->input;
	if (g_regex_match (_data_->_tmp6_, _data_->_tmp7_, 0, NULL)) {
		_data_->_tmp8_ = _data_->input;
		g_strcanon (_data_->_tmp8_, "1234567890ABCDEF();%^&|!*/-+iobase=.", '@');
	} else {
		_data_->_tmp9_ = _data_->input;
		_data_->_tmp10_ = g_utf8_strdown (_data_->_tmp9_, (gssize) -1);
		_g_free0 (_data_->input);
		_data_->input = _data_->_tmp10_;
		_data_->_tmp11_ = _data_->self->priv->express_regex;
		_data_->_tmp12_ = _data_->input;
		_data_->matched = g_regex_match (_data_->_tmp11_, _data_->_tmp12_, 0, NULL);
	}
	_data_->_tmp13_ = _data_->input;
	if (string_contains (_data_->_tmp13_, "@")) {
		_data_->matched = FALSE;
	}
	if (_data_->matched) {
		g_debug ("calculator-plugin-backend.vala:80: Matched");
		_data_->_tmp14_ = _data_->input;
		_data_->_tmp15_ = string_replace (_data_->_tmp14_, "--", "- -");
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = string_replace (_data_->_tmp16_, "+-", "+ -");
		_g_free0 (_data_->input);
		_data_->input = _data_->_tmp17_;
		_g_free0 (_data_->_tmp16_);
		_data_->_tmp18_ = g_strdup ("bc");
		_data_->_tmp19_ = g_strdup ("-l");
		_data_->_tmp20_ = g_new0 (gchar*, 2 + 1);
		_data_->_tmp20_[0] = _data_->_tmp18_;
		_data_->_tmp20_[1] = _data_->_tmp19_;
		_data_->argv = _data_->_tmp20_;
		_data_->argv_length1 = 2;
		_data_->_argv_size_ = _data_->argv_length1;
		_data_->_tmp21_ = _data_->argv;
		_data_->_tmp21__length1 = _data_->argv_length1;
		_data_->_tmp22_ = 0;
		_data_->_tmp23_ = 0;
		_data_->_tmp24_ = 0;
		g_spawn_async_with_pipes (NULL, _data_->_tmp21_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_data_->_tmp22_, &_data_->_tmp23_, &_data_->_tmp24_, NULL, &_data_->_inner_error0_);
		_data_->pid = _data_->_tmp22_;
		_data_->write_fd = _data_->_tmp23_;
		_data_->read_fd = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->input);
			_g_free0 (_data_->solution);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp25_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->read_fd, TRUE);
		_data_->read_stream = _data_->_tmp25_;
		_data_->_tmp26_ = _data_->read_stream;
		_data_->_tmp27_ = g_data_input_stream_new ((GInputStream*) _data_->_tmp26_);
		_data_->bc_output = _data_->_tmp27_;
		_data_->_tmp28_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->write_fd, TRUE);
		_data_->write_stream = _data_->_tmp28_;
		_data_->_tmp29_ = _data_->write_stream;
		_data_->_tmp30_ = g_data_output_stream_new ((GOutputStream*) _data_->_tmp29_);
		_data_->bc_input = _data_->_tmp30_;
		_data_->_tmp31_ = _data_->input;
		g_debug ("calculator-plugin-backend.vala:99: bc input string %s\n", _data_->_tmp31_);
		_data_->_tmp32_ = _data_->bc_input;
		_data_->_tmp33_ = _data_->input;
		_data_->_tmp34_ = g_strconcat (_data_->_tmp33_, "\n", NULL);
		_data_->_tmp35_ = _data_->_tmp34_;
		g_data_output_stream_put_string (_data_->_tmp32_, _data_->_tmp35_, _data_->cancellable, &_data_->_inner_error0_);
		_g_free0 (_data_->_tmp35_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->bc_input);
			_g_object_unref0 (_data_->write_stream);
			_g_object_unref0 (_data_->bc_output);
			_g_object_unref0 (_data_->read_stream);
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->input);
			_g_free0 (_data_->solution);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp36_ = _data_->bc_input;
		_data_->_state_ = 1;
		g_output_stream_close_async ((GOutputStream*) _data_->_tmp36_, G_PRIORITY_DEFAULT, _data_->cancellable, synapse_calculator_plugin_backend_get_solution_ready, _data_);
		return FALSE;
		_state_1:
		g_output_stream_close_finish ((GOutputStream*) _data_->_tmp36_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->bc_input);
			_g_object_unref0 (_data_->write_stream);
			_g_object_unref0 (_data_->bc_output);
			_g_object_unref0 (_data_->read_stream);
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->input);
			_g_free0 (_data_->solution);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp38_ = _data_->bc_output;
		_data_->_state_ = 2;
		g_data_input_stream_read_line_async (_data_->_tmp38_, G_PRIORITY_DEFAULT_IDLE, _data_->cancellable, synapse_calculator_plugin_backend_get_solution_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp39_ = g_data_input_stream_read_line_finish (_data_->_tmp38_, _data_->_res_, NULL, &_data_->_inner_error0_);
		_data_->_tmp37_ = _data_->_tmp39_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->bc_input);
			_g_object_unref0 (_data_->write_stream);
			_g_object_unref0 (_data_->bc_output);
			_g_object_unref0 (_data_->read_stream);
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->input);
			_g_free0 (_data_->solution);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp40_ = _data_->_tmp37_;
		_data_->_tmp37_ = NULL;
		_g_free0 (_data_->solution);
		_data_->solution = _data_->_tmp40_;
		_g_free0 (_data_->_tmp37_);
		_g_object_unref0 (_data_->bc_input);
		_g_object_unref0 (_data_->write_stream);
		_g_object_unref0 (_data_->bc_output);
		_g_object_unref0 (_data_->read_stream);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	} else {
		_data_->_tmp41_ = _data_->input;
		g_debug ("calculator-plugin-backend.vala:106: Query %s produced input %s, which " \
"did not match regex", _data_->query_string, _data_->_tmp41_);
	}
	_data_->_tmp43_ = _data_->solution;
	if (_data_->_tmp43_ == NULL) {
		_data_->_tmp42_ = TRUE;
	} else {
		_data_->_tmp44_ = _data_->solution;
		_data_->_tmp42_ = g_strcmp0 (_data_->_tmp44_, "") == 0;
	}
	if (_data_->_tmp42_) {
		_data_->_tmp45_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED_HANDLED, "No solution found");
		_data_->_inner_error0_ = _data_->_tmp45_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->input);
		_g_free0 (_data_->solution);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp46_ = _data_->solution;
		_data_->result = double_parse (_data_->_tmp46_);
		_g_free0 (_data_->input);
		_g_free0 (_data_->solution);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

SynapseCalculatorPluginBackend*
synapse_calculator_plugin_backend_construct (GType object_type)
{
	SynapseCalculatorPluginBackend * self = NULL;
	self = (SynapseCalculatorPluginBackend*) g_object_new (object_type, NULL);
	return self;
}

SynapseCalculatorPluginBackend*
synapse_calculator_plugin_backend_new (void)
{
	return synapse_calculator_plugin_backend_construct (SYNAPSE_TYPE_CALCULATOR_PLUGIN_BACKEND);
}

static GObject *
synapse_calculator_plugin_backend_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SynapseCalculatorPluginBackend * self;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (synapse_calculator_plugin_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN_BACKEND, SynapseCalculatorPluginBackend);
	{
		GRegex* _tmp0_ = NULL;
		GRegex* _tmp1_;
		GRegex* _tmp2_;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_;
		GRegex* _tmp5_;
		_tmp1_ = g_regex_new ("^.*(\\w+[\\/\\+\\-\\*\\^\\%\\!\\&\\|]{1,2}\\.?\\w+|\\(-?\\d+.*\\))+.*$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_regex_unref0 (self->priv->express_regex);
		self->priv->express_regex = _tmp2_;
		_tmp4_ = g_regex_new ("^.base=\\d+;.*$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_regex_unref0 (self->priv->base_regex);
		self->priv->base_regex = _tmp5_;
		_g_regex_unref0 (_tmp3_);
		_g_regex_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("calculator-plugin-backend.vala:53: Error creating regexp: %s", _tmp7_);
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
synapse_calculator_plugin_backend_class_init (SynapseCalculatorPluginBackendClass * klass,
                                              gpointer klass_data)
{
	synapse_calculator_plugin_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SynapseCalculatorPluginBackend_private_offset);
	G_OBJECT_CLASS (klass)->constructor = synapse_calculator_plugin_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = synapse_calculator_plugin_backend_finalize;
}

static void
synapse_calculator_plugin_backend_instance_init (SynapseCalculatorPluginBackend * self,
                                                 gpointer klass)
{
	self->priv = synapse_calculator_plugin_backend_get_instance_private (self);
	self->priv->express_regex = NULL;
	self->priv->base_regex = NULL;
}

static void
synapse_calculator_plugin_backend_finalize (GObject * obj)
{
	SynapseCalculatorPluginBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SYNAPSE_TYPE_CALCULATOR_PLUGIN_BACKEND, SynapseCalculatorPluginBackend);
	_g_regex_unref0 (self->priv->express_regex);
	_g_regex_unref0 (self->priv->base_regex);
	G_OBJECT_CLASS (synapse_calculator_plugin_backend_parent_class)->finalize (obj);
}

static GType
synapse_calculator_plugin_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SynapseCalculatorPluginBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) synapse_calculator_plugin_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SynapseCalculatorPluginBackend), 0, (GInstanceInitFunc) synapse_calculator_plugin_backend_instance_init, NULL };
	GType synapse_calculator_plugin_backend_type_id;
	synapse_calculator_plugin_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "SynapseCalculatorPluginBackend", &g_define_type_info, 0);
	SynapseCalculatorPluginBackend_private_offset = g_type_add_instance_private (synapse_calculator_plugin_backend_type_id, sizeof (SynapseCalculatorPluginBackendPrivate));
	return synapse_calculator_plugin_backend_type_id;
}

GType
synapse_calculator_plugin_backend_get_type (void)
{
	static volatile gsize synapse_calculator_plugin_backend_type_id__once = 0;
	if (g_once_init_enter (&synapse_calculator_plugin_backend_type_id__once)) {
		GType synapse_calculator_plugin_backend_type_id;
		synapse_calculator_plugin_backend_type_id = synapse_calculator_plugin_backend_get_type_once ();
		g_once_init_leave (&synapse_calculator_plugin_backend_type_id__once, synapse_calculator_plugin_backend_type_id);
	}
	return synapse_calculator_plugin_backend_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

